/*
 * mov.c - quicktime information functions for GINI
 * Copyright 2003 Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * Authors:
 *	Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <netinet/in.h>

#include "mov.h"

int a_sec;

void recurse_mov (char *buf,unsigned int llen,int dep)
{
    mvhd *hd;
    char *tbuf=buf;
    unsigned int *len;
    char id[5];
    unsigned int cuccolt;
    id[4]=0;
    cuccolt=llen;
    
    while (cuccolt>0){
    if (isalpha(tbuf[4])&&isalpha(tbuf[5])&&isalpha(tbuf[6])&&isalpha(tbuf[7])){
	if (0==memcmp(tbuf+4,"mvhd",4)){
	    hd=(mvhd *)tbuf+4;
//	    write(1,hd->type,4);
//		printf(" ==== %lu ==== %lu ====\n",htonl(hd->timescale),htonl(hd->duration));
		if (htonl(hd->duration)/htonl(hd->timescale)>a_sec){
			a_sec=htonl(hd->duration)/htonl(hd->timescale);
		}
	}
	if (0==memcmp(tbuf+4,"mdhd",4)){
	    hd=(mvhd *)tbuf+4;
//	    write(1,hd->type,4);
//		printf(" ==== %lu ==== %lu ====\n",htonl(hd->timescale),htonl(hd->duration));
		if (htonl(hd->duration)/htonl(hd->timescale)>a_sec){
			a_sec=htonl(hd->duration)/htonl(hd->timescale);
		}
	}
	len=(int *)tbuf;
	memcpy(id,tbuf+4,4);
/*	for (i=0;i<dep;i++){
	    printf(" ");
	}
	printf("%s : %d\n",id,htonl(*len));*/
	if (htonl(*len)>0){
	    recurse_mov(tbuf+8,htonl(*len)-8,dep+1);
	}else{
	    return;
	}
	cuccolt-=htonl(*len);
	tbuf+=htonl(*len);
    }else{
	cuccolt=0;
    }
    }
}

int get_mov_info (FILE * file, int *act_sec, int *act_bitrate, int *act_nominal,
		  char **act_artist, char **act_title)
{
    unsigned int len,len2;
    char *buf;
    int ret=1;

    if (fread(&len,4,1,file)==1){
		len2=htonl(len);
		buf=malloc(len2);
		if (fread(buf+4,len2-4,1,file)==1){
			memcpy(buf,&len,4);
			a_sec=0;
			recurse_mov (buf,len2,0);
			ret=0;
		}
		free(buf);
    }
	rewind(file);
	*act_sec=a_sec;
	*act_bitrate=*act_nominal=0;
    return ret;
}
