/*
 * ginicon.c - main source if GINIcon
 * Copyright 2003 Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * Author:
 *	Krisztian Pifko <monsta@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/signal.h>
#include <sys/stat.h>
//#include <time.h>
#include <glib.h>

#include "util.h"

#define GINICON_NAME "GINIcon"
#define BUFSIZE 1024

int mainsock;
fd_set sockset,socksetw;
char buff[BUFSIZE + 1];
char rbuff[BUFSIZE + 1];
int quit=0;
char *password = NULL;
char *host = NULL;
int mainport = 8000;
gchar *send_buffer;
gchar *header;
int headerlen;

#include "gini.h"
#include "net.h"
#include "getopt.h"

static char const shortopts[] = "w:H:P:vh";
static struct option const longopts[] = {
  {"password", required_argument, NULL, 'w'},
  {"host", required_argument, NULL, 'H'},
  {"port", required_argument, NULL, 'P'},
  {"version", no_argument, NULL, 'v'},
  {"help", no_argument, NULL, 'h'},
  {NULL, no_argument, NULL, 0}
};

static char const *const option_help[] = {
  "  -H    --host <host>           host to connect to. DEFAULT: 127.0.0.1",
  "  -P    --port <port>           port to connect to. DEFAULT: 8000",
  "  -w    --password <pass>       password of server.",
  "  -v    --version               output version info.",
  "  -h    --help                  output this help.",
  "",
  "Report bugs to <monsta@users.sourceforge.net>.",
  0
};

static void version ()
{
  printf ("%s %s %s\n%s\n", GINICON_NAME, VERSION, GINI_URL, GINI_COPYRIGHT);
}

static void usage ()
{
  printf ("\nusage: ginicon [OPTIONS]\n");
  printf ("\n [OPTIONS] Try --help for more information\n");
  printf ("\n\n");
  return;
}

void get_some_switches (int argc, char *argv[], int *todo)
{
  register int optc;
	int i;
  char const *const *p;
  if (optind == argc)
    return;
  while ((optc = getopt_long (argc, argv, shortopts, longopts, (int *) 0))
	 != -1) {
    switch (optc) {
    case 'w':
      password = g_strdup (optarg);
			for (i=0;i<strlen(optarg);i++){
		  	optarg[i]='*';
			}
      break;
    case 'H':
      host = g_strdup (optarg);
      break;
    case 'P':
      mainport = atoi (optarg);
      break;
    case 'v':
//      version ();
      exit (0);
      break;
    case 'h':
      usage (argv[0]);
      for (p = option_help; *p; p++)
	printf ("%s\n", *p);
      exit (0);
      break;
    default:
      usage (argv[0]);
    }
  }
}

void closeallsockets (void)
{
  closesocket (mainsock);
}

void closeall (void)
{
	closeallsockets();
	
	g_free(send_buffer);
	g_free(header);
}

void FD_SETALL (fd_set * set)
{
  FD_ZERO (set);
  FD_SET (0, set);
}

void FD_MSETALL (fd_set * set)
{
  FD_ZERO (set);
  FD_SET (mainsock, set);
}

void s1gnal (const int sig);

static void setup_signal_traps ()
{
  signal (SIGSEGV, s1gnal);
  signal (SIGPIPE, s1gnal);
  signal (SIGINT, s1gnal);
  signal (SIGQUIT, s1gnal);
  signal (SIGFPE, s1gnal);
  signal (SIGBUS, s1gnal);
  signal (SIGTERM, s1gnal);
  // signal (SIGHUP, s1gnal);
  // signal (SIGUSR1, s1gnal);
  // signal (SIGUSR2, s1gnal);
  // signal (SIGCHLD, s1gnal);
  signal (SIGIO, s1gnal);
  signal (SIGALRM, SIG_IGN);
}

void s1gnal (const int sig)
{
  setup_signal_traps ();
  switch (sig) {
    // case SIGHUP:
    // break;
  case SIGSEGV:
  case SIGBUS:
  case SIGFPE:
  case SIGIO:
  case SIGTERM:
    printf ("EEEEK!\n");
//    closeallsockets ();
//    exit (0);
      quit=1;
    break;
  case SIGINT:
  case SIGQUIT:
    printf ("MANUAL KILL!\n");
//    closeallsockets ();
//    exit (0);
      quit=1;
    break;
  }
  setup_signal_traps ();
}

int main (int argc, char *argv[])
{
  struct timeval tv;
  int ret, ret2;
	gchar *tmp_buf;
	int init_state=0;
	u_long socketswritten=0;
	int ret3;
	
  version ();
  get_some_switches (argc, argv, NULL);

  if (NULL == password) {
    password = g_strdup ("letmein");
  }
      if (NULL == host) {
	host = g_strdup ("127.0.0.1");
      }
	
      mainsock = connectto2 (host, mainport);
      if (mainsock != -1) {
				
					  header =
	    g_strdup_printf
	    ("CONSOLE %s\r\n\r\n", password);
	  headerlen = strlen (header);

	setup_signal_traps ();			
				send_buffer=g_strdup("");
			
    printf("GINI> ");
    fflush(0);
				
    while (!quit) {
			
/* console read stuff */
      FD_SETALL (&sockset);
      ret = select (1, &sockset, NULL, NULL, &tv);
      if (ret > 0) {
	  		if (FD_ISSET (0, &sockset)) {
	    		ret2 = read (0, buff, BUFSIZE);
	    		if (ret2 > 0) {
	      		buff[ret2-1] = '\0';
						if (buff[0]!='\0'){
							tmp_buf=send_buffer;
							send_buffer=g_strconcat(tmp_buf,buff,NULL);
							g_free(tmp_buf);
						}else{
							printf ("%s", PROMPT);
						}
	    		} else {
	      		quit=1;
	    		}
	  		}
      }
			
	    resettimeout (&tv);
	    FD_MSETALL (&sockset);
	    ret = select (mainsock + 1, &sockset, NULL, NULL, &tv);
	    if (ret > 0) {
	      if (FD_ISSET (mainsock, &sockset)) {
					ret2 = recv (mainsock, rbuff, BUFSIZE, MSG_DONTWAIT);
					if (ret2 > 0) {
						rbuff[ret2] = '\0';
						if (1 == init_state && 'O' == rbuff[0] && 'K' == rbuff[1]) {
							init_state++;
						} else if (2==init_state) {
							printf ("%s%s", rbuff, PROMPT);
						} else {
							printf ("\n%s\n", rbuff);
						}
					} else {
						closesocket (mainsock);
						printf ("\nremote end closed socket\n");
						quit = 1;
					}
	      }
			}
			
	      if ((0==init_state)||((2==init_state)&&(strlen(send_buffer)))) {
			resettimeout(&tv);
      FD_MSETALL (&socksetw);
      ret = select (mainsock+1, NULL, &socksetw, NULL, &tv);
			if (ret>0) {
					ret3 = 0;
					if (FD_ISSET (mainsock, &socksetw)) {
						if ((2 == init_state)) {
							if (socketswritten < strlen(send_buffer)) {
								ret3 = send (mainsock, send_buffer + socketswritten, strlen(send_buffer) - socketswritten, MSG_DONTWAIT);
							}
						} else if (0 == init_state) {
							ret3 = send (mainsock, header + socketswritten, headerlen - socketswritten, MSG_DONTWAIT);
						}
						if (ret3 > 0) {
							socketswritten += ret3;
							if (!init_state) {
								if (socketswritten == headerlen) {
						init_state = 1;
						socketswritten = 0;
								}
							} else if (2 == init_state) {
								if (socketswritten == strlen(send_buffer)) {
									g_free(send_buffer);
									send_buffer=g_strdup("");
									socketswritten=0;
								}
							}
						} else {
							closesocket (mainsock);
							printf ("\nremote end closed socket\n");
							quit = 1;
						}
					}
			}
	      }
			
			fflush(0);
      usleep (3);
    }
  closeall ();
	}else{
			printf ("cannot connect!\n");
	}
  return 0;
}
