/*
 * avi.c - avi information functions for GINI
 * Copyright 2002, 2003 Krisztian Pifko <monsta@users.sourceforge.net>
 * Copyright 2002, 2003 Balazs Dakay <dakayb@users.sourceforge.net>
 *
 * Taken from aviinfo of George Shunklin <gs@anime.org.ru>.
 *
 * Authors:
 *	Krisztian Pifko <monsta@users.sourceforge.net>
 *	Balazs Dakay <dakayb@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include "avi.h"


int AviSeek (FILE * file, FOURCC ID)
{
  struct {
    DWORD ID;
    DWORD Size;
  } chunk;			//reference view of chunk

  if (!fread (&chunk, sizeof (chunk), 1, file))
    return 0;
  while (chunk.ID != ID) {
    if (!fseek (file, chunk.Size, SEEK_CUR))
      return 0;
    if (!fread (&chunk, sizeof (chunk), 1, file))
      return 0;
  }
  return chunk.Size;
}

int ReadStreams (FILE * file, mem_chunk ** str_data, DWORD dwStreams)
{
  int counter;
  int SizeCount;
  DWORD Data;
  DWORD Size;
  mem_chunk *current = NULL;
  mem_chunk *temp;
  *str_data = NULL;
  for (counter = dwStreams; counter; counter--) {
    do {
      SizeCount = AviSeek (file, SIGN_LIST);
      if (!SizeCount)
	return -11;
      if (!fread (&Data, sizeof (Data), 1, file))
	return -23;
    } while (Data != SIGN_STRL);
    temp = (mem_chunk *) malloc (sizeof (mem_chunk));
    if (!temp)
      return -666;
    if (current)
      current->Next = (void *) temp;
    else
      current = temp;
    temp->Next = NULL;
    if (!*str_data)
      *str_data = current;
    if (!fread (&Data, 1, sizeof (Data), file))
      return -81;
    if (!fread (&Size, 1, sizeof (Size), file))
      return -91;
    if (Data == SIGN_STRH) {
      if (!(temp->Data_h = (void *) malloc (Size)))
	return -2;
      if (!fread (temp->Data_h, 1, Size, file))
	return -3;
      temp->DataSize_h = Size;
      SizeCount = SizeCount - Size - 12;
      if (SizeCount > 0) {
	if (!fread (&Data, 1, sizeof (Data), file))
	  return -82;
	if (!fread (&Size, 1, sizeof (Size), file))
	  return -92;
      }
    }
    if (Data == SIGN_STRF) {
      if (!(temp->Data_f.v = (void *) malloc (Size)))
	return -4;
      if (!fread (temp->Data_f.v, 1, Size, file))
	return -5;
      temp->DataSize_f = Size;
      SizeCount = SizeCount - Size - 8;
      if (SizeCount > 0) {
	if (!fread (&Data, 1, sizeof (Data), file))
	  return -83;
	if (!fread (&Size, 1, sizeof (Size), file))
	  return -93;
	SizeCount = SizeCount - 8;
      }
    }
    if (Data == SIGN_STRD) {
      if (!(temp->Data_d = (void *) malloc (Size)))
	return -6;
      if (!fread (temp->Data_d, 1, Size, file))
	return -7;
      temp->DataSize_d = Size;
    }
    if (SizeCount > 0)
      fseek (file, SizeCount, SEEK_CUR);
  }
  return 0;
}

int ReadAVIHeader (FILE * riff, MainAVIHeader * avihdr, mem_chunk ** str_data)
{
  DWORD riffType;
  DWORD Size;
  if (!AviSeek (riff, SIGN_RIFF))
    return -1;
  if (!fread (&riffType, 1, sizeof (riffType), riff))
    return -1;
  if (riffType != SIGN_AVI_)
    return 2;			//error: riff, but not AVI (e.g. WAV,RMI)
  if (!AviSeek (riff, SIGN_LIST))
    return -1;
  if (!fread (&riffType, sizeof (riffType), 1, riff))
    return -1;
  while (riffType != SIGN_HDRL) {	//if not a 'hrdl' type, skip all LIST chunk.
    if (!AviSeek (riff, SIGN_LIST))
      return -1;
    if (!fread (&riffType, sizeof (riffType), 1, riff))
      return -1;
  }
  if (!fread (&riffType, sizeof (riffType), 1, riff))
    return -1;
  if (riffType != SIGN_AVIH)
    return 3;
  if (!fread (&Size, sizeof (Size), 1, riff))
    return -1;
  if (Size != sizeof (MainAVIHeader))
    return 3;			//size of avi header doesn't match.
  if (!fread (avihdr, Size, 1, riff))
    return -1;			//<--Reading header
  ReadStreams (riff, str_data, avihdr->dwStreams);
  return 0;
}

int get_avi_info (FILE * file, aviinfo * ai, int *act_sec, int *act_bitrate, int *act_nominal,
		  char **act_artist, char **act_title)
{
  MainAVIHeader avih;
  int error = 0;
  mem_chunk *temp;
  int stream = 0;

  long tmplength;

  if (!file) {
    fprintf (stderr, "Ooops, NULL FILE * in getaviino!!!\n");
    return -1;
  }
  fseek (file, 0, SEEK_END);
  ai->size = ftell (file);
  fseek (file, 0, SEEK_SET);

  if (0 >= ai->size)
    return -1;

  error = ReadAVIHeader (file, &avih, &temp);

  if (0 != error)
    return error;

  ai->length = 0;

  while (temp && (stream < 4)) {
    if (temp->Data_h) {
/*
            printf("Stream %d FCCType: %u Length: %d\n",stream, temp->Data_h->fccType,
              temp->Data_h->dwLength / (temp->Data_h->dwRate / temp->Data_h->dwScale));
*/
      if (temp->Data_h->fccType == SIGN_VIDS) {
	ai->length = temp->Data_h->dwLength / (temp->Data_h->dwRate / temp->Data_h->dwScale);
	break;			// Video streams rules!
      } else {
	tmplength = temp->Data_h->dwLength / (temp->Data_h->dwRate / temp->Data_h->dwScale);
	if (ai->length < tmplength) {
	  ai->length = tmplength;
	}
      }
    }
    stream++;
    temp = temp->Next;
  }

/*
        ai->length = (avih.dwTotalFrames * avih.dwMicroSecPerFrame) / 1000000;
*/

//      fseek(file,0,SEEK_SET);

  if (0 == ai->length)
    return -1;
  ai->bps = ai->size * 8 / ai->length;

  *act_sec = ai->length;
  *act_bitrate = ai->bps / 1024;
  *act_nominal = ai->bps / 1024;

  return 0;
}
