/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-1997 Spencer Kimball and Peter Mattis
 *
 * GIMP Color Manager Plug-In
 * Copyright (C) 2000, 2001  Karl Heinz Kremer <khk@khk.net>
 * Gimp 2.X port 2004 Jordi Cantón <jordinitrox@virtual-sub.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "config.h"

#include <assert.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <errno.h>

#include <dirent.h>

#include <stdlib.h>		/*  For srand()  */
#include <time.h>		/*  For time()   */

#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

#include <lcms.h>

#include "utils.h"
#include "main.h"

#include "plugin-intl.h"


GimpPDBStatusType
embed_profile (gint32 image_ID, guchar * profile_name)
{

  GimpParasite *parasite;
  GimpParasite *actualparasite;
  FILE *profile;
  struct stat statbuf;
  int i;

  /* get file size */
  if (stat (profile_name, &statbuf) == 0)
    {
      guchar *tmp_profile;
      gint32 profile_size;

      profile_size = statbuf.st_size;
      profile = fopen (profile_name, "r");
      if (profile != NULL)
	{
	  tmp_profile = malloc (profile_size);
	  if (tmp_profile == NULL)
	    {
	      fclose (profile);
	      return GIMP_PDB_EXECUTION_ERROR;
	    }
	  i = fread (tmp_profile, 1, profile_size, profile);
	  if (profile_size == i)
	    {

	      parasite = gimp_parasite_new ("icc-profile", 0,
					    profile_size, tmp_profile);
              actualparasite= gimp_image_parasite_find(image_ID,"icc-profile");
	      if(actualparasite)
	      {
	         if(!gimp_parasite_compare(parasite,actualparasite))
	         {
		    fprintf(stderr,"Work Space conversion not implemented yet\n");
		    gimp_image_parasite_detach (image_ID,"icc-profile");
	         }
		 else
		 {
		    fprintf(stderr,"Workspace profile already embedded\n");
		    gimp_parasite_free (parasite);
		    free (tmp_profile);
		    return GIMP_PDB_SUCCESS;
		 }
	      }
	      gimp_image_parasite_attach (image_ID, parasite);
	      gimp_parasite_free (parasite);
	      free (tmp_profile);
	    }
	  else
	    {
	      fprintf (stderr, "only read %d bytes instead of %d\n", i,
		       profile_size);
	    }
	  fclose (profile);
	}
      else
	{
	  fprintf (stderr, "error in open\n");
	}
    }
  else
    {
      fprintf (stderr, "stat error (%d)\n", errno);
    }


  return GIMP_PDB_SUCCESS;
}

GimpPDBStatusType
delete_embed_profile (gint32 image_ID)
{

  GimpParasite *actualparasite;
  actualparasite= gimp_image_parasite_find(image_ID,"icc-profile");
  if(actualparasite)
  {
     gimp_image_parasite_detach (image_ID,"icc-profile");
  }
  return GIMP_PDB_SUCCESS;
}



