/*
 *
 * Copyright (C) 2012 CADCAM-Servies Franz Reiter (franz.reiter@cadcam.co.at)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 *
-----------------------------------------------------
TODO:
  ..

-----------------------------------------------------
Modifications:
2012-02-01 extracted from ut_gtk.c.  RF.

-----------------------------------------------------
*//*!
\file ../gui_gtk3/gtk_gl_x11.c
\brief Gtk-binding OpenGL Unix
\code

=====================================================
List_functions_start:

GLB_DrawInit          start OpenGL-commandblock
GLB_DrawExit          execute OpenGL-commandblock

GLB_Create            create opengl-window (used by GUI_gl__)
GLB_Query             display OpenGL-vendorstring (used by GUI_gl__)

List_functions_end:
=====================================================




// Gtk2 + OpenGL:
gcc -c `pkg-config --cflags gtk+-2.0` -DGTK2 gtk_gl_x11.c


// Gtk3 + OpenGL:
gcc -c `pkg-config --cflags gtk+-3.0` -DGTK3 gtk_gl_x11.c


======================================================================
*/


#include <stdio.h>
#include <stdlib.h>

#include <GL/gl.h>
#include <GL/glx.h>

#include <gtk/gtk.h>
#include <gdk/gdkx.h>        // gdk_x11_get_default_xdisplay GDK_WINDOW_XID

// #include "GLB.h"             // GLB_Create
#include "../gui_gtk3/gtk_gl_x11.h"

// 
static  GLXContext  GLB_x_context;
static  Display     *GLB_display;
static  int         GLB_x_id = 0;
static  GtkWidget   *area;
static  int         UI_GR_STAT = 0;



//================================================================
  void*  GLB_Create () {
//================================================================
/// GLB_Create            create opengl-window (used by GUI_gl__)
 
  // GtkWidget   *area;
  int         xscreen, i1;
  GdkScreen   *screen;
  GdkVisual   *visual;
  Window      root;
  XVisualInfo *xvisual;
  Colormap    xcolormap;
  int         attributes[] = {
                GLX_RGBA,
                GLX_DOUBLEBUFFER,
                GLX_RED_SIZE, 0,
                GLX_GREEN_SIZE, 0,
                GLX_BLUE_SIZE, 0,
                GLX_ALPHA_SIZE, 0,
                GLX_DEPTH_SIZE, 8,
                GLX_STENCIL_SIZE, 0,
                GLX_ACCUM_RED_SIZE, 0,
                GLX_ACCUM_GREEN_SIZE, 0,
                GLX_ACCUM_BLUE_SIZE, 0,
                GLX_ACCUM_ALPHA_SIZE, 0,
                None };

GLint           att[] = {
                  GLX_RGBA,
                  GLX_DEPTH_SIZE, 16,
                  GLX_DOUBLEBUFFER,
                // GLX_STENCIL_SIZE, 0,
                // GLX_ACCUM_RED_SIZE, 0,
                // GLX_ACCUM_GREEN_SIZE, 0,
                // GLX_ACCUM_BLUE_SIZE, 0,
                // GLX_ACCUM_ALPHA_SIZE, 0,
                  None };

  Window window;

  printf("GGGGGGGGGGGGG GLB_Create\n");


  area = gtk_drawing_area_new ();
  // gtk_widget_set_double_buffered (area, FALSE);   // deprecated

  // GLB_DrawInit (area);  // 2020-01-16

  // window = gtk_widget_get_window (area);
  // GLB_x_id = GDK_WINDOW_XID(window);                // causes expose!
    // printf("  GLB_x_id=%d\n",GLB_x_id);

  GLB_display = gdk_x11_get_default_xdisplay ();

//   xscreen = DefaultScreen (GLB_display);
//   xvisual = glXChooseVisual (GLB_display, xscreen, attributes);
  xvisual = glXChooseVisual (GLB_display, 0, att);

  if(!xvisual) {
    printf("****** GLB_Create ERROR glXChooseVisual \n");
    exit(-1);
  }


//   root = RootWindow (GLB_display, xscreen);
  root = DefaultRootWindow (GLB_display);

  xcolormap = XCreateColormap (GLB_display, root, xvisual->visual, AllocNone);

    // TESTBLOCK
    printf("GLB_Create visual %p selected\n", (void*)xvisual->visualid);
    glXGetConfig (GLB_display, xvisual, GLX_RED_SIZE, &i1);
    printf(" GLX_RED_SIZE=%d\n",i1);
    glXGetConfig (GLB_display, xvisual, GLX_DEPTH_SIZE, &i1);
    printf(" GLX_DEPTH_SIZE=%d\n",i1);
    // END TESTBLOCK

  // screen = gdk_screen_get_default ();
  //visual = gdk_x11_screen_lookup_visual (screen, xvisual->visualid);
  //colormap = gdk_x11_colormap_foreign_new (visual, xcolormap);
  //gtk_widget_set_colormap (area, colormap);

  GLB_x_context = glXCreateContext (GLB_display, xvisual, NULL, GL_TRUE);
  free (xvisual);

  glXWaitX();
  glXWaitGL();

  return area;

}


//================================================================
  int GLB_Init () {
//================================================================

  GdkWindow     *window;

  // printf("GLB_Init .......\n");

  // window = gtk_widget_get_window (widget);
  window = gtk_widget_get_window (area);
  GLB_x_id = GDK_WINDOW_XID(window);                // causes expose!
    printf("IIIIIIIIIII GLB_Init  GLB_x_id=%d\n",GLB_x_id);

  return 0;

}
 
//================================================================
  int GLB_DrawInit () {
//================================================================
/// GLB_DrawInit          start OpenGL-commandblock


  // printf("GLB_DrawInit \n");

  if(UI_GR_STAT != 0) {
    AP_debug__ ("********************** GLB_DrawInit ERROR");
  }

  UI_GR_STAT = 1;

  // gtk_widget_grab_focus (area);

  glXMakeCurrent (GLB_display, GLB_x_id, GLB_x_context);

  return 0;

}


//================================================================
  void GLB_DrawExit () {
//================================================================
/// GLB_DrawExit          execute OpenGL-commandblock

  // printf("GLB_DrawExit \n");

  if(UI_GR_STAT != 1) {
    AP_debug__ ("********************** GLB_DrawExit ERROR");
  }

  UI_GR_STAT = 0;

  glXSwapBuffers (GLB_display, GLB_x_id);

  return;

}


//================================================================
  int GLB_test1 () {
//================================================================
// test if GLB_Draw is active

  if(UI_GR_STAT == 0) {
    AP_debug__ ("********************** GLB_test1 ERROR");
  }

  return 0;

}


//================================================================
  int GLB_Query () {
//================================================================
/// GLB_Query             display OpenGL-vendorstring (used by GUI_gl__)

  char  const  *p1, *p2;


  p1 = glXGetClientString (GLB_display, GLX_VENDOR);
  if(!p1) return -1;

  p2 = glXGetClientString(GLB_display, GLX_VERSION);
    printf("OpenGL Vendor %s  Version %s\n",p1,p2);

  // p1 = glXGetClientString(GLB_display, GLX_EXTENSIONS);
    // printf("Extensions: %s\n",p1);

  return 0;

}

/*
//================================================================
  int GLB_Config () {
//================================================================

  XVisualInfo *vi;
  int i1;

  vi = get_xvisualinfo(visual);

  glXGetConfig (GLB_display, vi, GLX_RED_SIZE, &i1);
    printf(" GDK_GL_RED_SIZE=%d\n",i1);

  return 0;

}
*/

// EOF
