#!/usr/bin/env python

# Compute the power of five tables used by the floating-point printer.

import string, sys


# compute_p5()-- Given a power of five, return a list of strings that
# are the initialization elements.

def compute_p5(p):
    n = 5L ** (p+1)

    blist = []
    while n != 0:
        x = n & 0xFFFFFFFFFFFFFFFFL;
        n = n >> 64

        w0 = '0x%04X%04X%04X%04XLL' % \
             ((x >> 48) & 0xFFFF, (x >> 32) & 0xFFFF,
              (x >> 16) & 0xFFFF,  x & 0xFFFF)

        blist.append(w0)
        pass

    return blist


def print_indeces(name, ilist):
    print 'static const struct { short len, offset; } %s[] = {' % name

    n = 0
    for t in ilist:
        print '{ %3d, %5d },' % t,
        n = n + 1
        if n % 4 == 0:
            print
            pass

        pass

    print '};'
    return


max_five = 325   # Entries in the single-lookup table.
step = 26        # Number of words that have a power of five in a single word.
limit = 4931     # Maximum exponent that we have to worry about.

offset = 0
p5_list = []

small_p5 = []
big_p5 = []

p = 0

while p <= max_five:
    p5 = compute_p5(p)

    p5_list = p5_list + p5
    small_p5.append( (len(p5), offset) )

    offset = offset + len(p5)
    p = p + 1
    pass

p = max_five

while p <= limit:
    p5 = compute_p5(p)

    p5_list = p5_list + p5
    big_p5.append( (len(p5), offset) )

    offset = offset + len(p5)
    p = p + step
    pass


print "/* This file is generated by the p5.py script.  Don't modify! */"
print '#define MAX_FIVE', max_five
print '#define STEP_FIVE', step
print

print_indeces('small_p5', small_p5)

print

print_indeces('big_p5', big_p5)

print

print 'static const Bigit power5[] = {'

n = 0
for p in p5_list:
    print '%s,' % p,
    if n % 3 == 2:
        print
        pass

    n = n + 1
    pass

print '};'

