

/* Table of cutoff values for G formatting for 0 <= d <= 35.  Of
 * course, this file is generated and should not be modified. */

static const bigfloat cutoffs[] = {
   /* d = 0 */
   { -5, { 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCCCCCCCCU } }, /* 5.E-2 */
   { -1, { 0x80000000U, 0x00000000U, 0x00000000U, 0x00000000U } }, /* 5.E-1 */

   /* d = 1 */
   { -4, { 0xC28F5C28U, 0xF5C28F5CU, 0x28F5C28FU, 0x5C28F5C2U } }, /* 9.5E-2 */
   { -1, { 0xF3333333U, 0x33333333U, 0x33333333U, 0x33333333U } }, /* 9.5E-1 */
   {  3, { 0x98000000U, 0x00000000U, 0x00000000U, 0x00000000U } }, /* 9.5E+0 */

   /* d = 2 */
   { -4, { 0xCBC6A7EFU, 0x9DB22D0EU, 0x56041893U, 0x74BC6A7EU } }, /* 9.95E-2 */
   { -1, { 0xFEB851EBU, 0x851EB851U, 0xEB851EB8U, 0x51EB851EU } }, /* 9.95E-1 */
   {  3, { 0x9F333333U, 0x33333333U, 0x33333333U, 0x33333333U } }, /* 9.95E+0 */
   {  6, { 0xC7000000U, 0x00000000U, 0x00000000U, 0x00000000U } }, /* 9.95E+1 */

   /* d = 3 */
   { -4, { 0xCCB295E9U, 0xE1B089A0U, 0x27525460U, 0xAA64C2F8U } }, /* 9.995E-2 */
   { -1, { 0xFFDF3B64U, 0x5A1CAC08U, 0x3126E978U, 0xD4FDF3B6U } }, /* 9.995E-1 */
   {  3, { 0x9FEB851EU, 0xB851EB85U, 0x1EB851EBU, 0x851EB851U } }, /* 9.995E+0 */
   {  6, { 0xC7E66666U, 0x66666666U, 0x66666666U, 0x66666666U } }, /* 9.995E+1 */
   {  9, { 0xF9E00000U, 0x00000000U, 0x00000000U, 0x00000000U } }, /* 9.995E+2 */

   /* d = 4 */
   { -4, { 0xCCCA2DB6U, 0x1BB05FAEU, 0xBC408D8EU, 0xC95BFF04U } }, /* 9.9995E-2 */
   { -1, { 0xFFFCB923U, 0xA29C779AU, 0x6B50B0F2U, 0x7BB2FEC5U } }, /* 9.9995E-1 */
   {  3, { 0x9FFDF3B6U, 0x45A1CAC0U, 0x83126E97U, 0x8D4FDF3BU } }, /* 9.9995E+0 */
   {  6, { 0xC7FD70A3U, 0xD70A3D70U, 0xA3D70A3DU, 0x70A3D70AU } }, /* 9.9995E+1 */
   {  9, { 0xF9FCCCCCU, 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCCCCCCCCU } }, /* 9.9995E+2 */
   { 13, { 0x9C3E0000U, 0x00000000U, 0x00000000U, 0x00000000U } }, /* 9.9995E+3 */

   /* d = 5 */
   { -4, { 0xCCCC89B0U, 0xEE49F516U, 0x97F1F9ACU, 0xFFA7EB6BU } }, /* 9.99995E-2 */
   { -1, { 0xFFFFAC1DU, 0x29DC725CU, 0x3DEE7818U, 0x3F91E646U } }, /* 9.99995E-1 */
   {  3, { 0x9FFFCB92U, 0x3A29C779U, 0xA6B50B0FU, 0x27BB2FECU } }, /* 9.99995E+0 */
   {  6, { 0xC7FFBE76U, 0xC8B43958U, 0x10624DD2U, 0xF1A9FBE7U } }, /* 9.99995E+1 */
   {  9, { 0xF9FFAE14U, 0x7AE147AEU, 0x147AE147U, 0xAE147AE1U } }, /* 9.99995E+2 */
   { 13, { 0x9C3FCCCCU, 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCCCCCCCCU } }, /* 9.99995E+3 */
   { 16, { 0xC34FC000U, 0x00000000U, 0x00000000U, 0x00000000U } }, /* 9.99995E+4 */

   /* d = 6 */
   { -4, { 0xCCCCC616U, 0xD0261DA0U, 0xFAB6EAE3U, 0x38491CA9U } }, /* 9.999995E-2 */
   { -1, { 0xFFFFF79CU, 0x842FA509U, 0x3964A59CU, 0x065B63D3U } }, /* 9.999995E-1 */
   {  3, { 0x9FFFFAC1U, 0xD29DC725U, 0xC3DEE781U, 0x83F91E64U } }, /* 9.999995E+0 */
   {  6, { 0xC7FFF972U, 0x474538EFU, 0x34D6A161U, 0xE4F765FDU } }, /* 9.999995E+1 */
   {  9, { 0xF9FFF7CEU, 0xD916872BU, 0x020C49BAU, 0x5E353F7CU } }, /* 9.999995E+2 */
   { 13, { 0x9C3FFAE1U, 0x47AE147AU, 0xE147AE14U, 0x7AE147AEU } }, /* 9.999995E+3 */
   { 16, { 0xC34FF999U, 0x99999999U, 0x99999999U, 0x99999999U } }, /* 9.999995E+4 */
   { 19, { 0xF423F800U, 0x00000000U, 0x00000000U, 0x00000000U } }, /* 9.999995E+5 */

   /* d = 7 */
   { -4, { 0xCCCCCC21U, 0x0055BB48U, 0x6AFDCFCFU, 0x0ABFA196U } }, /* 9.9999995E-2 */
   { -1, { 0xFFFFFF29U, 0x406B2A1AU, 0x85BD43C2U, 0xCD6F89FBU } }, /* 9.9999995E-1 */
   {  3, { 0x9FFFFF79U, 0xC842FA50U, 0x93964A59U, 0xC065B63DU } }, /* 9.9999995E+0 */
   {  6, { 0xC7FFFF58U, 0x3A53B8E4U, 0xB87BDCF0U, 0x307F23CCU } }, /* 9.9999995E+1 */
   {  9, { 0xF9FFFF2EU, 0x48E8A71DU, 0xE69AD42CU, 0x3C9EECBFU } }, /* 9.9999995E+2 */
   { 13, { 0x9C3FFF7CU, 0xED916872U, 0xB020C49BU, 0xA5E353F7U } }, /* 9.9999995E+3 */
   { 16, { 0xC34FFF5CU, 0x28F5C28FU, 0x5C28F5C2U, 0x8F5C28F5U } }, /* 9.9999995E+4 */
   { 19, { 0xF423FF33U, 0x33333333U, 0x33333333U, 0x33333333U } }, /* 9.9999995E+5 */
   { 23, { 0x98967F80U, 0x00000000U, 0x00000000U, 0x00000000U } }, /* 9.9999995E+6 */

   /* d = 8 */
   { -4, { 0xCCCCCCBBU, 0x9EC0E4A5U, 0xF63819E6U, 0x9FCB7BADU } }, /* 9.99999995E-2 */
   { -1, { 0xFFFFFFEAU, 0x86711DCFU, 0x73C62060U, 0x47BE5A99U } }, /* 9.99999995E-1 */
   {  3, { 0x9FFFFFF2U, 0x9406B2A1U, 0xA85BD43CU, 0x2CD6F89FU } }, /* 9.99999995E+0 */
   {  6, { 0xC7FFFFEFU, 0x39085F4AU, 0x1272C94BU, 0x380CB6C7U } }, /* 9.99999995E+1 */
   {  9, { 0xF9FFFFEBU, 0x074A771CU, 0x970F7B9EU, 0x060FE479U } }, /* 9.99999995E+2 */
   { 13, { 0x9C3FFFF2U, 0xE48E8A71U, 0xDE69AD42U, 0xC3C9EECBU } }, /* 9.99999995E+3 */
   { 16, { 0xC34FFFEFU, 0x9DB22D0EU, 0x56041893U, 0x74BC6A7EU } }, /* 9.99999995E+4 */
   { 19, { 0xF423FFEBU, 0x851EB851U, 0xEB851EB8U, 0x51EB851EU } }, /* 9.99999995E+5 */
   { 23, { 0x98967FF3U, 0x33333333U, 0x33333333U, 0x33333333U } }, /* 9.99999995E+6 */
   { 26, { 0xBEBC1FF0U, 0x00000000U, 0x00000000U, 0x00000000U } }, /* 9.99999995E+7 */

   /* d = 9 */
   { -4, { 0xCCCCCCCBU, 0x14FECF2FU, 0x50F1214FU, 0x61E644B0U } }, /* 9.999999995E-2 */
   { -1, { 0xFFFFFFFDU, 0xDA3E82FBU, 0x252D69A3U, 0x3A5FD5DCU } }, /* 9.999999995E-1 */
   {  3, { 0x9FFFFFFEU, 0xA86711DCU, 0xF73C6206U, 0x047BE5A9U } }, /* 9.999999995E+0 */
   {  6, { 0xC7FFFFFEU, 0x5280D654U, 0x350B7A87U, 0x859ADF13U } }, /* 9.999999995E+1 */
   {  9, { 0xF9FFFFFDU, 0xE7210BE9U, 0x424E5929U, 0x670196D8U } }, /* 9.999999995E+2 */
   { 13, { 0x9C3FFFFEU, 0xB074A771U, 0xC970F7B9U, 0xE060FE47U } }, /* 9.999999995E+3 */
   { 16, { 0xC34FFFFEU, 0x5C91D14EU, 0x3BCD35A8U, 0x58793DD9U } }, /* 9.999999995E+4 */
   { 19, { 0xF423FFFDU, 0xF3B645A1U, 0xCAC08312U, 0x6E978D4FU } }, /* 9.999999995E+5 */
   { 23, { 0x98967FFEU, 0xB851EB85U, 0x1EB851EBU, 0x851EB851U } }, /* 9.999999995E+6 */
   { 26, { 0xBEBC1FFEU, 0x66666666U, 0x66666666U, 0x66666666U } }, /* 9.999999995E+7 */
   { 29, { 0xEE6B27FEU, 0x00000000U, 0x00000000U, 0x00000000U } }, /* 9.999999995E+8 */

   /* d = 10 */
   { -4, { 0xCCCCCCCCU, 0xA0D1CD09U, 0xDA03A20DU, 0x0EE8F263U } }, /* 9.9999999995E-2 */
   { -1, { 0xFFFFFFFFU, 0xC906404CU, 0x50848A90U, 0x52A32EFCU } }, /* 9.9999999995E-1 */
   {  3, { 0x9FFFFFFFU, 0xDDA3E82FU, 0xB252D69AU, 0x33A5FD5DU } }, /* 9.9999999995E+0 */
   {  6, { 0xC7FFFFFFU, 0xD50CE23BU, 0x9EE78C40U, 0xC08F7CB5U } }, /* 9.9999999995E+1 */
   {  9, { 0xF9FFFFFFU, 0xCA501ACAU, 0x86A16F50U, 0xF0B35BE2U } }, /* 9.9999999995E+2 */
   { 13, { 0x9C3FFFFFU, 0xDE7210BEU, 0x9424E592U, 0x9670196DU } }, /* 9.9999999995E+3 */
   { 16, { 0xC34FFFFFU, 0xD60E94EEU, 0x392E1EF7U, 0x3C0C1FC8U } }, /* 9.9999999995E+4 */
   { 19, { 0xF423FFFFU, 0xCB923A29U, 0xC779A6B5U, 0x0B0F27BBU } }, /* 9.9999999995E+5 */
   { 23, { 0x98967FFFU, 0xDF3B645AU, 0x1CAC0831U, 0x26E978D4U } }, /* 9.9999999995E+6 */
   { 26, { 0xBEBC1FFFU, 0xD70A3D70U, 0xA3D70A3DU, 0x70A3D70AU } }, /* 9.9999999995E+7 */
   { 29, { 0xEE6B27FFU, 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCCCCCCCCU } }, /* 9.9999999995E+8 */
   { 33, { 0x9502F8FFU, 0xE0000000U, 0x00000000U, 0x00000000U } }, /* 9.9999999995E+9 */

   /* d = 11 */
   { -4, { 0xCCCCCCCCU, 0xC866E66CU, 0x81524886U, 0x6D02D08FU } }, /* 9.99999999995E-2 */
   { -1, { 0xFFFFFFFFU, 0xFA80A007U, 0xA1A6DAA8U, 0x084384B2U } }, /* 9.99999999995E-1 */
   {  3, { 0x9FFFFFFFU, 0xFC906404U, 0xC50848A9U, 0x052A32EFU } }, /* 9.99999999995E+0 */
   {  6, { 0xC7FFFFFFU, 0xFBB47D05U, 0xF64A5AD3U, 0x4674BFABU } }, /* 9.99999999995E+1 */
   {  9, { 0xF9FFFFFFU, 0xFAA19C47U, 0x73DCF188U, 0x1811EF96U } }, /* 9.99999999995E+2 */
   { 13, { 0x9C3FFFFFU, 0xFCA501ACU, 0xA86A16F5U, 0x0F0B35BEU } }, /* 9.99999999995E+3 */
   { 16, { 0xC34FFFFFU, 0xFBCE4217U, 0xD2849CB2U, 0x52CE032DU } }, /* 9.99999999995E+4 */
   { 19, { 0xF423FFFFU, 0xFAC1D29DU, 0xC725C3DEU, 0xE78183F9U } }, /* 9.99999999995E+5 */
   { 23, { 0x98967FFFU, 0xFCB923A2U, 0x9C779A6BU, 0x50B0F27BU } }, /* 9.99999999995E+6 */
   { 26, { 0xBEBC1FFFU, 0xFBE76C8BU, 0x43958106U, 0x24DD2F1AU } }, /* 9.99999999995E+7 */
   { 29, { 0xEE6B27FFU, 0xFAE147AEU, 0x147AE147U, 0xAE147AE1U } }, /* 9.99999999995E+8 */
   { 33, { 0x9502F8FFU, 0xFCCCCCCCU, 0xCCCCCCCCU, 0xCCCCCCCCU } }, /* 9.99999999995E+9 */
   { 36, { 0xBA43B73FU, 0xFC000000U, 0x00000000U, 0x00000000U } }, /* 9.99999999995E+10 */

   /* d = 12 */
   { -4, { 0xCCCCCCCCU, 0xCC5C35C3U, 0x2BA6F2C5U, 0xC33899F9U } }, /* 9.999999999995E-2 */
   { -1, { 0xFFFFFFFFU, 0xFF734333U, 0xF690AF77U, 0x3406C078U } }, /* 9.999999999995E-1 */
   {  3, { 0x9FFFFFFFU, 0xFFA80A00U, 0x7A1A6DAAU, 0x8084384BU } }, /* 9.999999999995E+0 */
   {  6, { 0xC7FFFFFFU, 0xFF920C80U, 0x98A10915U, 0x20A5465DU } }, /* 9.999999999995E+1 */
   {  9, { 0xF9FFFFFFU, 0xFF768FA0U, 0xBEC94B5AU, 0x68CE97F5U } }, /* 9.999999999995E+2 */
   { 13, { 0x9C3FFFFFU, 0xFFAA19C4U, 0x773DCF18U, 0x81811EF9U } }, /* 9.999999999995E+3 */
   { 16, { 0xC34FFFFFU, 0xFF94A035U, 0x950D42DEU, 0xA1E166B7U } }, /* 9.999999999995E+4 */
   { 19, { 0xF423FFFFU, 0xFF79C842U, 0xFA509396U, 0x4A59C065U } }, /* 9.999999999995E+5 */
   { 23, { 0x98967FFFU, 0xFFAC1D29U, 0xDC725C3DU, 0xEE78183FU } }, /* 9.999999999995E+6 */
   { 26, { 0xBEBC1FFFU, 0xFF972474U, 0x538EF34DU, 0x6A161E4FU } }, /* 9.999999999995E+7 */
   { 29, { 0xEE6B27FFU, 0xFF7CED91U, 0x6872B020U, 0xC49BA5E3U } }, /* 9.999999999995E+8 */
   { 33, { 0x9502F8FFU, 0xFFAE147AU, 0xE147AE14U, 0x7AE147AEU } }, /* 9.999999999995E+9 */
   { 36, { 0xBA43B73FU, 0xFF999999U, 0x99999999U, 0x99999999U } }, /* 9.999999999995E+10 */
   { 39, { 0xE8D4A50FU, 0xFF800000U, 0x00000000U, 0x00000000U } }, /* 9.999999999995E+11 */

   /* d = 13 */
   { -4, { 0xCCCCCCCCU, 0xCCC18A7FU, 0x097C36FFU, 0x4BD79484U } }, /* 9.9999999999995E-2 */
   { -1, { 0xFFFFFFFFU, 0xFFF1ED1EU, 0xCBDB44BFU, 0x1ECD79A5U } }, /* 9.9999999999995E-1 */
   {  3, { 0x9FFFFFFFU, 0xFFF73433U, 0x3F690AF7U, 0x73406C07U } }, /* 9.9999999999995E+0 */
   {  6, { 0xC7FFFFFFU, 0xFFF50140U, 0x0F434DB5U, 0x50108709U } }, /* 9.9999999999995E+1 */
   {  9, { 0xF9FFFFFFU, 0xFFF24190U, 0x13142122U, 0xA414A8CBU } }, /* 9.9999999999995E+2 */
   { 13, { 0x9C3FFFFFU, 0xFFF768FAU, 0x0BEC94B5U, 0xA68CE97FU } }, /* 9.9999999999995E+3 */
   { 16, { 0xC34FFFFFU, 0xFFF54338U, 0x8EE7B9E3U, 0x103023DFU } }, /* 9.9999999999995E+4 */
   { 19, { 0xF423FFFFU, 0xFFF29406U, 0xB2A1A85BU, 0xD43C2CD6U } }, /* 9.9999999999995E+5 */
   { 23, { 0x98967FFFU, 0xFFF79C84U, 0x2FA50939U, 0x64A59C06U } }, /* 9.9999999999995E+6 */
   { 26, { 0xBEBC1FFFU, 0xFFF583A5U, 0x3B8E4B87U, 0xBDCF0307U } }, /* 9.9999999999995E+7 */
   { 29, { 0xEE6B27FFU, 0xFFF2E48EU, 0x8A71DE69U, 0xAD42C3C9U } }, /* 9.9999999999995E+8 */
   { 33, { 0x9502F8FFU, 0xFFF7CED9U, 0x16872B02U, 0x0C49BA5EU } }, /* 9.9999999999995E+9 */
   { 36, { 0xBA43B73FU, 0xFFF5C28FU, 0x5C28F5C2U, 0x8F5C28F5U } }, /* 9.9999999999995E+10 */
   { 39, { 0xE8D4A50FU, 0xFFF33333U, 0x33333333U, 0x33333333U } }, /* 9.9999999999995E+11 */
   { 43, { 0x9184E729U, 0xFFF80000U, 0x00000000U, 0x00000000U } }, /* 9.9999999999995E+12 */

   /* d = 14 */
   { -4, { 0xCCCCCCCCU, 0xCCCBAC91U, 0xD2DE576BU, 0x731AAD92U } }, /* 9.99999999999995E-2 */
   { -1, { 0xFFFFFFFFU, 0xFFFE97B6U, 0x4795ED46U, 0x4FE158F6U } }, /* 9.99999999999995E-1 */
   {  3, { 0x9FFFFFFFU, 0xFFFF1ED1U, 0xECBDB44BU, 0xF1ECD79AU } }, /* 9.99999999999995E+0 */
   {  6, { 0xC7FFFFFFU, 0xFFFEE686U, 0x67ED215EU, 0xEE680D80U } }, /* 9.99999999999995E+1 */
   {  9, { 0xF9FFFFFFU, 0xFFFEA028U, 0x01E869B6U, 0xAA0210E1U } }, /* 9.99999999999995E+2 */
   { 13, { 0x9C3FFFFFU, 0xFFFF2419U, 0x01314212U, 0x2A414A8CU } }, /* 9.99999999999995E+3 */
   { 16, { 0xC34FFFFFU, 0xFFFEED1FU, 0x417D9296U, 0xB4D19D2FU } }, /* 9.99999999999995E+4 */
   { 19, { 0xF423FFFFU, 0xFFFEA867U, 0x11DCF73CU, 0x6206047BU } }, /* 9.99999999999995E+5 */
   { 23, { 0x98967FFFU, 0xFFFF2940U, 0x6B2A1A85U, 0xBD43C2CDU } }, /* 9.99999999999995E+6 */
   { 26, { 0xBEBC1FFFU, 0xFFFEF390U, 0x85F4A127U, 0x2C94B380U } }, /* 9.99999999999995E+7 */
   { 29, { 0xEE6B27FFU, 0xFFFEB074U, 0xA771C970U, 0xF7B9E060U } }, /* 9.99999999999995E+8 */
   { 33, { 0x9502F8FFU, 0xFFFF2E48U, 0xE8A71DE6U, 0x9AD42C3CU } }, /* 9.99999999999995E+9 */
   { 36, { 0xBA43B73FU, 0xFFFEF9DBU, 0x22D0E560U, 0x4189374BU } }, /* 9.99999999999995E+10 */
   { 39, { 0xE8D4A50FU, 0xFFFEB851U, 0xEB851EB8U, 0x51EB851EU } }, /* 9.99999999999995E+11 */
   { 43, { 0x9184E729U, 0xFFFF3333U, 0x33333333U, 0x33333333U } }, /* 9.99999999999995E+12 */
   { 46, { 0xB5E620F4U, 0x7FFF0000U, 0x00000000U, 0x00000000U } }, /* 9.99999999999995E+13 */

   /* d = 15 */
   { -4, { 0xCCCCCCCCU, 0xCCCCAFFAU, 0x1A34F443U, 0x10A16346U } }, /* 9.999999999999995E-2 */
   { -1, { 0xFFFFFFFFU, 0xFFFFDBF8U, 0xA0C23153U, 0xD4C9BC18U } }, /* 9.999999999999995E-1 */
   {  3, { 0x9FFFFFFFU, 0xFFFFE97BU, 0x64795ED4U, 0x64FE158FU } }, /* 9.999999999999995E+0 */
   {  6, { 0xC7FFFFFFU, 0xFFFFE3DAU, 0x3D97B689U, 0x7E3D9AF3U } }, /* 9.999999999999995E+1 */
   {  9, { 0xF9FFFFFFU, 0xFFFFDCD0U, 0xCCFDA42BU, 0xDDCD01B0U } }, /* 9.999999999999995E+2 */
   { 13, { 0x9C3FFFFFU, 0xFFFFEA02U, 0x801E869BU, 0x6AA0210EU } }, /* 9.999999999999995E+3 */
   { 16, { 0xC34FFFFFU, 0xFFFFE483U, 0x20262842U, 0x45482951U } }, /* 9.999999999999995E+4 */
   { 19, { 0xF423FFFFU, 0xFFFFDDA3U, 0xE82FB252U, 0xD69A33A5U } }, /* 9.999999999999995E+5 */
   { 23, { 0x98967FFFU, 0xFFFFEA86U, 0x711DCF73U, 0xC6206047U } }, /* 9.999999999999995E+6 */
   { 26, { 0xBEBC1FFFU, 0xFFFFE528U, 0x0D654350U, 0xB7A87859U } }, /* 9.999999999999995E+7 */
   { 29, { 0xEE6B27FFU, 0xFFFFDE72U, 0x10BE9424U, 0xE5929670U } }, /* 9.999999999999995E+8 */
   { 33, { 0x9502F8FFU, 0xFFFFEB07U, 0x4A771C97U, 0x0F7B9E06U } }, /* 9.999999999999995E+9 */
   { 36, { 0xBA43B73FU, 0xFFFFE5C9U, 0x1D14E3BCU, 0xD35A8587U } }, /* 9.999999999999995E+10 */
   { 39, { 0xE8D4A50FU, 0xFFFFDF3BU, 0x645A1CACU, 0x083126E9U } }, /* 9.999999999999995E+11 */
   { 43, { 0x9184E729U, 0xFFFFEB85U, 0x1EB851EBU, 0x851EB851U } }, /* 9.999999999999995E+12 */
   { 46, { 0xB5E620F4U, 0x7FFFE666U, 0x66666666U, 0x66666666U } }, /* 9.999999999999995E+13 */
   { 49, { 0xE35FA931U, 0x9FFFE000U, 0x00000000U, 0x00000000U } }, /* 9.999999999999995E+14 */

   /* d = 16 */
   { -4, { 0xCCCCCCCCU, 0xCCCCC9EAU, 0xEE2403F2U, 0x39FBA8A5U } }, /* 9.9999999999999995E-2 */
   { -1, { 0xFFFFFFFFU, 0xFFFFFC65U, 0xA9AD04EEU, 0xC87A92CFU } }, /* 9.9999999999999995E-1 */
   {  3, { 0x9FFFFFFFU, 0xFFFFFDBFU, 0x8A0C2315U, 0x3D4C9BC1U } }, /* 9.9999999999999995E+0 */
   {  6, { 0xC7FFFFFFU, 0xFFFFFD2FU, 0x6C8F2BDAU, 0x8C9FC2B1U } }, /* 9.9999999999999995E+1 */
   {  9, { 0xF9FFFFFFU, 0xFFFFFC7BU, 0x47B2F6D1U, 0x2FC7B35EU } }, /* 9.9999999999999995E+2 */
   { 13, { 0x9C3FFFFFU, 0xFFFFFDCDU, 0x0CCFDA42U, 0xBDDCD01BU } }, /* 9.9999999999999995E+3 */
   { 16, { 0xC34FFFFFU, 0xFFFFFD40U, 0x5003D0D3U, 0x6D540421U } }, /* 9.9999999999999995E+4 */
   { 19, { 0xF423FFFFU, 0xFFFFFC90U, 0x6404C508U, 0x48A9052AU } }, /* 9.9999999999999995E+5 */
   { 23, { 0x98967FFFU, 0xFFFFFDDAU, 0x3E82FB25U, 0x2D69A33AU } }, /* 9.9999999999999995E+6 */
   { 26, { 0xBEBC1FFFU, 0xFFFFFD50U, 0xCE23B9EEU, 0x78C40C08U } }, /* 9.9999999999999995E+7 */
   { 29, { 0xEE6B27FFU, 0xFFFFFCA5U, 0x01ACA86AU, 0x16F50F0BU } }, /* 9.9999999999999995E+8 */
   { 33, { 0x9502F8FFU, 0xFFFFFDE7U, 0x210BE942U, 0x4E592967U } }, /* 9.9999999999999995E+9 */
   { 36, { 0xBA43B73FU, 0xFFFFFD60U, 0xE94EE392U, 0xE1EF73C0U } }, /* 9.9999999999999995E+10 */
   { 39, { 0xE8D4A50FU, 0xFFFFFCB9U, 0x23A29C77U, 0x9A6B50B0U } }, /* 9.9999999999999995E+11 */
   { 43, { 0x9184E729U, 0xFFFFFDF3U, 0xB645A1CAU, 0xC083126EU } }, /* 9.9999999999999995E+12 */
   { 46, { 0xB5E620F4U, 0x7FFFFD70U, 0xA3D70A3DU, 0x70A3D70AU } }, /* 9.9999999999999995E+13 */
   { 49, { 0xE35FA931U, 0x9FFFFCCCU, 0xCCCCCCCCU, 0xCCCCCCCCU } }, /* 9.9999999999999995E+14 */
   { 53, { 0x8E1BC9BFU, 0x03FFFE00U, 0x00000000U, 0x00000000U } }, /* 9.9999999999999995E+15 */

   /* d = 17 */
   { -4, { 0xCCCCCCCCU, 0xCCCCCC83U, 0x03558583U, 0xBE1E492FU } }, /* 9.99999999999999995E-2 */
   { -1, { 0xFFFFFFFFU, 0xFFFFFFA3U, 0xC42AE6E4U, 0xADA5DB7BU } }, /* 9.99999999999999995E-1 */
   {  3, { 0x9FFFFFFFU, 0xFFFFFFC6U, 0x5A9AD04EU, 0xEC87A92CU } }, /* 9.99999999999999995E+0 */
   {  6, { 0xC7FFFFFFU, 0xFFFFFFB7U, 0xF1418462U, 0xA7A99378U } }, /* 9.99999999999999995E+1 */
   {  9, { 0xF9FFFFFFU, 0xFFFFFFA5U, 0xED91E57BU, 0x5193F856U } }, /* 9.99999999999999995E+2 */
   { 13, { 0x9C3FFFFFU, 0xFFFFFFC7U, 0xB47B2F6DU, 0x12FC7B35U } }, /* 9.99999999999999995E+3 */
   { 16, { 0xC34FFFFFU, 0xFFFFFFB9U, 0xA199FB48U, 0x57BB9A03U } }, /* 9.99999999999999995E+4 */
   { 19, { 0xF423FFFFU, 0xFFFFFFA8U, 0x0A007A1AU, 0x6DAA8084U } }, /* 9.99999999999999995E+5 */
   { 23, { 0x98967FFFU, 0xFFFFFFC9U, 0x06404C50U, 0x848A9052U } }, /* 9.99999999999999995E+6 */
   { 26, { 0xBEBC1FFFU, 0xFFFFFFBBU, 0x47D05F64U, 0xA5AD3467U } }, /* 9.99999999999999995E+7 */
   { 29, { 0xEE6B27FFU, 0xFFFFFFAAU, 0x19C4773DU, 0xCF188181U } }, /* 9.99999999999999995E+8 */
   { 33, { 0x9502F8FFU, 0xFFFFFFCAU, 0x501ACA86U, 0xA16F50F0U } }, /* 9.99999999999999995E+9 */
   { 36, { 0xBA43B73FU, 0xFFFFFFBCU, 0xE4217D28U, 0x49CB252CU } }, /* 9.99999999999999995E+10 */
   { 39, { 0xE8D4A50FU, 0xFFFFFFACU, 0x1D29DC72U, 0x5C3DEE78U } }, /* 9.99999999999999995E+11 */
   { 43, { 0x9184E729U, 0xFFFFFFCBU, 0x923A29C7U, 0x79A6B50BU } }, /* 9.99999999999999995E+12 */
   { 46, { 0xB5E620F4U, 0x7FFFFFBEU, 0x76C8B439U, 0x5810624DU } }, /* 9.99999999999999995E+13 */
   { 49, { 0xE35FA931U, 0x9FFFFFAEU, 0x147AE147U, 0xAE147AE1U } }, /* 9.99999999999999995E+14 */
   { 53, { 0x8E1BC9BFU, 0x03FFFFCCU, 0xCCCCCCCCU, 0xCCCCCCCCU } }, /* 9.99999999999999995E+15 */
   { 56, { 0xB1A2BC2EU, 0xC4FFFFC0U, 0x00000000U, 0x00000000U } }, /* 9.99999999999999995E+16 */

   /* d = 18 */
   { -4, { 0xCCCCCCCCU, 0xCCCCCCC5U, 0x6BDA78DFU, 0x1821BFA3U } }, /* 9.999999999999999995E-2 */
   { -1, { 0xFFFFFFFFU, 0xFFFFFFF6U, 0xC6D11716U, 0xDE2A2F8CU } }, /* 9.999999999999999995E-1 */
   {  3, { 0x9FFFFFFFU, 0xFFFFFFFAU, 0x3C42AE6EU, 0x4ADA5DB7U } }, /* 9.999999999999999995E+0 */
   {  6, { 0xC7FFFFFFU, 0xFFFFFFF8U, 0xCB535A09U, 0xDD90F525U } }, /* 9.999999999999999995E+1 */
   {  9, { 0xF9FFFFFFU, 0xFFFFFFF6U, 0xFE28308CU, 0x54F5326FU } }, /* 9.999999999999999995E+2 */
   { 13, { 0x9C3FFFFFU, 0xFFFFFFFAU, 0x5ED91E57U, 0xB5193F85U } }, /* 9.999999999999999995E+3 */
   { 16, { 0xC34FFFFFU, 0xFFFFFFF8U, 0xF68F65EDU, 0xA25F8F66U } }, /* 9.999999999999999995E+4 */
   { 19, { 0xF423FFFFU, 0xFFFFFFF7U, 0x34333F69U, 0x0AF77340U } }, /* 9.999999999999999995E+5 */
   { 23, { 0x98967FFFU, 0xFFFFFFFAU, 0x80A007A1U, 0xA6DAA808U } }, /* 9.999999999999999995E+6 */
   { 26, { 0xBEBC1FFFU, 0xFFFFFFF9U, 0x20C8098AU, 0x1091520AU } }, /* 9.999999999999999995E+7 */
   { 29, { 0xEE6B27FFU, 0xFFFFFFF7U, 0x68FA0BECU, 0x94B5A68CU } }, /* 9.999999999999999995E+8 */
   { 33, { 0x9502F8FFU, 0xFFFFFFFAU, 0xA19C4773U, 0xDCF18818U } }, /* 9.999999999999999995E+9 */
   { 36, { 0xBA43B73FU, 0xFFFFFFF9U, 0x4A035950U, 0xD42DEA1EU } }, /* 9.999999999999999995E+10 */
   { 39, { 0xE8D4A50FU, 0xFFFFFFF7U, 0x9C842FA5U, 0x093964A5U } }, /* 9.999999999999999995E+11 */
   { 43, { 0x9184E729U, 0xFFFFFFFAU, 0xC1D29DC7U, 0x25C3DEE7U } }, /* 9.999999999999999995E+12 */
   { 46, { 0xB5E620F4U, 0x7FFFFFF9U, 0x72474538U, 0xEF34D6A1U } }, /* 9.999999999999999995E+13 */
   { 49, { 0xE35FA931U, 0x9FFFFFF7U, 0xCED91687U, 0x2B020C49U } }, /* 9.999999999999999995E+14 */
   { 53, { 0x8E1BC9BFU, 0x03FFFFFAU, 0xE147AE14U, 0x7AE147AEU } }, /* 9.999999999999999995E+15 */
   { 56, { 0xB1A2BC2EU, 0xC4FFFFF9U, 0x99999999U, 0x99999999U } }, /* 9.999999999999999995E+16 */
   { 59, { 0xDE0B6B3AU, 0x763FFFF8U, 0x00000000U, 0x00000000U } }, /* 9.999999999999999995E+17 */

   /* d = 19 */
   { -4, { 0xCCCCCCCCU, 0xCCCCCCCCU, 0x0FE7C468U, 0x3ABBB1E2U } }, /* 9.9999999999999999995E-2 */
   { -1, { 0xFFFFFFFFU, 0xFFFFFFFFU, 0x13E1B582U, 0x496A9E5AU } }, /* 9.9999999999999999995E-1 */
   {  3, { 0x9FFFFFFFU, 0xFFFFFFFFU, 0x6C6D1171U, 0x6DE2A2F8U } }, /* 9.9999999999999999995E+0 */
   {  6, { 0xC7FFFFFFU, 0xFFFFFFFFU, 0x478855CDU, 0xC95B4BB6U } }, /* 9.9999999999999999995E+1 */
   {  9, { 0xF9FFFFFFU, 0xFFFFFFFFU, 0x196A6B41U, 0x3BB21EA4U } }, /* 9.9999999999999999995E+2 */
   { 13, { 0x9C3FFFFFU, 0xFFFFFFFFU, 0x6FE28308U, 0xC54F5326U } }, /* 9.9999999999999999995E+3 */
   { 16, { 0xC34FFFFFU, 0xFFFFFFFFU, 0x4BDB23CAU, 0xF6A327F0U } }, /* 9.9999999999999999995E+4 */
   { 19, { 0xF423FFFFU, 0xFFFFFFFFU, 0x1ED1ECBDU, 0xB44BF1ECU } }, /* 9.9999999999999999995E+5 */
   { 23, { 0x98967FFFU, 0xFFFFFFFFU, 0x734333F6U, 0x90AF7734U } }, /* 9.9999999999999999995E+6 */
   { 26, { 0xBEBC1FFFU, 0xFFFFFFFFU, 0x501400F4U, 0x34DB5501U } }, /* 9.9999999999999999995E+7 */
   { 29, { 0xEE6B27FFU, 0xFFFFFFFFU, 0x24190131U, 0x42122A41U } }, /* 9.9999999999999999995E+8 */
   { 33, { 0x9502F8FFU, 0xFFFFFFFFU, 0x768FA0BEU, 0xC94B5A68U } }, /* 9.9999999999999999995E+9 */
   { 36, { 0xBA43B73FU, 0xFFFFFFFFU, 0x543388EEU, 0x7B9E3103U } }, /* 9.9999999999999999995E+10 */
   { 39, { 0xE8D4A50FU, 0xFFFFFFFFU, 0x29406B2AU, 0x1A85BD43U } }, /* 9.9999999999999999995E+11 */
   { 43, { 0x9184E729U, 0xFFFFFFFFU, 0x79C842FAU, 0x5093964AU } }, /* 9.9999999999999999995E+12 */
   { 46, { 0xB5E620F4U, 0x7FFFFFFFU, 0x583A53B8U, 0xE4B87BDCU } }, /* 9.9999999999999999995E+13 */
   { 49, { 0xE35FA931U, 0x9FFFFFFFU, 0x2E48E8A7U, 0x1DE69AD4U } }, /* 9.9999999999999999995E+14 */
   { 53, { 0x8E1BC9BFU, 0x03FFFFFFU, 0x7CED9168U, 0x72B020C4U } }, /* 9.9999999999999999995E+15 */
   { 56, { 0xB1A2BC2EU, 0xC4FFFFFFU, 0x5C28F5C2U, 0x8F5C28F5U } }, /* 9.9999999999999999995E+16 */
   { 59, { 0xDE0B6B3AU, 0x763FFFFFU, 0x33333333U, 0x33333333U } }, /* 9.9999999999999999995E+17 */
   { 63, { 0x8AC72304U, 0x89E7FFFFU, 0x80000000U, 0x00000000U } }, /* 9.9999999999999999995E+18 */

   /* d = 20 */
   { -4, { 0xCCCCCCCCU, 0xCCCCCCCCU, 0xB9E918C2U, 0xBE317D4EU } }, /* 9.99999999999999999995E-2 */
   { -1, { 0xFFFFFFFFU, 0xFFFFFFFFU, 0xE8635EF3U, 0x6DBDDCA2U } }, /* 9.99999999999999999995E-1 */
   {  3, { 0x9FFFFFFFU, 0xFFFFFFFFU, 0xF13E1B58U, 0x2496A9E5U } }, /* 9.99999999999999999995E+0 */
   {  6, { 0xC7FFFFFFU, 0xFFFFFFFFU, 0xED8DA22EU, 0x2DBC545FU } }, /* 9.99999999999999999995E+1 */
   {  9, { 0xF9FFFFFFU, 0xFFFFFFFFU, 0xE8F10AB9U, 0xB92B6976U } }, /* 9.99999999999999999995E+2 */
   { 13, { 0x9C3FFFFFU, 0xFFFFFFFFU, 0xF196A6B4U, 0x13BB21EAU } }, /* 9.99999999999999999995E+3 */
   { 16, { 0xC34FFFFFU, 0xFFFFFFFFU, 0xEDFC5061U, 0x18A9EA64U } }, /* 9.99999999999999999995E+4 */
   { 19, { 0xF423FFFFU, 0xFFFFFFFFU, 0xE97B6479U, 0x5ED464FEU } }, /* 9.99999999999999999995E+5 */
   { 23, { 0x98967FFFU, 0xFFFFFFFFU, 0xF1ED1ECBU, 0xDB44BF1EU } }, /* 9.99999999999999999995E+6 */
   { 26, { 0xBEBC1FFFU, 0xFFFFFFFFU, 0xEE68667EU, 0xD215EEE6U } }, /* 9.99999999999999999995E+7 */
   { 29, { 0xEE6B27FFU, 0xFFFFFFFFU, 0xEA02801EU, 0x869B6AA0U } }, /* 9.99999999999999999995E+8 */
   { 33, { 0x9502F8FFU, 0xFFFFFFFFU, 0xF2419013U, 0x142122A4U } }, /* 9.99999999999999999995E+9 */
   { 36, { 0xBA43B73FU, 0xFFFFFFFFU, 0xEED1F417U, 0xD9296B4DU } }, /* 9.99999999999999999995E+10 */
   { 39, { 0xE8D4A50FU, 0xFFFFFFFFU, 0xEA86711DU, 0xCF73C620U } }, /* 9.99999999999999999995E+11 */
   { 43, { 0x9184E729U, 0xFFFFFFFFU, 0xF29406B2U, 0xA1A85BD4U } }, /* 9.99999999999999999995E+12 */
   { 46, { 0xB5E620F4U, 0x7FFFFFFFU, 0xEF39085FU, 0x4A1272C9U } }, /* 9.99999999999999999995E+13 */
   { 49, { 0xE35FA931U, 0x9FFFFFFFU, 0xEB074A77U, 0x1C970F7BU } }, /* 9.99999999999999999995E+14 */
   { 53, { 0x8E1BC9BFU, 0x03FFFFFFU, 0xF2E48E8AU, 0x71DE69ADU } }, /* 9.99999999999999999995E+15 */
   { 56, { 0xB1A2BC2EU, 0xC4FFFFFFU, 0xEF9DB22DU, 0x0E560418U } }, /* 9.99999999999999999995E+16 */
   { 59, { 0xDE0B6B3AU, 0x763FFFFFU, 0xEB851EB8U, 0x51EB851EU } }, /* 9.99999999999999999995E+17 */
   { 63, { 0x8AC72304U, 0x89E7FFFFU, 0xF3333333U, 0x33333333U } }, /* 9.99999999999999999995E+18 */
   { 66, { 0xAD78EBC5U, 0xAC61FFFFU, 0xF0000000U, 0x00000000U } }, /* 9.99999999999999999995E+19 */

   /* d = 21 */
   { -4, { 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCAE93ACBU, 0xCB56DE73U } }, /* 9.999999999999999999995E-2 */
   { -1, { 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFDA3897EU, 0xBE2C9610U } }, /* 9.999999999999999999995E-1 */
   {  3, { 0x9FFFFFFFU, 0xFFFFFFFFU, 0xFE8635EFU, 0x36DBDDCAU } }, /* 9.999999999999999999995E+0 */
   {  6, { 0xC7FFFFFFU, 0xFFFFFFFFU, 0xFE27C36BU, 0x0492D53CU } }, /* 9.999999999999999999995E+1 */
   {  9, { 0xF9FFFFFFU, 0xFFFFFFFFU, 0xFDB1B445U, 0xC5B78A8BU } }, /* 9.999999999999999999995E+2 */
   { 13, { 0x9C3FFFFFU, 0xFFFFFFFFU, 0xFE8F10ABU, 0x9B92B697U } }, /* 9.999999999999999999995E+3 */
   { 16, { 0xC34FFFFFU, 0xFFFFFFFFU, 0xFE32D4D6U, 0x8277643DU } }, /* 9.999999999999999999995E+4 */
   { 19, { 0xF423FFFFU, 0xFFFFFFFFU, 0xFDBF8A0CU, 0x23153D4CU } }, /* 9.999999999999999999995E+5 */
   { 23, { 0x98967FFFU, 0xFFFFFFFFU, 0xFE97B647U, 0x95ED464FU } }, /* 9.999999999999999999995E+6 */
   { 26, { 0xBEBC1FFFU, 0xFFFFFFFFU, 0xFE3DA3D9U, 0x7B6897E3U } }, /* 9.999999999999999999995E+7 */
   { 29, { 0xEE6B27FFU, 0xFFFFFFFFU, 0xFDCD0CCFU, 0xDA42BDDCU } }, /* 9.999999999999999999995E+8 */
   { 33, { 0x9502F8FFU, 0xFFFFFFFFU, 0xFEA02801U, 0xE869B6AAU } }, /* 9.999999999999999999995E+9 */
   { 36, { 0xBA43B73FU, 0xFFFFFFFFU, 0xFE483202U, 0x62842454U } }, /* 9.999999999999999999995E+10 */
   { 39, { 0xE8D4A50FU, 0xFFFFFFFFU, 0xFDDA3E82U, 0xFB252D69U } }, /* 9.999999999999999999995E+11 */
   { 43, { 0x9184E729U, 0xFFFFFFFFU, 0xFEA86711U, 0xDCF73C62U } }, /* 9.999999999999999999995E+12 */
   { 46, { 0xB5E620F4U, 0x7FFFFFFFU, 0xFE5280D6U, 0x54350B7AU } }, /* 9.999999999999999999995E+13 */
   { 49, { 0xE35FA931U, 0x9FFFFFFFU, 0xFDE7210BU, 0xE9424E59U } }, /* 9.999999999999999999995E+14 */
   { 53, { 0x8E1BC9BFU, 0x03FFFFFFU, 0xFEB074A7U, 0x71C970F7U } }, /* 9.999999999999999999995E+15 */
   { 56, { 0xB1A2BC2EU, 0xC4FFFFFFU, 0xFE5C91D1U, 0x4E3BCD35U } }, /* 9.999999999999999999995E+16 */
   { 59, { 0xDE0B6B3AU, 0x763FFFFFU, 0xFDF3B645U, 0xA1CAC083U } }, /* 9.999999999999999999995E+17 */
   { 63, { 0x8AC72304U, 0x89E7FFFFU, 0xFEB851EBU, 0x851EB851U } }, /* 9.999999999999999999995E+18 */
   { 66, { 0xAD78EBC5U, 0xAC61FFFFU, 0xFE666666U, 0x66666666U } }, /* 9.999999999999999999995E+19 */
   { 69, { 0xD8D726B7U, 0x177A7FFFU, 0xFE000000U, 0x00000000U } }, /* 9.999999999999999999995E+20 */

   /* d = 22 */
   { -4, { 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCC9C7166U, 0x4CA7682AU } }, /* 9.9999999999999999999995E-2 */
   { -1, { 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFC38DBFU, 0xDFD14234U } }, /* 9.9999999999999999999995E-1 */
   {  3, { 0x9FFFFFFFU, 0xFFFFFFFFU, 0xFFDA3897U, 0xEBE2C961U } }, /* 9.9999999999999999999995E+0 */
   {  6, { 0xC7FFFFFFU, 0xFFFFFFFFU, 0xFFD0C6BDU, 0xE6DB7BB9U } }, /* 9.9999999999999999999995E+1 */
   {  9, { 0xF9FFFFFFU, 0xFFFFFFFFU, 0xFFC4F86DU, 0x60925AA7U } }, /* 9.9999999999999999999995E+2 */
   { 13, { 0x9C3FFFFFU, 0xFFFFFFFFU, 0xFFDB1B44U, 0x5C5B78A8U } }, /* 9.9999999999999999999995E+3 */
   { 16, { 0xC34FFFFFU, 0xFFFFFFFFU, 0xFFD1E215U, 0x737256D2U } }, /* 9.9999999999999999999995E+4 */
   { 19, { 0xF423FFFFU, 0xFFFFFFFFU, 0xFFC65A9AU, 0xD04EEC87U } }, /* 9.9999999999999999999995E+5 */
   { 23, { 0x98967FFFU, 0xFFFFFFFFU, 0xFFDBF8A0U, 0xC23153D4U } }, /* 9.9999999999999999999995E+6 */
   { 26, { 0xBEBC1FFFU, 0xFFFFFFFFU, 0xFFD2F6C8U, 0xF2BDA8C9U } }, /* 9.9999999999999999999995E+7 */
   { 29, { 0xEE6B27FFU, 0xFFFFFFFFU, 0xFFC7B47BU, 0x2F6D12FCU } }, /* 9.9999999999999999999995E+8 */
   { 33, { 0x9502F8FFU, 0xFFFFFFFFU, 0xFFDCD0CCU, 0xFDA42BDDU } }, /* 9.9999999999999999999995E+9 */
   { 36, { 0xBA43B73FU, 0xFFFFFFFFU, 0xFFD40500U, 0x3D0D36D5U } }, /* 9.9999999999999999999995E+10 */
   { 39, { 0xE8D4A50FU, 0xFFFFFFFFU, 0xFFC90640U, 0x4C50848AU } }, /* 9.9999999999999999999995E+11 */
   { 43, { 0x9184E729U, 0xFFFFFFFFU, 0xFFDDA3E8U, 0x2FB252D6U } }, /* 9.9999999999999999999995E+12 */
   { 46, { 0xB5E620F4U, 0x7FFFFFFFU, 0xFFD50CE2U, 0x3B9EE78CU } }, /* 9.9999999999999999999995E+13 */
   { 49, { 0xE35FA931U, 0x9FFFFFFFU, 0xFFCA501AU, 0xCA86A16FU } }, /* 9.9999999999999999999995E+14 */
   { 53, { 0x8E1BC9BFU, 0x03FFFFFFU, 0xFFDE7210U, 0xBE9424E5U } }, /* 9.9999999999999999999995E+15 */
   { 56, { 0xB1A2BC2EU, 0xC4FFFFFFU, 0xFFD60E94U, 0xEE392E1EU } }, /* 9.9999999999999999999995E+16 */
   { 59, { 0xDE0B6B3AU, 0x763FFFFFU, 0xFFCB923AU, 0x29C779A6U } }, /* 9.9999999999999999999995E+17 */
   { 63, { 0x8AC72304U, 0x89E7FFFFU, 0xFFDF3B64U, 0x5A1CAC08U } }, /* 9.9999999999999999999995E+18 */
   { 66, { 0xAD78EBC5U, 0xAC61FFFFU, 0xFFD70A3DU, 0x70A3D70AU } }, /* 9.9999999999999999999995E+19 */
   { 69, { 0xD8D726B7U, 0x177A7FFFU, 0xFFCCCCCCU, 0xCCCCCCCCU } }, /* 9.9999999999999999999995E+20 */
   { 73, { 0x87867832U, 0x6EAC8FFFU, 0xFFE00000U, 0x00000000U } }, /* 9.9999999999999999999995E+21 */

   /* d = 23 */
   { -4, { 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCCC7F6DCU, 0x2662A922U } }, /* 9.99999999999999999999995E-2 */
   { -1, { 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFF9F493U, 0x2FFB536BU } }, /* 9.99999999999999999999995E-1 */
   {  3, { 0x9FFFFFFFU, 0xFFFFFFFFU, 0xFFFC38DBU, 0xFDFD1423U } }, /* 9.99999999999999999999995E+0 */
   {  6, { 0xC7FFFFFFU, 0xFFFFFFFFU, 0xFFFB4712U, 0xFD7C592CU } }, /* 9.99999999999999999999995E+1 */
   {  9, { 0xF9FFFFFFU, 0xFFFFFFFFU, 0xFFFA18D7U, 0xBCDB6F77U } }, /* 9.99999999999999999999995E+2 */
   { 13, { 0x9C3FFFFFU, 0xFFFFFFFFU, 0xFFFC4F86U, 0xD60925AAU } }, /* 9.99999999999999999999995E+3 */
   { 16, { 0xC34FFFFFU, 0xFFFFFFFFU, 0xFFFB6368U, 0x8B8B6F15U } }, /* 9.99999999999999999999995E+4 */
   { 19, { 0xF423FFFFU, 0xFFFFFFFFU, 0xFFFA3C42U, 0xAE6E4ADAU } }, /* 9.99999999999999999999995E+5 */
   { 23, { 0x98967FFFU, 0xFFFFFFFFU, 0xFFFC65A9U, 0xAD04EEC8U } }, /* 9.99999999999999999999995E+6 */
   { 26, { 0xBEBC1FFFU, 0xFFFFFFFFU, 0xFFFB7F14U, 0x18462A7AU } }, /* 9.99999999999999999999995E+7 */
   { 29, { 0xEE6B27FFU, 0xFFFFFFFFU, 0xFFFA5ED9U, 0x1E57B519U } }, /* 9.99999999999999999999995E+8 */
   { 33, { 0x9502F8FFU, 0xFFFFFFFFU, 0xFFFC7B47U, 0xB2F6D12FU } }, /* 9.99999999999999999999995E+9 */
   { 36, { 0xBA43B73FU, 0xFFFFFFFFU, 0xFFFB9A19U, 0x9FB4857BU } }, /* 9.99999999999999999999995E+10 */
   { 39, { 0xE8D4A50FU, 0xFFFFFFFFU, 0xFFFA80A0U, 0x07A1A6DAU } }, /* 9.99999999999999999999995E+11 */
   { 43, { 0x9184E729U, 0xFFFFFFFFU, 0xFFFC9064U, 0x04C50848U } }, /* 9.99999999999999999999995E+12 */
   { 46, { 0xB5E620F4U, 0x7FFFFFFFU, 0xFFFBB47DU, 0x05F64A5AU } }, /* 9.99999999999999999999995E+13 */
   { 49, { 0xE35FA931U, 0x9FFFFFFFU, 0xFFFAA19CU, 0x4773DCF1U } }, /* 9.99999999999999999999995E+14 */
   { 53, { 0x8E1BC9BFU, 0x03FFFFFFU, 0xFFFCA501U, 0xACA86A16U } }, /* 9.99999999999999999999995E+15 */
   { 56, { 0xB1A2BC2EU, 0xC4FFFFFFU, 0xFFFBCE42U, 0x17D2849CU } }, /* 9.99999999999999999999995E+16 */
   { 59, { 0xDE0B6B3AU, 0x763FFFFFU, 0xFFFAC1D2U, 0x9DC725C3U } }, /* 9.99999999999999999999995E+17 */
   { 63, { 0x8AC72304U, 0x89E7FFFFU, 0xFFFCB923U, 0xA29C779AU } }, /* 9.99999999999999999999995E+18 */
   { 66, { 0xAD78EBC5U, 0xAC61FFFFU, 0xFFFBE76CU, 0x8B439581U } }, /* 9.99999999999999999999995E+19 */
   { 69, { 0xD8D726B7U, 0x177A7FFFU, 0xFFFAE147U, 0xAE147AE1U } }, /* 9.99999999999999999999995E+20 */
   { 73, { 0x87867832U, 0x6EAC8FFFU, 0xFFFCCCCCU, 0xCCCCCCCCU } }, /* 9.99999999999999999999995E+21 */
   { 76, { 0xA968163FU, 0x0A57B3FFU, 0xFFFC0000U, 0x00000000U } }, /* 9.99999999999999999999995E+22 */

   /* d = 24 */
   { -4, { 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCCCC5101U, 0x88F562D5U } }, /* 9.999999999999999999999995E-2 */
   { -1, { 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFF6541U, 0xEB32BB8AU } }, /* 9.999999999999999999999995E-1 */
   {  3, { 0x9FFFFFFFU, 0xFFFFFFFFU, 0xFFFF9F49U, 0x32FFB536U } }, /* 9.999999999999999999999995E+0 */
   {  6, { 0xC7FFFFFFU, 0xFFFFFFFFU, 0xFFFF871BU, 0x7FBFA284U } }, /* 9.999999999999999999999995E+1 */
   {  9, { 0xF9FFFFFFU, 0xFFFFFFFFU, 0xFFFF68E2U, 0x5FAF8B25U } }, /* 9.999999999999999999999995E+2 */
   { 13, { 0x9C3FFFFFU, 0xFFFFFFFFU, 0xFFFFA18DU, 0x7BCDB6F7U } }, /* 9.999999999999999999999995E+3 */
   { 16, { 0xC34FFFFFU, 0xFFFFFFFFU, 0xFFFF89F0U, 0xDAC124B5U } }, /* 9.999999999999999999999995E+4 */
   { 19, { 0xF423FFFFU, 0xFFFFFFFFU, 0xFFFF6C6DU, 0x11716DE2U } }, /* 9.999999999999999999999995E+5 */
   { 23, { 0x98967FFFU, 0xFFFFFFFFU, 0xFFFFA3C4U, 0x2AE6E4ADU } }, /* 9.999999999999999999999995E+6 */
   { 26, { 0xBEBC1FFFU, 0xFFFFFFFFU, 0xFFFF8CB5U, 0x35A09DD9U } }, /* 9.999999999999999999999995E+7 */
   { 29, { 0xEE6B27FFU, 0xFFFFFFFFU, 0xFFFF6FE2U, 0x8308C54FU } }, /* 9.999999999999999999999995E+8 */
   { 33, { 0x9502F8FFU, 0xFFFFFFFFU, 0xFFFFA5EDU, 0x91E57B51U } }, /* 9.999999999999999999999995E+9 */
   { 36, { 0xBA43B73FU, 0xFFFFFFFFU, 0xFFFF8F68U, 0xF65EDA25U } }, /* 9.999999999999999999999995E+10 */
   { 39, { 0xE8D4A50FU, 0xFFFFFFFFU, 0xFFFF7343U, 0x33F690AFU } }, /* 9.999999999999999999999995E+11 */
   { 43, { 0x9184E729U, 0xFFFFFFFFU, 0xFFFFA80AU, 0x007A1A6DU } }, /* 9.999999999999999999999995E+12 */
   { 46, { 0xB5E620F4U, 0x7FFFFFFFU, 0xFFFF920CU, 0x8098A109U } }, /* 9.999999999999999999999995E+13 */
   { 49, { 0xE35FA931U, 0x9FFFFFFFU, 0xFFFF768FU, 0xA0BEC94BU } }, /* 9.999999999999999999999995E+14 */
   { 53, { 0x8E1BC9BFU, 0x03FFFFFFU, 0xFFFFAA19U, 0xC4773DCFU } }, /* 9.999999999999999999999995E+15 */
   { 56, { 0xB1A2BC2EU, 0xC4FFFFFFU, 0xFFFF94A0U, 0x35950D42U } }, /* 9.999999999999999999999995E+16 */
   { 59, { 0xDE0B6B3AU, 0x763FFFFFU, 0xFFFF79C8U, 0x42FA5093U } }, /* 9.999999999999999999999995E+17 */
   { 63, { 0x8AC72304U, 0x89E7FFFFU, 0xFFFFAC1DU, 0x29DC725CU } }, /* 9.999999999999999999999995E+18 */
   { 66, { 0xAD78EBC5U, 0xAC61FFFFU, 0xFFFF9724U, 0x74538EF3U } }, /* 9.999999999999999999999995E+19 */
   { 69, { 0xD8D726B7U, 0x177A7FFFU, 0xFFFF7CEDU, 0x916872B0U } }, /* 9.999999999999999999999995E+20 */
   { 73, { 0x87867832U, 0x6EAC8FFFU, 0xFFFFAE14U, 0x7AE147AEU } }, /* 9.999999999999999999999995E+21 */
   { 76, { 0xA968163FU, 0x0A57B3FFU, 0xFFFF9999U, 0x99999999U } }, /* 9.999999999999999999999995E+22 */
   { 79, { 0xD3C21BCEU, 0xCCEDA0FFU, 0xFFFF8000U, 0x00000000U } }, /* 9.999999999999999999999995E+23 */

   /* d = 25 */
   { -4, { 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCCCCC06BU, 0xAC6A7567U } }, /* 9.9999999999999999999999995E-2 */
   { -1, { 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFF086U, 0x978512C1U } }, /* 9.9999999999999999999999995E-1 */
   {  3, { 0x9FFFFFFFU, 0xFFFFFFFFU, 0xFFFFF654U, 0x1EB32BB8U } }, /* 9.9999999999999999999999995E+0 */
   {  6, { 0xC7FFFFFFU, 0xFFFFFFFFU, 0xFFFFF3E9U, 0x265FF6A6U } }, /* 9.9999999999999999999999995E+1 */
   {  9, { 0xF9FFFFFFU, 0xFFFFFFFFU, 0xFFFFF0E3U, 0x6FF7F450U } }, /* 9.9999999999999999999999995E+2 */
   { 13, { 0x9C3FFFFFU, 0xFFFFFFFFU, 0xFFFFF68EU, 0x25FAF8B2U } }, /* 9.9999999999999999999999995E+3 */
   { 16, { 0xC34FFFFFU, 0xFFFFFFFFU, 0xFFFFF431U, 0xAF79B6DEU } }, /* 9.9999999999999999999999995E+4 */
   { 19, { 0xF423FFFFU, 0xFFFFFFFFU, 0xFFFFF13EU, 0x1B582496U } }, /* 9.9999999999999999999999995E+5 */
   { 23, { 0x98967FFFU, 0xFFFFFFFFU, 0xFFFFF6C6U, 0xD11716DEU } }, /* 9.9999999999999999999999995E+6 */
   { 26, { 0xBEBC1FFFU, 0xFFFFFFFFU, 0xFFFFF478U, 0x855CDC95U } }, /* 9.9999999999999999999999995E+7 */
   { 29, { 0xEE6B27FFU, 0xFFFFFFFFU, 0xFFFFF196U, 0xA6B413BBU } }, /* 9.9999999999999999999999995E+8 */
   { 33, { 0x9502F8FFU, 0xFFFFFFFFU, 0xFFFFF6FEU, 0x28308C54U } }, /* 9.9999999999999999999999995E+9 */
   { 36, { 0xBA43B73FU, 0xFFFFFFFFU, 0xFFFFF4BDU, 0xB23CAF6AU } }, /* 9.9999999999999999999999995E+10 */
   { 39, { 0xE8D4A50FU, 0xFFFFFFFFU, 0xFFFFF1EDU, 0x1ECBDB44U } }, /* 9.9999999999999999999999995E+11 */
   { 43, { 0x9184E729U, 0xFFFFFFFFU, 0xFFFFF734U, 0x333F690AU } }, /* 9.9999999999999999999999995E+12 */
   { 46, { 0xB5E620F4U, 0x7FFFFFFFU, 0xFFFFF501U, 0x400F434DU } }, /* 9.9999999999999999999999995E+13 */
   { 49, { 0xE35FA931U, 0x9FFFFFFFU, 0xFFFFF241U, 0x90131421U } }, /* 9.9999999999999999999999995E+14 */
   { 53, { 0x8E1BC9BFU, 0x03FFFFFFU, 0xFFFFF768U, 0xFA0BEC94U } }, /* 9.9999999999999999999999995E+15 */
   { 56, { 0xB1A2BC2EU, 0xC4FFFFFFU, 0xFFFFF543U, 0x388EE7B9U } }, /* 9.9999999999999999999999995E+16 */
   { 59, { 0xDE0B6B3AU, 0x763FFFFFU, 0xFFFFF294U, 0x06B2A1A8U } }, /* 9.9999999999999999999999995E+17 */
   { 63, { 0x8AC72304U, 0x89E7FFFFU, 0xFFFFF79CU, 0x842FA509U } }, /* 9.9999999999999999999999995E+18 */
   { 66, { 0xAD78EBC5U, 0xAC61FFFFU, 0xFFFFF583U, 0xA53B8E4BU } }, /* 9.9999999999999999999999995E+19 */
   { 69, { 0xD8D726B7U, 0x177A7FFFU, 0xFFFFF2E4U, 0x8E8A71DEU } }, /* 9.9999999999999999999999995E+20 */
   { 73, { 0x87867832U, 0x6EAC8FFFU, 0xFFFFF7CEU, 0xD916872BU } }, /* 9.9999999999999999999999995E+21 */
   { 76, { 0xA968163FU, 0x0A57B3FFU, 0xFFFFF5C2U, 0x8F5C28F5U } }, /* 9.9999999999999999999999995E+22 */
   { 79, { 0xD3C21BCEU, 0xCCEDA0FFU, 0xFFFFF333U, 0x33333333U } }, /* 9.9999999999999999999999995E+23 */
   { 83, { 0x84595161U, 0x4014849FU, 0xFFFFF800U, 0x00000000U } }, /* 9.9999999999999999999999995E+24 */

   /* d = 26 */
   { -4, { 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCCCCCB8FU, 0xE3295DA9U } }, /* 9.99999999999999999999999995E-2 */
   { -1, { 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFFE73U, 0xDBF3B513U } }, /* 9.99999999999999999999999995E-1 */
   {  3, { 0x9FFFFFFFU, 0xFFFFFFFFU, 0xFFFFFF08U, 0x6978512CU } }, /* 9.99999999999999999999999995E+0 */
   {  6, { 0xC7FFFFFFU, 0xFFFFFFFFU, 0xFFFFFECAU, 0x83D66577U } }, /* 9.99999999999999999999999995E+1 */
   {  9, { 0xF9FFFFFFU, 0xFFFFFFFFU, 0xFFFFFE7DU, 0x24CBFED4U } }, /* 9.99999999999999999999999995E+2 */
   { 13, { 0x9C3FFFFFU, 0xFFFFFFFFU, 0xFFFFFF0EU, 0x36FF7F45U } }, /* 9.99999999999999999999999995E+3 */
   { 16, { 0xC34FFFFFU, 0xFFFFFFFFU, 0xFFFFFED1U, 0xC4BF5F16U } }, /* 9.99999999999999999999999995E+4 */
   { 19, { 0xF423FFFFU, 0xFFFFFFFFU, 0xFFFFFE86U, 0x35EF36DBU } }, /* 9.99999999999999999999999995E+5 */
   { 23, { 0x98967FFFU, 0xFFFFFFFFU, 0xFFFFFF13U, 0xE1B58249U } }, /* 9.99999999999999999999999995E+6 */
   { 26, { 0xBEBC1FFFU, 0xFFFFFFFFU, 0xFFFFFED8U, 0xDA22E2DBU } }, /* 9.99999999999999999999999995E+7 */
   { 29, { 0xEE6B27FFU, 0xFFFFFFFFU, 0xFFFFFE8FU, 0x10AB9B92U } }, /* 9.99999999999999999999999995E+8 */
   { 33, { 0x9502F8FFU, 0xFFFFFFFFU, 0xFFFFFF19U, 0x6A6B413BU } }, /* 9.99999999999999999999999995E+9 */
   { 36, { 0xBA43B73FU, 0xFFFFFFFFU, 0xFFFFFEDFU, 0xC506118AU } }, /* 9.99999999999999999999999995E+10 */
   { 39, { 0xE8D4A50FU, 0xFFFFFFFFU, 0xFFFFFE97U, 0xB64795EDU } }, /* 9.99999999999999999999999995E+11 */
   { 43, { 0x9184E729U, 0xFFFFFFFFU, 0xFFFFFF1EU, 0xD1ECBDB4U } }, /* 9.99999999999999999999999995E+12 */
   { 46, { 0xB5E620F4U, 0x7FFFFFFFU, 0xFFFFFEE6U, 0x8667ED21U } }, /* 9.99999999999999999999999995E+13 */
   { 49, { 0xE35FA931U, 0x9FFFFFFFU, 0xFFFFFEA0U, 0x2801E869U } }, /* 9.99999999999999999999999995E+14 */
   { 53, { 0x8E1BC9BFU, 0x03FFFFFFU, 0xFFFFFF24U, 0x19013142U } }, /* 9.99999999999999999999999995E+15 */
   { 56, { 0xB1A2BC2EU, 0xC4FFFFFFU, 0xFFFFFEEDU, 0x1F417D92U } }, /* 9.99999999999999999999999995E+16 */
   { 59, { 0xDE0B6B3AU, 0x763FFFFFU, 0xFFFFFEA8U, 0x6711DCF7U } }, /* 9.99999999999999999999999995E+17 */
   { 63, { 0x8AC72304U, 0x89E7FFFFU, 0xFFFFFF29U, 0x406B2A1AU } }, /* 9.99999999999999999999999995E+18 */
   { 66, { 0xAD78EBC5U, 0xAC61FFFFU, 0xFFFFFEF3U, 0x9085F4A1U } }, /* 9.99999999999999999999999995E+19 */
   { 69, { 0xD8D726B7U, 0x177A7FFFU, 0xFFFFFEB0U, 0x74A771C9U } }, /* 9.99999999999999999999999995E+20 */
   { 73, { 0x87867832U, 0x6EAC8FFFU, 0xFFFFFF2EU, 0x48E8A71DU } }, /* 9.99999999999999999999999995E+21 */
   { 76, { 0xA968163FU, 0x0A57B3FFU, 0xFFFFFEF9U, 0xDB22D0E5U } }, /* 9.99999999999999999999999995E+22 */
   { 79, { 0xD3C21BCEU, 0xCCEDA0FFU, 0xFFFFFEB8U, 0x51EB851EU } }, /* 9.99999999999999999999999995E+23 */
   { 83, { 0x84595161U, 0x4014849FU, 0xFFFFFF33U, 0x33333333U } }, /* 9.99999999999999999999999995E+24 */
   { 86, { 0xA56FA5B9U, 0x9019A5C7U, 0xFFFFFF00U, 0x00000000U } }, /* 9.99999999999999999999999995E+25 */

   /* d = 27 */
   { -4, { 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCCCCCCADU, 0x1BD60E7CU } }, /* 9.999999999999999999999999995E-2 */
   { -1, { 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFFFD8U, 0x62CB921BU } }, /* 9.999999999999999999999999995E-1 */
   {  3, { 0x9FFFFFFFU, 0xFFFFFFFFU, 0xFFFFFFE7U, 0x3DBF3B51U } }, /* 9.999999999999999999999999995E+0 */
   {  6, { 0xC7FFFFFFU, 0xFFFFFFFFU, 0xFFFFFFE1U, 0x0D2F0A25U } }, /* 9.999999999999999999999999995E+1 */
   {  9, { 0xF9FFFFFFU, 0xFFFFFFFFU, 0xFFFFFFD9U, 0x507ACCAEU } }, /* 9.999999999999999999999999995E+2 */
   { 13, { 0x9C3FFFFFU, 0xFFFFFFFFU, 0xFFFFFFE7U, 0xD24CBFEDU } }, /* 9.999999999999999999999999995E+3 */
   { 16, { 0xC34FFFFFU, 0xFFFFFFFFU, 0xFFFFFFE1U, 0xC6DFEFE8U } }, /* 9.999999999999999999999999995E+4 */
   { 19, { 0xF423FFFFU, 0xFFFFFFFFU, 0xFFFFFFDAU, 0x3897EBE2U } }, /* 9.999999999999999999999999995E+5 */
   { 23, { 0x98967FFFU, 0xFFFFFFFFU, 0xFFFFFFE8U, 0x635EF36DU } }, /* 9.999999999999999999999999995E+6 */
   { 26, { 0xBEBC1FFFU, 0xFFFFFFFFU, 0xFFFFFFE2U, 0x7C36B049U } }, /* 9.999999999999999999999999995E+7 */
   { 29, { 0xEE6B27FFU, 0xFFFFFFFFU, 0xFFFFFFDBU, 0x1B445C5BU } }, /* 9.999999999999999999999999995E+8 */
   { 33, { 0x9502F8FFU, 0xFFFFFFFFU, 0xFFFFFFE8U, 0xF10AB9B9U } }, /* 9.999999999999999999999999995E+9 */
   { 36, { 0xBA43B73FU, 0xFFFFFFFFU, 0xFFFFFFE3U, 0x2D4D6827U } }, /* 9.999999999999999999999999995E+10 */
   { 39, { 0xE8D4A50FU, 0xFFFFFFFFU, 0xFFFFFFDBU, 0xF8A0C231U } }, /* 9.999999999999999999999999995E+11 */
   { 43, { 0x9184E729U, 0xFFFFFFFFU, 0xFFFFFFE9U, 0x7B64795EU } }, /* 9.999999999999999999999999995E+12 */
   { 46, { 0xB5E620F4U, 0x7FFFFFFFU, 0xFFFFFFE3U, 0xDA3D97B6U } }, /* 9.999999999999999999999999995E+13 */
   { 49, { 0xE35FA931U, 0x9FFFFFFFU, 0xFFFFFFDCU, 0xD0CCFDA4U } }, /* 9.999999999999999999999999995E+14 */
   { 53, { 0x8E1BC9BFU, 0x03FFFFFFU, 0xFFFFFFEAU, 0x02801E86U } }, /* 9.999999999999999999999999995E+15 */
   { 56, { 0xB1A2BC2EU, 0xC4FFFFFFU, 0xFFFFFFE4U, 0x83202628U } }, /* 9.999999999999999999999999995E+16 */
   { 59, { 0xDE0B6B3AU, 0x763FFFFFU, 0xFFFFFFDDU, 0xA3E82FB2U } }, /* 9.999999999999999999999999995E+17 */
   { 63, { 0x8AC72304U, 0x89E7FFFFU, 0xFFFFFFEAU, 0x86711DCFU } }, /* 9.999999999999999999999999995E+18 */
   { 66, { 0xAD78EBC5U, 0xAC61FFFFU, 0xFFFFFFE5U, 0x280D6543U } }, /* 9.999999999999999999999999995E+19 */
   { 69, { 0xD8D726B7U, 0x177A7FFFU, 0xFFFFFFDEU, 0x7210BE94U } }, /* 9.999999999999999999999999995E+20 */
   { 73, { 0x87867832U, 0x6EAC8FFFU, 0xFFFFFFEBU, 0x074A771CU } }, /* 9.999999999999999999999999995E+21 */
   { 76, { 0xA968163FU, 0x0A57B3FFU, 0xFFFFFFE5U, 0xC91D14E3U } }, /* 9.999999999999999999999999995E+22 */
   { 79, { 0xD3C21BCEU, 0xCCEDA0FFU, 0xFFFFFFDFU, 0x3B645A1CU } }, /* 9.999999999999999999999999995E+23 */
   { 83, { 0x84595161U, 0x4014849FU, 0xFFFFFFEBU, 0x851EB851U } }, /* 9.999999999999999999999999995E+24 */
   { 86, { 0xA56FA5B9U, 0x9019A5C7U, 0xFFFFFFE6U, 0x66666666U } }, /* 9.999999999999999999999999995E+25 */
   { 89, { 0xCECB8F27U, 0xF4200F39U, 0xFFFFFFE0U, 0x00000000U } }, /* 9.999999999999999999999999995E+26 */

   /* d = 28 */
   { -4, { 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCCCCCCC9U, 0xA180ECF7U } }, /* 9.9999999999999999999999999995E-2 */
   { -1, { 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFCU, 0x09E12835U } }, /* 9.9999999999999999999999999995E-1 */
   {  3, { 0x9FFFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFDU, 0x862CB921U } }, /* 9.9999999999999999999999999995E+0 */
   {  6, { 0xC7FFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFCU, 0xE7B7E76AU } }, /* 9.9999999999999999999999999995E+1 */
   {  9, { 0xF9FFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFCU, 0x21A5E144U } }, /* 9.9999999999999999999999999995E+2 */
   { 13, { 0x9C3FFFFFU, 0xFFFFFFFFU, 0xFFFFFFFDU, 0x9507ACCAU } }, /* 9.9999999999999999999999999995E+3 */
   { 16, { 0xC34FFFFFU, 0xFFFFFFFFU, 0xFFFFFFFCU, 0xFA4997FDU } }, /* 9.9999999999999999999999999995E+4 */
   { 19, { 0xF423FFFFU, 0xFFFFFFFFU, 0xFFFFFFFCU, 0x38DBFDFDU } }, /* 9.9999999999999999999999999995E+5 */
   { 23, { 0x98967FFFU, 0xFFFFFFFFU, 0xFFFFFFFDU, 0xA3897EBEU } }, /* 9.9999999999999999999999999995E+6 */
   { 26, { 0xBEBC1FFFU, 0xFFFFFFFFU, 0xFFFFFFFDU, 0x0C6BDE6DU } }, /* 9.9999999999999999999999999995E+7 */
   { 29, { 0xEE6B27FFU, 0xFFFFFFFFU, 0xFFFFFFFCU, 0x4F86D609U } }, /* 9.9999999999999999999999999995E+8 */
   { 33, { 0x9502F8FFU, 0xFFFFFFFFU, 0xFFFFFFFDU, 0xB1B445C5U } }, /* 9.9999999999999999999999999995E+9 */
   { 36, { 0xBA43B73FU, 0xFFFFFFFFU, 0xFFFFFFFDU, 0x1E215737U } }, /* 9.9999999999999999999999999995E+10 */
   { 39, { 0xE8D4A50FU, 0xFFFFFFFFU, 0xFFFFFFFCU, 0x65A9AD04U } }, /* 9.9999999999999999999999999995E+11 */
   { 43, { 0x9184E729U, 0xFFFFFFFFU, 0xFFFFFFFDU, 0xBF8A0C23U } }, /* 9.9999999999999999999999999995E+12 */
   { 46, { 0xB5E620F4U, 0x7FFFFFFFU, 0xFFFFFFFDU, 0x2F6C8F2BU } }, /* 9.9999999999999999999999999995E+13 */
   { 49, { 0xE35FA931U, 0x9FFFFFFFU, 0xFFFFFFFCU, 0x7B47B2F6U } }, /* 9.9999999999999999999999999995E+14 */
   { 53, { 0x8E1BC9BFU, 0x03FFFFFFU, 0xFFFFFFFDU, 0xCD0CCFDAU } }, /* 9.9999999999999999999999999995E+15 */
   { 56, { 0xB1A2BC2EU, 0xC4FFFFFFU, 0xFFFFFFFDU, 0x405003D0U } }, /* 9.9999999999999999999999999995E+16 */
   { 59, { 0xDE0B6B3AU, 0x763FFFFFU, 0xFFFFFFFCU, 0x906404C5U } }, /* 9.9999999999999999999999999995E+17 */
   { 63, { 0x8AC72304U, 0x89E7FFFFU, 0xFFFFFFFDU, 0xDA3E82FBU } }, /* 9.9999999999999999999999999995E+18 */
   { 66, { 0xAD78EBC5U, 0xAC61FFFFU, 0xFFFFFFFDU, 0x50CE23B9U } }, /* 9.9999999999999999999999999995E+19 */
   { 69, { 0xD8D726B7U, 0x177A7FFFU, 0xFFFFFFFCU, 0xA501ACA8U } }, /* 9.9999999999999999999999999995E+20 */
   { 73, { 0x87867832U, 0x6EAC8FFFU, 0xFFFFFFFDU, 0xE7210BE9U } }, /* 9.9999999999999999999999999995E+21 */
   { 76, { 0xA968163FU, 0x0A57B3FFU, 0xFFFFFFFDU, 0x60E94EE3U } }, /* 9.9999999999999999999999999995E+22 */
   { 79, { 0xD3C21BCEU, 0xCCEDA0FFU, 0xFFFFFFFCU, 0xB923A29CU } }, /* 9.9999999999999999999999999995E+23 */
   { 83, { 0x84595161U, 0x4014849FU, 0xFFFFFFFDU, 0xF3B645A1U } }, /* 9.9999999999999999999999999995E+24 */
   { 86, { 0xA56FA5B9U, 0x9019A5C7U, 0xFFFFFFFDU, 0x70A3D70AU } }, /* 9.9999999999999999999999999995E+25 */
   { 89, { 0xCECB8F27U, 0xF4200F39U, 0xFFFFFFFCU, 0xCCCCCCCCU } }, /* 9.9999999999999999999999999995E+26 */
   { 93, { 0x813F3978U, 0xF8940984U, 0x3FFFFFFEU, 0x00000000U } }, /* 9.9999999999999999999999999995E+27 */

   /* d = 29 */
   { -4, { 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCCCCCCCCU, 0x7BAB9CD1U } }, /* 9.99999999999999999999999999995E-2 */
   { -1, { 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0x9A968405U } }, /* 9.99999999999999999999999999995E-1 */
   {  3, { 0x9FFFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xC09E1283U } }, /* 9.99999999999999999999999999995E+0 */
   {  6, { 0xC7FFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xB0C59724U } }, /* 9.99999999999999999999999999995E+1 */
   {  9, { 0xF9FFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0x9CF6FCEDU } }, /* 9.99999999999999999999999999995E+2 */
   { 13, { 0x9C3FFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xC21A5E14U } }, /* 9.99999999999999999999999999995E+3 */
   { 16, { 0xC34FFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xB2A0F599U } }, /* 9.99999999999999999999999999995E+4 */
   { 19, { 0xF423FFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0x9F4932FFU } }, /* 9.99999999999999999999999999995E+5 */
   { 23, { 0x98967FFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xC38DBFDFU } }, /* 9.99999999999999999999999999995E+6 */
   { 26, { 0xBEBC1FFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xB4712FD7U } }, /* 9.99999999999999999999999999995E+7 */
   { 29, { 0xEE6B27FFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xA18D7BCDU } }, /* 9.99999999999999999999999999995E+8 */
   { 33, { 0x9502F8FFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xC4F86D60U } }, /* 9.99999999999999999999999999995E+9 */
   { 36, { 0xBA43B73FU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xB63688B8U } }, /* 9.99999999999999999999999999995E+10 */
   { 39, { 0xE8D4A50FU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xA3C42AE6U } }, /* 9.99999999999999999999999999995E+11 */
   { 43, { 0x9184E729U, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xC65A9AD0U } }, /* 9.99999999999999999999999999995E+12 */
   { 46, { 0xB5E620F4U, 0x7FFFFFFFU, 0xFFFFFFFFU, 0xB7F14184U } }, /* 9.99999999999999999999999999995E+13 */
   { 49, { 0xE35FA931U, 0x9FFFFFFFU, 0xFFFFFFFFU, 0xA5ED91E5U } }, /* 9.99999999999999999999999999995E+14 */
   { 53, { 0x8E1BC9BFU, 0x03FFFFFFU, 0xFFFFFFFFU, 0xC7B47B2FU } }, /* 9.99999999999999999999999999995E+15 */
   { 56, { 0xB1A2BC2EU, 0xC4FFFFFFU, 0xFFFFFFFFU, 0xB9A199FBU } }, /* 9.99999999999999999999999999995E+16 */
   { 59, { 0xDE0B6B3AU, 0x763FFFFFU, 0xFFFFFFFFU, 0xA80A007AU } }, /* 9.99999999999999999999999999995E+17 */
   { 63, { 0x8AC72304U, 0x89E7FFFFU, 0xFFFFFFFFU, 0xC906404CU } }, /* 9.99999999999999999999999999995E+18 */
   { 66, { 0xAD78EBC5U, 0xAC61FFFFU, 0xFFFFFFFFU, 0xBB47D05FU } }, /* 9.99999999999999999999999999995E+19 */
   { 69, { 0xD8D726B7U, 0x177A7FFFU, 0xFFFFFFFFU, 0xAA19C477U } }, /* 9.99999999999999999999999999995E+20 */
   { 73, { 0x87867832U, 0x6EAC8FFFU, 0xFFFFFFFFU, 0xCA501ACAU } }, /* 9.99999999999999999999999999995E+21 */
   { 76, { 0xA968163FU, 0x0A57B3FFU, 0xFFFFFFFFU, 0xBCE4217DU } }, /* 9.99999999999999999999999999995E+22 */
   { 79, { 0xD3C21BCEU, 0xCCEDA0FFU, 0xFFFFFFFFU, 0xAC1D29DCU } }, /* 9.99999999999999999999999999995E+23 */
   { 83, { 0x84595161U, 0x4014849FU, 0xFFFFFFFFU, 0xCB923A29U } }, /* 9.99999999999999999999999999995E+24 */
   { 86, { 0xA56FA5B9U, 0x9019A5C7U, 0xFFFFFFFFU, 0xBE76C8B4U } }, /* 9.99999999999999999999999999995E+25 */
   { 89, { 0xCECB8F27U, 0xF4200F39U, 0xFFFFFFFFU, 0xAE147AE1U } }, /* 9.99999999999999999999999999995E+26 */
   { 93, { 0x813F3978U, 0xF8940984U, 0x3FFFFFFFU, 0xCCCCCCCCU } }, /* 9.99999999999999999999999999995E+27 */
   { 96, { 0xA18F07D7U, 0x36B90BE5U, 0x4FFFFFFFU, 0xC0000000U } }, /* 9.99999999999999999999999999995E+28 */

   /* d = 30 */
   { -4, { 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCCCCCCCCU, 0xC4AFE19AU } }, /* 9.999999999999999999999999999995E-2 */
   { -1, { 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xF5DBDA00U } }, /* 9.999999999999999999999999999995E-1 */
   {  3, { 0x9FFFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xF9A96840U } }, /* 9.999999999999999999999999999995E+0 */
   {  6, { 0xC7FFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xF813C250U } }, /* 9.999999999999999999999999999995E+1 */
   {  9, { 0xF9FFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xF618B2E4U } }, /* 9.999999999999999999999999999995E+2 */
   { 13, { 0x9C3FFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xF9CF6FCEU } }, /* 9.999999999999999999999999999995E+3 */
   { 16, { 0xC34FFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xF8434BC2U } }, /* 9.999999999999999999999999999995E+4 */
   { 19, { 0xF423FFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xF6541EB3U } }, /* 9.999999999999999999999999999995E+5 */
   { 23, { 0x98967FFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xF9F4932FU } }, /* 9.999999999999999999999999999995E+6 */
   { 26, { 0xBEBC1FFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xF871B7FBU } }, /* 9.999999999999999999999999999995E+7 */
   { 29, { 0xEE6B27FFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xF68E25FAU } }, /* 9.999999999999999999999999999995E+8 */
   { 33, { 0x9502F8FFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFA18D7BCU } }, /* 9.999999999999999999999999999995E+9 */
   { 36, { 0xBA43B73FU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xF89F0DACU } }, /* 9.999999999999999999999999999995E+10 */
   { 39, { 0xE8D4A50FU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xF6C6D117U } }, /* 9.999999999999999999999999999995E+11 */
   { 43, { 0x9184E729U, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFA3C42AEU } }, /* 9.999999999999999999999999999995E+12 */
   { 46, { 0xB5E620F4U, 0x7FFFFFFFU, 0xFFFFFFFFU, 0xF8CB535AU } }, /* 9.999999999999999999999999999995E+13 */
   { 49, { 0xE35FA931U, 0x9FFFFFFFU, 0xFFFFFFFFU, 0xF6FE2830U } }, /* 9.999999999999999999999999999995E+14 */
   { 53, { 0x8E1BC9BFU, 0x03FFFFFFU, 0xFFFFFFFFU, 0xFA5ED91EU } }, /* 9.999999999999999999999999999995E+15 */
   { 56, { 0xB1A2BC2EU, 0xC4FFFFFFU, 0xFFFFFFFFU, 0xF8F68F65U } }, /* 9.999999999999999999999999999995E+16 */
   { 59, { 0xDE0B6B3AU, 0x763FFFFFU, 0xFFFFFFFFU, 0xF734333FU } }, /* 9.999999999999999999999999999995E+17 */
   { 63, { 0x8AC72304U, 0x89E7FFFFU, 0xFFFFFFFFU, 0xFA80A007U } }, /* 9.999999999999999999999999999995E+18 */
   { 66, { 0xAD78EBC5U, 0xAC61FFFFU, 0xFFFFFFFFU, 0xF920C809U } }, /* 9.999999999999999999999999999995E+19 */
   { 69, { 0xD8D726B7U, 0x177A7FFFU, 0xFFFFFFFFU, 0xF768FA0BU } }, /* 9.999999999999999999999999999995E+20 */
   { 73, { 0x87867832U, 0x6EAC8FFFU, 0xFFFFFFFFU, 0xFAA19C47U } }, /* 9.999999999999999999999999999995E+21 */
   { 76, { 0xA968163FU, 0x0A57B3FFU, 0xFFFFFFFFU, 0xF94A0359U } }, /* 9.999999999999999999999999999995E+22 */
   { 79, { 0xD3C21BCEU, 0xCCEDA0FFU, 0xFFFFFFFFU, 0xF79C842FU } }, /* 9.999999999999999999999999999995E+23 */
   { 83, { 0x84595161U, 0x4014849FU, 0xFFFFFFFFU, 0xFAC1D29DU } }, /* 9.999999999999999999999999999995E+24 */
   { 86, { 0xA56FA5B9U, 0x9019A5C7U, 0xFFFFFFFFU, 0xF9724745U } }, /* 9.999999999999999999999999999995E+25 */
   { 89, { 0xCECB8F27U, 0xF4200F39U, 0xFFFFFFFFU, 0xF7CED916U } }, /* 9.999999999999999999999999999995E+26 */
   { 93, { 0x813F3978U, 0xF8940984U, 0x3FFFFFFFU, 0xFAE147AEU } }, /* 9.999999999999999999999999999995E+27 */
   { 96, { 0xA18F07D7U, 0x36B90BE5U, 0x4FFFFFFFU, 0xF9999999U } }, /* 9.999999999999999999999999999995E+28 */
   { 99, { 0xC9F2C9CDU, 0x04674EDEU, 0xA3FFFFFFU, 0xF8000000U } }, /* 9.999999999999999999999999999995E+29 */

   /* d = 31 */
   {  -4, { 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCBFD1BAEU } }, /* 9.9999999999999999999999999999995E-2 */
   {  -1, { 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFEFC6299U } }, /* 9.9999999999999999999999999999995E-1 */
   {   3, { 0x9FFFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFF5DBDA0U } }, /* 9.9999999999999999999999999999995E+0 */
   {   6, { 0xC7FFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFF352D08U } }, /* 9.9999999999999999999999999999995E+1 */
   {   9, { 0xF9FFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFF02784AU } }, /* 9.9999999999999999999999999999995E+2 */
   {  13, { 0x9C3FFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFF618B2EU } }, /* 9.9999999999999999999999999999995E+3 */
   {  16, { 0xC34FFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFF39EDF9U } }, /* 9.9999999999999999999999999999995E+4 */
   {  19, { 0xF423FFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFF086978U } }, /* 9.9999999999999999999999999999995E+5 */
   {  23, { 0x98967FFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFF6541EBU } }, /* 9.9999999999999999999999999999995E+6 */
   {  26, { 0xBEBC1FFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFF3E9265U } }, /* 9.9999999999999999999999999999995E+7 */
   {  29, { 0xEE6B27FFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFF0E36FFU } }, /* 9.9999999999999999999999999999995E+8 */
   {  33, { 0x9502F8FFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFF68E25FU } }, /* 9.9999999999999999999999999999995E+9 */
   {  36, { 0xBA43B73FU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFF431AF7U } }, /* 9.9999999999999999999999999999995E+10 */
   {  39, { 0xE8D4A50FU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFF13E1B5U } }, /* 9.9999999999999999999999999999995E+11 */
   {  43, { 0x9184E729U, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFF6C6D11U } }, /* 9.9999999999999999999999999999995E+12 */
   {  46, { 0xB5E620F4U, 0x7FFFFFFFU, 0xFFFFFFFFU, 0xFF478855U } }, /* 9.9999999999999999999999999999995E+13 */
   {  49, { 0xE35FA931U, 0x9FFFFFFFU, 0xFFFFFFFFU, 0xFF196A6BU } }, /* 9.9999999999999999999999999999995E+14 */
   {  53, { 0x8E1BC9BFU, 0x03FFFFFFU, 0xFFFFFFFFU, 0xFF6FE283U } }, /* 9.9999999999999999999999999999995E+15 */
   {  56, { 0xB1A2BC2EU, 0xC4FFFFFFU, 0xFFFFFFFFU, 0xFF4BDB23U } }, /* 9.9999999999999999999999999999995E+16 */
   {  59, { 0xDE0B6B3AU, 0x763FFFFFU, 0xFFFFFFFFU, 0xFF1ED1ECU } }, /* 9.9999999999999999999999999999995E+17 */
   {  63, { 0x8AC72304U, 0x89E7FFFFU, 0xFFFFFFFFU, 0xFF734333U } }, /* 9.9999999999999999999999999999995E+18 */
   {  66, { 0xAD78EBC5U, 0xAC61FFFFU, 0xFFFFFFFFU, 0xFF501400U } }, /* 9.9999999999999999999999999999995E+19 */
   {  69, { 0xD8D726B7U, 0x177A7FFFU, 0xFFFFFFFFU, 0xFF241901U } }, /* 9.9999999999999999999999999999995E+20 */
   {  73, { 0x87867832U, 0x6EAC8FFFU, 0xFFFFFFFFU, 0xFF768FA0U } }, /* 9.9999999999999999999999999999995E+21 */
   {  76, { 0xA968163FU, 0x0A57B3FFU, 0xFFFFFFFFU, 0xFF543388U } }, /* 9.9999999999999999999999999999995E+22 */
   {  79, { 0xD3C21BCEU, 0xCCEDA0FFU, 0xFFFFFFFFU, 0xFF29406BU } }, /* 9.9999999999999999999999999999995E+23 */
   {  83, { 0x84595161U, 0x4014849FU, 0xFFFFFFFFU, 0xFF79C842U } }, /* 9.9999999999999999999999999999995E+24 */
   {  86, { 0xA56FA5B9U, 0x9019A5C7U, 0xFFFFFFFFU, 0xFF583A53U } }, /* 9.9999999999999999999999999999995E+25 */
   {  89, { 0xCECB8F27U, 0xF4200F39U, 0xFFFFFFFFU, 0xFF2E48E8U } }, /* 9.9999999999999999999999999999995E+26 */
   {  93, { 0x813F3978U, 0xF8940984U, 0x3FFFFFFFU, 0xFF7CED91U } }, /* 9.9999999999999999999999999999995E+27 */
   {  96, { 0xA18F07D7U, 0x36B90BE5U, 0x4FFFFFFFU, 0xFF5C28F5U } }, /* 9.9999999999999999999999999999995E+28 */
   {  99, { 0xC9F2C9CDU, 0x04674EDEU, 0xA3FFFFFFU, 0xFF333333U } }, /* 9.9999999999999999999999999999995E+29 */
   { 102, { 0xFC6F7C40U, 0x45812296U, 0x4CFFFFFFU, 0xFF000000U } }, /* 9.9999999999999999999999999999995E+30 */

   /* d = 32 */
   {  -4, { 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCCB807E3U } }, /* 9.99999999999999999999999999999995E-2 */
   {  -1, { 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFE609DCU } }, /* 9.99999999999999999999999999999995E-1 */
   {   3, { 0x9FFFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFEFC629U } }, /* 9.99999999999999999999999999999995E+0 */
   {   6, { 0xC7FFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFEBB7B4U } }, /* 9.99999999999999999999999999999995E+1 */
   {   9, { 0xF9FFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFE6A5A1U } }, /* 9.99999999999999999999999999999995E+2 */
   {  13, { 0x9C3FFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFF02784U } }, /* 9.99999999999999999999999999999995E+3 */
   {  16, { 0xC34FFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFEC3165U } }, /* 9.99999999999999999999999999999995E+4 */
   {  19, { 0xF423FFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFE73DBFU } }, /* 9.99999999999999999999999999999995E+5 */
   {  23, { 0x98967FFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFF08697U } }, /* 9.99999999999999999999999999999995E+6 */
   {  26, { 0xBEBC1FFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFECA83DU } }, /* 9.99999999999999999999999999999995E+7 */
   {  29, { 0xEE6B27FFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFE7D24CU } }, /* 9.99999999999999999999999999999995E+8 */
   {  33, { 0x9502F8FFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFF0E36FU } }, /* 9.99999999999999999999999999999995E+9 */
   {  36, { 0xBA43B73FU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFED1C4BU } }, /* 9.99999999999999999999999999999995E+10 */
   {  39, { 0xE8D4A50FU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFE8635EU } }, /* 9.99999999999999999999999999999995E+11 */
   {  43, { 0x9184E729U, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFF13E1BU } }, /* 9.99999999999999999999999999999995E+12 */
   {  46, { 0xB5E620F4U, 0x7FFFFFFFU, 0xFFFFFFFFU, 0xFFED8DA2U } }, /* 9.99999999999999999999999999999995E+13 */
   {  49, { 0xE35FA931U, 0x9FFFFFFFU, 0xFFFFFFFFU, 0xFFE8F10AU } }, /* 9.99999999999999999999999999999995E+14 */
   {  53, { 0x8E1BC9BFU, 0x03FFFFFFU, 0xFFFFFFFFU, 0xFFF196A6U } }, /* 9.99999999999999999999999999999995E+15 */
   {  56, { 0xB1A2BC2EU, 0xC4FFFFFFU, 0xFFFFFFFFU, 0xFFEDFC50U } }, /* 9.99999999999999999999999999999995E+16 */
   {  59, { 0xDE0B6B3AU, 0x763FFFFFU, 0xFFFFFFFFU, 0xFFE97B64U } }, /* 9.99999999999999999999999999999995E+17 */
   {  63, { 0x8AC72304U, 0x89E7FFFFU, 0xFFFFFFFFU, 0xFFF1ED1EU } }, /* 9.99999999999999999999999999999995E+18 */
   {  66, { 0xAD78EBC5U, 0xAC61FFFFU, 0xFFFFFFFFU, 0xFFEE6866U } }, /* 9.99999999999999999999999999999995E+19 */
   {  69, { 0xD8D726B7U, 0x177A7FFFU, 0xFFFFFFFFU, 0xFFEA0280U } }, /* 9.99999999999999999999999999999995E+20 */
   {  73, { 0x87867832U, 0x6EAC8FFFU, 0xFFFFFFFFU, 0xFFF24190U } }, /* 9.99999999999999999999999999999995E+21 */
   {  76, { 0xA968163FU, 0x0A57B3FFU, 0xFFFFFFFFU, 0xFFEED1F4U } }, /* 9.99999999999999999999999999999995E+22 */
   {  79, { 0xD3C21BCEU, 0xCCEDA0FFU, 0xFFFFFFFFU, 0xFFEA8671U } }, /* 9.99999999999999999999999999999995E+23 */
   {  83, { 0x84595161U, 0x4014849FU, 0xFFFFFFFFU, 0xFFF29406U } }, /* 9.99999999999999999999999999999995E+24 */
   {  86, { 0xA56FA5B9U, 0x9019A5C7U, 0xFFFFFFFFU, 0xFFEF3908U } }, /* 9.99999999999999999999999999999995E+25 */
   {  89, { 0xCECB8F27U, 0xF4200F39U, 0xFFFFFFFFU, 0xFFEB074AU } }, /* 9.99999999999999999999999999999995E+26 */
   {  93, { 0x813F3978U, 0xF8940984U, 0x3FFFFFFFU, 0xFFF2E48EU } }, /* 9.99999999999999999999999999999995E+27 */
   {  96, { 0xA18F07D7U, 0x36B90BE5U, 0x4FFFFFFFU, 0xFFEF9DB2U } }, /* 9.99999999999999999999999999999995E+28 */
   {  99, { 0xC9F2C9CDU, 0x04674EDEU, 0xA3FFFFFFU, 0xFFEB851EU } }, /* 9.99999999999999999999999999999995E+29 */
   { 102, { 0xFC6F7C40U, 0x45812296U, 0x4CFFFFFFU, 0xFFE66666U } }, /* 9.99999999999999999999999999999995E+30 */
   { 106, { 0x9DC5ADA8U, 0x2B70B59DU, 0xF01FFFFFU, 0xFFF00000U } }, /* 9.99999999999999999999999999999995E+31 */

   /* d = 33 */
   {  -4, { 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCCCAB91BU } }, /* 9.999999999999999999999999999999995E-2 */
   {  -1, { 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFD6762U } }, /* 9.999999999999999999999999999999995E-1 */
   {   3, { 0x9FFFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFE609DU } }, /* 9.999999999999999999999999999999995E+0 */
   {   6, { 0xC7FFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFDF8C5U } }, /* 9.999999999999999999999999999999995E+1 */
   {   9, { 0xF9FFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFD76F6U } }, /* 9.999999999999999999999999999999995E+2 */
   {  13, { 0x9C3FFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFE6A5AU } }, /* 9.999999999999999999999999999999995E+3 */
   {  16, { 0xC34FFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFE04F0U } }, /* 9.999999999999999999999999999999995E+4 */
   {  19, { 0xF423FFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFD862CU } }, /* 9.999999999999999999999999999999995E+5 */
   {  23, { 0x98967FFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFE73DBU } }, /* 9.999999999999999999999999999999995E+6 */
   {  26, { 0xBEBC1FFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFE10D2U } }, /* 9.999999999999999999999999999999995E+7 */
   {  29, { 0xEE6B27FFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFD9507U } }, /* 9.999999999999999999999999999999995E+8 */
   {  33, { 0x9502F8FFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFE7D24U } }, /* 9.999999999999999999999999999999995E+9 */
   {  36, { 0xBA43B73FU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFE1C6DU } }, /* 9.999999999999999999999999999999995E+10 */
   {  39, { 0xE8D4A50FU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFDA389U } }, /* 9.999999999999999999999999999999995E+11 */
   {  43, { 0x9184E729U, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFE8635U } }, /* 9.999999999999999999999999999999995E+12 */
   {  46, { 0xB5E620F4U, 0x7FFFFFFFU, 0xFFFFFFFFU, 0xFFFE27C3U } }, /* 9.999999999999999999999999999999995E+13 */
   {  49, { 0xE35FA931U, 0x9FFFFFFFU, 0xFFFFFFFFU, 0xFFFDB1B4U } }, /* 9.999999999999999999999999999999995E+14 */
   {  53, { 0x8E1BC9BFU, 0x03FFFFFFU, 0xFFFFFFFFU, 0xFFFE8F10U } }, /* 9.999999999999999999999999999999995E+15 */
   {  56, { 0xB1A2BC2EU, 0xC4FFFFFFU, 0xFFFFFFFFU, 0xFFFE32D4U } }, /* 9.999999999999999999999999999999995E+16 */
   {  59, { 0xDE0B6B3AU, 0x763FFFFFU, 0xFFFFFFFFU, 0xFFFDBF8AU } }, /* 9.999999999999999999999999999999995E+17 */
   {  63, { 0x8AC72304U, 0x89E7FFFFU, 0xFFFFFFFFU, 0xFFFE97B6U } }, /* 9.999999999999999999999999999999995E+18 */
   {  66, { 0xAD78EBC5U, 0xAC61FFFFU, 0xFFFFFFFFU, 0xFFFE3DA3U } }, /* 9.999999999999999999999999999999995E+19 */
   {  69, { 0xD8D726B7U, 0x177A7FFFU, 0xFFFFFFFFU, 0xFFFDCD0CU } }, /* 9.999999999999999999999999999999995E+20 */
   {  73, { 0x87867832U, 0x6EAC8FFFU, 0xFFFFFFFFU, 0xFFFEA028U } }, /* 9.999999999999999999999999999999995E+21 */
   {  76, { 0xA968163FU, 0x0A57B3FFU, 0xFFFFFFFFU, 0xFFFE4832U } }, /* 9.999999999999999999999999999999995E+22 */
   {  79, { 0xD3C21BCEU, 0xCCEDA0FFU, 0xFFFFFFFFU, 0xFFFDDA3EU } }, /* 9.999999999999999999999999999999995E+23 */
   {  83, { 0x84595161U, 0x4014849FU, 0xFFFFFFFFU, 0xFFFEA867U } }, /* 9.999999999999999999999999999999995E+24 */
   {  86, { 0xA56FA5B9U, 0x9019A5C7U, 0xFFFFFFFFU, 0xFFFE5280U } }, /* 9.999999999999999999999999999999995E+25 */
   {  89, { 0xCECB8F27U, 0xF4200F39U, 0xFFFFFFFFU, 0xFFFDE721U } }, /* 9.999999999999999999999999999999995E+26 */
   {  93, { 0x813F3978U, 0xF8940984U, 0x3FFFFFFFU, 0xFFFEB074U } }, /* 9.999999999999999999999999999999995E+27 */
   {  96, { 0xA18F07D7U, 0x36B90BE5U, 0x4FFFFFFFU, 0xFFFE5C91U } }, /* 9.999999999999999999999999999999995E+28 */
   {  99, { 0xC9F2C9CDU, 0x04674EDEU, 0xA3FFFFFFU, 0xFFFDF3B6U } }, /* 9.999999999999999999999999999999995E+29 */
   { 102, { 0xFC6F7C40U, 0x45812296U, 0x4CFFFFFFU, 0xFFFD70A3U } }, /* 9.999999999999999999999999999999995E+30 */
   { 106, { 0x9DC5ADA8U, 0x2B70B59DU, 0xF01FFFFFU, 0xFFFE6666U } }, /* 9.999999999999999999999999999999995E+31 */
   { 109, { 0xC5371912U, 0x364CE305U, 0x6C27FFFFU, 0xFFFE0000U } }, /* 9.999999999999999999999999999999995E+32 */

   /* d = 34 */
   {  -4, { 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCCCC97A1U } }, /* 9.9999999999999999999999999999999995E-2 */
   {  -1, { 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFBD89U } }, /* 9.9999999999999999999999999999999995E-1 */
   {   3, { 0x9FFFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFD676U } }, /* 9.9999999999999999999999999999999995E+0 */
   {   6, { 0xC7FFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFCC13U } }, /* 9.9999999999999999999999999999999995E+1 */
   {   9, { 0xF9FFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFBF18U } }, /* 9.9999999999999999999999999999999995E+2 */
   {  13, { 0x9C3FFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFD76FU } }, /* 9.9999999999999999999999999999999995E+3 */
   {  16, { 0xC34FFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFCD4BU } }, /* 9.9999999999999999999999999999999995E+4 */
   {  19, { 0xF423FFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFC09EU } }, /* 9.9999999999999999999999999999999995E+5 */
   {  23, { 0x98967FFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFD862U } }, /* 9.9999999999999999999999999999999995E+6 */
   {  26, { 0xBEBC1FFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFCE7BU } }, /* 9.9999999999999999999999999999999995E+7 */
   {  29, { 0xEE6B27FFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFC21AU } }, /* 9.9999999999999999999999999999999995E+8 */
   {  33, { 0x9502F8FFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFD950U } }, /* 9.9999999999999999999999999999999995E+9 */
   {  36, { 0xBA43B73FU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFCFA4U } }, /* 9.9999999999999999999999999999999995E+10 */
   {  39, { 0xE8D4A50FU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFC38DU } }, /* 9.9999999999999999999999999999999995E+11 */
   {  43, { 0x9184E729U, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFDA38U } }, /* 9.9999999999999999999999999999999995E+12 */
   {  46, { 0xB5E620F4U, 0x7FFFFFFFU, 0xFFFFFFFFU, 0xFFFFD0C6U } }, /* 9.9999999999999999999999999999999995E+13 */
   {  49, { 0xE35FA931U, 0x9FFFFFFFU, 0xFFFFFFFFU, 0xFFFFC4F8U } }, /* 9.9999999999999999999999999999999995E+14 */
   {  53, { 0x8E1BC9BFU, 0x03FFFFFFU, 0xFFFFFFFFU, 0xFFFFDB1BU } }, /* 9.9999999999999999999999999999999995E+15 */
   {  56, { 0xB1A2BC2EU, 0xC4FFFFFFU, 0xFFFFFFFFU, 0xFFFFD1E2U } }, /* 9.9999999999999999999999999999999995E+16 */
   {  59, { 0xDE0B6B3AU, 0x763FFFFFU, 0xFFFFFFFFU, 0xFFFFC65AU } }, /* 9.9999999999999999999999999999999995E+17 */
   {  63, { 0x8AC72304U, 0x89E7FFFFU, 0xFFFFFFFFU, 0xFFFFDBF8U } }, /* 9.9999999999999999999999999999999995E+18 */
   {  66, { 0xAD78EBC5U, 0xAC61FFFFU, 0xFFFFFFFFU, 0xFFFFD2F6U } }, /* 9.9999999999999999999999999999999995E+19 */
   {  69, { 0xD8D726B7U, 0x177A7FFFU, 0xFFFFFFFFU, 0xFFFFC7B4U } }, /* 9.9999999999999999999999999999999995E+20 */
   {  73, { 0x87867832U, 0x6EAC8FFFU, 0xFFFFFFFFU, 0xFFFFDCD0U } }, /* 9.9999999999999999999999999999999995E+21 */
   {  76, { 0xA968163FU, 0x0A57B3FFU, 0xFFFFFFFFU, 0xFFFFD405U } }, /* 9.9999999999999999999999999999999995E+22 */
   {  79, { 0xD3C21BCEU, 0xCCEDA0FFU, 0xFFFFFFFFU, 0xFFFFC906U } }, /* 9.9999999999999999999999999999999995E+23 */
   {  83, { 0x84595161U, 0x4014849FU, 0xFFFFFFFFU, 0xFFFFDDA3U } }, /* 9.9999999999999999999999999999999995E+24 */
   {  86, { 0xA56FA5B9U, 0x9019A5C7U, 0xFFFFFFFFU, 0xFFFFD50CU } }, /* 9.9999999999999999999999999999999995E+25 */
   {  89, { 0xCECB8F27U, 0xF4200F39U, 0xFFFFFFFFU, 0xFFFFCA50U } }, /* 9.9999999999999999999999999999999995E+26 */
   {  93, { 0x813F3978U, 0xF8940984U, 0x3FFFFFFFU, 0xFFFFDE72U } }, /* 9.9999999999999999999999999999999995E+27 */
   {  96, { 0xA18F07D7U, 0x36B90BE5U, 0x4FFFFFFFU, 0xFFFFD60EU } }, /* 9.9999999999999999999999999999999995E+28 */
   {  99, { 0xC9F2C9CDU, 0x04674EDEU, 0xA3FFFFFFU, 0xFFFFCB92U } }, /* 9.9999999999999999999999999999999995E+29 */
   { 102, { 0xFC6F7C40U, 0x45812296U, 0x4CFFFFFFU, 0xFFFFBE76U } }, /* 9.9999999999999999999999999999999995E+30 */
   { 106, { 0x9DC5ADA8U, 0x2B70B59DU, 0xF01FFFFFU, 0xFFFFD70AU } }, /* 9.9999999999999999999999999999999995E+31 */
   { 109, { 0xC5371912U, 0x364CE305U, 0x6C27FFFFU, 0xFFFFCCCCU } }, /* 9.9999999999999999999999999999999995E+32 */
   { 112, { 0xF684DF56U, 0xC3E01BC6U, 0xC731FFFFU, 0xFFFFC000U } }, /* 9.9999999999999999999999999999999995E+33 */

   /* d = 35 */
   {  -4, { 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCCCCCCCCU, 0xCCCCC77BU } }, /* 9.99999999999999999999999999999999995E-2 */
   {  -1, { 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFF95AU } }, /* 9.99999999999999999999999999999999995E-1 */
   {   3, { 0x9FFFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFFBD8U } }, /* 9.99999999999999999999999999999999995E+0 */
   {   6, { 0xC7FFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFFACEU } }, /* 9.99999999999999999999999999999999995E+1 */
   {   9, { 0xF9FFFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFF982U } }, /* 9.99999999999999999999999999999999995E+2 */
   {  13, { 0x9C3FFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFFBF1U } }, /* 9.99999999999999999999999999999999995E+3 */
   {  16, { 0xC34FFFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFFAEDU } }, /* 9.99999999999999999999999999999999995E+4 */
   {  19, { 0xF423FFFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFF9A9U } }, /* 9.99999999999999999999999999999999995E+5 */
   {  23, { 0x98967FFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFFC09U } }, /* 9.99999999999999999999999999999999995E+6 */
   {  26, { 0xBEBC1FFFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFFB0CU } }, /* 9.99999999999999999999999999999999995E+7 */
   {  29, { 0xEE6B27FFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFF9CFU } }, /* 9.99999999999999999999999999999999995E+8 */
   {  33, { 0x9502F8FFU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFFC21U } }, /* 9.99999999999999999999999999999999995E+9 */
   {  36, { 0xBA43B73FU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFFB2AU } }, /* 9.99999999999999999999999999999999995E+10 */
   {  39, { 0xE8D4A50FU, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFF9F4U } }, /* 9.99999999999999999999999999999999995E+11 */
   {  43, { 0x9184E729U, 0xFFFFFFFFU, 0xFFFFFFFFU, 0xFFFFFC38U } }, /* 9.99999999999999999999999999999999995E+12 */
   {  46, { 0xB5E620F4U, 0x7FFFFFFFU, 0xFFFFFFFFU, 0xFFFFFB47U } }, /* 9.99999999999999999999999999999999995E+13 */
   {  49, { 0xE35FA931U, 0x9FFFFFFFU, 0xFFFFFFFFU, 0xFFFFFA18U } }, /* 9.99999999999999999999999999999999995E+14 */
   {  53, { 0x8E1BC9BFU, 0x03FFFFFFU, 0xFFFFFFFFU, 0xFFFFFC4FU } }, /* 9.99999999999999999999999999999999995E+15 */
   {  56, { 0xB1A2BC2EU, 0xC4FFFFFFU, 0xFFFFFFFFU, 0xFFFFFB63U } }, /* 9.99999999999999999999999999999999995E+16 */
   {  59, { 0xDE0B6B3AU, 0x763FFFFFU, 0xFFFFFFFFU, 0xFFFFFA3CU } }, /* 9.99999999999999999999999999999999995E+17 */
   {  63, { 0x8AC72304U, 0x89E7FFFFU, 0xFFFFFFFFU, 0xFFFFFC65U } }, /* 9.99999999999999999999999999999999995E+18 */
   {  66, { 0xAD78EBC5U, 0xAC61FFFFU, 0xFFFFFFFFU, 0xFFFFFB7FU } }, /* 9.99999999999999999999999999999999995E+19 */
   {  69, { 0xD8D726B7U, 0x177A7FFFU, 0xFFFFFFFFU, 0xFFFFFA5EU } }, /* 9.99999999999999999999999999999999995E+20 */
   {  73, { 0x87867832U, 0x6EAC8FFFU, 0xFFFFFFFFU, 0xFFFFFC7BU } }, /* 9.99999999999999999999999999999999995E+21 */
   {  76, { 0xA968163FU, 0x0A57B3FFU, 0xFFFFFFFFU, 0xFFFFFB9AU } }, /* 9.99999999999999999999999999999999995E+22 */
   {  79, { 0xD3C21BCEU, 0xCCEDA0FFU, 0xFFFFFFFFU, 0xFFFFFA80U } }, /* 9.99999999999999999999999999999999995E+23 */
   {  83, { 0x84595161U, 0x4014849FU, 0xFFFFFFFFU, 0xFFFFFC90U } }, /* 9.99999999999999999999999999999999995E+24 */
   {  86, { 0xA56FA5B9U, 0x9019A5C7U, 0xFFFFFFFFU, 0xFFFFFBB4U } }, /* 9.99999999999999999999999999999999995E+25 */
   {  89, { 0xCECB8F27U, 0xF4200F39U, 0xFFFFFFFFU, 0xFFFFFAA1U } }, /* 9.99999999999999999999999999999999995E+26 */
   {  93, { 0x813F3978U, 0xF8940984U, 0x3FFFFFFFU, 0xFFFFFCA5U } }, /* 9.99999999999999999999999999999999995E+27 */
   {  96, { 0xA18F07D7U, 0x36B90BE5U, 0x4FFFFFFFU, 0xFFFFFBCEU } }, /* 9.99999999999999999999999999999999995E+28 */
   {  99, { 0xC9F2C9CDU, 0x04674EDEU, 0xA3FFFFFFU, 0xFFFFFAC1U } }, /* 9.99999999999999999999999999999999995E+29 */
   { 102, { 0xFC6F7C40U, 0x45812296U, 0x4CFFFFFFU, 0xFFFFF972U } }, /* 9.99999999999999999999999999999999995E+30 */
   { 106, { 0x9DC5ADA8U, 0x2B70B59DU, 0xF01FFFFFU, 0xFFFFFBE7U } }, /* 9.99999999999999999999999999999999995E+31 */
   { 109, { 0xC5371912U, 0x364CE305U, 0x6C27FFFFU, 0xFFFFFAE1U } }, /* 9.99999999999999999999999999999999995E+32 */
   { 112, { 0xF684DF56U, 0xC3E01BC6U, 0xC731FFFFU, 0xFFFFF999U } }, /* 9.99999999999999999999999999999999995E+33 */
   { 116, { 0x9A130B96U, 0x3A6C115CU, 0x3C7F3FFFU, 0xFFFFFC00U } }  /* 9.99999999999999999999999999999999995E+34 */   
};
