
/* Copyright (C) 2002-2008 Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

/* Implement the SIZE() intrinsic without the optional DIM parameter.
 * This returns the size of the whole array. */

#include "runtime.h"


/* size()-- SIZE intrinsic */

#define size_4 prefix(size_4)

G95_INT4 size_4(g95_array_descriptor *array) {
G95_INT4 size, extent;
int i, rank;

    rank = array->rank;
    size = 1;

    for(i=0; i<rank; i++) {
	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent < 0)
	    extent = 0;

	size *= extent;
    }

    return size;
}



/* size()-- SIZE intrinsic */

#define size_8 prefix(size_8)

G95_INT8 size_8(g95_array_descriptor *array) {
G95_INT8 size, extent;
int i, rank;

    rank = array->rank;
    size = 1;

    for(i=0; i<rank; i++) {
	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent < 0)
	    extent = 0;

	size *= extent;
    }

    return size;
}

