
/* Copyright (C) 2003-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

/* Implement the dot_product() intrinsic. */

#ifdef SUBROUTINE

#if COMPLEX == 0

/* Real dot_product() */

TYPE SUBROUTINE(g95_array_descriptor *a, g95_array_descriptor *b) {
G95_DINT n, da, db;
char *ap, *bp;
TYPE sum;

    sum = 0;

    ap = a->offset + a->info[0].mult * a->info[0].lbound;
    bp = b->offset + b->info[0].mult * b->info[0].lbound;

    da = a->info[0].mult;
    db = b->info[0].mult;

    n = a->info[0].ubound - a->info[0].lbound + 1;

    while(n > 0) {
	SUM

        ap += da;
	bp += db;

	n--;
    }

    return sum;
}


#elif COMPLEX == 1

/* Complex from complex/real */

void SUBROUTINE(TYPE *sum, g95_array_descriptor *a, g95_array_descriptor *b) {
G95_DINT n, da, db;
char *ap, *bp;

    sum->r = sum->c = 0;

    ap = a->offset + a->info[0].mult * a->info[0].lbound;
    bp = b->offset + b->info[0].mult * b->info[0].lbound;

    da = a->info[0].mult;
    db = b->info[0].mult;

    n = a->info[0].ubound - a->info[0].lbound + 1;

    while(n > 0) {
	sum->r += ((TYPE1 *) ap)->r * (*((TYPE2 *) bp));
	sum->c -= ((TYPE1 *) ap)->c * (*((TYPE2 *) bp));

	ap += da;
	bp += db;

	n--;
    }
}

#undef TYPE1
#undef TYPE2

#elif COMPLEX == 2

/* Complex from real/complex */

void SUBROUTINE(TYPE *sum, g95_array_descriptor *a, g95_array_descriptor *b) {
G95_DINT n, da, db;
char *ap, *bp;

    sum->r = sum->c = 0;

    ap = a->offset + a->info[0].mult * a->info[0].lbound;
    bp = b->offset + b->info[0].mult * b->info[0].lbound;

    da = a->info[0].mult;
    db = b->info[0].mult;

    n = a->info[0].ubound - a->info[0].lbound + 1;

    while(n > 0) {
	sum->r += (*((TYPE1 *) ap)) * ((TYPE2 *) bp)->r;
	sum->c += (*((TYPE1 *) ap)) * ((TYPE2 *) bp)->c;

	ap += da;
	bp += db;

	n--;
    }
}

#undef TYPE1
#undef TYPE2

#elif COMPLEX == 3

/* Complex from complex/complex */

void SUBROUTINE(TYPE *sum, g95_array_descriptor *a, g95_array_descriptor *b) {
G95_DINT n, da, db;
char *ap, *bp;

    sum->r = sum->c = 0;

    ap = a->offset + a->info[0].mult * a->info[0].lbound;
    bp = b->offset + b->info[0].mult * b->info[0].lbound;

    da = a->info[0].mult;
    db = b->info[0].mult;

    n = a->info[0].ubound - a->info[0].lbound + 1;

    while(n > 0) {
	sum->r += ((TYPE1 *) ap)->r * ((TYPE2 *) bp)->r
               + ((TYPE1 *) ap)->c * ((TYPE2 *) bp)->c;

	sum->c += ((TYPE1 *) ap)->r * ((TYPE2 *) bp)->c
                - ((TYPE1 *) ap)->c * ((TYPE2 *) bp)->r;

	ap += da;
	bp += db;

	n--;
    }
}

#undef TYPE1
#undef TYPE2

#endif

#undef SUBROUTINE
#undef SUM
#undef TYPE


#else

#include "runtime.h"

#define COMPLEX 0

#define SUBROUTINE prefix(dot_product_i1_i1)
#define TYPE G95_INT1
#define SUM    sum += (*((G95_INT1 *) ap)) * (*((G95_INT1 *) bp));
#include "dot_product.c"


#define SUBROUTINE prefix(dot_product_i1_i2)
#define TYPE G95_INT2
#define SUM    sum += (*((G95_INT1 *) ap)) * (*((G95_INT2 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i2_i1)
#define TYPE G95_INT2
#define SUM    sum += (*((G95_INT2 *) ap)) * (*((G95_INT1 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i2_i2)
#define TYPE G95_INT2
#define SUM    sum += (*((G95_INT2 *) ap)) * (*((G95_INT2 *) bp));
#include "dot_product.c"


#define SUBROUTINE prefix(dot_product_i1_i4)
#define TYPE G95_INT4
#define SUM    sum += (*((G95_INT1 *) ap)) * (*((G95_INT4 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i2_i4)
#define TYPE G95_INT4
#define SUM    sum += (*((G95_INT2 *) ap)) * (*((G95_INT4 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i4_i1)
#define TYPE G95_INT4
#define SUM    sum += (*((G95_INT4 *) ap)) * (*((G95_INT1 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i4_i2)
#define TYPE G95_INT4
#define SUM    sum += (*((G95_INT4 *) ap)) * (*((G95_INT2 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i4_i4)
#define TYPE G95_INT4
#define SUM    sum += (*((G95_INT4 *) ap)) * (*((G95_INT4 *) bp));
#include "dot_product.c"


#define SUBROUTINE prefix(dot_product_i1_i8)
#define TYPE G95_INT8
#define SUM    sum += (*((G95_INT1 *) ap)) * (*((G95_INT8 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i2_i8)
#define TYPE G95_INT8
#define SUM    sum += (*((G95_INT2 *) ap)) * (*((G95_INT8 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i4_i8)
#define TYPE G95_INT8
#define SUM    sum += (*((G95_INT4 *) ap)) * (*((G95_INT8 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i8_i1)
#define TYPE G95_INT8
#define SUM    sum += (*((G95_INT8 *) ap)) * (*((G95_INT1 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i8_i2)
#define TYPE G95_INT8
#define SUM    sum += (*((G95_INT8 *) ap)) * (*((G95_INT2 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i8_i4)
#define TYPE G95_INT8
#define SUM    sum += (*((G95_INT8 *) ap)) * (*((G95_INT4 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i8_i8)
#define TYPE G95_INT8
#define SUM    sum += (*((G95_INT8 *) ap)) * (*((G95_INT8 *) bp));
#include "dot_product.c"


#define SUBROUTINE prefix(dot_product_i1_r4)
#define TYPE float
#define SUM    sum += (*((G95_INT1 *) ap)) * (*((float *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i2_r4)
#define TYPE float
#define SUM    sum += (*((G95_INT2 *) ap)) * (*((float *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i4_r4)
#define SUM    sum += (*((G95_INT4 *) ap)) * (*((float *) bp));
#define TYPE float
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i8_r4)
#define TYPE float
#define SUM    sum += (*((G95_INT8 *) ap)) * (*((float *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_r4_i1)
#define TYPE float
#define SUM    sum += (*((float *) ap)) * (*((G95_INT1 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_r4_i2)
#define TYPE float
#define SUM    sum += (*((float *) ap)) * (*((G95_INT2 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_r4_i4)
#define TYPE float
#define SUM    sum += (*((float *) ap)) * (*((G95_INT4 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_r4_i8)
#define TYPE float
#define SUM    sum += (*((float *) ap)) * (*((G95_INT8 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_r4_r4)
#define TYPE float
#define SUM    sum += (*((float *) ap)) * (*((float *) bp));
#include "dot_product.c"


#define SUBROUTINE prefix(dot_product_i1_r8)
#define TYPE double
#define SUM    sum += (*((G95_INT1 *) ap)) * (*((double *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i2_r8)
#define SUM    sum += (*((G95_INT2 *) ap)) * (*((double *) bp));
#define TYPE double
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i4_r8)
#define TYPE double
#define SUM    sum += (*((G95_INT4 *) ap)) * (*((double *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i8_r8)
#define TYPE double
#define SUM    sum += (*((G95_INT8 *) ap)) * (*((double *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_r4_r8)
#define TYPE double
#define SUM    sum += (*((float *) ap)) * (*((double *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_r8_i1)
#define TYPE double
#define SUM    sum += (*((double *) ap)) * (*((G95_INT1 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_r8_i2)
#define TYPE double
#define SUM    sum += (*((double *) ap)) * (*((G95_INT2 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_r8_i4)
#define TYPE double
#define SUM    sum += (*((double *) ap)) * (*((G95_INT4 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_r8_i8)
#define TYPE double
#define SUM    sum += (*((double *) ap)) * (*((G95_INT8 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_r8_r4)
#define TYPE double
#define SUM    sum += (*((double *) ap)) * (*((float *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_r8_r8)
#define TYPE double
#define SUM    sum += (*((double *) ap)) * (*((double *) bp));
#include "dot_product.c"

/* Logical kinds.  Despite different logical input kinds, default
 * integer is always returned. */

#define SUBROUTINE prefix(dot_product_l1_l1)
#define TYPE G95_DINT
#define SUM sum |= (*((G95_INT1 *) ap)) & (*((G95_INT1 *) bp));
#include "dot_product.c"


#define SUBROUTINE prefix(dot_product_l1_l2)
#define TYPE G95_DINT
#define SUM sum |= (*((G95_INT1 *) ap)) & (*((G95_INT2 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_l2_l1)
#define TYPE G95_DINT
#define SUM sum |= (*((G95_INT2 *) ap)) & (*((G95_INT1 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_l2_l2)
#define TYPE G95_DINT
#define SUM sum |= (*((G95_INT2 *) ap)) & (*((G95_INT2 *) bp));
#include "dot_product.c"


#define SUBROUTINE prefix(dot_product_l1_l4)
#define TYPE G95_DINT
#define SUM sum |= (*((G95_INT1 *) ap)) & (*((G95_INT4 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_l2_l4)
#define TYPE G95_DINT
#define SUM sum |= (*((G95_INT2 *) ap)) & (*((G95_INT4 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_l4_l1)
#define TYPE G95_DINT
#define SUM sum |= (*((G95_INT4 *) ap)) & (*((G95_INT1 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_l4_l2)
#define TYPE G95_DINT
#define SUM sum |= (*((G95_INT4 *) ap)) & (*((G95_INT2 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_l4_l4)
#define TYPE G95_DINT
#define SUM sum |= (*((G95_INT4 *) ap)) & (*((G95_INT4 *) bp));
#include "dot_product.c"


#define SUBROUTINE prefix(dot_product_l1_l8)
#define TYPE G95_DINT
#define SUM sum |= (*((G95_INT1 *) ap)) & (*((G95_INT8 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_l2_l8)
#define TYPE G95_DINT
#define SUM sum |= (*((G95_INT2 *) ap)) & (*((G95_INT8 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_l4_l8)
#define TYPE G95_DINT
#define SUM sum |= (*((G95_INT4 *) ap)) & (*((G95_INT8 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_l8_l1)
#define TYPE G95_DINT
#define SUM sum |= (*((G95_INT8 *) ap)) & (*((G95_INT1 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_l8_l2)
#define TYPE G95_DINT
#define SUM sum |= (*((G95_INT8 *) ap)) & (*((G95_INT2 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_l8_l4)
#define TYPE G95_DINT
#define SUM sum |= (*((G95_INT8 *) ap)) & (*((G95_INT4 *) bp));
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_l8_l8)
#define TYPE G95_DINT
#define SUM sum |= (*((G95_INT8 *) ap)) & (*((G95_INT8 *) bp));
#include "dot_product.c"


#undef COMPLEX
#define COMPLEX 1

#define SUBROUTINE prefix(dot_product_z4_i1)
#define TYPE z4
#define TYPE1 z4
#define TYPE2 G95_INT1
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_z4_i2)
#define TYPE z4
#define TYPE1 z4
#define TYPE2 G95_INT2
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_z4_i4)
#define TYPE z4
#define TYPE1 z4
#define TYPE2 G95_INT4
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_z4_i8)
#define TYPE z4
#define TYPE1 z4
#define TYPE2 G95_INT8
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_z4_r4)
#define TYPE z4
#define TYPE1 z4
#define TYPE2 float
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_z4_r8)
#define TYPE z4
#define TYPE1 z4
#define TYPE2 double
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_z8_i1)
#define TYPE z8
#define TYPE1 z8
#define TYPE2 G95_INT1
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_z8_i2)
#define TYPE z8
#define TYPE1 z8
#define TYPE2 G95_INT2
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_z8_i4)
#define TYPE z8
#define TYPE1 z8
#define TYPE2 G95_INT4
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_z8_i8)
#define TYPE z8
#define TYPE1 z8
#define TYPE2 G95_INT8
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_z8_r4)
#define TYPE z8
#define TYPE1 z8
#define TYPE2 float
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_z8_r8)
#define TYPE z8
#define TYPE1 z8
#define TYPE2 double
#include "dot_product.c"

#undef COMPLEX
#define COMPLEX 2

#define SUBROUTINE prefix(dot_product_i1_z4)
#define TYPE z4
#define TYPE1 G95_INT1
#define TYPE2 z4
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i2_z4)
#define TYPE z4
#define TYPE1 G95_INT2
#define TYPE2 z4
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i4_z4)
#define TYPE z4
#define TYPE1 G95_INT4
#define TYPE2 z4
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i8_z4)
#define TYPE z4
#define TYPE1 G95_INT8
#define TYPE2 z4
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_r4_z4)
#define TYPE z4
#define TYPE1 float
#define TYPE2 z4
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_r8_z4)
#define TYPE z4
#define TYPE1 double
#define TYPE2 z4
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i1_z8)
#define TYPE z8
#define TYPE1 G95_INT1
#define TYPE2 z8
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i2_z8)
#define TYPE z8
#define TYPE1 G95_INT2
#define TYPE2 z8
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i4_z8)
#define TYPE z8
#define TYPE1 G95_INT4
#define TYPE2 z8
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_i8_z8)
#define TYPE z8
#define TYPE1 G95_INT8
#define TYPE2 z8
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_r4_z8)
#define TYPE z8
#define TYPE1 float
#define TYPE2 z8
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_r8_z8)
#define TYPE z8
#define TYPE1 double
#define TYPE2 z8
#include "dot_product.c"

#undef COMPLEX
#define COMPLEX 3

#define SUBROUTINE prefix(dot_product_z4_z4)
#define TYPE z4
#define TYPE1 z4
#define TYPE2 z4
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_z8_z4)
#define TYPE z8
#define TYPE1 z8
#define TYPE2 z4
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_z4_z8)
#define TYPE z8
#define TYPE1 z4
#define TYPE2 z8
#include "dot_product.c"

#define SUBROUTINE prefix(dot_product_z8_z8)
#define TYPE z8
#define TYPE1 z8
#define TYPE2 z8
#include "dot_product.c"

#endif /* SUBROUTINE */
