.\" Automatically generated from an mdoc input file.  Do not edit.
.\" zip_close.mdoc -- close zip archive
.\" Copyright (C) 2003-2022 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <info@libzip.org>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH "ZIP_CLOSE" "3" "January 23, 2023" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_close\fR
\- close zip archive
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIint\fR
.br
.PD 0
.HP 4n
\fBzip_close\fR(\fIzip_t\ *archive\fR);
.PD
.SH "DESCRIPTION"
The
\fBzip_close\fR()
function writes any changes made to
\fIarchive\fR
to disk.
If
\fIarchive\fR
contains no files, the file is completely removed (no empty archive is
written), unless the archive flag
\fRZIP_AFL_CREATE_OR_KEEP_FILE_FOR_EMPTY_ARCHIVE\fR
is set.
If successful,
\fIarchive\fR
is freed.
Otherwise
\fIarchive\fR
is left unchanged and must still be freed.
.PP
To close and free a zip archive without saving changes, use
zip_discard(3).
.PP
Progress updates for GUIs can be implemented using
zip_register_progress_callback_with_state(3).
Cancelling the write of an archive during
\fBzip_close\fR
can be implemented using
zip_register_cancel_callback_with_state(3).
.SH "RETURN VALUES"
Upon successful completion 0 is returned.
Otherwise, \-1 is returned and the error code in
\fIarchive\fR
is set to indicate the error.
.SH "ERRORS"
\fBzip_close\fR()
will fail if:
.TP 19n
[\fRZIP_ER_EOF\fR]
Unexpected end-of-file found while reading from a file.
.TP 19n
[\fRZIP_ER_INTERNAL\fR]
The callback function of an added or replaced file returned an
error but failed to report which.
.TP 19n
[\fRZIP_ER_INVAL\fR]
The
\fIpath\fR
argument is
\fRNULL\fR.
.TP 19n
[\fRZIP_ER_MEMORY\fR]
Required memory could not be allocated.
.TP 19n
[\fRZIP_ER_NOZIP\fR]
File is not a zip archive.
.TP 19n
[\fRZIP_ER_READ\fR]
A file read failed.
.TP 19n
[\fRZIP_ER_RENAME\fR]
A temporary file could not be renamed to its final name.
.TP 19n
[\fRZIP_ER_SEEK\fR]
A file seek failed.
.TP 19n
[\fRZIP_ER_TMPOPEN\fR]
A temporary file could not be created.
.TP 19n
[\fRZIP_ER_WRITE\fR]
A file write failed.
.TP 19n
[\fRZIP_ER_ZLIB\fR]
An error occurred while (de)compressing a stream with
zlib(3).
.PD 0
.PP
Additionally, any errors returned by the callback function
for added or replaced files will be passed back.
.PD
.SH "SEE ALSO"
libzip(3),
zip_discard(3),
zip_fdopen(3),
zip_get_error(3),
zip_open(3),
zip_register_cancel_callback_with_state(3),
zip_register_progress_callback_with_state(3),
zip_set_archive_flag(3),
zip_strerror(3)
.SH "HISTORY"
\fBzip_close\fR()
was added in libzip 0.6.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
.SH "CAVEATS"
Please note that all indices,
zip_stat(3)
information and other data about the archive is invalid after
\fBzip_close\fR.
When you open the same file again, it will be a completely new
\fIzip_t\fR
structure.
