/*
 *  Generated by combgen.sh.  DO NOT EDIT.
 */

#include <stdio.h>
#include <stdlib.h>
#include "exact-p-val.h"


const extern int    Debug;

/*
 *  Generate all combinations n choose 2 and count FCs >= observed.
 *  This is much faster than generic algorithms for generating n choose
 *  k lists for any n and k.
 */

unsigned long   extreme_fcs2(count_pair_t count_pairs[], unsigned long pair_count,
			double observed_fc,
			unsigned long *fc_count)

{
    // Using sample++ % sample_rate doesn't produce much gain
    // Go after loop increments instead
    unsigned long   fc_ge = 0, fc_le = 0,
		    increment = 1, pass, count = 0;
    double          c2_sum, c1_sum, fc;
    
    unsigned long  c1, c2;

    for (pass = 0; pass < 1; ++pass)
     for (c1 = 0; c1 < pair_count; c1 += increment)
      for (c2 = c1 + 1; c2 < pair_count; c2 += increment)
      {
          c2_sum =
              count_pairs[c1].c2_count +
              count_pairs[c2].c2_count;
          c1_sum =
              count_pairs[c1].c1_count +
              count_pairs[c2].c1_count;
          fc = c2_sum / c1_sum;
          if ( fc >= observed_fc ) ++fc_ge;
          else if ( fc <= 1.0 / observed_fc ) ++fc_le;
          ++count;
      }
    if ( Debug )
	printf("FCs > %0.3f = %-5lu     FCs < %0.3f = %-5lu\n",
		observed_fc, fc_ge, 1.0 / observed_fc, fc_le);
    *fc_count = count;
    
    return fc_ge + fc_le;
}

const extern int    Debug;

/*
 *  Generate all combinations n choose 3 and count FCs >= observed.
 *  This is much faster than generic algorithms for generating n choose
 *  k lists for any n and k.
 */

unsigned long   extreme_fcs3(count_pair_t count_pairs[], unsigned long pair_count,
			double observed_fc,
			unsigned long *fc_count)

{
    // Using sample++ % sample_rate doesn't produce much gain
    // Go after loop increments instead
    unsigned long   fc_ge = 0, fc_le = 0,
		    increment = 1, pass, count = 0;
    double          c2_sum, c1_sum, fc;
    
    unsigned long  c1, c2, c3;

    for (pass = 0; pass < 1; ++pass)
     for (c1 = 0; c1 < pair_count; c1 += increment)
      for (c2 = c1 + 1; c2 < pair_count; c2 += increment)
       for (c3 = c2 + 1; c3 < pair_count; c3 += increment)
       {
           c2_sum =
               count_pairs[c1].c2_count +
               count_pairs[c2].c2_count +
               count_pairs[c3].c2_count;
           c1_sum =
               count_pairs[c1].c1_count +
               count_pairs[c2].c1_count +
               count_pairs[c3].c1_count;
           fc = c2_sum / c1_sum;
           if ( fc >= observed_fc ) ++fc_ge;
           else if ( fc <= 1.0 / observed_fc ) ++fc_le;
           ++count;
       }
    if ( Debug )
	printf("FCs > %0.3f = %-5lu     FCs < %0.3f = %-5lu\n",
		observed_fc, fc_ge, 1.0 / observed_fc, fc_le);
    *fc_count = count;
    
    return fc_ge + fc_le;
}

const extern int    Debug;

/*
 *  Generate all combinations n choose 4 and count FCs >= observed.
 *  This is much faster than generic algorithms for generating n choose
 *  k lists for any n and k.
 */

unsigned long   extreme_fcs4(count_pair_t count_pairs[], unsigned long pair_count,
			double observed_fc,
			unsigned long *fc_count)

{
    // Using sample++ % sample_rate doesn't produce much gain
    // Go after loop increments instead
    unsigned long   fc_ge = 0, fc_le = 0,
		    increment = 1, pass, count = 0;
    double          c2_sum, c1_sum, fc;
    
    unsigned long  c1, c2, c3, c4;

    for (pass = 0; pass < 1; ++pass)
     for (c1 = 0; c1 < pair_count; c1 += increment)
      for (c2 = c1 + 1; c2 < pair_count; c2 += increment)
       for (c3 = c2 + 1; c3 < pair_count; c3 += increment)
        for (c4 = c3 + 1; c4 < pair_count; c4 += increment)
        {
            c2_sum =
                count_pairs[c1].c2_count +
                count_pairs[c2].c2_count +
                count_pairs[c3].c2_count +
                count_pairs[c4].c2_count;
            c1_sum =
                count_pairs[c1].c1_count +
                count_pairs[c2].c1_count +
                count_pairs[c3].c1_count +
                count_pairs[c4].c1_count;
            fc = c2_sum / c1_sum;
            if ( fc >= observed_fc ) ++fc_ge;
            else if ( fc <= 1.0 / observed_fc ) ++fc_le;
            ++count;
        }
    if ( Debug )
	printf("FCs > %0.3f = %-5lu     FCs < %0.3f = %-5lu\n",
		observed_fc, fc_ge, 1.0 / observed_fc, fc_le);
    *fc_count = count;
    
    return fc_ge + fc_le;
}

const extern int    Debug;

/*
 *  Generate all combinations n choose 5 and count FCs >= observed.
 *  This is much faster than generic algorithms for generating n choose
 *  k lists for any n and k.
 */

unsigned long   extreme_fcs5(count_pair_t count_pairs[], unsigned long pair_count,
			double observed_fc,
			unsigned long *fc_count)

{
    // Using sample++ % sample_rate doesn't produce much gain
    // Go after loop increments instead
    unsigned long   fc_ge = 0, fc_le = 0,
		    increment = 3, pass, count = 0;
    double          c2_sum, c1_sum, fc;
    
    unsigned long  c1, c2, c3, c4, c5;

    for (pass = 0; pass < 8; ++pass)
     for (c1 = 0; c1 < pair_count; c1 += increment)
      for (c2 = c1 + 1 + random() % increment; c2 < pair_count; c2 += increment)
       for (c3 = c2 + 1 + random() % increment; c3 < pair_count; c3 += increment)
        for (c4 = c3 + 1 + random() % increment; c4 < pair_count; c4 += increment)
         for (c5 = c4 + 1 + random() % increment; c5 < pair_count; c5 += increment)
         {
             c2_sum =
                 count_pairs[c1].c2_count +
                 count_pairs[c2].c2_count +
                 count_pairs[c3].c2_count +
                 count_pairs[c4].c2_count +
                 count_pairs[c5].c2_count;
             c1_sum =
                 count_pairs[c1].c1_count +
                 count_pairs[c2].c1_count +
                 count_pairs[c3].c1_count +
                 count_pairs[c4].c1_count +
                 count_pairs[c5].c1_count;
             fc = c2_sum / c1_sum;
             if ( fc >= observed_fc ) ++fc_ge;
             else if ( fc <= 1.0 / observed_fc ) ++fc_le;
             ++count;
         }
    if ( Debug )
	printf("FCs > %0.3f = %-5lu     FCs < %0.3f = %-5lu\n",
		observed_fc, fc_ge, 1.0 / observed_fc, fc_le);
    *fc_count = count;
    
    return fc_ge + fc_le;
}

const extern int    Debug;

/*
 *  Generate all combinations n choose 6 and count FCs >= observed.
 *  This is much faster than generic algorithms for generating n choose
 *  k lists for any n and k.
 */

unsigned long   extreme_fcs6(count_pair_t count_pairs[], unsigned long pair_count,
			double observed_fc,
			unsigned long *fc_count)

{
    // Using sample++ % sample_rate doesn't produce much gain
    // Go after loop increments instead
    unsigned long   fc_ge = 0, fc_le = 0,
		    increment = 5, pass, count = 0;
    double          c2_sum, c1_sum, fc;
    
    unsigned long  c1, c2, c3, c4, c5, c6;

    for (pass = 0; pass < 8; ++pass)
     for (c1 = 0; c1 < pair_count; c1 += increment)
      for (c2 = c1 + 1 + random() % increment; c2 < pair_count; c2 += increment)
       for (c3 = c2 + 1 + random() % increment; c3 < pair_count; c3 += increment)
        for (c4 = c3 + 1 + random() % increment; c4 < pair_count; c4 += increment)
         for (c5 = c4 + 1 + random() % increment; c5 < pair_count; c5 += increment)
          for (c6 = c5 + 1 + random() % increment; c6 < pair_count; c6 += increment)
          {
              c2_sum =
                  count_pairs[c1].c2_count +
                  count_pairs[c2].c2_count +
                  count_pairs[c3].c2_count +
                  count_pairs[c4].c2_count +
                  count_pairs[c5].c2_count +
                  count_pairs[c6].c2_count;
              c1_sum =
                  count_pairs[c1].c1_count +
                  count_pairs[c2].c1_count +
                  count_pairs[c3].c1_count +
                  count_pairs[c4].c1_count +
                  count_pairs[c5].c1_count +
                  count_pairs[c6].c1_count;
              fc = c2_sum / c1_sum;
              if ( fc >= observed_fc ) ++fc_ge;
              else if ( fc <= 1.0 / observed_fc ) ++fc_le;
              ++count;
          }
    if ( Debug )
	printf("FCs > %0.3f = %-5lu     FCs < %0.3f = %-5lu\n",
		observed_fc, fc_ge, 1.0 / observed_fc, fc_le);
    *fc_count = count;
    
    return fc_ge + fc_le;
}

const extern int    Debug;

/*
 *  Generate all combinations n choose 7 and count FCs >= observed.
 *  This is much faster than generic algorithms for generating n choose
 *  k lists for any n and k.
 */

unsigned long   extreme_fcs7(count_pair_t count_pairs[], unsigned long pair_count,
			double observed_fc,
			unsigned long *fc_count)

{
    // Using sample++ % sample_rate doesn't produce much gain
    // Go after loop increments instead
    unsigned long   fc_ge = 0, fc_le = 0,
		    increment = 7, pass, count = 0;
    double          c2_sum, c1_sum, fc;
    
    unsigned long  c1, c2, c3, c4, c5, c6, c7;

    for (pass = 0; pass < 4; ++pass)
     for (c1 = 0; c1 < pair_count; c1 += increment)
      for (c2 = c1 + 1 + random() % increment; c2 < pair_count; c2 += increment)
       for (c3 = c2 + 1 + random() % increment; c3 < pair_count; c3 += increment)
        for (c4 = c3 + 1 + random() % increment; c4 < pair_count; c4 += increment)
         for (c5 = c4 + 1 + random() % increment; c5 < pair_count; c5 += increment)
          for (c6 = c5 + 1 + random() % increment; c6 < pair_count; c6 += increment)
           for (c7 = c6 + 1 + random() % increment; c7 < pair_count; c7 += increment)
           {
               c2_sum =
                   count_pairs[c1].c2_count +
                   count_pairs[c2].c2_count +
                   count_pairs[c3].c2_count +
                   count_pairs[c4].c2_count +
                   count_pairs[c5].c2_count +
                   count_pairs[c6].c2_count +
                   count_pairs[c7].c2_count;
               c1_sum =
                   count_pairs[c1].c1_count +
                   count_pairs[c2].c1_count +
                   count_pairs[c3].c1_count +
                   count_pairs[c4].c1_count +
                   count_pairs[c5].c1_count +
                   count_pairs[c6].c1_count +
                   count_pairs[c7].c1_count;
               fc = c2_sum / c1_sum;
               if ( fc >= observed_fc ) ++fc_ge;
               else if ( fc <= 1.0 / observed_fc ) ++fc_le;
               ++count;
           }
    if ( Debug )
	printf("FCs > %0.3f = %-5lu     FCs < %0.3f = %-5lu\n",
		observed_fc, fc_ge, 1.0 / observed_fc, fc_le);
    *fc_count = count;
    
    return fc_ge + fc_le;
}

const extern int    Debug;

/*
 *  Generate all combinations n choose 8 and count FCs >= observed.
 *  This is much faster than generic algorithms for generating n choose
 *  k lists for any n and k.
 */

unsigned long   extreme_fcs8(count_pair_t count_pairs[], unsigned long pair_count,
			double observed_fc,
			unsigned long *fc_count)

{
    // Using sample++ % sample_rate doesn't produce much gain
    // Go after loop increments instead
    unsigned long   fc_ge = 0, fc_le = 0,
		    increment = 12, pass, count = 0;
    double          c2_sum, c1_sum, fc;
    
    unsigned long  c1, c2, c3, c4, c5, c6, c7, c8;

    for (pass = 0; pass < 6; ++pass)
     for (c1 = 0; c1 < pair_count; c1 += increment)
      for (c2 = c1 + 1 + random() % increment; c2 < pair_count; c2 += increment)
       for (c3 = c2 + 1 + random() % increment; c3 < pair_count; c3 += increment)
        for (c4 = c3 + 1 + random() % increment; c4 < pair_count; c4 += increment)
         for (c5 = c4 + 1 + random() % increment; c5 < pair_count; c5 += increment)
          for (c6 = c5 + 1 + random() % increment; c6 < pair_count; c6 += increment)
           for (c7 = c6 + 1 + random() % increment; c7 < pair_count; c7 += increment)
            for (c8 = c7 + 1 + random() % increment; c8 < pair_count; c8 += increment)
            {
                c2_sum =
                    count_pairs[c1].c2_count +
                    count_pairs[c2].c2_count +
                    count_pairs[c3].c2_count +
                    count_pairs[c4].c2_count +
                    count_pairs[c5].c2_count +
                    count_pairs[c6].c2_count +
                    count_pairs[c7].c2_count +
                    count_pairs[c8].c2_count;
                c1_sum =
                    count_pairs[c1].c1_count +
                    count_pairs[c2].c1_count +
                    count_pairs[c3].c1_count +
                    count_pairs[c4].c1_count +
                    count_pairs[c5].c1_count +
                    count_pairs[c6].c1_count +
                    count_pairs[c7].c1_count +
                    count_pairs[c8].c1_count;
                fc = c2_sum / c1_sum;
                if ( fc >= observed_fc ) ++fc_ge;
                else if ( fc <= 1.0 / observed_fc ) ++fc_le;
                ++count;
            }
    if ( Debug )
	printf("FCs > %0.3f = %-5lu     FCs < %0.3f = %-5lu\n",
		observed_fc, fc_ge, 1.0 / observed_fc, fc_le);
    *fc_count = count;
    
    return fc_ge + fc_le;
}

const extern int    Debug;

/*
 *  Generate all combinations n choose 9 and count FCs >= observed.
 *  This is much faster than generic algorithms for generating n choose
 *  k lists for any n and k.
 */

unsigned long   extreme_fcs9(count_pair_t count_pairs[], unsigned long pair_count,
			double observed_fc,
			unsigned long *fc_count)

{
    // Using sample++ % sample_rate doesn't produce much gain
    // Go after loop increments instead
    unsigned long   fc_ge = 0, fc_le = 0,
		    increment = 17, pass, count = 0;
    double          c2_sum, c1_sum, fc;
    
    unsigned long  c1, c2, c3, c4, c5, c6, c7, c8, c9;

    for (pass = 0; pass < 12; ++pass)
     for (c1 = 0; c1 < pair_count; c1 += increment)
      for (c2 = c1 + 1 + random() % increment; c2 < pair_count; c2 += increment)
       for (c3 = c2 + 1 + random() % increment; c3 < pair_count; c3 += increment)
        for (c4 = c3 + 1 + random() % increment; c4 < pair_count; c4 += increment)
         for (c5 = c4 + 1 + random() % increment; c5 < pair_count; c5 += increment)
          for (c6 = c5 + 1 + random() % increment; c6 < pair_count; c6 += increment)
           for (c7 = c6 + 1 + random() % increment; c7 < pair_count; c7 += increment)
            for (c8 = c7 + 1 + random() % increment; c8 < pair_count; c8 += increment)
             for (c9 = c8 + 1 + random() % increment; c9 < pair_count; c9 += increment)
             {
                 c2_sum =
                     count_pairs[c1].c2_count +
                     count_pairs[c2].c2_count +
                     count_pairs[c3].c2_count +
                     count_pairs[c4].c2_count +
                     count_pairs[c5].c2_count +
                     count_pairs[c6].c2_count +
                     count_pairs[c7].c2_count +
                     count_pairs[c8].c2_count +
                     count_pairs[c9].c2_count;
                 c1_sum =
                     count_pairs[c1].c1_count +
                     count_pairs[c2].c1_count +
                     count_pairs[c3].c1_count +
                     count_pairs[c4].c1_count +
                     count_pairs[c5].c1_count +
                     count_pairs[c6].c1_count +
                     count_pairs[c7].c1_count +
                     count_pairs[c8].c1_count +
                     count_pairs[c9].c1_count;
                 fc = c2_sum / c1_sum;
                 if ( fc >= observed_fc ) ++fc_ge;
                 else if ( fc <= 1.0 / observed_fc ) ++fc_le;
                 ++count;
             }
    if ( Debug )
	printf("FCs > %0.3f = %-5lu     FCs < %0.3f = %-5lu\n",
		observed_fc, fc_ge, 1.0 / observed_fc, fc_le);
    *fc_count = count;
    
    return fc_ge + fc_le;
}

const extern int    Debug;

/*
 *  Generate all combinations n choose 10 and count FCs >= observed.
 *  This is much faster than generic algorithms for generating n choose
 *  k lists for any n and k.
 */

unsigned long   extreme_fcs10(count_pair_t count_pairs[], unsigned long pair_count,
			double observed_fc,
			unsigned long *fc_count)

{
    // Using sample++ % sample_rate doesn't produce much gain
    // Go after loop increments instead
    unsigned long   fc_ge = 0, fc_le = 0,
		    increment = 22, pass, count = 0;
    double          c2_sum, c1_sum, fc;
    
    unsigned long  c1, c2, c3, c4, c5, c6, c7, c8, c9, c10;

    for (pass = 0; pass < 12; ++pass)
     for (c1 = 0; c1 < pair_count; c1 += increment)
      for (c2 = c1 + 1 + random() % increment; c2 < pair_count; c2 += increment)
       for (c3 = c2 + 1 + random() % increment; c3 < pair_count; c3 += increment)
        for (c4 = c3 + 1 + random() % increment; c4 < pair_count; c4 += increment)
         for (c5 = c4 + 1 + random() % increment; c5 < pair_count; c5 += increment)
          for (c6 = c5 + 1 + random() % increment; c6 < pair_count; c6 += increment)
           for (c7 = c6 + 1 + random() % increment; c7 < pair_count; c7 += increment)
            for (c8 = c7 + 1 + random() % increment; c8 < pair_count; c8 += increment)
             for (c9 = c8 + 1 + random() % increment; c9 < pair_count; c9 += increment)
              for (c10 = c9 + 1 + random() % increment; c10 < pair_count; c10 += increment)
              {
                  c2_sum =
                      count_pairs[c1].c2_count +
                      count_pairs[c2].c2_count +
                      count_pairs[c3].c2_count +
                      count_pairs[c4].c2_count +
                      count_pairs[c5].c2_count +
                      count_pairs[c6].c2_count +
                      count_pairs[c7].c2_count +
                      count_pairs[c8].c2_count +
                      count_pairs[c9].c2_count +
                      count_pairs[c10].c2_count;
                  c1_sum =
                      count_pairs[c1].c1_count +
                      count_pairs[c2].c1_count +
                      count_pairs[c3].c1_count +
                      count_pairs[c4].c1_count +
                      count_pairs[c5].c1_count +
                      count_pairs[c6].c1_count +
                      count_pairs[c7].c1_count +
                      count_pairs[c8].c1_count +
                      count_pairs[c9].c1_count +
                      count_pairs[c10].c1_count;
                  fc = c2_sum / c1_sum;
                  if ( fc >= observed_fc ) ++fc_ge;
                  else if ( fc <= 1.0 / observed_fc ) ++fc_le;
                  ++count;
              }
    if ( Debug )
	printf("FCs > %0.3f = %-5lu     FCs < %0.3f = %-5lu\n",
		observed_fc, fc_ge, 1.0 / observed_fc, fc_le);
    *fc_count = count;
    
    return fc_ge + fc_le;
}

const extern int    Debug;

/*
 *  Generate all combinations n choose 11 and count FCs >= observed.
 *  This is much faster than generic algorithms for generating n choose
 *  k lists for any n and k.
 */

unsigned long   extreme_fcs11(count_pair_t count_pairs[], unsigned long pair_count,
			double observed_fc,
			unsigned long *fc_count)

{
    // Using sample++ % sample_rate doesn't produce much gain
    // Go after loop increments instead
    unsigned long   fc_ge = 0, fc_le = 0,
		    increment = 26, pass, count = 0;
    double          c2_sum, c1_sum, fc;
    
    unsigned long  c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11;

    for (pass = 0; pass < 8; ++pass)
     for (c1 = 0; c1 < pair_count; c1 += increment)
      for (c2 = c1 + 1 + random() % increment; c2 < pair_count; c2 += increment)
       for (c3 = c2 + 1 + random() % increment; c3 < pair_count; c3 += increment)
        for (c4 = c3 + 1 + random() % increment; c4 < pair_count; c4 += increment)
         for (c5 = c4 + 1 + random() % increment; c5 < pair_count; c5 += increment)
          for (c6 = c5 + 1 + random() % increment; c6 < pair_count; c6 += increment)
           for (c7 = c6 + 1 + random() % increment; c7 < pair_count; c7 += increment)
            for (c8 = c7 + 1 + random() % increment; c8 < pair_count; c8 += increment)
             for (c9 = c8 + 1 + random() % increment; c9 < pair_count; c9 += increment)
              for (c10 = c9 + 1 + random() % increment; c10 < pair_count; c10 += increment)
               for (c11 = c10 + 1 + random() % increment; c11 < pair_count; c11 += increment)
               {
                   c2_sum =
                       count_pairs[c1].c2_count +
                       count_pairs[c2].c2_count +
                       count_pairs[c3].c2_count +
                       count_pairs[c4].c2_count +
                       count_pairs[c5].c2_count +
                       count_pairs[c6].c2_count +
                       count_pairs[c7].c2_count +
                       count_pairs[c8].c2_count +
                       count_pairs[c9].c2_count +
                       count_pairs[c10].c2_count +
                       count_pairs[c11].c2_count;
                   c1_sum =
                       count_pairs[c1].c1_count +
                       count_pairs[c2].c1_count +
                       count_pairs[c3].c1_count +
                       count_pairs[c4].c1_count +
                       count_pairs[c5].c1_count +
                       count_pairs[c6].c1_count +
                       count_pairs[c7].c1_count +
                       count_pairs[c8].c1_count +
                       count_pairs[c9].c1_count +
                       count_pairs[c10].c1_count +
                       count_pairs[c11].c1_count;
                   fc = c2_sum / c1_sum;
                   if ( fc >= observed_fc ) ++fc_ge;
                   else if ( fc <= 1.0 / observed_fc ) ++fc_le;
                   ++count;
               }
    if ( Debug )
	printf("FCs > %0.3f = %-5lu     FCs < %0.3f = %-5lu\n",
		observed_fc, fc_ge, 1.0 / observed_fc, fc_le);
    *fc_count = count;
    
    return fc_ge + fc_le;
}

const extern int    Debug;

/*
 *  Generate all combinations n choose 12 and count FCs >= observed.
 *  This is much faster than generic algorithms for generating n choose
 *  k lists for any n and k.
 */

unsigned long   extreme_fcs12(count_pair_t count_pairs[], unsigned long pair_count,
			double observed_fc,
			unsigned long *fc_count)

{
    // Using sample++ % sample_rate doesn't produce much gain
    // Go after loop increments instead
    unsigned long   fc_ge = 0, fc_le = 0,
		    increment = 30, pass, count = 0;
    double          c2_sum, c1_sum, fc;
    
    unsigned long  c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12;

    for (pass = 0; pass < 4; ++pass)
     for (c1 = 0; c1 < pair_count; c1 += increment)
      for (c2 = c1 + 1 + random() % increment; c2 < pair_count; c2 += increment)
       for (c3 = c2 + 1 + random() % increment; c3 < pair_count; c3 += increment)
        for (c4 = c3 + 1 + random() % increment; c4 < pair_count; c4 += increment)
         for (c5 = c4 + 1 + random() % increment; c5 < pair_count; c5 += increment)
          for (c6 = c5 + 1 + random() % increment; c6 < pair_count; c6 += increment)
           for (c7 = c6 + 1 + random() % increment; c7 < pair_count; c7 += increment)
            for (c8 = c7 + 1 + random() % increment; c8 < pair_count; c8 += increment)
             for (c9 = c8 + 1 + random() % increment; c9 < pair_count; c9 += increment)
              for (c10 = c9 + 1 + random() % increment; c10 < pair_count; c10 += increment)
               for (c11 = c10 + 1 + random() % increment; c11 < pair_count; c11 += increment)
                for (c12 = c11 + 1 + random() % increment; c12 < pair_count; c12 += increment)
                {
                    c2_sum =
                        count_pairs[c1].c2_count +
                        count_pairs[c2].c2_count +
                        count_pairs[c3].c2_count +
                        count_pairs[c4].c2_count +
                        count_pairs[c5].c2_count +
                        count_pairs[c6].c2_count +
                        count_pairs[c7].c2_count +
                        count_pairs[c8].c2_count +
                        count_pairs[c9].c2_count +
                        count_pairs[c10].c2_count +
                        count_pairs[c11].c2_count +
                        count_pairs[c12].c2_count;
                    c1_sum =
                        count_pairs[c1].c1_count +
                        count_pairs[c2].c1_count +
                        count_pairs[c3].c1_count +
                        count_pairs[c4].c1_count +
                        count_pairs[c5].c1_count +
                        count_pairs[c6].c1_count +
                        count_pairs[c7].c1_count +
                        count_pairs[c8].c1_count +
                        count_pairs[c9].c1_count +
                        count_pairs[c10].c1_count +
                        count_pairs[c11].c1_count +
                        count_pairs[c12].c1_count;
                    fc = c2_sum / c1_sum;
                    if ( fc >= observed_fc ) ++fc_ge;
                    else if ( fc <= 1.0 / observed_fc ) ++fc_le;
                    ++count;
                }
    if ( Debug )
	printf("FCs > %0.3f = %-5lu     FCs < %0.3f = %-5lu\n",
		observed_fc, fc_ge, 1.0 / observed_fc, fc_le);
    *fc_count = count;
    
    return fc_ge + fc_le;
}


unsigned long   extreme_fcs_count(count_pair_t count_pairs[], unsigned long pair_count,
		      unsigned long replicates, double observed_fc,
		      unsigned long *fc_count)

{
    static unsigned long (*extreme_fcs_funcs[])(count_pair_t count_pairs[],
				    unsigned long pair_count,
				    double observed_fc,
				    unsigned long *fc_count) =
    {
        extreme_fcs2,
        extreme_fcs3,
        extreme_fcs4,
        extreme_fcs5,
        extreme_fcs6,
        extreme_fcs7,
        extreme_fcs8,
        extreme_fcs9,
        extreme_fcs10,
        extreme_fcs11,
        extreme_fcs12
    };
    unsigned long  func_index = replicates - 2;
    
    return extreme_fcs_funcs[func_index](count_pairs, pair_count,
				   observed_fc, fc_count);
}
