# Code of Conduct

## Introduction

Exercism is a platform centered around empathetic conversation.
We have a low tolerance for communication that makes anyone feel unwelcome, unsupported, insulted or discriminated against.

## Seen or experienced something uncomfortable?

If you see or experience abuse, harassment, discrimination, or feel unsafe or upset, please email [abuse@exercism.org](mailto:abuse@exercism.org?subject=%5BCoC%5D) and include \[CoC\] in the subject line.
We will follow up with you as a priority.

## Enforcement

We actively monitor for Code of Conduct (CoC) violations and take any reports of violations extremely seriously.
We have banned contributors, mentors and users due to violations.

After we receive a report of a CoC violation, we view that person's conversation history on Exercism and related communication channels and attempt to understand whether someone has deliberately broken the CoC, or accidentally crossed a line.
We generally reach out to the person who has been reported to discuss any concerns we have and warn them that repeated violations will result in a ban.
Sometimes we decide that no violation has occurred and that no action is required and sometimes we will also ban people on a first offense.
We strive to be fair, but will err on the side of protecting the culture of our community.

Exercism's leadership reserve the right to take whatever action they feel appropriate with regards to CoC violations.

## The simple version

- Be empathetic
- Be welcoming
- Be kind
- Be honest
- Be supportive
- Be polite

## The details

Exercism should be a safe place for everybody regardless of

- Gender, gender identity or gender expression
- Sexual orientation
- Disability
- Physical appearance (including but not limited to body size)
- Race
- Age
- Religion
- Anything else you can think of

As someone who is part of this community, you agree that:

- We are collectively and individually committed to safety and inclusivity
- We have zero tolerance for abuse, harassment, or discrimination
- We respect people’s boundaries and identities
- We refrain from using language that can be considered offensive or oppressive (systemically or otherwise), eg. sexist, racist, homophobic, transphobic, ableist, classist, etc.
  - this includes (but is not limited to) various slurs.
- We avoid using offensive topics as a form of humor

We actively work towards:

- Being a safe community
- Cultivating a network of support & encouragement for each other
- Encouraging responsible and varied forms of expression

We condemn:

- Stalking, doxxing, or publishing private information
- Violence, threats of violence or violent language
- Anything that compromises people’s safety
- Conduct or speech which might be considered sexist, racist, homophobic, transphobic, ableist or otherwise discriminatory or offensive in nature
- The use of unwelcome, suggestive, derogatory or inappropriate nicknames or terms
- Disrespect towards others (jokes, innuendo, dismissive attitudes) and towards differences of opinion
- Intimidation or harassment (online or in-person).
  Please read the [Citizen Code of Conduct](https://github.com/stumpsyn/policies/blob/master/citizen_code_of_conduct.md) for how we interpret harassment
- Inappropriate attention or contact
- Not understanding the differences between constructive criticism and disparagement

These things are NOT OK.

Be aware of how your actions affect others.
If it makes someone uncomfortable, stop.

If you say something that is found offensive, and you are called out on it, try to:

- Listen without interruption
- Believe what the person is saying & do not attempt to disqualify what they have to say
- Ask for tips / help with avoiding making the offense in the future
- Apologize and ask forgiveness

## History

This policy was initially adopted from the Front-end London Slack community and has been modified since.
A version history can be seen on [GitHub](https://github.com/exercism/website-copy/edit/main/pages/code_of_conduct.md).

_This policy is a "living" document, and subject to refinement and expansion in the future.
This policy applies to the Exercism website, the Exercism GitHub organization, any other Exercism-related communication channels (e.g. Discord, Forum, Twitter, email) and any other Exercism entity or event._
