/* eLectrix - a pdf viewer
 * Copyright (C) 2011 Martin Linder <mali2297@users.sf.net>
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/gpl-2.0.html>.
 */
#pragma once
#ifndef __E6X_ATT_VIEW_H__
#define __E6X_ATT_VIEW_H__

#include <gtk/gtk.h>
#include "e6x-document.h"

#define E6X_TYPE_ATT_VIEW \
  (e6x_att_view_get_type ())
#define E6X_ATT_VIEW(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), E6X_TYPE_ATT_VIEW, E6xAttView))
#define E6X_ATT_VIEW_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_CAST ((obj), E6X_TYPE_ATT_VIEW,  E6xAttViewClass))
#define E6X_IS_ATT_VIEW(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), E6X_TYPE_ATT_VIEW))
#define E6X_IS_ATT_VIEW_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE ((obj), E6X_TYPE_ATT_VIEW))
#define E6X_ATT_VIEW_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), E6X_TYPE_ATT_VIEW, E6xAttViewClass))

typedef struct _E6xAttView E6xAttView;
typedef struct _E6xAttViewClass E6xAttViewClass;
typedef struct _E6xAttViewPrivate E6xAttViewPrivate;

struct _E6xAttView
{
  GtkTreeView parent;
  E6xAttViewPrivate *priv;
};

struct _E6xAttViewClass
{
  GtkTreeViewClass parent_class;
};

GType e6x_att_view_get_type ();
GtkWidget *e6x_att_view_new (E6xDocument *doc);
void e6x_att_view_set_document (E6xAttView *view, 
                                E6xDocument *doc);
gboolean e6x_att_view_open_selected (E6xAttView *view);
gboolean e6x_att_view_save_selected (E6xAttView *view);

#endif /* __E6X_ATT_VIEW_H__ */
