/*
 *  statusbar.c
 *
 *  (c) 2001-2003 Tim-Philipp Muller <t.i.m@orange.net>
 *
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <string.h>

#include "global.h"
#include "colors.h"
#include "mainwindow.h"
#include "misc_strings.h"
#include "statusbar.h"

#include <gtk/gtkstatusbar.h>

static GtkWidget  *statusbar = NULL;
static gint        statusbar_msg_context = 0;  /* statusbars need that somehow */


/* functions */

static void        statusbar_msg_real (const gchar *msg);


/******************************************************************************
 *
 *   statusbar_msg_real
 *
 ***/

static void
statusbar_msg_real (const gchar *msg)
{
	gchar *utf8;

	g_return_if_fail ( msg != NULL);

	if ((!window) || (!statusbar))
		return;

	utf8 = TO_UTF8(msg);

	gtk_statusbar_pop (GTK_STATUSBAR(statusbar), statusbar_msg_context);
	gtk_statusbar_push (GTK_STATUSBAR(statusbar), statusbar_msg_context, utf8);

	/* if we had a two-line statusbar before, we want it to
	 * go back to one line again without switching pages... => resize
	 */

	gtk_container_set_resize_mode(GTK_CONTAINER(statusbar), GTK_RESIZE_IMMEDIATE);
	gtk_container_check_resize(GTK_CONTAINER(statusbar));

	FREE_UTF8(utf8);
}


/******************************************************************************
 *
 *   statusbar_msg
 *
 ***/

void
statusbar_msg (const gchar *format, ...)
{
	GString	*output = NULL;
	gchar	*s_alloc = NULL;
	va_list	 ap;

	g_return_if_fail (format!=NULL);

	va_start(ap, format);
	s_alloc = g_strdup_vprintf(format,ap);
	va_end(ap);

	output = g_string_new(s_alloc);
	g_return_if_fail (output!=NULL);

	/* make sure there's a space as first character -> looks nicer */
	if ( *s_alloc != ' ')
		output = g_string_prepend_c (output, ' ');

	if (format[strlen(format)-1] == '\n')
		output = g_string_truncate(output, output->len - 1);

	statusbar_msg_real (output->str);

	g_string_free(output,TRUE);
	g_free(s_alloc);
}

/******************************************************************************
 *
 *   statusbar_create
 *
 ***/

GtkWidget *
statusbar_create (void)
{
	statusbar = gtk_statusbar_new();

	gtk_widget_show (statusbar);

	statusbar_msg_context = gtk_statusbar_get_context_id (GTK_STATUSBAR(statusbar), "msg");

	return statusbar;
}


/******************************************************************************
 *
 *   statusbar_set_styles
 *
 ***/

void
statusbar_set_styles (void)
{
	set_style_recursively (statusbar, style_dark_green_background);
}



