/***************************************************************************
                          ramfile.h  -  description
                             -------------------
    begin                : Fri Apr 26 2002
    copyright            : (C) 2002 by Tim-Philipp Mller
    email                : t.i.m@orange.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _ed2k_gui_ramfile_h_included_
#define _ed2k_gui_ramfile_h_included_

#include <glib.h>


struct _ramfile
{
	gsize 		 size;     	/* current size of data in bytes */
	gsize 		 allocated;	/* amount of bytes allocated     */
	guint 		 pos;      	/* current byte position         */
	guint8		*data;     	/* data buffer                   */
} ;


typedef struct _ramfile ramfile;

typedef enum
{
 RAMFILE_SEEK_FROM_HERE=1,
 RAMFILE_SEEK_FROM_START,
 RAMFILE_SEEK_FROM_END
} GuiRamfileSeekType;

/* functions */

ramfile * ramfile_new (guint len);
ramfile * ramfile_new_from_file (const gchar *filename);
void      ramfile_free (ramfile *rf);
guint8    ramfile_read8  (ramfile *rf);
guint16   ramfile_read16 (ramfile *rf);
guint32   ramfile_read32 (ramfile *rf);
gfloat    ramfile_readfloat (ramfile *rf);
guint8 *  ramfile_read (ramfile *rf, guint8 *buf, gint len);
guint8 *  ramfile_peek (ramfile *rf, guint8 *buf, gint pos, gint len);
void      ramfile_write8  (ramfile *rf, guint8 val);
void      ramfile_write16 (ramfile *rf, guint16 val);
void      ramfile_write32 (ramfile *rf, guint32 val);
void      ramfile_writefloat (ramfile *rf, gfloat val);
void      ramfile_write   (ramfile *rf, const guint8 *buf, gint len);
void      ramfile_write_i4_string (ramfile *rf, const gchar *string);
gchar *   ramfile_read_i4_string (ramfile *rf);
gboolean  ramfile_seek (ramfile *rf, gint inc, GuiRamfileSeekType seektype);
void      ramfile_dump (const ramfile *rf, const gchar *infostring);

const guint8 *ramfile_get_hash (ramfile *rf); /* CAREFUL! return value only valid until ramfile is changed */

gsize     ramfile_get_size (ramfile *rf); /* CAREFUL! this is the RAMFILE SIZE, not the packet data size (ie.+5) */
guint8*   ramfile_get_buffer(ramfile *rf);
gint      ramfile_get_pos (ramfile *rf); /* CAREFUL! don't compare directly with ramfile_get_size! */
void      ramfile_set_pos (ramfile *rf, guint newpos);

/* the ip is already in network byte order - we don't want it to be changed to
 *  some other order by ramfile_write32 if platform is not little endian
 *
 **/

#define ramfile_writeIP(rf,ip) ramfile_write32(rf,GINT32_FROM_LE(ip))
#define ramfile_readIP(rf)     GINT32_TO_LE(ramfile_read32(rf))

#endif


