
/***************************************************************************
                          progressbar-renderer.h
                          ----------------------
    begin                : Mon Oct 6 2003
    copyright            : (C) 2003 by Tim-Philipp Mller
    email                : t.i.m at orange dot net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _progressbar_renderer_h_included_
#define _progressbar_renderer_h_included_

#include <gtk/gtkcellrenderer.h>

/* Some boilerplate GObject type check and type cast macros */

#define GUI_TYPE_CELL_RENDERER_PROGRESS             (gui_cell_renderer_progress_get_type())
#define GUI_CELL_RENDERER_PROGRESS(obj)             (G_TYPE_CHECK_INSTANCE_CAST((obj),  GUI_TYPE_CELL_RENDERER_PROGRESS, GuiCellRendererProgress))
#define GUI_CELL_RENDERER_PROGRESS_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass),  GUI_TYPE_CELL_RENDERER_PROGRESS, GuiCellRendererProgressClass))
#define GUI_IS_CELL_RENDERER_PROGRESS(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GUI_TYPE_CELL_RENDERER_PROGRESS))
#define GUI_IS_CELL_RENDERER_PROGRESS_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass),  GUI_TYPE_CELL_RENDERER_PROGRESS))
#define GUI_CELL_RENDERER_PROGRESS_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj),  GUI_TYPE_CELL_RENDERER_PROGRESS, GuiCellRendererProgressClass))

#define GAPSTATUS_ASKED              1000
#define GAPSTATUS_FILLED             2000

enum
{
 PROGRESSBAR_PEN_PAUSED = 0,
 PROGRESSBAR_PEN_GOT_IT,
 PROGRESSBAR_PEN_NOT_AVAILABLE,
 PROGRESSBAR_PEN_ASKED_FOR,
 PROGRESSBAR_PEN_AVAILABLE_MORE_THAN_128,
 PROGRESSBAR_PEN_AVAILABLE_MORE_THAN_64,
 PROGRESSBAR_PEN_AVAILABLE_MORE_THAN_32,
 PROGRESSBAR_PEN_AVAILABLE_MORE_THAN_16,
 PROGRESSBAR_PEN_AVAILABLE_MORE_THAN_8,
 PROGRESSBAR_PEN_AVAILABLE_MORE_THAN_4,
 PROGRESSBAR_PEN_AVAILABLE_MORE_THAN_2,
 PROGRESSBAR_PEN_AVAILABLE,
 PROGRESSBAR_PENS_N
} ;

struct _progressbarGap
{
	guint32  start;
	guint32  end;
	guint16  status;

	gfloat   startrel; /* start / filesize */
	gfloat   endrel;   /* end   / filesize */
	gfloat   widthrel;
};

typedef struct _progressbarGap progressbarGap;


typedef struct _GuiCellRendererProgress         GuiCellRendererProgress;
typedef struct _GuiCellRendererProgressClass    GuiCellRendererProgressClass;

/* GuiCellRendererProgress: Our custom cell renderer structure */

struct _GuiCellRendererProgress
{
  GtkCellRenderer         parent;

  const progressbarGap   *gaplist;  /* pointer to NULL-terminated array of gaps */
	gboolean                paused;   /* draw in 'paused' colours (grey)          */

  gboolean                brushes_initialised;

  GdkGC                  *progressbar_pens_green[PROGRESSBAR_PENS_N];        /* all NULL */
  GdkGC                  *progressbar_pens_blue [PROGRESSBAR_PENS_N];        /* all NULL */
  GdkGC                 **progressbar_pens;                                  /* NULL     */

};

struct _GuiCellRendererProgressClass
{
  GtkCellRendererClass  parent_class;
};

GType                gui_cell_renderer_progress_get_type (void);

GtkCellRenderer     *gui_cell_renderer_progress_new (void);


#endif /* _progressbar_renderer_h_included_ */



