/*
*  http_get.h for ed2k_gui
*
*  GET HTML PAGE (SERVERLIST) VIA HTTP PROTOCOL
*
* (c) 2001 TP Muller <t.i.m@orange.net>
*/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _ED2K_GUI_HTTP_GET_H_INCLUDED_
#define _ED2K_GUI_HTTP_GET_H_INCLUDED_

#include <glib.h>

#define MAX_NUMBER_OF_REDIRECTIONS	3

/* we need this auxiliary structure, becauser we can only
 * pass one user_data pointer to the callback function
 */

struct http_get_callback_data
{
	gchar          *getstring;	// contains the GET request to send.
	gchar          *buf;	
	gint               bufsize, contentlength, headerlength;
	gboolean      clearserverlist;
	gchar            readbuf[2048];
	gboolean      using_httpproxy;
	gint               redirections;
} ;

enum
{
       OK = 0,         /* Must be 1st element in list */
       PRIVATE,        /* see RFCs 1918, 1466, 2544, 3068, 3330 */
       MULTICAST,
       T_H_I_S,        /* 'THIS' will confuse the mingw cross-compile due to some windows includes */
       TEST_NET,
       ANYCAST_6TO4,
       LINK_LOCAL,
       MEDIA_FORCE,    /* evil */
       MEDIA_DEFENDER,
       CYVEILLANCE,
       BAY_TSP,
};

struct net_range
{
	unsigned char mask;
	unsigned int  addx;
	unsigned int  type;
};

extern struct net_range net_list[];	/* why do we need this global? */

void      http_get_retrieve_serverlist (const gchar *url, guint redirections);

gint      extract_server_links (const gchar *pagebuf, gboolean clear_serverlist);

gint      extract_ed2k_links (const gchar *page_utf8);


#endif
