/********************************************************************
 *                                                                  *
 *                GUI <--->  Core protocol                          *
 *                                                                  *
 *                                                                  *
 *  Last updated: 14 August 2003, core v0.50                        *
 *                                                                  *
 *  Note: this documentation might not be completely up-to-date     *
 *        You should always look at the implementation in           *
 *        send_message.c and parse_message.c (as ugly as they       *
 *        might look like). The implementation is the true          *
 *        reference ;)                                              *
 *                                                                  *
 ********************************************************************/


#ifndef ed2k_gui_gui_core_protocol_h_included
#define ed2k_gui_gui_core_protocol_h_included

enum
{
  /* CORE => GUI */

  CORE_SERVER_LIST           = 170,
  CORE_FRIEND_LIST           = 171,
  CORE_SHARED_DIRS           = 172,
  CORE_SHARED_FILES          = 173,
  CORE_DOWNLOAD_GAP_DETAILS  = 174,
  CORE_CLIENT_STATS          = 175,
  CORE_STATUS_MSG            = 180,
  CORE_ERROR_MSG             = 181,
  CORE_CONNECTED_TO          = 182,
  CORE_DISCONNECTED          = 183,
  CORE_SET_SERVER_STATS      = 184,
  CORE_EXTENDING_SEARCH      = 185,
  CORE_SEARCH_RESULT         = 186,
  CORE_NEW_SEARCH_RESULTS    = 187,
  CORE_NEW_DOWNLOAD          = 188,
  CORE_REMOVE_DOWNLOAD       = 189,
  CORE_NEW_UPLOAD            = 190, /* DEPRECATED since core v0.45 */
  CORE_REMOVE_UPLOAD         = 191, /* DEPRECATED since core v0.45 */
  CORE_NEW_UPLOAD_SLOT       = 192, /* DEPRECATED since core v0.45 */
  CORE_REMOVE_UPLOAD_SLOT    = 193, /* DEPRECATED since core v0.45 */
  CORE_USER_FILES            = 194,
  CORE_HASHING               = 195,
  CORE_FRIEND_LIST_UPDATE    = 196,
  CORE_DOWNLOAD_STATUS       = 197,
  CORE_UPLOAD_STATUS         = 198,
  CORE_OPTIONS               = 199,
  CORE_UPLOAD_SLOT_STATUS    = 200,
  CORE_CHANGE_UPLOAD_SLOT    = 201,

  /* GUI => CORE */

  CONT_LOGIN                 = 100,
  CONT_STOP                  = 101,
  CONT_CMD                   = 102,
  GUI_CONNECT                = 200,
  GUI_DISCONNECT             = 201,
  GUI_SEARCH                 = 202,
  GUI_EXSEARCH               = 203,
  GUI_MORESEARCH             = 204,
  GUI_SEARCH_USER            = 205,    /* not implemented */
  GUI_EXSEARCH_USER          = 206,    /* not implemented */
  GUI_DOWNLOAD               = 207,    /* new download from search results; we use GUI_NEW_DOWNLOAD instead */
  GUI_PAUSE_DOWNLOAD         = 208,
  GUI_RESUME_DOWNLOAD        = 209,
  GUI_CANCEL_DOWNLOAD        = 210,
  GUI_SETPRI_DOWNLOAD        = 211,
  GUI_VIEW_FRIEND_FILES      = 212,
  GUI_GET_SERVERLIST         = 213,
  GUI_GET_FRIENDLIST         = 214,
  GUI_GET_SHARE_DIRS         = 215,
  GUI_SET_SHARE_DIRS         = 216,
  GUI_START_DL_STATUS        = 217,
  GUI_STOP_DL_STATUS         = 218,
  GUI_START_UL_STATUS        = 219,
  GUI_STOP_UL_STATUS         = 220,
  GUI_DELETE_SERVER          = 221,
  GUI_ADD_SERVER             = 222,
  GUI_SETPRI_SERVER          = 223,
  GUI_GET_SHARE_FILES        = 224,
  GUI_GET_OPTIONS            = 225,
  GUI_NEW_DOWNLOAD           = 226,
  GUI_GET_DOWNLOAD_GAP_DETAILS =  227,
  GUI_GET_CLIENT_STATS       = 228,
  GUI_SET_UPLOAD_PRIORITY    = 229,
  CORE_ED_NEW_SEARCH_RESULT  = 145, /* cdonkey only */
  CORE_ED_SEARCH_RESULT      = 146, /* cdonkey only */

} ;



#if 0
/*

 ********************************************************************
 *                                                                  *
 *                  Basics: packet format                           *
 *                                                                  *
 ********************************************************************

GUI and core exchange messages in forms of packets

Each packet consists of:
  * 5 bytes header
  * x bytes payload (at least 1 byte)

Header format:
  1 byte:   0xe3 = 227   header byte
  4 bytes:  length of payload data to follow (little endian integer)

Payload:
  1 byte:   message byte
  x bytes:  optional data that goes with the message


 ********************************************************************
 *                                                                  *
 *                  Basics: data types                              *
 *                                                                  *
 ********************************************************************

 w8:  one byte integer (usually unsigned)
 w16: 16-bit integer (little endian, usually unsigned)
 w32: 32-bit integer (little endian, usually unsigned)

hash:
 16 bytes

string = i4str:
  w16:     string length
  x bytes: string (not zero-terminated) (note that edonkey/overnet
           has absolutely no locale-awareness or so, so it is hard to
           say what character encoding you get. It is usually either
           ASCII or the locale, but search result filenames might be
           encoded in any encoding really (whatever the locale of the
           user who published that file was) *sigh*

taglist:
  w16:  number of tags
  for each tag:
    see implementation in tag.[ch]
    (first byte = tag type)
     metaTagInt
     metaTagString
     metaTagFloat
     metaTagHash


metalist:
  w16:  meta items to follow
  X meta items

meta item:
  X bytes of context-dependent data (see implementation)
  taglist

serverIDs/IPs:
  are in little endian order, not in network order.
  on MacOSX this is undefined (not sure what we get there) - and
  interoperability between a big endian GUI and a little endian
  core (or vice versa) is pretty much not guarenteed. Use overnet
  in that case ;)


 ********************************************************************
 *                                                                  *
 *                  Messages CORE ---> GUI                          *
 *                                                                  *
 ********************************************************************

----------------------------------------------------------------------

 CORE_SERVER_LIST: core sends the server list

 filelist: server list

----------------------------------------------------------------------

 CORE_FRIEND_LIST: core sends friends list

 filelist: friend list

----------------------------------------------------------------------

 CORE_SHARED_DIRS: core sends list of shared directories

 w16:    num directories
 string: directory name (num times)

----------------------------------------------------------------------

 CORE_SHARED_FILES: core sends list of shared files

 filelist: shared files

----------------------------------------------------------------------

 CORE_DOWNLOAD_GAP_DETAILS: core sends one download s gap list

 16 bytes: hash
 w16: number of gaps

 for each gap:

   w32 gap start
   w32 gap end
   w16 gap status

----------------------------------------------------------------------

 CORE_CLIENT_STATS

 float: free space on temp drive in MB
 float: free space in incoming in MB
 float: space needed by downloads in MB
 w32:   client ID
 w16:   no. of connections used currently
 w16:   no. of people on queue

----------------------------------------------------------------------

 CORE_STATUS_MSG

 string: message

----------------------------------------------------------------------

 CORE_ERROR_MSG

 string: error message

----------------------------------------------------------------------

 CORE_CONNECTED_TO: we are connected to an eDonkey2000 server

 string: server name

----------------------------------------------------------------------

 CORE_DISCONNECTED: we have been disconnected from the last
                    edonkey2000 server we have been connected to
                    or that we have tried to connect to

----------------------------------------------------------------------

 CORE_SET_SERVER_STATS: server stats of the current eDonkey2000 server
                        or the Overnet network (for overnet the files
                        number is undefined)

 w32: files
 w32: users

----------------------------------------------------------------------

 CORE_EXTENDING_SEARCH

 string: server name

----------------------------------------------------------------------

 CORE_SEARCH_RESULT: here is one search result from an  extended
                     server, or an overnet search result.
                     Note: is is impossible to know how many of these
                     will be coming in and/or whether we have received
                     the last result.

 meta: result meta

----------------------------------------------------------------------

 CORE_NEW_SEARCH_RESULTS: search result list from the main eDonkey2000
                          server we are connected to (an overnet core
                          will never send this message)

 filelist: result list
 w8:       more results available (1) or not (0)

----------------------------------------------------------------------

 CORE_NEW_DOWNLOAD

 meta:     download file
 w8:       initial preference
 i4string: path to temp directory (used to be temp filename in older
           versions). Full temp file path is
           <temp dir>/<download name>/1.x.part

----------------------------------------------------------------------

 CORE_REMOVE_DOWNLOAD: a download has been removed from the download
                       list - either because it has been cancelled,
                       or because it has been completed. The only
                       sane assumption to make is that if the GUI
                       has not cancelled the download earlier, it
                       has been completed. There is no way at the
                       moment to know whether the download has been
                       corrupted or not, apart from parsing the
                       core status message strings. We _might_ get
                       a complete/corrupted download status, but
                       as we got those only every 3 secs or so, we
                       might not get one with the completed/corrupt
                       status. v50 should redownload corrupt chunks
                       in all cases, so a download should never be
                       corrupted if it is finished. In theory at least.

 hash: fileID
 w8:   set to '1' if download was cancelled, ie. if the file is 
                  not complete at the time the download was removed.

 NOTE: the final byte is not mandatory, the core does not yet send
       this (however, 'burrito', the multiple-GUIs-on-one-core
       multiplexer needs this)!

----------------------------------------------------------------------

 CORE_NEW_UPLOAD - DEPRECATED since core v0.45

 string: file name
 meta: upload user

----------------------------------------------------------------------

 CORE_REMOVE_UPLOAD - DEPRECATED since core v0.45

 hash: uploader/user ID

----------------------------------------------------------------------

 CORE_NEW_UPLOAD_SLOT - DEPRECATED since core v0.45

 w32:    slot ID
 string: uploader name

----------------------------------------------------------------------

 CORE_REMOVE_UPLOAD_SLOT  - DEPRECATED since core v0.45

 w32: slot ID

----------------------------------------------------------------------

 CORE_USER_FILES - is this implemented?

 filelist: users filelist

----------------------------------------------------------------------

 CORE_HASHING: core is hashing the following shared file

 string: filename

----------------------------------------------------------------------

 CORE_FRIEND_LIST_UPDATE: the friend list needs to be updated
                          (is this implemented in core?)

----------------------------------------------------------------------

 CORE_DOWNLOAD_STATUS: here is the status for every download in the list

 w16: number of downloads

 for each:
   w32:   unique download ID
   w8:    status
   float: current speed (kB/sec)
   w32:   ammount transfered
   w8:    % available
   w8:    num sources

----------------------------------------------------------------------

 CORE_UPLOAD_STATUS

 w16: number of uploads

 for each:                           TODO: check
   w16: uploadID
   float: current speed (kB/sec)

----------------------------------------------------------------------

 CORE_OPTIONS: here are the current options settings

 w16     clientversion
 float   max down
 float   max up
 w16     doorport
 w16     max connections
 string  nick name
 string  temp dir
 string  incoming dir
 w8      autoConnect     NOTE: always 0 no matter what (core bug)
 w8      unused
 w8      autoServRemove  NOTE: always 0 no matter what (core bug)
 w8      primsgallow
 w8      savecorrupt
 w8      verifyCancel
 w16     adminDoorPort
 w32     core build date (see implementation)
 float   line down speed

----------------------------------------------------------------------

 CORE_UPLOAD_SLOT_STATUS

  w16: number of uploads

  for each:
    w32:    slotID
    float: current speed (kB/sec)

----------------------------------------------------------------------

 CORE_CHANGE_UPLOAD_SLOT           201

 w32     upload slot ID
 i4str   filename
 user    meta
 w128    filehash

----------------------------------------------------------------------

 ********************************************************************
 *                                                                  *
 *                  Messages GUI ---> CORE                          *
 *                                                                  *
 ********************************************************************


----------------------------------------------------------------------

  CONT_LOGIN: authenticate GUI to core (Note: yes, this is all
              clear text *sigh*)

  string: username
  string: password

----------------------------------------------------------------------

  CONT_STOP: make the core shut down (Note: this works only if the
             core is not waiting for user input, ie. has been started
             with the  -  and  !  command line options. Otherwise it
             will only shut down after pressing enter in the core
             console)

----------------------------------------------------------------------

  CONT_CMD: send an  advanced command  to the core as if it was
            typed in on the core command line.

  string: commandline command

----------------------------------------------------------------------

  GUI_CONNECT: make the core try to connect to the specified
               eDonkey2000 server (which must be in the server list!)

 w32: server ID 0 for any server
 w16: server port

----------------------------------------------------------------------

  GUI_DISCONNECT: make core disconnect from current eDonkey2000 server

----------------------------------------------------------------------

  GUI_SEARCH: search for something (eDonkey2000 only; an Overnet
              core might crash on sending this message).

  search: the search (see implementation in send_command.c), which
          is basically a binary tree of search meta tags

----------------------------------------------------------------------

 GUI_EXSEARCH: extend search to one other server (eDonkey2000 only)

----------------------------------------------------------------------

 GUI_MORESEARCH: get another 200 search results from the main server
                 (eDonkey2000 only)

----------------------------------------------------------------------

 GUI_SEARCH_USER: search for users, instead of files (not implemented)

 search: the search

----------------------------------------------------------------------

 GUI_EXSEARCH_USER: as above, only on extended servers (not implemented)

----------------------------------------------------------------------

 GUI_DOWNLOAD: download from search results list (result must be
               among results. Use GUI_NEW_DOWNLOAD to start a
               download that is not in the search results list)

 hash: fileID

----------------------------------------------------------------------

 GUI_PAUSE_DOWNLOAD: pause a download

 hash: fileID

----------------------------------------------------------------------

 GUI_RESUME_DOWNLOAD: resume a download

 hash: fileID

----------------------------------------------------------------------

 GUI_CANCEL_DOWNLOAD: cancel a download

 hash: fileID

----------------------------------------------------------------------

 GUI_SETPRI_DOWNLOAD: set a download s priority (Note: we have to keep
                      track of priority changes ourselves. Problem is
                      only that the core might automatically set a
                      download to highest priority = hording, which we
                      will not know about then).

 hash: fileID
 w8: priority (0 low, 1 normal, 2 high) :  cdonkey hybrid search result TODO: check values; highest=?

----------------------------------------------------------------------

 GUI_VIEW_FRIEND_FILES: not implemented?!

----------------------------------------------------------------------

 GUI_GET_SERVERLIST: get serverlist from core (eDonkey2000 only)

----------------------------------------------------------------------

 GUI_GET_FRIENDLIST: not implemented?!

----------------------------------------------------------------------

 GUI_GET_SHARE_DIRS: get shared dirs list from core

----------------------------------------------------------------------

 GUI_SET_SHARE_DIRS: is this implemented? (I think not)

----------------------------------------------------------------------

 GUI_START_DL_STATUS: Tell the core to start sending the
                      status of the downloads regularly

----------------------------------------------------------------------

 GUI_STOP_DL_STATUS: stop sending the download status

----------------------------------------------------------------------

 GUI_START_UL_STATUS: start/stop sending the upload status
 GUI_STOP_UL_STATUS

----------------------------------------------------------------------

 GUI_DELETE_SERVER

 w32: serverID
 w16: server port

----------------------------------------------------------------------

 GUI_ADD_SERVER

 w32: serverID
 w16: server port

----------------------------------------------------------------------

 GUI_SETPRI_SERVER

 w32: serverID
 w16: server port
 w8:  preference (0-NORMAL, 1-HIGH, 2-LOW)

----------------------------------------------------------------------

 GUI_GET_SHARE_FILES

----------------------------------------------------------------------

 GUI_GET_OPTIONS

----------------------------------------------------------------------

 GUI_NEW_DOWNLOAD: start download from ed2k-link (hash + file size)

 w128:    hash
 w32+w16: unused
 taglist (i.e. at least filename+filesize)

----------------------------------------------------------------------

 GUI_GET_DOWNLOAD_GAP_DETAILS

 16 bytes: hash
 w16: number of gaps
 for each gap:
   w32 start
   w32 end
   w16 value

----------------------------------------------------------------------

 GUI_GET_CLIENT_STATS

 float - free space in tmp in MB
 float - free space in incoming in MB
 float - space needed in MB
 w32   - clientID
 w16   - current connections
 w16   - currently on queue

----------------------------------------------------------------------

 GUI_SET_UPLOAD_PRIORITY

 hash: filehash
 w8:   new priority

----------------------------------------------------------------------

 CORE_ED_NEW_SEARCH_RESULT:  cdonkey hybrid search result

 CORE_ED_SEARCH_RESULT:  cdonkey hybrid search result

 * cDonkey hybrid opcodes for search results: The following two opcodes
 *  are only used by cDonkey, which is a overnet/eDonkey hybrid.
 *
 * Codes are there to mark each client result in edonkey format
 *  (as opposed to overnet format)
 *

----------------------------------------------------------------------

*/

#endif


#endif


