/***************************************************************************
                            downloads-list.h
                            ----------------
    begin                : Wed Oct 1 2003
    copyright            : (C) 2003 by Tim-Philipp Mller
    email                : t.i.m at orange dot net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __GUI_DOWNLOADS_LIST_H__
#define __GUI_DOWNLOADS_LIST_H__

#include "downloads_attrib.h"
#include "progressbar-renderer.h"

#include <gtk/gtktreemodel.h>

#define GUI_TYPE_DOWNLOAD_LIST            (gui_download_list_get_type ())
#define GUI_DOWNLOAD_LIST(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GUI_TYPE_DOWNLOAD_LIST, GuiDownloadList))
#define GUI_DOWNLOAD_LIST_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GUI_TYPE_DOWNLOAD_LIST, GuiDownloadListClass))
#define GUI_IS_DOWNLOAD_LIST(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GUI_TYPE_DOWNLOAD_LIST))
#define GUI_IS_DOWNLOAD_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GUI_TYPE_DOWNLOAD_LIST))
#define GUI_DOWNLOAD_LIST_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GUI_TYPE_DOWNLOAD_LIST, GuiDownloadListClass))

enum
{
  GUI_DOWNLOAD_LIST_DOT = 0,
  GUI_DOWNLOAD_LIST_NAME,
  GUI_DOWNLOAD_LIST_SIZE_STR,
  GUI_DOWNLOAD_LIST_STATUS_STR,
  GUI_DOWNLOAD_LIST_TRANSFERED_STR,
  GUI_DOWNLOAD_LIST_LEFT_STR,
  GUI_DOWNLOAD_LIST_SPEED_STR,
  GUI_DOWNLOAD_LIST_TIME_LEFT_STR,
  GUI_DOWNLOAD_LIST_PRIORITY_STR,
  GUI_DOWNLOAD_LIST_GAPLIST,
  GUI_DOWNLOAD_LIST_PAUSED_BOOL,
  GUI_DOWNLOAD_LIST_SOURCES_STR,
  GUI_DOWNLOAD_LIST_LAST_DL_STR,
  GUI_DOWNLOAD_LIST_LAST_COMPLETE_STR,
  GUI_DOWNLOAD_LIST_TYPE_STR,
  GUI_DOWNLOAD_LIST_FORMAT_STR,

	GUI_DOWNLOAD_LIST_N_COLUMNS,
} ;

enum
{
  GUI_DOWNLOAD_SORT_ID_NONE,
  GUI_DOWNLOAD_SORT_ID_NAME,
  GUI_DOWNLOAD_SORT_ID_SIZE,
  GUI_DOWNLOAD_SORT_ID_STATUS,
  GUI_DOWNLOAD_SORT_ID_TRANSFERED,
  GUI_DOWNLOAD_SORT_ID_LEFT,
  GUI_DOWNLOAD_SORT_ID_SPEED,
  GUI_DOWNLOAD_SORT_ID_TIME_LEFT,
  GUI_DOWNLOAD_SORT_ID_PRIORITY,
  GUI_DOWNLOAD_SORT_ID_AVAILABILITY,
  GUI_DOWNLOAD_SORT_ID_SOURCES,
  GUI_DOWNLOAD_SORT_ID_LAST_DL,
  GUI_DOWNLOAD_SORT_ID_LAST_COMPLETE,
  GUI_DOWNLOAD_SORT_ID_TYPE,
  GUI_DOWNLOAD_SORT_ID_FORMAT,
} ;


enum
{
 STATUS_HASHING=0,
 STATUS_QUEUED=1,
 STATUS_LOOKING,
 STATUS_DOWNLOADING,
 STATUS_PAUSED,
 STATUS_IDS,
 STATUS_NOSRCS,
 STATUS_DONE,
 STATUS_HASHING2,
 STATUS_ERRLOADING,
 STATUS_COMPLETING,
 STATUS_COMPLETE,
 STATUS_CORRUPTED,
 STATUS_ERRHASHING,
 STATUS_TRANSFERRING,
 STATUS_RESUMING,
 STATUS_PAUSING,
 STATUS_CANCELLING,
 STATUS_LAST
} ;	/* RESUMING, PAUSING, and CANCELLING are GUI status only */


enum
{
 DL_PRIO_LOW = 0,
 DL_PRIO_NORMAL,
 DL_PRIO_HIGH,
 DL_PRIO_HIGHEST,
} ;


typedef enum
{
  GUI_DOWNLOAD_LIST_FLAG_ID         = (1 << 0),  /* from v49.5 a 32-bit ID is used by DL status msg to identify the download. */
  GUI_DOWNLOAD_LIST_FLAG_HIDE_JUNK  = (1 << 1),
  GUI_DOWNLOAD_LIST_FLAG_TRANS_PERC = (1 << 2),  /* show 'transfered' as percentage value */
} GuiDownloadListFlags;

typedef struct _GuiDownload           GuiDownload;
typedef struct _GuiDownloadList       GuiDownloadList;
typedef struct _GuiDownloadListClass  GuiDownloadListClass;

struct _GuiDownload
{
  gchar                 *name;              /* the filename as the core knows it, in locale  */

  gchar                 *name_utf8;         /* the filename as the core knows it, in UTF8   */
  gchar                 *name_collate_key;

  gchar                 *name_nojunk_utf8;  /* the filename without junk in UTF8 (generated on demand) */
  gchar                 *name_nojunk_collate_key;

  guint32                size;
  gchar                 *size_str;

  gchar                 *previewname; /* path to temp file, different according to core version*/

  guint8                 status;
  gchar                 *status_completing_string;  /* set if completing + local core to show completing progress */

  guint8                 priority;
  guint32                transfered;   /* transfered value to be displayed                                      */
  guint32                transgaplist; /* 'transfered' value according to the gap list (used when trans > size) */
  guint32                transcore;    /* 'transfered' value according to the core                              */
  gfloat                 transfered_percent;
  guint32                left;

  guint                  num_speedvals; /* number of status packets we received with this DL being active    */
  gfloat                 speedvalsum;   /* speeds added when DL was active (for better time left estimation) */

  gfloat                 speed;
  guint                  secs_left;
  guint                  avail; /* availability in percent */
  guint                  sources;

  progressbarGap        *gaps_data;
  time_t                 last_gotten_gaps;

  guint                  min_sources;  /* the minimum number of sources as the gapslist tells us */

  gboolean               cancelled;
  gboolean               corrupted;
  gboolean               done; /* download is done, either completed or corrupted */

  guint8                 hash[16];
  guint32                id;

  gchar                 *ext;
  gchar                 *type;

  GuiDownloadAttributes *attributes;  /* we do NOT own this, the downloadsattriblist does */

  /* For the model: */
  guint                  pos;
  GuiDownloadList       *list;
};

struct _GuiDownloadList
{
  GObject                parent;

  guint                  num_rows;
  GuiDownload          **rows;              /* sorted array of pointers to download records  */

  gint                   stamp;

  gint                   n_columns;
  GType                  column_types[GUI_DOWNLOAD_LIST_N_COLUMNS];

  gint                   sort_id;
  GtkSortType            sort_order;

  gchar                **status_utf8;        /* translated status strings in UTF-8 */

  gint                   get_gaps_interval;     /* how many seconds before we ask for a new gap list */
  time_t                 last_dl_removed;

  guint                  resort_timeout;

  GuiDownloadListFlags   flags;
};

struct _GuiDownloadListClass
{
  GObjectClass parent_class;

  void (* download_removed) (GuiDownloadList *list, GuiDownload *item);
};



extern GuiDownloadList  *download_list;


GType             gui_download_list_get_type                   (void);

GuiDownloadList  *gui_download_list_new                        (void);

void              gui_download_list_clear                      (GuiDownloadList *list);

GuiDownload      *gui_download_list_get_download_from_path     (GuiDownloadList *list,
                                                                GtkTreePath     *path);

GuiDownload      *gui_download_list_get_download_from_hash     (GuiDownloadList *list,
                                                                const guint8    *hash);

void              gui_download_list_new_download               (GuiDownloadList *list,
                                                                gconstpointer    hash,
                                                                const gchar     *name,
                                                                guint            size,
                                                                guint            prio,
                                                                const gchar     *tmpfn,
                                                                guint            id,
                                                                gpointer         data);

void              gui_download_list_download_removed           (GuiDownloadList *list,
                                                                const guint8    *hash,
                                                                guint            cancelled,
                                                                gpointer         data);

void              gui_download_list_update_status              (GuiDownloadList *list,
                                                                guint            id,
                                                                guint            status,
                                                                gfloat           speed,
                                                                guint            transfered,
                                                                guint            availability,
                                                                guint            sources,
                                                                gpointer         data);

void              gui_download_list_download_gaps              (GuiDownloadList *list,
                                                                const guint8    *hash,
                                                                guint            id,
                                                                guint            num,
                                                                const guint     *startarr,
                                                                const guint     *endarr,
                                                                const guint     *statusarr,
                                                                gpointer         data);

void              gui_download_list_download_change_status     (GuiDownloadList *list, GuiDownload *dl, guint newstatus);

GList            *gui_download_list_get_all_downloads          (GuiDownloadList *list);

void              gui_download_list_clear_completed            (GuiDownloadList *list);

guint             gui_download_list_count_completed            (GuiDownloadList *list);

void              gui_download_list_pause_and_resume_all       (GuiDownloadList *list);

void              gui_download_list_set_corrupted_from_filename (GuiDownloadList *list, const gchar *fncore);

#endif /* __GUI_DOWNLOAD_LIST_H__ */

