/* blacklist.h
 *
 * part of ed2k_gui
 *
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _ed2k_gui_blacklist_h_included_
#define _ed2k_gui_blacklist_h_included_

#include <glib.h>

/* the blacklist contains hashes of files we don't want to see when we search
 * it is not saved anywhere, but the gui reads the gui_blacklist file at startup
 *  and then creates its blacklist
 */

struct _GuiBlacklistItem
{
	guint8		hash[16];
	guint32		filesize;
} ;

typedef struct _GuiBlacklistItem GuiBlacklistItem;


gboolean     is_item_in_blacklist           (const guint8 *hash, guint size);

void         add_to_blacklist               (const guint8 *hash, guint32 size, const gchar *name);

void         check_if_blacklistfile_changed (void);

#endif


