/* icons.h
*
* exports icons
*
*/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _ed2k_linux_gui_icons_h_included_
#define _ed2k_linux_gui_icons_h_included_

#include <gdk/gdkpixbuf.h>


GSList *	icons_get_installed_icon_themes (void);
gboolean	icons_check_theme (const gchar *theme);



typedef enum {

	ICON_NONE = 0,

	ICON_TAB_DOWNLOADS ,
	ICON_TAB_UPLOADS,
	ICON_TAB_SEARCH,
	ICON_TAB_SERVERS,
	ICON_TAB_STATUS,
	ICON_TAB_OPTIONS,
	ICON_TAB_SHARED,
	ICON_TAB_STATS,
	ICON_TAB_FORGET,

	ICON_OPTION_TRUE,
	ICON_OPTION_FALSE,

	ICON_OK,
	ICON_CANCEL,
	ICON_REFRESH,
	ICON_SEARCH,
	ICON_EXTEND,
	ICON_ROTATE,
	ICON_CONFIGURE,
	ICON_CONNECT,
	ICON_DISCONNECT,
	ICON_KILL,
	ICON_TRASH,
	ICON_FOLDER,
	ICON_NUKE,
	ICON_STATUS,
	ICON_ABOUT,
	ICON_CONTACT,
	ICON_STATS,
	ICON_CORE,
	ICON_SHUTDOWN,
	
	ICON_FILETYPE_FOLDER,
	ICON_FILETYPE_VIDEO,
	ICON_FILETYPE_AUDIO,
	ICON_FILETYPE_IMAGE,
	ICON_FILETYPE_DOCUMENT,
	ICON_FILETYPE_PROGRAM,
	ICON_FILETYPE_PACKAGE,
	ICON_FILETYPE_SUBTITLES,
	ICON_FILETYPE_CDIMAGE,

	ICON_MENU_OK,
	ICON_MENU_CANCEL,
	ICON_MENU_DOWNLOAD,
	ICON_MENU_REFRESH,
	ICON_MENU_STATUS,
	ICON_MENU_SEARCH,
	ICON_MENU_PRIO_HIGH,
	ICON_MENU_PRIO_MEDIUM,
	ICON_MENU_PRIO_LOW,
	ICON_MENU_CONNECT,
	ICON_MENU_DISCONNECT,
	ICON_MENU_SERVERS,
	ICON_MENU_OPTIONS,
	ICON_MENU_ABOUT,
	ICON_MENU_200,
	ICON_MENU_EXTEND,
	ICON_MENU_KILL,
	ICON_MENU_BLACKLIST,
	ICON_MENU_HIDE_COLUMN,
	ICON_MENU_UNHIDE_COLUMN,
	ICON_MENU_DL_CANCEL,
	ICON_MENU_PAUSE,
	ICON_MENU_PAUSE_ALL,
	ICON_MENU_RESUME,
	ICON_MENU_RESUME_ALL,
	ICON_MENU_PREVIEW,
	ICON_MENU_THANKYOU,
	ICON_MENU_QUIT,
	ICON_MENU_HOMEPAGE,

	/* downloads page stuff */

	ICON_DL_STATUS_ERROR,
	ICON_DL_STATUS_AVAIL_LOW,
	ICON_DL_STATUS_AVAIL_HIGH,
	ICON_DL_STATUS_AVAIL_FULL,
	ICON_DL_STATUS_PAUSED,


	ICON_TOOLBAR_ED2K_LOGO,
	ICON_TOOLBAR_OVERNET_LOGO,
	ICON_TOOLBAR_DOWN_SPEED,
	ICON_TOOLBAR_UP_SPEED,
	ICON_TOOLBAR_NUM_CONNECTIONS,
	ICON_TOOLBAR_SERVER,
	ICON_TOOLBAR_GO,
	ICON_TOOLBAR_ABOUT,

	ICON_SYS_KDE,
	ICON_SYS_GNOME1,
	ICON_SYS_GNOME2,
	ICON_SYS_LINUX,
	ICON_SYS_WINDOWS,

	ICON_ED2K_GTK_GUI,
	ICON_ED2K_GTK_GUI_MINI,

	ICON_NUM_ICONS

} IconName;



void			icons_init (void);

GdkPixbuf *	get_icon (IconName icon);
GdkPixbuf *	get_icon_for_file (const gchar *);


#endif
