/* SHARC EZ-KIT host services */
#include <stdarg.h>
#include "host.h"
#include "dsp.h"

/*
  Variables used for host services.  The PC host should check for _hs == 1
  before trying to provide services for the DSP.

 */
#if HAS_HOST_SERVICES
int _hs = 1; /* has host services flag */
#endif
volatile int _kbhit = 0;
volatile int _mtype = MSG_NONE;
int _mlen = 0;
#define MAXSTR 256 
unsigned _mbuf[MAXSTR];
volatile unsigned _rbuf[MAXSTR];

#undef getch
int
dh_getch ()
{
    int ch;
    while (!_kbhit) alive ();
    ch = _rbuf[0];
    _kbhit = 0;

    return ch;
}

/* improved printf.  host handles all the conversion work, so that
   compiled DSP code doesn't rely on the large libdh.a library just
   to get sprintf functionality
   */
int
dh_printf (const char *fmt, ...)
{
    int fmt_cnt, arg_cnt, j;
    char *sval;
    va_list arg;

    for (j=0;j<MAXSTR;j++)
        _mbuf[j] = 0;

    fmt_cnt = -1;
    j = 0;

    /* pack the format string into 32-bit words to save xmission time/space
       bytes are packed little-endian for consistency (the byte in the lowest
       address is least-significant)
     */
    
    do
    {
        ++fmt_cnt;
        _mbuf[j] = (_mbuf[j]>>8) + (fmt[fmt_cnt]<<24);
        if (!((fmt_cnt+1) & 0x3))
            _mbuf[++j] = 0;
    } while ((fmt[fmt_cnt] != 0) && fmt_cnt < MAXSTR);

    /* finish the final 32-bit word, if necessary */
    if ((fmt_cnt+1) & 0x3)
    {
        while ((fmt_cnt+1) & 0x3)
        {
            _mbuf[j] >>= 8;
            ++fmt_cnt;
        }
        ++j;
    }
    _mlen = j;

    /* now parse the format string to find the arguments and put them
       in the message buffer */
    arg_cnt = 0;

    va_start(arg, fmt);

    for (fmt_cnt = 0;fmt[fmt_cnt] && fmt_cnt < MAXSTR;fmt_cnt++)
    {
        if (fmt[fmt_cnt] == '%')
        {
            ++fmt_cnt;
            switch (fmt[fmt_cnt])
            {
            case 'd':
            case 'i':
            case 'o':
            case 'x':
            case 'X':
            case 'u':
            case 'c':
            case 'p':
                _mbuf[_mlen + arg_cnt] = va_arg(arg, int);
                arg_cnt++;
                break;
                
            case 's':
                /*
                 * Collect the string including '\0', in this case not
                 * compressed.
                 */
                sval = va_arg(arg, char *);
                
                do
                {
                    _mbuf[_mlen + arg_cnt] = *sval;
                    sval++;
                    arg_cnt++;
                }
                while ( (*(sval-1) != '\0') &&
                        (_mlen +
                         arg_cnt <
                         MAXSTR)
                        );
                break;
                
            case 'f':
            case 'e':
            case 'E':
            case 'g':
            case 'G':
                _mbuf[_mlen + arg_cnt] = va_arg(arg, int);
                arg_cnt++;
                break;
                
            case '%':
                fmt_cnt++;
                break;
                
                /*
                 * The %lf additional format argument is supported
                 * to print out double values of 64 bit for programs,
                 * compiled with -fno-short-double. Watch out that
                 * at the PC the two 32 bit portions are swapped.
                 */
            case 'l':
                fmt_cnt++;
                switch (fmt[fmt_cnt])
                {
                case 'f':
                    *((double *) (_mbuf +_mlen + arg_cnt)) =
                        va_arg(arg, double);
                    arg_cnt += 2;
                    break;
                    
                default:
                    break;
                }
                break;
                
            default:
                break;
            }
        }
    }
    
    _mlen += arg_cnt;
    
    va_end(arg);
    
    _mtype = MSG_PRINT;

    /*
     * Wait untill the message is transmitted.
     */
    
    while (_mtype) /* alive () */;
    
    return (_mlen - 1);
}

#undef kbhit
int
dh_kbhit ()
{
    return _kbhit;
}

#undef exit
void
dh_exit (int code)
{
    stack_check ();

    _mlen = 1;
    *_mbuf = code;

    _mtype = MSG_EXIT;

    exit (code);
}


#define SECOND 1000000ul
void
delay (int usecs)
{
    unsigned time = timer_get ();
    unsigned cycles = usecs * 40;

    while (time - timer_get () < cycles) ;
}

void
alive ()
{
}

/*
  stack_test_init() marks the stack and sets mark values which will be
  overwritten on stack overflow.  in this application, the stack overflows
  into the heap (which isn't used, so we can put marks in it).
  stack_check () looks at which marked values have changed
 */  
#include "stack.h"
#define MARK_WORD       0x12345678
static int _stack_test_init = 0;
void stack_test_init (void)
{
    unsigned long *currstack;
    unsigned long *base = (unsigned long *)STACK_BASE;

    _stack_test_init = 1;

    asm ("%0=i6;" : "=r" (currstack));
    /*printf ("stack on entry at 0x%lx\n", currstack);*/

    /* mark the end of the stack to detect overruns (stack grows down) */
    *(base-1) = MARK_WORD;
    *(base-2) = MARK_WORD;

    /* make sure we don't trash anything in use
       64 is a decent starting point
     */
    while (base < currstack - 64)
        *base = (unsigned long)base++;
}

void
stack_check (void)
{
    int i;

    if (!_stack_test_init)
        return;

    if (((unsigned long *)STACK_BASE)[-1] != MARK_WORD ||
        ((unsigned long *)STACK_BASE)[-2] != MARK_WORD)
    {
        printf ("*** Stack overrun likely\n");
    }
    else for (i=0;i<STACK_SIZE;i++)
    {
        if (((unsigned long *)STACK_BASE)[i] != STACK_BASE+i)
        {
            printf ("Max stack usage %d/%d 32-bit words\n",
                    STACK_SIZE - i, STACK_SIZE);
            return;
        }
    }
}

