# Generated by Django 5.2.2 on 2025-06-13 14:56

import datetime

from django.conf import settings
from django.db import migrations, models
from django.db.backends.base.schema import BaseDatabaseSchemaEditor
from django.db.migrations.state import StateApps


def update_status(apps: StateApps, schema_editor: BaseDatabaseSchemaEditor) -> None:
    DBTaskResult = apps.get_model("django_tasks_database", "DBTaskResult")

    DBTaskResult.objects.filter(status="NEW").update(status="READY")


def revert_status_rename(
    apps: StateApps, schema_editor: BaseDatabaseSchemaEditor
) -> None:
    DBTaskResult = apps.get_model("django_tasks_database", "DBTaskResult")

    DBTaskResult.objects.filter(status="READY").update(status="NEW")


class Migration(migrations.Migration):
    dependencies = [
        ("django_tasks_database", "0015_correctly_order_run_after"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="dbtaskresult",
            options={
                "ordering": [
                    models.OrderBy(models.F("priority"), descending=True),
                    models.OrderBy(models.F("run_after")),
                ],
                "verbose_name": "Task Result",
                "verbose_name_plural": "Task Results",
            },
        ),
        migrations.AlterField(
            model_name="dbtaskresult",
            name="backend_name",
            field=models.CharField(max_length=32, verbose_name="backend name"),
        ),
        migrations.AlterField(
            model_name="dbtaskresult",
            name="queue_name",
            field=models.CharField(
                default="default", max_length=32, verbose_name="queue name"
            ),
        ),
        migrations.AlterField(
            model_name="dbtaskresult",
            name="run_after",
            field=models.DateTimeField(
                default=datetime.datetime(
                    9999,
                    1,
                    1,
                    0,
                    0,
                    tzinfo=datetime.timezone.utc if settings.USE_TZ else None,
                ),
                verbose_name="run after",
            ),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="dbtaskresult",
            name="status",
            field=models.CharField(
                choices=[
                    ("READY", "Ready"),
                    ("RUNNING", "Running"),
                    ("FAILED", "Failed"),
                    ("SUCCEEDED", "Succeeded"),
                ],
                default="READY",
                max_length=9,
                verbose_name="status",
            ),
        ),
        migrations.AddField(
            model_name="dbtaskresult",
            name="worker_ids",
            field=models.JSONField(default=list, verbose_name="worker id"),
        ),
        migrations.RunPython(update_status, revert_status_rename),
        migrations.AddIndex(
            model_name="dbtaskresult",
            index=models.Index(
                models.F("status"),
                models.OrderBy(models.F("priority"), descending=True),
                models.OrderBy(models.F("run_after")),
                condition=models.Q(("status", "READY")),
                name="django_task_new_ordering_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="dbtaskresult",
            index=models.Index(
                fields=["queue_name"], name="django_task_queue_n_99c321_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="dbtaskresult",
            index=models.Index(
                fields=["backend_name"], name="django_task_backend_071754_idx"
            ),
        ),
    ]
