/*
* subdiv.cc
* DIN Is Noise is copyright (c) 2006-2025 Jagannathan Sampath
* For more information, please visit https://dinisnoise.org/
*/


#include "subdiv.h"
#include "multi_curve.h"
#include "console.h"
#include "curve_editor.h"

#include <vector>
using namespace std;

subdiv::subdiv () {
  name = "Beat Divider";
  dirty = 1;
}

subdiv::~subdiv () {
  widget_save ("d_subdiv", ctrls);
}

void subdiv::setup () {

  plugin::setup ();

  start.pick.set_text ("Pick start vertex");
  start.pick.id = 1;
  start.pick.set_listener (this);
  start.value = 0;
  end.pick.set_text ("Pick end vertex");
  end.pick.id = 2;
  end.pick.set_listener (this);
  end.value = 2;

  n.set ("Divisions", 1, 2, MILLION, this, 0);
  n.set_value (2);

  widget* w[] = {&start.pick, &end.pick, &n};
  for (int i = 0; i < 3; ++i) {
    widget* wi = w[i];
    ctrls.push_back (wi);
    //wi->set_moveable(1);
  }

  num_ctrls = ctrls.size ();
  widget_load ("d_subdiv", ctrls);

}

int subdiv::apply (multi_curve& crv) {

#ifdef __EVALUATION__
	cons << RED << "Can apply plugins only in the Licensed Version of DIN Is Noise" << eol;
	return 0;
#endif

  int v1 = start.value, v2 = end.value;
  int N = n.value;

  clamp (0, v1, crv.last_vertex);
  clamp (v1, v2, crv.last_vertex);

  start.value = v1;
  end.value = v2;

  if (v1 == v2) {
    cons << RED << "Invalid parameters, try again!" << eol;
    return 0;
  }

  multi_curve pre, post, stamp, sub;

  for (int i = 0, j = crv.num_vertices; i < j; ++i) {
    point<float>& vi = crv.vertices[i];
    point<float>& lt = crv.left_tangents[i];
    point<float>& rt = crv.right_tangents[i];
    if (i < v1) {
      // to pre
      pre.add_vertex_tangents (vi, lt, rt);
    } else {
      if (i > v2) {
        // to post
        post.add_vertex_tangents (vi, lt, rt);
      } else {
        // to stamp 
        stamp.add_vertex_tangents (vi, lt, rt);
      }
    }
  }

  if (stamp.num_vertices < 2) {
    cons << RED << "No curve between vertices: " << v1 << spc << v2 << eol;
    return 0;
  }

  point<float> lt0 = stamp.left_tangents[0];
  point<float> rtl = stamp.right_tangents[stamp.last_vertex];

  point<float>& v0 = stamp.vertices[0];
  stamp.cen.x = v0.x;
  stamp.cen.y = v0.y;

  stamp.scale (1.0f / N, 1.0f);

  sub = stamp;
  for (int i = 1; i < N; ++i) paste_append (sub, stamp, 1);

  crv.clear (0);
  crv.add (pre);

  point<float>& lts0 = sub.left_tangents[0];
  point<float>& rtsl = sub.right_tangents[sub.last_vertex];
  lts0 = lt0;
  rtsl = rtl;
  crv.add (sub);

  crv.add (post);

  crv.evaluate ();



  return 1;

}

void subdiv::draw () {
  if (dirty) {
    int& v1 = start.value;
    int& v2 = end.value;
    ed->calcline2vertices (v1, v2);
    start.value = v1;
    end.value = v2;
    dirty = 0;
  }
  int xx = b_apply.extents.left - 10; 
  box<int>& se = start.pick.extents;
  box<int>& ee = end.pick.extents;
  ed->drawline2vertices (xx, se.midy, xx, ee.midy);
  plugin::draw ();
}

void subdiv::changed (field& f) {
  dirty = 1;
}

int subdiv::handle_input () {
  if (ed->beater) {
    if (keypressed (SDLK_LEFT)) {
      ed->dobeatdivider (1);
    } 
    else 
    if (keypressed (SDLK_RIGHT)) {
      ed->dobeatdivider (2);
    }
    else
    if (keypressed (SDLK_UP)) ++n;
    else 
    if (keypressed (SDLK_DOWN)) --n;
  }
  return plugin::handle_input ();
}
