/*
* palet.cc
* DIN Is Noise is copyright (c) 2006-2025 Jagannathan Sampath
* DIN Is Noise is released under GNU Public License 2.0
* For more information, please visit https://dinisnoise.org/
*/

#include "log.h"
#include "palet.h"
#include "curve_editor.h"
#include "ui_list.h"
#include "console.h"
#include "main.h"

#define WIDGET_PTR_w widget* w [] = {&title, &fold, &loop, &pong, &rev, &scrub, &bpm, &halv, &doubl, &il};
#define NUM_WIDGETS 10

extern int line_height;
extern char BUFFER[];

palet::palet () {
  r = 0;
  lastbpm = -1;
}

palet::~palet () {
  int n = bpms.size ();
  if (n == 0) 
    ;
  else {
    for (int i = 0; i < n; ++i) {
      button* bi = bpms[i];
      if (bi) delete bi;
    }
    dlog << "--- destroyed " << n << " buttons of bpm palet ---" << endl;
  }

  WIDGET_PTR_w
  widget_save ("bpmtools", w, NUM_WIDGETS);
}


bpmratiot::bpmratiot (int nn, int dd) {
  n = nn;
  d = dd;
  r = n * 1.0f / d;
}

bpmratiopairt::bpmratiopairt (bpmratiot b0, bpmratiot b1) {
  r[0] = b0;
  r[1] = b1;
  sprintf (BUFFER, "%d/%d  %d/%d", b0.n, b0.d, b1.n, b1.d);
  lbl = BUFFER;
}

float palet::operator[] (int i) {
  bpmratiopairt& rp = ratios[r];
  return rp.r[i].r;
}

void palet::setup () {

  bpms.resize (81); // 9 x 9 ratios
  for (int i = 0, j = bpms.size (); i < j; ++i) bpms[i] = 0;

  title.set_text ("BPM tools");
  MOVE(title)

  folded = 1;
  fold.set_dir (arrow_button::right);

  rev.set_text ("Reverse");
  scrub.set_text ("Scrub");

  loop.set_text ("Loop");
  loop.id = beat2value::LOOP;
  loop.set_listener (this);

  pong.set_text ("Pong");
  pong.id = beat2value::PONG;
  pong.set_listener (this);


  {
    button* b [] = {&halv, &doubl, &rev, &scrub, &fold};
    for (int i = 0; i < 5; ++i) {
      button* bi = b[i];
      bi->set_listener (this);
    }
  }

  for (int i = 0; i < 6; ++i) il.add (ratios[i].lbl);
  r = 0;
  il.items[0].sel = 1;
  il.sel_lis = this;

  bpm.set ("BPM", 1, 0, MILLION, this, 0);

  {
    WIDGET_PTR_w
    widget_load ("bpmtools", w, NUM_WIDGETS);
    makefam (&title, &w[1], NUM_WIDGETS-1);
  }

}

void palet::build (float ib) {
  int x0 = scrub.extents.right + 25;
  int x = x0, y = doubl.posy;
  for (int i = 1, k = 0; i < 10; ++i) {
    for (int j = 1; j < 10; ++j, ++k) {
      float r = j * 1.0f / i;
      float fb = ib * r;
      int ibi = ib * r;
      button* b = bpms[k];
      if (b) 
        ;
      else {
        b = new button ();
        b->set_pos (x, y);
        b->set_listener (this);
        title.add_child (b);
        bpms[k] = b;
      }
      b->id = ibi;
      b->idf = fb;
      sprintf (BUFFER, "%d", ibi);
      b->set_text (BUFFER);
      x += 50;
    }
    x = x0;
    y -= line_height;
  }
}

int palet::handle_input () {

  if (folded) {
    return (title.handle_input () || fold.handle_input() );
  } else {

    WIDGET_PTR_w
    for (int i = 0; i < NUM_WIDGETS; ++i) {
      widget* wi = w[i];
      if (wi->handle_input()) return 1;
    }
    for (int i = 0, j = bpms.size (); i < j; ++i) {
      button* bi = bpms[i];
      if (bi->handle_input ()) return 1;
    }

  }

  return 0;
}

void palet::draw () {
  if (folded) {
    title.draw ();
    fold.draw (); 
  } else {
    WIDGET_PTR_w
    for (int i = 0; i < NUM_WIDGETS; ++i) {
      widget* wi = w[i];
      wi->draw ();
    }
    for (int i = 0, j = bpms.size (); i < j; ++i) {
      button* bi = bpms[i];
      bi->draw ();
    }
  }
}

void palet::clicked (button& b) {
  if (&b == &rev) {
    CRVED->reversebeat ();
  } else if (&b == &scrub) {
    CRVED->scrub ();
  } else if (&b == &fold) {
    folded = !folded;
    if (folded) 
      fold.set_dir (arrow_button::right); 
    else 
      fold.set_dir (arrow_button::down);
  } else {
    bpm.set_value (b.idf);
    changed (bpm.f_value);
  }
}

void palet::setbpm (float b) {
  beat2value* bv = CRVED->getbv ();
  lastbpm = bv->bpm;
  bv->set_bpm (b);
}


void palet::changed (field& f) {
  float b = bpm.value;
  build (b);
  setbpm (b);
  calc_halv_doubl ();
}

void palet::calc_halv_doubl () {
  int h = bpm.value / (operator[](BPM_ID) * EXTRA_BPM_MULT);
  int d = bpm.value * operator[](!BPM_ID) * EXTRA_BPM_MULT;
  sprintf (BUFFER, "%d", h);
  halv.set_text (BUFFER);
  halv.idf = h;
  sprintf (BUFFER, "%d", d);
  doubl.set_text (BUFFER);
  doubl.idf = d;
}

void palet::update () {
  beat2value* bv = CRVED->getbv ();
  float b = bv->bpm;
  if (b != lastbpm) {
    lastbpm = b;
    bpm.set_value (bv->bpm);
    changed (bpm.f_value);
  }
  static checkbutton* cb [] = {&loop, &pong};
  cb[bv->style]->set_state (1, 0);
  cb[!bv->style]->set_state (0, 0);
}

void palet::selected (item_list& il, int w) {
  if (w == -1) 
    return;
  else
    r = w;
  BPM_MULT = uis.palette [BPM_ID];
  calc_halv_doubl ();
}

void palet::changed (checkbutton& cb) {
  beat2value& bv = *CRVED->getbv ();
  if (cb.id == bv.style) {
    if (cb.state == 0) cb.set_state (1,0);
  } else {
    bv.setstyle (cb.id);
    checkbutton* cbs [] = {&loop, &pong};
    cbs[!cb.id]->set_state (0, 0);
  }
}
