pub fn option_display<T: ToString>(opt: &Option<T>) -> String {
    opt.as_ref()
        .map(|t| t.to_string())
        .unwrap_or_else(|| String::from("?"))
}

pub fn option_debug_display<T: std::fmt::Debug>(opt: &Option<T>) -> String {
    opt.as_ref()
        .map(|t| format!("{t:?}"))
        .unwrap_or_else(|| String::from("?"))
}
