{
  perSystem =
    {
      config,
      pkgs,
      lib,
      ...
    }:
    let
      deps = [
        pkgs.pkg-config
        pkgs.openssl
      ];
      cfg = {
        mkDerivation.buildInputs = deps;
        env.LD_LIBRARY_PATH = lib.makeLibraryPath deps;
      };
    in
    {
      nci = {
        toolchainConfig = ./../../rust-toolchain.toml;
        projects.codeberg-cli.path = ./../..;
        crates.codeberg-cli = {
          depsDrvConfig = cfg;
          drvConfig = cfg;
        };
      };
      packages = {
        berg = config.nci.outputs.codeberg-cli.packages.release;
        berg-rustfmt = config.nci.toolchains.shell;
      };
    };
}
