// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.5
// source: google/cloud/video/livestream/v1/resources.proto

package livestreampb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of the input.
type Input_Type int32

const (
	// Input type is not specified.
	Input_TYPE_UNSPECIFIED Input_Type = 0
	// Input will take an rtmp input stream.
	Input_RTMP_PUSH Input_Type = 1
	// Input will take an srt (Secure Reliable Transport) input stream.
	Input_SRT_PUSH Input_Type = 2
)

// Enum value maps for Input_Type.
var (
	Input_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "RTMP_PUSH",
		2: "SRT_PUSH",
	}
	Input_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"RTMP_PUSH":        1,
		"SRT_PUSH":         2,
	}
)

func (x Input_Type) Enum() *Input_Type {
	p := new(Input_Type)
	*p = x
	return p
}

func (x Input_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Input_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_livestream_v1_resources_proto_enumTypes[0].Descriptor()
}

func (Input_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_video_livestream_v1_resources_proto_enumTypes[0]
}

func (x Input_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Input_Type.Descriptor instead.
func (Input_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{0, 0}
}

// Tier of the input specification.
type Input_Tier int32

const (
	// Tier is not specified.
	Input_TIER_UNSPECIFIED Input_Tier = 0
	// Resolution < 1280x720. Bitrate <= 6 Mbps. FPS <= 60.
	Input_SD Input_Tier = 1
	// Resolution <= 1920x1080. Bitrate <= 25 Mbps. FPS <= 60.
	Input_HD Input_Tier = 2
	// Resolution <= 4096x2160. Not supported yet.
	Input_UHD Input_Tier = 3
)

// Enum value maps for Input_Tier.
var (
	Input_Tier_name = map[int32]string{
		0: "TIER_UNSPECIFIED",
		1: "SD",
		2: "HD",
		3: "UHD",
	}
	Input_Tier_value = map[string]int32{
		"TIER_UNSPECIFIED": 0,
		"SD":               1,
		"HD":               2,
		"UHD":              3,
	}
)

func (x Input_Tier) Enum() *Input_Tier {
	p := new(Input_Tier)
	*p = x
	return p
}

func (x Input_Tier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Input_Tier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_livestream_v1_resources_proto_enumTypes[1].Descriptor()
}

func (Input_Tier) Type() protoreflect.EnumType {
	return &file_google_cloud_video_livestream_v1_resources_proto_enumTypes[1]
}

func (x Input_Tier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Input_Tier.Descriptor instead.
func (Input_Tier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{0, 1}
}

// State of streaming operation that the channel is running.
type Channel_StreamingState int32

const (
	// Streaming state is not specified.
	Channel_STREAMING_STATE_UNSPECIFIED Channel_StreamingState = 0
	// Channel is getting the input stream, generating the live streams to the
	// specified output location.
	Channel_STREAMING Channel_StreamingState = 1
	// Channel is waiting for the input stream through the input.
	Channel_AWAITING_INPUT Channel_StreamingState = 2
	// Channel is running, but has trouble publishing the live streams onto the
	// specified output location (for example, the specified Cloud Storage
	// bucket is not writable).
	Channel_STREAMING_ERROR Channel_StreamingState = 4
	// Channel is generating live streams with no input stream. Live streams are
	// filled out with black screen, while input stream is missing.
	// Not supported yet.
	Channel_STREAMING_NO_INPUT Channel_StreamingState = 5
	// Channel is stopped, finishing live streams.
	Channel_STOPPED Channel_StreamingState = 6
	// Channel is starting.
	Channel_STARTING Channel_StreamingState = 7
	// Channel is stopping.
	Channel_STOPPING Channel_StreamingState = 8
)

// Enum value maps for Channel_StreamingState.
var (
	Channel_StreamingState_name = map[int32]string{
		0: "STREAMING_STATE_UNSPECIFIED",
		1: "STREAMING",
		2: "AWAITING_INPUT",
		4: "STREAMING_ERROR",
		5: "STREAMING_NO_INPUT",
		6: "STOPPED",
		7: "STARTING",
		8: "STOPPING",
	}
	Channel_StreamingState_value = map[string]int32{
		"STREAMING_STATE_UNSPECIFIED": 0,
		"STREAMING":                   1,
		"AWAITING_INPUT":              2,
		"STREAMING_ERROR":             4,
		"STREAMING_NO_INPUT":          5,
		"STOPPED":                     6,
		"STARTING":                    7,
		"STOPPING":                    8,
	}
)

func (x Channel_StreamingState) Enum() *Channel_StreamingState {
	p := new(Channel_StreamingState)
	*p = x
	return p
}

func (x Channel_StreamingState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Channel_StreamingState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_livestream_v1_resources_proto_enumTypes[2].Descriptor()
}

func (Channel_StreamingState) Type() protoreflect.EnumType {
	return &file_google_cloud_video_livestream_v1_resources_proto_enumTypes[2]
}

func (x Channel_StreamingState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Channel_StreamingState.Descriptor instead.
func (Channel_StreamingState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{1, 0}
}

// The severity level of platform logging for this channel. Logs with a
// severity level higher than or equal to the chosen severity level will be
// logged and can be viewed through Cloud Logging.
// The severity level of a log is ranked as followed from low to high: DEBUG <
// INFO < NOTICE < WARNING < ERROR < CRITICAL < ALERT < EMERGENCY.
// See
// [LogSeverity](https://cloud.google.com/logging/docs/reference/v2/rest/v2/LogEntry#logseverity)
// for more information.
type LogConfig_LogSeverity int32

const (
	// Log severity is not specified. This is the same as log severity is OFF.
	LogConfig_LOG_SEVERITY_UNSPECIFIED LogConfig_LogSeverity = 0
	// Log is turned off.
	LogConfig_OFF LogConfig_LogSeverity = 1
	// Log with severity higher than or equal to DEBUG are logged.
	LogConfig_DEBUG LogConfig_LogSeverity = 100
	// Logs with severity higher than or equal to INFO are logged.
	LogConfig_INFO LogConfig_LogSeverity = 200
	// Logs with severity higher than or equal to WARNING are logged.
	LogConfig_WARNING LogConfig_LogSeverity = 400
	// Logs with severity higher than or equal to ERROR are logged.
	LogConfig_ERROR LogConfig_LogSeverity = 500
)

// Enum value maps for LogConfig_LogSeverity.
var (
	LogConfig_LogSeverity_name = map[int32]string{
		0:   "LOG_SEVERITY_UNSPECIFIED",
		1:   "OFF",
		100: "DEBUG",
		200: "INFO",
		400: "WARNING",
		500: "ERROR",
	}
	LogConfig_LogSeverity_value = map[string]int32{
		"LOG_SEVERITY_UNSPECIFIED": 0,
		"OFF":                      1,
		"DEBUG":                    100,
		"INFO":                     200,
		"WARNING":                  400,
		"ERROR":                    500,
	}
)

func (x LogConfig_LogSeverity) Enum() *LogConfig_LogSeverity {
	p := new(LogConfig_LogSeverity)
	*p = x
	return p
}

func (x LogConfig_LogSeverity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LogConfig_LogSeverity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_livestream_v1_resources_proto_enumTypes[3].Descriptor()
}

func (LogConfig_LogSeverity) Type() protoreflect.EnumType {
	return &file_google_cloud_video_livestream_v1_resources_proto_enumTypes[3]
}

func (x LogConfig_LogSeverity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LogConfig_LogSeverity.Descriptor instead.
func (LogConfig_LogSeverity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{2, 0}
}

// State of the event
type Event_State int32

const (
	// Event state is not specified.
	Event_STATE_UNSPECIFIED Event_State = 0
	// Event is scheduled but not executed yet.
	Event_SCHEDULED Event_State = 1
	// Event is being executed.
	Event_RUNNING Event_State = 2
	// Event has been successfully executed.
	Event_SUCCEEDED Event_State = 3
	// Event fails to be executed.
	Event_FAILED Event_State = 4
	// Event has been created but not scheduled yet.
	Event_PENDING Event_State = 5
	// Event was stopped before running for its full duration.
	Event_STOPPED Event_State = 6
)

// Enum value maps for Event_State.
var (
	Event_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "SCHEDULED",
		2: "RUNNING",
		3: "SUCCEEDED",
		4: "FAILED",
		5: "PENDING",
		6: "STOPPED",
	}
	Event_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"SCHEDULED":         1,
		"RUNNING":           2,
		"SUCCEEDED":         3,
		"FAILED":            4,
		"PENDING":           5,
		"STOPPED":           6,
	}
)

func (x Event_State) Enum() *Event_State {
	p := new(Event_State)
	*p = x
	return p
}

func (x Event_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Event_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_livestream_v1_resources_proto_enumTypes[4].Descriptor()
}

func (Event_State) Type() protoreflect.EnumType {
	return &file_google_cloud_video_livestream_v1_resources_proto_enumTypes[4]
}

func (x Event_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Event_State.Descriptor instead.
func (Event_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{9, 0}
}

// Input resource represents the endpoint from which the channel ingests
// the input stream.
type Input struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the input, in the form of:
	// `projects/{project}/locations/{location}/inputs/{inputId}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The update time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-defined key/value metadata.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Source type.
	Type Input_Type `protobuf:"varint,5,opt,name=type,proto3,enum=google.cloud.video.livestream.v1.Input_Type" json:"type,omitempty"`
	// Tier defines the maximum input specification that is accepted by the
	// video pipeline. The billing is charged based on the tier specified here.
	// See [Pricing](https://cloud.google.com/livestream/pricing) for more detail.
	// The default is `HD`.
	Tier Input_Tier `protobuf:"varint,14,opt,name=tier,proto3,enum=google.cloud.video.livestream.v1.Input_Tier" json:"tier,omitempty"`
	// Output only. URI to push the input stream to.
	// Its format depends on the input [type][google.cloud.video.livestream.v1.Input.type], for example:
	//
	// *  `RTMP_PUSH`: `rtmp://1.2.3.4/live/{STREAM-ID}`
	// *  `SRT_PUSH`: `srt://1.2.3.4:4201?streamid={STREAM-ID}`
	Uri string `protobuf:"bytes,6,opt,name=uri,proto3" json:"uri,omitempty"`
	// Preprocessing configurations.
	PreprocessingConfig *PreprocessingConfig `protobuf:"bytes,9,opt,name=preprocessing_config,json=preprocessingConfig,proto3" json:"preprocessing_config,omitempty"`
	// Security rule for access control.
	SecurityRules *Input_SecurityRule `protobuf:"bytes,12,opt,name=security_rules,json=securityRules,proto3" json:"security_rules,omitempty"`
	// Output only. The information for the input stream. This field will be present only when
	// this input receives the input stream.
	InputStreamProperty *InputStreamProperty `protobuf:"bytes,15,opt,name=input_stream_property,json=inputStreamProperty,proto3" json:"input_stream_property,omitempty"`
}

func (x *Input) Reset() {
	*x = Input{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Input) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Input) ProtoMessage() {}

func (x *Input) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Input.ProtoReflect.Descriptor instead.
func (*Input) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{0}
}

func (x *Input) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Input) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Input) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Input) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Input) GetType() Input_Type {
	if x != nil {
		return x.Type
	}
	return Input_TYPE_UNSPECIFIED
}

func (x *Input) GetTier() Input_Tier {
	if x != nil {
		return x.Tier
	}
	return Input_TIER_UNSPECIFIED
}

func (x *Input) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *Input) GetPreprocessingConfig() *PreprocessingConfig {
	if x != nil {
		return x.PreprocessingConfig
	}
	return nil
}

func (x *Input) GetSecurityRules() *Input_SecurityRule {
	if x != nil {
		return x.SecurityRules
	}
	return nil
}

func (x *Input) GetInputStreamProperty() *InputStreamProperty {
	if x != nil {
		return x.InputStreamProperty
	}
	return nil
}

// Channel resource represents the processor that does a user-defined
// "streaming" operation, which includes getting an input stream through an
// input, transcoding it to multiple renditions, and publishing output live
// streams in certain formats (for example, HLS or DASH) to the specified
// location.
type Channel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the channel, in the form of:
	// `projects/{project}/locations/{location}/channels/{channelId}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The update time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-defined key/value metadata.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A list of input attachments that this channel uses.
	// One channel can have multiple inputs as the input sources. Only one
	// input can be selected as the input source at one time.
	InputAttachments []*InputAttachment `protobuf:"bytes,16,rep,name=input_attachments,json=inputAttachments,proto3" json:"input_attachments,omitempty"`
	// Output only. The [InputAttachment.key][google.cloud.video.livestream.v1.InputAttachment.key] that serves as the current input source. The
	// first input in the [input_attachments][google.cloud.video.livestream.v1.Channel.input_attachments] is the initial input source.
	ActiveInput string `protobuf:"bytes,6,opt,name=active_input,json=activeInput,proto3" json:"active_input,omitempty"`
	// Required. Information about the output (that is, the Cloud Storage bucket to store
	// the generated live stream).
	Output *Channel_Output `protobuf:"bytes,9,opt,name=output,proto3" json:"output,omitempty"`
	// List of elementary streams.
	ElementaryStreams []*ElementaryStream `protobuf:"bytes,10,rep,name=elementary_streams,json=elementaryStreams,proto3" json:"elementary_streams,omitempty"`
	// List of multiplexing settings for output streams.
	MuxStreams []*MuxStream `protobuf:"bytes,11,rep,name=mux_streams,json=muxStreams,proto3" json:"mux_streams,omitempty"`
	// List of output manifests.
	Manifests []*Manifest `protobuf:"bytes,12,rep,name=manifests,proto3" json:"manifests,omitempty"`
	// List of output sprite sheets.
	SpriteSheets []*SpriteSheet `protobuf:"bytes,13,rep,name=sprite_sheets,json=spriteSheets,proto3" json:"sprite_sheets,omitempty"`
	// Output only. State of the streaming operation.
	StreamingState Channel_StreamingState `protobuf:"varint,14,opt,name=streaming_state,json=streamingState,proto3,enum=google.cloud.video.livestream.v1.Channel_StreamingState" json:"streaming_state,omitempty"`
	// Output only. A description of the reason for the streaming error. This property is
	// always present when [streaming_state][google.cloud.video.livestream.v1.Channel.streaming_state] is
	// [STREAMING_ERROR][google.cloud.video.livestream.v1.Channel.StreamingState.STREAMING_ERROR].
	StreamingError *status.Status `protobuf:"bytes,18,opt,name=streaming_error,json=streamingError,proto3" json:"streaming_error,omitempty"`
	// Configuration of platform logs for this channel.
	LogConfig *LogConfig `protobuf:"bytes,19,opt,name=log_config,json=logConfig,proto3" json:"log_config,omitempty"`
}

func (x *Channel) Reset() {
	*x = Channel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Channel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Channel) ProtoMessage() {}

func (x *Channel) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Channel.ProtoReflect.Descriptor instead.
func (*Channel) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{1}
}

func (x *Channel) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Channel) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Channel) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Channel) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Channel) GetInputAttachments() []*InputAttachment {
	if x != nil {
		return x.InputAttachments
	}
	return nil
}

func (x *Channel) GetActiveInput() string {
	if x != nil {
		return x.ActiveInput
	}
	return ""
}

func (x *Channel) GetOutput() *Channel_Output {
	if x != nil {
		return x.Output
	}
	return nil
}

func (x *Channel) GetElementaryStreams() []*ElementaryStream {
	if x != nil {
		return x.ElementaryStreams
	}
	return nil
}

func (x *Channel) GetMuxStreams() []*MuxStream {
	if x != nil {
		return x.MuxStreams
	}
	return nil
}

func (x *Channel) GetManifests() []*Manifest {
	if x != nil {
		return x.Manifests
	}
	return nil
}

func (x *Channel) GetSpriteSheets() []*SpriteSheet {
	if x != nil {
		return x.SpriteSheets
	}
	return nil
}

func (x *Channel) GetStreamingState() Channel_StreamingState {
	if x != nil {
		return x.StreamingState
	}
	return Channel_STREAMING_STATE_UNSPECIFIED
}

func (x *Channel) GetStreamingError() *status.Status {
	if x != nil {
		return x.StreamingError
	}
	return nil
}

func (x *Channel) GetLogConfig() *LogConfig {
	if x != nil {
		return x.LogConfig
	}
	return nil
}

// Configuration of platform logs.
// See [Using and managing platform
// logs](https://cloud.google.com/logging/docs/api/platform-logs#managing-logs)
// for more information about how to view platform logs through Cloud Logging.
type LogConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The severity level of platform logging for this resource.
	LogSeverity LogConfig_LogSeverity `protobuf:"varint,1,opt,name=log_severity,json=logSeverity,proto3,enum=google.cloud.video.livestream.v1.LogConfig_LogSeverity" json:"log_severity,omitempty"`
}

func (x *LogConfig) Reset() {
	*x = LogConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogConfig) ProtoMessage() {}

func (x *LogConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogConfig.ProtoReflect.Descriptor instead.
func (*LogConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{2}
}

func (x *LogConfig) GetLogSeverity() LogConfig_LogSeverity {
	if x != nil {
		return x.LogSeverity
	}
	return LogConfig_LOG_SEVERITY_UNSPECIFIED
}

// Properties of the input stream.
type InputStreamProperty struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time that the current input stream is accepted and the connection is
	// established.
	LastEstablishTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=last_establish_time,json=lastEstablishTime,proto3" json:"last_establish_time,omitempty"`
	// Properties of the video streams.
	VideoStreams []*VideoStreamProperty `protobuf:"bytes,2,rep,name=video_streams,json=videoStreams,proto3" json:"video_streams,omitempty"`
	// Properties of the audio streams.
	AudioStreams []*AudioStreamProperty `protobuf:"bytes,3,rep,name=audio_streams,json=audioStreams,proto3" json:"audio_streams,omitempty"`
}

func (x *InputStreamProperty) Reset() {
	*x = InputStreamProperty{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InputStreamProperty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputStreamProperty) ProtoMessage() {}

func (x *InputStreamProperty) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputStreamProperty.ProtoReflect.Descriptor instead.
func (*InputStreamProperty) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{3}
}

func (x *InputStreamProperty) GetLastEstablishTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastEstablishTime
	}
	return nil
}

func (x *InputStreamProperty) GetVideoStreams() []*VideoStreamProperty {
	if x != nil {
		return x.VideoStreams
	}
	return nil
}

func (x *InputStreamProperty) GetAudioStreams() []*AudioStreamProperty {
	if x != nil {
		return x.AudioStreams
	}
	return nil
}

// Properties of the video stream.
type VideoStreamProperty struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Index of this video stream.
	Index int32 `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
	// Properties of the video format.
	VideoFormat *VideoFormat `protobuf:"bytes,2,opt,name=video_format,json=videoFormat,proto3" json:"video_format,omitempty"`
}

func (x *VideoStreamProperty) Reset() {
	*x = VideoStreamProperty{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoStreamProperty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoStreamProperty) ProtoMessage() {}

func (x *VideoStreamProperty) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoStreamProperty.ProtoReflect.Descriptor instead.
func (*VideoStreamProperty) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{4}
}

func (x *VideoStreamProperty) GetIndex() int32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *VideoStreamProperty) GetVideoFormat() *VideoFormat {
	if x != nil {
		return x.VideoFormat
	}
	return nil
}

// Properties of the video format.
type VideoFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Video codec used in this video stream.
	Codec string `protobuf:"bytes,1,opt,name=codec,proto3" json:"codec,omitempty"`
	// The width of the video stream in pixels.
	WidthPixels int32 `protobuf:"varint,2,opt,name=width_pixels,json=widthPixels,proto3" json:"width_pixels,omitempty"`
	// The height of the video stream in pixels.
	HeightPixels int32 `protobuf:"varint,3,opt,name=height_pixels,json=heightPixels,proto3" json:"height_pixels,omitempty"`
	// The frame rate of the input video stream.
	FrameRate float64 `protobuf:"fixed64,4,opt,name=frame_rate,json=frameRate,proto3" json:"frame_rate,omitempty"`
}

func (x *VideoFormat) Reset() {
	*x = VideoFormat{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoFormat) ProtoMessage() {}

func (x *VideoFormat) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoFormat.ProtoReflect.Descriptor instead.
func (*VideoFormat) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{5}
}

func (x *VideoFormat) GetCodec() string {
	if x != nil {
		return x.Codec
	}
	return ""
}

func (x *VideoFormat) GetWidthPixels() int32 {
	if x != nil {
		return x.WidthPixels
	}
	return 0
}

func (x *VideoFormat) GetHeightPixels() int32 {
	if x != nil {
		return x.HeightPixels
	}
	return 0
}

func (x *VideoFormat) GetFrameRate() float64 {
	if x != nil {
		return x.FrameRate
	}
	return 0
}

// Properties of the audio stream.
type AudioStreamProperty struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Index of this audio stream.
	Index int32 `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
	// Properties of the audio format.
	AudioFormat *AudioFormat `protobuf:"bytes,2,opt,name=audio_format,json=audioFormat,proto3" json:"audio_format,omitempty"`
}

func (x *AudioStreamProperty) Reset() {
	*x = AudioStreamProperty{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AudioStreamProperty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioStreamProperty) ProtoMessage() {}

func (x *AudioStreamProperty) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioStreamProperty.ProtoReflect.Descriptor instead.
func (*AudioStreamProperty) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{6}
}

func (x *AudioStreamProperty) GetIndex() int32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *AudioStreamProperty) GetAudioFormat() *AudioFormat {
	if x != nil {
		return x.AudioFormat
	}
	return nil
}

// Properties of the audio format.
type AudioFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Audio codec used in this audio stream.
	Codec string `protobuf:"bytes,1,opt,name=codec,proto3" json:"codec,omitempty"`
	// The number of audio channels.
	ChannelCount int32 `protobuf:"varint,2,opt,name=channel_count,json=channelCount,proto3" json:"channel_count,omitempty"`
	// A list of channel names specifying the layout of the audio channels.
	ChannelLayout []string `protobuf:"bytes,3,rep,name=channel_layout,json=channelLayout,proto3" json:"channel_layout,omitempty"`
}

func (x *AudioFormat) Reset() {
	*x = AudioFormat{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AudioFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioFormat) ProtoMessage() {}

func (x *AudioFormat) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioFormat.ProtoReflect.Descriptor instead.
func (*AudioFormat) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{7}
}

func (x *AudioFormat) GetCodec() string {
	if x != nil {
		return x.Codec
	}
	return ""
}

func (x *AudioFormat) GetChannelCount() int32 {
	if x != nil {
		return x.ChannelCount
	}
	return 0
}

func (x *AudioFormat) GetChannelLayout() []string {
	if x != nil {
		return x.ChannelLayout
	}
	return nil
}

// A group of information for attaching an input resource to this channel.
type InputAttachment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique key for this input attachment.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The resource name of an existing input, in the form of:
	// `projects/{project}/locations/{location}/inputs/{inputId}`.
	Input string `protobuf:"bytes,2,opt,name=input,proto3" json:"input,omitempty"`
	// Automatic failover configurations.
	AutomaticFailover *InputAttachment_AutomaticFailover `protobuf:"bytes,3,opt,name=automatic_failover,json=automaticFailover,proto3" json:"automatic_failover,omitempty"`
}

func (x *InputAttachment) Reset() {
	*x = InputAttachment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InputAttachment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputAttachment) ProtoMessage() {}

func (x *InputAttachment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputAttachment.ProtoReflect.Descriptor instead.
func (*InputAttachment) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{8}
}

func (x *InputAttachment) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *InputAttachment) GetInput() string {
	if x != nil {
		return x.Input
	}
	return ""
}

func (x *InputAttachment) GetAutomaticFailover() *InputAttachment_AutomaticFailover {
	if x != nil {
		return x.AutomaticFailover
	}
	return nil
}

// Event is a sub-resource of a channel, which can be scheduled by the user to
// execute operations on a channel resource without having to stop the channel.
type Event struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the event, in the form of:
	// `projects/{project}/locations/{location}/channels/{channelId}/events/{eventId}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The update time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-defined key/value metadata.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Operation to be executed by this event.
	//
	// Types that are assignable to Task:
	//
	//	*Event_AdBreak
	Task isEvent_Task `protobuf_oneof:"task"`
	// When this field is set to true, the event will be executed at the earliest
	// time that the server can schedule the event and [execution_time][google.cloud.video.livestream.v1.Event.execution_time] will be
	// populated with the time that the server actually schedules the event.
	ExecuteNow bool `protobuf:"varint,9,opt,name=execute_now,json=executeNow,proto3" json:"execute_now,omitempty"`
	// The time when the event should be executed. When [execute_now][google.cloud.video.livestream.v1.Event.execute_now] is set to
	// `true`, this field should not be set in `CreateEvent` request and will be
	// populated with the time that the server schedules the event.
	ExecutionTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=execution_time,json=executionTime,proto3" json:"execution_time,omitempty"`
	// Output only. The state of the event.
	State Event_State `protobuf:"varint,11,opt,name=state,proto3,enum=google.cloud.video.livestream.v1.Event_State" json:"state,omitempty"`
	// Output only. An error object that describes the reason for the failure.
	// This property is always present when `state` is `FAILED`.
	Error *status.Status `protobuf:"bytes,12,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *Event) Reset() {
	*x = Event{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event) ProtoMessage() {}

func (x *Event) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Event.ProtoReflect.Descriptor instead.
func (*Event) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{9}
}

func (x *Event) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Event) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Event) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Event) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (m *Event) GetTask() isEvent_Task {
	if m != nil {
		return m.Task
	}
	return nil
}

func (x *Event) GetAdBreak() *Event_AdBreakTask {
	if x, ok := x.GetTask().(*Event_AdBreak); ok {
		return x.AdBreak
	}
	return nil
}

func (x *Event) GetExecuteNow() bool {
	if x != nil {
		return x.ExecuteNow
	}
	return false
}

func (x *Event) GetExecutionTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExecutionTime
	}
	return nil
}

func (x *Event) GetState() Event_State {
	if x != nil {
		return x.State
	}
	return Event_STATE_UNSPECIFIED
}

func (x *Event) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

type isEvent_Task interface {
	isEvent_Task()
}

type Event_AdBreak struct {
	// Required. Inserts a new ad opportunity.
	AdBreak *Event_AdBreakTask `protobuf:"bytes,6,opt,name=ad_break,json=adBreak,proto3,oneof"`
}

func (*Event_AdBreak) isEvent_Task() {}

// Security rules for access control. Each field represents one security rule.
// Only when the source of the input stream satisfies all the fields, this
// input stream can be accepted.
type Input_SecurityRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// At least one ip range must match unless none specified. The IP range is
	// defined by CIDR block: for example, `192.0.1.0/24` for a range and
	// `192.0.1.0/32` for a single IP address.
	IpRanges []string `protobuf:"bytes,1,rep,name=ip_ranges,json=ipRanges,proto3" json:"ip_ranges,omitempty"`
}

func (x *Input_SecurityRule) Reset() {
	*x = Input_SecurityRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Input_SecurityRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Input_SecurityRule) ProtoMessage() {}

func (x *Input_SecurityRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Input_SecurityRule.ProtoReflect.Descriptor instead.
func (*Input_SecurityRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Input_SecurityRule) GetIpRanges() []string {
	if x != nil {
		return x.IpRanges
	}
	return nil
}

// Location of output file(s) in a Google Cloud Storage bucket.
type Channel_Output struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URI for the output file(s). For example, `gs://my-bucket/outputs/`.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *Channel_Output) Reset() {
	*x = Channel_Output{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Channel_Output) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Channel_Output) ProtoMessage() {}

func (x *Channel_Output) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Channel_Output.ProtoReflect.Descriptor instead.
func (*Channel_Output) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{1, 0}
}

func (x *Channel_Output) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// Configurations to follow when automatic failover happens.
type InputAttachment_AutomaticFailover struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [InputAttachment.key][google.cloud.video.livestream.v1.InputAttachment.key]s of inputs to failover to when this input is
	// disconnected. Currently, only up to one backup input is supported.
	InputKeys []string `protobuf:"bytes,1,rep,name=input_keys,json=inputKeys,proto3" json:"input_keys,omitempty"`
}

func (x *InputAttachment_AutomaticFailover) Reset() {
	*x = InputAttachment_AutomaticFailover{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InputAttachment_AutomaticFailover) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputAttachment_AutomaticFailover) ProtoMessage() {}

func (x *InputAttachment_AutomaticFailover) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputAttachment_AutomaticFailover.ProtoReflect.Descriptor instead.
func (*InputAttachment_AutomaticFailover) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{8, 0}
}

func (x *InputAttachment_AutomaticFailover) GetInputKeys() []string {
	if x != nil {
		return x.InputKeys
	}
	return nil
}

// Inserts a new ad opportunity.
type Event_AdBreakTask struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Duration of an ad opportunity. Must be greater than 0.
	Duration *durationpb.Duration `protobuf:"bytes,1,opt,name=duration,proto3" json:"duration,omitempty"`
}

func (x *Event_AdBreakTask) Reset() {
	*x = Event_AdBreakTask{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Event_AdBreakTask) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event_AdBreakTask) ProtoMessage() {}

func (x *Event_AdBreakTask) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_livestream_v1_resources_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Event_AdBreakTask.ProtoReflect.Descriptor instead.
func (*Event_AdBreakTask) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP(), []int{9, 0}
}

func (x *Event_AdBreakTask) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

var File_google_cloud_video_livestream_v1_resources_proto protoreflect.FileDescriptor

var file_google_cloud_video_livestream_v1_resources_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2f,
	0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2f,
	0x76, 0x31, 0x2f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf6, 0x07, 0x0a, 0x05, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x40, 0x0a, 0x04, 0x74,
	0x69, 0x65, 0x72, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x2e, 0x54, 0x69, 0x65, 0x72, 0x52, 0x04, 0x74, 0x69, 0x65, 0x72, 0x12, 0x15, 0x0a,
	0x03, 0x75, 0x72, 0x69, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x03, 0x75, 0x72, 0x69, 0x12, 0x68, 0x0a, 0x14, 0x70, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x13, 0x70, 0x72, 0x65, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5b,
	0x0a, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x2e,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x0d, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x6e, 0x0a, 0x15, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x1a, 0x2b, 0x0a, 0x0c, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x69,
	0x70, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08,
	0x69, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x39, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x54, 0x4d, 0x50, 0x5f, 0x50, 0x55, 0x53, 0x48, 0x10, 0x01,
	0x12, 0x0c, 0x0a, 0x08, 0x53, 0x52, 0x54, 0x5f, 0x50, 0x55, 0x53, 0x48, 0x10, 0x02, 0x22, 0x35,
	0x0a, 0x04, 0x54, 0x69, 0x65, 0x72, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x49, 0x45, 0x52, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02,
	0x53, 0x44, 0x10, 0x01, 0x12, 0x06, 0x0a, 0x02, 0x48, 0x44, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03,
	0x55, 0x48, 0x44, 0x10, 0x03, 0x3a, 0x5c, 0xea, 0x41, 0x59, 0x0a, 0x1f, 0x6c, 0x69, 0x76, 0x65,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x36, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x7d, 0x22, 0xf4, 0x0a, 0x0a, 0x07, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x5e, 0x0a, 0x11, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f,
	0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x10, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0b, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x4d,
	0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x61, 0x0a,
	0x12, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x79, 0x5f, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x79, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x11, 0x65,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x79, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
	0x12, 0x4c, 0x0a, 0x0b, 0x6d, 0x75, 0x78, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18,
	0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x78, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x52, 0x0a, 0x6d, 0x75, 0x78, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x48,
	0x0a, 0x09, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x52, 0x09, 0x6d,
	0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x73, 0x12, 0x52, 0x0a, 0x0d, 0x73, 0x70, 0x72, 0x69,
	0x74, 0x65, 0x5f, 0x73, 0x68, 0x65, 0x65, 0x74, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x70, 0x72, 0x69, 0x74, 0x65, 0x53, 0x68, 0x65, 0x65, 0x74, 0x52, 0x0c,
	0x73, 0x70, 0x72, 0x69, 0x74, 0x65, 0x53, 0x68, 0x65, 0x65, 0x74, 0x73, 0x12, 0x66, 0x0a, 0x0f,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e,
	0x67, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e,
	0x67, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x4a, 0x0a, 0x0a, 0x6c, 0x6f, 0x67, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x09, 0x6c, 0x6f, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x1a, 0x1a, 0x0a, 0x06, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x10, 0x0a, 0x03,
	0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x1a, 0x39,
	0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xaa, 0x01, 0x0a, 0x0e, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x1b,
	0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a,
	0x09, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e,
	0x41, 0x57, 0x41, 0x49, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x49, 0x4e, 0x50, 0x55, 0x54, 0x10, 0x02,
	0x12, 0x13, 0x0a, 0x0f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x49, 0x4e, 0x47, 0x5f, 0x45, 0x52,
	0x52, 0x4f, 0x52, 0x10, 0x04, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x49,
	0x4e, 0x47, 0x5f, 0x4e, 0x4f, 0x5f, 0x49, 0x4e, 0x50, 0x55, 0x54, 0x10, 0x05, 0x12, 0x0b, 0x0a,
	0x07, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54,
	0x41, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x4f, 0x50,
	0x50, 0x49, 0x4e, 0x47, 0x10, 0x08, 0x3a, 0x62, 0xea, 0x41, 0x5f, 0x0a, 0x21, 0x6c, 0x69, 0x76,
	0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x3a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73,
	0x2f, 0x7b, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x7d, 0x22, 0xcd, 0x01, 0x0a, 0x09, 0x4c,
	0x6f, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5a, 0x0a, 0x0c, 0x6c, 0x6f, 0x67, 0x5f,
	0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x6f, 0x67, 0x53,
	0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x52, 0x0b, 0x6c, 0x6f, 0x67, 0x53, 0x65, 0x76, 0x65,
	0x72, 0x69, 0x74, 0x79, 0x22, 0x64, 0x0a, 0x0b, 0x4c, 0x6f, 0x67, 0x53, 0x65, 0x76, 0x65, 0x72,
	0x69, 0x74, 0x79, 0x12, 0x1c, 0x0a, 0x18, 0x4c, 0x4f, 0x47, 0x5f, 0x53, 0x45, 0x56, 0x45, 0x52,
	0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x07, 0x0a, 0x03, 0x4f, 0x46, 0x46, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x45,
	0x42, 0x55, 0x47, 0x10, 0x64, 0x12, 0x09, 0x0a, 0x04, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0xc8, 0x01,
	0x12, 0x0c, 0x0a, 0x07, 0x57, 0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x90, 0x03, 0x12, 0x0a,
	0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0xf4, 0x03, 0x22, 0x99, 0x02, 0x0a, 0x13, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x12, 0x4a, 0x0a, 0x13, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x65, 0x73, 0x74, 0x61, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x11, 0x6c, 0x61, 0x73,
	0x74, 0x45, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5a,
	0x0a, 0x0d, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x0c, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x12, 0x5a, 0x0a, 0x0d, 0x61, 0x75,
	0x64, 0x69, 0x6f, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x0c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x22, 0x7d, 0x0a, 0x13, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x12, 0x50, 0x0a, 0x0c, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x0b, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0x8a, 0x01, 0x0a, 0x0b, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x12, 0x21, 0x0a, 0x0c, 0x77,
	0x69, 0x64, 0x74, 0x68, 0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0b, 0x77, 0x69, 0x64, 0x74, 0x68, 0x50, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x12, 0x23,
	0x0a, 0x0d, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x5f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x50, 0x69, 0x78,
	0x65, 0x6c, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f, 0x72, 0x61, 0x74,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x52, 0x09, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x61,
	0x74, 0x65, 0x22, 0x7d, 0x0a, 0x13, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12,
	0x50, 0x0a, 0x0c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x46, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x52, 0x0b, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x22, 0x6f, 0x0a, 0x0b, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x4c, 0x61, 0x79, 0x6f,
	0x75, 0x74, 0x22, 0x87, 0x02, 0x0a, 0x0f, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x74, 0x74, 0x61,
	0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3a, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x6c, 0x69,
	0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x05, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x12, 0x72, 0x0a, 0x12, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
	0x63, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x46, 0x61, 0x69,
	0x6c, 0x6f, 0x76, 0x65, 0x72, 0x52, 0x11, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63,
	0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x1a, 0x32, 0x0a, 0x11, 0x41, 0x75, 0x74, 0x6f,
	0x6d, 0x61, 0x74, 0x69, 0x63, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x12, 0x1d, 0x0a,
	0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x22, 0x8b, 0x07, 0x0a,
	0x05, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x55, 0x0a, 0x08, 0x61,
	0x64, 0x5f, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x64, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x54, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x07, 0x61, 0x64, 0x42, 0x72, 0x65,
	0x61, 0x6b, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x5f, 0x6e, 0x6f,
	0x77, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65,
	0x4e, 0x6f, 0x77, 0x12, 0x41, 0x0a, 0x0e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0d, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x1a,
	0x44, 0x0a, 0x0b, 0x41, 0x64, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x54, 0x61, 0x73, 0x6b, 0x12, 0x35,
	0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x6f, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0d, 0x0a, 0x09, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12,
	0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09,
	0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46,
	0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49,
	0x4e, 0x47, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x10,
	0x06, 0x3a, 0x6f, 0xea, 0x41, 0x6c, 0x0a, 0x1f, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x49, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x7d, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x7d, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x61, 0x73, 0x6b, 0x42, 0xf1, 0x01, 0x0a, 0x24, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x42, 0x0e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x3b, 0x6c, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0xaa, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x4c, 0x69, 0x76, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x5c, 0x4c, 0x69, 0x76, 0x65, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x3a, 0x3a,
	0x4c, 0x69, 0x76, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_video_livestream_v1_resources_proto_rawDescOnce sync.Once
	file_google_cloud_video_livestream_v1_resources_proto_rawDescData = file_google_cloud_video_livestream_v1_resources_proto_rawDesc
)

func file_google_cloud_video_livestream_v1_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_video_livestream_v1_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_video_livestream_v1_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_video_livestream_v1_resources_proto_rawDescData)
	})
	return file_google_cloud_video_livestream_v1_resources_proto_rawDescData
}

var file_google_cloud_video_livestream_v1_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_video_livestream_v1_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_cloud_video_livestream_v1_resources_proto_goTypes = []interface{}{
	(Input_Type)(0),             // 0: google.cloud.video.livestream.v1.Input.Type
	(Input_Tier)(0),             // 1: google.cloud.video.livestream.v1.Input.Tier
	(Channel_StreamingState)(0), // 2: google.cloud.video.livestream.v1.Channel.StreamingState
	(LogConfig_LogSeverity)(0),  // 3: google.cloud.video.livestream.v1.LogConfig.LogSeverity
	(Event_State)(0),            // 4: google.cloud.video.livestream.v1.Event.State
	(*Input)(nil),               // 5: google.cloud.video.livestream.v1.Input
	(*Channel)(nil),             // 6: google.cloud.video.livestream.v1.Channel
	(*LogConfig)(nil),           // 7: google.cloud.video.livestream.v1.LogConfig
	(*InputStreamProperty)(nil), // 8: google.cloud.video.livestream.v1.InputStreamProperty
	(*VideoStreamProperty)(nil), // 9: google.cloud.video.livestream.v1.VideoStreamProperty
	(*VideoFormat)(nil),         // 10: google.cloud.video.livestream.v1.VideoFormat
	(*AudioStreamProperty)(nil), // 11: google.cloud.video.livestream.v1.AudioStreamProperty
	(*AudioFormat)(nil),         // 12: google.cloud.video.livestream.v1.AudioFormat
	(*InputAttachment)(nil),     // 13: google.cloud.video.livestream.v1.InputAttachment
	(*Event)(nil),               // 14: google.cloud.video.livestream.v1.Event
	(*Input_SecurityRule)(nil),  // 15: google.cloud.video.livestream.v1.Input.SecurityRule
	nil,                         // 16: google.cloud.video.livestream.v1.Input.LabelsEntry
	(*Channel_Output)(nil),      // 17: google.cloud.video.livestream.v1.Channel.Output
	nil,                         // 18: google.cloud.video.livestream.v1.Channel.LabelsEntry
	(*InputAttachment_AutomaticFailover)(nil), // 19: google.cloud.video.livestream.v1.InputAttachment.AutomaticFailover
	(*Event_AdBreakTask)(nil),                 // 20: google.cloud.video.livestream.v1.Event.AdBreakTask
	nil,                                       // 21: google.cloud.video.livestream.v1.Event.LabelsEntry
	(*timestamppb.Timestamp)(nil),             // 22: google.protobuf.Timestamp
	(*PreprocessingConfig)(nil),               // 23: google.cloud.video.livestream.v1.PreprocessingConfig
	(*ElementaryStream)(nil),                  // 24: google.cloud.video.livestream.v1.ElementaryStream
	(*MuxStream)(nil),                         // 25: google.cloud.video.livestream.v1.MuxStream
	(*Manifest)(nil),                          // 26: google.cloud.video.livestream.v1.Manifest
	(*SpriteSheet)(nil),                       // 27: google.cloud.video.livestream.v1.SpriteSheet
	(*status.Status)(nil),                     // 28: google.rpc.Status
	(*durationpb.Duration)(nil),               // 29: google.protobuf.Duration
}
var file_google_cloud_video_livestream_v1_resources_proto_depIdxs = []int32{
	22, // 0: google.cloud.video.livestream.v1.Input.create_time:type_name -> google.protobuf.Timestamp
	22, // 1: google.cloud.video.livestream.v1.Input.update_time:type_name -> google.protobuf.Timestamp
	16, // 2: google.cloud.video.livestream.v1.Input.labels:type_name -> google.cloud.video.livestream.v1.Input.LabelsEntry
	0,  // 3: google.cloud.video.livestream.v1.Input.type:type_name -> google.cloud.video.livestream.v1.Input.Type
	1,  // 4: google.cloud.video.livestream.v1.Input.tier:type_name -> google.cloud.video.livestream.v1.Input.Tier
	23, // 5: google.cloud.video.livestream.v1.Input.preprocessing_config:type_name -> google.cloud.video.livestream.v1.PreprocessingConfig
	15, // 6: google.cloud.video.livestream.v1.Input.security_rules:type_name -> google.cloud.video.livestream.v1.Input.SecurityRule
	8,  // 7: google.cloud.video.livestream.v1.Input.input_stream_property:type_name -> google.cloud.video.livestream.v1.InputStreamProperty
	22, // 8: google.cloud.video.livestream.v1.Channel.create_time:type_name -> google.protobuf.Timestamp
	22, // 9: google.cloud.video.livestream.v1.Channel.update_time:type_name -> google.protobuf.Timestamp
	18, // 10: google.cloud.video.livestream.v1.Channel.labels:type_name -> google.cloud.video.livestream.v1.Channel.LabelsEntry
	13, // 11: google.cloud.video.livestream.v1.Channel.input_attachments:type_name -> google.cloud.video.livestream.v1.InputAttachment
	17, // 12: google.cloud.video.livestream.v1.Channel.output:type_name -> google.cloud.video.livestream.v1.Channel.Output
	24, // 13: google.cloud.video.livestream.v1.Channel.elementary_streams:type_name -> google.cloud.video.livestream.v1.ElementaryStream
	25, // 14: google.cloud.video.livestream.v1.Channel.mux_streams:type_name -> google.cloud.video.livestream.v1.MuxStream
	26, // 15: google.cloud.video.livestream.v1.Channel.manifests:type_name -> google.cloud.video.livestream.v1.Manifest
	27, // 16: google.cloud.video.livestream.v1.Channel.sprite_sheets:type_name -> google.cloud.video.livestream.v1.SpriteSheet
	2,  // 17: google.cloud.video.livestream.v1.Channel.streaming_state:type_name -> google.cloud.video.livestream.v1.Channel.StreamingState
	28, // 18: google.cloud.video.livestream.v1.Channel.streaming_error:type_name -> google.rpc.Status
	7,  // 19: google.cloud.video.livestream.v1.Channel.log_config:type_name -> google.cloud.video.livestream.v1.LogConfig
	3,  // 20: google.cloud.video.livestream.v1.LogConfig.log_severity:type_name -> google.cloud.video.livestream.v1.LogConfig.LogSeverity
	22, // 21: google.cloud.video.livestream.v1.InputStreamProperty.last_establish_time:type_name -> google.protobuf.Timestamp
	9,  // 22: google.cloud.video.livestream.v1.InputStreamProperty.video_streams:type_name -> google.cloud.video.livestream.v1.VideoStreamProperty
	11, // 23: google.cloud.video.livestream.v1.InputStreamProperty.audio_streams:type_name -> google.cloud.video.livestream.v1.AudioStreamProperty
	10, // 24: google.cloud.video.livestream.v1.VideoStreamProperty.video_format:type_name -> google.cloud.video.livestream.v1.VideoFormat
	12, // 25: google.cloud.video.livestream.v1.AudioStreamProperty.audio_format:type_name -> google.cloud.video.livestream.v1.AudioFormat
	19, // 26: google.cloud.video.livestream.v1.InputAttachment.automatic_failover:type_name -> google.cloud.video.livestream.v1.InputAttachment.AutomaticFailover
	22, // 27: google.cloud.video.livestream.v1.Event.create_time:type_name -> google.protobuf.Timestamp
	22, // 28: google.cloud.video.livestream.v1.Event.update_time:type_name -> google.protobuf.Timestamp
	21, // 29: google.cloud.video.livestream.v1.Event.labels:type_name -> google.cloud.video.livestream.v1.Event.LabelsEntry
	20, // 30: google.cloud.video.livestream.v1.Event.ad_break:type_name -> google.cloud.video.livestream.v1.Event.AdBreakTask
	22, // 31: google.cloud.video.livestream.v1.Event.execution_time:type_name -> google.protobuf.Timestamp
	4,  // 32: google.cloud.video.livestream.v1.Event.state:type_name -> google.cloud.video.livestream.v1.Event.State
	28, // 33: google.cloud.video.livestream.v1.Event.error:type_name -> google.rpc.Status
	29, // 34: google.cloud.video.livestream.v1.Event.AdBreakTask.duration:type_name -> google.protobuf.Duration
	35, // [35:35] is the sub-list for method output_type
	35, // [35:35] is the sub-list for method input_type
	35, // [35:35] is the sub-list for extension type_name
	35, // [35:35] is the sub-list for extension extendee
	0,  // [0:35] is the sub-list for field type_name
}

func init() { file_google_cloud_video_livestream_v1_resources_proto_init() }
func file_google_cloud_video_livestream_v1_resources_proto_init() {
	if File_google_cloud_video_livestream_v1_resources_proto != nil {
		return
	}
	file_google_cloud_video_livestream_v1_outputs_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_video_livestream_v1_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Input); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Channel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LogConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InputStreamProperty); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoStreamProperty); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoFormat); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AudioStreamProperty); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AudioFormat); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InputAttachment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_resources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Event); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_resources_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Input_SecurityRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_resources_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Channel_Output); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_resources_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InputAttachment_AutomaticFailover); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_livestream_v1_resources_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Event_AdBreakTask); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_video_livestream_v1_resources_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*Event_AdBreak)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_video_livestream_v1_resources_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_video_livestream_v1_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_video_livestream_v1_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_video_livestream_v1_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_video_livestream_v1_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_video_livestream_v1_resources_proto = out.File
	file_google_cloud_video_livestream_v1_resources_proto_rawDesc = nil
	file_google_cloud_video_livestream_v1_resources_proto_goTypes = nil
	file_google_cloud_video_livestream_v1_resources_proto_depIdxs = nil
}
