// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.3
// source: loadtest.proto

package google_pubsub_loadtest

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	LoadtestWorker_Start_FullMethodName = "/google.pubsub.loadtest.LoadtestWorker/Start"
	LoadtestWorker_Check_FullMethodName = "/google.pubsub.loadtest.LoadtestWorker/Check"
)

// LoadtestWorkerClient is the client API for LoadtestWorker service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type LoadtestWorkerClient interface {
	// Starts a worker
	Start(ctx context.Context, in *StartRequest, opts ...grpc.CallOption) (*StartResponse, error)
	// Check the status of a load test worker.
	Check(ctx context.Context, in *CheckRequest, opts ...grpc.CallOption) (*CheckResponse, error)
}

type loadtestWorkerClient struct {
	cc grpc.ClientConnInterface
}

func NewLoadtestWorkerClient(cc grpc.ClientConnInterface) LoadtestWorkerClient {
	return &loadtestWorkerClient{cc}
}

func (c *loadtestWorkerClient) Start(ctx context.Context, in *StartRequest, opts ...grpc.CallOption) (*StartResponse, error) {
	out := new(StartResponse)
	err := c.cc.Invoke(ctx, LoadtestWorker_Start_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *loadtestWorkerClient) Check(ctx context.Context, in *CheckRequest, opts ...grpc.CallOption) (*CheckResponse, error) {
	out := new(CheckResponse)
	err := c.cc.Invoke(ctx, LoadtestWorker_Check_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LoadtestWorkerServer is the server API for LoadtestWorker service.
// All implementations must embed UnimplementedLoadtestWorkerServer
// for forward compatibility
type LoadtestWorkerServer interface {
	// Starts a worker
	Start(context.Context, *StartRequest) (*StartResponse, error)
	// Check the status of a load test worker.
	Check(context.Context, *CheckRequest) (*CheckResponse, error)
	mustEmbedUnimplementedLoadtestWorkerServer()
}

// UnimplementedLoadtestWorkerServer must be embedded to have forward compatible implementations.
type UnimplementedLoadtestWorkerServer struct {
}

func (UnimplementedLoadtestWorkerServer) Start(context.Context, *StartRequest) (*StartResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Start not implemented")
}
func (UnimplementedLoadtestWorkerServer) Check(context.Context, *CheckRequest) (*CheckResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Check not implemented")
}
func (UnimplementedLoadtestWorkerServer) mustEmbedUnimplementedLoadtestWorkerServer() {}

// UnsafeLoadtestWorkerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to LoadtestWorkerServer will
// result in compilation errors.
type UnsafeLoadtestWorkerServer interface {
	mustEmbedUnimplementedLoadtestWorkerServer()
}

func RegisterLoadtestWorkerServer(s grpc.ServiceRegistrar, srv LoadtestWorkerServer) {
	s.RegisterService(&LoadtestWorker_ServiceDesc, srv)
}

func _LoadtestWorker_Start_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoadtestWorkerServer).Start(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LoadtestWorker_Start_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoadtestWorkerServer).Start(ctx, req.(*StartRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LoadtestWorker_Check_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LoadtestWorkerServer).Check(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LoadtestWorker_Check_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LoadtestWorkerServer).Check(ctx, req.(*CheckRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// LoadtestWorker_ServiceDesc is the grpc.ServiceDesc for LoadtestWorker service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var LoadtestWorker_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.pubsub.loadtest.LoadtestWorker",
	HandlerType: (*LoadtestWorkerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Start",
			Handler:    _LoadtestWorker_Start_Handler,
		},
		{
			MethodName: "Check",
			Handler:    _LoadtestWorker_Check_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "loadtest.proto",
}
