// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/edgecontainer/v1/resources.proto

package edgecontainerpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents the accessibility state of a customer-managed KMS key used for
// CMEK integration.
type KmsKeyState int32

const (
	// Unspecified.
	KmsKeyState_KMS_KEY_STATE_UNSPECIFIED KmsKeyState = 0
	// The key is available for use, and dependent resources should be accessible.
	KmsKeyState_KMS_KEY_STATE_KEY_AVAILABLE KmsKeyState = 1
	// The key is unavailable for an unspecified reason. Dependent resources may
	// be inaccessible.
	KmsKeyState_KMS_KEY_STATE_KEY_UNAVAILABLE KmsKeyState = 2
)

// Enum value maps for KmsKeyState.
var (
	KmsKeyState_name = map[int32]string{
		0: "KMS_KEY_STATE_UNSPECIFIED",
		1: "KMS_KEY_STATE_KEY_AVAILABLE",
		2: "KMS_KEY_STATE_KEY_UNAVAILABLE",
	}
	KmsKeyState_value = map[string]int32{
		"KMS_KEY_STATE_UNSPECIFIED":     0,
		"KMS_KEY_STATE_KEY_AVAILABLE":   1,
		"KMS_KEY_STATE_KEY_UNAVAILABLE": 2,
	}
)

func (x KmsKeyState) Enum() *KmsKeyState {
	p := new(KmsKeyState)
	*p = x
	return p
}

func (x KmsKeyState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (KmsKeyState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_edgecontainer_v1_resources_proto_enumTypes[0].Descriptor()
}

func (KmsKeyState) Type() protoreflect.EnumType {
	return &file_google_cloud_edgecontainer_v1_resources_proto_enumTypes[0]
}

func (x KmsKeyState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use KmsKeyState.Descriptor instead.
func (KmsKeyState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{0}
}

// Indicates the status of the cluster.
type Cluster_Status int32

const (
	// Status unknown.
	Cluster_STATUS_UNSPECIFIED Cluster_Status = 0
	// The cluster is being created.
	Cluster_PROVISIONING Cluster_Status = 1
	// The cluster is created and fully usable.
	Cluster_RUNNING Cluster_Status = 2
	// The cluster is being deleted.
	Cluster_DELETING Cluster_Status = 3
	// The status indicates that some errors occurred while reconciling/deleting
	// the cluster.
	Cluster_ERROR Cluster_Status = 4
	// The cluster is undergoing some work such as version upgrades, etc.
	Cluster_RECONCILING Cluster_Status = 5
)

// Enum value maps for Cluster_Status.
var (
	Cluster_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "PROVISIONING",
		2: "RUNNING",
		3: "DELETING",
		4: "ERROR",
		5: "RECONCILING",
	}
	Cluster_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"PROVISIONING":       1,
		"RUNNING":            2,
		"DELETING":           3,
		"ERROR":              4,
		"RECONCILING":        5,
	}
)

func (x Cluster_Status) Enum() *Cluster_Status {
	p := new(Cluster_Status)
	*p = x
	return p
}

func (x Cluster_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_edgecontainer_v1_resources_proto_enumTypes[1].Descriptor()
}

func (Cluster_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_edgecontainer_v1_resources_proto_enumTypes[1]
}

func (x Cluster_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Status.Descriptor instead.
func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{0, 0}
}

// The release channel a cluster is subscribed to.
type Cluster_ReleaseChannel int32

const (
	// Unspecified release channel. This will default to the REGULAR channel.
	Cluster_RELEASE_CHANNEL_UNSPECIFIED Cluster_ReleaseChannel = 0
	// No release channel.
	Cluster_NONE Cluster_ReleaseChannel = 1
	// Regular release channel.
	Cluster_REGULAR Cluster_ReleaseChannel = 2
)

// Enum value maps for Cluster_ReleaseChannel.
var (
	Cluster_ReleaseChannel_name = map[int32]string{
		0: "RELEASE_CHANNEL_UNSPECIFIED",
		1: "NONE",
		2: "REGULAR",
	}
	Cluster_ReleaseChannel_value = map[string]int32{
		"RELEASE_CHANNEL_UNSPECIFIED": 0,
		"NONE":                        1,
		"REGULAR":                     2,
	}
)

func (x Cluster_ReleaseChannel) Enum() *Cluster_ReleaseChannel {
	p := new(Cluster_ReleaseChannel)
	*p = x
	return p
}

func (x Cluster_ReleaseChannel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_ReleaseChannel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_edgecontainer_v1_resources_proto_enumTypes[2].Descriptor()
}

func (Cluster_ReleaseChannel) Type() protoreflect.EnumType {
	return &file_google_cloud_edgecontainer_v1_resources_proto_enumTypes[2]
}

func (x Cluster_ReleaseChannel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_ReleaseChannel.Descriptor instead.
func (Cluster_ReleaseChannel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{0, 1}
}

// Represents the policy configuration about how user applications are
// deployed.
type Cluster_ControlPlane_SharedDeploymentPolicy int32

const (
	// Unspecified.
	Cluster_ControlPlane_SHARED_DEPLOYMENT_POLICY_UNSPECIFIED Cluster_ControlPlane_SharedDeploymentPolicy = 0
	// User applications can be deployed both on control plane and worker
	// nodes.
	Cluster_ControlPlane_ALLOWED Cluster_ControlPlane_SharedDeploymentPolicy = 1
	// User applications can not be deployed on control plane nodes and can
	// only be deployed on worker nodes.
	Cluster_ControlPlane_DISALLOWED Cluster_ControlPlane_SharedDeploymentPolicy = 2
)

// Enum value maps for Cluster_ControlPlane_SharedDeploymentPolicy.
var (
	Cluster_ControlPlane_SharedDeploymentPolicy_name = map[int32]string{
		0: "SHARED_DEPLOYMENT_POLICY_UNSPECIFIED",
		1: "ALLOWED",
		2: "DISALLOWED",
	}
	Cluster_ControlPlane_SharedDeploymentPolicy_value = map[string]int32{
		"SHARED_DEPLOYMENT_POLICY_UNSPECIFIED": 0,
		"ALLOWED":                              1,
		"DISALLOWED":                           2,
	}
)

func (x Cluster_ControlPlane_SharedDeploymentPolicy) Enum() *Cluster_ControlPlane_SharedDeploymentPolicy {
	p := new(Cluster_ControlPlane_SharedDeploymentPolicy)
	*p = x
	return p
}

func (x Cluster_ControlPlane_SharedDeploymentPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_ControlPlane_SharedDeploymentPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_edgecontainer_v1_resources_proto_enumTypes[3].Descriptor()
}

func (Cluster_ControlPlane_SharedDeploymentPolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_edgecontainer_v1_resources_proto_enumTypes[3]
}

func (x Cluster_ControlPlane_SharedDeploymentPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_ControlPlane_SharedDeploymentPolicy.Descriptor instead.
func (Cluster_ControlPlane_SharedDeploymentPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{0, 0, 0}
}

// Indicates the maintenance event type.
type Cluster_MaintenanceEvent_Type int32

const (
	// Unspecified.
	Cluster_MaintenanceEvent_TYPE_UNSPECIFIED Cluster_MaintenanceEvent_Type = 0
	// Upgrade initiated by users.
	Cluster_MaintenanceEvent_USER_INITIATED_UPGRADE Cluster_MaintenanceEvent_Type = 1
	// Upgrade driven by Google.
	Cluster_MaintenanceEvent_GOOGLE_DRIVEN_UPGRADE Cluster_MaintenanceEvent_Type = 2
)

// Enum value maps for Cluster_MaintenanceEvent_Type.
var (
	Cluster_MaintenanceEvent_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "USER_INITIATED_UPGRADE",
		2: "GOOGLE_DRIVEN_UPGRADE",
	}
	Cluster_MaintenanceEvent_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":       0,
		"USER_INITIATED_UPGRADE": 1,
		"GOOGLE_DRIVEN_UPGRADE":  2,
	}
)

func (x Cluster_MaintenanceEvent_Type) Enum() *Cluster_MaintenanceEvent_Type {
	p := new(Cluster_MaintenanceEvent_Type)
	*p = x
	return p
}

func (x Cluster_MaintenanceEvent_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_MaintenanceEvent_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_edgecontainer_v1_resources_proto_enumTypes[4].Descriptor()
}

func (Cluster_MaintenanceEvent_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_edgecontainer_v1_resources_proto_enumTypes[4]
}

func (x Cluster_MaintenanceEvent_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_MaintenanceEvent_Type.Descriptor instead.
func (Cluster_MaintenanceEvent_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{0, 3, 0}
}

// Indicates when the maintenance event should be performed.
type Cluster_MaintenanceEvent_Schedule int32

const (
	// Unspecified.
	Cluster_MaintenanceEvent_SCHEDULE_UNSPECIFIED Cluster_MaintenanceEvent_Schedule = 0
	// Immediately after receiving the request.
	Cluster_MaintenanceEvent_IMMEDIATELY Cluster_MaintenanceEvent_Schedule = 1
)

// Enum value maps for Cluster_MaintenanceEvent_Schedule.
var (
	Cluster_MaintenanceEvent_Schedule_name = map[int32]string{
		0: "SCHEDULE_UNSPECIFIED",
		1: "IMMEDIATELY",
	}
	Cluster_MaintenanceEvent_Schedule_value = map[string]int32{
		"SCHEDULE_UNSPECIFIED": 0,
		"IMMEDIATELY":          1,
	}
)

func (x Cluster_MaintenanceEvent_Schedule) Enum() *Cluster_MaintenanceEvent_Schedule {
	p := new(Cluster_MaintenanceEvent_Schedule)
	*p = x
	return p
}

func (x Cluster_MaintenanceEvent_Schedule) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_MaintenanceEvent_Schedule) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_edgecontainer_v1_resources_proto_enumTypes[5].Descriptor()
}

func (Cluster_MaintenanceEvent_Schedule) Type() protoreflect.EnumType {
	return &file_google_cloud_edgecontainer_v1_resources_proto_enumTypes[5]
}

func (x Cluster_MaintenanceEvent_Schedule) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_MaintenanceEvent_Schedule.Descriptor instead.
func (Cluster_MaintenanceEvent_Schedule) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{0, 3, 1}
}

// Indicates the maintenance event state.
type Cluster_MaintenanceEvent_State int32

const (
	// Unspecified.
	Cluster_MaintenanceEvent_STATE_UNSPECIFIED Cluster_MaintenanceEvent_State = 0
	// The maintenance event is ongoing. The cluster might be unusable.
	Cluster_MaintenanceEvent_RECONCILING Cluster_MaintenanceEvent_State = 1
	// The maintenance event succeeded.
	Cluster_MaintenanceEvent_SUCCEEDED Cluster_MaintenanceEvent_State = 2
	// The maintenance event failed.
	Cluster_MaintenanceEvent_FAILED Cluster_MaintenanceEvent_State = 3
)

// Enum value maps for Cluster_MaintenanceEvent_State.
var (
	Cluster_MaintenanceEvent_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "RECONCILING",
		2: "SUCCEEDED",
		3: "FAILED",
	}
	Cluster_MaintenanceEvent_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RECONCILING":       1,
		"SUCCEEDED":         2,
		"FAILED":            3,
	}
)

func (x Cluster_MaintenanceEvent_State) Enum() *Cluster_MaintenanceEvent_State {
	p := new(Cluster_MaintenanceEvent_State)
	*p = x
	return p
}

func (x Cluster_MaintenanceEvent_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_MaintenanceEvent_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_edgecontainer_v1_resources_proto_enumTypes[6].Descriptor()
}

func (Cluster_MaintenanceEvent_State) Type() protoreflect.EnumType {
	return &file_google_cloud_edgecontainer_v1_resources_proto_enumTypes[6]
}

func (x Cluster_MaintenanceEvent_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_MaintenanceEvent_State.Descriptor instead.
func (Cluster_MaintenanceEvent_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{0, 3, 2}
}

// Routing mode.
type VpnConnection_BgpRoutingMode int32

const (
	// Unknown.
	VpnConnection_BGP_ROUTING_MODE_UNSPECIFIED VpnConnection_BgpRoutingMode = 0
	// Regional mode.
	VpnConnection_REGIONAL VpnConnection_BgpRoutingMode = 1
	// Global mode.
	VpnConnection_GLOBAL VpnConnection_BgpRoutingMode = 2
)

// Enum value maps for VpnConnection_BgpRoutingMode.
var (
	VpnConnection_BgpRoutingMode_name = map[int32]string{
		0: "BGP_ROUTING_MODE_UNSPECIFIED",
		1: "REGIONAL",
		2: "GLOBAL",
	}
	VpnConnection_BgpRoutingMode_value = map[string]int32{
		"BGP_ROUTING_MODE_UNSPECIFIED": 0,
		"REGIONAL":                     1,
		"GLOBAL":                       2,
	}
)

func (x VpnConnection_BgpRoutingMode) Enum() *VpnConnection_BgpRoutingMode {
	p := new(VpnConnection_BgpRoutingMode)
	*p = x
	return p
}

func (x VpnConnection_BgpRoutingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VpnConnection_BgpRoutingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_edgecontainer_v1_resources_proto_enumTypes[7].Descriptor()
}

func (VpnConnection_BgpRoutingMode) Type() protoreflect.EnumType {
	return &file_google_cloud_edgecontainer_v1_resources_proto_enumTypes[7]
}

func (x VpnConnection_BgpRoutingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VpnConnection_BgpRoutingMode.Descriptor instead.
func (VpnConnection_BgpRoutingMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{7, 0}
}

// The current connection state.
type VpnConnection_Details_State int32

const (
	// Unknown.
	VpnConnection_Details_STATE_UNSPECIFIED VpnConnection_Details_State = 0
	// Connected.
	VpnConnection_Details_STATE_CONNECTED VpnConnection_Details_State = 1
	// Still connecting.
	VpnConnection_Details_STATE_CONNECTING VpnConnection_Details_State = 2
	// Error occurred.
	VpnConnection_Details_STATE_ERROR VpnConnection_Details_State = 3
)

// Enum value maps for VpnConnection_Details_State.
var (
	VpnConnection_Details_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "STATE_CONNECTED",
		2: "STATE_CONNECTING",
		3: "STATE_ERROR",
	}
	VpnConnection_Details_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"STATE_CONNECTED":   1,
		"STATE_CONNECTING":  2,
		"STATE_ERROR":       3,
	}
)

func (x VpnConnection_Details_State) Enum() *VpnConnection_Details_State {
	p := new(VpnConnection_Details_State)
	*p = x
	return p
}

func (x VpnConnection_Details_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VpnConnection_Details_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_edgecontainer_v1_resources_proto_enumTypes[8].Descriptor()
}

func (VpnConnection_Details_State) Type() protoreflect.EnumType {
	return &file_google_cloud_edgecontainer_v1_resources_proto_enumTypes[8]
}

func (x VpnConnection_Details_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VpnConnection_Details_State.Descriptor instead.
func (VpnConnection_Details_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{7, 1, 0}
}

// Type of the rack.
type ZoneMetadata_RackType int32

const (
	// Unspecified rack type, single rack also belongs to this type.
	ZoneMetadata_RACK_TYPE_UNSPECIFIED ZoneMetadata_RackType = 0
	// Base rack type, a pair of two modified Config-1 racks containing
	// Aggregation switches.
	ZoneMetadata_BASE ZoneMetadata_RackType = 1
	// Expansion rack type, also known as standalone racks,
	// added by customers on demand.
	ZoneMetadata_EXPANSION ZoneMetadata_RackType = 2
)

// Enum value maps for ZoneMetadata_RackType.
var (
	ZoneMetadata_RackType_name = map[int32]string{
		0: "RACK_TYPE_UNSPECIFIED",
		1: "BASE",
		2: "EXPANSION",
	}
	ZoneMetadata_RackType_value = map[string]int32{
		"RACK_TYPE_UNSPECIFIED": 0,
		"BASE":                  1,
		"EXPANSION":             2,
	}
)

func (x ZoneMetadata_RackType) Enum() *ZoneMetadata_RackType {
	p := new(ZoneMetadata_RackType)
	*p = x
	return p
}

func (x ZoneMetadata_RackType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ZoneMetadata_RackType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_edgecontainer_v1_resources_proto_enumTypes[9].Descriptor()
}

func (ZoneMetadata_RackType) Type() protoreflect.EnumType {
	return &file_google_cloud_edgecontainer_v1_resources_proto_enumTypes[9]
}

func (x ZoneMetadata_RackType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ZoneMetadata_RackType.Descriptor instead.
func (ZoneMetadata_RackType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{9, 0}
}

// A Google Distributed Cloud Edge Kubernetes cluster.
type Cluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the cluster.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time when the cluster was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the cluster was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels associated with this resource.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Fleet configuration.
	Fleet *Fleet `protobuf:"bytes,11,opt,name=fleet,proto3" json:"fleet,omitempty"`
	// Required. Cluster-wide networking configuration.
	Networking *ClusterNetworking `protobuf:"bytes,7,opt,name=networking,proto3" json:"networking,omitempty"`
	// Required. Immutable. RBAC policy that will be applied and managed by GEC.
	Authorization *Authorization `protobuf:"bytes,9,opt,name=authorization,proto3" json:"authorization,omitempty"`
	// Optional. The default maximum number of pods per node used if a maximum
	// value is not specified explicitly for a node pool in this cluster. If
	// unspecified, the Kubernetes default value will be used.
	DefaultMaxPodsPerNode int32 `protobuf:"varint,8,opt,name=default_max_pods_per_node,json=defaultMaxPodsPerNode,proto3" json:"default_max_pods_per_node,omitempty"`
	// Output only. The IP address of the Kubernetes API server.
	Endpoint string `protobuf:"bytes,6,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Output only. The port number of the Kubernetes API server.
	Port int32 `protobuf:"varint,19,opt,name=port,proto3" json:"port,omitempty"`
	// Output only. The PEM-encoded public certificate of the cluster's CA.
	ClusterCaCertificate string `protobuf:"bytes,10,opt,name=cluster_ca_certificate,json=clusterCaCertificate,proto3" json:"cluster_ca_certificate,omitempty"`
	// Optional. Cluster-wide maintenance policy configuration.
	MaintenancePolicy *MaintenancePolicy `protobuf:"bytes,12,opt,name=maintenance_policy,json=maintenancePolicy,proto3" json:"maintenance_policy,omitempty"`
	// Output only. The control plane release version
	ControlPlaneVersion string `protobuf:"bytes,13,opt,name=control_plane_version,json=controlPlaneVersion,proto3" json:"control_plane_version,omitempty"`
	// Output only. The lowest release version among all worker nodes. This field
	// can be empty if the cluster does not have any worker nodes.
	NodeVersion string `protobuf:"bytes,14,opt,name=node_version,json=nodeVersion,proto3" json:"node_version,omitempty"`
	// Optional. The configuration of the cluster control plane.
	ControlPlane *Cluster_ControlPlane `protobuf:"bytes,15,opt,name=control_plane,json=controlPlane,proto3" json:"control_plane,omitempty"`
	// Optional. The configuration of the system add-ons.
	SystemAddonsConfig *Cluster_SystemAddonsConfig `protobuf:"bytes,16,opt,name=system_addons_config,json=systemAddonsConfig,proto3" json:"system_addons_config,omitempty"`
	// Optional. IPv4 address pools for cluster data plane external load
	// balancing.
	ExternalLoadBalancerIpv4AddressPools []string `protobuf:"bytes,17,rep,name=external_load_balancer_ipv4_address_pools,json=externalLoadBalancerIpv4AddressPools,proto3" json:"external_load_balancer_ipv4_address_pools,omitempty"`
	// Optional. Remote control plane disk encryption options. This field is only
	// used when enabling CMEK support.
	ControlPlaneEncryption *Cluster_ControlPlaneEncryption `protobuf:"bytes,18,opt,name=control_plane_encryption,json=controlPlaneEncryption,proto3" json:"control_plane_encryption,omitempty"`
	// Output only. The current status of the cluster.
	Status Cluster_Status `protobuf:"varint,20,opt,name=status,proto3,enum=google.cloud.edgecontainer.v1.Cluster_Status" json:"status,omitempty"`
	// Output only. All the maintenance events scheduled for the cluster,
	// including the ones ongoing, planned for the future and done in the past (up
	// to 90 days).
	MaintenanceEvents []*Cluster_MaintenanceEvent `protobuf:"bytes,21,rep,name=maintenance_events,json=maintenanceEvents,proto3" json:"maintenance_events,omitempty"`
	// Optional. The target cluster version. For example: "1.5.0".
	TargetVersion string `protobuf:"bytes,22,opt,name=target_version,json=targetVersion,proto3" json:"target_version,omitempty"`
	// Optional. The release channel a cluster is subscribed to.
	ReleaseChannel Cluster_ReleaseChannel `protobuf:"varint,23,opt,name=release_channel,json=releaseChannel,proto3,enum=google.cloud.edgecontainer.v1.Cluster_ReleaseChannel" json:"release_channel,omitempty"`
	// Optional. Configuration of the cluster survivability, e.g., for the case
	// when network connectivity is lost. Note: This only applies to local control
	// plane clusters.
	SurvivabilityConfig *Cluster_SurvivabilityConfig `protobuf:"bytes,24,opt,name=survivability_config,json=survivabilityConfig,proto3" json:"survivability_config,omitempty"`
	// Optional. IPv6 address pools for cluster data plane external load
	// balancing.
	ExternalLoadBalancerIpv6AddressPools []string `protobuf:"bytes,25,rep,name=external_load_balancer_ipv6_address_pools,json=externalLoadBalancerIpv6AddressPools,proto3" json:"external_load_balancer_ipv6_address_pools,omitempty"`
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{0}
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Cluster) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Cluster) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Cluster) GetFleet() *Fleet {
	if x != nil {
		return x.Fleet
	}
	return nil
}

func (x *Cluster) GetNetworking() *ClusterNetworking {
	if x != nil {
		return x.Networking
	}
	return nil
}

func (x *Cluster) GetAuthorization() *Authorization {
	if x != nil {
		return x.Authorization
	}
	return nil
}

func (x *Cluster) GetDefaultMaxPodsPerNode() int32 {
	if x != nil {
		return x.DefaultMaxPodsPerNode
	}
	return 0
}

func (x *Cluster) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *Cluster) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *Cluster) GetClusterCaCertificate() string {
	if x != nil {
		return x.ClusterCaCertificate
	}
	return ""
}

func (x *Cluster) GetMaintenancePolicy() *MaintenancePolicy {
	if x != nil {
		return x.MaintenancePolicy
	}
	return nil
}

func (x *Cluster) GetControlPlaneVersion() string {
	if x != nil {
		return x.ControlPlaneVersion
	}
	return ""
}

func (x *Cluster) GetNodeVersion() string {
	if x != nil {
		return x.NodeVersion
	}
	return ""
}

func (x *Cluster) GetControlPlane() *Cluster_ControlPlane {
	if x != nil {
		return x.ControlPlane
	}
	return nil
}

func (x *Cluster) GetSystemAddonsConfig() *Cluster_SystemAddonsConfig {
	if x != nil {
		return x.SystemAddonsConfig
	}
	return nil
}

func (x *Cluster) GetExternalLoadBalancerIpv4AddressPools() []string {
	if x != nil {
		return x.ExternalLoadBalancerIpv4AddressPools
	}
	return nil
}

func (x *Cluster) GetControlPlaneEncryption() *Cluster_ControlPlaneEncryption {
	if x != nil {
		return x.ControlPlaneEncryption
	}
	return nil
}

func (x *Cluster) GetStatus() Cluster_Status {
	if x != nil {
		return x.Status
	}
	return Cluster_STATUS_UNSPECIFIED
}

func (x *Cluster) GetMaintenanceEvents() []*Cluster_MaintenanceEvent {
	if x != nil {
		return x.MaintenanceEvents
	}
	return nil
}

func (x *Cluster) GetTargetVersion() string {
	if x != nil {
		return x.TargetVersion
	}
	return ""
}

func (x *Cluster) GetReleaseChannel() Cluster_ReleaseChannel {
	if x != nil {
		return x.ReleaseChannel
	}
	return Cluster_RELEASE_CHANNEL_UNSPECIFIED
}

func (x *Cluster) GetSurvivabilityConfig() *Cluster_SurvivabilityConfig {
	if x != nil {
		return x.SurvivabilityConfig
	}
	return nil
}

func (x *Cluster) GetExternalLoadBalancerIpv6AddressPools() []string {
	if x != nil {
		return x.ExternalLoadBalancerIpv6AddressPools
	}
	return nil
}

// Cluster-wide networking configuration.
type ClusterNetworking struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. All pods in the cluster are assigned an RFC1918 IPv4 address from
	// these blocks. Only a single block is supported. This field cannot be
	// changed after creation.
	ClusterIpv4CidrBlocks []string `protobuf:"bytes,1,rep,name=cluster_ipv4_cidr_blocks,json=clusterIpv4CidrBlocks,proto3" json:"cluster_ipv4_cidr_blocks,omitempty"`
	// Required. All services in the cluster are assigned an RFC1918 IPv4 address
	// from these blocks. Only a single block is supported. This field cannot be
	// changed after creation.
	ServicesIpv4CidrBlocks []string `protobuf:"bytes,2,rep,name=services_ipv4_cidr_blocks,json=servicesIpv4CidrBlocks,proto3" json:"services_ipv4_cidr_blocks,omitempty"`
}

func (x *ClusterNetworking) Reset() {
	*x = ClusterNetworking{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClusterNetworking) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterNetworking) ProtoMessage() {}

func (x *ClusterNetworking) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterNetworking.ProtoReflect.Descriptor instead.
func (*ClusterNetworking) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{1}
}

func (x *ClusterNetworking) GetClusterIpv4CidrBlocks() []string {
	if x != nil {
		return x.ClusterIpv4CidrBlocks
	}
	return nil
}

func (x *ClusterNetworking) GetServicesIpv4CidrBlocks() []string {
	if x != nil {
		return x.ServicesIpv4CidrBlocks
	}
	return nil
}

// Fleet related configuration.
//
// Fleets are a Google Cloud concept for logically organizing clusters,
// letting you use and manage multi-cluster capabilities and apply
// consistent policies across your systems.
type Fleet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Fleet host project where this cluster will be
	// registered.
	//
	// Project names are formatted as
	// `projects/<project-number>`.
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// Output only. The name of the managed Hub Membership resource associated to
	// this cluster.
	//
	// Membership names are formatted as
	// `projects/<project-number>/locations/global/membership/<cluster-id>`.
	Membership string `protobuf:"bytes,2,opt,name=membership,proto3" json:"membership,omitempty"`
}

func (x *Fleet) Reset() {
	*x = Fleet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Fleet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Fleet) ProtoMessage() {}

func (x *Fleet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Fleet.ProtoReflect.Descriptor instead.
func (*Fleet) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{2}
}

func (x *Fleet) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *Fleet) GetMembership() string {
	if x != nil {
		return x.Membership
	}
	return ""
}

// A user principal for an RBAC policy.
type ClusterUser struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. An active Google username.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
}

func (x *ClusterUser) Reset() {
	*x = ClusterUser{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClusterUser) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterUser) ProtoMessage() {}

func (x *ClusterUser) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterUser.ProtoReflect.Descriptor instead.
func (*ClusterUser) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{3}
}

func (x *ClusterUser) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

// RBAC policy that will be applied and managed by GEC.
type Authorization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. User that will be granted the cluster-admin role on the cluster,
	// providing full access to the cluster. Currently, this is a singular field,
	// but will be expanded to allow multiple admins in the future.
	AdminUsers *ClusterUser `protobuf:"bytes,1,opt,name=admin_users,json=adminUsers,proto3" json:"admin_users,omitempty"`
}

func (x *Authorization) Reset() {
	*x = Authorization{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Authorization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Authorization) ProtoMessage() {}

func (x *Authorization) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Authorization.ProtoReflect.Descriptor instead.
func (*Authorization) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{4}
}

func (x *Authorization) GetAdminUsers() *ClusterUser {
	if x != nil {
		return x.AdminUsers
	}
	return nil
}

// A set of Kubernetes nodes in a cluster with common configuration and
// specification.
type NodePool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the node pool.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time when the node pool was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the node pool was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels associated with this resource.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Name of the Google Distributed Cloud Edge zone where this node pool will be
	// created. For example: `us-central1-edge-customer-a`.
	NodeLocation string `protobuf:"bytes,8,opt,name=node_location,json=nodeLocation,proto3" json:"node_location,omitempty"`
	// Required. The number of nodes in the pool.
	NodeCount int32 `protobuf:"varint,6,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// Only machines matching this filter will be allowed to join the node pool.
	// The filtering language accepts strings like "name=<name>", and is
	// documented in more detail in [AIP-160](https://google.aip.dev/160).
	MachineFilter string `protobuf:"bytes,7,opt,name=machine_filter,json=machineFilter,proto3" json:"machine_filter,omitempty"`
	// Optional. Local disk encryption options. This field is only used when
	// enabling CMEK support.
	LocalDiskEncryption *NodePool_LocalDiskEncryption `protobuf:"bytes,9,opt,name=local_disk_encryption,json=localDiskEncryption,proto3" json:"local_disk_encryption,omitempty"`
	// Output only. The lowest release version among all worker nodes.
	NodeVersion string `protobuf:"bytes,10,opt,name=node_version,json=nodeVersion,proto3" json:"node_version,omitempty"`
	// Optional. Configuration for each node in the NodePool
	NodeConfig *NodePool_NodeConfig `protobuf:"bytes,11,opt,name=node_config,json=nodeConfig,proto3" json:"node_config,omitempty"`
}

func (x *NodePool) Reset() {
	*x = NodePool{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodePool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodePool) ProtoMessage() {}

func (x *NodePool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodePool.ProtoReflect.Descriptor instead.
func (*NodePool) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{5}
}

func (x *NodePool) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NodePool) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *NodePool) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *NodePool) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *NodePool) GetNodeLocation() string {
	if x != nil {
		return x.NodeLocation
	}
	return ""
}

func (x *NodePool) GetNodeCount() int32 {
	if x != nil {
		return x.NodeCount
	}
	return 0
}

func (x *NodePool) GetMachineFilter() string {
	if x != nil {
		return x.MachineFilter
	}
	return ""
}

func (x *NodePool) GetLocalDiskEncryption() *NodePool_LocalDiskEncryption {
	if x != nil {
		return x.LocalDiskEncryption
	}
	return nil
}

func (x *NodePool) GetNodeVersion() string {
	if x != nil {
		return x.NodeVersion
	}
	return ""
}

func (x *NodePool) GetNodeConfig() *NodePool_NodeConfig {
	if x != nil {
		return x.NodeConfig
	}
	return nil
}

// A Google Distributed Cloud Edge machine capable of acting as a Kubernetes
// node.
type Machine struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the machine.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time when the node pool was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the node pool was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels associated with this resource.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Canonical resource name of the node that this machine is responsible for
	// hosting e.g.
	// projects/{project}/locations/{location}/clusters/{cluster_id}/nodePools/{pool_id}/{node},
	// Or empty if the machine is not assigned to assume the role of a node.
	//
	// For control plane nodes hosted on edge machines, this will return
	// the following format:
	//
	//	"projects/{project}/locations/{location}/clusters/{cluster_id}/controlPlaneNodes/{node}".
	HostedNode string `protobuf:"bytes,5,opt,name=hosted_node,json=hostedNode,proto3" json:"hosted_node,omitempty"`
	// The Google Distributed Cloud Edge zone of this machine.
	Zone string `protobuf:"bytes,6,opt,name=zone,proto3" json:"zone,omitempty"`
	// Output only. The software version of the machine.
	Version string `protobuf:"bytes,7,opt,name=version,proto3" json:"version,omitempty"`
	// Output only. Whether the machine is disabled. If disabled, the machine is
	// unable to enter service.
	Disabled bool `protobuf:"varint,8,opt,name=disabled,proto3" json:"disabled,omitempty"`
}

func (x *Machine) Reset() {
	*x = Machine{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Machine) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Machine) ProtoMessage() {}

func (x *Machine) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Machine.ProtoReflect.Descriptor instead.
func (*Machine) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{6}
}

func (x *Machine) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Machine) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Machine) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Machine) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Machine) GetHostedNode() string {
	if x != nil {
		return x.HostedNode
	}
	return ""
}

func (x *Machine) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *Machine) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Machine) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

// A VPN connection .
type VpnConnection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of VPN connection
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time when the VPN connection was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the VPN connection was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels associated with this resource.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// NAT gateway IP, or WAN IP address. If a customer has multiple NAT IPs, the
	// customer needs to configure NAT such that only one external IP maps to the
	// GMEC Anthos cluster. This is empty if NAT is not used.
	NatGatewayIp string `protobuf:"bytes,5,opt,name=nat_gateway_ip,json=natGatewayIp,proto3" json:"nat_gateway_ip,omitempty"`
	// Dynamic routing mode of the VPC network, `regional` or `global`.
	//
	// Deprecated: Marked as deprecated in google/cloud/edgecontainer/v1/resources.proto.
	BgpRoutingMode VpnConnection_BgpRoutingMode `protobuf:"varint,6,opt,name=bgp_routing_mode,json=bgpRoutingMode,proto3,enum=google.cloud.edgecontainer.v1.VpnConnection_BgpRoutingMode" json:"bgp_routing_mode,omitempty"`
	// The canonical Cluster name to connect to. It is in the form of
	// projects/{project}/locations/{location}/clusters/{cluster}.
	Cluster string `protobuf:"bytes,7,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// The network ID of VPC to connect to.
	Vpc string `protobuf:"bytes,8,opt,name=vpc,proto3" json:"vpc,omitempty"`
	// Optional. Project detail of the VPC network. Required if VPC is in a
	// different project than the cluster project.
	VpcProject *VpnConnection_VpcProject `protobuf:"bytes,11,opt,name=vpc_project,json=vpcProject,proto3" json:"vpc_project,omitempty"`
	// Whether this VPN connection has HA enabled on cluster side. If enabled,
	// when creating VPN connection we will attempt to use 2 ANG floating IPs.
	EnableHighAvailability bool `protobuf:"varint,9,opt,name=enable_high_availability,json=enableHighAvailability,proto3" json:"enable_high_availability,omitempty"`
	// Optional. The VPN connection Cloud Router name.
	Router string `protobuf:"bytes,12,opt,name=router,proto3" json:"router,omitempty"`
	// Output only. The created connection details.
	Details *VpnConnection_Details `protobuf:"bytes,10,opt,name=details,proto3" json:"details,omitempty"`
}

func (x *VpnConnection) Reset() {
	*x = VpnConnection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VpnConnection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VpnConnection) ProtoMessage() {}

func (x *VpnConnection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VpnConnection.ProtoReflect.Descriptor instead.
func (*VpnConnection) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{7}
}

func (x *VpnConnection) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VpnConnection) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *VpnConnection) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *VpnConnection) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *VpnConnection) GetNatGatewayIp() string {
	if x != nil {
		return x.NatGatewayIp
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/edgecontainer/v1/resources.proto.
func (x *VpnConnection) GetBgpRoutingMode() VpnConnection_BgpRoutingMode {
	if x != nil {
		return x.BgpRoutingMode
	}
	return VpnConnection_BGP_ROUTING_MODE_UNSPECIFIED
}

func (x *VpnConnection) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

func (x *VpnConnection) GetVpc() string {
	if x != nil {
		return x.Vpc
	}
	return ""
}

func (x *VpnConnection) GetVpcProject() *VpnConnection_VpcProject {
	if x != nil {
		return x.VpcProject
	}
	return nil
}

func (x *VpnConnection) GetEnableHighAvailability() bool {
	if x != nil {
		return x.EnableHighAvailability
	}
	return false
}

func (x *VpnConnection) GetRouter() string {
	if x != nil {
		return x.Router
	}
	return ""
}

func (x *VpnConnection) GetDetails() *VpnConnection_Details {
	if x != nil {
		return x.Details
	}
	return nil
}

// Metadata for a given
// [google.cloud.location.Location][google.cloud.location.Location].
type LocationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of available Google Distributed Cloud Edge zones in the location.
	// The map is keyed by the lowercase ID of each zone.
	AvailableZones map[string]*ZoneMetadata `protobuf:"bytes,1,rep,name=available_zones,json=availableZones,proto3" json:"available_zones,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *LocationMetadata) Reset() {
	*x = LocationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LocationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocationMetadata) ProtoMessage() {}

func (x *LocationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocationMetadata.ProtoReflect.Descriptor instead.
func (*LocationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{8}
}

func (x *LocationMetadata) GetAvailableZones() map[string]*ZoneMetadata {
	if x != nil {
		return x.AvailableZones
	}
	return nil
}

// A Google Distributed Cloud Edge zone where edge machines are located.
type ZoneMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Quota for resources in this zone.
	Quota []*Quota `protobuf:"bytes,1,rep,name=quota,proto3" json:"quota,omitempty"`
	// The map keyed by rack name and has value of RackType.
	RackTypes map[string]ZoneMetadata_RackType `protobuf:"bytes,2,rep,name=rack_types,json=rackTypes,proto3" json:"rack_types,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=google.cloud.edgecontainer.v1.ZoneMetadata_RackType"`
}

func (x *ZoneMetadata) Reset() {
	*x = ZoneMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ZoneMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ZoneMetadata) ProtoMessage() {}

func (x *ZoneMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ZoneMetadata.ProtoReflect.Descriptor instead.
func (*ZoneMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{9}
}

func (x *ZoneMetadata) GetQuota() []*Quota {
	if x != nil {
		return x.Quota
	}
	return nil
}

func (x *ZoneMetadata) GetRackTypes() map[string]ZoneMetadata_RackType {
	if x != nil {
		return x.RackTypes
	}
	return nil
}

// Represents quota for Edge Container resources.
type Quota struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the quota metric.
	Metric string `protobuf:"bytes,1,opt,name=metric,proto3" json:"metric,omitempty"`
	// Quota limit for this metric.
	Limit float64 `protobuf:"fixed64,2,opt,name=limit,proto3" json:"limit,omitempty"`
	// Current usage of this metric.
	Usage float64 `protobuf:"fixed64,3,opt,name=usage,proto3" json:"usage,omitempty"`
}

func (x *Quota) Reset() {
	*x = Quota{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Quota) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Quota) ProtoMessage() {}

func (x *Quota) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Quota.ProtoReflect.Descriptor instead.
func (*Quota) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{10}
}

func (x *Quota) GetMetric() string {
	if x != nil {
		return x.Metric
	}
	return ""
}

func (x *Quota) GetLimit() float64 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *Quota) GetUsage() float64 {
	if x != nil {
		return x.Usage
	}
	return 0
}

// Maintenance policy configuration.
type MaintenancePolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the maintenance window in which maintenance may be performed.
	Window *MaintenanceWindow `protobuf:"bytes,1,opt,name=window,proto3" json:"window,omitempty"`
}

func (x *MaintenancePolicy) Reset() {
	*x = MaintenancePolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MaintenancePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MaintenancePolicy) ProtoMessage() {}

func (x *MaintenancePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MaintenancePolicy.ProtoReflect.Descriptor instead.
func (*MaintenancePolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{11}
}

func (x *MaintenancePolicy) GetWindow() *MaintenanceWindow {
	if x != nil {
		return x.Window
	}
	return nil
}

// Maintenance window configuration
type MaintenanceWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration of a recurring maintenance window.
	RecurringWindow *RecurringTimeWindow `protobuf:"bytes,1,opt,name=recurring_window,json=recurringWindow,proto3" json:"recurring_window,omitempty"`
}

func (x *MaintenanceWindow) Reset() {
	*x = MaintenanceWindow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MaintenanceWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MaintenanceWindow) ProtoMessage() {}

func (x *MaintenanceWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MaintenanceWindow.ProtoReflect.Descriptor instead.
func (*MaintenanceWindow) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{12}
}

func (x *MaintenanceWindow) GetRecurringWindow() *RecurringTimeWindow {
	if x != nil {
		return x.RecurringWindow
	}
	return nil
}

// Represents an arbitrary window of time that recurs.
type RecurringTimeWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The window of the first recurrence.
	Window *TimeWindow `protobuf:"bytes,1,opt,name=window,proto3" json:"window,omitempty"`
	// An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3) for how
	// this window recurs. They go on for the span of time between the start and
	// end time.
	Recurrence string `protobuf:"bytes,2,opt,name=recurrence,proto3" json:"recurrence,omitempty"`
}

func (x *RecurringTimeWindow) Reset() {
	*x = RecurringTimeWindow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RecurringTimeWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RecurringTimeWindow) ProtoMessage() {}

func (x *RecurringTimeWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RecurringTimeWindow.ProtoReflect.Descriptor instead.
func (*RecurringTimeWindow) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{13}
}

func (x *RecurringTimeWindow) GetWindow() *TimeWindow {
	if x != nil {
		return x.Window
	}
	return nil
}

func (x *RecurringTimeWindow) GetRecurrence() string {
	if x != nil {
		return x.Recurrence
	}
	return ""
}

// Represents an arbitrary window of time.
type TimeWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time that the window first starts.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time that the window ends. The end time must take place after the
	// start time.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *TimeWindow) Reset() {
	*x = TimeWindow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeWindow) ProtoMessage() {}

func (x *TimeWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeWindow.ProtoReflect.Descriptor instead.
func (*TimeWindow) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{14}
}

func (x *TimeWindow) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *TimeWindow) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// Server configuration for supported versions and release channels.
type ServerConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Mapping from release channel to channel config.
	Channels map[string]*ChannelConfig `protobuf:"bytes,1,rep,name=channels,proto3" json:"channels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Supported versions, e.g.: ["1.4.0", "1.5.0"].
	Versions []*Version `protobuf:"bytes,2,rep,name=versions,proto3" json:"versions,omitempty"`
	// Output only. Default version, e.g.: "1.4.0".
	DefaultVersion string `protobuf:"bytes,3,opt,name=default_version,json=defaultVersion,proto3" json:"default_version,omitempty"`
}

func (x *ServerConfig) Reset() {
	*x = ServerConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerConfig) ProtoMessage() {}

func (x *ServerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerConfig.ProtoReflect.Descriptor instead.
func (*ServerConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{15}
}

func (x *ServerConfig) GetChannels() map[string]*ChannelConfig {
	if x != nil {
		return x.Channels
	}
	return nil
}

func (x *ServerConfig) GetVersions() []*Version {
	if x != nil {
		return x.Versions
	}
	return nil
}

func (x *ServerConfig) GetDefaultVersion() string {
	if x != nil {
		return x.DefaultVersion
	}
	return ""
}

// Configuration for a release channel.
type ChannelConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Default version for this release channel, e.g.: "1.4.0".
	DefaultVersion string `protobuf:"bytes,1,opt,name=default_version,json=defaultVersion,proto3" json:"default_version,omitempty"`
}

func (x *ChannelConfig) Reset() {
	*x = ChannelConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChannelConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChannelConfig) ProtoMessage() {}

func (x *ChannelConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChannelConfig.ProtoReflect.Descriptor instead.
func (*ChannelConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{16}
}

func (x *ChannelConfig) GetDefaultVersion() string {
	if x != nil {
		return x.DefaultVersion
	}
	return ""
}

// Version of a cluster.
type Version struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Name of the version, e.g.: "1.4.0".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *Version) Reset() {
	*x = Version{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Version) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Version) ProtoMessage() {}

func (x *Version) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Version.ProtoReflect.Descriptor instead.
func (*Version) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{17}
}

func (x *Version) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Configuration of the cluster control plane.
type Cluster_ControlPlane struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Config:
	//
	//	*Cluster_ControlPlane_Remote_
	//	*Cluster_ControlPlane_Local_
	Config isCluster_ControlPlane_Config `protobuf_oneof:"config"`
}

func (x *Cluster_ControlPlane) Reset() {
	*x = Cluster_ControlPlane{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cluster_ControlPlane) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster_ControlPlane) ProtoMessage() {}

func (x *Cluster_ControlPlane) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster_ControlPlane.ProtoReflect.Descriptor instead.
func (*Cluster_ControlPlane) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{0, 0}
}

func (m *Cluster_ControlPlane) GetConfig() isCluster_ControlPlane_Config {
	if m != nil {
		return m.Config
	}
	return nil
}

func (x *Cluster_ControlPlane) GetRemote() *Cluster_ControlPlane_Remote {
	if x, ok := x.GetConfig().(*Cluster_ControlPlane_Remote_); ok {
		return x.Remote
	}
	return nil
}

func (x *Cluster_ControlPlane) GetLocal() *Cluster_ControlPlane_Local {
	if x, ok := x.GetConfig().(*Cluster_ControlPlane_Local_); ok {
		return x.Local
	}
	return nil
}

type isCluster_ControlPlane_Config interface {
	isCluster_ControlPlane_Config()
}

type Cluster_ControlPlane_Remote_ struct {
	// Remote control plane configuration.
	Remote *Cluster_ControlPlane_Remote `protobuf:"bytes,1,opt,name=remote,proto3,oneof"`
}

type Cluster_ControlPlane_Local_ struct {
	// Local control plane configuration.
	//
	// Warning: Local control plane clusters must be created in their own
	// project. Local control plane clusters cannot coexist in the same
	// project with any other type of clusters, including non-GDCE clusters.
	// Mixing local control plane GDCE clusters with any other type of
	// clusters in the same project can result in data loss.
	Local *Cluster_ControlPlane_Local `protobuf:"bytes,2,opt,name=local,proto3,oneof"`
}

func (*Cluster_ControlPlane_Remote_) isCluster_ControlPlane_Config() {}

func (*Cluster_ControlPlane_Local_) isCluster_ControlPlane_Config() {}

// Config that customers are allowed to define for GDCE system add-ons.
type Cluster_SystemAddonsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Config for Ingress.
	Ingress *Cluster_SystemAddonsConfig_Ingress `protobuf:"bytes,1,opt,name=ingress,proto3" json:"ingress,omitempty"`
}

func (x *Cluster_SystemAddonsConfig) Reset() {
	*x = Cluster_SystemAddonsConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cluster_SystemAddonsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster_SystemAddonsConfig) ProtoMessage() {}

func (x *Cluster_SystemAddonsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster_SystemAddonsConfig.ProtoReflect.Descriptor instead.
func (*Cluster_SystemAddonsConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Cluster_SystemAddonsConfig) GetIngress() *Cluster_SystemAddonsConfig_Ingress {
	if x != nil {
		return x.Ingress
	}
	return nil
}

// Configuration for Customer-managed KMS key support for remote control plane
// cluster disk encryption.
type Cluster_ControlPlaneEncryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The Cloud KMS CryptoKey e.g.
	// projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey}
	// to use for protecting control plane disks. If not specified, a
	// Google-managed key will be used instead.
	KmsKey string `protobuf:"bytes,1,opt,name=kms_key,json=kmsKey,proto3" json:"kms_key,omitempty"`
	// Output only. The Cloud KMS CryptoKeyVersion currently in use for
	// protecting control plane disks. Only applicable if kms_key is set.
	KmsKeyActiveVersion string `protobuf:"bytes,2,opt,name=kms_key_active_version,json=kmsKeyActiveVersion,proto3" json:"kms_key_active_version,omitempty"`
	// Output only. Availability of the Cloud KMS CryptoKey. If not
	// `KEY_AVAILABLE`, then nodes may go offline as they cannot access their
	// local data. This can be caused by a lack of permissions to use the key,
	// or if the key is disabled or deleted.
	KmsKeyState KmsKeyState `protobuf:"varint,3,opt,name=kms_key_state,json=kmsKeyState,proto3,enum=google.cloud.edgecontainer.v1.KmsKeyState" json:"kms_key_state,omitempty"`
	// Output only. Error status returned by Cloud KMS when using this key. This
	// field may be populated only if `kms_key_state` is not
	// `KMS_KEY_STATE_KEY_AVAILABLE`. If populated, this field contains the
	// error status reported by Cloud KMS.
	KmsStatus *status.Status `protobuf:"bytes,4,opt,name=kms_status,json=kmsStatus,proto3" json:"kms_status,omitempty"`
}

func (x *Cluster_ControlPlaneEncryption) Reset() {
	*x = Cluster_ControlPlaneEncryption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cluster_ControlPlaneEncryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster_ControlPlaneEncryption) ProtoMessage() {}

func (x *Cluster_ControlPlaneEncryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster_ControlPlaneEncryption.ProtoReflect.Descriptor instead.
func (*Cluster_ControlPlaneEncryption) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Cluster_ControlPlaneEncryption) GetKmsKey() string {
	if x != nil {
		return x.KmsKey
	}
	return ""
}

func (x *Cluster_ControlPlaneEncryption) GetKmsKeyActiveVersion() string {
	if x != nil {
		return x.KmsKeyActiveVersion
	}
	return ""
}

func (x *Cluster_ControlPlaneEncryption) GetKmsKeyState() KmsKeyState {
	if x != nil {
		return x.KmsKeyState
	}
	return KmsKeyState_KMS_KEY_STATE_UNSPECIFIED
}

func (x *Cluster_ControlPlaneEncryption) GetKmsStatus() *status.Status {
	if x != nil {
		return x.KmsStatus
	}
	return nil
}

// A Maintenance Event is an operation that could cause temporary disruptions
// to the cluster workloads, including Google-driven or user-initiated cluster
// upgrades, user-initiated cluster configuration changes that require
// restarting nodes, etc.
type Cluster_MaintenanceEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. UUID of the maintenance event.
	Uuid string `protobuf:"bytes,1,opt,name=uuid,proto3" json:"uuid,omitempty"`
	// Output only. The target version of the cluster.
	TargetVersion string `protobuf:"bytes,2,opt,name=target_version,json=targetVersion,proto3" json:"target_version,omitempty"`
	// Output only. The operation for running the maintenance event. Specified
	// in the format projects/*/locations/*/operations/*. If the maintenance
	// event is split into multiple operations (e.g. due to maintenance
	// windows), the latest one is recorded.
	Operation string `protobuf:"bytes,3,opt,name=operation,proto3" json:"operation,omitempty"`
	// Output only. The type of the maintenance event.
	Type Cluster_MaintenanceEvent_Type `protobuf:"varint,4,opt,name=type,proto3,enum=google.cloud.edgecontainer.v1.Cluster_MaintenanceEvent_Type" json:"type,omitempty"`
	// Output only. The schedule of the maintenance event.
	Schedule Cluster_MaintenanceEvent_Schedule `protobuf:"varint,5,opt,name=schedule,proto3,enum=google.cloud.edgecontainer.v1.Cluster_MaintenanceEvent_Schedule" json:"schedule,omitempty"`
	// Output only. The state of the maintenance event.
	State Cluster_MaintenanceEvent_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.edgecontainer.v1.Cluster_MaintenanceEvent_State" json:"state,omitempty"`
	// Output only. The time when the maintenance event request was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the maintenance event started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. The time when the maintenance event ended, either
	// successfully or not. If the maintenance event is split into multiple
	// maintenance windows, end_time is only updated when the whole flow ends.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The time when the maintenance event message was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *Cluster_MaintenanceEvent) Reset() {
	*x = Cluster_MaintenanceEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cluster_MaintenanceEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster_MaintenanceEvent) ProtoMessage() {}

func (x *Cluster_MaintenanceEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster_MaintenanceEvent.ProtoReflect.Descriptor instead.
func (*Cluster_MaintenanceEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Cluster_MaintenanceEvent) GetUuid() string {
	if x != nil {
		return x.Uuid
	}
	return ""
}

func (x *Cluster_MaintenanceEvent) GetTargetVersion() string {
	if x != nil {
		return x.TargetVersion
	}
	return ""
}

func (x *Cluster_MaintenanceEvent) GetOperation() string {
	if x != nil {
		return x.Operation
	}
	return ""
}

func (x *Cluster_MaintenanceEvent) GetType() Cluster_MaintenanceEvent_Type {
	if x != nil {
		return x.Type
	}
	return Cluster_MaintenanceEvent_TYPE_UNSPECIFIED
}

func (x *Cluster_MaintenanceEvent) GetSchedule() Cluster_MaintenanceEvent_Schedule {
	if x != nil {
		return x.Schedule
	}
	return Cluster_MaintenanceEvent_SCHEDULE_UNSPECIFIED
}

func (x *Cluster_MaintenanceEvent) GetState() Cluster_MaintenanceEvent_State {
	if x != nil {
		return x.State
	}
	return Cluster_MaintenanceEvent_STATE_UNSPECIFIED
}

func (x *Cluster_MaintenanceEvent) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Cluster_MaintenanceEvent) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Cluster_MaintenanceEvent) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Cluster_MaintenanceEvent) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Configuration of the cluster survivability, e.g., for the case when network
// connectivity is lost.
type Cluster_SurvivabilityConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Time period that allows the cluster nodes to be rebooted and
	// become functional without network connectivity to Google. The default 0
	// means not allowed. The maximum is 7 days.
	OfflineRebootTtl *durationpb.Duration `protobuf:"bytes,1,opt,name=offline_reboot_ttl,json=offlineRebootTtl,proto3" json:"offline_reboot_ttl,omitempty"`
}

func (x *Cluster_SurvivabilityConfig) Reset() {
	*x = Cluster_SurvivabilityConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cluster_SurvivabilityConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster_SurvivabilityConfig) ProtoMessage() {}

func (x *Cluster_SurvivabilityConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster_SurvivabilityConfig.ProtoReflect.Descriptor instead.
func (*Cluster_SurvivabilityConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Cluster_SurvivabilityConfig) GetOfflineRebootTtl() *durationpb.Duration {
	if x != nil {
		return x.OfflineRebootTtl
	}
	return nil
}

// Configuration specific to clusters with a control plane hosted remotely.
type Cluster_ControlPlane_Remote struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Cluster_ControlPlane_Remote) Reset() {
	*x = Cluster_ControlPlane_Remote{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cluster_ControlPlane_Remote) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster_ControlPlane_Remote) ProtoMessage() {}

func (x *Cluster_ControlPlane_Remote) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster_ControlPlane_Remote.ProtoReflect.Descriptor instead.
func (*Cluster_ControlPlane_Remote) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{0, 0, 0}
}

// Configuration specific to clusters with a control plane hosted locally.
//
// Warning: Local control plane clusters must be created in their own
// project. Local control plane clusters cannot coexist in the same
// project with any other type of clusters, including non-GDCE clusters.
// Mixing local control plane GDCE clusters with any other type of
// clusters in the same project can result in data loss.
type Cluster_ControlPlane_Local struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the Google Distributed Cloud Edge zones where this node pool
	// will be created. For example: `us-central1-edge-customer-a`.
	NodeLocation string `protobuf:"bytes,1,opt,name=node_location,json=nodeLocation,proto3" json:"node_location,omitempty"`
	// The number of nodes to serve as replicas of the Control Plane.
	NodeCount int32 `protobuf:"varint,2,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// Only machines matching this filter will be allowed to host control
	// plane nodes. The filtering language accepts strings like "name=<name>",
	// and is documented here: [AIP-160](https://google.aip.dev/160).
	MachineFilter string `protobuf:"bytes,3,opt,name=machine_filter,json=machineFilter,proto3" json:"machine_filter,omitempty"`
	// Policy configuration about how user applications are deployed.
	SharedDeploymentPolicy Cluster_ControlPlane_SharedDeploymentPolicy `protobuf:"varint,4,opt,name=shared_deployment_policy,json=sharedDeploymentPolicy,proto3,enum=google.cloud.edgecontainer.v1.Cluster_ControlPlane_SharedDeploymentPolicy" json:"shared_deployment_policy,omitempty"`
}

func (x *Cluster_ControlPlane_Local) Reset() {
	*x = Cluster_ControlPlane_Local{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cluster_ControlPlane_Local) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster_ControlPlane_Local) ProtoMessage() {}

func (x *Cluster_ControlPlane_Local) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster_ControlPlane_Local.ProtoReflect.Descriptor instead.
func (*Cluster_ControlPlane_Local) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{0, 0, 1}
}

func (x *Cluster_ControlPlane_Local) GetNodeLocation() string {
	if x != nil {
		return x.NodeLocation
	}
	return ""
}

func (x *Cluster_ControlPlane_Local) GetNodeCount() int32 {
	if x != nil {
		return x.NodeCount
	}
	return 0
}

func (x *Cluster_ControlPlane_Local) GetMachineFilter() string {
	if x != nil {
		return x.MachineFilter
	}
	return ""
}

func (x *Cluster_ControlPlane_Local) GetSharedDeploymentPolicy() Cluster_ControlPlane_SharedDeploymentPolicy {
	if x != nil {
		return x.SharedDeploymentPolicy
	}
	return Cluster_ControlPlane_SHARED_DEPLOYMENT_POLICY_UNSPECIFIED
}

// Config for the Ingress add-on which allows customers to create an Ingress
// object to manage external access to the servers in a cluster. The add-on
// consists of istiod and istio-ingress.
type Cluster_SystemAddonsConfig_Ingress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether Ingress is disabled.
	Disabled bool `protobuf:"varint,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// Optional. Ingress VIP.
	Ipv4Vip string `protobuf:"bytes,2,opt,name=ipv4_vip,json=ipv4Vip,proto3" json:"ipv4_vip,omitempty"`
}

func (x *Cluster_SystemAddonsConfig_Ingress) Reset() {
	*x = Cluster_SystemAddonsConfig_Ingress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cluster_SystemAddonsConfig_Ingress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster_SystemAddonsConfig_Ingress) ProtoMessage() {}

func (x *Cluster_SystemAddonsConfig_Ingress) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster_SystemAddonsConfig_Ingress.ProtoReflect.Descriptor instead.
func (*Cluster_SystemAddonsConfig_Ingress) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *Cluster_SystemAddonsConfig_Ingress) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

func (x *Cluster_SystemAddonsConfig_Ingress) GetIpv4Vip() string {
	if x != nil {
		return x.Ipv4Vip
	}
	return ""
}

// Configuration for CMEK support for edge machine local disk encryption.
type NodePool_LocalDiskEncryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The Cloud KMS CryptoKey e.g.
	// projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey}
	// to use for protecting node local disks. If not specified, a
	// Google-managed key will be used instead.
	KmsKey string `protobuf:"bytes,1,opt,name=kms_key,json=kmsKey,proto3" json:"kms_key,omitempty"`
	// Output only. The Cloud KMS CryptoKeyVersion currently in use for
	// protecting node local disks. Only applicable if kms_key is set.
	KmsKeyActiveVersion string `protobuf:"bytes,2,opt,name=kms_key_active_version,json=kmsKeyActiveVersion,proto3" json:"kms_key_active_version,omitempty"`
	// Output only. Availability of the Cloud KMS CryptoKey. If not
	// `KEY_AVAILABLE`, then nodes may go offline as they cannot access their
	// local data. This can be caused by a lack of permissions to use the key,
	// or if the key is disabled or deleted.
	KmsKeyState KmsKeyState `protobuf:"varint,3,opt,name=kms_key_state,json=kmsKeyState,proto3,enum=google.cloud.edgecontainer.v1.KmsKeyState" json:"kms_key_state,omitempty"`
	// Output only. Error status returned by Cloud KMS when using this key. This
	// field may be populated only if `kms_key_state` is not
	// `KMS_KEY_STATE_KEY_AVAILABLE`. If populated, this field contains the
	// error status reported by Cloud KMS.
	KmsStatus *status.Status `protobuf:"bytes,4,opt,name=kms_status,json=kmsStatus,proto3" json:"kms_status,omitempty"`
}

func (x *NodePool_LocalDiskEncryption) Reset() {
	*x = NodePool_LocalDiskEncryption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodePool_LocalDiskEncryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodePool_LocalDiskEncryption) ProtoMessage() {}

func (x *NodePool_LocalDiskEncryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodePool_LocalDiskEncryption.ProtoReflect.Descriptor instead.
func (*NodePool_LocalDiskEncryption) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{5, 0}
}

func (x *NodePool_LocalDiskEncryption) GetKmsKey() string {
	if x != nil {
		return x.KmsKey
	}
	return ""
}

func (x *NodePool_LocalDiskEncryption) GetKmsKeyActiveVersion() string {
	if x != nil {
		return x.KmsKeyActiveVersion
	}
	return ""
}

func (x *NodePool_LocalDiskEncryption) GetKmsKeyState() KmsKeyState {
	if x != nil {
		return x.KmsKeyState
	}
	return KmsKeyState_KMS_KEY_STATE_UNSPECIFIED
}

func (x *NodePool_LocalDiskEncryption) GetKmsStatus() *status.Status {
	if x != nil {
		return x.KmsStatus
	}
	return nil
}

// Configuration for each node in the NodePool
type NodePool_NodeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The Kubernetes node labels
	Labels map[string]string `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *NodePool_NodeConfig) Reset() {
	*x = NodePool_NodeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodePool_NodeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodePool_NodeConfig) ProtoMessage() {}

func (x *NodePool_NodeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodePool_NodeConfig.ProtoReflect.Descriptor instead.
func (*NodePool_NodeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{5, 1}
}

func (x *NodePool_NodeConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Project detail of the VPC network.
type VpnConnection_VpcProject struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The project of the VPC to connect to. If not specified, it is the same as
	// the cluster project.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Optional. The service account in the VPC project configured by user. It
	// is used to create/delete Cloud Router and Cloud HA VPNs for VPN
	// connection. If this SA is changed during/after a VPN connection is
	// created, you need to remove the Cloud Router and Cloud VPN resources in
	// |project_id|. It is in the form of
	// service-{project_number}@gcp-sa-edgecontainer.iam.gserviceaccount.com.
	//
	// Deprecated: Marked as deprecated in google/cloud/edgecontainer/v1/resources.proto.
	ServiceAccount string `protobuf:"bytes,2,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
}

func (x *VpnConnection_VpcProject) Reset() {
	*x = VpnConnection_VpcProject{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VpnConnection_VpcProject) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VpnConnection_VpcProject) ProtoMessage() {}

func (x *VpnConnection_VpcProject) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VpnConnection_VpcProject.ProtoReflect.Descriptor instead.
func (*VpnConnection_VpcProject) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{7, 0}
}

func (x *VpnConnection_VpcProject) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/edgecontainer/v1/resources.proto.
func (x *VpnConnection_VpcProject) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

// The created connection details.
type VpnConnection_Details struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The state of this connection.
	State VpnConnection_Details_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.edgecontainer.v1.VpnConnection_Details_State" json:"state,omitempty"`
	// The error message. This is only populated when state=ERROR.
	Error string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// The Cloud Router info.
	CloudRouter *VpnConnection_Details_CloudRouter `protobuf:"bytes,3,opt,name=cloud_router,json=cloudRouter,proto3" json:"cloud_router,omitempty"`
	// Each connection has multiple Cloud VPN gateways.
	CloudVpns []*VpnConnection_Details_CloudVpn `protobuf:"bytes,4,rep,name=cloud_vpns,json=cloudVpns,proto3" json:"cloud_vpns,omitempty"`
}

func (x *VpnConnection_Details) Reset() {
	*x = VpnConnection_Details{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VpnConnection_Details) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VpnConnection_Details) ProtoMessage() {}

func (x *VpnConnection_Details) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VpnConnection_Details.ProtoReflect.Descriptor instead.
func (*VpnConnection_Details) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{7, 1}
}

func (x *VpnConnection_Details) GetState() VpnConnection_Details_State {
	if x != nil {
		return x.State
	}
	return VpnConnection_Details_STATE_UNSPECIFIED
}

func (x *VpnConnection_Details) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

func (x *VpnConnection_Details) GetCloudRouter() *VpnConnection_Details_CloudRouter {
	if x != nil {
		return x.CloudRouter
	}
	return nil
}

func (x *VpnConnection_Details) GetCloudVpns() []*VpnConnection_Details_CloudVpn {
	if x != nil {
		return x.CloudVpns
	}
	return nil
}

// The Cloud Router info.
type VpnConnection_Details_CloudRouter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The associated Cloud Router name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *VpnConnection_Details_CloudRouter) Reset() {
	*x = VpnConnection_Details_CloudRouter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VpnConnection_Details_CloudRouter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VpnConnection_Details_CloudRouter) ProtoMessage() {}

func (x *VpnConnection_Details_CloudRouter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VpnConnection_Details_CloudRouter.ProtoReflect.Descriptor instead.
func (*VpnConnection_Details_CloudRouter) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{7, 1, 0}
}

func (x *VpnConnection_Details_CloudRouter) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The Cloud VPN info.
type VpnConnection_Details_CloudVpn struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The created Cloud VPN gateway name.
	Gateway string `protobuf:"bytes,1,opt,name=gateway,proto3" json:"gateway,omitempty"`
}

func (x *VpnConnection_Details_CloudVpn) Reset() {
	*x = VpnConnection_Details_CloudVpn{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VpnConnection_Details_CloudVpn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VpnConnection_Details_CloudVpn) ProtoMessage() {}

func (x *VpnConnection_Details_CloudVpn) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VpnConnection_Details_CloudVpn.ProtoReflect.Descriptor instead.
func (*VpnConnection_Details_CloudVpn) Descriptor() ([]byte, []int) {
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP(), []int{7, 1, 1}
}

func (x *VpnConnection_Details_CloudVpn) GetGateway() string {
	if x != nil {
		return x.Gateway
	}
	return ""
}

var File_google_cloud_edgecontainer_v1_resources_proto protoreflect.FileDescriptor

var file_google_cloud_edgecontainer_v1_resources_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x65,
	0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64,
	0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbb, 0x21, 0x0a, 0x07, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4a, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x3f, 0x0a, 0x05, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x66, 0x6c,
	0x65, 0x65, 0x74, 0x12, 0x55, 0x0a, 0x0a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e,
	0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x12, 0x5a, 0x0a, 0x0d, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x0d, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x19, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x6f, 0x64, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6e,
	0x6f, 0x64, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4d, 0x61, 0x78, 0x50, 0x6f, 0x64, 0x73, 0x50, 0x65,
	0x72, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x13,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12,
	0x39, 0x0a, 0x16, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x5f, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x43, 0x61, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x64, 0x0a, 0x12, 0x6d, 0x61,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e,
	0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x6d,
	0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x37, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5f, 0x70, 0x6c, 0x61, 0x6e,
	0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50, 0x6c, 0x61,
	0x6e, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0c, 0x6e, 0x6f, 0x64,
	0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x6e, 0x6f, 0x64, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x5d, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5f, 0x70, 0x6c, 0x61,
	0x6e, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50, 0x6c, 0x61, 0x6e, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50, 0x6c, 0x61, 0x6e, 0x65,
	0x12, 0x70, 0x0a, 0x14, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x61, 0x64, 0x64, 0x6f, 0x6e,
	0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64,
	0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x41, 0x64, 0x64,
	0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x41, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x5c, 0x0a, 0x29, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x6c,
	0x6f, 0x61, 0x64, 0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x76,
	0x34, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x18,
	0x11, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x24, 0x65, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72,
	0x49, 0x70, 0x76, 0x34, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6f, 0x6c, 0x73,
	0x12, 0x7c, 0x0a, 0x18, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5f, 0x70, 0x6c, 0x61, 0x6e,
	0x65, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x12, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x50, 0x6c, 0x61, 0x6e, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50,
	0x6c, 0x61, 0x6e, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4a,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64,
	0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x6b, 0x0a, 0x12, 0x6d, 0x61,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x15, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x4d,
	0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63,
	0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x2a, 0x0a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x63, 0x0a, 0x0f, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x2e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73,
	0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x72, 0x0a, 0x14, 0x73, 0x75, 0x72, 0x76,
	0x69, 0x76, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x53,
	0x75, 0x72, 0x76, 0x69, 0x76, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x73, 0x75, 0x72, 0x76, 0x69, 0x76, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5c, 0x0a, 0x29,
	0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x62, 0x61,
	0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x76, 0x36, 0x5f, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x18, 0x19, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x24, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x4c, 0x6f,
	0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x49, 0x70, 0x76, 0x36, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x1a, 0xa8, 0x04, 0x0a, 0x0c, 0x43,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50, 0x6c, 0x61, 0x6e, 0x65, 0x12, 0x54, 0x0a, 0x06, 0x72,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50, 0x6c, 0x61, 0x6e, 0x65,
	0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x48, 0x00, 0x52, 0x06, 0x72, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x12, 0x51, 0x0a, 0x05, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c,
	0x50, 0x6c, 0x61, 0x6e, 0x65, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x48, 0x00, 0x52, 0x05, 0x6c,
	0x6f, 0x63, 0x61, 0x6c, 0x1a, 0x08, 0x0a, 0x06, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x1a, 0xf9,
	0x01, 0x0a, 0x05, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x12, 0x23, 0x0a, 0x0d, 0x6e, 0x6f, 0x64, 0x65,
	0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a,
	0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0e,
	0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x84, 0x01, 0x0a, 0x18, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x43,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50, 0x6c, 0x61, 0x6e, 0x65, 0x2e, 0x53, 0x68, 0x61, 0x72,
	0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x16, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x5f, 0x0a, 0x16, 0x53, 0x68,
	0x61, 0x72, 0x65, 0x64, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x28, 0x0a, 0x24, 0x53, 0x48, 0x41, 0x52, 0x45, 0x44, 0x5f, 0x44,
	0x45, 0x50, 0x4c, 0x4f, 0x59, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b,
	0x0a, 0x07, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x44,
	0x49, 0x53, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x45, 0x44, 0x10, 0x02, 0x42, 0x08, 0x0a, 0x06, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xc2, 0x01, 0x0a, 0x12, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x41, 0x64, 0x64, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x60, 0x0a, 0x07,
	0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67,
	0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x41, 0x64, 0x64, 0x6f,
	0x6e, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x1a, 0x4a,
	0x0a, 0x07, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x1f, 0x0a, 0x08, 0x64, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x1e, 0x0a, 0x08, 0x69, 0x70,
	0x76, 0x34, 0x5f, 0x76, 0x69, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x07, 0x69, 0x70, 0x76, 0x34, 0x56, 0x69, 0x70, 0x1a, 0xd0, 0x02, 0x0a, 0x16, 0x43,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50, 0x6c, 0x61, 0x6e, 0x65, 0x45, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x07, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x05, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65,
	0x79, 0x52, 0x06, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x12, 0x65, 0x0a, 0x16, 0x6b, 0x6d, 0x73,
	0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x03, 0xfa, 0x41,
	0x2a, 0x0a, 0x28, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74,
	0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x6b, 0x6d, 0x73,
	0x4b, 0x65, 0x79, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x53, 0x0a, 0x0d, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x36, 0x0a, 0x0a, 0x6b, 0x6d, 0x73, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x09, 0x6b, 0x6d, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a, 0xe6, 0x06,
	0x0a, 0x10, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x75, 0x75, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x75, 0x75, 0x69, 0x64, 0x12, 0x2a, 0x0a, 0x0e, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x55, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x61, 0x0a, 0x08, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x4d, 0x61, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x73, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x65, 0x12, 0x58, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x4d, 0x61, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x53,
	0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16,
	0x55, 0x53, 0x45, 0x52, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x55,
	0x50, 0x47, 0x52, 0x41, 0x44, 0x45, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x47, 0x4f, 0x4f, 0x47,
	0x4c, 0x45, 0x5f, 0x44, 0x52, 0x49, 0x56, 0x45, 0x4e, 0x5f, 0x55, 0x50, 0x47, 0x52, 0x41, 0x44,
	0x45, 0x10, 0x02, 0x22, 0x35, 0x0a, 0x08, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12,
	0x18, 0x0a, 0x14, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4d, 0x4d,
	0x45, 0x44, 0x49, 0x41, 0x54, 0x45, 0x4c, 0x59, 0x10, 0x01, 0x22, 0x4a, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45,
	0x43, 0x4f, 0x4e, 0x43, 0x49, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53,
	0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41,
	0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x1a, 0x63, 0x0a, 0x13, 0x53, 0x75, 0x72, 0x76, 0x69, 0x76,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4c, 0x0a,
	0x12, 0x6f, 0x66, 0x66, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x72, 0x65, 0x62, 0x6f, 0x6f, 0x74, 0x5f,
	0x74, 0x74, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6f, 0x66, 0x66, 0x6c, 0x69,
	0x6e, 0x65, 0x52, 0x65, 0x62, 0x6f, 0x6f, 0x74, 0x54, 0x74, 0x6c, 0x1a, 0x39, 0x0a, 0x0b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x69, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x16, 0x0a, 0x12, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x52, 0x4f, 0x56,
	0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55,
	0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x04,
	0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x43, 0x4f, 0x4e, 0x43, 0x49, 0x4c, 0x49, 0x4e, 0x47, 0x10,
	0x05, 0x22, 0x48, 0x0a, 0x0e, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x12, 0x1f, 0x0a, 0x1b, 0x52, 0x45, 0x4c, 0x45, 0x41, 0x53, 0x45, 0x5f, 0x43,
	0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x0b,
	0x0a, 0x07, 0x52, 0x45, 0x47, 0x55, 0x4c, 0x41, 0x52, 0x10, 0x02, 0x3a, 0x65, 0xea, 0x41, 0x62,
	0x0a, 0x24, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x3a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x7d, 0x22, 0x91, 0x01, 0x0a, 0x11, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x12, 0x3c, 0x0a, 0x18, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c,
	0x6f, 0x63, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x15, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72,
	0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x12, 0x3e, 0x0a, 0x19, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x5f, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x62, 0x6c, 0x6f,
	0x63, 0x6b, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x16,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x49, 0x70, 0x76, 0x34, 0x43, 0x69, 0x64, 0x72,
	0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x22, 0x4b, 0x0a, 0x05, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x12,
	0x1d, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x23,
	0x0a, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73,
	0x68, 0x69, 0x70, 0x22, 0x2e, 0x0a, 0x0b, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x55, 0x73,
	0x65, 0x72, 0x12, 0x1f, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x61, 0x0a, 0x0d, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x0b, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x75, 0x73,
	0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x55, 0x73, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x55, 0x73, 0x65, 0x72, 0x73, 0x22, 0xb6, 0x0a, 0x0a, 0x08, 0x4e, 0x6f, 0x64, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x65, 0x64, 0x67, 0x65, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x6e, 0x6f, 0x64, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a,
	0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x25, 0x0a, 0x0e, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e,
	0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x74, 0x0a, 0x15, 0x6c, 0x6f, 0x63, 0x61, 0x6c,
	0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x2e,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x44, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x44,
	0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a,
	0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x6e, 0x6f, 0x64, 0x65, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x0b, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a,
	0xcd, 0x02, 0x0a, 0x13, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x44, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x07, 0x6b, 0x6d, 0x73, 0x5f, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x05, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f,
	0x4b, 0x65, 0x79, 0x52, 0x06, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x12, 0x65, 0x0a, 0x16, 0x6b,
	0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x03,
	0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79,
	0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x6b,
	0x6d, 0x73, 0x4b, 0x65, 0x79, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x0d, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x6d, 0x73, 0x4b, 0x65, 0x79,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x6b, 0x6d, 0x73, 0x4b,
	0x65, 0x79, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x36, 0x0a, 0x0a, 0x6b, 0x6d, 0x73, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x6b, 0x6d, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a,
	0xa4, 0x01, 0x0a, 0x0a, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5b,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64,
	0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4e,
	0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x3a, 0x7c, 0xea, 0x41, 0x79, 0x0a, 0x25, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f, 0x64, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x50, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f,
	0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x7d, 0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x6f,
	0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x7d, 0x22,
	0xb2, 0x04, 0x0a, 0x07, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x12, 0x40, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x26, 0x0a, 0x24, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x4a, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x1f, 0x0a,
	0x0b, 0x68, 0x6f, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x68, 0x6f, 0x73, 0x74, 0x65, 0x64, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x7a, 0x6f,
	0x6e, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x1f, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x65, 0xea,
	0x41, 0x62, 0x0a, 0x24, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x12, 0x3a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x6d, 0x61, 0x63, 0x68,
	0x69, 0x6e, 0x65, 0x7d, 0x22, 0xdc, 0x0c, 0x0a, 0x0d, 0x56, 0x70, 0x6e, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x65, 0x64,
	0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x70, 0x6e, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x50, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x70, 0x6e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x12, 0x24, 0x0a, 0x0e, 0x6e, 0x61, 0x74, 0x5f, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x5f, 0x69, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6e, 0x61,
	0x74, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x70, 0x12, 0x69, 0x0a, 0x10, 0x62, 0x67,
	0x70, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x70, 0x6e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x42, 0x67, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64,
	0x65, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x62, 0x67, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x43, 0x0a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x65, 0x64, 0x67,
	0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x10, 0x0a, 0x03, 0x76, 0x70,
	0x63, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x76, 0x70, 0x63, 0x12, 0x5d, 0x0a, 0x0b,
	0x76, 0x70, 0x63, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x56, 0x70, 0x6e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x56, 0x70, 0x63, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0a, 0x76, 0x70, 0x63, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x38, 0x0a, 0x18, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x68, 0x69, 0x67, 0x68, 0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x48, 0x69, 0x67, 0x68, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x1b, 0x0a, 0x06, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x72, 0x6f, 0x75, 0x74,
	0x65, 0x72, 0x12, 0x53, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x70, 0x6e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x1a, 0x5b, 0x0a, 0x0a, 0x56, 0x70, 0x63, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0xe0,
	0x41, 0x01, 0x18, 0x01, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x1a, 0xd9, 0x03, 0x0a, 0x07, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x50, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65,
	0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x70, 0x6e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x63, 0x0a, 0x0c, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64,
	0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56,
	0x70, 0x6e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72,
	0x52, 0x0b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x12, 0x5c, 0x0a,
	0x0a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x76, 0x70, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x56, 0x70, 0x6e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x70, 0x6e,
	0x52, 0x09, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x70, 0x6e, 0x73, 0x1a, 0x21, 0x0a, 0x0b, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x24,
	0x0a, 0x08, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x70, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x67, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x22, 0x5a, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x43, 0x4f,
	0x4e, 0x4e, 0x45, 0x43, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12,
	0x0f, 0x0a, 0x0b, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x03,
	0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x4c, 0x0a, 0x0e, 0x42,
	0x67, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x20, 0x0a,
	0x1c, 0x42, 0x47, 0x50, 0x5f, 0x52, 0x4f, 0x55, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x4d, 0x4f, 0x44,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0c, 0x0a, 0x08, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x0a, 0x0a,
	0x06, 0x47, 0x4c, 0x4f, 0x42, 0x41, 0x4c, 0x10, 0x02, 0x3a, 0x78, 0xea, 0x41, 0x75, 0x0a, 0x2a,
	0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x70, 0x6e,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x47, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x76, 0x70, 0x6e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x76, 0x70, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x22, 0xf0, 0x01, 0x0a, 0x10, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x6c, 0x0a, 0x0f, 0x61, 0x76, 0x61, 0x69,
	0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5a, 0x6f, 0x6e, 0x65,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c,
	0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x73, 0x1a, 0x6e, 0x0a, 0x13, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61,
	0x62, 0x6c, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x41, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64,
	0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x5a,
	0x6f, 0x6e, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xd9, 0x02, 0x0a, 0x0c, 0x5a, 0x6f, 0x6e, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3a, 0x0a, 0x05, 0x71, 0x75, 0x6f, 0x74, 0x61,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x52, 0x05, 0x71, 0x75,
	0x6f, 0x74, 0x61, 0x12, 0x59, 0x0a, 0x0a, 0x72, 0x61, 0x63, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x5a, 0x6f, 0x6e, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x52, 0x61, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x09, 0x72, 0x61, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x73, 0x1a, 0x72,
	0x0a, 0x0e, 0x52, 0x61, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x4a, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x5a, 0x6f, 0x6e, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x52,
	0x61, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x3e, 0x0a, 0x08, 0x52, 0x61, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19,
	0x0a, 0x15, 0x52, 0x41, 0x43, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x41, 0x53,
	0x45, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x45, 0x58, 0x50, 0x41, 0x4e, 0x53, 0x49, 0x4f, 0x4e,
	0x10, 0x02, 0x22, 0x4b, 0x0a, 0x05, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x12, 0x16, 0x0a, 0x06, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x75, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x75, 0x73, 0x61, 0x67, 0x65, 0x22,
	0x5d, 0x0a, 0x11, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x48, 0x0a, 0x06, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x52, 0x06, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x22, 0x72,
	0x0a, 0x11, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x12, 0x5d, 0x0a, 0x10, 0x72, 0x65, 0x63, 0x75, 0x72, 0x72, 0x69, 0x6e, 0x67,
	0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67,
	0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x63, 0x75, 0x72, 0x72, 0x69, 0x6e, 0x67, 0x54, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x52, 0x0f, 0x72, 0x65, 0x63, 0x75, 0x72, 0x72, 0x69, 0x6e, 0x67, 0x57, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x22, 0x78, 0x0a, 0x13, 0x52, 0x65, 0x63, 0x75, 0x72, 0x72, 0x69, 0x6e, 0x67, 0x54,
	0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x41, 0x0a, 0x06, 0x77, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x57, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x52, 0x06, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x1e, 0x0a, 0x0a,
	0x72, 0x65, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x72, 0x65, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x7e, 0x0a, 0x0a,
	0x54, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xcc, 0x02, 0x0a,
	0x0c, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5a, 0x0a,
	0x08, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65,
	0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x08, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x12, 0x47, 0x0a, 0x08, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0e, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x1a, 0x69, 0x0a, 0x0d, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x42, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x3d, 0x0a, 0x0d, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2c, 0x0a, 0x0f,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x22, 0x0a, 0x07, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x2a, 0x70,
	0x0a, 0x0b, 0x4b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a,
	0x19, 0x4b, 0x4d, 0x53, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1f, 0x0a, 0x1b,
	0x4b, 0x4d, 0x53, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x4b, 0x45,
	0x59, 0x5f, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x21, 0x0a,
	0x1d, 0x4b, 0x4d, 0x53, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x4b,
	0x45, 0x59, 0x5f, 0x55, 0x4e, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x02,
	0x42, 0x86, 0x04, 0xea, 0x41, 0x78, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x12, 0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x6b, 0x65, 0x79, 0x52, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x6b, 0x65, 0x79,
	0x5f, 0x72, 0x69, 0x6e, 0x67, 0x7d, 0x2f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79,
	0x73, 0x2f, 0x7b, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x7d, 0xea, 0x41,
	0xa6, 0x01, 0x0a, 0x28, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70,
	0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x7a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6b, 0x65, 0x79, 0x52, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b,
	0x6b, 0x65, 0x79, 0x5f, 0x72, 0x69, 0x6e, 0x67, 0x7d, 0x2f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f,
	0x4b, 0x65, 0x79, 0x73, 0x2f, 0x7b, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79,
	0x7d, 0x2f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x64, 0x67, 0x65, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x42, 0x0e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x47, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x65, 0x64, 0x67, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x70, 0x62, 0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x45, 0x64, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x45, 0x64, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x45, 0x64, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_edgecontainer_v1_resources_proto_rawDescOnce sync.Once
	file_google_cloud_edgecontainer_v1_resources_proto_rawDescData = file_google_cloud_edgecontainer_v1_resources_proto_rawDesc
)

func file_google_cloud_edgecontainer_v1_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_edgecontainer_v1_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_edgecontainer_v1_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_edgecontainer_v1_resources_proto_rawDescData)
	})
	return file_google_cloud_edgecontainer_v1_resources_proto_rawDescData
}

var file_google_cloud_edgecontainer_v1_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 10)
var file_google_cloud_edgecontainer_v1_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 40)
var file_google_cloud_edgecontainer_v1_resources_proto_goTypes = []any{
	(KmsKeyState)(0),                                 // 0: google.cloud.edgecontainer.v1.KmsKeyState
	(Cluster_Status)(0),                              // 1: google.cloud.edgecontainer.v1.Cluster.Status
	(Cluster_ReleaseChannel)(0),                      // 2: google.cloud.edgecontainer.v1.Cluster.ReleaseChannel
	(Cluster_ControlPlane_SharedDeploymentPolicy)(0), // 3: google.cloud.edgecontainer.v1.Cluster.ControlPlane.SharedDeploymentPolicy
	(Cluster_MaintenanceEvent_Type)(0),               // 4: google.cloud.edgecontainer.v1.Cluster.MaintenanceEvent.Type
	(Cluster_MaintenanceEvent_Schedule)(0),           // 5: google.cloud.edgecontainer.v1.Cluster.MaintenanceEvent.Schedule
	(Cluster_MaintenanceEvent_State)(0),              // 6: google.cloud.edgecontainer.v1.Cluster.MaintenanceEvent.State
	(VpnConnection_BgpRoutingMode)(0),                // 7: google.cloud.edgecontainer.v1.VpnConnection.BgpRoutingMode
	(VpnConnection_Details_State)(0),                 // 8: google.cloud.edgecontainer.v1.VpnConnection.Details.State
	(ZoneMetadata_RackType)(0),                       // 9: google.cloud.edgecontainer.v1.ZoneMetadata.RackType
	(*Cluster)(nil),                                  // 10: google.cloud.edgecontainer.v1.Cluster
	(*ClusterNetworking)(nil),                        // 11: google.cloud.edgecontainer.v1.ClusterNetworking
	(*Fleet)(nil),                                    // 12: google.cloud.edgecontainer.v1.Fleet
	(*ClusterUser)(nil),                              // 13: google.cloud.edgecontainer.v1.ClusterUser
	(*Authorization)(nil),                            // 14: google.cloud.edgecontainer.v1.Authorization
	(*NodePool)(nil),                                 // 15: google.cloud.edgecontainer.v1.NodePool
	(*Machine)(nil),                                  // 16: google.cloud.edgecontainer.v1.Machine
	(*VpnConnection)(nil),                            // 17: google.cloud.edgecontainer.v1.VpnConnection
	(*LocationMetadata)(nil),                         // 18: google.cloud.edgecontainer.v1.LocationMetadata
	(*ZoneMetadata)(nil),                             // 19: google.cloud.edgecontainer.v1.ZoneMetadata
	(*Quota)(nil),                                    // 20: google.cloud.edgecontainer.v1.Quota
	(*MaintenancePolicy)(nil),                        // 21: google.cloud.edgecontainer.v1.MaintenancePolicy
	(*MaintenanceWindow)(nil),                        // 22: google.cloud.edgecontainer.v1.MaintenanceWindow
	(*RecurringTimeWindow)(nil),                      // 23: google.cloud.edgecontainer.v1.RecurringTimeWindow
	(*TimeWindow)(nil),                               // 24: google.cloud.edgecontainer.v1.TimeWindow
	(*ServerConfig)(nil),                             // 25: google.cloud.edgecontainer.v1.ServerConfig
	(*ChannelConfig)(nil),                            // 26: google.cloud.edgecontainer.v1.ChannelConfig
	(*Version)(nil),                                  // 27: google.cloud.edgecontainer.v1.Version
	(*Cluster_ControlPlane)(nil),                     // 28: google.cloud.edgecontainer.v1.Cluster.ControlPlane
	(*Cluster_SystemAddonsConfig)(nil),               // 29: google.cloud.edgecontainer.v1.Cluster.SystemAddonsConfig
	(*Cluster_ControlPlaneEncryption)(nil),           // 30: google.cloud.edgecontainer.v1.Cluster.ControlPlaneEncryption
	(*Cluster_MaintenanceEvent)(nil),                 // 31: google.cloud.edgecontainer.v1.Cluster.MaintenanceEvent
	(*Cluster_SurvivabilityConfig)(nil),              // 32: google.cloud.edgecontainer.v1.Cluster.SurvivabilityConfig
	nil,                                              // 33: google.cloud.edgecontainer.v1.Cluster.LabelsEntry
	(*Cluster_ControlPlane_Remote)(nil),              // 34: google.cloud.edgecontainer.v1.Cluster.ControlPlane.Remote
	(*Cluster_ControlPlane_Local)(nil),               // 35: google.cloud.edgecontainer.v1.Cluster.ControlPlane.Local
	(*Cluster_SystemAddonsConfig_Ingress)(nil),       // 36: google.cloud.edgecontainer.v1.Cluster.SystemAddonsConfig.Ingress
	(*NodePool_LocalDiskEncryption)(nil),             // 37: google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption
	(*NodePool_NodeConfig)(nil),                      // 38: google.cloud.edgecontainer.v1.NodePool.NodeConfig
	nil,                                              // 39: google.cloud.edgecontainer.v1.NodePool.LabelsEntry
	nil,                                              // 40: google.cloud.edgecontainer.v1.NodePool.NodeConfig.LabelsEntry
	nil,                                              // 41: google.cloud.edgecontainer.v1.Machine.LabelsEntry
	(*VpnConnection_VpcProject)(nil),                 // 42: google.cloud.edgecontainer.v1.VpnConnection.VpcProject
	(*VpnConnection_Details)(nil),                    // 43: google.cloud.edgecontainer.v1.VpnConnection.Details
	nil,                                              // 44: google.cloud.edgecontainer.v1.VpnConnection.LabelsEntry
	(*VpnConnection_Details_CloudRouter)(nil),        // 45: google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter
	(*VpnConnection_Details_CloudVpn)(nil),           // 46: google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn
	nil,                                              // 47: google.cloud.edgecontainer.v1.LocationMetadata.AvailableZonesEntry
	nil,                                              // 48: google.cloud.edgecontainer.v1.ZoneMetadata.RackTypesEntry
	nil,                                              // 49: google.cloud.edgecontainer.v1.ServerConfig.ChannelsEntry
	(*timestamppb.Timestamp)(nil),                    // 50: google.protobuf.Timestamp
	(*status.Status)(nil),                            // 51: google.rpc.Status
	(*durationpb.Duration)(nil),                      // 52: google.protobuf.Duration
}
var file_google_cloud_edgecontainer_v1_resources_proto_depIdxs = []int32{
	50, // 0: google.cloud.edgecontainer.v1.Cluster.create_time:type_name -> google.protobuf.Timestamp
	50, // 1: google.cloud.edgecontainer.v1.Cluster.update_time:type_name -> google.protobuf.Timestamp
	33, // 2: google.cloud.edgecontainer.v1.Cluster.labels:type_name -> google.cloud.edgecontainer.v1.Cluster.LabelsEntry
	12, // 3: google.cloud.edgecontainer.v1.Cluster.fleet:type_name -> google.cloud.edgecontainer.v1.Fleet
	11, // 4: google.cloud.edgecontainer.v1.Cluster.networking:type_name -> google.cloud.edgecontainer.v1.ClusterNetworking
	14, // 5: google.cloud.edgecontainer.v1.Cluster.authorization:type_name -> google.cloud.edgecontainer.v1.Authorization
	21, // 6: google.cloud.edgecontainer.v1.Cluster.maintenance_policy:type_name -> google.cloud.edgecontainer.v1.MaintenancePolicy
	28, // 7: google.cloud.edgecontainer.v1.Cluster.control_plane:type_name -> google.cloud.edgecontainer.v1.Cluster.ControlPlane
	29, // 8: google.cloud.edgecontainer.v1.Cluster.system_addons_config:type_name -> google.cloud.edgecontainer.v1.Cluster.SystemAddonsConfig
	30, // 9: google.cloud.edgecontainer.v1.Cluster.control_plane_encryption:type_name -> google.cloud.edgecontainer.v1.Cluster.ControlPlaneEncryption
	1,  // 10: google.cloud.edgecontainer.v1.Cluster.status:type_name -> google.cloud.edgecontainer.v1.Cluster.Status
	31, // 11: google.cloud.edgecontainer.v1.Cluster.maintenance_events:type_name -> google.cloud.edgecontainer.v1.Cluster.MaintenanceEvent
	2,  // 12: google.cloud.edgecontainer.v1.Cluster.release_channel:type_name -> google.cloud.edgecontainer.v1.Cluster.ReleaseChannel
	32, // 13: google.cloud.edgecontainer.v1.Cluster.survivability_config:type_name -> google.cloud.edgecontainer.v1.Cluster.SurvivabilityConfig
	13, // 14: google.cloud.edgecontainer.v1.Authorization.admin_users:type_name -> google.cloud.edgecontainer.v1.ClusterUser
	50, // 15: google.cloud.edgecontainer.v1.NodePool.create_time:type_name -> google.protobuf.Timestamp
	50, // 16: google.cloud.edgecontainer.v1.NodePool.update_time:type_name -> google.protobuf.Timestamp
	39, // 17: google.cloud.edgecontainer.v1.NodePool.labels:type_name -> google.cloud.edgecontainer.v1.NodePool.LabelsEntry
	37, // 18: google.cloud.edgecontainer.v1.NodePool.local_disk_encryption:type_name -> google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption
	38, // 19: google.cloud.edgecontainer.v1.NodePool.node_config:type_name -> google.cloud.edgecontainer.v1.NodePool.NodeConfig
	50, // 20: google.cloud.edgecontainer.v1.Machine.create_time:type_name -> google.protobuf.Timestamp
	50, // 21: google.cloud.edgecontainer.v1.Machine.update_time:type_name -> google.protobuf.Timestamp
	41, // 22: google.cloud.edgecontainer.v1.Machine.labels:type_name -> google.cloud.edgecontainer.v1.Machine.LabelsEntry
	50, // 23: google.cloud.edgecontainer.v1.VpnConnection.create_time:type_name -> google.protobuf.Timestamp
	50, // 24: google.cloud.edgecontainer.v1.VpnConnection.update_time:type_name -> google.protobuf.Timestamp
	44, // 25: google.cloud.edgecontainer.v1.VpnConnection.labels:type_name -> google.cloud.edgecontainer.v1.VpnConnection.LabelsEntry
	7,  // 26: google.cloud.edgecontainer.v1.VpnConnection.bgp_routing_mode:type_name -> google.cloud.edgecontainer.v1.VpnConnection.BgpRoutingMode
	42, // 27: google.cloud.edgecontainer.v1.VpnConnection.vpc_project:type_name -> google.cloud.edgecontainer.v1.VpnConnection.VpcProject
	43, // 28: google.cloud.edgecontainer.v1.VpnConnection.details:type_name -> google.cloud.edgecontainer.v1.VpnConnection.Details
	47, // 29: google.cloud.edgecontainer.v1.LocationMetadata.available_zones:type_name -> google.cloud.edgecontainer.v1.LocationMetadata.AvailableZonesEntry
	20, // 30: google.cloud.edgecontainer.v1.ZoneMetadata.quota:type_name -> google.cloud.edgecontainer.v1.Quota
	48, // 31: google.cloud.edgecontainer.v1.ZoneMetadata.rack_types:type_name -> google.cloud.edgecontainer.v1.ZoneMetadata.RackTypesEntry
	22, // 32: google.cloud.edgecontainer.v1.MaintenancePolicy.window:type_name -> google.cloud.edgecontainer.v1.MaintenanceWindow
	23, // 33: google.cloud.edgecontainer.v1.MaintenanceWindow.recurring_window:type_name -> google.cloud.edgecontainer.v1.RecurringTimeWindow
	24, // 34: google.cloud.edgecontainer.v1.RecurringTimeWindow.window:type_name -> google.cloud.edgecontainer.v1.TimeWindow
	50, // 35: google.cloud.edgecontainer.v1.TimeWindow.start_time:type_name -> google.protobuf.Timestamp
	50, // 36: google.cloud.edgecontainer.v1.TimeWindow.end_time:type_name -> google.protobuf.Timestamp
	49, // 37: google.cloud.edgecontainer.v1.ServerConfig.channels:type_name -> google.cloud.edgecontainer.v1.ServerConfig.ChannelsEntry
	27, // 38: google.cloud.edgecontainer.v1.ServerConfig.versions:type_name -> google.cloud.edgecontainer.v1.Version
	34, // 39: google.cloud.edgecontainer.v1.Cluster.ControlPlane.remote:type_name -> google.cloud.edgecontainer.v1.Cluster.ControlPlane.Remote
	35, // 40: google.cloud.edgecontainer.v1.Cluster.ControlPlane.local:type_name -> google.cloud.edgecontainer.v1.Cluster.ControlPlane.Local
	36, // 41: google.cloud.edgecontainer.v1.Cluster.SystemAddonsConfig.ingress:type_name -> google.cloud.edgecontainer.v1.Cluster.SystemAddonsConfig.Ingress
	0,  // 42: google.cloud.edgecontainer.v1.Cluster.ControlPlaneEncryption.kms_key_state:type_name -> google.cloud.edgecontainer.v1.KmsKeyState
	51, // 43: google.cloud.edgecontainer.v1.Cluster.ControlPlaneEncryption.kms_status:type_name -> google.rpc.Status
	4,  // 44: google.cloud.edgecontainer.v1.Cluster.MaintenanceEvent.type:type_name -> google.cloud.edgecontainer.v1.Cluster.MaintenanceEvent.Type
	5,  // 45: google.cloud.edgecontainer.v1.Cluster.MaintenanceEvent.schedule:type_name -> google.cloud.edgecontainer.v1.Cluster.MaintenanceEvent.Schedule
	6,  // 46: google.cloud.edgecontainer.v1.Cluster.MaintenanceEvent.state:type_name -> google.cloud.edgecontainer.v1.Cluster.MaintenanceEvent.State
	50, // 47: google.cloud.edgecontainer.v1.Cluster.MaintenanceEvent.create_time:type_name -> google.protobuf.Timestamp
	50, // 48: google.cloud.edgecontainer.v1.Cluster.MaintenanceEvent.start_time:type_name -> google.protobuf.Timestamp
	50, // 49: google.cloud.edgecontainer.v1.Cluster.MaintenanceEvent.end_time:type_name -> google.protobuf.Timestamp
	50, // 50: google.cloud.edgecontainer.v1.Cluster.MaintenanceEvent.update_time:type_name -> google.protobuf.Timestamp
	52, // 51: google.cloud.edgecontainer.v1.Cluster.SurvivabilityConfig.offline_reboot_ttl:type_name -> google.protobuf.Duration
	3,  // 52: google.cloud.edgecontainer.v1.Cluster.ControlPlane.Local.shared_deployment_policy:type_name -> google.cloud.edgecontainer.v1.Cluster.ControlPlane.SharedDeploymentPolicy
	0,  // 53: google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption.kms_key_state:type_name -> google.cloud.edgecontainer.v1.KmsKeyState
	51, // 54: google.cloud.edgecontainer.v1.NodePool.LocalDiskEncryption.kms_status:type_name -> google.rpc.Status
	40, // 55: google.cloud.edgecontainer.v1.NodePool.NodeConfig.labels:type_name -> google.cloud.edgecontainer.v1.NodePool.NodeConfig.LabelsEntry
	8,  // 56: google.cloud.edgecontainer.v1.VpnConnection.Details.state:type_name -> google.cloud.edgecontainer.v1.VpnConnection.Details.State
	45, // 57: google.cloud.edgecontainer.v1.VpnConnection.Details.cloud_router:type_name -> google.cloud.edgecontainer.v1.VpnConnection.Details.CloudRouter
	46, // 58: google.cloud.edgecontainer.v1.VpnConnection.Details.cloud_vpns:type_name -> google.cloud.edgecontainer.v1.VpnConnection.Details.CloudVpn
	19, // 59: google.cloud.edgecontainer.v1.LocationMetadata.AvailableZonesEntry.value:type_name -> google.cloud.edgecontainer.v1.ZoneMetadata
	9,  // 60: google.cloud.edgecontainer.v1.ZoneMetadata.RackTypesEntry.value:type_name -> google.cloud.edgecontainer.v1.ZoneMetadata.RackType
	26, // 61: google.cloud.edgecontainer.v1.ServerConfig.ChannelsEntry.value:type_name -> google.cloud.edgecontainer.v1.ChannelConfig
	62, // [62:62] is the sub-list for method output_type
	62, // [62:62] is the sub-list for method input_type
	62, // [62:62] is the sub-list for extension type_name
	62, // [62:62] is the sub-list for extension extendee
	0,  // [0:62] is the sub-list for field type_name
}

func init() { file_google_cloud_edgecontainer_v1_resources_proto_init() }
func file_google_cloud_edgecontainer_v1_resources_proto_init() {
	if File_google_cloud_edgecontainer_v1_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*Cluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*ClusterNetworking); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*Fleet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*ClusterUser); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*Authorization); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*NodePool); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*Machine); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*VpnConnection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*LocationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*ZoneMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*Quota); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*MaintenancePolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*MaintenanceWindow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*RecurringTimeWindow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*TimeWindow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*ServerConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*ChannelConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[17].Exporter = func(v any, i int) any {
			switch v := v.(*Version); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[18].Exporter = func(v any, i int) any {
			switch v := v.(*Cluster_ControlPlane); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[19].Exporter = func(v any, i int) any {
			switch v := v.(*Cluster_SystemAddonsConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[20].Exporter = func(v any, i int) any {
			switch v := v.(*Cluster_ControlPlaneEncryption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[21].Exporter = func(v any, i int) any {
			switch v := v.(*Cluster_MaintenanceEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[22].Exporter = func(v any, i int) any {
			switch v := v.(*Cluster_SurvivabilityConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[24].Exporter = func(v any, i int) any {
			switch v := v.(*Cluster_ControlPlane_Remote); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[25].Exporter = func(v any, i int) any {
			switch v := v.(*Cluster_ControlPlane_Local); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[26].Exporter = func(v any, i int) any {
			switch v := v.(*Cluster_SystemAddonsConfig_Ingress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[27].Exporter = func(v any, i int) any {
			switch v := v.(*NodePool_LocalDiskEncryption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[28].Exporter = func(v any, i int) any {
			switch v := v.(*NodePool_NodeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[32].Exporter = func(v any, i int) any {
			switch v := v.(*VpnConnection_VpcProject); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[33].Exporter = func(v any, i int) any {
			switch v := v.(*VpnConnection_Details); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[35].Exporter = func(v any, i int) any {
			switch v := v.(*VpnConnection_Details_CloudRouter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[36].Exporter = func(v any, i int) any {
			switch v := v.(*VpnConnection_Details_CloudVpn); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_edgecontainer_v1_resources_proto_msgTypes[18].OneofWrappers = []any{
		(*Cluster_ControlPlane_Remote_)(nil),
		(*Cluster_ControlPlane_Local_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_edgecontainer_v1_resources_proto_rawDesc,
			NumEnums:      10,
			NumMessages:   40,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_edgecontainer_v1_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_edgecontainer_v1_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_edgecontainer_v1_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_edgecontainer_v1_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_edgecontainer_v1_resources_proto = out.File
	file_google_cloud_edgecontainer_v1_resources_proto_rawDesc = nil
	file_google_cloud_edgecontainer_v1_resources_proto_goTypes = nil
	file_google_cloud_edgecontainer_v1_resources_proto_depIdxs = nil
}
