/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/mlsubr.c,v $
 * $Id: mlsubr.c,v 3.13 1999/10/15 23:58:12 heiner Exp $
 *
 *	move list attributation & sorting
 */

#include "types.h"
#include "board.h"
#include "mgsubr.h"
#include "output.h"
#include <stdio.h>
#include "mlsubr.h"

#if !PROD_LEV && 0			/* CF: local debugging */
# define XDB(lv,x)	if( f_xdebug >= (lv) ) { x }else;
#else
# define XDB(lv,x)	/*empty*/
#endif

/*
 *  Make a copy of a fully constructed movelist.
 *  If there were not the linkage pointers, we would do a low level
 *  struct copy.  Currently: need not be very efficient.
 */
    Eximpl void
ml_copy( register const Movelist* src, register Movelist* dst )
{
    if( dst ) {
	clear_list(dst);
	if( src ) {
		register const Move*	mp;
	    formoves(src, mp) {
		app_move(mp, dst);
	    }
	    dst->l_attr    = src->l_attr;
	    dst->l_hasckmv = src->l_hasckmv;
	    mg_link(dst);		/* terminate construction */
	}
    }
}

/*
 *  When not yet done: attributize the moves in the list with their check attrs.
 *  Also: collect the set of pieces which have moves that say check.
 *  When there are any such moves, sort them before all others.
 *  List linkage is rebuild, here, if necessary.  The old linkage
 *  is used, and all hung out moves remain hung out (not inspected).
 *  FFS: not true: "mg_link_attr()" re-links them :-(
 *
 *  The following attributes are known:
 *   DCK: a direct (active) check
 *   ICK: an indirect (uncovered) check
 *   ECK: indirect check through the beaten e.p. pawn
 *   NCK: the direct check is "near" (additional info)
 */
    Eximpl void
ml_ck_attr(
    register Xconst Board*	bp,
    register Movelist*		lp)
{
    register Xconst Field*	tp;
    register Xconst Field*	fp;
    register Xconst Field*	ekp;
    register rPosition		ekpos;
    register Move*		mp;
    register PieceSet		mask;
    register PieceSet		atts;
    register int		dir;
    register int		delta;
    register Colour		self;
    const Field*		lastfp;
    uint8			lastick;

    XDB(1, printf("> ml_ck_attr\n"); )
    if( lp->l_attr & LA_CK ) {
	return;
    }
    lp->l_hasckmv = 0;
    self  = bp->b_tomove;
    ekpos = K_POS(bp, opp_colour(self));
    ekp   = &(bp->b_f[ ekpos ]);
    XDB(1, printf(": ekp @ "); put_position(ekpos); printf("\n"); )
    mask  = COLOUR_MASK(self);
    lastfp = 0;
#if lint
    lastick = 0;		/* shut off lint warnings */
#endif
    formoves(lp, mp) {
	fp = &(bp->b_f[ mp->m_from ]);
	tp = &(bp->b_f[ mp->m_to   ]);
	switch( fp->f_f ) {
	 default:	panic("ml_ck_attr: f_f"); /*NOTREACHED*/
	 case koenig:	/* beware castlings */
	    if( F_DATT(tp) & BOTH_KINGS ) {		/* normal K move */
		if( (atts = (F_DATT(fp) & F_IATT(ekp) & mask)) ) {
		    if( dam_dir(dir = att_dir(mp->m_from, ekpos))
		     && (lin_dir(dir) != lin_dir(att_dir(fp,tp))) ) {
						/* K is never near to K: */
			if( atts & F_IATT(&(fp[dam_mov[dir]])) ) {
			    mp->m_attr |= MA_ICK;
			}
		    }
		}
	    }else {				/* castling */
		tp -= (tp - fp)/2;		/* turm target */
		if( trm_dir(dir = att_dir(tp, ekp)) ) {
		    delta = dam_mov[dir];
		    tp += delta;
		    if( (tp == fp) || (tp->f_c == empty) ) {
			do {
			    tp += delta;
			}while( tp->f_c == empty );
		    }
		    if( tp == ekp ) {
			mp->m_attr |= MA_DCK;
		    }
		}
	    }
	    break;
	 case bauer:	/* beware e.p. */
	    if( (atts = (F_DATT(fp) & F_IATT(ekp) & mask)) ) {
		if( dam_dir(dir = att_dir(mp->m_from, ekpos))
		 && (lin_dir(dir) != lin_dir(att_dir(mp->m_from,mp->m_to))) ) {
		    delta = dam_mov[dir];	/* fp --> ekp */
		    if( (fp + delta) != ekp ) {
			if( atts & F_IATT(&(fp[delta])) ) {
			    mp->m_attr |= MA_ICK;
			}
		    }else {	/* near king possibly on L dir: search */
			do {
			    fp -= delta;
			}while( fp->f_c == empty );
			if( (fp->f_c == self) && (atts & SET1(fp->f_idx)) ) {
			    mp->m_attr |= MA_ICK;
			}
			fp = &(bp->b_f[ mp->m_from ]);	/* restored */
		    }
		}
	    }
	    switch( mp->m_fig ) {
	     default:	panic("ml_ck_attr: m_fig"); /*NOTREACHED*/
	     case bauer:		/* B -> B */
		if( ((tp + bau_left [self]) == ekp)
		 || ((tp + bau_right[self]) == ekp) ) {
		    mp->m_attr |= MA_DCK;		/* FFS: no MA_NCK ? */
		}
		if( (tp->f_c == empty)
		 && lfr_dir(att_dir(mp->m_from, mp->m_to)) ) {	/* e.p. */
		    /*
		     * Add special bit for those checks done by also
		     * removing the enemies B.
		     */
		    tp -= bau_mov[self];		/* also removed */
		    if( dam_dir(dir = att_dir(ekp, tp)) ) {
			    Xconst Field*	savekp;
			delta = dam_mov[dir];
			savekp = ekp;
			do {
			    ekp += delta;
			}while( (ekp==fp) || (ekp==tp) || (ekp->f_c == empty) );
			if( ekp->f_c == self ) {
			    if( (ekp->f_f == dame)
			     || ((ekp->f_f == turm   ) && trm_dir(dir))
			     || ((ekp->f_f == laeufer) && lfr_dir(dir)) ) {
				mp->m_attr |= MA_ECK;
			    }
			}
			ekp = savekp;
		    }
		}
		break;
	     case springer:		/* B -> S */
		if( spr_dir(att_dir(mp->m_to, ekpos)) ) {
		    mp->m_attr |= MA_DCK;
		}
		break;
	     case laeufer:		/* B -> L */
		if( lfr_dir(dir = att_dir(mp->m_to, ekpos)) ) {
		    goto prom_ltd_dir;
		}
		break;
	     case turm:			/* B -> T */
		if( trm_dir(dir = att_dir(mp->m_to, ekpos)) ) {
		    goto prom_ltd_dir;
		}
		break;
	     case dame:			/* B -> D */
		if( dam_dir(dir = att_dir(mp->m_to, ekpos)) ) {
		    /*
		     * The piece changes its attack type.  It may now
		     * attack backwards through its original position.
		     */
	prom_ltd_dir:;
		    delta = dam_mov[dir];	/* tp --> ekp */
		    tp += delta;
		    if( (tp != fp) && (tp->f_c != empty) ) {
			if( tp == ekp ) {
			    mp->m_attr |= MA_DCK | MA_NCK;
			}
		    }else {
			do {
			    tp += delta;
			}while( tp->f_c == empty );
			if( tp == ekp ) {
			    mp->m_attr |= MA_DCK;
			}
		    }
		}
	    } /* switch mp->m_fig */
	    break;
	 case springer:
	    if( (atts = (F_DATT(fp) & F_IATT(ekp) & mask)) ) {
		if( fp == lastfp ) {
		    mp->m_attr |= lastick;
		}else {
		    lastfp = fp;
		    if( dam_dir(dir = att_dir(mp->m_from, ekpos)) ) {
			delta = dam_mov[dir];
			if( (fp + delta) != ekp ) {
			    if( atts & F_IATT(&(fp[delta])) ) {
				mp->m_attr |= MA_ICK;
			    }
			}else {	/* near king possibly on L dir: search */
			    do {
				fp -= delta;
			    }while( fp->f_c == empty );
			    if( (fp->f_c==self) && (atts & SET1(fp->f_idx)) ) {
				mp->m_attr |= MA_ICK;
			    }
			}
		    }
		    lastick = mp->m_attr & MA_ICK;
		}
	    }
	    if( spr_dir(att_dir(mp->m_to, ekpos)) ) {
		mp->m_attr |= MA_DCK;
	    }
	    break;
	 case laeufer:
	    if( (atts = (F_DATT(fp) & F_IATT(ekp) & mask)) ) {
		if( fp == lastfp ) {
		    mp->m_attr |= lastick;
		}else {
		    lastfp = fp;
		    if( trm_dir(dir = att_dir(mp->m_from, ekpos)) ) {
			if( ((fp += dam_mov[dir]) == ekp)
			 || (atts & F_IATT(fp)) ) {
			    mp->m_attr |= MA_ICK;
			}
		    }
		    lastick = mp->m_attr & MA_ICK;
		}
	    }
	    if( lfr_dir(dir = att_dir(mp->m_to, ekpos)) ) {
		goto ltd_dir;
	    }
	    break;
	 case turm:
	    if( (atts = (F_DATT(fp) & F_IATT(ekp) & mask)) ) {
		if( fp == lastfp ) {
		    mp->m_attr |= lastick;
		}else {
		    lastfp = fp;
		    if( lfr_dir(dir = att_dir(mp->m_from, ekpos)) ) {
			delta = dam_mov[dir];
			if( (fp + delta) != ekp ) {
			    if( atts & F_IATT(&(fp[delta])) ) {
				mp->m_attr |= MA_ICK;
			    }
			}else {		/* near king on L dir: search */
			    do {
				fp -= delta;
			    }while( fp->f_c == empty );
			    if( (fp->f_c==self) && (atts & SET1(fp->f_idx)) ) {
				mp->m_attr |= MA_ICK;
			    }
			}
		    }
		    lastick = mp->m_attr & MA_ICK;
		}
	    }
	    if( trm_dir(dir = att_dir(mp->m_to, ekpos)) ) {
		goto ltd_dir;
	    }
	    break;
	 case dame:		/* never any indirect checks */
	    if( dam_dir(dir = att_dir(mp->m_to, ekpos)) ) {
    ltd_dir:    ;		/* NOTE: "fp" is not set, here */
		delta = att_dir(mp->m_from, mp->m_to);
		if( opp_dir(delta) == dir ) {
		    break;		/* moves away from the king */
		}
		if( delta == dir ) {	/* moves on that line towards the K */
		    /* follows its own attacks towards the K, and checks,
		     * if it beats the only intermediate piece, i.e.
		     * there is an indirect attack in the K, already.
		     */
		    if( (tp->f_c != empty)
		     && (F_IATT(ekp) & SET1(mp->m_idx)) ) {
			if( (tp + dam_mov[dir]) == ekp ) {
			    mp->m_attr |= MA_DCK | MA_NCK;
			}else {
			    mp->m_attr |= MA_DCK;
			}
		    }
		    break;
		}
		delta = dam_mov[dir];	/* tp --> ekp */
		tp += delta;
XDB(1,
    printf(": ltd_dir @ "); put_position(pos64_pos[tp->f_pos64]); printf("\n");
)
		if( tp->f_c != empty ) {
		    if( tp == ekp ) {
			mp->m_attr |= MA_DCK | MA_NCK;
		    }
		}else {
		    do {
			tp += delta;
		    }while( tp->f_c == empty );
		    if( tp == ekp ) {
			mp->m_attr |= MA_DCK;
		    }
		}
	    }
	    break;
	}
	if( mp->m_attr & MA__CK ) {
	    lp->l_hasckmv |= SET1(fp->f_idx);
	}
	XDB(1, printf("  attr %2x for ", mp->m_attr); put_move(bp, mp); )
    }
    if( lp->l_hasckmv ) {
	mg_link_attr(lp, MA__CK);	/* relink with checking moves first */
    }
    lp->l_attr |= LA_CK;
    XDB(1, printf("< ml_ck_attr\n"); )
}


    Eximpl void
mv_ck_attr(
    register Xconst Board*	bp,
    register Move*		mp)
{
    /*
     * The speed of this function is not crucial.
     * Therefore we create a movelist with just the move in it,
     * call "ml_ck_attr()" and transfer back the move attributes.
     */
    Movelist	mlist;

    mp->m_attr &= ~MA__CK;	/* clear out old garbage */
    clear_list(&mlist);		/* init new list */
    app_move(mp, &mlist);	/* append wanted move */
    mg_link(&mlist);		/* and close move list creation */
    ml_ck_attr(bp, &mlist);	/* create attrs ... and copy them: */
    mp->m_attr |= (mlist.l_first->m_attr & MA__CK);
}


/*
 * ml_sort_rdx()
 *	Sort the move list by decreasing value.
 *	Main method: radix sort	(cf. Knuth Vol 3, Algorithm R, 5.2.2)
 *	Modified to handle signed values.
 *	For small list lengthes use simple "straight insertion".
 */
#define RDX_TOTBITS	16
#define RDX_BITS	4		/* CF */
#define RDX_PHASES	((RDX_TOTBITS + RDX_BITS - 1) / RDX_BITS)

#define RDX_WIDTH	(1 << RDX_BITS)
#define RDX_MASK	((1 << RDX_BITS) - 1)

#define RDX_LWIDTH	(RDX_TOTBITS - ((RDX_PHASES - 1) * RDX_BITS))
#define RDX_LSPECIAL	1		/* CF */

#if RDX_LSPECIAL
# define RDX_UVAL(v)	((unsigned)(v))
# define RDX_0_SPECIAL	1		/* whether 0-value special-cased */
#else
# define RDX_UVAL(v)	((v) + (1 << (RDX_TOTBITS-1)))
# define RDX_0_SPECIAL	0		/* not expected */
#endif

typedef struct
{
    Move*	rb_last;
    Move*	rb_first;
} RdxBuck;

static Flag	inited_rdxbucks	= FALSE;	/* whether initialized */
static RdxBuck	rdxbucks[ RDX_WIDTH ];		/* initially 0-pointers */
#if RDX_0_SPECIAL
static RdxBuck	rdx0buck;
#endif

#define mnext(mp)	((mp)->m_next)		/* next move in list */

    Eximpl void
ml_sort_rdx( Movelist* lp )
{
    register Move*	mp;
    register Move*	p;

    /*
     * Small lengths are done best by straight insertion:
     * One radix phase is ca.
     *		RDX_WIDTH + list_length	== W + ll
     * straight insertion is at most
     *		(list_length ^ 2) / 2	== (ll*ll - 2*ll) / 2 + ll
     * So, straight is better if
     *		(ll * (ll-2))/2 < W
     * <=>	(ll * (ll-2)) < 2*W
     * <=>	(ll - 1)^2 - 1 < 2*W
     * <=>	(ll - 1)^2 <= 2*W
     * <=>	(ll - 1) <= sqrt(2*W)
     * <=>	ll <= 1 + sqrt(2*W)
     * As W == 2^B,
     *		sqrt(2*W) == sqrt(2^(B+1)) == 2^((B+1)/2)
     */
#define SQRT2POW(b)	((int) ((1 << ((b)/2)) * (1.0 + (0.41 * ((b)&01)))))
    if( list_length(lp) <= (1 + SQRT2POW(RDX_BITS+1)) ) {
					/* small length: straight insertion */
	    register int	v;
	    register Move*	last;
	    register Move*	np;
	    register Move*	sp;
		/* do not trust "list_length" to imply existing elements */
	sp = lp->l_first;
	if( sp ) {			/* at least one list element */
	    mp = mnext(sp);		/* not yet sorted rest */
	    mnext(sp) = (Move*)0;	/* one element sorted */
	    while( mp ) {
		np = mp;
		mp = mnext(mp);		/* cutted off "np" */
		v = np->m_value;	/* with value "v" */
		if( v > sp->m_value ) {	/* is new first element */
		    mnext(np) = sp;
		    sp = np;
		}else {			/* insert behind some element */
		    p = sp;
		    do {
			last = p;
			p = mnext(p);
		    }while( p && (v <= p->m_value) );
		    mnext(np) = p;
		    mnext(last) = np;
		}
	    }
	    lp->l_first = sp;
	}
    }else {					/* really radix sort */
	    register unsigned	uv;
	    register int	boff;		/* bit offset */
	    register RdxBuck*	bup;
	    register RdxBuck*	ebup;
	    register unsigned	uvored;
#if 1
	if( ! inited_rdxbucks ) {
	    for( uv=0 ; uv<RDX_WIDTH ; ++uv ) {
		rdxbucks[uv].rb_last  = 0;
		rdxbucks[uv].rb_first = 0;
	    }
# if RDX_0_SPECIAL
	    rdx0buck.rb_last  = 0;
	    rdx0buck.rb_first = 0;
# endif
	    inited_rdxbucks = TRUE;
	}
#endif
	mp = lp->l_first;
	boff   = 0;
	uvored = 0;
	do {
	    /*
	     * Distribute for current "boff" into "rdxbucks[]".
	     * The link in the last element in each bucket is not cleared.
	     */
	    if( ! boff ) {		/* first phase, collect "uvored" */
		for( ; mp ; mp=mnext(mp) ) {
		    uv = RDX_UVAL(mp->m_value);
#if RDX_0_SPECIAL
		    if( uv == 0 ) {
			bup = &rdx0buck;
		    }else
#endif
		    {
			uvored |= uv;
			bup = &(rdxbucks[ uv & RDX_MASK ]);
		    }
		    if( (p = bup->rb_last) ) {
			mnext(p) = mp;
		    }else {
			bup->rb_first = mp;
		    }
		    bup->rb_last = mp;
		}
		uvored &= ((1 << RDX_TOTBITS) - 1);
#if 0
		printf("uvored = %4x, lng = %2d\n",
			uvored & ((1<<RDX_TOTBITS)-1),
			list_length(lp));
#endif
	    }else {		/* have already "uvored" */
		if( ! (uvored & RDX_MASK) ) {
		    continue;
		}
#if 0 && (RDX_WIDTH > 1)
		 else {		/* there are bits, but low 0-s can be ignored */
		    while( ! (uvored & 01) ) {
			boff += 1;
			uvored >>= 1;
		    }
		}
#endif
		for( ; mp ; mp=mnext(mp) ) {
		    bup = rdxbucks + ((RDX_UVAL(mp->m_value)>>boff) & RDX_MASK);
		    if( (p = bup->rb_last) ) {
			mnext(p) = mp;
		    }else {
			bup->rb_first = mp;
		    }
		    bup->rb_last = mp;
		}
	    }
	    /*
	     * Collect the buckets, starting at the end.
	     * On the fly clear the buckets, again.
	     */
	    mp = (Move*)0;				/* rest list */
#if RDX_LSPECIAL
	    if( boff >= (RDX_TOTBITS - RDX_BITS) ) {
		/*
		 * Last phase, containing the sign bit
		 * "boff" bits are done, the sign is (1 << (RDX_TOTBITS-1)).
		 * Thus, two parts are there, each (RDX_TOTBITS-1-boff)
		 * bits large.
		 */
		ebup = rdxbucks + (uvored & RDX_MASK);	/* last filled */
		uv = (1 << (RDX_TOTBITS-1-boff));
		bup = rdxbucks + uv;
		while( bup <= ebup ) {
		    if( (p = bup->rb_last) ) {
			mnext(p) = mp;
			mp = bup->rb_first;
			bup->rb_last = (Move*)0;
		    }
		    ++bup;
		}
# if RDX_0_SPECIAL			/* between negative and positive */
		bup = &rdx0buck;
		if( (p = bup->rb_last) ) {
		    mnext(p) = mp;
		    mp = bup->rb_first;
		    bup->rb_last = (Move*)0;
		}
# endif	/* RDX_0_SPECIAL */
		bup = rdxbucks + uv - 1;
		if( bup < ebup ) {
		    ebup = bup;
		}
		bup = rdxbucks;
		do {
		    if( (p = bup->rb_last) ) {
			mnext(p) = mp;
			mp = bup->rb_first;
			bup->rb_last = (Move*)0;
		    }
		}while( ++bup <= ebup );
	    }else
#endif	/* RDX_LSPECIAL */
	    {
#if RDX_0_SPECIAL
		if( ! (uvored & ~RDX_MASK) ) {		/* will terminate */
		    bup = &rdx0buck;
		    if( (p = bup->rb_last) ) {
			mnext(p) = mp;
			mp = bup->rb_first;
			bup->rb_last = (Move*)0;
		    }
		}
#endif	/* RDX_0_SPECIAL */
		bup = rdxbucks;
		ebup = bup + (uvored & RDX_MASK);
		do {
		    if( (p = bup->rb_last) ) {
			mnext(p) = mp;
			mp = bup->rb_first;
			bup->rb_last = (Move*)0;
			/* bup->rb_first = (Move*)0;	*/
		    }
		}while( ++bup <= ebup );
	    }
	}while( (uvored >>= RDX_BITS) && ((boff += RDX_BITS) < RDX_TOTBITS) );
#if RDX_0_SPECIAL
	if( rdx0buck.rb_last ) {
#if !PROD_LEV && 1				/* CF */
	    printf("list = %8lx\n", (unsigned long) mp);
	    for( mp=lp->l_m ; mp < lp->l_free ; ++mp ) {
		printf("%8lx: val=%6d, uval=%6d, link=%8lx\n",
			(unsigned long) mp,
			mp->m_value,
			RDX_UVAL(mp->m_value),
			(unsigned long) mp->m_next
		);
	    }
	    printf("0b first=%8lx, last=%8lx\n", 
		    (unsigned long) rdx0buck.rb_first,
		    (unsigned long) rdx0buck.rb_last
	    );
#endif
	    panic("ml_sort_rdx: unsorted 0-bucket");
	}
#endif	/* RDX_0_SPECIAL */
	lp->l_first = mp;
    }
}
