/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/lang.h,v $
 * $Id: lang.h,v 3.3 1999/07/20 21:03:15 heiner Exp $
 *
 *	Languages
 */

#ifndef CHEST_lang_h_INCLUDED
#define CHEST_lang_h_INCLUDED

#include "types.h"

#define LANG_NONE	0		/* do NOT change */
#define LANG_GERMAN	1		/* deutsch */
#define LANG_ENGLISH	2
#define LANGS		3		/* first illegal value */
#ifndef DFT_LANG
# define DFT_LANG	LANG_GERMAN	/* CF: default language */
#endif

#define no_lang(lang)	(((lang) <= 0) || ((lang) >= LANGS))
#define is_lang(lang)	(! no_lang(lang) )

Extern int	lang_of_char( char c );

Extern char	lang_chr_colour (int lang, Colour c);	/* wb */
Extern char	lang_chr_Colour (int lang, Colour c);	/* WB */

Extern char	lang_chr_figure (int lang, Figure f);	/* pnbrqk */
Extern char	lang_chr_Figure (int lang, Figure f);	/* PNBRQK */

#endif	/* ndef CHEST_lang_h_INCLUDED */
