/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/job.h,v $
 * $Id: job.h,v 3.10 1999/11/28 22:08:53 heiner Exp $
 *
 * Implemented in "analyse.c"
 */

#ifndef CHEST_job_h_INCLUDED
#define CHEST_job_h_INCLUDED

#include "bastyp.h"

#ifndef WITH_EG
# define WITH_EG	0			/* CF: FFS*/
#endif

Extern int	f_jobtype;	/* type of job to do */
Extern int	f_jobattr;	/* attributes of that job */
Extern int	f_jobprog;	/* how to construct several jobs for 1 input */
Extern int	f_bulkmode;	/* EPD line in/out, one per job */
Extern int	f_Qallowed;	/* # of quiet moves allowed (FFS) */
Extern int	f_acmflags;	/* how to do adaptive chess fact memory */
Extern int	f_noanti;	/* suppress anti heuristic */
#if WITH_EG
  Extern int	f_eguse;	/* whether to use endgame theory tables */
#endif

#define JT_normal		0	/* orthodox */
#define JT_stalemate		1	/* force stalemate instead of mate */
#define JT_selfmate		2	/* force opponent to mate me */
#define JT_selfstalemate	3	/* force opponent to stalemate me */
#define JT_helpmate		4	/* cooperate for mate */
#define JT_helpstalemate	5	/* cooperate for stalemate */

#define JTA_ortho	(1 << 0)	/* orthodox (attacker/defender) */
#define JTA_help	(1 << 1)	/* both are "attacker" */
#define JTA_self	(1 << 2)	/* attacker to be [stale]mated */
#define JTA_mate	(1 << 3)	/* goal: mate */
#define JTA_stalemate	(1 << 4)	/* goal: stalemate */
#define JTA_2plies	(1 << 5)	/* two plies in last move */

#define JTA__normal		(JTA_ortho              | JTA_mate)
#define JTA__stalemate		(JTA_ortho              | JTA_stalemate)
#define JTA__selfmate		(JTA_self  | JTA_2plies | JTA_mate)
#define JTA__selfstalemate	(JTA_self  | JTA_2plies | JTA_stalemate)
#define JTA__helpmate		(JTA_help  | JTA_2plies | JTA_mate)
#define JTA__helpstalemate	(JTA_help  | JTA_2plies | JTA_stalemate)

#define JTP_DIR		(1 << 0)	/* normal/direct job */
#define JTP_DIR_SUCCRDY	(1 << 1)	/* stop, if DIR successful */
#define JTP_DEP_REDU	(1 << 2)	/* do rest with reduced depth */
#define JTP_LOST	(1 << 3)	/* prove "lost" after 1 move */
#define JTP_SET		(1 << 4)	/* unrelated subjobs after 1 move */

#define JTP__normal	(JTP_DIR)
#define JTP__lost	(JTP_LOST)
#define JTP__set	(JTP_SET)
#define JTP__botheasy	(JTP_DIR|JTP_DIR_SUCCRDY|JTP_DEP_REDU|JTP_LOST)
#define JTP__bothhard	(JTP_DIR|JTP_DIR_SUCCRDY             |JTP_LOST)

/*
 * The following function MUST be used to set "f_jobtype".
 * It also assignes the (redundant) "f_jobattr".
 */
Extern void	set_jobtype( int );

/*
 * For an explanation of the following two read "MEMO.nomove".
 * They are used to find out whether (the attacker's) job succeeds,
 * when either the attacker or the defender has no legal move left.
 */
#define JsuccAnomove(bp)	\
    ( (f_jobattr & JTA_2plies) && (!in_check(bp) == !(f_jobattr & JTA_mate)) )

#define JsuccDnomove(bp)	\
    (!(f_jobattr & JTA_2plies) && (!in_check(bp) == !(f_jobattr & JTA_mate)) )

/*
 * Explanation/definition of the types of job
 * by the properties of the solution tree.
 * The side to move initially is called "attacker",
 * the other side is called "defender".
 *
 * A "mate position" is a position, such that the side to move
 * has no more legal moves, and is in check (its king is attacked).
 *
 * A "stalemate position" is a position, such that the side to move
 * has no more legal moves, and is NOT in check (its king is not attacked).
 *
 * A common structure for a "forced" solution tree is:
 * FORCED(typ, pos, dep) [dep>1]
 * - there is no smaller solution FORCED(typ,pos,k) with k<dep.
 * - there are 1 or more (legal) moves A, such that for all A:
 *   + there are 1 or more (legal) defender moves
 *   + for all (legal) defender moves D:
 *     there exists FORCED(typ, pos.A.D, k) with k<dep.
 *
 * The second structure here known is
 * HELP(typ, pos, dep) [dep>1]
 * - there is no smaller solution HELP(typ,pos,k) with k<dep.
 * - there are one or more (legal) moves A, such that for all of them:
 *   + there are one or more (legal) moves D in P.A, such that for all of them:
 *     there exists HELP(typ, pos.A.D, k) with k<dep.
 * 
 * JT_normal:
 *   FORCED(mate, P, 1) = 
 *     one or more moves A, such that P.A is mate position.
 *
 * JT_stalemate:
 *   FORCED(stalemate, P, 1) = 
 *     one or more moves A, such that P.A is stalemate position.
 *
 * JT_selfmate:
 *   FORCED(selfmate, P, 1) = 
 *     one or more moves A, such that
 *     - there are one or more defender moves in P.A
 *     - for all defender moves D in P.A: P.A.D is mate position.
 *
 * JT_selfstalemate:
 *   FORCED(selfstalemate, P, 1) = 
 *     one or more moves A, such that
 *     - there are one or more defender moves in P.A
 *     - for all defender moves D in P.A: P.A.D is stalemate position.
 *
 * JT_helpmate:
 *   HELP(helpmate, P, 1) =
 *     one or more moves A, such that
 *     there are one or more (legal) moves D in P.A, such that
 *     P.A.D is mate position.
 *
 * JT_helpstalemate:
 *   HELP(helpmate, P, 1) =
 *     one or more moves A, such that
 *     there are one or more (legal) moves D in P.A, such that
 *     P.A.D is stalemate position.
 */

#endif	/* ndef CHEST_job_h_INCLUDED */
