#include <err.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <netinet/ipl.h>
#include <netinet/ip_fil.h>
#include <netinet/ip_state.h>
#include <netinet/ip_nat.h>
#include <netinet/ip_frag.h>

#ifdef USE_INET6
#define IPF_CALL(func) func ## _inet6
#else
#define IPF_CALL(func) func ## _default
#endif


int
IPF_CALL(get_ip_states)(int *cur, int *max) {
	int ret = -1;
	int ipstate_fd;
	ips_stat_t iss;
	ipfobj_t ipfo;

	if ((ipstate_fd = open("/dev/ipstate", O_RDONLY, 0)) == -1) {
		warn("failed to open /dev/ipstate");
		goto out;
	}

	memset(&ipfo, 0, sizeof(ipfo));
	ipfo.ipfo_rev = IPFILTER_VERSION;
	ipfo.ipfo_type = IPFOBJ_STATESTAT;
	ipfo.ipfo_size = sizeof(iss);
	ipfo.ipfo_ptr = &iss;
	
	if (ioctl(ipstate_fd, SIOCGETFS, &ipfo) == -1) {
		warn("ioctl SIOCGETFS failed on /dev/ipstate");
		goto out;
	}


	*cur = iss.iss_active;
	*max = iss.iss_state_max;
	ret = 0;

out:
	if (ipstate_fd != -1)
		(void)close(ipstate_fd);

	return ret;
}

int
IPF_CALL(get_nat_states)(int *cur, int *max) {
	int ret = -1;
	int ipnat_fd;
	natstat_t ns;
	ipfobj_t ipfo;

	if ((ipnat_fd = open("/dev/ipnat", O_RDONLY, 0)) == -1) {
		warn("failed to open /dev/ipnat");
		goto out;
	}

	memset(&ipfo, 0, sizeof(ipfo));
	ipfo.ipfo_rev = IPFILTER_VERSION;
	ipfo.ipfo_type = IPFOBJ_NATSTAT;
	ipfo.ipfo_size = sizeof(ns);
	ipfo.ipfo_ptr = &ns;
	
	if (ioctl(ipnat_fd, SIOCGNATS, &ipfo) == -1) {
		warn("ioctl SIOCGNATS failed on /dev/ipnat");
		goto out;
	}

	*cur = ns.ns_active;
	*max = ns.ns_nattab_max;
	ret = 0;

out:
	if (ipnat_fd != -1)
		(void)close(ipnat_fd);

	return ret;
}

int
IPF_CALL(get_frag_states)(int *cur, int *max) {
	int ret = -1;
	int ipl_fd;
	ipfrstat_t ifs;
	ipfobj_t ipfo;

	if ((ipl_fd = open("/dev/ipl", O_RDONLY, 0)) == -1) {
		warn("open /dev/ipl failed");
		goto out;
	}

	memset(&ipfo, 0, sizeof(ipfo));
	ipfo.ipfo_rev = IPFILTER_VERSION;
	ipfo.ipfo_type = IPFOBJ_FRAGSTAT;
	ipfo.ipfo_size = sizeof(ifs);
	ipfo.ipfo_ptr = &ifs;
	
	if (ioctl(ipl_fd, SIOCGFRST, &ipfo) == -1) {
		warn("ioctl SIOCGFRST failed on /dev/ipl");
		goto out;
	}


	*cur = ifs.ifs_inuse;
	*max = IPFT_SIZE;
	ret = 0;

out:
	if (ipl_fd != -1)
		(void)close(ipl_fd);

	return ret;
}
