/*
 * CDE - Common Desktop Environment
 *
 * Copyright (c) 1993-2012, The Open Group. All rights reserved.
 *
 * These libraries and programs are free software; you can
 * redistribute them and/or modify them under the terms of the GNU
 * Lesser General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * These libraries and programs are distributed in the hope that
 * they will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with these libraries and programs; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */
/*%%  (c) Copyright 1993, 1994 Hewlett-Packard Company			 */
/*%%  (c) Copyright 1993, 1994 International Business Machines Corp.	 */
/*%%  (c) Copyright 1993, 1994 Sun Microsystems, Inc.			 */
/*%%  (c) Copyright 1993, 1994 Novell, Inc. 				 */
/*%%  $XConsortium: mp_s_pattern.h /main/3 1995/10/23 11:57:50 rswiston $ 			 				 */
/* -*-C++-*-
 *
 * @(#)mp_s_pattern.h	1.7 29 Jul 1993
 *
 * Tool Talk Message Passer (MP) - mp_s_pattern.h
 * 
 * Copyright (c) 1990, 1992 by Sun Microsystems, Inc.
 * 
 * This file implements the server side of the _Tt_pattern object.
 */

#ifndef _MP_S_PATTERN_H
#define _MP_S_PATTERN_H

#include "mp/mp_pattern.h"
#include "mp/mp_arg_utils.h"
#include "mp_ptype_utils.h"
#include "mp_s_pattern_utils.h"
#include "mp_signature_utils.h"

class _Tt_msg_trace;
class _Tt_s_message;

class _Tt_s_pattern : public _Tt_pattern {
      public:
        _Tt_s_pattern();
	_Tt_s_pattern(const _Tt_signature_ptr &sig);
	virtual ~_Tt_s_pattern();

	int			match(
					const _Tt_s_message        &m,
					const _Tt_msg_trace	   &trace
				) const;
        Tt_status               add_arg(const _Tt_arg_ptr &arg);
	Tt_status		join_context(const _Tt_msg_context &context);
	Tt_status		quit_context(const _Tt_msg_context &context);
	_Tt_ptype_ptr		&generating_ptype(); // ptype it was generated
                                                     // by declaring
	_Tt_ptype_ptr		&generating_ptype(_Tt_ptype_ptr &pt); // set it
	int			is_from_ptype(); // true if generated by
						 // declaring a ptype
	unsigned int		timestamp() const
					{ return _timestamp; }
	void			set_timestamp(unsigned int stamp)
					{ _timestamp = stamp; }

      protected:
	// server-only methods that aid in matching patterns and
	// messages. 
	int			match_field(
					int			    val,
					const _Tt_int_rec_list_ptr &pvals,
					int			   &tm,
					const _Tt_msg_trace	   &trace,
					const char	    	   *failure_note
				) const;
	int			match_field(
					const _Tt_string	   &val,
					const _Tt_string_list_ptr  &pvals,
					int			   &tm,
					const _Tt_msg_trace	   &trace,
					const char		   *failure_note
				) const;
	int			match_scopes(
					const _Tt_message	   &m,
					int			   &tm,
					const _Tt_msg_trace	   &trace
				) const;
	int			match_args(
					const _Tt_message	   &m,
					int			   &tm,
					const _Tt_msg_trace	   &trace
				) const;
	int			match_contexts(
					const _Tt_message	   &m,
					int			   &tm,
					const _Tt_msg_trace	   &trace
				) const;
      private:
	_Tt_ptype_ptr		_generating_ptype;
	unsigned int		_timestamp;

	friend class		_Tt_mp;
	friend class		_Tt_message;
};
#include "mp_s_pattern_inlines.h"

#endif				/* _MP_S_PATTERN_H */
