/**
 * @namespace   biewlib
 * @file        biewlib/sysdep/ppc/macos/nls.c
 * @brief       This file contains implementation of OEM codepages support for PPC
 * @version     -
 * @remark      this source file is part of Binary vIEW project (BIEW).
 *              The Binary vIEW (BIEW) is copyright (C) 1995 Nickols_K.
 *              All rights reserved. This software is redistributable under the
 *              licence given in the file "Licence.en" ("Licence.ru" in russian
 *              translation) distributed in the BIEW archive.
 * @note        Requires POSIX compatible development system
 *
 * @author      Nickols_K
 * @since       1999
 * @note        Development, fixes and improvements
**/
#include "biewlib/biewlib.h"

static char alt2mac[] =
{
0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f,
0xe0,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,0xeb,0xec,0xed,0xee,0xef,
0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,
0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
0xd0,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xdb,0xdc,0xdd,0xde,0xdf,
0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xdf,
0xdd,0xde,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff
};

void __FASTCALL__ __nls_OemToOsdep(unsigned char *buff,unsigned len)
{
 int i;
 unsigned char cc,ch;
 for(i = 0;i < len;i++)
 {
   cc = buff[i];
   if(cc >= 0x80)
                  ch = alt2mac[cc-0x80];
   else           ch = cc;
  buff[i] = ch;
 }
}

void __FASTCALL__ __nls_OemToFs(unsigned char *buff,unsigned len)
{
 int i;
 unsigned char cc,ch;
 for(i = 0;i < len;i++)
 {
   cc = buff[i];
   if(cc >= 0x80)
                  ch = alt2mac[cc-0x80];
   else           ch = cc;
  buff[i] = ch;
 }
}

void __FASTCALL__ __nls_CmdlineToOem(unsigned char *buff,unsigned len)
{
}
