/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.bluemodern;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentBlueModernGroupingHeader
extends AbstractTextualComponent {
    private final int cornersize = 10;
    private final int commentMargin = 0;
    private final TextBlock commentTextBlock;
    private final HtmlColor headerBackgroundColor;
    private final HtmlColor generalBackgroundColor;
    private final HtmlColor borderColor;

    public ComponentBlueModernGroupingHeader(HtmlColor headerBackgroundColor, HtmlColor generalBackgroundColor, HtmlColor borderColor, HtmlColor fontColor2, FontConfiguration bigFont, UFont smallFont, Display strings, ISkinSimple spriteContainer) {
        super(strings.get(0), bigFont, HorizontalAlignment.LEFT, 15, 30, 1, spriteContainer, 0.0, null, null);
        this.headerBackgroundColor = headerBackgroundColor;
        this.generalBackgroundColor = generalBackgroundColor;
        this.borderColor = borderColor;
        this.commentTextBlock = strings.size() == 1 || strings.get(1) == null ? null : Display.create("[" + strings.get(1) + "]").create(new FontConfiguration(smallFont, fontColor2, bigFont.getHyperlinkColor(), bigFont.useUnderlineForHyperlink()), HorizontalAlignment.LEFT, spriteContainer);
    }

    @Override
    public final double getPreferredWidth(StringBounder stringBounder) {
        double sup;
        if (this.commentTextBlock == null) {
            sup = 0.0;
        } else {
            Dimension2D size = this.commentTextBlock.calculateDimension(stringBounder);
            sup = (double)(this.getMarginX1() + 0) + size.getWidth();
        }
        return this.getTextWidth(stringBounder) + sup;
    }

    @Override
    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 2.0 * this.getPaddingY();
    }

    @Override
    protected void drawBackgroundInternalU(UGraphic ug, Area area) {
        Dimension2D dimensionToUse = area.getDimensionToUse();
        ug.apply(new UChangeColor(this.borderColor)).apply(new UStroke(2.0)).apply(new UChangeBackColor(this.generalBackgroundColor)).draw(new URectangle(dimensionToUse.getWidth(), dimensionToUse.getHeight()));
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        Dimension2D dimensionToUse = area.getDimensionToUse();
        ug = ug.apply(new UChangeColor(this.borderColor));
        ug.apply(new UStroke(2.0)).draw(new URectangle(dimensionToUse.getWidth(), dimensionToUse.getHeight()));
        StringBounder stringBounder = ug.getStringBounder();
        int textWidth = (int)this.getTextWidth(stringBounder);
        int textHeight = (int)this.getTextHeight(stringBounder);
        UPolygon polygon = new UPolygon();
        polygon.addPoint(0.0, 0.0);
        polygon.addPoint(textWidth, 0.0);
        polygon.addPoint(textWidth, textHeight - 10);
        polygon.addPoint(textWidth - 10, textHeight);
        polygon.addPoint(0.0, textHeight);
        polygon.addPoint(0.0, 0.0);
        ug = ug.apply(new UStroke(2.0));
        ug = ug.apply(new UChangeBackColor(this.headerBackgroundColor));
        ug.draw(polygon);
        ug.draw(new ULine(dimensionToUse.getWidth(), 0.0));
        double heightWithoutPadding = dimensionToUse.getHeight() - this.getPaddingY();
        ug.apply(new UTranslate(dimensionToUse.getWidth(), 0.0)).draw(new ULine(0.0, heightWithoutPadding));
        ug.apply(new UTranslate(0.0, textHeight)).draw(new ULine(0.0, heightWithoutPadding - (double)textHeight));
        ug = ug.apply(new UStroke());
        this.getTextBlock().drawU(ug.apply(new UTranslate(this.getMarginX1(), this.getMarginY())));
        if (this.commentTextBlock != null) {
            int x1 = this.getMarginX1() + textWidth;
            int y2 = this.getMarginY() + 1;
            this.commentTextBlock.drawU(ug.apply(new UChangeColor(this.generalBackgroundColor)).apply(new UTranslate(x1 + 0, y2)));
        }
    }
}

