/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project2;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.project2.Day;
import net.sourceforge.plantuml.project2.Row;
import net.sourceforge.plantuml.project2.TimeConverter;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class RowSimple
implements Row {
    private static final int HEIGHT = 12;
    private final Day first;
    private final Day last;
    private final HtmlColor backcolor;
    private final TextBlock header;

    public RowSimple(Day first, Day last) {
        this(first, last, HtmlColorUtils.BLACK);
    }

    public RowSimple(Day first, Day last, HtmlColor backcolor) {
        this(first, last, backcolor, TextBlockUtils.empty(0.0, 12.0));
    }

    public RowSimple(Day first, Day last, HtmlColor backcolor, TextBlock header) {
        this.first = first;
        this.last = last;
        this.backcolor = backcolor;
        if (last.compareTo(first) < 0) {
            throw new IllegalArgumentException();
        }
        this.header = header;
    }

    @Override
    public TextBlock asTextBloc(final TimeConverter timeConverter) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                double x1 = RowSimple.this.getMinXwithoutHeader(timeConverter) + 1.0;
                double x2 = RowSimple.this.getMaxXwithoutHeader(timeConverter) - 1.0;
                double height = RowSimple.this.getHeight() - 4.0;
                URectangle rect = new URectangle(x2 - x1, height, 4.0, 4.0);
                ug.apply(new UChangeColor(HtmlColorUtils.RED)).apply(new UChangeBackColor(RowSimple.this.backcolor)).apply(new UTranslate(x1, 2.0)).draw(rect);
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                double width = RowSimple.this.getMaxXwithoutHeader(timeConverter) - RowSimple.this.getMinXwithoutHeader(timeConverter);
                double height = RowSimple.this.getHeight();
                return new Dimension2DDouble(width, height);
            }
        };
    }

    @Override
    public double getMinXwithoutHeader(TimeConverter timeConverter) {
        return timeConverter.getStartPosition(this.first);
    }

    @Override
    public double getMaxXwithoutHeader(TimeConverter timeConverter) {
        return timeConverter.getEndPosition(this.last);
    }

    @Override
    public double getHeight() {
        return 12.0;
    }

    @Override
    public TextBlock header() {
        return this.header;
    }
}

