/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import java.util.GregorianCalendar;
import net.sourceforge.plantuml.project.DayClose;
import net.sourceforge.plantuml.project.Month;
import net.sourceforge.plantuml.project.WeekDay;

public class Day
implements Comparable<Day> {
    private final int numDay;
    private final Month month;
    private final int year;
    private final WeekDay weekDay;

    private Day(int year, Month month, int numDay, WeekDay weekDay) {
        this.year = year;
        this.month = month;
        this.numDay = numDay;
        this.weekDay = weekDay;
    }

    public static boolean isValidDesc(String desc) {
        if (desc.matches("^\\d{4}/\\d{2}/\\d{2}$")) {
            return true;
        }
        return desc.matches("^\\d{2}-[A-Za-z]{3}-\\d{4}$");
    }

    public Day(String desc) {
        if (desc.matches("^\\d{4}/\\d{2}/\\d{2}$")) {
            this.year = Integer.parseInt(desc.substring(0, 4));
            this.month = Month.fromNum(Integer.parseInt(desc.substring(5, 7)));
            this.numDay = Integer.parseInt(desc.substring(8, 10));
        } else if (desc.matches("^\\d{2}-[A-Za-z]{3}-\\d{4}$")) {
            this.year = Integer.parseInt(desc.substring(7, 11));
            this.month = Month.valueOf(desc.substring(3, 6));
            this.numDay = Integer.parseInt(desc.substring(0, 2));
        } else {
            throw new IllegalArgumentException(desc);
        }
        int wd = new GregorianCalendar(this.year, this.month.getNum() - 1, this.numDay).get(7);
        this.weekDay = WeekDay.values()[wd - 1];
    }

    public Day next(DayClose dayClose) {
        if (dayClose == null) {
            return this.nextInternal();
        }
        if (dayClose.isClose(this)) {
            throw new IllegalArgumentException();
        }
        Day result = this.nextInternal();
        while (dayClose.isClose(result)) {
            result = result.nextInternal();
        }
        return result;
    }

    public Day prev(DayClose dayClose) {
        if (dayClose == null) {
            return this.prevInternal();
        }
        if (dayClose.isClose(this)) {
            throw new IllegalArgumentException();
        }
        Day result = this.prevInternal();
        while (dayClose.isClose(result)) {
            result = result.prevInternal();
        }
        return result;
    }

    private Day nextInternal() {
        if (this.numDay < this.month.getNbDays(this.year)) {
            return new Day(this.year, this.month, this.numDay + 1, this.weekDay.next());
        }
        Month next = this.month.next();
        if (next == null) {
            return new Day(this.year + 1, Month.JAN, 1, this.weekDay.next());
        }
        return new Day(this.year, next, 1, this.weekDay.next());
    }

    private Day prevInternal() {
        if (this.numDay > 1) {
            return new Day(this.year, this.month, this.numDay - 1, this.weekDay.prev());
        }
        Month prev = this.month.prev();
        if (prev == null) {
            return new Day(this.year - 1, Month.DEC, 31, this.weekDay.prev());
        }
        return new Day(this.year, prev, prev.getNbDays(this.year), this.weekDay.prev());
    }

    public String toString() {
        return "" + (Object)((Object)this.weekDay) + " " + this.year + "-" + (Object)((Object)this.month) + "-" + String.format("%02d", this.numDay);
    }

    public final int getNumDay() {
        return this.numDay;
    }

    public final Month getMonth() {
        return this.month;
    }

    public final int getYear() {
        return this.year;
    }

    @Override
    public int compareTo(Day other) {
        if (this.year > other.year) {
            return 1;
        }
        if (this.year < other.year) {
            return -1;
        }
        int cmpMonth = this.month.compareTo(other.month);
        if (cmpMonth != 0) {
            return cmpMonth;
        }
        return this.numDay - other.numDay;
    }

    public boolean equals(Object obj) {
        Day this2 = (Day)obj;
        return this.numDay == this2.numDay && this.month == this2.month && this.year == this2.year;
    }

    public int hashCode() {
        return this.numDay * 420 + this.year + this.month.hashCode();
    }

    public final WeekDay getWeekDay() {
        return this.weekDay;
    }
}

