/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.ColorParser;

public class CommandCreateElementFull
extends SingleLineCommand2<DescriptionDiagram> {
    private static final String CODE_CORE = "[\\p{L}0-9_.]+|\\(\\)[%s]*[\\p{L}0-9_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]";
    private static final String CODE = "([\\p{L}0-9_.]+|\\(\\)[%s]*[\\p{L}0-9_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\])";
    private static final String CODE_WITH_QUOTE = "([\\p{L}0-9_.]+|\\(\\)[%s]*[\\p{L}0-9_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]|[%g][^%g]+[%g])";
    private static final String DISPLAY_CORE = "[%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]";
    private static final String DISPLAY = "([%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\])";
    private static final String DISPLAY_WITHOUT_QUOTE = "([%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]|[\\p{L}0-9_.]+)";

    public CommandCreateElementFull() {
        super(CommandCreateElementFull.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("SYMBOL", "(?:(artifact|actor|folder|package|rectangle|node|frame|cloud|database|queue|storage|agent|usecase|component|boundary|control|entity|interface|\\(\\))[%s]+)?"), new RegexLeaf("[%s]*"), new RegexOr(new RegexLeaf("CODE1", CODE_WITH_QUOTE), new RegexConcat(new RegexLeaf("DISPLAY2", DISPLAY), new RegexLeaf("STEREOTYPE2", "(?:[%s]+(\\<\\<.+\\>\\>))?"), new RegexLeaf("[%s]*as[%s]+"), new RegexLeaf("CODE2", CODE)), new RegexConcat(new RegexLeaf("CODE3", CODE), new RegexLeaf("STEREOTYPE3", "(?:[%s]+(\\<\\<.+\\>\\>))?"), new RegexLeaf("[%s]+as[%s]*"), new RegexLeaf("DISPLAY3", DISPLAY)), new RegexConcat(new RegexLeaf("DISPLAY4", DISPLAY_WITHOUT_QUOTE), new RegexLeaf("STEREOTYPE4", "(?:[%s]+(\\<\\<.+\\>\\>))?"), new RegexLeaf("[%s]*as[%s]+"), new RegexLeaf("CODE4", CODE))), new RegexLeaf("STEREOTYPE", "(?:[%s]*(\\<\\<.+\\>\\>))?"), new RegexLeaf("[%s]*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*"), ColorParser.exp1(), new RegexLeaf("$"));
    }

    @Override
    protected final boolean isForbidden(CharSequence line) {
        return line.toString().matches("^[\\p{L}0-9_.]+$");
    }

    @Override
    protected CommandExecutionResult executeArg(DescriptionDiagram diagram, RegexResult arg) {
        String urlString;
        USymbol usymbol;
        LeafType type;
        String symbol;
        String codeRaw = arg.getLazzy("CODE", 0);
        String displayRaw = arg.getLazzy("DISPLAY", 0);
        char codeChar = this.getCharEncoding(codeRaw);
        char codeDisplay = this.getCharEncoding(displayRaw);
        if (codeRaw.startsWith("()")) {
            symbol = "interface";
            codeRaw = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(codeRaw.substring(2)));
        } else {
            symbol = codeChar == '(' || codeDisplay == '(' ? "usecase" : (codeChar == ':' || codeDisplay == ':' ? "actor" : (codeChar == '[' || codeDisplay == '[' ? "component" : arg.get("SYMBOL", 0)));
        }
        if (symbol == null) {
            type = LeafType.DESCRIPTION;
            usymbol = USymbol.ACTOR;
        } else if (symbol.equalsIgnoreCase("artifact")) {
            type = LeafType.DESCRIPTION;
            usymbol = USymbol.ARTIFACT;
        } else if (symbol.equalsIgnoreCase("folder")) {
            type = LeafType.DESCRIPTION;
            usymbol = USymbol.FOLDER;
        } else if (symbol.equalsIgnoreCase("package")) {
            type = LeafType.DESCRIPTION;
            usymbol = USymbol.PACKAGE;
        } else if (symbol.equalsIgnoreCase("rectangle")) {
            type = LeafType.DESCRIPTION;
            usymbol = USymbol.RECTANGLE;
        } else if (symbol.equalsIgnoreCase("node")) {
            type = LeafType.DESCRIPTION;
            usymbol = USymbol.NODE;
        } else if (symbol.equalsIgnoreCase("frame")) {
            type = LeafType.DESCRIPTION;
            usymbol = USymbol.FRAME;
        } else if (symbol.equalsIgnoreCase("cloud")) {
            type = LeafType.DESCRIPTION;
            usymbol = USymbol.CLOUD;
        } else if (symbol.equalsIgnoreCase("database")) {
            type = LeafType.DESCRIPTION;
            usymbol = USymbol.DATABASE;
        } else if (symbol.equalsIgnoreCase("queue")) {
            type = LeafType.DESCRIPTION;
            usymbol = USymbol.QUEUE;
        } else if (symbol.equalsIgnoreCase("storage")) {
            type = LeafType.DESCRIPTION;
            usymbol = USymbol.STORAGE;
        } else if (symbol.equalsIgnoreCase("agent")) {
            type = LeafType.DESCRIPTION;
            usymbol = USymbol.AGENT;
        } else if (symbol.equalsIgnoreCase("actor")) {
            type = LeafType.DESCRIPTION;
            usymbol = USymbol.ACTOR;
        } else if (symbol.equalsIgnoreCase("component")) {
            type = LeafType.DESCRIPTION;
            usymbol = diagram.getSkinParam().useUml2ForComponent() ? USymbol.COMPONENT2 : USymbol.COMPONENT1;
        } else if (symbol.equalsIgnoreCase("boundary")) {
            type = LeafType.DESCRIPTION;
            usymbol = USymbol.BOUNDARY;
        } else if (symbol.equalsIgnoreCase("control")) {
            type = LeafType.DESCRIPTION;
            usymbol = USymbol.CONTROL;
        } else if (symbol.equalsIgnoreCase("entity")) {
            type = LeafType.DESCRIPTION;
            usymbol = USymbol.ENTITY_DOMAIN;
        } else if (symbol.equalsIgnoreCase("interface")) {
            type = LeafType.DESCRIPTION;
            usymbol = USymbol.INTERFACE;
        } else if (symbol.equalsIgnoreCase("()")) {
            type = LeafType.DESCRIPTION;
            usymbol = USymbol.INTERFACE;
        } else if (symbol.equalsIgnoreCase("usecase")) {
            type = LeafType.USECASE;
            usymbol = null;
        } else {
            throw new IllegalStateException();
        }
        Code code = Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(codeRaw));
        String display = displayRaw;
        if (display == null) {
            display = code.getFullName();
        }
        display = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(display);
        String stereotype = arg.getLazzy("STEREOTYPE", 0);
        ILeaf entity = diagram.getOrCreateLeaf(code, type, usymbol);
        entity.setDisplay(Display.getWithNewlines(display));
        entity.setUSymbol(usymbol);
        if (stereotype != null) {
            entity.setStereotype(new Stereotype(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, null, false), diagram.getSkinParam().getIHtmlColorSet()));
        }
        if ((urlString = arg.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            entity.addUrl(url);
        }
        entity.setSpecificBackcolor(diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("COLOR", 0)));
        return CommandExecutionResult.ok();
    }

    private char getCharEncoding(String codeRaw) {
        return codeRaw != null && codeRaw.length() > 2 ? codeRaw.charAt(0) : (char)'\u0000';
    }
}

