/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionCollection;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.NotePosition;

public class InstructionGroup
implements Instruction,
InstructionCollection {
    private final InstructionList list;
    private final Instruction parent;
    private final HtmlColor backColor;
    private final HtmlColor titleColor;
    private final Display test;
    private Display headerNote = Display.NULL;

    public InstructionGroup(Instruction parent, Display test, HtmlColor backColor, HtmlColor titleColor, Swimlane swimlane) {
        this.list = new InstructionList(swimlane);
        this.parent = parent;
        this.test = test;
        this.backColor = backColor;
        this.titleColor = titleColor;
    }

    @Override
    public void add(Instruction ins) {
        this.list.add(ins);
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        return factory.createGroup(this.list.createFtile(factory), this.test, this.backColor, this.titleColor, this.headerNote);
    }

    public Instruction getParent() {
        return this.parent;
    }

    @Override
    public final boolean kill() {
        return this.list.kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return null;
    }

    @Override
    public boolean addNote(Display note, NotePosition position) {
        if (this.list.isEmpty()) {
            this.headerNote = note;
            return true;
        }
        return this.list.addNote(note, position);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.list.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.list.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.list.getSwimlaneOut();
    }

    @Override
    public Instruction getLast() {
        return this.list.getLast();
    }
}

