#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "globals.h"
#include "functions.h"

/* error() - output error messages */

void error(char *token,char *expected,char *keyword)
{
  if (supress==0)
  {
    printf("Parse Error: Expected '%s' and got '%s' in '%s' on line %d\n",expected,token,keyword,line);
  }
}

void unsupported(char *keyword)
{
  printf("Not Supported: '%s' on line %d.\n            -- asp2php attemps work around it.\n",keyword,line);
}

void comment_out(char *tmp_token)
{
char token[TOKENSIZE];
int tokentype;

  fprintf(out,"// %s",tmp_token);
  while(1)
  {
    tokentype=gettoken(token);
    if (tokentype==TOK_EOF || tokentype==TOK_EOL)
    { fprintf(out,"\n"); break; }
    fprintf(out," %s",token);
  }
}

/* push() - pushback a token (for looking ahead) */

void push(char *token,int tokentype)
{
  if (tokenpush[0]!=0)
  {
    strcpy(tokenpush2,token);
    tokentypepush2=tokentype;
    return;
  }

  strcpy(tokenpush,token);
  tokentypepush=tokentype;
}

void push2(char *token,int tokentype)
{
  strcpy(tokenpush2,token);
  tokentypepush2=tokentype;
}

/* isnum() - check and see if current string is a number */

int isnum(char *s)
{
int l,t;

  l=strlen(s);

  for(t=0; t<l; t++)
  { if (s[t]<'0' || s[t]>'9') return 0; }

  return 1;
}

/* strcasestr_m - case insensitive version of strstr */
/* returns a pointer to the matching section of hejstack, or 0 if no match */
char *strcasestr_m(char *hejstack, char *needle)
{
int hejlen,neelen;
int t;

  hejlen=strlen(hejstack);
  neelen=strlen(needle);

  for(t=0; t<=hejlen-neelen; t++)
  {
    if (strncasecmp(&hejstack[t],needle,neelen)==0)
    { return &hejstack[t]; }
  }

  return (char *)0;
}

/* Decide the case of an asp variable and change */

void strcase(char *s)
{
int l,r;

  if (casesense==0) return;

  l=strlen(s);

  for(r=0; r<l; r++)
  {
    if (casesense==1)
    { s[r]=tolower(s[r]); }
      else
    { s[r]=toupper(s[r]); }
  }
}

int array_insert_value(char *buffer, int buffer_len, char *token)
{
int p;

  p=0;

  while (buffer[p]!=0)
  {
    while (buffer[p]!=0)
    { p++; }

    p++;
  }

  if (p+strlen(token)+2>=buffer_len) return -1;

  strcpy(buffer+p,token);
  p=p+strlen(token)+1;
  buffer[p]=0;

  return 0;
}

int array_get_index(char *buffer, char *token)
{
int p,i;

  p=0;
  i=0;

  while (buffer[p]!=0)
  {
    if (strcmp(&buffer[p], token)==0)
    {
      return i;
    }

    while (buffer[p]!=0)
    { p++; }
    p++;

    i++;
  }

  return -1;
}

int array_get_length(char *buffer)
{
int p,i;

  p=0;
  i=0;

  while (buffer[p]!=0)
  {
    while (buffer[p]!=0)
    { p++; }
    p++;

    i++;
  }

  return i;
}

char *array_get_value(char *buffer, int index)
{
int p,i;

  p=0;
  i=0;

  while (buffer[p]!=0)
  {
    if (index==i) return &buffer[p];
/*
    if (strcmp(&buffer[p], token)==0)
    {
      return i;
    }
*/

    while (buffer[p]!=0)
    { p++; }
    p++;

    i++;
  }

  return 0;
}

void array_print_all(char *buffer) /* for debugging */
{
int p;

  p=0;
  while (buffer[p]!=0)
  {
    printf("%s\n",&buffer[p]);

    while (buffer[p]!=0)
    { p++; }

    p++;
  }
}

void array_print_value(char *buffer, int index) /* for debugging */
{
int p,k;

  p=0;
  k=0;

  while (buffer[p]!=0)
  {
    if (k==index) printf("%s\n",&buffer[p]);

    while (buffer[p]!=0)
    { p++; }

    p++;
    k++;
  }
}

/* returns 1 if filename ends with one of the extensions to be converted */
int is_asp_filename(char *filename)
{
int t;
char *s;

  t=0;
  while(1)
  {
    s=array_get_value(aspextensions,t);
    if (s==0) break;

    if (strlen(filename)>strlen(s))
    {
      if (strcasecmp(filename+(strlen(filename)-strlen(s)),s)==0)
      { return 1; }
    }

    t++;
  }

  return 0;
}

int extcmp(char *filename, char *extension)
{
  if (strlen(filename)>strlen(extension))
  {
    if (strcasecmp(filename+(strlen(filename)-strlen(extension)),extension)==0)
    { return 1; }
  }

  return 0;
}

void change_extension(char *filename, char *extension)
{
int t,r;

  t=strlen(filename);

  for (r=t; r>=0; r--)
  {
    if (filename[r]=='.')
    {
      strcpy(filename+r,extension);
      return;
    }
  }
}

/* autoindent() - this sets up proper clean Kohnian style
   programming indenting in the outputted php code */

int autoindent()
{
int r;
char spaces[1024];

  /* if (column!=0) return 0; */
  strcpy(spaces,"");

  for (r=0; r<indent; r++)
  { strcat(spaces,"  "); }

  fprintf(out,"%s",spaces);

  return 0;
}

int autoindent_string(char *newtoken)
{
int r;
char spaces[1024];

  /* if (column!=0) return 0; */
  strcpy(spaces,"");

  for (r=0; r<indent; r++)
  { strcat(spaces,"  "); }

  strcat(newtoken,spaces);

  return 0;
}

void add_indent(char *newtoken)
{
int r;

  for (r=0; r<indent; r++)
  { strcat(newtoken,"  "); }
}

void strtolower(char *s)
{
int r;

  r=0;
  while(1)
  {
    if (s[r]==0) break;
    s[r]=tolower(s[r]);
    r++;
  }

}

void insert_isnum()
{
  fprintf(out,"\nfunction IsNumeric($n)\n{\n");
  fprintf(out,"  $p=trim($n);\n  $l=strlen($p);\n\n");
  fprintf(out,"  for ($t=0; $t<$l; $t++)\n");
  fprintf(out,"  {\n    $c=substr($p,$t,1);\n");
  fprintf(out,"    if ($c<'0' || $c>'9')\n");
  fprintf(out,"    { if ($c!='.') return 0; }\n");
  fprintf(out,"  }\n\n  return 1;\n}\n");

  add_isnum=0;
}

int is_endscript()
{
char token[1024];
int tokentype;
char molecule[4096];

  strcpy(molecule,"<");
  tokentype=gettoken(token);
  strcat(molecule,token);
  tokentype=gettoken(token);
  strcat(molecule,token);
  tokentype=gettoken(token);
  strcat(molecule,token);

  if (strcasecmp("</script>",molecule)==0)
  { return 1; }

  return 0;
}

void eval_funct_or_molecule(char *newtoken)
{
char token[TOKENSIZE];
int tokentype;

  tokentype=gettoken(token);
  push(token,tokentype);
  strcpy(newtoken,"");

  if (strcmp(token,"(")==0)
  { eval_funct(newtoken); }
    else
  { eval_molecule(newtoken); }
}

void remove_quotes(char *s)
{
int t,l;

  if (s[0]=='\'' || s[0]=='\"')
  {
    l=strlen(s);

    for (t=0; t<l; t++)
    {
      s[t]=s[t+1];
    }

    s[l-2]=0;
  }
}

void fixwinpath(char *filename)
{
int t;

  t=0;
  while(filename[t]!=0)
  {
    if (filename[t]=='\\') filename[t]='/';
    t++;
  }
}

int copy_file(char *source, char *dest)
{
FILE *fin,*fout;
unsigned char buffer[8193];
int t;

  fin=fopen(source,"r");
  if (fin==0)
  {
    printf("Error: Unable to open file for reading: %s\n",source);
    return 1;
  }

  fout=fopen(dest,"w");
  if (fout==0)
  {
    fclose(fin);
    printf("Error: Unable to open file for writing: %s\n",dest);
    return 1;
  }

  while((t=fread(buffer,1,8192,fin))!=0)
  { fwrite(buffer,1,t,fout); }

  fclose(fin);
  fclose(fout);

  return 0;
}

/* return the directory portion of a path */
void dirname_kohn(char *s)
{
int l;

  l=strlen(s)-1;

  while(l>=0 && (s[l]!='\\' && s[l]!='/')) l--;

  if (l>=0)
  {
    s[l+1]=0;
    /* strcat(s,"/"); */
  }
    else
  { s[0]=0; }
}



