/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.test;

import java.io.File;
import junit.framework.AssertionFailedError;
import org.hyperic.sigar.ProcExe;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.test.SigarTestCase;

public class TestProcExe
extends SigarTestCase {
    public TestProcExe(String name) {
        super(name);
    }

    private void printExe(Sigar sigar, long pid) throws SigarException {
        this.traceln("\npid=" + pid);
        try {
            ProcExe exe = sigar.getProcExe(pid);
            String cwd = exe.getCwd();
            this.traceln("cwd='" + cwd + "'");
            this.traceln("exe='" + exe.getName() + "'");
        }
        catch (SigarNotImplementedException e) {
            // empty catch block
        }
    }

    public void testCreate() throws Exception {
        Sigar sigar = this.getSigar();
        try {
            sigar.getProcExe(this.getInvalidPid());
        }
        catch (SigarException e) {
            // empty catch block
        }
        try {
            ProcExe exe = sigar.getProcExe(sigar.getPid());
            File exeFile = new File(exe.getName());
            String cwd = exe.getCwd();
            this.traceln("cwd='" + cwd + "'");
            if (cwd.length() > 0) {
                TestProcExe.assertTrue((boolean)new File(cwd).isDirectory());
            }
            this.traceln("exe='" + exe.getName() + "'");
            if (exe.getName().length() > 0) {
                TestProcExe.assertTrue((boolean)exeFile.exists());
                TestProcExe.assertTrue((boolean)exeFile.getName().startsWith("java"));
            }
        }
        catch (SigarNotImplementedException e) {
            // empty catch block
        }
        long[] pids = sigar.getProcList();
        for (int i = 0; i < pids.length; ++i) {
            try {
                this.printExe(sigar, pids[i]);
                continue;
            }
            catch (SigarException e) {
                continue;
            }
            catch (AssertionFailedError e) {
                // empty catch block
            }
        }
    }
}

