/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.utils.UUIDSerializer;

public class AnticompactionRequest
extends RepairMessage {
    public static RepairMessage.MessageSerializer serializer = new AnticompactionRequestSerializer();
    public final UUID parentRepairSession;
    public final Collection<Range<Token>> successfulRanges;

    public AnticompactionRequest(UUID parentRepairSession, Collection<Range<Token>> ranges) {
        super(RepairMessage.Type.ANTICOMPACTION_REQUEST, null);
        this.parentRepairSession = parentRepairSession;
        this.successfulRanges = ranges;
    }

    public String toString() {
        return "AnticompactionRequest{parentRepairSession=" + this.parentRepairSession + "} " + super.toString();
    }

    public static class AnticompactionRequestSerializer
    implements RepairMessage.MessageSerializer<AnticompactionRequest> {
        @Override
        public void serialize(AnticompactionRequest message, DataOutputPlus out, int version) throws IOException {
            UUIDSerializer.serializer.serialize(message.parentRepairSession, out, version);
            out.writeInt(message.successfulRanges.size());
            for (Range<Token> r : message.successfulRanges) {
                MessagingService.validatePartitioner(r);
                Range.tokenSerializer.serialize(r, out, version);
            }
        }

        @Override
        public AnticompactionRequest deserialize(DataInput in, int version) throws IOException {
            UUID parentRepairSession = UUIDSerializer.serializer.deserialize(in, version);
            int rangeCount = in.readInt();
            ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>(rangeCount);
            for (int i = 0; i < rangeCount; ++i) {
                ranges.add((Range)Range.tokenSerializer.deserialize(in, MessagingService.globalPartitioner(), version));
            }
            return new AnticompactionRequest(parentRepairSession, ranges);
        }

        @Override
        public long serializedSize(AnticompactionRequest message, int version) {
            long size = UUIDSerializer.serializer.serializedSize(message.parentRepairSession, version);
            for (Range<Token> r : message.successfulRanges) {
                size += Range.tokenSerializer.serializedSize(r, version);
            }
            return size;
        }
    }
}

