/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.resolver;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.DefaultArtifact;
import fr.jayasoft.ivy.DefaultModuleDescriptor;
import fr.jayasoft.ivy.DefaultModuleRevision;
import fr.jayasoft.ivy.DependencyDescriptor;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.IvyNode;
import fr.jayasoft.ivy.LatestStrategy;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.ResolveData;
import fr.jayasoft.ivy.ResolvedModuleRevision;
import fr.jayasoft.ivy.ResolvedURL;
import fr.jayasoft.ivy.Status;
import fr.jayasoft.ivy.parser.ModuleDescriptorParserRegistry;
import fr.jayasoft.ivy.report.ArtifactDownloadReport;
import fr.jayasoft.ivy.report.DownloadReport;
import fr.jayasoft.ivy.report.DownloadStatus;
import fr.jayasoft.ivy.repository.url.URLResource;
import fr.jayasoft.ivy.resolver.AbstractResolver;
import fr.jayasoft.ivy.resolver.ModuleEntry;
import fr.jayasoft.ivy.resolver.OrganisationEntry;
import fr.jayasoft.ivy.resolver.ResolverHelper;
import fr.jayasoft.ivy.resolver.RevisionEntry;
import fr.jayasoft.ivy.resolver.URLLister;
import fr.jayasoft.ivy.util.CopyProgressEvent;
import fr.jayasoft.ivy.util.CopyProgressListener;
import fr.jayasoft.ivy.util.FileUtil;
import fr.jayasoft.ivy.util.IvyPattern;
import fr.jayasoft.ivy.util.IvyPatternHelper;
import fr.jayasoft.ivy.util.Message;
import fr.jayasoft.ivy.xml.XmlModuleDescriptorUpdater;
import fr.jayasoft.ivy.xml.XmlModuleDescriptorWriter;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public abstract class AbstractURLResolver
extends AbstractResolver {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    protected String _workspaceName;
    private boolean _envDependent = true;
    private LatestStrategy _latestStrategy;
    private String _latestStrategyName;
    private List _ivyattempts = new ArrayList();
    private List _ivyPatterns = new ArrayList();
    private List _artifactPatterns = new ArrayList();

    public AbstractURLResolver() {
        this._workspaceName = Ivy.getLocalHostName();
    }

    public String getWorkspaceName() {
        return this._workspaceName;
    }

    public void setWorkspaceName(String workspaceName) {
        this._workspaceName = workspaceName;
    }

    public boolean isEnvDependent() {
        return this._envDependent;
    }

    public void setEnvDependent(boolean envDependent) {
        this._envDependent = envDependent;
    }

    public LatestStrategy getLatestStrategy() {
        if (this._latestStrategy == null) {
            if (this._latestStrategyName != null) {
                this._latestStrategy = this.getIvy().getLatestStrategy(this._latestStrategyName);
                if (this._latestStrategy == null) {
                    Message.error("unknown latest strategy: " + this._latestStrategyName);
                    this._latestStrategy = this.getIvy().getDefaultLatestStrategy();
                }
            } else {
                this._latestStrategy = this.getIvy().getDefaultLatestStrategy();
                Message.debug(this.getName() + ": no latest strategy defined: using default");
            }
        }
        return this._latestStrategy;
    }

    public void setLatestStrategy(LatestStrategy latestStrategy) {
        this._latestStrategy = latestStrategy;
    }

    public void setLatest(String strategyName) {
        this._latestStrategyName = strategyName;
    }

    /*
     * WARNING - void declaration
     */
    public ResolvedModuleRevision getDependency(DependencyDescriptor dd, ResolveData data) throws ParseException {
        void var8_8;
        ModuleRevisionId resolvedMrid;
        ModuleDescriptor md;
        this._ivyattempts.clear();
        boolean downloaded = false;
        ModuleRevisionId mrid = dd.getDependencyRevisionId();
        int index = mrid.getRevision().indexOf("@");
        if (index != -1 && !mrid.getRevision().substring(index + 1).equals(this._workspaceName)) {
            Message.verbose("\t" + this.getName() + ": unhandled revision => " + mrid.getRevision());
            return null;
        }
        if (!mrid.isExactRevision() && !this.acceptLatest()) {
            Message.error("latest revisions not handled by " + this.getClass().getName() + ". impossible to resolve " + mrid);
            return null;
        }
        ResolvedURL ivyURL = this.getIvyURL(mrid, data.getDate());
        URL cachedIvyURL = null;
        if (ivyURL == null) {
            md = DefaultModuleDescriptor.newDefaultInstance(mrid, dd.getAllDependencyArtifactsIncludes());
            ResolvedURL artifactURL = this.findFirstArtifact(md, mrid, data.getDate());
            if (artifactURL == null) {
                Message.verbose("\t" + this.getName() + ": no ivy file nor artifact found for " + mrid);
                this.logIvyNotFound(mrid);
                return null;
            }
            Message.verbose("\t" + this.getName() + ": no ivy file found for " + mrid + ": using default data");
            this.logIvyNotFound(mrid);
            if (!mrid.isExactRevision()) {
                md.setResolvedModuleRevisionId(new ModuleRevisionId(mrid.getModuleId(), artifactURL.getRevision()));
            }
        } else {
            Message.verbose("\t" + this.getName() + ": found ivy file for " + mrid);
            Message.verbose("\t\t=> " + ivyURL);
            if (!mrid.isExactRevision()) {
                resolvedMrid = new ModuleRevisionId(mrid.getModuleId(), ivyURL.getRevision());
                IvyNode node = data.getNode(resolvedMrid);
                if (node != null) {
                    Message.verbose("\t" + this.getName() + ": revision already resolved: " + resolvedMrid);
                    return node.getModuleRevision();
                }
                ResolvedModuleRevision rmr = data.getIvy().findModuleInCache(resolvedMrid, data.getCache(), this.doValidate(data));
                if (rmr != null) {
                    Message.verbose("\t" + this.getName() + ": revision in cache: " + resolvedMrid);
                    return rmr;
                }
            }
            cachedIvyURL = ivyURL.getURL();
            try {
                File ivyTempFile = File.createTempFile("ivy", "xml");
                ivyTempFile.deleteOnExit();
                Message.debug("\t" + this.getName() + ": downloading " + ivyURL.getURL());
                FileUtil.copy(ivyURL.getURL(), ivyTempFile, null);
                downloaded = true;
                try {
                    cachedIvyURL = ivyTempFile.toURL();
                }
                catch (MalformedURLException ex) {
                    Message.warn("malformed url exception for temp file: " + ivyTempFile + ": " + ex.getMessage());
                }
            }
            catch (IOException ex) {
                Message.warn("problem while downloading ivy file: " + ivyURL + ": " + ex.getMessage());
            }
            try {
                md = ModuleDescriptorParserRegistry.getInstance().parseDescriptor(data.getIvy(), cachedIvyURL, new URLResource(ivyURL.getURL()), this.doValidate(data));
                Message.debug("\t" + this.getName() + ": parsed downloaded ivy file for " + mrid + " parsed=" + md.getModuleRevisionId());
            }
            catch (IOException ex) {
                Message.warn("io problem while parsing ivy file: " + ivyURL + ": " + ex.getMessage());
                return null;
            }
        }
        if (mrid.getRevision().startsWith("latest.")) {
            String askedStatus = mrid.getRevision().substring("latest.".length());
            if (Status.getPriority(askedStatus) < Status.getPriority(var8_8.getStatus())) {
                Message.info("\t" + this.getName() + ": unacceptable status => was=" + var8_8.getStatus() + " required=" + askedStatus);
                return null;
            }
        } else if (!mrid.acceptRevision(var8_8.getModuleRevisionId().getRevision())) {
            Message.info("\t" + this.getName() + ": unacceptable revision => was=" + var8_8.getModuleRevisionId().getRevision() + " required=" + mrid.getRevision());
            return null;
        }
        if (!(resolvedMrid = mrid).isExactRevision()) {
            resolvedMrid = var8_8.getResolvedModuleRevisionId();
            if (resolvedMrid.getRevision() == null || resolvedMrid.getRevision().length() == 0) {
                resolvedMrid = ivyURL.getRevision() == null || ivyURL.getRevision().length() == 0 ? new ModuleRevisionId(resolvedMrid.getModuleId(), (this._envDependent ? "##" : "") + DATE_FORMAT.format(data.getDate()) + "@" + this._workspaceName) : new ModuleRevisionId(resolvedMrid.getModuleId(), ivyURL.getRevision());
            }
            Message.verbose("\t\t[" + resolvedMrid.getRevision() + "] " + mrid.getModuleId());
        }
        var8_8.setResolvedModuleRevisionId(resolvedMrid);
        if (data.getDate() != null) {
            long pubDate = this.getPublicationDate((ModuleDescriptor)var8_8, resolvedMrid, data.getDate());
            if (pubDate > data.getDate().getTime()) {
                Message.info("\t" + this.getName() + ": unacceptable publication date => was=" + new Date(pubDate) + " required=" + data.getDate());
                return null;
            }
            if (pubDate == -1L) {
                Message.info("\t" + this.getName() + ": impossible to guess publication date: artifact missing for " + mrid);
                return null;
            }
            var8_8.setResolvedPublicationDate(new Date(pubDate));
        }
        try {
            if (ivyURL == null) {
                XmlModuleDescriptorWriter.write((ModuleDescriptor)var8_8, data.getIvy().getIvyFileInCache(data.getCache(), var8_8.getResolvedModuleRevisionId()));
            } else {
                XmlModuleDescriptorUpdater.update(cachedIvyURL != null ? cachedIvyURL : ivyURL.getURL(), data.getIvy().getIvyFileInCache(data.getCache(), var8_8.getResolvedModuleRevisionId()), Collections.EMPTY_MAP, var8_8.getStatus(), var8_8.getResolvedModuleRevisionId().getRevision(), var8_8.getResolvedPublicationDate());
            }
        }
        catch (Exception e) {
            Message.warn("impossible to copy ivy file to cache : " + ivyURL.getURL());
        }
        return new DefaultModuleRevision(this, (ModuleDescriptor)var8_8, true, downloaded);
    }

    public void reportFailure() {
        ListIterator iter = this._ivyattempts.listIterator();
        while (iter.hasNext()) {
            String m = (String)iter.next();
            Message.warn("\t\t" + this.getName() + ": tried " + m);
        }
    }

    protected boolean acceptLatest() {
        return true;
    }

    public DownloadReport download(Artifact[] artifacts, Ivy ivy, File cache) {
        DownloadReport dr = new DownloadReport();
        for (int i = 0; i < artifacts.length; ++i) {
            final ArtifactDownloadReport adr = new ArtifactDownloadReport(artifacts[i]);
            dr.addArtifactReport(adr);
            File archiveFile = ivy.getArchiveFileInCache(cache, artifacts[i]);
            if (archiveFile.exists()) {
                Message.verbose("\t[NOT REQUIRED] " + artifacts[i]);
                adr.setDownloadStatus(DownloadStatus.NO);
                adr.setSize(archiveFile.length());
                continue;
            }
            ResolvedURL artifactURL = this.getArtifactURL(artifacts[i]);
            if (artifactURL != null) {
                long start = System.currentTimeMillis();
                try {
                    Message.info("downloading " + artifactURL + " ...");
                    FileUtil.copy(artifactURL.getURL(), archiveFile, new CopyProgressListener(){

                        public void start(CopyProgressEvent evt) {
                        }

                        public void progress(CopyProgressEvent evt) {
                            Message.progress();
                        }

                        public void end(CopyProgressEvent evt) {
                            Message.endProgress(" (" + evt.getTotalReadBytes() / 1024L + "kB)");
                            adr.setSize(evt.getTotalReadBytes());
                        }
                    });
                    Message.info("\t[SUCCESSFUL ] " + artifacts[i] + " (" + (System.currentTimeMillis() - start) + "ms)");
                    adr.setDownloadStatus(DownloadStatus.SUCCESSFUL);
                }
                catch (Exception ex) {
                    Message.warn("\t[FAILED     ] " + artifacts[i] + " (" + (System.currentTimeMillis() - start) + "ms)");
                    adr.setDownloadStatus(DownloadStatus.FAILED);
                }
                continue;
            }
            Message.warn("\t[NOT FOUND  ] " + artifacts[i]);
            this.logNotFound(artifacts[i]);
            adr.setDownloadStatus(DownloadStatus.FAILED);
        }
        return dr;
    }

    protected long getPublicationDate(ModuleDescriptor md, ModuleRevisionId mrid, Date date) {
        if (md.getPublicationDate() != null) {
            return md.getPublicationDate().getTime();
        }
        ResolvedURL artifactURL = this.findFirstArtifact(md, mrid, date);
        if (artifactURL != null) {
            try {
                return artifactURL.getURL().openConnection().getLastModified();
            }
            catch (IOException e) {
                return 0L;
            }
        }
        return -1L;
    }

    public String toString() {
        return this.getName();
    }

    public void addIvyPattern(String pattern) {
        this._ivyPatterns.add(pattern);
    }

    public void addArtifactPattern(String pattern) {
        this._artifactPatterns.add(pattern);
    }

    public List getIvyPatterns() {
        return Collections.unmodifiableList(this._ivyPatterns);
    }

    public List getArtifactPatterns() {
        return Collections.unmodifiableList(this._artifactPatterns);
    }

    protected void setIvyPatterns(List ivyPatterns) {
        this._ivyPatterns = ivyPatterns;
    }

    protected void setArtifactPatterns(List artifactPatterns) {
        this._artifactPatterns = artifactPatterns;
    }

    public void addConfiguredIvy(IvyPattern p) {
        this._ivyPatterns.add(p.getPattern());
    }

    public void addConfiguredArtifact(IvyPattern p) {
        this._artifactPatterns.add(p.getPattern());
    }

    protected ResolvedURL getIvyURL(ModuleRevisionId moduleRevision, Date date) {
        return this.findURLUsingPatterns(moduleRevision, this._ivyPatterns, "ivy", "ivy", "xml", date);
    }

    protected ResolvedURL getArtifactURL(Artifact artifact) {
        return this.findURLUsingPatterns(artifact.getModuleRevisionId(), this._artifactPatterns, artifact.getName(), artifact.getType(), artifact.getExt(), null);
    }

    private ResolvedURL findURLUsingPatterns(ModuleRevisionId moduleRevision, List patternList, String artifact, String type, String ext, Date date) {
        ResolvedURL rurl = null;
        Iterator iter = patternList.iterator();
        while (iter.hasNext() && rurl == null) {
            String pattern = (String)iter.next();
            rurl = this.findURLUsingPattern(moduleRevision, pattern, artifact, type, ext, date);
        }
        return rurl;
    }

    protected ResolvedURL findFirstArtifact(ModuleDescriptor md, ModuleRevisionId mrid, Date date) {
        ResolvedURL ret = null;
        String[] conf = md.getConfigurationsNames();
        for (int i = 0; i < conf.length; ++i) {
            Artifact[] artifacts = md.getArtifacts(conf[i]);
            for (int j = 0; j < artifacts.length; ++j) {
                ret = this.findURLUsingPatterns(mrid, this._artifactPatterns, artifacts[j].getName(), artifacts[j].getType(), artifacts[j].getExt(), date);
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }

    protected void logIvyNotFound(ModuleRevisionId mrid) {
        DefaultArtifact artifact = new DefaultArtifact(mrid, new Date(), "ivy", "ivy", "xml");
        String revisionToken = mrid.getRevision().startsWith("latest.") ? "[any " + mrid.getRevision().substring("latest.".length()) + "]" : "[" + mrid.getRevision() + "]";
        DefaultArtifact latestArtifact = new DefaultArtifact(new ModuleRevisionId(mrid.getModuleId(), revisionToken), new Date(), "ivy", "ivy", "xml");
        Iterator iter = this._ivyPatterns.iterator();
        while (iter.hasNext()) {
            String pattern = (String)iter.next();
            String resolvedFileName = IvyPatternHelper.substitute(pattern, artifact);
            Message.verbose("\t\ttried " + resolvedFileName);
            this._ivyattempts.add(resolvedFileName);
            if (mrid.isExactRevision()) continue;
            resolvedFileName = IvyPatternHelper.substitute(pattern, latestArtifact);
            Message.verbose("\t\ttried " + resolvedFileName);
            this._ivyattempts.add(resolvedFileName);
        }
    }

    protected void logNotFound(Artifact artifact) {
        Iterator iter = this._artifactPatterns.iterator();
        while (iter.hasNext()) {
            String pattern = (String)iter.next();
            String resolvedFileName = IvyPatternHelper.substitute(pattern, artifact);
            Message.warn("\t\ttried " + resolvedFileName);
        }
    }

    protected abstract ResolvedURL findURLUsingPattern(ModuleRevisionId var1, String var2, String var3, String var4, String var5, Date var6);

    public OrganisationEntry[] listOrganisations() {
        Collection names = this.findNames(Collections.EMPTY_MAP, "organisation");
        OrganisationEntry[] ret = new OrganisationEntry[names.size()];
        int i = 0;
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String org = (String)iter.next();
            ret[i] = new OrganisationEntry(this, org);
            ++i;
        }
        return ret;
    }

    public ModuleEntry[] listModules(OrganisationEntry org) {
        HashMap<String, String> tokenValues = new HashMap<String, String>();
        tokenValues.put("organisation", org.getOrganisation());
        Collection names = this.findNames(tokenValues, "module");
        ModuleEntry[] ret = new ModuleEntry[names.size()];
        int i = 0;
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            ret[i] = new ModuleEntry(org, name);
            ++i;
        }
        return ret;
    }

    public RevisionEntry[] listRevisions(ModuleEntry mod) {
        HashMap<String, String> tokenValues = new HashMap<String, String>();
        tokenValues.put("organisation", mod.getOrganisation());
        tokenValues.put("module", mod.getModule());
        Collection names = this.findNames(tokenValues, "revision");
        RevisionEntry[] ret = new RevisionEntry[names.size()];
        int i = 0;
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            ret[i] = new RevisionEntry(mod, name);
            ++i;
        }
        return ret;
    }

    protected Collection findNames(Map tokenValues, String token) {
        HashSet names = new HashSet();
        names.addAll(this.findIvyNames(tokenValues, token));
        names.addAll(this.findArtifactNames(tokenValues, token));
        return names;
    }

    protected Collection findIvyNames(Map tokenValues, String token) {
        HashSet names = new HashSet();
        tokenValues = new HashMap<String, String>(tokenValues);
        tokenValues.put("artifact", "ivy");
        tokenValues.put("type", "ivy");
        tokenValues.put("ext", "xml");
        this.findTokenValues(names, this.getIvyPatterns(), tokenValues, token);
        this.getIvy().filterIgnore(names);
        return names;
    }

    protected Collection findArtifactNames(Map tokenValues, String token) {
        HashSet names = new HashSet();
        tokenValues = new HashMap(tokenValues);
        tokenValues.put("artifact", tokenValues.get("module"));
        tokenValues.put("type", "jar");
        tokenValues.put("ext", "jar");
        this.findTokenValues(names, this.getArtifactPatterns(), tokenValues, token);
        this.getIvy().filterIgnore(names);
        return names;
    }

    protected void findTokenValues(Collection names, List patterns, Map tokenValues, String token) {
    }

    protected void findTokenValues(Collection names, List listers, String prefix, List patterns, Map tokenValues, String token) {
        Iterator iter = patterns.iterator();
        while (iter.hasNext()) {
            String pattern = (String)iter.next();
            String partiallyResolvedPattern = IvyPatternHelper.substituteTokens(pattern, tokenValues);
            Iterator iterator = listers.iterator();
            while (iterator.hasNext()) {
                URLLister lister = (URLLister)iterator.next();
                String[] values = ResolverHelper.listTokenValues(lister, prefix + partiallyResolvedPattern, token);
                if (values == null) continue;
                names.addAll(Arrays.asList(values));
            }
        }
    }
}

