/*
 * Copyright © 2009-2020 Frictional Games
 *
 * This file is part of Amnesia: The Dark Descent.
 *
 * Amnesia: The Dark Descent is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * Amnesia: The Dark Descent is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Amnesia: The Dark Descent.  If not, see <https://www.gnu.org/licenses/>.
 */

// generated by Fast Light User Interface Designer (fluid) version 1.0300

#include "launcher.h"

using namespace hpl;

extern tString gsGameLanguageFolder;
extern tString gsDefaultGameLanguage;
#include "Main.h"
#include "LauncherHelper.h"



void cUserInterface::cb_AddResolutionWindow_i(Fl_Window* o, void*) {
  cLauncherHelper::ReselectResolution(mvVModes, mpConfigFile, CBResolution);
o->hide();
}
void cUserInterface::cb_AddResolutionWindow(Fl_Window* o, void* v) {
  ((cUserInterface*)(o->user_data()))->cb_AddResolutionWindow_i(o,v);
}

void cUserInterface::cb_BAddCustomResolution_i(Fl_Return_Button*, void*) {
  if (cLauncherHelper::AddCustomResolution(mvVModes, mpConfigFile, CBResolution, this, ICustomWidth->value(), ICustomHeight->value())) {
	AddResolutionWindow->hide();
};
}
void cUserInterface::cb_BAddCustomResolution(Fl_Return_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->user_data()))->cb_BAddCustomResolution_i(o,v);
}

void cUserInterface::cb_Cancel_i(Fl_Button*, void*) {
  AddResolutionWindow->do_callback();
}
void cUserInterface::cb_Cancel(Fl_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->user_data()))->cb_Cancel_i(o,v);
}

#include <FL/Fl_JPEG_Image.H>
static unsigned char idata_launcher_bg[] =
{255,216,255,224,0,16,74,70,73,70,0,1,2,1,0,98,0,98,0,0,255,225,18,202,69,
120,105,102,0,0,77,77,0,42,0,0,0,8,0,7,1,18,0,3,0,0,0,1,0,1,0,0,1,26,0,5,0,0,0,
1,0,0,0,98,1,27,0,5,0,0,0,1,0,0,0,106,1,40,0,3,0,0,0,1,0,2,0,0,1,49,0,2,0,0,0,
27,0,0,0,114,1,50,0,2,0,0,0,20,0,0,0,141,135,105,0,4,0,0,0,1,0,0,0,164,0,0,0,
208,0,0,0,98,0,0,0,1,0,0,0,98,0,0,0,1,65,100,111,98,101,32,80,104,111,116,111,
115,104,111,112,32,67,83,32,87,105,110,100,111,119,115,0,50,48,49,48,58,48,56,
58,49,57,32,48,49,58,51,53,58,50,54,0,0,0,0,0,3,160,1,0,3,0,0,0,1,255,255,0,0,
160,2,0,4,0,0,0,1,0,0,2,182,160,3,0,4,0,0,0,1,0,0,2,42,0,0,0,0,0,0,0,6,1,3,0,3,
0,0,0,1,0,6,0,0,1,26,0,5,0,0,0,1,0,0,1,30,1,27,0,5,0,0,0,1,0,0,1,38,1,40,0,3,
0,0,0,1,0,2,0,0,2,1,0,4,0,0,0,1,0,0,1,46,2,2,0,4,0,0,0,1,0,0,17,148,0,0,0,0,0,
0,0,72,0,0,0,1,0,0,0,72,0,0,0,1,255,216,255,224,0,16,74,70,73,70,0,1,2,1,0,72,
0,72,0,0,255,237,0,12,65,100,111,98,101,95,67,77,0,2,255,238,0,14,65,100,111,
98,101,0,100,128,0,0,0,1,255,219,0,132,0,12,8,8,8,9,8,12,9,9,12,17,11,10,11,17,
21,15,12,12,15,21,24,19,19,21,19,19,24,17,12,12,12,12,12,12,17,12,12,12,12,12,
12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,1,13,11,
11,13,14,13,16,14,14,16,20,14,14,14,20,20,14,14,14,14,20,17,12,12,12,12,12,17,
17,12,12,12,12,12,12,17,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
12,12,12,12,12,12,12,12,12,12,255,192,0,17,8,0,128,0,160,3,1,34,0,2,17,1,3,17,
1,255,221,0,4,0,10,255,196,1,63,0,0,1,5,1,1,1,1,1,1,0,0,0,0,0,0,0,3,0,1,2,4,5,
6,7,8,9,10,11,1,0,1,5,1,1,1,1,1,1,0,0,0,0,0,0,0,1,0,2,3,4,5,6,7,8,9,10,11,16,
0,1,4,1,3,2,4,2,5,7,6,8,5,3,12,51,1,0,2,17,3,4,33,18,49,5,65,81,97,19,34,113,
129,50,6,20,145,161,177,66,35,36,21,82,193,98,51,52,114,130,209,67,7,37,146,83,
240,225,241,99,115,53,22,162,178,131,38,68,147,84,100,69,194,163,116,54,23,210,
85,226,101,242,179,132,195,211,117,227,243,70,39,148,164,133,180,149,196,212,
228,244,165,181,197,213,229,245,86,102,118,134,150,166,182,198,214,230,246,55,
71,87,103,119,135,151,167,183,199,215,231,247,17,0,2,2,1,2,4,4,3,4,5,6,7,7,6,5,
53,1,0,2,17,3,33,49,18,4,65,81,97,113,34,19,5,50,129,145,20,161,177,66,35,193,
82,209,240,51,36,98,225,114,130,146,67,83,21,99,115,52,241,37,6,22,162,178,131,
7,38,53,194,210,68,147,84,163,23,100,69,85,54,116,101,226,242,179,132,195,211,
117,227,243,70,148,164,133,180,149,196,212,228,244,165,181,197,213,229,245,86,
102,118,134,150,166,182,198,214,230,246,39,55,71,87,103,119,135,151,167,183,199,
255,218,0,12,3,1,0,2,17,3,17,0,63,0,243,54,144,230,109,60,246,67,112,135,120,38,
107,128,58,240,156,153,215,186,74,91,153,76,36,20,224,246,41,112,138,153,71,112,
183,62,168,253,85,234,31,89,250,147,176,241,95,246,122,169,110,252,140,162,210,
230,214,211,237,96,218,54,181,215,91,254,10,175,81,159,225,63,209,172,140,12,
107,51,50,234,197,99,235,173,214,185,173,15,185,193,140,18,118,251,220,126,63,
154,189,219,234,222,39,79,250,149,210,112,186,54,126,85,67,39,35,213,200,182,
242,27,85,114,210,207,89,206,185,254,158,246,212,235,241,241,235,125,239,251,69,
190,207,230,232,253,30,58,181,83,230,223,94,14,47,79,201,187,234,255,0,79,233,
184,248,56,184,121,53,27,114,55,250,153,23,217,232,238,166,205,246,109,123,106,
251,59,247,100,87,87,169,233,100,89,250,91,63,90,253,38,54,1,107,108,49,19,18,
62,82,23,69,254,55,237,205,103,214,170,170,186,239,83,27,236,173,183,22,145,
163,107,15,115,235,191,79,244,150,221,71,168,251,63,115,211,103,248,53,201,227,
89,91,155,163,246,88,223,222,208,25,248,163,21,178,109,122,143,109,196,113,58,
133,165,77,182,186,179,184,79,156,199,117,156,225,188,206,155,227,88,241,133,99,
26,231,26,139,218,240,246,183,82,65,16,33,16,180,164,125,206,100,146,72,141,99,
141,1,255,0,190,160,89,127,168,216,145,45,48,59,133,51,125,118,176,27,61,162,39,
127,2,62,152,250,95,154,230,170,249,216,89,29,58,188,75,50,61,140,234,21,125,
167,21,166,67,189,45,219,42,177,242,3,63,79,244,235,175,119,243,127,215,74,213,
72,141,94,187,168,165,214,178,159,81,225,190,173,164,181,140,39,243,239,177,
162,205,149,235,244,246,170,217,20,230,215,75,46,202,199,182,186,237,96,117,86,
189,164,7,53,210,214,61,182,70,215,53,223,152,229,23,220,225,51,160,253,223,51,
162,222,192,250,231,215,217,245,99,63,163,88,43,205,233,173,199,20,180,222,230,
250,148,53,238,20,215,232,111,62,166,67,25,63,163,175,101,143,198,253,21,158,
165,53,82,129,43,128,238,243,64,135,106,12,31,226,160,227,172,56,144,71,142,170,
59,128,4,143,5,127,171,116,250,240,46,170,186,111,57,85,219,83,109,109,198,167,
82,29,62,215,122,12,187,244,207,199,222,54,85,125,181,208,251,191,208,33,105,
166,129,29,252,83,183,203,148,198,59,104,124,19,182,73,73,43,182,55,5,102,171,3,
65,7,147,192,242,213,86,46,215,79,189,48,62,63,52,144,255,0,255,208,242,206,71,
193,41,241,251,210,243,73,195,184,225,37,40,248,130,156,74,97,225,216,167,18,18,
83,219,125,81,250,183,208,109,205,163,52,245,11,186,174,70,19,153,144,254,155,
211,241,47,113,47,105,223,93,111,204,200,174,156,102,87,189,190,239,83,210,101,
159,153,114,244,78,191,245,103,168,253,99,234,253,23,169,122,140,194,196,192,38,
203,241,45,110,235,200,179,107,174,169,254,155,237,197,253,35,106,102,55,242,63,
77,111,173,127,178,133,195,253,89,234,24,191,82,254,170,15,172,158,171,178,186,
159,90,109,148,224,224,187,115,105,103,163,97,170,235,175,216,253,182,236,217,
85,159,224,237,255,0,180,213,108,245,44,185,113,125,75,172,103,245,62,167,119,
85,201,180,183,51,33,192,190,202,198,193,160,109,109,107,91,92,125,22,49,169,
41,244,63,241,207,140,43,175,161,185,228,190,192,203,233,178,242,61,206,13,20,
16,108,112,254,86,247,237,254,186,232,186,111,70,233,93,103,234,255,0,75,119,
84,163,24,117,220,190,150,234,113,111,123,69,206,21,134,49,141,201,219,187,109,
190,155,109,162,223,167,190,191,91,211,174,202,253,85,145,213,243,240,122,191,
248,162,126,109,33,214,62,143,73,150,122,246,156,139,170,176,100,210,47,107,239,
176,190,223,123,125,245,239,217,250,165,148,254,98,161,245,39,170,140,255,0,173,
93,28,87,112,117,125,51,162,250,5,144,233,54,50,125,106,217,79,183,244,254,246,
253,15,231,168,167,212,73,78,87,215,191,170,88,223,85,27,131,94,38,69,185,63,
106,166,223,84,219,17,186,145,86,231,87,179,110,214,191,214,254,111,252,23,250,
69,222,89,245,63,234,187,126,176,51,170,117,11,171,200,167,168,250,53,116,190,
155,183,244,0,211,77,108,105,13,97,119,218,171,244,49,191,71,234,55,236,181,127,
194,126,137,121,222,126,104,207,255,0,23,253,50,251,247,63,39,165,103,219,140,
224,233,217,107,50,107,127,80,46,178,192,24,247,63,219,232,217,233,95,234,127,
164,254,118,151,174,143,174,117,236,81,254,48,186,102,77,238,96,195,233,88,129,
205,175,232,212,44,183,26,252,170,253,55,235,252,227,157,135,93,79,255,0,139,
253,26,74,115,126,167,253,94,179,175,253,102,191,246,131,91,109,24,182,221,119,
82,0,3,91,238,22,26,233,197,245,25,250,63,210,189,190,181,159,79,214,166,175,
248,101,181,213,122,231,80,200,250,172,62,175,245,106,43,179,235,47,95,191,101,
125,61,182,151,58,150,216,230,91,69,249,85,123,190,192,218,63,71,232,99,111,250,
27,46,183,244,191,108,244,242,254,170,100,51,35,234,199,87,232,246,117,71,116,
142,165,146,246,231,187,46,219,5,88,238,15,44,99,169,117,141,244,221,141,234,
218,207,67,39,211,119,169,252,222,207,86,175,83,25,83,202,163,162,226,116,91,49,
155,153,137,251,119,166,134,221,211,242,250,19,47,182,231,61,197,254,183,237,14,
164,232,170,230,63,115,31,234,122,212,63,15,252,13,127,246,150,212,84,27,216,
191,81,250,14,83,186,167,65,175,168,12,159,173,52,49,182,80,95,85,148,83,89,97,
14,186,138,218,231,254,179,235,78,203,114,44,255,0,5,109,87,99,213,250,59,80,
126,173,50,191,171,191,83,122,246,111,87,160,176,100,222,220,38,212,219,4,228,
62,161,101,118,97,126,143,110,220,127,85,214,253,166,234,110,253,62,55,218,125,
63,230,191,73,10,113,242,190,191,227,95,146,205,173,250,203,210,106,173,213,
223,91,189,54,230,85,185,238,107,44,99,3,107,197,204,199,123,63,67,123,28,198,
88,251,63,73,250,47,210,81,91,174,102,209,157,254,47,186,111,79,102,56,196,206,
232,217,131,15,55,29,193,213,185,143,177,153,27,45,117,78,255,0,185,78,173,214,
100,111,253,35,50,125,111,209,164,166,207,213,60,110,159,208,48,186,47,82,183,4,
103,117,190,191,149,232,244,241,121,45,171,30,166,61,148,125,171,100,61,206,181,
246,61,143,101,159,232,191,154,125,95,246,163,15,252,98,12,129,245,207,170,125,
162,214,92,243,99,96,215,48,214,108,111,217,234,116,134,254,150,170,61,54,219,
255,0,8,189,2,238,145,245,71,164,125,98,193,207,235,29,98,157,248,21,226,225,
116,220,87,57,174,21,154,25,101,22,125,170,162,203,125,26,189,95,211,179,33,238,
171,236,185,62,255,0,93,112,63,227,23,16,226,253,116,234,117,134,128,44,177,183,
52,134,150,131,234,177,150,187,250,222,242,237,239,255,0,72,144,83,205,41,55,
191,156,166,38,12,248,164,39,178,42,88,242,7,130,67,84,157,202,73,41,255,209,
242,212,180,248,20,210,156,65,242,73,74,219,204,169,118,61,207,136,77,181,218,
15,45,10,125,174,19,161,9,41,119,62,215,177,173,46,37,172,144,209,58,0,78,227,
183,247,119,57,67,69,51,226,117,213,90,170,172,103,208,73,180,253,162,72,109,2,
178,67,155,3,107,189,125,222,199,57,206,119,210,173,37,58,127,87,250,165,117,
116,206,177,209,114,28,43,167,171,99,131,83,255,0,119,35,24,253,163,21,143,123,
158,198,87,86,87,191,29,238,219,252,239,217,254,133,126,162,23,76,203,101,21,
103,86,45,52,179,55,2,218,61,96,75,118,185,166,188,214,85,237,255,0,185,127,101,
251,22,207,251,178,143,133,129,209,172,197,181,249,153,14,198,200,101,165,130,
108,171,105,97,167,39,37,182,140,103,82,109,218,219,104,199,197,246,217,250,75,
175,255,0,7,250,54,39,234,29,63,166,214,218,7,76,202,57,46,123,156,108,113,178,
167,6,195,172,244,255,0,67,72,101,204,223,93,117,110,221,236,175,212,65,77,106,
29,152,41,191,26,135,109,198,202,104,23,84,230,181,192,237,141,143,107,94,15,
165,115,127,210,213,250,79,250,218,177,75,114,28,224,235,200,188,108,174,166,
135,141,90,202,71,167,75,63,151,233,87,250,54,255,0,35,211,87,42,193,233,6,186,
189,76,239,66,235,113,183,237,125,245,184,125,162,202,107,118,57,112,162,173,
216,52,209,212,31,233,100,85,154,255,0,232,223,165,255,0,4,172,217,87,67,109,86,
89,135,212,141,150,178,182,186,172,83,109,112,251,79,174,47,199,251,77,152,205,
117,126,143,165,141,103,175,179,208,201,254,141,141,119,235,148,223,142,224,80,
65,101,133,129,210,126,197,251,103,173,250,20,116,252,44,187,112,241,199,160,
251,44,191,42,192,50,55,245,39,212,230,62,220,12,47,110,202,170,123,61,74,105,
186,143,252,49,158,58,95,214,12,210,255,0,82,209,137,210,178,44,1,185,87,184,
116,236,11,91,39,211,186,154,108,110,35,31,83,153,250,70,87,78,37,183,108,90,29,
52,227,213,102,243,213,114,58,93,185,57,13,170,247,227,229,51,21,166,166,140,
127,74,203,113,75,77,207,125,142,201,203,165,185,78,253,14,39,163,235,91,250,58,
149,33,135,210,115,9,200,207,204,177,249,66,226,207,86,252,202,44,117,176,207,
83,26,138,172,44,189,213,55,41,222,203,51,178,125,28,60,15,87,254,213,122,86,
84,129,221,35,103,107,19,235,55,68,250,149,75,233,232,185,3,171,231,89,83,69,
222,147,118,227,125,162,14,252,140,156,191,231,179,43,171,119,167,131,137,139,
233,99,215,71,173,234,126,183,119,174,184,142,173,213,115,186,199,80,200,234,57,
207,15,201,201,32,216,230,183,107,72,96,109,117,181,172,108,55,109,117,177,141,
253,245,183,143,211,126,171,218,113,142,110,101,184,245,91,89,57,46,102,70,61,
174,165,226,255,0,179,181,158,147,24,207,89,159,103,221,127,232,235,255,0,135,
175,214,246,82,179,186,158,47,78,199,175,25,184,46,123,173,177,175,118,75,159,
125,121,12,102,203,174,197,244,246,227,211,94,219,61,58,89,149,252,229,158,173,
57,31,163,255,0,73,96,181,56,225,154,19,30,1,105,245,62,187,149,213,48,176,40,
204,30,166,71,79,109,149,12,167,123,158,250,156,230,217,69,118,216,233,185,255,
0,103,115,175,99,63,73,233,122,94,159,167,83,44,245,172,186,182,77,88,204,180,
12,107,159,148,35,87,58,191,74,29,251,173,99,159,102,228,23,50,36,190,71,114,
17,83,7,199,183,230,145,211,65,207,114,145,220,8,113,28,246,242,72,183,105,227,
113,228,120,106,146,152,193,153,78,117,16,151,39,146,79,130,114,35,158,201,41,
255,210,242,216,29,187,169,6,13,162,74,102,178,123,162,86,106,108,110,6,71,51,
38,82,83,42,232,105,32,111,131,49,7,253,146,136,230,122,14,6,194,44,111,1,194,
116,60,234,160,46,100,151,56,107,216,70,154,74,19,203,158,233,119,61,135,96,142,
136,109,182,172,91,32,234,201,152,219,168,153,253,215,34,211,211,61,225,205,189,
178,14,129,210,59,119,254,178,167,73,111,30,222,57,42,253,111,126,232,221,236,
145,1,166,127,234,146,176,162,15,70,206,55,79,205,47,19,233,134,180,180,253,38,
131,4,198,191,157,236,90,56,221,45,207,31,167,184,48,14,245,141,198,15,199,98,
206,102,83,152,247,107,160,238,117,236,183,122,94,69,47,175,115,32,196,2,223,61,
120,253,230,167,68,2,178,68,134,230,46,54,14,38,194,92,26,230,159,113,184,181,
160,184,159,162,198,255,0,228,183,174,134,158,143,210,175,173,182,185,135,21,
204,213,204,172,75,78,177,249,238,246,174,123,39,21,217,119,250,245,92,42,218,
11,125,236,222,57,240,150,171,247,11,169,233,236,168,90,205,172,107,125,91,139,
118,184,53,164,123,141,91,157,235,122,159,205,32,101,49,197,112,244,196,122,72,
61,187,170,67,31,4,76,100,78,67,243,196,138,140,124,152,100,244,46,145,37,181,
94,243,18,93,236,29,228,120,254,242,203,187,163,97,214,210,231,100,157,173,107,
128,138,137,39,157,173,250,77,111,253,37,178,204,140,23,180,85,77,196,56,9,139,
15,233,76,105,234,63,247,221,252,170,213,12,215,180,53,224,123,160,242,226,90,
32,120,167,138,32,19,68,248,44,18,47,53,147,137,133,94,140,156,139,67,189,206,
118,141,0,234,61,141,253,232,253,245,81,238,112,99,191,155,13,134,232,65,17,223,
111,181,105,103,227,11,236,251,86,9,246,145,54,210,199,105,184,123,13,149,15,
206,223,255,0,86,177,242,46,12,14,105,97,245,39,105,46,228,24,137,41,135,70,65,
170,33,123,164,130,221,73,58,180,141,52,67,53,210,226,232,123,133,158,15,239,
254,106,103,90,211,168,26,157,61,188,232,62,146,139,5,175,7,112,4,29,72,136,152,
40,46,93,204,126,205,208,12,114,65,230,80,221,188,52,75,64,16,57,29,188,84,222,
251,76,147,175,104,143,5,2,227,160,63,71,191,26,160,82,17,153,215,143,56,72,146,
1,5,49,62,26,3,224,150,211,224,146,159,255,211,242,222,10,82,15,41,146,141,18,
83,32,99,131,30,50,165,168,38,79,207,178,140,13,57,249,167,13,147,2,15,193,37,
47,238,14,152,131,228,172,87,117,187,140,64,152,17,193,229,9,161,205,26,112,
121,7,80,143,246,162,209,250,54,195,251,136,28,15,206,246,253,36,148,218,199,
166,251,67,156,6,209,36,251,184,145,167,117,209,98,217,70,53,6,166,56,88,231,16,
235,44,60,204,123,90,223,206,107,91,43,154,199,201,14,5,175,121,46,153,14,159,
18,173,11,73,13,116,131,184,136,35,157,19,129,165,132,91,208,183,34,242,97,174,
45,147,166,216,87,92,218,110,173,166,223,115,199,46,38,127,7,123,87,51,94,101,
149,25,15,218,211,160,147,58,243,244,66,210,163,170,54,198,24,30,238,117,239,31,
157,252,164,183,187,42,59,10,27,117,116,92,220,102,99,138,95,91,108,13,0,2,117,
49,51,201,220,168,92,41,107,143,181,174,110,190,199,52,24,145,249,179,238,106,
167,147,212,29,235,57,140,112,245,26,120,35,180,114,131,110,86,230,235,99,100,
198,160,157,117,254,218,90,10,29,144,1,95,47,41,149,18,216,12,49,39,183,63,71,
110,138,158,70,117,158,224,118,147,187,151,147,247,106,125,170,22,228,239,172,
178,253,174,12,4,183,190,135,128,215,126,242,163,104,165,165,219,102,100,198,
238,211,228,149,174,1,48,234,0,60,19,91,75,1,208,55,159,252,201,168,110,101,2,
93,85,174,218,238,26,125,221,255,0,178,170,204,19,50,60,116,29,210,220,98,26,
232,111,135,127,154,22,154,102,230,182,93,238,39,206,12,33,22,31,135,197,72,141,
59,159,154,129,7,192,2,130,86,136,79,169,239,41,184,236,37,52,148,148,255,0,
255,212,242,216,30,41,79,150,137,244,240,76,99,198,18,82,255,0,130,148,1,201,39,
224,160,12,113,10,68,144,117,208,248,36,165,228,158,26,126,100,240,166,25,187,
137,159,2,100,40,135,178,64,237,252,97,55,170,91,160,1,165,37,39,117,22,180,14,
224,144,76,14,18,109,238,172,252,184,37,70,188,155,132,25,132,119,185,175,27,
189,61,198,62,144,137,231,192,20,180,70,170,175,44,147,181,242,233,17,161,254,
229,111,20,220,92,44,123,182,6,184,31,116,238,118,174,27,67,127,57,83,170,198,
214,100,52,176,249,141,167,226,52,70,175,34,166,144,253,219,136,212,201,214,124,
209,20,163,109,236,195,69,132,152,135,68,135,13,72,143,250,166,170,27,237,198,
46,45,104,113,123,68,216,209,254,187,82,57,180,151,114,76,104,53,149,1,155,75,
76,182,70,154,200,7,186,38,144,1,65,246,167,17,238,36,152,231,255,0,34,132,235,
11,199,210,208,106,116,213,26,199,85,96,220,8,220,0,62,3,238,80,117,111,36,129,
4,13,36,20,18,134,125,160,112,38,126,105,18,20,220,199,128,100,113,224,80,224,
248,126,8,37,121,61,146,36,206,186,120,165,1,52,36,165,165,57,61,147,71,138,82,
37,37,63,255,213,242,201,74,124,84,101,36,148,202,66,65,196,112,162,146,74,101,
184,120,107,226,148,235,42,41,36,166,68,119,79,32,234,121,81,7,178,73,41,61,110,
116,136,119,203,113,254,42,110,177,222,237,223,136,7,255,0,34,170,202,125,230,
33,37,54,69,147,16,107,211,196,65,252,138,47,178,214,243,183,94,32,72,64,4,36,
30,71,31,114,74,72,110,127,118,180,248,136,254,229,23,88,29,244,155,247,105,10,
38,15,26,40,164,166,67,203,241,72,185,199,146,162,158,74,74,95,121,226,83,110,
74,1,238,154,18,82,242,153,36,146,83,255,214,242,164,146,73,37,41,36,146,73,74,
73,36,146,82,146,73,36,148,164,146,73,37,41,36,146,73,74,73,36,146,82,146,73,
36,148,164,146,73,37,41,36,146,73,79,255,217,255,237,23,152,80,104,111,116,111,
115,104,111,112,32,51,46,48,0,56,66,73,77,4,37,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,56,66,73,77,3,237,0,0,0,0,0,16,0,98,108,218,0,1,0,2,0,98,108,218,
0,1,0,2,56,66,73,77,4,38,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,63,128,0,0,56,66,73,
77,4,13,0,0,0,0,0,4,0,0,0,30,56,66,73,77,4,25,0,0,0,0,0,4,0,0,0,30,56,66,73,77,
3,243,0,0,0,0,0,9,0,0,0,0,0,0,0,0,1,0,56,66,73,77,4,10,0,0,0,0,0,1,0,0,56,66,
73,77,39,16,0,0,0,0,0,10,0,1,0,0,0,0,0,0,0,2,56,66,73,77,3,245,0,0,0,0,0,72,0,
47,102,102,0,1,0,108,102,102,0,6,0,0,0,0,0,1,0,47,102,102,0,1,0,161,153,154,0,
6,0,0,0,0,0,1,0,50,0,0,0,1,0,90,0,0,0,6,0,0,0,0,0,1,0,53,0,0,0,1,0,45,0,0,0,6,
0,0,0,0,0,1,56,66,73,77,3,248,0,0,0,0,0,112,0,0,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,3,232,0,0,0,0,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,3,232,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,3,232,0,0,0,0,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,3,232,0,0,56,66,73,77,4,0,0,
0,0,0,0,2,0,2,56,66,73,77,4,2,0,0,0,0,0,8,0,0,0,0,0,0,0,0,56,66,73,77,4,8,0,0,
0,0,0,16,0,0,0,1,0,0,2,64,0,0,2,64,0,0,0,0,56,66,73,77,4,30,0,0,0,0,0,4,0,0,0,
0,56,66,73,77,4,26,0,0,0,0,3,75,0,0,0,6,0,0,0,0,0,0,0,0,0,0,2,42,0,0,2,182,0,
0,0,11,0,108,0,97,0,117,0,110,0,99,0,104,0,101,0,114,0,95,0,98,0,103,0,0,0,1,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,2,182,0,0,2,42,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,
0,1,0,0,0,0,0,0,110,117,108,108,0,0,0,2,0,0,0,6,98,111,117,110,100,115,79,98,
106,99,0,0,0,1,0,0,0,0,0,0,82,99,116,49,0,0,0,4,0,0,0,0,84,111,112,32,108,111,
110,103,0,0,0,0,0,0,0,0,76,101,102,116,108,111,110,103,0,0,0,0,0,0,0,0,66,116,
111,109,108,111,110,103,0,0,2,42,0,0,0,0,82,103,104,116,108,111,110,103,0,0,2,
182,0,0,0,6,115,108,105,99,101,115,86,108,76,115,0,0,0,1,79,98,106,99,0,0,0,1,0,
0,0,0,0,5,115,108,105,99,101,0,0,0,18,0,0,0,7,115,108,105,99,101,73,68,108,
111,110,103,0,0,0,0,0,0,0,7,103,114,111,117,112,73,68,108,111,110,103,0,0,0,0,0,
0,0,6,111,114,105,103,105,110,101,110,117,109,0,0,0,12,69,83,108,105,99,101,
79,114,105,103,105,110,0,0,0,13,97,117,116,111,71,101,110,101,114,97,116,101,
100,0,0,0,0,84,121,112,101,101,110,117,109,0,0,0,10,69,83,108,105,99,101,84,121,
112,101,0,0,0,0,73,109,103,32,0,0,0,6,98,111,117,110,100,115,79,98,106,99,0,0,0,
1,0,0,0,0,0,0,82,99,116,49,0,0,0,4,0,0,0,0,84,111,112,32,108,111,110,103,0,0,
0,0,0,0,0,0,76,101,102,116,108,111,110,103,0,0,0,0,0,0,0,0,66,116,111,109,108,
111,110,103,0,0,2,42,0,0,0,0,82,103,104,116,108,111,110,103,0,0,2,182,0,0,0,3,
117,114,108,84,69,88,84,0,0,0,1,0,0,0,0,0,0,110,117,108,108,84,69,88,84,0,0,0,1,
0,0,0,0,0,0,77,115,103,101,84,69,88,84,0,0,0,1,0,0,0,0,0,6,97,108,116,84,97,
103,84,69,88,84,0,0,0,1,0,0,0,0,0,14,99,101,108,108,84,101,120,116,73,115,72,84,
77,76,98,111,111,108,1,0,0,0,8,99,101,108,108,84,101,120,116,84,69,88,84,0,0,0,
1,0,0,0,0,0,9,104,111,114,122,65,108,105,103,110,101,110,117,109,0,0,0,15,69,
83,108,105,99,101,72,111,114,122,65,108,105,103,110,0,0,0,7,100,101,102,97,117,
108,116,0,0,0,9,118,101,114,116,65,108,105,103,110,101,110,117,109,0,0,0,15,69,
83,108,105,99,101,86,101,114,116,65,108,105,103,110,0,0,0,7,100,101,102,97,117,
108,116,0,0,0,11,98,103,67,111,108,111,114,84,121,112,101,101,110,117,109,0,0,0,
17,69,83,108,105,99,101,66,71,67,111,108,111,114,84,121,112,101,0,0,0,0,78,111,
110,101,0,0,0,9,116,111,112,79,117,116,115,101,116,108,111,110,103,0,0,0,0,0,0,
0,10,108,101,102,116,79,117,116,115,101,116,108,111,110,103,0,0,0,0,0,0,0,12,
98,111,116,116,111,109,79,117,116,115,101,116,108,111,110,103,0,0,0,0,0,0,0,11,
114,105,103,104,116,79,117,116,115,101,116,108,111,110,103,0,0,0,0,0,56,66,73,
77,4,40,0,0,0,0,0,12,0,0,0,1,63,240,0,0,0,0,0,0,56,66,73,77,4,17,0,0,0,0,0,1,1,
0,56,66,73,77,4,20,0,0,0,0,0,4,0,0,0,4,56,66,73,77,4,12,0,0,0,0,17,176,0,0,0,
1,0,0,0,160,0,0,0,128,0,0,1,224,0,0,240,0,0,0,17,148,0,24,0,1,255,216,255,224,
0,16,74,70,73,70,0,1,2,1,0,72,0,72,0,0,255,237,0,12,65,100,111,98,101,95,67,
77,0,2,255,238,0,14,65,100,111,98,101,0,100,128,0,0,0,1,255,219,0,132,0,12,8,8,
8,9,8,12,9,9,12,17,11,10,11,17,21,15,12,12,15,21,24,19,19,21,19,19,24,17,12,
12,12,12,12,12,17,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
12,12,12,12,12,12,12,12,1,13,11,11,13,14,13,16,14,14,16,20,14,14,14,20,20,14,
14,14,14,20,17,12,12,12,12,12,17,17,12,12,12,12,12,12,17,12,12,12,12,12,12,12,
12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,255,192,0,17,8,
0,128,0,160,3,1,34,0,2,17,1,3,17,1,255,221,0,4,0,10,255,196,1,63,0,0,1,5,1,1,
1,1,1,1,0,0,0,0,0,0,0,3,0,1,2,4,5,6,7,8,9,10,11,1,0,1,5,1,1,1,1,1,1,0,0,0,0,0,
0,0,1,0,2,3,4,5,6,7,8,9,10,11,16,0,1,4,1,3,2,4,2,5,7,6,8,5,3,12,51,1,0,2,17,3,
4,33,18,49,5,65,81,97,19,34,113,129,50,6,20,145,161,177,66,35,36,21,82,193,98,
51,52,114,130,209,67,7,37,146,83,240,225,241,99,115,53,22,162,178,131,38,68,
147,84,100,69,194,163,116,54,23,210,85,226,101,242,179,132,195,211,117,227,243,
70,39,148,164,133,180,149,196,212,228,244,165,181,197,213,229,245,86,102,118,
134,150,166,182,198,214,230,246,55,71,87,103,119,135,151,167,183,199,215,231,
247,17,0,2,2,1,2,4,4,3,4,5,6,7,7,6,5,53,1,0,2,17,3,33,49,18,4,65,81,97,113,34,
19,5,50,129,145,20,161,177,66,35,193,82,209,240,51,36,98,225,114,130,146,67,83,
21,99,115,52,241,37,6,22,162,178,131,7,38,53,194,210,68,147,84,163,23,100,69,
85,54,116,101,226,242,179,132,195,211,117,227,243,70,148,164,133,180,149,196,
212,228,244,165,181,197,213,229,245,86,102,118,134,150,166,182,198,214,230,246,
39,55,71,87,103,119,135,151,167,183,199,255,218,0,12,3,1,0,2,17,3,17,0,63,0,
243,54,144,230,109,60,246,67,112,135,120,38,107,128,58,240,156,153,215,186,74,
91,153,76,36,20,224,246,41,112,138,153,71,112,183,62,168,253,85,234,31,89,250,
147,176,241,95,246,122,169,110,252,140,162,210,230,214,211,237,96,218,54,181,
215,91,254,10,175,81,159,225,63,209,172,140,12,107,51,50,234,197,99,235,173,214,
185,173,15,185,193,140,18,118,251,220,126,63,154,189,219,234,222,39,79,250,149,
210,112,186,54,126,85,67,39,35,213,200,182,242,27,85,114,210,207,89,206,185,254,
158,246,212,235,241,241,235,125,239,251,69,190,207,230,232,253,30,58,181,83,230,
223,94,14,47,79,201,187,234,255,0,79,233,184,248,56,184,121,53,27,114,55,250,
153,23,217,232,238,166,205,246,109,123,106,251,59,247,100,87,87,169,233,100,89,
250,91,63,90,253,38,54,1,107,108,49,19,18,62,82,23,69,254,55,237,205,103,214,
170,170,186,239,83,27,236,173,183,22,145,163,107,15,115,235,191,79,244,150,221,
71,168,251,63,115,211,103,248,53,201,227,89,91,155,163,246,88,223,222,208,25,
248,163,21,178,109,122,143,109,196,113,58,133,165,77,182,186,179,184,79,156,199,
117,156,225,188,206,155,227,88,241,133,99,26,231,26,139,218,240,246,183,82,65,
16,33,16,180,164,125,206,100,146,72,141,99,141,1,255,0,190,160,89,127,168,216,
145,45,48,59,133,51,125,118,176,27,61,162,39,127,2,62,152,250,95,154,230,170,
249,216,89,29,58,188,75,50,61,140,234,21,125,167,21,166,67,189,45,219,42,177,
242,3,63,79,244,235,175,119,243,127,215,74,213,72,141,94,187,168,165,214,178,
159,81,225,190,173,164,181,140,39,243,239,177,162,205,149,235,244,246,170,217,
20,230,215,75,46,202,199,182,186,237,96,117,86,189,164,7,53,210,214,61,182,70,
215,53,223,152,229,23,220,225,51,160,253,223,51,162,222,192,250,231,215,217,245,
99,63,163,88,43,205,233,173,199,20,180,222,230,250,148,53,238,20,215,232,111,
62,166,67,25,63,163,175,101,143,198,253,21,158,165,53,82,129,43,128,238,243,64,
135,106,12,31,226,160,227,172,56,144,71,142,170,59,128,4,143,5,127,171,116,250,
240,46,170,186,111,57,85,219,83,109,109,198,167,82,29,62,215,122,12,187,244,207,
199,222,54,85,125,181,208,251,191,208,33,105,166,129,29,252,83,183,203,148,198,
59,104,124,19,182,73,73,43,182,55,5,102,171,3,65,7,147,192,242,213,86,46,215,
79,189,48,62,63,52,144,255,0,255,208,242,206,71,193,41,241,251,210,243,73,195,
184,225,37,40,248,130,156,74,97,225,216,167,18,18,83,219,125,81,250,183,208,109,
205,163,52,245,11,186,174,70,19,153,144,254,155,211,241,47,113,47,105,223,93,
111,204,200,174,156,102,87,189,190,239,83,210,101,159,153,114,244,78,191,245,
103,168,253,99,234,253,23,169,122,140,194,196,192,38,203,241,45,110,235,200,179,
107,174,169,254,155,237,197,253,35,106,102,55,242,63,77,111,173,127,178,133,195,
253,89,234,24,191,82,254,170,15,172,158,171,178,186,159,90,109,148,224,224,187,
115,105,103,163,97,170,235,175,216,253,182,236,217,85,159,224,237,255,0,180,213,
108,245,44,185,113,125,75,172,103,245,62,167,119,85,201,180,183,51,33,192,190,
202,198,193,160,109,109,107,91,92,125,22,49,169,41,244,63,241,207,140,43,175,
161,185,228,190,192,203,233,178,242,61,206,13,20,16,108,112,254,86,247,237,254,
186,232,186,111,70,233,93,103,234,255,0,75,119,84,163,24,117,220,190,150,234,
113,111,123,69,206,21,134,49,141,201,219,187,109,190,155,109,162,223,167,190,
191,91,211,174,202,253,85,145,213,243,240,122,191,248,162,126,109,33,214,62,143,
73,150,122,246,156,139,170,176,100,210,47,107,239,176,190,223,123,125,245,239,
217,250,165,148,254,98,161,245,39,170,140,255,0,173,93,28,87,112,117,125,51,162,
250,5,144,233,54,50,125,106,217,79,183,244,254,246,253,15,231,168,167,212,73,78,
87,215,191,170,88,223,85,27,131,94,38,69,185,63,106,166,223,84,219,17,186,145,
86,231,87,179,110,214,191,214,254,111,252,23,250,69,222,89,245,63,234,187,126,
176,51,170,117,11,171,200,167,168,250,53,116,190,155,183,244,0,211,77,108,105,
13,97,119,218,171,244,49,191,71,234,55,236,181,127,194,126,137,121,222,126,104,
207,255,0,23,253,50,251,247,63,39,165,103,219,140,224,233,217,107,50,107,127,80,
46,178,192,24,247,63,219,232,217,233,95,234,127,164,254,118,151,174,143,174,
117,236,81,254,48,186,102,77,238,96,195,233,88,129,205,175,232,212,44,183,26,
252,170,253,55,235,252,227,157,135,93,79,255,0,139,253,26,74,115,126,167,253,94,
179,175,253,102,191,246,131,91,109,24,182,221,119,82,0,3,91,238,22,26,233,197,
245,25,250,63,210,189,190,181,159,79,214,166,175,248,101,181,213,122,231,80,200,
250,172,62,175,245,106,43,179,235,47,95,191,101,125,61,182,151,58,150,216,230,
91,69,249,85,123,190,192,218,63,71,232,99,111,250,27,46,183,244,191,108,244,
242,254,170,100,51,35,234,199,87,232,246,117,71,116,142,165,146,246,231,187,46,
219,5,88,238,15,44,99,169,117,141,244,221,141,234,218,207,67,39,211,119,169,252,
222,207,86,175,83,25,83,202,163,162,226,116,91,49,155,153,137,251,119,166,134,
221,211,242,250,19,47,182,231,61,197,254,183,237,14,164,232,170,230,63,115,31,
234,122,212,63,15,252,13,127,246,150,212,84,27,216,191,81,250,14,83,186,167,65,
175,168,12,159,173,52,49,182,80,95,85,148,83,89,97,14,186,138,218,231,254,179,
235,78,203,114,44,255,0,5,109,87,99,213,250,59,80,126,173,50,191,171,191,83,122,
246,111,87,160,176,100,222,220,38,212,219,4,228,62,161,101,118,97,126,143,110,
220,127,85,214,253,166,234,110,253,62,55,218,125,63,230,191,73,10,113,242,190,
191,227,95,146,205,173,250,203,210,106,173,213,223,91,189,54,230,85,185,238,107,
44,99,3,107,197,204,199,123,63,67,123,28,198,88,251,63,73,250,47,210,81,91,174,
102,209,157,254,47,186,111,79,102,56,196,206,232,217,131,15,55,29,193,213,185,
143,177,153,27,45,117,78,255,0,185,78,173,214,100,111,253,35,50,125,111,209,164,
166,207,213,60,110,159,208,48,186,47,82,183,4,103,117,190,191,149,232,244,241,
121,45,171,30,166,61,148,125,171,100,61,206,181,246,61,143,101,159,232,191,154,
125,95,246,163,15,252,98,12,129,245,207,170,125,162,214,92,243,99,96,215,48,214,
108,111,217,234,116,134,254,150,170,61,54,219,255,0,8,189,2,238,145,245,71,164,
125,98,193,207,235,29,98,157,248,21,226,225,116,220,87,57,174,21,154,25,101,22,
125,170,162,203,125,26,189,95,211,179,33,238,171,236,185,62,255,0,93,112,63,227,
23,16,226,253,116,234,117,134,128,44,177,183,52,134,150,131,234,177,150,187,
250,222,242,237,239,255,0,72,144,83,205,41,55,191,156,166,38,12,248,164,39,178,
42,88,242,7,130,67,84,157,202,73,41,255,209,242,212,180,248,20,210,156,65,242,
73,74,219,204,169,118,61,207,136,77,181,218,15,45,10,125,174,19,161,9,41,119,
62,215,177,173,46,37,172,144,209,58,0,78,227,183,247,119,57,67,69,51,226,117,
213,90,170,172,103,208,73,180,253,162,72,109,2,178,67,155,3,107,189,125,222,199,
57,206,119,210,173,37,58,127,87,250,165,117,116,206,177,209,114,28,43,167,171,
99,131,83,255,0,119,35,24,253,163,21,143,123,158,198,87,86,87,191,29,238,219,
252,239,217,254,133,126,162,23,76,203,101,21,103,86,45,52,179,55,2,218,61,96,75,
118,185,166,188,214,85,237,255,0,185,127,101,251,22,207,251,178,143,133,129,209,
172,197,181,249,153,14,198,200,101,165,130,108,171,105,97,167,39,37,182,140,103,
82,109,218,219,104,199,197,246,217,250,75,175,255,0,7,250,54,39,234,29,63,166,
214,218,7,76,202,57,46,123,156,108,113,178,167,6,195,172,244,255,0,67,72,101,
204,223,93,117,110,221,236,175,212,65,77,106,29,152,41,191,26,135,109,198,202,
104,23,84,230,181,192,237,141,143,107,94,15,165,115,127,210,213,250,79,250,218,
177,75,114,28,224,235,200,188,108,174,166,135,141,90,202,71,167,75,63,151,233,
87,250,54,255,0,35,211,87,42,193,233,6,186,189,76,239,66,235,113,183,237,125,
245,184,125,162,202,107,118,57,112,162,173,216,52,209,212,31,233,100,85,154,255,
0,232,223,165,255,0,4,172,217,87,67,109,86,89,135,212,141,150,178,182,186,172,
83,109,112,251,79,174,47,199,251,77,152,205,117,126,143,165,141,103,175,179,
208,201,254,141,141,119,235,148,223,142,224,80,65,101,133,129,210,126,197,251,
103,173,250,20,116,252,44,187,112,241,199,160,251,44,191,42,192,50,55,245,39,
212,230,62,220,12,47,110,202,170,123,61,74,105,186,143,252,49,158,58,95,214,12,
210,255,0,82,209,137,210,178,44,1,185,87,184,116,236,11,91,39,211,186,154,108,
110,35,31,83,153,250,70,87,78,37,183,108,90,29,52,227,213,102,243,213,114,58,93,
185,57,13,170,247,227,229,51,21,166,166,140,127,74,203,113,75,77,207,125,142,
201,203,165,185,78,253,14,39,163,235,91,250,58,149,33,135,210,115,9,200,207,204,
177,249,66,226,207,86,252,202,44,117,176,207,83,26,138,172,44,189,213,55,41,222,
203,51,178,125,28,60,15,87,254,213,122,86,84,129,221,35,103,107,19,235,55,68,
250,149,75,233,232,185,3,171,231,89,83,69,222,147,118,227,125,162,14,252,140,
156,191,231,179,43,171,119,167,131,137,139,233,99,215,71,173,234,126,183,119,
174,184,142,173,213,115,186,199,80,200,234,57,207,15,201,201,32,216,230,183,107,
72,96,109,117,181,172,108,55,109,117,177,141,253,245,183,143,211,126,171,218,
113,142,110,101,184,245,91,89,57,46,102,70,61,174,165,226,255,0,179,181,158,147,
24,207,89,159,103,221,127,232,235,255,0,135,175,214,246,82,179,186,158,47,78,
199,175,25,184,46,123,173,177,175,118,75,159,125,121,12,102,203,174,197,244,246,
227,211,94,219,61,58,89,149,252,229,158,173,57,31,163,255,0,73,96,181,56,225,
154,19,30,1,105,245,62,187,149,213,48,176,40,204,30,166,71,79,109,149,12,167,
123,158,250,156,230,217,69,118,216,233,185,255,0,103,115,175,99,63,73,233,122,
94,159,167,83,44,245,172,186,182,77,88,204,180,12,107,159,148,35,87,58,191,74,
29,251,173,99,159,102,228,23,50,36,190,71,114,17,83,7,199,183,230,145,211,65,
207,114,145,220,8,113,28,246,242,72,183,105,227,113,228,120,106,146,152,193,153,
78,117,16,151,39,146,79,130,114,35,158,201,41,255,210,242,216,29,187,169,6,13,
162,74,102,178,123,162,86,106,108,110,6,71,51,38,82,83,42,232,105,32,111,131,49,
7,253,146,136,230,122,14,6,194,44,111,1,194,116,60,234,160,46,100,151,56,107,
216,70,154,74,19,203,158,233,119,61,135,96,142,136,109,182,172,91,32,234,201,
152,219,168,153,253,215,34,211,211,61,225,205,189,178,14,129,210,59,119,254,178,
167,73,111,30,222,57,42,253,111,126,232,221,236,145,1,166,127,234,146,176,162,
15,70,206,55,79,205,47,19,233,134,180,180,253,38,131,4,198,191,157,236,90,56,
221,45,207,31,167,184,48,14,245,141,198,15,199,98,206,102,83,152,247,107,160,
238,117,236,183,122,94,69,47,175,115,32,196,2,223,61,120,253,230,167,68,2,178,
68,134,230,46,54,14,38,194,92,26,230,159,113,184,181,160,184,159,162,198,255,0,
228,183,174,134,158,143,210,175,173,182,185,135,21,204,213,204,172,75,78,177,
249,238,246,174,123,39,21,217,119,250,245,92,42,218,11,125,236,222,57,240,150,
171,247,11,169,233,236,168,90,205,172,107,125,91,139,118,184,53,164,123,141,91,
157,235,122,159,205,32,101,49,197,112,244,196,122,72,61,187,170,67,31,4,76,100,
78,67,243,196,138,140,124,152,100,244,46,145,37,181,94,243,18,93,236,29,228,
120,254,242,203,187,163,97,214,210,231,100,157,173,107,128,138,137,39,157,173,
250,77,111,253,37,178,204,140,23,180,85,77,196,56,9,139,15,233,76,105,234,63,
247,221,252,170,213,12,215,180,53,224,123,160,242,226,90,32,120,167,138,32,19,
68,248,44,18,47,53,147,137,133,94,140,156,139,67,189,206,118,141,0,234,61,141,
253,232,253,245,81,238,112,99,191,155,13,134,232,65,17,223,111,181,105,103,227,
11,236,251,86,9,246,145,54,210,199,105,184,123,13,149,15,206,223,255,0,86,177,
242,46,12,14,105,97,245,39,105,46,228,24,137,41,135,70,65,170,33,123,164,130,
221,73,58,180,141,52,67,53,210,226,232,123,133,158,15,239,254,106,103,90,211,
168,26,157,61,188,232,62,146,139,5,175,7,112,4,29,72,136,152,40,46,93,204,126,
205,208,12,114,65,230,80,221,188,52,75,64,16,57,29,188,84,222,251,76,147,175,
104,143,5,2,227,160,63,71,191,26,160,82,17,153,215,143,56,72,146,1,5,49,62,26,3,
224,150,211,224,146,159,255,211,242,222,10,82,15,41,146,141,18,83,32,99,131,30,
50,165,168,38,79,207,178,140,13,57,249,167,13,147,2,15,193,37,47,238,14,152,
131,228,172,87,117,187,140,64,152,17,193,229,9,161,205,26,112,121,7,80,143,246,
162,209,250,54,195,251,136,28,15,206,246,253,36,148,218,199,166,251,67,156,6,
209,36,251,184,145,167,117,209,98,217,70,53,6,166,56,88,231,16,235,44,60,204,
123,90,223,206,107,91,43,154,199,201,14,5,175,121,46,153,14,159,18,173,11,73,13,
116,131,184,136,35,157,19,129,165,132,91,208,183,34,242,97,174,45,147,166,216,
87,92,218,110,173,166,223,115,199,46,38,127,7,123,87,51,94,101,149,25,15,218,
211,160,147,58,243,244,66,210,163,170,54,198,24,30,238,117,239,31,157,252,164,
183,187,42,59,10,27,117,116,92,220,102,99,138,95,91,108,13,0,2,117,49,51,201,
220,168,92,41,107,143,181,174,110,190,199,52,24,145,249,179,238,106,167,147,212,
29,235,57,140,112,245,26,120,35,180,114,131,110,86,230,235,99,100,198,160,157,
117,254,218,90,10,29,144,1,95,47,41,149,18,216,12,49,39,183,63,71,110,138,158,
70,117,158,224,118,147,187,151,147,247,106,125,170,22,228,239,172,178,253,174,
12,4,183,190,135,128,215,126,242,163,104,165,165,219,102,100,198,238,211,228,
149,174,1,48,234,0,60,19,91,75,1,208,55,159,252,201,168,110,101,2,93,85,174,218,
238,26,125,221,255,0,178,170,204,19,50,60,116,29,210,220,98,26,232,111,135,127,
154,22,154,102,230,182,93,238,39,206,12,33,22,31,135,197,72,141,59,159,154,129,
7,192,2,130,86,136,79,169,239,41,184,236,37,52,148,148,255,0,255,212,242,216,
30,41,79,150,137,244,240,76,99,198,18,82,255,0,130,148,1,201,39,224,160,12,113,
10,68,144,117,208,248,36,165,228,158,26,126,100,240,166,25,187,137,159,2,100,
40,135,178,64,237,252,97,55,170,91,160,1,165,37,39,117,22,180,14,224,144,76,14,
18,109,238,172,252,184,37,70,188,155,132,25,132,119,185,175,27,189,61,198,62,
144,137,231,192,20,180,70,170,175,44,147,181,242,233,17,161,254,229,111,20,220,
92,44,123,182,6,184,31,116,238,118,174,27,67,127,57,83,170,198,214,100,52,176,
249,141,167,226,52,70,175,34,166,144,253,219,136,212,201,214,124,209,20,163,109,
236,195,69,132,152,135,68,135,13,72,143,250,166,170,27,237,198,46,45,104,113,
123,68,216,209,254,187,82,57,180,151,114,76,104,53,149,1,155,75,76,182,70,154,
200,7,186,38,144,1,65,246,167,17,238,36,152,231,255,0,34,132,235,11,199,210,208,
106,116,213,26,199,85,96,220,8,220,0,62,3,238,80,117,111,36,129,4,13,36,20,18,
134,125,160,112,38,126,105,18,20,220,199,128,100,113,224,80,224,248,126,8,37,
121,61,146,36,206,186,120,165,1,52,36,165,165,57,61,147,71,138,82,37,37,63,255,
213,242,201,74,124,84,101,36,148,202,66,65,196,112,162,146,74,101,184,120,107,
226,148,235,42,41,36,166,68,119,79,32,234,121,81,7,178,73,41,61,110,116,136,119,
203,113,254,42,110,177,222,237,223,136,7,255,0,34,170,202,125,230,33,37,54,69,
147,16,107,211,196,65,252,138,47,178,214,243,183,94,32,72,64,4,36,30,71,31,114,
74,72,110,127,118,180,248,136,254,229,23,88,29,244,155,247,105,10,38,15,26,40,
164,166,67,203,241,72,185,199,146,162,158,74,74,95,121,226,83,110,74,1,238,154,
18,82,242,153,36,146,83,255,214,242,164,146,73,37,41,36,146,73,74,73,36,146,82,
146,73,36,148,164,146,73,37,41,36,146,73,74,73,36,146,82,146,73,36,148,164,146,
73,37,41,36,146,73,79,255,217,56,66,73,77,4,33,0,0,0,0,0,83,0,0,0,1,1,0,0,0,15,
0,65,0,100,0,111,0,98,0,101,0,32,0,80,0,104,0,111,0,116,0,111,0,115,0,104,0,
111,0,112,0,0,0,18,0,65,0,100,0,111,0,98,0,101,0,32,0,80,0,104,0,111,0,116,0,
111,0,115,0,104,0,111,0,112,0,32,0,67,0,83,0,0,0,1,0,56,66,73,77,4,6,0,0,0,0,0,
7,0,8,0,0,0,1,1,0,255,225,25,61,104,116,116,112,58,47,47,110,115,46,97,100,
111,98,101,46,99,111,109,47,120,97,112,47,49,46,48,47,0,60,63,120,112,97,99,107,
101,116,32,98,101,103,105,110,61,39,239,187,191,39,32,105,100,61,39,87,53,77,48,
77,112,67,101,104,105,72,122,114,101,83,122,78,84,99,122,107,99,57,100,39,63,
62,10,60,120,58,120,109,112,109,101,116,97,32,120,109,108,110,115,58,120,61,39,
97,100,111,98,101,58,110,115,58,109,101,116,97,47,39,32,120,58,120,109,112,116,
107,61,39,88,77,80,32,116,111,111,108,107,105,116,32,51,46,48,45,50,56,44,32,
102,114,97,109,101,119,111,114,107,32,49,46,54,39,62,10,60,114,100,102,58,82,68,
70,32,120,109,108,110,115,58,114,100,102,61,39,104,116,116,112,58,47,47,119,
119,119,46,119,51,46,111,114,103,47,49,57,57,57,47,48,50,47,50,50,45,114,100,
102,45,115,121,110,116,97,120,45,110,115,35,39,32,120,109,108,110,115,58,105,88,
61,39,104,116,116,112,58,47,47,110,115,46,97,100,111,98,101,46,99,111,109,47,
105,88,47,49,46,48,47,39,62,10,10,32,60,114,100,102,58,68,101,115,99,114,105,
112,116,105,111,110,32,114,100,102,58,97,98,111,117,116,61,39,117,117,105,100,
58,101,100,100,48,53,98,56,98,45,97,98,50,48,45,49,49,100,102,45,57,102,102,98,
45,100,100,49,101,57,99,48,102,48,57,101,50,39,10,32,32,120,109,108,110,115,58,
101,120,105,102,61,39,104,116,116,112,58,47,47,110,115,46,97,100,111,98,101,46,
99,111,109,47,101,120,105,102,47,49,46,48,47,39,62,10,32,32,60,101,120,105,102,
58,67,111,108,111,114,83,112,97,99,101,62,52,50,57,52,57,54,55,50,57,53,60,47,
101,120,105,102,58,67,111,108,111,114,83,112,97,99,101,62,10,32,32,60,101,120,
105,102,58,80,105,120,101,108,88,68,105,109,101,110,115,105,111,110,62,54,57,52,
60,47,101,120,105,102,58,80,105,120,101,108,88,68,105,109,101,110,115,105,111,
110,62,10,32,32,60,101,120,105,102,58,80,105,120,101,108,89,68,105,109,101,110,
115,105,111,110,62,53,53,52,60,47,101,120,105,102,58,80,105,120,101,108,89,68,
105,109,101,110,115,105,111,110,62,10,32,60,47,114,100,102,58,68,101,115,99,114,
105,112,116,105,111,110,62,10,10,32,60,114,100,102,58,68,101,115,99,114,105,112,
116,105,111,110,32,114,100,102,58,97,98,111,117,116,61,39,117,117,105,100,58,
101,100,100,48,53,98,56,98,45,97,98,50,48,45,49,49,100,102,45,57,102,102,98,45,
100,100,49,101,57,99,48,102,48,57,101,50,39,10,32,32,120,109,108,110,115,58,112,
100,102,61,39,104,116,116,112,58,47,47,110,115,46,97,100,111,98,101,46,99,111,
109,47,112,100,102,47,49,46,51,47,39,62,10,32,60,47,114,100,102,58,68,101,115,
99,114,105,112,116,105,111,110,62,10,10,32,60,114,100,102,58,68,101,115,99,114,
105,112,116,105,111,110,32,114,100,102,58,97,98,111,117,116,61,39,117,117,105,
100,58,101,100,100,48,53,98,56,98,45,97,98,50,48,45,49,49,100,102,45,57,102,102,
98,45,100,100,49,101,57,99,48,102,48,57,101,50,39,10,32,32,120,109,108,110,115,
58,112,104,111,116,111,115,104,111,112,61,39,104,116,116,112,58,47,47,110,115,
46,97,100,111,98,101,46,99,111,109,47,112,104,111,116,111,115,104,111,112,47,
49,46,48,47,39,62,10,32,32,60,112,104,111,116,111,115,104,111,112,58,72,105,
115,116,111,114,121,62,60,47,112,104,111,116,111,115,104,111,112,58,72,105,115,
116,111,114,121,62,10,32,60,47,114,100,102,58,68,101,115,99,114,105,112,116,105,
111,110,62,10,10,32,60,114,100,102,58,68,101,115,99,114,105,112,116,105,111,110,
32,114,100,102,58,97,98,111,117,116,61,39,117,117,105,100,58,101,100,100,48,53,
98,56,98,45,97,98,50,48,45,49,49,100,102,45,57,102,102,98,45,100,100,49,101,57,
99,48,102,48,57,101,50,39,10,32,32,120,109,108,110,115,58,116,105,102,102,61,
39,104,116,116,112,58,47,47,110,115,46,97,100,111,98,101,46,99,111,109,47,116,
105,102,102,47,49,46,48,47,39,62,10,32,32,60,116,105,102,102,58,79,114,105,101,
110,116,97,116,105,111,110,62,49,60,47,116,105,102,102,58,79,114,105,101,110,
116,97,116,105,111,110,62,10,32,32,60,116,105,102,102,58,88,82,101,115,111,108,
117,116,105,111,110,62,57,56,47,49,60,47,116,105,102,102,58,88,82,101,115,111,
108,117,116,105,111,110,62,10,32,32,60,116,105,102,102,58,89,82,101,115,111,108,
117,116,105,111,110,62,57,56,47,49,60,47,116,105,102,102,58,89,82,101,115,111,
108,117,116,105,111,110,62,10,32,32,60,116,105,102,102,58,82,101,115,111,108,
117,116,105,111,110,85,110,105,116,62,50,60,47,116,105,102,102,58,82,101,115,
111,108,117,116,105,111,110,85,110,105,116,62,10,32,60,47,114,100,102,58,68,101,
115,99,114,105,112,116,105,111,110,62,10,10,32,60,114,100,102,58,68,101,115,99,
114,105,112,116,105,111,110,32,114,100,102,58,97,98,111,117,116,61,39,117,117,
105,100,58,101,100,100,48,53,98,56,98,45,97,98,50,48,45,49,49,100,102,45,57,102,
102,98,45,100,100,49,101,57,99,48,102,48,57,101,50,39,10,32,32,120,109,108,110,
115,58,120,97,112,61,39,104,116,116,112,58,47,47,110,115,46,97,100,111,98,101,
46,99,111,109,47,120,97,112,47,49,46,48,47,39,62,10,32,32,60,120,97,112,58,67,
114,101,97,116,101,68,97,116,101,62,50,48,49,48,45,48,56,45,49,57,84,48,49,58,
51,53,58,50,54,43,48,49,58,48,48,60,47,120,97,112,58,67,114,101,97,116,101,68,
97,116,101,62,10,32,32,60,120,97,112,58,77,111,100,105,102,121,68,97,116,101,
62,50,48,49,48,45,48,56,45,49,57,84,48,49,58,51,53,58,50,54,43,48,49,58,48,48,
60,47,120,97,112,58,77,111,100,105,102,121,68,97,116,101,62,10,32,32,60,120,97,
112,58,77,101,116,97,100,97,116,97,68,97,116,101,62,50,48,49,48,45,48,56,45,49,
57,84,48,49,58,51,53,58,50,54,43,48,49,58,48,48,60,47,120,97,112,58,77,101,116,
97,100,97,116,97,68,97,116,101,62,10,32,32,60,120,97,112,58,67,114,101,97,116,
111,114,84,111,111,108,62,65,100,111,98,101,32,80,104,111,116,111,115,104,111,
112,32,67,83,32,87,105,110,100,111,119,115,60,47,120,97,112,58,67,114,101,97,
116,111,114,84,111,111,108,62,10,32,60,47,114,100,102,58,68,101,115,99,114,105,
112,116,105,111,110,62,10,10,32,60,114,100,102,58,68,101,115,99,114,105,112,116,
105,111,110,32,114,100,102,58,97,98,111,117,116,61,39,117,117,105,100,58,101,
100,100,48,53,98,56,98,45,97,98,50,48,45,49,49,100,102,45,57,102,102,98,45,100,
100,49,101,57,99,48,102,48,57,101,50,39,10,32,32,120,109,108,110,115,58,115,116,
82,101,102,61,39,104,116,116,112,58,47,47,110,115,46,97,100,111,98,101,46,99,
111,109,47,120,97,112,47,49,46,48,47,115,84,121,112,101,47,82,101,115,111,117,
114,99,101,82,101,102,35,39,10,32,32,120,109,108,110,115,58,120,97,112,77,77,61,
39,104,116,116,112,58,47,47,110,115,46,97,100,111,98,101,46,99,111,109,47,120,
97,112,47,49,46,48,47,109,109,47,39,62,10,32,32,60,120,97,112,77,77,58,68,101,
114,105,118,101,100,70,114,111,109,32,114,100,102,58,112,97,114,115,101,84,121,
112,101,61,39,82,101,115,111,117,114,99,101,39,62,10,32,32,32,60,115,116,82,101,
102,58,105,110,115,116,97,110,99,101,73,68,62,117,117,105,100,58,101,100,100,48,
53,98,56,55,45,97,98,50,48,45,49,49,100,102,45,57,102,102,98,45,100,100,49,101,
57,99,48,102,48,57,101,50,60,47,115,116,82,101,102,58,105,110,115,116,97,110,
99,101,73,68,62,10,32,32,32,60,115,116,82,101,102,58,100,111,99,117,109,101,
110,116,73,68,62,97,100,111,98,101,58,100,111,99,105,100,58,112,104,111,116,111,
115,104,111,112,58,57,53,98,99,57,100,49,50,45,97,98,49,102,45,49,49,100,102,45,
57,102,102,98,45,100,100,49,101,57,99,48,102,48,57,101,50,60,47,115,116,82,101,
102,58,100,111,99,117,109,101,110,116,73,68,62,10,32,32,60,47,120,97,112,77,77,
58,68,101,114,105,118,101,100,70,114,111,109,62,10,32,32,60,120,97,112,77,77,
58,68,111,99,117,109,101,110,116,73,68,62,97,100,111,98,101,58,100,111,99,105,
100,58,112,104,111,116,111,115,104,111,112,58,101,100,100,48,53,98,56,97,45,97,
98,50,48,45,49,49,100,102,45,57,102,102,98,45,100,100,49,101,57,99,48,102,48,
57,101,50,60,47,120,97,112,77,77,58,68,111,99,117,109,101,110,116,73,68,62,10,
32,60,47,114,100,102,58,68,101,115,99,114,105,112,116,105,111,110,62,10,10,32,
60,114,100,102,58,68,101,115,99,114,105,112,116,105,111,110,32,114,100,102,58,
97,98,111,117,116,61,39,117,117,105,100,58,101,100,100,48,53,98,56,98,45,97,98,
50,48,45,49,49,100,102,45,57,102,102,98,45,100,100,49,101,57,99,48,102,48,57,
101,50,39,10,32,32,120,109,108,110,115,58,100,99,61,39,104,116,116,112,58,47,47,
112,117,114,108,46,111,114,103,47,100,99,47,101,108,101,109,101,110,116,115,47,
49,46,49,47,39,62,10,32,32,60,100,99,58,102,111,114,109,97,116,62,105,109,97,
103,101,47,106,112,101,103,60,47,100,99,58,102,111,114,109,97,116,62,10,32,60,
47,114,100,102,58,68,101,115,99,114,105,112,116,105,111,110,62,10,10,60,47,114,
100,102,58,82,68,70,62,10,60,47,120,58,120,109,112,109,101,116,97,62,10,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,10,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,10,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,10,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,10,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,10,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,10,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,10,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,10,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,10,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,10,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,10,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,10,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,10,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,10,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,10,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,10,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,10,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,10,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,10,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,10,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,10,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,10,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,10,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,10,60,63,120,112,97,99,107,101,116,32,101,110,
100,61,39,119,39,63,62,255,238,0,14,65,100,111,98,101,0,100,64,0,0,0,1,255,219,
0,132,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,
1,2,2,1,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,255,192,0,17,8,2,42,2,182,3,1,17,0,2,17,1,3,
17,1,255,221,0,4,0,87,255,196,1,162,0,0,0,6,2,3,1,0,0,0,0,0,0,0,0,0,0,7,8,6,5,
4,9,3,10,2,1,0,11,1,0,0,6,3,1,1,1,0,0,0,0,0,0,0,0,0,6,5,4,3,7,2,8,1,9,0,10,11,
16,0,2,1,3,4,1,3,3,2,3,3,3,2,6,9,117,1,2,3,4,17,5,18,6,33,7,19,34,0,8,49,20,65,
50,35,21,9,81,66,22,97,36,51,23,82,113,129,24,98,145,37,67,161,177,240,38,52,
114,10,25,193,209,53,39,225,83,54,130,241,146,162,68,84,115,69,70,55,71,99,40,
85,86,87,26,178,194,210,226,242,100,131,116,147,132,101,163,179,195,211,227,41,
56,102,243,117,42,57,58,72,73,74,88,89,90,103,104,105,106,118,119,120,121,122,
133,134,135,136,137,138,148,149,150,151,152,153,154,164,165,166,167,168,169,170,
180,181,182,183,184,185,186,196,197,198,199,200,201,202,212,213,214,215,216,217,
218,228,229,230,231,232,233,234,244,245,246,247,248,249,250,17,0,2,1,3,2,4,4,3,
5,4,4,4,6,6,5,109,1,2,3,17,4,33,18,5,49,6,0,34,19,65,81,7,50,97,20,113,8,66,
129,35,145,21,82,161,98,22,51,9,177,36,193,209,67,114,240,23,225,130,52,37,146,
83,24,99,68,241,162,178,38,53,25,84,54,69,100,39,10,115,131,147,70,116,194,210,
226,242,85,101,117,86,55,132,133,163,179,195,211,227,243,41,26,148,164,180,196,
212,228,244,149,165,181,197,213,229,245,40,71,87,102,56,118,134,150,166,182,198,
214,230,246,103,119,135,151,167,183,199,215,231,247,72,88,104,120,136,152,168,
184,200,216,232,248,57,73,89,105,121,137,153,169,185,201,217,233,249,42,58,74,
90,106,122,138,154,170,186,202,218,234,250,255,218,0,12,3,1,0,2,17,3,17,0,63,0,
209,70,26,225,79,60,55,142,77,18,89,52,200,3,170,121,0,45,37,237,115,114,71,43,
98,47,237,229,37,113,79,245,127,171,137,233,130,181,20,232,75,199,206,205,75,
34,36,129,77,70,144,132,143,35,196,80,43,43,131,114,161,73,28,155,92,113,244,
247,101,97,192,159,42,244,195,138,112,242,255,0,87,231,212,28,182,37,95,238,96,
107,203,81,73,69,21,101,215,198,146,152,106,26,13,36,235,12,205,164,49,44,5,155,
143,207,55,163,51,6,52,53,167,87,6,180,53,165,122,66,79,10,53,60,138,139,168,
188,145,148,101,187,33,14,11,0,198,192,49,85,63,142,65,231,223,188,74,143,157,
127,63,245,127,170,157,108,169,215,249,127,170,158,157,54,212,197,34,180,16,200,
30,237,5,79,237,196,247,146,66,74,120,164,33,134,152,238,201,205,137,36,125,45,
239,196,146,0,245,7,254,47,203,211,171,40,94,236,253,191,230,233,147,198,233,18,
147,18,128,204,140,36,181,203,191,146,75,171,7,188,122,157,159,232,71,208,127,
79,109,128,113,142,61,59,242,174,15,81,199,150,54,33,117,198,206,186,24,125,53,
11,157,64,134,91,13,66,223,142,72,227,221,125,41,215,177,131,142,185,197,47,
234,213,206,146,9,112,46,64,79,161,43,244,0,127,173,239,126,189,88,128,126,222,
148,76,254,104,22,57,73,150,37,146,48,4,118,121,66,202,92,137,1,65,109,8,120,
254,150,54,226,222,220,38,170,51,138,127,168,245,78,31,234,207,81,38,167,120,60,
37,72,93,78,158,55,58,163,118,67,26,152,229,64,90,229,26,247,184,22,30,235,74,
105,62,120,251,122,208,243,20,199,250,177,215,167,49,121,75,146,20,199,54,134,
75,55,10,46,85,212,181,149,188,140,126,131,250,95,222,216,144,216,227,254,172,
245,175,42,124,186,203,28,114,8,68,160,50,153,130,199,114,80,163,40,83,229,18,
49,225,47,197,191,175,250,254,247,164,40,192,62,95,207,249,117,170,230,135,143,
76,245,19,233,145,141,239,162,93,90,244,242,86,227,75,29,87,250,11,113,237,186,
228,211,167,23,128,38,189,66,168,151,204,222,64,204,196,147,98,198,237,199,229,
172,63,180,7,30,220,140,212,208,159,58,245,83,90,240,199,89,233,234,14,178,36,
36,146,140,151,63,78,22,224,91,250,127,81,244,62,220,175,113,31,46,188,69,113,
231,81,211,148,50,113,246,215,112,36,117,120,134,165,209,43,135,71,3,78,157,97,
72,7,130,127,167,187,134,242,39,29,54,203,70,215,143,243,12,245,214,189,18,29,
26,173,247,12,93,116,233,58,24,42,50,143,212,169,227,83,114,63,62,252,9,170,
129,95,139,173,21,212,163,204,211,242,251,124,184,245,62,104,245,82,249,160,168,
117,169,142,168,72,124,99,198,133,66,105,71,47,164,233,146,38,60,94,247,23,246,
251,14,208,202,199,88,111,245,31,183,166,148,143,18,140,189,180,167,77,134,170,
105,163,146,25,102,214,146,84,137,10,128,6,166,72,218,61,103,78,133,60,49,28,
242,111,249,246,193,118,32,169,60,77,122,189,0,49,209,115,79,242,250,245,128,75,
35,1,18,15,16,214,70,148,121,0,98,218,77,180,151,96,127,69,207,186,146,116,233,
24,233,224,190,109,241,99,165,21,37,108,211,71,43,249,227,84,130,9,20,9,192,
145,200,145,138,233,91,161,50,146,9,36,90,228,126,125,220,201,168,129,170,159,
225,255,0,103,166,60,48,164,84,84,147,246,117,30,150,8,231,120,148,234,37,153,
25,35,4,3,226,188,106,102,109,90,141,181,222,224,155,155,255,0,176,247,180,80,
113,231,254,172,245,167,52,242,192,175,82,5,51,81,85,76,178,54,133,106,137,52,
163,169,77,49,217,157,47,234,107,18,174,56,183,187,1,160,228,226,189,104,182,
181,80,6,64,252,250,81,83,86,199,224,192,44,66,165,162,117,50,214,170,134,65,
247,17,86,204,161,20,107,253,8,143,117,144,112,73,177,23,246,240,144,105,138,
149,167,159,218,15,250,179,211,44,132,25,181,17,81,195,236,35,174,43,82,178,206,
18,65,232,90,152,25,67,234,213,16,138,83,202,152,215,203,25,0,92,219,234,125,
236,53,91,134,49,215,138,144,62,116,232,81,167,220,235,38,74,182,118,38,57,139,
192,143,247,47,19,22,167,64,124,177,166,131,26,72,242,72,75,161,225,238,108,77,
249,246,177,110,50,237,154,252,253,63,213,254,110,138,218,218,138,191,195,242,
168,207,175,203,252,29,13,255,0,23,126,45,252,153,249,187,216,121,30,161,248,
165,213,25,174,226,223,216,188,30,67,118,100,112,56,122,204,46,49,177,155,122,
142,100,142,108,198,66,163,63,148,197,227,41,226,106,153,227,132,23,145,164,146,
105,81,5,201,30,202,238,239,225,128,129,33,37,152,208,0,9,38,153,224,1,224,56,
244,103,5,163,74,20,240,160,255,0,86,122,55,95,3,191,148,199,124,124,139,254,98,
61,99,240,123,229,191,92,252,129,248,211,140,220,181,251,192,238,221,193,47,89,
228,225,203,96,99,219,251,103,51,159,164,74,74,252,182,61,246,216,160,200,212,
208,165,58,86,52,211,83,159,40,42,92,149,4,162,227,116,87,72,214,218,116,50,180,
129,104,120,138,159,52,168,108,122,99,212,240,232,198,43,80,172,75,41,165,63,
213,158,183,13,249,207,255,0,9,166,254,92,159,29,191,150,39,201,153,186,109,100,
216,61,191,176,118,44,221,171,23,201,158,231,220,117,155,171,112,171,117,212,71,
63,95,182,38,145,22,135,7,182,240,219,214,158,145,232,10,99,168,34,147,238,39,
139,151,181,139,23,2,120,21,46,141,195,187,163,10,175,0,192,227,72,81,138,146,
70,154,212,212,1,90,30,159,10,141,85,210,0,35,175,156,6,14,170,106,186,178,140,
86,243,50,203,104,140,222,70,43,53,59,3,50,179,40,98,154,47,112,65,191,211,235,
236,216,18,88,125,188,58,72,212,11,171,142,41,208,150,139,44,143,73,84,90,89,88,
225,228,137,84,198,94,104,158,58,233,204,154,35,109,78,65,213,112,121,32,11,3,
199,181,42,107,159,42,127,151,164,36,14,224,127,139,252,131,165,90,225,225,74,
200,33,152,198,207,38,62,23,147,74,152,140,83,234,208,158,104,24,22,214,203,245,
191,168,222,254,212,170,249,128,58,72,206,217,249,31,245,103,161,123,105,99,165,
108,172,180,114,71,170,106,122,184,66,234,214,222,161,68,202,90,37,39,74,89,79,
54,228,143,107,227,80,88,10,100,127,155,164,18,183,109,124,136,255,0,47,70,67,
99,210,152,115,38,50,25,71,240,212,138,70,17,248,225,63,188,100,209,169,189,45,
39,210,199,218,248,129,8,221,21,76,65,35,161,147,61,36,84,216,52,10,222,49,50,
8,149,202,151,30,89,3,30,88,31,78,145,201,62,252,236,190,124,58,106,48,197,
170,7,69,239,113,85,58,227,104,177,194,118,153,4,243,198,31,251,18,195,34,19,43,
220,0,68,145,223,244,146,79,28,123,72,237,216,1,62,125,24,196,167,89,112,190,92,
58,71,218,106,42,60,176,131,68,204,233,65,73,74,46,200,179,233,58,8,144,2,34,
82,60,68,221,191,39,147,207,189,62,16,208,212,244,161,14,167,82,112,56,158,159,
54,206,228,105,181,227,229,144,150,167,164,101,113,80,24,122,236,160,4,33,142,
164,83,192,250,129,253,125,182,142,79,105,226,58,188,145,211,184,121,244,35,82,
110,41,232,210,134,104,167,116,90,108,213,51,176,58,200,103,86,144,42,133,39,
232,21,185,255,0,3,199,187,234,248,73,226,15,76,104,174,160,125,58,29,198,236,
251,239,225,113,78,201,33,21,18,77,44,49,179,24,154,158,53,142,240,212,13,119,
145,9,63,217,250,91,159,106,107,80,51,210,125,36,106,232,70,167,172,105,233,115,
116,180,48,190,154,170,72,234,222,147,80,146,73,157,114,49,105,116,212,47,27,17,
29,149,134,146,84,242,108,125,221,104,67,143,63,246,122,108,138,21,53,233,211,
13,89,84,48,185,138,121,41,235,41,229,130,170,130,178,88,139,6,104,154,79,44,
49,170,139,122,188,133,128,26,15,38,254,252,166,168,194,153,168,234,167,227,82,
14,40,122,79,230,39,150,151,114,83,196,173,85,20,190,89,35,241,148,213,226,148,
84,22,97,226,91,188,236,234,150,32,114,0,228,251,223,2,195,175,80,104,200,224,
58,71,202,106,197,102,230,134,190,88,255,0,138,140,173,68,241,75,80,82,49,36,
50,34,121,68,48,180,110,8,96,108,28,141,106,120,247,82,72,13,94,156,20,236,52,
253,157,99,106,154,124,176,158,147,24,249,6,204,227,233,157,235,41,103,145,41,
103,117,167,141,18,58,31,189,40,35,154,178,57,84,90,109,26,66,145,111,207,182,
131,106,52,21,173,58,112,130,181,173,52,147,210,121,243,191,97,73,153,145,230,
168,130,8,170,225,167,20,149,117,113,215,212,65,44,241,207,169,16,71,20,81,19,
230,140,243,26,130,7,208,27,223,222,181,233,38,188,58,223,133,168,10,116,231,
155,220,241,76,112,181,242,197,79,52,149,152,181,163,45,31,165,209,229,130,19,
27,36,16,150,83,96,5,141,172,135,252,125,168,83,149,52,242,233,19,33,26,199,
207,172,201,151,175,52,21,184,172,156,143,89,69,13,109,229,165,168,153,231,84,
100,4,72,232,3,248,89,192,225,73,213,111,168,246,241,36,22,244,233,178,6,149,97,
199,172,120,253,192,113,113,193,141,196,159,4,43,81,88,84,212,176,136,253,189,
100,209,9,42,67,74,89,80,120,218,198,247,96,63,54,247,102,26,66,105,225,79,240,
245,65,66,78,174,61,54,228,43,41,138,135,137,225,19,213,228,210,153,170,210,33,
52,201,77,36,53,48,214,24,38,66,151,121,97,148,160,97,233,185,189,136,246,157,
252,186,81,25,53,99,228,7,252,87,64,94,70,54,163,154,182,28,165,224,168,160,158,
186,41,43,36,251,122,120,144,70,240,44,34,58,129,26,197,81,42,196,57,22,214,11,
112,65,39,219,122,105,93,92,71,75,149,245,105,209,192,211,29,38,29,67,100,103,
170,147,198,23,51,116,134,48,24,72,244,171,47,154,58,173,86,210,154,164,64,13,
249,4,251,74,195,46,78,43,210,181,61,138,163,203,253,84,232,37,57,60,165,42,140,
66,200,202,185,74,191,4,240,179,180,233,81,229,174,88,195,5,144,178,153,21,148,
233,34,246,3,155,223,221,69,74,211,253,71,167,152,168,238,244,31,228,232,70,169,
99,128,196,96,169,40,25,41,103,199,203,150,154,70,121,161,2,106,89,162,132,77,
35,202,85,163,44,38,37,87,73,215,98,7,35,218,135,93,1,71,2,58,68,175,173,156,
182,84,255,0,168,116,11,246,76,56,234,44,4,20,115,84,84,23,201,195,61,42,79,82,
134,99,21,66,74,26,160,210,200,124,122,169,170,99,32,106,42,164,178,146,56,183,
182,46,40,138,186,143,203,252,253,40,181,37,221,138,140,140,250,126,222,139,238,
42,150,174,146,167,27,49,145,60,9,85,91,165,188,195,92,178,195,12,71,244,174,
145,175,233,233,22,71,32,106,250,123,66,161,170,164,30,218,244,186,66,8,146,128,
150,160,252,186,90,109,109,245,144,192,227,114,42,146,59,227,101,206,36,179,181,
98,203,24,184,166,116,113,67,29,51,170,25,34,105,1,102,147,82,218,192,47,245,
242,200,200,173,78,5,188,250,172,176,36,142,184,26,194,249,127,150,189,12,57,
125,199,143,174,216,121,10,191,52,19,154,218,12,106,210,205,69,231,150,178,99,
36,79,31,154,55,145,252,76,160,190,159,27,42,217,135,214,214,246,96,37,65,27,
177,32,134,3,135,30,29,23,24,27,198,64,1,26,73,227,195,236,232,11,174,162,129,
101,88,52,57,130,92,205,44,145,59,68,144,164,232,212,244,210,179,160,157,36,41,
172,27,232,55,23,82,7,227,219,90,70,7,21,47,246,121,14,156,169,29,254,97,63,203,
242,255,0,15,73,172,78,34,151,248,212,64,71,71,52,180,217,121,170,169,233,39,17,
195,21,90,68,245,48,76,4,141,22,184,157,4,170,200,109,114,126,159,143,126,134,
53,241,86,128,84,53,64,245,227,211,243,76,222,3,18,72,5,40,72,242,173,15,249,
51,210,30,130,102,164,200,188,208,131,77,34,87,205,81,13,20,54,170,101,148,202,
209,170,137,166,98,177,46,169,174,9,44,154,134,162,9,183,180,72,116,201,85,193,
213,195,165,238,60,72,116,156,246,249,255,0,171,253,158,164,230,233,68,141,151,
150,154,31,19,12,165,69,57,134,103,103,168,150,89,170,73,150,0,164,42,73,36,79,
102,184,226,230,224,216,219,218,137,0,34,90,10,16,212,249,241,253,135,253,71,
164,240,62,147,18,179,99,72,60,40,0,3,142,51,211,82,213,200,140,203,72,226,68,
149,163,165,88,229,95,21,84,14,145,179,43,37,61,70,182,112,89,117,7,7,198,0,177,
252,123,174,179,221,163,53,52,167,152,253,189,59,225,130,6,177,220,51,94,32,254,
99,254,47,168,211,52,139,66,42,35,154,22,150,86,137,73,68,36,234,58,84,151,82,
198,87,117,215,102,111,211,107,254,61,176,107,166,163,143,250,191,62,182,0,241,
138,149,33,64,62,127,234,31,151,26,252,250,82,164,213,145,210,67,80,38,83,13,44,
145,81,216,85,106,138,21,12,79,133,19,73,113,18,200,192,223,155,125,125,189,87,
210,24,176,33,77,56,244,156,4,212,84,169,169,169,225,199,230,127,46,152,231,220,
142,43,94,86,141,107,10,191,157,60,174,247,58,148,0,25,129,98,2,168,250,30,7,
214,215,246,211,76,117,212,173,79,31,245,127,171,231,210,165,181,6,53,21,160,
225,254,207,231,242,235,25,206,137,197,40,138,50,194,49,33,101,103,102,18,141,
90,214,47,40,112,236,145,133,231,233,200,254,190,234,100,13,64,162,185,234,203,
9,140,177,45,147,252,190,127,159,73,236,148,175,83,80,37,153,252,147,29,9,35,
133,62,69,178,221,88,233,58,1,45,249,22,191,250,254,211,57,175,197,199,135,75,
99,160,81,74,211,141,122,238,138,182,88,167,164,130,105,71,219,172,102,27,25,
86,51,26,49,102,176,144,171,180,64,177,55,176,177,63,143,126,87,53,2,184,167,
250,179,215,157,6,150,63,139,229,235,212,202,49,24,158,5,68,146,163,205,71,32,8,
186,21,230,90,67,174,58,104,228,157,36,143,65,100,244,150,82,79,251,31,123,0,29,
35,136,35,252,30,93,104,147,165,137,160,32,255,0,135,164,235,180,71,207,120,
218,48,65,13,25,32,216,7,229,121,0,150,3,250,126,71,182,116,154,146,15,151,79,
212,138,30,161,35,24,181,234,39,212,158,49,199,58,73,87,231,243,107,175,191,80,
80,211,143,91,25,225,214,122,131,105,9,212,28,146,46,121,231,211,207,31,95,175,
30,244,217,43,95,63,78,183,215,119,209,29,56,22,37,220,181,133,207,23,2,199,
232,65,247,97,144,1,30,103,252,157,111,172,149,18,93,149,88,30,23,232,63,4,31,
233,98,183,36,127,79,207,189,159,60,99,170,245,206,150,9,216,153,2,146,9,11,174,
224,162,221,73,253,195,109,42,2,243,115,97,239,203,147,90,103,175,19,229,211,
170,192,13,56,79,79,237,160,146,89,17,143,173,218,200,128,22,32,58,149,255,0,83,
255,0,16,125,236,129,164,10,124,250,209,38,188,122,151,52,209,42,233,141,73,253,
149,141,155,85,245,49,39,243,245,123,106,176,63,79,123,52,199,217,213,64,245,
235,140,82,135,158,36,144,145,30,134,22,86,10,64,244,89,121,184,38,227,232,62,
163,241,238,167,200,121,117,191,95,94,185,215,184,106,234,133,141,90,196,38,149,
77,55,45,96,73,146,224,221,141,191,31,79,118,111,137,205,49,213,84,29,43,82,58,
110,144,131,32,211,250,116,41,185,176,26,180,248,216,114,1,28,255,0,182,250,251,
105,141,51,94,173,78,61,40,40,161,147,237,102,146,36,147,201,12,144,56,146,25,4,
107,26,232,144,202,183,117,118,102,153,0,0,139,91,219,139,168,119,82,135,170,53,
9,161,24,233,246,158,211,99,214,89,163,70,13,35,199,19,211,249,36,213,106,84,
38,53,121,29,189,39,73,12,7,0,251,120,101,51,211,45,135,199,248,62,126,131,165,
38,23,113,24,191,137,226,37,101,137,31,19,235,212,110,222,170,138,57,69,52,8,
21,204,207,25,212,204,13,149,65,226,220,251,113,37,3,196,140,154,18,163,252,35,
166,94,42,136,228,244,110,63,183,252,60,58,91,97,103,254,39,150,170,174,80,240,
83,44,180,236,232,8,212,116,83,75,13,56,8,182,214,195,65,99,248,187,27,123,113,
51,172,160,224,124,255,0,203,210,121,0,141,105,170,167,63,234,254,127,159,66,4,
114,201,54,71,34,92,178,42,201,120,221,108,75,120,213,13,153,151,128,165,152,
219,243,237,209,220,31,53,62,180,255,0,87,14,147,138,42,169,2,164,143,246,58,
110,72,82,92,172,180,70,98,34,164,2,21,152,70,68,38,174,121,18,165,228,100,50,
122,139,86,0,214,6,195,72,184,191,30,237,165,104,86,189,180,165,122,245,105,70,
166,79,237,255,0,85,58,255,208,209,14,9,18,88,124,82,46,145,68,166,72,216,179,
90,123,200,172,98,127,171,27,16,45,254,22,247,117,210,199,133,15,77,126,94,125,
43,240,185,23,74,82,35,140,254,217,156,155,130,236,85,84,49,114,202,1,32,45,
173,192,181,136,247,160,104,104,91,166,228,67,81,65,210,209,222,121,180,85,199,
20,50,34,227,165,90,148,0,71,35,9,149,99,88,245,67,166,122,152,68,146,216,19,
123,15,175,30,253,83,168,144,120,127,197,127,151,170,80,0,5,58,64,100,35,106,24,
68,109,11,17,51,199,40,152,68,2,147,165,131,46,141,60,219,200,46,72,211,99,123,
243,238,160,144,164,87,207,167,184,145,158,3,166,207,248,21,80,138,177,25,66,80,
214,183,138,120,68,224,85,8,94,75,44,105,34,152,166,12,164,139,17,162,195,131,
111,118,197,43,242,255,0,87,250,190,222,183,64,42,61,78,122,111,72,241,229,17,
43,166,48,75,53,41,213,21,50,190,144,99,46,212,242,84,36,170,85,201,32,179,178,
131,113,199,13,239,202,71,226,254,95,46,188,107,64,71,149,122,99,169,209,44,190,
138,135,144,37,196,76,228,93,83,212,116,185,224,128,57,176,252,3,253,125,212,
146,114,14,58,184,249,142,162,171,178,130,200,16,41,63,164,155,19,245,11,117,81,
244,252,157,95,95,126,251,122,245,9,20,60,122,117,166,47,26,249,188,161,18,202,
224,16,61,115,194,11,52,30,59,122,224,148,218,228,93,71,26,190,163,221,192,170,
212,182,63,202,58,208,206,58,227,80,96,150,56,170,20,75,230,212,124,233,170,54,
68,111,65,135,194,75,25,133,56,75,223,240,13,128,247,230,0,128,212,35,253,94,
95,46,189,90,113,255,0,87,243,235,156,178,56,105,24,163,51,52,145,145,36,172,
100,115,14,130,190,49,43,128,71,35,233,197,191,214,247,167,36,147,140,255,0,62,
169,199,206,184,235,173,78,208,88,55,140,5,109,72,139,109,90,108,224,159,85,136,
107,159,199,215,222,137,60,79,250,191,213,235,215,171,159,151,76,210,163,147,96,
1,82,220,113,113,123,113,127,240,247,161,138,19,213,135,15,203,172,4,20,4,48,
6,247,28,143,167,211,159,173,128,254,158,220,10,172,67,14,31,234,255,0,81,235,
108,106,41,92,117,229,54,112,65,58,174,88,92,216,158,56,63,158,5,191,219,251,
213,74,185,198,62,93,104,141,32,145,195,169,241,50,223,204,27,215,26,171,46,143,
74,163,41,93,12,84,147,244,39,241,249,62,220,92,22,206,120,245,162,1,168,63,9,
235,60,69,139,21,190,165,105,100,211,114,73,185,85,34,252,114,183,35,221,151,
237,243,234,166,153,198,64,30,94,93,63,164,164,172,138,138,139,171,66,17,166,
228,21,2,50,193,184,26,121,231,252,125,171,201,6,148,233,42,174,65,201,243,227,
254,172,255,0,147,168,242,65,15,134,48,177,18,12,140,82,95,64,58,1,145,71,54,
185,33,143,213,172,109,254,195,219,108,160,0,41,142,183,83,170,186,190,93,54,
201,77,160,73,195,49,2,38,91,1,250,201,58,131,19,102,3,73,252,94,254,217,3,141,
79,79,33,224,73,227,94,165,139,211,211,74,202,8,145,227,138,33,228,185,6,41,90,
70,46,29,173,98,20,250,127,36,131,237,181,195,49,167,127,249,250,181,1,35,56,
201,199,203,174,233,227,129,204,82,44,204,178,222,49,165,137,84,155,247,226,2,
46,8,47,168,146,79,248,15,110,10,84,87,143,77,177,111,212,4,118,143,229,214,90,
233,103,51,78,202,241,135,122,186,149,12,3,216,160,118,30,48,207,112,144,34,112,
163,253,111,123,98,217,161,243,255,0,87,229,215,162,210,66,212,86,138,63,213,
246,244,230,106,209,165,161,16,210,78,90,8,169,146,176,200,244,169,27,107,152,
141,113,136,196,98,197,52,93,152,150,54,44,120,246,224,113,219,165,125,43,211,
90,8,12,197,197,13,105,199,203,253,95,228,235,58,212,199,21,108,174,234,247,
137,154,80,178,6,98,80,184,140,17,32,86,50,198,117,155,155,88,129,249,247,109,
97,88,212,100,117,160,165,148,0,122,116,218,249,29,177,144,220,187,123,21,188,
51,21,155,119,106,230,55,94,34,143,117,110,12,30,13,51,249,108,30,218,168,200,
71,14,95,45,133,193,205,93,137,139,43,87,142,199,75,35,67,74,106,96,243,148,88,
245,168,55,246,212,247,14,176,202,98,80,210,230,131,133,113,129,95,229,211,169,
8,103,82,196,233,29,125,120,255,0,148,119,242,109,248,43,252,184,182,38,31,
179,190,60,99,179,61,147,218,61,155,177,176,211,101,254,67,118,29,68,21,187,203,
63,182,51,180,116,89,136,177,248,12,109,16,76,30,202,219,245,234,97,146,74,74,
24,204,146,50,40,154,121,180,139,19,91,168,185,16,222,201,41,145,136,170,226,
138,181,30,74,43,154,96,146,88,241,0,128,72,233,121,26,42,138,40,58,181,30,239,
238,174,169,248,227,213,59,231,189,59,183,120,97,250,255,0,171,250,211,1,85,184,
247,150,241,205,179,173,22,27,17,76,81,25,138,193,20,213,117,85,21,53,18,36,48,
83,194,146,77,81,60,137,28,106,206,192,23,230,146,40,7,140,227,60,5,5,73,39,
128,30,100,159,78,180,1,56,29,124,229,255,0,157,247,252,41,183,109,127,48,174,
142,236,127,134,63,23,58,127,119,236,254,152,221,123,143,109,75,155,238,157,235,
157,24,141,219,189,246,238,214,205,197,150,147,29,75,176,113,180,243,197,133,
219,249,234,218,106,118,116,171,175,150,165,225,140,107,138,50,197,21,181,134,
226,226,72,100,153,85,33,70,212,23,139,86,132,13,70,180,197,107,65,92,129,220,
122,211,58,168,96,50,199,29,106,103,180,233,213,242,64,9,166,129,132,5,150,69,
66,241,173,172,211,52,174,21,132,72,186,62,173,197,184,62,205,17,106,220,104,
122,71,43,209,69,104,71,250,191,111,67,150,58,151,27,174,137,229,201,79,73,55,
217,196,38,168,137,76,141,27,61,99,126,202,43,129,36,50,77,168,21,45,194,139,
159,167,181,104,139,65,159,245,87,162,233,29,148,158,208,87,203,246,116,187,49,
65,83,91,147,169,243,61,94,70,26,211,21,61,83,200,166,154,175,196,145,187,170,
72,10,181,76,145,69,112,229,143,4,139,123,125,64,248,77,73,175,31,47,246,122,
73,86,236,168,237,167,66,62,203,26,242,6,119,34,57,37,170,215,36,100,182,176,
143,173,5,216,243,250,91,129,127,167,181,105,197,73,227,210,57,248,16,56,83,163,
47,183,222,20,201,207,15,137,101,135,237,197,165,1,139,197,36,4,234,49,157,62,
48,175,113,113,201,54,255,0,15,102,1,134,146,62,125,22,21,171,143,94,185,110,
45,195,246,184,199,167,170,104,86,34,181,32,187,168,125,34,36,146,72,221,163,
148,248,200,189,239,244,63,208,31,105,164,146,138,199,203,165,49,195,86,0,3,208,
31,189,114,6,139,5,65,150,85,106,138,106,138,183,90,63,12,241,188,201,78,244,
196,196,68,106,9,137,16,41,6,227,243,111,104,218,74,198,24,228,87,165,241,69,87,
32,154,99,164,29,38,237,149,254,230,154,72,150,17,42,196,165,149,195,200,178,
68,237,34,148,123,5,70,117,110,65,250,223,222,203,224,2,58,115,194,167,159,78,
120,198,134,35,44,233,39,169,105,148,178,161,26,195,59,150,93,108,88,150,93,43,
234,183,28,123,240,165,27,214,157,108,231,72,249,244,173,165,205,70,148,109,13,
80,146,174,159,248,146,79,24,140,8,234,82,111,11,18,138,242,122,100,75,122,191,
168,252,31,126,173,41,94,21,234,133,115,232,105,210,226,13,196,204,148,83,195,
247,39,32,141,42,8,166,143,199,77,18,4,85,86,50,194,236,231,75,191,208,131,200,
228,91,219,218,187,85,135,76,105,169,96,120,16,58,31,250,231,122,73,81,144,201,
65,90,94,25,23,31,20,83,75,35,44,81,85,74,42,225,71,138,56,216,11,74,196,106,
10,164,88,15,111,196,245,215,246,116,158,104,200,209,233,94,134,45,181,184,169,
165,200,101,41,171,140,18,82,248,105,170,130,72,91,65,74,57,139,168,0,147,98,
164,126,56,191,183,163,111,136,30,29,38,145,8,210,70,15,73,108,181,67,156,238,
58,169,36,104,111,13,67,188,144,25,38,169,69,150,105,94,89,210,67,173,42,42,61,
124,40,96,220,14,109,239,213,169,52,234,252,23,60,122,71,238,170,74,51,79,157,
201,84,87,212,203,144,106,134,134,153,199,152,86,214,64,250,164,141,217,222,53,
142,1,28,250,3,165,149,221,108,23,85,175,237,183,224,77,115,213,227,108,168,3,
31,234,199,65,252,181,25,193,45,64,133,170,75,209,150,116,172,104,12,85,147,
195,104,153,140,141,228,1,99,51,27,90,66,164,3,192,35,232,154,167,80,167,167,74,
64,80,166,190,125,122,83,61,78,213,205,133,166,20,117,168,102,175,212,181,34,
74,138,58,228,154,65,143,181,68,130,25,160,146,87,213,96,154,213,117,11,184,30,
246,213,101,199,196,58,242,154,55,26,142,177,85,229,41,160,200,98,233,107,162,
153,74,37,55,222,58,183,128,227,237,143,167,142,74,41,133,59,150,40,101,151,90,
58,18,77,143,212,125,21,33,21,80,127,62,145,186,225,136,227,229,254,126,179,
193,152,163,199,227,50,105,36,211,87,26,12,147,42,154,127,20,148,198,4,4,138,
132,154,55,102,120,22,47,173,212,143,110,182,21,137,57,7,164,244,44,84,96,2,58,
143,91,159,161,150,161,163,74,157,78,144,203,81,75,226,6,121,218,74,186,106,118,
166,161,158,37,5,82,130,57,163,47,170,192,141,68,14,61,249,223,82,129,242,255,0,
87,229,214,213,72,36,211,31,234,254,125,69,163,205,213,79,76,235,94,244,138,
191,126,183,157,35,137,158,164,180,202,106,45,228,101,50,172,87,58,52,130,16,
125,56,30,217,98,72,90,145,211,161,0,174,154,215,164,62,229,138,106,168,50,89,
12,140,75,145,111,36,145,80,171,159,45,52,85,82,120,149,93,52,19,26,201,36,80,
160,44,108,223,159,123,96,74,177,57,61,93,28,35,34,174,60,250,11,41,247,21,126,
93,241,244,181,180,51,81,152,62,230,157,235,105,138,198,218,161,113,78,40,30,
187,81,7,199,24,214,80,145,169,7,178,207,17,152,209,134,105,78,141,244,170,173,
85,171,95,245,87,160,227,33,247,180,213,243,85,210,201,44,162,154,185,82,37,
150,68,158,56,158,9,212,164,193,146,64,180,244,229,215,130,44,111,249,30,222,92,
100,30,29,84,178,144,20,208,87,165,222,119,59,36,56,215,99,137,150,173,216,213,
127,9,118,66,237,3,214,211,226,234,97,89,227,80,203,246,112,74,134,204,57,43,
127,107,38,224,69,51,229,210,56,148,85,78,160,5,115,243,165,127,159,72,30,196,
147,43,148,196,226,42,114,237,136,146,147,238,37,130,162,111,27,72,76,198,222,
73,101,107,249,14,147,254,97,227,91,142,63,161,246,150,232,59,36,122,169,79,62,
159,180,40,178,72,16,181,105,195,229,208,10,216,156,141,52,244,173,84,209,101,
111,145,201,197,71,53,52,158,74,103,90,104,226,121,165,242,40,241,38,164,35,210,
61,67,79,63,81,236,184,43,41,30,98,184,167,70,173,34,178,177,90,174,5,125,122,
131,74,210,212,211,75,79,58,8,162,74,169,106,160,104,196,134,152,120,161,253,
234,118,66,236,146,200,228,15,87,5,73,185,227,221,112,69,58,219,13,44,10,154,
146,41,158,57,224,122,153,53,93,102,62,31,179,142,105,165,197,54,42,6,48,213,
153,81,41,166,121,116,197,13,75,174,152,132,35,73,113,233,228,216,134,183,189,
18,84,208,87,73,29,105,64,146,173,78,253,71,135,79,176,102,41,243,53,116,116,
50,73,25,168,143,37,29,68,130,158,41,214,69,16,193,28,116,175,67,34,184,30,5,
149,125,122,137,183,4,241,199,181,113,75,226,24,213,188,143,252,87,73,37,136,
198,178,56,248,74,211,63,206,191,62,177,109,250,100,201,67,155,169,172,146,56,
114,20,75,88,96,80,130,75,85,75,19,8,165,105,252,126,47,13,68,209,174,157,7,93,
199,22,250,251,126,14,255,0,21,157,168,192,31,158,127,103,14,154,184,99,17,129,
23,49,154,126,193,254,81,251,58,5,234,96,171,198,73,21,81,113,52,178,60,235,57,
185,118,131,199,58,25,30,237,104,188,178,72,192,169,91,146,167,145,205,253,150,
48,104,200,62,103,163,117,43,32,100,224,60,190,120,255,0,5,58,88,80,24,178,21,
85,203,35,22,152,72,42,169,181,121,37,134,41,137,13,81,83,143,103,37,168,230,
125,76,90,199,211,199,224,3,237,116,101,93,164,173,117,113,31,47,90,122,116,90,
245,141,34,42,6,154,80,250,252,131,122,142,28,122,104,203,98,36,130,90,154,153,
166,106,122,127,60,5,218,154,58,169,60,134,64,12,49,227,158,120,252,102,72,35,
98,37,37,194,243,110,56,247,233,98,161,37,142,42,56,87,62,148,251,60,255,0,103,
79,193,61,85,99,85,171,80,241,35,20,226,90,153,207,17,138,244,209,73,78,213,48,
180,116,227,92,177,215,51,61,63,166,72,225,165,134,153,214,37,15,161,93,204,178,
169,46,20,149,142,215,35,234,125,167,166,165,33,120,234,225,232,0,233,249,8,70,
5,254,29,28,125,73,57,253,131,135,175,175,151,88,234,101,169,134,33,27,70,190,
41,230,245,83,9,81,212,72,209,188,104,66,0,173,2,59,53,181,6,42,195,250,90,222,
232,218,151,20,226,120,117,229,85,98,72,99,80,56,252,188,254,223,217,214,40,5,
20,161,196,226,42,105,22,6,69,142,55,1,20,198,225,60,139,34,220,78,30,228,145,
115,192,30,244,2,144,117,80,26,112,233,198,50,3,69,36,173,120,211,249,83,203,
237,245,234,19,210,64,52,189,43,57,208,140,36,129,146,83,58,23,109,40,99,17,40,
190,161,115,107,90,222,219,100,83,66,190,94,89,255,0,39,87,14,198,161,252,248,
28,80,255,0,197,117,18,66,105,228,147,74,121,60,72,53,170,128,145,180,43,117,
157,145,92,47,152,129,112,110,56,34,255,0,79,109,156,26,83,254,43,207,237,233,
229,239,69,238,205,127,226,190,206,177,43,105,168,142,162,1,44,115,66,212,235,
12,207,98,166,77,69,132,179,94,236,179,129,107,45,185,183,244,247,64,124,193,
200,234,237,132,109,70,160,215,172,177,78,95,64,168,90,40,226,150,154,161,26,67,
79,50,191,149,92,167,220,23,95,92,117,215,28,200,188,21,225,184,247,186,214,
149,160,199,250,191,62,189,74,140,19,196,121,255,0,171,31,46,153,244,179,9,25,
79,150,202,9,102,62,171,106,32,114,111,103,54,191,182,216,128,14,175,62,157,
168,243,234,61,139,2,26,194,224,91,240,91,149,44,15,63,155,123,240,0,12,112,234,
198,181,235,148,161,86,75,165,215,157,87,39,133,189,128,225,110,20,130,61,248,
252,95,46,188,14,62,125,74,96,24,196,132,143,74,70,196,254,166,183,45,33,39,144,
167,145,254,63,225,239,68,154,80,228,129,254,175,245,113,235,85,30,93,117,86,
138,206,186,125,39,79,22,36,242,73,107,30,73,63,171,222,203,3,156,112,175,91,7,
207,167,140,67,8,225,156,9,66,232,12,204,141,109,18,5,7,90,149,35,68,134,69,54,
91,222,215,247,120,206,77,56,245,166,226,61,122,229,145,169,137,222,20,164,5,
20,211,129,56,225,85,221,80,218,209,3,100,48,196,218,15,250,198,220,123,211,82,
162,156,41,214,128,34,181,235,3,48,8,159,143,76,96,53,238,23,158,89,71,226,220,
126,15,211,222,177,231,215,129,227,212,183,100,69,130,114,174,24,191,136,21,229,
24,45,137,0,216,183,154,95,232,121,7,235,239,68,124,63,111,94,243,35,20,167,83,
106,105,132,85,83,153,102,138,53,52,169,60,50,5,154,196,201,202,133,144,164,102,
25,69,172,117,90,199,143,110,149,161,53,62,95,225,233,180,53,69,160,169,225,
211,117,70,136,138,178,223,89,129,93,181,29,101,148,233,33,137,253,45,174,231,
250,142,61,178,104,51,230,51,159,217,211,138,43,199,165,6,50,56,230,161,173,168,
146,58,168,232,35,52,203,42,196,213,122,132,206,80,205,86,105,224,70,242,170,
211,149,93,68,105,94,125,184,0,34,180,52,233,182,52,96,5,53,244,170,67,143,162,
164,167,120,149,234,99,71,170,114,140,32,138,88,41,230,72,126,221,224,166,139,
76,44,234,77,195,15,95,211,80,185,183,183,214,129,42,56,103,164,231,81,36,31,
242,245,142,166,95,60,185,58,129,79,252,63,33,93,66,41,100,40,250,130,64,5,54,
165,69,176,120,165,172,134,48,210,150,245,2,196,123,208,96,60,73,76,125,212,160,
254,89,31,51,231,215,134,52,41,122,160,207,231,159,240,116,191,216,202,94,135,
36,229,85,237,20,13,168,233,30,168,229,16,42,150,0,105,185,146,220,0,45,237,
248,130,232,149,89,251,176,127,226,254,89,233,29,209,253,72,213,112,162,163,237,
243,39,254,47,165,196,245,177,81,228,26,134,79,19,212,77,60,162,75,49,253,207,9,
149,76,112,160,255,0,82,33,39,159,232,121,227,219,165,128,212,167,137,52,227,74,
254,127,225,233,162,3,173,17,169,65,254,170,254,223,240,117,14,154,118,50,228,
170,94,158,71,69,173,164,138,38,26,203,69,43,191,220,73,35,70,136,74,187,74,130,
61,110,163,130,0,55,181,253,81,66,105,217,215,138,141,74,181,199,229,254,127,
242,245,255,209,208,242,129,148,205,62,165,186,200,163,78,146,110,192,171,57,32,
106,45,169,110,57,252,91,221,227,227,74,10,30,62,189,52,64,199,79,88,173,84,149,
211,210,201,78,147,196,190,102,167,152,179,41,141,38,86,176,17,141,66,161,16,
189,236,108,111,123,94,254,244,42,14,158,63,234,35,173,17,81,199,63,234,253,157,
46,113,89,22,130,158,88,157,229,240,203,0,142,117,140,39,146,53,137,163,149,89,
88,169,110,10,219,241,193,254,163,222,148,211,253,47,159,77,72,50,188,43,214,
90,129,79,54,49,232,234,40,217,104,203,172,212,110,245,11,84,203,37,85,54,137,
8,153,69,236,239,29,217,127,22,230,214,191,191,83,180,159,67,215,170,86,65,
156,211,63,183,164,100,244,243,209,84,72,241,204,76,79,4,146,67,60,82,60,108,
174,81,150,41,18,102,80,37,86,12,202,172,5,136,36,127,143,182,253,113,211,224,
134,234,19,211,172,212,51,67,2,42,85,211,199,247,50,8,208,74,213,50,18,177,10,
117,169,144,234,44,85,252,154,84,159,233,199,187,138,84,122,245,238,39,229,251,
41,210,97,169,223,232,202,98,241,179,121,22,69,107,146,162,48,65,4,44,132,6,7,
139,11,123,216,7,61,123,86,40,122,155,5,42,205,168,194,140,210,132,102,63,65,25,
77,32,157,33,128,11,114,56,183,251,199,187,96,158,223,242,127,170,191,225,235,
76,212,205,105,211,107,201,33,213,78,14,152,213,217,169,193,102,211,121,237,
172,47,26,180,201,226,23,22,252,123,208,161,20,243,31,225,61,88,82,149,235,45,
75,146,208,36,128,36,145,36,49,48,17,152,209,144,42,129,111,245,107,96,8,111,
200,247,166,165,115,214,142,107,94,29,117,33,32,242,8,1,133,128,183,250,163,168,
142,127,87,208,131,199,211,222,137,174,72,207,85,175,3,78,185,177,82,138,86,231,
212,160,175,244,12,64,36,240,111,201,63,159,175,189,154,149,95,79,245,127,171,
231,215,134,42,79,30,186,8,174,30,192,29,18,92,27,88,233,181,249,183,211,79,189,
254,34,7,3,254,30,172,43,74,122,142,176,73,18,106,36,129,227,38,206,7,0,88,221,
126,188,128,72,247,96,148,161,53,6,188,120,255,0,171,254,47,175,12,215,29,55,72,
163,85,129,212,69,205,194,144,25,69,136,97,253,52,131,254,199,222,227,4,119,17,
215,168,104,41,215,36,103,81,96,52,169,26,120,31,168,18,8,227,144,86,252,219,
222,215,226,111,63,245,103,173,10,240,242,175,82,97,4,250,193,96,7,144,6,0,128,
203,97,112,5,201,96,127,63,155,123,186,175,151,159,249,58,171,231,210,132,142,
157,105,228,127,84,118,187,5,104,207,32,2,128,155,21,35,233,192,23,31,95,111,41,
226,190,125,87,180,209,141,116,142,156,117,171,24,16,190,148,208,183,54,176,186,
177,22,10,7,54,11,244,252,31,175,183,106,184,21,197,58,111,20,102,11,221,94,186,
158,153,33,130,110,24,134,228,18,164,186,88,198,125,92,222,53,0,253,121,6,254,
216,148,5,174,79,219,254,126,189,29,106,181,225,255,0,23,215,57,238,49,208,17,
28,73,173,84,0,5,219,84,101,159,200,53,91,88,116,54,60,216,30,61,182,8,211,218,
41,254,174,63,103,86,20,18,26,241,173,127,216,235,5,44,43,18,207,231,30,132,
120,20,70,160,175,147,203,123,77,166,196,161,140,243,192,55,250,123,240,175,19,
195,29,106,66,77,2,241,206,127,201,215,9,169,204,207,40,139,209,31,146,87,253,
201,52,170,211,216,200,140,82,192,132,191,211,235,253,61,238,149,38,135,29,81,
91,77,13,123,135,203,137,255,0,63,88,165,75,207,79,42,13,105,37,45,52,110,147,
197,25,155,152,194,191,136,189,209,89,215,232,223,234,79,62,245,76,131,138,116,
226,183,99,6,52,32,158,21,167,231,249,244,106,62,24,124,58,239,95,230,11,242,51,
99,252,89,248,227,183,198,107,176,119,114,100,100,21,121,236,140,88,236,14,208,
219,88,112,107,115,251,151,114,101,82,23,251,93,187,132,161,5,220,44,111,43,200,
201,20,40,242,72,168,201,238,110,86,20,94,214,103,38,138,184,169,57,52,28,5,41,
82,73,192,0,158,156,138,18,88,177,43,82,106,105,195,237,167,151,249,122,250,
105,127,45,15,248,76,127,192,95,129,53,187,59,180,183,238,22,163,229,23,200,204,
22,35,29,36,219,211,180,169,168,114,29,123,182,55,98,199,28,185,12,191,94,117,
180,148,135,19,66,244,245,101,150,138,171,38,114,21,176,198,170,232,209,74,73,8,
252,9,38,161,188,147,80,254,1,240,126,126,111,79,159,105,227,167,133,20,212,47,
192,63,63,63,246,58,180,111,230,145,219,125,189,241,255,0,249,118,124,188,237,
159,143,120,92,198,83,183,246,31,71,110,236,143,94,211,109,172,75,229,242,152,
156,185,163,90,5,220,52,56,154,101,50,212,46,210,162,170,147,36,203,26,146,145,
210,22,0,233,247,171,211,225,219,105,83,165,11,42,146,49,165,75,0,198,190,84,90,
231,203,143,94,95,138,188,79,249,122,249,6,246,111,243,31,249,231,242,7,227,181,
23,197,222,232,249,63,218,93,159,209,216,205,235,39,96,38,214,223,123,146,108,
253,76,187,133,5,84,145,73,149,220,185,37,159,115,102,177,212,115,214,77,53,53,
29,93,92,244,180,243,200,94,36,82,5,158,142,194,222,54,15,26,82,153,2,167,72,
60,9,3,128,36,98,191,51,234,106,219,206,126,22,53,39,162,125,140,154,20,50,202,
154,136,154,47,13,167,33,75,17,36,79,205,137,0,172,81,216,3,111,107,146,156,77,
104,71,76,72,42,41,95,63,46,132,125,187,67,41,171,154,161,80,201,18,227,106,165,
166,11,58,42,149,168,166,241,74,146,5,183,145,85,101,32,131,97,254,219,219,225,
14,170,143,134,157,33,149,198,154,86,135,80,175,237,175,67,94,54,144,214,237,
204,52,113,188,145,181,77,85,117,61,100,205,14,129,71,28,40,174,181,243,18,190,
105,224,84,176,22,178,175,36,95,218,228,77,80,45,60,201,4,250,124,250,46,121,52,
207,42,182,64,2,159,63,151,79,24,182,175,200,80,211,75,144,130,158,166,154,10,
170,138,56,219,67,9,235,105,100,210,169,83,48,139,72,72,201,140,122,184,44,108,
77,189,220,35,186,70,236,6,145,143,153,233,183,41,27,176,13,147,159,176,255,0,
171,203,165,246,205,168,116,200,77,23,161,145,116,104,121,100,102,96,34,186,161,
34,193,213,202,139,2,223,235,123,124,6,165,126,93,50,228,53,42,120,244,106,246,
131,165,76,185,66,178,200,242,189,60,108,10,50,40,70,50,0,232,200,223,82,196,94,
195,241,237,212,122,171,208,249,244,142,72,202,148,52,233,179,112,68,34,139,49,
10,210,197,94,210,65,48,209,56,191,140,180,37,26,162,156,6,186,203,18,130,202,
79,10,195,219,18,51,31,17,72,174,58,85,24,254,204,215,207,162,251,186,160,165,
108,94,10,157,222,186,97,69,89,83,42,136,85,132,21,50,201,18,133,73,166,212,214,
148,45,197,207,167,253,143,180,159,129,126,222,150,45,106,212,165,41,208,95,186,
169,229,70,74,236,124,34,16,178,169,43,35,159,40,89,180,168,146,116,75,249,35,
128,185,26,255,0,87,28,143,123,148,159,35,231,211,209,83,225,111,78,150,59,86,
168,79,21,50,176,30,106,136,150,53,43,27,178,106,13,227,184,191,169,146,223,147,
244,191,211,221,209,170,56,228,142,153,144,80,252,129,232,67,143,19,45,109,60,
177,192,101,20,244,181,138,241,171,160,107,207,79,78,255,0,112,140,194,77,74,
161,81,136,60,88,123,184,206,60,186,110,160,26,244,174,154,142,182,26,24,234,
158,159,204,42,210,154,88,100,6,54,89,20,185,46,241,58,204,26,30,1,86,212,171,
168,130,0,191,183,148,29,0,124,250,103,1,143,150,15,79,248,10,186,186,202,217,
222,138,146,71,141,149,103,146,140,249,11,66,209,84,34,35,149,144,137,98,137,
199,209,172,77,190,190,223,64,6,162,56,116,211,214,139,92,142,134,141,187,85,88,
181,175,13,162,136,86,208,212,66,176,204,26,49,31,166,203,30,165,98,201,165,199,
31,131,249,247,101,174,172,240,233,151,3,72,20,224,122,143,153,155,53,37,117,
28,148,254,77,126,40,41,169,173,80,212,226,122,185,221,98,133,244,23,189,163,
103,5,92,159,81,0,251,216,226,115,158,171,138,15,225,235,25,174,220,6,175,46,36,
230,179,29,83,247,21,245,19,232,146,57,223,24,168,77,99,161,146,194,116,65,102,
75,129,254,183,189,85,137,62,190,125,95,74,80,1,90,30,29,38,164,200,190,100,54,
122,158,182,178,41,38,201,195,89,246,106,25,90,85,154,79,242,147,2,22,96,200,
161,69,208,150,66,15,180,204,218,157,88,55,74,85,10,173,10,227,253,92,122,203,
180,115,24,124,62,103,112,87,110,234,6,202,81,133,175,130,174,142,154,120,254,
234,105,107,166,100,138,83,91,121,34,166,100,142,164,106,69,67,164,167,248,123,
210,184,86,45,38,105,254,94,180,232,206,138,19,4,244,157,223,106,152,108,221,76,
120,217,7,217,69,13,26,209,33,136,172,181,52,21,113,192,35,158,66,246,17,84,37,
204,99,73,55,228,233,23,246,165,15,144,56,29,37,96,104,106,56,255,0,135,164,86,
46,166,162,182,44,198,2,29,21,25,36,174,251,122,58,106,116,111,179,139,25,94,
60,66,73,174,232,197,105,231,156,46,145,114,24,155,251,116,29,90,144,30,234,
254,84,233,178,186,74,202,107,166,159,157,126,93,50,60,245,84,59,146,130,41,18,
166,186,162,25,165,164,201,152,166,240,42,253,156,66,36,89,76,226,21,134,8,144,
220,41,39,159,117,161,83,167,143,145,234,195,42,90,180,7,135,231,210,170,130,
178,8,105,241,180,245,34,72,210,175,40,245,49,212,200,209,77,60,40,243,189,27,
72,52,184,84,134,156,190,166,250,249,8,226,195,159,126,20,164,96,249,245,83,90,
201,79,33,229,195,172,114,100,113,107,67,145,120,158,169,167,166,100,142,153,28,
44,52,115,72,178,75,4,147,198,140,89,9,152,217,245,49,22,252,95,219,189,186,77,
43,94,169,71,212,3,82,135,160,110,42,26,106,170,140,141,108,79,28,114,82,85,67,
28,179,67,43,5,168,114,237,36,211,152,4,129,9,144,70,81,221,79,169,79,248,223,
217,84,170,4,172,71,70,241,57,49,40,60,105,255,0,21,210,39,111,203,84,217,28,
164,50,178,7,200,206,94,54,104,73,198,67,17,168,145,16,78,197,139,36,106,38,58,
111,170,223,227,237,69,181,77,71,155,126,192,62,125,55,116,112,167,200,126,211,
246,116,185,171,2,191,108,98,234,225,45,85,166,176,193,83,166,81,10,189,77,21,
60,84,234,204,93,148,136,41,17,192,176,31,94,121,7,218,210,186,211,80,206,115,
249,127,147,164,65,244,74,202,196,46,49,231,131,254,83,235,210,71,123,211,86,
193,29,14,46,188,199,12,112,67,85,93,88,240,206,178,71,229,19,44,81,149,69,111,
172,124,50,125,73,60,216,15,108,93,33,5,85,142,64,233,77,171,173,11,168,226,104,
49,254,174,61,5,248,108,118,236,222,59,154,131,106,236,13,167,188,55,222,227,
201,79,86,48,219,51,103,96,178,57,236,157,66,205,28,16,200,40,48,248,106,90,234,
153,36,41,39,145,220,41,227,147,107,95,217,61,213,196,86,233,174,73,52,173,120,
146,0,232,222,24,26,82,104,42,212,252,250,8,183,94,43,123,236,93,207,91,182,183,
142,222,207,108,125,195,137,171,170,166,204,237,237,205,137,202,97,179,248,186,
153,35,80,19,47,136,201,211,211,86,208,203,52,22,250,198,53,41,191,211,218,88,
167,89,80,60,78,25,15,152,53,31,203,165,109,8,64,200,224,234,199,151,250,188,
250,104,139,37,91,45,11,210,26,230,213,145,66,174,178,133,241,24,168,165,144,
164,114,74,91,92,43,227,103,91,11,220,27,91,159,119,169,33,115,147,254,78,172,
177,168,102,109,61,163,252,190,157,115,197,230,234,201,142,74,25,169,162,158,
157,230,16,199,50,51,169,135,196,97,151,67,42,221,166,142,54,98,138,214,36,123,
242,72,67,118,210,189,106,72,6,146,174,14,159,245,83,167,40,115,210,99,22,42,
232,161,104,76,25,42,138,122,136,76,114,10,74,161,76,96,34,156,173,155,238,60,
81,76,126,163,211,168,127,175,237,245,155,195,163,40,32,131,159,67,211,38,220,
72,12,100,241,24,62,98,191,224,225,210,43,112,84,203,61,108,239,118,70,118,145,
101,70,37,89,227,18,43,194,37,85,58,16,24,202,242,46,190,145,244,3,219,50,146,
196,208,154,244,252,42,130,128,175,15,245,87,253,89,234,70,54,182,117,172,167,
242,60,230,58,134,79,23,141,145,100,50,75,165,52,121,73,84,136,158,64,55,183,28,
253,125,186,140,85,148,158,29,51,44,74,99,106,80,17,229,229,251,58,88,99,178,
139,50,78,213,114,23,158,150,105,94,157,139,106,66,91,196,172,230,22,244,121,61,
34,252,144,215,250,113,237,108,82,106,29,237,144,113,233,251,58,69,44,69,8,10,
59,88,103,254,47,229,212,169,34,124,102,66,174,102,138,25,97,105,86,178,74,229,
40,42,225,154,160,75,35,83,160,97,28,102,10,131,39,168,13,86,191,60,123,187,3,
27,185,32,105,227,95,63,94,155,86,18,34,40,98,8,20,167,149,7,159,218,63,152,
233,170,74,36,175,194,229,166,164,145,35,150,157,35,103,166,69,8,76,62,85,98,80,
22,43,37,48,145,73,101,189,211,234,46,61,176,99,89,35,114,188,64,225,242,227,
251,58,124,57,142,104,131,140,31,63,203,252,52,253,189,32,4,75,44,42,234,195,
238,97,9,251,82,16,129,91,88,85,100,6,202,85,109,127,173,205,255,0,30,209,83,82,
212,252,67,163,50,74,185,5,127,76,154,212,125,159,225,235,24,175,158,23,140,77,
44,133,78,189,44,143,103,136,177,245,8,220,135,120,216,127,81,245,7,221,75,21,
160,61,108,34,61,74,40,4,127,63,243,244,226,146,209,75,58,154,128,18,141,160,
120,21,150,69,105,207,147,88,119,102,177,9,25,47,207,32,147,111,199,189,157,53,
169,166,154,83,166,192,117,194,215,93,120,127,171,137,235,203,71,45,85,66,37,52,
79,49,74,202,102,242,192,81,34,0,254,221,49,168,121,91,247,103,97,25,3,253,111,
109,145,168,133,243,168,225,252,186,115,86,149,36,154,84,31,219,196,211,208,117,
11,32,94,74,138,164,168,82,42,47,49,146,52,153,93,33,168,150,71,50,105,17,234,
143,81,31,85,4,143,85,191,214,171,19,168,249,30,156,66,40,163,138,249,99,203,
253,95,159,77,203,77,36,40,238,200,238,178,70,64,146,43,148,184,32,217,141,142,
144,183,177,189,189,208,138,131,211,212,29,69,58,85,88,21,12,26,69,228,125,64,
81,114,7,60,3,127,247,143,117,25,90,211,63,234,227,214,197,64,167,92,158,53,12,
71,246,95,75,63,167,232,20,6,3,139,2,109,199,251,31,126,106,31,60,255,0,171,
135,94,242,56,235,9,36,200,143,111,65,42,91,72,54,93,102,224,115,245,1,71,251,
31,117,6,149,212,222,127,241,125,104,121,158,185,176,103,159,194,69,216,20,140,
0,69,205,194,139,144,109,126,7,187,126,45,32,12,30,182,6,58,118,131,246,124,
136,186,181,92,216,130,127,73,75,49,34,220,19,253,111,99,238,202,64,61,163,173,
87,246,245,138,75,121,227,80,0,93,37,85,108,116,131,96,71,36,139,114,127,227,
126,252,126,124,122,245,43,94,167,56,86,140,68,89,132,58,67,72,79,167,214,85,
172,161,207,5,206,158,63,216,219,223,137,225,215,189,123,69,122,145,89,30,170,
188,108,48,243,92,85,42,88,76,209,197,12,237,57,19,197,40,62,70,4,204,10,242,
218,79,248,15,123,34,165,5,59,186,168,52,87,175,193,195,253,88,255,0,63,83,50,
76,32,202,213,253,244,6,49,12,49,151,129,100,242,34,76,121,49,33,132,55,26,216,
95,146,56,250,251,117,207,121,212,60,190,222,169,29,124,52,42,107,83,252,186,
108,168,138,173,170,227,240,132,157,254,218,8,163,26,111,230,142,84,185,97,112,
169,26,169,244,216,30,62,183,62,211,182,173,74,195,228,58,113,72,10,75,26,15,62,
159,41,105,89,98,158,142,161,254,221,93,124,13,95,67,36,140,210,172,192,186,81,
83,234,31,230,80,196,193,135,234,98,44,72,30,238,1,210,80,159,207,170,150,4,
169,2,164,249,31,240,244,162,106,202,6,198,209,205,88,200,186,161,168,142,60,
117,36,76,95,90,36,17,83,201,61,64,1,1,155,70,160,159,85,82,69,253,188,140,2,13,
71,242,29,50,225,181,149,21,57,25,62,189,97,199,71,36,143,35,76,161,94,106,89,
223,64,4,178,40,9,164,53,137,32,88,14,73,191,251,31,126,85,13,90,240,161,233,
183,195,130,50,1,255,0,87,236,255,0,55,66,70,199,200,67,74,38,212,166,65,6,62,
106,185,145,74,176,102,167,148,206,3,163,14,116,136,199,164,243,200,62,212,67,
37,26,65,74,141,36,83,207,215,164,183,32,149,82,78,75,80,126,120,254,125,57,83,
196,245,121,138,108,179,16,210,199,73,85,80,176,33,9,102,201,37,83,77,49,66,9,
125,6,115,253,108,15,189,175,115,150,243,0,245,227,164,70,99,211,218,79,248,41,
233,198,180,234,13,14,117,4,185,218,56,83,82,182,91,19,45,92,223,115,28,116,72,
247,168,84,32,55,249,250,38,145,99,45,102,225,244,255,0,66,13,67,246,181,41,199,
39,171,52,102,177,177,99,192,211,57,255,0,139,227,215,255,210,208,159,83,29,49,
175,173,132,129,4,133,5,147,89,210,133,64,250,122,152,127,143,30,253,233,213,8,
200,245,233,64,102,169,138,166,148,65,230,30,52,8,159,85,81,43,89,100,99,99,171,
73,86,255,0,95,142,45,238,255,0,137,114,125,58,215,105,20,62,125,40,233,234,
196,145,84,154,114,234,226,25,25,180,129,119,72,227,88,181,49,45,123,57,23,210,
45,113,111,116,35,56,225,213,72,21,21,200,255,0,7,82,177,185,170,120,232,198,
54,183,207,37,28,57,10,57,162,84,41,31,239,5,116,173,138,57,153,92,67,53,77,48,
210,165,131,46,175,175,62,246,14,41,243,234,172,132,157,66,149,211,211,150,70,
142,20,129,25,235,150,90,122,184,169,146,151,76,76,238,52,72,206,105,163,45,118,
15,72,16,172,186,116,216,241,110,125,232,211,73,52,197,49,214,149,178,49,144,
77,115,254,30,145,85,145,44,111,89,120,217,105,228,149,37,166,88,80,5,53,30,
105,19,204,172,161,124,81,16,62,158,146,47,111,122,249,244,232,224,5,115,211,21,
75,191,154,81,33,107,146,224,144,204,126,182,102,55,114,88,169,60,242,127,62,
237,90,214,167,183,252,189,120,10,5,167,92,41,166,157,100,186,134,186,162,179,
114,74,128,111,111,163,6,210,66,253,61,236,26,10,255,0,179,246,253,157,108,142,
53,235,28,202,203,234,149,154,104,100,152,56,210,86,34,174,65,102,40,91,81,142,
228,129,200,252,123,245,61,120,117,179,74,2,58,198,193,163,52,238,210,137,53,54,
160,204,165,198,161,24,43,245,32,232,69,54,35,240,71,211,222,168,69,9,56,255,0,
7,203,173,30,12,58,237,166,102,210,74,146,186,98,242,59,35,42,151,119,101,212,
57,44,7,244,254,190,245,231,90,228,245,173,62,135,167,20,166,142,56,21,203,218,
71,33,66,139,182,155,57,184,60,139,254,57,23,183,251,127,118,210,74,175,231,
213,115,90,121,117,2,53,211,60,138,84,232,58,15,214,246,12,46,91,241,123,15,122,
86,43,192,227,211,173,241,166,122,147,165,35,144,240,74,7,191,171,253,73,184,0,
253,69,237,237,202,112,36,246,252,191,105,235,199,225,35,168,230,152,22,37,9,96,
160,144,191,82,192,0,126,166,228,173,184,31,79,118,81,66,105,195,173,86,148,175,
80,52,184,64,0,30,162,169,202,223,73,45,114,154,129,178,255,0,175,238,212,57,
234,196,142,29,72,167,69,68,212,165,148,151,120,205,253,75,233,69,212,81,126,
183,177,63,211,221,192,233,167,62,71,229,212,232,160,123,196,202,21,84,249,21,
77,239,117,213,171,85,193,45,194,183,251,127,123,208,113,81,78,180,90,161,184,
212,83,167,196,137,30,84,118,66,241,5,9,101,176,47,32,212,222,80,194,227,146,
215,55,28,251,120,210,170,63,15,250,179,211,85,26,74,240,35,253,95,234,244,234,
99,137,148,87,157,94,104,163,73,84,232,140,48,144,50,71,101,98,196,31,29,184,0,
115,127,240,247,226,15,117,13,105,214,205,63,79,215,31,150,122,235,42,242,205,6,
26,137,98,138,15,5,28,84,200,37,136,174,147,56,105,4,77,43,22,180,198,84,126,
62,156,241,111,116,117,20,141,84,1,143,245,127,197,117,168,192,13,35,214,181,
62,95,225,255,0,87,217,215,42,10,83,80,249,40,228,30,10,207,183,199,172,81,212,
151,137,36,142,41,132,115,152,100,102,244,200,14,144,9,225,69,207,186,34,154,48,
63,23,249,43,156,245,230,160,210,56,173,73,199,242,255,0,103,135,88,218,150,52,
155,49,36,193,79,218,75,60,49,6,148,72,178,187,59,218,204,130,210,163,71,114,
191,131,97,239,101,104,92,250,127,171,254,43,170,235,37,97,11,230,63,213,254,99,
210,98,190,118,89,99,133,53,187,198,97,134,20,85,187,146,170,177,170,40,85,187,
18,71,164,11,147,237,134,106,86,167,135,79,198,181,7,212,254,117,235,234,55,
255,0,9,84,254,88,141,240,243,225,165,71,201,206,224,235,169,182,207,201,95,148,
213,50,102,86,77,205,140,146,147,119,108,254,144,166,146,3,178,54,203,83,215,83,
195,93,132,254,244,77,11,230,170,224,33,94,85,154,148,73,204,74,170,87,5,46,39,
146,232,230,49,219,31,165,63,19,15,244,199,0,249,170,138,96,154,172,248,85,87,
207,207,173,170,189,173,234,189,70,172,164,167,175,164,170,161,171,138,57,233,
43,105,167,164,170,130,104,227,150,25,169,234,34,104,103,138,88,166,87,138,88,
228,141,200,101,101,42,192,216,130,61,213,212,58,58,55,194,65,7,243,235,96,208,
131,215,195,243,249,135,237,174,170,235,159,158,63,48,118,79,74,71,175,170,246,
183,200,30,207,192,236,133,121,210,166,56,113,116,27,158,190,150,74,116,48,164,
112,53,61,61,90,74,144,133,80,168,138,160,0,7,182,54,215,99,101,110,88,215,183,
4,241,35,240,147,243,43,67,213,38,90,200,104,122,177,31,153,31,42,255,0,148,
103,200,191,130,93,47,71,208,223,12,247,103,199,143,230,17,181,166,218,123,99,
177,179,59,42,76,126,35,167,183,38,7,11,138,164,166,221,123,199,41,29,37,123,81,
238,108,150,231,150,128,53,44,43,139,199,86,209,84,212,202,242,205,50,15,220,
106,202,222,250,25,145,30,102,104,234,117,18,213,12,63,13,1,21,86,6,149,161,11,
74,241,36,83,211,60,58,9,160,7,20,251,122,168,205,182,98,104,234,42,24,24,146,
68,130,129,209,125,49,90,162,109,100,166,176,6,181,134,152,151,176,23,39,217,
240,1,168,105,199,31,234,253,157,20,204,9,33,107,90,18,127,103,252,95,67,213,4,
238,152,28,118,59,33,58,94,154,134,169,228,84,148,195,58,81,207,43,199,79,29,
209,181,181,163,132,130,88,250,149,248,250,123,52,81,166,0,174,112,1,63,145,225,
209,43,255,0,110,238,131,204,124,242,56,244,235,181,178,245,77,132,156,127,145,
84,35,253,211,127,154,145,74,83,144,35,134,158,57,94,77,101,9,3,79,31,155,243,
237,248,201,240,79,3,254,111,78,155,153,87,198,31,16,253,156,125,122,231,183,
178,65,107,69,90,211,154,52,200,201,224,167,129,229,225,32,135,90,201,42,53,216,
184,44,183,7,234,61,212,31,133,138,208,31,240,116,227,138,246,134,169,92,244,
105,54,206,124,81,87,87,248,227,45,18,199,141,71,101,188,170,165,180,43,76,140,
46,20,31,235,253,13,189,178,79,134,100,167,153,235,100,7,84,233,105,84,134,185,
235,50,20,109,21,195,84,192,68,143,24,91,77,79,165,84,150,212,81,77,175,112,56,
191,187,54,123,135,18,58,170,146,0,83,234,58,13,39,197,80,62,18,154,99,38,163,
68,245,17,152,126,231,202,141,84,238,210,24,144,133,79,36,81,254,160,196,155,
251,105,81,124,48,79,151,74,53,17,37,41,138,116,3,231,141,115,193,146,147,193,
79,37,37,27,71,69,82,233,4,132,151,169,253,200,161,141,181,13,102,70,36,63,244,
250,223,219,44,9,169,166,7,74,35,0,208,106,53,255,0,55,89,240,204,75,8,150,127,
183,49,78,246,8,164,52,1,156,49,118,177,213,160,1,192,250,88,123,220,103,200,
245,70,4,83,30,93,8,177,84,24,169,37,166,75,171,26,177,36,193,157,136,49,202,
135,76,250,185,144,137,89,245,15,173,193,250,91,219,192,81,105,79,62,154,53,173,
124,169,208,153,71,143,171,254,25,81,166,145,42,98,172,134,24,167,1,130,68,39,
137,82,79,44,158,181,156,52,72,65,91,113,127,245,253,168,3,3,208,244,193,35,86,
159,62,133,236,20,21,143,156,166,146,104,177,147,75,252,42,145,82,174,150,38,
130,84,138,104,209,146,25,153,89,90,80,2,139,131,253,174,111,237,240,120,244,
154,79,225,232,67,198,97,26,74,218,217,228,146,156,10,71,81,61,52,138,68,147,
203,81,229,138,10,117,147,254,12,121,58,141,193,250,11,123,218,241,207,77,182,
86,158,103,169,219,167,11,21,54,107,21,29,109,52,112,153,163,160,157,105,106,
131,5,165,165,100,95,72,150,29,99,196,142,6,155,141,75,112,61,220,140,212,117,
85,56,20,61,34,51,24,202,185,223,117,165,61,48,161,142,162,169,164,16,188,178,
112,178,133,183,238,54,167,144,76,24,17,114,85,174,47,127,109,178,229,169,233,
211,138,223,1,242,7,164,197,29,61,93,13,45,47,222,200,212,171,4,242,82,208,77,
17,5,225,114,170,39,251,160,163,210,22,192,43,90,195,87,250,254,211,0,86,69,
213,195,203,165,68,134,92,30,131,124,245,48,193,197,145,166,169,199,81,203,36,
185,25,234,26,162,150,190,21,21,139,12,239,84,241,170,202,205,170,171,77,221,
156,122,91,232,7,215,219,46,10,179,10,102,189,62,164,48,90,30,167,87,101,240,
249,68,167,170,169,154,186,73,18,49,148,196,60,166,153,70,58,52,162,130,9,41,
124,102,55,130,106,54,145,84,91,235,115,171,252,125,191,3,173,90,164,158,4,116,
150,120,152,105,56,167,3,243,232,25,164,206,154,217,50,53,177,214,65,21,66,212,
175,141,233,198,131,60,242,183,238,53,67,221,108,145,58,134,80,164,13,92,219,
219,186,195,18,65,165,15,77,152,180,133,26,124,188,250,111,207,110,136,105,229,
164,72,42,103,101,135,32,147,87,138,214,21,47,95,33,14,37,150,98,177,6,146,34,
84,216,106,177,4,92,31,126,105,2,246,134,60,122,218,68,198,164,168,173,49,79,
46,184,211,100,158,178,162,9,82,84,136,195,94,235,20,138,94,81,166,115,175,198,
209,150,42,138,3,232,32,0,53,27,219,221,3,106,101,167,145,234,229,116,171,212,
100,244,167,149,41,26,138,177,132,181,135,207,85,69,79,12,79,60,50,164,102,25,
181,204,181,49,120,192,141,11,63,160,218,254,213,143,134,185,227,79,248,190,146,
213,181,154,129,129,210,127,20,127,103,39,82,195,246,231,145,161,142,88,149,66,
145,26,149,183,140,40,253,191,87,54,177,22,246,195,199,171,89,243,245,233,244,
114,186,69,113,254,126,147,180,52,144,82,166,76,180,128,193,78,244,18,134,152,
176,87,138,57,92,180,50,5,185,43,41,32,15,173,136,252,123,221,176,237,53,224,58,
245,201,171,165,6,77,122,157,142,173,124,46,55,105,82,82,164,51,82,212,228,243,
211,154,42,195,230,241,75,52,240,69,11,84,84,178,141,48,192,173,126,79,208,242,
15,215,218,168,207,132,32,2,154,73,56,57,243,245,233,52,160,74,211,150,248,128,
92,255,0,152,124,250,67,246,205,52,205,158,154,162,134,52,142,26,249,234,222,
18,149,139,224,137,85,191,112,71,168,189,144,75,31,160,139,88,113,237,53,232,
38,118,32,96,244,182,193,135,130,138,220,64,244,232,205,255,0,46,127,230,57,
222,31,202,211,228,173,119,200,62,157,218,27,7,177,170,119,62,213,159,96,110,
205,173,191,241,243,62,59,51,183,170,106,40,242,242,199,136,207,99,204,121,125,
167,153,74,204,58,21,170,166,39,84,42,241,203,28,145,185,95,97,253,202,201,167,
120,100,71,164,170,112,105,81,145,67,81,142,52,242,32,143,90,18,9,237,149,194,
70,173,81,143,63,94,157,191,155,87,243,68,216,31,205,51,112,108,62,248,206,124,
96,161,232,15,146,248,106,9,182,158,255,0,220,251,27,116,203,184,182,47,109,
236,250,9,97,27,81,50,120,252,166,50,135,59,143,220,187,77,60,144,69,91,231,168,
74,138,87,16,178,175,142,34,165,54,208,93,219,77,43,200,232,97,124,144,1,94,
225,248,168,73,28,40,14,115,65,232,106,99,35,69,54,144,1,14,63,62,139,199,242,
243,248,50,159,55,190,80,109,143,138,219,251,177,115,31,27,183,143,107,108,125,
221,144,232,92,182,242,216,25,90,188,39,97,246,30,43,17,62,95,107,108,154,170,
138,138,204,28,248,172,94,235,251,73,163,143,43,24,169,138,55,64,186,25,157,65,
245,214,224,209,198,175,0,73,6,189,39,184,98,188,6,61,90,139,158,4,130,113,94,
175,20,3,81,15,90,210,191,234,252,186,36,155,235,107,238,94,164,223,59,219,171,
55,198,19,35,180,247,222,193,220,217,109,155,188,112,117,177,184,175,198,238,
61,171,151,159,21,148,197,75,4,145,198,11,71,95,72,234,204,65,14,162,226,224,
251,87,5,204,114,68,146,198,123,24,3,254,175,79,159,84,120,159,81,12,42,70,58,
77,79,146,86,138,122,87,161,90,105,254,255,0,206,173,83,44,222,72,36,168,137,
81,139,197,33,87,34,84,30,159,166,139,255,0,79,110,137,65,24,30,124,122,175,
134,202,65,45,128,61,56,211,172,85,117,85,82,249,73,168,215,59,82,52,53,70,87,
55,251,120,94,33,29,34,9,153,188,143,26,160,43,107,130,44,71,211,221,245,147,
90,156,255,0,171,29,107,64,4,118,246,214,162,158,190,189,71,130,81,52,39,202,
193,227,89,146,57,99,95,219,186,187,11,34,255,0,103,88,212,72,0,88,11,251,186,
181,106,107,138,244,219,174,151,26,69,49,95,217,254,31,159,79,144,207,2,172,148,
197,252,164,150,101,153,3,2,232,19,77,153,101,8,60,138,188,150,0,19,107,15,106,
67,0,25,79,14,146,178,57,253,64,40,61,63,226,191,151,74,138,138,152,222,153,41,
234,44,77,85,38,53,226,153,75,200,244,234,145,16,98,44,196,249,86,232,9,191,233,
39,243,248,80,236,165,66,183,152,25,244,233,20,106,117,177,95,34,216,245,249,
252,186,235,13,93,37,28,217,72,100,241,69,58,194,15,219,50,135,251,150,210,224,
168,115,101,69,141,46,195,252,13,190,163,222,161,145,149,220,82,132,15,219,211,
147,70,172,177,149,248,107,199,211,253,94,125,53,84,226,233,230,198,201,151,128,
44,50,83,205,18,205,26,216,171,121,8,32,152,28,56,49,223,130,65,31,214,214,247,
70,141,12,126,42,138,112,168,255,0,99,167,146,70,89,4,79,144,70,63,226,255,0,
207,210,58,172,180,147,179,60,107,25,98,37,13,160,50,217,129,178,146,190,155,
254,126,131,233,237,35,230,163,207,143,75,225,20,6,141,143,243,121,244,192,211,
61,216,91,74,30,30,192,141,64,113,103,13,244,255,0,11,251,79,231,158,158,252,
243,212,168,171,165,213,26,150,58,80,5,67,127,80,80,110,163,87,4,216,125,63,222,
61,250,167,215,173,21,20,52,2,189,75,142,104,244,186,0,34,62,51,165,130,145,
234,12,73,46,126,186,200,34,214,3,233,239,216,242,29,120,169,32,87,36,30,156,
160,170,120,161,154,25,84,52,114,211,105,86,60,56,6,69,228,148,96,24,11,159,168,
38,222,245,246,12,245,106,117,26,88,97,224,163,171,93,79,165,88,6,214,129,121,
36,139,50,126,72,252,123,209,52,21,234,192,156,245,2,102,91,217,185,186,32,227,
130,7,44,116,159,235,254,191,189,17,156,122,117,224,107,229,214,41,20,6,136,33,
39,210,158,128,5,197,254,141,96,126,164,31,122,205,59,142,61,127,62,189,83,70,
53,29,98,215,162,160,184,26,29,36,186,179,112,82,220,219,253,82,242,45,205,143,
191,82,164,233,35,252,61,123,200,122,117,62,42,137,93,230,148,133,33,245,92,128,
65,7,143,169,31,81,207,30,246,26,132,12,212,140,127,171,229,214,136,21,3,172,
197,124,213,8,23,149,10,218,172,9,32,241,97,110,45,168,253,15,189,230,160,117,
225,195,167,106,136,67,83,172,134,84,241,152,35,99,10,146,172,192,51,168,32,144,
84,74,172,188,139,126,126,190,246,120,99,173,3,147,143,207,166,137,157,132,209,
159,76,196,195,4,77,169,53,16,135,67,48,91,157,75,42,216,217,129,4,95,143,126,
60,86,148,225,254,175,248,190,182,56,31,94,179,72,197,235,221,227,211,76,12,
134,196,200,94,36,68,28,37,152,94,83,199,36,220,147,239,103,143,167,90,31,13,14,
77,58,144,103,146,23,141,233,89,100,180,98,169,30,81,38,155,9,53,60,104,25,194,
50,198,110,191,64,27,234,0,62,219,99,64,64,63,234,255,0,87,151,91,0,112,61,61,
82,85,212,85,125,191,237,194,92,10,159,0,141,36,128,210,43,233,99,40,30,75,52,
178,115,254,195,253,127,119,83,81,93,61,52,64,90,154,154,99,243,233,238,138,150,
35,36,239,35,125,192,134,152,202,147,50,50,70,37,227,200,80,112,183,81,199,3,
147,254,30,221,93,32,31,179,166,157,154,166,128,131,231,211,148,53,43,20,223,
178,1,102,199,78,12,150,182,163,96,72,5,142,157,86,23,185,246,234,159,136,142,
52,53,255,0,87,249,186,100,131,164,17,252,84,235,54,11,41,79,143,80,213,161,
148,60,85,116,250,9,4,133,146,55,144,51,27,145,229,97,194,253,45,239,209,56,83,
83,230,8,254,95,229,234,146,163,17,216,5,65,31,151,92,233,242,245,245,85,51,84,
83,152,169,37,76,66,76,175,80,174,237,246,130,66,178,52,37,95,72,158,119,54,85,
22,226,223,78,125,232,59,54,166,92,99,167,10,40,1,88,87,187,249,241,207,88,169,
233,38,158,151,32,239,64,173,29,21,45,57,138,37,9,25,141,38,203,162,153,158,3,
48,73,230,147,204,247,0,157,46,19,240,61,239,36,84,168,192,253,159,236,255,0,
151,175,19,70,3,196,201,63,228,225,195,135,207,175,255,211,208,139,204,169,50,
19,172,89,207,208,150,212,17,135,22,32,6,55,253,39,253,191,191,15,46,171,66,65,
53,233,226,77,114,58,18,194,64,182,146,224,240,202,164,105,177,44,160,2,164,
113,245,247,102,60,15,250,171,254,175,217,213,70,43,78,61,75,166,168,85,154,86,
210,39,101,7,80,112,86,5,214,53,145,116,101,114,117,143,199,251,11,123,247,241,
14,38,184,255,0,99,173,112,24,199,83,105,160,168,142,58,185,229,81,36,13,227,
16,186,186,72,1,10,236,47,99,200,176,183,250,160,61,234,153,56,235,207,76,0,
105,158,157,104,76,217,7,174,73,12,238,176,60,115,162,173,108,52,143,34,170,232,
157,127,116,92,57,10,25,164,225,130,175,55,247,234,84,49,175,12,245,86,26,116,
80,10,158,61,53,215,121,160,145,232,237,53,52,82,160,101,142,122,136,231,177,
141,204,99,247,162,44,179,220,142,44,70,159,122,165,9,233,197,161,21,168,61,50,
53,61,192,111,161,33,193,144,27,196,226,222,139,18,197,210,235,113,207,226,222,
253,198,167,173,19,74,122,117,1,46,140,89,72,26,116,112,198,192,146,27,210,223,
93,72,182,226,254,220,21,52,175,14,173,138,117,198,98,190,16,44,197,140,170,
111,123,220,168,98,197,99,228,242,8,177,255,0,15,123,166,27,208,126,125,108,113,
61,115,166,141,103,145,75,179,149,15,168,217,196,44,11,169,32,250,198,150,60,
11,253,56,227,221,64,26,168,78,15,250,191,195,213,91,28,56,83,172,222,18,34,82,
178,185,213,170,209,31,214,191,184,202,188,53,131,112,61,36,31,241,247,162,163,
141,124,191,213,94,181,90,147,143,62,166,200,227,197,76,188,126,220,103,213,254,
187,93,110,167,130,198,246,39,219,149,33,83,60,41,213,114,24,212,241,255,0,85,
58,134,23,212,198,246,230,24,203,11,147,234,12,23,232,127,39,221,10,208,113,
197,63,46,173,196,15,78,176,180,172,151,142,75,240,228,92,27,145,234,32,155,158,
72,176,247,101,166,13,106,41,214,200,166,65,199,250,191,213,242,235,156,14,10,
184,13,112,73,226,246,189,236,13,143,35,80,247,225,140,169,197,122,209,198,72,
165,122,227,167,82,75,235,211,125,62,155,218,246,112,9,0,112,79,60,126,71,187,7,
80,13,78,58,171,0,10,87,253,88,235,208,198,108,140,6,161,119,214,207,168,129,
123,16,2,139,40,123,27,159,240,247,112,69,20,131,213,88,158,224,14,126,207,219,
211,133,25,111,44,122,180,175,136,205,39,161,130,49,244,27,4,98,116,235,191,211,
241,238,234,212,161,7,61,81,244,128,194,135,52,233,194,58,130,203,27,150,146,65,
229,212,204,74,130,218,66,144,88,11,5,123,27,123,240,39,182,164,214,189,54,104,
186,134,41,78,164,44,236,203,90,53,15,220,147,196,164,240,128,200,99,0,144,8,35,
64,3,143,110,112,12,65,243,234,130,135,69,7,151,249,250,149,87,87,174,173,105,
100,37,209,105,233,163,48,196,177,136,139,161,105,111,103,39,68,186,156,250,175,
244,227,233,239,204,78,189,63,46,182,139,69,175,3,95,240,244,241,53,58,206,43,
141,233,26,89,50,88,180,140,203,228,105,16,20,18,106,142,27,221,66,159,75,181,
236,125,219,78,160,106,65,200,234,154,180,233,36,16,161,79,93,75,71,93,91,124,
86,59,19,22,91,49,149,220,235,143,160,161,197,67,87,91,150,200,213,212,78,105,
169,104,49,184,218,64,242,84,205,61,90,104,69,68,50,200,100,1,65,184,247,73,156,
36,78,238,64,80,114,78,61,127,42,14,189,24,47,34,133,213,93,56,31,234,175,91,
207,255,0,32,95,248,76,142,248,218,123,251,174,254,116,255,0,49,44,5,62,222,172,
218,249,26,61,229,211,95,22,178,244,116,89,76,143,241,104,148,85,96,247,159,114,
193,82,42,232,40,63,134,204,233,81,67,128,43,36,226,120,214,74,195,17,65,1,35,
145,159,112,160,161,91,58,212,215,139,142,52,167,146,31,50,114,195,20,10,106,77,
81,68,67,250,127,224,255,0,103,252,29,111,196,0,0,0,0,0,88,1,192,0,125,0,31,
211,218,206,181,215,126,253,215,186,199,47,249,169,127,108,75,251,111,251,68,
128,36,244,159,219,37,189,32,63,211,158,61,233,190,22,197,113,195,215,175,14,61,
107,197,241,207,249,4,127,46,127,143,155,51,185,251,223,228,119,199,78,160,238,
30,225,222,219,195,185,123,195,121,238,14,204,161,169,207,108,125,129,132,206,
103,179,219,190,131,102,237,172,30,94,174,163,1,139,219,123,79,7,227,73,171,26,
153,170,101,144,75,33,147,65,85,4,182,240,204,155,112,150,244,178,200,145,158,
192,204,21,66,140,3,164,141,71,21,36,215,141,7,14,157,98,12,132,47,153,227,246,
245,243,35,249,75,223,84,31,39,126,72,111,126,222,195,245,15,76,116,118,27,51,
154,135,17,182,186,223,227,246,207,77,159,214,152,188,62,220,213,67,138,155,21,
135,70,109,85,153,74,72,86,106,154,185,21,30,170,71,50,50,169,224,30,237,54,205,
4,49,171,59,51,147,83,92,208,159,33,198,128,121,2,79,218,122,44,191,147,86,
186,0,0,29,6,25,58,116,88,41,230,141,41,140,70,178,89,231,9,80,100,170,166,53,
138,209,81,71,88,86,208,190,155,27,132,229,76,150,183,179,169,83,129,0,82,190,
185,207,10,244,81,11,252,74,73,169,92,122,26,113,167,159,252,87,74,74,79,219,
162,169,21,15,16,145,177,75,224,42,238,38,96,181,190,20,141,153,255,0,84,90,31,
66,253,116,254,7,181,10,180,143,191,226,211,254,94,147,49,239,26,65,160,108,
250,112,233,202,138,121,32,86,90,118,14,90,161,96,144,9,101,103,183,137,85,100,
120,148,5,17,52,118,179,240,44,61,190,189,168,104,124,250,105,128,102,26,135,
151,229,255,0,23,210,199,37,137,120,42,49,115,35,71,28,52,88,104,229,139,237,
156,75,52,173,87,115,32,79,164,39,73,70,37,71,43,249,231,219,215,16,208,41,20,
210,168,56,113,233,155,121,170,92,121,151,205,120,10,116,43,108,106,150,170,195,
101,86,42,161,37,76,147,83,1,77,70,175,53,123,60,110,174,154,41,117,172,90,0,
189,174,117,92,114,45,237,51,198,12,58,151,44,58,82,26,147,104,97,219,76,87,135,
66,150,219,153,107,113,185,86,149,97,17,200,238,142,179,48,53,244,238,200,10,
199,81,24,98,17,164,189,248,229,126,158,232,157,202,195,206,157,105,212,161,4,
87,143,88,242,219,126,122,13,155,65,21,55,129,89,107,106,228,50,40,176,1,84,
200,15,140,222,237,115,98,79,244,247,109,5,98,10,7,90,89,3,76,73,244,232,5,171,
163,200,77,139,174,163,168,153,149,228,170,138,89,6,167,14,16,212,73,42,74,35,
140,248,165,37,63,73,35,232,64,30,210,190,175,132,158,150,169,0,134,28,58,150,
113,211,208,87,84,214,64,210,24,154,150,3,122,125,53,108,10,182,131,233,228,22,
31,155,147,205,193,247,165,212,26,190,163,203,173,86,160,10,116,161,163,175,
168,53,186,148,137,17,38,129,17,221,132,50,42,203,103,58,147,72,140,49,30,161,
127,208,125,62,238,175,221,220,113,213,89,113,78,135,8,13,66,197,52,222,42,53,
146,121,105,233,196,143,81,174,165,219,199,171,195,43,41,49,157,64,222,255,0,
143,167,181,224,212,156,116,133,135,10,30,29,9,84,153,58,74,90,202,56,203,211,
192,237,141,166,144,201,19,31,58,73,35,70,71,221,164,130,241,170,57,210,173,97,
245,247,122,254,222,153,32,145,81,199,161,4,72,94,158,83,35,195,44,232,215,210,
68,237,82,136,218,102,47,81,28,64,193,171,157,90,158,254,139,123,183,151,84,
245,234,125,106,79,53,77,60,192,208,187,148,165,17,205,143,170,142,58,169,90,84,
104,164,146,109,78,90,80,75,13,113,127,106,223,225,238,224,212,245,170,105,7,
211,174,85,177,214,218,177,234,39,86,120,162,241,192,209,34,52,236,177,56,213,
233,176,17,178,181,199,63,65,245,247,170,229,243,215,134,146,6,145,142,147,112,
82,9,107,26,26,154,88,16,215,121,168,196,143,58,130,124,209,151,105,36,32,148,
119,86,0,223,250,139,123,167,18,7,87,242,62,157,2,219,155,110,209,209,71,95,139,
200,81,82,214,73,20,237,80,144,212,192,211,205,246,171,44,197,163,50,70,136,209,
58,106,14,0,255,0,117,158,111,237,44,168,42,192,138,244,170,38,36,43,41,167,73,
186,234,220,118,37,105,77,79,134,74,90,169,49,115,210,81,195,75,12,30,28,118,63,
196,101,244,20,89,234,97,170,157,244,122,91,77,144,220,115,238,168,193,27,142,
42,58,179,35,72,24,15,67,251,122,7,183,141,38,38,37,200,100,168,68,143,77,81,
86,50,139,76,97,251,106,56,225,155,94,136,40,82,158,16,177,152,24,250,245,48,
185,255,0,91,219,243,105,210,93,78,43,95,151,229,211,81,107,44,21,184,129,79,
159,231,208,119,77,150,148,203,79,77,38,167,86,151,210,41,81,106,36,167,45,28,
133,209,218,100,242,56,145,87,159,25,184,63,75,123,78,143,197,79,167,151,74,26,
49,74,138,126,125,42,177,146,197,69,145,120,16,68,226,124,157,35,32,51,49,169,
44,209,164,159,185,19,92,173,191,54,250,123,121,9,86,3,20,61,50,234,88,19,232,
15,151,79,19,101,104,231,174,202,67,4,212,242,76,239,26,248,252,254,41,41,229,
73,195,250,193,43,121,36,84,96,163,242,7,30,222,14,9,34,189,50,99,52,82,65,167,
248,71,80,160,174,120,232,170,153,86,115,42,204,186,98,5,22,2,177,143,25,112,
131,75,121,19,251,108,77,216,127,143,189,234,33,9,243,234,197,23,82,208,142,29,
38,178,82,22,195,215,120,211,92,144,10,115,51,6,1,144,189,67,185,101,23,96,65,
0,11,126,47,127,116,161,210,212,226,79,87,20,14,132,240,242,233,150,142,160,
230,49,248,251,126,245,77,29,101,108,134,53,169,8,76,2,154,8,163,157,161,96,21,
70,167,182,160,77,207,215,219,145,131,42,169,243,4,244,204,133,98,145,255,0,
132,129,254,126,167,238,156,116,172,184,201,180,210,46,138,236,134,149,86,138,
82,224,71,27,184,242,18,90,47,19,94,202,45,174,255,0,155,123,188,241,30,214,35,
21,61,122,222,127,143,4,224,124,191,213,95,94,152,43,49,212,53,112,77,68,207,
79,29,90,83,5,67,21,149,11,75,12,234,84,177,13,225,148,73,32,228,11,92,255,0,
137,246,211,196,140,52,30,32,121,116,234,204,232,197,169,218,79,72,46,180,223,
245,93,13,220,61,63,220,144,109,250,13,211,89,211,253,129,177,251,1,182,222,118,
150,159,37,128,205,197,182,55,37,6,92,98,43,241,245,80,207,70,244,121,15,178,
104,100,242,35,2,207,170,199,216,119,114,181,241,173,38,131,81,12,201,74,250,87,
229,254,31,94,29,8,44,174,7,141,170,130,149,252,250,251,69,117,214,7,227,199,
202,157,149,241,171,229,36,61,117,176,55,38,70,13,159,183,187,63,166,55,148,152,
124,30,83,61,176,163,223,59,98,150,162,174,155,109,110,42,104,94,108,120,106,42,
246,165,171,138,25,22,39,120,236,233,169,6,144,252,86,246,151,144,219,78,96,10,
194,134,131,20,35,240,154,113,0,249,30,4,112,175,71,69,153,11,10,244,25,238,63,
229,125,252,190,119,119,200,195,242,219,115,124,73,233,188,223,200,183,203,199,
159,168,237,28,134,219,243,230,107,179,177,99,142,37,115,57,58,6,169,254,3,148,
202,125,129,208,213,21,52,146,202,196,6,44,92,6,15,181,149,187,22,212,135,73,
106,149,212,218,73,173,114,181,211,147,146,41,66,114,115,213,117,182,51,252,135,
248,122,166,223,231,83,255,0,9,173,233,31,230,65,81,155,249,3,208,153,202,78,
135,249,105,65,181,40,113,84,81,195,65,65,73,212,93,160,187,122,39,76,62,51,122,
226,49,152,248,235,48,57,153,40,216,210,199,153,164,50,50,170,194,39,130,84,142,
226,158,4,150,204,207,102,7,134,77,76,120,3,133,42,135,240,147,78,6,170,79,240,
146,79,91,168,96,3,113,245,255,0,63,95,48,30,198,234,253,239,211,157,141,190,
122,143,179,118,230,75,108,118,39,89,238,204,222,201,222,91,114,174,31,242,204,
46,229,219,89,10,138,28,149,28,139,34,248,221,86,122,86,209,33,213,20,145,16,
234,116,176,62,204,32,149,103,138,57,98,39,73,21,251,63,204,71,2,60,186,78,235,
160,178,181,43,254,175,245,99,164,3,198,208,211,179,19,74,68,210,107,64,89,154,
162,3,25,144,104,113,24,88,100,32,90,250,127,54,255,0,91,219,224,144,190,85,175,
236,255,0,39,84,32,23,28,69,63,97,235,151,222,93,150,39,133,108,124,87,40,158,
184,153,100,14,12,69,130,48,15,107,88,88,128,109,127,111,9,40,104,195,246,116,
209,136,128,88,28,138,253,156,60,250,81,37,98,75,69,6,173,36,43,64,92,8,191,65,
213,42,159,212,170,206,8,91,220,18,15,210,228,143,106,117,6,141,105,242,255,0,
47,73,12,68,72,255,0,159,249,58,225,81,145,147,244,68,89,12,129,82,73,22,65,
125,9,32,145,35,138,55,98,246,214,128,234,55,254,150,247,226,228,234,161,193,
234,203,8,205,115,79,95,240,147,212,220,62,94,174,24,142,168,210,72,154,80,36,
105,148,216,178,75,229,245,5,54,62,142,126,156,11,251,180,82,148,169,42,41,254,
205,122,172,240,41,106,2,106,7,151,77,98,17,80,43,52,36,215,134,73,52,83,163,
160,67,27,185,34,215,245,185,31,212,255,0,79,116,3,80,114,6,71,151,203,167,190,
18,134,191,159,77,141,65,13,113,102,140,178,203,227,85,215,41,10,25,173,192,77,
54,31,94,8,55,191,182,138,134,53,24,63,234,207,78,248,133,112,105,74,244,208,
244,51,68,228,58,16,117,149,39,252,86,223,235,106,54,228,31,161,246,193,82,10,
249,116,232,116,60,27,172,177,199,161,157,88,51,27,88,107,58,93,127,165,201,178,
158,79,189,105,53,165,58,221,105,67,95,217,158,178,168,104,213,193,23,212,160,
139,253,74,179,11,253,56,30,232,125,15,30,172,14,161,80,122,196,95,91,27,171,
125,52,216,89,109,193,54,0,145,96,62,190,244,107,93,36,230,184,249,255,0,155,
173,241,168,243,235,20,145,216,70,204,88,35,169,210,226,238,27,78,161,254,26,
108,23,144,127,215,247,188,215,175,99,200,245,34,40,201,120,159,73,209,104,203,
63,234,85,0,27,146,72,184,54,111,246,30,234,105,193,141,107,143,219,215,177,
154,245,138,96,28,146,192,107,45,201,2,247,80,0,191,22,252,127,135,191,17,146,
124,191,212,122,221,43,143,62,184,196,154,53,217,136,212,52,222,204,71,208,128,
8,54,3,159,201,250,15,123,169,171,31,151,250,179,215,177,94,157,35,43,28,176,
198,27,210,204,191,114,200,197,28,163,70,85,148,60,132,160,55,224,113,200,247,
229,3,180,3,246,159,243,117,162,5,41,76,116,235,83,44,49,196,177,201,49,141,191,
135,77,227,141,33,121,17,239,46,184,175,35,130,124,82,170,155,255,0,66,61,184,
212,160,24,165,58,109,107,83,143,62,63,236,124,186,198,48,211,55,130,121,91,68,
82,67,27,169,224,8,164,103,141,199,145,111,123,36,76,73,0,125,120,30,245,164,
254,93,104,200,181,167,159,89,114,24,153,35,168,169,1,233,25,98,100,4,193,25,
210,67,19,102,98,204,12,129,207,215,77,237,254,30,245,34,144,113,76,15,159,91,
141,170,160,154,254,125,96,155,28,17,252,38,69,145,192,1,130,92,68,7,234,212,
142,220,133,12,7,167,241,237,147,81,164,121,244,230,191,62,159,177,201,160,120,
208,2,74,165,165,45,165,64,22,212,214,107,159,72,54,31,225,237,212,24,0,255,0,
171,203,203,166,216,22,161,174,7,237,235,27,101,11,37,66,66,196,42,211,178,72,
215,0,55,224,132,39,233,250,120,254,190,238,77,104,190,125,83,195,11,74,250,255,
0,168,116,221,77,148,146,57,131,171,127,153,130,125,8,252,150,15,25,188,100,
41,62,150,38,255,0,227,249,247,80,235,82,213,168,244,255,0,87,31,183,211,167,
25,53,10,48,20,175,250,191,151,92,240,177,154,202,250,100,150,82,170,146,121,
28,58,171,33,242,35,93,221,53,216,2,188,18,127,31,79,118,143,81,145,65,224,15,
84,144,133,66,41,131,251,122,153,53,67,211,84,83,165,61,80,104,233,165,82,198,
37,103,141,146,150,168,206,238,218,181,234,133,0,38,247,176,10,5,189,222,180,
32,2,40,15,84,9,85,98,203,154,99,243,235,157,38,114,172,82,101,164,21,129,105,
217,105,157,175,37,73,121,8,204,83,205,100,169,98,101,82,28,6,42,172,23,72,250,
123,208,115,66,107,143,206,188,125,125,122,217,136,106,65,164,87,242,244,255,0,
86,122,255,212,208,138,175,215,83,35,34,104,83,168,232,78,85,8,82,91,77,254,
136,72,184,254,151,247,95,197,199,170,82,188,79,93,172,108,76,113,177,141,73,
101,176,38,230,59,149,123,150,7,65,54,99,126,111,239,96,99,175,99,36,84,142,179,
23,10,242,201,10,218,53,209,162,67,169,72,255,0,82,241,106,23,33,136,228,31,
168,255,0,111,238,198,160,250,30,181,196,10,241,233,119,71,76,181,152,201,36,89,
16,168,167,168,169,176,144,3,9,166,17,72,250,150,61,122,76,142,196,14,62,188,
113,127,119,211,138,254,31,245,124,254,222,171,171,75,82,128,31,159,250,191,216,
233,150,145,162,70,168,242,198,91,92,20,238,12,140,161,87,198,255,0,185,30,157,
45,45,159,128,9,0,219,234,61,208,176,36,158,174,213,197,15,14,176,204,130,157,
18,50,17,203,34,11,194,218,164,107,177,209,52,62,109,34,194,78,46,160,158,62,
150,247,174,189,168,177,52,255,0,87,219,212,89,16,83,201,52,150,85,137,213,227,
134,234,200,89,135,26,138,27,221,163,45,99,127,207,226,222,253,246,241,235,100,
224,117,19,199,228,70,224,107,91,93,135,3,64,2,218,139,27,51,0,9,22,255,0,121,
246,224,39,86,70,124,255,0,217,235,85,243,242,234,32,109,14,89,72,184,212,202,
47,234,191,58,73,6,194,223,239,173,239,223,132,212,241,255,0,39,86,244,61,120,
183,238,83,134,244,172,129,46,77,128,63,78,127,175,211,243,110,47,238,190,98,
188,58,209,24,39,207,167,181,145,36,89,99,22,145,146,96,80,250,4,45,17,177,140,
89,27,66,183,38,231,87,248,123,118,160,169,167,26,255,0,46,168,48,70,113,215,
10,133,82,98,95,36,76,200,129,90,204,88,90,49,116,63,79,85,212,127,176,63,237,
253,249,133,89,64,206,63,103,249,186,210,208,86,131,172,75,20,142,252,41,96,210,
40,1,148,35,241,101,230,228,5,22,63,159,109,145,66,85,20,245,110,209,81,76,245,
30,162,32,223,82,44,236,204,150,183,23,4,233,3,243,234,94,63,214,247,181,168,
53,7,253,67,173,128,64,169,227,212,40,216,197,168,93,87,146,121,250,27,90,196,
113,96,121,255,0,99,239,71,12,123,127,103,207,173,250,84,19,212,181,101,104,200,
6,204,52,157,38,193,128,14,191,67,207,63,159,123,66,1,63,58,127,135,170,29,70,
135,203,252,61,112,141,217,18,225,149,66,188,140,21,133,218,229,16,95,77,172,65,
95,200,255,0,31,110,2,13,72,234,132,84,211,53,167,89,163,151,75,51,122,181,104,
37,27,235,98,44,64,111,160,177,30,237,195,207,170,16,8,0,129,77,89,255,0,81,
235,184,103,5,81,117,32,5,236,193,155,234,160,175,39,252,77,189,217,104,13,107,
142,183,161,181,26,250,127,171,253,95,103,83,232,165,73,31,197,250,195,206,238,
235,198,144,99,70,209,244,212,74,234,230,255,0,225,237,197,163,26,87,21,255,0,
39,84,117,43,154,227,79,250,191,213,246,245,142,103,89,231,145,244,182,166,103,
144,0,72,244,143,72,26,120,210,5,143,28,159,109,146,42,77,124,250,188,66,128,
103,246,254,222,150,52,21,176,212,44,84,117,79,10,197,45,125,29,76,178,178,171,
40,138,154,41,82,58,116,33,188,229,202,199,110,5,174,121,246,252,100,48,85,108,
85,135,242,29,38,145,104,89,215,52,82,58,180,47,228,237,242,239,225,231,193,
223,153,216,239,148,223,44,250,239,179,59,89,122,207,105,103,243,221,35,177,122,
247,17,182,115,11,83,220,217,54,139,27,133,200,238,79,239,54,83,23,13,44,56,108,
100,245,18,81,79,23,150,74,124,131,69,47,140,152,199,178,157,201,37,148,196,17,
85,162,13,169,129,58,107,76,173,77,14,1,201,199,144,199,30,150,90,209,65,213,
196,10,14,190,178,191,8,123,231,182,62,78,252,109,235,238,249,238,30,138,173,
248,223,184,59,58,142,125,211,130,234,76,214,226,109,201,186,118,254,199,200,
204,102,217,245,123,190,168,225,176,73,143,220,121,172,43,71,87,61,8,130,244,
130,101,70,109,122,130,167,179,154,89,227,105,36,85,10,88,233,34,185,95,92,249,
19,90,31,49,67,65,94,148,176,0,128,58,54,126,213,245,94,189,239,221,123,175,16,
8,177,228,30,8,63,66,61,251,175,117,160,31,252,43,107,249,185,119,110,204,236,
72,63,150,39,74,212,238,62,179,218,50,108,220,6,249,239,189,239,138,200,255,0,
12,201,246,102,35,121,80,212,201,183,250,231,27,61,4,233,87,75,178,169,104,149,
164,202,163,58,54,70,161,146,38,79,12,68,72,138,52,250,171,137,21,199,232,68,
244,11,234,212,13,83,242,80,70,145,235,82,69,66,210,204,116,40,167,196,71,90,36,
208,228,36,166,72,152,31,243,8,194,56,193,32,51,187,134,44,161,108,65,65,248,63,
95,103,17,62,154,48,233,20,145,43,118,250,255,0,171,252,61,9,148,117,102,179,
31,86,101,130,90,148,167,166,138,173,140,202,170,210,201,18,133,129,85,160,186,
163,187,125,88,144,198,215,3,217,138,157,106,245,4,128,1,232,165,144,36,139,70,
165,73,29,60,215,84,164,208,210,26,41,98,144,212,203,142,20,197,25,217,82,58,
102,74,164,145,172,183,68,18,183,171,80,23,31,139,251,122,74,48,66,135,137,20,
252,179,210,120,193,12,225,193,20,6,191,105,198,58,18,104,101,150,42,186,154,
104,96,241,72,211,136,167,103,210,209,74,242,83,135,18,68,234,75,74,31,233,234,
10,160,31,102,145,182,134,40,7,117,104,127,103,69,142,186,209,92,154,138,84,
126,71,207,167,173,195,181,30,136,44,212,181,53,116,244,130,150,20,116,89,29,96,
141,252,58,167,87,44,229,73,121,175,164,165,248,60,251,102,230,16,53,104,98,20,
0,62,95,234,175,78,218,207,168,233,145,70,162,73,235,188,78,115,39,79,67,87,
13,93,37,60,20,175,61,34,8,131,200,140,38,73,184,174,243,71,160,153,29,22,193,
79,167,242,62,158,210,187,63,128,225,211,254,47,215,165,26,81,101,71,71,37,191,
213,142,132,12,14,78,162,44,174,77,105,167,213,66,102,166,18,77,52,12,210,173,
65,70,32,68,241,203,36,106,25,120,112,204,89,137,190,145,237,34,177,215,199,
165,108,160,162,134,227,208,225,77,154,251,189,163,74,39,86,18,67,144,174,114,
206,224,233,141,2,43,72,197,126,158,107,155,11,113,237,122,61,99,21,227,210,6,
139,188,145,210,50,183,192,152,236,154,211,7,142,121,106,232,92,9,33,13,16,72,
53,146,232,255,0,78,99,91,250,136,213,248,231,143,108,181,51,74,244,242,2,8,36,
227,164,222,62,24,139,228,34,89,234,41,233,204,98,164,44,122,98,166,127,44,132,
207,27,144,133,140,147,177,187,105,55,255,0,91,219,17,208,150,29,58,216,161,166,
122,110,220,112,189,28,148,250,92,36,69,96,16,24,218,231,198,121,48,16,194,50,
29,128,33,111,115,113,239,82,97,134,113,213,147,34,157,62,79,154,170,196,146,
26,25,149,35,169,167,146,151,238,193,19,2,208,32,145,16,33,100,210,164,134,101,
4,181,173,237,229,144,174,122,166,128,79,207,161,102,147,49,21,126,78,141,167,
88,146,119,197,82,152,229,255,0,55,79,164,104,85,5,137,213,27,223,234,27,218,
173,122,179,231,210,109,26,87,30,189,10,216,188,254,99,29,28,180,24,250,209,226,
170,104,62,226,73,100,80,182,62,137,180,185,118,142,74,118,136,250,153,205,192,
94,61,186,60,168,122,78,202,181,38,157,101,174,203,45,37,102,74,146,139,36,141,
13,29,61,60,81,84,170,183,218,215,34,85,33,101,245,145,40,105,28,219,82,234,4,
95,222,235,199,61,87,73,0,99,174,117,155,170,108,125,86,80,84,42,82,209,203,79,
0,163,2,71,120,233,102,65,16,62,41,92,151,23,213,115,170,228,95,233,111,117,
214,65,53,225,78,172,168,25,84,249,244,231,141,201,67,87,82,179,125,209,138,106,
99,247,81,212,78,141,44,115,203,100,47,12,45,24,208,23,65,189,135,231,243,239,
218,129,52,175,94,42,85,106,41,215,29,250,35,203,79,54,74,145,99,50,179,32,119,
66,18,140,84,83,72,64,180,230,210,9,38,136,130,85,133,141,136,228,123,212,148,
39,173,67,218,185,232,35,236,204,19,79,153,162,142,17,42,67,79,73,141,240,44,
72,194,39,137,105,163,106,181,88,255,0,112,168,90,134,231,79,7,235,111,108,58,
213,177,234,58,81,27,209,106,105,192,255,0,177,208,111,148,219,245,245,219,79,
116,83,84,69,52,147,37,77,13,70,40,69,40,134,158,4,149,204,18,105,78,79,141,42,
21,75,107,97,235,99,97,111,110,233,45,20,145,181,107,229,254,175,183,170,49,85,
150,23,90,82,134,190,189,23,188,228,117,179,210,99,104,242,169,87,20,148,21,238,
134,166,156,172,114,211,212,130,98,105,94,42,120,245,179,134,107,40,213,102,23,
62,211,54,170,34,189,106,15,250,184,116,174,61,42,196,167,152,243,235,14,23,39,
87,46,81,224,106,170,81,38,37,233,163,167,150,181,111,81,82,12,161,110,101,115,
31,137,217,94,231,81,185,224,113,244,247,165,99,168,2,120,122,241,235,110,136,
16,224,208,250,121,116,255,0,83,139,76,207,151,33,21,43,37,100,139,19,199,61,
64,146,58,63,243,147,44,65,38,141,124,146,49,26,217,148,139,47,28,139,251,124,
168,114,204,7,117,56,249,116,200,111,8,4,39,21,252,255,0,213,243,235,134,42,173,
105,33,124,125,52,230,84,161,118,198,186,168,121,106,38,168,141,214,41,230,48,
39,150,72,224,87,127,202,129,249,189,185,247,120,232,20,34,154,211,29,55,40,44,
67,17,74,231,166,201,106,42,127,132,231,91,198,90,65,28,1,18,56,194,137,137,
157,209,99,33,152,18,165,136,245,47,251,126,61,251,81,80,213,227,246,117,114,
160,152,193,61,4,146,110,74,220,100,116,144,125,141,68,117,41,87,86,97,16,128,
88,41,90,117,49,179,201,162,57,99,50,41,184,60,216,253,61,180,183,12,128,40,83,
168,49,225,254,207,31,245,121,244,231,211,171,188,132,176,210,64,227,210,130,
191,59,61,107,209,253,205,48,166,38,166,85,158,53,115,48,69,146,63,33,102,241,2,
52,249,0,186,173,192,22,246,165,229,50,83,90,210,167,61,49,20,65,3,104,106,224,
117,62,143,81,158,104,89,226,158,71,129,209,196,86,67,81,229,213,227,142,38,7,
74,173,212,11,94,231,222,178,167,73,34,189,109,200,41,81,90,127,131,160,75,39,
146,173,150,141,241,178,59,37,38,137,163,211,90,168,146,196,30,172,153,160,142,
53,5,210,4,100,63,172,146,47,197,135,178,183,102,41,225,214,139,243,251,127,
193,209,180,113,170,183,136,62,60,112,225,195,143,219,246,116,126,126,20,127,55,
191,230,35,252,185,81,241,255,0,25,123,255,0,63,139,235,168,234,150,170,167,168,
55,197,53,46,254,234,201,228,149,227,51,154,125,169,185,18,165,118,252,213,42,
150,121,177,82,80,204,218,137,47,168,223,217,52,251,124,108,210,77,19,50,73,230,
84,210,191,104,53,86,251,88,19,209,164,87,6,136,173,67,215,210,175,249,53,127,
60,223,143,63,205,43,166,240,241,231,243,219,47,168,62,88,109,227,75,133,236,
174,138,201,110,58,74,10,156,158,89,192,74,109,211,213,209,102,106,162,200,110,
157,165,159,35,84,113,66,103,171,160,155,85,60,247,42,146,200,133,103,48,183,
131,118,193,100,174,27,130,191,165,43,193,189,86,181,174,70,8,233,93,3,13,73,
195,252,31,234,245,234,228,251,111,177,241,93,69,213,157,147,218,153,152,141,94,
47,173,118,38,239,223,121,26,40,234,34,167,154,178,147,104,109,250,252,253,85,
20,51,202,26,56,103,169,134,128,162,179,2,21,152,18,45,238,247,51,173,188,18,
205,130,85,73,2,188,72,28,58,242,174,166,3,175,137,63,204,95,147,57,63,155,63,
45,62,69,124,165,202,96,211,104,213,247,143,100,110,93,249,30,217,21,162,180,
96,169,51,21,49,199,142,193,12,133,61,29,26,228,38,199,98,226,138,51,41,137,4,
140,133,136,185,229,235,56,90,24,86,55,112,91,36,159,82,196,177,167,230,113,211,
82,178,234,46,70,58,44,178,59,212,68,3,5,146,154,3,27,248,85,34,242,71,20,108,
180,229,228,154,40,213,163,141,229,176,245,125,89,189,171,7,137,165,64,255,0,87,
236,233,190,28,79,119,250,191,193,212,9,130,50,185,85,114,165,173,16,213,228,
144,220,250,150,224,43,160,44,111,98,188,219,235,238,252,120,122,245,161,241,0,
78,105,249,127,171,243,233,242,134,182,86,164,74,121,142,165,19,164,41,59,170,
5,72,163,69,146,42,96,7,246,131,220,253,1,55,177,62,223,73,27,70,150,225,95,
245,14,147,73,24,15,173,124,197,127,63,51,215,12,141,106,6,100,113,1,121,165,
144,137,158,21,73,17,86,202,186,46,76,136,30,255,0,218,227,131,107,251,219,200,
50,9,201,62,157,106,56,201,29,181,160,28,43,254,161,214,56,170,12,42,25,25,116,
76,10,146,108,65,102,0,22,22,45,123,143,167,250,254,252,30,130,163,173,233,242,
110,53,252,250,228,146,24,231,251,152,159,76,167,213,172,16,109,33,184,32,139,
241,113,199,191,6,167,114,138,30,188,192,211,75,12,14,164,196,145,78,254,57,229,
72,142,130,198,94,3,113,170,65,33,79,208,91,87,234,228,92,123,245,65,161,56,61,
84,212,2,85,73,29,54,214,84,163,58,21,37,202,218,211,105,253,97,91,240,111,103,
80,195,131,254,39,159,116,102,7,206,160,116,224,71,161,31,229,234,108,176,193,
88,174,241,17,28,140,3,170,155,217,152,170,22,12,198,220,125,72,252,143,123,
165,106,192,241,235,65,138,83,168,82,82,201,11,49,145,89,209,99,87,30,43,88,157,
118,81,114,46,20,145,207,30,218,113,79,44,116,236,100,86,128,224,158,161,52,103,
94,149,54,58,111,118,252,177,23,228,57,82,164,126,125,178,71,117,72,168,20,255,
0,15,79,124,233,142,177,198,161,149,226,181,244,141,79,200,96,16,16,9,23,250,
253,127,7,222,141,106,223,151,91,245,235,138,31,11,184,140,150,70,227,67,45,130,
131,164,6,83,207,55,22,255,0,138,251,222,77,107,254,175,245,14,182,49,154,245,
234,135,187,162,232,140,126,117,198,45,174,224,127,94,13,136,250,158,125,248,
156,177,244,235,85,165,51,214,72,144,16,117,13,64,93,172,13,137,190,149,91,113,
98,69,239,110,47,239,99,137,32,117,98,62,125,114,0,73,35,137,24,240,151,5,173,
206,139,233,75,11,126,163,199,191,14,0,87,203,170,125,188,122,118,130,157,167,
52,169,233,153,197,44,65,81,164,43,250,75,48,66,4,102,232,73,185,183,62,237,74,
208,10,112,234,149,11,175,52,53,255,0,39,159,249,58,145,74,92,213,197,27,171,
157,49,71,117,54,241,180,132,143,65,50,178,5,143,212,72,55,181,254,156,123,241,
52,32,83,61,86,149,83,243,39,246,127,171,253,85,234,70,77,158,122,198,145,140,
101,218,89,1,208,61,8,3,0,21,64,181,208,94,215,183,63,143,122,145,73,36,149,171,
103,173,173,2,170,173,71,219,254,175,47,78,163,85,79,20,117,6,228,139,36,97,79,
0,150,83,99,164,3,100,23,250,126,7,182,219,2,180,207,250,191,109,58,186,30,
218,86,191,234,254,125,67,154,190,73,156,136,239,18,181,200,28,146,47,101,107,
176,213,125,99,253,239,223,149,245,26,143,135,253,95,224,255,0,63,86,244,251,
127,213,78,161,25,8,73,144,29,42,154,129,37,128,190,166,31,95,201,62,159,233,
239,205,69,7,28,127,213,251,7,252,95,90,192,201,25,61,117,75,11,60,170,133,89,
129,142,70,178,1,171,72,66,196,128,197,73,5,125,237,19,32,208,131,254,174,63,
236,117,227,129,195,61,63,81,42,211,70,213,4,64,11,66,146,32,154,57,20,106,86,
210,209,178,19,193,101,111,246,36,143,110,173,0,168,25,233,166,32,144,149,243,
207,250,190,93,67,47,20,144,204,13,196,10,142,100,65,100,157,26,228,29,8,204,21,
181,1,254,176,191,210,222,235,80,107,95,245,103,171,103,200,230,190,125,117,75,
83,88,244,121,73,73,70,138,26,74,71,10,36,245,70,90,169,33,187,203,160,199,230,
117,147,133,184,91,255,0,133,253,216,51,16,199,200,103,175,20,77,73,140,215,175,
255,213,208,121,93,216,136,193,12,215,208,164,127,75,176,224,241,199,191,99,170,
144,50,122,204,124,34,53,66,138,125,72,88,168,38,75,3,234,96,154,148,127,188,
255,0,176,247,234,212,12,103,173,100,154,249,245,200,55,147,202,232,206,140,206,
1,70,32,169,62,171,234,97,116,45,167,233,101,0,19,239,220,126,222,181,138,100,
244,162,195,102,38,134,38,199,26,117,146,42,160,34,121,21,73,112,176,205,4,141,
46,155,128,100,5,20,19,113,192,250,123,117,100,53,210,6,56,117,70,90,149,62,99,
174,235,154,147,238,158,74,122,138,150,142,88,111,29,166,132,178,201,168,41,141,
216,41,4,218,230,64,108,44,120,247,82,189,216,53,7,171,169,44,56,10,142,162,72,
239,55,132,73,78,133,96,91,48,136,144,80,187,220,129,207,165,203,114,45,192,31,
143,117,167,16,58,177,20,28,79,92,155,92,209,74,178,201,11,60,76,239,29,202,49,
10,109,171,245,233,177,121,44,72,253,92,125,61,248,126,93,104,113,4,112,233,
164,172,171,39,169,149,143,147,77,201,244,240,162,250,248,2,246,250,31,123,7,
133,58,217,20,4,121,117,133,238,29,193,32,169,177,46,0,3,142,109,99,205,192,31,
79,126,53,224,120,117,225,192,26,103,172,18,29,108,10,235,98,170,0,255,0,131,
88,19,207,0,113,239,103,184,129,79,46,183,79,94,164,67,43,31,36,99,252,235,72,
164,11,128,198,196,223,76,122,108,193,72,4,242,56,23,247,173,76,9,12,49,95,245,
83,135,84,32,244,232,146,33,88,153,212,89,94,197,151,69,254,131,151,80,67,122,
155,131,126,61,187,80,113,231,252,255,0,62,188,58,118,90,82,239,247,11,44,100,
26,132,93,111,117,140,150,190,147,117,28,120,218,214,63,79,193,247,106,86,159,
51,215,141,105,211,85,90,113,39,148,21,98,89,197,172,186,72,123,181,199,169,
127,60,0,125,212,241,108,121,245,224,41,78,154,180,115,234,191,0,233,54,23,58,
143,212,254,56,247,160,1,4,41,251,126,223,179,253,95,203,173,249,84,117,218,70,
205,229,210,65,177,69,183,0,176,46,46,57,181,172,71,245,247,226,13,88,211,63,
234,255,0,81,235,212,24,29,99,179,133,23,4,184,102,5,127,160,227,159,199,212,
159,109,234,160,33,79,19,254,163,213,104,42,116,245,203,204,162,39,86,71,37,200,
177,184,40,21,8,23,3,234,173,114,71,36,251,176,111,136,22,52,249,117,173,53,101,
161,235,164,91,233,116,40,218,89,184,23,6,250,87,155,31,169,23,250,123,125,77,
41,92,26,245,179,198,153,175,82,49,229,214,86,101,42,178,4,152,2,207,227,23,
176,7,83,48,97,244,111,233,239,107,150,199,207,173,56,168,163,12,99,174,150,114,
25,11,217,154,236,73,31,168,139,18,94,69,250,139,177,252,19,199,226,254,232,24,
30,180,70,43,242,255,0,80,233,69,183,177,187,139,119,110,29,191,180,182,94,223,
203,238,173,205,158,174,165,199,224,54,254,219,198,214,230,115,217,172,205,97,
106,122,106,12,70,43,31,13,85,101,125,92,210,56,17,199,28,109,35,18,120,247,89,
103,72,7,136,238,22,49,146,77,49,249,245,85,136,176,101,166,125,58,250,9,127,
194,120,127,225,54,213,93,93,93,129,249,189,252,199,58,234,170,14,217,195,102,
126,255,0,163,190,56,111,24,40,42,168,182,75,80,20,122,30,203,236,172,108,114,
214,83,87,238,121,42,127,115,21,138,152,232,160,241,138,138,148,105,154,52,132,
177,139,95,181,94,162,204,121,17,67,39,218,14,66,124,191,17,227,219,241,42,85,
17,10,15,139,252,31,236,255,0,131,237,225,188,207,181,157,107,164,254,230,221,
24,77,161,139,57,108,245,116,52,84,207,85,75,143,164,73,29,69,70,75,43,144,153,
105,177,184,140,116,4,135,172,201,228,106,157,99,134,20,5,157,143,244,4,132,247,
87,80,218,66,102,153,168,188,0,243,36,240,80,60,201,60,7,249,58,178,169,99,65,
211,173,12,181,51,210,65,53,101,56,164,168,150,53,146,74,81,32,148,211,151,26,
132,47,42,217,30,72,193,179,21,244,234,189,184,246,228,76,237,26,180,137,165,
200,225,198,159,46,180,105,92,28,117,47,219,157,107,175,151,71,252,44,3,227,69,
111,81,127,50,237,191,222,105,89,155,200,109,239,147,125,63,128,207,194,249,41,
165,171,164,196,238,78,188,113,178,243,120,60,84,238,52,82,208,12,125,53,13,82,
211,131,251,111,82,237,244,97,237,53,153,17,220,222,192,120,212,56,251,24,83,
249,21,35,236,160,235,210,2,68,108,62,207,217,255,0,23,214,170,233,44,114,68,
176,170,48,85,102,241,234,34,250,221,238,206,196,88,44,134,53,2,195,143,240,246,
106,2,208,208,103,164,196,53,117,18,42,127,213,254,30,151,27,123,37,36,116,117,
112,35,78,178,72,85,100,144,57,5,210,218,139,186,48,146,39,62,49,96,44,191,211,
218,200,100,162,16,9,207,159,69,183,81,254,162,18,7,250,191,159,79,56,106,234,
26,81,42,82,9,158,145,102,69,2,234,93,116,134,112,190,54,26,214,159,72,63,158,
111,127,167,183,226,100,90,170,215,79,73,167,73,24,130,244,14,127,213,251,122,
23,118,246,114,57,37,140,42,71,29,60,130,35,51,200,218,103,101,137,148,172,175,
29,164,14,3,88,41,82,182,252,131,245,246,189,95,80,0,96,116,94,241,105,201,53,
106,159,179,163,29,64,244,155,134,132,211,74,96,51,134,31,184,142,38,32,200,44,
45,117,88,203,233,28,139,88,123,177,144,234,53,165,122,79,225,128,20,142,30,94,
92,58,78,203,183,171,177,240,229,105,254,206,154,170,139,195,12,134,42,176,237,
78,106,32,121,86,158,82,234,202,232,241,23,224,95,67,31,168,183,187,211,82,157,
32,20,167,159,175,85,50,81,208,177,33,235,196,122,121,244,140,85,207,81,197,
153,135,29,83,79,5,75,214,80,100,107,28,60,48,253,229,57,137,163,149,97,141,149,
129,158,158,126,78,155,22,83,107,123,40,157,25,28,215,207,61,30,64,241,188,104,
222,64,17,159,46,134,108,0,174,59,78,138,21,72,100,87,159,39,36,177,139,151,50,
39,138,64,74,191,213,139,93,174,77,136,246,162,58,149,63,159,73,158,154,234,
126,93,56,60,94,74,57,162,146,71,1,170,41,76,132,201,9,30,72,244,56,89,199,208,
182,179,100,3,139,95,223,143,159,167,90,166,1,28,122,133,246,58,141,115,169,142,
39,141,34,88,196,86,113,161,228,242,79,42,199,100,188,234,171,98,160,88,15,109,
1,77,68,121,245,114,114,49,131,210,119,118,210,85,138,138,89,164,134,40,169,
45,17,73,66,18,100,146,158,79,27,51,35,219,67,27,88,175,212,253,125,214,64,67,
3,248,113,213,227,34,152,57,234,73,193,86,103,161,168,89,243,21,63,111,21,76,
21,20,127,229,2,72,214,10,136,194,180,134,35,30,181,170,5,21,1,13,171,72,230,
254,220,211,168,181,79,159,84,215,161,133,23,161,15,21,135,159,23,80,180,243,66,
164,50,82,173,60,245,4,222,117,117,8,95,73,190,168,217,141,131,233,26,143,244,
246,246,146,162,135,166,153,195,28,30,132,26,73,43,169,92,40,139,237,214,36,138,
95,42,128,204,60,76,85,25,135,172,129,118,227,130,15,231,219,128,144,41,78,154,
42,9,201,235,14,79,32,173,49,144,193,12,147,248,34,137,167,77,71,75,153,81,252,
177,173,214,32,204,171,103,58,108,62,163,219,129,171,246,245,77,36,96,28,116,
209,152,203,228,235,62,234,57,214,151,192,4,243,83,211,132,127,2,84,120,33,167,
121,149,82,78,42,29,98,23,187,50,177,230,223,143,108,57,106,154,240,233,196,85,
197,9,175,88,182,254,226,168,197,8,168,171,26,90,88,164,151,212,235,40,242,65,
20,177,148,105,17,74,184,242,27,216,233,252,127,173,239,74,229,78,120,87,171,
24,195,2,86,149,233,127,150,221,212,34,151,39,5,92,10,105,132,81,44,50,141,23,
105,33,109,20,110,228,50,198,22,72,137,140,241,168,146,63,199,219,206,234,28,
250,83,166,4,77,64,71,26,244,241,22,90,12,189,28,144,10,89,105,170,32,165,164,
171,162,168,131,71,236,136,168,161,142,122,25,93,204,140,178,186,168,123,1,107,
41,60,126,118,173,129,81,231,214,180,229,136,111,46,153,170,197,17,46,147,5,
144,213,227,228,163,175,151,204,173,11,199,44,113,184,138,38,64,138,21,102,208,
192,128,92,56,247,185,30,128,48,227,94,170,170,88,144,58,40,251,238,150,143,109,
71,13,68,169,84,17,235,197,64,89,248,73,217,93,141,75,25,9,89,30,84,85,22,7,
129,112,121,230,204,23,85,5,169,142,63,231,255,0,7,75,17,25,201,95,151,76,152,
60,22,238,221,251,115,125,118,142,3,105,100,163,235,253,143,144,192,99,183,102,
255,0,158,154,40,54,246,63,39,149,188,88,141,187,38,82,182,33,73,89,185,107,208,
107,131,31,78,94,174,72,163,121,116,120,209,152,33,125,194,221,39,142,18,192,78,
252,7,18,71,217,233,142,39,31,62,149,139,57,124,34,223,128,87,166,185,55,60,144,
67,45,94,66,145,104,241,48,209,211,248,170,34,36,194,106,103,152,211,254,255,0,
229,26,85,101,176,210,108,255,0,158,109,237,120,147,139,58,209,58,72,96,168,85,
83,87,175,88,114,117,180,24,245,173,158,165,36,198,180,244,146,120,178,113,71,
28,113,207,82,236,145,37,20,181,40,175,56,168,23,212,203,166,193,6,171,241,237,
215,100,77,68,226,163,143,207,211,166,149,36,114,170,172,26,135,135,167,206,158,
158,157,6,21,187,193,169,13,77,28,77,37,64,172,134,154,132,86,203,34,172,62,71,
127,37,76,81,199,28,80,179,67,12,90,68,108,199,80,114,199,155,139,35,150,226,
133,149,77,124,171,254,199,75,163,182,37,67,145,66,9,52,255,0,7,237,233,139,33,
88,147,224,169,154,178,48,202,213,53,115,197,52,70,242,137,23,237,35,149,77,
200,96,164,122,185,255,0,95,159,123,89,7,130,186,134,42,127,201,94,170,35,97,59,
105,198,63,207,215,84,191,229,121,8,218,40,221,149,102,93,55,23,102,209,21,199,
168,184,68,66,188,149,63,211,235,237,213,58,218,160,18,58,100,246,39,113,0,245,
142,187,118,69,67,82,244,48,68,163,233,19,84,73,24,103,210,135,77,227,1,236,125,
77,233,44,108,57,247,183,184,68,62,26,173,51,199,175,71,110,206,186,219,211,
135,250,191,159,65,141,117,117,77,68,177,35,186,169,130,41,34,73,27,76,103,247,
101,111,41,145,136,32,169,13,205,248,30,203,156,177,32,19,192,116,109,28,106,
170,105,192,231,252,221,113,170,168,143,237,107,161,100,149,164,146,52,72,216,
72,173,22,165,33,30,73,21,148,27,126,20,254,47,249,250,251,247,1,32,227,81,214,
244,247,68,106,48,127,212,58,77,83,86,228,176,185,124,118,123,13,152,201,225,51,
184,218,216,43,241,249,156,101,101,70,55,35,140,173,166,43,53,53,109,6,66,134,
88,42,233,43,33,149,67,71,36,76,174,135,144,111,237,12,209,71,34,149,144,85,78,
8,60,15,203,211,165,145,200,69,116,142,3,171,163,162,255,0,133,13,255,0,51,
218,207,142,157,157,241,127,181,59,173,59,159,171,123,87,170,115,253,65,147,174,
223,24,92,100,253,135,137,194,102,224,161,198,190,107,21,191,104,41,104,243,85,
153,234,28,60,18,210,71,61,121,171,103,142,161,218,82,210,4,117,38,147,106,133,
90,169,35,5,102,4,130,106,167,73,4,14,234,145,195,200,240,168,225,210,181,152,
156,48,26,169,213,38,99,171,41,168,92,151,142,77,43,254,109,135,235,121,124,145,
176,243,40,62,141,49,171,40,209,244,36,94,252,251,55,70,1,136,211,81,255,0,21,
210,119,86,101,165,120,244,226,213,81,149,144,83,67,52,111,80,172,24,194,254,40,
94,55,49,50,7,32,57,149,86,75,93,90,203,170,220,223,221,142,7,104,34,191,234,
255,0,15,90,10,106,11,48,52,255,0,15,93,71,81,10,202,209,196,243,65,4,209,172,
115,36,133,95,89,95,83,106,42,20,178,43,139,216,16,72,247,181,96,13,70,20,245,
86,29,160,176,6,157,101,18,172,70,33,25,18,1,38,181,73,81,139,180,111,32,64,
165,84,148,141,27,71,227,215,111,118,215,240,133,245,243,227,213,74,147,170,184,
199,229,235,246,245,23,39,52,117,14,178,180,49,198,148,214,142,24,99,36,68,227,
201,229,113,32,98,101,8,193,143,228,145,239,206,192,231,211,175,70,172,149,90,
228,241,245,24,193,244,234,210,255,0,150,79,242,87,249,177,252,214,163,223,217,
191,142,88,109,165,128,235,238,183,170,160,198,110,62,200,236,188,213,102,219,
218,114,238,44,138,153,225,219,24,25,104,241,153,90,220,230,114,158,128,125,197,
66,67,23,142,154,22,140,202,232,101,141,88,190,107,207,13,218,24,161,105,36,
165,72,4,10,15,42,146,71,28,208,113,193,242,29,44,84,168,169,52,94,134,223,230,
215,252,146,55,47,242,140,216,93,49,148,236,191,150,157,55,219,93,169,218,153,
236,198,55,39,211,155,22,155,41,143,220,155,87,9,143,198,69,95,79,187,25,50,213,
135,35,93,183,166,169,127,181,106,137,168,168,208,206,232,34,50,122,244,53,5,
228,210,78,109,222,48,167,73,39,75,106,211,66,0,13,128,1,53,168,201,224,122,219,
198,129,117,12,231,211,252,29,81,218,121,36,14,117,88,198,202,93,193,99,114,120,
66,24,150,101,7,253,224,251,50,173,65,169,207,73,240,191,62,185,75,19,194,218,
133,213,75,58,219,80,176,104,138,151,2,195,215,164,56,231,232,111,199,189,149,
35,143,94,86,15,229,129,212,186,92,139,193,48,15,125,12,92,88,42,221,65,3,75,
41,60,240,87,145,254,30,236,36,32,247,112,233,182,132,17,142,158,231,149,76,
110,233,34,113,4,74,39,143,80,33,153,141,193,252,134,35,219,141,145,131,211,81,
234,12,162,158,125,55,73,78,36,113,43,4,144,24,238,77,238,204,45,98,88,130,14,
171,159,207,60,251,79,79,219,210,190,20,234,52,148,243,104,14,138,60,97,149,25,
149,74,168,103,83,161,93,203,29,42,192,112,77,135,62,245,80,15,250,189,58,223,
219,212,86,136,166,155,131,25,214,44,77,192,188,77,200,7,144,193,91,253,135,186,
138,241,213,81,214,248,245,129,156,177,37,152,30,73,107,143,211,253,10,253,1,60,
127,135,189,49,161,175,159,250,184,253,157,123,30,92,127,203,214,68,147,74,50,
173,253,94,146,79,167,139,169,63,147,107,91,253,143,187,154,102,188,58,209,4,
143,151,89,140,167,90,200,0,212,209,219,215,99,125,35,242,7,215,210,167,250,31,
167,191,121,252,186,245,120,0,56,244,249,19,200,148,240,204,168,240,58,64,128,
200,64,11,33,145,72,240,220,190,180,22,23,226,252,30,127,197,204,141,62,88,233,
172,126,166,170,156,244,239,21,27,8,160,53,46,27,86,157,73,202,72,21,24,1,17,
147,155,198,159,147,193,55,247,71,52,237,169,175,250,177,213,64,29,218,120,145,
143,79,183,166,138,249,10,214,184,82,164,172,242,125,61,42,64,100,10,0,254,200,
43,205,237,207,182,222,76,224,80,215,253,67,167,80,6,65,171,43,78,147,210,73,
170,118,55,37,73,250,155,243,118,250,114,73,177,35,221,11,122,228,254,222,156,
192,20,24,235,36,31,187,118,99,165,20,157,92,128,214,102,91,127,65,168,127,79,
207,187,168,166,75,119,121,227,253,95,234,199,84,36,37,15,153,63,234,252,186,
199,35,168,47,165,65,32,162,139,219,75,11,159,199,212,134,63,95,122,45,248,105,
231,252,250,181,14,56,211,169,244,83,6,107,204,34,37,245,67,25,62,148,77,17,105,
86,119,31,166,36,191,208,11,183,210,227,219,139,158,39,166,216,99,4,143,245,
127,135,169,19,215,73,62,134,146,225,150,36,176,50,35,51,34,92,31,37,144,17,52,
105,107,0,77,128,191,215,222,201,39,25,29,108,13,53,3,169,88,199,140,202,254,68,
140,150,142,82,16,42,146,85,0,44,222,71,6,195,72,229,141,173,245,62,246,163,215,
141,58,163,212,208,15,151,250,191,213,199,169,84,34,153,169,179,140,176,85,44,
49,210,208,135,163,45,18,137,1,201,193,22,181,91,217,213,100,117,0,234,190,141,
77,110,57,178,211,188,249,127,179,215,155,85,98,225,170,167,252,31,230,235,255,
214,208,66,22,245,128,13,136,4,234,187,114,64,250,155,243,245,231,252,125,248,
103,173,127,135,169,115,222,57,46,165,155,87,34,230,250,92,90,228,63,234,176,
254,131,222,200,243,61,107,30,157,98,50,235,191,167,74,31,162,2,2,219,128,27,
232,13,248,63,236,61,214,153,207,90,28,114,122,117,114,205,44,115,43,167,174,52,
30,149,9,226,101,81,168,18,5,174,126,183,228,17,254,183,187,12,159,151,84,4,82,
128,117,200,72,199,200,170,27,90,160,96,74,0,68,137,250,193,54,179,43,196,62,
191,66,7,191,19,195,30,93,91,129,7,61,117,247,1,20,161,11,235,186,182,146,224,
120,197,155,80,210,72,114,109,99,127,167,189,84,144,7,86,165,72,233,194,130,176,
67,82,210,15,248,230,197,18,102,188,97,212,41,73,65,55,253,192,191,164,126,63,
30,236,113,90,117,230,21,167,82,42,232,85,204,178,211,2,232,172,26,95,36,128,
177,87,23,121,52,168,3,78,166,35,250,159,175,189,12,144,58,240,62,71,143,73,217,
24,106,126,73,26,200,4,14,69,175,167,143,167,227,253,135,189,117,191,62,187,4,
128,84,139,93,81,201,34,215,26,126,191,239,63,236,125,184,160,12,215,143,90,160,
173,124,250,198,202,88,147,169,144,141,2,50,183,42,162,196,158,87,213,110,126,
190,252,71,242,235,103,167,40,64,241,68,163,75,58,149,103,141,88,22,32,144,36,
114,224,128,34,118,250,123,240,38,154,64,7,63,228,234,149,227,214,120,234,140,
76,244,170,250,225,90,132,104,144,177,116,66,101,4,178,129,192,98,7,63,234,184,
191,62,236,24,138,122,121,125,157,110,159,60,245,54,178,95,52,147,52,178,235,21,
18,177,215,165,84,163,52,129,153,157,74,128,141,197,172,45,254,189,189,220,208,
134,7,215,173,1,195,166,207,19,43,148,176,112,24,174,161,200,44,44,44,8,226,252,
255,0,173,207,182,194,26,154,28,117,227,94,29,70,44,98,105,35,101,228,0,13,254,
163,84,170,199,233,253,22,222,247,83,90,129,215,188,192,60,122,234,57,162,104,
202,21,10,196,177,215,127,80,82,22,234,45,250,151,250,131,237,186,131,81,74,10,
249,245,178,58,229,50,159,17,107,89,30,103,179,42,168,28,40,10,164,126,160,183,
28,126,47,239,196,121,252,250,168,227,211,124,36,198,215,32,145,118,111,232,77,
184,189,143,226,227,159,245,253,188,122,115,174,198,180,142,98,120,184,36,129,
250,84,30,126,134,214,44,192,91,223,170,64,52,57,235,216,173,58,179,63,136,31,
203,142,62,238,196,208,247,39,202,191,145,157,87,240,115,226,186,177,150,167,
181,123,115,37,29,110,252,223,52,240,48,242,80,116,175,74,99,106,78,253,236,122,
233,136,208,181,113,211,193,139,137,143,170,161,152,120,201,85,198,228,171,33,
183,183,83,36,227,141,1,33,126,218,3,159,144,252,202,241,234,235,23,226,108,47,
250,191,213,254,126,190,136,31,240,158,159,136,63,201,247,108,117,46,67,187,191,
151,246,221,203,118,254,235,193,229,106,54,134,226,249,39,222,120,44,119,250,94,
201,230,233,147,199,95,46,214,195,84,182,190,185,218,181,202,132,211,199,69,67,
143,122,132,44,36,146,160,134,111,105,45,155,234,110,229,91,144,198,88,194,154,
54,144,1,53,202,168,102,253,164,146,63,139,171,176,210,128,175,3,254,174,61,
108,211,236,227,166,186,109,204,230,49,155,123,17,149,207,230,235,169,241,152,
108,38,58,183,47,150,201,86,72,176,210,99,241,152,218,105,107,43,171,106,101,
107,44,84,244,180,176,179,187,30,2,169,62,233,35,172,72,242,57,162,40,36,253,
131,173,128,73,0,113,235,84,111,229,167,252,197,119,231,243,140,254,112,29,217,
216,27,86,163,33,139,248,51,240,115,173,178,52,29,57,180,106,233,227,52,187,203,
180,247,190,102,93,167,65,219,27,133,66,21,109,195,89,128,162,203,73,139,137,
153,215,31,69,167,65,242,187,191,178,175,9,231,188,178,146,225,127,83,186,64,
167,240,40,1,64,167,13,68,176,98,125,69,6,7,87,213,69,112,188,56,125,191,234,
167,91,101,251,56,233,190,189,239,221,123,173,51,191,225,105,251,7,19,151,248,
41,241,179,177,36,165,160,254,57,178,190,71,54,18,138,190,79,18,228,151,25,188,
54,70,107,248,133,29,43,155,77,45,52,181,56,42,119,145,5,192,40,172,109,237,28,
157,187,133,163,15,197,28,128,252,254,2,63,102,127,111,86,31,3,125,163,252,189,
124,219,169,68,33,86,74,136,166,240,180,65,225,69,98,53,202,111,23,149,223,67,
50,169,145,126,160,31,165,189,155,141,36,84,131,195,164,165,141,104,172,53,121,
253,157,79,164,53,33,252,139,17,171,142,21,96,105,200,97,20,165,2,50,68,20,0,36,
105,25,245,233,252,11,254,125,186,154,188,133,71,167,77,202,16,131,83,66,124,
253,62,125,63,99,38,49,122,38,156,106,154,64,226,37,65,26,70,250,52,206,133,153,
124,133,197,244,150,55,6,222,222,67,76,19,159,245,87,164,115,41,96,8,24,31,183,
229,242,233,113,131,174,11,82,191,111,82,127,97,138,141,47,125,49,176,91,180,
108,69,137,4,90,255,0,143,199,181,177,56,168,33,248,116,93,58,29,57,28,122,18,
176,91,210,175,3,8,81,35,125,160,152,75,41,46,161,229,211,59,2,53,139,120,228,
101,32,216,125,64,246,236,140,66,146,15,111,77,4,86,96,72,205,63,103,70,187,110,
110,58,13,207,133,168,169,2,55,138,72,105,138,5,36,150,1,201,30,101,7,139,242,
15,224,251,186,187,120,101,212,118,244,150,72,215,196,208,223,23,80,106,113,88,
127,184,149,103,125,6,182,58,49,162,63,26,136,214,25,210,105,170,33,4,43,195,46,
133,211,233,32,145,253,125,234,77,18,40,99,241,14,175,11,73,27,105,31,14,127,
216,235,37,85,44,24,220,76,66,154,177,22,146,161,235,196,98,178,105,32,104,232,
154,52,251,122,191,34,182,152,231,133,134,147,248,111,205,253,167,81,165,104,14,
15,175,167,74,201,212,212,35,56,233,133,119,4,67,25,78,130,134,187,35,229,200,
172,82,24,105,130,249,235,32,116,142,148,73,57,208,141,2,168,186,200,72,28,115,
238,165,254,220,245,112,132,30,32,116,245,45,53,115,45,101,44,38,10,236,207,220,
125,213,45,48,89,105,169,151,19,61,133,74,213,77,25,11,19,150,82,11,169,177,250,
222,222,232,106,9,211,151,255,0,39,91,20,168,60,23,246,231,167,156,187,26,250,
28,125,82,211,191,249,84,194,3,73,49,105,36,188,1,4,166,156,88,134,96,164,142,
71,44,62,190,221,36,48,82,71,77,5,42,196,87,61,55,35,210,208,57,90,105,138,67,
5,85,60,113,77,84,34,209,51,89,164,104,188,72,84,69,81,173,141,174,62,183,183,
187,10,3,66,113,94,180,117,26,146,51,79,46,132,152,95,248,154,83,52,194,146,151,
32,212,225,226,242,74,165,167,162,167,4,209,76,140,250,145,2,59,6,117,91,92,30,
121,30,212,26,48,21,165,105,211,35,182,190,149,255,0,139,232,66,166,197,213,71,
68,213,117,38,106,129,79,78,137,91,90,18,212,113,209,187,2,191,108,237,119,157,
213,141,207,234,36,90,222,247,160,133,173,124,191,46,168,92,22,237,3,229,246,
244,215,184,182,243,45,68,114,70,143,18,152,169,164,72,216,132,147,75,0,183,119,
95,67,88,155,17,112,65,247,178,153,7,175,9,49,158,61,6,27,163,46,48,114,206,
100,166,89,209,228,251,38,71,105,81,169,164,26,109,34,233,99,24,118,63,67,111,
233,237,51,190,159,46,159,141,53,80,3,67,199,168,212,217,12,126,82,4,2,73,101,
154,157,244,199,80,74,188,144,31,236,199,45,130,7,43,115,172,218,255,0,239,94,
232,90,189,58,170,203,229,131,214,44,222,39,37,80,242,206,245,234,180,136,242,
10,138,55,104,132,83,35,70,250,156,43,220,1,8,91,181,174,1,228,126,15,191,72,
13,78,124,186,212,108,180,225,158,148,24,93,221,22,219,175,160,254,34,245,146,
199,54,62,158,162,166,36,18,51,84,44,248,248,210,152,192,146,2,1,12,229,102,228,
107,44,44,71,183,21,202,120,96,240,243,253,157,54,209,235,241,10,128,58,107,222,
219,178,146,26,104,170,140,242,134,163,197,160,56,79,183,74,111,27,69,20,50,154,
137,170,98,2,54,30,144,186,145,175,172,17,245,62,247,59,174,144,71,16,120,117,
88,35,58,136,243,62,125,27,63,229,115,252,173,123,151,249,199,247,102,227,219,
88,140,252,157,107,241,227,171,106,176,217,62,228,237,41,104,167,172,170,199,
201,152,144,189,22,194,218,52,147,72,177,85,111,28,254,62,154,162,69,242,63,134,
138,20,51,74,173,116,71,14,110,23,243,107,250,107,85,6,118,21,207,4,28,53,55,
174,120,40,203,80,230,128,144,32,180,180,74,9,36,224,49,246,245,111,63,240,169,
46,145,248,217,240,135,227,71,242,238,248,107,241,235,5,65,214,251,79,3,189,
119,238,246,196,108,124,50,87,53,102,126,106,92,38,35,111,231,123,31,126,230,
170,36,48,238,77,201,147,172,171,142,17,83,83,229,172,121,37,150,205,28,10,177,
146,171,40,12,91,190,160,250,135,131,220,73,171,18,205,231,229,157,56,3,0,10,80,
10,116,186,226,134,216,168,20,206,7,90,147,85,237,216,55,6,42,146,156,229,102,
164,83,78,90,162,137,170,18,24,101,174,80,124,21,113,179,134,87,138,0,46,85,174,
1,4,173,143,177,150,128,232,1,122,124,191,203,208,116,72,81,240,149,167,3,254,
78,147,85,248,201,105,41,196,117,121,55,200,66,180,211,28,190,106,75,181,61,77,
123,160,142,153,105,162,62,134,79,29,163,114,128,18,198,230,246,62,246,233,64,
160,189,113,147,243,242,234,170,218,216,149,74,26,224,121,211,231,254,174,29,34,
179,244,209,211,9,167,104,204,198,137,49,19,83,208,69,28,102,6,215,26,171,203,
52,136,11,36,79,167,134,91,88,139,123,75,40,10,114,56,83,165,81,18,64,28,43,90,
158,161,84,206,27,29,73,76,241,153,170,171,234,170,36,129,32,46,35,163,138,69,
128,149,157,230,102,84,88,164,22,0,253,88,128,61,250,180,64,60,201,253,157,121,
82,172,231,240,129,231,231,246,117,141,179,41,136,45,137,146,178,17,35,249,103,
102,154,45,18,139,60,145,105,89,77,209,174,35,212,8,36,115,248,62,212,44,202,
138,99,213,146,51,94,147,180,13,37,36,208,104,49,210,54,182,170,146,105,227,47,
32,158,65,27,92,196,205,32,80,28,21,47,34,89,88,126,109,254,195,219,44,202,72,
233,245,89,20,29,56,94,153,178,115,183,220,170,149,113,169,80,157,67,214,225,
154,247,42,56,0,31,165,249,183,182,228,98,88,31,245,30,148,64,189,141,242,235,
182,119,120,165,45,164,122,36,11,41,213,251,141,169,9,214,220,169,208,62,159,
208,127,175,238,184,53,234,198,149,24,233,75,213,61,73,217,221,255,0,217,251,23,
166,122,131,103,102,55,247,104,118,78,126,135,107,108,173,155,132,134,57,242,
153,220,198,67,246,224,165,167,18,180,84,240,199,26,6,146,89,164,120,226,130,53,
105,29,149,21,152,36,185,157,33,67,35,154,40,251,77,107,64,0,2,181,36,224,1,146,
79,74,227,74,154,47,159,242,234,207,127,153,47,242,66,249,61,252,172,250,39,
164,251,111,228,246,250,233,232,55,71,116,238,236,214,217,161,234,13,149,185,
170,247,38,235,219,80,225,176,212,217,153,178,153,92,131,81,81,225,242,52,241,
180,226,158,115,64,106,97,130,118,64,102,96,234,73,116,119,111,44,226,22,128,
165,84,176,169,21,160,160,200,21,165,107,140,230,134,188,58,80,80,5,213,90,158,
169,172,10,103,86,121,26,120,208,194,230,148,43,71,41,122,180,40,186,100,26,80,
248,95,159,160,184,255,0,27,123,49,90,10,212,144,190,95,111,249,186,104,234,160,
2,152,63,102,58,234,25,93,74,105,77,113,35,198,172,164,49,142,71,45,171,67,70,
8,98,36,208,5,133,190,159,215,222,241,94,189,211,135,165,154,208,183,149,217,
172,98,49,178,180,108,196,218,54,5,71,170,252,14,121,62,253,67,138,117,163,138,
106,224,58,144,8,62,153,53,59,33,65,126,84,233,86,177,8,226,218,130,17,96,62,
182,191,244,30,246,126,125,80,209,64,167,195,215,10,216,91,68,65,89,24,202,100,
17,180,110,172,183,184,10,172,196,113,193,224,113,254,223,221,30,160,3,92,117,
116,53,36,255,0,135,173,187,122,167,254,20,1,75,252,184,63,147,231,68,124,32,
248,127,186,113,253,137,243,35,116,226,247,62,83,119,239,250,125,143,142,194,
108,143,140,116,123,231,59,95,90,187,103,31,84,209,69,254,149,187,118,158,42,
144,227,35,82,38,164,160,150,109,50,180,191,111,12,0,142,40,238,93,238,134,99,
129,164,36,156,6,165,41,69,243,238,165,75,26,105,4,42,10,141,65,81,43,69,243,96,
63,213,255,0,21,251,122,171,141,211,241,67,226,60,61,41,216,127,37,191,152,87,
243,68,139,126,124,201,223,123,95,55,184,182,95,198,254,140,251,175,145,93,157,
46,252,200,210,79,89,182,233,187,219,182,170,170,235,118,78,211,213,95,42,28,
150,58,58,182,158,130,22,42,178,153,84,192,53,20,243,16,177,216,90,5,132,55,226,
82,42,43,150,252,32,122,214,174,199,205,71,94,101,25,50,62,127,213,254,175,47,
183,170,88,167,141,230,46,254,54,159,132,67,20,113,177,23,99,101,81,227,42,53,
150,110,1,60,251,63,74,29,70,149,52,233,27,16,186,6,170,103,253,92,122,113,169,
142,4,118,167,54,251,136,217,3,200,46,35,208,87,252,208,86,26,67,88,115,244,55,
247,118,165,105,76,244,218,113,13,229,252,250,139,45,63,238,196,174,1,5,127,109,
173,111,211,123,3,249,255,0,17,245,36,123,211,12,142,172,173,80,198,191,104,255,
0,87,175,93,23,150,153,231,142,233,98,161,89,128,212,161,77,175,112,65,210,
223,155,255,0,188,251,168,197,69,122,208,238,240,201,25,7,252,29,116,181,186,93,
36,83,121,21,29,14,159,72,179,41,1,131,3,114,109,245,247,90,228,103,167,233,92,
31,46,178,67,51,76,218,101,127,28,92,53,175,114,74,130,65,85,107,234,28,88,223,
233,239,102,128,254,125,123,36,87,169,11,11,50,153,67,160,13,41,65,20,162,210,
105,11,168,200,136,163,74,70,52,233,54,252,155,123,175,104,160,32,83,253,95,229,
235,66,157,51,200,183,36,0,1,245,112,191,129,126,127,193,151,159,240,246,219,
233,213,67,196,30,182,49,154,99,174,126,2,176,234,140,150,58,130,27,217,185,107,
50,254,44,62,156,254,125,186,9,35,135,94,20,207,82,232,98,243,73,4,126,50,237,
42,178,36,100,27,29,45,235,70,39,157,5,46,75,11,90,195,243,239,98,128,252,143,
90,38,130,160,30,148,148,208,132,90,66,201,247,4,64,52,41,99,227,137,75,18,201,
26,253,57,183,169,185,36,251,115,32,45,114,105,251,51,81,249,244,203,100,178,
128,1,45,249,159,243,122,245,130,190,177,214,68,71,123,191,145,143,136,27,105,
212,250,128,58,121,213,107,127,135,182,25,91,89,52,193,57,255,0,55,217,255,0,21,
211,168,5,56,230,157,50,79,35,189,67,144,127,181,49,63,235,16,164,143,167,245,
30,234,193,117,149,205,7,78,84,1,212,5,85,122,133,91,159,85,138,218,228,150,
228,219,243,97,253,125,213,69,90,128,15,245,127,151,173,55,15,159,89,228,244,
254,218,93,66,128,89,77,245,72,75,27,179,255,0,100,16,15,28,253,7,187,53,74,133,
35,237,234,160,102,167,136,234,53,140,138,64,28,151,250,233,182,155,219,234,
199,241,199,189,80,80,227,135,250,191,212,122,176,52,165,79,151,92,163,86,95,74,
219,211,172,146,79,31,79,247,143,246,31,95,118,205,59,71,31,179,253,95,183,170,
212,53,77,58,158,161,66,121,28,147,175,131,244,22,176,179,134,60,128,199,155,
125,57,246,231,153,235,217,244,235,138,60,110,116,154,128,138,167,143,34,220,
232,185,141,163,225,88,50,186,159,245,135,212,251,240,96,106,65,235,192,99,135,
83,35,157,98,142,162,29,81,44,53,58,35,241,153,67,121,105,163,153,37,18,137,67,
221,26,48,132,114,220,131,239,117,227,156,117,162,42,65,244,235,255,215,208,70,
157,25,153,138,18,2,131,201,183,233,4,27,27,3,201,247,175,240,117,66,105,131,
212,233,144,48,12,5,248,178,173,216,217,64,211,168,127,64,88,95,235,238,248,242,
167,14,173,95,159,80,72,60,133,28,216,11,0,44,225,79,230,231,142,125,215,230,79,
250,189,58,169,193,169,225,95,217,214,88,201,229,45,234,210,57,37,141,138,220,
216,3,192,226,227,253,135,191,127,135,175,80,156,244,237,78,81,188,38,66,108,69,
191,114,80,138,84,141,90,28,155,157,49,253,71,31,81,111,118,82,7,30,63,203,170,
208,138,250,245,212,244,229,70,162,161,73,84,117,69,123,234,18,18,14,146,9,212,
202,15,168,126,61,210,157,88,31,33,214,21,104,84,72,161,73,11,196,110,186,172,
228,50,146,206,9,60,15,197,191,39,250,123,176,36,84,83,171,103,29,79,130,172,68,
241,134,4,34,145,33,80,196,53,194,158,89,65,0,175,224,143,247,143,126,168,13,
242,235,199,236,207,81,170,21,88,188,177,0,0,55,0,127,182,36,106,98,192,177,250,
243,239,116,12,212,3,29,123,243,207,81,237,170,218,133,248,67,203,94,192,11,216,
88,242,46,127,215,247,101,26,79,197,65,195,253,95,179,173,122,30,176,131,169,
136,44,64,103,93,68,91,133,36,223,235,115,239,102,162,162,184,235,124,7,78,17,
105,10,60,154,202,200,238,154,148,106,148,70,53,89,205,135,11,172,128,8,227,240,
125,215,133,43,192,117,67,94,20,224,58,143,85,251,42,106,4,129,244,79,10,8,204,
90,4,138,99,36,179,55,4,186,180,99,128,62,135,222,171,81,220,115,95,242,113,
235,124,69,15,92,163,170,77,50,89,91,91,72,36,23,80,218,64,253,32,106,60,126,
163,201,255,0,15,118,14,0,29,111,202,189,76,90,138,114,8,101,117,96,64,54,62,
146,160,115,170,237,112,236,223,236,61,184,25,124,188,250,173,43,142,186,127,20,
130,161,236,98,58,84,141,55,39,153,16,0,111,113,233,181,207,182,219,67,112,193,
175,91,165,41,212,5,79,64,210,99,102,212,222,145,195,104,1,73,107,31,170,177,
252,123,169,90,29,62,149,252,255,0,213,229,214,199,31,151,82,170,245,70,176,3,
195,43,112,44,111,164,128,69,195,1,197,207,186,156,18,64,167,85,3,142,49,211,
105,67,168,122,73,62,161,107,159,169,38,196,125,46,125,190,164,30,7,173,169,175,
92,151,95,219,191,7,135,30,171,220,139,105,210,27,235,199,191,30,21,61,91,169,
25,156,174,99,63,44,85,121,188,157,110,86,162,150,146,26,10,121,178,21,147,85,
203,13,13,48,127,183,165,133,231,119,104,233,105,203,157,8,44,169,123,1,237,176,
136,139,216,160,10,245,226,77,122,250,82,127,194,43,246,230,127,25,240,67,228,
134,123,37,215,177,224,112,187,143,228,92,127,221,190,195,106,17,5,71,96,195,
137,217,152,186,44,173,7,222,55,238,87,210,108,204,129,240,161,30,136,228,171,
145,71,171,95,178,248,243,127,118,64,168,8,130,190,135,184,233,253,132,31,207,
230,58,112,252,11,246,159,242,117,185,119,181,189,83,162,209,243,55,175,54,223,
109,124,73,249,41,214,91,199,125,30,177,218,187,235,164,123,43,108,238,14,196,
251,232,49,169,178,177,57,109,167,148,165,173,220,211,214,212,207,77,79,5,46,34,
23,51,75,228,145,17,162,70,5,128,55,246,146,249,67,90,77,169,194,128,43,83,194,
160,130,1,249,18,40,71,152,52,234,201,241,14,190,82,95,200,219,249,158,225,191,
148,255,0,205,221,209,190,119,246,243,223,249,223,140,185,173,183,190,246,223,
97,237,94,178,198,80,101,127,210,142,79,13,139,205,69,213,121,68,198,101,171,
168,32,167,138,159,61,84,181,17,84,26,132,106,120,103,109,90,129,35,223,167,138,
89,62,150,230,56,169,58,241,21,167,105,25,83,228,69,105,229,229,81,158,168,140,
171,169,9,237,61,92,87,85,124,193,254,105,253,89,243,163,160,127,157,39,115,203,
218,155,7,249,112,252,219,249,77,75,215,120,94,173,220,125,175,38,228,194,97,
250,143,180,229,172,219,219,83,239,250,233,107,159,29,128,198,98,177,216,232,
235,168,178,34,142,1,37,69,25,104,189,50,134,114,207,210,137,11,170,159,172,70,
103,46,6,31,75,86,68,4,229,128,82,84,2,41,218,41,149,195,227,81,193,61,134,130,
158,158,135,175,163,188,114,36,209,199,44,78,178,69,42,44,145,200,132,50,186,58,
134,71,82,56,42,202,110,15,244,246,122,8,32,17,192,244,207,84,17,255,0,10,92,
248,123,83,242,239,249,80,247,146,96,40,141,102,250,232,7,199,252,133,218,49,
198,186,170,42,34,216,17,85,182,240,199,195,114,22,245,123,46,186,185,237,98,89,
161,80,57,62,209,222,126,155,91,93,15,244,55,161,255,0,74,253,167,246,26,55,216,
58,186,228,58,250,143,240,117,242,58,193,75,89,247,17,72,25,202,24,133,54,184,
150,25,39,240,72,12,109,20,16,204,82,54,114,140,69,137,2,199,147,111,103,17,150,
168,32,159,242,211,162,249,180,233,97,231,90,254,125,45,96,139,23,77,247,107,
141,170,168,74,200,160,14,149,85,178,66,101,130,250,110,145,197,77,230,166,67,2,
146,175,234,212,77,192,31,79,106,198,129,168,43,16,212,243,227,252,170,58,70,90,
103,43,226,160,240,137,224,43,252,235,67,209,232,254,92,95,203,143,181,255,0,
154,23,123,230,126,62,245,63,110,245,46,194,236,42,93,141,147,223,88,106,126,
210,202,229,232,134,237,135,1,85,71,6,83,19,182,198,27,13,150,168,159,33,77,73,
82,106,229,86,69,9,78,140,110,116,144,11,47,174,229,129,161,1,12,143,33,160,
200,28,1,60,79,153,0,208,124,143,75,237,227,141,195,0,154,66,143,228,127,205,
213,138,127,48,95,248,77,223,206,79,229,209,241,103,111,124,172,220,219,147,103,
247,14,11,19,60,209,119,166,219,235,58,44,189,93,111,74,210,201,80,105,241,27,
158,174,186,176,39,247,171,104,84,18,177,213,215,211,193,78,40,37,145,12,169,
227,99,34,167,131,114,153,100,140,220,91,152,145,141,20,147,82,13,104,3,83,3,87,
225,161,32,240,168,36,3,185,108,208,169,8,213,52,251,63,213,78,168,50,44,197,45,
117,21,70,138,141,51,202,21,191,108,122,21,128,4,172,129,133,180,57,31,226,127,
167,179,241,50,200,173,221,147,209,87,130,241,186,209,123,71,66,30,216,223,181,
155,114,58,216,161,173,177,168,164,162,65,74,36,43,18,201,25,145,34,141,41,211,
137,203,121,13,190,156,219,219,226,112,136,192,182,116,255,0,171,254,47,164,230,
219,196,101,170,31,136,255,0,170,189,9,249,92,198,232,198,215,83,98,119,222,15,
112,109,60,156,116,49,79,246,155,135,9,145,196,87,45,45,98,172,244,245,205,69,
95,5,52,223,111,86,146,126,204,129,116,53,193,4,143,116,138,230,43,132,86,73,3,
10,241,20,35,249,117,231,183,146,22,106,46,124,186,93,205,184,106,171,182,125,
37,52,18,153,89,42,106,231,146,10,198,140,22,52,172,137,12,76,100,60,187,133,
185,91,0,182,0,31,119,122,132,199,14,171,16,6,76,142,234,14,29,112,92,162,207,
75,73,142,172,169,174,167,21,53,117,70,161,197,100,83,82,58,43,91,194,60,32,74,
212,147,142,53,126,8,176,7,219,37,171,77,68,212,244,240,94,210,64,29,41,254,247,
23,134,166,171,161,148,84,25,106,233,35,142,155,38,203,52,53,53,52,162,210,81,
203,60,197,130,26,49,25,250,42,135,8,5,215,241,238,186,128,20,245,235,122,89,
141,64,20,244,255,0,15,75,90,74,170,105,41,177,249,2,154,169,34,149,244,188,50,
203,58,60,232,232,124,173,44,173,27,67,21,67,27,133,224,127,136,246,242,48,173,
122,100,161,161,81,233,208,225,240,239,224,255,0,203,95,230,57,218,121,126,185,
248,161,214,242,103,40,118,221,84,75,190,123,3,63,50,224,58,219,98,69,87,29,77,
77,52,155,139,118,75,79,81,4,89,42,212,133,205,61,29,58,79,89,57,30,152,136,
187,2,235,173,197,32,113,26,171,52,199,130,173,9,167,169,38,128,15,153,32,122,
84,244,186,222,197,228,93,71,135,169,255,0,7,207,160,135,118,237,205,235,212,
221,187,217,125,33,189,227,251,61,247,211,251,203,45,215,59,180,209,84,73,61,42,
230,118,198,106,124,54,78,108,69,84,177,194,213,20,111,81,75,170,55,49,173,226,
183,164,94,222,213,217,94,45,228,49,76,128,128,64,227,199,230,62,209,195,164,
183,86,198,6,117,106,84,87,165,230,3,41,145,167,165,157,100,203,74,244,130,121,
161,198,125,253,111,162,173,27,67,53,125,68,1,75,180,116,207,117,1,111,123,114,
61,152,171,16,15,127,158,63,207,210,2,1,43,217,159,58,14,179,118,15,104,109,
204,102,68,180,85,137,247,84,244,244,149,21,109,3,33,166,154,68,85,69,77,82,58,
194,228,134,12,52,241,113,253,108,61,218,73,227,82,115,158,181,21,188,140,0,211,
138,244,229,241,115,225,191,202,159,230,63,189,55,133,95,76,226,241,187,75,168,
250,255,0,239,119,31,111,252,144,236,138,138,157,175,209,61,91,183,168,40,228,
171,201,87,110,61,207,37,52,212,249,28,158,55,19,76,243,12,125,10,212,214,29,58,
153,82,51,172,7,47,247,104,160,46,1,213,32,21,160,242,30,173,232,60,135,153,224,
160,156,116,125,105,183,146,23,80,160,255,0,87,14,130,206,226,207,124,94,196,
110,157,187,177,190,39,239,30,213,236,156,38,207,138,179,27,191,251,223,176,113,
148,24,74,78,216,220,10,218,102,205,117,231,90,208,197,81,89,177,182,60,14,172,
152,248,242,117,181,121,74,216,191,118,127,3,31,10,235,111,150,254,93,82,222,50,
170,159,133,64,202,253,167,204,255,0,47,178,180,27,186,138,4,26,99,82,79,169,
243,233,146,175,60,181,240,207,70,141,82,211,82,233,70,158,174,57,233,37,153,
106,17,137,154,56,155,146,168,223,155,91,80,211,200,30,206,221,170,105,231,78,
138,163,74,103,203,166,28,130,214,187,3,54,81,229,154,147,27,71,28,13,60,130,51,
246,200,176,76,100,229,78,137,80,2,160,47,12,27,213,248,247,231,38,170,43,144,5,
58,216,165,13,23,4,244,128,108,30,254,238,222,210,217,61,51,210,251,95,49,190,
251,79,178,51,56,205,159,179,118,142,223,134,108,134,71,53,154,202,191,218,210,
194,145,68,36,81,12,65,140,179,200,223,181,12,40,206,236,170,164,132,23,247,113,
67,19,72,198,138,61,51,83,229,79,82,120,0,56,156,14,151,89,219,51,178,227,175,
172,23,242,133,254,93,123,115,249,101,124,40,235,175,143,148,242,208,102,59,42,
184,73,190,251,203,121,81,71,233,221,125,171,184,160,167,124,227,211,206,229,
166,151,11,183,160,134,28,94,56,51,31,242,74,69,123,6,118,246,69,111,27,143,18,
121,135,235,200,106,126,64,124,43,254,212,113,245,98,199,207,163,179,64,2,175,
194,63,213,94,136,175,243,229,254,72,219,159,249,193,226,122,83,43,214,253,237,
182,122,139,125,116,67,238,202,10,42,93,215,180,234,179,155,119,113,82,110,185,
112,245,53,208,214,102,240,179,174,115,19,91,143,151,15,23,137,82,42,136,125,
111,169,67,16,67,100,76,46,154,226,223,67,141,1,72,36,130,8,36,224,128,69,115,
144,70,61,122,217,0,168,86,168,243,235,89,117,255,0,132,125,255,0,50,124,62,127,
237,40,62,70,124,102,202,96,41,113,239,37,54,104,102,123,14,134,162,106,132,75,
174,53,177,115,108,249,101,136,205,39,30,95,33,65,245,39,241,237,80,191,190,79,
248,136,73,30,142,180,254,116,53,252,191,62,147,53,164,45,94,225,251,58,213,239,
47,129,220,155,67,124,238,254,188,220,181,82,227,55,118,193,222,251,139,102,
103,105,218,70,158,146,12,182,219,204,85,98,114,174,98,49,221,192,174,160,116,
83,96,10,155,240,61,156,89,92,139,168,161,154,55,32,48,4,87,208,231,135,175,69,
119,48,136,93,131,32,35,207,254,47,165,22,226,198,97,154,28,180,148,159,114,106,
150,10,13,66,153,98,20,147,77,44,140,138,199,238,89,24,248,25,9,113,30,160,47,
127,175,181,210,172,103,93,43,171,249,127,62,144,194,210,22,136,26,105,207,219,
252,186,11,233,241,117,240,195,78,94,70,138,57,50,18,37,181,45,157,196,113,72,
36,84,110,85,86,53,54,36,126,61,165,85,58,69,78,9,233,99,186,106,63,233,122,
105,174,90,58,200,161,134,174,21,180,206,237,43,74,169,35,85,164,51,183,144,43,
149,13,77,35,39,32,175,4,255,0,175,238,199,77,59,191,63,219,213,106,193,137,83,
254,170,116,144,200,237,223,183,168,41,142,127,34,170,171,211,168,33,218,113,
168,179,197,172,27,137,20,90,203,207,39,235,238,134,58,87,79,15,46,157,89,65,95,
212,25,60,122,100,173,163,168,146,182,138,157,163,43,44,178,197,18,197,34,253,
184,18,121,116,188,108,110,90,51,97,205,212,115,238,165,73,101,95,196,113,213,
163,96,145,200,195,34,135,134,113,212,38,146,175,193,92,165,216,40,153,204,148,
240,144,96,28,159,221,95,201,10,160,131,107,123,175,112,4,19,231,211,227,65,104,
202,250,121,241,234,211,191,146,239,76,127,49,29,233,243,143,170,187,107,249,
119,117,35,118,15,99,244,222,235,167,200,215,238,205,213,139,146,62,153,218,84,
121,156,125,118,46,168,118,134,230,159,197,69,133,195,228,241,21,21,9,227,138,
111,226,18,165,254,217,26,75,123,36,220,94,38,164,37,137,152,144,84,46,90,170,
106,13,14,41,81,146,212,95,83,209,132,33,169,171,246,215,134,127,213,246,245,
181,23,243,8,255,0,132,185,255,0,48,239,154,120,195,242,67,180,254,125,237,239,
144,191,51,179,121,56,191,141,236,141,209,130,200,108,126,136,217,251,98,174,
127,57,218,157,89,145,73,178,149,184,12,46,218,70,49,193,15,240,170,116,171,176,
121,0,148,187,178,88,150,234,218,140,182,234,193,143,119,117,95,134,9,102,160,
63,96,160,94,11,142,157,58,91,139,16,127,151,90,65,124,190,248,125,222,63,4,
254,70,239,239,139,159,33,48,216,188,63,101,245,244,216,232,50,209,224,178,84,
187,143,11,144,197,231,40,105,178,248,108,206,222,201,67,225,251,154,12,166,54,
173,38,132,186,193,50,130,86,68,70,5,125,153,219,78,39,82,85,72,32,149,32,241,4,
121,122,124,234,13,58,98,69,11,147,246,250,15,207,162,218,33,142,26,122,149,141,
195,72,178,66,146,35,241,56,2,77,78,212,241,141,107,97,34,40,212,9,111,240,183,
181,56,163,80,231,170,96,148,36,99,253,92,122,192,62,230,118,152,180,199,214,84,
52,178,11,137,3,204,169,172,185,60,58,18,57,28,143,240,247,225,82,73,235,102,
130,148,28,58,150,165,161,139,65,144,176,82,87,234,13,130,177,187,35,22,211,164,
158,108,63,62,244,69,42,15,85,168,60,71,161,252,250,62,255,0,14,127,149,183,207,
207,230,3,61,44,223,21,190,55,239,221,251,180,91,46,112,245,221,153,83,73,30,
215,234,252,85,114,48,90,159,190,223,91,134,108,118,13,164,160,12,12,241,211,75,
81,81,29,192,49,220,128,80,205,121,10,49,136,106,121,7,225,80,73,252,233,129,
249,145,211,171,22,43,64,43,235,214,223,63,13,255,0,225,21,187,109,182,118,71,
47,243,187,228,174,116,111,156,144,140,97,118,119,199,81,65,22,15,109,195,166,
243,73,158,221,123,211,5,87,62,224,200,200,252,8,169,104,169,169,226,3,252,236,
164,240,156,53,236,195,85,22,21,167,2,53,55,231,66,0,251,1,63,104,225,211,148,
69,249,255,0,46,169,143,249,179,116,39,242,108,254,91,187,27,112,252,46,248,
169,69,154,249,157,243,79,43,87,61,15,105,252,143,223,123,231,33,62,218,248,239,
73,73,86,39,93,191,181,112,27,14,108,54,198,203,246,85,80,95,183,168,134,84,
174,139,25,10,185,168,99,80,235,12,76,192,46,110,167,141,214,232,152,84,228,168,
1,91,250,42,50,72,254,38,44,71,146,230,164,109,217,17,79,102,127,159,250,190,
84,251,122,215,42,26,121,41,140,177,36,169,246,254,8,150,89,0,58,151,82,137,13,
214,32,206,179,36,128,130,202,24,40,250,251,16,41,166,9,199,69,205,220,7,241,87,
168,50,205,9,19,41,170,15,170,160,74,168,164,235,73,5,131,51,75,50,166,165,113,
244,183,63,212,123,211,17,67,221,211,138,166,181,43,76,83,175,84,84,164,139,2,
196,1,177,146,71,36,126,166,231,78,179,249,123,126,7,30,234,205,195,173,132,61,
222,134,159,46,155,231,144,188,142,204,120,42,132,216,5,182,144,0,26,121,250,
127,79,235,238,164,146,115,213,213,116,143,159,88,22,38,147,89,0,1,112,75,27,
128,183,23,177,28,253,125,235,212,147,213,143,217,215,106,198,41,7,245,176,229,
143,35,252,8,250,31,167,227,253,191,189,154,121,245,236,240,175,30,157,226,40,
242,234,26,131,150,45,164,145,234,191,54,83,126,121,63,235,219,223,184,28,28,
112,235,126,89,234,12,202,69,67,130,24,250,141,148,242,196,254,126,131,158,125,
212,138,208,208,96,255,0,197,127,147,175,3,215,63,29,195,41,13,166,53,50,176,81,
207,3,244,128,77,139,22,96,63,216,251,221,77,43,231,215,188,248,116,233,139,66,
181,148,193,100,88,142,161,25,111,36,146,39,142,72,191,119,72,98,2,42,147,234,
191,231,250,251,184,168,34,156,107,211,82,1,161,235,194,157,42,170,36,142,158,
138,148,162,248,131,81,152,224,119,4,52,214,121,23,201,28,99,144,132,142,9,250,
251,187,157,34,167,142,158,31,229,233,168,199,113,166,51,154,127,148,244,137,
158,64,211,122,73,39,201,119,102,58,155,251,28,2,120,31,210,227,218,119,52,60,5,
122,85,90,131,215,37,137,222,89,27,78,160,179,73,96,160,181,201,8,5,192,185,63,
95,246,62,232,169,64,9,90,131,229,214,133,41,231,94,154,102,111,242,151,36,184,
26,10,168,140,88,220,241,163,232,52,144,220,31,118,161,169,44,0,61,108,100,10,
12,215,174,74,86,73,20,51,49,212,64,185,189,180,143,66,130,192,158,46,1,227,
243,239,64,26,3,76,159,243,103,175,82,158,121,234,91,132,17,20,141,126,178,176,
98,91,234,127,4,11,131,115,167,243,239,100,225,130,212,15,246,58,169,39,174,
224,64,75,220,95,76,82,23,43,244,30,139,134,255,0,16,73,250,251,178,140,224,98,
157,107,228,61,122,137,44,193,148,34,0,21,88,179,158,73,63,166,227,155,240,195,
221,89,170,66,143,63,245,127,179,213,192,30,125,98,28,169,107,139,127,180,242,
88,150,23,213,249,63,95,119,24,20,166,127,151,91,160,192,249,245,193,84,233,
147,250,233,7,87,227,153,17,180,243,244,23,31,143,117,213,228,56,121,245,172,
112,242,235,255,208,208,98,16,21,91,72,26,152,61,207,233,42,7,224,216,219,143,
246,222,246,181,173,122,173,120,117,53,72,49,88,233,22,79,202,159,200,4,48,177,
224,139,219,159,126,7,53,165,58,240,251,60,250,131,50,48,98,116,240,223,143,160,
231,145,127,245,55,252,127,79,122,60,73,175,3,215,189,122,236,149,13,19,184,33,
108,9,0,253,79,208,89,190,163,145,239,95,103,30,170,9,207,83,169,234,162,85,45,
166,36,42,235,113,34,106,87,80,77,238,164,150,37,56,54,31,211,159,118,7,134,6,
58,241,6,153,61,101,58,133,155,208,86,85,14,68,101,77,131,57,42,69,205,148,144,
110,121,183,187,1,143,232,211,252,191,203,171,12,30,177,24,71,173,17,151,87,140,
184,224,170,157,38,230,206,79,37,69,237,253,125,210,149,234,223,62,184,88,17,
123,136,205,193,3,73,100,62,158,77,218,204,24,159,126,175,168,199,85,249,249,
245,204,74,201,245,69,54,82,198,247,32,218,220,16,127,85,135,250,214,191,187,22,
248,134,172,112,255,0,87,219,215,191,60,117,198,87,12,223,182,170,46,137,192,4,
15,210,183,32,18,79,191,3,81,74,208,117,186,226,167,168,151,210,92,17,115,164,
88,216,220,114,126,128,219,129,127,118,35,204,154,126,125,123,231,215,112,85,
136,88,71,33,147,197,201,188,36,43,221,173,195,51,3,173,5,190,156,11,159,117,45,
199,63,234,29,104,173,126,222,185,100,106,161,145,52,65,37,68,250,164,142,86,
121,128,85,5,35,84,185,80,9,12,24,145,123,216,129,254,62,244,72,251,122,242,130,
41,192,117,29,95,212,178,112,252,106,63,85,12,1,212,65,3,158,127,167,186,117,
238,31,183,252,61,76,71,187,133,11,250,152,221,73,250,18,120,250,241,101,6,195,
221,193,10,56,84,131,142,189,246,112,235,50,74,182,113,160,3,164,126,110,67,7,
22,2,224,251,116,145,76,158,207,245,113,235,196,31,46,61,99,65,172,45,136,62,
166,22,110,9,99,107,125,46,162,195,253,183,182,188,169,231,214,243,156,245,34,
178,66,172,18,228,152,244,128,26,206,1,23,36,6,191,32,123,245,117,30,227,142,
180,6,14,49,212,104,129,242,14,11,6,55,23,224,181,249,183,23,224,129,205,185,
247,226,52,210,135,184,126,206,189,167,135,89,37,142,208,198,87,82,179,146,108,
108,111,102,99,249,2,252,31,118,18,28,87,173,85,129,200,233,178,70,10,30,246,63,
75,128,44,63,199,128,72,28,147,239,122,129,224,41,214,250,250,225,255,0,194,91,
122,31,176,250,27,249,63,116,149,39,100,99,171,240,185,62,209,221,253,133,220,
152,28,54,73,38,130,182,135,102,239,124,173,63,247,98,89,233,39,84,150,140,229,
177,248,193,90,136,192,19,21,74,55,246,189,151,90,29,114,94,76,191,217,180,152,
249,233,80,164,254,208,127,103,78,182,2,15,48,63,217,235,98,47,107,122,167,84,
23,255,0,10,109,163,237,26,207,228,211,242,164,245,125,101,109,19,209,174,193,
173,223,237,65,92,180,19,79,214,16,111,108,48,221,212,178,57,146,38,168,163,157,
30,17,60,10,73,154,29,74,65,82,71,180,119,127,21,145,97,250,126,58,215,246,16,
181,255,0,111,167,243,161,234,203,194,79,93,39,253,95,178,189,124,142,234,41,32,
49,78,82,67,251,70,16,21,23,74,178,152,84,18,65,185,178,17,249,55,62,206,74,
138,53,15,69,225,206,165,199,175,248,122,222,183,249,49,100,40,190,124,255,0,
194,117,255,0,152,39,196,78,210,124,175,106,231,254,52,46,250,207,245,38,222,
121,33,159,117,236,86,167,217,114,118,95,86,100,54,110,71,39,39,249,33,195,111,
108,29,113,163,84,101,104,147,205,2,13,50,5,33,155,165,240,100,189,160,248,116,
74,191,46,34,67,246,16,14,161,230,9,243,61,25,33,212,169,243,168,255,0,55,243,
225,214,222,31,202,63,229,28,223,50,191,151,23,196,142,255,0,201,78,103,220,251,
167,168,182,246,31,125,51,66,96,111,239,246,203,137,182,118,241,144,199,200,11,
85,157,193,205,58,216,219,68,163,232,110,2,235,38,253,15,8,252,81,49,79,201,77,
20,254,107,67,249,245,86,201,213,235,159,245,126,125,31,221,213,182,241,27,203,
108,110,61,161,159,164,135,33,130,221,88,44,182,220,205,80,212,34,203,5,102,43,
55,65,81,141,200,82,205,27,130,175,28,244,149,46,172,15,4,31,111,205,26,205,20,
176,183,194,202,71,237,20,235,74,116,144,71,151,95,17,79,156,95,20,247,39,195,
111,153,159,34,190,46,238,200,82,138,167,170,123,63,114,97,113,115,56,168,90,12,
142,213,169,171,124,150,206,203,83,200,202,38,146,143,39,182,107,169,101,87,181,
142,162,63,30,220,219,100,51,219,197,226,31,212,29,173,254,153,77,15,243,6,159,
46,146,221,86,54,37,69,125,61,122,46,85,152,249,113,240,68,179,61,64,106,179,
232,34,42,97,66,209,216,106,16,84,66,210,89,99,3,244,185,187,95,217,155,46,128,
5,120,253,148,252,169,210,21,145,100,36,138,118,143,207,243,7,171,163,255,0,
132,223,111,138,141,149,252,232,62,24,183,220,203,2,238,44,238,250,217,146,36,
108,52,75,6,232,235,221,209,66,32,96,129,111,28,178,233,36,30,1,23,252,123,39,
220,203,120,118,199,205,102,143,249,176,83,252,143,70,86,160,85,200,243,7,252,
29,125,120,115,56,108,70,226,196,228,240,27,131,21,142,206,96,179,84,21,88,188,
198,23,49,69,77,146,197,101,113,149,208,61,53,110,59,37,142,173,138,106,74,234,
26,202,121,26,57,98,149,26,57,17,138,176,32,145,238,238,137,34,50,72,160,161,
25,7,129,233,208,72,53,7,61,105,25,252,198,127,225,35,244,223,35,126,103,80,
239,239,133,187,143,167,254,36,124,106,220,219,62,130,183,177,240,13,6,235,207,
79,142,236,68,204,100,23,49,46,196,216,52,197,113,148,120,236,174,33,169,229,
90,117,200,80,208,211,206,27,198,138,27,72,73,27,94,91,188,177,68,154,225,193,
82,207,128,41,149,38,140,199,57,24,60,105,81,78,182,201,27,208,176,21,251,63,
212,58,182,143,229,229,255,0,9,159,254,93,31,3,115,120,30,201,203,237,220,215,
202,46,240,193,172,83,208,246,23,121,195,138,201,237,236,6,90,39,18,46,87,102,
245,141,37,57,218,216,74,200,24,126,196,245,135,41,89,79,245,142,117,110,125,
184,208,201,55,251,151,54,181,254,16,40,159,152,201,111,177,137,31,209,235,74,
17,63,179,90,31,95,62,180,213,255,0,133,62,124,122,126,132,254,103,219,143,119,
103,62,76,195,220,187,151,228,62,21,59,46,93,131,87,183,166,193,231,186,43,105,
249,226,193,236,189,163,93,61,36,147,224,114,27,126,90,108,116,233,139,120,68,
85,13,13,43,189,76,65,220,73,35,187,65,48,189,197,165,6,149,122,234,21,21,46,
75,80,143,80,41,192,145,66,56,112,233,45,234,213,68,160,84,211,135,200,127,159,
170,30,202,239,40,32,194,81,64,243,125,195,171,213,185,142,180,167,237,44,136,
174,165,37,132,68,100,153,86,214,185,42,63,199,216,150,105,87,194,10,77,79,207,
162,75,120,24,76,196,10,112,225,215,40,183,173,61,86,55,27,74,145,209,177,129,
37,211,32,99,12,193,26,102,127,26,76,140,88,235,111,81,58,78,146,125,62,210,
179,97,105,195,165,97,10,234,227,94,134,12,30,101,242,53,152,250,92,141,241,241,
82,98,105,32,142,161,148,228,69,196,129,99,18,71,35,42,134,120,216,53,201,189,
248,54,28,123,176,5,136,20,166,58,101,216,0,196,100,215,236,234,15,100,238,233,
118,230,58,113,76,203,45,218,170,161,103,213,36,83,204,94,77,48,180,148,236,136,
145,135,98,164,105,10,7,2,231,221,38,114,149,233,203,120,181,211,210,157,125,64,
191,225,59,191,13,104,190,28,255,0,44,110,159,106,202,252,22,225,223,159,32,160,
111,145,91,239,63,182,229,138,186,146,182,126,194,199,209,86,237,92,44,25,37,88,
206,65,118,238,208,138,142,154,237,112,149,30,85,4,142,72,118,217,140,159,81,
120,70,100,56,30,97,87,0,125,181,169,167,145,98,58,61,210,21,82,49,192,127,132,
245,243,134,249,23,191,119,102,233,249,243,243,51,61,219,24,172,158,222,222,153,
207,145,157,183,93,184,54,238,118,19,71,147,196,212,203,188,242,162,26,26,180,
15,120,103,164,165,17,169,0,144,66,130,9,30,204,182,54,67,101,109,86,168,40,9,
251,78,91,254,52,79,69,155,136,98,238,64,205,127,226,186,205,177,118,62,254,249,
17,218,253,103,241,191,162,49,20,219,163,182,59,111,115,82,109,77,149,138,170,
200,82,99,168,171,50,117,80,79,81,228,169,200,214,188,84,216,218,42,90,90,73,36,
158,87,43,26,71,27,27,155,88,153,95,222,69,107,9,115,82,42,5,7,18,73,160,3,237,
36,15,47,159,72,173,45,90,89,7,91,76,255,0,46,175,248,74,7,99,175,111,99,251,
79,249,157,239,45,131,184,250,247,105,212,65,144,195,124,120,234,141,193,150,
205,227,55,222,73,2,201,28,61,133,187,37,196,237,230,164,218,212,178,5,50,208,
208,7,158,181,151,75,79,20,119,214,69,44,247,119,103,65,86,134,31,60,141,71,228,
52,146,22,190,109,90,250,0,123,129,204,54,241,67,145,66,221,89,63,243,173,248,
146,114,127,23,177,191,25,33,239,239,139,95,202,231,249,89,108,72,182,230,91,
126,238,58,44,62,73,187,23,179,243,180,117,19,204,189,123,179,58,239,107,75,183,
177,178,96,168,239,20,243,82,137,43,242,57,218,242,140,241,248,226,37,138,164,
215,12,225,69,186,136,213,170,149,53,46,212,203,16,3,59,21,169,25,160,31,17,110,
26,85,241,95,139,203,63,47,151,144,31,234,252,244,22,238,108,23,195,13,189,217,
88,29,163,240,147,53,222,59,223,174,182,150,26,44,94,119,183,187,119,248,102,
216,202,246,214,244,122,218,185,171,183,126,223,235,252,109,41,77,131,179,96,
163,154,26,106,10,10,185,234,171,157,99,51,78,202,206,35,81,6,216,47,8,103,187,
160,36,138,0,41,167,237,201,207,230,105,235,154,2,155,195,31,4,242,25,175,249,
58,107,207,253,188,34,127,36,185,9,196,112,197,29,222,162,63,74,43,17,173,39,
68,70,210,215,250,55,231,217,212,132,6,60,124,186,42,140,26,1,79,62,144,91,167,
55,85,149,174,195,108,253,167,137,175,220,123,175,114,212,224,182,206,222,194,
208,68,213,153,44,198,107,44,212,148,56,156,101,4,49,94,121,171,235,235,229,142,
36,140,126,169,24,15,207,180,247,87,17,194,143,44,132,4,85,169,63,33,196,244,
166,218,6,145,128,167,19,215,209,11,254,19,209,252,143,229,248,1,178,42,126,81,
124,162,219,248,202,191,154,61,169,136,122,40,112,179,154,12,180,93,1,176,170,
156,72,54,126,38,190,154,90,186,22,222,91,133,99,73,115,53,148,206,124,105,162,
142,55,40,146,153,3,195,93,212,194,230,101,34,53,248,20,241,30,69,200,254,34,48,
7,21,28,104,73,0,241,17,98,77,11,196,241,63,228,233,87,252,233,63,157,62,227,
248,203,189,118,79,192,63,129,177,227,251,39,249,128,247,94,115,111,109,169,101,
161,194,73,189,241,127,30,176,27,170,178,146,130,29,205,184,176,148,70,72,107,
119,156,244,245,194,166,142,138,164,53,61,21,42,26,202,196,49,248,163,149,61,
213,213,22,98,143,166,24,193,212,222,100,255,0,190,210,184,212,124,206,105,192,
119,30,215,0,225,138,177,224,63,202,126,93,108,3,210,155,11,39,213,253,77,215,
187,11,61,185,178,155,219,113,237,157,169,135,199,110,157,235,156,152,84,102,
119,134,233,74,56,159,114,110,140,156,193,84,61,102,119,52,243,212,184,0,42,249,
52,168,10,0,246,245,141,176,181,181,138,17,196,10,159,155,19,86,57,207,18,120,
231,173,59,106,98,122,20,125,171,234,189,124,130,63,157,183,198,88,254,32,127,
53,255,0,149,155,10,151,113,12,254,15,119,239,52,238,252,60,200,60,83,227,177,
157,188,175,188,219,5,90,130,53,86,174,195,214,215,79,13,214,203,36,74,141,245,
39,222,182,134,49,194,208,159,244,23,41,95,80,40,65,253,132,87,231,94,146,95,
32,99,80,62,33,95,245,126,125,16,90,34,219,154,26,140,131,203,37,101,20,16,80,
137,33,38,40,4,49,36,239,164,82,114,29,103,97,245,32,62,162,126,159,79,98,36,62,
53,92,212,174,63,195,229,209,43,15,167,42,128,81,141,122,235,44,152,234,124,
126,42,172,86,71,142,130,153,243,18,195,13,69,40,157,225,117,164,8,33,154,82,67,
188,178,177,190,150,186,141,32,131,238,236,21,81,78,170,10,156,83,166,148,187,
51,169,21,38,157,28,175,137,63,201,131,249,128,124,245,232,252,71,200,191,141,
253,121,137,221,93,87,87,217,181,253,85,14,78,183,116,227,49,185,161,184,40,231,
198,38,71,35,30,2,117,73,255,0,186,216,217,50,104,181,21,190,64,144,52,114,22,1,
80,177,13,93,238,241,65,33,132,67,43,144,64,37,86,163,81,200,94,53,173,8,205,
40,43,147,209,236,22,76,195,89,42,63,216,243,234,188,251,111,175,50,253,25,222,
29,153,210,155,139,41,140,206,231,250,127,176,55,111,94,231,50,120,119,145,177,
57,12,198,209,203,213,97,114,21,24,217,166,84,155,236,101,172,162,112,140,192,
54,146,13,189,152,237,215,66,234,8,103,10,64,101,173,61,43,210,91,168,60,50,
235,92,250,244,31,239,9,34,143,113,195,146,161,132,198,205,5,53,84,178,44,49,
206,230,170,36,253,201,81,36,153,21,224,10,183,23,250,133,185,228,251,93,112,71,
140,29,61,43,249,244,158,218,166,6,73,26,185,35,143,151,236,227,210,6,186,74,
137,87,239,39,138,53,51,179,241,26,164,74,88,46,144,205,18,18,80,190,171,159,
235,207,180,174,196,141,76,56,244,185,17,20,233,70,173,7,91,175,127,194,43,182,
111,201,89,123,215,229,46,245,197,101,183,38,23,226,133,54,197,195,226,247,126,
46,163,23,35,237,29,241,220,79,145,85,218,139,142,202,77,7,133,55,6,210,219,
175,93,45,64,130,77,98,158,174,53,144,89,147,216,126,122,54,227,7,134,104,234,
164,189,63,135,130,169,249,150,58,151,207,181,169,231,209,154,26,198,196,240,
174,62,222,183,49,254,108,127,60,241,223,203,155,225,31,106,124,136,130,142,12,
239,100,24,241,253,125,209,123,54,72,100,171,147,122,119,86,249,149,241,27,23,8,
148,16,6,168,174,166,166,172,47,95,85,26,11,181,37,28,160,114,71,187,93,204,99,
140,42,48,89,28,208,19,193,69,9,102,62,93,170,9,206,9,160,243,235,202,42,120,96,
127,170,157,124,225,127,155,135,242,117,249,25,240,251,227,238,196,254,96,63,53,
126,69,97,187,7,228,119,203,157,249,140,173,222,125,99,45,54,75,251,205,132,223,
59,203,25,156,222,219,182,28,142,122,122,134,161,201,83,237,44,116,52,180,175,
29,50,69,12,19,76,98,141,68,49,71,169,139,41,228,73,109,224,88,2,219,178,150,
92,213,136,20,203,10,96,146,65,57,38,167,57,175,90,149,123,89,245,119,125,157,
107,223,46,54,157,105,161,79,52,225,159,76,205,6,136,99,134,55,177,22,134,160,
23,152,39,140,255,0,82,15,177,0,81,164,231,252,29,33,18,49,98,104,62,218,255,0,
147,135,92,113,152,188,182,228,203,209,237,173,191,143,203,231,115,249,170,234,
60,118,31,7,136,198,207,152,203,229,114,85,82,164,116,148,24,220,126,58,25,106,
235,107,42,100,97,26,69,20,109,36,140,120,4,251,102,73,99,137,29,157,194,168,
226,78,40,7,175,151,87,85,45,162,137,159,151,91,180,127,40,15,248,73,110,249,
236,58,237,149,242,39,249,155,172,251,15,96,172,180,59,147,5,241,79,21,82,209,
111,189,219,10,24,234,104,97,238,12,213,28,139,30,201,195,84,240,103,196,81,60,
153,73,99,30,57,229,164,98,201,236,181,165,158,239,17,86,59,115,248,142,25,191,
210,143,194,63,164,217,244,94,13,210,164,69,78,57,111,245,113,235,232,43,215,
221,119,176,250,155,102,109,222,186,235,29,157,182,182,6,194,218,56,202,124,62,
216,217,251,67,13,65,128,219,184,44,101,42,104,130,143,25,137,198,193,79,71,75,
18,142,78,148,5,152,150,98,88,146,94,142,56,226,80,145,168,11,254,172,159,82,
124,201,201,243,235,100,147,147,209,105,249,221,134,235,106,223,141,157,157,159,
239,62,237,237,46,139,232,93,141,180,179,155,195,183,183,47,80,110,138,205,141,
187,43,246,86,27,31,53,70,99,23,38,240,193,208,86,238,236,102,42,178,144,60,83,
67,136,122,74,218,175,32,140,76,160,216,161,220,35,214,129,228,157,214,221,78,
85,64,37,201,32,40,53,7,21,52,211,192,215,56,234,232,104,104,20,22,249,249,117,
241,211,254,97,93,143,240,207,181,126,81,239,29,207,240,43,167,247,119,74,124,
112,131,27,134,192,109,77,187,189,119,5,110,119,114,238,26,236,52,50,82,229,55,
230,82,76,149,118,90,191,23,62,237,151,77,67,82,75,89,87,50,31,84,146,107,119,
85,89,99,20,241,196,68,238,197,139,84,84,130,84,83,129,32,0,124,206,5,5,104,43,
74,150,228,96,79,104,232,154,81,228,133,60,111,3,66,101,33,200,70,14,85,133,
203,19,169,142,162,215,99,199,210,220,251,94,173,64,126,99,164,238,154,200,161,
234,60,135,238,94,89,157,21,63,73,81,24,176,211,125,35,95,4,200,71,245,60,147,
238,166,173,243,234,203,64,6,106,126,125,103,96,60,72,69,181,3,163,80,224,150,
34,224,30,45,194,159,175,191,100,249,99,173,252,233,211,116,174,192,253,65,224,
11,219,253,79,31,235,243,239,102,129,177,233,215,186,231,19,112,220,91,139,145,
98,121,250,90,247,4,253,126,190,253,235,214,253,43,215,108,193,128,224,220,27,
243,107,113,244,183,231,223,186,215,248,122,149,27,104,149,24,145,109,10,225,
155,144,214,22,3,232,52,177,35,253,129,247,238,2,189,108,145,233,215,157,131,
121,101,82,72,242,46,144,73,39,146,77,137,189,197,173,245,31,215,219,103,20,167,
149,63,103,94,24,173,120,87,169,49,71,27,193,52,174,234,138,196,4,32,59,133,42,
174,88,56,86,214,172,120,3,234,117,127,128,246,225,249,245,239,203,167,218,32,
33,169,197,201,84,179,71,71,78,67,59,104,142,91,9,69,225,100,68,1,140,114,180,
170,52,187,107,213,123,129,199,187,140,21,44,49,254,126,153,97,168,58,128,53,19,
254,175,207,249,117,55,116,203,20,115,82,67,71,43,213,3,67,25,121,230,100,105,
61,82,73,169,20,68,218,99,142,62,0,22,91,126,121,247,185,169,169,64,110,35,243,
207,249,58,172,25,12,196,102,188,56,15,182,190,103,215,249,116,139,5,181,35,55,
37,191,195,254,11,245,22,250,143,105,220,168,1,66,244,160,10,254,93,56,43,37,
167,83,52,145,176,157,70,158,84,58,145,169,216,144,9,93,26,120,181,254,190,252,
164,22,38,148,207,252,87,90,166,5,7,76,18,1,168,232,26,134,162,4,182,36,182,163,
168,2,72,228,133,224,253,15,187,26,26,255,0,8,235,127,151,93,68,214,117,176,184,
82,188,158,44,11,114,7,212,115,253,79,186,83,11,140,249,255,0,171,203,211,175,
83,143,78,14,234,145,216,132,176,121,127,218,154,231,142,79,228,16,127,54,247,
99,229,82,61,113,195,173,113,52,251,58,196,179,59,69,32,91,34,21,177,81,115,
112,7,26,137,231,77,255,0,31,79,126,81,69,53,244,255,0,85,58,221,40,105,199,168,
233,12,147,249,22,61,23,69,18,59,187,42,32,23,28,22,38,192,221,190,159,241,79,
122,65,90,191,30,173,195,20,199,92,214,9,35,66,37,66,154,90,223,212,53,201,107,
130,13,153,120,255,0,109,239,206,116,212,15,136,245,237,92,58,228,154,133,60,
188,92,157,55,54,4,128,172,191,242,72,58,191,216,251,182,145,162,158,93,107,206,
148,199,95,255,209,208,102,154,69,40,226,225,89,70,161,113,245,45,254,164,139,
242,63,199,241,239,124,8,53,175,84,35,128,167,159,89,131,136,222,48,215,187,175,
26,57,13,115,233,102,83,192,55,254,158,244,43,90,208,83,173,173,115,81,214,90,
148,87,44,197,131,19,245,60,130,26,192,254,147,98,223,143,245,189,220,10,158,
222,31,234,174,122,247,77,175,168,105,28,144,116,220,30,108,45,123,126,45,238,
218,64,238,174,0,254,125,111,207,29,97,228,155,175,233,227,79,6,220,254,45,254,
36,251,105,129,6,135,143,90,35,229,212,168,157,147,82,176,38,204,161,181,220,4,
227,211,207,5,94,223,236,0,247,176,196,113,235,99,29,56,71,80,164,16,178,178,
169,113,173,180,221,152,241,97,97,127,236,143,235,239,100,140,158,181,154,14,
178,172,145,235,44,74,179,235,93,10,192,56,82,71,234,119,250,27,159,199,212,31,
122,243,52,207,248,122,241,245,61,101,127,28,129,18,48,197,128,81,38,145,98,166,
66,186,84,171,112,205,174,246,185,247,226,50,126,222,181,66,1,167,81,164,141,
225,40,92,21,87,75,161,97,112,192,1,123,115,245,13,245,252,123,169,31,46,183,90,
143,159,80,200,15,114,192,90,214,185,54,10,69,205,200,55,228,255,0,182,247,115,
246,245,166,174,61,122,135,44,70,51,249,96,218,191,60,218,255,0,79,205,184,247,
174,209,76,245,224,126,202,245,196,161,245,20,55,3,212,84,129,113,113,253,56,
184,255,0,91,223,136,174,125,58,176,38,153,235,168,138,139,139,122,139,114,121,
231,234,79,6,246,255,0,95,222,186,241,234,119,209,129,23,35,85,199,226,246,183,
244,189,143,191,14,189,212,152,211,82,202,193,128,211,234,2,246,37,181,175,164,
169,245,17,207,189,140,80,245,163,252,186,238,8,89,202,11,53,203,185,208,191,
164,160,80,73,26,110,254,144,13,253,232,211,175,31,78,179,215,192,176,212,58,21,
32,134,69,96,193,195,95,71,58,129,36,130,63,167,191,30,38,156,58,208,169,243,
234,50,212,68,36,2,226,228,91,72,28,22,185,11,96,44,220,255,0,135,191,117,98,58,
17,54,143,82,246,239,99,238,125,167,176,182,23,86,246,6,243,222,91,202,104,162,
218,91,99,109,109,12,246,99,57,185,94,178,81,21,57,195,227,168,104,38,170,200,
196,238,79,238,34,178,40,185,36,0,72,101,174,32,69,102,105,148,40,227,145,199,
211,237,249,117,176,172,78,20,215,173,235,255,0,145,167,252,37,107,57,181,183,
54,212,249,95,252,207,246,158,43,238,112,179,211,102,250,219,226,77,116,244,
153,136,160,200,196,34,170,199,110,94,237,154,138,106,156,93,73,160,155,213,6,
219,142,73,163,50,168,106,230,32,26,111,105,207,141,118,218,116,20,180,243,174,
25,254,64,113,85,245,173,24,240,160,28,110,52,166,107,87,255,0,7,91,237,82,82,
82,208,82,211,80,208,211,83,209,81,81,83,195,73,71,71,73,12,116,244,180,148,
180,241,172,52,244,212,212,240,170,69,5,60,17,32,84,69,1,85,64,0,0,61,173,85,85,
80,170,0,80,40,0,224,58,167,30,164,123,223,94,235,77,175,248,80,199,117,252,
224,249,177,242,111,101,255,0,35,47,132,59,19,25,89,67,219,157,121,179,251,83,
228,103,96,228,232,178,209,211,96,246,148,219,162,162,183,21,14,226,220,70,146,
108,94,212,216,24,169,54,252,21,149,149,81,71,83,87,93,84,99,164,135,247,47,20,
133,114,202,30,228,135,4,172,78,52,160,226,239,166,181,207,146,134,7,200,12,146,
112,58,115,77,20,83,137,25,62,131,253,67,175,156,95,99,109,76,231,83,246,15,96,
245,110,234,88,227,220,157,121,188,183,62,198,220,11,0,152,64,114,251,79,53,89,
131,200,152,5,68,113,204,240,53,93,3,52,101,209,88,161,4,129,244,246,113,5,200,
154,8,165,81,135,80,71,230,43,210,55,134,143,74,112,61,125,1,63,225,31,95,3,254,
93,117,14,200,237,223,149,125,150,54,214,220,248,161,242,179,96,99,49,187,39,
96,101,101,254,37,187,187,2,183,111,102,107,33,198,118,28,84,84,222,74,44,30,
212,92,117,94,74,132,45,84,134,166,188,76,24,66,177,34,200,229,174,62,170,235,
90,39,232,170,178,57,60,27,135,104,30,122,72,53,108,14,32,87,52,84,163,66,80,
156,224,142,182,93,254,84,255,0,20,115,255,0,9,58,39,182,62,54,215,82,101,105,
246,102,201,249,79,223,57,142,153,155,36,208,180,21,93,55,191,55,29,54,248,217,
67,18,97,154,93,52,24,193,159,168,161,101,96,140,181,20,178,250,108,65,45,109,
139,42,11,164,153,72,113,45,42,71,196,2,34,134,30,186,169,83,243,61,90,74,118,
80,138,83,246,100,154,117,103,30,204,250,111,175,145,255,0,252,42,39,41,185,
159,249,211,124,148,143,112,26,241,13,22,221,234,26,61,189,247,244,80,227,255,0,
223,184,221,115,129,169,162,20,146,65,12,77,93,143,53,53,51,248,234,28,188,140,
46,165,172,128,4,251,103,111,213,255,0,23,142,245,254,84,254,84,167,202,135,
207,170,220,40,96,130,159,132,117,69,248,200,43,242,218,113,242,67,93,91,67,39,
237,45,14,62,70,121,141,75,167,249,59,65,79,35,134,171,211,62,155,133,54,183,
211,217,242,46,190,205,36,143,65,235,79,231,209,76,133,34,253,69,33,100,245,62,
158,127,102,43,199,161,99,227,31,200,94,196,248,75,242,99,167,126,80,117,206,47,
17,95,190,250,95,118,210,239,45,173,65,185,233,167,173,219,249,26,234,24,106,
169,26,159,43,13,37,84,21,51,208,206,181,46,172,177,204,142,57,1,129,23,246,93,
125,107,226,197,225,150,42,106,8,56,193,82,8,63,180,116,182,218,117,60,8,60,127,
159,95,100,255,0,229,157,242,199,112,252,230,248,37,241,171,229,118,237,219,24,
157,155,186,123,155,175,41,247,46,225,219,120,26,154,186,188,46,51,49,6,75,35,
135,175,92,84,213,224,86,125,141,68,248,211,52,105,33,119,141,100,208,89,244,
234,40,109,100,121,35,111,16,130,234,236,164,140,87,75,17,90,102,149,167,14,150,
176,0,138,112,32,30,143,79,181,61,87,175,123,247,94,235,229,239,252,196,255,0,
149,63,243,62,254,102,159,207,3,230,126,211,218,27,11,43,157,160,192,246,62,22,
150,62,234,222,48,215,237,62,151,216,157,73,81,183,241,149,29,115,71,30,229,174,
166,169,138,181,168,118,185,85,92,126,53,107,107,166,170,73,155,196,11,51,2,235,
59,165,138,41,35,0,189,231,136,250,130,241,174,162,42,107,133,20,166,157,68,
118,208,10,245,233,35,44,192,159,130,131,252,29,109,31,240,27,254,18,187,252,
189,190,49,236,61,189,63,201,109,180,159,48,187,198,12,158,51,113,102,55,126,
245,155,55,136,235,236,78,78,131,68,201,132,218,61,123,143,203,67,67,62,220,142,
170,230,83,151,53,211,86,128,60,139,26,126,208,80,99,184,158,166,230,118,0,254,
20,36,40,30,149,195,49,245,56,249,1,215,130,198,159,2,10,250,145,213,44,124,
222,255,0,132,239,119,70,229,222,159,204,163,249,134,124,178,220,125,81,210,157,
77,213,251,67,179,119,167,198,238,146,248,173,136,196,81,83,103,240,187,31,13,
42,117,167,241,186,89,48,216,252,62,205,192,71,138,162,128,228,226,88,231,202,
214,214,60,174,90,21,179,50,56,166,187,178,182,80,176,133,163,141,69,141,65,44,
224,81,0,56,81,92,22,200,2,154,73,36,141,188,81,202,73,39,203,20,249,15,60,117,
169,6,203,221,73,149,20,211,85,233,105,150,154,33,59,184,89,190,236,64,0,136,44,
106,186,133,76,68,1,123,220,175,177,140,111,170,149,25,167,248,58,14,202,154,11,
1,254,170,244,45,108,31,147,123,223,226,223,103,237,206,225,235,188,110,203,
220,149,152,145,81,141,220,91,35,178,118,126,11,127,108,29,249,180,107,158,24,
247,6,206,221,219,99,115,81,100,40,234,240,185,170,88,124,114,60,126,42,154,114,
67,195,36,110,3,123,45,220,237,99,187,136,36,149,4,26,130,60,136,224,125,15,
216,122,89,96,198,55,36,15,46,190,192,255,0,10,179,155,79,117,124,71,248,225,
187,182,55,93,225,122,143,105,239,30,154,235,253,225,133,235,45,182,145,197,183,
182,45,46,234,219,116,25,230,219,88,56,162,142,24,98,197,99,38,200,52,112,42,34,
40,140,11,40,250,123,41,219,244,253,36,69,16,40,53,52,21,165,106,106,115,83,
147,83,159,94,142,30,186,141,79,90,10,127,54,255,0,228,237,243,123,229,255,0,
243,212,249,3,178,190,48,108,207,190,194,111,237,137,176,187,186,78,197,221,80,
29,159,213,187,67,111,230,48,244,88,60,173,14,67,116,166,50,74,26,220,156,91,
167,31,86,177,210,211,173,70,66,161,216,177,91,6,96,213,173,194,90,53,197,178,
41,105,196,172,66,173,42,67,0,245,201,0,40,213,166,164,129,81,65,83,142,169,44,
94,46,150,63,13,7,242,199,237,235,96,47,228,185,255,0,9,197,219,255,0,203,131,
180,224,249,75,242,7,183,168,187,215,228,125,6,7,39,128,217,116,27,103,15,62,51,
173,122,206,151,63,74,41,115,85,248,215,205,44,153,189,201,186,39,165,121,41,
163,173,120,232,98,166,130,71,9,11,51,249,2,134,89,238,94,55,185,210,168,134,
161,65,173,79,145,99,65,194,184,0,80,28,212,226,154,68,72,129,9,196,249,245,180,
63,181,61,111,173,22,127,225,104,157,83,178,242,88,95,131,125,155,54,231,220,
145,118,5,94,228,236,78,187,162,217,169,85,44,219,82,191,105,210,208,99,183,61,
118,225,124,121,144,67,71,158,199,229,42,34,167,19,162,151,168,167,168,208,220,
68,190,210,198,180,220,198,156,151,139,187,229,165,187,105,246,234,53,31,33,
214,165,106,66,79,161,255,0,15,90,137,117,190,194,181,37,57,215,22,143,3,73,74,
99,37,194,203,78,168,242,37,98,72,4,176,43,69,170,206,73,0,142,7,211,216,162,
24,251,64,175,159,65,203,137,168,78,51,78,184,239,234,73,113,63,124,210,37,100,
8,76,149,10,149,73,42,198,209,74,25,181,44,190,83,36,200,172,160,169,0,13,39,
252,125,250,112,84,177,21,235,80,29,74,0,61,108,11,255,0,9,104,254,88,237,242,
159,229,6,91,231,159,109,98,101,170,233,175,139,155,130,158,151,171,232,235,34,
127,225,219,231,191,94,149,106,97,201,70,147,161,90,188,63,90,227,39,142,173,
128,37,127,137,79,76,63,221,110,61,134,239,31,234,174,69,168,63,164,180,103,249,
231,181,127,50,42,223,32,7,226,232,65,109,31,135,30,178,59,142,7,249,255,0,213,
254,78,183,4,254,121,255,0,204,127,53,252,177,190,5,111,94,239,217,24,70,204,
246,190,244,204,82,245,39,82,84,76,180,114,226,118,206,250,221,152,172,189,69,
22,241,206,210,85,76,143,95,141,219,20,88,185,234,133,60,105,39,158,165,34,141,
192,141,152,134,238,29,203,67,109,25,163,200,79,119,240,168,203,17,243,166,7,
144,38,167,133,11,226,128,22,60,7,95,63,95,229,235,252,251,178,63,203,150,135,
116,118,30,11,225,166,199,239,191,148,189,205,186,119,14,231,239,239,150,93,221,
216,187,151,39,217,155,222,76,222,85,235,161,219,251,114,92,126,44,141,163,183,
233,225,125,83,70,147,74,107,170,137,146,96,66,196,145,183,244,19,164,154,227,
146,48,139,132,5,11,105,20,205,59,198,73,169,45,77,70,180,173,58,168,149,72,165,
9,111,60,255,0,177,215,212,39,226,47,201,109,133,243,11,227,79,75,252,150,235,
92,141,30,67,105,246,254,194,192,238,234,101,162,152,204,184,172,149,117,28,99,
61,183,170,75,90,88,171,246,238,109,42,40,167,73,2,186,201,1,184,30,223,182,
152,205,10,179,138,74,48,195,209,134,8,253,188,61,69,15,86,96,1,199,14,133,222,
192,236,29,143,213,27,39,115,246,71,101,238,204,6,197,216,91,47,15,89,184,55,94,
239,221,25,58,92,54,3,1,134,160,140,203,87,144,201,228,171,100,138,158,154,8,
148,88,92,221,216,133,80,88,128,92,146,68,137,12,146,53,20,127,168,1,234,79,0,6,
73,192,235,64,18,104,58,248,249,127,57,111,154,93,115,243,227,249,150,119,255,
0,200,174,171,138,167,253,19,229,50,88,45,153,177,115,46,149,80,84,238,205,
185,176,48,180,187,118,151,117,73,67,90,33,168,160,93,202,244,114,212,195,9,10,
99,167,116,212,3,146,61,238,193,29,35,146,73,65,13,35,150,167,160,52,0,31,157,
0,175,161,36,116,196,231,83,81,115,65,78,136,38,206,175,221,219,199,39,6,202,
235,109,155,185,183,158,237,201,84,65,79,183,246,254,205,219,217,29,209,184,235,
42,30,123,66,137,138,196,210,87,215,212,201,112,161,4,113,179,3,244,252,221,
115,94,71,108,165,158,64,163,212,144,63,195,210,51,106,101,32,156,159,245,112,
234,246,190,29,255,0,194,104,127,154,151,203,93,221,180,42,123,139,174,42,254,
46,116,158,107,49,71,89,188,247,151,108,100,48,212,27,222,155,109,214,248,229,
200,84,237,206,180,165,169,159,113,85,102,38,164,140,165,60,53,113,208,194,146,
186,180,165,84,27,162,151,114,150,101,97,107,19,51,31,54,5,84,87,204,214,132,
129,253,16,107,229,78,61,41,142,205,18,154,168,41,249,255,0,171,243,235,233,181,
241,95,226,247,77,124,52,232,94,186,248,225,208,123,78,147,103,245,159,90,224,
225,196,98,40,32,80,245,185,42,198,253,236,190,228,207,86,216,75,149,220,123,
143,36,242,85,215,85,73,234,150,121,90,218,84,42,171,80,66,33,77,58,137,114,106,
196,241,102,60,73,255,0,32,224,5,0,192,29,42,38,191,103,95,55,79,248,84,199,242,
239,238,239,142,63,47,243,95,50,19,173,122,59,104,124,98,239,125,207,14,216,217,
89,78,152,161,151,1,148,254,250,12,85,102,123,53,55,111,224,171,152,203,87,216,
155,166,117,172,172,155,43,75,122,42,196,64,170,35,120,216,51,91,115,27,73,94,
213,212,130,197,153,115,85,210,8,20,95,49,64,69,65,197,73,43,140,6,174,99,241,
84,55,144,253,181,235,87,220,148,147,212,62,54,166,169,74,70,104,233,192,16,
107,145,157,73,42,53,134,210,202,101,78,126,164,91,216,141,131,54,130,70,52,142,
138,163,10,190,34,47,16,199,253,95,151,76,153,23,129,82,70,72,130,66,147,144,
202,93,38,145,98,153,61,41,35,3,235,110,5,180,155,175,231,219,47,64,62,93,63,24,
53,21,57,167,165,58,250,169,127,194,95,190,85,252,63,236,127,229,209,210,223,
26,62,63,230,233,199,111,244,150,203,173,205,124,135,217,195,9,89,138,201,226,
119,174,230,221,153,73,106,247,38,82,170,120,35,166,205,71,185,36,149,5,53,92,
15,42,188,80,4,58,76,122,64,118,9,124,43,169,109,100,137,132,206,93,245,126,22,
1,128,20,53,242,82,162,158,84,232,210,149,64,192,138,0,7,242,255,0,61,122,179,
255,0,152,63,9,104,254,90,252,158,248,21,191,183,153,76,143,87,124,75,236,110,
196,239,28,206,214,174,138,154,124,86,123,176,151,106,208,109,254,172,122,170,
58,148,150,58,246,195,102,107,42,43,172,200,194,33,74,44,84,201,114,213,220,18,
207,125,106,2,147,109,160,235,225,64,53,43,83,231,172,128,8,254,16,125,122,186,
16,17,143,226,174,63,213,242,235,70,143,248,88,63,205,222,186,239,223,151,29,
59,241,39,174,179,67,60,62,41,96,183,61,79,107,100,241,181,177,85,226,169,123,
51,127,190,25,219,104,34,196,94,52,202,109,77,191,137,139,239,220,155,197,61,
111,128,128,241,56,246,178,213,68,247,115,92,15,236,149,66,15,153,4,151,35,229,
90,47,218,167,166,38,109,17,129,248,171,95,243,117,167,220,245,94,10,106,133,
127,83,176,64,172,88,42,192,136,223,68,213,113,44,140,162,223,64,64,246,108,91,
74,159,95,240,116,144,13,76,41,243,252,250,250,124,255,0,194,100,63,149,55,196,
62,153,248,151,212,127,60,41,118,86,236,222,191,37,59,195,106,140,179,239,126,
230,217,176,225,43,122,218,133,107,38,165,159,17,212,123,122,177,106,87,25,131,
175,168,164,50,71,184,85,218,179,49,77,227,116,120,96,111,17,34,135,85,228,146,
79,113,144,146,50,170,254,28,31,139,250,71,231,248,77,64,0,130,74,250,4,80,171,
230,51,235,254,175,240,245,127,31,56,254,119,124,109,254,94,29,19,159,249,3,242,
103,124,211,237,77,165,139,18,82,96,176,180,130,58,237,227,191,119,25,133,165,
163,218,123,31,111,249,162,168,205,231,43,52,242,1,72,41,227,188,179,201,20,64,
184,85,52,194,45,42,20,180,173,240,168,226,127,204,7,153,56,31,105,0,232,10,212,
249,14,169,23,166,191,225,74,93,95,242,142,95,138,61,71,241,255,0,172,182,211,
124,176,249,135,218,57,61,191,180,58,151,116,246,85,46,115,5,210,189,73,138,173,
175,3,178,123,227,114,237,92,92,81,98,183,118,123,19,134,169,168,199,237,12,113,
168,200,56,146,19,44,241,171,93,139,165,188,190,84,152,8,21,101,18,5,4,234,40,
117,105,2,149,210,91,184,144,72,160,0,87,38,128,184,17,9,94,227,74,87,231,209,
180,255,0,133,25,247,101,23,71,255,0,39,63,151,85,217,60,142,218,167,206,118,46,
202,196,117,6,18,151,55,36,209,83,230,115,61,129,156,198,98,242,52,152,74,69,
147,203,83,151,139,8,149,181,84,200,90,201,224,214,228,132,32,168,187,212,203,
107,19,102,70,145,43,79,232,144,228,143,247,159,62,3,231,78,170,188,88,249,0,
127,205,215,199,234,146,203,26,155,216,139,126,63,39,250,95,130,125,154,138,80,
83,166,13,114,5,43,215,40,21,137,103,117,110,92,22,107,125,53,134,177,176,43,
126,71,250,195,221,250,109,216,210,149,205,63,193,211,129,154,10,100,101,167,
138,77,111,101,150,105,196,69,199,2,250,21,1,208,53,94,199,143,246,254,237,242,
3,61,106,129,177,90,255,0,155,168,225,213,89,85,180,233,242,29,86,224,40,176,
97,199,36,175,251,207,186,226,189,59,158,176,212,5,119,214,167,211,115,123,128,
166,252,30,7,212,139,31,126,244,62,125,107,211,174,72,129,203,0,52,221,9,80,163,
141,66,198,228,147,197,253,232,87,32,252,61,88,231,172,54,63,145,111,247,195,
250,255,0,175,239,125,84,244,227,78,200,178,71,169,20,171,198,192,249,9,210,9,4,
6,22,32,255,0,176,247,238,63,111,94,235,13,76,102,7,13,201,14,170,31,212,9,
176,244,233,35,143,162,143,199,35,222,143,10,112,207,251,61,90,131,242,233,219,
31,28,75,69,93,81,43,178,198,35,151,84,62,22,149,36,40,35,142,156,179,17,165,
95,207,40,63,168,48,23,54,54,183,187,138,82,163,135,77,189,117,40,28,125,122,
157,140,64,107,89,171,161,156,192,104,22,90,104,169,216,185,112,244,250,33,144,
202,24,105,85,171,94,11,2,192,142,62,158,252,163,187,32,211,229,214,156,144,189,
164,113,207,252,87,159,92,178,208,178,195,143,145,97,9,44,80,152,170,158,17,254,
73,204,140,99,30,77,35,85,81,185,13,126,15,227,222,228,0,80,211,128,255,0,87,
231,213,99,111,136,87,21,197,120,255,0,197,122,116,155,107,235,5,0,177,144,112,
71,168,122,197,128,39,232,13,237,254,195,218,114,181,53,39,165,20,31,159,89,
153,149,38,33,201,10,90,79,32,177,83,164,129,96,0,229,121,254,156,251,182,144,8,
167,2,122,175,1,195,166,148,58,143,212,145,253,91,243,167,129,244,23,189,143,
215,235,111,123,39,226,56,251,63,47,62,180,106,58,206,87,82,160,210,68,140,81,
80,1,164,48,80,0,42,127,63,83,254,199,219,67,136,58,168,62,125,111,21,251,58,
234,82,0,224,112,53,31,201,35,241,245,254,160,15,119,53,160,52,201,199,94,81,
231,231,214,53,125,48,184,6,228,146,62,128,129,117,252,159,197,189,213,137,243,
225,79,179,253,158,188,70,65,242,235,53,33,101,142,103,185,11,162,205,113,195,
18,2,149,185,4,95,159,165,185,247,112,123,75,183,167,91,52,234,66,200,250,93,
73,7,91,2,65,183,232,33,109,207,210,195,221,72,212,9,34,135,214,190,159,47,245,
126,125,84,84,30,24,235,148,66,51,21,80,54,186,44,37,64,225,121,112,24,150,250,
19,234,250,123,221,123,43,83,254,95,245,121,117,188,212,125,189,127,255,210,
208,50,55,104,202,191,233,0,105,32,126,71,33,129,247,225,233,214,136,253,189,59,
201,98,168,86,218,88,93,72,96,204,190,149,189,174,56,7,241,254,30,247,64,69,122,
167,169,3,35,169,0,153,16,7,211,234,80,28,54,145,165,144,105,23,224,27,155,95,
252,125,217,72,205,6,8,254,125,108,80,159,151,77,211,198,201,32,6,215,244,1,254,
213,245,250,0,62,158,236,13,84,181,125,127,213,246,117,191,35,214,36,12,188,146,
8,58,190,164,113,111,212,172,45,198,175,117,52,162,154,240,20,235,198,152,235,
62,152,209,138,136,203,36,160,56,229,86,193,75,93,129,4,240,72,177,95,240,247,
86,0,96,117,170,156,252,186,192,210,40,117,33,180,29,92,171,71,202,179,30,67,
45,189,87,28,3,253,61,234,189,110,156,71,82,33,170,139,212,36,208,28,59,129,
107,144,67,33,211,169,13,213,163,13,254,196,123,216,225,199,173,250,116,227,171,
201,28,210,2,242,74,186,99,33,163,14,162,18,133,28,106,63,82,163,149,54,184,31,
159,123,38,132,29,89,235,92,49,229,214,25,91,198,33,66,53,177,134,2,172,84,175,
142,61,10,74,104,189,143,248,159,207,215,223,168,48,61,115,254,110,189,79,151,
159,92,230,240,52,101,34,149,61,80,130,198,254,149,96,56,65,233,99,169,217,108,
71,191,18,0,160,173,113,213,120,26,241,234,60,177,44,48,180,21,16,188,114,150,
18,70,238,89,84,89,57,88,220,92,157,87,6,204,62,131,143,122,175,28,99,173,249,
212,112,233,184,120,116,41,101,187,25,21,110,173,235,101,176,86,244,105,176,231,
232,126,183,247,174,57,39,171,103,207,169,200,169,19,95,64,103,253,54,117,0,168,
87,244,6,211,112,196,143,201,247,101,21,52,168,235,217,243,235,52,209,170,149,
96,193,188,128,57,80,108,21,172,65,75,88,91,250,251,209,251,58,245,120,245,232,
227,86,47,96,88,147,17,189,199,167,83,11,128,110,125,70,255,0,235,251,215,91,
200,174,49,78,156,105,226,121,26,42,106,106,105,26,170,57,231,97,32,75,49,138,
72,209,22,37,191,161,163,12,141,125,86,177,60,123,217,34,148,60,107,213,41,158,
62,152,234,236,190,8,255,0,41,60,111,104,238,62,190,238,79,152,191,52,62,37,
124,49,248,244,62,207,119,86,228,119,191,117,117,38,239,238,92,198,62,6,21,24,
122,28,63,73,166,227,174,172,65,153,154,16,142,249,133,133,33,135,83,52,19,18,
35,98,153,175,227,144,201,4,42,213,200,45,70,160,245,160,29,236,125,40,0,254,
144,233,245,140,138,49,225,254,175,203,173,220,126,10,247,215,252,38,119,169,55,
54,222,232,94,155,238,31,137,61,135,219,153,202,229,166,143,177,251,43,171,246,
173,22,71,117,103,89,153,214,58,109,249,150,235,45,179,177,49,15,33,26,97,130,
150,106,88,78,144,23,83,114,83,195,5,164,85,123,145,44,149,243,145,91,72,251,1,
20,81,243,63,153,234,236,206,223,13,7,216,122,186,125,233,252,193,63,150,167,
79,75,67,144,222,63,45,254,34,236,202,170,88,83,7,141,168,110,214,235,24,171,
169,169,108,74,98,232,134,55,43,53,92,20,106,23,252,210,1,24,254,158,215,44,251,
120,96,209,132,44,5,1,85,169,3,253,168,56,254,93,55,73,14,13,105,243,232,188,
247,199,243,233,254,82,31,30,49,149,149,187,215,230,231,80,110,28,141,54,46,92,
173,62,216,234,204,165,79,107,110,76,146,36,2,120,169,41,40,182,29,46,114,150,
10,250,165,101,17,199,85,61,48,37,133,202,139,144,231,214,70,223,217,36,142,
126,74,127,194,64,81,249,145,214,180,17,196,129,214,191,249,47,248,91,55,199,
169,55,142,71,11,179,254,13,247,118,234,219,255,0,197,50,20,59,111,37,254,144,
54,150,63,112,103,233,163,144,71,136,171,109,181,14,31,39,246,51,228,172,93,
233,214,170,119,133,74,174,167,107,219,197,239,0,214,209,196,171,243,99,143,180,
233,167,219,214,251,43,74,159,245,126,125,108,171,252,184,254,111,119,191,206,
158,178,202,246,167,101,252,29,237,127,134,187,102,162,60,109,79,93,191,114,238,
108,13,126,99,177,113,185,40,13,64,204,80,109,58,10,76,94,231,193,227,41,163,
210,68,153,10,106,113,82,36,83,14,181,187,123,110,11,155,137,217,194,198,158,16,
24,112,91,73,62,130,170,43,235,85,36,121,86,189,121,149,86,153,53,244,232,205,
117,71,197,142,161,233,254,216,239,14,247,219,120,122,234,254,228,249,21,148,
219,245,253,169,216,91,135,43,93,154,205,229,113,251,67,26,113,59,67,105,97,254,
246,105,105,246,206,201,218,212,46,226,139,23,66,144,211,164,146,188,174,30,86,
47,238,246,246,107,3,73,33,145,158,86,38,164,249,84,214,128,14,3,135,169,160,2,
180,2,158,103,45,65,74,47,85,61,213,63,240,155,175,229,129,177,251,239,186,126,
70,118,63,81,77,242,47,126,246,247,105,238,62,206,164,162,238,170,249,119,30,
206,216,50,110,60,156,153,170,156,38,3,104,83,53,22,11,45,12,121,106,153,164,21,
25,88,107,102,40,234,131,72,75,181,34,178,100,141,97,146,225,154,21,20,80,42,
152,242,212,84,213,143,149,106,1,254,26,215,175,23,4,212,46,127,111,87,151,180,
182,126,210,216,27,111,17,179,182,46,216,219,219,47,104,237,250,56,241,248,29,
175,181,48,216,237,189,183,112,180,17,92,199,69,137,194,226,105,169,49,216,250,
84,44,72,142,40,209,65,39,143,107,35,142,56,148,36,72,21,61,0,167,85,36,147,82,
115,214,104,240,148,240,110,42,157,193,10,178,212,87,227,41,241,181,196,205,35,
44,137,67,52,179,81,20,133,203,69,23,143,238,101,4,160,82,218,134,171,216,123,
100,91,170,221,189,202,252,76,129,78,125,9,35,31,153,225,214,245,29,33,124,129,
233,247,218,158,171,215,202,131,254,21,167,216,235,216,223,205,235,116,237,122,
125,147,89,181,107,58,131,166,58,191,100,213,229,170,158,145,234,183,202,214,99,
235,183,173,54,231,165,138,145,89,211,29,21,46,234,90,40,4,172,211,17,74,88,133,
5,84,39,219,193,121,175,164,165,43,37,41,231,218,161,107,249,241,31,42,117,89,
217,85,80,30,20,255,0,15,90,227,237,170,169,113,193,37,154,53,173,199,121,34,
121,168,106,161,150,90,121,90,57,1,241,176,30,168,217,155,139,253,85,172,72,62,
207,35,33,104,105,85,244,232,190,112,31,3,182,95,81,214,76,181,14,87,115,101,
113,152,61,173,135,175,201,229,179,245,180,248,204,38,215,195,81,85,101,114,213,
85,181,213,11,77,143,197,99,232,104,105,158,162,186,190,170,170,65,28,49,68,
141,35,146,160,41,98,110,205,212,139,26,151,102,11,24,25,174,0,31,51,214,237,99,
60,14,90,188,125,79,95,100,31,228,141,212,29,153,208,223,202,171,225,95,84,247,
22,209,202,236,46,200,218,157,71,79,14,231,217,185,234,19,141,206,109,202,172,
142,119,53,150,166,198,230,40,25,154,74,76,148,84,21,209,25,163,123,72,142,214,
96,172,8,4,150,32,248,82,53,8,13,43,176,174,48,88,208,231,212,100,124,186,51,
126,32,121,128,58,180,202,138,136,41,32,158,170,166,104,233,233,169,161,146,162,
162,121,157,99,134,8,33,70,146,89,165,145,200,88,227,142,53,44,204,72,0,11,251,
86,204,168,172,238,104,160,84,159,64,58,175,28,14,163,227,114,88,252,206,62,
135,45,138,172,167,200,99,50,84,176,87,99,235,233,37,89,233,107,40,234,163,89,
169,234,105,230,66,82,88,102,137,195,43,3,98,13,253,234,57,18,104,210,88,152,52,
108,1,7,212,30,7,173,144,65,32,140,245,52,0,46,64,0,177,187,16,0,185,176,23,63,
212,216,123,191,90,235,191,126,235,221,83,191,243,249,236,234,238,166,254,80,
159,55,247,46,50,60,108,181,217,62,167,147,101,66,153,70,181,57,143,125,103,49,
27,86,177,162,79,36,77,53,100,116,25,89,90,21,6,254,64,13,136,4,123,69,125,86,
72,35,28,26,100,7,236,12,15,249,58,178,227,81,254,137,255,0,55,95,36,238,183,
113,73,70,42,84,130,137,26,64,28,165,136,150,118,6,193,116,155,184,81,233,2,247,
246,40,128,86,34,65,232,59,116,79,137,79,63,242,14,148,253,148,126,251,19,20,80,
210,195,24,169,103,135,207,28,108,93,165,146,85,141,252,106,109,226,14,27,212,
71,4,253,125,179,116,116,163,31,64,122,118,207,46,51,215,218,71,226,118,215,
131,101,124,91,248,225,180,41,148,172,27,107,162,186,155,9,24,40,35,54,199,108,
76,21,41,38,48,72,66,90,50,109,248,250,123,15,109,226,150,54,159,56,212,254,
209,95,242,244,125,39,198,223,111,67,254,133,212,31,74,235,10,84,61,134,173,36,
220,174,175,173,174,62,158,213,233,21,213,65,170,156,122,167,92,189,239,175,117,
2,131,43,139,202,253,239,240,188,149,6,75,248,117,125,78,43,33,246,21,148,245,
159,97,148,163,40,43,49,181,191,111,36,159,107,95,72,100,95,36,47,166,72,238,53,
1,127,116,73,35,147,87,134,225,168,104,104,107,66,56,131,232,71,167,91,32,142,
35,173,56,191,225,99,31,31,247,94,234,248,231,241,99,228,158,220,198,87,100,
176,221,43,218,153,253,165,191,36,163,74,153,151,17,134,236,172,85,28,120,76,
181,82,69,35,71,79,66,185,172,25,167,150,83,29,131,212,70,11,139,128,88,4,67,
184,193,41,56,145,10,124,181,3,168,15,204,106,253,157,86,85,47,3,175,166,127,
213,252,186,211,51,96,84,82,100,113,152,24,43,157,94,67,34,77,75,16,72,94,57,
221,161,120,154,154,121,101,43,26,196,11,139,106,42,46,61,138,161,53,80,60,241,
208,98,112,67,49,29,4,221,229,185,115,166,87,194,209,129,93,147,171,200,166,35,
23,138,199,172,147,75,53,109,68,130,146,151,31,73,79,24,105,100,171,154,121,21,
66,129,118,102,210,46,44,61,167,189,148,70,24,177,1,71,236,20,233,77,140,33,
138,224,245,245,112,254,76,31,16,115,63,7,191,150,223,198,110,135,221,98,72,247,
221,54,206,27,239,176,233,166,162,167,160,159,29,189,251,26,162,77,223,157,194,
212,197,2,6,146,167,111,201,147,90,9,30,86,121,89,233,141,205,172,170,27,178,12,
99,146,119,195,74,229,233,232,8,1,127,61,32,87,208,227,161,11,80,81,71,144,167,
68,183,254,20,245,241,59,115,124,167,254,84,253,163,62,202,92,47,247,151,227,
246,228,195,124,129,145,179,89,22,198,9,54,142,197,198,103,19,123,209,227,102,
101,106,105,114,211,224,114,47,37,60,82,233,19,60,33,21,131,48,7,215,68,69,37,
173,201,24,71,161,255,0,74,227,79,252,123,79,206,149,235,192,106,12,190,163,252,
31,234,61,124,252,191,149,151,242,93,249,147,252,215,119,54,63,253,31,224,39,
235,127,142,180,25,83,142,223,223,35,119,134,62,161,118,126,46,60,121,133,242,
24,109,165,76,230,26,157,245,188,116,72,136,180,148,108,98,133,216,26,169,160,
64,73,126,107,162,25,160,129,53,207,251,21,126,108,124,190,204,177,242,20,200,
105,34,21,14,112,191,234,225,254,170,117,245,101,248,33,240,175,171,127,151,223,
198,14,179,248,181,212,53,251,131,47,180,122,227,23,61,48,207,110,138,154,121,
243,155,131,45,146,173,168,202,102,179,117,241,209,65,75,143,166,151,35,147,172,
150,65,20,49,133,141,10,165,219,78,162,213,181,183,211,248,174,206,90,87,109,76,
120,10,252,135,144,3,30,184,201,61,58,205,170,128,12,1,142,190,126,223,240,168,
79,231,71,89,242,239,183,178,159,1,254,56,110,122,149,248,215,210,27,166,122,
30,226,220,56,170,135,142,151,185,59,127,111,87,61,45,78,52,77,25,95,185,216,
253,113,144,167,146,8,82,237,29,110,77,100,168,55,72,169,207,191,91,169,187,145,
110,154,190,0,254,204,122,250,185,251,70,23,209,106,127,21,6,157,180,41,80,123,
143,31,243,127,159,253,142,168,159,249,83,252,45,204,252,244,249,233,241,207,
227,21,46,22,191,55,180,55,6,248,161,220,29,183,45,0,152,71,131,234,29,171,81,
14,95,126,101,43,234,225,146,25,40,169,38,196,195,246,81,200,29,24,212,213,196,
136,117,178,251,122,250,87,142,31,14,38,164,206,66,175,200,158,39,253,168,171,
31,144,233,168,148,51,85,135,104,207,95,97,30,150,248,183,241,75,226,38,210,
154,135,163,58,71,166,186,27,106,224,241,83,75,146,200,109,13,163,182,182,138,
193,136,199,83,180,245,85,155,135,114,165,52,25,10,186,122,74,104,76,147,84,87,
85,73,165,84,179,191,4,251,104,65,109,5,102,42,1,3,44,198,164,15,155,53,77,63,
62,158,171,28,121,122,117,81,61,207,255,0,10,117,254,80,93,75,177,123,39,116,
226,62,69,63,108,238,126,190,220,25,13,171,73,214,189,117,180,247,37,102,233,
223,57,154,41,165,166,90,157,161,95,151,198,226,182,181,118,214,168,158,34,70,
93,171,210,143,199,235,86,109,72,26,162,229,220,126,149,172,133,143,10,141,34,
158,164,158,3,228,123,191,163,215,168,163,139,143,245,127,171,236,249,245,101,
31,203,179,231,119,86,255,0,50,15,138,29,121,242,183,169,233,39,194,96,247,188,
153,218,12,174,205,201,101,40,50,187,131,98,238,28,6,102,179,25,93,182,55,44,
248,208,40,211,51,21,52,48,85,50,165,215,197,85,25,5,129,4,222,222,102,148,72,
36,64,178,163,16,64,53,251,8,36,10,130,40,70,58,209,0,80,131,130,58,86,124,221,
248,91,209,159,63,190,56,239,255,0,141,31,32,54,205,46,123,102,111,92,108,235,
142,201,253,180,18,103,118,54,235,134,158,117,219,251,239,105,86,74,165,241,187,
151,109,214,77,230,130,69,42,36,93,81,73,170,41,29,91,115,194,37,85,42,218,101,
83,85,111,67,254,80,120,17,230,49,215,129,167,30,7,143,95,36,255,0,230,109,252,
165,126,95,255,0,43,238,203,205,237,78,234,217,89,173,213,211,241,87,83,197,215,
159,34,182,158,23,39,85,214,59,187,15,89,89,81,22,21,107,178,194,158,74,109,179,
187,12,113,232,168,196,86,188,117,49,205,254,108,205,19,71,43,171,182,220,85,
200,182,184,26,110,105,240,215,141,60,212,254,37,254,99,241,0,122,70,246,165,73,
120,254,3,254,170,124,191,193,213,90,101,132,149,77,69,79,73,12,245,53,57,25,86,
24,41,41,225,121,103,168,154,70,88,224,142,58,120,195,73,36,211,205,32,84,80,
11,18,108,5,253,173,184,117,10,9,52,20,175,77,192,164,150,20,200,167,95,85,95,
248,76,127,242,170,220,127,203,183,225,166,67,178,59,155,17,6,43,228,87,202,169,
118,254,252,221,120,119,140,28,150,194,235,218,92,115,75,176,54,38,70,95,172,89,
129,79,146,155,35,145,128,127,192,122,170,161,3,122,225,54,34,130,179,202,247,
141,240,21,210,159,233,120,150,255,0,110,105,254,212,47,157,64,49,61,170,19,207,
207,237,255,0,99,163,167,252,242,127,152,254,39,249,104,252,3,237,62,218,196,
110,44,94,51,189,55,198,62,167,173,190,59,97,106,101,167,147,37,146,236,141,197,
15,218,141,195,71,139,146,84,154,179,31,176,113,115,75,150,170,112,166,52,48,
69,27,144,102,64,219,186,118,58,45,162,106,75,33,165,71,16,191,137,190,88,192,
63,196,87,175,40,226,199,128,255,0,80,235,227,177,146,220,121,237,205,158,204,
110,237,205,152,174,207,110,125,201,150,200,103,55,6,123,47,85,45,110,91,47,152,
202,213,75,93,147,202,100,106,234,25,231,171,172,200,85,206,242,75,35,18,206,
236,73,231,217,156,40,144,198,177,198,0,80,40,62,64,116,154,69,44,73,36,215,253,
92,122,81,245,126,38,77,231,219,253,91,181,215,9,62,236,59,155,178,246,86,12,
109,186,110,106,247,23,241,109,205,139,160,108,29,53,131,104,151,40,42,12,11,
253,11,251,98,254,77,54,215,14,30,148,141,136,62,152,227,213,225,64,29,69,51,
143,207,175,187,70,218,197,98,54,158,210,192,96,241,88,154,93,183,129,219,91,
119,21,138,198,224,232,210,52,162,192,98,48,216,200,41,40,241,52,177,192,60,73,
75,138,163,166,88,80,32,210,18,49,110,61,167,136,44,54,241,141,58,81,80,99,208,
1,195,242,233,227,86,99,154,146,122,248,220,255,0,58,143,159,189,135,252,192,
254,126,247,206,251,204,239,141,209,184,58,127,99,118,54,233,216,221,5,179,179,
89,9,211,111,236,189,141,183,178,95,192,162,108,46,21,10,209,209,84,110,73,177,
109,144,170,151,71,158,103,156,121,24,133,80,186,219,163,13,16,185,113,250,210,
247,18,124,129,36,170,253,138,8,20,24,173,79,19,94,169,59,80,149,7,3,253,95,225,
234,196,255,0,225,37,31,23,107,187,199,249,168,227,59,118,122,10,106,157,171,
241,111,175,55,47,98,228,228,168,32,44,27,135,115,82,84,236,157,163,246,160,176,
105,106,227,174,202,77,58,240,116,136,75,27,88,94,151,221,243,217,219,175,155,
234,63,98,103,254,60,87,171,69,132,102,62,148,253,191,234,61,125,55,190,76,124,
104,233,79,151,253,37,190,254,60,252,132,216,248,206,193,234,190,197,196,190,43,
112,96,114,33,163,154,39,4,75,65,153,194,228,97,41,91,132,220,56,90,197,90,138,
42,218,119,73,233,231,64,202,109,112,94,150,21,153,66,181,65,6,160,142,32,250,
143,245,80,138,130,8,36,117,224,74,154,245,242,58,254,119,127,202,182,63,229,73,
243,54,163,164,54,182,229,220,155,211,165,119,230,208,198,118,87,81,238,237,203,
67,75,30,121,182,254,67,35,91,139,202,237,156,164,184,240,180,89,92,174,212,
204,209,61,43,84,197,20,2,166,23,142,70,138,54,98,190,247,103,51,200,102,134,86,
6,72,200,200,197,65,24,52,169,161,173,65,21,226,15,150,58,164,163,72,86,81,
199,170,135,158,149,40,234,37,130,119,144,168,70,36,172,64,24,153,117,44,112,
181,200,226,67,98,121,244,254,1,246,188,128,15,28,116,158,165,210,161,124,250,
136,176,235,44,229,192,141,24,46,171,221,89,174,109,26,90,247,102,31,159,192,30,
244,7,157,122,112,96,87,246,245,130,64,21,154,235,101,46,15,164,158,61,36,16,79,
23,191,189,99,141,58,242,240,227,158,185,32,71,215,171,252,218,173,213,207,211,
91,40,210,53,1,123,141,39,235,245,183,189,245,99,214,54,141,160,149,66,130,197,
211,80,111,161,245,39,250,228,216,125,125,232,12,252,186,245,79,88,137,102,140,
18,226,234,71,167,81,37,155,242,196,31,192,250,30,62,190,253,215,171,243,234,
64,230,52,60,222,199,235,97,98,132,255,0,141,255,0,226,190,253,192,99,175,28,
158,178,9,117,163,43,34,61,145,110,223,66,95,81,11,123,15,73,96,44,127,63,235,
251,161,52,90,208,215,231,214,240,14,120,117,54,158,164,154,113,143,13,22,151,
106,141,47,34,170,192,175,80,170,146,25,100,42,89,244,232,30,59,159,75,27,143,
207,187,147,64,23,214,189,86,157,204,252,122,147,16,159,74,86,85,59,249,245,8,
162,168,69,130,98,137,74,129,68,73,17,32,49,149,129,44,214,33,71,36,223,223,191,
14,162,115,252,198,58,241,167,15,47,207,253,95,151,79,185,105,234,42,18,154,42,
151,243,121,113,209,201,10,43,168,104,229,50,13,76,21,8,86,75,40,109,13,253,61,
62,239,43,225,107,156,116,212,64,2,212,28,24,244,155,158,155,199,32,91,137,85,
9,34,68,1,146,68,89,111,228,87,185,244,128,125,67,251,39,131,237,49,212,8,207,
30,148,6,4,87,135,81,178,64,67,80,10,144,202,20,189,238,110,250,150,195,87,244,
110,7,248,123,178,157,77,95,46,181,154,26,244,204,132,22,250,105,6,59,168,111,
161,96,109,112,77,141,253,223,128,110,181,138,231,167,61,8,208,211,200,236,214,
101,113,162,52,82,117,2,44,56,33,150,228,27,155,251,110,148,90,249,31,62,181,74,
19,78,160,202,88,217,88,113,201,35,244,219,80,213,107,139,155,113,239,196,28,
154,255,0,171,231,214,215,215,174,10,45,21,129,28,201,207,54,224,170,254,145,
254,198,223,227,239,64,212,138,28,250,255,0,171,249,117,191,49,83,215,48,73,70,
185,228,216,19,96,0,177,211,97,110,121,35,253,127,119,193,90,156,124,190,206,
189,80,56,140,142,167,71,26,120,153,139,29,90,145,71,211,75,13,42,73,252,155,
113,254,195,221,130,169,28,49,90,245,162,72,52,167,92,16,15,20,227,75,253,99,
186,220,90,247,189,138,127,77,92,95,235,111,123,242,235,212,235,255,211,208,90,
74,80,33,142,85,34,242,6,5,8,180,128,198,56,184,31,131,253,120,247,234,112,61,
104,245,194,41,26,202,188,112,25,65,111,192,60,21,228,127,177,31,211,223,188,
135,237,235,94,103,167,24,156,22,96,108,9,231,73,36,242,160,141,33,133,185,32,
115,253,125,221,8,225,144,125,122,208,200,249,87,172,149,107,168,40,5,120,68,
228,147,234,213,98,111,249,54,255,0,31,126,169,242,225,254,3,235,254,172,117,
224,69,72,242,233,172,143,81,94,7,214,246,228,127,94,57,182,146,125,216,16,23,
35,253,95,234,207,86,235,140,139,227,100,100,109,38,231,75,92,234,86,80,77,190,
150,0,255,0,182,247,67,196,211,61,111,242,235,36,132,85,6,46,132,76,128,2,45,
118,118,28,159,165,137,66,127,219,123,175,90,31,62,155,142,164,54,102,97,111,
210,45,112,71,211,253,135,251,111,123,227,90,241,61,111,169,11,44,160,105,141,
216,220,27,11,150,28,243,192,230,215,31,95,126,225,196,117,175,94,187,133,221,
164,13,43,254,155,27,179,30,72,178,219,155,143,64,254,131,241,199,189,117,227,
242,227,211,138,135,102,77,10,53,93,136,115,244,32,6,26,88,5,176,224,127,177,
247,188,249,249,245,170,142,53,234,124,191,112,212,209,71,51,235,142,36,12,137,
164,177,36,155,16,236,108,90,215,224,253,5,253,248,158,2,184,234,181,200,199,76,
213,116,246,104,222,18,89,100,8,167,232,10,75,111,80,115,197,174,15,7,243,111,
126,167,10,117,112,73,242,235,60,102,204,132,166,160,74,171,131,201,7,145,96,65,
181,212,255,0,197,125,251,42,125,8,235,199,237,234,123,198,38,125,42,192,105,97,
26,151,244,143,74,127,81,123,139,131,207,231,223,188,232,79,90,24,31,111,93,
132,100,231,69,136,137,88,27,146,36,26,130,129,244,226,223,239,62,245,79,78,61,
111,236,234,125,51,212,86,42,64,225,222,56,53,148,69,75,171,240,170,110,226,205,
35,27,0,63,165,253,239,52,52,234,164,10,231,29,96,108,120,150,87,85,4,148,98,
150,182,157,79,173,172,128,27,48,110,44,46,63,7,223,136,165,115,129,215,171,74,
124,250,197,54,58,52,120,192,28,25,4,111,112,61,45,197,237,244,28,17,239,85,242,
235,117,232,250,252,54,254,84,159,61,63,152,77,124,175,241,67,227,198,237,223,
219,82,139,53,6,223,205,246,77,99,80,109,126,178,192,101,39,26,222,159,41,189,
119,29,86,59,16,211,82,68,117,207,13,51,84,84,66,164,22,143,212,183,79,37,204,
113,177,140,106,121,125,20,18,115,194,190,75,95,45,68,14,174,170,72,169,192,235,
123,15,229,67,255,0,9,36,232,63,140,245,184,14,231,249,251,151,219,191,38,251,
126,132,211,100,113,29,69,139,166,170,61,15,178,242,8,171,44,82,102,35,200,69,
73,146,236,236,173,28,237,192,171,134,155,22,174,128,253,180,220,63,182,252,57,
238,63,183,58,33,254,21,57,63,233,152,127,199,87,243,98,49,213,170,171,240,228,
250,255,0,155,173,159,182,135,193,223,134,189,127,216,117,157,179,177,254,43,
252,126,218,61,149,93,69,65,142,159,122,109,206,164,216,248,124,242,209,227,20,
37,12,84,181,180,56,88,90,132,211,162,128,26,1,27,176,30,162,125,236,88,218,3,
95,1,105,232,114,7,204,41,192,63,48,43,215,181,191,241,116,105,25,149,84,179,
16,170,160,179,51,16,21,84,11,146,73,224,0,61,170,36,0,73,56,234,157,20,221,
135,243,207,225,87,103,238,237,201,176,182,7,202,206,128,221,59,207,105,110,170,
141,143,157,219,88,190,213,217,178,102,41,247,117,28,77,53,102,2,146,138,76,188,
83,101,178,20,145,163,121,86,140,78,168,84,130,67,2,2,65,184,90,22,42,102,3,
208,154,168,53,254,18,104,24,124,197,71,207,171,232,106,86,157,26,170,74,202,58,
248,22,166,134,170,154,182,153,239,162,162,146,120,170,96,123,112,116,203,11,60,
109,99,253,15,181,74,232,226,168,192,143,145,175,84,32,142,35,169,62,237,215,
186,247,191,117,238,189,239,221,123,175,152,23,252,44,71,163,51,189,115,252,204,
246,55,119,149,11,183,123,255,0,161,118,169,198,213,161,145,84,103,58,206,166,
167,104,230,232,101,125,58,76,233,68,212,18,133,7,244,76,164,241,237,53,139,24,
174,175,227,39,58,149,199,216,202,7,248,80,255,0,46,171,48,212,136,105,242,253,
159,241,125,106,235,142,145,5,4,199,236,239,82,178,227,76,114,66,88,196,18,239,
41,131,65,80,237,52,230,48,75,27,5,0,129,250,129,7,138,195,78,5,122,44,144,29,
106,53,118,230,160,255,0,135,236,232,245,255,0,43,223,154,219,91,224,31,207,255,
0,143,95,40,247,230,202,166,222,251,19,96,110,185,211,121,98,164,193,227,115,
153,188,102,221,220,120,250,204,38,87,61,180,105,242,118,130,155,117,237,232,
171,69,93,20,193,150,100,120,138,198,200,204,24,23,110,113,188,209,47,134,42,
232,234,192,30,6,134,186,79,30,34,180,244,52,62,93,44,181,162,17,83,138,83,253,
158,190,206,123,27,121,96,187,23,100,236,254,193,218,243,205,83,182,183,214,215,
192,111,13,189,83,81,79,37,37,69,70,15,115,98,169,51,88,169,167,165,148,9,105,
166,150,130,182,54,104,219,212,140,72,60,143,108,67,42,207,12,115,40,33,89,65,
21,227,158,149,48,210,72,62,93,107,117,255,0,10,129,254,105,7,224,135,194,106,
206,144,234,253,201,73,67,242,55,229,157,22,103,96,224,150,143,33,28,123,131,99,
245,85,69,28,212,125,129,191,225,165,141,254,230,158,74,186,89,127,131,227,231,
96,20,84,213,200,232,75,64,108,196,231,199,149,44,199,192,70,167,255,0,75,92,
47,251,115,143,244,161,186,216,194,151,243,224,63,213,242,255,0,13,58,62,255,0,
200,99,182,171,123,163,249,69,124,25,221,249,92,156,185,140,213,15,76,227,182,
78,102,186,119,154,89,228,174,216,25,60,158,206,9,52,211,150,150,105,99,163,
195,66,25,137,55,63,147,239,214,88,142,88,192,194,74,227,242,212,72,254,68,117,
230,205,15,168,29,91,191,181,157,87,164,78,59,178,122,255,0,49,190,247,39,87,
226,183,150,220,201,118,38,206,195,225,55,6,236,217,116,57,90,74,173,199,182,
176,187,145,170,87,111,228,115,152,168,101,122,172,93,54,107,236,229,52,166,101,
67,50,161,100,186,243,237,149,158,22,153,237,213,235,50,138,145,232,62,222,30,
99,28,114,61,71,91,161,165,105,142,170,227,249,246,245,126,67,182,255,0,148,95,
206,13,175,136,194,193,158,203,80,117,5,110,239,198,227,229,164,106,201,68,251,
51,39,141,220,146,213,208,198,135,92,117,244,52,120,233,101,137,197,202,20,189,
143,211,219,23,181,9,4,149,160,73,144,159,179,80,7,249,28,252,171,214,215,241,
15,80,122,249,29,117,180,244,254,10,99,28,107,83,60,76,110,103,109,52,192,205,
16,208,197,108,192,77,19,106,177,183,63,212,91,216,166,212,174,144,5,11,124,
248,127,197,244,27,189,7,83,84,208,31,78,61,45,119,155,172,59,114,120,106,90,18,
30,26,185,35,241,9,34,169,142,165,220,40,244,179,16,209,6,63,81,249,30,245,119,
240,100,100,142,189,102,72,147,21,226,58,250,160,255,0,194,115,254,90,239,143,
152,127,202,163,161,119,183,101,86,203,149,223,29,115,62,225,233,12,214,118,163,
200,106,115,244,253,101,83,6,35,1,151,172,150,70,99,61,124,219,114,74,68,168,
147,143,36,209,179,16,9,246,24,180,236,55,54,195,225,137,232,63,210,149,12,7,
229,90,15,144,29,9,14,66,183,168,255,0,99,171,204,246,179,170,245,170,207,252,
40,91,249,245,77,252,191,241,21,63,18,126,41,205,69,154,249,137,190,118,194,
228,55,6,236,63,111,93,141,248,255,0,181,51,113,178,99,178,207,69,32,146,12,135,
98,231,169,75,75,140,167,155,246,104,32,211,87,50,200,90,24,217,41,241,46,164,
120,34,98,34,95,141,135,26,255,0,2,250,26,83,83,121,3,65,221,149,243,48,140,6,
110,39,135,249,207,250,191,217,41,159,240,141,126,215,222,27,247,173,126,125,
227,187,11,127,110,173,223,188,106,59,175,99,118,6,90,159,115,231,43,50,211,54,
79,120,224,51,223,222,29,204,203,93,60,211,12,166,225,203,80,94,178,113,99,80,
241,33,123,178,143,116,88,210,11,247,142,53,10,158,2,208,12,124,44,195,249,2,7,
91,86,215,22,162,107,221,254,78,172,215,254,21,33,221,153,30,159,254,80,253,
193,136,195,203,77,30,75,187,55,223,88,244,214,153,188,102,103,197,103,247,8,
220,25,209,74,178,6,2,73,49,123,98,72,153,128,186,36,164,139,27,31,118,185,26,
229,178,138,188,101,4,253,138,165,191,227,193,122,245,104,146,55,203,252,63,236,
87,175,154,158,35,123,81,237,173,179,74,149,52,115,69,56,88,165,148,180,161,
161,18,44,50,47,150,50,125,86,228,21,183,246,189,136,150,64,136,6,159,46,136,26,
54,121,77,14,1,235,108,127,248,79,199,242,24,220,61,243,186,250,243,249,138,
252,211,194,125,143,81,226,235,113,187,243,227,95,80,100,24,156,167,97,229,40,
50,43,95,130,236,221,243,66,225,150,131,104,81,212,210,172,248,186,41,63,127,
34,116,78,234,144,4,243,7,238,164,125,197,218,36,106,89,131,70,111,227,161,202,
175,244,120,134,111,62,2,185,32,230,218,17,110,160,145,223,229,242,249,255,0,
155,175,160,79,181,61,59,209,115,249,115,241,191,109,124,191,248,213,220,191,24,
247,150,111,49,182,246,151,118,108,172,142,195,220,153,205,188,41,191,142,227,
176,217,103,132,87,207,136,106,200,230,165,143,32,96,136,172,79,34,58,163,54,
162,166,214,246,158,234,22,158,45,8,225,92,50,176,36,84,118,176,110,21,21,225,
235,213,148,128,106,70,40,122,32,57,159,146,63,203,31,249,16,252,76,235,174,129,
222,157,229,133,216,59,43,169,118,221,102,59,101,117,237,118,110,13,245,222,59,
193,231,175,170,205,87,213,71,180,54,252,11,156,202,101,50,217,44,164,146,53,76,
148,180,148,64,189,140,136,171,195,17,188,118,193,161,70,105,110,11,18,64,0,154,
147,92,240,85,244,26,136,192,243,235,199,57,52,11,254,175,219,214,161,31,204,83,
254,21,185,242,71,228,4,153,30,184,254,95,155,66,179,227,39,92,253,227,83,213,
246,238,242,135,13,184,123,155,115,99,217,158,155,253,198,226,244,100,118,183,
95,81,77,172,72,198,55,200,87,133,30,153,226,55,30,221,250,121,238,113,114,250,
34,254,20,38,167,253,51,224,254,74,7,218,71,84,105,85,62,17,83,243,255,0,32,
235,79,156,131,84,172,185,106,204,187,190,67,59,85,89,85,95,87,144,150,67,43,87,
75,91,44,149,21,85,178,204,204,90,162,90,153,229,46,100,36,150,99,115,249,246,
100,138,177,199,165,69,0,225,246,116,156,157,69,77,120,245,244,75,255,0,132,116,
124,27,218,59,11,226,215,100,252,244,206,80,214,79,218,93,245,186,115,189,91,
181,170,107,233,188,52,248,14,170,216,25,74,99,88,184,86,114,205,57,221,155,185,
29,234,167,1,67,46,58,24,199,232,98,75,20,248,247,147,72,126,24,187,23,237,32,
51,31,183,128,30,153,245,233,88,26,35,81,235,158,182,77,254,103,221,49,216,255,
0,34,63,151,199,203,206,144,234,28,44,187,143,179,123,55,164,55,142,212,217,
24,24,119,5,46,214,147,47,184,50,20,107,246,84,3,61,90,201,71,64,181,44,133,91,
202,203,28,170,76,108,192,61,198,175,145,228,183,162,33,98,29,13,62,74,234,79,
219,128,113,231,195,175,39,30,52,193,255,0,7,95,26,94,233,248,185,242,47,226,
214,243,168,235,111,146,29,41,216,157,51,187,227,169,158,54,195,246,30,216,201,
96,69,114,83,152,214,89,241,21,213,48,12,110,114,142,50,195,247,232,231,158,27,
16,67,16,71,181,246,179,195,113,81,19,130,71,17,192,143,180,28,143,204,14,146,
78,166,62,226,62,206,140,207,193,111,158,127,44,190,1,246,230,201,206,252,118,
239,237,239,212,251,55,53,191,118,142,71,177,246,141,14,90,124,143,93,238,92,84,
57,138,90,76,164,187,171,102,214,137,240,57,100,254,12,242,70,211,120,5,74,197,
194,72,164,41,21,191,178,86,138,73,227,82,46,66,29,36,26,26,230,130,190,98,190,
70,163,229,213,109,174,9,109,4,246,215,207,175,174,159,123,255,0,49,127,134,31,
23,250,139,103,247,55,124,124,134,235,173,149,179,247,246,215,162,221,27,10,
121,50,233,91,148,236,106,42,216,177,230,17,215,219,126,131,238,243,59,170,121,
166,202,64,158,58,72,165,49,121,84,202,81,110,193,0,191,131,194,71,4,187,148,
213,69,4,147,229,195,203,32,142,226,41,76,244,187,65,169,174,5,124,250,168,95,
248,84,151,200,30,172,217,191,201,211,179,112,27,131,49,129,77,203,242,15,39,
214,152,30,168,219,25,163,16,220,57,218,225,185,48,91,186,187,37,132,197,22,106,
159,185,219,120,26,39,168,168,152,13,20,218,128,102,12,232,27,82,184,184,109,
191,195,248,153,195,252,194,133,36,159,151,16,191,157,60,250,209,26,68,154,184,
112,235,74,31,248,75,207,66,236,127,145,31,205,215,169,211,177,54,182,43,120,98,
122,151,98,111,254,224,198,97,179,145,154,140,71,247,191,106,81,80,209,237,92,
173,117,19,82,84,211,86,46,15,43,152,74,184,99,155,74,10,168,98,110,74,128,92,
220,221,223,233,97,80,15,137,40,4,30,4,5,102,32,252,187,69,71,152,199,159,77,
219,168,93,71,208,127,177,215,214,147,45,150,198,224,113,57,60,230,106,186,155,
25,135,195,99,235,114,217,108,149,100,171,5,30,63,27,142,166,150,178,190,186,
174,119,33,33,165,164,165,133,228,119,99,101,85,36,251,82,238,177,163,59,176,10,
1,36,250,1,213,192,36,128,56,245,241,202,254,121,127,204,235,120,255,0,51,127,
155,27,199,121,71,157,53,253,21,212,121,93,197,215,95,31,177,148,176,212,81,227,
91,102,209,230,39,89,119,123,99,229,158,112,185,109,231,53,50,85,74,231,214,96,
88,84,219,77,189,165,219,160,148,33,185,185,106,220,203,147,253,21,242,81,232,
0,63,180,158,61,110,86,31,2,252,3,249,245,78,2,71,84,229,128,228,241,254,60,
241,253,108,63,167,179,74,112,167,76,117,182,47,252,36,159,249,113,225,62,87,
252,208,220,159,44,123,47,26,217,30,179,248,104,48,25,221,175,140,169,166,89,
241,155,131,187,119,39,223,157,156,43,60,183,137,160,217,184,250,25,242,193,44,
196,213,165,41,60,3,236,178,228,248,243,197,105,248,41,173,254,96,30,213,255,0,
108,213,39,212,41,30,125,62,131,74,151,252,135,91,234,127,55,111,230,35,214,223,
203,75,225,71,104,119,182,242,200,82,203,189,178,184,108,166,199,233,61,151,247,
17,166,87,124,118,166,123,25,85,79,128,162,163,167,45,229,108,94,17,216,228,50,
115,133,41,79,69,78,196,144,204,129,189,118,204,83,233,162,254,218,80,84,124,
135,226,99,242,80,127,51,65,231,214,210,128,235,63,8,255,0,80,31,159,95,24,170,
233,242,153,172,134,83,51,148,153,103,169,203,229,107,51,25,90,168,204,78,211,
100,242,114,201,93,82,84,106,184,71,150,114,204,69,192,191,230,222,204,162,139,
195,141,35,81,216,162,159,179,164,140,245,98,72,201,235,232,67,255,0,8,154,234,
76,182,43,163,190,105,247,109,126,11,237,49,59,195,179,118,14,192,219,89,217,
169,87,203,148,254,231,224,50,185,109,195,73,73,92,70,185,105,113,245,59,138,
147,200,131,210,37,112,126,163,217,105,163,238,82,176,224,145,1,246,22,98,105,
251,0,39,242,233,74,255,0,100,191,51,214,231,61,237,219,123,63,161,122,95,181,
59,167,176,55,5,38,214,217,157,93,176,183,70,247,220,91,130,187,198,105,241,
152,237,189,136,170,200,73,63,142,86,69,168,157,158,21,72,161,189,230,149,150,
49,203,15,110,92,201,225,65,44,128,247,1,143,180,225,64,245,36,208,1,230,122,
242,138,144,58,248,128,247,183,127,118,191,201,94,209,222,253,165,219,125,129,
187,251,11,61,187,247,102,233,220,209,85,110,92,181,117,107,227,151,113,110,10,
172,220,240,97,241,211,84,84,81,237,250,9,39,169,184,163,164,88,233,227,0,5,91,
1,237,251,43,104,237,161,84,142,32,24,129,90,12,146,56,146,124,205,124,207,77,
72,229,220,146,216,7,242,232,30,175,132,172,193,227,12,140,81,29,158,73,11,23,
111,79,43,250,174,191,235,251,86,212,20,167,77,84,233,53,233,180,72,235,32,11,
254,109,90,250,137,189,216,128,110,13,236,7,248,251,166,1,207,30,172,1,166,113,
212,209,78,210,198,100,34,209,6,245,92,217,156,129,168,5,91,115,97,126,125,238,
166,189,108,10,0,0,234,28,192,129,32,143,136,238,132,169,250,158,108,53,90,252,
243,254,183,189,14,7,215,171,126,93,57,211,82,201,45,68,42,134,34,74,21,6,89,4,
97,193,86,1,61,66,202,199,77,133,254,167,221,240,24,122,117,162,112,221,96,168,
198,202,173,42,170,159,50,72,215,166,30,171,105,184,107,27,115,32,183,233,31,81,
107,123,169,226,41,195,173,117,18,223,180,47,244,26,175,111,168,63,128,127,216,
251,247,145,245,175,87,205,122,198,140,170,178,112,88,178,169,4,127,98,199,147,
167,242,64,38,222,234,113,79,74,255,0,179,214,240,120,244,231,12,49,212,235,70,
101,80,250,10,205,57,16,165,208,16,202,207,99,161,78,191,192,38,254,239,241,96,
211,253,95,62,168,123,70,122,112,90,97,75,148,164,180,148,142,146,192,88,164,19,
25,214,157,61,92,48,35,209,53,197,237,248,39,221,168,21,134,69,63,193,213,3,22,
66,115,90,126,222,157,252,147,194,212,175,76,145,205,32,164,118,123,0,117,163,
59,137,8,119,10,85,209,108,0,181,190,190,235,35,81,148,10,86,157,105,5,85,193,
224,79,250,190,222,160,78,201,27,83,178,76,103,68,141,90,8,181,235,16,195,52,
194,73,22,64,64,180,173,39,58,121,0,19,237,151,168,43,79,245,121,211,253,95,207,
171,168,173,65,20,249,254,93,50,229,165,13,87,84,200,183,71,98,138,10,132,244,
144,9,212,5,197,193,63,65,193,250,123,112,83,52,61,108,2,168,160,241,233,149,
213,174,111,114,5,236,77,129,244,170,240,9,250,255,0,173,239,220,117,117,186,
112,234,88,149,82,26,116,86,12,238,175,169,91,212,177,248,220,16,2,223,146,223,
91,127,200,189,232,83,72,7,211,173,230,167,172,3,214,75,27,2,174,46,71,208,150,
6,205,164,240,71,4,126,61,209,148,240,29,108,15,47,62,186,211,104,72,43,193,
114,64,228,150,32,88,254,125,2,195,235,253,125,237,23,21,251,126,222,181,233,
233,215,141,188,127,147,96,162,255,0,215,128,13,205,185,212,61,219,73,165,62,93,
110,181,24,52,61,78,163,98,139,227,86,79,84,128,150,54,54,102,136,139,112,9,181,
143,31,227,238,195,3,170,17,214,56,192,240,79,101,81,100,64,110,78,166,62,84,93,
72,63,168,191,63,224,61,235,200,159,245,113,235,116,53,3,175,255,212,208,162,
142,120,227,97,79,60,113,24,75,180,139,82,225,158,111,200,31,82,65,97,110,87,
128,127,216,251,246,58,214,15,88,107,233,34,64,101,166,151,202,133,204,143,166,
222,135,121,28,13,34,192,240,170,47,248,7,143,123,32,130,122,215,204,142,162,64,
246,101,127,85,213,193,34,227,81,177,28,242,61,233,120,227,253,95,151,94,251,56,
117,62,234,88,217,174,8,4,92,142,1,189,189,63,94,46,46,47,199,227,219,140,79,
113,32,117,225,199,61,116,208,106,93,96,11,234,181,192,228,32,183,212,126,69,
207,251,127,117,166,40,167,30,127,46,188,41,74,142,3,166,233,210,224,222,226,
195,128,246,95,81,228,234,33,191,79,22,255,0,120,247,161,76,250,245,176,122,131,
230,149,100,12,183,87,28,112,77,205,255,0,6,223,81,253,63,195,222,186,223,82,
102,150,57,145,156,0,132,133,58,8,250,72,56,58,24,126,45,200,250,125,125,251,
231,231,214,169,78,163,194,254,173,60,11,130,47,123,127,141,185,191,36,251,241,
235,199,172,146,0,13,195,91,232,214,28,158,71,208,159,167,215,223,184,117,239,
62,29,57,65,81,250,82,82,192,16,138,151,93,32,105,189,149,141,190,167,155,127,
95,207,30,253,90,138,86,189,107,242,233,230,107,172,126,160,117,127,82,218,74,
160,35,242,7,58,255,0,167,191,28,117,81,199,39,29,54,84,19,20,147,33,210,222,
152,70,146,57,97,233,42,109,207,173,127,199,223,188,241,213,135,150,58,194,146,
130,195,77,138,147,169,111,97,99,166,222,171,15,233,197,189,239,207,39,173,145,
231,212,168,219,212,71,212,137,8,181,207,168,21,55,252,251,240,201,25,207,94,
161,165,60,250,150,225,180,22,5,141,226,28,14,64,11,55,244,11,233,231,253,231,
222,200,33,169,79,62,181,198,157,101,163,169,120,105,217,131,29,34,164,113,115,
169,67,105,224,55,1,20,168,55,227,147,239,94,67,237,235,76,181,225,212,147,41,
157,190,235,202,169,51,72,236,18,48,67,176,98,57,44,215,84,176,63,155,159,118,
227,86,39,187,175,122,15,62,156,214,158,74,137,168,96,100,26,252,173,103,58,76,
129,120,242,25,52,4,89,138,254,44,7,191,1,90,99,211,252,31,236,117,83,218,15,86,
199,241,127,249,217,127,53,47,140,216,14,169,248,225,241,99,189,225,217,123,23,
9,149,198,237,157,141,214,120,94,177,235,122,252,94,71,55,155,220,10,64,201,
253,246,210,173,204,231,50,251,131,45,90,22,170,105,234,37,158,96,225,117,14,61,
151,205,105,12,34,121,140,178,40,203,49,12,71,150,77,43,78,3,211,128,167,14,158,
71,45,164,105,29,125,127,58,129,123,13,122,167,173,135,110,86,226,242,61,166,
118,46,213,126,198,173,194,99,14,27,15,81,189,228,194,81,62,232,124,94,40,212,
213,156,126,60,102,90,97,12,94,87,208,128,11,251,118,212,202,109,161,51,181,102,
42,9,197,50,115,229,65,81,192,224,125,131,173,181,53,53,56,87,161,23,218,142,
171,214,171,191,240,168,222,205,254,102,251,27,226,14,238,147,226,113,217,157,
101,241,71,23,179,126,251,228,223,117,67,217,88,157,185,220,57,42,92,222,97,54,
229,55,90,108,172,37,105,163,200,209,226,50,191,125,0,171,159,29,44,153,26,255,
0,184,251,120,252,81,44,190,82,235,134,45,113,28,87,17,183,210,18,0,165,8,102,
62,77,157,84,30,148,161,226,198,130,157,56,184,82,84,247,255,0,171,135,95,44,
186,42,89,68,70,178,41,100,138,166,57,149,163,154,55,145,38,71,13,25,214,142,
132,56,146,239,245,6,247,246,110,35,5,73,35,31,203,164,229,187,128,7,163,71,209,
255,0,55,190,102,252,98,170,154,175,227,255,0,202,62,245,234,71,172,7,239,41,54,
87,101,238,172,94,46,176,175,209,171,48,241,100,91,15,85,34,127,89,32,102,95,
193,246,149,172,109,156,146,97,80,254,163,7,246,138,30,174,36,113,248,141,58,
176,46,183,255,0,133,13,127,57,253,129,94,50,56,239,156,253,153,185,161,140,163,
61,7,96,226,246,94,248,198,200,18,64,108,209,110,61,179,93,42,234,38,196,36,
139,123,216,251,168,219,227,252,18,74,15,252,212,115,252,137,35,249,117,230,154,
156,64,175,216,58,185,46,162,255,0,133,169,252,210,218,120,220,14,43,186,126,45,
244,15,107,84,80,197,75,79,154,220,155,111,45,188,186,215,55,156,241,50,173,85,
115,82,71,83,186,118,245,13,101,76,97,136,88,105,18,5,115,112,129,125,62,234,97,
187,76,37,202,145,253,36,169,252,202,178,143,248,207,91,14,135,240,127,62,190,
128,223,13,126,80,109,15,154,95,22,250,63,229,62,195,195,102,182,238,214,238,
237,131,136,222,248,221,191,184,163,68,204,224,158,185,100,131,33,135,174,120,
191,98,169,241,185,42,105,161,90,136,255,0,110,161,17,100,80,21,192,27,182,155,
199,143,89,90,56,98,164,113,21,82,65,161,243,21,24,62,156,64,56,234,204,40,120,
227,162,121,243,207,249,66,124,104,254,99,95,33,126,44,247,79,201,97,150,221,
187,79,227,44,59,227,79,77,57,17,236,222,201,170,221,50,97,42,177,99,119,84,65,
52,25,31,225,152,76,134,28,75,45,44,76,35,175,70,17,77,251,122,131,51,45,172,
143,115,226,164,186,99,100,10,244,248,136,82,72,210,124,171,83,168,241,165,40,
65,207,91,12,52,208,138,144,113,254,175,245,124,250,249,108,255,0,53,9,50,79,
252,205,190,106,97,51,123,67,5,215,169,181,190,64,110,221,165,129,216,216,92,61,
54,209,219,91,107,104,237,74,180,193,109,28,78,43,21,132,167,166,163,199,208,
13,173,65,72,234,34,77,78,142,92,93,154,229,94,202,20,89,68,181,252,77,92,156,
29,70,163,242,56,252,186,67,123,80,236,126,94,159,44,117,95,153,44,93,45,102,
226,195,197,145,104,177,216,58,236,246,62,154,166,190,3,44,244,84,212,114,100,
32,138,182,116,155,198,178,152,169,105,100,44,3,94,66,1,54,191,181,183,133,150,
57,89,87,52,52,167,14,28,58,165,169,29,160,181,79,207,143,95,114,222,141,161,
192,224,58,51,167,241,187,126,190,42,221,175,133,234,126,191,162,194,229,3,254,
205,94,7,29,180,49,48,99,171,252,143,111,218,159,31,10,73,168,254,13,207,178,
139,34,137,99,106,67,118,8,148,215,253,168,232,197,234,93,133,51,94,190,61,159,
206,255,0,231,6,95,249,129,255,0,50,47,144,189,197,36,238,54,22,211,220,117,189,
59,212,148,14,242,52,56,254,187,235,58,250,236,30,50,166,36,14,209,172,251,143,
38,149,89,73,138,216,52,181,167,240,7,187,216,33,104,190,161,190,57,142,179,
242,4,13,35,242,80,7,219,83,231,213,100,34,180,28,23,253,71,173,239,127,225,30,
249,173,245,148,254,84,149,244,59,158,121,170,54,190,3,228,79,102,226,250,241,
231,168,146,115,22,21,233,118,246,67,49,75,2,189,197,61,36,59,142,182,164,162,
41,176,119,115,197,253,210,12,93,223,133,248,53,41,255,0,108,84,87,249,105,235,
103,224,79,207,252,61,95,199,207,63,145,201,241,19,225,167,201,95,146,130,90,24,
171,58,119,168,119,142,241,195,127,18,84,150,138,93,197,69,139,150,45,183,77,52,
15,36,43,84,42,115,179,211,160,139,82,249,75,105,191,62,237,121,36,145,91,177,
136,129,41,33,87,237,98,20,126,202,215,175,40,4,231,135,90,93,255,0,194,68,254,
81,247,127,201,207,157,159,204,83,179,59,207,124,215,118,6,253,237,158,178,235,
237,245,188,183,22,98,74,111,226,53,249,188,102,243,200,226,241,203,73,4,126,37,
163,195,98,49,121,22,164,166,164,166,141,105,169,32,17,198,170,170,23,219,94,26,
65,119,103,28,96,208,199,37,107,146,77,80,212,159,82,107,158,180,164,178,200,
79,26,143,242,245,190,126,251,218,216,61,243,178,55,142,202,220,208,193,81,183,
55,126,214,207,237,140,252,21,90,62,218,108,54,123,21,87,139,201,199,63,147,
246,196,77,69,84,225,137,224,15,106,110,17,101,130,104,220,128,172,164,126,209,
215,151,4,31,159,95,19,92,255,0,94,97,246,47,112,246,215,93,225,242,216,236,190,
19,175,251,63,125,237,42,12,238,46,127,191,161,201,99,182,190,235,202,98,49,
185,10,9,169,221,5,77,53,77,53,32,113,34,18,12,109,113,113,236,215,106,144,220,
89,219,74,248,98,138,79,219,65,209,45,248,41,51,168,206,113,210,55,119,211,101,
50,134,131,3,132,130,93,193,149,220,89,56,240,216,122,60,124,47,81,89,95,150,
201,87,71,65,142,198,209,196,128,60,149,21,85,82,162,68,128,22,145,218,223,83,
237,235,185,81,35,146,71,52,74,18,73,242,166,122,173,154,22,117,160,206,58,250,
249,127,39,207,132,148,31,203,247,249,123,124,123,248,239,246,85,52,91,194,143,
106,83,239,142,213,90,170,169,106,229,126,213,223,112,83,231,183,180,96,200,0,
167,139,29,145,156,81,164,72,2,34,83,11,92,146,72,126,205,91,195,105,228,4,73,
43,106,35,208,28,40,252,148,0,126,117,232,245,188,148,112,2,159,231,254,125,26,
239,150,253,139,187,58,139,227,15,126,118,134,196,207,245,206,213,222,91,3,170,
55,174,236,219,123,147,183,43,107,241,253,107,130,203,225,48,117,117,212,121,
77,229,85,140,166,171,175,76,53,20,144,235,117,142,54,50,48,9,192,98,70,239,
100,120,173,165,146,51,222,41,252,200,24,245,111,225,7,5,168,14,58,242,0,88,3,
195,175,141,22,225,236,206,195,249,17,219,125,149,222,253,229,188,107,251,7,180,
187,43,117,101,55,30,236,222,117,164,78,185,122,202,167,100,242,83,55,130,52,
166,198,199,79,20,113,82,83,164,81,199,79,78,145,162,34,0,0,52,177,130,56,161,
85,69,32,82,185,201,169,201,36,249,146,120,159,94,138,238,165,37,248,255,0,171,
252,221,110,81,255,0,8,208,235,173,202,251,195,231,247,113,36,148,177,108,105,
127,209,55,89,193,76,101,111,190,168,220,244,95,199,247,44,245,30,13,58,86,142,
159,23,82,139,168,177,58,229,176,224,123,45,184,238,221,22,159,130,19,95,246,
236,41,255,0,28,63,203,165,214,216,183,207,153,31,202,191,231,232,254,255,0,194,
193,14,219,151,249,109,245,109,14,71,112,211,99,247,37,87,202,125,131,38,216,
219,206,235,247,123,145,41,246,198,243,254,54,244,145,255,0,156,43,132,164,150,
57,164,97,194,135,80,72,212,61,213,215,85,253,128,95,143,191,31,42,10,159,200,
233,31,237,186,188,141,166,25,73,225,142,190,122,74,251,79,5,46,200,203,111,202,
28,142,107,103,99,183,30,6,179,118,98,113,15,70,185,92,166,217,199,228,232,234,
179,184,220,106,100,28,81,253,253,118,49,37,134,35,49,241,107,97,171,143,169,
205,220,18,155,89,4,110,4,197,72,7,208,211,7,162,123,121,81,174,40,71,109,71,95,
95,223,229,171,243,19,168,62,118,124,55,234,79,144,221,17,178,55,87,92,117,134,
102,135,33,180,182,222,200,222,56,236,86,55,49,183,41,246,5,124,219,65,177,139,
6,14,178,191,15,38,62,152,226,130,211,73,77,43,68,209,1,96,44,64,38,180,52,
140,195,160,41,136,232,32,26,140,0,112,104,43,130,60,129,175,30,142,219,39,85,
120,231,162,147,252,237,63,155,238,215,254,81,255,0,31,54,182,245,162,217,148,
61,163,222,61,185,184,170,182,183,79,245,206,79,37,81,139,194,85,73,137,130,
158,183,114,238,157,211,89,66,175,144,135,111,96,41,42,161,79,28,58,37,170,170,
168,142,53,145,6,183,93,205,36,166,68,183,130,130,86,4,146,69,66,168,197,105,81,
82,73,160,21,30,103,202,135,93,170,11,55,14,180,74,249,11,255,0,10,28,254,112,
159,38,233,242,24,245,239,154,15,143,123,59,53,230,67,183,62,63,237,108,126,208,
174,166,199,84,130,173,72,55,197,104,204,111,133,180,100,3,44,121,8,36,228,216,
253,110,165,118,178,225,77,196,242,56,62,85,210,63,98,233,168,249,49,61,35,107,
224,11,5,80,41,254,175,58,245,74,216,254,182,223,61,247,220,91,67,96,98,50,57,
190,199,238,206,237,236,28,6,208,195,215,238,172,206,79,53,155,207,238,141,215,
149,166,198,81,79,154,206,100,229,173,175,153,100,171,171,13,81,60,174,236,170,
11,27,219,219,147,253,61,133,187,184,64,177,168,38,128,1,249,1,234,124,135,175,
90,141,164,157,198,122,217,178,127,248,71,39,243,2,199,117,164,219,162,143,190,
190,51,229,59,22,28,123,228,163,234,136,106,119,197,44,53,89,8,89,94,12,44,59,
238,171,3,22,24,85,202,1,30,73,96,142,152,53,175,37,189,65,31,212,93,129,175,
233,6,159,77,99,95,236,166,154,255,0,183,252,250,84,97,67,141,121,245,167,250,
143,242,235,86,238,234,235,61,241,211,93,129,191,250,87,184,182,118,71,96,246,
159,92,103,50,187,55,118,237,76,228,95,109,93,182,119,38,26,163,197,81,78,254,6,
104,170,232,106,227,253,200,39,86,104,103,134,68,146,34,209,178,179,46,134,104,
238,34,87,140,246,31,202,135,129,4,121,16,112,71,16,113,210,86,70,142,74,55,10,
245,178,79,242,194,255,0,133,84,247,119,194,173,175,210,223,25,126,64,244,39,87,
239,111,140,29,117,79,142,217,112,110,14,171,192,62,197,236,253,169,178,41,81,
105,98,202,80,98,168,235,151,103,239,10,234,41,75,84,212,253,197,53,37,94,69,
218,70,122,131,51,23,98,239,165,184,182,215,244,210,6,93,68,233,97,147,83,83,70,
20,161,57,166,160,223,50,7,5,130,84,122,106,30,92,127,216,255,0,55,95,72,30,
132,239,142,169,249,57,211,221,127,223,61,33,187,241,219,239,171,123,59,110,80,
238,125,163,185,113,140,222,42,204,117,116,97,140,21,84,210,5,169,199,101,40,39,
13,5,93,44,202,147,211,84,70,241,200,161,148,143,111,67,50,76,154,210,188,72,
32,241,4,96,130,61,65,255,0,99,29,108,130,13,15,90,63,127,194,208,126,46,247,
86,66,171,226,255,0,204,44,86,103,112,110,110,141,218,120,220,223,79,110,141,
169,77,137,243,98,186,195,116,230,235,78,123,31,188,106,114,52,84,254,88,104,
119,220,52,226,134,70,170,127,28,117,56,248,81,8,51,5,45,68,194,13,197,153,207,
246,168,2,159,66,149,170,126,96,234,30,127,23,144,234,178,174,184,168,60,191,
213,95,242,126,206,180,92,162,48,101,105,226,129,244,42,164,76,128,107,244,18,
170,204,128,105,93,100,115,244,55,177,255,0,15,98,4,42,232,23,162,119,6,55,168,
245,232,109,236,95,145,221,251,218,56,127,142,251,59,176,59,14,183,118,237,15,
139,27,121,54,247,70,109,92,252,16,87,97,54,118,19,251,196,187,150,92,98,227,
229,132,67,147,130,167,36,168,178,249,245,179,211,196,144,147,227,69,80,93,251,
178,4,51,232,20,241,65,174,79,157,73,167,166,73,56,243,36,244,168,94,182,149,
174,105,209,141,254,105,31,204,31,189,127,152,247,109,237,30,210,238,121,95,25,
141,235,222,181,217,253,121,177,246,69,21,112,59,123,109,83,225,176,212,80,238,
92,214,51,29,79,77,67,67,69,146,222,187,134,9,114,21,94,40,70,157,81,194,9,72,
16,6,237,182,211,183,197,73,36,215,45,0,212,112,116,174,21,126,193,254,18,79,
159,86,23,159,82,221,184,95,79,240,245,191,183,252,37,135,249,101,208,124,59,
248,65,142,249,43,216,251,67,31,67,242,19,229,156,52,251,219,248,133,126,58,47,
239,38,209,233,137,227,130,77,133,180,82,182,120,254,246,138,45,193,4,127,198,
235,32,82,129,158,170,5,112,90,17,100,81,82,230,119,188,57,81,85,79,176,124,76,
63,211,28,87,248,64,245,233,112,170,160,79,62,39,252,159,179,171,148,254,106,
213,155,182,131,249,108,252,226,170,216,166,165,119,84,95,25,59,112,98,141,36,
47,61,64,242,237,28,140,85,166,40,163,5,216,255,0,14,146,107,145,250,69,207,
227,222,183,31,247,18,65,248,75,40,63,97,117,175,242,175,86,143,226,31,159,248,
58,248,147,83,68,52,41,73,57,93,44,65,6,197,172,73,31,146,125,95,79,102,138,48,
58,78,90,153,35,29,75,171,165,145,84,187,40,64,193,116,234,82,132,220,92,144,
45,112,44,127,160,247,178,40,58,242,145,234,58,250,158,127,194,75,190,56,97,
254,63,255,0,41,188,103,115,100,181,82,231,62,74,118,6,247,237,157,195,89,80,
101,88,169,182,190,212,170,169,217,27,93,2,58,141,16,195,140,219,181,21,69,148,
16,255,0,114,72,36,91,217,76,76,60,91,251,167,110,192,116,255,0,181,140,18,127,
227,69,191,96,233,65,29,168,163,143,31,219,254,197,58,211,127,254,20,153,252,
205,240,63,204,83,231,145,198,117,38,244,147,117,252,100,248,231,183,224,216,
157,99,83,69,13,109,38,43,63,186,50,75,5,127,98,239,8,169,43,162,165,146,73,107,
114,250,40,34,150,72,149,141,54,57,52,146,173,127,110,216,169,150,73,110,228,82,
53,208,40,56,33,7,12,121,18,106,199,242,7,135,84,151,128,141,79,252,95,84,54,
212,84,213,181,180,88,204,72,130,162,183,48,104,241,212,84,133,60,62,122,202,
223,5,45,28,54,103,130,8,170,38,154,69,70,118,97,24,22,38,214,39,217,172,173,28,
72,206,79,104,90,159,217,210,36,87,98,1,6,181,235,233,217,255,0,9,236,254,79,
31,63,255,0,150,69,77,118,99,186,62,89,108,205,193,241,243,178,246,60,91,146,
171,226,206,206,167,206,102,241,248,14,205,220,184,236,5,106,238,119,207,102,
168,105,49,216,172,198,10,8,37,160,171,56,166,146,159,37,165,93,157,213,35,32,
138,47,26,121,226,187,88,132,113,145,158,234,150,82,59,106,160,105,168,36,26,
214,162,148,224,122,48,194,169,77,68,245,105,159,207,19,162,166,249,21,252,168,
254,109,117,213,38,75,37,139,200,83,116,190,123,127,227,102,198,121,222,74,154,
238,175,122,126,194,139,25,85,79,3,198,245,120,252,170,237,198,167,154,50,74,
233,147,81,7,77,139,151,253,176,164,223,239,185,21,191,32,104,127,96,36,252,136,
7,175,38,73,95,80,71,95,26,250,4,134,162,134,6,210,35,153,67,4,145,93,211,85,
136,244,18,1,181,175,207,248,123,56,140,84,3,231,210,23,37,88,143,35,212,26,191,
84,210,49,80,6,144,52,130,72,210,172,20,170,220,146,84,91,143,175,191,54,120,
117,115,81,164,15,51,211,115,129,230,81,19,105,33,138,241,194,157,55,23,98,120,
35,250,253,125,212,129,147,214,210,186,69,120,244,251,44,229,226,137,88,249,24,
45,164,241,186,242,195,209,125,17,128,160,88,253,64,22,39,252,125,232,86,180,
174,122,181,58,100,119,49,201,42,48,96,65,32,163,146,47,103,4,92,11,131,123,125,
61,248,87,133,124,186,221,120,117,159,201,106,184,206,173,43,104,100,82,57,250,
149,231,144,1,35,232,71,248,123,241,174,160,7,14,188,50,58,158,149,101,101,145,
75,37,188,142,85,217,24,202,133,223,212,67,134,189,152,128,7,228,123,241,244,
235,84,235,157,100,72,244,162,101,84,30,187,49,143,128,110,196,92,131,201,55,
247,179,194,181,243,235,96,249,87,166,61,4,113,245,255,0,91,252,120,23,254,135,
222,184,159,151,91,192,168,60,58,149,16,77,64,72,154,227,58,133,153,217,0,102,
82,171,37,193,228,196,214,63,235,142,125,238,185,3,173,54,6,14,122,113,99,28,
85,116,108,218,204,130,206,210,8,213,18,162,101,186,23,10,45,120,89,16,14,45,
123,94,198,254,252,194,149,63,234,251,122,166,72,108,116,236,245,145,75,26,9,17,
65,120,172,210,64,52,63,18,56,67,125,65,65,101,60,241,110,61,209,200,168,98,58,
218,169,3,183,136,233,185,203,55,42,165,84,24,135,167,77,213,56,94,111,203,112,
188,1,249,231,221,15,225,58,123,122,181,0,63,234,227,211,53,102,182,154,96,46,
121,255,0,19,250,23,235,207,54,36,251,116,99,81,249,245,182,225,243,234,28,142,
2,125,75,18,172,5,254,129,181,5,102,252,27,113,239,194,185,36,121,245,226,125,
122,192,24,222,35,96,10,134,177,176,36,159,165,205,253,239,173,14,185,194,78,
183,7,253,79,244,254,159,64,127,219,251,241,3,207,203,173,130,65,207,82,155,136,
77,192,250,223,158,109,168,240,127,192,254,125,208,26,2,120,87,61,108,129,90,
215,174,138,169,142,17,164,134,96,67,27,222,226,246,91,125,65,35,221,135,90,60,
114,58,231,16,211,17,34,193,146,69,32,145,205,212,92,14,7,63,79,118,28,15,173,
122,173,58,151,3,32,165,174,0,146,10,66,172,134,45,78,186,170,97,144,20,123,250,
9,120,249,63,66,56,252,251,215,175,250,188,250,209,252,61,127,255,213,208,117,
162,50,50,132,98,116,40,98,162,218,236,6,167,104,248,187,145,126,63,214,247,109,
52,60,51,214,189,105,215,104,239,166,192,131,27,146,178,31,213,123,47,33,212,
128,214,54,191,244,191,187,156,233,175,94,255,0,15,80,139,0,73,80,110,13,129,3,
235,253,64,210,110,8,3,234,56,246,217,26,73,235,94,120,225,212,165,125,68,19,
233,112,53,50,254,64,0,88,168,252,251,186,144,42,41,138,127,62,188,7,175,79,84,
53,26,8,12,138,200,200,202,227,79,215,149,55,187,88,27,144,13,189,211,241,31,
46,180,192,17,199,168,25,74,97,28,229,161,98,80,253,47,195,2,66,250,8,60,113,
248,60,251,217,26,72,167,12,117,181,225,211,12,188,147,165,66,145,203,95,210,65,
252,159,246,60,127,177,247,94,173,212,113,115,126,120,226,252,254,46,0,250,145,
244,247,238,189,212,136,224,144,130,235,200,22,253,63,95,175,3,252,79,31,143,
126,235,213,3,174,206,173,94,171,131,197,239,245,183,211,155,115,244,247,238,
189,215,40,228,242,105,66,79,244,0,159,170,146,120,191,55,210,126,158,253,249,
117,162,61,7,79,208,74,239,18,70,237,168,145,30,150,12,198,202,89,117,22,63,225,
107,123,182,56,87,211,170,83,249,117,233,224,103,149,131,41,86,186,29,28,3,205,
180,222,247,228,95,253,183,191,53,42,115,213,171,74,14,154,221,90,25,89,13,192,
13,207,212,240,79,212,14,57,247,160,120,30,183,90,245,43,144,65,4,2,52,217,191,
175,31,83,254,36,123,247,3,158,188,56,117,57,42,45,11,249,23,245,40,181,191,1,
88,159,85,254,183,35,219,167,35,142,15,94,29,113,89,80,70,0,176,98,250,245,253,
24,0,188,1,123,122,127,175,245,247,70,90,125,157,123,174,174,235,226,177,42,
164,55,63,64,220,243,125,39,145,238,160,18,43,214,235,243,234,101,54,106,106,26,
132,148,16,222,49,41,1,143,246,153,2,254,108,5,136,227,222,193,43,229,213,25,1,
20,29,109,201,255,0,9,115,254,92,255,0,38,55,151,204,157,149,242,247,177,254,
22,98,183,95,199,45,183,140,168,151,111,119,7,124,28,158,209,195,237,108,252,
237,29,118,63,125,116,206,213,173,198,76,221,161,188,169,214,33,13,45,75,65,252,
54,129,42,90,160,85,36,235,23,178,203,167,55,82,67,28,4,58,171,141,99,138,83,
204,49,168,200,226,23,187,52,212,0,207,79,160,8,24,182,9,24,245,255,0,87,207,
211,175,166,204,178,197,4,82,77,52,145,195,12,49,188,178,203,43,172,113,69,20,
106,94,73,36,145,200,84,141,20,18,73,32,0,61,152,18,20,22,99,64,58,111,173,50,
127,153,111,252,43,231,163,58,7,117,110,110,154,248,31,214,180,223,36,59,3,108,
229,178,88,13,193,219,123,222,174,191,110,244,190,43,37,141,154,162,134,182,45,
171,69,64,209,110,110,192,48,85,199,233,170,89,49,212,15,160,152,222,161,24,55,
180,168,247,55,64,52,10,35,132,240,102,21,36,122,133,168,160,244,44,107,234,157,
88,148,79,139,39,211,253,95,234,249,245,164,39,205,111,230,187,243,247,249,131,
201,153,163,249,57,242,43,118,110,157,135,153,220,116,219,150,46,163,196,253,
190,216,234,172,38,67,30,146,174,38,44,78,208,196,164,20,102,12,74,202,222,3,82,
213,18,137,9,145,157,164,37,253,168,139,111,134,41,4,237,86,184,254,38,53,63,
151,144,244,192,28,79,207,166,204,174,123,105,69,249,117,95,113,209,188,56,216,
207,136,149,158,163,84,50,68,73,97,161,157,95,145,250,173,193,23,183,250,254,
204,52,159,15,135,159,76,107,95,16,231,203,168,181,20,18,161,34,39,102,83,228,
214,164,50,58,178,169,42,100,81,114,183,23,181,248,247,66,135,143,86,14,180,167,
3,254,175,219,212,173,183,61,12,57,60,122,231,147,37,54,6,58,202,89,51,144,98,
158,158,28,172,152,149,168,136,229,6,42,122,248,231,164,143,38,212,106,226,19,
42,60,75,38,146,202,69,193,108,180,161,36,11,77,116,52,175,10,252,254,95,102,
122,179,5,52,45,235,215,208,39,249,35,127,35,15,228,119,243,7,103,224,254,89,
245,207,102,119,151,202,248,54,78,224,162,135,116,244,231,120,211,96,118,102,59,
97,111,53,167,90,250,125,173,217,123,63,106,98,161,167,221,49,199,16,243,67,
226,201,77,140,175,134,204,193,208,180,96,162,54,184,185,102,134,226,114,142,
160,22,85,26,112,120,81,245,49,42,104,114,165,79,173,14,58,81,69,80,10,173,71,
169,255,0,55,252,95,91,205,224,240,88,77,177,134,197,109,205,183,136,198,109,
253,191,130,199,210,98,112,184,60,45,13,46,47,17,136,197,208,66,148,212,88,236,
102,58,138,40,105,40,104,104,233,227,84,138,40,145,81,17,64,0,1,237,122,34,70,
170,145,168,8,56,1,195,170,18,78,79,30,157,125,219,175,117,242,58,255,0,133,13,
96,170,246,239,243,181,249,133,5,102,25,49,145,238,76,198,199,207,209,211,42,
208,86,38,94,147,37,215,27,93,151,44,68,33,141,60,153,9,41,164,39,85,167,70,185,
60,251,174,208,202,5,194,159,41,164,254,108,79,243,6,191,159,73,111,199,96,111,
232,142,169,39,118,197,28,176,85,152,199,216,34,89,38,166,118,242,1,43,45,210,
56,221,71,54,241,173,216,255,0,94,77,253,153,78,65,4,129,65,210,91,114,65,81,
196,241,7,175,171,135,78,252,244,192,244,151,252,39,87,171,62,99,246,134,118,
120,43,112,95,8,241,24,140,116,213,66,58,44,166,127,176,163,219,149,29,113,179,
49,24,200,102,84,19,215,101,55,37,53,50,197,165,78,168,129,144,250,65,62,194,
234,88,109,207,108,159,218,51,188,75,254,246,202,63,37,92,159,144,61,28,19,87,
14,120,80,31,229,215,201,220,98,166,201,82,215,229,242,82,77,252,74,174,105,
235,170,106,25,11,138,137,234,101,105,234,37,145,237,204,179,74,89,128,191,36,
251,16,44,97,35,10,49,65,252,186,47,241,143,137,74,84,87,175,165,103,252,35,99,
125,102,179,255,0,203,107,182,54,61,124,176,201,138,235,143,147,123,182,147,2,
177,209,172,18,69,6,232,218,251,95,112,215,172,213,35,154,194,245,243,187,41,60,
198,173,167,233,236,174,46,219,235,229,7,4,35,126,100,21,255,0,2,143,245,30,151,
86,177,198,126,209,254,175,219,208,155,255,0,10,241,238,252,199,88,255,0,42,
180,235,204,36,213,180,211,119,247,122,117,254,193,204,79,77,14,168,31,108,225,
33,203,239,156,165,13,92,255,0,238,133,173,173,219,180,128,126,92,43,15,165,
253,250,126,251,155,40,188,181,51,159,246,162,131,249,176,63,151,90,173,18,67,
231,74,127,171,246,117,161,231,242,95,249,137,150,248,5,252,199,62,50,119,92,21,
179,209,236,140,230,247,163,234,46,221,162,134,113,246,249,46,185,236,154,154,
109,189,155,74,180,242,44,50,62,14,166,166,155,41,14,191,211,61,18,31,199,183,
175,208,172,30,58,142,248,142,177,246,15,136,126,106,88,125,164,31,46,153,129,
245,72,84,240,35,175,175,231,126,116,206,211,249,35,210,29,161,209,155,206,191,
59,67,179,251,115,99,103,118,78,107,41,180,179,85,88,45,195,67,141,220,56,249,
41,27,37,129,205,227,228,74,138,44,133,39,145,101,134,69,37,75,40,12,25,9,83,
169,225,75,168,12,100,246,154,16,120,228,16,65,161,193,21,3,7,7,135,79,2,84,215,
175,143,31,205,79,135,155,187,249,105,124,218,238,127,137,25,252,252,27,198,78,
189,204,208,213,109,205,221,79,67,37,36,155,175,100,110,92,125,54,123,107,229,
170,49,242,95,237,43,234,49,85,200,149,113,43,60,107,83,28,129,25,151,73,246,
191,107,185,50,163,6,80,37,86,42,212,225,81,233,242,34,132,87,200,244,87,184,66,
49,158,210,58,94,255,0,47,79,146,95,31,126,55,255,0,48,191,139,189,253,242,107,
3,22,123,166,250,219,127,54,228,222,45,83,183,107,247,42,225,141,46,19,40,112,
59,130,131,107,227,151,238,50,121,109,185,184,205,45,93,60,90,36,85,158,48,229,
91,79,189,111,17,188,208,5,69,44,117,169,43,142,229,12,9,25,160,225,92,18,43,
192,227,175,109,196,35,154,224,80,211,237,235,235,157,241,171,228,71,89,252,178,
232,142,177,249,27,211,121,12,134,83,172,123,115,108,211,110,205,157,93,150,198,
203,135,202,77,137,169,154,122,116,254,33,138,157,222,106,10,184,230,166,117,
120,152,146,164,123,69,4,194,120,245,133,32,212,130,13,42,8,36,17,130,71,17,228,
122,52,97,67,74,245,172,39,252,43,91,249,140,210,124,127,248,163,130,248,43,179,
13,68,157,163,242,254,149,231,221,85,177,188,208,83,237,190,150,219,25,170,57,
51,64,202,128,45,78,71,121,102,233,99,199,199,14,171,45,42,84,59,3,232,12,211,
15,168,186,142,220,124,17,144,237,246,212,232,95,218,53,31,74,15,94,180,237,
225,198,205,230,112,63,203,254,110,190,122,27,98,106,140,118,58,104,163,171,122,
24,233,17,41,2,203,4,156,79,45,59,24,188,141,254,96,107,98,84,94,231,253,183,
177,44,43,72,253,60,184,116,31,153,170,227,21,174,122,250,15,127,194,56,251,47,
103,110,95,132,63,35,122,247,23,182,32,196,111,109,131,242,58,167,41,188,183,20,
94,103,155,119,81,239,61,171,140,159,109,79,83,44,154,163,18,97,32,195,84,82,
170,41,225,0,98,46,196,144,231,13,198,240,55,196,202,132,125,157,203,79,200,130,
127,219,116,125,23,246,17,250,10,245,70,223,240,170,127,151,181,127,33,191,153,
30,15,227,78,43,42,42,186,227,226,46,210,199,225,166,161,165,173,113,71,39,106,
111,170,74,77,199,188,107,43,85,125,17,215,227,49,95,195,232,77,174,202,176,17,
193,36,123,127,109,65,61,213,205,203,124,33,180,47,216,188,127,107,147,95,244,
163,164,215,210,24,226,10,56,210,191,183,253,142,169,151,227,55,195,221,205,243,
191,190,182,87,197,157,183,218,189,99,212,91,179,126,227,51,227,98,230,187,95,
39,144,199,109,173,195,184,49,152,201,43,113,219,34,135,33,140,161,175,156,110,
13,208,244,230,42,4,101,88,230,156,105,190,162,3,24,238,183,47,107,4,108,35,46,
11,83,136,28,120,100,224,84,224,87,21,34,188,107,210,13,185,22,73,91,186,134,
159,234,255,0,87,167,95,87,191,229,171,241,6,63,129,191,7,62,58,124,84,146,191,
27,151,205,117,70,193,163,198,238,252,222,33,106,23,25,155,222,217,58,154,156,
230,239,202,208,138,160,181,31,105,85,158,201,78,98,44,170,76,97,73,81,244,246,
79,107,27,164,108,101,20,149,217,152,230,180,44,107,74,255,0,68,80,124,233,209,
217,166,0,224,5,58,210,151,254,22,41,209,95,36,233,62,80,124,123,249,53,159,166,
175,220,191,19,160,235,170,110,181,218,181,248,186,10,151,197,245,167,98,12,190,
71,45,184,241,123,170,162,50,241,82,87,239,136,228,130,162,134,161,194,36,241,
82,52,0,151,134,199,214,229,99,190,156,75,241,56,82,167,200,170,140,168,249,
171,85,143,168,106,249,26,55,58,150,136,105,255,0,81,235,87,189,191,184,182,174,
113,113,144,100,178,48,109,220,123,65,23,241,28,196,84,242,87,205,76,142,124,79,
37,62,50,146,104,159,33,58,198,125,48,235,140,49,2,236,162,237,236,70,210,86,
29,81,165,92,14,21,165,127,63,46,136,4,110,178,144,205,219,95,229,213,213,252,
15,254,105,159,203,75,249,96,238,60,119,99,117,247,192,110,208,249,13,222,52,
212,85,240,212,124,133,238,30,203,217,216,252,254,42,174,166,142,116,161,29,95,
176,113,251,99,53,130,235,188,109,117,83,42,212,212,125,229,118,91,237,64,31,
112,218,138,123,13,77,107,186,75,32,150,115,9,32,213,86,173,164,124,233,65,86,
30,166,191,209,211,209,228,18,219,129,165,53,86,156,113,95,245,127,171,61,94,
55,242,177,255,0,133,93,102,190,98,252,218,219,255,0,27,62,82,244,255,0,85,116,
38,195,237,201,39,219,157,79,187,246,230,225,220,85,83,225,251,17,221,63,187,
91,91,121,100,183,5,64,199,85,211,238,242,26,146,10,152,225,163,17,228,30,20,
211,162,79,77,100,107,155,102,89,39,149,90,26,209,168,186,116,250,55,19,128,104,
26,167,0,234,192,7,165,10,85,234,0,161,242,255,0,55,250,190,206,133,111,248,82,
23,242,23,207,124,201,138,191,231,87,195,236,5,70,91,229,38,214,192,227,241,
221,163,212,244,62,13,61,229,179,118,245,41,167,160,202,109,216,166,120,85,59,
55,108,99,144,67,20,33,180,229,232,209,97,22,168,138,47,37,137,123,57,30,100,5,
173,220,213,128,21,42,120,106,3,137,28,53,40,255,0,76,51,80,106,202,36,26,79,
196,56,117,243,174,202,226,98,151,31,147,219,27,151,109,87,237,173,227,183,50,
185,28,126,82,139,33,71,81,138,220,24,220,173,52,230,142,183,25,157,199,86,195,
21,92,21,52,85,113,186,203,4,137,28,145,186,21,176,55,30,205,226,120,230,136,
58,144,65,21,4,121,255,0,177,209,121,87,142,83,83,143,67,209,255,0,254,94,255,
0,205,7,230,183,242,178,222,152,29,233,208,189,131,152,204,245,36,121,218,74,
237,255,0,241,251,115,229,235,235,250,151,127,82,85,74,203,150,165,124,28,174,
233,181,243,213,84,229,204,89,92,122,197,85,79,51,43,177,149,111,27,34,185,178,
86,38,104,155,69,198,59,135,159,201,134,53,15,42,28,143,34,13,15,74,98,184,206,
150,202,250,127,179,215,212,139,225,7,206,47,135,95,206,47,226,60,187,207,101,
82,237,157,247,179,119,150,12,237,46,241,232,61,255,0,77,137,205,230,182,54,
114,178,146,51,154,216,251,255,0,108,85,164,176,213,209,23,98,244,53,226,47,180,
200,64,18,120,24,48,101,141,42,178,92,171,219,220,70,4,195,226,95,240,50,156,18,
43,149,97,144,125,24,16,20,229,104,202,113,254,175,245,83,173,51,255,0,158,223,
252,38,107,115,116,30,71,112,252,185,254,91,59,2,187,114,244,108,52,50,230,123,
75,227,118,223,108,150,115,119,117,123,210,35,75,147,221,61,109,71,87,61,110,
79,116,108,121,32,83,53,78,54,54,150,187,24,85,154,36,154,159,136,47,21,196,
150,36,172,204,90,214,184,99,146,191,39,245,30,143,229,248,169,77,69,169,96,89,
129,43,135,244,245,251,63,205,251,61,58,211,107,13,184,41,214,172,165,85,37,218,
153,202,79,27,39,137,224,138,38,62,84,100,116,213,20,136,203,111,80,176,60,112,
125,158,195,50,150,83,130,58,41,158,221,194,144,14,127,203,210,211,31,187,54,
181,46,240,217,155,163,119,237,113,187,118,110,23,116,97,115,155,159,105,81,228,
34,199,213,110,93,187,142,204,82,213,228,48,39,39,37,45,91,80,127,23,161,141,
233,204,166,41,4,126,66,66,146,45,238,155,129,121,224,149,98,33,100,42,64,62,
132,140,31,203,175,89,39,131,34,171,212,128,71,217,249,117,246,124,254,94,223,
46,250,67,231,39,196,94,155,249,19,241,241,63,135,117,198,233,219,52,152,170,
93,163,50,211,199,146,235,220,198,217,134,60,30,107,96,101,160,166,146,72,97,
173,218,213,148,102,157,74,233,73,105,196,114,160,209,34,251,35,180,96,97,17,
232,210,241,246,149,244,32,14,30,160,138,16,125,8,174,122,59,108,154,214,160,
231,161,91,229,7,80,108,222,251,232,78,210,234,46,201,220,251,163,105,117,158,
249,217,185,220,39,99,101,246,102,117,246,182,227,27,34,124,124,237,184,233,104,
55,44,41,37,70,14,58,188,106,58,84,79,26,235,251,114,234,8,12,79,186,223,69,
226,192,117,76,82,37,58,152,128,13,66,230,153,168,166,51,140,140,117,180,52,111,
134,164,227,246,245,241,29,237,76,47,95,227,187,159,182,168,58,179,213,215,56,
174,197,222,120,174,190,251,138,217,43,166,155,102,99,247,30,78,139,110,78,213,
117,10,38,171,168,168,195,195,11,188,165,117,57,98,214,23,183,181,246,62,35,91,
64,243,127,106,80,19,246,211,61,33,184,96,29,148,3,166,189,7,237,129,175,207,
230,112,59,95,24,30,76,182,225,205,99,48,184,248,44,100,121,171,115,21,112,99,
233,17,74,2,210,25,42,106,20,88,94,247,227,219,151,46,34,141,221,190,21,82,79,
228,43,214,224,26,152,80,86,184,235,237,235,241,247,161,241,253,69,240,191,169,
190,57,109,202,100,198,82,108,191,143,27,99,172,40,225,64,148,226,158,174,151,
97,211,97,42,37,62,52,69,141,223,34,242,72,205,107,234,98,79,62,201,226,133,
219,107,240,127,209,94,19,254,244,224,147,252,207,75,137,253,90,158,0,255,0,131,
175,136,247,117,108,156,175,87,119,143,110,245,126,227,164,168,167,206,236,110,
212,223,27,43,45,76,242,9,39,76,134,221,221,153,60,69,82,60,136,21,37,127,61,33,
245,1,102,250,139,123,89,107,48,123,88,100,3,138,3,252,135,77,72,167,81,21,197,
122,221,83,188,191,225,31,84,21,159,9,49,61,233,241,99,191,251,43,122,124,139,
147,170,182,175,102,209,117,31,96,224,54,206,59,5,187,37,201,109,168,183,46,91,
100,225,242,24,120,225,200,226,119,69,171,22,155,31,36,238,244,242,79,22,153,
130,121,53,198,137,46,175,13,188,119,146,132,104,74,134,42,170,218,130,145,82,
70,78,162,61,40,43,229,154,14,156,240,227,12,84,86,190,181,199,91,184,127,47,
173,145,223,125,105,240,175,227,71,94,124,156,203,96,51,157,221,178,122,127,100,
109,157,239,148,219,145,87,67,67,61,94,39,7,71,73,69,5,92,121,11,206,115,120,
236,100,112,210,228,29,73,138,106,200,100,146,59,35,133,14,237,235,34,219,34,
186,105,95,194,60,194,28,168,108,10,16,13,8,249,113,235,210,83,86,14,124,254,
223,62,167,124,251,221,27,87,102,252,31,249,115,184,55,182,224,164,218,219,98,
155,227,159,112,209,100,247,5,124,117,50,209,226,198,107,98,103,48,148,115,212,
71,71,28,181,45,27,87,228,98,67,165,73,245,115,97,115,239,219,139,1,101,112,13,
106,203,164,124,203,96,15,204,144,58,244,127,26,245,240,253,198,50,136,35,84,33,
9,80,146,181,194,171,46,160,73,0,13,122,153,126,183,230,220,123,51,67,142,153,
96,60,199,78,51,10,116,98,206,140,204,240,177,80,91,79,140,240,110,121,37,153,
180,253,56,176,247,122,241,199,85,165,60,186,79,77,35,7,140,133,85,91,187,45,
133,184,55,23,55,252,145,254,243,239,102,158,93,107,242,233,223,196,190,22,153,
24,70,30,48,201,113,123,177,182,168,219,72,176,36,31,175,244,247,170,100,250,
245,99,229,211,101,82,49,105,101,33,130,175,164,145,245,15,96,121,6,196,3,248,
247,160,56,159,94,188,78,58,192,203,166,88,249,177,11,27,112,111,99,99,195,127,
181,92,123,247,152,31,46,189,229,215,51,40,243,49,114,121,107,255,0,173,123,126,
126,163,254,53,239,126,125,107,167,81,255,0,0,173,125,74,24,72,22,220,220,159,
213,207,4,27,251,209,225,195,21,235,192,138,252,233,211,97,63,91,92,139,169,250,
114,191,237,190,183,191,186,12,128,71,30,175,95,159,82,98,210,25,137,23,0,19,
253,0,5,128,252,254,125,184,58,175,88,124,224,176,102,23,104,220,105,80,154,76,
209,155,122,154,79,174,180,250,3,110,71,248,251,161,24,200,207,30,189,212,208,
195,204,25,6,148,2,214,28,125,88,250,136,44,110,73,62,244,253,170,190,189,108,
121,131,199,167,43,196,128,146,164,72,168,31,89,60,175,44,110,136,120,179,222,
223,78,7,189,105,4,12,86,148,243,234,164,156,87,164,253,100,165,231,145,148,155,
2,202,47,109,86,63,212,254,110,7,183,78,42,71,30,189,171,80,168,225,211,92,
130,247,23,228,30,7,215,131,201,231,250,127,197,125,232,12,154,112,235,221,115,
64,167,199,171,133,64,117,16,45,115,113,197,255,0,62,159,117,44,106,8,62,127,
234,253,167,249,117,117,20,173,122,229,1,12,89,141,238,218,207,244,181,237,163,
250,131,96,7,251,15,126,24,57,24,63,228,227,214,252,207,82,223,152,72,252,105,
95,232,57,191,245,183,62,247,154,124,250,214,120,215,174,0,22,42,161,84,105,
176,80,63,212,216,17,233,255,0,110,109,238,194,153,199,90,57,225,214,104,145,
140,50,177,181,181,157,38,196,6,107,233,33,79,208,114,111,248,247,96,59,73,61,
84,249,15,94,184,0,68,76,227,141,78,177,144,0,177,181,218,206,163,243,170,196,
94,252,143,116,160,225,78,183,83,95,159,95,255,214,208,105,139,44,142,69,163,
23,97,167,81,31,141,55,227,234,15,230,220,123,81,131,251,58,173,72,166,58,155,
4,73,49,141,117,248,228,139,204,89,85,65,18,113,117,82,65,93,26,152,145,207,
22,246,217,90,147,243,29,120,158,62,189,67,158,142,68,8,227,85,158,250,79,213,
110,9,213,102,38,246,255,0,31,161,247,186,142,33,113,214,235,156,117,12,139,53,
255,0,181,112,110,167,139,145,192,230,220,251,108,224,231,175,14,156,232,230,1,
213,36,81,249,1,216,27,27,255,0,170,11,250,8,254,163,250,123,115,180,154,30,180,
70,49,211,132,138,101,145,238,76,138,167,145,112,87,72,109,37,131,2,125,62,234,
71,169,235,94,95,62,153,39,129,188,140,202,53,169,98,183,98,9,211,200,60,16,57,
255,0,17,244,247,78,175,94,161,188,90,127,178,64,255,0,17,254,63,67,127,173,189,
251,173,117,38,144,144,193,9,244,22,185,231,133,38,247,55,63,147,255,0,19,239,
221,105,133,69,122,205,52,70,86,70,11,24,5,111,114,66,187,5,33,73,107,144,90,
228,125,45,244,247,239,203,175,12,14,162,75,2,44,140,81,128,34,214,85,37,128,98,
1,62,175,173,191,192,142,61,251,243,235,96,240,233,202,134,100,77,76,64,186,
198,66,216,94,236,214,91,255,0,137,7,222,197,71,90,32,227,29,58,184,99,35,74,79,
171,208,1,54,179,112,131,141,55,28,40,255,0,94,254,247,64,124,250,169,206,58,
105,170,44,90,48,71,30,70,42,74,253,85,136,55,212,71,62,244,41,235,213,151,133,
122,232,17,244,191,36,159,247,223,236,61,220,128,193,113,231,213,143,82,130,40,
133,239,127,84,86,231,158,68,151,176,63,129,238,212,198,7,90,167,81,157,85,116,
141,36,93,120,230,252,178,216,159,167,210,255,0,143,175,191,19,199,25,161,235,
221,120,182,133,139,155,90,227,233,113,201,23,250,241,249,247,86,32,168,199,151,
94,235,117,191,248,70,159,197,78,156,238,206,209,249,151,218,253,191,211,253,
127,218,7,175,118,159,92,108,253,151,89,216,27,103,29,187,105,182,237,102,241,
174,220,213,155,145,113,152,156,237,45,118,30,58,140,166,51,17,2,75,51,66,211,
172,107,161,25,85,228,12,91,50,164,247,145,67,32,213,24,136,177,7,133,106,160,
84,121,208,106,165,122,112,118,161,35,226,175,95,71,42,26,26,44,101,21,30,55,
27,71,75,143,199,99,233,105,232,104,40,40,105,226,164,162,161,162,164,137,32,
165,164,163,165,129,35,130,154,150,154,8,213,35,141,21,81,17,64,0,1,237,106,170,
162,170,34,128,160,80,1,128,7,203,170,18,78,79,30,181,39,255,0,133,64,127,57,
156,87,196,255,0,140,207,241,51,227,78,255,0,219,249,95,144,95,37,113,187,135,
109,239,13,195,180,183,29,22,75,33,212,29,77,3,203,132,221,211,201,38,30,166,
118,198,239,13,217,85,230,196,210,199,43,199,53,44,34,170,109,58,210,59,161,102,
75,233,62,158,39,13,108,50,228,100,28,225,42,61,72,37,191,162,41,248,177,127,
128,106,63,23,151,249,250,249,132,192,190,33,126,67,155,92,30,111,249,228,91,
158,126,190,206,20,104,24,167,76,154,147,242,234,88,144,44,97,24,16,194,67,37,
254,172,53,125,52,216,233,253,35,232,109,239,122,184,99,173,17,158,156,158,170,
122,122,122,40,174,150,26,164,231,240,116,198,44,214,32,3,205,253,220,200,20,32,
224,122,107,195,212,204,79,83,191,137,171,188,158,72,213,11,179,145,52,77,173,
70,164,211,234,75,107,43,115,245,23,35,250,123,183,136,40,113,142,169,224,144,
65,213,90,121,127,179,214,76,100,216,201,137,90,182,9,231,86,16,200,116,233,
134,80,202,75,43,61,215,80,210,120,32,95,219,117,92,131,214,217,94,160,142,174,
51,249,50,127,54,174,226,254,84,159,38,246,158,79,31,186,114,153,239,138,189,
149,186,177,152,207,144,93,77,85,82,223,192,114,24,122,249,32,196,191,98,98,41,
219,92,120,221,241,178,233,36,21,52,245,49,91,238,105,226,106,105,131,198,227,
73,117,221,187,47,248,205,190,103,81,195,248,192,175,105,31,153,210,120,169,
249,18,10,136,100,7,177,134,63,193,254,175,63,94,190,192,59,99,114,224,55,158,
219,192,110,253,171,150,162,207,109,141,211,134,198,110,29,189,156,198,206,181,
56,252,198,19,51,71,14,67,23,147,161,168,79,76,212,149,212,85,9,36,108,62,170,
195,221,227,145,37,141,36,67,84,97,81,211,132,16,72,60,122,124,247,126,181,215,
199,27,249,247,245,229,119,82,255,0,56,223,155,152,41,178,153,154,248,242,125,
161,14,246,196,84,229,42,170,171,235,99,199,111,124,22,23,116,83,81,69,81,81,35,
191,216,227,228,201,201,5,60,96,232,72,81,81,64,2,222,211,109,116,72,158,49,248,
37,113,143,147,154,127,34,62,222,155,186,5,191,48,63,193,213,80,238,10,182,172,
142,69,157,221,102,88,117,16,194,225,188,154,75,32,69,81,226,58,137,107,253,15,
231,159,102,142,218,129,4,30,145,66,52,211,72,243,235,121,15,231,19,185,167,200,
127,194,95,191,149,244,123,115,112,210,230,246,238,83,33,241,238,131,112,212,96,
30,47,225,53,149,24,78,186,222,1,49,245,171,67,166,157,103,197,102,41,94,41,17,
192,97,83,11,92,107,7,216,110,211,251,107,5,62,79,62,61,14,163,252,192,39,246,
244,105,47,246,114,17,232,191,224,235,74,179,82,35,219,245,9,20,168,139,246,113,
3,31,1,139,0,165,12,203,118,44,52,150,23,224,129,199,177,59,186,132,227,209,
44,98,179,10,143,62,190,159,223,240,148,47,142,217,94,143,254,83,187,51,121,
230,230,141,235,190,70,246,86,249,238,74,58,120,100,142,88,233,54,244,181,52,
219,55,111,169,41,250,39,169,164,218,166,119,67,202,25,0,252,123,37,183,239,158,
242,111,34,225,71,216,130,135,254,52,91,242,167,71,39,10,131,229,95,219,254,199,
65,7,252,44,51,31,71,144,254,88,27,16,84,85,209,193,61,63,202,110,181,150,154,
9,101,165,21,213,34,77,187,189,169,103,108,125,36,167,238,170,205,58,84,6,144,
67,250,87,245,16,15,189,76,64,190,176,30,125,255,0,179,79,248,58,209,254,206,
67,246,117,243,84,206,109,12,197,6,58,151,37,20,105,20,81,59,75,73,91,79,80,
194,105,170,33,48,207,5,87,135,210,104,234,98,126,117,2,72,32,15,199,179,159,15,
90,16,69,69,58,44,89,105,39,207,253,94,125,125,121,63,145,119,207,156,71,243,
11,254,93,29,37,218,85,25,58,90,158,210,216,24,106,62,157,238,236,100,78,5,86,
59,177,54,38,58,143,29,54,66,162,157,164,121,163,131,117,225,126,211,41,11,55,
14,42,152,14,84,128,79,105,88,213,237,31,227,132,208,124,211,240,31,217,130,
127,137,91,163,70,238,163,143,63,240,249,245,162,143,252,43,7,27,154,219,95,206,
87,112,231,154,134,90,10,77,205,208,93,41,144,197,87,201,50,73,14,78,28,118,43,
37,133,171,168,138,32,21,162,20,245,148,15,3,41,36,147,30,171,216,143,111,237,
204,86,226,253,65,161,241,71,243,141,58,98,233,67,71,29,70,41,254,83,214,186,
219,203,94,83,31,29,92,250,26,89,212,201,34,165,149,77,162,8,174,17,110,5,212,
114,9,38,255,0,95,102,211,119,47,69,176,82,57,24,14,29,125,94,63,225,52,56,201,
177,127,201,131,225,250,77,85,45,89,173,197,246,22,70,51,41,148,152,33,172,236,
189,216,241,82,167,151,145,28,10,44,52,250,63,167,178,43,76,155,195,255,0,14,
111,229,65,254,78,142,79,4,255,0,74,58,215,59,254,22,91,189,186,59,113,119,183,
195,126,173,196,209,253,239,200,125,169,180,55,118,232,222,25,186,92,147,188,91,
123,172,55,22,74,150,151,107,109,234,236,74,185,129,114,153,204,246,62,174,186,
41,89,68,171,79,76,162,250,100,95,110,90,160,109,206,103,143,128,69,13,233,170,
164,175,230,20,212,252,153,122,98,233,180,219,129,231,83,78,181,58,160,195,237,
193,140,197,34,87,213,84,85,199,48,69,199,213,42,71,12,179,176,152,154,169,171,
73,103,241,196,250,77,130,55,212,129,107,123,22,170,71,225,39,113,251,15,65,
103,121,60,71,198,8,25,235,118,31,248,70,102,232,168,131,173,63,152,30,203,151,
64,166,197,118,167,91,110,216,93,32,12,3,228,246,166,127,29,51,9,99,62,176,203,
136,67,227,252,91,143,169,246,18,186,62,30,231,114,107,131,0,63,239,44,223,231,
232,83,104,117,91,71,79,95,242,14,180,209,238,156,206,115,181,190,92,124,147,
236,77,219,147,200,238,12,206,237,249,21,218,249,156,142,94,181,37,74,188,138,
29,225,158,134,151,32,233,40,253,132,72,98,142,53,141,236,35,85,3,241,236,211,
99,137,126,134,206,163,37,20,159,180,138,147,249,154,244,85,186,76,86,73,7,218,
63,159,14,160,238,237,167,157,161,154,143,113,237,92,134,83,15,184,246,229,85,
14,224,194,103,40,100,168,165,201,97,114,184,90,168,114,56,204,142,62,178,32,
178,81,86,99,107,32,73,33,100,32,171,128,195,144,61,155,222,90,44,208,200,142,
181,66,50,15,152,60,122,45,179,187,240,164,83,92,245,244,191,254,73,95,206,175,
163,63,152,191,79,108,142,165,221,219,197,118,191,205,78,189,217,56,172,87,104,
245,198,239,158,150,135,53,216,53,187,119,27,77,69,151,236,189,133,50,152,233,
183,62,31,51,36,95,119,87,12,33,106,232,37,145,132,176,172,97,100,96,148,101,
237,74,218,92,147,172,97,88,240,97,229,159,226,167,16,114,104,72,168,175,66,180,
117,153,124,68,56,60,71,167,251,29,93,127,108,245,23,88,119,191,94,238,142,167,
238,93,135,181,251,51,173,183,166,54,92,78,232,217,123,199,17,73,155,192,102,
104,101,177,241,213,81,85,198,232,37,134,69,18,67,50,105,154,9,85,100,141,149,
213,88,61,36,81,204,186,100,90,138,215,208,131,234,8,200,35,200,130,8,234,192,
145,195,173,3,62,127,255,0,194,69,190,77,96,59,47,176,59,39,249,124,111,126,176,
221,93,93,184,247,70,71,51,181,186,11,118,102,115,59,55,116,108,12,21,68,223,
113,75,182,241,123,179,113,214,102,112,187,174,150,128,18,145,201,85,87,69,49,
80,170,85,190,190,218,138,226,246,213,2,75,25,149,65,61,202,69,105,92,85,78,
159,42,3,66,106,115,78,154,146,8,164,53,173,63,213,235,209,29,233,31,248,74,231,
243,101,238,189,223,141,195,118,222,218,235,15,142,219,22,60,197,45,22,229,222,
59,175,125,225,55,69,116,24,232,89,141,86,71,110,237,77,153,83,150,173,206,74,
33,184,133,37,158,142,39,118,1,164,69,187,43,175,127,52,162,144,218,185,111,86,
162,129,246,212,234,167,216,167,170,199,106,177,156,184,167,237,234,242,182,191,
252,34,207,227,22,31,61,183,183,6,87,230,215,200,106,170,172,85,102,55,39,90,
112,59,67,97,109,218,201,178,52,50,197,82,103,195,229,47,146,168,194,186,213,68,
30,9,52,207,44,36,3,169,136,191,182,29,47,100,86,70,154,45,36,80,246,49,193,
226,50,244,63,234,199,79,129,26,210,129,170,62,127,236,117,185,158,223,197,166,
216,219,88,76,44,217,90,236,164,123,123,7,141,197,203,156,206,84,199,54,79,34,
152,154,8,105,31,43,152,171,9,12,82,215,85,173,57,154,162,77,40,173,35,51,88,15,
111,70,130,8,99,66,245,8,160,84,252,135,19,254,94,188,78,162,77,56,245,242,220,
255,0,133,40,124,146,248,105,242,47,249,136,229,51,31,18,241,123,126,174,191,
175,246,210,236,94,253,238,29,145,75,76,219,119,181,187,98,147,45,80,38,154,142,
106,56,254,207,63,85,179,177,168,184,218,188,186,6,21,115,41,11,36,139,2,200,
117,182,130,94,230,104,193,91,87,35,72,245,57,212,224,121,6,168,251,105,171,241,
84,167,187,167,98,154,23,28,127,205,254,175,179,170,63,165,199,214,101,54,117,
102,37,35,134,74,184,103,142,160,147,79,246,230,88,24,130,177,49,169,118,22,151,
88,208,214,1,205,248,246,115,74,161,30,125,22,146,18,101,122,224,244,132,235,
254,223,249,7,241,83,117,199,217,125,7,219,253,131,211,91,191,238,169,97,124,
231,92,110,220,190,214,171,201,54,50,174,12,141,61,22,86,12,77,85,52,89,172,93,
61,90,35,136,170,99,158,149,223,245,47,212,18,251,171,72,102,85,241,99,13,78,7,
204,125,135,136,251,71,70,48,76,107,165,91,175,179,135,242,239,249,16,223,44,
190,13,124,84,249,21,83,150,139,59,151,237,94,144,216,91,139,116,101,161,167,
134,142,58,221,232,152,74,124,102,247,148,81,211,218,10,67,253,237,160,173,6,36,
1,16,139,0,0,3,218,43,55,105,45,144,72,107,34,146,166,190,101,73,83,95,182,
149,252,250,84,226,140,105,195,143,237,235,72,31,248,85,71,242,90,218,29,17,89,
47,243,43,248,195,182,33,219,187,15,121,238,188,110,19,228,159,87,237,140,19,
67,128,219,91,187,112,73,90,244,125,195,140,142,137,141,30,35,17,186,114,130,
58,60,181,55,134,58,120,242,83,69,58,17,247,18,40,244,12,108,174,18,15,248,138,
245,211,253,22,227,167,236,57,43,233,66,163,26,64,164,169,226,33,35,227,31,234,
175,250,190,222,180,175,79,222,193,214,153,64,142,45,77,49,168,129,13,76,181,12,
242,171,71,78,99,80,34,161,166,69,3,83,106,33,79,226,254,207,128,13,17,53,255,0,
47,252,87,69,103,19,38,156,159,78,20,249,252,207,167,91,142,255,0,194,61,190,
126,109,254,144,237,159,146,255,0,18,251,151,181,246,190,198,234,157,245,182,
112,253,183,215,163,125,102,232,118,222,38,155,178,177,57,108,110,214,207,81,
226,178,25,186,154,90,104,42,55,30,7,43,74,90,16,203,231,122,21,96,9,7,216,126,
245,227,179,188,73,221,180,192,234,85,143,149,70,84,159,76,106,21,251,43,192,
116,107,13,94,32,63,16,255,0,81,235,123,15,230,27,241,238,183,229,119,194,31,
147,159,31,240,251,151,116,109,76,207,102,116,254,239,195,224,51,155,55,43,81,
136,205,199,158,135,25,46,83,5,70,149,148,135,203,38,55,47,149,161,134,150,182,
17,113,83,71,52,177,30,31,222,175,215,93,164,142,185,41,71,3,136,109,39,85,15,
168,52,167,87,143,14,62,120,253,189,124,68,223,27,149,219,57,252,134,223,204,82,
75,65,152,219,121,138,220,46,98,134,112,99,154,139,37,139,170,168,163,200,82,
202,143,165,227,154,158,166,153,209,193,31,169,121,30,204,237,228,87,88,221,77,
80,128,126,208,122,77,42,1,172,30,61,92,215,242,13,248,115,47,206,207,230,157,
241,227,102,229,168,30,171,175,122,187,58,123,231,179,11,134,146,33,183,58,194,
166,151,51,141,198,84,74,170,35,140,231,55,71,216,81,168,176,184,145,143,54,246,
139,114,111,17,18,216,124,83,54,159,246,180,171,255,0,198,65,31,105,29,94,221,
52,213,189,51,254,110,190,195,192,91,129,192,28,1,253,61,191,213,250,213,207,
96,127,194,95,62,39,110,143,155,125,253,243,111,229,78,95,43,217,153,157,253,
242,107,43,221,125,87,212,59,90,118,219,61,113,182,112,75,155,135,112,80,208,
118,5,51,193,83,95,188,242,25,156,207,146,90,234,116,150,154,143,196,21,125,122,
228,30,202,96,181,186,120,12,19,73,225,192,25,133,23,37,148,177,57,36,118,130,
13,40,50,6,107,232,235,50,87,82,138,159,240,30,182,136,138,40,160,138,56,32,
142,56,97,134,52,138,24,98,69,142,40,162,141,66,71,28,113,160,10,145,162,0,0,0,
0,5,189,154,128,0,0,10,1,211,93,100,247,190,189,210,47,177,250,251,105,118,
207,95,239,110,175,223,184,138,108,254,202,236,61,171,158,217,123,175,11,87,26,
73,79,147,219,251,147,25,83,136,202,210,58,200,174,160,205,71,86,225,90,215,70,
179,14,64,246,220,209,44,241,73,19,252,44,41,246,124,199,204,113,31,62,182,9,4,
17,215,197,111,249,142,252,58,139,249,125,252,234,249,9,241,57,55,77,62,246,
195,117,86,242,240,109,157,192,136,240,213,100,54,174,123,29,69,185,54,204,121,
88,37,22,139,57,65,135,203,195,79,88,20,152,154,166,39,100,58,25,125,234,202,
102,150,33,226,127,104,172,85,169,192,149,52,36,124,141,43,79,46,29,86,64,1,199,
14,136,237,69,65,169,157,164,113,196,136,66,34,155,128,2,88,18,69,245,17,199,
181,152,56,234,188,41,215,15,179,212,41,252,158,53,105,1,208,5,219,200,73,22,60,
27,90,66,109,127,167,30,247,233,158,181,94,61,103,166,10,139,60,21,5,148,201,
32,138,53,38,246,82,68,141,96,46,150,31,146,127,30,247,80,69,107,215,169,214,
74,154,93,70,112,36,46,138,186,190,154,155,212,1,85,214,61,90,65,3,150,250,123,
213,62,125,123,252,61,53,50,105,169,41,33,34,85,40,45,98,193,154,196,92,146,13,
128,189,199,212,123,247,159,229,215,143,14,162,74,46,230,223,80,46,110,2,223,
235,248,226,196,127,188,251,223,85,234,76,47,40,140,133,111,77,133,192,55,227,
143,246,22,3,253,136,247,238,188,78,70,58,200,29,85,174,192,216,105,183,231,232,
120,0,27,31,246,62,232,40,13,67,87,253,89,235,117,192,234,65,241,145,35,40,32,
223,85,173,107,6,185,185,55,230,222,239,138,28,117,172,215,250,52,254,125,69,
142,59,191,0,253,9,250,220,88,127,79,207,230,223,239,62,233,67,128,120,255,0,
171,252,221,57,130,65,234,120,30,184,236,0,58,6,190,47,99,118,213,192,255,0,31,
167,227,222,218,148,26,135,159,14,168,72,53,206,107,212,169,25,217,92,184,36,
170,48,4,30,0,186,88,53,199,4,3,244,231,159,118,3,7,20,3,253,84,255,0,138,233,
186,229,104,120,255,0,171,253,71,166,122,144,138,242,144,77,149,216,0,110,47,
109,71,144,121,83,111,246,30,236,64,21,36,227,173,165,104,184,25,29,52,49,181,
219,243,200,81,111,237,18,109,245,231,143,109,215,1,125,71,242,243,233,209,214,
75,13,17,70,15,32,22,114,63,196,253,79,31,94,63,222,189,233,114,73,34,159,234,
255,0,87,243,234,196,211,169,116,201,170,234,71,44,24,142,56,83,206,146,44,62,
159,212,255,0,197,61,234,129,143,167,90,242,173,122,145,44,101,81,148,143,87,
140,55,63,64,3,90,224,254,120,231,221,233,78,3,175,18,41,80,58,198,177,182,180,
93,36,23,84,35,235,248,184,22,226,228,144,191,236,125,232,112,245,35,173,16,56,
158,167,50,17,28,209,166,166,49,196,229,229,54,97,173,157,120,22,36,0,47,111,
234,15,183,60,136,244,234,130,186,170,120,19,212,127,27,125,181,202,11,107,12,
18,254,162,10,187,22,50,125,117,0,191,79,117,244,235,125,127,255,215,208,76,
234,254,213,238,56,228,242,7,60,114,121,246,162,180,29,87,211,172,241,204,84,2,
64,226,224,145,193,101,224,149,54,34,227,223,129,4,99,173,30,61,56,210,213,137,
38,137,156,254,150,0,18,129,132,96,254,18,50,116,155,222,223,235,251,245,51,
142,188,78,56,245,138,174,154,17,55,46,29,28,220,207,24,26,31,150,179,232,80,10,
41,63,81,245,83,237,182,4,26,142,29,108,28,124,250,139,26,50,57,208,224,0,196,
221,94,255,0,75,157,74,91,79,22,255,0,30,125,214,148,57,192,235,71,133,15,78,54,
120,205,162,99,102,0,19,167,80,32,222,196,95,250,220,251,246,161,66,41,142,189,
80,70,122,238,88,134,144,65,250,23,191,224,130,44,126,159,67,238,160,117,190,
160,77,19,155,15,212,164,3,254,36,220,139,115,244,36,251,245,61,122,223,80,36,
167,145,63,118,50,125,55,46,62,182,177,185,191,28,123,221,15,26,99,173,18,43,74,
117,159,202,178,36,103,79,0,38,165,189,205,214,227,253,112,24,31,118,10,13,51,
158,189,74,30,189,99,44,168,2,241,33,2,192,18,195,235,101,6,247,184,3,221,41,
215,133,105,215,38,67,18,146,167,77,236,195,241,249,0,143,245,205,189,251,173,
87,187,167,138,105,214,98,183,253,62,139,216,92,150,26,117,30,127,35,253,235,
223,186,241,7,143,81,106,163,179,57,26,180,41,96,46,121,10,204,116,143,167,208,
48,231,223,190,125,120,122,83,61,97,72,152,148,109,5,213,158,215,67,234,252,11,
11,139,147,207,189,130,65,173,122,183,78,37,98,251,102,101,37,207,10,223,80,35,
213,33,210,72,60,250,128,250,125,7,189,234,52,32,245,80,77,64,61,67,144,18,170,
220,216,92,122,173,203,89,69,151,235,244,83,249,247,234,147,74,245,110,184,73,
11,8,163,55,58,74,177,7,234,13,141,128,54,250,115,249,247,234,246,240,235,213,
235,232,97,255,0,8,136,169,197,142,154,249,235,66,43,169,142,104,118,143,79,213,
54,59,84,34,179,248,89,218,155,170,20,174,241,234,243,181,49,170,82,151,182,
133,126,47,115,237,0,167,239,25,43,199,193,90,127,189,53,127,102,63,111,78,127,
161,143,183,252,131,171,113,255,0,133,33,127,55,42,223,229,155,241,34,13,151,
212,181,207,7,202,79,147,20,187,131,103,245,94,70,29,4,245,230,220,164,130,158,
155,120,246,115,151,12,6,75,15,6,74,58,124,74,233,55,200,76,178,159,76,12,14,
238,25,165,145,108,227,36,84,85,200,226,22,180,160,249,177,168,175,144,12,70,
105,215,150,128,23,63,151,219,254,199,95,38,170,186,204,150,78,122,204,198,106,
178,183,41,149,203,87,84,100,50,25,60,149,68,213,149,213,213,149,115,203,83,83,
89,87,85,80,242,79,83,85,87,81,35,188,146,59,51,59,177,36,146,79,179,8,149,81,
2,170,208,14,20,224,0,233,179,83,154,245,17,191,215,228,126,0,250,112,57,254,
190,220,235,93,118,222,161,26,146,77,172,24,241,233,13,123,15,197,255,0,216,251,
217,199,159,94,227,214,90,150,117,149,66,220,5,137,24,45,191,196,250,136,181,
136,54,231,253,135,187,191,17,246,14,171,74,87,215,174,153,139,2,90,205,123,177,
117,26,15,42,1,45,164,0,57,250,11,123,108,128,73,205,9,235,121,63,103,88,232,
141,164,22,112,183,12,44,226,202,194,214,0,159,162,91,250,219,219,53,161,0,26,
231,173,159,179,165,6,54,89,169,171,41,171,62,210,142,187,248,110,70,154,176,80,
100,96,21,152,202,199,166,146,42,145,71,145,165,44,130,162,138,175,197,166,69,4,
9,35,37,73,23,247,230,62,34,178,130,65,34,149,30,95,236,245,70,58,74,182,58,
250,224,255,0,194,122,255,0,153,111,67,252,248,248,85,182,246,95,93,236,253,185,
210,253,151,241,179,25,136,235,190,195,232,124,22,94,178,187,23,182,113,244,244,
254,60,6,234,216,208,229,234,170,179,43,215,123,139,197,40,164,134,73,38,254,27,
60,111,70,92,170,68,88,182,197,126,156,53,155,147,226,41,44,9,36,235,4,212,182,
124,234,104,195,200,208,224,48,29,40,115,175,245,0,199,248,63,213,229,213,248,
251,48,234,157,124,150,127,225,81,248,76,158,3,249,210,247,245,70,90,138,104,
105,115,251,67,166,243,184,198,169,138,90,120,107,177,147,108,156,69,36,117,52,
210,186,170,212,68,149,116,82,166,164,36,23,70,91,220,31,105,118,227,165,239,1,
25,19,183,243,10,71,242,61,86,224,29,40,71,240,255,0,159,170,10,173,137,42,22,
71,130,89,42,37,18,18,144,58,151,15,169,202,248,162,60,202,186,173,114,173,170,
223,91,254,61,153,177,213,82,185,233,10,29,37,65,160,29,89,86,193,254,96,221,
149,15,242,216,237,207,229,189,190,241,205,187,250,151,47,187,112,93,187,211,89,
10,249,164,25,126,171,236,61,183,184,160,201,102,49,216,225,36,108,95,7,184,
113,149,181,132,194,165,76,115,187,50,217,93,129,39,150,193,133,236,23,144,200,
64,215,86,95,34,116,149,175,219,67,67,234,0,233,80,185,82,143,19,241,166,15,
231,94,171,162,166,165,211,26,235,49,120,101,120,208,60,70,232,230,53,69,22,107,
168,89,3,149,82,45,107,91,217,137,53,53,242,233,149,80,167,29,125,103,191,225,
51,123,198,93,227,252,153,126,37,153,171,49,245,114,109,122,94,193,217,250,104,
42,96,168,106,72,176,125,133,185,5,61,37,122,194,238,105,178,9,77,80,140,241,
61,157,85,148,145,200,246,130,207,6,241,125,38,111,230,3,127,151,246,116,185,
184,39,250,94,168,127,254,22,181,180,179,200,62,0,239,244,201,206,118,208,203,
118,230,209,155,12,102,173,20,75,156,72,182,142,110,155,43,44,42,223,195,252,
255,0,101,228,137,24,129,54,144,192,29,55,247,100,3,247,158,71,197,14,62,90,88,
215,246,234,31,179,170,201,253,137,207,159,248,127,226,186,210,171,114,102,13,
70,206,166,160,145,100,103,146,182,127,13,75,78,171,227,142,26,88,95,236,41,
160,140,15,38,151,151,91,179,88,128,121,7,217,245,0,79,180,158,137,212,31,24,
154,98,131,254,47,173,168,127,225,26,251,151,229,5,23,203,175,145,27,79,99,10,
124,151,197,44,150,194,162,203,119,157,38,75,39,75,3,96,59,1,62,246,30,173,220,
91,127,22,243,37,101,94,94,186,74,106,218,10,166,137,26,49,69,41,50,88,199,25,
4,55,77,166,254,215,195,169,149,129,13,233,160,121,159,152,114,41,231,220,222,
167,163,120,115,27,87,128,255,0,15,252,87,65,71,252,44,3,33,214,153,95,230,135,
212,248,237,181,150,90,189,241,136,248,219,181,169,59,66,145,107,165,168,139,17,
91,38,229,220,185,13,171,74,244,242,49,130,134,162,125,183,84,147,178,37,181,
172,136,204,46,220,185,99,79,172,190,35,224,212,181,255,0,76,20,87,246,13,63,
157,126,125,82,231,17,45,56,208,255,0,135,173,110,50,123,123,13,38,223,165,253,
240,38,146,158,241,176,147,134,151,95,168,72,15,166,36,104,248,81,249,255,0,121,
246,118,234,190,24,245,167,68,209,187,120,164,183,10,245,245,25,255,0,132,197,
118,126,15,177,191,147,215,199,124,94,39,198,149,157,85,154,236,158,174,207,211,
174,157,81,101,112,91,215,43,148,142,71,10,238,199,238,241,153,202,121,67,27,
106,212,108,45,236,130,215,178,75,216,143,196,179,19,249,48,12,63,195,79,203,
163,218,234,72,219,212,127,131,29,105,55,255,0,10,33,196,228,114,31,206,251,228,
168,172,207,46,225,141,113,253,74,99,102,169,251,177,183,113,191,232,235,10,241,
109,248,194,241,72,244,74,117,248,191,178,210,159,203,31,106,182,113,86,186,255,
0,154,237,159,92,255,0,144,99,242,167,72,183,38,162,40,175,225,234,175,95,2,
98,170,167,68,130,10,131,81,21,84,171,33,130,65,83,6,149,112,35,93,44,35,17,
204,8,32,144,91,131,244,231,216,165,84,233,2,158,93,6,139,124,206,41,213,241,
255,0,194,121,191,152,183,92,252,20,220,223,49,186,63,177,113,251,133,183,31,
200,172,28,249,190,191,206,98,169,163,56,236,62,115,175,58,239,177,114,245,53,
57,226,85,62,218,134,173,141,60,81,58,74,88,75,32,244,105,5,148,23,190,165,197,
188,146,220,71,22,165,120,202,28,208,130,79,105,3,207,39,134,58,20,109,243,68,
241,34,22,200,207,242,234,138,122,222,146,170,175,30,251,163,53,36,117,53,91,
147,59,87,151,174,134,105,30,41,69,86,71,35,89,91,81,53,68,252,200,85,165,157,
184,36,107,99,127,175,212,89,183,194,34,183,142,47,69,3,246,99,160,230,229,41,
105,88,174,115,246,244,99,218,179,27,85,75,20,25,24,233,225,53,162,122,69,138,
157,154,168,84,180,148,165,19,232,0,177,43,115,126,117,91,233,236,220,172,110,
132,54,31,252,61,19,7,104,222,163,43,246,116,150,248,105,190,115,95,30,63,152,
215,195,158,230,217,147,212,211,215,96,126,73,117,142,34,178,74,100,213,247,88,
109,215,186,168,182,190,118,128,68,9,47,29,94,27,53,81,11,41,228,7,63,210,254,
194,91,252,52,180,184,144,14,228,26,129,249,175,112,254,99,161,110,211,62,166,
141,73,227,229,246,227,175,174,127,115,252,140,232,47,142,123,125,183,87,125,
247,63,88,244,230,222,17,180,169,148,236,141,237,183,182,133,61,66,43,104,111,
178,25,186,250,57,107,220,55,26,97,89,27,252,61,151,201,113,12,68,44,146,0,231,
128,226,199,236,81,82,127,33,209,208,82,115,76,117,91,187,195,249,255,0,255,0,
39,109,149,134,172,205,87,252,241,233,172,196,84,109,36,103,31,179,228,220,187,
203,53,83,36,98,229,40,176,251,107,111,228,235,234,131,253,21,213,12,108,79,13,
238,159,82,167,225,134,82,127,230,155,143,230,192,15,218,122,245,7,155,10,125,
163,170,196,239,159,248,87,255,0,242,228,216,184,44,169,232,77,135,223,127,34,
55,117,59,180,24,218,37,217,241,117,102,207,169,151,144,38,172,220,187,202,164,
230,233,233,147,245,90,44,52,206,203,192,0,145,239,122,174,223,17,90,149,62,174,
64,31,177,75,19,246,99,237,234,165,227,94,47,95,179,253,154,117,175,55,120,255,
0,194,187,127,154,30,238,221,21,153,94,163,217,223,31,58,55,101,74,238,184,
157,181,46,203,173,236,140,220,20,192,217,36,202,110,77,199,148,167,134,174,181,
148,2,198,26,26,120,181,49,178,1,111,118,250,59,150,21,150,241,129,254,136,80,
63,227,65,143,243,234,190,58,214,129,7,68,39,190,191,225,75,159,205,175,191,
186,219,124,117,22,249,239,45,157,138,217,125,143,182,235,182,142,233,162,216,
221,91,180,182,174,90,124,22,82,15,182,201,199,65,184,40,233,31,57,138,154,174,
154,70,70,150,158,162,57,52,146,1,0,159,109,181,138,184,11,61,196,143,29,65,161,
211,67,67,81,90,40,168,175,151,159,86,241,79,225,80,15,84,123,137,202,197,141,
198,201,246,179,105,243,85,131,245,107,205,1,136,164,137,199,164,19,253,162,7,
248,95,217,162,16,163,29,37,116,46,217,29,10,81,111,42,170,116,167,170,162,167,
130,84,169,168,161,74,196,118,118,101,166,167,22,164,167,149,203,189,49,86,64,
90,50,227,137,20,255,0,91,123,126,164,10,129,138,142,152,49,41,61,199,34,191,
234,245,235,46,238,200,182,238,192,71,145,68,140,127,10,138,183,25,53,61,38,58,
146,150,101,168,169,169,199,201,20,136,80,233,120,226,166,137,195,19,203,19,233,
3,222,156,234,82,71,84,140,120,78,5,112,198,188,127,151,95,65,159,248,70,247,
203,204,175,103,252,65,238,143,137,91,150,179,39,144,171,248,215,216,75,158,216,
243,205,140,174,52,52,93,125,217,34,106,247,195,28,217,67,143,243,209,110,234,
74,233,34,164,212,38,72,167,45,98,128,16,68,159,163,184,79,7,224,145,117,143,
145,20,86,251,43,218,71,145,53,249,244,110,59,162,86,243,24,255,0,40,235,111,
141,251,176,182,103,104,236,189,209,215,61,139,182,48,187,211,98,111,108,30,71,
109,238,205,169,184,168,32,201,225,51,248,44,173,59,210,100,49,185,42,26,133,
120,167,167,168,130,66,13,197,212,217,148,134,0,133,82,70,146,163,71,34,213,15,
250,191,34,56,130,50,14,70,122,208,36,26,142,61,124,207,191,155,103,252,37,215,
229,103,198,30,200,236,62,204,248,31,179,243,189,253,241,59,35,139,207,111,88,
182,165,22,103,31,55,104,117,61,13,36,85,185,108,222,209,175,194,213,207,73,91,
189,49,24,186,40,52,227,107,104,69,69,109,76,54,142,88,12,232,94,86,163,188,150,
205,76,87,90,140,126,78,5,65,31,211,167,194,71,153,160,83,196,83,225,13,188,9,
35,7,64,3,127,58,255,0,151,229,231,214,164,53,79,80,245,90,191,126,151,35,28,
204,149,43,170,88,39,130,122,121,87,199,25,13,162,72,100,167,120,190,134,197,93,
127,168,246,98,196,74,1,173,107,211,72,12,88,224,7,95,86,255,0,248,77,79,243,
123,203,127,50,95,140,185,174,163,237,232,113,244,127,34,126,43,97,118,70,211,
220,149,244,179,72,95,178,118,35,98,191,131,109,206,197,154,25,229,146,84,204,
75,83,137,122,92,168,23,67,85,166,80,127,126,192,166,0,214,242,155,39,53,140,
37,83,31,132,96,169,245,43,85,207,152,35,206,189,42,168,101,14,56,215,63,234,
249,245,243,195,254,116,91,95,102,237,111,230,203,243,215,109,245,230,41,112,
155,98,139,228,86,245,150,147,25,27,67,246,244,181,245,239,79,145,206,188,2,159,
84,73,79,46,114,178,166,68,65,202,43,233,183,22,246,238,215,254,226,162,249,6,
112,62,64,59,0,63,32,7,85,152,128,196,158,56,255,0,7,87,229,255,0,8,187,236,156,
70,217,249,211,242,107,171,171,49,169,54,87,177,190,60,210,229,48,185,147,78,
173,85,77,253,198,222,120,218,188,157,25,168,80,124,20,117,244,249,149,114,188,
106,146,20,185,54,30,233,115,219,127,100,254,76,29,127,50,3,87,246,33,29,122,35,
88,223,214,160,255,0,147,252,189,125,39,77,109,18,214,38,61,170,233,86,190,74,
119,170,142,132,212,68,43,36,165,141,214,39,169,74,98,254,102,167,73,24,41,112,
186,67,16,47,127,106,11,160,112,133,198,186,86,149,205,61,105,214,232,105,90,99,
162,195,218,63,56,254,27,116,150,248,195,245,167,110,252,162,232,126,184,236,28,
250,214,62,47,102,239,14,208,218,24,45,195,58,99,233,102,172,170,121,177,149,
217,88,106,104,81,41,233,220,134,157,98,14,87,74,146,220,123,78,247,214,168,74,
153,65,35,141,42,64,251,72,168,95,204,142,182,17,143,151,90,50,255,0,51,143,248,
88,127,104,110,60,142,237,234,15,229,191,215,176,245,158,10,131,37,147,192,207,
242,47,178,233,177,59,147,122,102,34,162,170,158,141,242,125,127,178,96,147,35,
181,118,245,21,106,166,186,122,188,132,185,57,218,61,46,177,66,199,211,164,91,
155,165,87,114,98,132,138,208,124,100,124,219,240,252,194,228,30,15,214,234,171,
229,83,252,191,213,254,170,116,126,63,146,39,252,42,107,100,124,144,175,217,223,
21,255,0,152,45,78,215,234,30,218,131,110,97,176,59,59,228,94,79,112,69,142,
216,189,191,185,40,150,159,31,37,46,250,92,140,52,148,91,23,122,238,7,117,150,
41,68,199,25,87,56,117,6,7,104,209,180,12,182,116,89,152,189,183,147,100,178,
250,107,227,168,121,107,197,49,168,113,110,189,135,200,195,122,127,155,252,221,
110,141,20,177,79,20,115,65,36,115,67,52,105,44,50,196,235,36,82,197,34,135,142,
72,228,66,81,227,116,32,130,9,4,27,143,107,1,12,3,41,168,60,58,167,95,32,143,
248,81,158,193,238,13,187,252,224,190,86,102,187,167,175,215,174,234,59,3,45,
131,221,253,124,244,25,39,205,97,183,111,93,67,183,49,219,119,110,110,236,94,85,
163,135,204,114,223,192,159,238,160,40,143,69,88,178,192,87,246,195,50,109,183,
17,204,142,41,48,145,139,15,66,196,176,167,168,32,130,15,159,200,224,90,94,32,
143,134,131,170,63,146,149,161,93,106,195,72,88,153,117,30,89,89,136,60,88,233,
7,243,236,198,159,46,153,233,202,146,157,166,104,33,41,103,14,26,71,91,93,98,
23,36,130,250,23,72,4,92,2,9,250,143,123,3,128,61,104,144,50,122,195,95,75,28,
114,184,134,84,34,86,103,243,147,116,136,70,192,50,217,185,69,55,186,243,201,
252,123,240,53,168,167,94,173,56,30,187,242,41,136,178,131,169,221,99,148,133,
210,163,72,3,76,183,98,84,51,115,127,241,247,110,20,207,94,227,211,117,104,83,
60,243,199,233,241,0,116,220,130,45,166,246,245,27,40,60,139,123,247,159,90,62,
94,189,51,75,41,110,109,114,192,242,127,44,121,99,245,231,212,125,235,252,29,
111,174,227,114,15,212,133,42,46,121,22,34,254,155,114,126,190,238,164,102,163,
203,173,117,61,16,50,254,171,122,110,120,191,31,225,207,62,219,197,114,51,94,
183,212,136,76,102,241,177,245,25,2,254,116,242,70,155,145,253,125,218,131,21,
234,181,161,207,83,4,1,28,31,73,23,32,40,91,163,88,91,131,253,174,79,189,148,
210,41,94,188,175,170,191,46,178,201,17,167,23,250,51,32,54,38,229,65,50,105,31,
215,147,244,254,190,219,145,112,9,28,58,210,181,106,41,145,215,25,100,82,160,49,
58,244,242,45,193,179,41,22,210,45,101,81,207,245,35,221,193,213,81,196,255,0,
171,253,71,170,154,128,125,43,249,244,205,91,32,188,167,250,72,64,63,240,80,79,
62,155,49,177,247,166,58,65,174,13,122,114,58,144,158,148,29,53,150,191,168,
158,0,178,143,235,254,195,253,227,219,96,26,124,255,0,213,143,203,137,249,244,
232,0,14,29,103,85,211,26,223,130,234,111,254,0,155,127,175,244,191,248,251,218,
145,147,248,71,15,242,158,180,217,160,28,122,154,173,103,26,61,33,64,80,69,193,
184,185,36,88,139,92,15,167,231,223,137,238,0,112,235,212,242,235,43,59,57,147,
87,32,68,203,112,47,165,65,4,234,211,107,220,255,0,182,191,189,147,164,231,173,
121,17,243,235,20,146,52,42,236,52,107,40,139,102,14,218,236,201,96,186,90,234,
231,235,112,126,158,244,172,13,113,254,175,229,215,171,94,189,22,69,76,208,70,
93,132,102,57,150,165,26,202,162,73,89,156,42,48,93,106,154,173,114,218,185,
231,221,139,154,246,241,207,94,35,21,60,58,114,116,101,167,140,235,38,55,96,192,
31,16,148,1,28,242,24,214,109,94,54,1,86,196,223,128,71,191,18,40,173,249,255,
0,46,155,4,18,71,95,255,208,208,109,227,7,159,247,175,168,255,0,138,143,106,
43,146,58,215,88,180,21,78,121,30,174,109,113,248,255,0,88,139,216,251,240,20,
224,58,169,25,235,140,76,209,200,164,125,71,60,143,234,63,161,247,191,48,71,30,
181,242,60,58,114,165,156,94,204,1,64,61,81,241,234,91,146,69,143,228,159,123,6,
184,61,120,131,76,117,229,99,28,135,198,19,198,90,196,72,154,180,221,127,23,4,0,
126,135,221,74,241,161,235,68,227,35,61,99,169,70,12,10,29,30,160,163,198,111,
19,16,5,180,16,109,113,254,219,219,4,122,14,29,92,112,235,161,52,194,54,12,117,
13,68,122,236,196,30,63,63,131,97,239,221,111,174,205,70,166,179,33,91,5,228,
31,169,224,223,253,143,189,158,0,86,163,175,121,30,179,44,202,194,81,115,234,
86,189,254,132,127,67,207,245,247,100,35,81,234,172,43,78,153,234,23,68,129,
163,58,85,172,74,139,216,91,234,188,159,246,35,241,239,68,21,58,135,14,172,56,
117,46,38,184,70,13,205,201,0,53,156,48,250,16,126,190,246,194,170,40,58,215,
167,89,154,154,73,32,146,85,210,203,31,212,107,93,97,129,5,142,159,199,31,81,
245,62,232,71,31,151,94,192,61,97,164,149,160,153,65,3,150,83,207,227,232,65,7,
241,112,125,235,173,156,142,148,254,8,106,105,11,198,117,234,36,176,185,186,242,
70,146,163,155,165,239,127,207,187,1,130,115,213,13,65,225,211,48,134,122,105,
5,141,194,59,94,224,233,36,38,171,31,232,214,255,0,121,247,176,190,188,58,189,
106,58,115,166,170,133,169,100,90,136,199,168,199,118,10,172,108,174,88,11,166,
150,0,177,231,235,199,191,83,180,249,245,82,42,106,58,199,87,79,19,34,75,77,34,
72,173,43,222,50,192,186,150,9,98,67,115,234,55,254,167,223,169,219,168,245,
177,90,228,117,210,66,90,40,212,94,254,39,45,195,88,149,98,108,46,109,197,239,
248,191,189,141,71,35,143,94,60,79,87,167,255,0,9,180,238,253,221,208,95,205,
179,162,243,56,108,146,81,236,205,199,182,123,87,17,219,80,86,228,37,163,198,
191,91,99,186,227,114,110,204,254,74,120,252,240,82,84,87,224,134,220,74,186,65,
55,167,205,24,91,141,68,251,44,220,221,45,226,134,236,140,199,34,159,200,246,
183,252,100,147,246,129,211,145,10,146,149,226,63,226,186,41,63,205,111,249,138,
118,159,243,61,249,125,216,31,34,55,214,74,178,29,147,75,144,173,218,157,25,177,
166,97,29,15,95,245,62,63,39,82,219,123,15,5,44,106,177,255,0,22,202,68,223,125,
147,156,134,146,122,233,222,236,85,80,42,171,72,12,104,210,75,155,153,50,223,
228,81,242,81,129,235,146,114,79,85,115,82,0,248,71,15,243,255,0,171,236,234,
188,106,98,133,232,169,53,4,70,86,101,44,93,67,233,10,199,213,24,191,42,71,244,
252,251,87,154,14,170,56,154,244,192,192,106,96,174,186,121,191,224,16,166,192,
15,245,87,28,216,123,183,219,214,250,198,204,53,30,2,149,100,178,159,173,128,
55,63,237,64,255,0,183,247,170,215,175,83,174,82,49,105,53,41,36,105,2,196,253,
7,39,243,245,176,54,247,226,192,249,212,158,189,212,184,98,70,86,18,115,251,
12,81,212,233,241,181,212,130,223,151,96,5,135,248,19,239,85,32,240,57,235,84,
249,245,25,5,164,137,111,165,75,47,12,163,245,63,5,172,111,126,15,227,219,102,
160,208,138,30,188,58,120,161,73,31,207,50,22,211,79,34,62,165,184,54,98,168,
165,128,191,165,109,249,54,26,189,209,153,70,107,221,215,138,234,160,242,234,
192,191,150,247,243,18,237,111,229,135,242,207,100,252,163,234,232,162,205,211,
99,76,187,107,178,250,229,235,100,160,196,118,87,91,102,204,47,157,219,57,9,34,
19,199,77,86,166,4,170,160,170,40,237,71,95,4,82,88,174,181,100,114,68,101,8,
81,180,204,166,170,78,126,208,126,76,48,71,231,130,7,87,67,166,160,240,60,127,
213,235,215,216,247,226,255,0,200,222,181,249,113,241,247,169,62,73,117,14,85,
114,253,121,220,59,43,13,188,246,252,197,227,106,170,36,201,211,43,87,97,50,137,
25,43,79,153,192,100,150,106,42,200,190,177,212,192,235,248,246,252,19,9,226,
89,52,209,178,8,244,97,130,63,35,231,231,199,175,48,210,105,215,207,91,254,22,
115,190,182,222,91,231,63,198,221,143,71,180,23,31,189,54,111,69,75,85,148,221,
178,70,173,14,235,219,219,171,116,214,85,226,49,206,170,183,145,246,229,118,58,
172,37,245,48,53,13,98,5,135,182,45,153,142,225,124,113,160,4,95,180,211,85,79,
251,213,63,46,181,48,6,37,173,124,207,90,136,45,61,77,36,232,98,165,127,44,242,
137,124,78,178,121,85,181,16,88,43,106,145,1,0,48,252,5,228,1,236,193,164,84,
207,151,72,21,76,130,154,134,58,18,182,244,180,178,79,12,117,113,153,103,87,169,
88,245,187,198,117,52,92,1,40,176,144,223,80,33,185,177,252,123,169,109,116,
244,233,163,25,76,169,161,199,74,220,127,89,47,99,239,93,133,215,184,60,206,3,
109,85,246,38,237,219,187,54,143,112,111,140,178,225,118,158,7,37,184,242,116,
248,154,124,134,224,202,152,165,254,15,133,167,169,170,15,45,67,35,8,162,4,243,
99,237,153,36,240,97,146,82,132,133,82,113,196,211,167,225,171,184,66,71,95,73,
239,229,255,0,215,27,91,254,19,77,252,167,55,78,233,249,219,221,213,27,210,58,
254,202,173,222,83,109,158,181,164,169,221,91,123,23,187,55,156,80,227,54,239,
95,245,89,150,135,23,85,147,171,220,244,248,132,172,173,173,174,122,106,49,80,
210,54,168,227,75,186,24,228,120,221,231,104,207,137,57,1,80,16,126,16,123,139,
87,77,72,201,32,208,40,0,84,241,49,32,80,10,225,120,158,181,20,254,114,31,207,
131,118,127,55,220,127,88,117,222,7,163,160,233,46,147,234,173,231,158,222,248,
202,60,174,231,167,221,187,191,120,229,170,232,70,23,17,144,207,72,152,140,118,
59,21,252,35,24,243,21,166,163,105,212,189,75,151,146,64,168,66,251,91,89,218,
224,92,220,50,234,85,32,42,214,130,164,18,73,63,17,192,28,7,217,158,146,92,74,
161,12,107,92,158,169,62,185,169,155,3,13,13,76,8,178,75,149,202,79,83,59,194,
30,35,84,209,210,248,218,37,81,228,66,208,234,228,30,7,248,123,58,165,16,10,
121,159,242,116,95,194,66,192,226,131,252,189,93,239,252,38,119,231,29,23,194,
175,230,91,182,182,38,243,220,20,24,30,155,249,103,131,143,167,55,77,102,81,106,
34,199,209,111,71,172,251,254,172,202,36,182,116,162,158,125,210,70,53,165,127,
219,241,228,14,166,31,95,100,91,138,152,100,130,240,12,33,163,127,164,106,84,
255,0,181,32,55,216,15,70,86,205,168,52,103,137,255,0,8,232,237,118,143,242,81,
236,239,159,95,207,195,249,143,245,199,110,118,206,87,59,181,246,110,198,220,
189,255,0,73,191,113,117,244,117,91,134,101,236,13,188,244,93,15,177,233,233,34,
134,174,130,151,251,179,184,210,44,125,117,1,17,178,227,241,114,1,166,71,82,11,
33,186,150,40,12,54,212,107,133,121,73,60,65,210,117,19,243,44,89,70,56,18,105,
240,211,165,44,138,196,151,248,72,31,207,252,217,235,83,168,78,99,15,159,202,
109,236,164,78,153,60,5,126,83,110,100,113,243,234,30,28,134,46,174,124,117,92,
111,77,48,46,173,29,76,6,225,151,90,145,111,175,177,52,51,44,241,199,34,158,214,
80,127,35,158,138,39,136,70,90,162,132,30,182,222,255,0,132,156,127,48,109,175,
241,191,189,123,147,225,199,112,110,248,176,59,47,228,46,103,101,101,186,110,58,
233,203,82,183,120,84,207,62,6,77,181,142,166,12,242,36,155,203,10,97,245,198,
130,21,158,137,68,172,12,138,125,148,95,48,179,186,142,228,171,24,157,116,181,5,
105,67,218,199,246,144,79,204,121,14,151,90,191,139,22,138,247,14,31,229,234,
174,191,157,78,206,202,236,207,231,73,243,178,13,203,93,13,92,249,206,210,197,
239,44,92,235,144,53,166,28,38,233,218,123,127,41,131,165,145,212,218,153,232,
40,234,210,35,1,23,135,69,135,245,246,187,101,32,164,170,220,86,89,63,227,236,
127,192,71,73,55,16,113,79,65,254,14,139,230,23,15,44,241,75,50,64,178,52,56,
177,28,79,2,163,122,228,100,242,202,131,234,36,177,185,183,54,62,197,145,229,
112,124,186,10,202,40,217,245,232,54,172,216,121,188,70,252,169,174,196,199,89,
79,144,113,91,142,90,184,146,162,55,90,92,173,1,164,168,100,120,30,57,35,153,
224,170,107,130,108,121,226,196,251,77,61,162,203,135,24,173,127,203,210,152,
110,217,16,80,249,116,187,219,219,66,92,102,204,163,142,86,86,154,159,51,53,50,
86,66,163,237,163,167,142,15,32,150,162,102,0,121,32,107,218,51,245,98,125,190,
154,82,49,92,154,244,158,77,82,74,199,200,142,144,59,147,115,38,38,187,17,66,
239,247,114,125,219,170,81,81,195,61,69,101,76,178,130,99,48,69,10,150,50,189,
238,170,139,112,191,143,108,75,118,145,0,88,246,142,158,138,197,223,86,158,39,
164,165,38,228,223,93,119,159,218,59,171,31,143,222,29,111,187,104,114,113,110,
189,137,184,178,56,108,134,35,35,75,91,71,49,150,135,114,237,202,140,173,21,63,
154,106,74,128,37,130,170,32,226,57,108,192,220,3,236,174,105,237,55,24,222,29,
74,233,192,128,65,252,141,58,52,138,222,107,70,241,50,13,49,138,116,221,191,
159,118,119,30,115,49,190,59,191,177,55,215,102,238,250,168,254,235,251,205,216,
91,167,57,187,107,207,223,79,36,178,129,91,157,172,174,168,140,153,73,33,16,
132,185,250,11,91,221,97,180,182,132,50,197,18,167,216,41,95,183,212,252,207,78,
189,212,204,69,92,156,244,9,100,241,120,129,146,163,219,187,91,23,83,184,50,153,
26,136,105,40,241,24,154,25,242,57,138,170,191,172,48,80,208,209,195,45,93,85,
67,254,22,53,109,95,208,139,123,212,178,69,8,37,216,5,28,73,199,248,122,122,37,
146,74,96,215,163,213,214,63,202,67,249,153,246,162,193,89,182,190,21,118,254,
15,111,101,41,105,243,195,122,246,78,10,159,169,182,46,51,15,35,90,60,166,111,
118,246,61,102,216,192,226,233,13,236,162,121,81,200,185,85,60,123,46,125,214,
205,21,152,73,81,242,4,143,219,74,126,117,167,74,197,172,164,138,143,219,208,
197,133,254,93,223,22,122,43,121,109,220,207,243,28,254,96,191,28,246,150,205,
219,153,10,124,134,240,232,159,138,27,142,187,228,239,125,110,122,122,90,133,
103,218,116,181,221,127,140,155,172,118,125,78,81,148,193,53,109,94,106,81,77,
25,102,84,102,177,246,142,77,198,226,229,116,90,90,73,159,196,64,160,249,140,
233,39,210,172,63,62,5,228,129,81,181,59,143,179,171,33,223,31,205,227,254,19,
199,176,48,249,140,31,199,191,228,149,137,236,76,174,46,133,161,217,153,238,219,
199,237,92,126,43,43,148,134,33,28,21,155,141,235,51,59,231,115,45,9,112,30,78,
90,105,121,22,66,110,26,250,59,167,198,130,62,109,52,164,253,165,86,128,253,
129,128,249,142,157,241,35,92,255,0,144,127,135,253,142,169,111,228,95,243,71,
205,252,137,192,103,182,14,194,248,83,240,39,226,222,200,206,121,105,39,131,164,
62,52,108,184,55,160,166,100,120,165,130,46,204,221,52,249,221,197,71,44,180,
236,23,201,72,104,228,212,161,149,129,231,218,152,54,168,214,68,146,91,137,25,
129,173,53,16,191,178,164,254,69,143,77,201,49,0,128,160,127,135,162,27,6,52,
211,237,28,133,28,10,30,157,159,29,87,85,73,22,128,238,171,81,53,203,177,245,72,
170,228,11,115,111,245,190,135,154,127,77,189,49,94,139,89,137,149,88,113,161,
233,55,152,154,44,118,33,41,104,157,224,14,254,71,164,141,25,101,170,153,210,33,
18,234,70,185,208,120,10,7,168,243,237,153,8,80,104,104,58,113,1,103,21,21,61,
125,99,63,144,239,196,173,179,252,179,191,149,23,87,213,119,37,102,3,175,55,103,
96,98,165,249,15,222,187,139,115,201,142,192,38,7,37,191,225,163,170,192,224,
243,249,90,151,132,153,54,222,217,108,125,10,69,51,121,18,177,228,137,23,91,89,
136,162,154,52,138,227,113,157,194,198,230,160,159,224,24,79,247,175,136,1,154,
181,41,94,140,244,158,200,148,100,127,135,207,252,223,151,87,185,69,87,6,66,142,
150,190,149,139,211,86,211,65,87,76,236,141,25,120,42,35,89,161,115,27,133,116,
47,27,131,102,1,133,236,64,62,215,163,172,136,146,47,194,192,17,246,30,170,69,
9,7,169,62,237,214,186,249,105,255,0,194,176,191,151,94,55,226,79,206,76,63,
200,158,169,235,250,93,163,209,95,44,112,173,159,172,77,179,136,90,13,169,133,
238,220,28,134,29,251,141,17,211,218,135,27,91,186,105,164,167,205,44,74,177,36,
146,212,84,180,105,100,107,38,179,62,12,210,217,214,137,241,32,254,137,193,3,
253,43,87,30,65,148,112,235,82,10,129,39,159,159,250,190,125,82,111,242,235,249,
221,221,63,203,111,228,238,214,249,73,210,79,4,217,44,69,6,95,108,103,54,142,78,
73,191,128,239,221,179,157,199,201,75,147,196,103,105,169,153,69,77,36,21,105,
13,76,45,112,209,213,64,140,140,164,19,237,69,237,161,186,74,198,250,37,83,85,
96,50,15,3,249,82,160,255,0,159,166,162,152,70,116,145,90,140,255,0,147,252,
253,66,249,253,218,24,255,0,144,31,52,187,251,191,241,207,136,120,123,163,117,
71,217,51,193,134,150,86,161,160,202,238,220,54,55,39,152,160,166,105,85,74,
138,76,164,179,70,202,73,241,148,176,39,219,59,114,181,189,154,44,226,142,11,
113,199,22,39,135,206,189,110,118,241,30,139,192,211,169,127,9,255,0,152,79,201,
255,0,229,187,216,27,247,178,126,41,238,45,167,180,119,230,253,216,115,117,214,
87,114,231,54,118,7,121,86,98,48,53,21,180,217,25,91,110,127,29,130,166,155,21,
145,251,186,72,155,205,227,125,90,0,101,97,199,187,203,108,46,76,82,179,50,233,
173,40,105,196,103,141,124,188,248,250,117,100,125,21,94,36,244,13,118,31,205,
143,152,157,173,219,21,157,233,216,31,39,123,207,114,118,245,103,154,54,236,41,
251,47,117,209,110,58,90,105,203,25,49,248,154,204,102,78,132,97,49,62,162,22,
142,141,96,165,65,194,198,7,30,244,182,54,165,74,152,16,230,166,163,81,39,212,
147,82,79,204,231,171,151,113,248,179,209,109,202,100,50,185,220,141,94,99,57,
147,200,102,114,217,9,222,170,191,41,150,173,169,200,228,107,170,101,98,242,212,
85,214,213,201,53,77,76,210,49,187,59,179,49,63,83,237,74,70,136,2,34,128,163,
200,96,15,179,170,18,78,73,235,36,112,39,135,86,161,112,47,160,134,4,130,20,107,
191,55,0,159,167,187,18,20,117,172,231,168,178,192,10,234,250,125,120,250,147,
111,175,245,181,143,251,127,116,99,80,8,234,194,158,67,175,167,63,242,84,254,
126,159,2,176,63,19,63,151,55,195,30,217,249,21,189,119,31,201,173,223,183,219,
167,243,117,91,211,109,228,5,38,201,221,216,140,180,248,237,161,183,247,190,244,
170,145,113,233,134,206,65,83,75,141,192,87,121,170,164,168,142,56,190,235,192,
196,216,162,41,90,205,94,57,32,97,2,187,29,88,210,170,90,171,76,215,72,7,52,29,
153,192,3,167,136,15,66,24,86,159,207,253,95,183,161,103,254,20,245,252,159,123,
83,249,140,244,143,88,119,71,197,189,151,137,221,223,37,126,62,85,102,105,42,
118,223,223,166,51,114,246,55,84,102,162,106,186,221,169,183,39,172,154,12,69,
102,115,9,159,141,107,169,41,234,36,136,204,178,206,145,190,182,84,101,18,134,
130,225,110,81,9,140,174,151,3,39,6,170,212,226,105,86,4,12,154,140,26,117,161,
66,186,124,252,186,249,153,246,63,83,246,231,73,238,92,150,200,238,158,175,223,
93,95,188,113,111,81,65,91,183,123,7,106,230,182,166,82,26,154,55,11,50,173,54,
98,146,141,230,88,89,129,15,30,164,96,192,130,65,23,91,13,196,83,173,98,145,90,
156,104,120,125,163,203,243,233,166,82,184,35,164,109,29,64,136,84,71,36,74,235,
62,130,29,216,179,38,149,23,11,115,101,28,241,254,183,181,3,0,245,67,235,212,
42,165,117,130,88,162,136,202,178,122,189,67,83,21,186,181,174,5,201,214,111,
111,240,183,189,0,124,248,127,171,254,43,173,2,14,122,225,64,165,193,142,71,177,
89,224,111,19,198,117,50,15,67,22,69,58,153,181,11,125,111,111,118,166,71,173,
122,223,88,114,8,168,114,76,143,232,80,16,121,18,205,109,55,208,56,81,175,82,
253,109,127,118,35,227,234,160,134,10,122,73,181,138,146,72,5,74,178,143,246,
150,22,224,126,108,71,251,111,117,242,234,221,118,1,212,204,140,44,79,233,97,
248,224,106,224,158,77,191,30,247,194,180,235,93,74,71,168,86,93,10,116,254,10,
217,141,215,243,165,110,64,254,191,237,253,208,12,212,158,183,231,158,61,58,233,
208,104,157,69,188,146,179,16,85,137,50,95,88,4,88,106,244,181,189,188,70,16,
143,94,154,166,94,167,0,117,58,36,49,176,157,217,204,102,73,25,131,92,234,44,
246,34,53,0,104,0,253,71,208,251,163,226,132,240,235,96,212,105,92,55,251,29,
114,171,171,142,54,36,32,145,156,50,32,102,212,81,108,77,245,15,237,45,248,252,
115,239,206,65,244,56,234,177,169,226,113,254,175,229,211,114,234,144,49,102,99,
101,36,22,60,223,155,255,0,177,62,244,132,1,143,229,254,174,29,56,192,154,15,42,
244,209,87,39,145,180,253,61,108,92,254,11,105,245,127,172,69,236,63,199,219,78,
230,162,158,189,56,170,5,58,138,125,70,223,217,79,240,250,183,54,28,254,23,222,
206,64,167,152,199,217,230,126,211,213,250,154,168,22,53,115,107,233,12,3,94,
218,73,22,96,127,173,197,128,247,179,128,7,85,0,19,94,179,169,245,165,197,244,
155,125,47,168,159,240,177,228,126,127,168,247,92,154,128,194,191,236,117,234,
249,245,63,29,24,154,90,134,98,74,50,75,31,166,247,70,55,101,32,15,212,69,191,
214,183,189,129,82,115,229,254,199,236,61,84,214,148,199,94,31,105,76,240,201,
81,174,69,85,187,44,97,124,170,225,109,19,13,103,74,217,191,173,254,151,183,
191,47,104,4,154,240,199,94,205,42,15,73,121,230,121,106,90,71,211,168,18,61,42,
169,112,9,32,185,80,53,57,191,39,234,79,182,235,86,227,211,157,74,50,176,137,97,
36,248,219,214,170,10,232,4,35,18,197,57,253,207,241,224,251,221,59,64,21,225,
252,250,165,5,14,58,255,209,208,130,246,98,47,202,219,232,65,31,236,45,248,246,
237,1,36,147,142,181,214,69,85,110,9,0,177,252,155,14,110,7,187,6,226,9,235,221,
68,120,89,25,74,139,169,255,0,98,69,135,55,255,0,11,251,176,197,58,169,174,41,
215,20,109,44,236,44,14,150,176,55,230,255,0,129,239,221,123,141,58,112,161,153,
252,183,213,102,186,122,64,176,35,232,215,224,139,17,238,232,104,107,94,171,32,
170,156,103,167,43,23,158,153,93,131,40,112,76,114,88,70,61,127,164,165,129,34,
223,237,175,237,130,51,253,30,172,166,171,212,122,138,61,30,114,170,85,82,98,52,
253,121,0,220,95,243,245,227,250,123,108,138,87,237,235,117,234,19,198,68,87,
210,72,191,45,110,1,210,64,5,255,0,54,250,251,215,94,7,36,117,133,86,215,0,144,
8,55,2,255,0,239,141,199,189,212,85,77,58,241,29,97,120,201,109,4,253,44,57,
252,241,197,255,0,23,246,246,8,175,94,6,189,120,2,173,109,34,201,201,54,250,1,
193,224,127,95,123,198,41,214,135,159,78,81,18,41,228,228,17,52,129,152,2,44,91,
86,149,185,224,241,171,253,111,109,182,56,127,171,252,253,120,127,49,211,121,
133,140,172,164,55,224,221,136,94,7,215,243,99,254,30,233,254,30,175,212,186,90,
151,167,212,20,218,223,95,200,96,62,164,255,0,136,247,176,220,122,213,1,28,58,
80,209,19,83,4,198,204,247,86,97,166,50,252,20,39,73,31,75,18,121,191,187,169,
90,103,170,145,67,215,15,225,168,104,158,93,76,178,45,66,35,66,240,76,136,202,
121,58,38,209,226,12,127,212,147,200,247,64,196,212,83,175,10,215,166,185,129,
80,80,221,25,88,105,94,120,0,3,170,255,0,66,111,111,110,0,52,209,186,183,175,
89,169,235,82,73,19,200,166,54,141,100,103,101,231,204,25,8,40,192,11,40,213,
99,244,250,255,0,175,238,163,2,190,64,245,162,15,150,122,123,199,229,42,241,53,
63,125,136,202,213,227,234,158,146,174,129,170,241,181,211,80,85,61,46,66,154,
74,42,218,87,146,9,97,152,83,215,82,204,241,74,132,232,150,55,100,96,65,35,223,
153,17,134,151,80,194,190,99,243,29,104,99,135,30,154,43,24,198,175,18,217,21,
108,52,6,183,0,128,53,176,228,144,191,95,241,247,114,51,67,214,199,77,34,70,60,
18,69,129,254,213,238,72,35,253,126,125,212,240,175,91,235,136,181,239,248,191,
211,222,197,56,249,245,238,187,112,4,141,253,162,74,250,137,28,13,39,128,47,115,
244,247,70,175,10,224,117,190,187,133,69,206,162,62,159,82,120,176,250,14,127,
22,247,188,117,82,79,151,83,227,120,211,251,67,244,216,129,118,35,155,125,0,38,
214,247,122,168,252,93,107,60,122,143,28,77,37,74,11,182,133,145,11,181,153,116,
199,172,41,54,54,99,125,95,142,125,178,204,188,88,227,171,26,240,3,61,43,169,99,
20,237,50,45,76,244,131,194,138,202,180,173,50,212,94,70,101,105,194,2,176,170,
132,4,23,36,155,123,47,154,64,228,16,152,242,21,207,79,36,100,2,107,159,245,126,
206,154,243,44,149,194,77,46,92,249,158,67,35,68,33,184,104,194,150,72,151,244,
249,217,47,205,191,169,177,62,221,183,86,81,168,138,10,125,191,234,167,84,145,
151,86,15,95,85,175,248,74,39,106,109,77,221,252,159,186,79,101,209,228,241,145,
110,126,191,223,253,213,181,114,216,63,226,116,115,101,139,193,190,171,55,34,
228,91,27,28,159,119,77,77,62,63,116,83,176,214,182,55,189,236,71,182,109,165,
141,46,110,237,217,192,148,201,168,15,50,52,33,168,31,46,31,151,91,32,149,70,
167,109,63,202,122,215,143,254,22,179,183,106,40,62,92,252,51,221,113,227,35,90,
108,231,69,238,188,83,229,34,70,21,53,21,152,93,246,210,154,22,150,250,72,134,
155,36,142,130,215,26,143,54,62,246,148,75,235,204,228,164,103,254,62,63,200,58,
211,0,99,90,240,169,255,0,39,90,137,226,115,153,88,212,211,164,50,125,137,138,
40,204,21,144,83,146,199,200,29,74,153,85,204,102,118,176,102,30,171,127,135,
187,72,202,205,82,115,211,26,83,130,138,103,161,66,44,38,47,49,70,106,102,167,
135,13,95,44,206,241,37,43,179,209,157,113,137,85,26,41,0,1,162,114,66,182,178,
74,243,111,110,91,200,1,0,147,167,164,82,234,70,1,114,58,11,247,58,213,203,75,
81,139,173,146,54,168,72,218,74,89,163,145,222,58,184,1,118,50,197,39,215,84,
12,182,245,92,168,255,0,91,218,237,125,180,84,160,254,125,93,40,8,111,46,183,
171,254,106,61,221,185,187,207,254,18,125,240,255,0,177,51,159,115,186,243,59,
158,171,227,62,11,119,238,26,233,60,85,116,89,29,161,95,157,219,114,215,212,70,
170,198,178,106,154,156,10,64,205,113,171,201,228,60,241,236,130,3,67,97,21,113,
28,242,175,228,171,32,81,254,243,74,125,157,25,177,237,118,245,80,127,193,94,
180,120,219,114,45,22,54,40,144,142,85,126,223,66,202,198,73,101,241,141,52,197,
80,6,120,199,36,19,112,223,79,241,62,18,58,240,110,138,91,184,154,244,34,84,
208,195,54,58,211,214,73,20,226,166,186,117,154,166,154,181,141,83,45,61,22,180,
141,204,12,169,35,188,214,7,234,192,88,155,123,80,179,176,0,72,106,181,255,0,55,
73,234,197,168,160,112,3,143,14,63,159,229,208,111,91,75,83,73,37,22,90,130,
166,183,23,148,197,77,65,89,139,171,167,168,146,58,234,28,133,28,203,83,71,95,
79,81,3,6,166,169,167,168,137,100,141,149,129,82,20,220,31,118,145,82,88,205,
69,81,135,15,151,79,194,204,173,243,31,151,250,190,222,174,99,249,100,127,61,
175,148,223,2,190,79,231,123,151,181,34,155,228,166,204,237,102,150,135,189,97,
220,15,65,79,218,91,162,133,191,123,17,146,198,111,202,154,105,38,76,142,223,
201,222,120,161,168,70,130,113,44,168,229,124,129,212,149,182,181,129,214,123,
26,36,138,8,161,39,73,7,36,30,36,102,134,163,53,30,98,163,163,21,184,12,8,147,
35,249,245,90,63,37,187,71,103,247,223,203,143,145,29,221,215,59,95,45,177,246,
39,108,246,174,253,236,237,179,179,243,77,139,108,134,221,162,221,89,106,220,
255,0,240,218,233,48,233,14,48,201,73,87,86,224,44,42,17,150,192,92,253,76,118,
235,121,45,237,97,134,90,22,81,229,195,228,5,125,6,56,116,138,234,68,145,218,
156,9,232,58,199,102,119,167,95,110,157,141,218,27,3,39,93,181,247,182,201,220,
24,157,229,179,247,46,58,169,41,242,120,77,199,128,174,131,41,138,202,210,40,
46,209,84,83,86,211,35,168,112,65,210,1,4,18,10,139,155,100,154,22,142,69,170,
48,161,252,250,98,9,76,79,131,209,149,249,151,242,211,114,124,227,239,140,95,
201,141,245,136,162,193,247,6,115,98,108,93,181,221,117,56,181,164,167,199,239,
45,243,178,49,145,224,191,210,21,14,55,31,12,16,98,134,230,193,81,210,10,138,
113,168,45,92,18,48,54,101,1,14,221,105,45,147,75,19,200,93,11,150,4,241,205,48,
125,77,115,95,58,215,165,87,50,44,200,24,12,211,165,255,0,86,110,185,126,194,48,
201,5,108,75,42,199,229,154,160,66,234,102,145,16,199,27,19,173,145,22,35,193,6,
215,254,150,246,43,183,126,222,29,6,110,227,26,170,42,27,163,44,185,90,41,119,
67,172,112,83,232,171,254,25,33,209,233,149,204,202,136,93,103,10,53,204,132,
89,92,220,242,125,170,174,122,67,163,244,193,169,174,122,112,201,227,40,206,
192,170,72,233,104,105,213,114,240,143,28,169,160,179,202,101,82,250,2,104,38,
83,253,166,34,196,147,192,247,70,11,225,156,121,245,177,171,198,94,227,195,163,
163,252,133,59,11,226,111,69,127,48,77,203,221,95,49,183,246,193,235,237,185,
179,186,151,47,69,214,21,253,129,143,108,134,46,167,126,110,156,238,31,12,213,
52,114,125,133,124,24,204,150,43,0,245,76,181,18,42,52,113,72,204,25,64,54,7,
111,181,18,218,120,144,179,91,6,37,128,82,217,2,139,80,43,81,83,94,30,67,206,
157,11,118,166,66,178,119,0,244,243,61,119,252,255,0,63,156,7,92,127,48,254,225,
218,29,41,208,123,107,16,159,29,190,56,231,243,53,120,94,223,168,197,71,30,119,
181,119,38,66,146,60,77,118,71,108,137,177,241,87,96,58,230,138,158,57,35,164,
133,153,91,36,236,42,37,69,85,129,70,172,45,88,220,125,100,137,225,168,77,42,
180,161,211,80,106,223,51,65,69,252,35,142,73,1,219,201,131,39,132,134,166,181,
63,234,255,0,47,85,3,240,255,0,226,255,0,107,127,49,111,148,61,95,241,35,164,
225,169,251,253,235,151,134,175,122,239,1,73,61,70,39,174,58,239,29,36,82,110,
157,239,156,240,171,136,169,48,212,12,124,40,196,125,205,108,145,66,190,169,7,
181,55,247,158,4,96,70,53,76,198,138,61,79,151,216,7,18,124,128,61,51,105,109,
169,139,62,20,117,191,223,200,253,239,252,168,191,225,60,95,22,49,181,91,79,97,
244,206,119,229,62,208,235,5,219,125,47,183,115,88,253,177,150,249,33,220,219,
165,164,148,99,179,91,175,59,69,142,147,117,98,246,213,70,126,177,170,114,89,54,
251,106,88,41,81,160,167,98,235,20,94,200,140,49,171,148,95,214,220,24,212,150,
171,5,39,241,17,90,40,3,225,81,66,70,1,57,61,27,84,42,214,154,99,31,149,122,208,
19,230,207,243,62,249,253,252,199,243,149,117,159,38,59,183,61,95,178,215,33,
53,94,23,167,54,107,201,180,58,143,109,178,196,190,56,232,182,134,46,100,166,
202,212,193,10,132,251,188,148,149,149,142,69,218,91,159,102,208,216,34,176,146,
66,100,152,126,38,205,62,193,64,171,254,212,15,157,122,66,247,53,37,65,162,255,
0,171,253,89,234,187,191,129,82,198,81,91,68,138,36,142,18,134,38,142,78,85,
13,147,80,5,201,45,112,69,192,183,181,202,130,135,170,107,36,241,233,53,22,42,
55,145,21,65,144,164,161,216,5,101,109,68,155,165,197,195,32,226,198,214,36,
219,222,148,14,20,207,86,119,207,203,165,70,3,106,87,207,75,60,141,78,233,8,168,
168,179,23,141,25,157,96,46,65,75,135,191,224,88,127,175,238,164,211,85,120,116,
219,61,72,206,122,125,133,50,149,49,80,97,241,116,153,26,204,230,82,90,12,70,31,
21,13,36,181,89,28,190,74,179,32,180,120,188,109,29,37,56,121,170,106,230,170,
145,34,142,16,133,157,152,5,231,219,77,40,137,29,153,168,128,84,250,99,253,142,
180,168,206,192,0,51,254,175,231,214,209,191,7,63,149,47,196,255,0,229,249,212,
56,79,230,55,252,243,243,149,253,103,146,219,217,218,172,215,66,124,19,204,69,
77,75,216,253,133,152,219,21,136,248,140,190,234,217,70,169,115,251,141,242,57,
74,69,122,92,58,138,108,124,16,129,62,78,117,137,188,62,201,174,110,218,237,
154,21,13,225,159,194,1,15,32,243,57,166,136,248,130,198,133,179,164,140,106,49,
138,17,31,113,166,175,228,63,206,126,93,91,111,242,215,249,87,223,159,240,162,
223,154,217,238,224,238,109,143,254,141,191,150,127,194,220,222,47,114,117,231,
199,58,122,167,174,192,246,135,124,201,47,220,245,173,127,115,100,227,16,82,246,
22,83,98,99,224,124,223,240,207,10,225,177,245,63,106,22,25,25,140,178,55,37,
187,79,113,20,51,144,212,93,76,7,194,171,192,40,245,46,112,88,228,170,176,1,67,
17,211,129,168,165,135,229,234,79,251,31,225,235,116,80,0,22,28,1,192,3,232,7,
179,110,155,234,152,255,0,153,231,243,211,248,61,252,175,49,237,128,236,189,213,
55,105,247,197,90,211,201,138,248,249,213,149,120,204,182,251,134,154,121,80,
28,166,242,168,150,164,98,182,22,37,105,245,73,27,100,93,42,42,72,2,8,100,4,
178,165,123,134,98,209,218,71,226,74,48,115,69,83,253,38,206,127,162,1,62,180,
25,235,116,3,46,104,63,159,95,58,15,231,9,252,229,254,67,127,55,126,215,167,
164,203,83,100,122,191,226,182,201,205,127,19,234,78,137,130,106,122,198,162,
173,134,138,163,31,253,244,223,89,58,56,163,109,193,189,235,169,42,230,82,202,
223,107,67,12,198,24,22,218,228,146,240,65,58,191,212,76,133,231,200,0,124,42,
13,48,188,43,90,2,88,228,211,200,80,6,228,150,58,21,87,0,117,77,141,73,135,160,
149,34,146,121,84,131,170,88,98,36,182,142,86,56,220,1,251,32,51,220,131,249,
255,0,31,106,93,238,152,105,72,233,211,10,177,158,230,53,233,151,39,151,73,8,48,
203,31,143,202,97,88,198,179,58,70,18,194,232,177,172,107,27,3,244,91,220,143,
126,72,89,187,165,146,167,211,171,130,7,106,199,219,235,235,254,175,159,73,73,
231,150,118,28,128,23,133,65,113,168,19,250,141,249,102,63,66,79,183,170,41,74,
80,83,171,82,149,61,71,141,1,191,208,144,77,207,211,253,137,183,208,251,210,
138,10,17,158,172,107,198,184,235,189,3,149,28,155,158,127,165,175,244,247,178,
104,9,235,95,46,156,233,34,105,40,235,44,172,250,97,142,204,8,84,142,238,197,
245,150,181,248,95,210,57,62,217,99,82,77,113,215,171,229,211,105,75,221,90,222,
144,79,244,54,36,88,255,0,137,35,222,210,149,165,56,245,186,124,186,118,193,228,
170,246,222,123,9,184,241,97,83,41,183,179,24,188,238,56,75,228,84,21,152,154,
200,43,233,76,154,30,57,44,42,41,212,146,172,13,190,132,27,31,108,74,190,34,188,
109,149,96,65,252,248,245,181,98,8,62,157,125,106,190,9,255,0,54,45,201,252,216,
127,149,247,111,246,127,198,108,150,217,235,15,157,125,91,215,121,234,60,247,86,
195,144,167,205,46,7,179,182,238,34,76,142,219,202,209,227,50,48,77,91,62,196,
236,121,104,90,58,25,38,142,95,12,146,52,18,59,188,76,88,170,103,184,250,105,
237,245,148,185,136,6,5,127,26,2,9,43,90,228,138,169,25,163,83,52,35,165,10,23,
82,181,42,167,249,30,190,93,191,38,254,93,124,172,249,121,216,185,189,229,242,
191,184,59,3,181,119,173,46,95,54,198,13,235,149,168,158,151,107,86,77,84,177,
100,177,27,127,2,130,28,78,215,160,166,146,145,97,20,148,112,65,12,107,16,80,
188,123,53,180,130,222,33,226,66,185,97,82,220,75,121,212,147,82,122,101,217,
142,27,162,250,146,255,0,147,171,181,206,150,88,202,216,114,174,160,19,254,60,
168,228,251,90,8,165,71,30,154,243,233,206,51,121,35,66,89,79,169,133,185,36,
104,22,42,56,190,146,62,158,236,163,32,117,83,65,154,117,158,8,12,21,20,213,104,
247,79,187,150,9,33,227,200,206,35,89,53,48,55,101,242,134,4,95,233,166,222,239,
164,150,7,203,173,22,160,62,180,233,139,56,8,134,183,198,15,136,85,164,111,168,
51,16,14,166,82,164,142,44,255,0,91,251,179,10,33,52,234,136,213,117,7,133,58,
75,66,190,82,5,237,114,161,91,240,164,253,72,30,218,90,156,121,116,235,144,181,
39,174,127,106,200,88,106,189,245,92,216,142,1,1,143,245,183,189,51,5,213,213,
65,214,22,152,207,78,184,228,10,88,155,157,1,136,109,55,211,199,36,91,155,155,
251,109,100,201,174,58,112,174,48,122,83,181,50,120,105,181,141,40,160,72,88,
139,141,69,70,165,5,128,245,113,197,190,158,233,37,193,36,0,113,252,250,160,90,
106,39,36,244,217,145,170,142,123,232,244,152,198,128,81,145,65,26,128,10,52,
216,59,129,249,63,79,123,241,11,142,239,138,189,121,16,45,41,231,211,20,140,188,
88,122,174,73,250,144,57,227,147,201,63,215,241,239,122,235,143,231,211,186,
122,200,178,152,226,107,15,220,107,143,199,3,250,145,254,30,246,42,88,249,80,
127,62,180,120,142,154,37,224,168,31,172,146,9,63,147,254,168,31,235,115,239,71,
74,129,171,173,131,199,211,175,42,16,2,255,0,188,159,235,249,255,0,111,127,118,
30,109,76,154,99,252,29,120,183,167,82,152,186,170,2,222,139,173,151,198,125,
32,31,193,32,94,223,147,239,204,120,80,255,0,47,231,214,184,121,84,117,37,90,
24,230,13,195,7,45,112,73,23,86,6,202,161,110,86,205,110,77,238,61,233,105,90,
234,7,173,147,196,249,244,239,71,83,12,66,89,17,72,69,45,123,220,18,186,9,50,92,
11,200,84,11,127,94,61,217,105,146,15,84,53,56,29,55,235,134,79,24,151,198,79,
139,91,72,4,200,25,217,133,148,129,25,42,198,255,0,139,253,127,195,221,42,213,
98,163,3,253,95,234,61,111,20,249,244,203,53,56,18,201,42,134,49,6,0,157,54,
245,16,13,128,63,215,232,63,175,182,205,56,143,46,174,13,122,137,229,114,224,
104,28,31,209,99,123,233,211,107,125,127,62,247,83,94,61,122,153,175,159,95,255,
210,208,128,139,177,107,114,127,216,95,159,111,26,12,158,181,214,98,170,209,165,
238,8,110,15,228,115,244,31,225,238,167,77,62,93,111,174,42,172,172,191,82,6,
174,47,169,72,35,232,87,250,115,253,61,250,133,105,78,61,107,143,81,244,45,220,
1,207,231,146,69,137,254,135,240,61,216,55,168,235,92,41,215,116,231,67,141,
70,228,58,250,129,60,122,191,222,141,253,236,16,105,214,142,70,58,159,228,103,
169,143,75,0,83,232,204,192,253,88,157,87,35,139,3,111,122,111,136,99,35,173,12,
3,211,165,81,168,241,74,179,66,85,141,69,212,233,34,228,32,39,77,174,13,191,
165,207,182,229,212,166,158,71,171,46,115,215,81,120,222,146,69,37,85,142,155,3,
193,39,250,148,63,75,115,127,197,189,182,31,36,30,188,84,241,29,97,106,120,229,
86,6,52,133,227,139,89,116,83,105,36,43,198,176,165,133,172,111,113,111,110,
149,227,242,235,93,52,178,72,146,8,200,177,54,38,223,66,25,126,160,149,189,172,
120,247,228,98,5,43,214,142,62,206,177,180,47,175,86,131,111,74,181,207,28,223,
146,5,184,246,233,63,62,189,81,198,189,59,253,171,199,73,160,16,89,196,58,151,
74,184,228,220,144,65,176,32,128,79,62,252,86,163,35,61,80,55,125,65,198,122,
227,81,77,170,64,0,143,94,168,213,141,143,212,128,126,162,193,127,87,62,232,195,
203,167,3,3,212,148,197,75,60,13,36,104,21,128,84,66,72,62,86,245,220,170,130,
88,16,84,92,253,61,212,163,82,190,93,123,80,199,88,177,213,243,209,165,84,14,
186,81,135,138,78,15,145,88,56,183,143,233,192,35,158,125,180,194,180,161,233,
202,14,148,117,121,9,134,33,210,50,78,170,186,98,233,164,20,117,101,114,193,137,
7,198,69,133,156,125,126,158,246,140,20,16,126,46,169,76,214,157,36,170,234,
12,140,160,161,64,172,228,161,190,176,205,166,218,220,128,88,133,2,214,176,176,
246,230,174,7,173,211,168,40,72,118,34,255,0,160,131,245,231,253,183,208,123,
218,138,175,207,175,30,164,192,78,185,52,122,143,164,217,128,2,192,22,55,177,4,
0,71,189,129,66,189,123,203,169,181,74,5,54,163,165,153,155,151,4,182,176,222,
174,110,45,96,45,111,207,187,30,25,61,104,125,152,233,166,37,176,99,249,32,241,
249,1,127,62,232,105,164,117,190,178,34,135,100,4,129,168,158,127,227,86,55,247,
86,114,1,199,14,182,7,83,196,48,151,136,233,5,200,26,184,62,166,177,28,220,149,
82,45,254,199,219,26,206,115,142,173,74,253,189,98,109,17,176,186,133,177,181,
136,91,150,228,27,95,221,193,168,38,189,84,138,87,29,115,138,166,4,111,87,144,
47,32,133,210,111,233,191,227,143,247,159,109,200,92,147,74,117,96,163,207,249,
117,204,213,167,153,164,72,152,13,119,0,181,207,214,247,212,5,149,135,245,252,
31,108,144,196,0,79,86,2,153,174,43,211,148,153,106,137,86,174,26,116,142,8,
107,36,245,199,161,93,213,21,131,166,170,135,6,81,98,126,165,185,254,158,219,88,
69,81,152,213,128,255,0,86,58,179,72,123,128,20,235,140,20,179,85,53,174,206,
36,36,154,166,44,34,181,189,86,22,26,152,254,47,107,159,106,117,0,40,7,73,205,
42,107,213,210,255,0,33,127,158,123,139,249,127,127,48,254,141,220,251,135,119,
100,177,93,9,217,123,164,117,119,110,97,234,235,156,96,32,194,239,101,76,37,38,
239,158,133,234,82,146,9,118,238,94,106,90,151,168,32,105,130,39,213,112,5,145,
93,129,68,187,84,253,104,142,172,113,43,193,135,251,201,52,30,180,233,200,218,
189,132,246,159,240,249,127,62,182,176,255,0,133,157,245,149,46,239,248,195,240,
231,182,240,251,116,102,228,195,119,30,228,217,113,111,12,101,74,205,246,20,251,
219,103,182,83,3,68,5,62,180,173,162,206,87,237,246,241,56,112,129,192,32,250,
135,191,60,136,111,32,158,55,6,23,137,133,70,65,210,202,64,252,129,99,251,122,
181,14,134,83,196,30,180,25,216,9,252,94,140,201,44,176,197,51,83,248,151,238,
29,100,242,79,71,26,248,41,116,202,169,254,81,52,131,211,98,72,247,75,138,164,
128,1,85,255,0,87,242,233,35,208,18,8,249,244,44,80,99,166,173,171,166,162,142,
4,130,66,185,7,180,145,188,11,2,8,180,164,141,44,160,192,188,173,174,133,197,
248,39,217,133,148,26,212,31,42,255,0,131,162,203,153,138,51,121,244,16,239,92,
67,208,204,174,149,10,203,75,4,146,201,20,106,89,227,242,157,18,249,153,110,
168,172,57,43,248,252,253,71,181,236,129,69,43,158,156,130,83,38,125,122,219,23,
249,96,231,42,255,0,152,239,242,27,249,251,252,179,171,51,211,211,246,167,197,
186,55,249,33,210,209,77,5,51,83,100,246,86,42,186,77,247,22,8,78,33,106,137,35,
143,118,97,107,233,11,88,72,131,41,6,131,164,17,236,61,116,191,75,112,242,15,
132,17,55,251,200,209,47,252,101,131,15,83,209,180,109,226,69,79,62,31,229,31,
204,117,171,135,85,54,46,190,90,42,202,234,232,146,60,76,38,87,161,49,83,190,
185,74,170,60,114,25,11,73,16,184,12,8,95,212,7,179,214,224,148,165,107,209,60,
218,148,200,180,57,29,46,55,53,104,168,205,211,96,49,191,197,22,158,148,213,215,
85,86,90,87,161,162,130,106,88,124,208,66,86,17,229,172,142,40,214,197,67,42,7,
230,231,128,158,121,11,75,64,120,121,122,245,187,104,116,197,226,176,29,196,82,
191,203,253,71,164,68,134,57,168,107,234,230,146,48,203,89,28,116,244,209,180,
109,50,172,43,30,169,35,167,37,92,64,14,171,177,81,249,184,246,186,26,8,128,39,
3,167,92,17,32,199,17,94,166,108,220,49,202,102,33,163,9,21,80,6,211,43,170,
153,47,35,49,129,12,108,111,47,151,158,0,36,253,45,244,247,116,26,200,31,62,181,
33,240,195,215,211,165,123,236,170,73,226,174,166,165,164,151,31,80,181,83,210,
70,201,75,247,75,45,108,118,149,233,32,84,141,106,169,252,144,114,9,212,138,46,
63,179,237,94,154,13,36,83,249,244,132,72,213,13,92,245,193,182,125,61,86,63,
14,180,154,167,48,208,60,85,113,153,93,157,37,87,99,228,144,204,137,32,103,4,
21,60,15,197,237,245,185,90,170,128,107,214,181,154,182,163,199,169,237,212,
227,83,86,83,201,8,108,139,82,173,50,220,181,76,179,128,195,199,37,53,208,170,
234,4,41,13,102,35,130,121,247,127,4,106,13,81,78,189,227,26,105,206,58,87,197,
67,155,219,80,82,8,168,163,130,142,41,216,213,78,33,127,36,82,197,169,105,212,
70,220,180,213,5,141,172,8,23,250,218,222,223,21,85,24,199,73,141,36,38,167,62,
93,14,213,57,215,171,201,227,165,166,105,214,49,79,138,169,168,118,18,164,234,
164,48,80,19,68,108,10,72,191,167,139,14,111,111,106,3,130,216,61,38,240,244,
163,84,122,244,62,81,100,178,24,77,149,145,88,226,53,34,89,168,170,150,90,184,
141,82,131,42,136,158,80,140,197,153,22,246,22,253,95,235,30,108,88,132,173,58,
96,168,105,23,61,19,157,251,83,181,114,85,82,125,194,137,106,81,90,185,170,26,
144,193,74,130,52,102,172,109,12,202,86,41,83,233,175,79,215,128,71,180,47,225,
183,197,209,148,75,42,129,167,215,215,161,147,224,23,242,215,249,83,252,209,251,
169,186,247,227,182,215,151,7,214,88,172,182,46,147,181,251,215,49,67,60,29,119,
214,216,58,133,141,230,53,21,206,200,155,135,117,10,4,105,41,48,244,111,37,84,
206,65,127,20,100,202,9,111,47,196,109,224,64,53,92,17,133,244,30,172,124,151,
231,196,240,0,156,116,113,109,108,88,7,147,225,30,127,230,235,233,169,252,180,
63,148,207,196,207,229,107,215,85,187,91,160,118,221,102,87,176,55,110,59,23,
77,218,125,215,187,166,251,254,192,236,106,156,97,150,104,190,246,80,198,135,
111,224,99,173,158,73,97,197,227,210,26,88,201,5,252,178,40,147,218,8,225,33,
204,211,73,174,122,82,188,0,7,36,40,242,28,43,146,77,5,73,160,232,203,0,105,81,
69,235,74,207,248,82,119,242,112,249,249,187,255,0,152,126,226,249,95,210,221,
105,216,95,39,186,187,228,0,219,109,136,147,99,227,101,207,103,58,187,57,183,54,
236,120,153,122,231,51,134,167,150,74,202,60,44,116,88,71,174,199,214,164,127,
104,241,204,241,187,36,202,67,166,138,226,61,189,165,75,166,210,26,70,101,106,
18,27,85,77,49,94,229,24,167,154,128,71,152,30,116,50,0,87,141,41,246,127,171,
252,61,107,31,216,221,103,220,31,31,183,198,123,168,251,151,97,230,250,223,179,
118,174,67,29,22,225,217,155,146,158,58,108,214,17,242,120,218,28,181,2,228,33,
73,167,72,222,163,27,144,138,127,173,244,72,183,0,220,123,60,182,185,142,230,
21,150,23,172,100,241,225,231,78,7,56,232,186,72,130,59,6,20,106,116,20,60,25,
58,170,221,50,206,210,204,181,134,8,145,44,129,8,148,92,240,3,42,240,44,160,
240,57,246,246,114,1,235,213,1,69,7,151,75,15,224,208,96,35,166,19,253,188,147,
138,145,81,36,172,234,124,168,186,245,232,73,124,68,172,26,125,43,253,77,197,
205,189,166,186,111,14,33,164,230,189,110,0,36,144,212,116,159,205,246,28,120,
122,24,41,105,202,72,210,212,86,79,83,24,188,44,230,169,4,94,42,134,10,30,86,49,
125,2,129,98,45,123,219,219,73,57,42,186,178,105,158,174,214,224,187,53,40,60,
186,218,227,254,19,37,252,151,251,67,189,254,66,237,207,159,63,41,122,227,57,
179,186,7,164,235,233,243,253,39,180,119,206,3,33,139,159,183,123,45,21,167,192,
238,122,44,94,102,24,101,171,216,251,22,66,181,171,86,232,209,86,100,68,9,17,
100,142,98,165,210,200,183,207,224,70,107,110,13,92,142,6,156,16,30,7,35,191,
208,118,159,139,10,227,143,195,26,136,238,242,255,0,63,249,186,217,7,229,175,
242,3,199,127,51,143,156,89,159,148,255,0,204,39,185,50,25,126,160,217,120,124,
102,195,248,253,241,167,165,204,219,106,12,62,196,198,205,87,144,171,168,236,
158,197,200,65,62,91,33,157,220,121,250,185,43,42,225,197,67,78,129,100,17,37,
74,172,107,237,168,97,189,103,150,73,89,98,103,57,167,115,80,97,64,168,210,180,
25,224,213,36,156,112,233,214,49,209,64,169,167,250,191,213,195,171,30,151,39,
252,180,191,146,103,198,6,198,26,254,168,248,133,208,88,106,236,142,106,151,8,
249,42,185,115,91,187,115,215,199,16,172,151,25,65,89,87,153,222,253,129,187,50,
127,109,28,127,182,42,231,210,136,164,164,106,52,191,91,123,50,84,22,105,159,52,
203,59,83,31,109,7,15,37,31,46,181,220,255,0,96,253,131,173,39,127,155,39,252,
43,75,186,123,230,163,41,211,191,203,84,110,94,128,234,133,142,170,147,57,223,
25,250,10,42,126,230,223,17,191,146,38,27,63,28,231,33,77,214,120,89,32,32,164,
247,147,50,205,234,15,74,70,143,119,88,46,46,136,51,147,28,63,192,14,79,250,102,
31,241,213,52,245,99,192,84,186,165,52,138,183,169,255,0,39,251,61,105,201,184,
42,247,126,234,204,228,119,142,232,200,103,247,118,227,220,181,245,89,108,238,
227,206,215,228,51,89,204,229,125,116,186,171,50,89,92,197,124,211,215,87,85,86,
205,33,213,44,178,25,25,185,36,251,95,29,185,137,21,18,61,40,5,0,2,131,242,244,
233,49,153,24,176,103,21,233,158,40,170,99,104,154,26,73,193,148,188,108,135,
202,67,3,192,136,155,47,208,125,127,38,254,220,167,12,26,117,162,67,106,82,70,
58,148,184,156,181,77,86,129,76,206,205,26,222,19,36,81,5,80,139,96,205,36,138,
2,162,143,169,254,158,247,82,72,52,235,192,198,23,7,169,53,120,42,186,72,162,
169,173,158,10,152,67,175,158,154,145,203,201,20,210,13,48,196,211,248,150,34,
197,46,215,6,192,41,31,95,117,53,227,171,31,231,234,202,235,93,32,83,166,89,233,
146,25,52,198,117,163,13,80,18,229,229,117,176,81,103,69,23,44,198,250,72,31,
210,254,244,192,228,252,186,216,108,100,117,29,228,47,74,67,166,169,33,58,12,
162,0,151,87,81,160,52,168,192,23,141,129,224,142,127,175,182,235,65,243,29,88,
113,193,235,129,134,36,114,85,157,227,67,24,98,1,140,157,66,238,166,252,171,41,
250,112,65,247,226,245,242,199,94,167,237,233,74,126,220,210,202,138,150,11,69,
12,130,45,101,9,93,70,69,144,5,82,166,234,110,117,94,247,246,211,99,137,235,96,
126,222,147,2,250,219,82,220,105,22,38,230,195,250,131,249,36,159,246,222,252,
15,152,234,196,14,188,215,149,204,100,155,27,93,155,131,127,165,245,242,120,
191,191,14,32,249,117,170,240,35,135,86,175,252,151,255,0,152,45,103,242,198,
249,233,214,159,33,242,20,153,76,207,91,100,105,115,29,113,219,123,119,25,89,44,
7,37,177,247,148,2,133,242,159,108,37,74,108,141,70,212,204,45,46,78,40,228,4,
184,166,100,66,172,224,251,75,123,19,58,44,176,83,199,140,234,90,240,56,32,169,
251,65,253,180,175,87,70,28,27,225,63,234,175,68,251,229,133,110,102,179,229,
127,200,188,174,227,108,44,153,108,255,0,112,246,22,228,168,170,219,56,229,196,
237,218,232,183,38,229,200,103,104,242,56,92,74,23,90,12,86,70,143,33,28,240,68,
11,104,142,64,9,63,95,110,109,160,125,21,168,21,194,1,159,80,40,127,97,235,82,
215,91,125,189,0,42,117,65,32,12,79,33,173,110,44,15,63,241,30,215,249,30,169,
199,167,135,245,69,69,46,162,25,24,234,224,15,210,21,121,191,35,235,249,247,117,
108,47,145,233,186,10,176,233,207,21,12,117,249,168,233,156,200,82,69,89,249,
144,70,162,120,212,155,121,24,20,5,138,133,23,228,253,61,181,112,228,21,53,199,
91,81,142,31,46,154,243,10,87,31,147,89,65,243,45,124,104,236,52,149,102,87,75,
233,34,202,53,3,244,0,251,244,108,74,182,113,142,188,203,71,67,232,15,72,161,
168,203,165,65,55,32,16,47,171,133,191,22,252,143,110,169,167,151,90,96,10,154,
30,158,98,253,203,40,4,186,70,222,64,198,255,0,155,3,244,250,144,127,167,215,
221,95,75,47,119,175,91,80,105,79,78,157,233,162,130,8,208,59,6,36,54,176,9,0,
221,110,138,57,189,175,254,245,237,35,225,136,3,173,138,211,135,89,114,117,254,
86,72,209,153,22,40,218,55,32,221,99,4,88,36,66,192,106,96,45,170,215,183,251,
15,122,11,194,131,61,120,2,43,195,61,37,201,44,224,34,218,215,178,14,109,207,
215,242,73,62,220,166,64,39,171,131,142,185,152,100,55,185,211,166,228,254,71,
245,60,253,0,30,247,76,224,99,173,212,249,245,210,168,80,127,169,54,35,252,10,
139,17,245,7,235,237,196,4,3,83,196,244,217,207,14,160,200,6,181,226,192,17,201,
255,0,123,23,250,143,123,101,7,62,125,108,26,87,174,67,245,41,96,91,252,69,195,
27,88,159,235,110,61,232,28,128,180,167,250,191,159,94,245,198,58,206,230,241,
198,198,224,57,181,172,56,255,0,89,190,132,1,199,189,177,20,226,56,249,245,236,
249,14,186,86,32,11,4,187,200,145,14,5,152,183,33,65,254,190,218,46,42,105,255,
0,21,215,190,222,157,89,74,164,145,70,5,131,104,44,111,169,138,233,45,248,55,
231,158,125,235,81,227,95,242,117,238,35,60,122,192,193,97,166,121,37,96,210,
191,137,99,44,46,99,84,39,81,91,53,143,36,88,219,223,188,128,30,191,183,173,12,
159,203,168,112,84,24,222,70,230,242,250,82,246,230,237,164,159,165,185,94,47,
248,247,174,7,167,40,61,49,212,66,45,144,87,191,12,77,159,242,88,68,65,54,189,
195,6,255,0,138,251,245,15,14,181,229,94,191,255,211,208,136,114,109,192,189,
135,63,78,63,175,250,246,246,245,49,214,186,204,71,161,7,211,235,244,184,55,230,
255,0,239,30,232,112,160,30,61,111,172,138,61,87,63,208,91,250,250,173,111,241,
231,221,241,196,156,117,174,176,178,130,238,72,231,89,3,241,253,79,63,139,123,
245,1,57,235,199,229,214,33,16,242,45,191,39,243,253,71,60,145,239,97,40,112,77,
58,165,122,226,75,164,141,254,191,55,0,168,31,237,141,254,158,245,192,158,56,
235,126,92,58,117,254,33,58,193,15,28,7,70,44,88,144,126,162,225,117,122,117,95,
155,123,109,178,63,151,86,30,163,175,26,152,95,235,75,12,172,124,162,55,13,40,
42,207,25,1,181,106,245,17,245,177,184,191,182,6,9,0,245,127,79,78,189,73,57,
118,149,95,82,176,140,0,84,242,87,82,134,31,227,199,212,127,79,111,43,104,173,
120,117,82,43,158,186,150,25,11,199,41,39,78,166,64,227,139,120,214,246,245,126,
143,167,215,233,239,102,149,4,112,234,164,84,83,172,50,176,9,96,110,236,202,186,
88,114,200,252,3,112,2,155,17,253,61,185,141,35,57,234,129,105,129,142,156,165,
18,66,138,60,171,234,146,52,100,11,100,93,40,11,122,173,101,33,111,111,235,237,
210,10,128,43,231,158,155,82,24,214,157,67,122,200,213,143,237,70,203,230,183,
161,155,214,0,81,103,47,168,201,112,188,155,254,125,182,106,107,140,87,171,168,
0,113,233,230,158,162,52,117,146,41,18,234,136,224,22,85,79,24,15,170,156,6,
55,89,21,200,177,63,80,63,215,247,86,21,225,194,157,88,240,21,29,71,74,111,187,
166,105,140,150,150,106,196,70,67,30,176,142,227,80,141,92,29,42,164,88,146,44,
9,227,221,52,0,1,99,142,183,90,26,14,20,234,44,115,72,35,158,148,68,101,184,
209,229,33,149,2,130,56,88,173,161,156,24,248,63,80,47,237,151,174,71,87,29,67,
169,138,69,165,142,79,19,105,51,20,105,90,237,164,170,169,100,4,146,108,171,207,
189,169,242,235,222,157,66,138,254,190,63,82,45,191,179,114,72,224,106,252,219,
219,202,212,20,35,29,104,245,38,150,158,105,154,83,26,221,80,134,114,15,232,91,
233,63,214,246,191,187,3,83,94,181,168,1,211,196,216,170,211,76,210,160,242,67,
125,2,242,167,151,80,228,40,136,233,98,21,71,212,126,61,216,174,15,94,12,43,79,
62,153,86,158,160,134,111,27,216,18,165,184,28,159,245,67,139,1,127,117,35,182,
148,243,235,117,234,114,198,148,177,35,76,127,115,80,185,10,90,203,107,233,95,
193,228,114,125,162,127,18,82,116,142,209,211,130,128,113,207,80,204,206,210,88,
13,8,88,48,42,13,202,253,69,207,234,191,63,143,110,136,197,6,123,169,213,106,
122,143,225,245,150,103,37,174,125,63,130,164,155,122,143,246,174,125,251,77,58,
213,79,92,180,170,48,4,27,19,107,92,159,200,255,0,83,207,7,221,8,57,210,79,91,
173,5,79,82,204,34,236,34,101,153,69,191,113,111,110,84,125,3,122,174,62,156,
143,122,0,208,18,49,215,181,103,231,210,138,142,134,54,47,25,49,77,85,227,87,
138,153,219,198,143,35,198,206,129,133,238,252,70,215,36,216,91,159,116,53,168,
174,7,77,150,36,208,116,252,174,180,232,177,199,16,120,99,146,72,228,37,63,109,
157,52,235,44,87,146,209,130,61,55,191,186,131,85,238,166,122,242,249,154,244,
215,144,143,238,98,109,43,164,23,147,210,35,9,111,78,147,100,176,107,216,125,
126,135,219,208,169,161,237,243,233,167,96,24,103,173,189,191,150,247,204,28,39,
243,54,254,81,191,37,127,147,151,200,141,225,5,119,201,206,188,218,25,30,198,
248,51,156,222,57,128,115,29,135,89,176,146,93,227,183,58,227,111,215,86,200,
106,50,91,219,106,86,226,39,165,162,164,5,166,173,197,87,148,93,94,7,246,81,118,
171,102,89,149,105,8,112,235,232,167,131,167,200,58,146,87,213,137,28,116,130,
182,38,241,0,205,88,138,127,152,254,71,249,117,169,230,217,171,170,196,181,94,
59,49,68,40,170,163,172,120,235,233,166,138,72,36,167,173,138,121,22,162,154,
90,103,208,244,205,12,200,81,149,116,176,181,191,30,215,178,134,101,100,126,
218,99,231,210,73,22,181,52,207,67,167,247,204,69,143,163,129,167,130,58,53,162,
169,167,162,88,203,129,142,142,84,180,244,241,76,90,89,69,170,26,236,130,231,
130,77,175,203,208,201,34,83,45,64,126,84,63,149,58,68,214,241,179,19,225,138,
227,246,255,0,131,160,190,172,87,231,32,168,52,116,149,14,213,104,40,132,236,
124,81,84,51,216,68,29,166,9,116,144,194,73,102,54,31,83,111,111,188,201,248,
164,33,143,250,179,211,177,68,168,64,11,80,63,151,252,87,87,179,255,0,9,177,249,
43,136,248,155,252,209,58,175,23,189,146,187,251,157,242,47,106,238,79,143,217,
227,18,44,212,144,102,183,84,244,21,155,62,108,141,44,167,69,102,60,238,92,52,
52,206,20,72,247,169,26,84,216,130,130,248,128,176,221,21,45,28,108,117,14,53,
86,5,79,248,84,145,232,58,85,3,13,78,149,201,225,213,88,252,179,223,251,103,
118,252,230,249,85,189,58,219,111,211,109,77,157,184,123,239,183,179,27,95,109,
82,225,168,240,244,248,76,117,102,238,203,10,108,98,226,169,162,56,250,72,168,
35,186,44,11,24,137,109,96,162,246,15,237,233,166,202,219,197,243,64,104,15,0,
114,7,228,49,142,169,112,170,238,244,225,211,22,51,13,144,146,164,81,215,100,42,
218,168,65,37,100,203,79,59,70,171,44,209,26,185,35,38,45,65,209,127,212,147,96,
71,189,150,11,36,165,6,114,58,222,144,99,76,99,165,6,55,109,80,83,45,100,233,
140,138,116,168,72,42,164,53,87,150,9,147,215,78,141,80,197,36,96,237,80,164,45,
136,23,60,251,126,57,180,195,86,35,86,122,75,42,107,151,72,192,199,66,54,209,
217,52,245,148,212,121,168,49,226,38,138,169,171,41,18,153,66,212,84,26,9,238,
201,60,177,120,164,129,103,156,48,82,20,105,7,139,143,106,172,88,201,74,215,29,
39,187,98,139,66,120,128,63,213,235,211,246,83,21,35,87,54,82,149,62,206,63,
185,122,200,204,14,194,182,154,116,136,35,22,144,141,78,206,238,85,201,224,169,
32,251,92,231,69,91,56,225,210,21,53,52,242,233,56,244,7,27,91,140,134,134,49,
120,234,93,165,150,161,34,146,48,227,199,120,158,53,75,50,250,120,15,168,31,240,
246,220,115,23,57,25,233,242,131,77,107,81,208,147,32,21,209,224,18,163,23,75,
94,230,56,96,168,134,150,161,233,234,162,89,43,204,138,145,202,19,252,145,166,
94,22,69,12,171,114,63,62,204,117,234,208,116,249,116,139,73,30,37,9,31,241,95,
207,167,60,250,209,189,59,225,147,23,40,140,103,177,180,2,26,169,190,242,170,
154,150,8,156,214,197,164,167,134,121,227,118,4,77,110,72,181,189,186,120,210,
135,143,77,141,64,6,175,151,75,217,48,184,228,150,69,122,181,158,74,74,40,154,5,
49,50,188,170,176,212,197,246,235,56,8,36,150,102,111,83,122,148,30,63,30,220,
17,138,116,201,149,170,40,58,85,201,72,143,181,50,85,20,21,178,106,164,166,194,
212,44,114,218,68,104,102,144,164,180,6,45,64,44,201,50,91,80,4,129,107,128,15,
186,156,35,80,228,83,166,234,76,139,81,196,159,248,190,137,38,239,218,199,118,
118,38,200,235,186,121,170,49,185,142,207,236,173,173,214,240,79,233,169,159,24,
55,70,224,198,225,36,169,20,16,235,103,74,120,107,146,77,12,228,51,15,73,23,
224,147,113,152,219,90,220,79,78,229,86,52,255,0,74,9,232,254,197,60,89,35,90,
246,227,175,175,151,199,47,143,189,39,240,119,227,102,212,234,30,165,217,248,61,
137,214,189,79,178,254,226,182,155,110,226,163,163,108,165,94,43,18,43,55,54,
235,202,4,105,42,178,187,131,61,81,77,45,85,76,243,201,44,242,200,214,46,64,80,
8,227,85,180,181,105,95,46,19,83,183,155,16,42,79,249,135,0,40,6,7,71,167,45,
164,112,174,58,249,213,252,164,255,0,133,90,127,48,222,243,198,252,136,233,190,
171,194,117,119,86,236,110,192,207,238,205,173,179,247,166,27,5,149,155,179,54,
103,89,214,203,146,194,140,118,43,42,249,99,64,187,150,171,17,50,59,229,77,55,
220,83,74,89,160,208,193,25,43,21,148,247,10,13,205,211,20,112,53,32,3,78,127,8,
52,174,159,35,154,145,231,213,30,101,74,233,81,81,192,244,34,252,23,255,0,133,
82,252,207,248,139,214,20,157,59,242,95,175,118,255,0,203,188,46,214,192,77,
137,235,238,194,203,110,76,134,202,237,10,15,177,199,173,62,11,17,188,115,173,
140,203,82,111,172,109,13,66,162,73,85,60,16,229,94,16,117,84,206,224,89,65,179,
184,130,139,109,42,248,94,74,192,144,191,233,72,32,208,127,9,175,160,42,40,58,
109,46,81,197,89,77,127,213,254,170,245,173,151,124,247,214,246,249,41,221,221,
165,242,31,183,50,144,229,55,247,109,239,157,201,190,119,61,74,52,139,78,149,
155,130,178,74,168,241,20,41,36,175,36,120,172,53,57,74,90,69,6,241,211,197,26,
242,0,246,178,218,52,182,134,56,129,173,56,159,50,78,73,63,50,73,39,237,233,137,
11,73,35,55,72,61,153,135,223,189,143,184,232,246,199,83,236,29,227,217,123,
154,172,195,79,71,131,216,219,107,53,186,51,18,213,73,165,80,71,67,132,162,172,
169,213,40,184,98,64,250,146,77,185,247,233,174,225,128,86,73,21,71,204,129,214,
197,185,124,82,163,171,226,248,101,255,0,9,162,254,104,95,52,51,24,170,222,217,
216,141,240,239,168,69,68,51,100,55,159,119,198,240,239,90,154,25,116,204,195,
106,117,93,13,87,247,166,178,176,196,72,141,178,39,21,73,114,15,148,142,61,150,
189,203,206,196,219,196,207,95,54,170,167,237,34,167,253,170,145,243,29,42,142,
37,143,137,167,91,174,252,18,255,0,132,222,255,0,44,239,132,105,183,55,85,111,
86,143,146,125,213,132,251,42,249,187,111,191,86,155,118,52,25,218,79,220,57,
45,175,176,158,49,178,54,188,73,57,45,16,20,181,85,104,44,30,166,66,47,239,95,
75,173,107,117,41,113,230,163,181,63,96,226,63,211,150,233,205,64,124,2,159,
225,255,0,87,217,213,152,247,239,207,223,131,223,19,232,170,27,228,15,202,94,
138,234,35,139,141,34,147,7,185,123,3,110,210,238,24,130,34,136,169,105,118,141,
21,93,78,227,158,82,150,9,12,52,142,228,88,42,251,191,213,218,175,233,164,129,
136,242,64,88,143,201,65,167,90,210,199,39,249,255,0,179,214,177,95,204,119,254,
21,245,241,143,172,182,118,99,100,127,47,12,14,87,228,31,110,101,177,213,116,
116,61,169,187,246,238,103,103,245,22,193,170,157,26,8,178,209,226,55,5,38,55,
116,239,204,181,9,127,44,52,162,154,143,30,206,139,228,168,145,117,70,205,180,
151,19,246,198,134,36,60,89,169,171,253,170,228,126,109,74,127,9,235,221,171,
146,106,127,213,254,172,117,243,254,249,19,242,83,189,62,91,118,37,95,113,124,
151,237,125,227,220,157,139,154,150,162,162,175,55,188,115,85,185,33,143,166,50,
33,131,19,183,241,74,241,98,182,254,26,159,80,17,82,80,195,13,58,42,216,47,181,
112,65,12,3,177,114,120,158,36,252,201,57,39,237,61,39,119,149,216,138,99,246,
127,171,246,116,13,83,228,233,41,13,99,65,28,194,73,97,209,117,133,35,71,17,137,
22,61,118,112,45,235,228,216,147,199,181,145,200,65,109,52,225,211,79,19,56,0,
144,115,215,67,63,32,199,71,12,116,234,190,48,202,238,53,50,155,202,38,253,37,
130,11,30,46,121,35,252,61,236,200,205,74,252,52,61,85,96,1,137,36,212,245,138,
73,170,88,83,51,204,200,198,69,145,209,28,187,46,165,0,27,142,57,32,88,123,211,
48,0,2,221,90,139,86,198,79,153,235,28,181,178,10,153,156,249,184,72,209,139,
202,228,146,22,215,96,69,200,63,94,127,219,251,108,184,35,142,122,176,92,80,122,
252,186,152,179,234,161,157,12,242,180,181,106,191,177,30,159,21,226,30,147,80,
179,69,39,147,210,88,174,130,164,91,235,238,136,228,103,203,175,49,36,244,215,
42,193,73,85,34,99,234,130,210,207,12,41,44,243,66,178,72,164,21,109,6,109,58,
214,236,6,162,150,35,158,77,189,186,207,64,66,249,211,173,14,234,22,25,7,253,88,
233,165,225,117,134,81,17,53,49,121,44,140,3,69,24,99,96,210,248,216,3,43,11,
216,18,79,30,216,45,157,36,244,234,215,29,101,135,23,61,100,226,36,88,224,212,
218,11,6,53,30,55,209,254,114,102,91,176,141,201,177,177,176,62,218,51,40,4,215,
29,56,69,104,71,74,221,201,65,79,138,198,172,73,229,18,75,143,164,88,231,102,
136,73,251,105,26,74,170,83,150,167,157,195,89,79,170,198,215,227,218,100,145,
165,144,19,192,30,31,224,252,250,216,20,233,19,68,20,48,242,43,185,101,184,241,
218,202,170,70,178,232,202,89,128,80,120,4,123,89,228,64,227,213,88,211,135,78,
210,80,211,201,85,86,180,53,33,96,10,145,235,169,64,99,114,224,89,110,183,3,81,
31,91,113,249,247,225,142,60,122,169,38,130,163,166,234,69,132,76,144,74,93,21,
200,18,3,200,86,110,22,84,184,22,140,30,88,126,71,248,251,116,13,36,106,255,0,
138,235,205,92,145,212,249,69,85,85,100,205,87,52,213,21,101,22,51,53,92,175,36,
173,227,81,28,113,180,147,51,29,2,53,0,92,240,160,90,222,221,69,211,128,7,90,36,
28,249,116,221,25,98,174,5,213,131,125,44,87,129,96,65,224,243,127,235,199,191,
103,57,199,248,58,181,50,58,120,53,12,208,67,3,166,151,14,193,94,252,62,160,191,
66,44,5,173,254,183,189,212,14,61,106,149,169,29,60,98,228,90,90,177,35,57,214,
241,200,241,232,189,227,241,232,11,174,220,220,219,253,143,180,114,185,99,147,
213,128,199,14,152,115,181,94,85,49,45,199,154,115,83,80,156,105,18,13,81,162,
71,115,168,32,0,158,109,201,246,252,84,8,22,188,79,175,85,97,83,171,208,116,
156,167,3,204,13,255,0,38,198,255,0,66,198,220,255,0,64,1,246,233,60,105,199,
170,228,129,78,61,63,82,132,74,146,117,43,9,97,117,115,193,23,210,79,215,242,
120,184,255,0,95,250,251,102,66,0,31,183,171,40,21,207,30,164,200,145,70,198,86,
112,99,137,99,213,29,137,58,64,212,215,183,245,22,231,252,125,162,44,197,130,
208,212,244,229,60,169,211,68,239,173,139,91,155,130,0,185,10,191,80,46,79,39,
159,106,84,105,28,115,213,78,78,120,117,212,82,52,78,116,143,91,240,24,139,149,
83,250,180,222,227,81,247,189,71,6,189,107,0,30,185,48,113,234,212,72,107,130,
63,0,253,108,7,210,215,62,220,29,220,70,122,215,203,172,97,72,7,131,203,125,1,
230,220,19,111,246,3,219,181,28,73,235,95,111,81,158,54,105,66,4,99,171,233,127,
160,22,250,147,248,30,218,102,31,132,231,173,254,125,78,142,153,68,114,234,185,
210,182,107,125,8,115,99,107,142,26,223,159,116,44,79,159,94,249,83,29,122,162,
40,226,88,45,121,73,39,75,48,0,5,96,164,105,80,2,130,191,75,253,111,239,92,51,
215,133,73,61,119,227,243,8,89,161,101,241,75,120,152,93,157,157,109,171,82,125,
91,75,11,127,83,245,247,170,245,161,143,179,172,147,204,236,68,113,185,86,103,
210,45,244,111,72,4,3,245,7,83,115,111,167,211,221,128,173,13,43,214,232,49,140,
83,168,181,49,47,145,163,143,84,104,186,84,198,205,171,196,67,21,177,36,146,24,
146,15,244,26,189,217,84,213,133,5,122,240,39,237,234,36,200,76,168,161,10,163,
34,145,101,210,11,11,134,107,31,241,30,253,163,184,103,29,88,98,185,235,56,165,
189,49,118,0,206,9,100,254,170,183,65,107,216,45,202,146,63,60,251,182,142,223,
159,94,168,235,255,212,208,141,65,4,113,253,127,199,241,254,30,221,212,8,57,207,
90,235,43,19,116,4,158,16,255,0,183,54,38,223,225,199,186,183,1,159,46,183,215,
37,96,138,117,27,91,72,31,227,248,22,255,0,97,238,224,154,15,94,181,214,9,30,
206,74,176,32,56,54,228,131,113,111,167,248,11,251,241,60,122,247,92,225,96,210,
37,237,192,39,159,200,183,1,127,169,62,236,13,64,175,84,34,135,172,100,22,118,
176,184,215,110,13,201,231,241,249,247,190,188,124,186,200,192,24,163,230,218,
25,189,63,91,92,253,120,255,0,91,253,111,108,72,78,41,254,174,61,88,113,167,
203,172,49,139,72,20,14,53,167,63,75,220,88,16,45,245,55,246,214,161,196,240,
233,221,39,20,57,235,158,182,2,86,6,214,147,139,219,80,250,158,63,63,217,247,
234,127,15,3,214,170,120,30,159,49,228,212,45,245,216,232,112,215,183,162,78,45,
101,184,244,223,253,239,219,69,244,156,127,197,245,234,102,135,166,154,131,36,
21,35,201,24,37,28,241,33,188,108,192,146,126,132,49,31,145,110,61,168,89,1,0,
142,61,84,143,78,179,188,242,58,72,37,241,186,179,135,39,130,69,253,42,65,4,233,
211,123,219,235,199,183,245,150,4,84,122,244,214,154,83,229,212,67,17,210,128,
106,32,73,233,4,0,6,160,57,54,228,49,183,250,214,247,74,224,138,125,189,108,12,
228,245,149,145,116,198,190,84,38,68,10,225,129,253,171,18,193,9,254,166,223,81,
238,226,160,84,55,17,251,58,217,251,15,81,195,166,128,162,67,28,158,95,83,163,
54,150,84,253,35,130,45,102,31,95,207,182,73,205,41,213,128,253,157,63,98,234,
37,112,226,160,188,144,169,242,66,21,244,194,28,72,169,60,154,44,65,153,144,
129,253,61,232,128,65,4,117,226,105,211,141,76,212,115,68,34,122,136,212,79,33,
120,163,158,51,225,134,82,169,168,250,47,164,48,60,130,57,63,159,108,48,42,216,
248,125,122,216,224,40,58,134,184,88,12,51,85,32,148,65,20,176,52,242,13,58,152,
72,204,129,34,83,112,46,84,216,218,214,246,226,48,173,27,129,234,173,95,33,212,
86,165,154,25,74,194,146,8,217,229,72,227,158,209,75,32,98,24,130,1,23,189,197,
143,210,222,223,166,69,56,117,160,107,147,199,169,137,146,84,129,162,170,133,
154,80,241,170,77,172,47,141,23,86,165,0,175,47,167,141,87,231,221,193,227,81,
195,175,83,53,7,29,112,74,152,230,95,77,59,121,29,136,26,89,68,100,16,53,93,127,
85,203,115,127,117,214,0,52,29,120,2,15,203,174,235,96,117,49,211,204,138,22,
65,19,197,165,133,252,100,92,51,139,7,67,99,249,246,202,154,240,29,88,127,62,
162,71,142,47,50,136,99,151,198,92,122,192,44,172,52,223,158,53,3,168,17,249,
250,255,0,135,183,48,40,107,214,181,113,175,89,230,199,213,249,89,126,198,93,74,
225,69,138,198,231,81,44,10,70,205,169,245,15,160,254,158,234,87,87,14,61,120,
50,249,30,184,12,92,242,205,20,94,9,21,216,29,74,241,232,96,5,205,218,223,218,
10,63,167,182,143,96,36,215,175,84,30,7,172,109,73,91,69,82,96,146,25,35,115,
24,116,5,73,45,19,234,245,34,145,201,107,27,123,218,184,160,58,186,243,105,53,
245,233,87,65,143,202,71,16,168,72,82,36,154,18,86,70,212,210,50,178,144,10,44,
55,96,225,65,189,200,60,219,219,5,212,154,100,158,170,66,143,62,165,211,210,87,
84,233,84,164,169,156,201,39,134,208,199,33,119,112,128,164,49,162,234,213,168,
115,111,246,254,238,26,58,119,32,31,103,77,145,164,255,0,105,251,122,114,56,138,
169,160,121,77,51,71,226,151,76,158,98,144,51,150,86,44,223,186,201,202,233,229,
64,60,251,178,205,18,118,130,116,253,156,63,207,213,29,93,205,113,94,158,182,
165,110,250,235,157,219,181,187,3,97,101,51,155,55,122,108,188,222,43,116,237,
61,213,183,235,90,147,47,129,220,88,106,216,50,56,172,166,58,182,25,4,144,86,
81,85,64,146,33,79,200,177,184,184,246,196,166,25,21,213,142,165,110,61,57,27,
56,211,234,58,89,111,186,173,207,216,27,203,113,118,46,238,74,21,220,123,219,
57,95,186,179,181,212,116,116,20,116,181,153,252,196,242,214,101,114,13,71,74,
77,45,26,215,100,39,105,158,20,84,80,238,218,84,45,128,102,38,72,81,34,65,216,
162,128,31,79,47,217,235,215,139,135,36,19,86,60,122,193,131,198,211,83,86,136,
170,41,168,100,154,40,165,148,136,132,89,2,179,198,145,151,149,52,25,35,140,43,
183,169,28,18,63,32,143,106,4,216,3,252,29,52,224,157,76,9,211,138,121,87,161,
86,146,178,154,154,136,154,138,117,170,138,188,85,211,69,9,72,167,158,178,161,
233,161,105,86,120,164,93,49,64,177,58,41,123,37,146,225,71,182,100,39,12,51,94,
155,10,9,211,170,132,126,93,6,185,92,222,98,133,240,153,44,85,69,94,31,53,138,
174,134,179,17,93,139,169,151,23,95,141,200,208,84,172,216,250,170,26,218,105,
41,231,163,169,161,158,37,146,41,17,213,149,208,50,155,216,251,122,53,214,180,
127,128,224,215,133,15,203,167,64,68,96,17,179,252,250,125,219,91,79,39,150,158,
44,245,101,100,117,121,220,197,109,110,91,47,144,202,84,60,145,101,235,107,89,
167,148,138,197,41,39,220,71,41,18,206,236,89,164,149,141,175,207,181,90,210,52,
84,11,145,138,99,253,94,125,108,18,229,152,55,67,157,69,93,92,117,82,83,154,6,
134,124,150,44,197,4,149,213,113,213,10,122,225,3,211,35,67,89,75,27,220,144,61,
50,62,132,100,212,53,234,0,123,44,186,102,89,152,166,84,208,254,71,253,95,62,
149,219,170,180,106,27,136,168,63,151,14,149,27,86,40,106,54,180,213,117,129,36,
172,167,163,147,31,73,20,101,227,200,82,78,210,23,172,104,166,91,172,152,249,34,
13,195,29,108,120,0,31,106,209,127,196,221,241,242,253,185,63,179,162,249,78,
155,208,167,25,207,236,233,91,65,152,170,135,25,21,4,241,212,189,161,137,218,74,
64,209,78,29,67,186,69,10,21,104,249,210,29,142,190,116,155,139,251,81,99,54,
128,237,192,1,231,213,47,99,241,10,26,142,150,180,91,138,13,195,75,21,28,212,
173,21,107,205,76,25,229,62,8,165,83,29,164,50,71,40,140,35,200,170,77,148,178,
155,91,159,102,47,114,146,96,156,244,90,182,230,50,79,149,56,117,146,60,102,30,
174,162,154,116,167,161,150,86,172,147,90,172,139,205,174,94,54,51,50,198,10,31,
234,62,167,139,251,164,76,189,172,105,215,152,184,170,230,157,42,246,221,61,4,
251,142,151,30,248,165,138,10,116,166,144,79,28,96,63,220,83,212,73,233,50,42,0,
202,200,252,88,233,227,158,125,172,183,156,73,44,104,169,219,211,82,163,44,108,
197,179,215,166,163,170,166,171,122,144,74,75,85,186,37,49,78,4,106,3,60,235,28,
94,118,107,21,137,214,67,168,253,13,192,246,100,160,174,88,113,61,37,108,128,
163,210,189,47,179,24,202,185,43,77,57,138,22,18,192,36,122,195,84,41,233,224,
48,179,1,28,186,144,0,236,77,142,146,64,91,145,244,191,189,74,94,160,41,167,
207,166,147,77,27,31,151,74,250,176,152,189,177,151,161,153,191,124,38,26,138,
26,154,122,71,154,147,33,45,84,205,63,219,209,201,28,70,5,145,68,223,169,153,
90,196,27,145,238,223,232,103,215,166,213,65,145,13,49,83,95,151,249,105,208,
15,179,115,219,19,162,62,83,124,113,249,7,220,93,111,186,59,39,172,186,151,183,
118,166,248,221,251,75,1,95,30,43,55,150,163,219,85,176,215,83,189,29,115,44,94,
74,172,93,101,36,53,8,142,233,5,72,136,66,210,32,147,87,178,45,226,210,91,139,
71,137,7,115,122,249,138,247,10,208,211,80,168,174,105,90,244,125,182,220,71,
28,149,36,105,235,233,199,241,87,249,128,252,36,254,102,125,95,185,41,126,56,
119,142,7,122,156,222,206,200,80,111,93,133,21,114,237,190,220,216,248,221,195,
67,38,34,187,251,193,179,50,90,51,152,106,138,51,95,227,21,105,20,244,66,114,
186,38,123,173,201,26,72,238,22,75,73,3,71,35,169,5,72,161,165,40,116,156,171,
83,213,73,29,8,6,40,234,65,3,173,27,62,92,255,0,194,69,126,116,245,30,246,221,
249,255,0,134,187,251,175,190,66,117,124,210,215,101,246,238,27,118,238,24,186,
247,182,40,233,217,229,168,24,124,133,54,78,156,237,92,206,90,37,1,22,170,158,
190,157,106,238,9,138,35,117,247,120,238,46,96,26,37,183,46,0,248,146,148,63,
237,73,4,31,144,213,242,62,93,52,240,163,240,106,125,191,234,255,0,55,68,163,
107,127,194,114,63,156,30,238,206,237,122,94,200,248,193,153,219,251,42,73,214,
92,246,67,3,216,61,73,144,221,88,236,106,134,18,38,63,23,150,222,148,56,249,
242,76,229,116,199,44,209,173,137,55,226,222,253,113,184,200,99,62,13,180,141,
37,49,85,32,126,103,203,173,37,170,171,84,176,211,246,142,175,107,226,191,242,
80,248,79,240,226,131,251,211,242,139,225,108,253,155,187,170,84,71,22,83,231,
79,204,223,140,221,123,180,40,165,136,121,164,172,193,117,182,206,207,85,97,
205,42,186,149,103,200,207,93,48,81,194,11,92,144,201,127,124,90,151,17,15,244,
162,81,23,253,14,127,109,62,93,43,88,163,92,131,249,210,191,236,116,227,220,95,
240,162,222,151,254,94,171,63,91,124,102,248,107,240,84,53,17,172,199,80,98,126,
54,247,182,47,120,226,224,90,103,11,11,231,171,250,191,167,48,216,120,254,228,
60,108,35,254,33,59,144,172,11,130,163,219,246,141,115,35,147,21,146,68,223,
196,202,73,63,99,22,5,186,211,148,3,47,95,176,245,175,223,201,31,248,82,31,243,
127,249,41,187,51,153,29,161,223,143,241,171,102,215,215,79,62,23,174,186,103,
15,131,195,203,131,198,74,162,40,232,142,241,201,226,106,247,134,93,162,80,72,
158,74,149,98,205,168,5,176,177,160,179,102,4,205,60,142,223,38,40,63,32,164,99,
237,39,237,233,131,50,131,128,0,253,189,86,247,96,252,204,249,251,222,80,84,55,
107,124,203,249,53,189,17,36,142,63,182,204,119,14,250,106,9,229,145,204,70,149,
104,232,243,84,244,87,185,212,84,160,95,246,39,141,166,223,110,94,141,108,167,
253,48,212,127,227,85,61,82,75,146,22,161,191,103,251,29,19,76,158,7,34,119,28,
217,29,201,95,95,155,173,172,168,21,57,60,134,94,178,122,220,213,83,202,171,11,
84,85,86,213,61,68,213,44,108,23,247,29,137,250,92,113,237,233,71,132,186,99,
74,45,49,78,31,179,170,36,158,40,36,158,238,148,123,163,106,224,106,3,73,139,
169,242,107,142,57,41,227,241,180,34,164,187,40,172,71,41,8,88,158,150,67,163,
80,186,7,191,36,123,98,55,103,52,166,105,214,181,180,121,110,21,233,130,93,191,
138,161,122,117,158,155,56,148,169,29,55,220,133,142,150,74,134,11,121,42,4,117,
162,56,227,130,88,217,236,21,253,12,160,94,78,44,23,34,146,149,97,211,63,80,88,
144,164,87,63,234,167,26,116,159,200,212,193,77,37,66,208,99,96,175,4,172,230,
178,173,222,101,74,70,101,146,158,157,98,66,18,25,204,63,231,65,109,55,22,91,
139,251,221,78,154,10,14,174,160,154,119,145,242,249,245,2,162,150,26,139,213,
71,81,3,79,60,66,185,49,148,240,17,60,52,242,74,202,176,60,113,169,67,37,61,
181,50,32,244,199,203,90,254,246,78,154,246,144,122,240,12,13,43,219,235,254,
175,95,248,174,156,160,196,4,88,36,200,175,130,40,229,132,16,182,146,66,36,79,
72,145,162,14,69,212,222,194,236,63,195,221,117,171,119,10,245,77,76,11,5,61,
199,253,94,125,60,13,189,142,172,57,81,72,201,4,176,76,169,13,40,168,169,181,76,
87,105,94,88,86,176,201,60,140,176,173,216,88,173,185,189,189,182,211,198,69,
64,207,219,214,193,117,41,168,96,143,79,243,127,151,169,216,184,227,18,176,135,
16,149,56,223,52,43,84,18,8,99,171,95,5,52,172,166,142,162,173,180,7,99,45,220,
114,28,113,96,72,246,157,238,52,157,41,65,138,244,239,135,81,83,134,207,73,90,
250,76,171,84,120,150,158,8,130,163,57,154,74,127,21,59,198,5,204,118,136,170,
153,142,142,87,245,126,61,236,220,212,18,95,173,170,168,60,122,234,60,93,60,20,
181,6,182,162,25,42,204,113,204,32,162,138,65,34,164,188,34,204,42,25,211,200,
164,92,132,189,133,175,237,150,119,36,21,67,167,231,195,171,3,195,211,172,81,
213,83,208,68,82,39,214,35,46,172,37,85,188,151,185,34,71,93,55,35,241,244,3,
222,188,38,102,37,136,255,0,87,167,78,86,180,20,207,73,204,214,86,167,51,80,158,
87,30,40,33,72,224,140,133,9,24,66,66,199,24,91,151,84,191,4,253,79,39,218,136,
162,17,253,167,173,158,167,208,197,20,75,12,174,178,248,66,49,104,203,136,220,
13,5,75,106,6,246,102,110,71,228,113,237,90,198,72,169,199,76,177,36,211,207,
172,245,84,162,149,208,8,2,202,202,179,73,42,176,116,149,29,99,113,23,12,209,
217,18,214,81,234,7,235,253,61,216,174,144,2,241,234,160,215,53,199,77,117,104,
124,254,41,213,22,86,141,88,148,244,186,106,37,148,1,96,21,194,158,87,221,92,
210,128,140,245,112,222,157,102,153,106,60,210,16,60,204,99,141,174,127,87,160,
47,215,157,55,54,231,219,170,226,180,25,61,104,50,211,141,58,106,89,22,26,201,
140,138,76,100,49,58,64,4,51,141,92,125,87,70,177,254,60,123,161,97,154,30,156,
242,227,212,234,91,84,207,27,72,52,198,46,25,172,2,254,155,160,28,216,128,127,
175,227,218,119,145,136,32,100,129,255,0,21,214,248,12,244,247,4,76,103,130,64,
201,21,134,129,168,144,171,16,30,162,45,245,36,155,145,110,7,182,0,36,233,99,
159,242,245,73,36,0,26,10,244,144,169,211,44,215,28,153,37,144,223,155,149,212,
89,65,60,223,74,127,175,237,101,52,0,213,207,94,4,233,32,250,117,138,24,25,72,
184,7,86,171,40,39,250,241,200,255,0,15,123,215,168,208,117,224,5,58,117,165,
141,146,84,109,63,230,209,154,223,81,207,230,223,155,159,104,165,118,36,142,157,
90,82,189,70,200,213,150,112,151,40,94,49,229,32,15,80,212,52,167,28,219,211,
249,246,228,40,27,36,112,63,207,173,181,49,231,212,45,109,33,102,181,148,146,84,
31,246,215,255,0,92,251,127,73,161,33,129,233,179,246,117,216,114,173,127,213,
107,129,114,77,136,228,91,243,239,65,73,242,234,190,68,30,61,102,136,201,58,248,
227,86,118,214,79,22,94,0,231,159,167,22,189,189,185,85,74,250,245,234,143,62,
29,59,210,208,95,66,202,218,93,197,208,14,87,147,99,173,185,10,5,249,63,129,
237,183,98,70,120,117,77,92,72,25,235,45,85,44,49,184,137,8,18,196,88,204,228,
16,178,233,28,132,176,54,176,63,83,201,252,254,61,182,164,156,158,29,108,87,29,
65,121,52,71,203,70,240,202,75,17,168,249,88,168,33,52,32,30,132,39,234,88,222,
227,221,180,146,126,99,171,99,141,61,58,135,85,81,35,172,74,73,210,177,139,18,
75,55,7,242,65,3,146,57,252,255,0,95,110,120,100,122,3,214,199,92,37,125,77,25,
18,185,58,52,149,4,232,94,73,98,135,253,83,19,107,254,7,189,162,138,215,203,
175,112,29,72,167,80,204,100,109,69,236,165,91,245,1,233,80,13,143,3,143,110,
144,107,195,61,87,143,82,28,216,202,210,104,4,74,170,218,151,212,197,185,32,94,
196,22,45,207,189,159,60,231,175,113,166,15,81,97,157,76,159,230,253,40,174,158,
162,13,238,215,30,49,254,164,18,47,253,61,232,28,240,235,100,84,96,211,61,101,
214,193,203,149,0,50,250,110,194,204,3,5,36,92,90,192,15,160,247,186,245,175,83,
215,255,213,208,150,41,99,103,0,48,28,31,175,228,251,241,21,166,58,247,82,164,
177,107,27,122,85,65,227,252,63,175,248,127,135,182,232,107,198,157,120,117,22,
83,173,130,253,2,1,199,248,142,69,238,127,161,246,226,150,245,175,85,225,214,
54,141,70,183,99,164,122,74,168,224,243,245,183,248,123,246,190,183,94,29,112,
136,146,228,223,129,168,130,198,199,252,15,244,23,246,234,176,28,113,214,136,
168,235,52,82,40,213,170,53,114,207,232,123,183,161,135,210,214,60,134,191,231,
219,149,21,234,153,234,84,40,210,137,214,193,157,46,130,57,52,149,185,63,171,85,
192,102,0,31,234,69,253,215,78,165,63,46,173,93,52,245,234,12,177,72,132,189,
218,202,202,27,242,20,155,144,3,2,65,227,250,113,237,128,160,121,116,240,112,69,
58,192,229,163,210,44,108,88,176,250,242,183,176,181,141,184,31,239,126,246,84,
83,35,173,86,159,62,157,113,51,198,147,32,146,95,31,146,69,66,197,4,129,71,224,
233,6,246,254,182,250,123,79,42,96,209,124,186,245,104,120,99,169,181,208,125,
197,98,4,180,132,69,228,112,140,12,65,88,145,117,213,96,44,125,178,140,66,147,
92,127,62,189,243,235,20,148,48,164,114,22,157,210,224,105,180,62,68,46,64,58,
60,129,192,189,190,182,189,191,167,189,137,91,24,169,235,84,225,212,18,137,5,
98,71,51,153,34,67,22,179,19,250,77,192,98,1,77,92,0,121,181,172,111,237,245,
144,178,87,204,245,230,2,164,99,174,117,18,164,250,86,40,163,137,53,159,243,74,
192,178,143,160,115,35,22,44,191,227,111,175,187,120,184,166,58,174,145,235,94,
164,211,208,170,135,146,88,102,112,29,144,233,30,130,165,47,167,80,6,215,191,
212,126,61,211,196,30,71,61,110,159,179,172,244,117,105,68,149,169,29,49,97,37,
47,138,197,219,74,59,74,135,202,5,149,131,174,143,175,189,49,147,0,53,9,61,88,
105,243,29,55,73,170,90,115,40,114,87,201,161,239,160,93,153,84,128,46,218,153,
136,31,91,88,123,240,7,87,119,90,173,48,58,114,197,229,30,142,58,250,121,228,37,
38,142,20,33,192,150,34,176,106,40,140,161,139,13,33,142,146,13,129,62,245,36,
108,116,178,241,235,202,71,159,89,102,205,79,85,5,34,72,29,165,166,145,126,222,
75,43,52,84,218,116,164,23,60,184,23,181,207,32,113,238,235,226,41,52,99,78,
181,165,106,77,50,122,195,60,115,203,3,75,44,200,204,210,105,80,218,2,150,82,24,
160,176,227,74,159,175,231,233,237,208,112,107,215,170,188,0,234,12,49,43,181,
149,152,92,13,58,65,39,85,255,0,81,63,128,64,227,223,170,120,117,238,149,177,
193,69,82,33,74,74,106,202,138,187,193,28,160,248,166,51,72,30,228,47,9,162,234,
44,110,8,183,187,196,191,22,161,147,211,110,72,224,113,210,138,58,156,133,6,91,
32,181,84,40,176,65,93,11,78,240,68,60,81,66,23,74,120,160,141,137,68,184,181,
215,131,248,62,221,197,72,211,142,153,210,25,20,234,205,58,113,201,57,154,72,
242,205,20,177,48,104,146,33,97,28,234,136,150,211,32,50,134,10,100,36,49,225,
173,110,63,62,247,90,128,124,186,170,138,18,157,103,160,168,120,178,84,242,59,
83,169,145,93,17,216,133,49,133,133,140,175,27,125,108,136,226,220,221,141,237,
238,142,154,129,83,192,250,117,234,85,79,30,178,213,99,166,25,26,124,140,242,
211,85,82,182,166,130,72,38,21,55,146,7,119,16,177,136,135,137,237,245,215,109,
35,253,135,180,255,0,78,253,193,88,83,171,107,80,52,128,120,116,187,134,174,
161,49,84,241,96,168,30,183,253,196,61,107,189,45,16,154,40,212,5,138,93,79,80,
218,72,179,217,129,212,85,173,167,232,125,180,45,100,44,106,195,173,81,13,117,
154,26,244,133,92,246,78,65,16,254,32,49,248,202,138,159,184,104,40,21,85,221,
194,104,102,53,79,11,69,20,160,30,4,97,172,15,54,62,220,22,195,26,141,122,177,
211,86,237,207,207,165,116,50,224,40,224,132,213,85,203,83,56,121,153,222,90,
170,137,146,56,25,84,197,168,142,117,181,218,254,147,110,56,3,219,134,217,8,32,
147,252,186,107,83,138,209,113,210,245,242,187,56,99,233,145,177,176,212,191,
138,24,35,171,88,227,89,68,236,190,43,254,212,80,73,35,198,73,107,233,34,192,31,
173,253,182,214,81,99,185,171,246,159,248,174,182,30,74,241,199,217,211,198,225,
147,108,188,170,244,117,94,42,105,5,34,188,30,49,246,142,209,64,215,152,211,180,
87,50,106,39,130,108,5,199,183,13,154,37,15,136,105,211,33,157,190,37,238,255,
0,103,164,245,53,78,49,39,2,54,164,152,162,77,35,189,40,147,30,200,160,34,130,
145,67,50,66,215,84,3,233,172,234,255,0,97,238,173,110,181,173,1,83,233,131,213,
141,106,106,13,122,201,95,147,138,181,100,131,25,37,12,173,85,52,171,37,53,100,
47,247,17,71,80,32,31,228,211,24,233,252,90,252,86,23,37,116,112,121,228,238,
75,120,217,20,70,199,80,28,60,255,0,193,213,99,26,92,51,214,160,227,60,126,95,
234,255,0,63,72,188,212,50,83,77,183,34,173,146,41,86,90,106,184,213,2,184,104,
102,30,67,75,20,239,35,122,138,48,28,128,20,40,227,233,238,145,192,202,42,64,
227,211,188,73,53,207,75,204,61,116,148,56,244,149,234,225,158,64,39,180,201,81,
122,147,33,82,10,210,211,29,81,196,21,152,149,212,2,200,126,158,237,37,163,0,90,
149,63,47,159,175,217,211,97,244,182,129,90,30,148,213,251,202,157,37,69,135,
199,36,144,83,66,38,170,243,125,156,130,146,10,115,43,200,208,79,20,145,212,3,
102,1,45,193,99,127,233,237,12,182,145,49,26,218,134,158,98,191,224,255,0,99,
165,49,75,34,212,138,245,207,7,190,150,68,164,90,74,216,4,149,79,20,35,214,61,
104,2,163,198,207,164,42,112,53,95,243,110,57,22,247,113,3,4,209,28,189,188,56,
211,207,231,142,61,54,228,235,214,203,220,15,75,234,78,217,167,193,67,146,199,
228,106,222,190,58,181,150,26,56,103,145,1,103,167,104,66,129,16,83,228,96,233,
164,139,171,88,240,121,230,209,9,32,5,100,90,169,193,255,0,139,225,214,165,83,
49,70,92,83,252,189,56,227,187,39,22,178,203,77,148,197,84,237,252,157,29,63,
220,211,205,83,79,61,29,76,65,98,11,64,103,130,165,11,178,207,19,45,143,8,192,2,
182,63,91,135,6,133,41,74,241,29,50,208,200,158,100,252,143,78,184,238,228,197,
208,37,57,171,142,153,234,36,169,119,150,117,64,35,169,118,213,25,114,84,27,106,
40,108,172,71,214,252,143,102,17,206,186,16,48,207,76,27,118,98,74,240,244,243,
232,107,218,61,149,139,121,254,242,124,164,49,70,97,136,210,210,227,207,155,84,
128,201,51,153,221,131,194,88,182,136,212,91,64,230,226,194,225,125,172,209,199,
146,212,3,211,164,115,219,177,175,111,119,169,233,68,253,141,182,234,27,59,73,
38,46,58,121,32,74,68,53,31,116,60,233,51,213,44,146,66,84,137,34,121,22,196,
51,35,21,109,39,133,191,10,222,245,52,149,85,201,233,133,181,144,21,98,216,31,
46,132,250,237,229,183,50,11,75,76,23,29,52,83,80,52,115,213,181,82,83,84,58,
200,154,156,50,72,174,36,86,86,33,52,155,128,109,123,251,208,184,47,64,105,211,
70,2,149,34,181,175,219,211,220,121,156,20,187,75,53,139,20,18,73,138,167,202,
83,87,193,170,71,151,40,180,49,10,68,168,163,199,136,146,63,216,103,5,3,49,18,
20,28,1,96,197,68,44,26,55,90,98,191,234,167,77,52,82,9,85,245,119,83,249,252,
250,9,59,10,175,19,151,161,198,67,21,6,68,195,37,52,152,197,30,106,121,96,209,
36,100,203,72,145,84,104,118,90,101,81,121,88,21,12,0,191,245,164,165,77,5,13,
58,81,10,233,36,177,21,227,209,72,195,110,221,239,208,59,210,30,204,232,94,212,
222,29,59,217,20,112,174,58,135,116,117,150,229,201,237,28,215,142,161,210,74,
202,41,235,48,117,112,181,93,60,254,52,242,195,49,104,36,120,129,101,58,87,217,
61,221,173,188,232,22,88,193,161,199,200,252,188,193,167,152,232,226,222,121,
83,131,26,127,147,254,47,163,199,142,254,126,95,206,47,3,134,165,193,167,206,
77,229,89,13,37,58,69,29,126,95,102,117,190,95,57,57,142,233,254,83,151,170,
217,179,86,85,189,151,213,35,187,59,126,162,121,246,95,251,182,46,2,89,64,255,0,
154,143,254,122,244,191,234,159,248,71,236,29,2,253,183,252,222,191,154,215,118,
227,231,194,239,143,158,221,235,30,15,44,139,79,95,135,218,123,134,147,96,82,77,
27,144,186,93,118,38,59,110,214,36,110,160,234,26,200,185,247,227,182,218,154,
120,154,156,122,51,51,15,216,73,31,203,173,125,84,153,160,3,236,3,162,35,81,183,
178,91,203,45,62,95,125,238,204,230,245,203,75,36,134,92,174,237,205,228,183,21,
108,211,144,166,83,45,94,110,186,170,173,217,139,92,177,112,228,255,0,83,237,68,
118,240,196,8,138,53,81,232,0,29,50,215,14,199,53,233,219,31,133,218,120,100,
169,90,147,64,106,35,82,169,26,211,200,209,168,34,220,90,80,198,48,220,234,213,
96,71,55,247,166,64,8,175,14,173,169,243,65,211,46,229,160,219,181,211,211,203,
72,41,228,156,201,77,75,226,166,38,25,67,47,12,201,42,202,226,45,36,139,234,
244,31,168,30,236,10,163,145,213,70,166,90,240,227,212,252,57,198,225,77,79,222,
213,181,84,116,190,25,96,19,24,76,130,83,32,69,142,95,16,9,50,192,36,96,93,135,
32,139,183,183,196,170,5,56,244,203,198,236,1,76,26,245,195,37,154,195,84,23,
106,127,225,198,40,220,44,138,154,3,120,135,170,122,70,96,165,163,44,182,40,125,
55,255,0,90,222,211,79,4,76,25,133,71,217,254,110,157,133,229,80,22,181,63,49,
208,91,157,135,111,181,47,146,150,174,142,149,155,32,254,104,234,35,9,60,235,83,
35,79,12,136,97,99,161,82,70,58,152,217,120,4,243,237,34,70,241,150,33,133,63,
159,86,118,98,192,50,183,15,46,29,54,205,61,92,141,68,241,229,164,167,88,162,
145,99,87,49,52,115,199,251,139,35,42,187,176,184,127,208,195,65,97,254,195,219,
139,33,101,1,152,233,213,192,121,127,170,189,108,68,23,85,16,86,128,215,207,166,
90,218,234,40,158,161,234,98,240,75,58,139,100,41,105,226,142,34,218,84,8,229,
240,13,50,49,253,90,236,73,32,143,175,214,218,211,81,94,62,125,89,99,96,21,148,
158,28,9,255,0,7,73,122,220,150,66,170,178,170,154,134,74,90,74,65,76,98,154,
191,192,144,101,170,80,59,19,33,109,102,70,187,56,22,1,117,1,98,61,213,216,58,
128,64,167,250,184,245,101,141,5,25,171,171,200,121,15,179,174,53,79,34,67,2,
205,35,212,170,72,25,96,168,96,139,6,165,208,242,70,137,171,196,100,91,106,189,
201,62,209,171,178,181,1,161,233,78,144,213,97,76,244,166,199,85,97,210,87,154,
60,120,168,168,120,145,124,141,61,133,42,24,136,146,37,148,130,204,174,81,69,
236,6,129,237,137,163,158,92,71,38,154,127,51,235,214,226,109,32,235,21,7,252,
30,67,167,188,118,78,8,171,100,168,174,20,80,193,0,73,108,103,101,133,37,113,
164,45,195,23,146,55,141,77,197,143,251,199,191,60,78,241,106,215,71,225,65,211,
98,139,219,164,211,231,210,110,179,122,210,66,218,113,85,17,161,88,164,21,76,
117,23,119,145,244,217,53,199,167,198,73,224,1,115,193,246,228,54,237,128,234,
116,252,250,211,160,38,167,143,72,41,243,114,180,142,170,165,200,98,88,162,248,
158,82,199,81,103,114,53,95,159,162,129,237,81,140,250,127,155,173,128,180,201,
233,156,37,85,84,143,193,80,206,61,32,221,1,0,112,71,246,143,183,86,49,81,235,
213,137,3,52,233,242,150,130,8,226,150,66,178,154,149,42,16,135,68,137,227,36,
44,145,221,236,76,142,126,128,115,111,111,5,0,140,103,170,22,175,30,29,40,84,
26,26,90,70,146,149,166,104,235,31,196,2,21,132,161,65,120,229,152,6,89,132,
146,16,56,224,55,231,218,128,104,160,211,166,13,25,219,186,130,157,52,203,90,
254,73,94,58,71,162,142,23,208,85,25,191,106,170,70,4,235,46,13,223,80,224,88,
125,61,179,169,191,134,130,191,207,167,2,103,57,175,80,43,105,43,37,142,146,161,
145,94,158,77,98,105,162,100,150,105,100,86,12,198,161,82,67,49,46,72,177,32,27,
94,227,143,109,30,218,159,63,245,103,173,168,227,198,189,112,46,99,121,233,231,
134,169,106,196,81,133,86,109,12,146,161,228,49,31,90,121,33,245,6,177,35,241,
199,62,235,80,60,184,245,106,112,167,14,153,141,52,199,81,85,253,176,201,119,34,
201,169,136,10,3,92,107,185,63,65,123,126,109,239,117,26,75,31,78,156,28,64,243,
233,77,136,162,134,35,59,213,187,1,4,74,241,197,97,251,172,236,163,159,167,210,
252,45,133,253,167,44,105,80,50,221,86,66,112,41,215,178,149,220,25,174,3,50,60,
49,17,250,144,178,89,180,5,181,180,165,249,177,185,62,223,130,50,115,232,49,
211,69,64,199,73,41,21,237,15,246,84,37,201,82,1,250,11,130,62,162,227,219,173,
219,166,185,199,78,47,157,120,244,227,71,17,98,2,176,1,20,95,158,69,222,223,78,
125,64,31,117,80,197,88,254,19,95,183,175,18,53,83,165,20,116,69,38,97,192,11,
28,136,88,15,237,42,139,242,62,130,254,203,165,174,172,113,233,213,108,3,199,
164,125,116,46,106,202,220,27,5,254,159,66,79,252,71,62,215,91,142,202,158,61,
85,207,19,229,215,71,253,72,252,27,113,199,22,176,191,215,222,215,80,171,87,4,
245,95,32,58,152,180,19,31,19,50,216,49,107,142,117,160,22,32,176,32,91,88,250,
123,243,62,8,83,142,171,210,207,29,130,154,28,108,85,211,120,168,40,217,100,97,
87,85,96,38,63,79,29,44,74,90,122,137,9,28,128,7,245,36,14,125,167,50,85,138,
140,158,170,120,211,53,233,59,85,92,34,2,40,63,110,21,55,14,232,60,206,214,228,
150,83,109,38,252,40,224,3,249,62,212,170,212,2,120,211,175,1,196,252,250,101,
122,233,92,57,50,17,173,181,51,19,201,35,139,255,0,91,145,245,254,190,246,16,10,
215,135,87,160,199,175,81,90,64,109,110,73,28,147,249,55,189,254,191,95,119,56,
4,124,186,181,43,158,178,152,222,66,117,58,170,198,5,201,54,22,250,255,0,200,
94,246,213,56,175,90,31,46,29,112,16,159,65,31,67,99,123,240,111,115,248,185,
184,183,189,85,141,61,122,216,20,233,210,145,4,127,185,44,161,201,141,66,1,169,
201,10,255,0,166,223,69,224,145,207,251,207,191,83,52,62,157,104,159,150,58,145,
80,169,40,168,245,16,76,209,147,170,237,33,214,160,6,107,89,88,49,22,255,0,2,
125,220,224,84,210,157,84,103,236,234,14,151,134,79,19,37,152,48,44,44,46,3,0,
71,250,235,192,252,251,216,195,3,229,215,188,248,99,174,193,118,114,250,197,
144,92,220,1,193,32,105,84,34,204,61,92,129,248,247,234,103,135,94,174,15,167,
95,255,214,208,72,196,53,3,234,255,0,27,94,227,254,53,239,100,17,131,215,186,
202,178,201,25,96,178,183,211,133,123,50,144,5,200,36,216,251,215,94,235,198,
114,5,217,46,88,147,169,126,159,95,202,253,120,247,238,2,157,123,172,138,230,87,
212,204,61,42,13,219,139,14,64,224,143,126,167,144,235,95,103,92,163,208,207,
102,30,148,33,158,214,36,128,65,176,250,91,252,61,248,212,231,175,127,135,167,4,
17,178,144,143,250,128,4,149,32,143,87,208,128,15,43,111,197,189,250,180,234,
164,154,228,117,146,56,28,211,76,197,86,162,50,228,149,14,209,149,144,233,85,
144,129,98,196,47,208,127,183,247,117,122,10,83,173,154,84,87,7,172,10,146,152,
30,49,15,26,163,87,210,204,92,107,37,163,70,94,64,212,77,215,252,125,239,4,96,
127,171,231,215,188,248,245,146,166,155,195,80,81,146,104,226,26,4,111,42,232,
58,89,3,2,195,158,111,127,167,189,184,53,3,175,3,81,214,40,233,94,105,145,96,6,
94,89,65,141,66,234,32,19,113,171,235,113,237,170,121,117,179,195,29,70,51,206,
133,161,14,193,72,82,209,144,8,44,172,109,98,121,58,77,253,212,162,150,169,25,
235,99,172,190,105,228,210,141,35,120,214,66,218,111,120,213,216,45,216,175,28,
219,243,199,189,24,211,38,157,106,164,140,117,212,104,60,172,211,57,8,93,3,148,
81,228,42,0,98,20,125,1,42,120,247,82,128,45,19,175,3,242,234,105,168,167,128,
50,197,79,169,62,230,241,201,49,85,144,162,155,216,128,9,185,7,252,71,182,188,
38,57,39,203,171,146,56,14,185,174,98,104,146,69,210,52,180,215,54,31,65,207,
162,205,201,22,247,177,0,198,115,78,189,90,226,157,102,164,203,121,133,79,160,
126,236,108,183,85,228,13,74,84,114,62,138,71,186,152,159,183,186,180,234,188,
60,250,203,60,148,109,72,129,84,52,218,137,245,35,6,79,74,220,223,141,68,183,
244,184,247,101,14,27,63,15,91,199,175,81,169,168,22,163,202,160,170,89,163,45,
233,33,128,60,27,144,108,183,183,3,243,238,228,149,167,175,94,234,101,70,46,158,
9,21,53,186,16,209,173,220,134,80,218,65,43,112,163,81,31,158,109,237,216,205,
86,173,199,170,159,42,116,224,180,144,54,62,105,4,134,103,51,48,240,65,19,30,3,
34,177,86,182,139,145,245,231,222,203,102,154,104,58,213,49,90,227,172,113,83,
67,225,105,106,218,84,9,32,133,41,210,63,28,128,34,23,242,153,92,216,233,54,22,
32,241,127,110,4,0,85,186,214,163,80,7,14,166,137,227,19,83,173,1,154,103,38,
38,21,50,249,94,117,176,240,186,41,138,64,68,42,167,146,109,111,245,189,221,
104,41,219,213,104,105,158,156,199,249,40,204,65,49,143,199,104,152,36,80,183,
154,208,203,112,18,109,101,162,65,170,192,31,72,39,233,239,101,135,175,90,226,
84,140,244,203,91,154,142,146,166,53,88,230,141,2,43,17,59,29,76,205,114,100,
212,66,249,216,173,134,166,4,144,7,182,234,41,158,61,95,36,116,225,137,204,81,
79,81,73,53,75,59,50,20,77,11,114,174,110,125,62,160,218,253,3,158,127,195,222,
153,141,42,56,245,170,121,80,116,57,96,171,224,206,50,65,85,87,20,20,148,181,66,
127,225,241,194,208,234,51,21,133,252,69,109,17,15,2,105,101,117,35,79,210,222,
253,28,178,57,96,212,167,76,73,26,168,192,201,232,110,171,198,225,99,199,86,255,
0,15,167,166,128,67,66,237,0,89,26,56,41,98,84,120,196,112,198,205,50,207,26,
186,174,171,220,6,3,252,125,188,75,16,5,6,174,153,81,66,13,107,254,127,242,116,
126,186,223,173,127,148,119,70,127,47,174,168,239,63,154,248,158,225,239,63,148,
125,223,219,187,251,29,183,122,119,227,167,122,237,173,139,151,235,126,155,219,
111,14,30,159,123,111,106,26,253,185,185,168,49,217,122,156,230,62,170,90,74,
106,180,18,228,35,170,130,194,40,209,228,246,76,247,23,82,220,77,28,44,65,83,
242,11,192,100,146,140,73,36,144,0,166,20,159,74,152,162,70,17,73,0,215,253,94,
189,90,95,205,143,229,91,252,143,62,0,244,127,195,31,145,125,253,67,252,197,63,
184,191,46,87,5,91,143,219,91,79,123,244,222,99,113,108,28,86,79,107,225,55,133,
117,110,243,70,199,82,211,86,154,44,86,105,11,69,136,158,166,73,25,88,39,58,84,
180,183,55,178,136,60,55,169,116,47,74,1,128,64,193,243,38,181,21,210,41,196,
142,174,82,49,90,140,86,157,3,127,203,247,249,84,255,0,43,143,149,125,191,252,
203,113,41,221,189,253,219,189,57,241,31,108,226,123,243,165,183,215,77,238,173,
155,142,135,125,252,126,220,219,67,47,186,40,246,166,99,23,186,118,140,25,138,
126,219,217,57,76,36,216,218,243,57,164,163,105,213,85,210,50,11,55,154,242,240,
46,166,58,72,141,205,52,228,148,106,112,39,21,12,167,21,161,175,149,58,240,138,
44,138,87,35,207,212,116,78,191,145,255,0,195,127,131,223,204,211,230,239,106,
252,105,238,250,223,144,155,79,21,153,218,123,187,124,252,118,171,219,187,239,
101,226,178,144,225,246,166,65,36,159,111,239,231,254,233,212,190,99,117,54,215,
174,74,161,38,63,195,73,170,146,164,52,69,89,28,42,150,75,176,109,81,229,69,103,
193,32,87,190,149,197,127,13,1,249,214,159,147,72,145,119,209,77,63,201,209,174,
254,82,95,203,23,249,114,252,242,249,65,252,192,58,3,122,228,126,86,237,108,95,
197,236,158,228,221,27,31,125,175,102,245,237,61,61,95,86,236,253,212,219,39,51,
71,187,225,139,96,209,71,253,227,174,203,82,189,114,77,26,37,44,52,39,198,255,
0,185,31,146,68,235,117,121,225,195,36,146,170,171,66,95,3,210,132,131,83,78,
12,63,48,124,186,191,131,17,102,93,38,160,211,162,75,189,243,191,200,38,167,35,
150,167,216,219,19,249,182,28,46,213,203,75,143,220,251,219,23,149,248,215,184,
177,52,216,239,190,151,25,138,201,66,181,210,73,10,80,101,234,163,189,49,168,
154,141,164,12,0,187,122,3,139,38,226,68,100,188,96,176,194,183,31,94,0,12,143,
60,245,67,28,25,162,156,121,142,171,171,177,112,189,125,187,50,217,202,254,151,
27,236,245,206,31,34,231,103,85,118,116,88,52,223,115,96,31,71,217,255,0,122,
99,218,146,214,224,19,46,146,75,164,138,119,241,21,250,31,168,246,115,7,140,
208,39,140,19,198,166,105,90,113,249,231,162,247,40,147,48,90,233,63,183,160,
143,44,51,219,118,25,175,27,6,125,2,254,65,28,161,0,41,164,196,206,175,19,232,
30,158,73,31,82,163,235,239,222,59,194,218,116,224,254,207,179,173,232,87,3,
237,235,102,111,229,77,252,186,255,0,150,7,243,4,254,89,93,245,222,95,34,119,23,
119,117,39,114,124,44,221,219,219,116,247,182,240,234,140,244,121,172,190,103,
168,102,219,45,187,118,181,93,38,199,205,226,115,88,137,149,177,248,172,141,42,
37,28,17,212,189,85,3,179,72,222,125,42,71,112,242,45,197,201,241,72,0,41,85,
210,164,16,123,113,149,58,181,86,164,181,40,69,122,49,137,23,66,213,115,235,254,
170,249,124,186,126,248,209,252,173,63,146,119,243,20,216,223,36,58,135,249,112,
124,165,249,85,184,126,102,236,126,187,171,236,254,158,194,252,128,197,225,182,
94,223,207,199,133,208,103,219,244,88,106,109,183,141,59,139,23,93,93,36,88,
250,234,143,184,134,175,26,245,177,84,132,146,21,109,84,102,186,79,138,161,136,
52,82,170,53,83,36,2,172,221,212,169,25,0,211,210,189,95,76,102,180,253,191,
234,3,170,181,254,66,251,19,188,119,135,243,117,248,251,177,118,196,91,127,110,
100,182,38,230,222,217,62,230,78,199,217,184,141,229,183,48,157,105,178,241,57,
86,237,156,126,230,193,103,89,49,244,213,18,99,105,36,160,130,164,201,20,180,
89,9,33,150,55,214,128,54,239,4,111,109,22,67,43,50,149,175,15,226,36,131,196,
5,4,144,120,129,76,113,235,72,165,92,249,80,103,171,66,255,0,133,106,116,100,
93,125,243,43,164,254,92,117,229,93,38,87,168,254,82,244,150,39,29,139,202,109,
248,232,191,186,231,114,245,120,135,26,240,225,235,40,99,251,89,225,201,237,140,
174,50,176,21,39,80,118,35,143,111,89,180,34,73,150,32,12,46,4,139,65,65,66,52,
154,125,133,65,255,0,109,213,38,82,193,73,29,195,29,14,159,15,55,95,242,179,204,
255,0,34,157,217,243,59,190,127,149,166,199,237,174,192,248,207,191,54,223,65,
246,1,219,123,243,49,180,243,253,173,185,107,226,219,137,75,217,245,219,202,138,
119,203,236,186,106,138,13,203,17,175,132,83,215,15,188,133,204,43,227,144,8,
147,53,86,103,139,83,153,76,130,135,91,40,163,234,97,129,81,218,22,128,80,131,
142,21,61,89,85,116,131,164,80,15,65,229,78,154,162,254,90,191,0,127,152,135,
242,147,239,143,230,27,252,191,58,223,180,190,33,247,15,66,228,55,254,107,57,
213,27,195,184,114,157,183,179,43,104,58,147,1,77,186,55,102,215,142,191,55,75,
71,37,52,121,205,157,92,181,248,250,216,227,134,120,235,97,88,37,140,199,33,
112,242,77,113,1,144,180,140,66,48,12,13,8,33,169,220,8,85,53,21,200,53,224,71,
152,34,166,56,221,71,96,169,232,0,233,255,0,129,159,7,119,231,242,24,170,254,97,
185,12,39,202,13,231,242,95,111,118,85,79,87,238,28,23,94,246,70,35,30,185,237,
255,0,147,223,180,91,51,109,96,112,219,106,179,99,110,140,106,237,167,166,221,
24,218,198,72,232,234,50,179,184,146,40,230,93,107,163,211,93,93,36,146,82,224,
41,18,133,161,3,72,82,186,181,28,6,173,43,248,169,81,192,117,161,12,90,127,179,
205,63,63,78,133,190,183,254,87,223,13,126,3,252,54,219,95,33,191,157,23,105,
119,14,208,249,15,218,205,46,67,168,254,35,245,6,242,219,11,218,213,27,98,72,
105,6,35,31,151,219,217,12,12,255,0,99,157,51,249,101,202,84,85,213,193,139,197,
163,44,50,202,42,131,65,237,255,0,171,187,154,109,16,53,1,166,145,164,86,158,
108,245,248,20,249,84,106,52,52,4,227,166,154,222,221,35,45,34,253,191,230,30,
167,249,117,95,85,237,178,115,91,195,116,212,244,222,43,176,176,253,61,144,220,
158,125,131,139,223,149,184,92,166,245,199,109,169,25,14,54,13,207,85,134,88,
241,21,249,136,32,136,121,197,61,162,60,1,200,185,21,216,173,194,65,16,186,32,
205,230,87,135,31,46,30,84,252,250,11,221,60,126,51,152,106,20,112,7,143,65,150,
237,220,29,81,183,247,14,221,147,188,83,179,168,250,146,145,165,155,118,167,82,
197,182,37,236,23,166,69,144,199,77,183,6,236,169,166,219,180,149,117,181,122,
86,73,106,89,163,137,110,218,25,172,11,27,140,147,172,45,244,129,124,106,254,
42,211,231,195,61,40,176,69,121,7,140,73,95,151,31,231,213,242,111,255,0,229,
187,252,137,54,47,242,206,233,223,230,137,216,91,83,231,210,116,215,104,197,182,
232,134,220,218,61,167,178,243,189,131,136,203,238,124,246,99,110,82,201,155,
163,169,160,192,109,209,246,57,108,36,177,202,212,181,26,6,164,210,140,57,246,
23,23,55,111,163,84,172,101,103,101,160,211,64,87,85,115,65,130,22,162,160,156,
244,37,16,192,160,144,157,180,7,207,207,170,218,249,199,252,178,126,14,110,143,
229,213,181,255,0,152,239,242,147,222,189,227,220,221,111,215,251,226,44,119,
202,141,133,217,91,199,111,79,191,250,139,104,125,180,191,117,89,185,118,189,14,
220,139,43,132,174,164,201,181,56,168,168,142,162,166,149,49,245,43,89,15,158,1,
36,145,237,46,174,22,65,28,178,16,13,65,170,138,171,26,104,224,104,85,178,1,
245,162,214,181,3,102,40,138,213,87,253,145,231,249,142,141,71,125,252,42,254,
66,93,61,252,185,190,37,255,0,48,141,231,215,191,63,112,155,99,229,91,81,237,
124,38,209,235,158,214,217,59,159,118,109,173,217,143,161,206,29,203,89,148,143,
124,82,98,112,85,244,24,188,158,220,169,68,120,38,137,106,144,198,233,4,97,138,
171,41,45,235,21,69,149,140,196,181,107,167,72,208,64,36,16,181,161,36,80,28,
250,145,213,180,66,6,162,157,184,254,127,111,85,25,220,187,91,249,53,110,31,134,
253,225,217,159,18,62,69,252,179,217,191,40,122,227,116,236,89,118,143,78,124,
177,198,117,237,49,237,29,165,156,204,166,39,113,255,0,113,164,235,26,108,166,
46,186,179,15,77,82,107,38,106,156,141,61,69,42,81,155,193,34,74,172,175,9,47,
210,104,86,85,170,147,154,12,82,135,58,171,130,8,24,32,2,14,9,53,165,60,56,10,
146,163,171,131,236,95,141,31,202,247,249,64,127,45,47,136,93,187,243,83,226,22,
111,231,239,201,111,155,123,102,13,238,43,233,59,35,120,117,198,208,218,120,140,
222,219,193,111,88,176,248,141,221,139,53,120,253,191,253,218,194,238,44,109,44,
126,44,117,70,67,39,84,245,82,249,18,5,176,99,196,154,225,208,135,106,184,44,6,
173,33,84,26,14,0,150,99,196,131,129,145,233,87,52,170,14,3,246,121,255,0,147,
162,227,243,127,227,215,242,41,220,95,202,202,135,231,183,196,93,209,186,58,47,
228,175,98,174,26,143,101,124,76,168,239,202,61,245,154,195,239,216,55,126,51,1,
190,182,222,75,104,110,90,10,253,215,91,136,218,212,51,84,85,255,0,17,142,74,58,
122,202,52,73,98,1,220,71,239,209,203,112,37,142,49,41,50,7,163,171,10,128,160,
30,224,193,87,4,83,78,175,90,113,7,175,50,71,66,74,142,24,167,175,217,210,255,
0,227,135,192,191,229,149,252,182,190,37,244,79,202,79,231,129,143,237,125,
219,221,191,39,83,59,187,186,99,226,198,203,166,220,73,54,31,174,104,177,116,
177,208,203,191,176,152,124,150,219,47,158,174,92,221,62,66,67,95,146,162,134,
129,234,41,169,202,73,52,115,170,221,167,150,225,202,198,95,65,21,1,52,130,87,
134,162,199,128,99,240,129,146,5,114,9,2,162,52,80,11,1,95,159,248,0,255,0,15,
68,87,228,23,197,143,229,31,219,159,18,119,215,204,255,0,129,157,213,223,219,
25,250,31,188,54,22,222,239,63,139,95,38,183,55,84,226,187,63,116,245,70,242,
205,208,208,84,239,14,152,131,17,95,95,91,151,170,161,90,162,176,198,14,72,164,
113,76,106,99,136,194,134,109,53,205,220,78,32,102,6,70,20,21,3,141,13,13,70,8,
168,163,138,2,42,15,14,182,35,137,134,160,48,56,255,0,171,252,29,88,191,243,47,
248,135,252,136,127,150,22,212,248,125,216,239,241,63,229,71,203,189,185,242,
135,172,107,187,11,98,230,233,126,78,84,245,206,205,202,109,162,113,25,188,126,
71,112,212,65,183,50,89,25,247,36,248,173,219,72,134,146,154,26,106,104,233,
227,66,235,229,189,219,141,238,38,42,169,112,205,84,12,73,210,188,73,20,0,35,
112,166,114,40,124,243,65,98,17,127,0,227,243,63,229,29,85,255,0,204,189,177,
252,177,55,175,96,124,14,222,223,23,122,95,126,124,95,205,215,118,103,95,245,
183,203,111,229,249,221,146,246,141,54,253,147,9,186,119,94,59,57,132,237,29,
189,216,219,133,210,61,199,178,247,182,206,200,61,19,85,81,127,13,154,4,106,57,
210,156,25,164,41,67,52,235,13,209,70,45,24,141,136,96,85,128,101,175,2,0,226,
41,130,162,132,30,32,142,183,165,53,41,35,53,31,46,174,99,254,20,91,252,131,
186,63,165,118,78,55,229,255,0,192,189,160,155,67,101,117,135,247,31,111,124,
161,232,13,139,87,46,78,159,102,236,156,164,178,81,225,123,167,27,143,154,167,
41,159,199,125,206,149,167,203,9,188,144,200,136,43,146,222,58,166,46,248,130,
6,100,89,117,165,5,106,106,200,196,118,212,214,186,95,202,188,14,6,14,52,86,
185,43,254,74,255,0,197,116,195,252,239,255,0,147,255,0,242,191,248,205,178,127,
150,245,55,86,226,243,63,23,183,71,202,13,253,180,122,203,118,119,86,103,179,
242,53,125,73,180,246,93,53,22,217,207,111,206,203,236,252,126,232,163,220,185,
44,166,229,143,23,184,95,236,155,25,83,140,165,105,20,121,144,162,160,246,200,
150,120,210,7,70,103,47,14,182,7,57,162,140,0,43,197,179,74,224,96,84,245,109,
42,106,10,128,1,167,76,127,21,127,151,143,252,39,111,231,215,106,252,166,233,
175,143,52,95,58,6,15,225,215,84,229,59,55,117,252,129,78,202,219,115,237,14,
223,192,237,90,163,67,184,115,91,59,3,148,198,85,101,124,245,213,113,72,244,38,
90,76,117,53,100,8,36,68,140,50,234,179,73,44,85,146,71,112,60,54,108,132,173,
22,149,237,162,233,173,112,11,19,228,212,53,235,192,39,5,3,136,30,127,234,254,
93,17,110,246,248,55,252,145,187,59,249,108,124,164,249,95,252,186,59,239,228,
86,111,186,126,54,228,186,221,178,253,121,242,19,112,109,141,169,152,151,9,188,
183,118,23,17,85,89,14,202,92,20,21,59,150,131,248,125,109,72,134,163,31,84,233,
29,101,62,137,8,186,135,191,141,42,73,18,72,72,102,96,40,66,138,131,92,169,4,
212,131,74,250,15,145,29,104,170,149,36,12,1,254,175,46,181,168,90,48,248,250,
150,41,46,134,125,49,60,179,35,9,37,142,152,51,24,138,6,85,66,243,139,95,240,47,
237,114,198,84,150,13,65,94,152,46,42,7,159,76,50,69,139,165,102,104,222,242,44,
250,65,145,204,128,160,36,250,180,233,140,170,58,253,71,39,241,199,183,115,65,
83,214,234,79,151,151,80,100,169,140,202,66,70,65,126,75,179,131,119,191,235,
250,0,183,254,130,252,123,181,69,60,250,208,173,56,244,241,143,102,117,99,18,43,
58,200,138,128,88,171,16,202,78,155,29,65,128,254,159,95,167,186,25,66,231,79,
90,211,92,19,210,214,164,80,80,210,210,84,79,44,2,162,71,145,218,146,162,159,
207,59,41,149,213,94,56,145,188,113,201,42,219,75,114,0,247,79,171,145,137,40,
131,173,136,0,195,49,235,148,213,216,152,168,160,167,165,138,166,21,71,114,180,
146,76,89,9,127,94,168,228,101,180,97,90,230,214,176,60,216,251,216,158,228,208,
86,131,228,58,217,138,42,146,120,245,194,26,88,178,21,51,200,0,12,35,163,242,
72,243,175,142,119,130,65,36,46,108,84,75,60,101,199,63,91,131,248,247,70,123,
158,53,57,61,92,36,56,199,77,245,219,114,104,148,212,69,77,36,39,196,146,73,80,
245,33,153,181,62,153,36,148,66,17,81,164,189,136,7,221,68,178,212,134,61,120,
170,226,157,96,155,5,149,135,93,64,167,103,148,164,26,26,57,163,114,177,83,186,
91,200,210,16,195,68,100,11,41,26,147,143,110,199,32,96,107,229,211,100,167,
173,5,122,205,79,69,91,88,239,3,68,162,56,160,67,43,202,128,136,218,73,2,135,
103,3,208,196,45,129,30,217,158,122,1,70,160,7,173,170,129,82,58,139,156,168,
138,158,67,24,120,165,159,246,208,203,4,45,2,183,138,37,64,186,28,159,88,255,0,
84,126,191,83,253,61,210,22,119,167,26,117,98,60,235,210,94,166,104,167,100,48,
144,92,39,172,144,110,94,214,22,31,150,231,217,132,110,202,8,52,35,253,95,203,
166,180,215,128,197,122,138,244,222,52,15,97,168,170,128,132,146,197,141,174,88,
15,200,254,158,244,89,137,165,122,176,198,60,250,229,27,60,33,139,50,174,171,
112,15,208,22,28,255,0,70,212,71,251,15,118,86,210,10,142,29,122,156,122,84,67,
82,100,73,153,4,165,76,5,203,3,117,58,153,53,234,227,133,212,8,227,159,104,138,
254,165,125,79,86,167,167,167,76,127,106,210,85,9,29,138,35,155,200,203,201,96,
65,79,77,135,30,147,249,30,212,163,105,21,30,93,84,138,141,52,235,157,21,36,30,
118,105,57,142,157,139,217,184,50,178,200,52,35,15,245,4,114,127,63,211,222,153,
245,119,30,180,65,174,120,244,238,114,94,9,106,37,121,74,233,19,24,194,162,218,
197,116,248,208,16,73,1,94,220,253,45,239,69,75,1,214,168,77,40,49,211,5,94,94,
162,169,98,18,77,35,136,21,146,5,45,112,131,143,210,191,161,65,63,82,57,62,238,
177,133,205,56,245,96,180,234,35,197,61,67,22,177,118,84,5,173,244,69,23,28,159,
160,181,190,131,147,237,241,129,65,215,141,58,195,22,57,229,116,93,65,153,153,
64,28,159,175,208,105,81,253,175,123,161,52,207,91,175,82,126,194,197,89,253,
33,164,100,176,95,211,165,194,146,215,228,1,238,165,69,126,125,106,190,157,103,
120,105,159,94,186,153,3,45,194,233,132,88,232,65,105,8,185,244,47,231,243,253,
61,248,250,3,199,175,3,78,176,36,81,104,113,229,138,201,31,165,95,85,219,213,
245,81,192,91,142,127,173,189,249,70,7,167,94,173,105,212,216,105,200,139,200,
241,74,35,65,29,230,35,246,151,89,4,18,182,45,38,180,250,11,139,123,240,32,10,
177,227,213,73,207,219,214,23,129,154,22,153,3,56,90,149,140,186,223,73,46,172,
202,142,15,208,178,161,54,254,138,125,220,184,165,124,171,254,172,117,111,145,
234,68,49,194,230,154,73,153,89,202,176,97,40,111,24,141,29,143,175,73,214,200,
23,234,56,54,250,123,240,226,60,135,90,34,160,231,169,95,114,133,140,134,181,
204,171,8,180,130,150,61,0,248,116,18,99,181,244,104,109,63,215,144,127,30,247,
92,214,167,246,127,147,173,80,83,134,58,255,215,208,126,55,191,37,65,177,22,
255,0,97,107,243,126,7,183,42,27,203,173,117,193,252,108,90,234,110,88,242,57,
250,125,127,0,251,173,5,77,56,117,190,186,120,65,10,21,190,182,252,113,200,184,
250,95,222,169,215,186,224,241,149,32,176,22,34,227,253,129,252,31,168,250,251,
241,4,113,235,221,98,98,200,56,36,128,67,48,54,212,111,126,111,107,218,199,243,
239,93,123,167,24,36,136,139,21,96,254,61,68,254,7,44,110,160,88,143,247,155,
251,165,72,175,167,90,234,100,82,20,167,117,83,197,145,219,234,47,251,128,1,253,
71,189,150,28,49,214,143,17,94,156,168,25,89,230,144,153,21,98,240,187,248,166,
104,188,134,57,3,71,114,164,23,10,71,3,235,253,45,239,105,32,83,86,235,196,19,
195,169,245,2,190,190,111,44,203,252,70,38,90,121,101,72,66,9,34,167,79,42,175,
18,147,36,105,31,228,223,73,250,155,19,237,237,90,197,107,81,214,128,11,229,78,
160,69,72,211,73,28,77,227,128,212,56,17,43,233,91,35,2,7,150,69,182,130,150,
181,143,62,219,106,241,242,235,213,161,175,77,249,10,121,169,234,188,46,171,28,
176,248,196,109,28,97,117,195,115,227,104,216,13,76,88,243,115,112,125,232,245,
101,58,133,122,204,156,145,79,37,36,109,35,204,146,172,236,226,38,142,158,40,
202,201,229,49,27,2,230,204,46,62,163,222,136,52,52,29,104,241,175,14,176,173,
52,82,196,197,26,96,77,91,8,153,128,145,12,74,163,247,52,68,12,172,1,252,168,
60,123,247,15,62,181,95,94,160,177,180,164,50,59,164,110,204,92,43,40,49,130,
70,160,92,41,0,219,139,129,239,221,120,227,52,235,152,141,37,100,23,91,60,151,
181,133,194,21,39,150,31,66,47,207,189,154,83,229,214,234,105,90,116,243,143,
161,143,78,135,145,105,229,242,50,143,217,33,157,73,210,0,123,95,149,39,234,57,
255,0,91,219,168,160,130,15,159,85,102,39,128,168,234,44,180,51,0,241,134,86,
208,196,133,4,106,54,85,184,6,193,117,88,94,215,254,190,252,82,167,231,213,181,
122,244,232,42,42,96,198,195,79,61,32,138,9,102,40,147,169,84,158,83,18,6,98,
235,123,176,100,146,215,63,94,109,237,191,10,172,9,25,235,218,178,64,61,115,50,
71,48,140,36,170,150,98,74,72,24,8,99,141,78,176,196,130,25,152,216,113,123,
223,159,123,208,71,1,215,137,199,92,19,33,85,22,58,104,41,117,172,114,57,242,72,
0,10,10,74,141,233,42,3,216,159,168,189,189,216,40,85,62,103,175,122,116,221,
37,213,68,211,187,207,35,16,195,91,106,0,186,147,123,30,15,35,222,131,46,65,
207,94,206,41,142,158,176,149,239,79,36,166,24,135,170,32,146,20,211,28,201,30,
155,200,209,187,6,80,193,77,141,197,172,79,30,244,26,148,167,84,42,26,181,233,
101,79,22,47,52,149,85,179,151,68,129,86,141,220,211,134,50,135,136,178,206,98,
141,132,106,84,168,191,28,128,125,208,187,252,129,249,117,176,60,135,87,137,240,
63,249,206,117,247,192,223,142,45,241,251,49,252,180,126,27,252,143,170,155,
112,102,183,45,87,101,247,6,223,167,200,239,29,195,46,79,196,244,244,187,155,
248,222,220,220,241,87,82,224,140,75,13,34,211,201,73,10,64,21,68,98,77,114,186,
22,180,215,36,146,150,70,44,127,18,234,166,41,69,200,160,243,167,169,38,190,
142,171,246,129,67,79,151,76,123,143,249,190,252,70,236,156,198,71,114,246,159,
242,63,254,95,185,124,237,125,69,85,85,4,253,111,146,238,14,165,167,18,78,196,
211,173,118,19,101,238,152,177,117,198,7,55,99,28,52,192,255,0,101,83,221,62,
142,113,93,23,52,252,158,159,176,185,0,125,128,117,125,107,230,159,224,255,0,55,
85,237,221,125,167,179,123,191,183,243,125,135,213,95,30,250,235,226,246,205,
202,209,237,236,78,43,170,58,227,116,110,140,198,215,194,75,138,162,88,50,57,8,
178,251,227,35,156,220,85,89,92,204,234,211,202,166,65,0,118,210,170,160,114,
162,222,23,141,25,94,98,217,38,167,20,254,100,208,113,226,127,102,58,106,89,19,
21,81,215,120,228,120,168,36,142,187,90,213,61,60,244,243,199,45,35,212,74,237,
90,229,146,55,90,87,30,16,225,73,103,91,93,65,35,232,125,168,15,225,240,4,175,
173,122,70,207,168,226,157,23,222,209,194,26,122,90,89,4,49,7,142,142,231,198,
39,42,85,101,147,67,199,36,165,139,168,85,11,123,219,80,183,189,120,161,192,
193,233,232,205,13,43,214,227,31,240,168,90,201,50,63,203,19,249,45,213,211,172,
217,28,109,87,91,237,249,63,142,64,233,85,141,146,166,78,135,235,143,29,57,175,
89,155,201,87,80,154,221,69,152,178,163,18,110,44,75,44,234,30,211,229,110,71,
252,105,113,249,83,165,111,193,207,244,186,8,255,0,225,40,52,88,172,15,85,255,0,
56,14,203,202,109,172,62,244,143,106,124,92,194,209,228,118,86,230,139,43,69,
182,247,86,25,113,29,163,184,107,240,25,140,246,50,167,238,41,113,185,152,176,
109,77,83,20,48,25,196,82,235,87,91,88,238,255,0,185,216,208,16,32,124,26,249,
178,122,16,71,15,92,250,142,189,30,60,243,168,127,151,161,123,254,19,209,252,
199,190,55,247,31,243,59,235,126,163,235,191,229,135,240,239,226,246,99,123,236,
14,212,165,195,246,175,84,158,199,204,118,102,22,108,30,209,169,220,71,27,69,
153,222,251,167,57,69,14,59,49,140,196,79,77,89,224,165,130,121,81,239,228,8,29,
30,230,23,134,91,102,119,214,53,211,58,241,80,217,26,164,97,95,46,28,9,167,90,
12,8,96,5,49,242,255,0,55,94,255,0,132,243,100,182,230,209,254,107,255,0,206,
87,96,198,155,117,225,204,245,143,201,40,177,111,184,200,155,103,45,22,218,238,
170,185,170,163,220,177,77,85,74,213,27,121,233,170,255,0,203,63,126,63,242,116,
112,93,111,168,38,102,211,101,100,237,76,218,184,207,15,129,78,126,84,83,213,
134,100,144,127,72,127,135,253,158,169,19,117,127,53,104,59,23,227,199,202,207,
135,24,175,129,255,0,22,122,227,114,252,142,171,235,61,183,136,222,31,16,250,
255,0,41,177,115,21,249,110,179,236,120,179,180,212,153,204,96,204,238,239,239,
222,43,41,28,110,148,80,211,10,121,22,162,65,46,169,110,23,218,132,178,10,214,
151,30,49,208,189,199,89,36,140,112,21,61,188,114,15,160,244,233,179,37,68,139,
76,159,78,138,39,93,98,183,94,200,221,179,245,150,248,193,230,54,142,102,42,
186,61,181,155,193,103,177,242,99,243,24,108,163,78,244,149,248,204,229,53,92,
49,79,141,146,37,111,28,205,42,107,130,214,146,197,120,18,90,204,178,34,20,96,
98,110,7,215,162,123,152,200,44,127,24,255,0,139,233,77,216,125,55,62,28,86,
212,98,227,164,221,72,211,73,38,74,150,41,96,124,156,17,189,44,113,249,40,167,
105,18,146,183,237,218,48,195,197,227,114,5,173,99,195,178,219,176,96,209,209,
135,152,243,233,60,87,64,141,14,116,183,151,167,250,191,212,122,191,47,248,79,
14,221,155,53,240,63,249,241,236,60,117,27,166,75,55,241,106,25,168,217,169,
165,148,49,29,105,220,177,45,57,167,66,243,52,133,221,108,161,73,189,255,0,214,
246,25,220,128,75,135,111,47,0,159,247,151,83,209,245,179,106,140,125,191,228,
232,183,127,194,69,250,211,177,42,127,153,126,111,189,232,112,114,211,244,215,
75,244,39,104,127,166,30,196,200,149,160,218,251,70,143,116,98,97,139,5,77,93,
148,168,104,233,151,33,144,170,198,60,203,21,201,90,90,89,230,107,36,101,189,
187,120,234,36,181,238,161,71,46,126,72,17,129,39,229,144,63,226,143,91,140,87,
85,60,197,63,58,142,135,191,229,255,0,150,248,239,211,93,25,252,236,63,154,15,
104,246,230,107,165,54,71,201,174,219,237,191,134,31,25,59,19,103,108,90,78,197,
221,240,14,234,221,123,151,176,55,78,75,100,236,153,51,59,113,50,121,25,182,164,
212,4,121,43,104,99,165,166,166,158,86,146,202,1,45,100,119,142,218,215,195,38,
84,133,6,159,82,192,106,7,133,40,138,65,53,252,126,102,128,188,8,5,156,156,18,
127,213,251,127,193,209,186,249,67,215,125,33,252,197,63,225,52,91,10,159,225,
183,111,110,31,144,89,255,0,229,139,155,160,200,110,76,150,254,217,41,215,221,
148,187,87,107,98,179,20,251,195,13,145,218,210,102,183,73,197,69,71,215,155,
142,155,35,71,246,249,10,184,107,169,112,193,21,252,139,161,30,136,180,77,27,74,
186,100,71,109,67,209,101,53,4,80,154,141,64,10,249,0,213,2,157,85,168,84,233,
200,35,252,31,236,127,147,166,143,229,37,187,190,47,124,69,255,0,132,221,124,
141,239,31,155,93,77,155,238,238,135,239,95,148,121,61,185,148,234,157,183,88,
49,217,109,225,20,11,178,54,142,220,130,155,34,217,156,34,227,141,54,229,193,
214,84,25,146,120,218,53,166,7,213,244,247,185,148,60,243,141,26,164,50,34,174,
116,209,149,11,234,173,15,0,199,200,250,83,175,41,162,169,242,161,255,0,13,58,
122,254,119,221,159,185,182,95,242,158,248,205,186,255,0,148,126,63,98,245,87,
242,166,239,236,60,248,254,253,193,244,222,221,161,160,221,180,27,235,112,73,66,
180,27,95,180,179,226,106,252,229,45,29,124,212,115,98,50,225,228,90,153,50,216,
245,167,171,168,150,41,225,70,180,11,27,206,162,64,193,26,152,36,159,212,90,150,
14,78,73,2,133,7,195,64,72,28,15,85,114,116,118,255,0,168,31,245,103,161,63,
249,52,124,206,151,249,124,127,194,118,55,79,202,244,235,76,63,110,209,117,215,
205,10,195,185,54,134,82,181,49,85,17,237,204,254,243,235,125,189,153,205,224,
171,38,130,162,54,221,24,58,12,131,84,227,150,64,136,213,8,160,178,139,251,220,
218,133,204,170,138,133,154,68,166,161,80,8,66,71,216,106,0,7,202,181,161,165,
58,242,30,192,115,128,120,125,189,17,31,231,139,240,195,25,242,99,35,181,63,
157,199,194,190,202,220,127,37,126,42,119,79,240,185,187,142,139,33,149,200,110,
93,203,241,203,113,210,65,79,64,104,43,241,85,149,21,149,123,91,98,209,214,76,
180,149,120,194,21,54,238,65,153,72,52,181,16,74,20,216,204,177,77,161,133,21,
159,207,136,115,248,31,230,106,52,55,2,40,7,225,212,158,233,11,196,204,166,189,
191,203,229,254,94,171,215,105,238,120,14,223,197,10,58,118,165,137,41,241,44,
102,2,33,77,161,227,134,22,121,188,96,56,30,83,200,142,246,31,82,72,183,177,137,
122,34,145,242,255,0,81,232,28,209,159,17,129,201,207,250,135,64,23,203,215,163,
27,63,36,82,19,230,137,149,46,177,202,151,150,89,217,180,196,179,129,34,193,26,
147,164,184,12,126,150,183,180,183,98,177,55,168,233,117,134,161,42,212,224,245,
118,255,0,204,147,182,168,250,103,254,18,245,252,174,126,63,225,246,213,37,108,
95,35,230,197,238,28,158,114,122,249,18,163,3,62,198,205,230,59,19,33,87,69,72,
22,79,187,159,53,151,206,199,3,18,202,144,67,170,195,81,91,4,45,143,137,52,96,
121,75,51,159,181,88,198,7,236,106,254,95,62,133,79,136,254,208,163,252,191,228,
233,37,252,145,246,182,226,248,229,252,150,191,156,111,201,239,144,120,153,112,
255,0,28,59,143,168,31,174,250,191,15,185,167,109,188,157,151,190,169,118,190,
244,219,18,213,109,90,154,237,11,147,134,187,63,188,177,184,200,94,21,127,61,93,
60,177,173,204,79,167,87,132,75,51,132,227,69,74,255,0,72,184,35,243,64,11,31,
145,251,122,220,98,139,83,195,39,242,167,249,120,116,104,96,236,154,78,185,255,
0,132,165,252,69,238,189,243,241,179,227,151,125,142,168,237,76,158,11,111,
236,239,145,155,87,53,187,118,187,224,119,7,112,118,70,214,27,155,7,77,132,220,
59,114,190,139,116,249,170,68,122,150,164,70,208,36,160,169,36,89,167,140,188,
225,53,149,83,112,226,160,144,114,154,205,8,35,204,16,126,202,249,117,176,70,
138,210,184,255,0,45,58,214,43,249,135,252,128,218,159,61,50,61,103,223,253,15,
241,70,46,138,218,221,43,241,187,169,58,171,191,241,253,97,215,212,24,30,154,
219,189,143,138,201,230,177,177,102,112,213,216,37,172,122,44,46,228,76,133,52,
52,39,59,85,46,86,67,23,141,164,148,32,111,106,237,148,90,51,195,36,139,87,110,
209,90,147,65,198,135,204,210,167,142,106,107,211,109,87,161,11,128,51,213,162,
214,127,52,111,154,191,12,190,45,124,89,248,109,243,167,224,183,198,255,0,150,
223,17,41,250,107,11,188,186,167,35,218,152,44,158,236,162,236,46,181,223,244,
223,222,93,147,151,217,189,209,132,200,101,177,152,45,195,178,105,114,47,136,
151,236,227,90,234,21,129,168,170,35,141,163,7,218,68,142,43,134,127,6,226,132,
49,33,24,80,173,73,44,65,5,92,2,125,26,156,65,224,64,112,187,40,26,151,20,227,
235,254,17,208,155,191,126,55,255,0,47,108,247,192,190,139,254,123,95,16,186,6,
175,160,178,127,29,190,85,245,141,15,200,143,135,187,255,0,116,230,123,15,168,
247,188,88,238,195,192,227,235,241,93,105,148,222,144,67,89,148,119,146,186,138,
178,149,82,105,41,205,27,212,197,60,66,162,148,234,169,241,89,102,180,105,245,
18,74,103,200,149,44,164,26,84,130,5,25,78,162,61,104,42,119,142,215,11,142,63,
207,61,8,223,240,172,46,189,237,142,224,236,111,136,63,204,63,105,103,167,237,
31,132,253,179,209,123,91,5,214,121,44,13,26,214,225,58,211,57,149,73,119,133,
85,30,102,178,154,73,225,73,123,10,147,43,21,84,21,46,35,213,45,4,148,173,103,
129,3,42,182,153,124,103,114,40,101,80,87,253,168,161,79,181,26,164,143,233,31,
67,74,72,164,174,15,15,245,87,243,235,87,13,221,241,139,191,40,186,52,124,151,
202,244,230,247,219,157,22,55,22,39,107,209,118,102,229,193,205,183,54,198,127,
112,102,224,173,151,31,135,219,21,121,175,178,155,118,213,24,177,179,203,55,240,
228,169,74,120,208,180,197,20,169,42,22,226,19,40,139,197,13,41,174,6,120,100,
212,240,31,103,77,4,96,43,166,139,214,227,191,205,127,231,23,87,124,72,248,83,
252,147,182,71,106,124,32,248,221,242,246,124,143,195,237,153,216,24,202,15,144,
35,122,197,146,216,82,209,108,254,179,163,167,151,110,67,181,51,248,72,190,207,
62,168,126,233,43,162,170,130,83,77,16,40,64,96,197,144,196,211,144,170,66,209,
9,175,118,67,200,244,29,174,184,237,7,53,227,210,146,116,140,138,240,244,242,
3,212,30,181,226,254,106,191,42,247,31,243,40,249,21,151,254,100,221,61,208,
219,219,171,250,111,173,246,135,198,174,171,223,57,10,186,124,123,237,61,141,
219,24,140,4,233,141,218,248,172,222,57,225,163,169,165,172,169,195,206,113,112,
198,137,86,180,52,203,36,176,192,165,71,181,145,42,199,227,91,78,80,73,41,194,
175,10,4,11,233,138,233,36,3,246,2,104,122,161,58,180,176,6,131,252,245,255,0,
47,91,60,255,0,50,207,230,107,158,254,92,63,205,159,225,183,127,103,105,63,190,
191,23,62,95,124,10,233,93,149,242,127,175,235,169,198,103,13,188,58,234,108,
254,230,119,221,248,236,45,83,61,60,219,163,102,199,185,94,162,34,234,198,182,
141,166,163,144,20,155,210,138,8,252,116,119,85,13,39,135,25,35,248,195,32,12,
166,190,186,113,232,195,208,144,92,99,164,138,156,84,254,89,233,135,254,22,101,
186,54,102,239,248,127,252,181,247,87,91,228,177,25,158,189,220,219,243,126,238,
45,143,153,194,60,115,97,242,59,79,33,214,187,50,179,110,213,226,30,33,99,141,
168,196,213,68,209,88,91,70,144,71,181,177,24,205,197,169,139,251,47,1,169,246,
85,49,249,116,219,87,75,87,142,175,243,245,93,255,0,240,149,157,175,45,95,84,
255,0,57,29,235,77,95,246,6,143,225,93,110,214,21,48,232,19,210,205,153,195,246,
62,86,58,165,73,111,26,152,70,17,136,36,105,63,236,15,182,55,42,214,65,78,22,
210,255,0,133,63,205,213,162,255,0,159,135,249,122,212,83,27,75,45,44,116,173,
39,136,211,100,245,70,242,74,242,194,145,60,110,26,61,110,145,157,106,72,5,79,
233,12,57,181,175,236,201,72,98,212,6,171,211,108,40,62,222,133,6,219,114,28,76,
79,72,140,106,93,39,170,72,165,80,192,195,36,212,84,177,131,34,166,141,71,75,
114,172,121,4,91,243,239,75,41,10,198,128,12,255,0,132,14,154,43,222,3,121,211,
252,21,232,235,252,45,239,239,130,95,31,176,59,154,127,148,127,203,194,171,230,
55,106,71,158,254,41,180,178,249,255,0,145,27,163,173,186,211,21,131,142,26,
120,142,7,59,176,118,198,216,170,151,51,34,86,36,147,52,237,90,124,161,196,70,
52,85,212,201,164,142,226,103,213,28,244,138,156,56,125,166,163,184,215,228,86,
157,62,25,20,10,174,122,181,26,191,248,81,14,197,218,123,82,135,99,124,123,254,
76,223,203,99,171,246,165,50,4,171,198,239,94,177,166,237,90,156,140,86,58,5,
93,100,248,125,169,83,84,196,49,179,213,61,84,154,77,174,7,182,218,203,72,95,
16,161,249,232,212,127,222,157,152,245,177,32,106,233,7,246,255,0,154,157,85,
255,0,202,239,230,65,132,249,47,178,43,246,125,23,192,95,129,159,30,114,89,13,
201,69,157,200,118,47,64,116,246,111,102,111,102,251,83,44,173,138,160,200,84,
239,44,166,31,27,65,85,52,161,167,88,41,23,82,160,81,101,36,27,67,100,171,42,72,
110,36,32,3,219,83,67,246,143,79,78,29,85,221,136,166,145,246,211,170,232,71,
175,205,84,83,201,71,67,163,196,142,177,188,137,233,168,141,94,225,238,205,197,
141,192,183,23,246,180,70,162,171,140,244,217,106,10,177,233,178,190,58,203,179,
135,120,213,9,214,188,216,30,65,85,42,8,250,139,91,235,237,229,12,130,135,47,
242,235,68,143,62,185,98,168,171,107,72,72,31,89,5,220,44,133,213,64,64,25,220,
155,242,20,27,155,15,122,98,212,205,122,171,48,225,211,180,179,101,162,165,40,
245,51,67,11,168,143,194,42,217,86,80,100,14,101,142,23,11,100,14,191,158,79,
180,164,33,106,249,245,113,82,41,211,133,36,217,170,181,150,85,215,44,40,28,203,
83,35,36,112,133,133,81,88,36,206,200,142,66,88,144,186,154,199,233,237,60,210,
198,138,16,183,119,144,29,109,99,171,86,157,98,203,102,152,196,34,129,13,36,16,
82,192,229,89,134,153,39,18,16,242,179,169,213,33,147,139,15,173,135,211,218,
116,140,147,86,53,106,244,241,165,69,58,15,170,39,122,218,183,147,214,229,219,
74,235,36,216,1,109,86,250,33,176,250,123,50,133,40,190,157,81,143,151,159,78,
52,84,65,11,50,222,71,85,102,107,11,89,64,185,81,171,131,97,254,199,218,143,44,
12,116,203,19,195,168,245,139,33,208,200,133,82,94,80,216,126,225,91,155,175,
171,80,85,191,215,221,48,72,21,235,96,145,196,117,2,72,229,120,203,122,206,159,
163,16,52,21,6,204,85,205,181,89,191,167,189,138,131,129,142,174,40,122,117,195,
85,53,205,59,179,89,239,167,150,227,87,44,191,159,75,159,246,30,219,145,112,88,
40,235,213,253,157,42,164,195,213,60,115,201,76,21,164,167,128,212,72,172,203,
169,226,64,12,130,27,130,175,38,131,125,39,250,123,72,110,2,233,169,165,120,117,
96,181,110,144,226,73,78,165,242,185,42,228,59,143,168,69,54,35,233,245,81,244,
246,169,20,144,184,20,235,204,104,122,225,32,244,177,58,164,37,108,46,110,196,
14,1,63,226,64,231,219,227,21,234,158,84,175,81,150,25,116,197,39,225,155,139,
130,53,88,219,208,72,10,64,255,0,3,238,225,171,143,46,189,76,96,231,169,102,166,
88,203,195,30,152,75,34,150,11,25,105,27,72,183,55,184,22,191,244,30,236,65,
173,107,219,214,177,229,199,168,237,51,164,233,34,59,134,65,173,91,88,253,64,17,
206,145,110,47,248,231,223,142,63,195,215,188,184,116,225,77,145,73,101,81,58,
88,105,182,160,117,179,73,163,198,173,35,55,234,85,38,247,60,129,199,191,113,
35,231,214,136,227,78,185,212,192,85,170,140,118,146,56,66,171,205,164,52,109,
43,128,2,70,202,61,96,219,139,254,65,247,86,248,155,242,235,96,211,169,216,252,
127,222,83,214,204,230,53,52,84,202,222,70,43,164,142,84,33,65,105,85,216,114,9,
31,139,126,125,180,210,80,83,207,173,145,144,41,142,185,248,16,178,42,212,10,
184,93,17,33,9,229,70,66,2,254,212,133,130,166,144,204,65,181,215,253,143,189,
106,169,207,30,181,167,172,153,24,85,102,108,120,89,96,158,158,68,209,27,0,110,
76,122,164,46,209,141,82,105,64,66,145,114,65,246,234,30,223,80,15,85,243,168,
233,173,228,138,25,65,148,136,180,41,40,46,11,22,120,74,43,74,86,235,161,0,191,
245,252,123,115,143,30,183,159,46,176,129,16,118,26,200,140,192,183,37,64,187,
248,217,253,36,11,21,12,191,159,126,205,7,119,231,254,94,189,143,203,175,255,
208,208,77,60,136,7,248,220,221,129,10,109,98,61,64,159,167,187,122,86,189,123,
174,132,238,47,117,189,205,197,185,177,63,235,88,219,223,170,106,61,122,247,89,
252,168,214,54,31,170,199,252,57,189,191,4,94,222,253,215,186,229,170,236,0,55,
189,174,15,55,185,177,31,215,221,128,168,238,25,235,93,97,145,144,187,112,71,
175,232,15,28,125,1,31,210,255,0,237,253,209,176,125,71,91,235,43,153,35,23,8,
138,88,11,8,197,145,69,200,34,218,152,139,143,116,175,94,21,234,124,50,66,212,
210,51,122,29,68,105,34,255,0,171,245,6,212,23,234,46,7,63,143,117,32,30,29,106,
189,98,146,163,74,175,138,83,98,250,153,45,234,82,160,5,255,0,14,45,197,191,167,
186,233,25,175,86,233,234,151,44,21,105,229,141,218,158,182,155,91,9,210,250,
153,209,139,43,125,108,120,107,21,60,31,108,21,116,106,169,199,219,214,136,173,
65,24,61,42,49,85,184,218,255,0,2,213,192,178,85,122,218,97,228,72,75,179,150,
116,168,69,54,73,21,111,98,9,4,123,164,147,220,71,83,170,170,60,248,245,176,139,
194,180,233,186,120,42,38,53,11,0,132,194,213,126,72,227,70,86,145,11,48,5,17,
201,50,42,15,232,46,188,253,125,220,93,82,154,135,151,94,9,215,17,141,145,205,
85,65,138,68,90,102,2,82,234,27,67,20,14,7,164,95,67,14,1,211,107,159,111,45,
194,29,62,167,170,144,122,205,79,13,92,148,225,163,71,154,55,119,105,137,131,83,
199,227,245,187,171,2,150,142,53,31,139,125,57,246,231,136,134,128,54,122,163,
80,101,177,210,154,150,106,90,154,184,45,10,66,26,153,38,211,86,190,77,115,152,
154,9,28,155,0,180,237,229,37,23,234,13,185,247,106,160,52,175,77,80,211,174,25,
28,30,42,148,153,35,199,171,205,21,82,35,39,154,81,3,19,5,154,68,141,88,51,35,
61,174,11,11,126,61,190,141,21,5,8,63,159,90,12,228,208,154,99,166,40,169,169,
99,64,94,158,104,60,181,12,237,246,178,159,10,70,88,144,136,36,50,150,9,166,
220,158,63,175,187,141,21,31,228,234,196,159,35,83,212,153,176,43,60,47,45,60,
178,157,50,143,220,146,63,216,12,108,194,55,104,181,31,220,184,10,127,175,227,
222,252,49,82,65,234,162,80,13,8,233,175,39,13,85,12,52,208,84,70,37,4,61,149,
193,109,19,57,0,69,228,117,91,181,148,16,20,144,47,207,186,154,227,167,87,73,36,
142,61,65,162,165,251,202,189,50,52,141,49,89,12,65,172,200,28,112,20,165,193,
114,206,192,127,75,251,210,241,207,30,182,204,64,36,12,117,46,106,71,134,9,226,
63,212,172,178,72,16,36,114,43,198,89,1,87,58,86,226,196,129,201,32,123,211,
128,23,231,213,67,2,65,233,162,174,142,117,134,73,4,145,180,104,97,80,34,109,99,
203,34,151,97,96,110,2,170,145,127,161,110,61,178,56,245,112,122,147,66,242,211,
24,166,34,53,137,117,41,63,66,38,68,14,188,174,166,187,48,0,18,45,239,122,79,
152,199,94,173,107,210,162,159,49,71,71,67,35,214,67,51,87,72,105,1,122,122,136,
252,65,101,73,94,72,170,99,91,23,149,150,204,52,240,62,191,225,239,90,78,7,85,
25,56,56,233,184,86,140,179,75,61,100,239,35,0,209,83,192,25,74,195,164,141,6,
71,154,198,64,82,224,243,123,242,125,216,37,5,72,235,103,4,83,165,214,212,139,
28,180,117,240,211,44,73,144,72,34,104,229,43,3,84,85,186,201,166,104,41,117,
16,177,42,23,5,205,201,35,145,192,62,210,202,197,74,141,36,169,234,224,130,9,
61,24,141,151,22,31,25,53,82,213,149,251,138,84,162,150,89,85,67,67,4,206,92,
136,210,53,58,38,142,171,80,12,202,73,88,239,114,45,237,232,100,136,33,19,26,41,
175,218,122,77,50,59,149,208,49,208,185,73,185,232,170,37,172,142,143,196,245,
51,66,239,58,214,72,239,77,4,145,35,58,77,164,67,163,193,20,0,186,50,146,9,54,
191,182,11,148,238,64,175,25,30,98,184,249,245,79,1,191,17,56,244,255,0,85,122,
8,105,183,38,67,104,118,22,207,221,145,237,109,151,187,39,218,121,156,94,125,
118,111,96,96,169,183,78,193,220,169,79,92,42,99,197,239,13,183,52,226,12,254,
15,38,6,138,138,102,146,48,209,61,129,4,223,219,47,32,154,38,142,165,107,230,
180,4,125,134,157,41,69,8,67,105,207,86,171,223,159,206,231,231,31,202,78,150,
168,248,211,219,29,89,240,211,253,5,211,98,42,54,182,221,217,120,239,141,91,90,
138,131,97,98,163,129,104,177,211,117,196,213,217,44,140,187,27,37,133,166,138,
53,161,159,25,246,243,65,226,80,24,128,65,105,45,98,62,24,121,164,162,156,80,
40,166,106,104,66,131,159,63,95,62,39,171,180,224,112,2,191,159,69,155,224,223,
243,37,249,161,252,188,246,103,105,117,207,197,45,255,0,180,246,254,212,238,92,
154,215,111,76,94,224,235,61,157,189,215,33,88,152,182,219,107,87,21,118,225,
196,213,213,248,232,49,211,178,138,103,146,90,95,91,49,128,151,147,83,242,195,
20,174,237,169,133,87,73,225,145,156,28,31,83,233,213,22,118,69,21,167,174,122,
110,248,133,242,227,229,239,242,251,237,126,198,237,191,141,153,205,149,182,123,
27,179,99,154,159,114,110,109,197,213,219,19,119,85,211,172,213,149,185,74,152,
246,204,153,172,45,75,237,42,90,249,178,242,44,241,227,154,150,41,162,209,27,
163,36,104,170,173,246,244,111,2,133,148,198,180,20,34,163,0,121,131,154,14,60,
105,92,228,244,218,93,30,239,58,158,134,127,142,127,205,95,231,111,198,206,240,
249,27,223,93,103,180,62,47,213,111,175,147,79,56,238,60,142,224,248,241,177,
155,7,154,167,202,82,64,185,138,90,106,76,41,192,213,98,112,219,130,174,144,87,
100,104,34,148,99,242,21,242,60,245,48,188,143,127,105,215,108,142,136,22,87,10,
20,174,116,145,66,114,40,202,64,244,192,225,65,192,117,99,118,42,106,5,73,252,
250,29,176,159,206,247,231,30,212,206,212,110,172,95,199,143,229,255,0,176,123,
5,48,245,24,141,189,218,123,27,225,199,93,237,174,197,216,95,196,168,209,19,
37,179,183,38,46,172,77,143,174,74,71,45,27,73,247,2,50,80,149,35,208,119,251,
161,9,53,153,255,0,100,127,202,137,131,79,49,145,229,213,26,247,4,168,95,231,
254,126,136,198,214,193,228,223,39,149,203,238,136,78,229,171,200,22,201,229,
243,89,26,249,50,211,229,242,121,1,89,147,202,84,230,178,147,212,53,85,86,67,37,
60,146,60,200,25,153,137,37,200,99,236,250,24,22,52,85,88,199,134,180,3,211,3,
135,236,198,58,36,154,82,206,123,200,99,254,170,255,0,197,245,63,49,73,94,113,
50,75,132,200,234,141,43,82,170,92,100,144,69,85,11,82,202,69,59,77,64,134,71,
169,241,99,149,148,120,70,166,104,212,148,34,199,219,181,33,78,146,107,94,29,85,
10,150,210,227,136,165,127,213,235,235,213,155,255,0,47,159,230,174,127,149,
255,0,67,246,94,215,232,175,137,27,115,180,251,231,228,6,245,154,183,176,187,63,
183,243,245,95,220,156,207,89,237,204,91,98,48,27,83,19,180,54,237,29,38,101,98,
164,173,200,228,13,84,117,121,5,134,105,103,102,40,227,74,169,77,206,219,119,
115,117,44,169,34,120,44,129,69,84,147,79,196,41,80,59,143,18,107,192,10,98,189,
25,91,223,69,4,65,28,29,106,115,159,63,47,229,209,100,237,143,230,13,243,167,
190,186,115,45,241,199,9,63,86,252,73,248,227,188,234,43,229,220,93,47,241,7,
169,118,159,70,109,45,199,73,59,190,172,126,231,172,192,64,251,175,114,209,212,
223,77,84,53,21,239,21,102,155,74,172,182,81,123,125,138,52,204,140,204,107,92,
210,132,142,21,0,10,211,203,85,105,138,122,245,73,183,122,124,32,83,164,6,214,
205,124,169,220,63,20,91,224,226,118,39,93,203,241,117,242,223,222,42,94,188,
202,117,55,83,199,144,167,222,47,5,84,159,223,122,61,216,187,54,93,225,79,188,
141,62,184,127,139,10,255,0,190,106,119,240,25,68,45,163,219,195,96,136,207,227,
7,109,101,181,124,71,141,41,251,41,138,112,166,58,101,183,202,38,157,62,94,
157,10,127,203,163,190,254,93,127,42,202,223,144,24,62,164,216,219,3,121,227,
190,73,108,81,213,219,143,104,246,182,58,191,115,108,232,114,144,65,151,108,22,
235,93,187,5,92,120,172,205,93,5,38,82,178,42,154,42,181,150,146,178,142,115,20,
232,203,107,86,231,99,154,225,148,7,10,72,42,112,13,84,210,163,60,14,48,77,64,
206,13,122,188,123,212,42,24,241,3,62,148,61,4,145,252,172,249,169,31,196,29,
207,252,182,242,121,14,180,166,248,227,93,188,183,14,229,171,217,167,170,118,
136,203,67,159,221,155,170,167,125,75,93,183,243,115,209,26,172,28,216,188,212,
210,26,1,64,32,106,26,113,226,142,202,45,237,143,220,186,102,212,30,77,65,193,
165,70,72,80,160,228,84,212,10,28,231,62,189,63,251,209,124,48,64,26,8,244,249,
231,161,111,226,63,200,47,156,159,14,58,35,177,190,53,245,77,102,206,207,116,55,
116,228,233,247,22,244,235,78,221,234,237,171,219,27,78,182,190,44,125,58,84,
212,81,224,119,174,63,37,142,164,166,175,139,31,4,149,73,224,40,239,71,20,182,
18,40,98,252,187,33,154,66,207,173,75,1,90,83,52,173,14,65,200,245,20,60,61,7,
76,141,225,17,77,8,63,234,251,122,106,235,239,145,159,48,246,119,194,93,241,
240,15,15,95,214,116,159,26,251,67,51,187,119,78,228,219,149,221,73,182,43,51,
185,92,142,236,203,211,100,234,114,116,91,150,178,138,103,196,84,99,106,177,48,
28,84,144,136,230,161,17,32,137,149,81,45,161,177,163,75,226,180,175,241,41,
165,71,21,0,12,210,188,6,115,156,250,154,233,183,141,42,84,32,255,0,139,233,123,
240,127,188,254,99,255,0,47,13,183,191,246,239,199,62,206,125,187,177,187,72,
209,141,249,177,55,54,209,218,157,129,179,115,57,121,177,149,88,168,114,147,225,
119,38,43,47,5,61,76,120,201,93,11,64,66,74,136,22,100,149,81,84,42,151,101,130,
114,93,203,6,34,134,135,136,201,161,6,160,140,159,42,142,147,141,230,69,237,74,
122,245,203,45,79,158,204,103,247,62,242,222,56,218,38,201,110,124,174,95,122,
101,133,13,6,63,109,80,54,90,176,189,125,125,69,54,23,7,6,59,21,141,198,84,212,
200,210,71,65,75,4,41,26,29,49,168,10,7,179,56,173,210,218,37,137,20,248,74,184,
169,205,0,243,232,169,167,51,203,175,80,214,91,211,215,253,92,122,5,243,25,140,
165,29,81,220,184,218,76,54,225,203,236,156,246,15,112,224,105,247,22,218,195,
110,189,189,91,81,143,153,107,212,103,118,222,118,12,142,47,59,137,159,194,203,
61,53,66,73,25,69,33,195,126,160,150,230,52,186,182,158,6,44,20,138,85,77,14,
124,193,25,233,124,21,134,91,121,69,1,174,107,195,236,232,242,238,15,231,219,
243,191,122,237,140,22,198,236,95,139,159,0,251,99,97,108,96,177,108,205,175,
188,254,45,211,100,54,222,209,132,69,246,82,157,187,131,151,115,75,137,192,172,
244,225,16,138,88,33,93,10,20,11,91,216,116,236,250,128,85,152,233,90,210,171,
30,43,199,130,142,62,126,167,163,207,222,10,8,212,5,79,204,255,0,159,170,233,
249,209,243,39,230,135,243,25,77,189,69,222,59,147,19,181,186,163,175,41,168,
176,219,3,161,186,131,11,254,142,58,79,102,154,72,234,47,89,138,216,116,213,117,
52,53,25,169,129,8,213,149,70,105,34,141,86,56,140,81,0,129,251,125,186,56,65,
110,44,48,14,5,7,162,128,0,80,120,154,10,159,50,113,213,94,247,81,29,89,158,216,
255,0,133,16,252,183,234,175,133,157,51,240,239,173,190,39,124,89,199,199,214,
88,61,183,177,168,119,94,238,218,57,61,237,182,178,91,99,109,80,83,209,227,166,
170,234,202,250,218,108,2,239,76,141,116,114,213,215,87,189,76,208,75,81,41,117,
129,100,118,111,105,27,110,147,72,141,165,83,6,162,126,0,90,164,158,37,181,47,
159,29,53,62,190,175,139,196,53,199,117,61,113,254,175,207,162,133,242,67,249,
152,124,224,249,209,241,167,37,241,71,181,177,29,17,180,250,226,163,122,226,119,
246,232,131,166,122,127,1,214,117,155,162,175,108,201,60,248,44,118,89,246,236,
227,31,54,63,11,61,95,144,36,116,209,200,238,169,229,119,210,53,90,13,186,40,
223,94,179,218,106,5,20,102,132,106,237,80,78,9,165,77,5,120,112,234,146,222,26,
47,161,243,207,249,120,116,50,252,54,254,114,223,52,190,10,245,22,220,248,205,
185,122,231,165,254,87,252,114,217,244,21,216,221,155,213,221,231,180,226,174,
172,218,120,140,141,76,149,149,56,92,14,236,160,132,85,156,72,53,18,232,166,200,
82,215,164,106,246,77,40,52,141,92,109,234,106,200,69,9,38,140,161,214,167,36,
129,130,9,227,134,2,185,167,91,142,243,25,24,167,216,127,205,209,92,254,102,159,
204,3,190,63,153,62,123,106,109,135,219,137,241,191,227,14,192,196,224,40,182,
87,197,30,182,203,40,234,157,191,185,104,82,173,178,59,198,76,86,27,9,182,232,
50,25,220,165,102,82,111,20,147,211,127,146,194,116,70,69,220,179,112,89,120,
100,180,140,190,47,225,160,210,170,60,232,42,114,114,75,113,36,208,154,83,171,
61,216,52,8,9,95,63,245,127,170,157,8,255,0,203,207,249,170,252,201,254,90,91,
91,51,211,27,78,13,139,242,51,227,254,77,37,204,191,69,247,70,63,35,184,246,
102,221,220,181,162,159,195,156,218,53,232,195,33,135,142,150,90,120,222,162,
134,9,190,202,105,144,177,141,37,253,211,115,182,188,142,212,112,9,201,5,67,43,
124,202,159,196,61,65,7,133,106,7,84,91,213,2,186,113,90,113,200,232,152,252,
214,249,161,243,15,231,199,104,109,206,198,249,49,189,105,183,53,46,192,202,78,
221,99,213,84,56,28,94,39,167,58,250,132,85,193,83,252,7,109,245,237,36,103,18,
105,38,76,116,81,85,26,213,170,170,175,167,69,142,121,228,85,0,41,22,9,10,20,
238,46,203,74,240,52,249,82,129,126,197,3,57,227,213,126,172,187,87,200,103,229,
254,207,71,75,63,255,0,10,29,254,99,153,172,118,213,198,238,158,183,248,79,189,
7,94,109,170,93,151,181,234,247,103,196,157,129,184,50,27,123,108,81,197,21,
60,120,188,67,214,204,180,56,108,76,81,83,68,159,109,71,13,61,47,237,173,163,0,
15,101,109,183,196,74,161,149,152,168,160,4,70,104,163,128,175,135,90,15,183,
243,233,104,159,26,176,1,207,159,19,249,244,78,126,90,255,0,54,111,153,31,45,
250,247,174,186,119,181,241,159,31,246,255,0,86,245,167,110,98,187,175,25,213,
253,107,208,27,35,174,54,102,225,223,184,250,9,241,216,236,150,246,219,216,186,
111,225,123,170,130,76,102,66,88,30,158,100,240,212,197,80,203,48,145,116,217,
92,123,100,113,106,1,152,18,164,98,130,149,226,70,144,51,194,132,240,242,243,
233,191,169,213,67,138,126,222,161,127,48,239,230,161,242,123,249,149,245,239,
76,109,143,145,184,254,150,134,159,166,210,179,25,179,43,58,199,170,48,219,11,
35,226,24,244,199,75,13,78,83,92,249,56,176,113,34,71,28,56,202,47,179,196,164,
137,173,97,212,160,251,114,11,20,129,196,190,35,51,232,210,56,0,20,26,129,69,85,
173,60,171,195,52,226,122,171,78,206,74,105,26,120,255,0,171,39,165,166,249,254,
108,185,30,209,254,81,155,63,249,92,246,223,199,76,39,103,238,78,163,221,116,
185,158,142,249,33,159,222,25,9,55,47,87,109,218,108,236,217,88,113,56,108,11,
97,195,9,105,240,181,85,88,40,175,147,90,38,197,77,26,188,12,240,70,87,75,97,
34,220,7,73,64,140,57,96,41,144,24,119,45,107,77,37,187,184,113,251,1,23,51,41,
74,17,158,31,234,251,7,93,127,46,111,230,229,243,87,249,110,116,238,248,233,
126,129,218,125,11,156,216,93,173,151,169,220,155,166,143,182,122,141,55,141,
126,98,90,172,28,24,108,150,10,92,181,38,99,5,62,87,108,189,20,86,122,26,195,85,
78,173,44,166,61,34,89,3,57,46,219,227,202,242,43,149,44,186,91,10,106,7,250,
101,108,122,142,7,249,244,223,213,44,98,141,154,31,245,121,244,70,123,159,112,
213,247,143,96,238,254,193,173,235,110,172,234,250,221,225,37,118,244,125,137,
211,123,110,61,147,215,24,85,130,5,251,202,109,161,180,36,172,200,197,129,199,
73,91,27,52,212,145,184,140,74,239,227,80,182,3,118,251,123,219,177,66,89,128,
4,212,156,250,252,184,112,167,167,94,123,180,116,83,90,100,99,237,233,186,151,
1,37,38,212,164,206,203,60,177,227,169,154,146,121,49,173,35,70,173,231,158,
169,218,37,129,3,2,128,203,30,142,99,9,97,245,226,202,100,180,162,107,69,20,197,
107,249,147,95,94,153,91,128,206,99,99,221,154,127,33,208,114,184,8,37,167,146,
185,230,158,165,228,254,43,83,28,196,46,147,246,21,176,68,140,36,96,171,38,149,
127,81,181,139,30,46,61,234,56,6,146,195,225,32,255,0,46,188,242,247,21,60,69,
63,159,73,236,149,36,52,195,33,224,46,210,121,33,130,0,36,98,129,36,142,57,24,
144,70,165,109,68,242,13,191,23,246,196,232,164,84,121,31,242,116,236,76,221,
181,225,76,244,201,75,134,57,60,130,125,234,253,194,138,186,120,26,146,37,17,44,
175,36,97,163,85,0,177,68,3,210,64,23,39,233,237,168,215,29,166,153,233,198,125,
60,61,43,210,182,169,164,240,154,88,233,35,167,208,213,40,97,69,62,166,130,75,
34,198,196,43,56,136,1,98,108,117,95,143,110,198,131,85,14,77,115,211,36,145,
154,255,0,168,244,247,183,54,10,229,169,161,175,174,142,166,165,170,242,66,26,
124,124,22,139,202,194,35,35,169,89,93,82,70,208,63,44,188,255,0,95,167,181,143,
9,17,135,31,103,73,164,185,10,218,106,0,167,236,233,91,77,140,174,196,211,61,
18,81,45,53,79,143,237,227,119,167,163,68,131,196,12,147,212,84,212,233,178,
168,133,128,55,99,114,191,75,123,38,184,188,72,129,90,138,127,63,217,211,136,
133,206,161,90,116,22,103,19,21,66,146,73,28,212,181,82,248,76,173,84,177,187,
155,172,190,54,86,12,190,56,253,77,117,211,233,252,15,101,127,85,52,239,165,84,
170,86,159,229,199,70,137,26,128,11,31,46,29,52,54,68,85,82,148,150,65,44,8,34,
42,198,203,26,72,87,73,147,87,164,70,74,168,83,253,125,250,56,244,72,60,159,
252,63,231,245,233,198,11,162,160,116,143,202,164,149,96,180,112,131,10,168,64,
192,146,145,22,39,75,16,56,50,53,184,55,250,123,55,133,115,195,61,37,39,206,189,
100,194,97,42,106,164,88,40,224,121,165,98,19,128,164,187,11,220,33,54,210,65,
250,95,235,237,95,77,51,40,21,174,58,17,177,152,236,46,58,158,160,86,210,77,61,
100,114,75,2,121,101,241,22,145,213,21,109,50,144,145,40,119,32,129,168,216,92,
251,178,41,44,69,43,210,121,9,106,16,104,58,14,50,84,212,176,213,203,79,71,17,
73,86,117,188,104,60,200,182,210,86,21,146,83,169,214,59,92,16,44,71,187,152,
243,67,252,186,121,107,160,22,108,117,197,98,242,137,150,120,90,73,8,121,17,88,
136,149,218,51,98,200,80,50,136,238,182,35,243,253,61,185,224,209,5,1,7,171,107,
28,3,99,166,183,47,12,210,72,97,69,12,232,172,22,193,67,63,175,208,160,240,164,
19,110,126,158,211,159,133,135,151,87,20,252,250,20,118,166,78,25,181,199,45,
52,173,20,180,114,68,209,200,35,111,51,198,86,241,35,18,0,26,73,34,246,227,216,
114,245,89,88,29,66,161,190,120,175,159,74,144,2,164,1,196,116,133,171,197,148,
157,165,133,23,198,242,184,68,7,132,77,71,72,35,143,80,191,63,235,15,102,112,61,
2,234,63,236,244,203,231,21,207,81,210,154,52,141,37,42,26,72,235,76,50,163,
42,148,210,24,18,121,101,224,2,73,55,246,182,164,159,183,166,179,195,172,245,
85,84,177,58,49,138,89,216,24,230,134,57,2,198,34,147,88,82,82,85,212,60,82,5,
30,155,126,7,183,252,148,117,160,56,244,205,88,146,207,81,87,82,218,34,154,162,
114,35,69,0,106,39,214,97,11,115,165,216,139,125,109,239,122,179,67,195,175,83,
29,53,84,153,96,58,36,210,68,177,41,54,253,40,11,53,133,133,238,203,111,199,
186,177,244,61,88,117,138,158,23,149,195,40,33,84,173,207,208,147,107,216,15,
205,135,215,233,238,161,233,78,183,76,17,210,141,99,52,234,223,117,29,226,104,
27,64,118,32,254,177,111,25,93,90,12,132,218,228,123,109,216,177,36,31,62,181,
78,167,147,73,36,52,255,0,102,77,40,117,146,150,168,70,230,73,39,242,106,178,
42,48,3,84,8,108,174,120,114,111,112,125,183,154,210,149,63,234,255,0,47,91,
192,175,144,233,175,204,212,98,73,3,233,87,58,21,36,23,19,194,140,2,36,177,220,
121,25,138,146,214,224,91,235,237,208,149,165,122,214,120,10,211,174,164,119,
152,58,75,82,27,90,195,105,63,117,162,128,0,198,48,116,169,42,64,26,5,175,245,
255,0,95,218,138,83,0,99,170,210,157,70,175,137,34,150,53,44,28,61,44,119,96,2,
234,114,154,153,108,73,33,151,233,99,207,23,247,175,82,14,41,214,243,76,117,9,
90,54,134,64,77,194,64,133,73,45,117,187,27,162,143,203,29,95,95,126,212,13,
114,58,245,15,26,103,175,255,209,208,108,137,146,220,122,8,227,233,99,164,18,64,
191,55,191,215,252,125,187,85,52,169,167,85,161,29,99,69,12,86,226,214,35,233,
107,155,127,129,254,190,232,105,90,86,163,173,154,245,208,136,145,112,7,234,54,
252,92,255,0,66,63,60,251,175,217,214,170,124,143,93,11,106,91,150,23,91,155,1,
125,32,218,255,0,79,173,199,30,247,159,49,214,137,62,157,113,96,161,164,1,139,
174,187,234,32,6,255,0,11,242,127,7,233,239,94,127,46,172,13,122,116,154,96,105,
227,113,233,62,161,25,241,250,88,27,234,228,155,106,95,126,162,249,113,235,222,
103,172,96,170,196,250,245,134,34,59,18,0,46,88,242,109,254,164,123,246,158,61,
111,172,101,84,221,75,170,129,234,23,254,132,112,77,175,99,207,211,223,169,199,
175,117,197,80,21,119,87,13,160,130,203,125,44,1,4,18,15,231,233,238,154,51,94,
189,95,46,178,83,203,52,51,69,58,187,41,141,148,163,3,115,97,192,0,127,105,109,
254,195,219,78,154,129,26,112,122,221,120,245,45,43,42,53,51,135,212,100,123,
242,57,0,63,6,214,227,159,116,48,138,14,223,46,172,8,234,79,241,58,167,243,147,
44,128,190,149,148,172,142,186,208,90,194,215,181,148,14,61,211,194,2,148,29,
111,136,192,233,65,67,152,170,142,146,106,116,240,136,221,99,184,152,73,40,72,
244,218,66,20,48,253,201,84,243,107,14,79,191,8,193,53,106,244,211,143,65,210,
150,159,115,83,85,84,192,42,35,167,161,130,150,137,41,128,100,5,37,40,117,35,92,
41,153,151,202,6,149,44,116,155,125,125,233,145,129,37,73,201,233,160,131,78,
115,212,156,129,169,120,32,130,23,169,155,31,80,149,85,232,178,170,10,216,198,
189,96,44,138,0,150,51,250,138,250,88,220,253,61,238,41,69,78,176,42,41,195,170,
180,98,181,7,61,70,166,166,200,228,96,133,168,100,138,158,90,106,113,79,28,126,
3,25,154,6,37,101,170,154,70,242,34,84,49,109,37,184,213,123,11,123,90,164,16,
72,56,233,166,33,8,7,204,244,174,163,163,200,237,156,48,21,84,70,111,191,171,
167,131,198,176,179,214,26,121,20,249,167,154,34,229,4,20,186,207,139,244,177,
55,55,62,238,172,84,130,172,105,252,186,104,178,200,198,141,215,13,223,180,243,
53,187,87,11,152,167,131,239,18,156,215,189,88,165,80,237,77,20,117,21,15,20,
210,170,168,144,218,144,11,155,27,1,254,30,212,143,212,69,32,100,117,184,103,69,
150,68,115,147,74,116,145,219,56,216,41,167,124,174,65,100,122,72,85,68,137,11,
194,142,35,152,40,22,50,171,217,157,156,17,199,211,252,125,249,84,124,68,96,117,
121,101,175,98,241,249,252,186,105,174,161,120,170,102,72,207,142,57,41,229,157,
100,66,173,120,97,102,5,98,146,228,21,148,143,210,214,43,111,116,34,181,7,7,167,
3,2,160,250,126,222,154,233,126,240,165,90,197,78,75,212,193,20,94,87,125,49,
138,120,238,26,32,218,85,100,11,192,227,142,79,62,218,93,85,109,63,236,116,225,
210,41,81,231,211,193,198,182,38,57,50,53,75,28,101,105,233,170,105,80,152,143,
221,137,93,99,214,99,187,42,24,245,222,205,234,97,205,189,187,148,239,197,127,
195,213,107,171,180,19,79,62,145,242,188,149,18,55,16,203,36,15,26,71,16,144,29,
82,57,12,74,42,1,228,242,55,31,225,254,195,219,97,135,3,90,244,230,7,14,156,97,
171,84,118,166,165,127,76,244,210,26,181,16,164,101,42,149,201,42,23,212,81,35,
101,176,58,174,195,159,240,247,178,70,154,15,207,170,83,4,145,212,252,77,112,
136,207,21,76,78,145,213,70,162,58,184,143,136,82,145,36,95,185,41,4,241,48,80,
8,22,224,223,250,251,104,130,72,61,56,106,69,58,50,187,103,45,67,87,71,89,20,
148,242,69,79,24,167,164,88,214,56,234,3,72,201,46,189,65,228,69,131,202,89,131,
90,224,139,48,231,221,26,56,218,166,157,199,62,125,52,75,10,17,195,165,30,212,
171,122,124,253,126,61,157,135,217,60,209,210,81,74,158,104,166,164,167,18,36,
81,74,146,4,73,146,58,89,144,139,145,171,73,252,253,107,224,120,154,10,133,7,
253,94,99,170,7,32,182,162,105,210,183,15,130,199,87,189,49,25,8,180,71,75,37,
94,64,253,168,121,230,106,90,137,167,138,16,181,5,2,33,148,42,6,32,132,9,233,3,
131,237,73,182,112,213,240,234,62,84,233,134,144,212,252,207,159,78,84,248,140,
20,82,68,238,177,66,8,154,162,88,235,167,154,101,138,81,81,11,45,66,44,139,44,
113,188,65,205,172,120,252,15,199,178,217,218,72,228,84,161,175,250,177,211,168,
133,148,145,195,169,123,93,41,119,6,118,170,42,23,132,208,83,214,195,10,85,204,
86,154,8,227,170,171,134,56,219,131,165,230,148,196,198,63,232,47,127,232,93,
180,157,227,114,28,168,168,243,251,125,122,244,160,34,46,59,190,95,228,232,97,
220,50,197,46,67,51,170,134,153,229,149,202,44,52,138,222,72,181,65,28,73,251,
50,132,79,49,0,18,84,233,13,207,214,254,204,100,152,26,46,161,90,159,63,245,
103,166,21,91,74,156,208,124,186,112,218,200,31,237,222,182,20,215,60,13,28,80,
212,211,83,25,32,128,43,68,176,78,91,90,52,212,108,161,30,51,245,255,0,95,130,
242,51,2,129,205,86,131,166,93,83,73,41,140,255,0,171,249,121,245,19,47,135,13,
77,146,139,19,73,65,61,44,244,209,215,56,104,229,151,195,52,57,1,9,129,44,201,
225,142,162,41,65,147,73,212,160,11,45,184,15,6,88,213,244,82,135,253,95,151,73,
221,139,188,98,67,74,31,245,127,177,246,244,229,87,89,4,25,41,164,134,58,131,
183,106,241,120,152,198,57,170,232,190,242,159,61,83,71,82,222,121,110,169,43,
195,227,164,148,232,3,74,173,128,144,155,251,117,180,165,10,131,160,129,196,249,
159,245,127,179,211,96,187,212,49,26,197,120,15,33,254,175,246,58,141,135,153,
106,43,182,244,152,202,152,233,234,5,112,52,217,40,228,49,85,164,148,149,144,
189,85,91,71,44,140,208,181,20,138,44,8,227,241,123,251,210,113,74,113,175,94,
42,66,154,131,129,254,78,133,154,204,117,38,14,139,21,152,105,93,178,51,228,
243,107,93,247,11,79,71,2,37,110,224,172,158,150,150,6,14,102,158,106,137,42,30,
86,36,20,88,229,4,16,111,236,193,41,26,163,177,163,86,159,207,3,253,94,189,35,
125,82,153,16,14,210,1,245,242,227,254,79,203,163,59,75,178,82,175,111,226,142,
217,162,197,182,86,56,99,137,255,0,137,68,211,211,53,20,212,145,87,58,20,129,
100,86,15,4,228,59,105,189,215,251,36,95,217,138,169,108,70,23,87,207,162,182,
112,167,245,245,104,243,166,51,195,207,165,174,210,217,179,227,55,53,109,52,155,
107,44,212,217,120,99,142,150,170,134,74,74,186,69,99,75,224,150,138,56,169,233,
107,158,74,97,34,35,35,186,161,215,99,123,241,237,245,128,7,35,67,105,52,32,227,
246,15,240,215,164,175,61,99,7,90,234,28,120,254,223,242,80,116,120,58,143,164,
54,158,227,163,195,97,115,56,172,156,147,97,119,0,206,210,73,142,34,186,170,44,
173,26,198,145,193,54,78,165,105,199,216,77,5,73,243,71,26,184,140,18,132,18,13,
150,67,109,93,42,104,88,31,245,103,162,203,139,214,70,98,159,9,20,255,0,80,255,
0,87,175,83,183,55,242,254,223,219,135,183,55,14,75,13,138,196,138,106,172,
207,247,155,9,145,157,97,146,142,191,11,143,163,49,69,79,75,36,168,177,228,234,
160,154,164,83,172,113,133,210,9,1,143,211,223,190,147,86,166,63,29,107,90,87,
229,159,245,15,94,183,30,233,160,4,6,170,22,148,6,159,109,58,70,236,127,143,57,
159,187,76,47,96,98,41,54,182,107,13,185,177,120,156,158,35,113,75,89,143,168,
168,165,56,169,217,165,150,134,21,143,35,91,65,54,95,66,63,219,51,59,45,208,5,
117,35,219,2,221,79,115,83,80,52,60,71,15,95,207,165,198,232,208,5,200,43,81,74,
121,250,121,112,233,13,144,233,233,48,184,60,150,54,182,53,9,81,79,151,166,206,
205,133,196,201,144,195,109,26,188,125,102,66,92,57,173,169,146,90,120,49,67,43,
0,208,89,92,105,142,69,2,50,193,136,72,109,200,32,212,1,195,129,245,255,0,7,
74,86,100,96,107,90,241,161,63,103,93,117,143,87,228,178,152,23,164,49,69,81,
136,201,140,101,43,229,50,120,232,233,162,137,233,38,133,87,35,12,154,219,86,
186,154,157,58,70,169,46,143,199,212,251,81,28,7,67,2,13,15,203,164,243,220,42,
184,109,93,227,52,174,124,255,0,205,210,103,187,122,154,169,254,226,12,116,105,
81,106,21,129,52,69,48,88,78,57,226,90,170,137,196,81,151,146,58,184,39,40,26,
224,18,188,16,73,246,197,197,177,106,170,127,170,158,191,111,74,109,110,85,8,99,
198,191,225,232,184,14,171,108,102,55,125,36,192,127,16,74,92,116,152,218,74,
152,57,201,74,37,169,134,182,142,146,117,153,60,81,195,67,39,144,146,9,111,81,
31,167,218,33,6,159,27,214,131,243,242,255,0,7,70,38,239,196,54,196,252,21,53,
207,14,25,253,189,98,93,133,137,155,23,89,13,56,128,9,176,180,179,26,248,225,21,
8,174,178,55,222,192,173,100,187,64,144,56,42,116,139,15,240,7,219,98,49,70,0,
212,83,143,248,122,241,153,129,86,35,58,184,127,131,246,244,28,225,182,133,4,
152,138,137,43,167,165,139,15,150,157,33,197,152,40,84,214,74,35,73,209,157,168,
228,146,64,166,56,156,171,153,36,22,215,250,175,207,182,60,16,203,82,195,65,56,
245,255,0,87,175,74,30,98,173,64,164,184,227,156,103,231,210,19,47,178,33,144,
99,177,216,205,188,181,85,88,202,245,18,211,213,195,53,60,210,207,247,18,211,
192,241,213,203,51,37,53,227,101,113,168,50,253,15,211,219,111,16,248,21,51,95,
246,43,210,132,152,17,169,155,20,255,0,38,127,103,77,184,189,161,145,167,254,
240,229,38,199,84,83,211,212,197,78,248,79,181,169,160,155,33,18,202,230,142,
178,15,177,34,154,161,224,242,194,9,101,70,214,5,195,123,74,109,26,158,32,7,250,
32,83,243,29,58,247,1,128,140,113,31,23,167,200,253,189,74,202,98,164,90,124,
140,213,116,193,235,163,142,146,158,130,89,224,241,36,245,109,28,115,71,19,153,
45,224,168,106,96,206,125,69,110,116,130,15,183,34,64,202,225,211,129,3,253,94,
157,85,165,166,133,83,65,231,246,14,39,236,233,37,14,214,200,214,182,66,151,27,
53,35,195,23,216,203,89,69,28,9,13,107,85,85,212,66,34,106,89,229,97,172,197,
42,178,18,229,2,234,190,150,250,251,211,217,52,134,169,76,17,143,62,63,179,254,
47,173,253,90,39,197,197,129,167,165,6,79,237,235,22,107,106,208,224,243,25,
108,100,120,234,127,185,164,195,212,83,212,83,98,100,251,184,177,217,26,152,227,
201,84,210,44,175,52,145,107,106,136,203,72,53,58,70,110,20,91,232,232,131,195,
50,235,53,146,158,89,211,138,211,237,233,163,56,145,81,214,186,107,92,241,63,
234,242,225,209,125,220,98,56,235,41,161,72,30,38,42,114,198,52,101,98,174,222,
25,52,179,48,45,161,213,253,63,234,172,111,237,36,224,149,30,64,103,165,144,26,
22,62,184,232,58,174,172,161,163,124,149,51,70,42,41,25,103,164,48,65,74,38,
172,53,213,145,192,99,168,105,245,193,31,134,7,109,62,37,211,33,54,177,176,32,
176,168,160,146,65,169,225,210,178,89,149,52,145,81,147,159,33,90,126,127,62,29,
38,107,54,38,123,115,238,167,150,162,56,87,21,182,177,176,12,198,81,105,188,11,
80,148,120,255,0,242,92,126,62,4,87,122,220,196,148,80,15,51,1,226,87,91,19,
112,125,168,240,153,216,26,97,70,79,175,203,237,233,191,26,56,162,245,102,56,30,
149,226,107,228,61,58,108,77,160,55,5,93,12,210,83,86,71,69,28,117,77,49,32,213,
201,166,158,160,199,69,67,18,83,198,82,55,170,32,21,69,26,210,236,79,36,123,178,
194,29,129,35,31,234,199,85,51,232,86,10,65,39,253,68,231,161,177,122,113,240,
184,220,173,110,114,130,151,31,77,45,62,42,183,45,75,46,21,114,117,248,100,138,
112,244,52,111,29,68,144,44,19,86,69,47,238,34,93,218,57,130,2,24,92,47,54,172,
163,81,74,15,60,87,236,31,159,159,219,210,17,120,29,194,172,149,34,160,103,143,
175,236,233,81,81,71,179,242,187,59,15,152,162,217,51,99,115,144,208,157,75,65,
38,67,195,84,124,73,25,121,41,235,171,170,233,146,162,56,66,49,1,148,159,85,
197,253,184,177,169,90,172,68,63,90,102,147,94,147,62,164,249,244,156,196,97,
153,166,166,200,46,3,43,73,37,126,53,160,172,25,102,165,241,28,100,18,212,46,65,
40,210,130,5,171,158,150,90,198,102,10,69,237,193,55,3,223,132,84,200,136,129,
231,95,231,79,62,61,85,230,200,77,96,145,233,252,191,151,74,206,197,198,224,171,
48,216,232,42,118,245,13,93,76,88,202,74,168,49,52,244,204,216,179,91,28,112,
208,209,10,186,25,37,137,28,50,43,134,115,34,207,168,221,88,27,131,91,152,213,
162,210,16,107,35,128,225,229,254,207,90,183,145,132,149,18,16,181,227,231,243,
232,6,131,13,143,158,158,138,58,61,183,15,134,159,248,132,141,77,60,53,143,78,
98,105,68,223,107,83,74,245,139,52,244,172,208,104,96,236,170,200,127,216,251,
72,145,143,2,158,30,0,61,44,105,91,196,169,124,154,122,127,155,30,189,99,202,
45,13,123,211,135,218,251,71,24,33,89,11,71,141,195,138,84,105,71,169,225,88,
222,178,169,213,163,11,112,73,26,69,128,246,92,241,179,41,24,20,35,165,8,212,53,
212,198,189,55,224,234,49,141,145,134,65,129,195,74,240,230,212,72,242,227,252,
177,49,49,15,20,233,18,204,161,164,64,61,39,232,8,7,221,96,14,120,170,252,94,64,
117,105,15,26,187,14,223,94,165,228,235,177,209,213,85,52,123,103,27,0,53,213,
130,164,34,70,160,214,84,94,69,251,101,179,60,84,239,107,105,46,74,255,0,91,251,
81,167,73,169,3,86,124,186,111,37,104,28,254,211,215,28,158,122,151,19,179,233,
34,197,98,177,148,149,19,101,158,106,106,153,30,179,203,142,52,213,2,67,36,37,
170,2,176,112,186,0,125,96,173,239,248,246,237,196,133,109,10,162,141,71,166,
162,140,189,201,241,24,149,3,61,2,249,45,221,78,148,83,127,16,153,107,124,51,
120,141,44,68,39,150,25,152,180,171,25,139,208,132,161,63,91,123,9,125,40,102,
212,171,70,245,249,250,244,122,7,10,116,16,228,50,41,80,106,190,222,155,195,28,
212,235,24,18,78,247,241,172,151,142,70,1,173,36,192,88,115,101,255,0,11,251,
121,45,200,211,169,178,13,127,207,211,161,188,169,142,176,227,56,136,138,214,
146,90,104,196,76,97,4,148,118,89,20,105,35,141,74,21,191,226,158,222,48,150,
109,74,0,62,189,84,183,145,56,244,233,69,37,87,220,137,35,98,70,153,208,211,83,
197,26,132,74,80,12,102,229,85,66,232,227,241,127,175,179,40,225,84,143,73,36,
249,254,125,36,109,94,32,34,153,29,79,194,211,152,230,167,240,54,154,135,172,
104,214,72,201,30,34,129,200,144,181,212,133,91,92,30,110,125,190,136,135,77,69,
79,77,187,84,26,240,165,122,117,168,165,150,170,186,161,37,172,46,41,181,24,
161,117,244,60,168,0,14,200,160,22,87,39,155,16,79,183,66,128,198,135,135,85,87,
26,5,7,113,233,143,39,65,90,181,241,99,204,8,188,192,82,106,132,17,170,196,205,
28,174,191,113,29,157,213,8,208,62,164,131,166,231,219,134,58,184,85,249,117,
65,40,8,206,79,10,224,117,38,182,101,160,154,151,193,79,67,83,53,88,122,120,
105,163,243,198,240,197,36,174,139,44,129,24,171,150,121,90,202,86,227,235,207,
183,100,26,0,2,153,28,63,62,154,134,175,93,68,128,60,250,102,173,128,107,172,
160,153,8,174,165,149,36,44,178,36,136,34,136,186,232,144,248,227,3,64,96,7,31,
159,101,179,195,164,201,252,94,159,229,233,124,111,168,35,41,237,35,165,14,199,
18,212,45,66,192,32,128,149,80,100,153,11,235,40,24,53,131,106,85,176,226,224,
15,168,185,246,23,220,74,171,38,163,209,132,85,1,180,214,189,70,171,195,229,
165,138,22,243,209,232,251,141,5,159,82,153,14,173,37,101,210,160,34,149,38,250,
121,63,225,238,201,121,6,70,147,195,253,84,234,141,19,100,145,142,178,86,237,
105,254,219,237,96,146,24,209,114,101,22,73,156,47,221,106,179,217,36,80,100,
180,76,52,133,54,252,94,254,221,143,116,82,59,147,52,253,159,111,219,254,170,
117,81,3,87,81,225,254,30,146,146,227,42,104,171,40,18,186,116,38,174,166,74,52,
17,150,113,27,121,12,113,137,88,43,34,172,132,31,170,241,236,193,47,60,69,102,
65,192,87,170,148,166,15,81,235,177,147,197,90,184,234,137,97,130,186,156,77,
52,141,35,137,33,132,2,60,127,189,24,9,173,193,31,212,15,207,189,173,195,21,
214,185,79,231,214,232,189,51,86,98,234,102,120,94,38,19,121,160,137,150,69,87,
72,244,134,145,75,106,147,64,42,182,250,219,250,123,176,150,152,114,106,58,245,
0,233,210,143,31,5,44,176,253,203,169,72,221,117,90,250,95,72,215,119,99,245,
86,252,142,61,176,206,207,240,169,235,85,244,233,179,47,145,89,42,103,251,125,
43,19,201,39,10,56,114,116,125,23,141,42,45,253,125,168,142,50,20,106,227,214,
186,105,18,57,17,178,51,44,139,112,88,19,192,23,36,106,31,143,240,246,163,72,
160,53,207,90,243,167,151,78,145,229,35,208,41,171,97,19,70,86,52,89,21,71,154,
20,87,46,116,146,64,36,94,246,227,254,35,221,67,26,80,230,157,122,132,240,233,
71,21,62,54,153,165,41,52,149,180,82,180,83,227,106,160,178,105,172,12,3,81,
213,135,82,10,74,9,211,112,164,50,254,8,229,209,74,159,79,47,183,170,29,88,174,
27,204,117,15,39,30,58,90,118,138,40,254,218,170,42,147,32,89,89,158,89,14,134,
18,164,146,42,186,72,196,146,20,174,145,233,28,114,125,236,145,67,76,17,215,
148,157,74,120,138,116,149,87,30,180,179,3,227,17,6,176,187,69,169,14,171,145,
248,23,228,11,251,104,99,87,29,39,171,211,246,117,255,210,208,202,25,196,129,
226,104,245,1,173,239,37,172,204,215,1,197,135,224,127,66,47,239,68,211,135,94,
160,244,207,88,79,142,63,35,120,98,96,183,80,222,162,73,54,30,145,172,92,115,
238,226,148,224,58,209,206,7,88,146,79,160,88,162,107,5,185,208,24,92,155,0,24,
253,56,247,224,105,233,94,181,212,121,144,180,190,65,164,22,224,133,176,85,36,
127,100,11,240,15,54,250,251,240,13,232,122,246,41,78,162,52,47,200,211,168,39,
212,129,125,60,255,0,105,173,97,115,254,223,221,105,138,245,188,113,233,210,60,
125,67,198,76,115,131,26,104,121,5,248,140,73,112,166,195,147,169,184,224,123,
184,82,40,124,186,209,97,90,244,229,69,73,13,52,229,234,99,19,133,65,245,107,
169,113,164,130,69,130,148,22,250,31,235,239,213,21,34,157,122,181,160,233,181,
233,194,203,43,93,61,122,221,85,3,50,175,146,70,40,2,105,178,148,184,0,125,61,
211,57,167,86,237,106,82,189,114,90,74,134,123,8,244,217,236,125,37,64,63,218,
14,26,236,13,189,236,131,74,249,117,227,65,192,245,53,49,195,205,26,150,111,81,
81,111,19,70,202,69,181,240,65,12,67,142,5,238,222,244,5,105,94,180,78,9,234,
92,56,187,186,179,72,99,137,165,72,164,154,84,14,177,151,149,175,33,17,221,217,
52,219,128,46,13,193,247,109,7,203,135,90,213,199,169,199,25,28,49,86,249,36,
167,43,231,146,142,25,23,208,100,49,176,253,244,82,3,44,100,253,9,255,0,91,221,
29,22,180,32,84,30,170,24,224,215,20,233,73,135,195,64,184,236,140,242,28,108,
241,199,75,76,158,33,33,251,211,44,238,35,138,162,153,61,79,169,28,89,215,234,
65,191,211,219,145,34,177,210,71,111,77,74,196,21,106,154,215,30,157,38,231,
197,203,174,87,134,154,82,18,109,46,121,34,55,66,20,168,35,128,247,31,67,244,
247,179,110,181,243,167,78,43,147,167,34,189,75,131,55,83,140,147,196,12,254,53,
141,209,180,178,179,35,222,229,244,31,74,218,255,0,79,234,125,163,123,110,36,30,
173,134,207,66,30,222,203,83,73,87,75,36,21,20,240,53,149,10,212,192,178,128,
140,218,100,46,186,147,87,6,250,73,31,225,238,136,166,38,53,108,116,204,200,93,
116,230,189,14,201,153,198,99,96,134,10,250,28,101,55,241,4,83,77,150,72,39,127,
44,244,143,127,222,129,42,85,94,14,65,177,231,79,11,201,246,96,138,86,152,4,
113,175,30,137,222,54,44,105,90,142,148,212,125,152,63,134,85,69,65,37,53,66,
195,36,176,199,170,40,227,142,85,122,118,93,105,28,241,51,44,10,64,253,183,213,
97,111,235,237,84,45,165,193,28,71,76,181,177,198,170,212,244,201,181,168,177,
251,155,39,145,130,93,163,141,202,69,28,81,181,68,145,131,79,12,111,36,99,202,
34,169,167,104,197,209,215,88,91,159,80,177,250,123,95,28,97,221,129,142,160,
117,233,9,137,84,137,136,39,135,77,25,254,167,219,245,57,10,10,60,12,233,131,
145,113,117,213,132,84,187,86,37,109,77,31,249,84,177,87,249,2,178,67,87,28,133,
10,141,36,47,210,252,251,241,182,70,98,136,104,71,175,86,75,201,21,75,63,118,
105,246,125,159,103,77,57,14,136,207,140,75,228,235,153,227,162,143,24,245,244,
178,208,99,227,151,31,26,82,50,173,98,214,212,210,73,32,229,238,82,36,102,63,75,
155,92,123,97,173,36,160,98,113,199,165,9,184,70,172,6,154,181,105,147,156,244,
15,228,118,134,118,89,235,34,245,54,59,195,174,15,37,10,195,106,120,90,16,241,
201,4,160,74,181,10,36,14,117,127,100,223,218,86,134,76,96,233,251,58,88,183,17,
80,26,247,215,215,253,95,103,72,156,134,222,56,150,33,214,57,42,37,104,196,12,
136,229,94,35,196,143,20,118,228,131,198,160,77,175,237,162,186,6,70,122,80,178,
106,200,225,212,140,46,215,204,231,114,213,11,75,67,37,66,69,72,199,84,69,33,88,
162,91,40,105,218,98,60,58,139,91,242,127,62,244,160,147,93,56,235,77,34,42,138,
154,103,172,248,221,177,144,169,104,113,117,52,213,84,51,201,33,167,74,121,2,
198,100,49,221,231,137,90,114,19,203,12,65,152,151,60,131,199,4,94,235,17,32,41,
92,159,231,215,158,96,163,80,96,87,207,252,29,11,155,98,130,60,38,78,171,22,
210,197,60,72,161,34,95,56,151,206,228,56,136,180,138,235,164,194,65,245,40,252,
113,237,51,135,140,144,203,70,7,253,95,234,253,189,83,197,14,186,188,186,141,
216,185,201,134,224,197,53,34,193,20,205,128,138,42,167,149,53,44,181,112,25,9,
153,212,155,153,4,106,161,79,215,211,238,209,106,64,77,51,215,149,107,86,206,
154,245,195,21,186,234,105,163,138,74,26,186,184,94,186,8,227,70,122,133,47,117,
117,73,90,36,144,188,242,66,242,68,224,223,73,183,208,123,116,77,34,169,82,194,
191,47,242,117,70,78,227,95,46,151,59,118,122,141,209,83,91,230,169,149,252,75,
42,69,79,61,68,130,24,34,98,190,58,161,28,135,73,146,102,70,110,65,3,232,45,
237,57,132,248,133,202,130,105,83,81,231,233,213,181,144,170,162,180,63,234,61,
9,219,34,166,141,50,56,139,65,251,45,147,198,210,148,103,121,86,105,99,212,26,
57,85,9,136,21,100,213,118,177,98,44,13,253,161,250,105,11,41,40,77,79,166,56,
244,243,72,180,61,254,94,189,9,57,124,149,77,46,74,173,230,164,156,172,114,61,
69,68,136,30,89,33,134,41,100,132,22,75,188,65,53,195,207,245,2,254,246,150,
242,234,44,71,175,84,50,46,144,136,223,47,79,231,212,140,78,86,75,234,169,125,
107,91,139,158,173,97,241,195,77,20,117,159,117,87,19,146,84,42,83,249,0,138,
229,193,210,19,158,125,155,90,198,26,36,82,79,10,122,116,138,82,192,177,90,96,
255,0,171,143,66,37,22,11,112,100,6,55,111,208,44,245,112,229,176,181,213,51,83,
82,199,45,101,98,253,170,208,87,188,130,154,37,57,19,59,60,65,163,72,213,158,
68,253,54,7,217,189,181,145,170,141,32,131,199,207,237,62,167,162,185,238,149,
11,59,55,112,52,244,255,0,99,169,180,123,27,126,75,184,242,244,121,44,53,37,53,
13,94,39,22,217,41,191,134,209,210,199,148,199,213,173,76,180,41,77,83,246,102,
162,57,170,163,86,80,142,86,84,150,161,75,0,195,133,34,214,102,119,87,64,20,211,
243,244,251,58,101,174,160,8,142,173,220,43,78,56,62,117,21,242,253,152,227,208,
157,181,250,203,122,127,15,166,174,93,158,245,56,42,236,252,248,196,170,175,142,
120,107,105,140,49,71,88,166,169,146,25,229,169,104,169,230,64,111,166,82,35,
224,18,125,236,90,178,144,186,86,132,226,184,52,245,233,163,118,174,11,107,109,
74,51,65,81,95,79,151,71,71,168,62,56,238,110,229,221,127,221,109,155,140,93,
233,252,15,29,138,205,249,178,24,108,148,152,127,37,117,100,84,159,195,177,139,
81,75,29,80,106,106,182,255,0,41,153,237,12,64,250,221,236,168,76,60,31,12,6,
209,173,5,51,67,76,250,87,56,232,191,199,14,115,40,71,32,226,185,199,14,28,106,
48,58,61,245,191,17,59,87,169,182,214,82,159,61,181,246,150,62,106,140,206,78,
60,38,42,131,122,96,234,25,99,251,92,127,154,161,150,41,80,210,224,224,169,213,
12,170,142,102,46,199,66,50,139,251,87,105,20,140,101,101,66,23,87,159,14,28,7,
230,58,67,125,117,0,240,85,164,5,200,205,43,90,131,231,243,167,77,21,141,77,182,
40,113,84,248,172,45,13,76,243,121,97,171,153,114,149,205,81,67,61,36,244,213,
210,165,52,244,53,17,211,84,84,194,172,98,66,2,6,10,26,192,146,61,152,148,210,
162,135,29,20,164,162,70,58,177,254,90,244,99,186,99,112,82,80,143,181,193,201,
138,167,169,83,95,146,175,175,138,191,33,73,83,41,138,122,88,138,86,28,162,101,
22,42,218,217,234,254,215,68,81,218,89,189,42,5,239,239,112,235,109,65,176,61,
15,250,143,15,62,169,117,28,85,5,91,83,1,254,161,228,13,124,186,60,157,71,242,
15,39,179,49,56,12,101,59,109,168,176,21,185,44,182,39,44,187,142,182,149,31,3,
79,28,180,213,25,74,138,202,185,86,166,74,24,42,166,40,97,113,3,249,138,48,250,
155,123,114,91,113,90,145,159,80,73,175,161,3,207,207,164,208,200,204,190,25,3,
73,242,101,0,142,21,4,156,250,122,244,101,170,118,250,246,61,58,84,209,227,176,
114,227,235,114,122,231,131,39,132,199,84,211,75,45,58,164,213,211,109,250,239,
181,243,210,100,234,42,196,104,254,87,138,56,221,3,40,12,222,211,157,9,95,20,
146,195,246,211,202,191,42,103,167,74,220,53,82,221,85,99,60,5,5,42,56,233,244,
62,70,184,175,68,99,113,252,45,236,141,187,179,119,178,82,211,230,107,255,0,
136,111,57,55,126,71,13,95,132,74,156,85,71,241,35,37,37,13,53,43,80,196,177,
210,226,113,152,232,217,150,41,213,207,158,102,111,82,133,246,218,181,181,74,
199,53,67,87,253,144,58,86,69,231,132,175,37,181,25,72,245,245,173,91,203,135,
72,236,103,199,221,241,143,206,96,112,180,24,13,163,77,69,20,123,114,76,166,24,
99,178,113,86,197,73,35,180,217,10,23,169,211,73,81,36,248,165,97,81,77,172,36,
114,120,184,99,250,10,209,31,233,171,31,128,249,244,88,183,8,100,145,70,163,38,
104,40,124,235,67,235,243,233,147,181,62,62,111,90,157,203,159,150,13,187,53,
100,90,233,97,143,39,133,165,131,248,106,60,34,32,113,117,245,114,53,50,197,84,
35,40,172,186,72,44,111,126,110,88,112,30,82,136,185,32,30,29,24,67,34,195,111,
226,75,37,21,73,6,190,167,252,191,151,64,102,87,226,166,248,171,198,213,97,107,
118,132,147,75,186,177,42,124,148,81,9,179,88,117,131,33,81,40,166,199,165,74,
197,65,83,151,154,154,241,197,28,115,184,117,245,17,164,251,67,20,2,73,46,145,
168,7,248,5,124,186,91,61,201,130,59,57,134,170,87,242,38,156,13,51,79,60,113,
242,232,50,221,95,14,51,29,117,177,30,190,171,28,245,13,75,75,34,215,83,99,147,
41,61,52,25,54,197,86,87,190,50,170,87,166,138,63,191,169,142,125,31,164,70,
141,17,85,7,130,88,54,105,28,110,1,5,128,225,254,31,246,58,121,119,39,154,101,
46,140,171,81,146,41,196,143,240,126,222,128,94,174,248,235,151,174,195,231,62,
242,159,29,71,143,24,204,133,80,161,167,45,81,95,139,150,127,4,143,67,83,42,201,
60,244,82,211,122,166,154,52,83,112,129,56,55,3,112,89,29,7,88,0,80,154,121,
138,254,223,183,167,39,190,83,42,136,201,102,168,21,242,52,243,249,250,3,208,75,
186,122,31,45,46,34,171,53,83,129,207,211,194,249,250,76,110,3,40,248,249,82,12,
206,68,82,202,240,68,137,77,83,81,52,212,245,180,14,29,67,40,86,102,4,49,250,6,
102,180,253,50,250,90,132,138,26,113,63,207,203,165,214,247,131,197,88,252,85,
170,130,88,87,128,243,226,56,215,160,89,250,215,119,154,166,131,43,69,144,162,
157,167,165,198,197,44,212,135,239,41,74,85,86,70,105,105,105,105,193,155,72,
145,28,144,7,44,172,44,2,251,72,109,101,162,134,6,188,63,159,151,75,22,238,5,
241,10,145,78,60,113,246,147,254,170,117,147,117,108,58,156,101,14,224,134,90,9,
50,186,38,198,83,85,3,50,163,70,241,213,197,45,77,102,42,132,186,24,106,35,117,
71,209,232,105,90,224,92,31,119,250,98,130,99,160,158,31,241,96,116,215,213,
163,188,0,72,21,104,105,231,229,74,19,210,0,237,140,218,238,74,58,120,241,213,
190,15,225,244,208,199,29,94,45,221,50,51,253,252,159,104,105,165,174,166,143,
68,200,100,103,67,169,215,72,39,95,208,123,174,146,28,130,164,129,138,211,137,
226,63,49,254,163,213,181,161,0,134,21,63,210,225,235,195,253,85,233,139,119,
117,190,119,21,144,166,16,82,195,29,37,86,75,35,67,85,20,144,172,110,198,41,69,
68,249,25,105,149,86,21,195,253,157,74,41,104,181,129,227,36,182,162,71,187,
173,175,139,25,145,70,53,102,163,143,175,236,225,214,141,215,134,218,8,238,167,
145,225,140,126,103,162,211,186,122,215,118,110,252,245,58,109,220,110,111,46,
244,251,120,78,78,19,29,85,38,219,130,154,170,170,166,120,161,135,47,5,27,207,
62,86,158,142,156,234,143,83,172,113,6,176,96,46,11,164,133,24,170,87,245,8,39,
25,20,169,252,255,0,201,243,232,197,39,49,2,204,191,167,80,42,120,214,131,231,
79,243,244,62,236,63,137,219,211,17,154,174,255,0,74,249,154,173,179,36,113,
209,85,83,227,55,22,50,134,82,237,61,4,235,13,92,50,209,70,96,154,40,49,166,23,
134,57,42,22,86,154,71,50,34,176,35,218,251,77,184,201,17,146,71,34,48,105,66,7,
31,151,216,41,249,158,139,239,55,37,66,35,142,32,100,62,135,203,231,246,154,
253,131,29,45,242,253,109,209,59,98,150,12,70,219,198,75,156,251,45,191,145,170,
204,238,252,158,79,49,13,53,94,226,208,207,37,75,98,96,166,130,130,74,100,165,
147,67,70,146,74,177,33,253,101,189,190,150,182,235,80,169,85,3,137,39,39,236,
255,0,139,233,51,94,92,185,44,94,132,145,64,41,195,237,232,175,82,239,45,191,
178,232,90,12,77,109,61,5,100,180,82,228,105,113,248,184,107,36,121,19,33,84,
232,144,255,0,16,138,138,69,167,88,174,204,215,145,68,86,250,115,237,50,203,20,
108,65,96,26,152,167,251,29,45,240,103,152,41,40,74,249,147,254,172,244,138,221,
221,154,50,53,84,248,156,21,84,85,53,85,24,250,57,235,169,164,189,108,254,52,
169,251,90,124,132,50,73,27,77,91,79,87,93,14,146,121,85,88,200,34,238,190,219,
186,188,94,193,16,201,25,175,203,253,158,148,219,88,145,173,159,10,14,15,173,
122,13,42,183,118,243,166,193,226,177,223,222,169,2,227,235,242,73,151,199,81,
208,164,70,188,85,75,41,134,150,24,178,43,26,213,147,19,169,30,47,13,209,137,4,
16,15,180,134,246,110,21,20,243,249,244,179,233,34,36,157,21,198,9,242,253,157,
48,109,158,205,222,244,245,20,169,77,44,57,200,255,0,132,87,227,68,149,152,127,
177,138,240,212,181,81,129,171,169,234,85,169,234,32,105,192,125,106,160,242,
121,252,212,95,76,0,168,175,151,14,182,246,48,183,10,131,95,94,148,123,139,185,
99,122,232,211,43,130,168,167,133,41,214,87,154,20,106,202,86,165,93,50,137,41,
220,71,16,21,73,83,16,93,44,138,145,171,18,73,63,87,77,226,16,42,180,207,219,
254,172,244,210,216,186,214,141,196,116,31,80,246,142,217,173,154,178,115,91,22,
52,44,21,111,79,76,18,164,46,70,73,100,17,26,95,63,219,184,166,125,36,191,169,
172,5,249,226,222,235,245,17,180,108,3,80,210,180,245,249,116,233,181,149,89,
104,42,63,193,210,43,35,186,176,245,146,44,116,153,154,105,158,39,145,106,208,
199,34,24,227,42,52,172,83,13,10,201,127,169,23,184,31,143,101,114,13,64,208,
249,103,165,201,27,37,42,180,30,93,63,109,10,186,88,171,232,227,210,89,231,201,
64,82,103,63,182,145,21,11,228,77,70,214,230,252,243,244,3,222,226,139,195,80,
6,122,110,118,102,169,168,24,233,206,174,120,171,100,202,36,132,67,53,38,66,
121,82,90,115,17,152,163,75,52,38,57,227,97,166,35,100,22,35,235,127,111,133,
212,114,122,100,48,65,140,215,166,188,134,220,131,63,131,1,164,158,105,40,245,
74,145,84,149,147,73,22,50,182,148,211,16,81,249,177,231,253,191,183,154,48,
200,71,152,234,171,57,138,65,229,95,78,146,241,245,94,66,108,61,125,67,154,37,
20,149,218,35,49,72,81,164,100,72,216,44,34,40,202,177,211,32,185,63,78,127,
167,180,194,204,178,182,170,113,233,65,189,80,234,5,77,71,76,105,210,250,170,25,
163,169,53,30,40,42,107,42,98,167,47,60,201,8,49,58,68,1,136,72,230,50,204,28,
133,39,129,111,108,181,154,163,85,143,111,79,27,242,64,162,231,164,250,236,201,
27,35,149,198,211,67,60,49,210,66,179,67,40,0,197,251,193,86,16,227,244,171,
188,141,107,17,112,79,62,234,177,38,166,85,29,56,211,144,136,199,36,244,141,251,
122,188,101,94,74,138,166,43,159,185,122,93,70,224,10,133,145,100,12,188,13,69,
17,190,188,14,125,185,74,10,17,235,213,170,24,43,131,229,215,116,249,133,21,
234,194,50,0,144,163,48,98,199,82,161,93,64,18,65,110,71,7,142,61,233,13,41,95,
94,172,209,146,40,14,58,84,225,243,48,197,185,86,176,207,26,67,207,158,25,2,
133,148,78,17,42,81,133,153,93,100,71,55,82,44,61,184,27,245,13,58,100,161,240,
192,161,255,0,138,225,212,205,209,151,196,215,84,137,224,108,116,222,9,190,213,
227,148,50,69,122,74,136,204,69,68,109,26,199,227,85,191,2,205,110,56,247,169,
102,210,164,168,24,234,177,65,252,68,138,255,0,151,164,92,209,61,53,92,179,189,
66,44,162,105,15,150,50,135,196,170,19,196,232,183,10,89,193,250,30,125,148,
189,204,172,65,12,71,75,4,64,0,186,106,58,105,139,32,148,213,213,181,114,17,51,
207,231,26,111,234,5,153,157,72,23,0,183,58,120,246,211,200,239,130,196,227,167,
17,126,17,166,128,116,168,193,238,63,178,138,190,101,163,47,28,144,8,181,74,0,
209,173,25,128,136,149,42,117,186,155,255,0,82,7,178,251,139,35,49,82,15,112,53,
233,64,146,128,131,195,164,213,86,225,148,51,199,28,113,180,50,51,72,139,169,
166,28,169,35,95,224,177,54,224,142,61,216,89,129,220,65,168,252,186,247,136,
104,86,184,61,53,203,184,242,46,158,39,208,21,106,132,218,76,72,8,123,125,117,
126,177,167,219,209,217,33,37,252,233,78,61,88,204,86,128,28,117,211,103,50,113,
8,153,106,237,105,218,100,85,130,34,22,67,45,152,137,29,26,231,219,130,214,58,
147,76,210,158,157,123,199,108,122,125,131,166,233,115,53,50,180,162,104,226,
148,235,113,174,69,99,34,171,187,51,38,160,64,210,79,22,252,15,167,181,2,21,28,
24,245,83,34,147,253,152,167,92,27,53,90,168,96,64,154,20,143,25,101,212,240,
250,70,165,71,36,145,114,62,166,254,239,224,165,106,87,166,137,4,226,189,55,73,
45,93,68,183,121,90,77,100,146,53,94,220,27,157,54,8,13,191,195,219,139,165,73,
160,199,94,161,167,88,204,12,88,93,149,77,153,136,55,44,108,72,60,139,95,133,
247,178,245,168,165,7,91,11,242,235,32,113,227,65,102,83,114,87,139,113,111,234,
73,60,155,255,0,135,189,84,240,28,58,182,149,2,167,207,172,97,24,184,184,185,
28,131,244,250,253,46,120,250,131,238,250,43,64,48,122,107,133,104,122,119,163,
150,40,86,84,159,84,176,188,113,147,0,119,143,247,84,176,87,86,79,237,161,111,
161,28,139,251,216,90,125,132,117,163,83,246,245,158,186,166,158,25,213,105,85,
26,40,163,80,245,17,201,43,37,75,56,55,145,67,217,144,128,250,77,255,0,165,189,
219,4,245,160,13,51,211,39,150,51,41,55,33,71,164,182,174,24,16,44,183,181,189,
39,159,167,189,84,211,134,122,181,49,215,255,211,208,178,153,208,202,71,145,
185,87,85,30,155,253,46,1,254,160,145,254,191,186,53,6,122,247,166,58,238,72,
219,214,65,3,234,194,198,194,231,139,131,248,189,189,236,100,15,78,189,212,61,0,
130,110,84,136,210,246,33,5,238,109,113,197,255,0,215,30,239,214,143,207,174,38,
55,66,31,80,96,24,114,164,254,71,224,144,126,159,159,118,11,154,30,29,106,131,
174,66,68,49,58,107,144,106,154,224,17,114,73,95,77,255,0,173,143,248,254,125,
248,212,86,188,122,240,174,43,210,188,34,64,180,180,191,108,207,80,228,7,112,
214,42,235,100,208,252,5,42,15,22,250,143,245,253,184,124,133,58,167,175,167,78,
175,141,139,74,51,169,147,246,213,152,43,132,141,116,177,178,131,123,185,32,115,
249,30,244,87,35,211,175,3,199,166,204,133,32,164,97,81,20,14,34,120,66,199,36,
110,86,32,239,96,79,62,162,84,181,152,126,61,250,157,184,25,234,195,207,61,40,
33,79,38,44,215,212,83,211,181,76,53,226,142,163,237,71,142,105,60,104,154,103,
49,254,159,28,139,201,224,22,250,129,238,230,186,42,70,65,233,154,209,194,212,
129,78,148,184,217,176,233,81,79,87,87,135,158,162,138,39,115,89,21,115,186,198,
242,146,124,40,77,56,86,240,146,70,162,125,127,142,61,249,116,215,43,129,235,
213,95,89,82,22,78,227,194,157,40,255,0,223,159,95,12,173,6,212,90,58,137,105,
37,48,94,166,163,195,80,124,133,21,130,74,154,22,25,30,54,228,61,212,123,80,4,
102,131,194,227,210,114,101,90,159,31,0,240,255,0,87,249,122,116,109,171,182,
107,112,63,124,148,84,20,50,203,225,50,202,217,122,152,4,48,212,148,154,17,78,
245,30,65,63,154,49,175,74,43,114,57,177,246,150,80,53,146,22,131,167,17,228,21,
82,73,63,103,249,58,87,99,58,132,72,208,253,182,72,86,209,228,169,159,33,28,21,
174,176,193,4,116,225,117,172,115,64,241,53,76,68,45,138,139,29,71,241,127,110,
90,197,169,141,60,250,102,107,154,2,52,247,3,229,210,155,1,208,112,84,83,103,
171,229,207,109,218,57,227,169,108,165,6,186,218,234,122,106,152,101,158,24,99,
196,83,36,148,213,108,245,230,105,117,47,147,199,19,34,57,105,5,128,38,95,70,66,
147,138,147,235,210,67,124,75,170,0,104,7,152,255,0,55,65,191,97,244,212,56,140,
150,79,199,185,176,153,105,41,97,138,83,79,139,90,217,228,122,137,76,62,106,52,
169,168,130,158,150,86,165,105,181,72,67,20,211,250,73,250,123,75,45,177,169,56,
233,92,55,138,66,130,164,116,2,228,49,21,216,10,232,210,93,80,190,131,52,78,175,
162,57,98,245,105,37,24,176,141,156,11,133,38,246,246,89,52,76,164,169,29,24,
199,34,200,42,14,58,16,49,187,169,107,233,49,208,84,214,172,102,146,6,167,115,
38,137,228,32,3,42,44,109,48,180,49,42,253,116,243,237,132,145,225,20,39,180,
117,167,130,54,169,210,43,210,166,155,31,75,81,93,225,76,237,53,75,10,200,146,
57,60,69,169,36,142,65,27,180,166,72,29,100,92,114,164,133,93,136,14,172,62,
135,218,200,238,163,174,162,58,76,208,183,225,25,255,0,87,229,210,203,102,200,
113,52,217,121,96,174,48,125,229,101,84,109,252,15,205,36,239,12,58,156,50,154,
149,143,76,62,179,110,1,99,201,246,99,5,196,125,196,72,63,46,61,33,184,130,74,
160,104,234,0,226,122,207,141,168,138,186,151,17,87,89,54,170,61,51,195,83,22,
82,4,174,174,169,101,150,54,44,213,78,142,228,52,114,0,21,46,20,130,47,237,209,
38,115,194,159,111,76,50,232,45,78,35,211,20,252,186,23,48,123,193,233,26,166,
154,22,104,169,41,169,25,97,74,154,138,196,167,170,50,197,36,144,70,105,185,165,
141,161,144,125,21,64,127,200,246,228,115,178,149,207,151,76,188,33,240,195,53,
233,94,155,190,170,186,71,25,140,94,27,37,14,79,26,211,83,180,236,180,235,224,
167,210,166,49,83,69,9,149,9,150,54,244,233,5,128,3,219,166,231,94,145,164,19,
94,153,250,96,181,163,48,167,242,253,189,50,85,117,246,197,223,94,76,118,227,
201,87,237,172,141,6,77,168,96,168,161,194,210,229,105,140,85,17,66,244,180,180,
211,73,83,73,83,143,136,241,207,39,200,46,56,191,182,188,56,230,42,30,171,159,
44,244,232,150,91,112,198,49,171,21,227,210,231,172,190,61,245,181,46,123,112,
197,87,216,57,49,148,163,194,163,227,225,200,224,32,167,165,214,124,71,192,124,
85,213,79,87,44,69,10,200,25,144,48,33,185,23,30,222,138,210,35,172,25,14,160,
125,49,211,83,95,79,68,253,33,160,241,161,207,73,90,111,143,207,149,221,117,85,
49,100,32,169,171,163,206,84,69,69,142,153,234,40,154,170,60,181,60,241,125,
197,2,189,24,160,200,203,79,10,134,147,67,198,225,27,74,130,79,181,34,192,18,8,
32,176,56,21,167,31,49,228,105,231,213,63,120,5,142,129,72,82,50,120,208,131,
231,230,58,114,204,116,150,246,219,56,186,167,204,108,236,236,17,68,245,53,174,
217,61,175,91,131,150,49,17,167,241,61,70,73,225,37,169,26,32,172,159,184,164,
137,5,144,18,79,182,164,182,89,21,196,145,2,71,153,25,165,61,122,176,157,124,69,
100,151,6,156,13,115,242,31,236,116,8,197,212,255,0,222,132,175,154,186,112,134,
42,4,156,148,163,147,205,28,53,62,105,97,20,243,75,233,84,15,25,210,77,200,12,
46,61,160,138,193,144,229,135,249,186,50,250,208,56,41,244,253,158,189,32,113,
219,10,174,76,148,20,24,140,69,68,193,89,35,166,138,60,116,230,182,162,178,90,
134,138,24,145,100,134,52,150,99,32,253,76,206,47,244,246,225,133,141,21,19,31,
103,87,107,149,0,151,124,253,162,157,15,125,97,213,181,21,251,171,63,70,35,174,
161,147,27,183,50,18,34,61,77,77,83,211,202,241,104,88,69,93,52,102,142,176,25,
68,151,142,50,85,90,224,250,129,246,215,211,55,137,42,58,254,18,122,163,93,175,
133,27,43,3,86,255,0,87,249,58,113,235,253,129,158,163,207,109,44,133,93,101,
106,209,38,239,166,194,212,198,250,89,214,120,143,221,84,75,224,117,9,78,146,
199,17,98,7,60,218,230,231,219,17,195,77,52,248,107,211,179,76,172,28,126,34,
181,175,70,243,116,116,166,241,175,174,158,92,102,212,207,102,30,23,202,136,96,
196,226,170,77,93,109,37,69,117,83,164,233,27,196,86,170,1,126,86,234,172,159,
75,223,219,178,91,55,112,8,77,125,62,222,144,165,202,167,250,32,3,7,39,168,219,
59,226,23,103,101,41,113,213,245,184,184,98,199,230,112,241,102,169,170,36,153,
252,212,244,233,37,102,70,183,23,91,2,197,50,227,183,52,212,176,168,251,89,222,
59,52,138,28,169,12,21,125,165,131,188,113,246,247,99,246,127,159,164,151,91,
164,72,210,162,177,168,168,167,149,120,99,213,122,52,20,93,43,179,241,117,93,73,
95,147,203,97,243,88,214,218,217,31,239,29,30,211,196,101,112,155,138,179,39,
80,149,9,45,30,67,114,154,74,214,163,220,52,19,141,26,89,22,145,160,139,73,54,
58,129,170,91,233,120,64,21,193,169,3,162,135,185,37,101,28,26,162,128,254,94,
95,206,189,28,76,101,23,81,231,241,176,127,113,182,180,45,144,196,86,199,21,93,
95,100,125,191,247,135,37,143,90,124,117,127,142,150,45,184,171,140,166,198,83,
120,35,137,12,147,60,146,188,96,149,212,45,236,193,16,56,21,90,128,120,249,211,
231,209,116,146,120,76,196,49,200,255,0,87,250,171,208,177,146,237,106,188,190,
49,113,209,100,105,241,56,248,170,164,163,135,110,71,77,73,145,195,81,189,84,
62,41,101,81,89,10,52,212,98,20,40,204,32,73,44,74,155,142,125,237,32,141,90,
186,123,189,122,105,238,102,43,161,91,183,203,167,140,39,120,238,101,154,158,
133,51,240,210,83,96,240,211,226,104,154,28,30,19,21,81,79,77,151,200,81,86,201,
75,14,66,138,130,158,170,162,134,182,174,129,29,226,145,152,22,69,211,107,91,
218,165,155,226,7,200,83,162,249,32,26,129,11,82,217,63,234,249,117,143,51,190,
42,115,180,181,75,13,76,140,244,20,53,20,112,84,68,98,115,79,53,92,166,243,39,
158,70,89,30,79,43,74,195,234,183,230,220,123,216,53,28,122,109,150,142,42,180,
7,252,157,56,109,225,143,197,226,227,166,206,65,84,211,213,85,213,210,163,193,
138,194,66,162,73,40,100,150,57,132,109,44,147,214,74,137,24,123,130,129,135,55,
224,251,124,70,116,21,243,169,255,0,7,167,77,7,214,117,47,195,143,94,148,251,
123,19,69,65,184,171,159,29,93,147,164,105,168,102,170,101,168,134,128,227,234,
212,213,211,85,192,181,50,209,137,30,154,97,40,214,193,25,204,66,255,0,144,7,
182,190,2,67,122,127,135,167,193,15,167,77,56,249,227,135,219,254,170,244,60,
109,106,204,180,184,249,41,161,237,12,15,223,229,50,120,76,124,24,217,240,212,
149,120,248,107,227,168,138,174,146,154,20,154,160,212,182,20,172,198,39,103,
141,44,88,155,41,60,52,2,147,128,212,165,122,120,179,84,138,175,26,15,219,246,
112,234,198,182,7,96,75,137,198,237,239,227,203,143,220,185,76,253,93,13,54,78,
156,229,27,6,49,248,186,138,161,35,10,105,177,49,255,0,14,97,36,204,36,45,28,
179,76,168,46,84,220,159,105,222,39,144,176,50,182,149,225,231,229,143,245,112,
233,255,0,26,24,66,21,182,82,237,130,6,48,77,107,143,231,76,142,142,46,51,120,
68,212,89,173,185,54,114,159,13,65,85,51,195,140,171,151,118,62,70,10,120,225,
104,163,142,24,106,235,104,169,215,37,42,73,16,16,49,242,128,23,71,225,172,128,
196,65,142,81,30,162,56,138,83,252,184,243,175,70,41,59,186,205,6,189,42,78,14,
162,127,153,25,242,167,31,78,157,119,7,200,76,174,215,207,109,169,219,33,180,
255,0,134,197,79,38,50,167,33,134,197,65,54,82,133,69,52,114,84,228,234,30,60,
108,203,60,102,26,125,36,73,12,164,74,254,130,20,177,247,72,182,180,158,57,87,
67,248,132,212,2,77,14,112,56,227,143,151,151,78,79,189,205,105,44,47,226,69,
225,129,66,85,123,134,50,213,166,120,121,131,158,24,175,72,205,195,189,227,160,
216,120,172,134,226,196,87,99,229,155,115,207,185,14,230,204,109,44,239,241,29,
199,38,83,34,202,176,83,214,99,49,180,56,145,71,83,142,150,57,36,134,243,76,25,
90,69,99,160,5,89,13,161,107,137,150,39,5,68,96,105,14,6,154,15,66,73,168,63,
151,151,159,72,174,111,149,108,161,121,227,96,198,93,90,204,109,87,169,242,42,2,
210,148,175,31,94,139,238,232,221,216,29,207,66,248,243,188,86,178,154,170,58,
252,147,209,215,237,50,105,177,241,196,211,86,201,227,25,124,122,212,206,19,205,
234,49,201,21,162,0,6,6,199,218,216,44,221,100,102,250,96,13,6,117,26,159,159,
30,61,22,220,223,44,177,34,125,89,101,169,198,128,64,244,226,185,255,0,81,232,
23,207,246,29,12,20,85,24,57,119,218,230,141,69,6,42,154,117,175,162,165,142,
103,167,251,203,164,24,220,107,82,168,197,61,37,50,196,222,96,92,48,44,111,127,
170,145,110,233,175,88,65,154,129,82,127,193,235,243,233,43,92,36,154,74,59,176,
211,74,208,10,122,12,255,0,42,116,31,237,238,192,217,114,224,114,24,196,235,106,
12,142,39,17,84,149,208,212,81,165,54,63,35,152,90,35,29,48,81,150,129,194,84,
196,106,100,105,196,181,2,29,104,218,74,16,164,150,76,13,245,5,151,143,0,7,3,
243,207,74,210,229,86,213,99,124,249,146,120,143,65,246,116,16,157,195,177,163,
196,156,110,71,102,98,51,169,65,149,202,80,209,28,196,178,102,168,228,166,171,
170,243,82,36,79,144,56,76,126,61,49,177,199,39,142,174,22,50,137,28,168,44,160,
89,249,99,117,93,45,35,18,61,63,205,210,120,166,12,213,72,145,107,230,113,246,
228,122,244,8,103,58,171,175,183,70,227,76,205,53,38,216,161,192,193,37,15,221,
209,182,127,52,245,53,114,211,207,8,167,154,146,65,60,211,68,104,86,188,130,181,
12,4,242,202,53,217,62,169,252,34,66,177,148,254,106,7,15,47,245,26,244,173,
110,50,233,225,10,127,69,137,227,254,174,4,80,116,152,236,174,185,235,185,242,
146,81,199,246,20,212,213,145,85,84,226,234,62,250,134,182,174,70,197,208,137,
43,177,185,223,29,44,176,181,124,210,208,105,166,48,196,18,21,153,53,130,61,70,
201,81,151,85,97,67,143,245,127,135,173,59,138,182,130,203,194,166,181,253,190,
85,233,251,253,23,124,93,197,255,0,114,42,243,245,27,141,114,24,250,204,29,93,
85,6,6,42,58,58,138,172,61,42,43,102,177,121,202,186,170,218,149,132,75,230,
167,148,212,37,60,136,89,89,22,53,95,163,44,173,169,138,168,24,225,83,254,15,
246,122,81,28,194,129,90,70,98,72,224,1,253,135,203,246,30,145,63,41,251,23,227,
172,89,188,70,35,7,210,91,34,158,77,172,137,70,107,38,197,228,115,213,181,149,
212,241,82,80,138,74,156,181,85,111,240,156,158,42,167,206,141,36,16,165,28,4,
233,45,28,140,5,181,26,168,0,48,169,60,61,0,249,15,243,215,167,157,166,39,82,
177,84,166,124,234,105,196,147,195,242,3,162,93,220,91,243,1,22,75,248,182,219,
198,82,237,248,162,219,15,73,73,135,196,67,22,27,1,140,74,90,197,163,90,154,28,
117,21,76,211,189,124,243,177,120,73,116,132,68,133,80,40,22,41,110,132,100,2,
224,97,77,43,65,74,159,151,173,62,206,159,183,50,225,67,154,22,7,28,73,3,28,125,
63,195,208,27,69,184,171,183,35,138,186,120,233,38,166,166,198,197,61,85,125,
101,77,73,174,122,138,202,86,142,122,202,121,234,226,138,45,108,242,8,231,150,
99,165,152,122,92,251,91,110,67,219,162,34,138,113,253,190,157,51,50,178,72,89,
171,94,31,179,215,162,143,217,253,150,248,252,78,236,135,99,35,238,124,148,24,
108,165,29,70,231,197,67,30,79,5,128,174,48,79,77,226,199,87,6,254,29,83,146,
133,208,248,221,75,198,143,24,54,118,178,146,155,203,213,84,120,224,96,101,161,
207,144,249,15,42,255,0,46,142,173,44,93,154,57,103,82,177,226,139,192,159,183,
204,14,137,238,222,122,252,110,219,209,159,198,215,227,103,143,18,176,44,198,89,
42,161,168,142,169,216,135,19,212,69,12,205,87,88,29,164,153,143,12,246,177,
185,246,20,213,164,141,109,147,231,254,127,243,244,40,195,173,35,24,175,250,143,
217,214,60,174,75,22,95,29,76,248,154,180,168,169,168,196,82,72,203,71,21,42,9,
30,162,5,18,203,60,102,66,208,82,204,117,16,197,117,218,224,19,199,189,72,229,
88,15,46,173,28,100,175,197,210,147,113,227,182,246,66,135,7,231,196,81,197,13,
93,124,205,85,45,55,174,105,62,218,157,111,44,198,17,12,145,33,119,5,72,187,31,
167,3,222,164,110,210,87,211,175,34,208,229,191,205,208,91,141,216,101,194,81,
82,100,97,134,28,132,153,56,163,49,202,178,207,68,126,246,158,36,135,247,169,
230,6,102,70,26,174,236,72,26,108,57,62,217,70,114,180,102,29,58,250,107,133,61,
57,103,122,146,166,28,183,216,80,238,35,61,120,195,201,170,142,40,226,88,158,
38,111,55,152,154,106,169,6,170,75,218,82,208,168,185,22,12,47,237,64,53,29,
174,9,233,145,32,169,170,209,122,5,179,187,114,175,25,67,52,153,13,171,69,149,
166,137,230,74,153,168,213,33,200,65,173,53,173,94,184,18,58,143,34,218,228,133,
41,127,241,227,223,137,35,240,215,167,69,9,160,108,244,10,203,65,4,191,119,162,
155,33,143,10,36,49,36,245,13,80,68,235,115,28,90,26,149,39,141,141,237,201,55,
255,0,15,109,235,76,140,215,167,203,48,165,30,189,114,219,89,253,203,128,156,
212,209,197,29,125,60,85,4,73,77,82,174,37,127,12,101,135,132,141,37,94,53,36,
216,16,64,250,241,238,241,179,173,74,144,71,85,149,82,64,3,212,53,60,186,151,
139,221,117,53,213,25,52,167,158,179,203,82,101,103,164,32,73,81,169,39,51,24,
244,151,85,96,158,174,73,63,227,199,186,172,131,53,111,219,213,90,32,2,96,116,
180,199,239,92,246,58,136,7,164,170,8,26,72,139,75,2,132,140,152,152,107,141,
145,88,48,208,125,67,250,243,237,212,184,0,80,83,166,94,222,55,111,159,74,28,95,
110,210,65,131,201,99,30,146,145,42,42,43,227,170,138,99,53,166,140,152,2,126,
203,177,116,43,36,128,25,20,221,137,254,158,223,75,144,35,112,0,6,189,54,246,68,
200,140,24,156,116,225,142,223,84,245,53,148,45,37,50,83,213,233,158,9,150,157,
172,89,37,167,118,50,37,157,149,164,242,14,72,183,215,232,125,212,204,90,162,
153,61,121,160,42,167,53,29,8,120,109,213,14,80,75,27,206,149,52,98,158,198,58,
216,162,157,11,196,11,48,253,197,46,85,93,62,154,173,254,23,246,218,16,79,12,
116,220,136,80,46,115,94,146,155,207,108,97,114,210,80,149,163,199,199,83,229,
74,154,99,143,175,52,73,86,239,63,141,254,226,146,97,80,196,160,148,16,5,140,
129,79,244,3,221,153,84,133,20,207,30,173,12,174,149,201,165,41,195,160,39,45,
215,117,120,204,172,66,158,166,26,255,0,61,126,72,125,181,53,61,112,150,5,165,
66,65,147,238,41,96,131,84,133,174,170,178,57,181,175,245,183,182,60,38,6,180,
243,233,112,184,66,156,115,78,163,195,181,231,53,181,173,84,230,137,105,18,169,
102,90,152,218,57,96,154,157,169,252,145,212,211,184,90,136,16,45,66,144,236,
186,27,232,164,144,109,186,0,198,166,152,243,234,194,86,210,165,86,167,229,210,
120,97,166,154,180,31,60,77,8,174,17,64,209,254,137,205,214,54,104,65,34,233,
175,133,39,235,237,135,161,36,215,129,233,224,78,156,131,90,117,207,127,81,201,
142,201,173,36,113,77,24,120,146,121,157,149,149,89,153,155,69,189,32,13,10,46,
108,127,35,219,51,68,138,226,139,214,237,156,178,106,212,15,72,25,16,171,189,
137,38,229,139,49,32,128,0,98,53,19,245,185,246,213,7,231,211,245,233,239,11,
106,136,234,233,222,165,163,242,120,214,20,145,159,67,77,38,165,10,63,178,27,
243,114,71,62,220,88,203,2,66,215,170,49,167,83,177,204,21,166,199,84,42,153,
160,148,149,101,80,11,143,210,77,202,223,86,163,99,236,186,225,8,58,192,193,255,
0,15,78,33,175,1,214,29,193,141,43,79,37,80,43,31,134,69,89,84,166,146,198,70,
184,98,65,107,155,183,244,250,31,117,182,114,26,149,227,215,137,6,163,207,166,
204,99,66,85,117,164,140,67,75,112,170,140,128,249,20,141,74,223,91,143,107,89,
120,227,29,52,78,56,245,153,161,128,84,200,239,246,209,198,70,165,14,132,191,
234,7,210,171,117,18,105,54,252,15,111,199,66,7,219,214,129,253,189,55,86,65,
173,229,85,153,17,124,170,0,10,136,28,76,88,130,8,102,244,165,185,7,250,251,217,
193,39,253,95,234,29,90,180,25,234,37,53,21,229,114,210,189,172,252,71,97,112,
173,253,150,32,169,186,255,0,79,167,189,105,24,235,122,136,243,235,57,130,34,
177,159,183,123,217,208,235,145,201,212,170,26,252,0,9,179,131,97,244,30,246,80,
84,26,28,255,0,171,252,29,108,57,161,235,26,248,217,136,142,34,165,208,8,254,
133,84,143,163,2,111,114,223,226,71,39,221,105,221,64,58,240,62,189,114,72,172,
178,204,239,27,11,139,70,8,243,184,185,38,199,78,136,248,22,63,147,253,61,239,
250,85,235,95,42,117,194,84,49,132,100,33,53,34,149,12,250,159,234,73,33,128,
177,81,192,55,183,62,236,40,41,215,190,125,72,50,199,246,6,145,163,140,204,92,
55,220,21,5,160,143,212,197,85,190,151,149,218,231,250,15,126,224,9,249,245,
236,215,229,211,17,182,181,81,253,77,207,63,235,14,63,224,163,223,169,199,175,
124,186,255,212,208,77,37,112,86,198,204,13,212,253,15,31,77,36,114,69,253,251,
173,86,157,62,211,212,36,145,183,32,16,164,49,55,55,45,201,176,255,0,15,109,17,
74,1,235,94,173,212,57,138,221,131,89,120,93,39,142,44,71,208,242,1,62,222,4,
126,125,83,207,135,89,233,222,48,25,100,87,114,204,128,149,183,11,201,32,15,205,
193,247,188,131,242,234,196,138,12,231,172,114,199,11,9,37,70,101,141,101,26,5,
185,118,189,194,220,155,134,3,147,239,117,38,163,170,230,180,233,87,135,111,53,
68,107,35,36,170,174,146,172,207,40,72,145,203,22,49,84,203,37,196,113,179,27,
147,165,143,22,227,219,171,150,21,225,235,94,168,216,4,142,179,140,159,219,85,
201,73,33,84,165,105,192,145,188,98,86,8,140,89,124,102,233,111,87,7,250,143,
207,189,18,106,71,225,235,217,34,163,174,21,185,167,117,169,161,146,149,33,104,
157,99,64,254,150,140,176,6,65,41,37,172,84,242,63,167,231,221,117,26,145,78,
238,183,76,3,94,157,246,165,80,145,235,26,164,8,233,215,33,143,136,77,34,121,63,
203,103,242,152,160,145,195,42,133,150,40,24,139,143,175,228,123,188,70,154,170,
40,42,63,111,77,74,191,14,158,52,255,0,81,233,69,158,159,30,134,103,130,100,73,
86,162,41,197,44,112,75,4,21,82,75,38,189,34,165,231,156,86,75,20,108,20,13,49,
169,23,60,251,117,233,90,215,166,226,13,230,60,184,249,254,207,46,167,225,50,
176,42,103,42,204,16,151,133,210,171,27,60,181,38,88,101,20,178,172,213,24,138,
216,189,58,33,117,114,20,199,26,221,238,47,97,238,200,252,77,63,213,233,211,82,
198,65,69,7,28,15,231,231,212,227,151,251,152,103,38,85,143,30,181,212,107,73,
69,82,99,149,99,164,130,38,122,120,82,168,162,90,55,241,8,192,209,118,7,146,15,
62,211,59,84,185,242,174,58,121,84,46,156,119,83,61,9,219,63,116,84,215,61,117,
93,106,208,208,136,143,139,27,143,70,149,131,64,3,76,244,209,130,242,138,120,
86,107,106,98,71,214,247,54,183,181,118,108,50,196,138,244,150,233,52,232,10,
62,211,210,207,27,146,196,82,164,38,170,73,103,169,200,228,66,100,25,43,41,157,
105,165,142,93,114,83,81,132,64,35,75,63,39,212,26,222,155,115,236,198,169,81,
83,196,244,132,171,249,45,0,30,159,225,233,49,185,43,104,107,179,181,66,145,
226,135,197,145,85,142,59,154,69,170,89,18,4,65,17,47,52,117,21,2,40,198,171,
152,199,248,95,219,47,150,57,21,7,246,245,116,168,65,81,196,126,207,243,116,17,
246,110,217,20,84,243,84,75,146,142,74,152,99,21,177,211,154,168,229,81,79,33,1,
23,80,140,48,154,80,196,160,250,27,17,199,180,119,80,138,84,176,168,233,117,
164,213,162,133,199,15,207,160,70,154,165,41,188,70,71,185,18,60,225,108,164,
185,30,144,183,38,250,26,214,35,250,123,66,201,219,209,130,253,189,41,177,91,
178,76,115,187,193,36,177,107,83,11,199,17,114,173,11,48,115,25,96,8,17,220,94,
198,231,218,102,132,86,160,208,244,238,8,4,244,34,236,189,204,101,89,86,44,156,
48,72,245,47,36,177,203,116,149,154,77,41,97,254,109,76,98,48,215,62,144,61,
184,162,135,36,116,203,128,70,23,29,41,102,205,209,77,77,2,215,83,204,130,150,
89,66,213,197,10,81,211,122,229,78,97,243,74,222,119,33,64,44,164,169,22,58,
125,173,134,170,114,216,233,36,138,14,20,10,253,153,233,243,111,214,227,43,235,
158,12,125,85,77,59,136,89,140,18,187,218,165,132,31,231,101,138,81,173,28,139,
128,202,52,181,197,135,183,195,252,250,97,147,29,195,161,3,111,172,212,19,109,
185,198,86,103,242,210,77,52,80,207,70,147,68,193,36,157,166,134,57,96,120,100,
242,189,189,42,80,88,253,127,175,189,234,33,144,106,234,140,128,163,128,152,233,
118,249,170,248,215,43,93,87,137,166,254,30,238,173,29,93,52,237,13,75,75,246,
214,167,136,211,213,186,183,221,150,136,175,161,217,77,248,176,247,117,184,53,
109,75,231,229,211,38,220,84,5,108,252,255,0,216,233,109,181,55,134,39,21,150,
174,215,95,146,163,172,150,42,159,53,13,77,18,189,68,144,201,8,145,132,107,79,
59,137,227,129,77,174,166,192,88,251,95,12,208,1,151,33,171,254,174,29,34,150,
222,98,1,8,10,211,253,92,120,116,231,67,184,155,5,81,81,95,183,221,100,65,72,
153,40,164,211,44,62,58,154,99,4,240,46,138,149,213,79,50,60,70,215,82,192,144,
108,13,143,181,190,42,170,185,86,4,127,177,210,83,9,122,9,48,107,79,203,161,245,
59,167,119,238,185,242,52,217,204,141,77,45,53,64,164,171,166,170,205,79,53,
125,46,62,10,152,231,168,174,90,60,117,4,20,144,214,133,89,217,153,107,190,226,
57,180,105,144,128,170,61,187,12,254,43,48,34,131,212,214,158,188,7,31,207,143,
73,222,217,98,80,192,215,228,48,127,159,249,41,242,235,150,213,76,37,12,107,92,
248,122,61,223,72,245,245,81,189,56,169,92,110,87,51,77,81,12,126,108,141,21,29,
3,83,193,85,29,50,197,115,224,84,240,11,161,182,165,246,226,172,96,2,20,16,14,
124,137,249,131,231,213,24,203,222,11,233,52,251,64,249,30,132,122,173,221,212,
148,21,181,184,74,157,154,203,154,143,15,61,61,86,77,166,174,167,132,12,154,199,
145,165,129,234,91,239,170,232,159,237,170,68,50,65,225,93,33,110,178,22,245,
123,124,180,75,84,24,111,95,151,248,122,76,18,86,26,245,84,31,47,159,249,120,
116,35,244,214,231,218,59,114,12,48,162,217,251,91,45,53,85,30,95,29,150,203,
138,41,227,138,178,158,106,246,171,166,166,130,152,204,212,240,181,13,55,237,69,
85,111,184,147,247,4,138,75,92,85,71,240,210,132,17,195,173,187,54,117,19,131,
81,159,245,125,189,56,195,187,246,44,91,215,21,62,23,99,224,168,106,41,247,14,
126,71,207,98,246,247,220,163,228,151,20,133,204,114,61,69,93,44,18,44,41,162,
105,161,143,80,98,21,154,231,148,38,56,149,133,35,21,175,26,116,167,84,204,59,
164,60,6,43,229,210,175,123,246,14,79,53,185,228,149,93,214,39,131,29,61,31,158,
68,241,121,158,17,80,142,23,209,28,162,53,125,37,1,0,254,47,111,123,148,163,49,
7,134,58,164,64,133,168,227,158,163,213,103,170,5,92,35,31,146,154,10,56,112,
242,82,84,99,232,178,66,28,93,116,181,20,122,197,114,81,197,102,89,40,222,156,
174,162,204,224,250,24,155,95,218,216,84,148,4,26,32,242,242,225,210,71,35,81,4,
2,231,204,244,171,218,105,132,74,237,149,138,167,197,203,82,244,244,245,212,
166,169,114,85,73,44,179,215,83,73,87,36,50,178,75,36,149,26,156,176,55,228,22,
181,237,237,74,4,14,138,16,227,254,47,164,143,172,137,24,183,19,94,151,20,89,42,
252,5,77,63,142,134,158,60,141,110,59,36,213,52,129,191,110,5,150,167,23,2,71,
49,18,255,0,146,213,52,81,146,215,213,107,3,107,219,219,186,138,232,168,201,
233,129,24,114,249,237,233,87,178,105,114,25,68,200,70,139,83,147,134,155,51,60,
82,69,137,146,142,161,42,171,22,168,70,148,68,178,192,69,88,66,2,41,10,206,15,
6,228,251,113,42,75,31,159,76,76,85,2,84,208,252,241,79,152,227,210,203,59,
182,119,14,54,60,113,198,80,226,197,70,86,178,144,215,87,84,211,165,103,219,37,
42,78,96,138,58,64,105,98,209,105,116,47,147,159,40,214,199,72,39,222,155,196,
165,0,25,227,213,131,196,106,93,176,6,51,74,250,159,63,245,99,172,208,100,37,
194,227,222,108,212,116,113,224,49,114,100,35,202,87,74,105,227,175,146,106,22,
37,98,52,184,246,168,138,174,185,170,25,81,99,82,85,191,72,39,143,108,110,123,
150,221,177,109,55,251,222,241,116,182,251,61,164,77,36,178,49,160,0,12,1,252,
78,198,137,26,14,231,114,170,160,147,210,205,143,151,247,110,110,230,13,159,
149,249,106,198,75,190,100,220,103,72,109,224,76,151,103,57,98,127,12,113,173,
100,150,67,68,138,53,105,28,133,82,122,118,236,223,148,27,47,161,58,223,29,148,
218,242,99,119,166,226,220,244,212,117,20,248,218,20,122,153,101,166,157,234,
177,144,40,158,150,73,234,214,165,100,146,211,136,212,196,129,211,232,196,40,
199,237,247,223,253,191,152,54,91,56,125,175,185,43,188,25,143,213,53,221,185,
67,101,26,46,17,213,216,70,211,74,72,32,35,72,22,53,103,37,42,164,230,23,42,
125,209,247,14,66,230,205,194,231,239,5,180,173,215,43,11,96,54,232,246,219,245,
117,221,103,148,143,213,138,88,81,167,75,91,101,82,11,73,28,12,247,18,36,96,73,
165,212,50,117,7,205,140,71,98,238,124,62,10,143,107,227,182,230,232,201,99,167,
200,111,10,141,225,145,168,165,164,193,80,99,42,34,76,212,24,83,137,199,212,212,
238,10,242,100,130,74,74,55,138,158,66,206,201,80,200,177,151,32,219,143,127,
189,192,229,221,166,238,235,113,93,166,233,245,168,142,224,69,46,141,46,6,157,
112,197,50,32,26,171,89,67,158,52,210,213,4,75,187,47,221,3,216,175,113,185,143,
102,218,246,21,230,109,161,138,191,212,216,181,221,176,117,120,164,34,86,130,
238,234,210,121,100,34,54,93,54,205,18,84,174,163,36,116,101,107,2,217,113,237,
12,206,11,109,103,178,77,13,110,220,201,101,107,177,185,241,140,201,211,227,
170,177,19,225,225,72,234,233,235,68,105,29,84,88,248,36,52,181,104,145,249,37,
20,245,75,113,234,247,145,254,219,115,85,231,59,242,94,195,205,19,195,8,187,
186,14,179,42,146,18,41,226,118,142,100,10,199,86,128,202,36,143,46,76,114,37,
88,241,235,6,189,249,246,218,195,217,239,120,57,231,219,88,47,103,123,13,178,
88,158,214,89,52,180,151,54,151,48,165,197,164,204,209,141,30,43,69,39,135,53,
86,42,77,20,148,69,20,29,26,220,6,211,198,213,80,80,81,12,20,237,136,73,113,
117,24,186,76,198,97,65,200,208,5,69,140,97,171,105,106,39,52,244,83,227,195,
121,12,170,174,4,107,234,12,120,29,75,15,133,23,136,230,140,79,151,15,183,253,
94,189,68,9,117,245,18,136,19,58,69,123,177,74,96,143,65,143,63,151,67,46,215,
254,239,109,140,189,92,184,156,62,42,55,170,220,207,69,129,201,100,242,121,90,
255,0,225,148,216,248,32,90,118,140,153,155,31,79,4,149,5,225,138,73,175,41,44,
218,85,130,221,145,201,23,136,181,36,146,22,164,112,57,242,249,250,227,163,24,
103,17,18,181,210,53,144,27,12,0,28,13,124,189,5,115,212,238,192,220,27,198,179,
41,95,143,158,28,84,111,94,82,71,146,169,235,18,177,42,146,157,171,109,143,5,
169,230,169,43,34,220,176,70,128,234,26,206,155,143,107,172,32,141,188,33,26,
150,127,65,156,121,215,208,126,99,129,232,186,250,103,15,46,182,162,156,212,241,
175,17,79,51,251,61,43,209,113,236,77,227,141,25,156,149,69,117,94,69,114,105,
76,181,245,155,127,5,81,148,171,74,9,99,164,1,36,135,28,245,53,144,83,79,144,
150,0,66,93,89,228,123,160,8,125,132,185,227,220,126,80,246,206,11,5,230,43,137,
158,254,230,190,20,16,170,60,204,163,140,175,168,162,199,10,158,223,17,219,39,8,
174,67,81,27,9,175,1,145,6,152,171,196,212,47,149,105,158,62,103,252,157,22,202,
46,208,222,123,161,164,201,214,99,170,48,177,129,61,66,98,50,187,190,138,174,
122,90,104,35,157,5,61,81,197,199,88,105,167,142,156,131,46,168,153,97,46,203,
200,91,180,73,189,253,228,246,91,105,160,93,139,151,38,189,183,52,5,218,81,0,21,
201,8,26,23,103,227,64,104,181,57,165,41,85,130,206,21,142,139,117,169,143,160,
52,63,110,127,201,195,160,235,106,239,170,45,251,184,55,5,46,47,19,64,171,128,
124,141,78,103,62,245,213,153,92,125,78,71,196,49,212,155,88,101,214,159,25,143,
125,193,85,20,169,90,180,232,178,148,162,11,33,26,216,90,78,228,46,114,222,249,
217,38,186,187,228,201,54,221,185,65,62,36,179,120,165,201,166,133,74,71,24,202,
154,177,33,116,211,10,213,7,170,207,9,179,142,35,36,164,72,220,23,2,130,191,21,
50,105,243,198,113,210,241,106,99,163,219,211,67,32,142,151,29,18,210,12,141,
116,21,255,0,97,30,154,104,161,146,42,122,101,142,67,60,181,83,76,172,4,69,8,60,
6,32,94,210,15,134,53,127,71,214,190,156,58,222,162,87,141,92,240,20,175,250,
135,65,1,203,98,226,200,24,34,168,206,83,195,30,106,56,227,133,106,162,170,130,
158,70,163,146,169,105,167,121,170,84,80,48,184,73,144,121,149,100,185,4,251,
171,233,14,69,77,43,235,211,136,25,144,18,5,127,213,158,129,124,229,126,78,92,
158,98,167,31,157,173,48,211,229,39,40,180,152,248,49,207,27,99,170,169,214,122,
1,87,25,169,72,17,26,67,36,146,0,204,215,252,169,0,36,152,53,87,184,249,249,
116,178,217,84,6,212,130,180,30,127,111,217,215,123,133,106,243,53,212,213,12,
145,85,201,75,184,75,209,212,61,102,66,6,174,130,122,88,254,232,67,149,134,74,
102,171,146,8,86,236,139,161,20,11,174,187,4,247,64,1,100,143,26,242,71,30,3,7,
252,61,93,77,18,105,42,124,50,2,154,211,4,138,140,122,99,253,158,131,61,198,217,
10,186,250,121,107,242,144,200,184,250,218,137,164,201,86,87,85,10,106,250,108,
140,21,8,184,234,186,68,146,57,224,52,162,132,105,146,53,44,73,26,185,107,10,
144,24,176,44,43,234,127,193,211,202,116,42,209,114,124,133,48,71,159,243,232,
175,111,42,131,156,173,165,73,230,148,197,20,245,21,117,70,155,33,60,241,68,212,
37,225,142,250,26,48,144,20,78,3,163,58,130,183,63,79,109,118,211,143,10,249,
244,172,52,149,53,249,14,30,189,5,153,92,173,30,47,15,183,162,166,172,105,233,
36,146,190,121,162,19,71,84,212,180,212,213,209,200,232,213,171,36,107,76,142,
128,6,141,132,132,11,216,169,189,203,229,49,136,208,86,181,111,229,243,61,45,64,
204,228,211,52,255,0,86,58,39,93,147,216,109,153,220,16,99,26,142,166,162,150,
154,9,100,198,208,154,167,88,178,12,107,227,86,156,208,232,97,85,5,13,19,232,9,
35,182,129,38,178,9,110,11,46,47,26,90,36,100,170,129,78,60,105,254,64,58,60,
180,179,240,144,187,128,100,36,126,95,236,250,245,154,181,115,181,123,66,90,132,
219,146,214,85,84,80,82,38,58,7,41,79,65,29,41,173,52,237,29,13,4,53,30,57,120,
63,68,88,175,164,88,147,199,178,233,24,44,69,134,107,195,165,235,164,200,1,52,
81,199,164,149,76,178,205,138,41,81,77,89,28,176,209,208,211,76,106,96,168,169,
139,201,79,36,113,79,17,241,44,171,16,133,64,185,55,186,255,0,83,236,171,89,121,
42,112,223,63,245,127,135,163,10,4,94,210,41,210,47,114,98,37,167,220,27,102,
212,83,210,81,75,61,117,108,85,245,6,185,226,157,158,150,9,160,161,161,141,105,
158,73,202,20,105,76,102,38,33,110,1,91,123,172,238,67,40,34,171,235,246,99,171,
69,149,122,158,225,142,163,86,230,49,239,46,27,7,252,67,31,2,189,20,144,202,
179,67,57,128,77,43,69,173,1,154,56,155,202,11,45,214,218,191,163,1,127,106,41,
80,169,140,10,117,66,14,90,159,231,249,116,197,65,69,144,254,255,0,99,226,161,
147,11,93,75,13,126,85,227,52,129,163,243,125,185,102,158,10,179,41,104,100,100,
158,152,43,31,27,20,38,215,252,251,104,32,105,40,63,111,91,45,217,144,122,145,
185,50,149,167,118,144,180,203,76,212,152,140,157,45,99,82,76,33,158,57,105,86,
7,165,141,17,38,5,97,144,72,228,176,80,10,155,243,111,117,240,142,170,41,200,
235,202,70,154,241,175,64,230,55,119,85,204,213,30,90,178,34,103,170,163,18,207,
165,130,137,151,76,23,153,143,146,102,109,122,111,199,245,176,246,250,135,81,
134,39,243,235,108,163,24,249,244,25,230,50,111,27,69,45,114,67,228,164,175,86,
36,51,180,177,24,103,228,201,19,42,90,41,83,155,43,48,36,126,47,237,162,104,
249,201,233,192,154,170,69,122,112,138,187,13,18,214,212,211,84,82,75,45,93,83,
212,218,57,24,67,28,78,47,33,97,52,107,31,132,180,158,149,3,80,254,188,123,174,
176,160,233,30,125,54,200,204,64,32,211,164,125,100,99,59,147,74,248,40,18,28,
133,84,196,86,18,84,49,51,45,205,94,154,112,132,43,2,44,214,28,147,127,167,191,
106,14,117,19,220,122,181,12,106,84,154,160,233,89,30,6,99,141,6,174,25,233,102,
118,134,89,166,142,119,88,252,210,41,8,198,6,226,34,209,114,197,72,30,232,194,
131,134,58,105,100,5,137,7,168,57,140,60,20,88,111,186,104,35,201,10,186,164,64,
237,12,101,169,244,198,98,253,249,99,105,21,197,214,234,127,89,28,158,61,220,10,
71,249,245,181,144,153,116,250,14,144,82,227,233,233,38,165,151,31,144,251,121,
245,152,218,196,24,196,172,161,73,81,97,251,103,87,244,224,127,182,247,97,38,
146,15,151,74,53,51,2,25,42,58,120,192,110,44,181,20,147,83,75,3,75,4,81,178,74,
244,178,42,76,250,101,42,10,60,162,202,228,155,130,63,31,91,142,61,187,19,212,
149,167,249,250,172,171,25,163,121,147,210,186,183,112,98,42,165,167,171,165,
122,218,74,248,33,164,21,20,213,197,30,22,72,194,222,72,166,17,135,14,12,96,218,
252,177,63,79,203,172,64,205,114,7,76,170,55,112,52,161,39,167,124,246,106,120,
231,142,26,103,18,193,88,166,174,157,163,153,212,25,170,150,37,154,73,21,185,
142,104,173,107,0,80,40,213,207,183,36,106,42,208,212,28,244,212,81,131,168,145,
67,195,246,116,236,114,209,229,107,225,25,47,21,125,241,41,18,249,244,94,87,66,
12,111,44,177,250,234,188,109,248,107,2,62,190,253,168,51,85,133,113,214,194,
20,82,87,6,190,95,234,199,92,33,150,31,188,254,29,83,73,70,209,69,81,45,69,57,
150,150,15,48,168,14,166,244,210,34,186,122,100,13,125,54,5,5,254,190,218,144,
46,170,5,28,122,190,166,43,93,71,246,158,187,236,74,152,114,27,134,166,150,151,
25,67,85,144,153,32,11,229,133,154,40,225,88,227,150,164,180,9,83,4,96,44,64,
184,229,111,248,39,233,238,178,252,101,105,158,181,109,169,99,15,90,0,115,208,
59,93,131,142,74,230,199,24,49,211,185,121,42,225,172,199,41,138,73,160,168,
142,55,142,25,230,243,202,143,77,10,126,130,17,91,73,177,185,60,38,40,9,61,45,
89,40,129,168,105,212,252,55,95,75,89,79,93,42,193,42,165,60,107,49,38,162,61,
17,41,242,6,50,195,173,166,16,13,58,149,135,170,195,155,123,83,4,85,6,156,58,
106,91,128,8,245,60,49,210,122,171,25,93,67,51,100,132,50,75,29,14,96,226,228,
168,210,100,74,138,89,161,13,20,230,96,125,119,77,32,155,11,48,231,159,101,183,
107,137,18,152,226,58,83,19,6,85,21,238,35,167,25,40,5,118,55,39,228,36,136,144,
202,193,85,165,118,17,32,149,80,5,228,146,69,137,250,91,253,111,101,30,38,137,
16,15,62,149,232,213,90,48,4,14,131,42,25,77,60,206,156,35,9,153,7,144,22,85,
23,58,181,40,117,245,14,47,245,246,116,165,104,73,244,233,141,37,141,23,203,
172,149,44,89,205,244,177,82,110,202,64,87,22,245,18,72,63,95,245,135,186,169,
80,213,20,167,90,10,220,41,212,119,152,76,215,117,84,30,31,243,145,168,38,54,
80,214,98,46,64,4,145,205,143,183,245,3,140,117,189,44,43,142,178,209,75,59,13,
26,81,236,26,32,196,219,66,200,20,18,128,88,177,43,123,19,249,247,108,96,83,61,
106,157,119,52,53,17,189,68,110,13,43,136,252,139,28,198,243,52,108,116,153,8,
23,11,100,110,77,135,31,143,109,146,51,94,182,0,227,212,204,109,53,3,165,97,
171,154,71,251,122,57,36,134,215,66,37,141,47,23,142,205,162,68,215,96,117,47,
211,252,125,249,72,207,90,36,224,15,94,184,193,45,32,21,70,8,21,53,164,94,137,
10,205,227,101,11,99,26,178,234,5,216,30,46,126,191,211,222,215,42,125,105,214,
232,122,137,91,80,190,112,226,52,112,98,6,55,176,69,91,220,150,8,6,129,102,3,
139,90,220,123,241,52,35,173,140,142,160,60,202,194,64,135,83,59,49,102,98,1,
231,72,36,91,232,79,245,247,108,121,245,238,24,29,55,129,234,98,109,250,130,142,
125,63,168,3,254,54,183,189,127,71,173,124,250,255,213,208,64,128,61,63,208,222,
227,240,127,195,223,169,158,181,196,212,245,212,114,201,19,131,114,69,238,63,
161,62,253,214,250,114,14,147,95,242,196,11,130,5,199,245,54,191,211,159,117,29,
107,142,58,196,111,25,32,92,168,227,235,192,255,0,27,253,69,189,221,73,199,85,
167,31,183,169,145,87,170,208,154,86,28,249,53,169,208,141,195,27,184,36,169,
107,144,7,250,222,247,94,35,175,126,42,245,39,75,72,240,180,110,89,138,130,177,
198,6,144,163,85,201,100,33,87,64,254,188,223,221,179,81,215,133,7,78,83,77,75,
37,20,67,67,174,70,158,111,89,83,170,57,33,0,130,193,137,212,95,80,86,255,0,3,
127,123,44,8,62,181,235,66,160,231,225,235,170,92,69,78,66,42,138,213,66,20,76,
22,71,105,63,206,107,12,206,110,73,103,183,228,147,245,247,165,82,65,52,235,
197,148,81,73,233,93,77,136,200,73,141,138,42,83,61,66,203,83,164,99,160,141,84,
181,100,113,145,4,229,128,50,61,98,35,144,132,157,0,19,192,246,224,70,210,41,95,
179,253,94,125,55,169,117,230,152,28,122,17,178,187,82,143,17,133,219,148,242,
201,87,46,98,166,142,135,39,81,135,129,99,89,92,187,198,13,60,127,118,175,170,
90,168,143,151,200,65,212,120,79,79,30,212,120,96,5,6,181,227,79,248,190,147,
120,197,154,66,41,160,18,1,255,0,46,63,213,249,244,130,172,166,167,168,173,201,
73,52,213,43,82,39,120,163,134,40,162,136,83,68,178,222,23,151,237,214,56,228,
150,50,89,25,109,250,133,207,186,149,21,39,61,57,86,10,163,20,62,190,126,189,62,
100,225,130,146,142,74,106,168,166,142,72,234,105,12,70,38,65,101,167,166,30,
150,18,11,105,242,72,133,248,184,246,149,198,146,106,58,178,26,209,129,207,74,
26,29,75,141,74,167,73,40,190,226,51,79,247,30,72,146,154,175,205,36,137,44,
176,136,213,28,164,64,216,234,186,177,7,218,187,113,69,29,49,35,85,136,193,167,
151,165,58,115,48,71,77,73,246,175,77,174,101,106,179,18,198,243,193,18,181,36,
158,37,153,227,103,50,211,205,42,49,208,183,10,69,239,237,73,0,85,72,233,128,
196,154,234,237,199,77,185,204,192,195,64,207,247,81,131,12,107,53,62,181,134,
81,34,61,137,75,74,186,164,168,89,110,73,189,193,255,0,1,238,174,193,64,207,14,
172,137,226,26,105,243,255,0,87,229,208,17,153,220,185,76,220,178,61,93,67,201,
27,162,199,96,21,21,210,51,116,186,168,80,109,237,4,210,187,28,240,233,106,70,
177,252,35,166,101,129,217,68,129,65,177,252,181,143,31,155,88,240,15,215,219,
20,56,206,79,78,128,79,83,22,142,163,211,33,12,177,144,165,136,58,212,6,177,44,
64,97,197,152,27,123,240,82,105,233,215,168,195,207,165,45,22,54,24,229,130,83,
92,105,215,68,142,36,137,29,159,80,213,166,52,208,218,131,30,1,191,3,221,218,
51,130,167,173,147,94,35,167,227,69,184,113,248,236,125,68,53,81,214,64,100,72,
40,169,38,134,41,222,84,168,70,169,85,138,96,172,174,2,33,103,4,155,17,207,211,
221,52,178,181,104,71,90,212,166,185,7,165,86,209,150,150,187,47,88,249,50,105,
170,66,33,125,38,56,164,50,10,121,53,44,80,196,85,204,64,11,165,148,146,1,231,
219,176,154,184,213,199,166,229,0,39,104,207,74,92,7,247,154,135,37,137,135,21,
93,95,81,2,75,83,32,104,97,89,106,33,212,106,145,74,65,88,90,55,130,36,228,30,
1,34,223,94,61,186,184,117,210,124,250,101,244,50,182,165,207,67,186,110,24,
114,56,220,204,84,147,199,146,164,138,60,100,177,197,85,21,61,61,87,154,45,72,
166,37,146,24,29,196,165,239,175,75,1,200,13,164,17,238,164,133,45,156,99,166,
76,121,92,103,61,45,49,21,24,76,158,79,25,36,245,85,116,211,255,0,144,188,126,
74,26,86,106,111,184,164,167,130,68,166,58,116,79,16,150,236,92,5,60,223,85,
135,10,98,113,172,183,26,83,164,178,43,133,32,12,26,249,250,103,167,253,205,75,
253,223,45,83,67,147,90,248,115,38,178,158,154,10,184,228,120,169,90,174,72,138,
199,82,203,34,84,187,76,177,56,138,82,0,225,109,207,5,90,184,209,35,234,37,241,
252,250,76,59,180,174,156,15,79,151,79,248,61,241,79,251,20,141,74,137,144,254,
30,1,199,121,158,73,208,195,73,58,211,201,81,12,230,57,34,138,165,79,234,54,75,
240,73,231,219,246,243,147,164,41,7,253,138,244,212,214,228,106,45,143,217,208,
153,130,220,109,87,180,234,105,107,41,49,84,56,176,212,205,227,84,16,101,168,
234,18,56,106,71,219,213,170,188,171,37,76,132,44,154,38,4,169,28,176,2,239,139,
177,161,195,26,17,229,195,164,205,111,220,165,106,79,242,233,31,143,221,123,87,
9,186,178,113,228,99,74,70,170,167,104,39,124,149,93,121,167,104,43,105,207,
153,6,70,170,89,162,90,155,205,172,76,10,104,62,144,44,61,180,151,137,140,102,
189,56,214,178,186,141,38,180,244,167,248,7,67,94,51,27,37,6,59,24,248,131,52,
52,84,153,60,131,82,188,63,108,179,84,84,24,40,164,73,210,159,197,37,28,212,
201,43,31,27,18,204,64,107,146,72,177,148,78,25,65,13,138,244,93,32,42,90,162,
164,143,245,125,157,47,246,141,78,103,200,185,42,250,200,100,88,219,34,126,230,
108,117,74,214,211,83,170,80,76,240,209,127,15,130,24,163,151,77,45,164,102,37,
88,218,254,236,23,80,212,120,87,170,49,85,52,3,52,252,191,203,211,36,212,251,
142,178,58,76,245,27,212,86,60,113,83,43,131,28,255,0,103,142,138,41,52,81,130,
213,175,45,50,121,220,3,165,0,60,255,0,79,108,120,85,42,105,94,157,241,80,106,
21,161,175,252,95,67,14,47,47,157,173,164,162,76,230,18,10,170,127,225,241,177,
158,134,120,161,145,101,149,230,168,146,41,34,166,68,141,124,208,146,199,69,130,
146,47,249,185,138,176,17,133,101,198,58,64,203,221,85,108,244,52,245,228,89,
137,42,241,85,84,176,80,226,169,241,149,179,9,43,169,41,43,242,117,174,42,18,43,
136,164,90,232,254,213,233,149,20,92,223,200,165,201,244,139,7,99,39,138,210,
131,237,61,49,34,129,80,213,44,124,170,7,66,158,11,111,228,166,205,230,12,117,
51,172,112,213,103,152,76,49,148,87,171,179,208,86,188,80,199,89,60,240,201,16,
149,70,167,3,202,132,240,64,6,239,42,190,115,128,221,39,145,163,165,72,205,7,
159,66,78,218,194,211,38,78,108,107,53,81,157,234,43,114,181,16,211,215,197,17,
146,74,145,61,68,94,117,50,34,213,195,247,82,106,117,96,8,181,129,1,125,184,5,
106,122,75,35,0,51,143,46,21,232,104,221,155,127,31,87,146,200,65,37,13,72,164,
197,80,99,138,181,101,122,86,81,210,42,97,195,46,81,234,102,169,85,199,209,67,
57,99,51,106,115,29,62,177,98,72,246,238,144,73,6,129,70,106,78,0,167,18,113,
65,235,232,43,210,96,236,52,21,203,146,104,0,201,36,211,72,0,100,156,0,60,201,
29,16,222,227,164,206,213,73,191,118,118,82,147,21,128,219,125,75,181,107,247,
167,97,99,240,116,21,143,150,164,219,213,21,248,164,163,120,177,179,201,27,208,
213,238,58,140,133,63,138,57,92,212,20,34,74,148,134,47,50,123,194,79,120,249,
142,126,113,230,221,175,110,219,110,41,183,237,236,201,0,18,232,130,230,121,25,
67,76,83,62,39,129,69,88,217,147,180,25,29,27,91,165,58,121,247,109,229,104,
125,185,246,255,0,153,183,77,230,204,253,126,237,28,114,223,63,210,248,183,150,
86,112,36,154,45,210,74,47,130,183,69,157,167,68,150,146,58,67,20,201,224,199,
41,114,171,215,27,71,111,231,106,183,140,248,76,246,63,111,99,182,157,69,46,
249,205,103,232,106,106,219,35,146,194,227,243,24,218,252,14,195,235,156,149,56,
163,173,202,238,236,151,47,83,28,127,111,246,137,28,178,169,58,125,130,174,164,
152,194,240,238,215,75,28,147,89,180,73,28,160,13,79,165,188,105,165,134,165,66,
40,162,199,82,85,129,26,136,207,82,69,134,223,183,37,249,185,229,107,95,169,
179,219,119,88,238,165,184,129,220,254,151,139,16,180,180,180,187,1,100,105,93,
139,73,115,64,30,50,14,133,61,11,152,237,147,181,187,45,187,87,183,183,156,91,
139,111,84,238,141,227,143,197,109,92,142,42,149,54,254,58,147,118,181,20,217,
17,153,200,71,65,77,70,178,197,134,201,83,81,200,212,148,234,141,60,115,121,
106,30,70,102,12,8,59,244,219,60,59,102,206,23,234,33,240,93,228,237,14,173,110,
95,75,163,26,144,186,198,165,86,53,1,148,232,10,0,61,77,113,242,150,209,206,59,
151,56,243,150,227,57,219,103,250,216,33,129,82,70,137,147,112,240,139,197,60,
74,2,188,141,15,232,187,68,8,213,28,181,153,228,114,71,86,43,241,39,179,183,
182,231,134,179,108,172,216,229,204,231,54,22,79,41,145,156,65,142,151,17,140,
222,187,65,232,48,53,59,136,193,87,74,145,211,81,228,105,43,158,157,189,26,170,
82,158,5,144,157,8,6,77,125,216,183,150,219,111,249,155,145,132,178,61,155,35,
221,64,206,196,233,17,120,65,88,138,149,30,36,50,162,187,12,188,145,138,214,131,
172,25,251,252,237,107,206,27,79,183,62,239,79,105,12,59,228,62,14,217,124,33,
85,83,43,201,245,12,86,161,82,67,224,220,66,230,20,112,194,56,101,52,43,149,
232,242,109,140,55,97,121,229,90,90,204,62,66,167,248,101,53,12,149,213,196,226,
176,240,202,43,105,167,143,31,146,163,47,161,226,133,163,13,52,148,186,87,84,
118,80,1,55,203,150,183,149,254,17,92,87,31,207,253,92,56,117,206,21,187,138,21,
98,192,140,140,113,252,255,0,226,243,208,189,130,220,25,124,118,102,139,45,79,
184,49,102,165,80,109,202,249,148,98,168,182,238,71,113,12,141,117,22,78,162,
122,122,236,161,202,208,205,37,35,35,208,69,112,134,68,215,164,11,130,211,194,
25,84,233,4,224,100,140,122,255,0,155,167,99,185,49,151,79,17,130,13,71,180,18,
79,166,120,113,169,175,217,228,122,42,61,169,222,57,138,173,249,185,240,85,212,
146,81,109,237,181,158,147,103,110,42,237,197,144,131,248,253,85,62,211,128,210,
125,173,86,78,142,165,169,101,162,174,220,41,84,90,40,117,72,105,105,163,82,165,
164,145,189,227,31,189,222,226,95,218,216,243,151,33,216,197,28,86,76,182,209,
52,170,100,241,203,61,36,154,50,67,5,11,32,49,42,209,71,97,145,90,165,176,220,
208,180,150,243,92,74,117,178,164,102,163,203,95,195,74,241,52,160,175,171,31,
65,208,95,131,223,20,88,36,146,163,59,87,155,206,82,214,37,97,122,75,199,81,45,
61,38,15,1,30,50,37,202,213,84,199,20,191,196,81,177,174,144,69,87,120,163,139,
72,149,36,46,116,98,190,233,251,215,127,220,163,185,220,175,24,132,134,56,252,
66,196,177,76,233,72,203,22,162,13,68,0,156,13,72,161,226,103,5,191,135,26,201,
115,24,102,31,135,58,20,147,94,234,113,106,147,85,225,138,17,211,63,247,163,63,
216,57,108,200,234,28,6,217,207,85,224,50,38,45,219,184,123,35,53,95,135,196,
237,24,114,216,250,231,134,106,223,178,138,186,151,37,152,72,98,241,173,5,22,58,
90,104,153,173,36,144,104,69,105,179,219,175,103,121,135,153,252,67,184,73,37,
134,202,129,123,201,69,149,193,63,10,134,83,54,146,160,145,33,167,1,196,26,135,
30,79,167,80,247,242,201,250,149,40,170,42,88,138,84,121,105,95,176,143,64,61,
6,156,116,27,67,111,69,157,219,187,95,24,18,170,190,150,106,154,225,141,164,
50,190,75,48,248,188,14,79,37,185,114,25,106,186,120,60,141,51,83,202,67,136,
213,180,4,80,170,162,195,55,246,219,13,179,100,219,45,182,141,166,223,195,180,
133,52,42,10,156,1,196,179,100,147,196,177,201,254,93,18,57,158,105,188,121,207,
96,24,205,40,60,148,1,210,99,112,45,93,54,35,14,118,204,53,51,125,158,77,90,
178,167,33,53,36,223,196,90,113,4,117,18,202,37,141,132,58,106,170,0,85,140,88,
172,150,252,114,227,134,10,26,36,36,10,100,211,63,234,62,157,42,137,150,154,102,
113,249,87,30,159,110,60,248,245,31,39,158,171,197,96,107,48,251,155,108,81,208,
85,87,71,53,66,194,211,71,75,80,98,215,42,80,199,67,45,31,220,212,199,144,146,
90,114,94,123,21,104,238,164,88,240,204,146,189,10,201,29,26,156,126,207,79,
242,244,236,33,89,149,226,150,169,92,249,143,207,236,232,45,200,87,81,81,193,23,
219,237,100,139,43,87,129,134,190,176,210,67,91,86,180,243,228,157,105,205,95,
133,69,50,205,82,241,105,145,228,115,127,32,224,21,227,218,86,248,84,181,107,
147,233,233,249,116,190,61,37,165,10,163,70,0,4,250,113,249,244,139,147,63,69,
133,201,199,85,122,161,45,29,115,212,227,162,201,96,104,114,6,55,197,138,42,154,
74,172,76,117,159,123,72,178,69,80,190,73,46,160,14,64,1,65,187,68,71,168,106,
6,180,60,43,231,254,172,244,164,120,180,58,10,233,199,26,121,122,130,63,103,
65,150,236,221,83,248,82,38,199,99,231,199,211,228,5,117,125,68,39,205,93,53,
124,193,229,116,146,146,86,10,212,90,21,30,209,128,3,179,235,37,85,109,224,230,
166,185,31,103,159,252,87,94,48,138,45,48,196,250,249,127,128,121,249,87,160,7,
113,42,229,114,177,83,226,240,88,249,227,156,71,27,125,159,146,2,217,6,167,147,
77,41,167,128,159,36,203,114,202,100,86,136,133,44,126,158,232,224,49,162,168,
206,63,63,78,175,31,96,171,200,216,255,0,7,173,122,1,59,71,103,85,211,236,77,
201,150,219,52,149,89,42,250,93,135,159,174,163,199,99,98,170,168,97,246,17,206,
43,170,38,84,87,113,82,175,49,10,84,4,46,162,252,15,101,119,81,16,178,21,25,
208,127,151,249,127,103,70,182,114,131,52,43,33,198,177,94,30,184,234,185,233,
183,22,16,230,232,178,121,76,148,116,149,20,120,122,106,76,100,204,69,17,156,
212,213,99,234,167,163,132,200,162,54,173,146,146,157,137,254,177,196,192,17,
199,178,32,161,148,131,235,254,175,229,208,152,212,26,1,142,132,12,239,105,81,
97,40,241,248,202,57,169,126,250,147,35,65,150,203,84,45,116,100,53,27,85,200,
152,149,128,77,84,67,78,36,123,178,194,1,72,255,0,112,147,126,18,203,168,32,0,
84,126,127,151,217,211,177,34,179,18,198,152,199,14,62,125,69,159,122,82,53,54,
99,11,76,40,146,133,235,103,49,198,223,109,29,100,48,53,72,111,12,121,8,76,196,
121,76,161,148,150,91,8,249,250,181,208,145,36,114,81,128,211,67,143,49,94,149,
34,163,168,33,137,63,200,254,93,98,200,231,76,187,155,106,99,36,203,86,227,191,
129,224,37,142,74,74,95,37,85,65,57,42,135,166,150,182,171,43,21,92,111,71,21,
93,51,52,97,169,157,26,66,2,16,65,55,163,177,241,145,25,72,81,79,231,199,171,
209,86,54,101,0,150,255,0,39,200,143,47,159,14,130,126,209,203,127,123,50,145,
210,99,177,85,7,43,71,69,64,213,89,106,72,32,162,133,38,112,213,13,142,170,72,
188,75,89,59,162,162,198,160,235,86,212,206,195,218,151,149,13,72,166,163,211,
113,171,32,3,85,71,231,211,30,56,230,40,114,50,200,184,156,174,84,83,77,95,79,
51,227,162,89,36,165,167,154,22,122,134,104,169,170,96,150,162,67,60,160,180,
170,110,0,55,191,191,70,132,41,99,198,159,202,157,109,153,73,3,80,167,76,149,24,
95,191,203,214,100,50,53,212,216,134,52,82,43,207,93,83,52,53,49,161,84,84,88,
234,106,42,94,58,111,42,146,1,46,70,171,11,115,111,116,67,85,98,91,207,167,24,
208,0,7,65,222,79,109,98,232,36,199,34,213,76,179,206,243,164,33,165,134,86,149,
9,102,77,79,26,253,180,136,20,242,64,255,0,15,175,182,228,106,45,1,167,79,70,
197,137,98,58,104,147,97,253,250,86,53,118,77,35,138,50,222,24,229,70,146,161,
101,99,251,79,40,136,198,134,5,39,212,62,170,62,156,251,160,67,196,147,214,204,
128,16,7,30,131,140,116,207,139,174,154,144,34,31,3,85,71,26,75,2,177,118,89,2,
183,136,27,150,14,98,33,77,239,207,22,62,221,17,169,32,26,158,188,213,161,39,
142,58,89,165,92,212,213,240,86,127,15,171,164,168,118,142,165,42,67,35,0,15,
133,154,241,155,135,136,133,4,234,179,143,201,228,147,103,130,156,56,116,208,36,
130,43,142,167,202,104,115,30,68,174,171,200,121,218,181,196,106,242,194,148,
146,170,134,51,66,36,119,105,190,227,192,215,10,116,128,1,250,251,108,150,65,76,
21,251,58,208,31,194,7,81,183,22,54,26,60,46,62,154,135,32,244,116,162,162,166,
165,233,234,228,19,61,85,66,130,145,34,58,42,197,31,142,16,63,109,53,49,6,231,
233,239,74,86,88,232,130,132,19,249,253,159,230,234,163,90,202,204,233,170,160,
10,250,14,144,79,141,160,240,65,16,168,169,74,160,203,36,177,58,16,170,121,84,
141,89,245,57,102,253,65,137,34,223,129,237,38,183,14,70,154,208,255,0,62,150,
210,162,163,161,15,13,215,53,249,134,171,200,81,87,208,248,32,162,165,168,156,
60,218,66,249,222,18,242,169,141,85,94,40,149,253,69,121,224,159,199,181,112,
202,143,47,135,165,129,34,189,35,145,202,40,7,215,160,211,121,83,166,30,191,237,
142,70,142,182,104,161,104,228,124,124,130,166,36,48,74,214,212,210,198,21,245,
130,8,177,212,7,181,51,26,17,159,46,157,128,6,82,74,154,86,185,233,111,178,106,
5,86,14,150,187,57,143,121,82,182,89,233,169,242,179,205,12,38,74,72,100,142,
141,232,177,101,148,186,215,7,107,92,177,82,90,223,235,186,180,208,165,151,143,
159,249,190,125,49,32,164,133,81,184,121,124,248,231,229,208,151,148,163,198,
211,102,41,113,184,216,228,19,98,54,250,182,90,47,184,142,170,120,107,101,98,84,
205,82,170,41,35,156,163,42,52,106,160,41,4,158,125,221,244,169,80,6,64,207,219,
243,244,251,58,110,45,108,172,204,69,11,99,30,93,33,169,106,161,167,202,79,36,
19,85,73,92,69,92,178,99,197,60,166,104,30,21,102,104,80,200,29,39,79,172,132,
165,173,26,155,216,251,78,204,1,106,54,122,127,75,144,42,163,79,175,88,119,69,
70,83,41,73,252,78,26,152,18,149,171,4,78,203,75,75,28,173,83,81,75,2,212,202,
243,133,114,244,80,198,136,0,123,233,36,219,234,125,176,210,22,111,42,116,236,
72,169,219,233,210,102,76,75,60,179,200,149,226,237,48,212,77,58,147,20,52,38,
40,196,212,243,64,99,48,197,60,210,128,151,176,58,126,158,244,204,218,142,43,
195,167,20,128,0,63,111,89,176,20,217,90,105,103,168,165,149,106,165,157,94,7,
134,103,149,132,194,81,36,117,15,36,177,185,148,235,70,181,138,159,207,7,221,82,
118,70,160,31,111,94,120,150,69,21,199,78,21,185,44,237,110,214,175,195,74,113,
46,148,53,141,83,56,167,244,212,45,213,4,100,203,227,6,71,140,16,2,2,65,250,
159,167,191,92,207,27,66,202,126,62,169,12,69,37,212,43,167,168,184,170,124,133,
54,30,122,208,201,79,80,178,76,255,0,186,146,144,177,165,34,63,130,104,215,64,
45,44,76,120,55,86,189,200,183,30,200,8,71,146,148,175,70,10,238,181,210,42,40,
107,208,67,91,79,80,107,154,165,162,80,106,42,37,152,120,213,99,167,50,51,9,37,
88,150,227,74,2,252,15,192,183,179,207,10,136,84,156,83,166,210,167,186,159,46,
163,204,186,21,139,27,115,45,190,167,149,58,127,63,130,126,159,159,116,210,114,
58,177,26,120,140,30,155,150,23,180,109,98,130,81,116,185,230,69,60,105,64,7,
60,255,0,95,118,161,29,88,145,192,244,251,21,60,43,73,87,36,115,136,158,10,88,
214,81,98,29,234,88,184,49,135,38,204,24,31,197,128,247,166,144,84,1,196,244,
222,159,145,167,77,11,90,34,243,8,221,165,51,67,161,139,32,5,88,105,34,250,245,
22,17,149,250,253,15,186,154,249,142,172,71,15,78,162,201,86,196,5,102,184,4,
128,5,128,210,199,91,223,72,93,87,123,112,120,247,97,242,234,189,115,167,169,88,
205,213,9,98,72,28,233,0,233,250,139,92,220,127,133,189,186,170,71,30,180,77,
120,245,30,162,89,29,148,147,127,72,0,27,105,82,9,54,3,155,242,61,219,21,21,29,
107,243,199,92,148,177,82,29,66,241,254,243,253,79,228,17,248,247,170,86,148,61,
123,243,235,31,248,126,63,167,251,27,255,0,183,247,106,14,30,93,123,207,175,255,
214,208,87,72,107,6,44,56,255,0,6,177,227,139,255,0,67,123,251,245,9,173,60,186,
215,175,92,29,45,126,65,23,176,60,242,63,6,223,236,61,251,175,99,172,145,176,
142,196,143,82,240,84,220,106,4,255,0,196,123,215,94,199,79,177,138,125,12,234,
183,112,3,40,250,173,173,127,210,120,38,228,112,125,215,56,207,94,165,122,103,
104,89,217,153,65,105,25,236,17,0,81,169,137,183,0,5,81,127,192,247,122,249,117,
227,235,94,151,184,29,171,77,150,201,99,40,39,201,82,226,86,172,197,4,213,149,
205,84,99,138,73,117,218,89,169,232,160,170,169,146,56,216,88,172,42,239,164,94,
215,227,218,149,64,196,122,244,195,201,165,75,100,142,150,67,98,99,40,242,45,
141,77,205,71,145,34,169,233,94,179,29,140,170,122,18,93,130,192,226,124,145,
166,170,40,229,72,107,194,154,65,6,231,144,46,32,21,57,199,77,25,201,93,90,73,
199,217,212,170,28,30,47,21,147,201,81,249,43,234,96,163,112,38,141,228,20,145,
200,163,76,137,34,147,27,43,34,70,73,184,191,244,28,251,178,198,170,88,0,122,
161,149,157,80,227,62,157,10,49,103,49,91,95,3,138,175,194,83,80,129,83,91,4,25,
12,139,180,210,212,211,212,201,80,213,18,54,66,42,161,81,21,77,60,11,26,4,84,
81,19,139,131,207,30,239,218,169,218,112,120,252,186,108,106,121,72,96,106,163,
3,215,164,14,224,220,85,185,218,197,132,181,62,73,98,150,150,10,74,185,157,
162,170,85,73,145,204,58,148,71,26,67,47,39,129,161,1,226,222,234,88,179,0,26,
163,167,145,2,13,69,52,147,229,211,0,255,0,32,203,74,173,78,126,245,178,15,60,
212,165,227,146,130,122,116,102,145,4,51,185,2,102,167,118,36,51,17,168,255,0,
91,123,223,2,65,25,175,229,214,143,114,84,28,83,143,152,61,42,243,21,255,0,115,
77,65,247,107,20,162,162,169,205,86,168,193,158,174,34,209,105,133,229,140,89,
85,93,67,16,15,54,231,221,29,106,7,204,245,84,193,52,233,74,162,146,147,25,80,
124,72,38,167,165,140,64,234,190,72,224,97,33,148,232,44,74,36,145,41,22,191,
231,253,111,106,35,26,64,20,233,59,234,103,25,226,115,210,63,35,187,160,198,86,
26,138,132,147,41,61,76,79,162,142,119,6,121,37,154,61,106,245,6,51,226,69,64,
227,145,248,3,252,125,209,230,85,99,83,147,211,139,11,50,168,24,3,207,160,111,
39,93,93,152,168,121,235,37,214,76,146,24,226,46,124,81,106,96,218,17,72,28,
128,109,171,218,55,155,81,233,106,170,168,160,29,54,69,77,122,136,17,143,237,
184,87,46,1,43,234,111,82,129,245,213,126,61,180,196,31,178,157,91,4,228,227,
172,149,235,29,29,82,8,154,41,116,4,145,94,53,149,62,167,152,217,101,81,165,197,
172,108,8,177,250,251,222,165,32,83,171,2,195,20,235,32,122,217,35,50,73,92,97,
136,161,97,120,227,114,8,181,133,162,64,70,171,0,63,60,123,181,5,43,226,83,173,
140,254,12,244,190,199,81,180,213,84,69,43,43,53,83,194,89,100,137,41,154,87,
143,194,117,203,227,150,23,78,89,172,84,130,63,199,143,117,214,71,226,235,196,0,
42,71,74,13,173,89,75,75,53,63,223,200,78,63,238,102,166,166,73,9,138,37,150,
69,90,99,225,164,63,75,187,174,176,0,10,183,35,242,61,208,185,224,79,30,168,
203,80,104,51,208,197,77,130,194,154,234,87,169,92,109,37,91,162,26,26,186,119,
129,170,154,37,130,104,202,67,20,113,148,40,64,23,7,87,62,220,143,44,164,17,78,
146,177,52,34,135,175,108,248,176,115,103,40,41,229,89,232,116,156,155,165,69,
100,126,124,117,161,19,203,165,233,146,109,105,60,134,246,26,128,70,58,128,7,
143,111,34,18,234,117,14,61,86,102,101,7,21,255,0,15,74,108,158,31,22,49,89,115,
77,150,106,137,161,194,125,237,50,80,208,71,26,74,34,170,9,44,95,113,80,36,18,
78,81,136,213,101,0,92,113,238,178,41,5,170,120,252,250,210,57,98,152,243,233,
29,38,99,47,66,184,10,102,206,87,214,83,61,51,45,52,212,107,77,141,154,33,78,
207,26,82,173,84,20,250,160,122,112,64,117,44,192,253,111,99,238,245,160,6,148,
255,0,139,234,212,86,212,74,138,215,253,95,241,125,44,206,242,205,209,210,211,
46,69,113,249,76,124,25,53,167,21,203,51,137,94,157,81,209,97,106,117,100,50,
60,12,10,200,228,0,220,114,73,184,125,139,5,106,30,147,8,209,138,208,16,72,56,
233,125,180,105,107,50,116,117,249,136,232,26,26,236,21,117,71,130,190,122,166,
146,111,176,204,99,158,40,232,145,100,142,84,158,141,78,175,175,233,15,207,63,
68,176,27,174,230,13,164,175,229,254,14,157,157,173,83,76,124,67,15,183,135,
159,165,122,88,209,225,234,42,240,149,213,45,147,204,165,111,223,172,244,212,
216,148,158,105,154,74,115,5,61,69,85,68,203,24,164,106,8,28,48,8,201,117,86,
224,125,61,184,99,149,136,121,103,37,129,242,233,147,44,75,216,144,168,90,113,
63,234,227,249,245,203,29,79,67,37,85,116,146,99,232,163,174,155,21,68,210,138,
186,231,168,175,121,82,40,106,203,36,149,173,24,242,72,165,67,34,196,76,96,219,
241,239,83,127,184,206,8,161,167,173,63,159,77,198,72,149,64,61,160,249,12,116,
182,160,204,215,226,168,124,112,192,209,65,6,126,79,44,51,72,102,251,197,158,
147,238,164,68,150,37,214,228,143,80,116,0,1,123,253,61,151,65,117,50,83,64,96,
1,200,207,250,191,62,148,203,111,19,212,146,42,70,15,66,38,214,221,241,71,134,
201,65,148,167,200,99,233,197,70,66,146,10,234,151,50,197,79,44,180,69,254,214,
106,168,157,124,49,200,29,66,180,129,13,192,26,191,62,206,173,238,101,248,206,
160,106,120,154,142,139,102,183,66,116,141,39,30,95,234,227,242,233,107,176,210,
45,213,78,139,143,171,25,16,148,115,210,84,198,185,10,198,130,121,210,236,164,
197,12,222,55,138,113,194,185,229,88,21,31,79,103,150,210,139,128,41,80,64,200,
255,0,87,151,68,247,72,109,217,181,112,39,7,254,47,207,163,47,67,147,154,143,21,
130,76,142,55,27,225,199,65,143,165,145,101,38,111,242,41,233,222,8,41,96,111,
12,83,176,141,228,4,72,93,220,233,42,231,155,131,21,97,161,117,40,197,63,213,
229,209,125,59,154,132,208,255,0,170,189,11,125,115,148,147,53,145,160,166,197,
225,113,245,15,65,45,115,181,101,50,213,96,65,173,24,234,147,5,76,106,181,18,
210,63,145,100,30,90,105,81,145,226,39,77,245,112,242,29,90,66,15,245,127,171,
143,77,187,5,171,55,159,70,59,106,212,45,38,90,190,74,172,1,200,197,77,157,205,
26,154,101,104,227,66,114,24,173,186,234,81,197,93,56,168,167,167,130,42,137,
12,103,147,112,20,30,108,169,107,86,198,107,254,65,209,124,134,170,20,73,67,79,
243,244,48,98,107,113,25,12,205,54,49,168,232,40,92,26,154,149,120,227,165,53,
210,164,212,117,51,136,16,213,65,82,37,142,40,165,34,250,129,95,193,246,249,161,
227,235,209,121,47,71,122,147,143,203,211,252,61,68,236,10,76,59,253,237,24,221,
20,148,143,186,177,31,194,170,226,165,17,190,66,183,9,91,67,29,30,66,58,121,18,
88,225,21,24,148,173,21,69,223,75,172,148,252,6,253,62,216,187,180,130,250,210,
234,194,226,82,176,220,198,241,49,95,136,36,138,81,136,35,205,67,22,31,48,58,85,
183,222,222,109,151,246,59,165,157,186,201,115,105,52,115,160,113,84,50,68,235,
42,43,131,197,92,160,86,227,134,61,86,47,119,109,13,229,132,237,189,249,147,
171,223,194,143,43,190,106,234,166,254,53,77,216,116,184,94,193,146,158,191,9,
78,107,48,187,135,105,229,162,88,55,62,27,51,89,12,149,145,79,13,53,92,82,199,
35,69,228,35,208,188,248,221,54,152,249,127,119,221,246,77,227,107,186,111,221,
210,202,133,102,180,105,146,112,36,47,13,196,51,166,147,28,147,67,163,78,146,33,
202,181,5,25,143,97,172,247,235,238,100,218,118,14,122,228,222,98,219,32,151,
152,97,183,157,102,179,221,163,183,150,200,75,12,112,221,216,94,216,78,28,75,
109,109,116,36,213,174,54,184,10,178,38,167,37,84,23,156,78,95,27,138,76,20,191,
199,115,15,22,213,200,228,38,171,197,86,232,194,211,199,43,213,195,143,189,115,
80,71,14,110,158,186,124,117,25,145,226,46,171,26,84,16,182,250,173,164,217,
175,72,191,105,108,224,100,187,132,19,36,68,200,104,105,131,226,118,105,93,65,
62,15,136,84,131,230,20,126,101,180,213,181,67,22,231,116,91,108,184,41,20,115,
133,129,85,133,114,4,64,76,36,118,82,249,151,251,50,0,35,58,68,44,247,201,250,
186,248,48,251,67,115,212,9,246,230,203,143,43,142,218,248,188,51,78,152,202,15,
36,197,94,170,95,5,50,171,228,39,186,77,85,81,59,207,60,170,23,84,214,10,61,
144,91,251,127,184,33,71,179,184,113,110,174,78,153,21,77,65,203,5,166,154,131,
229,64,163,250,52,232,103,185,251,213,183,110,86,146,219,111,59,100,38,250,68,
21,150,7,116,58,151,225,102,7,88,214,190,122,153,218,159,138,189,15,95,27,123,
199,23,177,187,171,98,183,223,82,87,227,51,162,109,187,153,139,238,5,45,13,74,
231,105,105,114,242,100,171,103,169,211,166,60,110,98,142,59,200,0,142,202,47,
245,36,73,30,215,92,93,242,55,52,69,186,93,197,254,234,86,214,72,230,84,239,100,
137,168,66,0,163,46,174,177,182,129,82,6,0,242,235,27,254,241,91,230,217,205,
222,218,92,91,61,196,178,110,2,254,41,163,118,1,124,73,195,24,204,192,30,226,
166,23,149,53,96,54,77,77,49,126,85,211,182,111,99,212,208,245,214,71,9,187,247,
133,36,216,58,180,197,109,205,213,131,202,228,51,48,84,85,126,203,97,233,167,
169,130,57,242,53,114,86,34,136,153,22,39,98,20,221,138,131,37,251,159,239,46,
207,187,242,229,133,175,38,111,151,155,127,53,90,110,86,215,81,75,53,165,194,
192,205,110,205,170,41,136,80,198,23,215,166,104,217,84,75,24,116,4,19,81,207,9,
185,111,117,121,46,10,198,190,30,10,209,150,184,242,210,9,106,127,62,177,229,
234,232,118,102,10,147,123,246,191,95,238,125,163,81,252,71,237,171,182,118,122,
130,12,30,232,135,51,149,150,44,29,45,81,162,174,169,166,72,224,130,166,165,106,
218,173,157,132,116,145,179,13,102,193,230,30,92,247,87,147,185,143,101,219,247,
25,55,205,190,45,238,83,12,82,217,44,202,37,142,238,92,24,98,142,86,89,94,54,
96,205,12,153,13,8,12,88,176,35,164,45,107,125,111,114,150,83,131,4,237,90,107,
5,65,160,169,0,211,187,208,105,173,73,2,163,170,106,236,126,240,195,98,187,
163,124,210,253,244,89,125,165,30,233,221,216,202,41,119,26,77,27,228,183,27,
110,124,118,71,108,100,36,163,142,151,203,53,94,31,43,69,89,85,43,25,35,18,208,
73,168,149,89,20,24,71,220,254,87,178,223,247,93,230,247,106,146,70,186,190,
187,19,150,21,4,44,113,248,18,3,82,52,134,80,170,148,7,61,192,87,61,10,45,118,
244,54,102,87,66,25,162,67,65,83,220,6,41,79,149,62,206,165,28,127,99,252,173,
204,99,246,230,211,205,111,140,254,206,193,215,98,169,247,214,244,159,43,73,132,
216,120,122,26,25,233,142,102,29,245,150,219,177,80,227,43,178,185,90,9,95,199,
128,195,232,174,173,14,169,43,8,175,50,165,246,203,219,57,223,124,27,156,155,68,
31,77,25,61,197,95,195,136,215,181,98,46,113,160,112,213,170,70,166,22,58,212,
85,238,69,163,201,117,117,77,116,62,26,28,181,105,64,99,78,10,1,226,236,41,231,
199,29,90,182,46,135,100,237,221,181,135,235,254,180,199,97,118,182,223,90,106,
249,106,40,48,155,70,135,108,80,100,114,198,156,82,229,51,115,199,64,36,164,169,
202,228,169,161,121,165,45,36,210,71,165,19,200,214,13,239,48,109,254,158,218,
49,20,42,0,28,104,161,117,31,54,32,113,39,207,39,237,232,43,39,212,205,59,77,
116,229,165,249,177,106,12,208,103,200,126,93,71,204,29,181,89,149,207,84,98,
228,96,104,194,181,85,52,84,111,76,178,83,211,82,154,26,90,73,42,41,2,172,149,
83,190,130,192,182,162,13,255,0,30,253,35,173,65,83,154,103,253,94,135,171,70,
178,3,250,139,138,224,241,227,242,255,0,99,160,170,93,187,184,164,192,127,18,
169,158,161,98,145,205,77,22,60,107,165,138,58,89,146,40,41,89,154,114,234,228,
53,57,117,100,189,180,223,130,77,216,82,254,25,53,60,124,186,84,100,143,196,68,
0,87,253,94,157,6,181,187,107,45,22,71,27,53,93,90,65,6,168,104,28,81,201,84,
43,90,89,33,53,18,249,214,77,102,9,68,149,4,234,8,170,198,246,26,189,176,67,19,
168,183,203,165,65,214,154,64,207,207,135,76,153,58,121,228,207,101,162,146,125,
193,148,56,253,186,190,42,88,106,38,122,104,105,168,33,131,204,32,152,80,198,
166,54,170,134,68,33,248,39,232,125,249,248,168,21,38,157,110,54,96,27,225,0,
158,152,233,232,119,174,115,26,244,143,186,170,22,146,166,28,45,88,142,167,43,
142,150,102,167,173,121,106,164,134,47,183,129,167,180,52,196,171,174,171,145,
201,39,221,0,144,224,183,243,233,210,240,33,212,33,238,175,161,255,0,47,72,109,
203,180,49,212,143,158,134,155,39,72,51,176,65,87,43,180,210,189,69,53,74,44,54,
142,119,167,141,154,69,154,120,153,129,88,163,10,203,98,79,186,104,1,155,61,222,
125,60,183,46,218,1,66,98,242,232,30,104,240,99,33,75,71,142,166,207,82,86,182,
46,74,108,173,113,168,162,74,89,170,166,163,172,242,77,65,77,77,26,214,255,0,
147,130,177,64,31,74,218,228,250,172,125,232,208,173,5,107,211,234,37,213,169,
157,116,121,12,212,125,190,89,252,250,50,253,59,38,203,204,118,46,45,51,52,85,
163,9,91,177,243,56,170,188,3,10,188,89,173,168,201,164,244,244,181,20,91,138,
36,203,10,57,40,100,69,159,83,210,84,35,145,227,49,21,246,142,106,185,106,97,
130,255,0,151,253,88,233,108,29,133,73,238,74,240,252,188,207,249,122,160,207,
152,31,24,226,216,89,224,248,204,141,62,95,108,238,10,205,209,151,219,126,44,
133,61,110,86,130,108,86,98,88,150,166,9,232,177,152,195,83,136,142,169,90,56,
234,126,222,20,146,64,240,232,30,63,100,211,91,4,141,75,53,107,83,249,249,83,
229,95,243,116,34,180,188,241,89,212,45,10,227,242,249,215,207,246,250,244,64,
243,139,50,82,224,39,52,121,35,246,217,21,163,102,158,24,98,89,231,137,41,230,
240,164,209,198,100,154,0,181,64,52,158,48,197,129,183,55,246,78,192,130,52,169,
31,236,244,113,24,29,197,136,173,13,58,19,41,182,236,8,217,247,201,86,37,62,94,
24,241,53,148,212,49,45,100,240,213,208,215,203,8,106,218,41,105,105,228,131,
34,241,164,193,94,55,49,178,177,37,128,210,9,220,236,73,144,18,0,0,228,127,171,
252,221,121,9,1,8,94,210,126,92,71,219,195,172,185,77,185,27,86,227,43,49,52,85,
208,212,99,113,248,218,89,43,7,146,9,171,218,121,94,174,154,106,35,6,186,122,
119,104,244,106,88,221,249,23,13,170,254,201,103,184,172,233,10,16,199,3,214,
191,230,165,122,125,90,138,89,128,28,127,47,94,150,185,108,103,240,156,227,98,
227,17,228,32,167,90,102,141,232,163,188,15,35,194,238,93,89,149,103,169,142,82,
65,185,188,136,126,163,219,194,217,140,140,236,106,223,203,236,234,158,46,168,
241,90,208,241,255,0,47,78,123,103,3,144,147,49,46,70,31,51,209,75,139,206,74,
176,33,77,76,104,252,47,83,19,199,33,66,62,214,38,12,65,1,128,58,184,184,186,
162,36,88,92,183,10,31,183,29,50,164,23,69,35,58,135,77,88,117,196,230,159,53,4,
140,93,98,196,84,188,180,243,69,11,82,207,31,141,120,11,50,183,150,56,136,55,99,
115,200,230,254,210,217,202,37,89,20,140,215,165,115,196,200,200,65,52,232,158,
238,134,161,194,238,90,24,104,30,73,176,245,148,179,85,71,74,132,198,105,231,
165,156,69,80,209,71,44,140,244,196,192,183,9,249,95,235,127,126,148,43,18,170,
115,142,149,71,93,32,158,61,47,177,145,199,46,62,74,230,242,197,83,87,26,150,64,
3,164,173,36,154,147,82,23,46,99,210,192,55,34,222,253,29,72,97,229,94,155,
144,209,148,17,210,104,45,30,58,169,37,158,42,106,202,131,41,102,70,142,18,233,
4,210,212,67,44,75,76,77,165,70,212,12,76,72,210,203,237,234,169,148,10,80,10,
103,249,245,224,92,199,80,112,122,104,201,195,73,28,205,42,44,173,72,181,210,5,
168,165,160,72,140,82,149,245,99,218,101,145,86,63,28,96,92,16,215,60,94,254,
219,146,73,6,24,138,83,207,207,171,132,86,90,160,32,250,116,147,220,144,26,241,
37,102,58,74,170,202,73,36,165,67,84,33,90,87,130,170,58,113,229,121,163,80,
186,127,112,58,171,92,159,235,207,191,41,98,104,192,86,149,245,235,105,165,23,
60,122,75,174,225,202,69,68,41,107,235,165,159,236,230,169,151,68,218,100,2,45,
45,15,160,128,163,91,6,210,90,247,54,3,233,237,66,72,99,64,170,163,137,235,205,
24,102,45,79,78,161,29,194,42,41,160,142,90,90,49,60,82,206,30,162,117,5,230,
142,91,10,116,89,46,204,177,194,166,193,64,32,159,246,30,218,174,78,6,79,78,105,
249,158,159,246,238,102,170,7,162,166,170,156,75,138,142,158,100,56,244,168,150,
154,57,153,164,149,135,150,72,0,145,180,51,234,9,205,236,7,211,219,209,142,229,
98,7,14,154,149,106,173,79,138,189,55,229,160,160,200,207,61,116,51,227,233,
181,84,75,0,199,9,94,89,253,76,53,84,160,145,88,24,245,241,203,106,191,227,222,
164,166,15,91,140,149,26,72,53,165,107,208,143,145,220,88,124,60,84,116,155,122,
134,65,142,195,225,96,162,169,135,53,28,117,39,41,85,48,138,162,166,183,31,69,
37,162,167,20,217,54,44,133,117,27,40,147,245,123,114,103,80,20,32,58,64,166,
127,195,210,120,162,102,44,210,48,212,90,184,253,148,253,157,53,212,246,109,122,
86,67,230,52,57,19,224,65,91,85,12,82,211,62,90,31,19,43,210,100,97,100,69,144,
232,112,143,48,245,190,158,79,245,104,200,73,3,207,167,150,221,64,243,31,228,
251,58,66,193,186,103,89,214,162,58,51,85,56,251,184,167,121,103,49,196,86,72,
222,56,86,5,75,60,126,24,164,228,49,33,138,255,0,75,251,105,165,1,136,39,61,61,
225,254,67,167,92,150,240,172,168,134,158,143,248,77,20,180,227,198,85,101,115,
11,195,51,43,42,200,178,211,198,60,135,243,102,5,79,31,211,222,154,104,234,27,
70,122,210,66,86,180,124,87,168,57,29,211,151,151,45,91,61,52,73,72,181,68,211,
212,104,168,144,234,132,164,106,33,109,81,184,99,251,119,185,55,4,155,31,126,
105,214,164,245,97,16,85,11,198,157,64,197,207,146,242,34,210,211,131,52,210,
189,154,9,166,96,165,85,156,171,186,174,148,38,53,254,213,129,54,30,217,105,213,
42,105,213,192,60,15,78,149,121,10,154,74,25,161,173,169,158,157,228,213,82,
208,27,58,164,110,160,205,10,172,66,64,255,0,116,209,250,137,250,91,142,61,161,
118,241,100,26,80,127,159,167,2,233,28,122,107,174,221,245,53,20,171,66,33,72,
226,209,26,41,73,157,153,162,104,132,127,188,27,132,32,40,176,4,250,69,143,183,
96,181,84,109,69,179,92,255,0,177,235,243,235,218,168,78,58,203,135,130,44,164,
19,53,75,196,198,25,68,168,218,25,52,52,42,177,185,54,11,228,66,133,108,128,
126,47,244,246,169,166,69,4,57,32,214,184,207,87,140,80,138,199,171,229,192,253,
181,235,172,173,13,12,16,204,165,149,228,11,26,165,56,11,228,141,76,168,230,105,
180,176,17,163,234,0,1,127,213,127,105,254,171,87,106,71,143,83,254,78,172,99,
34,164,181,43,228,63,203,210,94,178,174,158,25,101,208,125,41,33,17,196,203,
118,75,198,52,72,161,198,168,213,72,60,125,71,251,31,117,95,17,192,212,115,213,
72,0,157,35,29,53,212,87,212,84,192,177,187,5,138,59,217,80,5,18,51,51,49,154,
69,22,212,231,85,174,127,30,222,68,0,154,2,79,94,45,65,65,211,123,31,173,181,
125,7,224,47,252,108,241,237,192,186,114,192,127,135,166,201,39,207,172,171,74,
79,44,127,219,112,63,216,150,183,251,215,187,226,188,51,213,120,113,235,145,65,
25,91,114,67,2,57,191,251,239,175,187,211,133,122,169,63,46,187,123,179,91,253,
87,22,177,255,0,84,127,175,189,84,19,249,245,177,195,174,202,157,68,30,6,163,
197,197,174,44,44,109,199,227,223,137,60,60,250,240,20,243,235,142,143,221,209,
113,250,190,191,131,207,210,255,0,65,254,191,191,103,226,205,58,223,159,95,255,
215,208,174,10,93,97,238,140,9,45,165,139,89,80,164,110,237,245,28,130,171,244,
54,185,247,112,184,53,31,234,167,90,62,189,98,142,132,203,48,136,31,83,131,162,
215,182,166,179,32,32,41,42,198,246,230,227,222,128,36,252,250,214,50,122,115,
139,111,79,43,21,50,196,116,175,146,66,192,217,67,27,127,100,27,253,15,250,214,
247,178,181,3,173,87,211,169,21,184,26,188,117,42,215,64,36,169,162,19,170,180,
169,29,154,39,191,167,82,171,56,84,112,166,196,155,123,243,70,218,117,12,175,94,
214,43,74,230,157,65,167,146,150,72,139,50,175,148,73,193,36,216,250,185,227,
250,143,175,182,252,201,234,221,45,41,170,97,25,28,120,147,73,49,197,14,152,228,
119,13,113,228,44,209,50,149,210,109,244,39,159,106,146,69,170,215,203,164,210,
35,81,169,195,61,62,125,216,148,214,24,166,47,83,53,76,81,211,220,168,208,192,
233,253,197,118,80,72,64,108,125,188,28,22,96,27,61,55,164,133,4,173,0,233,101,
136,167,172,174,204,85,173,93,77,37,12,7,29,79,56,90,153,36,169,159,33,46,49,21,
169,162,164,129,163,189,75,84,84,45,138,51,5,75,242,196,15,111,170,146,198,180,
2,159,182,157,38,118,26,42,1,38,191,101,43,235,211,62,85,224,197,193,12,41,75,
87,79,13,108,213,50,186,205,74,176,59,67,35,72,200,94,29,82,199,20,66,98,214,
42,205,254,195,219,109,69,82,40,69,122,113,117,59,3,80,88,124,250,101,134,179,
17,76,104,124,207,68,198,39,136,84,197,144,18,197,4,144,206,202,242,122,160,46,
242,43,147,96,108,10,169,6,223,143,116,30,26,233,6,152,233,214,241,88,53,1,207,
167,78,117,213,20,243,103,101,171,53,184,201,98,136,211,173,13,37,35,21,138,58,
80,168,238,163,80,5,204,104,64,102,62,183,34,246,30,238,88,51,147,81,78,154,1,
132,97,116,26,249,244,184,203,86,192,135,13,74,102,167,251,137,42,100,120,61,84,
144,194,180,199,76,115,180,134,103,212,228,155,233,60,16,126,158,222,98,160,0,
78,127,201,211,9,171,184,149,58,64,255,0,138,233,57,190,50,13,140,163,157,96,
153,210,81,77,10,38,169,147,237,202,74,209,178,17,31,143,252,162,89,35,60,16,73,
254,188,123,110,67,65,81,140,116,236,21,114,42,49,94,129,65,229,212,149,18,187,
188,210,49,179,55,44,111,249,183,58,73,63,143,246,30,203,200,28,117,10,158,150,
87,136,3,29,68,251,168,253,58,98,243,187,121,20,199,102,184,36,105,31,163,213,
170,255,0,75,1,207,182,233,129,158,156,210,124,206,58,158,240,78,144,193,44,148,
114,199,25,137,116,201,59,184,184,87,32,148,1,71,209,143,227,241,249,247,162,
166,158,149,235,104,69,104,14,122,199,84,213,55,166,74,136,215,77,72,213,4,160,
41,6,31,35,71,192,210,24,29,96,216,147,127,207,182,188,48,13,107,142,159,241,
59,74,211,169,89,10,25,60,114,49,140,83,216,67,166,5,147,212,197,253,63,183,25,
26,159,233,115,123,90,254,244,186,42,163,85,72,235,69,245,22,210,40,15,78,52,9,
146,243,69,19,25,221,218,35,26,44,78,209,212,16,163,244,232,58,68,158,53,30,165,
227,222,207,3,74,83,236,235,213,20,225,211,249,168,161,135,25,74,139,43,25,230,
144,78,248,186,170,111,56,242,134,85,150,69,117,30,72,207,164,155,6,211,123,123,
103,75,179,145,228,60,250,245,5,9,167,119,79,184,41,106,170,114,152,202,136,230,
89,231,92,138,164,169,18,24,210,141,21,100,13,230,208,186,24,49,98,64,26,137,
63,129,237,68,90,99,113,67,211,50,14,198,251,58,89,96,113,25,119,201,178,197,
86,241,248,228,203,84,172,58,99,8,36,134,148,130,109,34,73,103,144,19,97,254,
223,250,133,104,245,98,64,233,60,185,81,142,158,41,169,183,29,21,23,220,3,246,
114,212,97,178,43,227,90,169,52,212,149,102,71,109,115,35,69,35,5,114,76,96,33,
7,235,114,61,177,36,244,160,242,167,86,88,193,174,60,250,74,67,85,151,164,164,
166,73,167,202,76,105,101,85,168,20,212,109,87,162,25,163,17,175,142,164,7,133,
144,132,33,210,241,150,126,8,228,159,118,89,89,163,36,26,128,125,63,213,233,213,
74,128,244,166,72,61,13,53,123,151,110,127,0,200,71,93,83,90,242,69,91,73,53,
47,222,96,39,196,74,35,106,200,5,74,52,82,36,212,114,254,201,34,194,69,177,250,
88,251,117,167,170,178,156,98,191,207,164,162,50,29,74,250,253,190,95,231,232,
75,218,20,155,115,41,180,55,85,102,54,151,38,133,41,226,34,55,146,122,106,201,
157,102,52,235,44,102,10,151,240,19,16,253,103,82,243,114,182,247,184,38,237,
151,170,78,178,9,34,5,199,236,199,251,61,46,227,146,163,5,182,34,170,165,251,
132,164,136,173,29,45,4,213,145,121,107,100,18,60,102,105,35,104,227,157,195,
202,125,78,85,181,57,38,222,236,211,233,143,88,28,62,127,228,233,177,22,185,52,
176,227,154,211,160,118,108,245,110,118,177,101,164,129,105,154,158,7,65,168,
212,248,105,229,139,212,222,5,117,133,101,152,22,227,89,11,99,233,22,35,217,116,
183,146,61,69,0,21,199,70,49,219,71,24,193,201,255,0,87,236,233,87,79,148,204,
80,97,228,170,202,152,234,167,165,201,52,97,32,121,49,146,52,105,11,199,15,130,
57,221,233,43,116,44,186,142,137,17,141,136,34,194,231,112,70,206,22,66,73,53,
253,157,82,93,58,138,170,128,180,251,127,226,143,66,46,19,115,84,215,108,236,
132,211,154,102,106,140,162,195,79,143,134,161,234,107,171,229,68,167,80,100,
142,48,49,144,164,139,113,98,238,220,255,0,133,137,194,106,211,70,165,122,44,
146,32,178,17,154,83,143,75,204,102,226,174,199,86,97,77,21,28,180,117,199,13,
52,148,176,193,80,29,23,197,89,226,172,138,90,152,60,98,73,105,162,147,90,190,
157,14,108,21,79,62,239,19,180,110,29,73,6,158,189,38,146,53,145,88,18,10,87,
253,92,122,62,157,115,188,96,206,97,113,88,220,133,36,113,101,169,244,205,36,
225,32,157,50,16,199,87,36,102,162,47,220,241,83,200,105,202,201,163,67,130,141,
112,214,184,2,91,59,161,113,14,135,31,170,15,228,125,72,255,0,55,65,219,155,102,
134,93,74,199,69,63,97,199,250,171,208,181,181,168,107,105,102,129,227,130,146,
3,62,122,120,22,170,90,111,217,74,90,26,90,196,213,92,40,81,153,39,118,80,7,6,
203,167,144,24,123,89,70,0,31,159,250,171,210,82,69,114,113,166,191,224,225,208,
185,143,168,201,39,241,147,77,91,182,233,171,38,171,169,175,90,151,124,134,62,
101,158,61,189,140,167,101,145,103,136,66,96,208,117,106,146,225,44,109,97,127,
106,6,175,34,56,252,254,93,37,109,21,21,215,65,249,255,0,168,244,181,216,123,
142,149,235,170,235,178,176,83,26,156,117,53,121,251,234,44,149,92,244,149,0,71,
47,153,203,100,41,226,134,32,101,12,186,131,24,194,129,103,231,219,192,130,115,
199,237,233,36,177,145,165,84,224,158,20,255,0,55,74,61,200,235,145,168,162,156,
210,195,94,152,249,105,196,226,146,55,106,186,42,122,74,120,101,128,36,194,24,
100,166,129,234,162,69,121,226,114,214,98,11,27,143,122,57,210,106,48,122,104,
22,140,181,48,72,63,234,249,253,135,160,127,182,246,166,19,180,49,184,143,227,
251,107,35,146,159,21,81,75,45,62,67,22,29,43,112,85,77,227,168,170,147,9,83,84,
159,118,152,188,140,145,235,146,6,105,148,143,94,160,234,132,19,239,91,77,134,
249,20,73,124,132,188,109,84,117,52,117,245,0,211,225,63,194,65,28,14,14,122,16,
114,230,253,185,114,228,247,18,237,210,170,172,203,71,71,93,72,249,193,43,81,
222,60,152,81,188,178,43,208,98,126,11,117,236,84,243,214,174,250,236,168,81,
107,158,122,108,108,49,109,236,150,234,164,164,173,160,90,184,191,201,126,194,
149,141,22,153,213,80,73,37,67,70,139,123,115,236,28,61,181,217,209,153,215,114,
184,193,60,68,102,128,241,28,60,241,158,56,175,67,215,247,147,152,153,4,50,109,
86,165,104,1,33,165,80,72,173,9,238,53,165,78,48,40,105,195,169,149,223,203,
239,171,107,171,49,121,212,236,46,210,174,219,181,9,85,87,145,169,165,194,109,
57,106,232,150,58,100,154,167,30,77,84,84,234,213,117,84,195,246,214,74,105,13,
202,221,136,55,246,227,123,101,180,16,165,119,59,159,14,185,196,100,254,210,63,
153,7,166,63,215,167,152,1,100,109,162,204,75,74,124,82,211,228,104,15,145,242,
12,7,70,191,171,62,49,252,77,219,249,173,189,77,75,214,251,91,113,110,57,40,
226,105,50,189,167,95,145,223,27,146,162,174,180,207,144,118,201,82,248,232,54,
142,18,162,132,84,66,130,26,72,12,8,15,141,28,48,99,236,69,99,201,156,177,96,
144,164,59,98,72,192,124,82,177,114,73,201,36,97,1,225,193,104,49,78,163,221,
243,155,185,147,152,103,150,231,115,190,112,149,194,68,4,113,160,24,1,70,88,249,
229,137,99,196,249,14,134,205,215,241,127,227,158,231,21,213,25,46,164,218,148,
17,75,65,77,143,21,189,117,132,155,103,103,48,133,106,229,169,198,73,29,118,
205,170,194,102,105,107,216,17,172,249,66,68,88,22,44,69,253,172,186,216,182,27,
136,154,25,118,152,10,210,148,10,23,249,129,199,231,209,36,119,55,202,67,45,219,
129,199,184,107,7,215,13,229,209,81,239,250,237,251,241,35,9,136,220,61,67,219,
155,191,33,71,185,114,223,220,220,191,90,119,13,85,15,102,108,5,218,56,42,22,
201,231,42,171,178,217,149,109,219,131,106,120,107,41,150,138,20,168,170,154,
162,122,149,103,87,88,220,24,159,155,189,180,228,155,150,219,175,47,118,52,146,
97,169,80,146,67,70,48,204,81,193,170,144,193,72,243,243,20,53,168,139,107,158,
75,185,37,134,225,85,145,70,104,13,14,162,41,216,221,135,34,181,2,171,76,16,
122,14,115,93,77,142,249,81,73,62,255,0,222,157,117,141,218,59,203,3,155,206,14,
193,219,120,60,142,224,198,197,53,118,106,108,118,59,15,184,126,195,34,18,166,
179,3,74,152,101,154,25,41,33,197,202,4,205,12,194,70,82,36,131,119,237,195,123,
246,226,226,45,171,104,188,213,104,81,22,1,118,186,213,82,35,169,162,213,134,70,
147,196,210,89,218,67,64,172,140,159,135,82,72,182,90,97,219,60,56,163,33,116,
234,61,131,207,77,51,166,181,32,241,160,167,167,86,247,214,29,147,178,240,155,3,
31,176,49,56,220,31,95,101,54,174,30,139,100,109,172,46,79,35,76,152,49,81,132,
194,83,208,43,97,243,153,8,226,165,174,90,186,42,175,58,25,130,84,84,153,61,74,
238,67,28,151,228,63,122,57,43,153,190,143,99,146,101,219,55,95,13,86,40,167,
112,177,76,64,161,88,39,102,208,207,81,81,27,148,149,178,0,114,9,232,19,184,109,
219,148,55,83,75,116,190,38,166,36,148,201,206,106,80,10,133,242,12,42,49,229,
211,149,29,84,21,121,26,99,130,202,77,145,200,96,107,106,241,213,152,202,10,101,
74,120,213,169,195,44,116,53,117,48,26,185,166,190,173,85,107,11,149,145,180,
180,118,177,247,49,31,244,64,173,89,16,209,133,14,15,167,73,163,198,147,32,162,
54,106,127,203,254,106,138,249,30,144,89,36,220,141,73,158,161,204,121,177,243,
138,164,169,171,160,200,64,180,179,255,0,14,104,61,46,205,47,219,191,221,1,119,
214,67,9,11,22,0,2,0,106,96,196,16,231,52,233,76,79,30,176,209,228,87,242,175,
243,255,0,39,76,49,109,188,84,152,188,31,139,34,148,194,171,25,79,76,184,202,
137,164,173,72,49,144,160,153,38,154,86,100,48,200,84,72,5,197,226,13,110,110,
45,165,141,60,48,107,146,56,116,225,153,204,132,17,195,207,231,233,211,9,195,
97,114,149,20,249,23,111,51,207,184,169,96,146,42,75,137,169,99,154,121,26,56,
42,98,102,15,16,9,17,69,151,214,72,81,112,7,30,219,8,52,150,25,207,231,251,58,
117,100,112,193,78,49,95,229,254,172,116,18,230,49,123,42,108,206,229,172,106,
205,194,181,99,29,94,11,234,130,186,42,129,22,65,107,37,20,144,67,89,143,89,221,
149,196,66,55,104,21,76,71,212,237,101,246,211,248,97,184,154,128,126,121,175,
151,14,149,196,210,149,21,211,146,63,103,12,241,199,159,159,64,245,37,110,16,
215,208,238,108,101,101,28,251,113,43,40,191,143,227,34,207,58,228,112,43,93,73,
82,33,164,169,162,146,154,166,90,40,216,18,144,178,73,40,186,178,157,0,106,246,
209,193,4,154,143,60,244,180,106,100,100,42,67,142,24,227,243,249,252,255,0,46,
130,157,219,191,37,164,220,219,173,169,37,117,200,104,150,74,185,62,198,44,253,
46,62,152,220,98,169,226,240,200,194,158,166,90,104,164,140,180,136,201,34,255,
0,96,16,9,101,165,1,155,248,169,246,253,157,60,144,22,138,42,252,21,199,225,
39,214,191,234,199,69,119,113,110,92,149,30,227,196,75,142,202,226,27,32,42,48,
209,228,97,255,0,41,195,207,20,130,64,32,244,211,226,228,181,45,96,143,91,30,92,
202,225,66,253,79,180,239,41,170,81,148,154,253,158,95,103,70,17,197,64,224,171,
82,152,243,255,0,47,74,152,183,133,101,29,126,26,84,169,130,142,168,200,180,
212,213,117,121,95,60,112,74,22,124,109,100,185,165,170,163,160,254,19,13,60,
237,53,193,73,4,113,168,103,253,64,251,109,218,55,213,171,21,3,206,191,183,211,
171,174,165,210,71,21,169,225,242,242,201,169,233,107,218,251,90,139,178,186,
207,17,151,104,177,251,171,177,48,49,229,167,90,172,109,61,58,214,228,54,125,20,
194,90,198,161,130,136,45,13,77,4,114,177,146,37,128,162,160,130,68,41,172,179,
55,174,96,212,154,234,24,80,112,244,255,0,87,151,14,156,178,153,84,148,161,92,
154,131,94,63,63,243,245,76,93,187,177,127,187,163,100,42,83,203,53,30,95,115,
71,81,53,71,129,189,20,240,71,73,80,194,53,146,55,100,2,87,0,144,56,41,107,139,
251,35,150,12,71,79,54,207,66,75,121,181,120,132,252,74,184,251,79,65,198,228,
196,48,175,134,171,35,21,109,94,46,150,149,231,145,67,37,49,49,67,85,80,37,167,
142,56,212,69,36,204,21,124,36,223,74,6,184,212,111,237,44,241,128,29,200,242,
255,0,87,250,190,71,165,113,200,212,208,27,184,159,245,126,207,240,244,231,149,
223,59,74,167,111,82,228,41,43,169,161,173,135,25,135,166,130,26,26,76,140,210,
98,178,52,242,69,1,134,172,154,26,120,53,213,82,143,35,34,179,105,81,96,183,
177,4,203,2,130,30,160,143,44,80,143,204,102,167,206,189,63,250,135,82,176,252,
207,15,217,242,234,46,75,37,145,173,205,84,230,48,147,182,36,82,227,225,243,54,
82,53,199,73,82,226,20,168,127,225,212,117,6,89,100,98,160,133,212,177,150,184,
183,189,190,177,38,168,134,107,246,127,170,131,173,68,170,168,85,242,63,109,62,
222,155,48,59,206,179,7,78,114,137,153,210,153,60,6,98,22,165,148,152,188,116,
249,57,62,202,168,76,250,37,30,74,177,14,157,60,150,254,163,218,89,238,156,51,
168,61,172,191,236,116,182,59,117,117,92,81,213,191,47,94,128,140,135,101,230,
177,117,25,55,162,171,241,84,100,41,26,149,30,79,220,171,161,241,44,96,248,145,
16,194,18,72,200,177,58,72,91,240,125,183,102,116,212,83,143,79,72,154,138,215,
203,160,197,105,229,201,101,113,181,53,21,6,80,192,206,243,204,224,49,105,152,9,
153,131,17,164,14,88,126,93,152,126,61,170,44,177,22,103,52,169,255,0,138,167,
91,242,32,14,29,44,42,179,25,6,164,15,68,149,152,218,127,187,154,26,106,136,
170,117,71,246,241,4,137,34,180,139,121,74,31,212,126,131,87,30,234,146,68,131,
226,171,249,244,209,21,112,88,84,83,168,27,26,146,76,198,127,113,26,137,101,104,
160,162,105,117,201,36,147,59,171,73,227,141,89,149,236,109,35,107,183,211,143,
168,246,197,221,195,160,77,10,114,124,184,244,226,129,164,84,82,157,53,238,86,
76,108,185,28,85,29,84,50,43,203,254,85,36,114,56,69,30,82,199,75,57,99,231,
186,115,110,127,23,247,84,102,117,30,32,32,122,116,226,168,52,97,215,121,60,237,
12,59,47,26,241,77,227,174,122,233,224,49,232,97,231,142,24,188,143,58,105,62,
54,42,42,108,30,255,0,174,214,7,218,152,64,93,84,4,154,113,61,54,192,179,144,
70,58,7,238,245,116,204,170,206,165,76,128,49,111,236,1,174,207,114,11,91,79,
63,147,127,106,43,80,62,93,95,129,249,117,206,42,88,105,81,88,176,150,75,107,
229,203,155,50,220,149,68,184,26,126,191,212,123,223,219,215,171,94,148,216,188,
69,70,70,92,120,154,49,21,44,130,123,122,244,205,48,69,103,96,145,234,4,106,3,
131,99,115,199,183,87,130,10,244,219,61,3,211,136,233,245,233,169,40,5,63,240,
154,103,165,146,26,170,177,37,68,172,42,37,148,232,64,35,111,35,24,161,141,7,
229,73,4,159,167,245,163,157,36,105,25,207,94,80,91,227,106,212,112,233,188,28,
173,76,85,46,106,134,182,168,1,238,173,44,226,52,68,96,201,32,250,195,112,3,5,
182,159,207,30,245,171,82,235,175,159,91,10,3,80,15,46,185,211,208,214,26,165,
243,168,184,167,54,244,54,150,118,0,170,177,177,211,228,12,44,126,135,223,178,
212,167,26,117,237,74,22,180,224,122,142,216,185,254,226,68,177,208,210,70,242,
104,73,60,145,155,40,157,116,160,37,165,143,87,43,110,79,231,243,237,134,82,9,5,
113,211,128,138,10,245,195,43,79,169,41,226,142,139,197,32,80,174,200,178,134,
117,6,202,205,168,255,0,111,234,71,224,251,161,4,26,249,117,181,243,207,77,50,
255,0,147,84,79,27,194,93,163,148,18,186,239,234,244,177,250,18,75,113,244,246,
212,128,234,1,70,63,193,214,192,20,207,79,212,181,243,165,55,162,10,168,162,51,
54,152,116,152,215,199,101,99,39,165,23,242,198,214,63,215,218,118,136,212,213,
197,122,112,80,138,233,233,138,190,164,70,229,128,18,79,59,160,18,150,119,111,
24,86,85,67,168,155,139,31,246,254,238,177,86,149,110,209,229,214,243,192,14,
155,168,245,9,11,178,57,241,177,103,34,204,125,42,228,40,39,129,118,62,220,102,
160,162,211,175,5,4,212,158,148,24,204,172,212,146,137,35,66,45,81,33,89,85,148,
72,133,227,210,108,140,133,74,5,63,159,205,184,246,203,68,207,246,158,156,70,
210,120,116,203,151,202,75,85,43,204,238,4,178,234,89,53,122,158,72,218,202,1,
80,23,73,10,163,253,183,183,99,131,78,24,227,170,51,212,154,14,61,38,88,22,36,
234,39,243,170,215,114,71,23,36,255,0,189,123,127,2,148,234,189,198,158,93,100,
187,71,27,11,27,23,210,215,250,240,5,199,245,23,191,189,249,113,207,94,11,94,
178,66,86,69,32,149,10,45,107,143,81,22,7,208,0,228,255,0,175,238,164,210,149,
234,234,181,243,235,35,213,39,5,81,174,87,213,170,223,82,57,254,188,143,110,107,
249,116,206,154,117,142,71,14,202,64,177,109,60,95,147,109,55,63,79,118,12,9,
160,199,85,35,21,235,154,45,229,191,225,11,49,32,255,0,193,136,3,241,203,123,
245,104,104,6,107,215,188,171,215,15,201,23,191,45,205,172,121,35,155,19,113,
199,189,212,250,99,253,85,235,99,249,245,216,83,168,191,228,255,0,182,252,14,63,
58,191,62,245,92,241,26,125,122,215,159,14,191,255,208,208,246,149,7,133,203,
105,225,129,36,240,72,42,194,236,127,10,15,183,85,177,195,135,251,61,104,140,
245,232,92,171,157,54,30,159,161,42,52,142,7,234,181,198,160,63,30,244,14,113,
199,175,48,225,94,179,193,53,83,15,218,84,66,0,82,9,10,175,107,49,189,212,243,
253,127,195,222,245,19,90,14,168,71,159,74,138,41,178,6,150,47,184,47,5,18,17,
56,101,145,153,14,153,65,111,26,49,8,121,55,32,139,126,61,168,66,116,128,71,
111,76,61,11,118,154,191,14,152,242,56,104,166,19,214,82,9,169,231,18,188,142,
60,45,225,96,206,182,102,37,172,133,181,130,0,91,123,171,196,26,164,96,215,242,
234,241,185,20,7,34,159,159,73,228,172,168,134,178,159,204,0,149,21,108,204,120,
126,8,5,88,254,10,159,105,72,32,208,142,159,227,145,214,121,114,85,16,206,94,38,
49,176,114,203,160,114,164,27,139,127,67,199,189,3,76,142,189,64,69,15,14,157,
227,222,155,130,121,34,89,114,51,76,162,57,98,88,201,181,210,72,217,90,43,160,
87,208,255,0,218,0,139,251,127,234,101,193,103,36,14,152,250,104,133,116,165,
43,212,79,188,243,188,127,120,210,8,209,12,39,192,72,145,66,234,178,159,43,50,
131,127,173,253,215,90,189,42,113,213,252,58,3,65,231,212,58,152,163,150,95,37,
7,220,172,105,226,85,21,5,36,151,82,90,238,242,40,85,245,176,224,91,143,122,
193,166,147,79,183,173,208,129,66,163,167,15,226,149,113,74,99,251,120,201,115,
22,181,104,17,152,73,24,26,89,27,72,149,31,80,191,7,159,119,241,115,74,14,171,
225,131,230,127,111,82,234,247,29,116,243,210,253,220,172,62,216,105,0,209,194,
242,149,145,238,224,137,65,83,99,244,62,252,242,177,199,159,85,88,148,3,65,199,
231,211,118,86,113,92,94,100,158,162,114,218,17,228,153,125,64,105,80,34,177,
102,1,17,64,2,214,246,197,79,175,87,85,211,138,1,212,180,166,251,85,166,42,12,
141,28,193,136,153,139,37,217,46,81,212,17,197,199,214,252,123,184,92,130,56,
245,90,244,205,60,210,186,16,17,41,239,43,223,195,169,53,19,102,245,31,212,5,
190,150,62,232,72,234,227,237,235,29,239,77,16,98,206,218,141,139,75,33,1,46,
215,64,186,180,242,220,253,63,30,234,192,249,117,126,7,167,41,162,171,20,16,84,
201,84,173,13,44,203,28,16,120,204,210,6,125,50,178,7,101,26,99,60,126,72,4,241,
238,128,130,197,105,229,214,241,196,117,46,166,170,90,231,122,153,156,197,20,
244,241,129,36,84,209,153,72,136,250,226,136,48,83,228,6,196,176,32,241,253,61,
213,66,167,104,226,15,91,30,84,233,218,175,43,67,140,52,243,99,42,106,107,106,
214,159,159,186,10,85,101,149,116,220,248,253,38,69,38,228,92,155,251,210,214,
74,134,92,87,173,241,205,58,229,182,124,1,30,166,182,104,124,172,238,209,134,
141,165,213,36,101,72,136,56,244,198,215,99,112,65,224,127,95,116,145,155,80,10,
166,157,108,82,153,57,232,88,218,219,137,4,135,95,130,208,212,210,76,146,211,36,
87,167,47,28,162,118,44,145,171,150,12,20,21,36,170,255,0,75,159,109,5,147,90,
144,185,235,78,123,104,79,66,134,214,206,98,255,0,140,85,73,85,18,178,173,6,113,
1,120,170,21,30,87,240,60,98,67,18,234,136,48,70,245,128,64,32,94,194,254,205,
227,97,26,18,87,58,106,122,47,149,25,169,221,138,142,156,70,74,154,170,161,233,
150,84,100,163,197,100,252,48,10,168,132,158,25,130,85,72,209,155,172,107,56,
107,91,144,110,222,202,101,99,64,77,41,210,165,90,22,52,243,234,54,39,38,248,
120,178,50,179,72,144,62,61,231,116,142,24,149,4,208,60,82,169,150,80,74,212,
205,63,209,80,45,238,198,195,219,182,211,128,37,0,86,180,254,95,111,77,77,30,
162,149,245,255,0,15,74,188,158,226,195,229,49,181,177,209,228,113,238,181,152,
58,137,234,96,171,34,156,210,214,210,211,211,160,135,84,144,58,203,53,68,207,
116,0,221,154,192,126,79,181,36,51,85,156,28,142,152,2,132,16,48,24,126,202,245,
15,102,227,40,230,164,207,53,49,168,199,228,106,233,100,138,153,41,235,102,172,
21,144,12,117,46,85,130,186,120,169,229,13,44,68,56,43,244,93,32,219,223,163,
70,40,253,198,132,249,15,78,157,145,168,232,10,10,143,159,207,161,66,189,227,
159,108,209,8,235,116,87,69,87,70,26,138,166,164,121,103,48,75,60,197,148,35,
135,105,66,147,251,86,60,27,223,143,101,165,142,161,85,39,56,252,250,80,65,53,0,
138,83,253,95,179,160,147,43,138,202,237,124,142,70,178,155,29,144,203,99,18,10,
74,138,186,90,41,26,106,200,197,76,177,199,44,67,30,146,77,81,53,52,114,141,41,
50,35,222,61,55,183,215,218,191,166,109,10,199,225,174,61,122,103,196,13,85,
173,27,253,95,228,233,99,132,222,248,29,195,128,202,209,76,176,33,138,182,158,
182,158,159,196,34,156,47,239,165,82,73,12,139,35,3,2,20,184,80,44,77,137,246,
178,18,99,140,253,189,36,150,35,172,29,94,94,189,119,91,85,141,27,48,203,131,
106,88,107,170,114,213,85,51,99,106,124,141,29,68,20,47,73,44,85,152,217,165,
146,244,117,128,35,171,34,160,15,170,223,129,117,72,213,74,173,1,233,157,44,178,
16,224,240,227,79,240,250,250,244,177,218,155,215,5,144,20,2,189,234,224,113,
142,151,196,101,43,27,65,44,213,26,69,52,210,145,78,147,133,80,72,107,146,56,
191,248,95,80,32,80,208,244,220,145,56,36,168,29,12,123,115,183,115,120,109,199,
182,105,54,204,113,215,81,82,98,41,166,174,251,179,45,111,130,155,35,36,136,208,
125,245,56,9,231,170,132,31,28,65,203,32,30,155,128,65,85,109,60,144,180,110,
134,191,111,161,227,210,25,173,99,149,100,215,241,126,204,253,157,89,79,94,110,
173,189,185,48,143,154,117,151,28,217,122,200,114,134,3,144,142,68,166,62,54,
165,138,89,166,148,44,41,76,99,172,88,228,147,129,34,5,63,95,160,166,23,134,84,
142,78,0,231,143,219,252,191,195,208,98,72,102,138,86,140,10,144,41,195,243,225,
199,161,19,16,180,199,29,183,40,41,241,176,102,232,228,201,213,213,212,227,171,
107,234,94,157,105,224,198,213,82,75,121,233,252,245,85,49,74,178,248,204,5,217,
101,225,111,112,183,86,165,10,174,149,243,233,52,161,195,55,125,13,56,211,215,
252,7,231,211,197,6,230,151,29,91,87,140,138,138,151,106,213,214,74,152,218,138,
39,172,158,131,31,45,30,144,203,29,61,6,86,34,244,212,166,56,148,232,184,244,
158,111,127,122,50,37,90,130,159,234,244,234,130,38,160,37,139,15,231,252,186,
82,214,110,44,231,150,170,24,42,224,1,231,158,96,212,19,37,125,75,169,81,18,35,
211,83,51,72,33,215,118,250,1,249,254,158,244,206,0,99,164,254,93,53,225,131,65,
65,233,158,151,123,114,42,233,113,208,192,149,175,91,145,155,31,71,44,179,212,
226,50,149,144,65,43,72,137,52,112,83,36,241,134,142,56,208,91,89,23,189,191,30,
219,45,35,41,8,158,94,191,228,233,167,72,193,12,104,22,190,160,116,51,225,75,75,
130,140,209,212,227,171,107,234,234,18,147,24,177,98,210,134,169,11,164,209,249,
214,166,182,178,69,45,76,169,167,76,158,157,35,235,244,38,134,55,49,54,70,178,
104,58,101,168,178,209,129,0,12,230,189,58,127,121,97,144,24,134,26,158,150,88,
43,205,45,113,164,158,143,59,21,93,52,41,73,20,241,47,130,165,94,146,150,162,
96,192,220,218,205,97,113,238,221,192,70,66,0,65,206,73,7,252,185,233,191,8,
247,143,16,181,70,49,164,138,240,251,79,66,38,7,55,246,64,140,126,26,42,58,20,
199,164,81,181,46,222,198,214,86,85,138,153,27,199,67,36,240,104,169,167,167,89,
34,37,82,52,99,117,4,168,60,151,196,142,199,70,160,22,131,200,126,207,151,249,
122,77,162,134,164,146,213,206,72,3,231,78,132,10,77,255,0,79,147,194,83,203,81,
67,148,11,67,89,86,185,7,24,186,196,169,167,165,165,169,133,81,98,106,122,26,
58,167,167,134,174,69,26,156,159,27,198,9,254,134,193,168,70,23,31,111,84,104,
220,6,10,198,166,180,244,233,135,124,226,250,227,125,229,182,126,235,203,237,
186,221,193,144,216,217,12,206,91,111,211,87,71,40,195,209,229,170,232,104,214,
124,149,93,12,154,233,50,25,19,61,44,70,9,103,134,102,167,49,134,139,67,122,131,
55,54,182,183,178,193,44,209,234,240,137,42,60,129,60,73,245,225,130,107,79,46,
156,182,123,155,120,164,137,100,3,93,1,62,116,28,0,254,120,175,219,209,107,249,
29,191,242,123,34,175,167,171,241,184,138,83,149,172,139,126,98,179,134,151,61,
36,211,228,54,126,114,109,191,93,83,131,171,171,132,75,20,177,228,115,51,69,89,
27,58,181,77,60,212,193,148,221,218,240,151,190,214,91,117,255,0,45,237,246,
243,64,62,162,25,204,203,32,5,154,61,42,65,175,170,177,106,29,70,159,183,165,
150,182,167,233,238,238,29,219,195,170,210,163,26,151,207,242,24,244,53,249,116,
93,247,143,110,230,42,241,52,120,218,56,99,24,28,152,220,109,152,74,198,147,33,
138,219,91,170,147,46,153,250,106,157,189,74,30,3,71,86,177,230,170,43,42,4,111,
228,146,162,89,146,127,44,6,56,151,24,172,57,103,111,184,119,253,231,6,173,13,
17,70,0,7,42,202,17,195,113,212,171,165,21,117,13,60,2,233,98,79,70,214,207,36,
182,209,52,197,137,137,234,24,211,7,87,104,7,243,60,113,154,122,116,160,193,124,
140,220,221,53,87,4,93,161,183,243,59,135,99,207,12,245,88,238,251,235,140,86,
102,191,109,226,176,200,212,223,117,81,191,118,173,66,255,0,20,217,211,195,42,
165,234,99,142,76,119,218,106,144,50,125,125,228,109,180,60,239,200,49,44,188,
183,185,75,190,114,128,132,180,80,206,78,180,83,66,166,59,134,70,146,48,163,30,
20,160,198,71,194,65,201,241,182,219,239,208,71,45,97,191,213,70,213,74,181,
124,192,4,43,26,255,0,14,122,52,219,127,187,182,223,98,228,235,235,48,27,247,
110,246,126,58,162,138,137,169,42,112,217,204,116,167,193,246,205,95,82,209,210,
202,177,85,214,205,37,59,148,148,171,189,172,190,158,1,35,93,143,221,157,187,
116,72,227,220,39,91,91,224,66,152,238,25,32,110,52,170,25,8,138,80,73,160,43,
46,190,21,65,195,162,219,142,89,187,181,171,91,193,226,68,115,170,48,91,203,
205,126,37,32,14,5,105,232,72,207,74,241,184,247,106,79,28,255,0,192,104,205,18,
227,101,138,148,153,157,161,155,202,241,199,166,37,85,19,77,19,211,72,108,202,
170,110,61,203,113,93,201,34,43,27,98,168,69,65,60,8,227,85,34,161,129,242,161,
232,136,193,23,112,89,136,122,231,212,122,212,30,7,164,230,95,127,212,80,41,171,
205,109,188,62,3,28,50,136,97,173,172,147,44,200,255,0,109,64,236,209,99,234,
146,145,233,36,200,165,64,26,135,169,81,26,238,192,250,125,184,103,26,78,164,11,
159,58,255,0,44,113,234,209,91,18,71,135,51,48,161,225,79,230,56,211,160,31,114,
239,184,178,85,123,153,177,48,227,98,164,175,120,41,54,252,84,117,89,24,170,164,
141,38,255,0,114,52,185,79,226,11,30,169,124,245,26,220,67,32,18,92,233,3,72,5,
153,92,49,37,70,15,14,57,251,107,209,141,180,12,52,234,98,72,193,173,41,242,165,
63,213,94,61,3,248,252,254,83,248,94,84,85,224,176,255,0,100,180,116,145,86,84,
99,232,42,127,136,212,61,85,82,210,154,183,50,204,13,77,60,33,90,50,116,184,
138,37,36,139,19,237,166,86,203,20,167,74,145,80,178,162,202,213,251,124,253,62,
71,211,164,37,22,236,172,204,87,75,146,138,158,25,161,201,200,176,149,24,156,
125,29,66,184,89,33,138,112,98,130,157,170,18,166,56,120,96,46,10,223,243,237,
149,36,213,135,3,242,255,0,87,30,148,60,74,154,81,137,20,4,241,39,254,43,160,
235,119,12,149,6,118,150,178,178,190,163,23,28,56,76,12,181,75,4,20,244,174,100,
130,114,22,25,170,163,215,252,87,33,51,132,242,62,171,166,189,109,97,199,186,
202,36,14,23,129,255,0,55,175,250,177,211,208,232,104,201,165,120,241,63,224,
244,29,5,251,171,126,230,246,206,73,240,213,155,130,146,124,133,99,85,172,116,
81,65,29,30,70,56,209,233,191,138,100,33,58,225,118,167,105,164,72,100,111,24,
142,95,46,174,109,112,69,22,243,183,94,203,119,107,103,127,20,179,197,241,42,28,
129,194,181,243,24,165,65,35,165,241,64,207,165,252,34,22,128,230,191,151,88,
240,59,203,127,215,127,119,254,223,37,78,248,202,73,51,153,40,150,151,113,82,80,
85,53,58,214,82,164,52,17,195,230,106,214,101,137,90,89,19,83,70,79,26,125,87,
246,97,11,62,144,7,144,255,0,80,255,0,87,14,172,209,208,146,71,113,167,145,253,
189,8,27,247,173,240,61,165,83,183,105,178,91,114,42,215,196,61,113,53,47,154,
146,138,174,159,33,246,104,244,15,71,78,147,197,31,217,84,214,64,5,115,68,166,
86,184,211,167,145,237,215,137,38,211,169,114,15,250,191,111,86,142,105,32,36,
171,100,254,206,138,7,125,244,181,86,7,112,12,94,7,31,80,155,118,12,86,102,103,
203,214,64,166,145,107,104,42,34,21,212,90,230,243,75,29,116,105,82,30,24,152,
151,150,53,45,113,165,189,151,223,91,14,196,0,133,63,158,122,48,178,185,175,136,
238,195,88,35,246,116,72,51,155,10,118,172,221,185,42,106,92,76,216,186,122,154,
168,36,240,228,106,176,181,70,155,14,201,81,52,176,99,210,166,158,130,106,181,
17,9,8,74,105,102,144,19,164,243,112,80,109,93,89,153,88,5,7,249,116,110,183,
72,22,53,96,117,145,246,140,255,0,171,215,160,71,57,81,83,46,99,57,54,51,49,94,
138,213,105,247,48,110,216,148,140,132,171,7,142,90,38,142,89,42,100,74,191,44,
71,198,98,241,144,150,4,253,61,163,253,80,206,75,138,231,136,233,114,132,208,
149,83,254,212,240,252,250,205,15,241,28,198,219,158,162,150,44,92,73,77,141,
173,163,173,200,192,245,21,50,211,213,83,213,205,84,209,82,197,26,248,117,8,236,
82,231,244,144,13,143,62,202,175,109,29,212,74,171,90,122,99,243,251,61,122,
126,41,86,57,41,171,143,10,255,0,171,246,116,94,114,80,253,162,188,136,245,4,84,
67,84,193,156,22,67,34,13,18,21,107,122,230,208,220,159,199,251,207,182,33,214,
62,42,84,116,177,216,54,71,83,74,86,195,79,141,188,176,174,154,104,170,8,33,10,
148,151,76,138,93,60,102,204,168,64,35,235,127,118,49,52,204,91,56,199,30,170,
29,64,53,245,235,5,84,147,181,44,94,121,16,51,9,216,164,15,52,141,167,88,33,
220,18,18,37,23,28,40,26,143,215,221,210,34,164,147,199,170,234,95,203,167,125,
173,91,77,135,254,240,197,83,37,101,53,92,152,89,157,188,0,94,25,33,49,85,83,
197,40,114,117,35,34,106,96,188,255,0,94,61,250,88,221,130,61,48,15,251,29,107,
36,12,224,255,0,62,144,85,211,77,90,245,14,166,241,186,70,243,84,202,215,38,
224,220,107,63,218,188,159,81,237,212,136,124,92,58,112,53,6,158,177,212,80,253,
229,52,20,212,52,245,76,144,35,76,26,105,91,198,145,14,36,88,217,216,40,37,138,
3,107,147,112,7,181,41,25,32,138,117,77,64,18,89,178,122,106,165,163,170,158,
55,52,244,242,24,226,44,29,17,100,54,185,23,105,28,11,70,151,255,0,31,175,189,
208,105,0,3,213,137,3,207,161,43,7,64,148,81,194,245,81,73,20,222,54,117,49,83,
193,57,17,130,70,165,50,46,151,118,107,91,89,227,250,123,218,249,83,211,166,92,
212,113,20,233,79,133,197,213,228,50,56,105,86,158,24,33,134,73,209,228,48,200,
38,113,80,39,87,88,180,50,67,10,0,193,174,21,136,97,245,247,231,112,186,73,248,
122,208,80,67,130,114,127,201,211,164,219,43,239,18,86,131,32,35,88,243,21,116,
174,210,170,178,36,175,25,149,22,209,132,33,74,143,165,253,165,18,9,40,224,226,
190,189,88,2,134,135,142,145,211,71,247,82,169,49,117,163,205,76,230,142,182,54,
89,85,190,220,171,152,150,63,218,145,236,186,185,23,91,218,222,235,43,24,211,
196,242,61,58,157,205,160,113,167,73,182,243,67,146,154,150,77,18,191,217,36,
114,201,79,32,104,74,201,16,17,206,8,38,53,120,217,236,225,77,185,252,123,114,
57,129,161,225,219,211,122,40,8,60,43,212,54,199,231,36,169,163,136,145,12,149,
17,89,25,230,75,201,246,241,155,179,30,87,201,31,30,175,169,224,251,189,88,154,
129,158,156,162,208,244,201,148,254,32,37,68,168,30,89,86,52,111,219,151,210,
173,169,129,46,87,85,213,194,125,63,38,254,219,145,205,104,79,91,85,20,52,24,
175,77,83,82,56,169,63,116,146,137,36,100,229,72,88,163,46,168,117,21,54,54,8,
223,215,143,241,246,197,107,168,182,71,87,0,212,1,210,150,58,49,246,186,97,121,
90,34,154,98,101,148,77,166,233,251,140,69,203,5,184,191,244,0,251,105,136,102,
207,78,0,116,154,116,206,113,51,175,137,84,3,169,211,91,149,244,162,51,27,18,
164,113,200,181,248,189,189,236,80,215,74,245,170,17,146,122,195,28,17,25,103,
140,72,170,34,142,98,193,165,209,169,163,139,81,58,133,193,214,108,63,215,246,
228,113,147,146,104,58,209,122,82,131,168,116,198,83,168,199,28,122,30,39,111,
243,140,206,140,120,14,25,25,108,214,28,3,199,245,30,222,65,76,133,20,235,85,
206,122,108,180,104,7,173,188,133,46,85,172,85,94,252,158,72,54,62,244,51,146,
122,245,77,0,167,92,12,203,192,147,68,129,141,136,64,56,80,44,120,22,36,159,199,
62,252,124,235,199,175,103,168,18,149,55,0,233,67,32,58,77,206,128,91,241,127,
169,0,125,125,236,83,73,234,213,160,56,207,92,181,42,170,162,61,191,86,162,84,
31,240,22,63,95,199,186,133,4,147,231,254,110,189,172,231,174,113,195,205,228,
32,130,7,210,247,185,23,3,143,118,11,154,17,213,24,215,35,169,6,156,107,26,71,
165,120,176,36,155,113,99,207,32,241,238,250,64,36,14,52,234,181,199,89,202,139,
142,63,178,67,3,193,255,0,3,207,38,254,246,218,120,158,181,220,78,58,247,136,
146,204,66,129,244,245,15,37,205,135,228,131,98,111,193,247,90,140,0,49,92,127,
159,253,142,173,79,159,93,16,190,65,199,22,255,0,97,125,39,252,126,188,123,213,
13,14,115,78,63,229,225,213,104,106,69,5,122,255,209,208,162,26,169,52,73,169,
144,43,32,22,3,235,102,83,111,207,234,247,176,196,84,121,117,176,5,115,212,132,
171,133,117,51,106,245,37,150,202,27,212,64,250,243,115,167,159,126,168,207,94,
35,3,215,167,10,90,244,138,37,85,117,212,29,200,242,68,183,26,147,212,117,185,
0,242,5,189,239,81,0,117,237,57,56,52,234,97,202,146,42,18,162,178,105,34,20,
209,172,17,196,193,35,129,139,13,64,5,224,106,94,27,142,125,219,196,98,8,45,229,
213,60,37,25,3,53,206,58,225,38,66,158,95,41,87,144,164,206,196,152,206,176,218,
66,216,128,8,85,84,123,127,143,189,235,98,123,124,207,159,91,10,149,238,175,15,
231,212,41,77,13,67,211,36,192,6,85,10,65,5,25,236,13,152,48,252,185,247,82,117,
48,30,93,88,81,84,13,61,221,50,84,211,200,174,194,39,18,11,106,37,138,130,182,
229,130,150,55,32,15,165,249,62,234,71,144,235,64,131,214,90,106,197,165,145,
128,138,215,66,205,44,168,173,33,96,135,210,150,4,34,150,107,255,0,83,111,116,
32,154,87,175,117,29,170,146,105,136,141,154,37,112,5,200,185,98,72,187,185,31,
150,213,127,240,247,177,81,196,245,176,126,89,233,217,31,199,10,199,4,186,207,
147,247,90,246,99,166,218,66,147,206,147,249,250,123,168,169,58,136,167,91,38,
190,93,78,167,153,229,200,68,29,163,114,242,43,4,118,82,161,143,224,184,176,0,
91,222,201,210,42,106,122,214,43,211,157,109,40,53,104,172,127,94,150,71,95,80,
179,160,210,1,227,128,223,237,189,248,72,41,198,159,46,181,79,46,163,205,143,
150,158,163,195,43,166,161,36,75,118,147,74,2,20,59,92,93,149,237,127,160,252,
241,239,74,225,135,203,173,17,140,112,233,238,172,163,80,82,198,129,4,144,203,
35,74,228,5,5,91,233,103,38,197,172,71,31,131,238,193,232,125,15,76,132,109,68,
211,20,233,53,20,148,175,25,89,203,43,25,165,33,192,215,111,210,80,58,155,50,
161,183,213,125,251,171,149,35,53,29,73,52,9,37,52,50,162,43,3,175,79,238,217,
153,181,158,85,44,188,113,253,125,232,16,73,0,228,117,178,178,32,86,35,7,172,
126,83,24,138,9,32,141,149,181,41,15,229,58,217,175,165,152,7,26,100,95,195,15,
160,247,96,159,46,180,24,228,245,26,182,142,82,32,146,8,66,172,104,22,234,175,
105,27,85,155,80,114,92,155,31,168,185,62,235,164,10,142,61,92,55,237,233,185,
204,178,18,89,10,178,134,83,100,100,211,227,228,253,71,226,222,234,64,7,180,117,
96,120,103,167,76,69,89,13,31,238,52,96,128,218,143,169,85,195,15,85,154,230,
50,196,115,238,186,120,212,99,173,241,243,233,87,137,154,177,158,166,142,158,
166,109,33,216,172,52,241,128,241,254,239,153,206,160,163,209,41,78,5,248,4,219,
219,109,48,142,140,163,243,235,193,117,87,61,9,59,93,36,74,250,129,83,83,53,72,
171,160,200,154,120,144,60,173,4,130,38,45,43,51,133,148,92,3,193,22,7,221,26,
121,29,105,90,99,246,245,66,0,57,30,125,58,65,78,232,181,81,67,60,21,18,199,20,
194,63,184,146,59,21,154,50,86,38,84,188,190,59,15,85,253,86,183,180,250,75,149,
102,234,203,140,211,167,221,183,151,142,47,185,143,39,19,77,12,144,77,79,59,60,
210,60,104,41,163,86,167,154,8,248,149,39,138,91,105,6,234,223,159,199,181,176,
192,129,100,245,211,211,50,229,163,53,243,232,69,196,201,137,204,227,96,135,199,
56,132,227,51,146,44,43,64,209,208,154,234,58,19,60,89,42,202,183,34,169,153,
32,136,157,78,193,24,94,255,0,143,107,35,118,236,171,10,83,164,174,160,120,140,
6,106,51,211,238,223,11,137,147,25,246,102,170,119,200,71,2,46,137,229,242,
204,179,98,42,81,226,131,64,120,212,212,16,92,171,89,24,128,46,1,246,161,217,
188,50,170,72,173,127,101,58,161,21,106,154,99,252,253,54,101,170,118,181,118,
26,26,172,132,149,187,127,61,67,36,151,145,98,169,85,89,157,52,25,41,75,232,
214,211,9,46,0,62,107,6,11,199,62,210,67,106,115,35,17,163,203,237,249,244,244,
146,157,65,87,63,228,255,0,87,250,143,80,54,92,178,213,214,212,71,184,183,86,82,
73,232,27,26,179,69,138,95,179,106,138,88,38,86,1,50,136,242,213,8,158,152,34,
58,130,160,13,64,216,88,21,165,106,84,179,96,116,205,70,64,28,122,125,222,67,
110,211,82,87,207,77,44,18,85,153,168,36,200,80,188,84,241,213,212,81,83,86,85,
10,154,191,52,66,73,86,114,146,104,121,72,93,108,23,146,65,181,194,15,13,253,
122,107,89,18,197,233,158,185,212,100,54,139,109,44,29,61,36,89,210,191,198,170,
1,88,105,162,122,72,17,160,149,22,55,158,184,26,184,140,143,10,157,65,164,13,
193,210,108,15,189,141,10,171,219,219,254,199,86,238,47,37,72,213,229,235,78,
156,104,54,36,57,236,83,212,201,71,246,173,79,145,158,128,84,197,146,146,150,59,
202,244,211,194,106,106,164,137,105,102,49,199,43,89,76,68,146,64,38,194,227,
102,38,104,212,145,65,156,252,254,222,152,105,130,74,203,171,26,122,48,59,103,
111,211,96,240,120,73,69,35,72,148,16,227,42,106,105,252,145,130,176,83,51,44,
149,176,52,87,34,120,96,145,101,142,197,148,232,39,210,79,181,81,67,164,43,72,
48,40,127,217,233,12,178,234,119,208,114,73,207,71,99,226,118,35,118,101,182,
213,93,117,101,34,205,130,170,163,162,76,61,75,196,146,83,212,85,79,91,61,30,71,
202,76,50,10,105,222,76,50,188,104,1,10,175,126,46,125,157,237,78,100,214,167,
224,20,254,117,232,163,116,11,19,70,203,241,154,215,215,0,127,159,163,95,142,
196,83,208,102,182,220,85,19,170,54,54,130,162,74,202,10,72,25,105,214,86,196,
249,20,85,60,45,77,41,168,83,35,41,30,160,192,92,11,242,13,66,48,101,169,237,29,
18,75,46,165,115,167,56,201,233,73,134,168,166,170,169,161,214,212,149,98,67,
85,150,149,178,180,100,203,28,179,82,190,62,45,21,20,245,112,87,197,3,172,195,
210,210,53,217,7,22,36,123,169,35,134,41,94,168,21,142,64,33,169,76,127,170,157,
96,142,150,29,192,50,243,85,110,81,6,98,68,89,66,208,210,98,182,221,21,84,81,
199,28,53,209,65,87,89,59,71,19,201,10,35,5,7,81,109,95,94,79,186,208,176,99,82,
15,202,159,229,234,172,198,50,131,71,102,120,212,211,210,180,233,119,140,201,
82,99,112,180,184,54,198,100,97,175,74,58,97,91,154,76,205,70,97,102,11,28,51,
83,70,41,113,211,255,0,15,10,241,168,184,58,249,58,141,189,221,70,2,210,134,
156,107,95,240,116,156,130,196,201,172,20,175,10,1,246,241,255,0,99,165,245,45,
107,215,227,41,177,20,248,154,90,42,120,96,131,207,60,144,73,143,102,158,41,36,
101,145,170,94,160,173,59,58,203,227,113,16,83,39,0,143,234,219,150,85,210,169,
143,245,125,189,120,0,29,164,103,169,252,142,63,213,194,189,57,98,41,176,120,
154,58,170,120,169,16,215,10,169,39,90,218,121,228,242,152,170,232,226,142,72,
12,181,17,199,75,52,17,75,25,96,204,154,193,54,185,224,123,107,234,74,33,172,
71,249,255,0,150,157,89,161,105,95,14,60,135,31,217,195,161,103,15,153,219,180,
84,36,73,153,201,69,49,164,134,20,88,164,89,18,72,213,132,177,152,226,100,86,
133,181,46,149,184,80,0,184,181,200,247,161,115,27,26,234,53,167,77,27,89,170,
79,134,8,234,30,230,223,155,94,167,111,205,87,91,187,225,199,181,1,201,253,179,
54,61,42,106,234,167,95,177,100,167,241,209,201,60,213,40,178,42,151,87,69,140,
27,179,19,237,61,197,228,5,91,92,148,167,15,51,81,242,31,234,245,233,69,181,
156,226,128,67,90,241,205,7,30,57,255,0,39,69,86,15,145,112,108,28,205,21,73,
166,219,187,158,153,215,33,28,147,86,62,226,104,177,53,209,65,91,144,165,138,
162,39,166,198,227,12,243,153,147,83,66,242,136,132,74,142,8,34,228,35,116,250,
105,53,29,12,164,249,234,199,26,121,12,253,149,232,66,118,145,117,14,154,178,48,
244,211,144,113,234,77,7,206,156,122,0,126,69,118,182,238,238,129,180,242,27,87,
99,228,48,89,109,173,147,25,121,242,110,212,181,152,106,164,69,197,213,83,120,
104,168,105,98,153,18,42,188,72,37,1,153,136,102,83,192,185,7,243,57,253,251,
107,45,188,150,68,169,142,69,52,248,74,186,208,142,222,224,15,175,17,229,210,
200,246,184,173,237,102,128,206,36,12,8,0,212,113,168,57,63,35,249,113,232,50,
218,251,220,103,179,121,42,60,232,124,13,85,126,105,49,25,124,44,213,33,153,106,
41,26,90,220,125,125,101,18,131,227,171,163,92,140,96,155,177,146,158,86,87,
244,187,95,31,175,237,164,219,60,59,41,35,106,193,7,197,164,130,165,194,134,80,
220,89,92,0,212,32,29,65,72,202,138,23,189,140,214,12,109,88,171,198,232,56,100,
3,195,143,168,34,163,246,231,161,223,175,48,221,201,6,215,173,204,109,60,197,
37,70,212,198,180,184,106,10,68,150,133,178,81,253,149,92,52,249,28,124,115,77,
3,57,88,139,53,144,204,53,2,200,64,34,222,242,55,147,174,247,75,205,135,110,
191,130,106,46,141,36,96,54,165,52,122,113,52,38,164,10,240,52,61,59,51,88,220,
36,43,115,13,36,101,26,177,219,90,113,165,120,31,47,62,139,238,237,234,29,213,
153,223,245,27,167,25,136,162,217,25,218,115,121,178,155,63,13,79,178,34,53,112,
196,100,89,170,41,113,52,244,148,149,117,5,21,27,202,229,154,96,205,125,95,95,
122,221,246,40,183,105,36,75,219,24,154,54,20,97,161,66,183,218,180,161,63,58,
116,190,218,107,120,33,11,19,184,97,195,184,146,63,213,252,186,18,83,182,62,89,
117,78,210,76,52,91,230,29,211,183,76,212,47,75,135,221,251,82,129,252,18,5,44,
143,73,185,40,82,44,193,158,170,20,85,149,131,161,40,8,35,144,65,68,28,183,119,
178,198,163,99,220,174,172,212,112,88,220,248,98,188,71,134,218,208,87,228,162,
131,135,87,144,193,126,25,46,18,57,129,205,93,70,175,247,177,221,143,183,167,
189,169,242,215,181,230,139,94,235,217,244,25,90,106,6,202,84,45,54,22,171,103,
215,100,42,105,104,245,212,84,208,154,45,205,67,143,168,128,150,188,48,205,67,
44,146,8,110,206,165,141,203,177,110,30,230,88,78,178,199,204,145,93,192,6,99,
184,133,24,19,242,49,178,63,243,254,93,33,147,99,217,157,89,70,222,241,201,235,
28,140,63,227,213,7,246,30,155,178,253,255,0,6,74,182,186,142,135,175,59,143,
15,18,110,105,90,88,42,182,102,11,37,22,58,41,43,96,172,150,76,118,90,159,13,
81,58,69,90,180,229,196,113,197,227,210,156,155,122,131,109,205,94,235,137,132,
31,187,118,185,45,117,226,79,6,224,57,207,240,43,208,125,128,211,231,211,47,
179,109,221,166,21,152,28,106,5,235,143,145,11,159,58,87,164,86,55,188,42,182,
234,230,242,84,189,125,220,51,237,211,73,86,212,117,213,187,90,76,117,122,215,
197,95,151,73,235,38,163,165,138,175,31,58,84,80,77,27,68,145,51,36,119,5,200,
102,210,174,46,249,238,109,164,126,53,189,165,165,53,146,200,96,156,161,4,96,46,
185,137,1,77,77,84,40,53,249,116,195,109,59,106,134,255,0,25,106,147,128,104,8,
207,173,105,95,183,160,190,135,228,220,177,87,84,86,86,245,231,111,152,242,24,
41,206,209,166,160,218,20,245,63,101,152,158,146,166,163,29,91,86,137,5,37,40,
164,133,161,7,194,138,101,152,222,196,27,123,78,188,205,238,180,139,19,8,45,198,
162,62,27,102,62,103,9,169,155,138,240,45,83,199,229,215,163,219,237,12,146,6,
117,104,198,62,48,15,206,164,99,160,187,181,247,215,201,108,255,0,241,188,237,
22,198,203,224,241,52,63,192,115,56,8,183,46,66,159,6,208,98,178,180,120,218,
122,92,116,88,233,228,124,141,110,66,102,162,21,85,207,85,33,241,53,208,150,80,
192,40,190,217,189,196,230,27,73,147,123,220,166,88,24,1,225,199,166,5,0,215,56,
210,204,212,35,86,170,138,10,17,142,158,181,143,110,128,233,86,82,204,79,14,237,
32,124,255,0,203,249,116,24,110,14,167,236,156,215,97,46,247,222,89,170,76,45,
124,117,180,117,50,137,254,202,170,41,226,142,132,84,229,241,160,82,84,192,148,
166,73,165,84,72,233,210,88,153,181,234,116,97,102,16,109,124,163,38,215,53,157,
192,148,70,33,80,10,142,230,97,76,234,114,120,147,241,82,163,141,41,210,248,238,
99,42,161,106,198,135,253,143,245,99,236,233,123,143,50,213,174,30,135,17,128,
198,164,56,234,108,207,223,229,107,170,170,49,57,10,217,38,202,176,11,79,65,82,
149,66,170,147,32,39,70,138,68,90,101,17,95,91,55,167,216,217,72,210,16,47,1,
231,138,31,242,244,196,185,109,69,243,92,80,87,246,255,0,168,231,167,161,149,
220,17,102,182,100,112,201,145,168,63,197,171,41,163,167,129,42,190,207,66,82,
170,134,99,8,142,150,8,105,188,35,65,109,32,159,161,36,223,222,148,176,17,208,
226,189,80,232,62,38,170,112,252,250,24,106,55,190,82,179,49,80,39,102,166,129,
95,35,142,171,142,58,185,210,170,69,137,4,212,211,77,32,34,70,242,2,67,11,221,
201,183,35,232,251,76,193,213,73,160,7,166,68,43,161,177,82,71,73,154,122,94,
190,223,57,26,9,179,84,88,246,21,47,95,247,45,113,69,13,93,84,19,7,158,58,169,
22,100,90,26,167,141,27,83,66,21,220,89,91,87,187,19,20,142,117,47,250,191,213,
249,245,80,37,69,237,39,162,129,185,254,63,108,52,201,110,76,164,123,142,178,
162,182,61,192,42,99,163,172,194,210,120,113,148,115,204,245,171,0,200,199,84,
211,84,73,36,17,5,50,27,134,140,2,71,36,251,46,150,210,13,76,218,170,212,255,0,
87,219,209,140,87,179,133,69,11,68,251,120,244,128,163,248,189,252,11,174,179,
243,237,221,208,50,181,217,138,250,183,170,142,150,162,92,124,117,98,189,134,
152,52,214,86,61,45,60,180,116,245,72,11,144,174,232,165,126,167,79,180,2,204,8,
155,75,130,79,250,169,158,151,27,253,82,174,184,240,63,213,228,43,208,1,150,232,
90,249,48,117,147,84,73,72,205,4,117,82,195,91,105,105,106,32,168,164,157,41,
50,17,199,65,42,164,147,194,75,45,244,92,56,96,227,143,104,158,214,149,4,112,
227,210,244,189,161,0,112,253,191,62,146,59,139,164,183,173,13,118,34,150,74,72,
164,134,170,10,89,150,90,24,165,171,134,44,115,40,90,154,132,158,55,140,207,45,
33,91,152,136,103,6,215,22,247,191,164,106,40,68,201,29,88,94,197,165,216,156,
252,253,127,217,233,23,77,215,123,158,143,17,36,185,60,36,148,149,194,164,64,
213,181,177,79,44,181,62,162,41,40,241,20,112,49,65,160,5,144,180,129,87,155,31,
165,189,183,244,79,241,48,32,143,231,246,116,227,93,196,88,4,106,143,245,113,
233,99,67,211,27,170,106,172,236,48,120,106,107,42,118,221,84,212,184,247,172,
166,134,47,186,129,97,137,114,84,245,211,67,81,50,26,106,134,211,52,67,77,195,
90,229,120,246,232,219,156,234,163,10,250,116,201,191,140,4,4,16,181,227,79,
229,212,105,122,126,179,248,133,68,149,117,20,149,15,81,24,90,232,33,111,180,
130,54,138,42,104,102,48,16,134,57,25,30,35,206,128,100,45,244,30,238,182,58,42,
9,175,90,250,218,133,0,80,121,31,62,158,106,122,226,41,93,100,145,113,178,78,
83,246,126,228,188,49,255,0,147,209,40,142,53,38,11,71,81,15,138,225,88,5,213,
207,227,219,134,37,0,240,234,171,112,126,116,232,29,167,146,120,113,38,146,88,
214,33,41,149,216,172,98,55,101,18,200,73,168,117,10,106,139,113,98,247,22,183,
30,208,177,109,36,121,116,97,69,46,8,207,250,191,144,234,124,94,20,164,196,84,
85,43,34,150,150,23,157,136,17,206,80,52,145,164,104,26,236,145,180,118,39,250,
183,186,84,5,86,61,108,130,90,64,163,53,233,67,128,200,200,42,225,104,103,137,
150,25,226,147,198,10,131,26,18,82,228,145,112,22,66,46,127,199,218,119,89,36,
13,225,200,8,62,84,235,221,170,1,161,7,252,61,62,72,213,20,84,57,73,147,194,92,
110,98,68,112,74,174,89,190,221,11,52,81,249,20,182,133,43,123,126,73,30,203,82,
25,170,64,92,142,148,187,169,208,124,136,233,55,148,169,170,155,1,83,4,235,26,
84,213,101,233,167,165,150,64,148,243,42,206,139,10,51,69,254,116,34,147,126,1,
0,243,248,246,252,166,95,7,67,142,6,189,54,154,124,74,169,242,167,72,218,239,
179,199,206,254,73,164,171,170,251,53,43,25,136,65,78,142,170,235,119,112,203,
45,73,102,7,147,245,252,142,61,179,27,59,0,66,227,167,52,214,190,149,235,10,
231,163,120,40,222,89,97,95,19,44,209,178,69,170,93,109,101,168,125,106,25,139,
2,150,4,94,195,143,207,181,74,39,56,207,31,79,242,245,172,10,215,172,117,117,
216,89,42,103,149,150,169,30,122,104,144,197,226,119,86,104,209,154,70,104,162,
81,28,110,202,46,79,228,18,79,183,30,22,85,171,212,19,215,131,131,211,86,122,
174,137,42,81,41,225,122,181,138,154,21,212,162,53,83,36,106,168,211,70,218,136,
145,70,155,122,110,108,61,249,130,142,209,233,215,149,201,21,56,53,233,45,30,86,
113,173,105,174,26,103,138,52,137,157,132,78,204,14,164,35,246,195,70,223,86,
226,195,143,109,162,141,64,133,4,117,114,9,60,79,14,185,212,228,218,10,25,233,
158,105,103,170,73,74,66,209,60,134,153,3,92,146,90,73,24,202,168,65,177,91,47,
183,245,128,180,85,3,173,5,37,170,79,111,76,43,85,40,44,102,117,42,99,44,6,165,
94,28,1,112,162,199,245,55,211,221,42,73,110,175,64,60,250,245,60,142,81,252,
115,48,1,95,244,150,95,233,253,45,193,254,190,244,9,245,235,98,158,157,66,37,65,
176,212,223,215,87,2,246,224,114,121,31,227,239,198,190,124,122,169,235,131,73,
166,214,42,127,224,160,158,45,98,65,32,0,65,247,163,215,135,175,88,216,146,20,
189,254,183,250,91,234,72,185,183,244,247,108,5,94,175,65,65,156,245,61,105,226,
17,35,179,139,178,253,0,103,55,28,219,240,162,234,125,234,131,203,170,240,249,
244,225,4,113,32,141,180,128,24,13,42,218,121,185,35,145,110,15,248,123,181,104,
122,213,7,152,233,246,56,40,137,118,158,203,40,40,10,235,96,46,223,69,111,160,
70,32,254,125,216,147,249,245,90,15,46,177,63,218,249,110,35,188,66,59,233,208,
198,197,11,2,46,73,4,49,183,182,201,175,19,254,175,242,117,160,42,122,207,36,
148,168,79,166,36,66,160,250,209,46,109,205,193,99,113,107,127,175,111,119,0,31,
60,127,63,240,117,227,194,157,54,153,241,230,169,79,136,54,145,115,57,4,34,92,
48,210,171,125,79,171,232,120,176,30,245,78,56,20,235,117,106,113,207,249,58,
255,210,208,153,62,213,148,36,177,152,238,218,75,36,135,210,20,88,182,159,163,
177,99,254,216,123,184,3,207,175,16,65,227,214,54,142,45,65,34,114,192,94,237,
248,50,15,192,22,6,192,125,63,199,221,105,194,156,58,240,39,61,75,130,37,241,
198,142,81,152,183,36,174,169,44,100,177,244,31,232,163,250,251,221,56,125,189,
107,81,7,229,211,144,133,9,171,140,162,186,195,22,162,85,194,148,85,183,63,91,
220,159,199,187,208,85,170,56,14,181,171,129,175,159,81,197,29,57,8,4,254,50,
215,36,186,234,141,30,192,216,149,228,42,255,0,177,191,189,105,6,153,235,97,190,
93,69,74,53,51,198,145,73,20,242,53,65,77,74,8,141,180,184,81,160,159,170,177,
60,27,112,61,235,73,168,30,117,252,186,182,172,112,235,170,186,58,184,90,70,
100,42,186,91,91,35,29,12,53,176,30,177,112,110,87,253,141,189,248,169,25,52,
235,90,148,240,29,54,4,96,127,83,242,15,32,146,109,164,220,95,254,53,238,180,
175,14,183,94,24,235,50,134,89,116,139,127,101,53,52,106,88,41,91,2,64,7,159,
205,253,232,138,117,173,88,249,117,153,163,145,22,54,215,27,171,48,245,3,98,26,
220,130,0,36,15,126,160,61,106,188,71,94,87,109,113,183,40,224,173,152,21,32,
242,108,86,220,251,245,58,223,78,75,149,169,19,196,243,31,56,136,168,11,33,58,
56,185,22,3,142,11,92,127,143,186,24,212,212,14,61,123,167,137,51,20,149,11,1,
170,136,121,13,75,75,35,39,160,42,182,149,183,245,55,3,250,253,125,179,225,48,
38,135,20,235,96,211,169,121,2,141,11,189,29,66,201,24,64,224,13,44,241,128,
183,37,135,245,23,250,255,0,135,189,196,199,85,27,7,170,176,4,100,116,140,111,
32,104,201,55,46,25,137,32,250,175,123,147,245,250,219,253,135,181,84,25,28,58,
173,78,123,122,149,79,148,168,164,138,36,210,94,45,110,2,233,13,98,228,92,131,
250,173,254,30,234,20,3,170,157,88,179,80,41,108,14,164,166,102,172,76,135,237,
225,117,15,233,18,66,247,4,220,94,54,107,2,66,253,63,167,187,130,195,180,112,
234,186,126,125,41,155,114,201,26,83,211,37,16,65,10,163,137,4,51,51,74,29,193,
117,102,110,29,133,248,112,66,219,221,72,66,107,82,27,170,233,38,185,199,93,228,
50,242,87,187,83,201,143,5,30,158,75,59,192,194,88,219,194,89,164,69,19,32,0,
42,131,99,111,235,111,123,49,129,86,62,93,109,69,58,69,75,1,129,160,52,238,206,
146,197,172,155,21,4,219,81,5,9,186,233,35,253,183,186,26,16,65,29,59,229,243,
233,223,17,146,169,167,172,18,199,20,240,72,181,17,185,106,104,222,93,76,183,60,
0,222,134,0,254,73,30,211,201,0,97,199,29,108,53,51,231,208,163,179,119,1,254,
52,242,86,215,65,28,126,28,130,6,169,242,22,99,36,108,170,128,68,158,85,150,66,
44,1,4,95,159,199,189,36,42,162,148,242,234,146,122,142,132,13,187,87,67,124,
189,91,210,61,84,181,56,201,100,240,195,13,51,8,170,97,4,172,122,170,188,158,34,
238,190,183,95,73,91,130,57,246,220,145,149,210,25,188,250,222,172,246,244,157,
207,213,208,227,229,138,40,229,202,165,125,119,129,26,158,116,138,154,5,166,171,
41,17,101,35,80,74,185,170,20,36,100,130,138,159,75,92,123,126,55,210,166,148,
225,213,114,196,30,134,204,94,110,26,12,38,53,211,30,145,205,91,135,202,83,84,
18,173,85,174,44,118,48,154,74,117,152,233,138,157,98,121,79,144,233,97,33,111,
80,247,182,157,85,161,95,12,84,14,53,167,31,203,166,188,34,222,47,121,161,63,
229,251,122,100,195,238,186,201,50,184,163,227,171,172,21,52,84,48,10,53,134,76,
54,38,9,101,130,162,57,124,121,39,31,229,85,170,146,3,165,198,148,181,175,99,
238,235,116,236,72,41,92,250,255,0,144,14,29,120,194,136,5,15,218,127,62,178,
110,70,25,122,61,191,183,214,154,44,83,101,114,244,113,203,147,30,106,153,169,
90,158,150,176,145,53,72,147,194,148,136,19,81,88,244,148,112,63,175,42,98,184,
81,24,86,90,83,164,239,17,50,23,83,254,172,116,147,168,193,214,98,178,21,113,
99,170,22,178,159,29,76,25,42,42,11,226,106,106,161,130,48,213,34,145,21,43,30,
170,162,121,8,212,171,163,84,135,144,57,178,144,241,144,41,32,211,211,116,62,
104,122,17,40,162,200,97,54,228,143,156,138,130,170,171,43,54,58,162,56,41,142,
184,155,26,117,154,103,18,200,169,81,14,65,38,214,24,126,146,82,196,115,237,74,
50,120,109,220,9,62,158,159,231,233,59,212,203,29,42,0,175,79,123,122,56,142,
209,219,181,85,250,4,80,212,85,198,137,43,175,219,172,137,53,108,148,122,193,34,
211,180,112,149,0,158,127,28,123,214,128,81,9,245,252,186,164,146,184,145,208,
122,126,127,62,151,216,170,198,202,203,77,75,54,66,119,104,170,204,213,52,58,
196,208,196,137,25,138,57,222,88,180,198,137,42,71,22,182,44,140,117,49,60,123,
117,168,123,75,112,60,60,186,77,195,187,78,122,24,240,152,220,198,114,111,182,
51,154,81,30,17,41,170,185,89,96,40,24,185,8,205,116,86,212,162,43,88,2,129,
184,228,159,110,5,118,243,224,189,48,89,83,52,226,113,213,232,124,101,154,187,
109,252,107,197,54,95,111,227,42,164,222,24,250,106,218,12,149,93,68,20,117,56,
88,81,107,167,168,124,109,60,84,233,10,79,42,180,49,194,124,133,154,59,92,11,
216,156,216,6,141,81,221,176,104,122,37,220,157,36,119,68,90,176,20,63,109,122,
103,221,240,210,84,230,168,142,37,166,150,186,12,60,117,25,89,42,242,41,12,162,
106,168,37,167,72,212,82,218,70,209,75,8,96,110,44,207,253,71,179,4,148,150,62,
100,15,245,127,131,162,183,69,10,188,127,103,250,177,210,90,139,37,62,55,115,
100,3,97,148,98,40,182,212,113,193,85,77,20,245,50,195,81,27,67,40,146,122,167,
166,30,74,121,24,218,68,45,112,64,55,230,254,218,18,56,35,82,29,62,185,233,198,
85,96,218,91,187,211,29,37,243,89,170,88,71,219,67,71,247,209,84,83,73,86,178,
69,45,57,154,111,24,68,240,143,60,250,33,46,28,106,11,202,158,79,0,217,169,174,
68,71,73,126,34,163,215,173,197,107,36,203,169,13,0,63,151,250,191,213,196,245,
34,143,125,226,49,120,216,169,233,177,217,151,71,161,77,75,70,206,90,90,181,
167,80,26,9,22,103,137,18,49,245,185,189,249,183,178,251,157,214,56,163,52,142,
82,212,31,15,175,12,17,233,209,157,150,209,61,204,170,117,194,22,191,142,159,
111,3,235,229,212,42,254,225,45,247,98,19,185,177,144,138,20,168,84,151,33,84,
245,70,96,124,101,89,40,241,162,20,89,192,37,73,123,128,45,127,97,217,247,139,
151,145,213,12,232,180,24,102,106,255,0,198,86,159,102,127,62,133,246,155,13,
178,164,126,36,22,178,73,83,144,139,74,127,182,98,113,231,131,246,117,3,29,221,
89,124,92,213,243,194,249,42,149,43,64,154,170,166,158,170,160,180,145,137,86,
218,230,142,197,26,227,90,141,69,79,180,11,187,238,17,18,60,73,8,36,100,154,255,
0,35,209,132,252,185,181,220,70,123,96,18,133,52,85,70,21,62,149,11,76,159,83,
208,205,138,236,141,207,185,49,217,9,163,205,97,176,254,118,240,137,234,49,145,
37,122,154,120,155,90,25,106,158,4,146,80,171,97,164,182,176,65,0,181,253,153,
141,214,102,143,55,20,7,134,9,253,164,15,240,244,21,125,162,56,157,244,218,84,
168,238,206,7,228,127,200,58,17,233,246,46,99,61,182,99,169,171,204,103,242,21,
211,149,169,167,104,113,184,232,60,80,179,120,133,52,116,107,0,142,121,39,8,204,
53,50,181,213,77,192,189,215,253,45,212,138,8,121,53,211,21,90,215,246,112,63,
224,243,232,169,239,45,163,169,240,163,211,95,38,63,224,233,25,186,58,194,166,
44,29,70,67,41,179,242,85,213,56,202,184,214,159,55,154,169,88,49,20,82,73,69,
52,146,77,30,223,74,121,160,154,166,58,133,69,98,247,5,137,245,149,22,44,95,
217,125,53,185,158,229,36,33,127,27,124,32,250,233,0,147,233,252,250,114,210,
248,77,48,142,57,209,65,226,170,59,141,60,171,94,129,218,100,220,27,98,24,49,
181,84,152,172,206,23,39,95,229,158,134,186,120,104,42,168,171,150,71,153,171,
40,42,220,81,9,40,170,164,149,131,42,59,160,144,130,85,121,176,121,46,196,34,
71,140,137,20,100,241,173,107,197,72,7,207,136,255,0,0,232,218,102,86,11,90,
171,47,160,36,126,124,127,111,65,247,99,245,126,59,124,110,20,220,184,178,187,
83,126,227,228,196,73,74,130,182,162,60,78,64,209,60,52,144,197,184,168,214,26,
147,51,85,226,188,148,45,91,77,33,63,111,44,101,150,79,183,137,125,146,111,27,
54,221,190,199,43,169,49,221,180,101,5,50,43,80,84,184,167,225,53,0,131,192,
145,228,58,113,30,51,11,197,56,212,132,124,64,85,128,227,140,208,138,230,135,60,
105,196,244,108,186,15,3,186,176,155,7,43,139,202,193,79,67,81,38,252,206,86,38,
18,162,96,176,71,77,45,6,7,30,50,84,181,100,207,73,150,199,86,85,226,166,145,
106,35,88,196,170,229,139,95,146,38,228,77,187,112,219,54,5,177,220,115,50,79,
37,62,105,68,1,129,224,84,233,52,32,14,6,185,175,65,107,249,16,78,2,182,86,53,
21,25,205,88,210,158,70,132,99,203,237,232,103,199,236,156,101,62,228,170,206,
207,4,6,10,58,106,72,145,234,166,174,168,160,163,168,172,132,210,67,51,78,210,
152,91,210,133,80,57,102,177,4,0,109,236,109,29,172,94,49,126,42,163,231,64,79,
207,135,69,82,221,73,225,104,12,106,78,120,84,211,229,199,246,116,141,223,219,3,
51,156,193,193,83,137,195,82,230,233,131,78,217,8,49,181,181,113,102,18,33,28,
45,227,158,149,99,115,81,79,87,60,14,226,235,251,107,253,65,246,220,214,114,73,
26,180,105,168,131,229,199,203,136,252,171,210,171,107,216,227,144,137,36,42,
212,20,39,135,252,93,62,125,23,186,30,180,219,137,131,173,158,175,5,76,149,72,
245,180,201,137,21,52,205,89,18,214,75,28,114,162,25,86,54,53,40,9,244,168,86,
36,139,11,147,236,180,88,33,46,52,154,138,227,21,244,199,249,135,70,191,188,37,
5,8,144,21,52,205,62,94,116,242,249,244,6,111,29,189,185,232,171,243,212,251,
109,183,62,26,171,27,85,77,29,45,13,101,61,3,209,249,38,79,28,213,18,26,146,181,
160,249,92,198,116,235,5,121,0,2,125,166,146,27,168,128,82,88,56,39,203,202,184,
30,184,251,63,46,149,71,116,143,70,214,165,24,121,31,231,233,211,62,198,236,
253,207,182,179,57,216,178,181,113,210,54,38,42,140,127,222,105,116,162,119,121,
158,57,231,163,168,165,30,77,107,43,220,168,224,162,251,122,61,198,120,156,30,
45,94,53,2,159,58,159,240,14,169,36,49,72,128,17,199,253,92,15,66,32,223,85,59,
157,240,48,212,212,97,82,137,233,106,86,112,217,5,33,210,41,37,141,38,188,242,8,
89,226,145,13,154,18,179,234,78,46,61,172,139,119,185,241,4,98,117,56,173,11,
154,129,194,180,36,254,85,31,103,73,94,198,33,169,244,231,236,255,0,55,81,183,
86,222,197,101,242,228,65,154,162,171,158,124,53,108,85,52,52,49,99,166,171,
158,10,172,99,83,194,168,213,107,58,82,77,66,35,168,84,158,53,44,134,126,10,158,
125,155,125,79,137,66,204,141,92,224,138,215,135,236,233,42,161,65,167,69,0,35,
249,127,171,135,64,238,233,219,148,152,252,30,46,60,141,14,82,122,204,110,114,
167,6,181,205,146,130,182,156,211,203,77,4,148,213,149,16,165,68,51,66,239,48,
115,27,105,253,197,34,228,145,127,109,181,8,161,173,107,235,254,30,149,71,35,
247,0,202,5,61,41,195,246,255,0,62,131,118,59,114,146,187,29,93,78,147,248,235,
48,52,153,56,131,71,169,111,19,69,141,170,37,140,178,211,72,98,145,117,6,4,148,
214,7,167,221,5,20,143,66,58,116,248,141,85,36,84,55,175,93,229,242,52,17,100,
118,157,26,125,140,112,151,175,200,130,101,128,214,167,221,40,74,83,13,90,212,
32,72,163,105,25,153,100,79,91,129,111,161,247,93,67,244,243,215,134,163,226,
159,58,83,135,167,203,164,102,224,220,47,87,150,220,6,150,137,230,167,153,163,
171,134,162,9,164,251,148,150,106,133,163,36,210,82,153,5,69,51,148,1,157,91,
252,72,28,251,164,142,11,51,80,241,233,216,214,138,160,241,255,0,87,159,175,73,
253,191,85,149,20,50,150,154,154,146,163,25,53,92,141,78,243,10,64,35,146,174,
117,140,83,67,91,28,70,74,129,11,218,71,82,108,5,137,247,97,168,150,58,128,53,
255,0,87,30,182,218,69,48,104,124,248,244,157,139,29,145,201,190,110,166,58,137,
62,234,121,218,38,122,96,29,195,104,146,41,75,195,30,177,233,132,216,1,114,1,
246,195,161,110,226,79,87,12,20,233,167,74,188,69,45,108,24,76,181,52,145,152,
164,90,138,3,13,41,96,133,173,70,179,52,160,51,89,101,255,0,54,64,60,250,185,
183,215,221,72,33,52,211,173,134,5,171,208,113,151,173,153,246,253,38,86,167,
203,61,99,193,91,73,83,67,165,38,169,166,128,72,163,83,80,198,226,57,12,222,33,
235,63,184,85,77,139,15,108,82,171,86,227,79,245,30,159,31,25,81,235,212,102,
141,154,70,119,121,34,157,98,188,149,159,115,41,135,246,232,64,130,58,72,75,200,
17,2,143,160,182,179,245,231,219,209,130,51,76,245,87,165,41,90,231,135,72,231,
211,252,63,27,79,45,68,103,238,43,53,131,49,12,146,72,229,149,8,244,106,82,52,
27,139,241,127,123,36,208,131,230,122,182,144,24,176,29,56,211,214,203,95,121,
39,170,85,168,168,165,175,165,210,144,20,75,24,213,20,17,165,16,29,49,133,191,
31,91,159,123,13,169,73,45,214,130,81,192,11,142,129,234,218,88,169,242,168,
144,25,102,146,202,233,17,149,84,172,17,20,150,73,25,157,130,63,55,54,23,60,123,
78,64,213,65,199,165,32,213,125,7,67,94,200,219,120,141,205,89,71,142,201,200,
49,15,95,30,90,154,44,156,169,19,199,1,150,146,70,162,150,104,132,131,72,251,
128,168,117,122,138,158,15,62,223,72,86,70,1,141,43,231,211,46,230,52,44,162,
180,35,29,87,39,102,98,55,94,222,205,230,97,171,161,146,145,41,43,234,113,147,
72,148,111,75,71,44,212,146,73,31,220,208,43,164,108,41,42,160,140,60,36,92,58,
16,121,191,178,73,227,117,103,168,207,15,151,66,27,119,141,209,8,62,85,249,244,
27,253,198,65,177,248,148,168,154,70,137,107,38,169,134,41,117,58,7,55,102,102,
123,234,32,149,225,126,131,159,235,237,144,13,20,19,211,198,133,223,25,167,74,
205,183,81,44,149,84,139,60,14,205,37,92,46,13,41,209,80,66,79,21,198,141,71,
201,168,2,109,193,255,0,109,237,177,10,185,168,237,111,151,90,99,64,212,108,83,
207,215,165,61,85,111,220,215,101,104,41,38,86,145,235,252,203,231,137,226,150,
38,140,40,152,234,23,40,69,136,60,147,127,105,74,76,146,54,154,177,169,207,78,
16,52,33,99,74,14,147,181,213,206,103,170,166,153,91,76,109,31,146,84,156,148,
209,2,233,137,97,42,31,76,132,240,9,54,184,247,230,138,103,82,24,26,215,173,46,
154,134,29,35,43,43,86,166,180,232,129,209,98,50,18,243,77,229,44,186,138,128,
67,40,231,79,228,155,95,219,208,195,165,178,163,29,92,181,64,161,199,81,115,
117,239,74,152,248,22,125,20,242,196,101,138,4,91,52,81,7,179,121,77,174,73,151,
85,173,233,32,123,83,35,178,178,231,20,233,180,90,234,175,26,245,203,27,4,153,
69,172,170,140,180,180,201,4,144,204,94,102,71,138,63,9,102,156,198,73,99,12,
100,89,173,201,191,186,55,234,106,39,35,173,212,71,164,112,61,38,242,48,79,79,
58,15,37,210,104,160,122,89,175,37,154,153,227,186,232,45,200,85,67,164,253,79,
227,219,12,186,91,128,255,0,99,167,84,130,48,51,212,122,24,218,89,153,77,131,
199,20,146,11,182,144,22,49,248,184,34,224,253,63,175,186,198,7,167,86,106,14,
160,77,61,221,131,22,229,216,144,73,184,228,131,253,144,121,255,0,91,221,122,
176,225,195,174,62,96,57,245,16,111,199,228,89,108,44,126,156,123,221,124,199,
94,167,26,113,235,177,61,131,47,170,205,25,13,99,110,73,4,19,111,168,227,222,
200,43,143,58,117,234,126,206,163,23,255,0,3,254,177,254,190,235,199,61,87,236,
235,144,115,110,13,137,22,63,82,109,244,183,251,31,126,235,100,83,172,129,25,
172,5,207,215,240,126,151,254,130,247,250,251,217,224,7,86,62,190,93,79,142,55,
84,0,234,22,86,228,131,98,56,250,112,69,236,120,247,170,145,214,143,14,156,3,
199,2,192,224,232,96,84,250,65,44,202,164,217,150,247,58,201,62,237,74,228,14,
169,215,22,172,242,51,113,99,193,63,133,212,73,36,233,231,147,254,240,125,216,
130,6,58,169,175,151,80,164,168,37,129,13,162,49,127,212,196,6,184,63,91,90,230,
254,246,22,148,38,149,235,98,190,125,114,73,4,128,21,245,127,137,244,131,254,
181,249,62,236,13,9,234,167,203,211,174,32,191,148,254,226,129,160,13,28,105,
111,167,5,175,96,65,247,79,83,231,171,252,189,91,202,180,235,255,211,208,154,
174,32,174,109,101,80,72,0,92,143,201,184,250,250,100,250,253,127,62,247,213,
197,72,234,35,31,89,32,216,155,126,155,254,64,228,91,235,115,239,93,106,135,211,
172,162,121,53,129,171,155,129,127,205,150,192,29,86,184,38,222,236,13,8,35,175,
21,4,224,99,167,54,171,22,144,180,122,75,198,162,70,75,16,234,8,210,108,214,33,
172,57,23,62,220,114,8,39,206,157,55,160,142,177,138,136,25,156,6,41,104,208,1,
164,233,37,64,187,5,7,209,193,250,95,159,235,238,131,35,173,253,163,168,190,68,
87,128,70,229,212,78,210,43,243,19,191,11,112,215,253,58,173,254,176,247,170,
211,129,235,221,58,213,84,212,25,154,73,213,158,59,159,28,13,163,72,46,8,187,
104,54,125,31,81,97,254,219,221,137,62,99,21,234,163,208,113,235,28,75,27,79,28,
65,202,0,21,101,86,81,112,37,224,132,224,222,224,253,111,113,239,75,74,140,230,
189,111,52,175,92,167,162,143,215,37,58,74,151,12,172,75,43,169,176,177,85,190,
151,214,192,126,47,239,198,149,192,235,192,249,30,177,209,209,63,221,82,243,26,
171,141,106,231,87,26,117,6,178,145,235,117,176,244,243,115,199,189,83,129,38,
131,175,30,6,156,122,205,90,180,198,95,28,75,230,8,198,72,234,124,46,179,73,168,
128,99,154,48,56,213,244,2,252,123,208,211,82,7,10,245,81,80,160,145,67,211,44,
197,133,67,48,80,161,221,244,39,226,193,138,128,87,130,46,61,232,210,166,157,92,
112,29,72,41,114,177,168,212,214,10,224,105,54,117,191,0,115,127,117,245,61,90,
188,58,230,141,52,5,180,179,114,135,210,120,26,74,144,192,3,245,4,123,165,5,77,
71,94,227,212,186,89,226,146,88,53,22,137,213,72,5,192,42,75,92,30,44,65,77,39,
128,65,247,230,50,45,104,216,235,84,175,83,150,146,6,164,119,31,180,202,172,11,
242,67,57,118,40,83,234,99,97,107,143,168,255,0,91,223,146,122,18,167,211,170,
21,109,67,211,166,195,29,84,26,4,177,52,162,218,148,146,193,153,57,26,148,177,
10,250,148,253,71,183,227,112,194,163,61,108,210,163,200,245,33,243,50,29,20,
211,69,42,47,219,162,56,4,150,10,183,40,171,96,73,5,121,54,176,35,221,72,53,213,
231,215,169,194,157,76,25,88,90,162,73,160,114,204,212,164,5,157,210,59,222,19,
9,250,169,86,49,171,31,72,228,255,0,95,126,171,112,7,29,86,134,134,188,58,139,
19,152,226,167,158,55,8,73,118,5,202,200,8,215,249,185,36,18,63,22,228,126,125,
251,69,124,186,177,39,61,78,160,200,170,200,140,203,246,166,50,218,100,165,82,
60,197,143,62,113,172,16,57,60,242,45,238,196,46,157,36,117,82,107,192,227,167,
122,25,113,205,90,146,68,207,75,52,174,102,21,9,36,68,121,180,48,230,57,85,130,
160,102,39,147,249,252,123,105,200,65,85,53,20,225,213,128,212,50,122,115,20,59,
135,39,53,124,20,80,67,80,194,49,173,163,113,27,165,27,176,214,76,69,172,235,59,
1,112,53,30,56,62,218,55,9,74,182,43,254,30,188,35,43,74,112,233,17,94,249,7,
153,146,170,89,42,38,132,136,166,18,77,48,122,113,17,12,170,86,81,127,24,54,32,
219,72,247,117,10,77,65,199,86,175,67,126,31,41,61,61,126,197,119,174,42,173,
134,120,161,53,51,70,212,161,103,166,168,164,145,170,67,202,244,226,61,36,171,
106,80,90,224,234,4,3,238,239,10,182,142,209,144,61,122,76,92,129,40,7,53,233,
198,130,170,182,150,163,31,67,45,81,170,160,138,182,162,66,146,70,243,65,17,158,
25,52,35,51,134,141,146,52,224,92,88,233,184,184,247,104,161,126,42,188,122,
172,146,2,15,119,78,185,60,229,85,4,116,49,81,79,226,142,154,187,30,80,59,197,
60,82,71,45,91,25,9,6,50,200,84,185,99,164,11,254,79,187,24,141,27,176,231,229,
214,149,170,114,124,143,74,10,73,178,181,147,87,229,38,71,156,81,211,41,167,145,
99,104,226,142,12,132,210,177,157,81,180,198,236,171,96,164,242,220,19,205,253,
184,144,48,83,218,120,116,211,72,1,81,171,53,167,151,79,148,53,213,249,93,185,
20,115,43,68,212,85,45,17,105,99,88,76,209,121,53,10,120,223,198,202,242,177,
118,241,145,98,173,127,106,34,74,39,152,61,49,43,1,48,36,212,17,210,131,37,130,
171,199,237,231,195,213,100,158,5,134,191,21,224,166,9,28,145,35,152,220,50,204,
72,26,255,0,102,123,45,148,157,102,254,213,148,210,140,11,121,142,147,235,172,
186,194,102,135,253,95,234,242,232,196,116,142,214,156,87,225,40,214,8,233,169,
106,228,200,208,203,71,46,153,107,42,218,178,35,8,166,251,157,44,213,43,34,27,
128,235,120,237,245,176,30,212,91,161,12,181,224,79,14,145,220,201,218,205,92,
128,13,122,178,62,174,232,252,39,95,152,51,59,196,10,141,81,227,166,139,111,83,
172,11,19,208,205,18,215,197,83,147,169,172,168,58,1,26,7,134,52,82,21,155,145,
199,179,56,161,88,245,22,60,124,186,39,154,229,165,26,82,188,120,255,0,155,163,
73,186,251,120,102,241,181,149,20,52,152,218,40,40,241,148,52,56,90,60,115,73,
38,31,21,71,119,95,217,134,103,141,86,86,140,1,113,24,33,175,126,0,1,79,136,14,
105,233,195,135,73,4,101,106,164,154,231,160,134,175,125,166,67,54,210,207,143,
197,75,92,184,202,31,188,173,199,205,34,77,82,86,158,167,246,228,215,251,81,74,
238,65,107,3,107,31,193,247,96,235,168,211,141,61,126,222,182,99,32,113,58,79,
251,29,67,165,221,251,146,181,183,4,106,211,99,233,63,134,198,210,194,217,54,
109,113,74,18,85,73,93,245,83,146,209,89,110,44,24,139,123,240,146,102,64,43,
218,122,108,69,10,177,114,6,175,179,164,219,238,21,180,141,33,100,81,74,99,141,
106,37,120,82,56,209,100,105,38,142,118,208,203,44,104,132,45,215,65,189,207,
178,89,36,187,80,242,53,170,133,167,226,148,10,113,174,105,78,28,63,159,71,208,
218,237,210,178,34,223,187,63,244,96,44,9,197,0,26,181,113,57,199,217,211,78,11,
34,172,186,169,178,21,209,73,46,57,222,51,22,74,105,60,112,120,252,107,10,68,
135,83,0,25,125,92,105,34,255,0,159,100,115,61,218,174,164,17,161,35,7,197,6,
128,215,63,63,183,63,207,161,77,133,190,216,206,35,144,77,45,41,143,0,169,212,
15,173,15,15,49,142,60,113,211,188,203,65,61,44,194,174,190,103,142,58,101,100,
19,79,43,50,169,33,220,180,147,145,40,144,94,229,142,171,6,226,222,201,229,185,
185,52,90,234,20,20,169,254,127,48,125,60,186,22,219,237,86,46,230,85,145,146,
48,77,64,90,2,63,60,143,58,147,143,67,212,207,178,197,197,231,174,166,170,197,
84,104,134,154,85,71,202,73,32,86,103,251,123,73,78,142,36,142,107,53,197,207,
211,253,183,178,246,188,144,184,15,27,208,15,225,165,115,234,13,72,255,0,85,58,
63,27,21,167,131,226,67,115,14,163,83,241,130,192,17,192,134,20,7,237,242,56,
167,66,254,192,220,9,140,138,90,69,199,174,59,248,134,70,140,202,179,203,38,70,
25,132,232,144,201,82,137,58,73,58,43,107,110,87,232,195,146,8,246,34,218,238,
99,31,10,208,22,161,53,168,244,173,60,191,46,128,92,203,180,200,221,174,202,92,
35,50,173,2,181,56,210,160,138,255,0,135,229,209,205,219,123,138,157,177,162,
60,92,147,213,44,49,60,126,9,227,111,183,49,36,201,12,179,82,134,134,121,4,114,
70,192,171,175,26,79,30,198,246,242,44,138,17,28,149,161,25,225,79,151,200,249,
117,13,220,198,84,150,117,0,215,143,249,252,186,235,63,246,208,99,155,201,95,25,
105,24,168,138,190,179,43,40,212,240,222,214,51,67,25,93,7,72,188,118,36,253,
109,236,167,113,218,98,104,36,141,110,90,165,113,173,156,211,254,55,251,49,199,
167,237,103,111,16,16,159,239,33,115,252,191,111,65,149,70,215,203,77,4,21,80,
98,112,21,244,83,20,145,91,41,75,79,81,72,96,147,68,165,37,74,151,71,162,187,
50,146,65,12,24,131,245,62,227,59,205,185,225,146,84,50,205,161,106,117,162,
204,163,237,169,90,55,243,232,66,147,196,194,134,66,15,201,133,127,151,249,122,
68,238,206,184,195,100,100,143,236,170,160,160,172,138,42,26,218,76,37,44,144,
84,99,233,170,33,153,53,83,209,228,226,251,106,200,163,243,74,12,122,139,141,
64,6,99,245,246,91,99,184,73,21,221,46,9,150,12,247,234,49,191,17,70,173,15,15,
62,211,131,229,213,203,72,128,147,25,211,90,122,19,140,31,49,252,186,17,54,174,
99,112,71,183,177,80,101,18,49,12,128,227,225,147,33,93,134,108,166,45,104,214,
165,161,108,149,3,212,25,225,89,36,137,148,188,114,178,186,190,160,186,65,247,
39,109,215,211,75,109,18,46,241,11,130,191,136,174,165,30,90,187,84,159,74,128,
43,233,199,160,221,212,40,178,187,44,111,170,181,224,104,106,69,104,70,63,226,
186,88,201,188,242,88,204,46,69,171,168,99,181,84,180,210,76,85,141,101,13,93,
85,180,227,163,88,225,49,67,79,18,8,129,184,44,1,4,218,196,31,98,168,238,63,64,
252,36,53,50,56,54,40,14,49,76,122,158,139,141,176,146,85,210,77,87,215,136,30,
127,111,251,61,36,107,183,116,148,240,205,28,241,125,228,115,248,5,35,191,223,
36,180,113,172,130,166,88,163,171,165,122,143,218,169,100,177,89,3,122,110,191,
66,125,178,92,210,140,42,191,159,74,86,33,197,90,142,60,177,159,219,210,10,76,
237,38,71,11,143,38,134,87,52,181,57,25,99,174,146,23,74,201,36,82,179,120,100,
200,83,210,195,17,72,165,98,137,174,48,77,189,38,203,203,114,62,160,1,21,81,192,
249,211,237,243,252,250,83,10,233,36,214,140,120,143,47,217,208,105,152,72,235,
107,114,136,43,164,164,53,139,71,41,89,4,85,85,34,88,100,149,208,222,172,70,145,
204,139,58,162,149,109,95,159,175,180,242,177,96,65,106,85,126,211,210,232,72,6,
161,42,65,255,0,32,232,25,201,225,168,107,32,205,205,93,93,139,163,164,168,151,
40,178,100,101,163,14,74,199,13,43,69,28,205,21,101,20,82,58,76,218,26,71,82,
73,107,95,218,73,45,232,28,132,64,41,241,83,35,243,52,207,151,74,150,224,158,
210,13,125,58,14,242,155,78,109,185,81,73,153,122,220,62,122,26,109,183,142,49,
81,200,102,134,146,58,138,170,245,154,150,74,85,160,148,8,101,100,1,85,84,187,
126,227,234,2,196,251,38,104,210,201,227,104,161,139,65,61,197,137,30,124,106,
160,150,111,180,208,125,157,45,20,96,212,168,53,225,76,255,0,171,253,94,125,41,
171,178,84,180,185,28,78,118,37,197,174,78,158,3,21,93,13,170,228,242,75,82,222,
42,106,106,199,120,68,82,26,106,133,4,176,212,16,74,164,145,200,246,121,5,229,
148,131,197,141,151,85,51,246,31,158,7,236,233,11,193,169,104,43,90,254,93,5,
149,27,234,92,158,103,49,143,220,176,69,137,198,60,209,37,96,197,194,143,93,48,
130,87,135,30,41,94,86,72,101,175,195,100,162,120,153,236,45,78,206,154,141,128,
6,40,224,212,234,253,51,230,63,201,235,214,188,47,13,87,66,214,67,235,192,125,
163,141,58,107,206,103,246,190,211,199,238,12,127,150,166,150,90,127,21,119,130,
19,69,91,53,94,30,170,179,31,89,53,66,48,166,154,12,109,13,95,134,41,60,42,193,
73,83,114,73,211,237,233,39,134,21,209,171,200,84,12,147,243,249,14,169,28,19,
76,225,200,169,169,161,56,3,229,243,61,3,155,167,179,118,166,55,126,81,77,73,
183,40,87,246,35,200,137,16,10,226,191,107,12,241,82,205,226,134,84,47,34,187,
43,216,1,10,128,70,147,111,104,100,187,65,42,170,165,40,122,95,29,148,174,132,
188,181,20,166,63,213,249,116,199,14,253,146,186,143,116,125,157,60,17,211,85,
64,141,14,90,155,201,77,80,99,149,94,177,233,39,114,211,74,17,230,226,200,232,
74,106,7,235,237,43,92,200,225,149,5,43,138,131,254,126,148,11,84,70,93,68,212,
126,206,131,92,46,65,227,161,171,50,205,91,89,81,34,255,0,146,201,45,53,80,198,
186,85,212,203,52,158,122,216,197,64,198,165,52,178,149,85,125,65,174,69,238,45,
237,182,46,20,234,155,39,133,79,249,250,122,131,1,87,30,125,5,39,116,229,169,
114,149,146,98,93,232,190,223,32,177,181,59,72,226,81,88,213,49,34,205,33,79,27,
197,34,184,10,24,149,93,55,63,91,123,111,234,36,78,7,3,167,254,157,29,84,183,
159,75,106,45,255,0,151,56,154,200,27,13,151,202,137,178,18,137,106,49,123,150,
166,98,12,130,74,87,70,159,238,117,134,138,88,25,144,5,98,169,97,112,182,247,
101,185,145,128,44,107,211,102,214,53,63,16,7,236,232,185,231,183,175,98,208,
173,70,66,60,182,224,79,182,138,145,169,147,33,4,46,145,50,153,162,138,146,89,4,
104,243,196,98,182,150,145,153,137,212,127,39,219,94,52,162,172,167,61,44,91,
123,114,0,42,10,215,39,253,92,58,207,183,251,83,118,212,83,188,50,146,79,220,
196,133,157,33,16,66,226,21,6,170,53,145,18,54,107,241,160,58,173,174,77,207,62,
252,183,82,82,148,199,94,123,56,65,168,227,254,172,117,139,116,111,60,142,62,
143,0,148,249,154,184,106,96,201,73,145,76,154,211,44,149,37,221,12,83,211,125,
190,169,168,218,153,92,217,21,149,136,4,176,252,123,219,78,248,201,173,122,244,
118,200,73,212,160,138,82,159,234,243,232,53,196,118,206,241,219,217,90,73,40,
171,170,50,116,241,25,148,209,101,158,90,152,192,169,214,28,36,37,153,195,144,
73,5,143,248,91,143,126,142,226,69,52,13,81,233,211,178,89,196,234,117,45,15,
203,29,44,233,59,98,154,183,53,81,139,206,83,82,226,235,105,72,133,114,181,134,
86,197,76,3,68,90,7,166,129,98,146,130,162,160,250,86,77,94,37,34,246,231,219,
159,82,11,148,113,67,235,229,211,13,102,202,154,163,36,175,160,227,254,205,58,
49,20,123,173,35,128,8,4,110,255,0,96,103,141,41,106,34,171,2,73,76,80,128,245,
17,126,219,9,85,245,40,250,130,0,230,254,214,164,131,128,244,232,184,198,69,43,
194,189,43,119,134,75,110,238,189,159,139,161,221,56,104,50,162,152,248,181,100,
3,199,44,11,16,185,13,85,78,171,83,4,176,143,167,170,205,244,54,191,187,77,
165,227,64,203,142,181,9,104,229,114,184,175,64,30,123,160,246,133,125,30,18,
109,181,186,102,164,149,231,210,212,241,196,249,42,92,125,49,138,87,50,202,210,
6,169,150,98,224,42,142,3,22,23,189,175,237,3,91,33,161,70,199,70,17,222,178,
179,22,94,61,5,184,222,159,74,137,169,175,186,41,241,238,149,109,5,68,149,212,
147,67,43,198,42,76,113,76,240,57,135,237,158,41,44,174,46,67,112,226,192,251,
100,66,69,40,115,94,148,181,202,176,225,211,100,93,87,184,106,49,249,76,178,100,
240,210,197,14,91,237,29,233,243,148,177,212,201,29,88,119,162,168,106,121,158,
41,141,45,81,86,85,96,95,214,10,159,160,189,86,50,21,137,25,175,87,121,208,233,
21,32,83,164,104,216,219,155,29,21,121,204,208,212,99,41,210,180,80,172,181,78,
168,149,85,106,83,93,60,5,67,181,68,104,196,106,117,86,84,32,143,168,183,189,0,
203,170,171,67,94,182,100,70,209,70,168,167,242,235,157,94,204,167,192,228,50,
144,230,178,88,125,52,8,12,198,60,132,236,147,71,51,42,170,193,25,162,89,39,145,
65,5,129,210,69,237,245,247,82,180,45,94,61,88,75,173,87,69,120,117,214,79,16,
164,226,6,26,124,70,106,174,188,24,164,167,138,41,99,90,84,72,252,180,226,41,
106,204,75,44,179,68,150,17,125,23,250,159,122,101,194,209,134,122,180,114,252,
90,148,128,62,207,240,116,225,156,154,86,195,206,96,198,82,97,242,25,12,117,29,
44,148,234,25,103,143,200,210,45,92,245,54,75,196,100,208,84,169,30,146,9,4,
220,123,244,180,161,160,226,58,212,101,139,128,90,170,9,255,0,138,29,7,249,204,
78,66,142,174,129,43,41,226,120,169,241,180,126,31,4,162,104,164,139,212,209,
232,149,192,102,212,88,220,113,111,105,164,87,4,84,10,14,149,33,141,129,208,198,
190,117,254,125,48,152,169,154,26,186,186,224,248,245,121,13,35,201,27,35,207,
44,142,89,229,134,20,107,175,141,83,78,179,193,184,22,35,219,73,90,18,91,229,
195,167,164,210,24,5,81,138,121,255,0,171,237,233,166,124,108,108,207,28,112,
203,36,209,202,235,44,242,84,13,50,250,189,12,33,72,239,19,105,229,189,109,254,
195,222,202,240,251,122,166,188,12,227,174,41,135,168,212,23,77,50,150,46,64,44,
88,157,10,61,35,245,18,205,248,254,167,221,13,64,30,157,91,86,58,198,180,105,
24,153,229,171,167,82,1,178,90,238,91,253,72,83,98,13,255,0,195,143,122,215,
147,131,78,189,90,240,29,97,142,157,36,211,170,75,130,202,9,178,139,2,121,32,
127,66,63,62,246,41,230,122,174,125,49,214,105,104,99,70,54,55,98,234,170,138,
161,141,154,255,0,227,114,194,223,211,222,200,2,185,235,194,190,157,73,168,145,
35,240,44,49,120,23,65,245,50,139,242,20,49,54,181,197,253,212,156,154,103,171,
104,198,78,58,128,210,202,47,105,116,130,166,63,77,236,223,67,99,110,61,87,247,
170,240,235,198,148,61,97,185,58,46,79,244,23,38,220,126,45,248,246,242,112,29,
54,122,236,43,233,102,64,195,75,122,152,2,218,65,253,32,144,45,114,127,175,215,
221,181,10,210,185,235,94,89,235,160,23,250,92,233,190,163,234,107,139,253,75,
95,72,191,191,55,167,169,235,96,254,206,179,22,228,250,137,255,0,97,110,15,63,
79,199,250,222,244,185,25,235,120,244,235,165,4,172,158,144,66,178,250,185,244,
221,148,105,189,173,98,120,250,123,213,14,154,121,245,186,249,249,245,255,212,
208,186,127,220,82,120,85,117,141,71,212,146,200,61,68,127,75,17,238,196,19,229,
214,193,3,166,166,186,29,39,234,167,143,193,184,255,0,31,199,251,15,122,207,94,
175,93,167,212,31,233,255,0,20,247,174,189,229,212,187,59,193,173,85,136,179,33,
224,30,65,191,250,252,175,189,147,128,15,91,57,62,189,96,12,23,245,42,250,185,
36,93,120,11,254,183,214,254,253,214,136,242,29,66,118,35,213,123,216,147,254,
3,250,126,45,127,122,235,64,83,169,102,179,93,175,101,37,110,79,23,190,147,
110,120,62,247,231,214,184,117,150,42,166,14,174,91,86,128,74,131,200,189,173,
114,57,62,252,15,236,235,216,234,66,215,56,44,13,153,45,166,48,73,244,113,201,7,
242,214,226,254,252,115,65,92,117,173,35,167,26,106,182,141,226,150,45,112,201,
20,122,163,145,36,212,67,47,32,254,230,165,13,126,110,7,191,26,17,78,189,66,58,
201,11,234,145,164,215,44,117,58,163,150,57,220,134,141,93,14,163,168,165,244,
150,63,70,250,15,109,16,195,236,234,216,235,45,68,209,10,136,195,199,4,215,152,
201,80,30,37,149,86,71,211,101,86,0,16,167,253,127,105,232,213,98,73,7,167,0,24,
234,78,54,146,130,170,122,184,222,41,145,146,1,45,58,198,161,163,71,5,131,153,
164,186,145,31,171,139,126,120,247,86,145,212,41,39,207,173,133,4,224,99,167,
202,236,22,61,155,69,37,92,168,30,157,220,54,180,171,2,116,138,226,32,161,34,
210,178,200,164,94,231,64,227,159,107,68,177,178,128,203,229,210,122,56,36,159,
95,179,164,77,93,28,144,26,99,111,212,182,12,183,0,56,114,57,38,197,72,34,255,
0,211,222,232,41,64,113,213,181,113,39,29,115,160,201,189,55,148,74,25,213,
129,86,185,1,255,0,87,6,230,226,196,113,107,125,62,158,216,146,26,229,112,71,87,
13,230,71,79,162,178,155,33,29,34,57,9,163,88,118,10,12,164,180,140,67,29,95,
88,199,208,142,44,61,180,60,72,170,104,64,235,199,73,53,245,235,62,67,110,176,
168,132,164,146,52,98,146,9,101,169,240,190,152,32,62,130,210,52,122,174,128,
255,0,128,54,252,123,118,57,193,26,152,98,189,81,150,152,24,61,38,107,113,130,
41,101,13,83,20,234,84,148,49,70,87,244,88,43,128,86,224,55,224,253,79,228,123,
123,90,48,44,173,214,178,40,8,234,19,44,11,28,32,194,206,200,52,182,135,114,135,
212,44,117,1,166,224,31,118,175,94,36,215,142,58,231,4,74,241,31,18,184,103,152,
174,157,90,136,12,8,179,37,174,159,224,79,215,159,116,102,53,61,123,24,235,56,
199,79,117,48,190,146,35,103,104,229,144,70,88,130,117,44,72,220,191,233,252,11,
31,167,191,86,190,93,122,163,215,167,188,117,110,103,29,83,27,44,127,112,36,89,
26,208,18,28,141,4,178,169,64,44,160,27,129,107,113,199,182,154,21,144,98,160,
245,109,96,112,35,167,186,124,213,6,80,209,193,93,78,180,159,111,80,134,158,73,
175,80,201,170,241,184,105,220,44,134,6,191,49,190,168,201,224,251,114,24,194,
31,136,5,60,126,125,54,229,168,72,201,233,117,154,217,63,115,141,218,149,80,
205,78,230,176,215,80,210,248,42,85,17,7,220,157,80,134,129,85,96,80,101,7,157,
74,22,227,129,236,193,163,70,88,232,194,135,164,34,102,13,40,42,124,143,14,177,
97,54,78,123,27,45,26,212,75,83,28,241,215,44,126,47,190,139,237,38,136,200,86,
33,13,70,138,138,105,181,35,122,78,160,182,189,189,250,43,124,41,213,159,145,
235,210,220,171,3,219,130,61,13,122,153,184,105,107,226,200,39,147,17,146,169,
149,32,120,169,160,145,213,168,81,141,65,30,86,90,84,145,167,112,24,250,156,133,
22,28,123,116,161,83,196,159,240,117,85,96,192,255,0,168,244,44,108,108,125,
126,71,19,184,232,234,40,230,21,73,73,8,72,213,38,49,199,36,76,236,19,253,165,
83,85,197,189,34,220,113,237,197,7,75,99,166,37,162,180,109,92,116,52,237,77,
163,89,147,219,52,111,52,107,77,85,22,224,166,71,164,149,225,187,76,170,193,252,
168,238,178,66,37,209,173,25,128,7,233,245,35,218,129,17,49,3,231,171,135,72,
100,148,120,228,12,138,86,189,13,219,147,173,115,21,208,215,229,169,40,105,78,
46,108,230,26,138,44,173,119,130,56,241,77,11,80,173,115,189,63,145,167,98,76,
182,82,232,186,134,163,30,162,61,188,209,22,82,66,140,145,211,94,50,171,128,79,
5,56,245,232,211,245,14,43,101,108,172,133,45,102,71,24,55,38,225,92,129,163,
76,153,175,197,214,211,65,5,84,255,0,115,21,70,55,9,91,83,72,41,38,241,71,166,
73,101,140,200,168,77,136,111,106,162,68,141,134,42,245,232,190,119,146,69,52,
52,143,253,92,79,159,248,58,49,91,211,112,99,42,234,113,63,115,95,246,208,12,
85,52,117,112,25,34,157,146,97,10,207,28,148,210,82,188,194,4,241,233,141,163,
44,20,158,69,133,135,181,76,65,106,147,76,116,141,117,13,65,86,189,49,81,230,
49,84,91,54,111,182,174,162,105,37,120,170,96,134,28,132,50,87,205,2,107,245,
75,75,18,84,212,200,161,163,102,253,22,189,249,224,251,175,15,62,188,193,137,
248,115,246,99,246,244,208,55,85,20,178,86,78,176,210,164,166,138,150,154,33,
247,51,29,111,246,239,41,242,106,199,70,85,133,197,143,233,28,15,123,12,42,205,
230,122,241,87,192,165,127,213,246,245,134,139,35,30,103,17,158,109,126,170,154,
58,88,188,66,99,226,148,36,13,100,104,154,24,74,201,20,139,117,55,38,224,31,
175,180,243,105,150,51,27,198,29,15,149,127,60,253,135,165,54,166,72,36,89,35,
152,198,227,204,113,21,198,41,94,35,31,102,58,199,69,142,142,170,158,72,231,166,
168,251,111,182,105,216,120,3,75,51,71,117,116,142,57,27,203,39,144,139,93,52,
216,22,231,212,46,69,125,2,152,28,5,2,14,36,10,147,243,226,79,242,227,208,143,
110,220,140,87,49,200,238,207,113,93,32,182,144,180,224,43,69,20,227,94,227,233,
199,172,152,188,36,144,194,181,184,201,160,73,71,218,80,84,211,61,92,80,85,170,
75,20,47,106,104,100,212,211,211,219,251,113,177,85,99,164,216,143,97,255,0,24,
163,186,204,181,28,42,50,10,249,17,228,8,224,71,16,113,208,214,43,84,184,72,167,
176,185,4,215,42,88,43,171,121,141,36,84,130,114,172,49,78,157,90,152,253,149,
98,214,199,15,150,58,100,243,71,36,171,80,192,135,137,86,79,84,130,82,200,121,
228,16,120,252,123,222,184,91,79,132,160,130,15,21,243,255,0,39,237,234,207,29,
226,169,23,87,20,210,65,248,245,15,247,154,212,215,206,171,79,94,148,184,12,62,
42,174,99,27,67,134,200,40,16,51,154,234,106,106,52,215,5,76,79,78,171,10,214,
163,205,42,50,217,70,150,12,246,22,252,251,44,152,92,49,166,176,136,71,26,234,
160,243,197,43,251,58,19,237,237,182,70,145,200,80,92,74,180,236,42,177,212,249,
113,108,255,0,151,211,163,21,140,197,208,199,12,213,190,44,100,83,125,197,43,
202,149,52,192,24,12,207,44,174,232,178,57,20,241,197,29,137,186,133,212,64,42,
127,79,179,109,166,200,67,23,141,22,226,146,68,167,184,48,43,234,126,34,195,0,
121,210,149,227,209,63,54,110,166,254,229,173,46,54,9,173,111,228,66,35,113,34,
176,169,0,15,211,84,238,39,29,160,212,254,28,244,169,219,213,17,210,80,253,155,
98,234,35,125,51,201,67,52,46,255,0,112,49,203,52,106,212,206,213,112,81,25,
168,148,60,101,88,4,22,32,241,199,177,156,17,133,26,124,60,10,144,107,229,233,
92,99,133,58,129,37,144,129,241,0,248,12,15,241,14,56,201,6,181,4,125,189,9,82,
77,83,20,120,248,170,242,80,36,95,103,12,169,228,160,21,144,120,152,50,164,38,
165,106,231,128,85,23,23,42,73,96,5,236,7,183,100,170,118,179,80,82,185,26,133,
61,43,82,43,211,17,209,193,117,79,58,122,31,35,194,128,211,164,125,69,51,53,80,
146,108,122,86,71,23,219,153,170,201,144,83,60,147,213,44,169,81,77,66,88,210,
71,56,98,34,188,98,234,84,254,15,176,222,227,97,184,221,220,178,195,121,42,64,
52,144,16,83,52,161,200,53,57,227,142,140,226,158,37,128,6,3,94,120,241,251,42,
124,188,250,118,172,163,146,89,25,69,25,164,70,49,194,137,83,16,166,11,39,154,
63,38,164,242,122,34,149,150,247,28,18,111,205,175,236,134,78,94,221,88,9,39,
139,226,243,44,15,14,32,227,252,63,229,234,191,91,110,24,170,201,82,63,63,179,
252,61,39,163,161,202,205,91,71,29,14,87,47,76,205,95,92,146,81,205,12,117,88,
170,170,116,164,156,188,113,25,203,9,145,98,96,66,220,44,100,127,82,15,181,182,
27,61,213,187,90,186,237,49,72,235,154,144,14,71,169,175,31,74,240,227,213,101,
186,183,43,46,185,5,1,251,8,244,251,51,251,122,72,212,238,122,52,171,199,99,42,
232,242,52,241,72,193,234,104,107,40,171,41,230,18,68,137,246,243,8,170,22,20,
169,95,60,167,65,22,82,27,159,160,246,44,130,105,216,71,28,182,50,68,7,30,0,99,
210,135,252,131,164,254,24,58,222,57,85,137,244,62,188,115,211,22,234,150,42,
202,153,211,21,34,36,177,65,11,120,106,41,162,138,168,136,99,12,34,243,35,70,85,
204,76,196,220,106,115,97,244,246,251,184,44,116,131,64,60,250,180,106,66,141,
99,207,237,233,7,137,200,205,75,134,141,103,172,9,71,21,116,147,212,44,147,212,
68,213,41,30,182,104,125,117,154,25,65,229,180,2,192,240,120,247,229,117,163,
10,158,61,95,78,107,76,211,168,149,57,8,107,51,117,146,229,252,117,18,99,40,34,
171,146,105,32,11,26,211,199,34,213,202,149,1,36,117,138,38,120,227,98,34,62,
149,178,219,159,116,184,141,59,93,184,32,252,250,122,18,234,74,198,72,44,105,79,
203,160,234,165,177,178,80,238,170,196,53,57,42,5,202,215,196,112,244,98,174,
165,233,100,151,29,72,240,44,55,170,88,161,133,210,86,102,86,7,144,53,48,32,123,
243,90,69,112,59,145,180,47,149,72,25,249,3,254,30,175,226,186,148,4,141,116,
227,210,47,113,201,36,148,84,180,176,66,152,209,91,54,62,145,210,154,170,75,83,
37,37,44,51,8,151,85,218,77,26,13,219,139,130,127,4,251,79,115,12,2,21,140,5,3,
3,136,242,251,79,74,99,145,139,84,177,175,26,244,199,185,83,43,140,205,184,
199,86,211,172,211,226,40,234,97,21,244,198,12,109,65,168,165,165,134,162,162,
87,168,169,40,236,208,76,197,124,114,33,46,16,223,211,201,45,229,196,187,91,71,
58,219,179,51,208,80,41,98,107,242,30,64,100,245,116,210,224,213,242,15,73,42,
117,159,118,26,106,234,22,165,138,42,220,210,8,229,200,165,54,46,182,88,98,153,
234,114,116,254,73,156,44,15,49,149,171,193,1,17,153,158,48,1,30,206,97,185,184,
120,18,71,69,20,165,64,224,40,5,64,251,120,142,175,161,90,64,153,165,63,195,195,
160,34,76,142,27,59,140,220,27,149,165,170,166,171,161,168,174,198,61,45,77,84,
51,10,140,50,110,56,83,20,206,181,38,10,151,74,156,92,243,197,33,36,248,158,48,
69,130,143,126,121,195,135,101,195,112,245,199,74,163,141,144,162,84,21,57,175,
206,153,254,125,7,181,13,134,196,246,52,191,192,112,229,234,211,13,29,93,73,175,
157,99,165,144,130,33,53,56,165,170,131,76,180,242,199,53,164,95,59,1,32,54,31,
128,157,217,17,213,128,32,83,204,214,191,203,165,0,49,132,213,187,107,228,63,
195,210,78,155,116,101,106,179,121,134,104,113,138,18,130,90,199,129,42,81,168,
214,56,87,246,133,68,178,47,218,210,85,43,55,40,232,82,194,250,173,245,45,15,36,
151,90,171,65,78,30,95,103,74,76,104,177,1,158,62,153,233,151,108,238,168,100,
199,87,227,98,161,169,158,178,60,134,61,170,164,120,97,24,232,162,168,129,235,
89,210,166,23,9,12,109,32,99,24,241,105,144,242,7,181,140,192,215,91,121,112,
24,249,240,234,158,17,12,164,96,80,241,233,9,95,61,62,83,112,100,180,99,157,50,
179,100,36,129,229,25,95,220,144,186,106,95,37,43,82,70,177,65,57,42,18,66,199,
143,160,191,211,104,35,106,175,14,156,34,69,81,220,10,253,157,54,85,228,247,13,
62,34,90,19,73,143,130,24,217,117,154,47,218,144,71,78,242,29,50,213,209,202,
169,166,82,228,151,10,36,55,177,62,252,171,66,64,53,29,108,170,124,71,137,245,
233,150,183,25,46,225,199,231,105,95,43,227,143,25,69,65,82,105,34,160,154,42,
161,78,39,17,71,173,231,85,106,179,251,165,70,150,111,240,63,143,126,161,171,3,
94,175,80,165,124,201,62,189,48,203,215,237,76,179,212,83,103,30,40,99,168,88,
80,77,92,41,150,55,122,22,121,133,100,14,139,20,15,126,66,151,190,144,72,31,
211,67,212,28,116,238,178,69,13,9,232,21,171,167,171,163,144,211,75,87,50,176,
170,10,38,242,53,108,13,161,36,118,86,103,111,220,70,141,117,92,27,0,110,15,186,
18,65,233,234,6,90,233,207,236,233,227,31,69,224,20,85,31,99,8,145,213,106,34,
168,150,172,199,19,186,200,86,51,246,206,93,29,108,182,37,181,45,137,227,219,
138,64,207,77,61,73,32,183,73,60,237,80,168,170,171,146,190,141,28,137,137,150,
74,114,22,68,119,97,251,171,36,118,214,20,253,20,141,28,123,211,228,154,140,
116,234,0,20,5,110,157,54,230,247,155,106,85,71,69,25,124,134,18,166,153,146,
174,57,32,81,47,138,66,38,71,167,80,228,199,60,53,17,171,30,121,43,197,137,247,
168,228,49,181,56,175,85,150,1,50,147,193,235,254,175,219,209,146,219,123,239,
21,158,199,207,26,86,67,61,109,2,86,171,36,179,12,122,205,4,180,254,68,171,49,
206,198,7,158,23,98,143,168,134,107,94,198,247,246,190,57,67,41,53,169,29,21,75,
3,68,203,80,116,159,149,127,46,158,163,147,236,234,48,213,212,20,153,172,98,
75,73,42,25,194,185,164,152,199,28,136,106,18,39,84,16,196,224,155,95,210,167,
233,245,247,227,130,24,84,117,94,58,148,144,122,107,163,202,65,85,3,64,51,216,
169,99,167,169,146,74,217,37,200,134,169,81,11,249,228,134,109,78,75,74,17,45,
98,117,17,244,247,80,213,198,161,251,122,217,90,100,161,253,157,34,119,6,74,
139,33,90,113,244,245,212,66,40,92,214,199,224,158,40,227,90,122,10,164,10,235,
19,189,147,197,117,109,39,214,188,17,245,229,151,36,146,186,134,58,81,24,40,
165,138,154,156,117,134,171,61,140,74,154,223,178,201,80,203,145,199,211,82,67,
13,69,80,168,168,168,129,26,173,36,158,88,124,172,242,67,44,210,54,162,226,206,
110,73,247,234,173,28,3,159,159,91,208,231,69,65,210,107,142,144,153,189,211,9,
171,174,168,112,43,102,20,249,10,55,127,18,207,79,57,151,73,89,180,72,173,161,
99,102,109,42,87,131,234,60,147,237,151,144,46,162,199,165,49,66,72,80,5,7,76,
148,219,170,138,138,124,9,150,57,99,20,70,149,239,88,215,242,145,25,142,105,64,
85,178,130,9,211,127,160,227,218,37,186,171,10,140,15,207,165,173,102,2,144,
174,5,107,230,7,207,167,202,237,199,135,200,85,67,91,21,84,45,44,177,36,110,136,
200,180,194,238,228,163,163,185,119,45,123,220,91,159,111,153,144,149,34,189,36,
16,186,169,82,71,219,211,22,111,39,21,77,115,197,76,105,234,104,232,233,105,97,
81,54,147,235,72,16,200,3,106,37,23,93,237,99,244,30,253,36,203,168,129,145,
211,145,68,193,106,77,26,190,189,35,93,102,2,10,136,82,138,79,23,153,226,89,97,
134,169,85,229,211,170,80,142,204,134,75,160,179,88,21,3,218,99,43,84,80,116,
180,70,133,91,31,231,233,45,106,133,121,44,108,100,50,7,228,4,44,88,51,58,11,
149,67,207,227,233,248,246,219,55,26,147,213,150,50,64,162,128,62,125,76,130,
135,45,38,147,7,149,6,183,2,71,145,163,64,108,182,58,228,210,5,255,0,7,219,77,
34,129,144,122,217,142,156,100,74,252,186,149,22,217,172,144,189,221,11,253,
172,181,109,99,228,186,33,69,44,204,9,252,191,55,252,251,161,151,250,35,175,5,
31,198,120,121,116,210,104,124,44,162,86,22,14,1,0,170,189,174,5,180,114,218,
175,248,246,226,73,246,116,209,31,62,164,189,36,98,41,192,107,58,72,170,1,14,36,
15,114,194,201,164,22,227,242,62,158,220,45,81,147,214,184,121,117,14,106,73,
153,197,206,176,80,50,157,74,165,129,250,11,19,123,255,0,79,117,212,58,216,249,
240,235,132,184,186,184,137,13,25,140,217,78,137,1,86,179,158,56,35,155,143,246,
254,246,28,53,41,213,176,58,149,5,2,169,77,127,184,116,151,23,22,11,111,201,85,
38,235,254,191,183,22,166,162,184,233,179,79,207,169,112,21,40,241,5,66,154,
129,88,213,136,46,186,185,68,141,110,93,141,185,191,210,222,246,1,5,107,78,181,
243,243,235,148,212,145,248,37,145,19,72,141,172,87,192,21,185,39,86,171,168,
186,168,255,0,109,238,217,166,43,254,174,29,121,77,79,151,80,18,157,45,168,32,
55,55,181,203,17,115,201,85,63,94,7,187,80,113,61,91,172,235,25,6,67,226,113,
27,104,109,4,45,136,4,139,14,44,70,177,253,47,199,189,208,0,112,115,214,189,49,
215,255,213,208,162,23,253,176,24,181,238,46,160,95,72,31,209,72,28,223,147,253,
125,184,64,175,17,78,189,214,57,148,184,50,217,109,101,12,79,55,54,22,32,114,65,
176,247,82,41,81,215,135,151,80,1,5,236,160,169,45,164,16,127,73,39,234,126,163,
235,239,95,225,234,223,159,82,218,90,154,56,194,36,168,232,89,201,28,27,143,77,
244,155,159,173,191,215,30,252,87,215,173,10,245,129,170,82,96,53,174,150,55,
250,113,253,109,164,142,127,215,247,234,112,235,222,125,68,107,129,199,60,251,
215,94,235,129,23,43,248,63,208,253,62,128,219,223,186,215,89,85,135,32,243,107,
94,215,224,255,0,135,251,31,126,235,84,235,40,185,3,159,165,128,183,55,252,255,
0,188,223,223,186,223,89,227,138,89,90,192,150,58,72,177,63,81,249,227,253,
113,244,247,238,183,249,245,210,83,205,251,140,53,40,30,159,75,216,92,158,53,2,
64,177,247,234,143,207,173,241,20,61,102,99,50,233,145,174,127,112,187,18,194,
214,178,143,210,15,210,223,237,189,212,168,106,245,170,208,224,245,38,130,180,
193,56,144,179,89,81,181,1,35,168,97,170,252,255,0,85,22,191,186,24,117,12,30,
182,24,214,189,61,38,111,192,3,121,152,51,199,45,181,71,244,14,24,18,165,63,28,
240,125,215,194,60,0,235,117,7,143,82,32,169,161,168,142,133,102,168,212,218,28,
191,238,161,85,86,245,42,145,253,135,213,123,220,255,0,135,187,213,147,136,199,
84,32,55,92,165,194,68,240,79,161,159,134,5,93,244,6,44,22,250,73,7,149,63,241,
62,238,29,79,149,58,160,12,41,94,146,206,141,25,140,165,200,93,74,23,155,5,185,
245,88,92,241,254,181,189,219,6,128,103,171,10,244,175,199,231,43,104,94,150,90,
184,68,148,130,22,128,191,152,180,18,41,137,244,171,133,36,141,10,199,130,62,
159,143,109,201,106,66,85,65,161,235,218,195,30,34,163,169,242,83,97,242,129,
164,142,71,128,253,148,160,21,116,98,42,53,122,16,18,72,100,11,248,22,36,127,79,
105,14,184,13,41,85,175,94,102,44,113,199,168,248,173,169,81,42,188,175,36,114,
83,172,44,124,139,42,235,70,45,16,191,137,88,6,0,55,210,252,115,237,245,149,92,
138,26,30,170,213,92,17,214,25,40,169,232,53,106,149,155,195,80,165,148,131,96,
24,132,4,92,49,254,166,220,251,80,148,225,195,252,7,166,201,38,148,61,56,98,
164,163,53,51,65,37,66,195,13,68,50,196,210,61,59,78,247,37,138,34,186,47,146,
48,215,6,203,114,125,187,165,133,64,28,122,171,84,40,38,166,157,40,41,162,141,
161,143,36,240,172,137,143,106,221,30,54,208,62,221,160,49,211,1,9,184,120,204,
141,112,61,64,1,201,247,117,141,188,50,126,93,54,204,53,149,7,143,77,213,148,84,
84,244,244,181,210,195,70,41,106,49,233,94,173,13,101,29,83,42,181,69,69,58,
138,152,233,164,146,90,73,86,122,103,13,20,203,28,156,6,210,81,149,141,68,85,26,
158,148,234,225,141,74,130,117,87,161,71,35,72,91,105,237,106,167,160,149,232,
140,85,109,11,248,229,240,76,210,52,72,166,34,170,80,42,201,107,155,114,220,115,
244,246,164,198,166,56,195,14,222,146,43,48,146,76,231,29,44,176,184,93,235,4,
120,56,91,23,144,154,171,238,124,102,12,158,58,40,19,237,114,222,56,48,117,145,
125,220,80,45,77,37,157,38,89,0,241,180,95,86,210,218,189,238,40,116,168,84,24,
175,248,122,244,147,2,73,45,154,127,131,165,158,83,170,119,165,86,226,150,44,
150,70,151,31,141,197,154,141,117,114,120,32,166,171,72,170,32,16,154,49,66,103,
139,39,35,61,87,149,163,166,145,153,33,184,63,79,119,16,183,137,242,255,0,15,76,
155,133,9,234,221,14,93,111,181,41,113,248,221,205,30,79,41,35,44,52,242,8,158,
0,205,173,166,150,181,149,175,40,133,161,165,120,219,210,161,153,144,112,196,
90,222,214,71,29,3,84,249,244,138,105,106,234,20,103,253,142,132,141,191,77,
179,48,56,73,234,241,88,153,32,171,202,110,76,94,78,90,172,181,81,171,122,138,
90,87,161,226,31,61,71,132,164,190,166,85,211,170,252,1,193,246,250,170,42,26,
46,107,210,103,103,119,21,108,1,210,219,43,217,56,164,166,175,197,100,105,106,
37,198,86,100,49,80,19,230,154,153,194,188,247,133,60,84,147,204,147,83,177,
176,44,128,233,86,246,234,178,132,238,61,181,233,151,71,173,80,119,83,211,174,
123,115,120,9,23,41,67,20,115,227,230,17,212,152,102,41,34,81,82,180,40,208,193,
43,214,50,249,165,18,25,217,142,182,215,114,71,244,62,252,179,33,174,147,144,
58,110,72,216,83,88,237,39,168,249,94,198,204,210,229,34,104,92,82,37,61,36,
113,53,53,21,61,12,116,249,45,80,149,134,166,90,169,216,200,207,59,45,213,64,
102,60,29,62,210,79,184,195,16,6,188,63,213,229,94,149,65,99,36,213,162,212,87,
253,94,157,40,182,166,254,220,17,237,172,30,62,186,147,7,28,19,165,119,221,214,
36,48,174,93,107,241,213,181,209,83,138,90,249,164,73,169,85,23,76,140,17,73,
179,17,198,171,123,98,45,207,196,240,144,47,107,3,145,138,82,190,185,254,88,234,
242,237,190,31,136,236,212,101,34,128,156,100,14,150,21,157,147,94,226,154,23,
24,10,230,146,166,130,174,166,108,148,205,29,107,107,164,169,167,130,1,85,12,
138,222,10,166,101,45,31,141,139,50,142,71,181,66,234,161,65,117,57,174,120,143,
151,151,73,133,168,4,144,172,166,148,162,240,251,115,212,205,157,190,150,74,106,
200,114,88,138,138,111,32,85,150,174,5,188,112,44,75,62,180,142,83,42,75,226,88,
173,227,119,28,183,212,123,114,57,156,45,89,7,135,140,140,255,0,179,251,122,163,
219,169,43,225,201,89,15,145,255,0,81,29,46,49,123,150,142,170,183,205,134,143,
239,227,154,210,104,86,142,117,73,99,118,142,41,100,137,101,155,252,161,163,32,
56,64,142,108,1,191,180,215,22,214,247,136,241,131,196,122,249,249,28,80,215,
243,225,211,176,92,220,217,188,114,106,164,136,120,211,249,102,160,143,145,4,
116,239,65,151,162,151,9,51,75,138,138,1,45,117,74,60,51,210,201,4,209,58,148,
133,164,138,169,105,62,226,158,160,201,24,211,44,96,232,10,53,94,195,216,123,
247,42,64,93,225,86,102,39,129,118,34,181,244,36,138,253,160,143,80,122,18,14,
102,186,149,82,11,131,24,90,124,73,20,74,244,167,0,202,170,105,231,134,6,181,
161,21,233,97,62,3,53,37,45,101,85,30,21,114,65,167,164,142,207,85,41,145,148,
36,126,74,119,104,163,48,212,79,62,145,233,253,187,7,6,247,227,218,75,141,183,
118,68,47,109,24,103,169,52,36,128,126,93,162,153,252,190,93,27,89,243,30,206,
242,162,110,14,74,0,42,192,13,67,231,87,38,148,199,241,10,138,145,208,139,182,
240,147,207,80,239,93,182,168,49,43,72,24,66,149,180,213,19,60,205,77,50,201,
166,17,14,136,228,137,25,70,169,90,66,109,109,34,223,71,172,172,183,55,102,107,
171,120,35,81,195,181,206,175,152,238,56,251,77,43,229,210,125,207,127,216,208,
34,88,75,117,41,243,239,140,105,243,28,16,84,215,135,152,245,20,3,165,98,99,
178,148,13,13,106,84,101,161,137,164,143,90,207,28,147,81,205,40,149,230,0,138,
255,0,59,207,232,144,6,36,222,246,177,30,215,174,205,60,50,164,139,122,65,127,
192,163,182,158,148,32,138,83,143,175,69,146,243,106,95,219,60,47,100,165,227,
21,214,206,218,245,122,234,86,4,53,120,80,16,7,74,196,222,20,212,84,74,99,129,
227,175,90,70,167,171,171,251,105,50,82,201,77,53,82,84,51,85,68,211,64,33,165,
158,80,173,32,12,74,144,170,85,128,30,197,72,242,196,138,173,9,47,74,86,149,199,
249,7,81,251,193,226,72,238,100,237,38,180,173,40,127,157,78,112,122,84,255,0,
17,122,248,104,114,19,54,12,83,227,105,208,210,200,144,100,104,149,99,150,48,
53,212,65,36,213,11,11,250,142,163,34,122,90,193,69,253,181,34,180,186,106,128,
10,112,10,71,237,254,126,93,89,63,75,80,12,197,137,243,32,231,249,116,154,203,
111,33,67,52,20,244,243,211,83,199,146,121,104,162,143,197,87,95,79,104,252,19,
17,29,254,221,233,153,228,10,68,175,111,33,58,191,30,245,24,49,101,5,23,237,
255,0,33,227,254,172,117,118,93,127,22,72,234,102,75,118,164,17,164,21,185,211,
83,34,212,208,64,148,201,130,168,153,188,140,201,44,50,86,213,180,115,196,144,
38,171,59,0,92,218,201,237,90,177,96,9,53,3,200,143,245,14,147,180,71,81,34,50,
43,243,255,0,81,233,154,175,123,237,202,161,145,74,237,205,79,77,51,87,201,85,
71,72,180,114,195,24,88,161,120,103,140,85,65,24,85,84,0,249,1,69,209,193,246,
251,104,100,10,41,198,184,199,251,29,54,177,76,141,80,149,20,243,233,27,252,87,
5,5,110,34,166,44,150,86,162,10,185,99,73,154,170,90,215,138,8,35,171,131,238,
37,72,223,247,22,22,177,177,66,53,139,16,61,176,201,86,34,164,99,165,10,175,70,
170,141,95,47,229,211,44,251,170,10,156,189,118,79,29,45,36,180,20,249,85,241,
207,46,184,36,16,71,37,77,233,154,148,89,198,138,40,149,206,178,166,255,0,224,
71,180,130,17,173,156,55,19,210,154,182,132,86,25,167,250,179,246,244,221,133,
163,132,99,178,48,213,83,208,229,181,77,92,129,39,243,178,137,229,170,146,234,
233,16,116,163,103,166,116,97,173,130,232,32,169,39,219,139,27,40,33,191,213,
243,235,76,245,62,157,70,200,65,71,52,190,108,124,169,142,142,175,109,210,199,
93,71,69,47,216,213,78,77,20,144,34,170,60,177,163,84,52,42,135,85,181,61,129,
63,143,119,116,5,74,154,229,127,213,158,180,142,202,67,0,13,15,159,64,53,94,71,
39,143,160,207,98,233,147,37,13,45,90,211,214,173,108,180,153,3,81,162,58,106,
119,41,20,212,207,44,12,149,102,153,158,167,158,88,145,239,107,30,128,244,99,67,
67,251,5,63,226,250,119,88,99,29,84,84,84,83,237,39,252,30,93,51,231,30,20,201,
82,82,213,84,67,83,70,49,209,77,227,148,100,9,146,188,195,246,234,209,4,137,
101,140,70,9,210,92,232,250,143,169,246,149,237,227,93,56,4,252,253,79,74,195,
179,228,140,245,2,162,155,57,19,228,18,52,199,215,193,81,133,137,233,8,171,142,
121,40,229,165,49,83,137,97,165,171,73,37,165,141,227,136,173,208,33,55,38,246,
30,239,34,84,0,70,49,214,208,87,184,99,61,57,109,12,140,120,13,195,137,72,113,
227,13,151,131,34,149,179,229,231,202,188,245,77,85,72,240,86,208,127,15,168,
137,18,28,105,86,156,180,179,171,107,60,70,70,146,125,209,17,84,170,17,65,254,
111,242,244,225,174,150,112,42,71,69,3,184,122,154,61,171,69,190,42,104,105,229,
175,125,193,147,204,228,240,57,14,106,49,241,61,70,78,155,33,32,128,128,244,136,
178,229,234,37,178,22,5,174,197,110,7,180,146,195,225,25,78,154,138,224,158,141,
109,238,60,79,4,18,53,83,62,190,99,252,31,224,232,13,206,212,215,96,37,155,41,
80,144,86,84,255,0,5,137,5,34,59,199,19,71,44,56,196,168,168,72,245,145,247,
113,73,48,43,198,159,161,250,251,77,112,164,186,122,138,112,249,211,165,16,133,
101,111,74,255,0,159,160,107,115,110,188,185,59,153,230,167,74,73,106,105,227,
192,210,83,83,209,149,14,176,227,92,210,249,166,71,88,238,83,252,236,239,201,
252,3,249,66,241,201,168,185,52,28,58,89,26,168,211,67,95,51,251,115,210,227,99,
229,240,155,91,105,75,45,94,86,191,39,145,172,76,102,71,35,44,114,99,231,19,228,
165,198,62,56,83,52,83,100,141,89,165,166,129,202,197,120,25,99,54,55,23,183,
181,105,20,104,140,198,165,177,246,116,196,140,239,40,1,64,76,250,250,253,159,
229,232,60,169,221,243,62,238,174,200,227,117,44,19,207,77,86,244,140,169,52,
117,16,210,67,11,194,91,200,34,103,33,160,32,104,2,198,246,30,252,72,215,211,
154,8,143,63,103,82,234,183,184,20,52,243,82,227,62,219,33,35,211,206,245,242,
177,72,36,66,92,53,226,104,230,240,200,220,0,224,130,10,220,173,190,158,87,101,
1,147,7,252,253,105,163,86,37,92,85,122,10,119,38,235,151,39,81,159,68,30,122,
186,214,211,37,82,84,8,233,32,140,72,166,73,106,124,106,145,249,108,128,2,166,
220,125,9,62,244,210,150,103,0,100,244,234,66,138,35,53,192,242,245,233,135,39,
186,144,172,244,216,239,20,120,249,154,7,106,120,228,170,152,77,83,73,26,83,125,
204,235,85,161,216,203,9,114,164,133,185,60,128,125,213,164,66,41,78,222,188,
145,48,96,197,179,254,175,231,210,58,158,106,218,218,170,118,145,103,170,133,
234,193,150,8,203,0,254,171,5,146,65,168,37,193,229,172,108,61,183,150,106,210,
189,41,192,7,57,233,227,55,81,144,162,147,26,141,94,37,140,60,151,162,85,210,
209,197,28,242,132,212,202,11,24,230,79,211,201,177,191,187,119,41,90,250,244,
222,149,98,221,190,92,122,79,87,212,84,207,83,225,12,209,71,57,242,222,45,82,
145,245,0,92,40,244,144,63,219,251,187,54,1,29,89,0,29,56,79,21,5,53,28,101,97,
102,152,67,5,229,150,67,228,242,180,236,196,160,3,74,169,140,0,64,189,255,0,195,
233,237,189,107,196,140,245,189,44,73,238,199,88,169,235,26,142,167,206,135,196,
11,161,111,192,214,215,190,165,82,13,164,64,67,15,233,239,90,187,170,58,241,64,
195,75,14,133,236,102,243,158,182,186,158,24,18,162,120,162,142,122,154,154,119,
146,106,168,155,246,37,242,211,169,134,86,144,211,171,91,155,129,117,4,146,61,
191,29,204,102,64,146,19,74,244,149,237,136,66,86,154,169,211,76,184,74,140,157,
50,86,198,203,140,104,69,76,210,179,253,189,59,187,60,173,227,89,7,148,84,204,
175,19,0,172,17,128,31,215,222,229,40,23,88,106,15,180,14,173,24,201,86,161,63,
159,248,122,79,12,108,98,112,143,137,167,158,162,120,230,13,81,40,171,148,200,
117,93,164,83,19,32,19,40,28,177,7,233,200,246,133,238,86,180,0,106,233,74,70,
127,136,211,167,58,138,47,177,53,48,64,212,50,203,62,50,142,169,226,170,148,68,
171,75,72,201,36,245,48,146,241,212,26,202,134,136,171,11,22,32,157,35,233,238,
139,57,118,32,129,67,235,214,217,64,210,120,15,151,73,89,219,29,87,91,34,193,
225,87,171,139,202,105,162,158,103,72,24,249,60,237,28,242,21,107,233,69,58,88,
13,55,252,223,221,102,149,74,146,163,129,234,209,163,14,61,56,211,109,184,42,
30,140,100,216,195,20,212,159,125,4,51,202,28,180,107,78,197,146,113,13,73,168,
167,34,91,105,89,21,110,57,189,189,151,52,236,11,104,74,208,255,0,171,237,233,
240,170,5,107,147,214,44,182,14,134,88,113,13,71,246,65,205,28,166,114,175,20,
18,48,142,161,215,201,34,43,43,149,208,84,92,241,111,165,249,247,181,184,150,
172,10,80,3,246,245,226,169,252,85,63,103,73,207,225,144,26,138,191,32,241,66,
186,9,43,56,134,32,8,224,2,160,179,29,34,246,63,236,125,186,38,126,209,140,245,
74,47,30,156,232,147,111,208,194,29,211,31,85,80,230,158,71,50,84,202,210,210,
253,177,105,3,83,180,111,232,146,167,141,124,31,246,22,247,118,121,51,67,142,
181,252,143,92,39,201,225,108,254,24,16,187,207,28,210,60,34,197,73,71,242,159,
43,40,102,26,216,31,240,177,247,67,175,248,191,195,214,252,250,79,182,78,146,
38,145,2,203,40,15,35,126,244,222,88,200,104,198,148,176,85,212,202,252,255,0,
79,117,116,115,67,171,171,134,65,196,117,22,60,237,100,94,154,89,166,136,180,
82,199,33,242,182,146,36,182,162,139,97,166,225,69,249,252,123,215,128,15,197,
145,94,183,226,210,154,70,58,110,106,153,158,55,213,98,206,214,105,127,182,116,
216,240,194,196,18,71,63,215,219,226,32,60,250,108,177,207,88,3,146,254,162,204,
1,4,250,141,255,0,215,231,147,113,237,205,34,148,28,58,215,82,76,145,25,87,88,
210,166,199,85,152,144,109,192,0,115,201,247,90,48,225,213,188,248,117,233,218,
22,255,0,52,207,244,177,36,185,189,133,135,12,127,63,159,126,80,248,213,214,
177,215,24,196,192,240,92,45,184,211,115,98,71,55,1,135,183,150,180,3,170,156,
245,210,172,209,220,134,11,102,3,146,85,143,58,141,152,122,148,3,245,247,190,39,
225,255,0,87,248,58,247,153,175,83,217,170,10,3,117,55,140,31,84,178,27,134,107,
14,9,227,235,249,247,236,80,138,113,253,189,83,3,3,172,180,224,5,188,128,42,
221,141,227,44,28,31,175,234,43,164,220,95,252,71,250,222,246,24,228,19,65,213,
133,107,215,35,79,8,42,62,233,12,78,13,159,213,112,2,235,176,7,155,126,46,7,228,
159,117,212,116,210,166,189,94,135,141,58,255,214,208,121,217,133,217,64,250,15,
201,37,185,185,60,242,121,60,251,176,168,32,127,171,243,235,100,250,15,46,185,
165,71,212,105,95,87,6,214,0,142,57,91,139,134,191,189,254,125,107,174,111,76,
29,101,148,133,93,54,10,80,220,144,15,35,139,93,127,226,61,215,207,61,90,180,
225,212,66,89,147,197,164,45,131,18,127,173,205,238,46,46,57,30,237,228,122,208,
242,234,46,134,184,107,128,67,17,111,199,31,159,207,215,222,169,142,189,147,199,
172,128,41,38,252,88,94,223,65,254,183,189,113,235,120,161,234,87,218,198,81,29,
69,139,41,226,226,228,131,201,39,139,14,125,214,189,87,174,205,33,141,117,21,
91,176,184,228,17,249,252,223,235,239,213,207,94,235,0,109,39,143,199,214,195,
131,199,248,11,125,61,239,175,121,117,205,102,17,176,117,83,168,11,159,246,55,
224,253,125,234,152,167,94,235,146,212,105,73,45,24,188,151,185,213,126,63,214,
176,177,7,243,127,126,160,199,94,235,165,116,96,60,145,155,47,208,107,54,176,
254,205,173,126,79,189,245,238,165,83,154,89,93,196,160,162,50,61,201,66,196,13,
54,0,90,246,187,88,123,247,94,233,194,158,142,138,105,147,93,66,188,74,165,157,
121,87,0,33,58,80,63,246,245,91,241,239,70,184,167,30,183,94,56,235,60,216,74,
70,130,154,72,188,136,37,70,187,255,0,181,93,138,2,160,221,9,31,212,159,118,39,
134,122,215,80,163,167,171,72,220,193,87,32,97,48,136,66,124,145,249,53,41,32,
143,81,55,96,44,46,44,125,212,250,149,199,91,245,3,168,242,85,85,169,72,93,35,
212,133,65,127,12,101,193,28,221,221,20,61,197,249,31,155,123,245,22,181,3,29,
104,240,235,58,75,50,200,21,180,70,204,84,234,33,194,182,145,96,25,72,210,194,
199,242,61,186,172,117,40,174,58,108,133,227,78,178,210,202,177,78,101,42,29,
212,51,106,134,209,216,88,130,60,68,20,127,175,208,251,244,177,235,12,60,184,
255,0,135,173,169,165,15,159,75,253,187,185,86,146,18,50,46,146,83,4,98,201,28,
8,146,46,177,169,96,93,58,7,169,212,92,157,65,65,252,123,45,158,205,242,241,
212,112,233,213,148,86,142,49,210,247,13,142,219,27,171,17,94,211,84,34,87,211,
200,237,2,9,162,19,188,133,27,66,120,75,50,207,11,49,4,175,36,1,193,30,210,61,
205,196,82,42,186,214,63,90,126,222,174,34,140,130,80,231,174,182,238,211,199,
71,158,251,122,233,5,44,200,182,166,20,216,191,187,90,216,149,92,72,98,19,19,
79,12,242,198,196,29,68,58,181,136,181,174,78,172,202,78,128,137,143,14,20,200,
252,250,47,185,46,152,9,131,243,232,88,160,218,59,101,233,242,34,165,179,146,
211,211,209,42,65,18,197,142,163,17,70,170,82,21,150,84,53,2,77,32,141,7,64,60,
88,255,0,95,102,209,193,24,74,18,116,158,139,218,105,3,112,21,252,207,89,99,
218,219,10,7,130,159,21,135,163,152,154,42,73,231,131,32,104,171,30,182,170,56,
14,167,149,205,58,199,44,165,154,250,52,255,0,177,227,222,150,56,84,144,5,107,
214,154,89,200,171,49,29,8,20,57,90,58,125,189,139,154,104,234,34,45,89,87,25,
142,138,74,109,116,49,83,78,64,88,32,49,180,54,91,139,2,0,12,63,6,222,238,72,
160,35,212,244,206,146,197,233,156,117,38,139,114,21,93,181,81,73,83,152,168,
106,76,184,167,138,108,181,99,212,72,40,105,234,133,67,81,202,151,9,246,230,148,
21,241,223,74,169,183,211,221,227,56,90,250,245,231,25,108,14,30,95,228,233,
135,122,118,22,54,135,34,179,84,214,60,210,69,95,147,41,77,72,71,219,211,126,
228,32,217,20,199,73,16,152,168,44,27,149,7,232,71,187,59,34,145,147,90,158,181,
28,46,250,168,58,125,217,59,231,35,185,98,204,193,29,12,176,249,41,99,172,101,
150,127,183,73,41,145,154,56,213,170,254,217,60,9,52,102,202,22,34,73,107,243,
239,75,55,105,5,122,172,176,209,212,234,28,63,213,142,156,23,45,153,155,108,212,
156,130,193,79,81,71,142,158,122,120,96,168,50,253,188,35,39,246,244,78,179,254,
236,158,118,88,239,250,80,178,131,192,247,230,156,233,36,140,83,173,8,147,196,
10,135,4,255,0,147,167,26,157,207,147,163,142,133,166,17,87,189,126,91,7,45,93,
119,241,39,162,13,71,77,29,83,197,20,84,193,202,138,185,110,36,213,227,37,93,
116,147,110,61,164,123,164,69,83,90,154,244,255,0,210,146,196,112,160,225,254,
126,133,40,183,92,121,60,189,92,38,122,69,167,146,135,247,162,74,184,170,125,18,
151,40,236,177,17,27,202,29,7,169,137,185,28,125,44,83,155,169,100,86,240,151,4,
31,153,63,46,172,182,145,198,85,164,108,143,203,253,147,211,158,127,11,133,200,
81,81,199,73,91,67,29,76,244,145,212,141,57,16,30,25,97,133,10,200,232,178,188,
171,50,181,208,112,45,175,139,125,67,95,75,82,133,211,253,84,253,159,178,157,57,
245,37,85,130,84,252,233,65,212,40,246,147,71,180,232,168,41,243,19,53,102,43,
51,155,170,120,218,49,144,154,101,202,83,82,213,68,124,211,188,19,24,30,84,96,
8,107,130,69,239,127,119,22,210,58,199,69,211,164,158,7,62,95,229,234,162,229,
67,200,72,36,48,3,60,60,250,77,212,214,230,214,175,201,61,60,44,148,191,99,80,
134,17,36,18,44,112,65,35,84,10,138,106,137,38,142,9,204,140,129,10,202,235,99,
194,143,123,210,226,133,151,21,235,65,99,206,146,51,95,246,63,213,199,161,79,
106,238,57,105,182,237,125,109,61,61,84,51,197,68,111,6,163,69,20,130,146,58,
132,74,121,107,103,108,177,158,90,215,79,65,42,86,223,141,60,135,161,151,75,138,
18,160,127,58,116,154,72,56,41,34,167,249,87,207,203,169,52,59,234,142,58,241,
113,252,45,22,121,226,160,158,40,165,131,37,145,5,105,166,213,44,81,71,28,46,
234,21,130,168,1,88,130,71,181,102,88,159,73,36,15,67,144,124,191,111,76,248,78,
16,226,170,60,184,129,251,120,116,179,166,238,76,197,5,22,59,25,95,88,213,84,
21,53,82,8,91,45,44,80,213,37,44,245,156,248,227,118,150,164,24,98,185,189,192,
3,234,8,23,246,159,199,145,106,35,144,30,52,174,127,203,215,190,145,26,173,
225,144,126,95,47,229,208,227,132,223,184,140,185,52,116,210,101,241,249,106,
153,40,239,19,200,212,244,242,126,212,6,88,133,69,60,145,121,37,44,3,169,62,157,
63,155,223,219,240,220,74,89,86,85,64,15,152,175,72,103,183,10,165,128,37,71,
145,167,66,206,51,113,103,104,43,43,31,70,98,178,39,19,234,73,234,42,234,34,87,
49,104,70,62,50,241,134,224,157,103,242,63,199,217,191,131,25,2,181,43,246,227,
162,221,71,186,148,3,229,78,151,244,219,169,234,255,0,133,65,147,170,200,65,0,
163,157,208,188,85,21,17,9,11,69,166,193,220,132,121,88,217,152,1,199,55,246,
166,49,26,5,25,0,14,154,101,201,34,149,39,165,78,58,58,89,107,41,227,142,167,16,
42,42,42,68,72,107,234,241,141,67,228,242,171,134,145,166,158,50,171,160,139,7,
252,155,94,252,123,82,30,33,164,16,43,210,119,13,70,57,254,125,42,142,78,150,60,
196,82,196,212,205,49,172,100,155,197,37,61,32,34,23,85,152,197,51,154,138,84,
141,237,101,101,143,233,205,207,215,219,79,50,131,143,78,188,34,58,52,159,245,
127,151,168,89,172,172,149,245,148,53,50,65,139,163,240,100,224,62,105,13,45,
101,73,162,87,104,224,130,189,161,128,53,106,82,68,170,161,213,23,87,0,242,125,
164,87,26,152,180,35,237,193,255,0,37,122,115,69,40,3,30,31,49,159,151,88,242,
219,170,124,99,201,34,110,53,163,48,212,211,188,41,67,135,103,136,35,20,133,47,
0,154,8,221,230,102,22,103,184,137,135,183,196,244,4,134,160,175,77,180,10,
120,166,172,121,156,244,26,239,13,199,138,168,154,85,204,238,122,28,97,147,25,
93,11,35,97,98,142,74,137,235,153,37,150,70,139,29,76,173,36,204,170,15,50,199,
127,171,18,47,237,215,145,106,85,166,85,3,228,43,254,175,207,175,67,27,105,6,56,
139,26,250,250,125,191,230,232,42,173,203,81,215,99,74,226,247,77,53,84,244,133,
98,164,166,147,25,36,245,85,81,152,131,53,50,121,252,148,244,79,49,210,35,45,
117,181,192,111,108,130,164,26,75,81,246,113,233,88,71,86,80,209,81,79,157,120,
126,206,146,248,218,232,86,174,157,178,191,119,143,169,203,80,100,50,117,21,81,
211,80,209,75,87,36,104,244,73,77,28,174,146,26,122,97,80,229,165,146,69,177,
244,133,0,17,116,242,74,145,130,78,73,255,0,87,30,156,96,115,167,32,26,83,142,
63,213,233,211,133,46,227,196,81,83,77,67,140,205,213,52,244,207,144,167,153,
165,170,18,203,79,145,199,36,109,36,66,158,142,24,160,200,180,144,203,25,11,44,
154,137,33,65,22,183,180,207,184,34,233,1,115,79,95,246,51,214,210,222,71,171,
50,80,86,191,234,244,233,138,61,202,217,26,128,198,190,8,170,177,212,180,79,4,
191,197,227,137,103,165,131,66,168,116,211,81,21,38,82,166,72,222,40,233,153,
216,93,78,167,0,143,109,157,193,10,84,173,8,249,255,0,177,199,203,165,11,110,
234,40,16,149,62,68,87,252,216,249,142,145,25,20,197,213,201,156,53,25,236,133,
41,72,177,21,13,141,166,165,200,154,154,104,234,164,120,228,137,210,61,120,153,
42,188,147,18,66,78,22,205,254,55,247,95,174,143,33,88,158,29,88,199,32,167,
232,119,84,138,146,7,15,231,252,186,97,202,100,48,2,150,60,148,185,188,228,18,
194,213,116,99,10,50,145,208,215,253,185,175,147,199,144,19,154,202,200,158,5,
58,27,67,52,58,84,112,91,144,54,215,200,186,1,67,67,243,233,229,129,245,21,42,
56,12,210,163,236,242,232,43,203,238,214,150,153,107,147,53,144,167,163,155,27,
155,161,124,133,68,210,228,168,165,166,199,170,58,184,168,160,158,181,52,204,
245,101,99,46,83,83,130,45,110,75,173,117,19,42,154,102,159,224,233,197,130,140,
202,63,204,115,242,52,233,143,106,110,227,75,36,25,170,138,163,95,67,74,233,89,
27,209,100,53,9,94,164,64,150,141,96,142,70,13,15,133,90,72,193,227,253,113,
238,130,85,108,171,240,253,189,56,83,77,87,73,175,67,6,59,177,49,25,180,206,82,
231,176,117,146,224,50,181,153,90,202,74,100,158,105,163,72,60,177,180,88,242,
181,137,19,209,100,42,170,47,160,43,27,107,87,95,233,237,65,37,170,165,43,25,
207,230,60,186,100,0,164,48,106,72,49,251,127,201,209,119,236,157,173,181,55,
150,236,197,97,246,190,63,50,210,87,208,86,99,40,20,212,195,73,79,228,72,169,43,
233,160,135,34,213,180,201,82,97,166,167,8,254,81,25,50,41,6,197,133,152,150,36,
50,37,20,210,152,233,100,23,14,145,181,88,84,28,255,0,62,139,134,245,235,131,
89,14,244,170,200,85,214,193,73,131,155,27,91,6,38,58,243,61,124,149,50,227,33,
167,86,174,13,72,30,42,90,233,162,186,136,221,150,209,53,236,126,172,73,109,153,
106,77,7,207,63,224,243,233,84,87,154,124,42,40,169,243,166,63,44,249,14,130,4,
194,98,112,88,28,70,94,58,218,186,202,172,130,84,68,49,106,145,209,201,143,164,
160,116,130,10,234,250,153,105,103,134,103,150,85,54,128,42,48,81,169,88,175,
171,221,12,72,34,86,169,169,28,61,41,231,195,249,116,163,198,145,228,117,160,0,
125,166,191,96,175,243,232,31,131,49,148,133,99,170,133,229,142,124,113,120,162,
45,8,43,12,173,59,186,150,141,195,187,137,99,153,133,154,203,97,254,30,209,102,
133,188,199,75,232,24,233,174,14,126,209,76,245,33,107,228,175,85,122,249,234,
106,212,42,188,180,204,254,10,102,49,202,174,99,17,64,128,133,184,54,4,250,191,
36,123,178,141,66,164,245,166,80,180,160,233,79,22,54,139,55,83,52,49,83,87,
209,227,165,142,79,36,20,130,4,148,213,68,76,144,77,118,68,71,166,78,11,70,215,
123,92,41,4,130,54,35,5,136,0,208,158,147,146,200,160,146,42,63,213,251,122,105,
24,232,205,100,176,44,84,47,40,150,20,54,141,32,129,89,34,17,72,111,80,7,135,
84,134,196,177,176,55,231,221,116,247,16,7,242,233,208,212,80,115,242,207,73,
42,246,168,253,178,145,73,7,219,207,44,126,100,242,70,172,207,102,210,174,160,
71,112,164,17,111,168,62,232,213,4,116,242,211,215,39,231,212,117,138,89,36,
136,207,49,49,188,72,12,242,163,180,177,42,51,126,218,128,109,25,86,107,94,228,
19,239,106,213,60,105,215,152,208,86,157,40,43,113,244,240,85,81,26,9,218,160,
10,85,171,209,51,136,216,71,18,254,236,13,40,176,77,69,90,199,128,109,253,79,
47,182,149,28,123,105,211,106,89,129,212,40,120,117,27,112,100,240,245,181,80,
61,45,59,82,210,36,116,174,228,7,53,15,49,129,124,140,232,255,0,64,36,54,80,64,
227,147,245,246,129,69,94,188,71,203,252,157,58,20,175,73,10,133,53,150,49,180,
151,109,65,129,91,11,179,19,206,158,116,243,254,31,237,189,213,216,173,75,55,
159,78,40,232,71,194,152,169,210,26,122,120,190,209,77,29,66,79,81,19,159,185,
155,84,90,100,243,204,52,48,66,56,8,182,93,60,115,245,246,147,234,8,168,142,164,
158,182,217,234,93,110,114,143,28,151,170,169,142,98,136,171,28,16,132,119,176,
11,227,10,170,108,163,74,254,77,191,167,187,136,166,145,73,118,199,73,244,130,
195,72,61,34,171,183,75,84,70,145,70,181,15,105,38,101,245,34,105,14,224,174,
157,2,235,193,183,215,253,123,251,184,129,20,12,244,248,4,125,157,70,92,205,100,
249,42,108,131,32,106,186,90,84,142,55,157,188,169,100,98,64,146,38,82,29,13,
236,87,143,235,239,104,17,13,20,121,245,179,82,41,242,233,162,174,74,166,146,
110,97,69,149,167,145,146,56,213,20,60,173,169,202,253,89,67,126,7,211,221,219,
73,53,174,122,242,18,5,58,201,247,117,192,172,145,213,205,28,166,4,137,221,72,
44,98,17,248,196,101,143,213,2,113,205,248,246,211,44,122,64,240,199,243,233,
193,81,154,245,143,238,50,40,35,9,83,43,93,13,151,252,231,23,184,80,108,199,65,
39,233,244,247,66,34,63,232,99,175,6,97,231,215,58,108,126,78,173,106,36,101,
157,148,58,121,11,199,125,77,125,55,209,117,46,84,127,79,199,189,106,132,17,69,
29,107,187,172,81,209,167,158,85,86,112,200,146,170,248,212,169,149,213,26,240,
172,99,86,175,39,211,139,219,159,126,14,40,48,58,247,88,100,198,248,226,71,62,
80,210,38,177,27,71,162,209,19,101,112,73,58,145,143,0,241,244,247,125,121,194,
227,173,30,162,37,42,190,181,51,71,27,34,150,34,93,64,146,45,169,120,12,56,28,
223,221,72,60,116,159,203,175,117,202,58,122,104,164,111,43,26,128,209,75,160,
83,150,5,100,176,17,179,106,81,232,45,248,183,62,245,222,64,1,105,246,245,225,
65,199,168,142,173,162,241,197,41,94,53,23,86,210,28,40,215,250,7,210,224,218,
231,233,238,224,26,241,235,212,249,117,227,79,86,236,159,183,38,183,85,117,11,
11,221,215,147,169,84,40,212,61,39,233,254,62,236,5,48,58,213,51,158,179,125,
157,74,51,234,138,94,8,109,77,25,91,41,211,98,67,0,66,223,222,232,78,105,142,
181,138,241,235,42,83,144,101,18,20,82,186,91,233,113,169,216,126,217,181,130,0,
13,255,0,62,236,5,106,9,165,58,177,61,115,212,138,45,165,4,136,197,129,62,160,
71,36,166,144,125,74,63,215,7,143,167,189,112,235,121,0,227,172,77,94,138,186,
7,140,182,173,90,149,5,201,42,6,150,54,111,212,127,195,222,250,245,60,186,194,
213,18,105,8,87,141,8,166,255,0,133,4,48,250,127,136,181,253,248,84,214,156,122,
174,43,90,14,185,75,83,40,91,107,68,245,112,87,146,77,173,171,146,88,88,127,135,
189,132,45,159,46,183,81,196,117,28,207,125,39,204,197,149,89,117,106,189,129,
91,112,117,88,95,233,245,247,109,2,164,87,20,235,213,251,122,255,215,208,126,
215,214,191,83,114,13,214,237,114,79,246,173,101,246,227,86,163,31,179,173,141,
52,199,80,228,253,178,72,185,7,253,99,207,248,255,0,75,31,116,225,215,186,147,
28,206,208,254,174,20,139,143,235,197,185,255,0,91,222,168,43,81,199,173,129,
212,86,98,220,255,0,83,99,205,248,250,113,244,247,106,142,29,120,138,117,231,
224,2,63,222,63,195,252,127,175,189,103,61,107,172,145,135,145,244,174,145,168,
1,201,176,102,255,0,131,31,161,62,252,122,209,29,74,154,41,140,113,61,163,10,
110,171,160,128,127,175,32,19,205,253,248,245,161,246,245,17,33,154,73,2,22,44,
57,189,152,241,254,28,241,245,247,82,64,201,235,116,174,58,150,40,228,86,85,
177,210,223,155,143,168,23,63,224,15,186,7,168,62,189,110,157,61,227,112,47,87,
52,136,210,5,68,133,166,46,209,59,71,161,81,137,39,128,45,168,90,255,0,215,219,
15,113,64,8,25,175,78,44,100,241,62,93,75,27,110,158,74,57,229,167,158,86,158,
41,68,101,157,45,7,0,234,84,35,234,220,95,252,7,245,247,161,117,70,1,151,173,
248,38,132,171,87,166,52,195,214,172,214,146,41,60,119,91,74,5,213,181,16,20,
197,126,100,60,253,7,54,246,164,72,140,42,15,77,16,71,17,215,13,18,36,179,211,
44,47,36,154,218,4,178,139,249,109,123,27,155,6,0,123,112,80,249,231,170,147,
76,158,29,100,52,21,138,208,248,148,72,210,66,238,35,137,147,200,2,19,168,50,
234,46,178,32,224,223,158,61,232,144,60,250,245,65,235,52,21,213,65,161,67,47,
162,52,117,241,50,0,233,160,59,88,51,5,185,214,196,115,115,205,189,220,51,96,14,
181,69,21,199,89,169,178,142,229,144,162,199,16,168,142,166,236,162,73,132,208,
43,95,68,160,6,187,160,32,14,20,31,122,61,217,167,86,31,111,78,147,189,53,114,
121,180,198,143,27,152,140,115,180,107,35,137,73,146,47,90,217,137,0,144,73,183,
215,222,130,18,42,7,90,52,173,15,83,211,9,75,53,93,60,49,73,58,107,137,117,21,
103,117,138,102,140,57,84,86,185,225,77,136,39,159,123,5,129,3,211,175,21,4,99,
174,73,183,32,154,10,207,181,171,153,234,105,225,188,200,234,172,88,249,63,221,
49,141,44,75,1,244,185,183,183,3,161,168,98,65,167,229,211,46,24,21,160,5,107,
214,8,113,222,36,117,240,139,36,42,242,3,82,25,117,43,105,113,160,170,134,50,
235,22,0,240,127,63,143,111,133,71,4,3,229,235,211,101,216,80,158,21,244,255,0,
47,94,195,205,5,18,154,250,84,154,147,33,79,42,154,105,99,72,230,245,7,1,132,
129,148,16,171,115,96,53,15,234,61,164,150,209,101,66,40,126,207,94,157,241,25,
24,84,227,246,83,161,75,105,231,232,242,147,211,98,247,50,253,223,154,121,203,
84,172,172,143,28,198,23,88,42,86,116,100,150,9,160,153,129,86,28,134,252,219,
210,75,29,37,181,103,104,112,195,203,200,244,245,86,69,200,237,232,71,198,227,
181,69,153,138,41,103,106,120,177,215,142,177,103,154,41,209,214,62,11,194,38,
140,187,134,66,75,5,208,65,22,3,233,237,109,166,230,173,69,144,21,198,115,143,
248,174,144,220,219,50,29,81,141,64,30,157,94,130,42,26,186,88,169,242,126,68,
48,83,217,227,169,213,31,144,80,194,206,35,77,2,69,58,223,155,146,56,63,235,
251,60,33,104,10,189,70,58,47,44,236,8,100,161,234,29,86,123,23,130,193,82,45,
68,242,84,77,5,101,73,72,35,149,86,198,98,146,77,35,235,212,158,59,143,200,189,
255,0,199,222,153,128,92,250,245,229,141,221,141,60,199,65,182,71,177,170,42,
224,142,154,145,37,138,142,158,176,213,65,20,78,254,111,52,171,225,122,134,157,
215,146,177,157,32,104,183,39,143,207,182,140,224,2,60,186,84,45,130,252,95,21,
58,104,170,143,57,89,85,20,140,23,252,182,161,234,131,200,162,89,141,43,72,143,
45,76,174,255,0,71,46,0,5,253,92,88,123,163,25,24,227,171,168,90,28,100,14,135,
109,131,5,20,89,44,159,241,92,174,94,73,224,143,30,41,35,254,33,230,62,114,4,
160,79,60,133,97,161,165,88,153,172,25,150,252,11,112,61,235,196,208,132,150,58,
191,111,76,21,241,8,1,7,159,203,254,47,161,246,133,86,167,248,180,75,26,182,188,
108,83,173,67,75,77,89,78,180,210,57,48,69,37,66,160,2,22,145,152,45,218,202,88,
218,255,0,79,105,252,103,144,53,51,142,172,97,68,211,154,10,215,166,141,207,179,
222,158,131,105,138,138,154,70,169,124,187,180,212,226,7,75,67,175,77,20,201,33,
82,233,25,74,134,4,72,9,54,22,63,95,123,32,105,82,202,43,83,78,188,174,67,48,
70,106,83,168,209,225,77,21,101,76,152,74,154,101,45,32,53,143,83,60,70,33,21,
61,101,68,127,105,75,20,137,4,241,185,18,3,195,58,179,112,163,219,30,58,168,33,
107,79,145,233,241,27,181,53,128,127,47,248,190,157,229,200,100,165,169,198,210,
200,180,83,78,212,116,241,52,38,88,42,100,136,15,51,175,153,144,71,45,58,170,
160,97,114,223,166,222,222,23,20,42,24,22,244,243,167,77,24,7,118,147,79,179,
165,54,15,112,111,1,137,148,201,11,213,197,28,245,2,165,234,170,35,134,109,84,
208,44,43,47,134,106,69,169,169,165,150,54,82,17,74,178,144,46,73,246,162,41,
245,169,40,195,236,174,122,75,53,184,67,149,57,24,32,26,127,135,164,247,247,176,
87,164,147,67,137,174,72,94,86,165,106,95,21,76,191,112,205,19,206,43,38,96,92,
152,63,110,218,138,241,126,127,62,221,12,127,135,173,120,84,3,188,87,165,190,
211,167,174,172,138,174,166,121,33,130,135,199,42,25,168,12,208,196,146,65,142,
158,103,130,118,118,67,40,8,224,19,165,67,16,192,126,61,232,47,121,192,167,84,
145,197,2,138,215,231,158,149,24,168,100,135,7,75,61,125,116,181,117,176,85,212,
31,178,142,161,106,106,209,206,62,212,113,211,228,170,133,66,81,82,120,213,153,
238,167,88,1,110,63,30,208,2,118,224,215,215,229,252,135,77,52,140,95,181,70,
156,121,98,149,244,20,175,77,82,213,98,208,82,207,70,117,63,142,26,170,199,174,
165,63,126,37,172,189,53,42,197,81,45,100,208,193,20,243,200,177,178,170,146,
209,216,139,6,62,211,0,136,228,168,53,251,115,210,141,82,21,58,151,7,24,225,254,
160,58,95,77,87,4,53,21,248,138,140,188,30,117,170,199,83,211,80,197,148,74,70,
171,173,154,40,165,84,117,17,177,142,106,91,63,46,117,221,133,155,77,189,248,
208,158,53,52,233,176,48,36,68,199,173,63,213,142,165,97,247,246,233,218,145,61,
68,57,26,207,182,168,159,33,73,75,73,93,82,243,88,171,42,70,213,180,204,204,
211,200,136,246,5,74,169,189,255,0,55,15,67,60,176,17,166,102,211,232,114,58,
105,237,162,158,186,162,82,107,196,10,127,155,163,67,181,187,37,50,248,204,70,
70,114,216,234,232,86,150,130,182,41,90,10,216,30,105,150,73,196,148,209,169,
105,161,130,72,169,131,21,126,80,182,157,70,215,246,127,111,117,227,173,41,220,
6,125,62,222,61,18,92,91,120,47,164,26,169,225,254,175,243,116,50,225,247,62,
59,35,67,83,13,58,81,215,215,78,96,54,155,24,150,84,105,212,18,100,251,141,49,
161,96,47,168,131,207,224,113,237,77,77,126,28,116,136,161,3,39,165,244,83,205,
162,173,229,198,225,105,227,167,105,21,94,166,174,56,227,181,130,160,134,26,99,
89,59,50,144,77,199,0,113,127,122,251,122,241,166,0,98,79,72,220,174,73,40,230,
174,168,122,22,20,240,120,100,119,161,170,169,132,198,137,47,149,164,141,39,149,
102,40,222,27,176,101,91,126,63,30,219,56,21,175,87,94,236,87,246,211,164,134,
79,113,100,230,142,122,227,12,245,134,103,199,196,163,197,87,44,144,184,172,
142,88,230,67,45,68,48,249,25,99,211,98,89,8,98,45,249,247,65,66,53,13,89,61,59,
161,67,1,142,130,77,235,184,190,238,58,138,129,133,20,213,82,203,90,203,83,147,
90,21,130,254,50,228,76,20,59,164,107,162,204,4,151,80,0,6,255,0,93,25,9,212,4,
125,223,58,113,233,216,226,161,74,62,49,129,199,253,95,151,72,172,62,227,150,58,
72,37,48,201,170,154,57,170,178,154,163,120,161,168,168,130,149,30,150,10,25,
102,104,226,48,71,164,148,101,91,27,113,234,36,251,78,110,2,140,158,239,240,240,
253,157,42,240,14,165,31,60,121,158,128,41,187,90,71,57,234,13,195,89,85,85,13,
29,94,50,170,42,122,100,200,81,46,66,159,41,81,71,81,86,101,155,89,134,4,132,
173,150,61,108,12,144,134,98,64,4,22,75,43,112,166,58,91,244,163,5,48,63,47,245,
127,155,229,212,188,127,116,109,124,125,30,75,31,144,135,40,5,66,100,169,177,
234,107,223,45,150,171,50,45,84,18,213,212,84,249,22,167,34,98,150,56,100,46,
200,4,146,14,27,211,203,0,187,168,175,207,203,253,89,235,205,108,193,153,151,
143,26,244,174,192,119,150,208,163,10,245,48,196,212,213,82,208,67,20,179,99,10,
203,65,38,58,162,24,228,92,162,53,65,151,203,55,152,179,200,241,31,160,43,169,
69,253,211,208,208,99,252,253,120,218,204,213,227,249,31,42,116,171,170,223,
213,121,92,141,109,101,29,86,34,144,86,197,5,108,102,31,184,163,129,232,151,33,
21,92,113,206,180,149,81,70,244,239,74,198,234,84,88,54,171,1,238,225,136,44,
192,103,207,253,92,58,74,96,42,168,140,172,64,62,125,36,178,212,59,139,38,162,
187,248,134,47,21,3,209,196,106,26,57,206,74,174,100,145,228,154,25,200,69,104,
210,145,165,133,10,7,100,213,164,27,31,126,185,98,170,142,20,146,60,135,207,237,
233,108,33,75,104,53,251,79,65,101,53,30,33,107,230,166,151,38,185,9,218,162,
178,135,33,68,208,210,211,73,81,62,66,24,106,127,106,105,140,84,240,153,17,3,52,
68,155,183,1,137,54,30,130,125,104,3,174,151,6,148,251,125,58,83,36,14,135,82,
10,165,43,254,175,245,99,160,131,41,30,23,31,133,175,198,249,227,138,106,132,
146,153,98,166,168,116,170,163,97,36,210,72,32,131,31,168,171,41,145,22,53,42,
35,86,82,24,253,15,191,77,35,45,2,138,177,235,112,130,204,9,29,191,225,235,158,
196,236,152,229,143,33,129,159,37,75,61,20,95,195,225,135,45,146,53,71,70,102,
58,121,229,174,143,28,16,7,51,99,216,34,84,74,75,198,121,10,52,168,37,200,238,
102,241,52,51,29,35,253,67,246,117,233,173,80,170,176,78,239,151,250,191,103,74,
92,134,229,170,164,48,209,230,40,177,208,52,181,147,100,41,24,66,143,74,181,
175,66,177,172,212,101,228,251,63,183,203,71,78,205,42,139,51,187,35,11,145,237,
97,187,147,82,234,3,246,116,153,109,163,42,204,164,145,252,233,243,251,58,101,
202,102,233,51,152,172,244,177,208,77,69,73,86,216,74,41,4,222,97,90,242,199,61,
56,169,105,41,163,74,154,196,133,53,177,179,0,138,202,108,120,247,233,46,31,
190,135,143,78,36,1,89,1,227,159,242,249,244,149,56,45,155,145,218,135,36,152,
26,57,106,154,138,181,17,205,67,38,149,21,162,158,142,89,34,42,212,190,101,137,
213,25,196,104,204,56,39,218,79,171,6,54,212,166,131,231,210,161,12,138,234,4,
131,203,252,25,207,64,109,70,205,243,84,85,77,75,53,60,84,205,91,20,181,24,250,
148,117,146,100,135,84,81,133,158,4,116,143,67,49,177,183,246,190,150,246,207,
212,173,105,234,58,82,20,240,166,124,168,127,201,212,186,29,163,130,100,106,186,
129,87,5,44,18,228,40,234,26,153,104,114,36,179,65,45,89,152,40,146,158,173,22,
43,105,86,8,80,1,98,121,183,181,9,34,176,173,5,51,211,110,92,96,28,227,143,250,
169,211,5,78,63,23,71,79,156,251,77,197,133,169,69,170,168,171,129,178,52,21,20,
217,153,167,90,42,122,106,26,113,47,221,164,102,9,75,146,209,168,186,152,239,
192,62,253,172,13,120,235,106,25,244,18,164,99,215,31,63,207,160,107,33,75,184,
49,245,44,179,153,93,166,167,140,137,162,89,4,79,12,145,181,156,49,1,93,29,84,
159,233,254,199,219,29,224,159,94,150,41,70,90,14,31,62,152,231,147,50,248,212,
87,170,121,104,34,152,212,45,41,169,186,65,35,145,8,159,237,181,94,57,36,9,107,
129,114,7,244,247,163,168,138,147,143,183,171,13,1,254,30,243,231,79,242,245,17,
163,175,134,104,161,49,212,43,55,138,53,215,112,53,181,218,49,173,142,145,113,
244,228,123,108,176,30,89,234,224,14,156,42,40,178,210,193,13,71,219,200,209,21,
120,11,180,202,250,154,38,26,128,230,246,82,194,214,227,221,90,68,160,13,214,
244,241,167,92,218,141,164,90,122,99,79,44,85,51,24,84,188,192,105,150,70,80,66,
153,133,214,36,177,191,248,251,112,186,20,10,139,158,24,234,148,101,108,240,233,
65,30,30,92,116,14,52,71,60,108,72,146,104,215,85,221,64,184,242,155,254,218,
218,214,227,250,159,104,231,71,109,42,58,208,117,32,154,211,61,48,85,231,214,
141,76,48,135,148,248,100,84,107,120,194,180,151,4,53,199,168,47,227,241,237,
212,133,97,21,43,220,122,182,95,236,175,72,214,146,162,174,86,153,216,18,246,4,
155,143,74,253,2,0,44,21,64,247,179,33,81,213,192,30,124,122,113,130,158,235,
112,215,58,194,31,73,181,136,227,155,139,91,253,227,219,12,196,228,245,110,60,
79,79,116,84,119,152,174,150,145,132,64,217,110,0,187,128,120,191,32,223,221,
75,99,229,215,177,215,51,69,174,105,145,98,140,217,92,11,158,20,130,214,177,38,
197,174,191,236,61,212,189,6,73,235,96,14,156,142,54,40,213,29,213,76,102,16,
125,10,161,206,152,238,246,44,8,32,55,23,30,217,13,83,131,94,156,165,7,1,215,9,
229,164,90,10,120,214,9,60,166,53,208,81,129,96,128,216,95,73,7,65,32,222,220,
251,216,66,91,173,106,20,35,207,166,248,178,112,210,71,82,1,99,57,125,10,238,92,
131,172,242,52,220,184,84,81,97,200,231,219,162,35,81,140,117,93,93,53,54,65,30,
167,203,229,88,90,32,25,30,159,201,27,41,23,26,227,26,142,153,20,126,69,174,125,
184,18,156,7,85,38,188,122,193,45,92,14,75,74,242,84,122,12,107,121,36,47,166,
247,81,172,243,199,215,147,111,110,31,151,90,11,130,75,103,166,211,60,103,80,
181,136,4,45,236,56,176,225,244,128,88,143,241,250,251,223,14,29,106,149,29,99,
73,144,27,50,181,244,183,173,100,28,88,112,182,63,81,199,248,123,215,30,183,
214,100,175,88,98,2,39,153,28,150,7,85,138,149,113,98,182,7,233,111,240,247,234,
84,103,135,94,28,122,122,76,243,188,216,249,42,4,146,37,52,17,193,170,9,30,41,
99,68,119,111,242,118,86,43,19,218,66,56,176,255,0,1,238,218,73,2,157,123,231,
229,215,10,188,251,78,42,207,134,48,36,43,20,105,102,12,144,35,177,140,52,163,
151,96,5,141,238,79,191,0,235,81,228,71,86,162,211,142,122,97,146,178,121,245,9,
52,105,178,130,22,36,75,178,216,43,27,32,245,0,62,191,82,61,236,208,140,241,
234,163,172,77,117,145,133,148,216,147,117,82,0,12,57,181,205,254,163,253,227,
221,180,103,206,157,108,177,34,157,70,107,180,135,212,64,212,121,80,1,22,252,
254,63,3,252,61,218,128,2,49,213,73,60,122,198,87,80,229,216,241,126,73,107,255,
0,65,254,4,123,221,71,94,242,235,183,72,192,186,171,88,30,73,35,144,87,240,15,
248,143,122,7,236,235,221,113,15,251,108,159,237,63,78,45,171,82,139,253,47,244,
247,234,26,214,189,123,211,175,255,208,208,120,19,119,184,91,144,63,214,91,112,
79,7,134,227,219,197,129,1,136,199,90,206,61,58,139,39,168,155,216,220,125,126,
167,253,231,222,158,134,180,165,58,176,225,215,10,114,7,7,149,39,145,248,54,228,
223,219,95,103,91,29,100,168,80,46,87,233,201,6,223,237,173,254,181,253,248,86,
153,235,199,174,112,199,229,66,183,252,106,95,245,255,0,167,248,125,61,248,154,
14,181,196,117,201,1,140,50,216,240,214,211,126,1,4,240,71,36,241,239,223,230,
234,167,237,235,40,12,81,130,242,197,193,85,28,181,200,22,55,252,1,239,85,235,
217,168,234,116,113,136,225,12,215,46,175,105,28,45,189,86,54,85,252,155,128,
121,250,95,219,77,82,212,29,88,83,143,92,205,65,81,162,52,43,97,169,204,198,215,
184,22,88,255,0,178,57,250,159,123,9,140,245,234,215,172,233,150,85,134,104,201,
148,222,21,95,75,176,80,255,0,86,109,32,17,160,95,129,254,62,233,225,41,32,176,
53,235,101,200,199,151,92,169,50,42,144,72,162,121,66,249,129,17,58,134,69,102,
87,5,239,123,2,215,183,186,201,14,67,14,172,31,203,174,215,35,87,104,213,106,
148,42,191,5,189,126,59,5,250,6,5,163,38,214,176,227,221,124,48,181,36,26,245,
224,196,227,136,235,56,158,166,105,234,100,214,98,118,180,126,72,244,174,176,99,
30,166,98,109,171,72,0,220,92,95,221,131,178,132,166,126,222,155,96,13,107,214,
119,197,84,195,74,178,67,80,84,74,17,222,243,128,210,51,166,162,125,38,230,255,
0,66,53,115,239,98,85,38,154,77,122,208,0,116,210,232,234,212,225,224,241,201,
0,189,212,104,62,54,250,47,167,137,26,228,27,253,108,125,189,172,121,117,106,
30,161,70,240,7,116,154,57,24,106,38,200,80,17,169,141,193,12,62,159,235,31,
110,35,130,50,56,245,70,7,136,227,210,158,77,186,100,197,77,147,138,41,81,65,
141,99,54,44,89,226,125,50,197,227,143,83,172,174,142,165,110,7,231,218,211,10,
24,188,68,112,1,24,252,186,77,227,55,137,225,158,164,46,7,43,75,95,68,28,214,
64,245,17,164,203,28,70,65,80,151,87,26,78,160,165,100,0,31,245,189,183,36,97,
101,80,88,80,128,120,245,101,148,148,44,163,129,235,45,1,170,73,171,41,138,213,
202,237,27,44,133,228,48,203,30,153,2,201,234,186,125,86,247,185,7,218,118,143,
81,33,72,254,93,60,94,128,22,29,103,160,138,172,65,32,73,13,59,152,214,4,117,
118,63,170,84,210,172,164,149,144,53,191,161,183,23,246,223,234,169,168,235,125,
140,185,225,212,220,94,26,121,82,172,68,108,177,84,248,206,167,87,117,115,207,
141,88,253,125,98,252,5,31,227,237,212,150,64,64,31,234,255,0,55,85,120,208,141,
94,157,96,130,147,35,77,91,5,76,97,197,170,101,28,55,239,22,82,178,51,169,66,
195,82,234,181,133,254,156,251,80,241,9,148,85,115,235,254,175,46,154,168,93,64,
28,211,165,45,14,249,203,226,170,115,8,29,103,89,224,138,158,166,39,85,19,52,
113,202,128,157,70,225,216,16,13,189,39,243,248,246,81,45,160,86,2,148,32,254,
93,60,30,170,167,141,122,18,162,204,225,179,245,112,181,51,85,55,133,32,106,
170,53,146,109,105,106,69,140,253,178,106,14,194,233,118,10,75,1,244,30,252,183,
147,219,34,161,202,252,252,186,169,133,28,147,192,244,10,103,155,199,85,145,139,
29,229,20,45,81,36,177,36,146,201,54,180,141,110,238,194,123,76,178,23,191,13,
235,0,128,111,237,124,119,9,32,175,3,233,215,130,80,10,208,145,231,211,109,6,68,
197,69,46,155,9,202,104,96,125,58,227,119,79,209,111,194,168,252,17,99,237,213,
60,106,51,254,79,94,170,64,36,87,161,63,199,89,54,58,60,164,21,30,45,85,28,211,
23,2,102,10,136,52,152,21,252,141,74,140,194,238,192,41,191,231,219,174,90,160,
240,233,132,211,221,80,73,167,78,123,99,40,184,220,166,70,166,166,161,33,53,47,
74,177,203,58,172,148,111,82,33,112,169,86,229,245,66,146,160,32,72,1,101,63,
94,9,62,209,51,56,82,65,227,199,167,116,171,16,42,42,58,27,182,158,231,172,197,
97,242,85,153,58,72,60,149,208,204,148,243,226,107,245,193,13,28,149,81,181,58,
72,202,124,15,13,55,137,188,141,47,162,37,253,36,94,222,246,147,248,106,72,21,
20,244,244,255,0,86,58,164,182,226,82,162,180,32,250,244,190,159,119,228,43,
247,37,22,42,188,59,194,38,165,158,9,163,81,76,1,170,137,38,49,80,250,26,8,5,27,
173,164,215,233,97,111,199,182,94,239,196,163,52,67,71,152,251,122,240,181,210,
13,36,58,255,0,213,254,110,166,101,36,164,81,79,38,78,182,158,72,160,175,89,
169,33,18,159,186,121,181,222,86,170,146,9,35,142,81,1,113,50,232,18,41,91,142,
13,207,187,118,5,86,240,242,127,213,249,117,78,242,62,35,164,113,235,21,22,9,
168,232,168,231,90,231,150,92,140,180,185,106,73,168,4,213,34,122,122,137,172,
193,108,36,106,193,81,25,214,192,145,166,48,199,251,39,223,156,23,80,218,8,242,
165,126,126,95,228,235,202,212,98,181,198,122,91,73,22,91,248,126,131,230,181,
110,98,106,185,105,231,129,225,82,96,178,200,40,106,217,124,117,11,60,10,128,
169,43,201,28,115,237,195,10,66,168,204,160,212,228,31,63,152,62,93,121,37,105,
75,170,181,52,140,17,243,242,35,160,210,168,212,79,88,114,84,166,124,100,180,
198,120,36,134,26,167,180,208,219,211,81,18,92,177,114,91,196,95,244,130,192,19,
237,40,114,205,88,209,180,147,228,106,71,74,136,10,0,145,151,93,60,197,1,255,0,
87,159,75,61,187,147,220,180,116,53,21,105,147,67,68,34,168,167,48,213,9,211,
200,143,74,202,159,114,165,86,71,46,179,40,96,186,139,175,248,115,237,116,18,
201,168,179,49,43,232,195,32,253,189,33,158,40,91,72,208,3,122,169,249,255,0,
171,143,78,83,230,114,117,155,104,181,60,148,115,203,65,83,134,145,107,36,132,
83,85,68,102,90,186,90,152,226,171,140,154,144,129,66,218,50,236,230,255,0,79,
106,188,77,80,234,83,233,246,142,146,136,66,202,67,12,26,244,158,147,25,150,201,
78,86,178,182,20,164,170,164,141,89,92,178,84,75,28,193,124,49,203,44,196,51,
222,53,190,145,245,3,77,199,180,140,53,49,36,119,14,149,6,68,2,131,165,188,116,
24,184,50,21,51,208,210,64,242,83,79,4,30,58,182,18,76,145,196,169,15,139,198,
31,76,114,128,9,71,55,42,9,247,124,171,208,212,142,29,48,213,120,199,145,57,
168,232,67,251,76,77,21,36,181,179,226,3,178,215,87,83,212,213,210,210,194,39,
162,104,100,140,25,106,222,178,7,19,52,64,132,67,100,14,150,42,111,245,188,160,
10,21,29,55,24,118,58,53,208,83,0,156,31,150,14,58,86,99,247,210,82,228,241,
203,79,151,48,180,232,159,120,33,16,183,221,197,79,79,52,148,106,198,84,158,53,
104,149,90,193,226,147,64,36,130,56,179,144,200,222,32,10,212,106,15,179,164,
247,22,139,160,150,90,128,126,120,245,225,249,116,170,196,118,230,66,26,202,169,
88,227,115,24,107,99,35,169,120,105,222,130,178,1,53,79,146,60,205,35,211,164,
45,90,212,197,74,79,6,128,100,0,149,32,216,123,53,130,246,85,112,178,26,167,10,
250,127,159,162,249,172,98,41,88,234,36,254,70,158,95,236,249,116,53,207,157,
175,100,168,34,189,4,146,79,36,138,149,85,18,68,173,28,139,112,208,104,167,44,
203,161,190,183,31,227,237,94,182,97,142,144,164,98,163,82,227,229,254,92,245,
142,155,47,149,169,160,204,68,115,16,206,137,72,180,225,133,83,187,58,89,68,186,
62,232,192,250,145,65,23,177,226,231,233,238,229,164,224,7,231,214,180,32,32,
154,211,236,255,0,55,79,177,228,234,170,49,185,36,108,139,168,104,113,230,24,
196,176,213,67,35,137,36,42,141,27,153,16,73,226,36,221,65,210,108,126,182,246,
211,52,157,203,170,135,215,143,159,249,186,178,34,87,85,58,46,211,231,177,249,
234,236,246,55,41,145,52,77,142,173,169,240,67,151,169,138,26,58,106,10,10,72,
39,142,186,10,212,242,138,88,242,245,49,126,208,152,70,11,105,187,49,42,61,162,
89,124,105,158,50,133,81,88,140,210,148,166,15,216,222,95,179,163,65,1,134,40,
164,82,12,140,7,150,106,120,254,193,199,164,164,185,170,74,28,66,85,69,188,113,
249,10,231,206,255,0,14,160,108,122,151,122,150,174,162,44,148,237,36,12,167,33,
12,83,199,226,18,1,160,187,125,121,247,169,85,20,113,243,233,196,86,98,107,29,
22,149,63,234,242,232,59,203,231,232,38,174,165,193,86,45,45,125,101,101,109,
61,59,138,218,86,145,160,128,208,76,245,102,58,152,99,142,70,74,117,171,102,35,
202,81,24,46,171,253,61,161,96,232,112,53,125,166,159,241,125,42,138,16,65,110,
20,31,111,81,54,142,214,217,240,213,71,21,30,35,27,89,144,150,178,167,29,81,91,
81,60,191,196,106,97,163,18,214,77,34,84,185,253,167,156,58,17,110,76,108,71,
250,202,33,93,75,89,16,3,233,214,229,119,12,66,154,37,1,232,76,143,31,141,52,53,
115,12,94,26,26,104,222,137,42,227,30,42,57,80,26,152,162,143,195,57,166,11,81,
36,77,164,177,118,6,67,113,171,221,124,48,84,5,85,3,253,159,217,211,7,81,111,
136,215,166,12,149,62,220,134,183,195,67,65,29,4,116,184,122,250,76,172,184,185,
226,162,74,137,94,92,109,42,100,170,1,37,235,106,188,141,120,205,184,69,176,35,
87,55,240,23,80,213,79,240,87,236,235,193,90,153,53,53,175,251,31,234,255,0,39,
78,123,143,3,129,143,3,12,146,212,209,193,86,49,176,226,215,37,35,228,233,42,
39,84,172,154,72,93,158,156,149,172,118,87,145,116,56,253,43,234,252,123,165,
194,164,113,234,99,233,235,156,240,234,209,107,241,6,146,105,90,255,0,47,248,
174,131,169,122,251,109,204,242,44,142,185,56,17,169,180,82,67,53,82,85,249,230,
161,26,229,169,154,115,174,168,122,144,218,235,96,120,22,246,193,182,73,17,89,
152,214,190,71,135,250,184,215,165,6,226,64,116,133,3,25,251,122,45,251,151,170,
177,209,229,179,24,236,110,2,4,164,105,18,9,101,161,156,44,234,134,40,234,37,53,
79,228,103,153,148,203,98,20,17,253,120,30,211,202,182,203,36,105,83,171,228,
120,255,0,171,203,165,17,73,33,93,76,115,159,46,147,16,182,79,105,82,173,59,211,
81,127,0,117,130,157,194,68,144,180,48,181,68,144,44,95,119,224,130,105,103,
134,246,77,69,145,201,213,123,251,113,133,6,6,15,14,183,64,222,186,186,93,77,93,
6,228,193,69,79,36,243,80,227,182,188,116,20,84,148,244,84,18,159,180,162,167,
122,248,169,228,72,204,70,106,186,170,10,153,208,204,65,105,25,31,72,224,123,
123,12,1,39,135,76,81,145,201,226,91,253,95,207,165,94,243,18,97,246,217,169,
167,170,164,18,212,46,62,131,31,252,62,160,84,193,154,151,25,138,8,42,169,33,
244,203,83,89,10,78,169,48,79,162,130,223,168,49,27,122,133,199,28,116,220,68,
153,104,69,5,15,229,83,195,160,203,11,186,190,239,108,140,101,45,18,53,85,52,
117,239,79,72,114,146,163,76,178,200,244,242,20,133,65,152,84,165,79,58,52,177,
42,53,88,11,31,109,172,33,145,206,170,18,15,151,79,147,162,69,207,111,73,145,
151,169,167,200,76,204,241,73,27,79,26,235,142,25,41,105,99,26,188,117,21,50,61,
67,180,178,74,131,211,96,130,231,150,246,146,72,2,0,164,255,0,179,210,180,96,
114,6,71,73,44,238,235,165,146,178,122,58,76,173,50,169,169,73,242,83,83,196,
198,25,16,161,166,106,8,130,35,121,230,149,216,22,241,16,72,191,224,18,45,18,
181,5,71,86,113,79,176,142,146,127,119,136,172,134,190,177,97,134,40,188,136,
177,83,213,81,194,249,47,185,85,88,229,241,69,251,178,199,76,160,13,114,88,92,
155,2,69,207,187,49,97,172,121,87,207,173,40,166,157,62,135,164,117,109,52,148,
148,178,84,73,80,26,19,52,143,14,62,41,166,168,52,202,200,192,164,3,80,253,11,
127,174,149,85,32,123,210,200,77,126,223,245,127,177,211,160,100,84,84,211,164,
36,217,44,138,203,35,192,172,177,3,30,133,104,128,97,22,129,160,235,36,221,88,
2,192,92,218,254,220,214,244,39,207,171,208,83,135,93,207,184,50,117,233,4,85,
108,175,21,47,140,70,241,137,53,136,227,98,64,119,18,133,147,250,3,107,129,244,
246,211,6,205,23,29,110,138,58,118,109,197,87,94,233,205,67,203,8,211,21,50,68,
124,34,16,20,51,40,245,59,76,79,4,158,45,111,109,152,235,76,103,173,234,3,207,
29,63,83,110,122,37,49,165,109,57,90,133,155,81,14,164,150,11,30,157,47,192,
183,208,88,113,99,239,202,2,86,188,122,171,85,248,30,185,85,102,158,166,154,165,
113,44,209,163,31,92,82,188,111,5,166,33,72,96,108,226,69,250,241,127,126,105,
202,179,1,93,39,215,173,8,84,208,181,42,58,100,198,96,169,114,31,112,106,42,12,
117,20,209,202,213,9,104,254,191,217,146,61,108,25,163,7,245,16,61,60,127,81,
239,218,181,1,158,175,77,61,64,169,164,163,167,141,163,140,153,220,72,209,221,
91,142,44,67,128,0,215,168,31,199,7,223,169,83,215,137,3,135,30,185,71,78,244,
244,197,236,186,12,183,213,206,165,118,95,243,124,243,100,250,159,245,253,212,
140,15,159,90,4,212,87,167,74,9,229,53,108,99,144,178,26,53,26,85,85,9,37,192,
191,23,46,160,139,251,104,174,15,87,173,122,200,95,77,68,237,44,18,59,52,115,50,
199,20,158,18,192,94,205,166,218,136,36,251,160,141,142,1,243,234,213,165,15,78,
213,213,46,202,176,20,134,56,98,16,172,80,175,246,47,2,49,32,177,5,152,150,58,
174,47,127,109,8,116,190,73,175,78,234,26,113,158,146,21,110,64,167,17,132,66,
33,5,229,30,167,12,88,217,149,129,54,13,253,7,181,177,227,203,166,79,175,76,
114,199,250,217,165,213,121,69,200,187,57,125,36,145,166,215,0,19,249,250,251,
187,122,250,245,80,43,142,162,37,59,51,56,0,255,0,96,13,64,130,46,72,185,252,90,
222,235,199,237,235,117,25,235,58,210,149,228,221,236,24,233,69,55,0,91,147,253,
47,127,118,92,103,207,173,30,29,114,88,20,49,213,29,197,205,139,144,183,26,9,
23,45,110,5,175,238,202,61,71,90,7,211,168,165,33,58,212,133,86,85,37,108,215,
98,192,27,90,220,149,63,208,240,61,248,173,124,186,216,39,168,197,35,23,3,83,
21,34,254,155,45,136,184,181,239,207,62,253,164,215,36,117,226,64,25,235,36,72,
186,81,149,94,224,176,58,92,92,255,0,75,125,108,46,61,215,87,150,142,189,95,67,
214,54,185,91,133,225,156,242,90,231,129,249,22,255,0,31,123,80,120,211,175,117,
192,147,98,1,176,244,144,62,191,236,79,248,159,118,3,200,158,189,195,174,76,1,
109,69,201,109,43,110,15,228,114,56,231,139,255,0,173,239,194,181,249,117,227,
78,177,170,57,39,73,191,224,159,245,200,250,241,249,62,247,233,215,186,226,171,
102,33,185,176,252,30,63,31,211,235,239,100,31,90,30,189,215,114,253,16,155,144,
28,2,8,184,228,27,113,126,125,239,0,26,117,239,151,81,180,250,244,254,9,250,92,
253,62,182,250,95,222,171,138,245,238,191,255,209,208,138,56,153,131,45,129,213,
233,13,192,39,155,159,169,63,129,127,123,103,83,65,92,142,157,72,152,228,10,245,
18,96,168,210,27,130,0,176,31,218,252,91,235,253,63,62,253,90,142,61,105,150,
157,97,129,90,204,246,58,111,167,253,141,174,109,253,108,61,251,203,170,14,179,
206,200,193,127,168,95,167,22,39,254,35,143,117,30,125,123,172,148,164,106,1,
135,0,15,161,177,34,220,0,127,4,223,234,125,236,134,60,58,215,82,52,73,41,43,
100,141,26,77,44,214,190,147,113,97,113,111,200,247,226,41,196,245,170,142,157,
41,150,58,99,61,248,118,69,179,61,175,171,131,193,4,112,71,208,126,125,208,141,
71,60,58,222,122,131,81,80,199,128,226,194,86,42,170,8,181,212,139,147,123,27,
95,232,62,158,246,160,2,58,241,62,189,65,111,35,104,44,13,164,58,148,179,11,16,
88,165,194,142,80,93,79,212,95,221,178,56,245,170,254,222,156,4,98,56,72,36,16,
218,111,101,34,218,172,9,7,242,160,15,175,245,247,125,60,42,185,234,181,62,93,
101,130,146,87,162,169,169,72,217,161,134,174,24,26,80,191,182,146,76,178,52,
113,204,223,85,121,22,50,83,139,27,27,251,246,158,210,72,192,61,90,167,86,145,
198,157,65,49,233,96,110,46,92,159,233,201,227,143,199,215,221,74,240,192,235,
64,227,211,169,41,36,177,18,85,138,181,218,247,0,131,173,44,127,216,241,254,
223,221,76,96,140,87,29,88,53,122,155,45,101,81,16,175,144,16,85,46,46,71,42,
186,110,127,167,215,253,111,109,248,52,175,110,122,222,160,113,78,177,189,84,
226,72,218,85,87,9,8,186,223,245,14,64,250,91,149,54,23,254,131,221,90,58,86,
156,122,221,71,151,14,167,80,77,79,88,26,148,208,211,161,51,138,132,168,213,31,
146,32,172,35,125,90,213,164,150,32,26,250,69,201,183,182,100,86,90,57,98,113,
214,193,169,225,210,158,191,28,191,98,205,69,147,44,190,65,83,40,86,146,154,51,
82,93,213,73,1,36,50,185,142,192,3,107,48,230,222,218,134,86,171,2,164,117,231,
93,52,168,6,189,77,170,254,53,75,149,130,73,204,117,18,253,188,77,27,79,43,180,
178,135,228,44,81,222,226,95,220,250,53,174,79,181,13,49,112,43,33,36,122,255,0,
150,189,50,129,69,40,167,73,235,6,46,174,70,171,201,45,76,69,19,201,36,114,9,
233,133,162,118,153,133,217,100,113,165,150,220,139,220,91,243,238,172,199,4,0,
73,233,211,76,103,167,156,124,120,184,233,36,168,171,170,162,130,104,101,111,
12,10,166,90,201,84,194,250,30,152,68,76,86,105,163,0,134,210,81,69,207,215,
222,245,203,90,8,207,249,58,241,11,234,43,212,124,9,145,154,162,24,170,16,36,
181,116,234,209,50,7,91,186,155,56,28,54,165,183,224,144,71,227,222,252,118,90,
31,240,245,227,24,35,230,58,153,5,125,60,117,180,144,203,3,212,8,106,42,26,63,
17,240,171,153,181,42,203,48,96,196,178,149,31,211,143,107,224,187,20,163,129,
79,243,250,255,0,177,211,15,9,203,3,221,78,147,249,172,119,154,183,57,48,135,
194,209,149,101,177,32,11,178,89,52,158,111,207,245,231,222,222,88,217,155,207,
175,32,33,16,30,61,69,76,205,70,45,163,251,133,148,72,143,74,98,158,34,105,231,
79,28,74,4,134,72,200,14,202,8,23,60,219,130,15,180,242,219,171,169,167,10,121,
245,113,198,160,244,249,14,99,29,157,142,42,124,147,44,85,50,74,225,50,254,47,
92,72,67,93,166,104,19,83,171,126,110,8,255,0,15,104,30,222,88,14,168,193,211,
233,213,195,14,4,142,154,51,27,82,190,150,21,172,163,169,161,201,82,105,71,89,
49,149,43,82,67,51,133,208,232,79,150,35,254,210,202,45,127,110,67,119,220,84,
213,91,230,58,209,64,115,254,14,164,77,149,204,98,82,72,72,106,89,76,218,37,242,
69,19,74,141,18,68,237,18,9,28,164,74,124,138,91,253,87,31,211,218,223,171,50,
0,172,160,175,168,175,250,188,186,108,64,170,106,14,125,15,89,241,217,186,170,
201,106,218,83,20,186,146,25,230,129,169,69,61,60,102,149,52,171,199,34,201,161,
164,6,197,154,201,168,240,61,216,188,94,30,146,104,79,10,255,0,171,211,175,120,
99,80,32,112,255,0,87,236,232,69,218,153,138,74,89,43,168,234,225,146,21,76,90,
199,37,32,170,34,150,187,238,170,42,39,44,194,39,112,250,124,222,164,60,56,60,
254,159,108,136,205,90,166,170,105,254,163,214,137,7,73,3,63,234,255,0,15,66,51,
239,76,70,75,57,143,154,106,58,25,17,77,60,81,22,134,70,64,83,192,67,4,81,15,
238,198,168,44,196,128,160,159,233,238,202,145,37,73,21,63,234,251,63,213,142,
155,97,35,0,43,79,94,165,86,111,24,103,203,98,41,243,116,166,164,205,146,19,210,
211,70,202,194,152,194,186,5,77,96,68,241,69,17,184,10,65,185,211,207,245,247,
80,205,35,2,71,15,151,31,151,30,29,123,195,8,167,73,53,232,103,135,113,211,228,
27,205,37,12,152,232,105,105,163,154,158,26,148,137,102,12,163,198,141,77,8,72,
197,60,13,1,58,74,105,5,69,191,54,246,173,210,164,6,6,148,233,50,157,20,210,123,
171,246,249,249,250,244,239,185,55,117,69,6,30,127,28,223,117,227,153,146,56,
200,45,20,66,104,110,250,60,111,119,120,209,172,182,224,115,199,227,219,115,172,
169,12,133,14,184,169,231,196,127,197,127,168,116,228,30,28,146,163,48,209,39,
168,224,126,223,245,126,125,5,180,213,114,228,170,90,85,199,1,83,5,60,38,152,
169,18,184,75,171,177,133,185,80,100,78,116,88,92,168,36,241,236,190,5,118,58,
210,181,95,78,151,74,85,71,113,20,39,207,161,7,17,148,213,135,201,211,86,100,36,
166,143,238,214,87,72,144,55,144,71,79,18,175,150,68,129,129,158,6,60,54,174,0,
181,173,207,179,27,105,252,82,21,165,39,25,4,127,151,164,23,16,170,157,73,8,175,
145,7,167,92,102,66,150,124,86,224,106,40,35,169,196,201,65,74,213,149,94,39,
120,233,234,133,117,57,21,145,200,172,15,249,58,163,41,37,5,156,253,79,183,213,
84,36,154,56,83,207,61,48,192,135,143,95,197,95,240,215,165,22,39,35,143,138,
188,81,78,244,53,212,149,21,49,171,81,84,171,202,178,24,234,82,88,106,41,106,
228,69,69,8,169,205,253,74,164,143,241,247,64,40,195,85,8,244,244,234,174,53,81,
130,176,96,56,143,240,30,146,27,167,45,73,73,44,213,56,186,117,89,242,85,173,11,
125,181,106,72,109,13,107,138,106,200,162,75,5,5,164,100,32,187,61,191,195,222,
152,29,71,187,4,244,234,84,227,56,29,54,209,118,14,98,106,57,99,130,122,184,35,
147,35,147,90,72,28,86,163,188,181,17,197,44,52,209,211,55,146,104,86,102,114,
141,228,224,106,23,211,237,245,33,69,79,10,158,154,104,181,53,65,206,56,117,35,
37,184,51,211,46,26,90,138,74,124,93,61,18,195,29,36,115,101,103,74,168,101,
152,199,81,83,62,90,42,72,254,222,160,79,22,160,204,98,112,177,240,170,15,234,
182,172,130,79,105,29,111,194,1,72,36,150,243,52,255,0,7,167,75,92,86,62,41,38,
168,172,139,49,75,14,78,52,130,174,104,105,99,171,154,138,131,30,213,178,105,
120,228,52,148,132,188,159,82,52,72,28,88,216,15,173,151,32,146,58,77,46,52,141,
56,254,125,24,45,187,218,148,180,113,211,226,50,149,39,45,68,98,106,57,197,53,
44,168,99,72,225,116,90,217,114,82,23,136,52,81,198,160,189,130,56,250,250,189,
94,220,138,233,145,144,144,116,142,146,201,96,27,84,137,135,255,0,86,41,208,
147,252,62,182,56,21,232,232,105,169,233,106,35,167,171,134,170,90,218,74,149,
149,38,184,104,197,40,102,155,199,18,149,37,159,143,81,31,80,125,153,181,194,80,
106,99,67,251,63,35,254,172,244,129,87,44,29,77,69,113,212,60,26,215,213,45,69,
28,102,89,36,168,168,149,41,42,40,104,165,137,32,154,105,163,135,138,180,149,
41,225,69,104,201,3,158,13,200,183,186,49,110,11,156,245,230,208,130,166,148,
198,43,209,85,239,140,117,117,22,243,202,90,36,197,214,195,148,204,80,87,45,56,
166,6,166,60,77,21,31,237,212,152,108,181,81,242,175,173,89,145,195,134,28,146,
74,25,226,140,78,242,4,163,240,243,244,31,203,163,91,87,47,0,66,107,25,207,237,
255,0,87,159,64,109,14,233,174,124,92,155,118,25,168,230,150,145,161,173,148,
199,59,25,204,242,46,152,41,86,104,212,61,20,83,155,37,149,244,172,146,11,242,
109,238,129,170,10,99,165,75,22,150,18,80,208,131,254,175,159,74,157,179,143,
162,201,46,59,34,211,67,28,212,180,193,40,226,204,102,60,116,244,84,85,255,0,
114,134,146,89,35,136,83,136,230,117,1,6,181,145,202,142,61,209,206,149,213,76,
245,117,36,49,82,123,126,206,63,234,243,232,65,195,228,37,161,168,219,203,5,126,
49,29,51,143,73,85,252,24,154,37,153,40,218,158,149,166,171,25,71,13,80,179,
227,234,22,57,41,162,188,142,20,181,206,175,105,36,186,127,167,18,70,140,30,190,
127,47,90,117,82,168,94,64,80,82,159,105,255,0,85,124,250,231,134,236,156,76,
155,144,99,103,174,202,71,53,53,116,180,244,145,99,0,170,72,85,101,146,67,44,41,
36,117,16,211,105,72,64,1,252,138,131,146,192,251,74,183,119,142,154,146,64,
163,137,3,31,204,212,254,125,89,161,81,66,80,26,245,203,123,110,188,44,242,174,
70,57,112,145,201,86,113,226,174,188,85,197,45,66,206,4,73,31,241,4,166,104,
212,8,30,52,36,144,82,71,0,139,218,199,74,247,15,228,76,132,140,156,254,117,61,
105,97,81,218,107,65,252,254,206,146,187,215,124,173,121,192,210,97,178,212,147,
81,201,45,29,60,203,77,12,217,88,83,37,26,228,34,171,212,133,41,39,143,200,37,
86,212,62,165,27,219,215,50,92,2,170,206,74,211,215,137,175,94,142,21,90,146,
153,255,0,38,58,100,197,110,105,105,202,98,43,42,104,100,171,133,36,118,170,142,
186,182,106,157,45,44,68,106,166,146,153,74,206,176,75,112,171,33,230,203,123,
11,251,211,95,2,168,142,10,212,241,167,15,245,122,245,191,11,185,152,12,17,195,
166,47,239,137,25,109,194,31,27,29,109,42,191,155,237,33,152,82,205,79,52,200,
148,242,79,44,18,222,121,94,173,34,64,81,125,66,223,129,239,104,218,229,73,76,
100,170,240,24,161,175,159,167,86,84,210,161,73,207,65,206,119,39,45,76,53,20,
81,71,185,165,15,78,104,41,169,41,177,237,85,41,12,3,162,249,234,34,56,161,12,
147,21,86,118,97,225,80,77,195,15,122,154,249,21,187,148,211,204,212,0,63,203,
251,7,74,82,18,105,82,43,211,110,207,134,116,161,173,162,200,101,168,162,204,
127,15,130,9,106,228,200,75,227,157,104,170,13,79,219,85,194,41,223,200,105,201,
85,89,212,48,96,151,36,220,15,123,75,237,69,68,107,80,126,71,170,201,17,29,197,
123,65,249,99,166,188,150,235,170,56,90,202,44,93,125,5,60,24,140,237,102,95,26,
208,39,241,31,183,122,186,26,202,9,210,42,145,67,65,80,41,178,17,2,209,46,133,
100,35,147,237,230,150,109,42,172,152,169,60,58,210,198,165,201,211,229,79,242,
244,197,177,233,115,21,212,82,81,195,89,178,40,168,49,17,255,0,185,41,107,30,
161,242,116,116,217,42,118,169,135,239,171,140,46,210,87,205,35,150,130,8,36,
105,24,218,54,60,123,114,57,138,130,25,115,79,78,169,58,174,176,221,196,159,78,
24,249,116,157,109,173,81,32,175,121,51,180,217,8,62,236,6,49,84,156,117,43,
137,32,122,157,113,28,171,36,181,40,190,43,60,73,30,180,144,88,131,112,125,215,
78,176,175,211,186,168,64,81,78,146,248,172,244,120,10,255,0,180,170,129,231,
160,154,54,141,164,194,45,45,69,119,143,92,134,68,101,172,15,78,203,41,176,119,
91,24,192,224,113,111,122,80,67,124,71,61,93,129,117,212,23,35,215,172,123,147,
43,67,93,38,98,122,122,76,85,25,158,138,9,105,242,20,85,245,38,112,218,149,85,
38,131,196,178,71,86,234,45,42,149,88,208,221,128,250,123,180,128,157,71,7,243,
234,177,138,104,21,110,62,159,229,233,57,64,146,84,225,229,169,172,203,207,28,
52,245,115,81,82,120,35,53,115,19,83,69,81,57,138,102,38,158,73,82,98,160,128,
77,237,253,0,183,180,224,98,181,60,113,78,156,39,52,3,167,51,141,196,87,109,
250,133,76,142,222,197,173,34,211,163,192,223,123,53,124,115,4,79,85,100,241,
210,71,79,53,92,142,27,198,177,134,109,13,166,228,169,37,228,140,16,196,176,3,
170,179,178,176,236,98,79,217,254,126,29,6,145,194,236,179,133,40,82,43,51,157,
66,61,74,95,77,213,89,129,114,24,253,0,224,123,210,130,122,120,144,41,210,202,
151,26,216,140,116,89,74,201,99,47,89,1,122,56,32,125,82,20,113,233,51,145,202,
21,250,219,250,251,106,87,96,194,56,216,87,137,35,203,229,214,210,141,146,63,
111,73,90,250,143,184,145,89,212,107,244,217,193,185,191,0,11,115,199,250,222,
246,20,5,161,227,214,207,30,176,193,93,36,77,162,194,194,215,250,142,65,31,94,
79,215,219,108,185,227,215,171,79,179,167,49,88,243,151,185,84,38,22,80,224,
216,144,246,22,98,77,200,35,253,239,222,133,6,58,223,153,234,93,45,65,65,160,36,
70,161,65,91,191,172,72,13,236,34,31,137,73,63,95,247,174,125,221,64,56,99,78,
180,120,96,117,203,238,84,163,181,141,132,151,104,92,174,165,110,3,33,22,4,88,
241,254,62,220,208,189,86,189,76,161,158,37,170,50,128,80,132,143,72,79,77,159,
202,163,155,125,47,127,241,7,221,148,46,162,116,142,170,245,166,58,207,36,173,
61,124,146,131,121,11,200,158,50,121,179,56,102,75,112,8,231,129,244,231,219,
108,164,177,32,117,117,56,21,233,202,190,174,150,167,90,200,212,241,179,74,247,
210,9,145,66,128,168,143,164,114,234,5,141,175,199,182,152,16,72,35,173,130,0,
193,234,21,69,30,56,248,34,89,89,192,163,12,210,249,23,70,176,73,208,16,133,112,
109,244,32,17,127,123,31,46,29,120,53,120,145,199,166,250,74,8,230,106,128,149,
17,168,74,134,250,223,148,11,250,217,172,5,151,252,57,247,163,76,3,214,170,192,
209,79,81,166,198,253,188,243,47,221,195,33,77,60,166,162,174,182,12,25,110,1,
11,102,183,62,246,56,19,229,213,136,201,29,67,40,193,159,68,160,0,8,22,4,126,
44,65,177,31,147,237,218,100,117,83,228,15,77,222,51,173,172,93,202,173,200,6,
224,0,121,38,224,219,235,199,231,222,248,121,227,175,113,166,58,227,233,89,24,
139,6,97,30,160,169,113,107,125,11,90,200,13,185,254,190,245,231,243,235,222,93,
72,84,87,93,78,145,178,128,121,107,94,250,46,66,241,201,254,159,211,223,143,
250,191,205,249,245,175,78,186,104,225,20,138,201,24,5,25,129,144,40,71,245,91,
72,32,55,168,130,109,254,31,227,238,244,237,225,231,254,78,172,9,175,77,111,
164,89,65,227,83,17,127,169,28,2,56,250,143,245,237,127,126,235,125,123,198,7,
144,232,227,84,127,65,192,215,234,3,250,92,14,61,235,182,165,72,3,175,103,25,39,
172,128,5,241,49,10,1,252,233,212,77,137,7,211,201,54,183,191,121,3,79,78,181,
231,142,177,185,101,98,45,164,19,245,36,94,234,116,217,136,224,90,254,247,242,
243,167,91,234,50,175,39,242,121,250,114,0,31,94,120,31,225,239,195,173,117,204,
161,112,23,73,32,155,253,5,173,200,60,159,161,255,0,137,247,162,115,129,83,214,
250,146,40,100,241,151,227,85,180,142,110,255,0,143,171,159,64,54,63,142,111,
239,85,106,106,210,41,214,170,61,122,255,210,208,116,202,1,97,117,0,143,205,201,
183,215,139,31,175,183,21,87,241,26,183,231,213,131,184,94,29,67,98,28,147,245,
6,246,189,248,39,250,14,62,159,79,122,163,3,78,180,78,163,95,62,187,12,202,
138,151,224,155,216,115,201,250,222,223,79,126,52,235,220,58,231,164,1,245,228,
126,74,219,146,126,150,60,129,199,215,222,169,74,117,238,178,68,225,91,212,77,
184,3,130,79,3,234,63,23,227,223,133,58,215,83,82,23,112,10,157,82,72,232,4,118,
228,234,62,155,15,163,106,39,235,244,191,191,106,242,174,58,213,105,143,46,167,
85,42,194,177,106,116,47,102,47,24,36,180,68,217,82,62,56,54,177,39,158,63,167,
189,84,106,235,195,207,29,52,54,161,201,3,73,102,42,188,133,250,255,0,64,127,
199,221,212,100,227,61,120,231,172,180,234,161,131,146,56,58,180,91,143,73,4,22,
252,48,184,250,127,135,191,51,102,135,128,235,85,21,165,51,211,133,94,74,170,
182,86,122,138,135,152,8,188,42,14,144,162,48,235,38,129,26,133,142,56,195,37,
236,160,11,255,0,135,189,23,98,105,90,245,237,42,56,47,89,34,168,171,122,22,166,
137,234,60,82,213,189,68,177,171,94,41,94,52,69,89,28,5,12,94,33,199,169,136,91,
240,7,231,192,182,154,102,157,104,144,15,88,86,149,200,118,102,228,50,139,2,24,
2,111,112,91,232,15,248,15,118,8,70,107,214,171,228,71,92,42,61,15,52,104,64,
8,0,210,163,139,88,3,99,200,252,251,115,173,127,135,172,209,58,13,55,43,112,
172,15,245,183,28,243,123,220,126,61,251,173,208,245,33,217,37,98,74,243,246,
204,186,148,11,141,23,250,243,207,164,254,61,232,128,104,8,235,121,245,234,52,
30,63,40,97,245,80,88,125,108,44,7,250,174,110,167,145,207,215,219,68,39,229,
213,170,124,250,125,135,45,147,167,167,169,164,164,172,104,133,89,97,59,232,133,
188,148,186,2,104,33,213,202,146,191,149,210,111,249,247,65,107,20,141,219,77,
95,179,173,23,175,31,46,157,78,231,175,122,252,84,213,208,211,205,44,9,73,105,
162,180,18,55,136,194,158,74,151,49,204,36,98,136,7,208,91,235,207,180,243,88,
133,26,78,1,31,104,255,0,99,173,197,32,81,143,35,212,138,173,205,79,59,101,34,
120,229,152,60,149,21,1,34,13,53,165,50,61,217,157,161,80,222,134,182,171,112,7,
226,254,218,75,82,180,208,104,105,254,175,62,156,45,92,183,76,84,121,154,106,71,
18,45,29,233,145,190,224,68,140,4,165,165,141,35,117,18,112,21,192,39,147,113,
253,71,181,200,179,42,16,31,63,103,76,145,169,186,127,219,155,203,17,141,158,
105,234,40,230,82,101,149,215,74,70,90,53,20,213,80,194,117,179,155,200,90,69,
36,128,160,88,219,241,237,36,144,200,228,85,198,7,250,188,186,184,199,194,79,
76,80,229,169,204,241,180,147,76,161,181,220,240,88,43,151,44,111,171,81,36,
177,54,250,251,113,98,3,135,30,173,168,244,229,62,107,31,35,229,36,255,0,41,118,
152,0,140,168,86,252,15,83,121,36,244,222,223,75,31,111,44,110,62,206,155,174,
56,117,10,167,45,77,81,50,9,35,82,161,80,106,153,213,190,176,160,187,248,139,
49,60,15,205,248,255,0,97,237,240,40,41,94,181,74,117,10,28,133,53,49,97,4,199,
238,24,77,163,237,224,100,58,164,31,182,197,155,245,134,97,111,235,111,123,212,
23,237,235,68,121,158,164,35,213,228,162,49,206,178,23,89,188,168,180,203,105,
252,159,230,212,204,98,8,4,33,128,183,212,143,201,231,219,69,99,53,37,6,163,215,
184,112,61,40,115,80,193,74,244,211,215,192,179,133,121,163,141,234,14,183,47,
19,196,6,164,142,67,173,180,185,226,66,192,88,123,106,75,112,160,136,216,128,
122,240,114,107,94,163,226,241,84,85,144,72,106,106,254,196,203,50,66,171,57,
146,66,136,33,106,128,242,52,41,162,242,132,85,182,165,10,236,1,246,219,164,232,
59,64,52,252,191,195,142,156,212,165,168,71,74,220,126,218,70,103,52,121,255,0,
182,173,143,28,102,140,213,65,247,49,53,72,146,69,142,141,150,53,71,69,158,225,
67,27,128,77,207,211,218,127,22,68,203,64,116,252,177,249,245,227,196,0,70,122,
100,164,205,85,71,150,199,195,89,68,201,61,53,76,226,162,24,93,16,72,254,45,44,
20,72,196,4,33,72,253,69,72,54,224,159,110,7,114,192,234,170,252,250,217,85,42,
124,177,211,214,55,53,76,60,149,85,177,201,53,108,222,74,41,102,41,27,19,20,108,
173,10,179,50,187,2,220,115,233,34,220,17,237,80,150,131,178,49,80,58,104,161,
56,212,120,244,184,135,114,45,28,191,119,67,53,84,5,217,180,163,53,67,211,175,
237,233,80,45,60,244,159,183,164,13,37,64,183,211,223,146,67,71,43,135,39,231,
79,245,125,163,170,148,6,138,114,7,250,190,222,150,81,111,168,42,41,99,131,43,
20,18,42,157,76,97,130,63,182,144,58,8,188,145,141,6,104,228,114,227,90,173,
193,35,241,111,108,73,36,250,26,50,106,27,246,250,241,29,120,70,154,131,45,106,
58,89,97,242,16,101,105,102,170,166,16,154,154,106,170,108,123,153,161,16,179,
71,64,133,85,252,133,111,119,141,209,84,144,56,82,77,175,238,182,241,6,12,235,
241,234,175,28,26,14,183,36,180,210,140,14,138,83,30,93,60,83,110,42,108,125,
126,82,134,182,165,113,174,235,117,89,101,53,20,154,5,48,8,231,198,214,89,156,
141,32,92,173,207,212,123,244,119,30,21,75,70,67,112,234,146,71,90,105,53,31,
179,165,54,217,175,165,173,168,175,72,234,11,73,87,183,242,52,146,71,2,183,134,
69,72,212,172,83,75,9,11,22,162,11,22,102,60,129,207,183,227,153,89,228,1,206,
80,255,0,46,155,240,187,69,86,189,245,234,6,14,143,236,179,47,83,252,69,98,164,
106,153,100,13,145,201,18,144,5,141,245,151,52,110,103,175,133,95,132,141,147,
202,45,98,228,125,45,27,106,145,53,176,210,122,179,40,11,85,92,252,186,105,166,
195,46,107,236,178,57,13,201,28,120,201,171,105,37,121,36,165,20,176,172,117,85,
77,174,53,0,137,140,73,41,123,149,32,143,165,239,127,106,21,1,211,87,26,73,251,
58,174,160,165,187,42,115,254,161,211,70,99,114,210,97,106,178,212,216,202,106,
74,250,104,55,52,13,29,108,52,190,111,187,129,209,209,221,234,146,162,69,167,
163,143,192,11,153,99,214,88,155,27,14,91,122,56,109,63,8,108,125,167,143,87,
140,105,165,112,74,255,0,131,252,185,233,123,31,98,237,201,112,120,168,34,72,
113,178,101,43,105,240,244,242,228,233,104,171,22,119,180,212,241,136,171,44,
177,65,5,57,91,43,149,136,0,202,15,212,159,118,5,180,160,211,128,63,42,245,71,
64,106,124,235,95,159,92,179,219,179,114,198,178,109,220,164,217,57,160,165,
116,199,179,66,230,162,24,49,18,67,85,77,79,79,170,138,24,150,79,27,200,31,192,
230,86,70,91,165,136,7,219,139,175,10,77,127,213,233,211,5,99,36,58,160,245,175,
159,74,220,46,127,103,75,67,2,212,101,170,106,230,133,90,147,31,71,28,117,97,77,
52,48,198,186,76,18,164,74,164,72,11,17,43,34,13,64,243,245,247,237,20,80,43,
86,254,93,54,197,153,201,210,2,244,49,245,175,98,46,106,58,76,108,117,149,88,
156,126,59,32,137,85,87,23,135,41,146,72,68,45,53,108,213,134,60,100,179,66,138,
245,41,34,176,121,105,162,139,80,182,178,44,101,106,137,42,170,75,82,1,193,206,
63,46,138,111,85,163,44,227,226,32,99,31,225,254,84,227,208,163,67,24,197,209,
230,162,201,166,59,117,212,28,181,89,135,37,74,43,32,105,168,10,81,86,195,81,79,
16,163,240,205,19,211,78,172,247,80,236,215,54,183,209,65,70,71,101,104,193,0,
99,63,234,173,122,72,166,57,21,74,49,83,246,127,170,157,5,125,157,180,211,121,
110,104,171,49,152,95,224,212,25,125,189,44,2,186,171,29,58,211,209,100,49,212,
229,100,200,225,164,127,182,173,148,228,37,155,237,166,66,146,44,103,69,174,163,
219,82,42,134,1,84,128,86,185,242,63,47,242,244,170,222,70,141,13,90,164,55,0,
120,143,159,248,71,68,231,120,117,46,238,216,217,140,254,50,155,31,155,74,168,
176,85,53,63,122,40,205,69,25,158,144,81,213,52,83,213,195,11,82,70,138,175,17,
66,250,91,91,171,88,92,123,74,208,186,49,3,141,43,209,188,119,73,50,163,84,83,
87,15,63,217,199,174,25,237,195,147,219,217,108,86,54,92,101,42,174,227,43,148,
90,122,199,150,42,214,134,90,106,120,140,49,199,70,210,98,101,138,135,36,101,0,
186,166,135,4,31,105,230,241,104,4,100,130,79,151,159,203,171,70,170,81,141,73,
211,143,216,127,205,215,26,218,218,218,232,241,180,53,209,215,85,85,54,246,174,
150,108,132,6,162,182,190,150,69,167,163,161,153,206,137,68,112,84,196,80,159,
59,134,141,109,192,176,30,246,144,50,162,235,52,206,64,252,171,213,9,163,179,
131,141,35,236,233,10,185,58,236,86,67,32,105,107,43,40,188,11,92,178,212,52,
223,229,82,84,80,201,53,62,180,240,192,212,243,65,80,138,117,35,22,71,7,213,126,
61,178,33,129,91,80,203,14,30,127,236,116,245,73,0,26,103,164,5,110,90,178,106,
218,218,119,44,149,121,151,195,209,71,52,116,254,22,171,130,18,30,154,122,122,
88,132,81,159,66,70,232,138,161,152,40,177,189,239,189,73,168,234,244,25,255,0,
55,167,78,5,162,131,154,10,145,242,62,117,254,127,159,71,47,105,117,198,74,44,
78,54,125,211,60,116,217,131,6,70,48,176,126,220,198,117,158,165,227,19,59,129,
28,210,212,82,76,82,63,49,80,186,201,7,235,102,38,149,9,134,145,130,148,53,173,
124,143,15,207,164,161,205,89,148,250,127,171,31,234,197,58,86,238,26,125,171,
78,248,71,88,91,30,208,200,177,214,82,82,8,37,38,170,145,32,154,154,176,57,121,
36,145,191,104,71,44,164,5,44,220,88,159,101,119,23,2,103,85,49,80,87,138,215,
246,103,253,92,122,118,48,234,31,57,166,43,254,175,245,14,129,44,189,102,214,
142,124,230,172,85,36,166,162,56,171,61,114,205,45,79,174,120,252,142,86,66,124,
51,200,168,53,16,23,128,109,97,237,232,245,197,225,40,78,211,254,15,245,124,
186,112,43,53,123,178,49,254,175,151,76,113,101,241,244,46,180,180,20,212,180,
81,85,160,149,214,162,17,27,148,214,173,49,47,35,24,97,43,37,136,114,44,7,214,
252,251,176,181,146,82,92,0,195,208,211,171,120,138,104,90,161,253,71,30,146,
121,138,204,34,83,230,96,251,154,122,106,231,89,225,251,172,121,167,122,185,33,
50,6,72,105,165,10,35,58,53,29,69,1,225,174,61,191,21,188,168,99,44,72,35,230,
8,249,226,189,91,196,53,198,65,253,189,55,100,206,30,166,178,5,69,138,89,41,
113,152,244,171,203,205,36,20,130,5,157,158,186,168,204,176,211,65,73,83,51,36,
1,19,208,210,128,88,6,23,35,217,141,24,26,51,84,0,58,110,186,178,20,130,73,
234,53,54,51,22,55,70,62,158,166,122,24,233,183,109,12,89,177,68,191,115,74,141,
14,38,190,106,172,117,108,147,64,235,4,109,36,40,22,204,190,93,66,220,94,254,
238,163,184,131,76,142,170,229,180,87,53,92,127,177,254,172,116,141,48,98,183,
60,166,146,146,150,174,166,116,171,200,215,83,48,138,174,162,15,45,75,164,147,
74,243,60,134,104,230,93,0,54,177,245,181,154,215,30,219,36,26,0,51,213,203,50,
100,145,145,215,33,137,200,99,106,177,248,218,154,218,26,44,60,112,215,214,87,
67,47,219,10,204,116,80,228,102,130,117,153,228,165,153,79,154,169,110,116,45,
143,211,147,201,113,84,130,42,70,158,170,90,161,142,146,95,203,253,95,46,130,
204,209,197,70,147,26,121,228,167,168,150,55,149,18,72,206,185,87,91,25,35,101,
88,194,15,34,216,175,208,90,247,246,158,70,26,216,14,3,165,8,8,69,169,233,165,
229,157,113,79,44,78,110,145,163,84,162,32,88,252,43,80,36,14,14,155,52,145,104,
177,60,48,83,96,109,113,238,172,48,104,127,213,254,199,86,198,161,210,122,146,
162,169,188,139,27,250,94,162,58,130,151,42,130,72,181,136,165,43,171,196,88,9,
8,4,130,71,191,45,112,0,234,196,1,78,158,112,24,147,144,171,142,89,227,213,75,
4,171,169,73,35,202,238,236,66,2,79,32,105,36,255,0,135,182,229,58,104,163,
137,243,249,117,96,113,211,174,235,201,106,154,26,120,216,104,130,50,138,170,52,
133,179,145,164,40,225,0,3,129,239,105,24,69,169,226,122,162,147,249,244,140,72,
154,86,87,50,40,177,12,1,4,144,163,150,114,5,237,97,238,213,212,107,81,78,175,
74,15,159,82,141,31,249,201,17,213,185,70,85,252,188,109,198,180,185,185,33,
191,31,91,115,111,109,156,212,142,171,214,40,129,18,21,189,191,7,80,181,143,250,
223,95,122,211,144,8,235,100,227,231,212,134,71,211,31,132,56,150,32,204,25,63,
81,32,150,12,1,254,131,223,141,58,216,53,234,55,144,84,22,185,2,82,192,158,64,
107,243,115,234,55,23,252,15,118,13,80,84,245,226,41,145,195,172,212,213,19,211,
202,80,151,6,241,130,183,250,217,131,0,45,250,121,247,112,77,79,85,32,17,211,
145,200,147,59,73,168,134,110,93,156,89,141,181,106,80,64,63,91,223,252,125,219,
81,173,71,94,166,6,56,117,45,170,169,140,161,195,199,112,133,218,54,89,52,135,
49,233,58,77,128,187,158,120,183,189,176,82,120,121,117,80,8,20,7,174,111,36,
53,18,71,226,49,171,199,78,1,15,96,9,80,236,125,124,11,27,139,11,94,247,247,70,
137,77,52,158,3,253,95,225,235,75,170,153,25,235,13,52,141,18,203,168,198,81,
220,16,99,253,198,212,64,33,52,114,45,199,28,123,108,33,31,111,14,172,79,204,
245,135,35,42,172,136,99,140,198,100,128,73,34,242,28,89,138,174,179,194,146,45,
248,227,219,129,116,144,181,32,127,135,253,92,122,209,36,212,3,158,155,132,234,
53,25,21,201,58,109,110,5,238,47,253,120,211,239,103,180,99,135,94,86,36,208,
145,90,117,201,42,227,50,73,102,241,198,231,64,12,57,111,232,204,79,210,199,221,
41,65,145,195,246,117,110,177,6,142,54,45,168,89,201,4,47,58,70,134,58,138,216,
51,47,227,221,171,74,212,87,173,211,246,245,134,73,226,178,144,56,94,44,46,53,
112,61,87,110,19,241,197,189,249,120,117,186,122,117,136,212,23,132,160,0,131,
33,210,159,83,111,169,54,2,246,36,123,216,56,32,250,245,191,49,214,120,146,37,
72,154,66,46,67,22,18,0,88,184,109,40,182,55,45,114,126,188,112,61,248,211,24,
169,234,167,229,214,71,168,88,80,196,135,83,146,130,193,120,82,56,33,134,171,19,
113,254,183,191,3,219,67,195,173,211,135,88,21,88,21,125,72,174,11,41,26,117,27,
19,201,60,120,237,201,183,215,223,189,58,223,217,212,154,100,164,89,38,122,132,
146,164,171,250,2,104,88,217,67,144,250,181,31,73,55,4,88,55,248,251,177,211,
231,194,184,225,215,179,214,73,94,150,203,12,80,165,57,132,54,167,105,26,67,36,
142,197,185,178,162,2,170,109,192,211,239,198,148,0,47,243,227,214,128,53,53,53,
234,20,147,128,65,70,85,55,190,148,65,125,66,194,192,139,168,82,63,167,186,29,
126,180,235,116,29,96,251,201,195,107,212,121,60,14,109,199,244,31,79,211,199,
211,221,104,115,158,189,65,198,157,127,255,211,208,133,141,35,132,187,70,8,250,
133,82,9,22,36,106,176,32,155,15,111,181,48,105,159,231,213,115,215,23,17,170,
134,1,116,219,244,223,87,168,255,0,170,2,228,88,255,0,176,247,95,44,2,5,122,176,
249,245,21,153,23,77,174,78,155,147,253,79,245,54,191,211,223,141,49,65,94,183,
199,175,5,146,91,233,28,3,254,0,144,214,3,243,244,247,82,78,43,214,184,14,158,
41,177,129,138,73,36,171,161,129,113,24,36,23,85,93,77,118,34,201,127,246,254,
235,90,245,239,151,159,78,38,205,225,100,241,248,163,78,98,66,168,100,100,58,
174,64,58,154,241,218,236,120,189,253,236,2,105,78,171,95,78,153,42,165,103,148,
179,88,139,29,32,15,74,221,141,128,31,224,61,217,128,174,58,216,235,19,43,19,
198,155,1,123,234,0,11,129,197,205,191,222,189,236,154,28,12,245,236,117,42,56,
80,172,96,203,24,114,228,48,191,32,29,30,160,69,128,101,91,139,27,251,221,42,
42,124,250,175,159,82,4,84,128,200,85,204,138,164,132,15,125,122,88,133,86,109,
10,20,144,127,216,123,208,69,165,122,245,79,3,199,169,169,83,12,116,196,40,12,
4,140,206,168,130,45,32,161,80,26,192,41,213,166,252,92,115,201,247,96,124,
188,235,213,79,18,79,30,155,26,178,99,231,17,132,69,114,140,192,40,184,8,192,
250,88,155,2,84,243,199,186,179,80,156,231,171,233,225,214,14,88,176,93,86,96,
188,27,2,64,97,197,133,249,231,253,143,191,7,7,30,125,123,2,149,234,84,9,99,121,
23,143,81,60,92,139,253,79,244,176,3,159,119,167,167,14,189,211,173,35,68,178,
57,112,10,182,184,206,165,63,161,209,109,164,161,0,114,63,62,252,192,105,62,
191,234,207,90,57,192,234,52,80,36,174,203,9,39,85,244,92,21,18,16,121,11,35,16,
182,31,211,147,111,105,205,6,124,186,181,14,58,146,152,234,230,140,120,213,88,
68,29,222,206,3,52,8,140,210,132,45,101,123,161,32,1,234,247,160,64,60,72,61,
104,160,226,79,78,20,56,198,174,52,111,9,87,97,235,81,36,192,74,201,14,144,73,
137,21,128,120,133,128,83,193,247,119,148,46,146,91,35,253,84,235,197,112,113,
211,189,54,44,197,83,153,170,130,166,41,39,130,9,37,167,146,7,17,53,218,160,195,
36,130,59,165,188,36,220,0,8,247,79,168,140,18,89,77,126,93,81,148,144,171,229,
94,187,131,1,141,24,212,146,163,40,241,201,28,115,22,95,4,30,63,36,60,232,83,
228,118,114,27,235,244,227,241,238,134,118,32,170,167,111,219,215,180,209,177,
199,166,154,60,45,19,181,112,90,241,112,34,48,177,16,149,113,114,92,63,173,27,
144,5,128,252,253,125,215,198,34,149,140,231,167,51,235,211,132,27,54,89,231,
166,142,10,202,118,121,3,38,137,85,227,1,140,114,202,161,88,49,83,169,83,143,
123,91,181,21,213,25,167,203,170,231,215,172,85,123,95,41,143,154,175,93,18,79,
26,75,12,124,31,34,18,222,54,22,82,209,189,164,83,111,241,7,143,235,237,229,
186,129,188,233,246,245,161,170,130,188,122,106,200,208,212,83,86,206,178,209,
10,86,66,174,41,154,156,70,158,49,24,182,130,73,5,86,223,80,77,255,0,175,183,
60,68,113,88,152,17,214,133,71,30,61,117,142,166,134,90,136,139,48,243,201,233,
137,244,160,17,20,212,66,253,11,32,98,220,144,62,156,1,237,179,233,94,172,41,
212,104,140,113,180,226,74,153,17,197,133,163,4,146,222,64,74,189,192,23,63,217,
183,26,133,253,217,105,154,129,78,182,126,99,167,25,233,134,70,25,150,54,170,
168,175,150,173,18,154,53,83,48,169,105,36,211,33,103,1,72,145,17,117,27,155,
177,250,125,13,172,217,201,111,62,171,90,82,180,167,88,98,167,202,80,178,24,117,
197,35,22,155,198,99,105,1,140,170,232,105,97,145,24,186,50,181,192,42,110,8,34,
247,30,252,21,192,170,227,173,234,83,74,211,167,79,227,249,120,241,181,52,181,2,
140,199,47,137,154,171,194,198,169,124,114,150,137,46,2,203,30,135,55,83,167,
143,165,253,232,211,75,6,140,125,163,173,104,26,213,181,31,179,168,52,53,210,61,
102,57,188,225,106,233,231,151,73,102,32,76,95,233,126,20,134,36,216,143,205,
255,0,215,247,65,26,159,76,245,102,56,61,63,77,4,152,250,136,38,10,208,193,49,
129,166,132,20,168,138,41,3,179,5,149,150,204,108,232,111,194,176,252,95,223,
154,61,52,90,131,94,181,171,80,36,113,233,91,77,226,171,67,87,20,17,188,76,63,
113,227,8,86,55,245,59,249,3,233,58,155,253,168,15,235,127,119,10,153,31,62,155,
36,138,227,61,115,200,85,45,68,208,83,253,213,34,50,203,28,143,164,170,5,72,
192,182,149,87,17,130,172,111,249,189,189,213,149,107,66,69,58,178,156,84,3,208,
147,183,242,244,56,145,69,85,90,210,4,169,72,2,70,35,19,66,105,163,170,48,44,
213,67,85,60,218,218,113,117,144,43,122,77,174,125,165,142,68,137,151,53,227,
214,202,51,134,28,7,79,59,159,41,138,173,200,84,68,105,82,153,140,137,166,72,
156,192,70,168,3,57,148,52,12,236,110,193,148,127,79,105,221,158,71,0,40,211,
254,14,174,168,17,50,73,110,147,216,157,193,91,143,204,81,211,83,86,75,20,30,58,
213,136,202,117,71,36,82,198,82,89,8,133,81,172,71,209,92,144,111,107,123,178,
130,25,78,125,49,199,170,145,85,193,234,102,219,204,228,42,43,102,106,186,152,
169,232,163,163,200,79,46,187,9,85,228,133,227,164,240,196,209,120,245,201,51,
254,163,123,14,46,61,191,27,41,52,211,220,1,245,234,146,2,20,21,53,200,255,0,15,
66,70,217,196,69,151,92,112,122,185,42,169,227,200,69,66,143,101,88,34,139,88,
156,15,4,55,142,165,60,173,35,74,85,131,42,145,111,110,197,26,59,166,176,105,
233,79,217,199,166,92,184,212,87,24,245,233,199,33,181,214,151,23,85,61,20,84,
148,240,165,69,29,99,188,80,203,45,69,70,172,169,162,166,133,32,71,150,76,162,
179,214,35,20,145,16,58,175,165,137,178,149,218,162,85,117,68,192,251,60,191,
226,255,0,159,77,13,108,202,75,100,138,83,253,95,103,65,166,225,222,13,83,78,
184,124,246,47,18,101,197,213,194,147,212,154,90,122,168,234,188,53,19,149,137,
241,245,241,180,105,20,212,211,31,36,104,141,161,212,122,65,246,226,182,164,3,
175,8,232,73,12,77,124,191,217,233,250,155,118,227,34,200,71,87,91,155,102,65,
44,85,20,43,91,60,213,81,227,113,209,79,122,106,74,114,80,172,3,25,8,10,110,47,
17,176,224,123,163,70,88,154,53,1,235,195,32,10,100,127,171,249,244,172,202,
238,140,14,235,163,46,173,83,143,172,160,161,170,174,155,43,75,75,73,63,220,52,
109,26,197,32,173,100,26,105,76,28,48,114,101,102,185,7,241,238,233,24,3,38,167,
170,18,193,143,165,127,226,252,186,147,215,245,227,105,99,36,203,207,89,38,70,
99,94,179,227,210,147,35,140,171,158,190,190,58,143,48,164,164,90,184,234,82,
56,50,56,245,146,25,150,72,172,30,101,186,144,61,191,19,21,101,112,114,13,127,
213,246,244,158,117,241,6,146,49,67,249,127,197,125,189,89,13,5,7,241,188,84,
121,42,249,27,3,4,242,88,80,140,205,86,59,27,69,60,136,146,65,141,163,138,178,
165,234,101,106,80,170,53,132,72,214,43,42,175,167,217,184,62,34,171,86,149,249,
240,232,58,127,72,149,80,11,125,149,252,255,0,63,240,244,159,222,27,89,177,48,
212,56,205,99,51,71,25,81,85,134,146,31,0,203,24,132,249,106,9,222,67,13,109,85,
124,85,216,194,164,32,133,32,146,238,67,130,116,216,55,36,117,2,172,15,151,243,
233,200,230,174,74,17,92,250,121,127,135,160,234,191,47,75,89,154,204,225,50,91,
146,183,15,151,172,142,175,29,73,151,199,199,144,169,150,9,178,24,182,68,171,73,
38,138,106,81,0,49,164,8,163,65,17,197,96,64,39,218,118,7,87,135,234,41,95,183,
165,81,146,2,200,19,0,214,159,97,255,0,15,64,23,124,117,237,94,7,33,179,179,152,
236,76,217,218,88,48,237,74,153,120,170,235,104,168,242,77,60,243,77,45,53,116,
212,71,70,34,179,32,9,144,20,177,144,151,7,85,237,237,44,145,178,144,8,200,232,
194,210,116,145,93,53,80,215,129,226,49,233,231,78,139,6,227,205,205,140,196,96,
234,40,32,174,199,229,233,43,235,165,137,103,150,54,166,138,122,122,42,25,39,73,
89,109,85,60,101,24,162,49,42,197,189,77,193,247,66,104,160,124,250,90,139,170,
70,169,26,105,252,171,251,63,46,157,169,242,117,153,108,78,79,43,81,85,143,168,
203,234,33,166,167,160,251,168,158,90,138,121,166,122,63,225,245,103,84,176,70,
16,43,157,38,203,114,69,173,238,158,28,101,28,208,234,251,127,111,85,96,86,85,
0,81,125,15,88,49,27,132,195,137,130,117,108,13,33,195,212,98,69,68,180,255,0,
109,252,64,70,181,81,187,75,142,142,72,150,105,18,15,220,82,212,229,140,70,214,
183,3,219,10,128,105,160,169,28,120,245,114,181,98,42,104,79,229,209,155,254,
254,110,90,205,189,79,62,126,28,54,96,83,84,212,182,49,49,141,3,195,76,229,233,
228,199,85,213,53,43,73,4,83,69,42,8,193,147,247,227,87,185,31,159,109,200,240,
35,9,36,132,80,12,83,237,225,156,142,168,182,238,14,136,216,129,231,92,116,12,
110,45,231,148,172,241,230,43,214,108,108,115,215,77,21,76,84,25,58,132,165,164,
168,54,53,20,106,149,18,1,49,87,140,73,42,130,84,130,90,246,22,246,132,201,36,
178,23,0,0,13,105,79,95,79,231,210,149,137,35,64,140,106,120,116,94,115,219,173,
104,43,105,142,43,39,147,174,158,166,158,162,66,217,49,73,34,232,51,48,5,197,59,
203,231,132,178,233,30,66,15,166,250,64,34,235,63,208,227,241,22,172,69,72,227,
79,219,213,169,93,122,112,63,103,89,132,27,147,37,67,38,116,230,24,161,6,25,82,
129,5,92,231,83,104,109,94,24,252,84,52,159,217,58,139,5,181,173,245,62,220,18,
82,131,135,77,174,129,197,106,126,222,166,226,113,248,74,135,105,51,53,245,78,
62,233,7,130,178,173,53,180,109,196,229,22,36,17,204,130,199,213,21,236,8,184,
246,211,201,71,160,38,157,92,87,72,32,12,252,191,203,212,221,211,251,85,149,52,
143,37,61,70,169,171,169,32,154,53,134,103,146,157,34,20,101,202,160,49,70,237,
18,169,14,108,224,2,127,39,219,239,42,241,174,71,167,90,133,9,21,251,56,244,29,
214,249,150,191,25,81,81,21,73,164,24,200,162,21,52,65,17,164,180,134,7,130,162,
87,54,148,162,46,146,161,185,94,126,158,246,26,180,36,17,142,172,225,64,101,
212,56,245,15,31,53,93,44,211,215,209,138,248,21,33,50,201,84,243,105,241,208,
201,34,134,19,60,110,76,113,56,2,192,88,216,31,119,26,69,74,240,235,206,27,180,
26,125,157,66,151,113,84,209,84,84,79,67,149,243,125,229,53,116,19,202,193,228,
146,101,171,7,204,142,143,254,234,42,192,43,63,168,90,246,247,178,218,73,161,
242,235,65,1,20,100,161,29,32,170,42,12,238,12,146,35,69,234,253,90,152,129,96,
62,141,235,28,142,61,167,110,227,90,231,165,25,235,37,33,13,74,212,237,44,177,
253,192,85,169,254,206,181,119,123,72,56,187,193,20,41,126,126,164,241,239,202,
0,83,92,87,143,85,60,106,7,10,245,12,49,137,36,142,27,180,98,102,80,214,0,72,
170,120,242,1,201,93,63,129,253,125,248,246,214,157,88,121,19,210,238,138,174,
154,135,29,79,53,62,160,224,22,34,91,15,222,98,226,87,96,13,213,126,138,130,223,
167,159,175,182,74,51,201,168,249,255,0,131,173,240,20,242,233,7,60,223,113,80,
238,247,62,182,231,147,245,185,28,253,108,73,255,0,94,222,220,99,154,30,29,106,
156,58,237,79,130,117,98,9,142,225,142,130,70,168,143,215,73,60,143,165,189,232,
12,211,173,142,31,62,148,114,85,211,205,40,81,24,20,136,209,136,215,70,153,47,
166,225,138,130,24,133,45,207,231,250,123,176,249,241,234,180,35,207,61,117,85,
75,73,251,128,77,28,146,75,125,10,238,30,84,80,46,66,155,141,26,201,224,158,
125,217,148,28,30,168,164,158,35,135,76,177,188,212,211,46,182,4,196,218,75,141,
77,126,44,159,209,120,28,113,237,159,195,145,231,78,156,243,175,93,203,68,210,
68,245,144,145,169,57,101,11,115,32,82,117,56,34,234,186,79,215,159,109,214,
132,3,211,190,89,234,61,59,249,65,189,157,181,196,160,175,212,146,77,136,102,
181,172,127,175,183,67,214,128,241,234,140,51,214,66,154,36,145,94,229,129,185,
36,131,97,253,46,56,60,127,78,61,218,191,62,171,229,243,235,148,178,70,25,139,
158,72,93,32,90,204,72,6,196,114,223,159,245,175,238,220,73,235,67,3,135,88,37,
157,154,87,241,150,2,202,160,11,139,139,1,165,143,230,246,247,178,71,90,85,199,
28,245,206,154,114,132,143,160,214,196,129,115,123,170,240,127,162,221,126,183,
184,247,234,158,7,173,149,4,100,116,239,83,53,61,79,138,226,118,148,81,36,72,
151,141,138,76,30,73,20,107,105,53,152,81,88,105,191,62,244,199,143,165,58,168,
193,53,25,175,77,82,67,50,146,204,174,80,89,117,174,155,41,62,163,126,73,91,126,
79,186,21,52,166,105,254,175,240,117,113,235,231,212,29,86,126,72,47,102,210,
199,69,173,99,245,63,142,127,216,251,211,83,25,53,251,122,223,231,215,8,164,36,
149,103,40,25,192,103,177,116,181,207,251,16,108,61,250,149,211,233,254,175,245,
99,173,245,158,88,29,68,126,80,85,36,212,232,196,216,176,213,163,85,143,1,110,
8,62,236,6,156,145,138,99,173,2,56,117,197,93,16,38,130,67,7,96,196,50,223,
244,133,31,67,112,44,56,247,82,91,181,137,167,249,63,203,214,207,92,29,203,8,
192,43,197,239,199,165,110,214,185,176,187,27,255,0,175,238,203,74,0,13,122,215,
153,234,66,40,72,192,250,73,116,116,211,99,172,151,62,167,38,196,127,128,247,
188,80,128,63,213,235,214,250,203,98,99,226,193,132,170,13,181,18,65,28,134,63,
80,63,195,233,127,117,201,83,230,107,231,214,252,250,226,34,213,62,131,41,81,
119,99,112,126,138,196,220,219,243,111,233,238,194,160,228,117,174,161,24,195,
57,58,217,201,146,202,182,211,171,145,234,189,236,15,60,253,61,239,207,61,123,
174,205,57,148,177,250,16,223,75,250,184,39,144,215,38,220,31,246,63,235,251,
213,126,93,111,174,204,32,42,141,67,214,77,197,199,0,11,129,171,253,113,239,66,
185,20,235,221,127,255,212,208,149,233,85,88,135,43,99,99,198,159,64,0,18,24,0,
218,65,255,0,98,125,184,66,168,62,189,104,31,47,46,188,200,164,120,149,148,128,
72,83,111,167,1,175,169,121,191,208,125,57,246,217,249,14,183,246,245,196,83,
249,124,100,146,2,144,173,251,124,41,191,11,107,216,220,15,167,231,221,181,1,
192,117,227,212,199,161,72,47,36,146,155,180,107,36,105,250,100,46,24,106,87,80,
182,82,20,92,127,64,125,248,150,32,130,122,174,115,140,117,201,42,86,5,34,34,70,
160,117,151,117,101,36,130,8,102,2,220,234,250,14,57,247,234,17,246,117,186,87,
39,168,82,212,150,12,170,198,204,21,64,190,162,2,253,1,98,7,23,55,176,247,122,
129,129,235,215,186,140,6,171,243,118,60,14,126,159,157,68,159,247,143,126,81,
83,95,159,94,56,28,49,215,54,184,11,126,13,185,227,234,71,245,255,0,92,251,183,
104,35,215,170,142,2,189,103,180,122,98,118,105,52,23,111,42,199,24,212,139,169,
121,70,103,11,43,104,231,157,32,30,47,253,55,233,83,215,189,64,199,93,196,11,6,
96,190,139,170,234,98,151,228,217,125,23,187,18,109,253,125,212,18,86,131,175,
80,14,179,67,164,147,27,53,175,101,185,94,65,250,30,126,150,10,15,187,40,165,
79,151,94,244,235,26,248,218,119,85,4,114,171,103,96,73,253,63,167,233,114,109,
192,250,11,251,100,181,6,78,58,189,13,56,103,169,48,160,50,166,152,228,127,219,
118,97,26,6,96,220,216,6,39,77,193,176,247,79,20,41,227,215,138,177,173,79,79,
208,98,106,36,68,146,84,88,208,198,74,168,115,113,119,181,244,232,63,214,246,
191,191,53,210,233,160,28,58,240,21,233,194,28,124,16,202,60,228,150,67,23,150,
50,69,158,222,173,65,198,167,91,20,22,177,250,123,104,220,59,3,69,199,250,189,
122,221,51,212,88,35,161,138,114,92,44,33,100,6,63,213,43,162,137,117,47,231,
213,117,224,92,15,116,99,37,7,126,122,216,251,58,117,170,201,80,10,137,102,133,
170,255,0,122,228,21,20,154,225,147,80,23,66,76,74,204,160,18,7,167,250,19,237,
186,55,3,154,31,58,245,172,154,245,225,158,154,8,160,173,162,241,211,154,10,143,
186,14,12,63,118,245,133,194,201,35,75,227,110,36,88,245,105,228,88,144,7,28,
216,33,102,165,15,243,225,213,104,56,30,146,149,57,138,170,134,173,118,184,73,
229,22,215,160,248,208,202,211,42,93,81,9,23,107,131,97,199,183,196,84,81,142,
29,110,131,29,71,106,201,229,199,248,200,109,10,242,54,145,117,5,189,33,156,
128,220,134,0,115,110,71,183,40,6,105,214,168,43,243,234,4,109,52,65,152,1,98,
61,87,210,223,67,111,235,126,24,126,7,211,222,143,91,233,214,159,47,81,27,65,
227,125,22,158,23,11,24,123,2,170,201,127,81,43,125,45,254,243,239,218,23,241,
127,62,180,122,124,131,118,87,67,231,89,37,212,178,75,1,96,197,148,146,133,72,
186,185,104,254,130,198,255,0,79,109,61,186,19,81,199,175,116,190,164,201,255,0,
23,157,4,180,2,122,105,162,141,88,1,233,35,212,133,144,46,176,141,113,193,31,
78,120,246,141,163,104,207,107,119,87,173,227,143,151,76,21,187,89,181,249,113,
107,121,124,241,175,128,157,14,132,201,98,142,24,132,112,1,225,150,222,212,37,
193,173,36,234,180,254,19,211,5,94,15,39,44,108,96,199,212,72,148,213,73,12,235,
77,78,211,23,242,185,100,149,164,140,180,146,172,114,41,67,97,232,255,0,99,237,
98,134,43,169,107,78,169,172,86,133,179,210,178,139,11,34,65,141,201,84,227,
169,234,233,163,105,60,24,234,216,167,165,25,20,53,53,17,249,42,26,148,165,69,
70,153,163,100,58,244,48,85,0,240,65,247,96,14,24,142,169,80,106,3,100,245,195,
45,137,205,96,133,37,85,77,52,158,72,7,136,154,215,142,69,69,88,80,67,77,36,69,
239,29,40,132,132,75,18,52,0,1,4,1,237,90,171,232,169,225,211,97,227,110,208,
217,249,87,166,170,241,7,138,73,41,218,164,211,203,13,47,149,167,165,72,116,228,
28,201,60,244,48,175,221,79,230,164,66,23,67,150,89,24,3,117,0,11,236,160,209,
142,31,229,234,232,205,80,24,10,252,189,58,99,199,209,69,95,152,163,137,228,142,
57,43,39,49,107,145,64,72,42,164,186,163,106,212,52,47,147,77,239,192,28,251,
101,80,51,1,78,157,103,210,164,250,116,33,229,105,177,212,115,86,211,26,255,0,
226,84,24,90,137,41,154,166,130,59,10,217,140,37,162,168,97,84,35,99,0,169,144,
198,215,80,87,199,193,55,4,222,72,87,184,214,160,116,157,100,115,163,178,140,71,
3,254,199,76,102,74,134,142,33,75,60,144,68,141,35,170,150,140,21,17,144,28,
47,162,50,117,44,183,3,83,112,13,189,181,224,212,241,233,193,38,77,87,63,231,
255,0,87,159,88,234,50,45,137,171,133,195,199,87,162,100,150,19,165,157,39,127,
28,108,235,41,146,218,99,91,144,83,250,31,105,229,142,140,70,72,233,200,216,50,
131,78,167,100,243,198,166,44,75,55,166,122,111,219,17,137,164,188,116,145,204,
181,42,154,35,140,166,133,118,36,92,150,63,211,233,237,143,12,159,244,191,103,
87,173,13,107,233,212,90,172,252,181,181,21,14,89,230,53,16,68,131,238,144,179,
69,40,133,97,167,112,229,148,70,238,0,210,79,244,23,227,221,210,54,210,6,156,
245,173,67,39,87,74,45,171,184,177,56,172,205,22,71,48,245,85,176,81,71,82,210,
67,20,194,20,173,105,105,173,77,73,45,64,102,20,145,187,2,92,233,26,128,211,
113,199,187,152,216,58,147,194,189,80,212,171,40,28,120,127,171,253,158,177,83,
238,151,243,214,75,75,85,91,13,52,180,21,138,194,25,218,88,144,205,162,87,167,
143,201,161,153,83,244,6,123,216,112,47,245,246,174,61,32,73,68,28,15,85,101,36,
33,35,184,30,132,29,173,186,230,161,147,7,58,64,107,150,150,117,146,12,115,200,
208,194,243,3,225,102,168,151,81,114,38,19,250,236,111,96,57,226,222,236,163,32,
14,153,97,167,88,60,15,243,255,0,138,233,87,67,189,170,34,146,158,105,241,139,
247,210,121,62,242,41,42,222,32,105,113,210,90,51,13,50,171,163,61,52,212,196,
71,35,184,213,164,88,115,127,118,10,72,116,245,7,254,47,173,5,24,238,224,127,
195,254,175,159,72,12,230,107,31,84,106,36,163,163,6,151,39,45,90,75,252,69,35,
154,174,138,79,46,52,195,81,75,42,59,36,6,54,6,236,11,54,153,90,247,31,77,173,2,
12,227,254,43,171,42,29,109,83,74,122,121,241,255,0,87,250,171,211,170,166,34,
146,157,103,204,82,26,138,122,170,135,161,130,10,121,52,84,60,237,60,94,72,30,
115,117,134,8,169,193,151,210,24,63,0,243,199,187,173,105,83,246,116,205,9,56,
226,51,208,173,138,217,147,127,116,178,53,148,42,210,37,92,244,152,140,72,158,
178,41,163,169,118,105,180,210,161,49,83,133,90,145,14,133,242,88,9,15,36,14,
125,184,80,233,213,229,94,153,50,3,32,79,58,87,161,111,105,116,54,227,196,193,
180,247,62,229,168,165,217,56,42,120,228,170,201,86,211,229,33,151,63,87,43,205,
74,212,216,236,102,18,138,26,137,70,98,80,164,68,179,254,202,200,3,72,222,157,
62,238,177,145,164,211,29,39,150,229,25,93,80,85,171,230,63,203,209,165,202,
238,28,93,69,78,70,142,130,138,182,106,100,122,106,156,119,241,26,138,153,38,20,
52,244,49,211,44,217,8,49,210,67,8,200,83,74,36,242,185,150,204,206,45,166,231,
217,138,0,20,212,116,78,117,84,62,175,63,245,83,169,185,253,223,67,137,219,89,
41,69,44,116,212,117,89,17,95,25,93,170,208,92,210,42,82,56,74,207,226,85,211,
173,35,205,85,28,158,77,76,222,147,233,22,246,227,182,149,39,231,233,254,172,
117,69,66,210,0,13,79,219,235,249,116,17,207,38,196,147,61,20,240,35,144,181,
152,122,91,209,227,171,100,169,200,61,114,182,58,178,116,158,157,227,160,140,3,
25,43,228,23,114,195,139,251,97,188,54,42,65,243,244,233,66,120,192,48,62,135,
207,243,251,122,133,214,251,132,214,87,100,118,134,235,163,53,130,154,138,167,
17,140,168,119,187,70,152,163,170,136,87,209,204,237,53,44,46,145,178,6,86,33,
229,60,160,3,219,112,128,210,21,113,83,76,124,169,254,14,157,156,105,69,146,38,
161,173,79,206,191,62,139,239,99,245,227,207,137,165,203,99,226,243,109,252,126,
74,186,159,39,154,134,7,41,142,21,148,180,105,33,170,163,1,234,105,66,211,143,
184,10,84,137,33,1,208,149,62,211,72,148,7,248,106,122,49,183,151,33,88,247,208,
99,231,254,175,243,116,26,99,48,18,99,182,198,79,47,29,96,150,146,155,33,94,
184,172,137,163,120,36,174,85,142,141,162,154,58,118,105,36,240,207,27,122,108,
111,164,220,216,220,6,192,160,227,92,227,165,44,250,156,118,228,241,232,49,173,
171,147,26,18,89,169,160,53,79,122,181,243,86,211,86,73,226,127,249,119,199,21,
58,213,253,186,214,68,239,226,119,42,100,4,220,41,3,219,108,41,66,6,127,213,
142,156,168,112,70,172,112,243,227,235,233,246,142,167,213,110,138,72,87,25,60,
90,245,248,101,133,20,52,169,70,203,44,138,76,179,37,227,73,60,17,146,10,223,
87,144,92,27,113,237,155,143,214,88,214,131,142,79,159,175,91,139,180,190,113,
243,255,0,87,243,233,61,149,175,166,165,166,150,10,60,140,57,10,121,170,71,150,
173,35,168,133,153,76,96,196,236,146,27,130,225,45,32,231,147,111,207,183,86,
138,129,84,130,61,122,174,150,103,44,235,70,161,167,167,30,131,204,109,84,49,
229,42,100,174,136,132,122,101,134,32,208,151,134,52,50,39,153,230,85,112,218,
52,175,224,55,34,196,123,73,33,4,144,126,222,149,48,58,104,189,9,7,127,81,65,
75,53,61,11,100,102,172,86,164,134,129,214,10,74,74,83,72,138,209,255,0,151,
203,21,83,212,58,193,228,38,52,88,254,182,23,247,230,101,21,52,207,76,172,109,
80,90,148,166,115,154,252,188,186,74,84,101,169,77,91,171,49,136,25,160,121,
167,8,146,120,29,89,188,236,177,72,66,217,193,37,130,144,27,250,251,241,42,204,
167,143,229,254,175,78,156,210,66,16,13,120,211,169,113,215,82,213,208,37,68,
243,84,211,77,20,114,34,168,112,139,82,149,82,62,179,20,186,211,194,142,182,46,
0,186,143,72,38,228,143,0,21,193,252,39,249,117,124,129,74,244,220,213,212,41,
147,138,72,132,43,69,28,16,82,204,171,44,222,41,194,40,18,84,72,142,206,200,100,
6,204,70,171,255,0,177,246,254,9,173,122,111,75,21,210,112,122,76,100,242,147,
56,52,84,194,52,167,169,17,173,68,144,171,41,172,88,238,209,68,247,126,98,140,
144,72,2,197,172,79,208,123,173,105,80,58,184,90,157,77,199,252,29,119,79,141,
162,251,105,196,226,90,154,153,41,81,130,196,237,20,52,79,114,84,73,233,86,171,
168,96,129,64,22,141,117,125,88,143,118,8,51,94,52,235,69,154,160,142,21,255,0,
87,217,254,30,155,104,241,149,53,82,83,65,13,45,65,19,188,106,179,44,13,25,62,
77,74,192,201,40,85,10,10,145,114,116,220,125,125,210,156,43,90,117,125,67,212,
117,236,162,84,227,32,130,10,136,226,70,87,153,162,10,81,164,145,99,149,163,209,
42,163,51,46,153,33,35,240,8,28,123,209,52,33,79,90,20,106,176,53,31,234,225,
211,77,11,60,203,36,146,155,169,123,184,99,233,103,96,88,220,0,0,184,247,226,
107,199,171,240,235,205,60,143,161,82,87,137,109,105,91,75,105,86,14,109,168,15,
207,35,250,139,251,247,217,215,169,199,169,9,4,82,70,218,36,44,69,228,39,232,
165,237,245,191,246,79,251,79,227,222,143,161,225,215,171,158,177,235,50,170,45,
200,10,133,121,177,8,197,172,71,54,37,77,189,215,231,214,207,219,158,163,137,39,
70,106,115,244,14,24,41,176,212,127,30,162,65,209,111,126,227,66,41,214,233,
199,167,34,210,200,99,242,64,224,198,175,26,149,70,116,148,42,221,92,186,235,
255,0,55,244,181,255,0,55,246,229,65,193,29,83,72,252,186,110,144,183,170,202,
215,228,162,134,107,33,189,201,94,0,54,3,219,85,4,145,242,235,195,136,207,83,41,
114,139,13,60,148,242,68,14,164,210,38,13,197,203,3,202,91,150,33,126,160,251,
105,208,18,105,195,167,65,160,165,58,232,71,27,70,30,50,168,159,112,220,233,26,
211,76,106,247,44,204,163,73,123,216,127,182,254,158,252,42,0,207,90,39,211,168,
141,35,9,153,72,177,37,1,32,21,101,86,2,231,77,199,211,235,111,118,173,43,67,
214,141,41,158,184,50,3,56,64,234,75,176,182,162,64,60,241,168,254,62,150,247,
117,238,35,253,92,122,214,115,76,245,152,171,175,220,185,72,152,6,181,201,83,
202,158,124,55,42,47,111,199,55,30,236,77,56,147,254,175,245,113,235,106,42,27,
133,127,213,251,122,140,28,163,49,86,5,8,96,93,46,69,220,0,203,200,82,63,62,235,
90,233,175,86,210,1,62,157,114,146,162,87,116,69,111,164,97,85,128,210,89,65,
98,3,27,159,167,227,250,123,241,92,249,145,213,120,208,99,174,6,173,138,180,
109,52,218,72,250,43,89,65,94,6,165,183,171,252,62,150,247,170,26,82,149,29,88,
4,31,111,81,188,128,56,109,58,141,172,3,125,109,111,175,6,250,181,30,63,167,
189,178,227,39,61,84,121,227,167,42,88,92,197,43,69,250,227,241,206,236,246,188,
107,234,5,210,199,234,132,253,109,249,247,90,129,192,87,237,235,100,156,143,46,
176,213,75,234,97,172,201,26,174,148,44,218,141,201,214,72,36,14,75,147,126,45,
239,69,141,77,27,29,104,112,233,184,155,19,207,54,177,35,155,255,0,95,175,228,
223,221,65,57,249,255,0,46,188,43,199,169,72,0,85,231,146,9,38,226,195,213,192,
4,126,57,250,123,223,152,243,235,125,72,213,113,35,115,114,19,129,192,80,6,
155,159,200,37,69,135,183,176,114,5,71,94,235,44,44,214,114,110,218,29,29,174,
71,10,186,137,4,125,79,28,127,175,239,204,120,250,245,174,189,19,170,59,48,114,
9,140,130,88,92,6,98,170,69,255,0,167,63,95,122,20,165,65,227,215,186,192,10,
146,8,11,114,236,72,31,80,46,45,111,245,254,151,247,177,235,95,245,124,250,223,
82,76,144,33,37,194,161,46,61,34,193,130,130,65,81,99,195,15,234,120,227,222,
181,1,65,215,186,139,229,143,203,229,34,79,23,213,120,255,0,15,83,92,255,0,107,
143,199,231,252,61,238,185,167,159,94,173,124,248,117,255,213,208,205,103,163,
45,251,165,150,209,198,63,97,132,119,84,0,184,107,171,147,38,161,96,63,216,223,
221,201,21,53,24,234,191,224,235,185,170,232,245,106,68,146,84,121,139,248,137,
208,254,49,167,74,60,136,151,98,234,63,7,143,126,106,48,168,235,192,28,87,143,
89,107,51,30,72,163,138,8,33,165,72,175,225,141,80,72,235,168,50,190,183,39,
146,126,160,219,219,122,72,36,158,61,111,62,103,166,41,38,150,83,170,103,121,13,
128,12,236,77,128,181,185,63,208,123,186,177,24,25,235,212,235,214,102,2,230,
194,223,237,184,184,224,126,79,189,234,213,214,233,78,188,139,112,111,110,120,
23,23,35,235,200,255,0,15,241,247,179,82,64,243,235,221,113,191,246,77,237,123,
183,211,235,244,31,239,30,220,198,113,254,207,90,167,167,93,150,102,178,146,72,
189,255,0,199,253,240,30,219,102,161,160,235,221,72,141,152,196,74,42,143,29,
249,22,98,229,128,22,101,114,215,10,63,160,3,221,53,17,248,186,221,56,117,197,
98,149,149,10,173,141,197,173,101,60,45,238,13,237,200,55,255,0,120,247,83,32,
31,139,29,110,158,93,58,69,72,134,72,30,105,30,84,145,139,186,38,160,14,129,
102,212,222,149,213,168,222,214,30,219,50,54,147,78,61,120,10,17,195,174,233,
140,9,81,250,98,72,238,173,112,85,135,235,3,155,6,36,18,57,254,190,218,33,202,
241,53,225,158,175,74,113,53,233,206,162,178,228,24,129,150,225,163,64,136,168,
170,111,109,37,164,96,128,128,47,192,30,245,20,68,176,175,30,180,79,236,234,100,
249,74,130,194,156,55,142,101,132,177,12,205,61,157,129,186,198,84,149,31,83,
197,128,246,163,192,206,150,3,135,77,7,197,79,14,163,189,54,81,164,165,142,106,
129,1,168,95,36,15,60,145,44,108,80,9,45,251,47,48,64,3,14,8,4,126,64,246,240,
131,128,52,161,175,90,241,87,186,130,180,233,155,199,59,207,81,38,178,233,16,81,
52,178,6,69,23,113,16,37,91,67,173,228,54,181,175,254,30,238,33,82,72,31,8,235,
102,74,105,245,61,115,130,138,121,33,154,161,30,61,52,234,235,33,125,58,148,222,
254,146,236,110,164,27,234,226,222,234,83,6,128,80,30,181,226,84,128,107,211,83,
204,242,235,82,75,49,62,144,156,1,123,21,55,91,41,63,227,239,68,10,31,51,215,
133,6,58,151,29,5,108,234,209,199,5,69,67,23,12,22,24,228,123,88,30,108,168,69,
128,63,83,239,218,73,205,49,215,137,245,34,157,60,83,225,114,141,70,117,36,177,
163,146,88,75,23,42,93,130,41,98,214,97,19,158,1,23,228,123,246,131,128,69,58,
214,165,213,131,214,122,12,109,18,207,36,25,39,157,226,63,111,28,115,192,82,10,
117,119,181,214,118,153,68,168,8,224,88,127,143,186,144,190,96,144,61,58,221,88,
142,222,63,63,246,58,150,216,252,109,60,177,206,191,112,200,245,18,210,172,31,
115,29,43,151,134,96,99,2,118,142,102,240,105,34,242,133,250,143,109,175,204,
118,253,189,108,147,194,185,233,246,182,171,110,154,90,154,60,126,218,197,193,
122,200,38,25,15,226,89,44,149,113,8,141,228,87,106,199,20,235,12,236,120,180,
67,155,112,61,184,72,200,84,3,249,244,218,135,20,45,33,63,144,31,224,233,190,
63,189,166,154,41,241,213,44,81,99,141,205,42,177,67,77,228,212,194,57,84,15,
19,42,177,184,101,230,196,126,125,213,128,97,70,61,94,180,173,122,87,224,103,
171,200,180,77,44,4,73,247,9,168,249,80,153,53,155,43,172,76,225,217,27,253,85,
185,246,150,75,119,80,89,7,111,94,44,160,211,207,167,168,113,57,47,190,199,210,
82,125,196,1,178,162,52,52,53,82,82,176,121,29,85,211,238,41,167,138,165,21,
191,193,173,253,61,238,24,238,77,26,58,254,222,169,35,198,3,7,35,135,159,75,156,
84,153,12,77,53,81,138,121,98,79,188,202,201,81,59,61,93,108,248,168,103,172,
241,73,81,67,85,87,85,54,181,146,110,8,149,140,140,215,245,123,54,129,200,92,
158,241,90,249,211,254,47,164,50,42,59,15,66,5,7,10,253,191,234,167,75,93,229,
148,220,180,244,180,149,21,187,47,110,238,28,81,169,199,209,165,80,198,197,81,
145,115,79,76,166,111,61,252,149,9,21,66,131,32,225,135,170,247,63,79,106,94,87,
42,42,131,166,35,137,42,218,101,101,106,87,143,65,102,91,1,134,204,210,211,205,
22,38,92,97,159,33,82,39,166,143,239,241,205,79,11,199,20,84,117,54,171,242,81,
84,253,180,226,94,98,100,184,101,186,91,223,136,12,162,131,207,167,86,73,17,
200,45,80,7,203,246,116,28,103,118,45,118,221,220,20,216,244,146,147,48,107,82,
170,74,100,89,124,69,196,65,144,199,87,230,251,100,167,169,49,176,146,193,191,
64,44,44,20,251,107,195,163,250,215,203,165,9,112,30,50,196,21,167,250,177,212,
157,229,29,93,60,20,62,122,156,125,76,147,83,210,84,66,113,149,112,85,120,168,
100,142,40,227,130,165,162,103,148,0,240,53,188,140,110,65,181,135,214,242,97,
70,163,95,245,121,245,88,10,147,128,70,79,17,254,14,176,234,138,130,56,134,70,
138,89,226,156,220,20,150,34,208,50,200,3,76,74,249,16,162,216,241,193,36,11,
113,127,117,245,234,202,75,57,42,220,63,159,73,186,249,96,116,169,158,35,45,165,
6,68,89,130,94,102,214,34,140,160,187,13,36,173,207,233,36,125,46,7,182,25,
127,97,233,66,147,240,176,235,185,197,59,80,227,93,107,217,100,55,73,32,148,134,
136,189,212,50,162,40,89,64,93,86,179,49,6,199,159,109,181,75,40,3,29,106,153,
110,164,99,234,226,164,173,16,71,82,161,76,110,96,168,106,88,154,68,4,35,84,60,
203,102,87,42,65,43,168,144,5,189,184,56,154,113,234,173,145,66,63,213,246,245,
42,90,204,88,240,69,81,40,170,68,163,145,160,20,230,157,132,77,54,178,32,150,
68,136,121,88,59,18,9,103,176,54,22,2,222,237,219,138,210,148,255,0,15,85,163,
85,153,86,134,191,234,63,179,166,98,40,160,164,47,72,245,107,36,176,49,150,39,
42,33,85,102,94,52,233,6,64,16,127,135,62,252,2,133,36,113,167,87,44,218,191,
163,90,127,171,243,233,87,140,204,77,19,99,158,40,68,111,20,209,121,90,18,30,87,
103,168,132,144,35,151,84,113,0,139,232,22,55,189,201,63,65,120,254,37,96,191,
234,175,77,184,61,192,159,245,80,244,178,138,170,182,179,53,70,213,76,201,36,
226,162,149,102,148,52,102,122,57,163,173,20,222,98,190,96,205,20,147,13,54,0,
22,81,113,238,234,73,148,41,243,175,77,224,33,161,205,62,223,49,95,245,122,121,
245,135,39,64,180,41,69,142,13,230,145,62,252,183,147,81,62,57,5,43,206,130,199,
85,217,63,216,146,126,190,235,74,40,7,38,189,89,24,85,154,180,24,255,0,96,255,
0,159,161,97,58,211,119,103,49,187,86,133,161,162,160,47,140,159,44,42,106,
221,210,21,129,150,35,28,210,56,14,175,80,212,177,161,34,195,146,70,175,175,183,
130,62,149,20,205,58,76,110,35,87,144,138,241,167,250,191,62,143,183,95,209,108,
253,159,179,34,167,162,74,25,114,169,145,199,214,209,190,114,72,140,52,57,175,
10,83,73,148,142,98,210,153,234,100,158,25,100,129,216,40,245,128,21,116,220,
173,70,137,83,78,158,236,82,190,71,215,162,137,140,178,62,178,212,92,240,244,
244,232,53,206,111,233,12,52,144,75,12,21,21,245,25,41,105,35,162,152,73,81,144,
146,55,120,106,82,170,52,116,76,84,117,16,72,138,201,58,178,190,159,232,24,159,
116,248,93,69,59,171,211,203,24,40,72,61,180,233,107,68,42,171,41,106,76,178,
210,154,181,168,142,73,154,10,136,163,172,41,52,116,210,79,74,29,38,116,130,82,
222,167,12,173,30,164,12,63,167,181,131,93,41,94,239,217,199,143,72,187,107,85,
61,180,62,71,253,71,165,78,91,43,141,172,172,142,104,243,145,154,151,169,170,
146,171,205,95,5,93,37,61,145,225,53,48,210,202,175,174,142,152,4,82,214,212,
218,135,166,224,123,241,42,90,160,255,0,151,166,194,178,130,10,227,236,255,0,86,
79,64,141,100,123,86,151,117,101,113,103,118,201,43,100,77,52,94,37,171,154,8,
226,200,212,165,44,237,68,222,39,106,101,130,162,57,84,64,162,205,113,172,21,45,
96,156,132,5,151,95,159,243,233,90,153,74,43,136,184,127,130,180,254,93,50,101,
247,37,45,37,28,227,17,144,133,226,74,193,75,58,64,181,143,51,203,74,100,141,98,
151,32,149,0,1,168,48,115,245,23,250,220,143,116,36,5,237,63,236,244,234,70,197,
193,117,58,136,243,255,0,55,65,173,78,103,47,69,159,70,171,169,62,42,169,157,
242,52,57,156,141,77,11,207,136,159,27,142,150,159,16,210,64,106,34,172,199,10,
116,90,88,86,100,212,131,66,27,126,175,109,158,214,32,210,156,115,243,28,43,252,
186,84,17,89,69,7,119,145,2,185,200,175,219,254,207,67,6,35,53,181,247,134,203,
206,97,243,187,119,13,141,144,71,29,61,60,244,242,85,224,151,104,228,82,90,165,
161,48,74,210,86,203,144,146,174,48,177,73,228,243,125,193,81,125,62,253,69,106,
141,52,21,253,159,103,30,171,220,133,106,229,190,126,191,179,162,137,188,58,211,
53,180,51,18,100,104,215,251,217,181,161,164,162,106,188,230,26,138,169,177,84,
89,186,234,33,95,89,182,43,36,40,42,33,173,198,214,235,139,200,232,139,35,15,
79,168,91,218,119,70,70,39,143,75,132,171,34,173,79,119,65,181,70,22,90,201,
218,26,58,57,224,106,138,130,105,224,116,43,44,51,93,204,148,178,43,170,176,150,
64,61,55,28,219,221,72,20,192,234,234,212,60,69,105,159,179,215,166,106,154,73,
168,85,252,113,153,102,141,37,111,25,100,114,160,38,147,169,71,10,65,189,239,
207,31,236,125,181,70,40,115,142,173,94,225,243,167,72,73,154,73,235,154,71,86,
145,157,28,125,80,196,174,90,229,124,71,78,155,22,185,191,180,202,26,166,188,
127,217,249,116,167,1,64,242,29,102,104,132,47,170,234,174,84,48,112,64,33,190,
163,74,198,69,174,71,0,130,45,237,182,227,78,31,234,255,0,86,122,160,106,228,
112,235,20,43,61,109,98,210,198,186,252,135,79,141,158,205,41,147,133,214,126,
154,67,126,56,23,247,100,90,50,227,173,214,128,154,112,235,217,124,238,78,119,
72,26,154,154,133,97,69,130,56,98,137,137,72,163,26,19,81,149,158,229,128,185,
107,2,199,159,118,53,96,8,3,171,34,0,61,107,211,43,84,84,153,21,230,151,91,40,
253,4,36,106,192,17,100,85,2,199,233,248,247,97,80,114,122,182,58,234,108,164,
58,149,227,132,199,161,185,8,125,39,77,136,245,18,110,110,57,227,241,238,197,
242,41,195,175,83,202,189,79,161,206,229,169,164,121,40,164,240,44,250,67,196,
241,197,81,28,138,139,232,118,142,120,221,63,111,81,42,71,32,251,214,169,43,80,
64,234,164,3,131,210,145,115,251,146,88,26,166,108,189,91,107,136,194,222,34,
176,170,83,169,58,195,248,213,80,135,54,22,252,91,143,118,46,105,150,233,176,
145,234,211,167,29,32,42,228,150,162,99,229,145,164,149,220,131,35,57,44,88,155,
27,183,171,139,126,125,167,4,0,73,233,64,30,93,79,74,181,138,6,69,75,15,219,
141,92,2,88,183,171,83,146,126,182,191,250,231,233,238,193,141,9,235,69,122,205,
37,28,70,135,206,141,161,149,244,200,146,61,228,99,98,86,38,85,10,34,185,58,
128,245,127,137,246,224,161,65,78,63,234,253,157,54,26,146,105,166,41,211,44,78,
209,72,170,9,80,27,212,134,196,88,155,146,127,13,101,250,126,125,238,185,234,
254,85,29,78,185,229,209,150,224,233,178,145,244,231,252,79,211,242,125,212,128,
71,14,180,49,214,32,190,114,193,92,9,80,106,81,170,231,210,13,133,239,123,155,
251,214,23,137,199,87,252,177,214,122,74,176,190,72,229,11,114,173,169,77,189,
79,165,128,100,54,186,139,30,108,125,219,136,61,104,245,40,212,82,253,177,1,
138,76,199,73,93,87,85,4,88,149,13,200,38,214,55,191,186,22,162,240,207,90,58,
171,195,166,183,142,23,18,16,73,250,51,89,175,107,158,91,142,7,227,142,127,214,
246,217,227,90,231,171,142,29,122,10,144,136,201,46,162,167,82,130,191,169,189,
67,72,107,130,44,165,126,190,245,254,30,180,124,186,153,52,112,50,183,44,89,
217,36,97,116,96,137,164,122,203,105,212,10,18,69,190,183,247,172,214,190,125,
120,86,156,122,227,246,200,42,52,151,112,65,141,213,165,86,93,75,160,56,0,128,
69,153,126,132,142,125,216,119,96,14,239,229,215,171,242,235,26,192,101,140,
200,90,200,206,218,139,58,128,85,153,128,34,230,224,240,127,7,223,184,14,189,
154,240,234,101,6,46,10,137,180,77,43,172,106,4,141,28,58,89,194,150,64,131,83,
176,0,51,30,120,38,223,79,123,212,213,193,207,90,169,242,235,53,93,30,50,57,180,
171,25,60,113,144,98,67,46,162,222,89,3,89,152,139,168,64,8,227,252,61,232,146,
113,94,182,15,175,80,234,105,105,85,132,96,216,233,5,216,183,8,133,110,166,224,
253,77,190,159,139,127,143,191,86,156,43,95,242,117,226,115,79,78,177,199,79,73,
8,152,187,41,33,19,212,246,144,73,234,12,85,2,242,11,39,210,220,251,241,98,
120,147,215,170,113,65,158,162,75,80,161,221,226,65,10,176,178,168,0,155,127,65,
192,0,31,246,246,247,161,94,182,62,125,66,36,200,196,240,171,123,216,94,203,254,
191,228,218,222,247,215,186,237,20,95,87,246,65,32,95,242,126,162,255,0,79,245,
253,251,200,30,189,214,107,143,200,39,232,5,172,45,201,189,255,0,199,219,139,90,
118,174,126,125,123,172,168,232,169,48,44,65,42,188,27,16,197,88,241,192,38,195,
143,167,189,106,227,83,158,189,246,245,202,57,172,179,0,172,14,131,168,11,125,
20,221,87,81,36,145,111,175,189,43,1,82,122,217,169,2,188,58,194,92,220,88,248,
212,149,60,243,107,144,9,62,159,167,230,222,235,95,78,189,79,157,122,194,210,
185,26,77,141,175,96,126,156,253,79,212,91,223,170,49,90,252,250,215,93,25,26,
91,18,160,179,55,55,60,93,120,245,27,220,128,61,218,170,8,32,144,63,46,183,243,
235,37,152,220,150,36,129,117,183,232,82,120,55,82,167,208,71,28,1,239,88,225,
78,218,245,170,245,255,214,208,101,172,77,192,177,38,230,220,41,176,231,252,65,
63,95,233,238,244,224,120,255,0,134,149,235,195,174,69,136,64,72,211,102,91,88,
155,16,65,252,241,96,15,189,233,25,30,117,235,221,121,155,233,113,117,10,218,
108,120,4,88,92,19,245,95,207,245,247,162,172,64,206,125,58,215,231,215,38,101,
40,138,163,232,14,150,250,18,165,185,22,63,166,196,19,113,249,247,93,38,191,62,
183,214,69,81,107,220,250,109,97,249,39,129,207,31,64,7,231,222,197,0,28,60,250,
247,89,99,84,23,103,85,179,43,42,134,110,0,185,185,191,36,176,35,241,249,62,246,
196,26,83,61,123,174,7,196,218,142,149,93,45,244,12,65,55,63,65,115,123,47,228,
223,223,181,226,148,199,90,62,189,73,68,167,146,70,54,210,182,102,4,57,91,90,50,
64,176,228,2,127,199,221,77,78,107,158,188,107,76,12,245,202,22,167,138,31,33,
43,228,42,197,175,168,51,104,145,46,133,207,234,214,173,96,7,212,253,125,212,
133,193,244,235,198,181,193,235,3,212,174,150,72,225,36,235,81,27,147,233,11,
195,0,224,19,118,96,45,107,218,222,253,64,77,66,254,125,123,52,227,142,177,249,
231,147,74,147,164,7,214,85,0,98,56,3,144,71,42,0,3,252,61,219,78,56,211,175,87,
32,244,225,67,69,27,213,32,153,42,89,110,140,254,51,24,49,171,18,73,112,197,81,
64,65,112,9,230,222,219,34,184,63,207,175,22,166,107,211,228,241,82,36,243,69,
77,5,78,137,98,67,19,75,34,179,59,70,164,175,147,74,186,8,222,120,184,85,230,
252,95,219,169,164,53,20,30,29,55,86,34,164,255,0,171,252,253,70,152,179,186,78,
17,98,102,17,170,60,62,67,175,196,53,204,1,146,238,179,2,108,196,155,95,252,45,
237,211,67,66,7,236,255,0,103,175,10,138,130,73,235,165,149,0,208,38,156,195,81,
40,118,142,37,41,9,63,169,163,144,157,44,242,175,229,215,131,127,126,38,152,44,
104,122,245,43,70,160,168,245,227,212,58,134,164,103,118,132,78,150,66,250,102,
146,61,44,205,32,185,244,47,145,89,239,114,110,121,247,176,65,200,168,7,31,47,
245,124,250,210,234,60,105,83,214,61,66,86,241,211,195,167,82,70,172,183,214,10,
146,124,140,89,239,109,92,0,44,111,238,180,13,64,139,67,233,254,126,183,70,2,
172,115,211,154,83,80,209,25,0,68,171,172,214,61,49,171,138,120,120,6,198,218,
124,173,114,65,60,1,237,214,68,85,169,166,175,229,254,175,159,84,12,228,240,162,
17,249,244,230,77,107,204,74,38,149,168,17,202,33,128,144,143,231,117,135,76,
48,44,159,186,254,69,2,192,19,127,175,191,31,47,78,183,129,196,240,245,255,0,
63,78,148,56,124,164,84,57,57,234,34,140,69,65,79,5,69,64,243,163,84,211,71,91,
83,246,241,222,158,63,36,137,174,77,33,197,181,71,112,90,192,223,222,194,54,79,
144,28,58,163,74,181,80,14,73,255,0,37,122,79,153,169,197,68,177,73,35,149,38,
48,9,34,68,127,221,10,229,27,139,122,121,13,197,199,182,124,49,235,211,213,243,
29,60,101,69,25,146,155,237,162,212,145,34,199,45,136,125,44,178,151,43,33,147,
244,51,35,2,64,252,17,111,109,246,18,104,113,214,178,122,111,158,190,37,105,96,
16,131,12,147,25,35,132,70,134,30,20,141,82,186,143,36,160,3,96,110,109,239,71,
39,28,122,176,28,13,115,211,222,39,33,59,187,198,32,72,161,154,150,153,10,52,
238,34,158,36,119,88,192,31,162,66,178,22,181,185,22,231,222,180,147,90,103,170,
178,140,103,61,44,176,43,58,73,59,210,173,52,50,127,17,199,143,50,180,178,214,
68,162,79,76,86,12,17,197,75,94,218,135,237,128,108,69,253,184,11,173,105,140,
244,219,5,36,2,43,131,210,156,207,91,73,146,71,120,49,177,31,226,121,90,157,94,
42,169,100,86,138,158,160,68,146,37,69,76,176,181,44,114,0,16,168,212,167,213,
127,167,191,42,54,65,167,31,159,250,169,211,109,160,143,62,3,165,44,91,151,45,
69,181,177,184,168,155,26,40,242,57,40,242,85,58,160,103,243,204,209,212,15,43,
130,234,140,35,66,246,86,86,80,228,159,207,183,96,85,138,32,23,204,231,243,233,
153,0,105,89,179,80,41,210,211,33,153,150,155,31,72,212,179,67,76,209,8,93,165,
163,138,16,209,169,137,227,134,52,129,34,178,198,5,128,54,189,191,195,218,160,
69,20,240,233,38,130,100,96,69,107,249,117,202,187,57,147,202,237,218,28,97,
106,92,189,46,67,45,91,59,197,52,42,242,9,35,20,130,50,116,248,101,134,68,46,90,
192,220,14,127,62,222,44,76,97,107,138,215,170,34,4,149,154,154,104,58,201,252,
18,135,59,53,61,54,74,155,6,211,26,122,136,216,230,147,92,134,89,102,140,148,
53,50,209,228,86,72,170,129,210,179,58,121,96,137,219,75,14,8,240,80,73,12,7,
231,255,0,20,122,222,163,29,10,51,105,249,127,197,143,217,210,127,124,245,229,
124,27,126,122,211,143,217,212,180,244,244,83,171,213,237,122,124,173,77,76,82,
120,224,82,185,37,201,233,142,190,140,152,236,146,42,47,133,151,82,105,12,125,
213,227,58,50,0,251,58,114,41,134,176,1,114,73,243,35,249,83,135,65,126,67,5,
147,254,237,82,43,53,45,127,221,87,84,58,67,26,203,252,73,41,150,158,105,233,
178,70,158,43,106,160,175,135,91,194,254,181,210,167,233,199,182,88,54,156,113,
61,40,71,5,206,8,160,255,0,47,14,130,12,165,20,101,66,67,2,44,138,138,210,180,
110,239,230,101,58,9,148,51,21,71,1,125,32,91,143,105,248,28,142,150,33,36,87,
81,61,53,181,13,92,141,79,174,35,26,74,78,145,36,38,215,46,168,196,50,220,90,
246,191,245,252,123,177,174,42,49,213,170,40,79,83,159,9,93,2,18,234,8,18,71,77,
99,24,64,237,41,5,52,22,187,68,24,168,4,155,11,123,246,147,78,24,61,54,101,94,
3,174,49,209,93,226,85,86,86,16,25,27,90,104,101,46,238,109,41,32,106,116,2,
235,111,73,6,252,159,122,225,199,143,87,12,15,248,58,118,161,195,165,74,73,28,
146,72,177,180,45,166,252,179,16,23,74,139,0,46,220,219,241,238,200,43,171,62,
93,54,239,166,149,248,171,210,218,135,99,101,106,171,150,158,130,148,152,86,
124,72,146,166,106,138,88,147,84,190,34,145,145,52,208,198,218,18,109,68,11,183,
35,252,7,183,150,35,85,2,188,122,101,167,69,90,177,205,14,58,51,184,142,191,
219,85,21,184,135,203,103,89,42,105,171,233,105,163,134,130,53,73,29,40,234,71,
144,71,4,177,76,254,41,85,14,153,31,72,91,31,205,189,169,72,193,144,106,106,81,
186,66,247,12,17,130,33,32,142,149,91,170,135,101,227,165,172,131,23,12,20,213,
84,16,7,158,186,104,40,235,107,170,158,166,174,166,83,102,171,242,84,71,36,81,
248,67,0,21,108,183,176,224,251,212,161,85,168,163,133,127,195,211,105,36,172,
181,99,131,233,211,110,247,220,84,211,100,176,248,234,26,202,186,154,120,35,146,
153,204,81,84,210,36,81,199,71,28,115,155,84,145,117,1,52,149,31,182,93,128,0,
142,125,233,171,93,32,224,127,147,175,68,157,140,72,234,22,23,61,184,115,120,
237,195,79,10,202,96,147,112,211,211,99,100,189,53,18,163,194,37,81,27,188,172,
100,125,17,40,36,198,17,22,228,123,242,134,58,128,39,143,217,211,133,81,116,26,
230,159,63,63,179,165,126,200,138,90,169,232,234,170,102,150,178,174,142,8,134,
74,56,140,10,102,163,143,32,138,255,0,107,60,148,166,56,166,137,73,112,204,44,
64,35,85,254,175,160,200,32,247,1,211,50,16,42,167,225,39,161,2,182,158,121,
119,54,118,175,27,83,64,180,176,215,229,17,34,200,87,208,67,164,104,10,133,193,
153,73,30,50,84,144,164,177,32,1,237,227,33,86,114,90,189,38,0,20,64,160,215,29,
119,85,79,135,199,229,36,104,170,240,240,82,82,207,48,90,58,83,3,37,57,118,87,
34,24,228,121,161,87,71,210,228,235,212,172,191,131,239,64,169,238,24,29,122,
173,77,44,9,99,231,208,119,151,194,224,162,202,156,149,63,241,10,169,235,42,38,
155,238,105,233,169,5,32,168,89,5,76,85,80,71,3,24,229,100,117,23,39,75,155,125,
125,212,162,228,142,61,58,178,53,2,249,127,63,78,185,46,108,38,54,170,40,50,15,
79,76,34,164,165,172,164,153,90,42,193,45,53,108,140,94,122,74,90,89,104,164,
82,106,75,72,210,159,32,38,229,173,111,109,212,12,106,24,234,226,62,245,109,53,
173,115,254,175,179,29,37,183,61,52,248,156,188,21,18,228,113,212,145,212,101,
32,167,124,134,11,53,65,184,37,129,100,142,138,89,234,42,233,41,26,83,45,60,
113,173,221,64,213,168,104,35,80,247,230,5,116,181,64,169,226,13,122,242,62,181,
3,73,52,28,24,17,252,253,122,97,160,206,84,37,61,66,195,82,97,142,12,172,169,
71,95,21,226,149,103,21,173,80,60,107,120,254,220,74,135,82,255,0,67,199,215,
222,171,230,72,211,211,206,0,226,59,169,251,49,211,118,71,51,89,247,219,146,58,
108,180,225,171,226,161,168,153,219,238,146,89,204,15,21,66,199,80,137,51,193,
81,32,168,127,40,50,13,72,226,234,192,147,122,187,29,71,56,234,232,40,169,84,
254,125,8,81,213,83,110,186,202,10,188,205,95,241,28,142,46,106,138,56,29,133,
117,71,150,157,41,82,174,158,73,171,43,34,215,79,87,73,43,106,141,117,24,138,
106,224,146,15,187,57,212,160,145,94,238,170,11,41,52,20,26,124,233,251,58,6,
106,246,178,154,157,195,88,212,236,198,162,77,17,83,145,34,20,146,162,105,244,0,
218,4,13,228,102,58,20,49,98,1,227,233,237,133,64,4,141,78,148,234,169,141,106,
62,125,3,57,93,135,53,5,52,245,118,242,85,204,202,52,234,102,48,136,37,49,202,
129,44,164,9,68,128,144,65,32,143,233,237,49,142,128,211,143,74,12,133,168,13,
41,212,10,252,13,73,145,89,162,128,36,116,113,63,249,58,23,102,253,176,200,242,
13,17,192,142,110,109,115,125,34,254,219,116,5,178,190,93,90,54,242,106,214,
189,35,104,41,217,171,229,122,105,188,146,88,35,120,88,187,131,43,105,210,21,
149,9,32,3,200,31,239,30,244,22,180,30,93,60,112,188,58,105,173,132,137,228,14,
36,109,50,149,98,203,41,146,195,128,202,132,223,77,191,55,227,253,111,117,248,
65,173,106,63,212,58,216,224,58,149,46,26,185,226,128,165,12,146,67,34,122,10,
129,114,85,142,146,91,80,84,54,191,215,222,202,133,69,98,48,122,208,97,82,43,
158,163,46,221,172,118,66,104,166,85,18,128,198,67,8,10,151,58,135,145,230,11,
112,127,54,246,219,72,163,135,78,10,158,28,58,122,166,192,85,200,140,106,5,45,
37,60,47,226,105,100,145,221,238,163,157,1,5,136,22,181,192,183,182,154,224,80,
105,21,39,173,132,245,39,169,204,184,26,24,205,61,67,138,150,144,5,140,203,28,
139,8,118,181,167,180,83,42,148,140,31,165,218,231,235,237,173,83,57,56,237,175,
91,237,21,167,30,145,21,72,169,82,82,146,158,87,44,94,56,164,84,213,228,102,99,
101,69,102,37,13,143,248,155,123,112,130,181,14,220,58,218,231,169,227,9,151,
120,169,42,36,164,211,19,7,148,153,167,133,16,248,202,151,140,42,200,196,72,215,
227,139,146,125,212,92,70,42,160,212,255,0,159,175,20,38,190,157,78,251,42,160,
178,197,49,167,70,86,243,164,107,87,19,235,89,35,101,10,196,187,122,212,30,126,
150,247,177,115,24,0,1,192,250,31,207,170,152,205,106,41,195,164,227,208,76,236,
169,227,66,199,77,143,144,159,75,146,170,204,21,74,196,137,164,220,155,15,207,
187,120,160,130,117,227,175,81,129,225,214,99,139,173,81,11,147,78,68,146,52,64,
137,150,70,12,17,164,245,162,166,165,143,211,96,109,98,79,189,137,106,113,39,94,
35,228,122,104,125,110,222,152,206,176,194,234,57,191,244,244,143,201,246,225,
98,51,80,122,245,58,200,72,144,47,14,140,47,107,145,96,44,53,114,0,176,247,160,
244,169,35,29,110,159,60,245,194,69,4,2,5,172,183,5,143,214,231,144,56,28,123,
245,117,18,43,142,189,214,36,184,28,22,23,42,9,81,233,35,234,111,123,92,143,116,
199,167,94,235,34,17,107,56,36,255,0,176,31,139,128,63,22,35,222,199,173,58,247,
89,132,138,13,236,121,210,203,115,200,32,11,113,127,161,183,189,208,113,206,
174,171,74,1,230,122,119,138,180,249,101,146,115,36,250,213,191,68,190,50,28,
196,171,30,146,7,9,17,183,0,1,110,56,247,173,39,128,235,196,112,29,65,188,90,65,
70,144,182,150,91,53,181,11,240,196,50,141,58,13,249,22,247,234,154,19,78,183,
214,24,167,104,141,213,75,21,112,194,220,148,210,194,204,162,214,12,7,31,236,
125,239,73,52,225,158,183,229,242,235,53,93,98,79,80,93,140,196,159,163,76,81,
158,247,111,212,202,171,123,3,253,61,239,73,32,83,35,170,140,14,162,179,1,126,
65,253,86,177,224,14,0,189,237,123,219,223,138,208,103,171,117,136,220,240,79,
211,253,183,215,240,63,31,79,117,167,94,235,139,13,77,168,150,63,75,255,0,91,90,
199,155,143,126,199,144,199,94,235,178,69,180,6,181,216,250,64,38,255,0,215,253,
230,222,246,5,13,72,235,221,113,23,208,190,162,160,9,15,234,252,139,92,5,254,
207,4,127,175,239,85,253,157,120,82,191,46,185,222,230,247,26,108,8,36,243,244,
181,175,244,6,254,252,73,60,79,94,167,237,235,178,66,157,32,45,244,32,54,0,173,
197,174,72,183,44,15,231,223,135,167,87,90,28,117,193,77,216,220,0,214,32,29,90,
127,4,91,143,201,28,123,215,94,32,230,157,113,146,77,55,3,253,99,110,57,28,30,
127,167,191,117,74,124,186,142,28,159,199,250,246,247,238,183,212,149,4,144,94,
225,117,129,97,198,147,110,45,166,247,182,159,126,249,142,189,246,112,234,80,
104,68,101,66,27,183,212,241,113,102,7,250,105,183,248,127,196,251,223,231,215,
171,242,207,95,255,215,208,182,42,81,33,44,99,54,228,147,234,0,105,253,199,86,
85,189,137,95,165,200,247,176,196,126,93,107,206,131,143,82,99,165,134,101,155,
74,181,188,170,201,169,143,145,131,59,5,138,53,7,212,63,38,246,254,190,237,90,
134,63,103,90,62,93,112,251,53,116,103,104,145,66,43,51,51,91,75,49,123,21,13,
171,212,194,252,105,231,222,215,32,10,245,226,124,129,207,88,103,167,150,18,170,
240,148,214,52,160,43,164,169,123,50,130,188,30,65,22,191,251,15,116,97,78,183,
81,228,122,204,41,222,101,101,88,189,104,20,178,47,44,204,0,66,227,146,197,137,
230,192,123,167,117,42,0,255,0,87,14,183,143,94,160,104,101,83,25,70,13,25,36,
234,4,29,39,234,8,32,5,231,222,198,174,38,148,29,123,236,235,14,145,103,250,92,
234,250,115,96,8,183,7,159,175,244,247,177,229,94,189,249,245,231,10,20,122,128,
244,58,145,250,141,195,11,3,244,181,195,127,188,123,181,86,156,51,215,186,227,
30,146,64,224,49,45,234,63,64,10,241,245,176,4,176,191,186,130,71,14,181,214,
84,102,4,95,245,71,98,66,149,5,205,192,31,81,96,66,155,92,92,251,221,71,167,94,
234,84,38,210,121,162,186,248,157,164,6,93,36,58,160,212,232,88,6,80,246,111,
161,226,222,245,92,245,162,48,65,244,233,230,22,130,120,127,92,101,18,75,177,
177,138,174,71,149,79,237,67,29,218,47,183,132,2,117,27,49,191,231,233,238,224,
118,255,0,170,189,83,35,135,237,235,41,175,121,105,99,243,178,165,53,20,75,75,
28,50,37,150,125,83,180,206,86,96,141,34,212,74,204,116,53,180,141,63,143,110,
169,237,4,156,83,254,47,175,105,21,39,241,28,245,58,186,58,58,88,169,17,140,173,
93,49,142,172,66,230,6,166,166,71,212,124,0,197,38,191,184,100,60,171,170,149,
181,185,189,253,221,244,0,163,241,31,245,83,29,54,140,236,198,128,104,24,249,
159,159,73,249,101,100,168,1,103,208,171,57,32,68,74,233,4,122,92,220,38,150,
255,0,5,39,213,123,251,108,213,8,56,193,255,0,87,251,61,59,74,130,8,193,235,29,
61,47,222,84,60,41,60,20,202,177,188,146,84,213,74,177,195,28,42,235,169,141,
193,146,119,245,122,81,3,59,31,160,247,94,36,210,159,63,65,159,231,215,137,43,
228,79,217,211,220,18,99,169,18,244,206,198,50,166,6,150,98,62,238,103,143,213,
231,241,50,133,130,157,205,172,1,37,127,196,251,121,10,128,74,215,143,237,249,
252,186,104,134,106,134,31,230,255,0,103,172,146,153,85,152,69,2,152,21,149,9,
60,201,227,98,24,55,164,93,152,183,212,253,62,131,221,156,224,156,83,173,175,
12,241,234,83,209,179,228,18,153,164,209,81,41,138,63,221,1,4,38,56,24,200,158,
147,96,86,214,55,177,95,241,247,89,10,249,113,199,94,82,64,36,140,117,146,150,
178,74,10,185,195,83,211,213,60,75,226,36,179,51,70,124,209,6,48,146,16,75,36,
168,129,65,33,189,55,247,160,225,42,199,211,173,178,7,2,134,157,67,72,69,85,99,
148,164,168,152,71,173,100,2,193,124,55,104,144,137,64,88,98,106,125,99,210,88,
221,172,61,163,150,96,70,24,5,234,224,28,112,233,254,163,108,75,60,244,128,215,
83,44,18,134,149,65,19,26,136,84,36,111,166,104,66,160,77,105,99,117,213,207,
210,254,210,253,82,141,65,80,234,29,92,47,175,78,43,130,163,166,199,227,165,169,
167,130,165,223,238,227,62,116,180,172,145,159,218,72,225,105,1,88,213,95,234,
120,191,182,69,251,51,50,42,1,74,103,143,86,17,249,146,105,214,122,76,102,222,
62,6,19,197,76,194,40,139,153,36,72,138,122,88,218,53,12,3,29,124,127,94,47,
237,167,185,185,161,160,63,151,87,84,140,241,61,54,26,216,169,178,69,205,99,49,
142,178,18,242,192,89,166,111,19,40,243,43,34,168,119,39,144,64,250,127,143,189,
254,163,37,114,13,60,250,245,16,53,9,237,233,230,183,122,81,73,35,10,134,70,104,
5,74,195,44,52,171,12,172,242,60,133,158,164,29,45,44,206,237,102,98,73,35,
155,123,212,105,112,153,14,217,226,43,95,217,215,156,68,223,135,253,158,158,49,
123,170,137,41,16,67,94,180,177,75,145,73,37,37,153,94,34,32,241,106,123,131,
233,64,214,1,70,158,79,183,214,75,165,237,50,181,41,229,211,79,28,76,65,42,43,
79,78,157,164,202,227,170,233,170,100,130,166,168,75,37,109,210,88,228,150,74,
217,26,53,102,80,241,6,144,152,153,65,0,175,224,253,5,189,220,79,112,40,12,166,
157,80,197,25,53,208,56,117,46,151,176,115,148,203,140,135,29,89,44,127,103,75,
93,53,52,94,37,188,66,90,213,50,153,188,145,161,144,200,129,110,196,146,186,77,
236,61,170,91,171,133,31,218,87,166,141,172,77,172,178,100,244,241,93,217,11,90,
176,213,86,175,223,100,102,90,119,73,74,248,92,152,218,40,228,146,63,18,203,27,
105,17,19,168,147,234,252,123,88,183,128,173,89,40,127,151,251,29,38,54,97,72,
10,253,157,10,231,116,98,38,196,79,141,130,165,233,106,107,169,37,154,138,177,
230,134,58,103,241,3,60,180,121,42,120,152,248,103,244,122,100,49,216,139,113,
123,143,107,67,134,24,108,116,143,194,104,206,162,42,7,151,159,218,58,121,131,
248,117,102,50,178,8,104,241,81,228,106,167,95,186,147,31,233,119,127,15,237,26,
48,135,68,226,53,189,189,26,85,127,3,159,126,20,161,56,234,167,46,172,65,63,
234,254,93,3,121,45,135,135,197,205,92,33,172,201,67,48,152,180,175,61,45,52,
160,26,180,139,85,44,138,101,100,95,13,137,71,10,174,117,16,215,176,246,217,64,
24,154,244,164,74,236,170,116,15,231,212,77,205,180,177,209,97,240,194,28,140,
52,72,230,162,64,178,211,79,174,53,142,72,131,48,8,102,244,94,198,196,139,92,
143,233,238,228,46,149,161,242,235,73,35,106,122,166,107,210,118,93,187,139,172,
162,168,90,172,147,76,35,150,149,163,122,72,92,79,84,73,43,162,23,42,124,97,128,
28,233,46,110,0,250,223,222,180,171,41,234,197,152,82,139,251,122,109,198,109,
109,177,46,229,120,163,203,212,205,69,121,205,52,115,208,65,140,241,210,83,198,
60,127,113,28,115,87,159,34,55,165,152,220,189,174,121,107,10,132,93,121,61,89,
164,117,139,10,43,143,157,79,79,116,181,27,23,27,61,69,55,220,214,61,96,69,129,
42,229,163,172,74,125,82,72,166,161,17,34,165,16,58,115,160,51,0,52,242,44,125,
236,104,21,30,127,97,234,132,92,26,16,162,158,152,233,127,183,107,240,248,202,
204,132,171,29,61,89,164,155,29,174,160,83,60,163,193,247,41,25,16,75,41,72,195,
19,16,179,3,168,95,250,31,110,161,1,199,76,74,36,100,0,240,61,79,204,230,235,
23,54,211,208,82,37,26,140,201,43,175,201,52,176,185,145,31,212,10,20,15,18,
183,249,179,96,20,94,231,243,231,98,36,98,63,139,173,162,169,142,149,252,61,49,
230,171,107,178,59,151,35,44,245,105,81,43,100,93,204,147,197,166,31,36,17,6,
167,142,90,101,208,20,72,5,208,183,2,220,254,61,250,79,237,91,210,189,90,53,2,
37,162,249,14,148,248,204,94,70,191,116,97,42,230,31,123,150,173,129,217,35,
146,174,56,210,71,120,45,28,162,72,217,244,9,46,47,19,105,32,139,112,79,187,40,
118,113,230,221,81,221,22,38,81,132,31,234,207,74,28,85,46,110,6,52,82,99,98,
251,133,174,172,169,19,73,34,67,20,210,57,152,249,140,242,104,138,2,172,8,23,
107,89,44,121,247,122,56,198,145,90,255,0,168,244,219,20,227,171,20,233,105,177,
40,106,43,95,28,179,85,226,177,82,203,80,148,174,12,200,76,250,170,26,79,213,4,
51,193,12,112,66,29,206,162,151,54,228,243,238,241,10,182,104,14,58,110,83,134,
162,147,231,214,93,253,142,24,172,230,82,156,86,83,84,52,153,12,178,65,54,54,
140,53,30,86,9,32,45,228,151,91,76,177,229,139,18,60,113,182,151,22,62,155,31,
118,149,10,57,26,170,63,213,252,250,110,39,241,17,73,95,33,254,175,179,168,63,
105,45,124,89,8,96,174,120,39,175,146,105,105,233,35,111,37,109,53,93,27,17,44,
115,211,152,11,199,37,76,119,81,205,137,183,4,253,40,170,72,52,61,199,246,245,
226,193,72,39,135,242,233,25,95,67,81,77,246,205,61,77,96,133,164,105,88,48,2,
109,81,217,200,64,172,77,219,149,39,129,239,90,91,133,113,235,211,129,129,4,1,
158,156,241,180,56,191,50,253,179,151,146,170,74,112,194,174,118,71,127,43,130,
52,163,58,211,204,1,26,138,235,4,218,220,155,123,214,144,48,13,79,94,36,208,
215,203,166,202,188,75,208,86,172,38,55,17,45,124,243,53,36,145,180,44,234,145,
187,164,208,170,163,221,165,0,50,171,88,220,216,251,245,74,212,31,94,173,151,21,
245,29,37,41,150,90,172,188,162,76,108,222,20,205,137,39,138,58,102,146,148,125,
210,199,37,58,180,205,201,105,24,53,193,210,15,248,113,238,181,44,192,17,138,
244,249,20,143,136,39,79,159,243,233,227,51,92,49,149,181,104,216,245,211,54,50,
56,190,222,41,230,251,88,102,18,35,126,237,59,106,40,232,19,87,234,2,255,0,75,
251,117,142,145,77,30,71,166,66,150,81,158,149,180,155,194,141,41,86,36,85,166,
150,41,41,42,100,142,158,162,162,154,173,229,24,215,129,204,96,249,227,123,44,4,
220,241,238,197,192,136,246,210,134,184,233,177,17,215,90,249,30,35,231,94,149,
152,238,194,169,163,219,109,87,4,179,76,179,28,124,63,109,151,74,42,237,36,212,
153,63,99,76,42,47,164,222,230,236,164,123,216,144,248,18,83,35,231,78,172,168,
30,85,174,8,244,232,16,171,254,236,77,142,122,124,149,28,181,21,47,91,145,150,
72,158,166,162,154,113,44,179,5,137,85,195,13,62,89,133,207,165,184,62,209,81,
79,17,158,151,85,235,138,82,131,160,251,124,83,201,78,162,138,47,36,211,183,
138,141,96,161,21,21,0,42,199,26,38,185,218,8,3,128,125,34,234,166,223,143,108,
202,172,26,157,41,133,151,77,79,14,57,232,30,151,105,103,49,235,53,116,152,188,
204,97,97,134,82,242,82,150,136,71,43,170,235,242,165,194,175,142,230,252,255,0,
176,247,80,140,50,84,245,111,20,18,86,163,77,122,106,134,158,170,42,201,76,31,
115,165,116,95,200,87,196,29,245,8,238,172,116,155,128,74,129,201,183,186,82,
133,142,122,116,176,210,5,115,212,250,188,198,66,69,167,49,184,9,21,59,198,22,
192,179,73,16,5,72,4,0,30,66,151,181,184,30,244,197,89,50,216,234,168,129,73,32,
102,189,114,73,55,35,83,121,18,85,97,96,66,203,225,66,68,150,253,58,34,187,243,
201,185,191,180,218,35,39,47,158,157,213,164,129,167,166,74,202,125,200,242,201,
18,34,188,186,244,201,60,101,164,141,93,142,179,35,73,45,210,37,83,199,226,199,
221,79,132,141,90,142,174,9,96,15,151,80,23,11,90,38,121,43,204,83,178,95,89,50,
74,85,136,81,164,235,96,142,67,95,241,199,31,225,237,179,50,224,87,173,132,39,
20,199,92,222,150,170,86,125,62,56,81,37,94,35,102,80,174,200,109,226,70,179,
122,71,212,155,17,238,174,241,145,82,58,176,12,58,148,41,43,68,106,124,101,212,
41,101,214,226,218,84,217,138,168,99,127,167,244,246,197,86,167,29,94,134,157,
98,146,89,160,188,197,85,66,5,12,67,27,5,109,74,53,133,82,87,213,199,62,246,20,
28,87,61,107,81,29,96,147,39,60,9,174,50,171,63,23,1,175,192,224,31,241,255,0,
31,119,240,84,154,30,7,173,106,61,64,124,140,172,254,73,34,26,152,50,134,95,
208,9,42,64,33,72,252,243,254,191,251,31,118,240,133,8,28,58,216,98,113,231,215,
105,146,68,62,170,120,24,144,182,10,1,113,166,226,228,58,159,81,98,126,164,251,
169,137,177,147,78,182,77,1,173,42,71,92,154,182,153,229,36,70,99,180,96,42,144,
168,164,139,126,175,75,47,3,142,7,62,252,21,151,241,214,156,122,209,11,228,49,
215,19,52,45,16,89,41,161,145,148,221,94,202,91,212,223,91,169,23,34,214,191,30,
237,144,198,173,214,169,215,57,105,96,63,72,133,206,130,163,155,55,215,93,137,
107,223,241,192,252,123,178,191,85,61,67,146,146,34,142,52,74,52,3,98,6,160,28,
90,215,22,30,147,244,231,219,160,154,147,231,214,191,46,155,36,140,163,42,150,
227,139,41,4,88,94,224,31,73,183,63,155,159,118,30,127,103,94,235,202,93,124,
165,191,206,112,46,164,250,121,179,16,64,183,3,143,126,12,105,131,142,189,199,
174,74,90,204,88,2,47,96,65,95,199,208,114,65,230,255,0,236,125,236,30,56,235,
84,198,58,245,227,97,123,50,218,192,155,142,27,250,216,95,130,127,226,158,253,
168,250,103,171,83,24,235,139,155,149,82,25,181,114,11,32,185,36,255,0,91,146,
127,219,251,217,35,61,106,132,245,192,223,139,16,109,244,227,129,114,46,63,22,
60,126,61,232,102,190,157,123,135,94,0,125,127,192,241,205,185,63,226,73,227,
222,184,158,61,123,172,130,50,71,234,11,126,71,35,253,228,90,246,255,0,99,239,
216,30,95,234,255,0,7,94,235,17,98,134,246,45,127,169,97,97,170,220,88,143,193,
30,237,128,48,40,71,94,235,131,72,20,41,189,201,213,168,127,91,177,60,141,67,
80,31,95,117,36,117,236,245,209,98,223,215,145,127,167,38,214,36,159,205,135,
189,117,238,178,170,240,14,146,199,139,176,185,0,27,114,72,55,181,189,251,171,
12,87,175,8,139,126,146,64,250,139,254,77,237,165,110,64,102,35,223,128,39,61,
107,86,63,62,184,50,29,70,198,223,240,110,13,255,0,34,192,126,61,251,175,19,154,
245,224,140,74,130,64,28,1,110,127,32,91,142,111,239,221,107,169,49,64,133,217,
89,200,5,88,131,244,213,167,145,123,94,220,15,123,167,12,245,162,198,181,234,
71,218,70,83,90,150,37,86,238,117,45,130,31,211,98,23,131,126,9,63,147,239,94,
93,122,167,175,255,208,208,202,54,13,161,145,217,66,178,254,79,55,125,37,64,
185,189,193,230,255,0,143,122,205,113,213,78,43,65,214,117,155,91,72,142,195,
235,33,95,24,0,220,62,171,178,128,61,55,28,125,45,127,118,255,0,77,215,189,43,
199,169,113,207,7,133,166,85,34,160,154,139,167,141,76,42,140,177,105,40,93,228,
58,238,205,112,85,108,62,134,254,252,52,249,240,167,94,52,168,52,235,16,48,22,
103,150,51,161,81,194,248,228,12,201,34,34,20,101,215,114,2,187,115,170,252,112,
45,239,84,63,234,253,157,108,142,29,121,224,101,138,23,142,86,107,194,179,42,
201,165,37,0,159,220,100,32,40,118,14,120,177,252,31,175,189,87,60,49,214,215,
204,30,177,164,101,131,44,170,2,36,114,161,12,150,144,163,18,86,71,114,88,181,
157,137,252,219,233,244,247,66,196,30,225,215,188,143,81,106,113,222,22,96,211,
45,214,195,74,147,109,44,129,238,73,31,70,7,143,175,215,222,245,84,129,167,29,
111,174,50,82,133,132,48,213,118,39,95,161,2,131,35,48,93,14,93,131,0,170,47,
244,177,227,223,149,193,2,188,122,241,167,30,161,125,187,35,5,101,112,218,180,
254,24,18,64,181,128,183,4,31,235,238,224,130,56,227,173,117,129,227,104,202,
234,254,208,13,192,36,139,219,143,199,34,254,253,215,186,224,206,235,112,67,11,
147,233,189,133,191,38,220,129,113,239,84,7,143,94,235,58,203,101,23,12,57,22,
31,218,183,214,223,91,145,123,123,245,79,159,30,171,138,224,117,153,106,93,124,
154,91,137,35,40,197,149,93,72,114,70,161,175,86,145,207,36,88,251,245,122,245,
7,14,164,125,221,214,32,193,142,144,214,245,130,18,80,120,145,120,214,65,7,
155,146,79,245,247,109,84,166,163,81,214,180,241,43,199,174,150,236,99,137,21,
53,234,26,75,129,114,8,214,197,137,60,88,254,127,35,222,181,130,56,100,117,186,
102,189,73,251,121,24,70,85,131,220,90,202,8,123,43,131,125,7,145,107,253,111,
98,56,247,98,196,159,67,74,117,92,214,157,101,49,146,170,100,102,45,28,140,44,
168,173,98,164,17,228,212,201,165,75,112,127,195,241,239,85,174,9,61,108,10,112,
233,194,148,207,13,244,29,84,236,193,92,29,40,209,32,58,137,140,146,88,182,179,
250,126,150,246,234,154,80,30,181,249,116,255,0,145,74,89,84,214,15,184,142,121,
37,19,44,172,44,12,78,124,109,97,234,70,212,127,81,255,0,15,175,187,62,140,159,
62,170,160,168,3,24,235,12,116,241,75,41,50,10,95,182,20,44,101,96,147,121,81,
34,141,228,105,149,17,174,103,5,45,203,114,61,151,203,35,83,72,168,167,78,1,
211,150,218,175,137,230,134,73,138,36,117,80,253,188,24,250,102,241,34,201,9,43,
12,146,22,87,33,164,116,26,64,185,63,83,254,40,110,11,32,109,39,35,36,245,125,
1,177,231,214,45,207,146,171,243,82,62,165,73,34,134,53,136,218,236,1,244,32,
153,172,154,166,1,121,60,2,44,61,222,214,32,218,141,8,4,215,170,224,96,116,195,
62,97,213,33,90,135,154,162,69,30,34,128,178,88,152,193,40,101,36,40,80,71,250,
246,246,242,194,13,72,20,29,111,60,65,199,81,23,40,238,2,69,18,66,170,136,73,99,
169,174,53,127,104,220,155,147,237,241,2,12,181,107,214,181,30,53,234,49,200,58,
74,238,101,167,144,220,155,24,216,243,197,137,107,134,224,143,234,125,187,162,
62,26,69,58,245,79,77,149,53,83,84,76,207,100,77,87,184,140,241,207,39,245,41,
97,239,196,47,146,128,58,247,94,138,187,199,18,192,242,75,38,137,67,149,191,
166,195,142,65,209,235,183,189,128,61,51,215,186,119,74,138,18,133,81,43,41,75,
75,97,32,149,89,153,52,31,77,149,217,173,192,181,190,135,223,180,158,30,125,87,
35,61,40,41,165,240,179,54,63,35,52,178,71,141,8,60,146,152,230,90,118,117,19,
194,186,196,176,232,42,108,65,95,205,239,199,189,149,212,0,167,14,180,60,207,
207,203,169,137,150,72,42,81,107,168,209,22,24,162,140,186,25,60,136,186,15,62,
120,36,17,131,37,249,37,69,207,227,222,244,0,105,192,87,253,89,249,117,224,79,
30,135,12,50,225,178,216,138,150,162,85,168,47,68,234,243,153,23,238,169,81,99,
44,146,179,159,30,184,100,42,84,135,189,236,56,35,159,106,162,10,170,77,127,
213,254,207,73,220,18,234,52,249,249,116,178,194,100,178,24,13,191,68,240,96,
158,190,153,90,116,135,43,139,172,167,243,70,239,19,152,229,202,137,153,133,21,
66,137,141,172,165,28,88,0,61,233,166,8,132,3,92,245,95,5,157,193,35,166,172,
174,231,171,147,26,149,89,74,31,44,142,240,181,116,230,106,116,12,26,169,150,
154,35,77,24,136,48,189,196,166,226,252,16,87,218,115,123,90,138,231,203,29,56,
45,66,129,65,219,246,244,227,187,221,230,161,197,169,131,13,75,76,210,85,67,76,
40,196,242,136,83,197,29,65,136,197,52,242,181,83,157,22,214,36,85,191,4,126,
125,232,95,225,42,1,52,251,58,216,180,29,217,63,234,255,0,15,65,248,160,167,168,
242,34,207,77,78,36,132,212,201,247,108,244,162,56,226,100,12,244,73,28,82,37,
69,88,176,33,3,71,96,126,164,251,215,239,10,86,171,143,151,250,135,86,250,80,
105,158,185,210,212,12,94,84,214,212,99,163,154,154,37,144,189,76,70,73,239,16,
93,43,83,44,81,178,201,246,236,5,205,192,55,60,143,106,35,190,136,176,44,189,
39,150,210,77,36,3,254,175,243,245,58,135,112,226,205,60,201,86,100,163,164,
150,120,114,18,213,79,137,168,70,167,81,168,193,28,72,241,75,229,19,72,0,86,229,
72,60,139,123,84,147,70,196,141,120,233,59,219,200,180,42,166,180,167,31,240,
245,54,29,211,183,226,21,210,165,53,20,245,216,250,202,16,107,105,41,234,42,144,
25,102,50,10,148,41,225,163,154,72,149,0,100,241,168,26,143,231,221,196,168,
167,128,36,30,171,224,202,69,53,29,36,121,227,242,245,252,250,84,73,156,199,230,
225,50,206,248,246,160,172,200,102,39,148,25,42,169,62,242,90,52,146,158,25,209,
137,38,158,104,215,73,84,189,223,240,5,237,239,218,245,212,249,84,245,65,25,138,
130,135,85,7,229,231,79,246,122,153,79,128,194,84,85,140,170,215,207,86,147,84,
97,210,10,104,222,57,217,226,150,156,49,154,173,199,129,227,101,149,25,124,103,
81,32,253,125,184,85,89,171,170,188,58,175,136,224,104,211,67,158,157,50,17,81,
199,94,106,169,41,165,167,201,213,206,237,0,150,57,232,69,44,179,173,234,215,28,
41,42,93,102,90,105,65,88,73,40,25,126,169,123,15,123,109,35,33,104,73,243,255,
0,39,90,21,32,2,221,128,125,191,234,249,245,23,5,46,105,234,106,69,27,79,81,
81,29,108,197,34,169,122,170,147,50,198,26,238,180,143,33,71,167,242,43,107,36,
217,77,238,125,233,75,82,160,212,245,185,2,121,224,124,191,207,208,131,142,169,
150,166,134,162,147,31,69,12,18,213,125,253,89,127,181,101,102,167,89,86,71,152,
188,245,82,105,200,197,82,66,71,8,80,165,24,243,237,68,72,243,48,72,98,37,143,
167,73,164,120,225,163,203,37,23,231,254,175,207,167,138,28,134,18,178,130,170,
10,184,234,226,169,173,15,86,101,175,122,104,17,114,21,111,252,61,235,37,172,
240,132,128,198,202,25,105,99,68,101,39,86,166,13,96,98,44,39,240,245,186,82,
162,188,70,15,15,245,15,179,215,164,6,238,49,32,84,126,6,152,7,135,30,30,159,62,
145,249,188,254,15,27,152,19,203,152,57,58,204,76,255,0,107,77,27,165,25,166,
157,133,83,213,172,245,51,209,213,210,212,83,199,28,3,72,215,231,115,172,130,72,
228,22,72,209,196,221,242,46,160,105,196,127,147,253,158,151,70,175,50,246,33,
210,69,120,31,242,138,127,131,168,181,57,45,186,213,82,5,168,172,79,186,200,84,
79,5,60,240,207,12,137,247,145,45,75,253,174,133,116,120,33,146,82,168,121,12,
138,62,191,95,104,230,187,137,25,180,73,81,242,233,244,130,118,21,101,224,63,
213,251,122,207,67,145,166,169,163,130,136,44,9,60,85,66,111,226,13,79,83,45,
114,232,44,176,194,170,41,100,132,64,85,141,248,176,60,241,111,109,11,232,152,
133,98,0,39,143,30,172,240,50,130,244,36,83,229,79,240,245,145,178,56,250,137,
34,73,42,37,141,227,150,88,37,122,122,105,234,82,162,24,252,154,29,162,118,88,
192,12,164,144,170,44,88,251,118,75,200,98,83,169,201,74,122,117,168,160,145,
190,16,42,124,137,235,14,38,125,172,146,82,44,249,122,184,106,170,103,163,18,45,
69,13,77,60,46,222,86,88,211,207,3,200,162,193,126,165,44,46,5,253,233,47,32,
44,160,49,21,60,124,186,187,195,50,169,192,160,244,53,233,179,51,14,30,108,238,
110,9,25,245,199,104,164,146,25,222,73,10,232,107,151,19,92,44,112,149,93,32,0,
198,254,223,55,54,224,157,82,168,167,207,170,4,148,170,159,12,231,229,210,110,
72,104,210,42,186,229,171,170,142,150,146,142,149,107,42,100,166,103,167,142,
162,73,102,165,134,47,184,86,8,25,214,65,233,176,34,254,210,11,229,109,117,28,
64,225,246,252,250,112,192,218,148,126,42,159,240,116,227,89,11,211,109,74,9,
20,185,142,103,89,21,202,21,87,142,25,25,19,67,17,165,154,71,95,165,248,30,213,
125,68,38,16,3,28,158,52,199,84,88,216,74,105,74,142,131,189,50,164,136,106,1,
97,85,84,145,67,230,66,202,242,129,231,96,143,114,202,250,24,146,77,239,238,
128,131,66,13,69,122,83,235,235,211,150,82,158,178,57,230,146,134,178,174,2,238,
178,250,37,142,120,12,145,30,44,39,82,200,5,141,197,205,201,247,182,20,99,214,
148,246,138,142,163,229,114,85,6,58,24,179,195,52,204,248,216,222,248,166,142,
42,121,226,73,170,4,66,117,240,200,143,34,24,198,160,46,8,28,243,238,133,206,3,
3,195,203,171,42,41,215,164,138,131,254,78,128,204,253,45,98,212,153,41,233,
234,234,161,55,145,140,52,181,26,163,242,106,100,18,94,21,212,66,254,126,159,
211,218,57,81,203,18,42,84,244,174,38,80,41,128,122,110,198,228,105,35,165,152,
249,2,61,58,200,52,149,209,44,102,204,178,7,213,99,22,146,69,255,0,175,182,244,
157,53,167,78,182,91,229,211,33,220,48,198,225,226,102,155,75,43,35,49,12,193,
147,144,8,26,163,60,255,0,95,199,186,105,52,173,15,87,167,145,235,45,78,228,171,
172,154,86,138,148,165,216,204,202,140,196,88,175,45,32,123,40,32,95,241,244,
247,227,25,98,65,92,245,165,5,64,29,71,124,193,208,67,180,128,248,86,197,23,85,
228,44,9,185,98,191,65,197,255,0,219,123,96,194,163,214,157,92,18,64,235,140,25,
101,72,229,214,238,198,73,46,165,163,125,74,194,204,75,89,189,90,155,241,254,
223,221,26,31,67,142,182,27,212,103,168,95,196,147,88,102,105,88,92,146,93,219,
245,114,1,26,108,87,235,239,222,19,112,20,234,218,197,122,203,5,108,46,4,69,229,
101,208,232,129,89,64,70,118,103,46,195,74,234,32,253,117,31,167,183,4,79,198,
156,122,214,170,116,225,42,208,213,120,218,78,103,17,159,32,88,213,82,162,96,
127,206,5,12,25,21,199,63,83,118,191,35,221,4,110,184,168,167,248,58,213,71,159,
77,211,208,81,202,231,197,36,112,33,183,34,87,224,139,35,45,164,39,212,173,127,
161,35,221,192,113,196,215,173,214,156,58,108,108,100,68,149,53,112,22,242,44,
72,198,83,251,142,194,192,35,91,147,175,129,237,192,204,180,35,173,84,19,195,
168,115,210,189,44,205,17,103,114,2,114,72,33,117,0,220,16,73,189,135,230,222,
247,90,140,129,214,171,231,214,47,242,128,90,222,155,220,112,204,172,82,231,240,
79,210,254,246,170,167,3,143,94,175,167,89,99,169,145,91,212,36,99,107,150,184,
44,8,55,26,75,112,160,123,246,133,168,161,255,0,55,94,169,234,84,53,234,129,
195,59,130,89,142,151,28,31,206,157,75,125,55,255,0,99,239,218,9,161,165,105,
215,171,212,216,170,233,165,44,38,140,53,141,181,129,175,211,97,202,220,112,22,
254,252,107,74,121,245,238,164,248,177,142,142,8,210,196,168,224,56,82,1,224,
240,192,159,246,214,227,221,1,56,7,175,117,227,138,198,201,19,21,170,101,144,72,
70,128,192,129,107,19,107,130,110,109,244,247,186,145,229,142,189,212,121,112,
208,69,25,146,58,166,102,22,36,13,54,32,219,250,145,239,213,53,24,235,125,54,
201,68,85,67,9,75,11,29,99,74,129,245,32,113,170,228,31,246,254,247,198,135,175,
87,246,245,141,33,136,6,102,103,32,125,44,138,6,163,112,69,136,111,167,31,236,
125,248,122,117,163,214,9,12,104,196,32,107,139,128,77,137,226,196,254,125,239,
134,15,94,235,16,109,68,0,183,230,220,127,82,15,55,253,32,15,126,205,56,227,175,
117,193,145,192,187,18,161,236,120,224,218,199,250,15,248,223,191,83,175,125,
131,172,74,170,90,203,109,64,223,159,165,135,214,247,226,222,245,215,189,58,205,
10,146,73,96,69,129,228,16,120,224,19,111,169,181,253,248,127,46,183,145,92,
117,54,50,165,194,0,116,150,36,146,44,87,130,46,23,243,244,31,235,251,247,151,
94,205,9,30,157,113,121,63,80,185,102,11,113,115,244,3,139,13,35,157,95,155,
251,222,122,208,235,1,231,234,182,55,63,79,160,36,2,57,35,233,99,239,93,123,174,
5,236,109,99,112,127,173,191,223,91,223,186,247,93,138,130,132,48,28,134,189,
203,15,245,238,73,250,158,61,251,207,173,83,169,6,173,131,44,220,216,130,250,
116,89,62,156,169,91,216,141,64,127,135,189,252,250,221,58,255,209,208,141,9,
213,107,3,244,38,252,88,95,143,193,44,111,238,193,43,221,229,213,72,28,79,92,
163,102,89,148,143,245,76,15,37,109,250,174,47,126,65,30,244,86,141,74,117,234,
10,83,175,37,65,142,61,34,246,188,130,192,92,113,226,36,144,87,143,167,245,247,
174,188,71,175,94,146,164,170,106,224,249,13,239,193,58,65,227,73,183,32,31,175,
244,227,223,186,222,63,62,179,61,113,145,65,96,89,163,210,1,55,44,20,159,193,
191,208,255,0,188,31,123,168,244,207,94,7,212,14,185,197,49,102,39,212,9,36,63,
168,134,113,123,141,99,213,99,249,252,15,117,58,77,59,71,90,103,3,169,53,185,25,
42,219,84,230,55,145,127,109,164,72,209,29,226,22,42,8,64,170,204,183,182,175,
173,128,247,93,34,181,28,122,216,36,140,117,21,170,149,145,33,45,166,40,152,178,
35,22,43,203,49,99,109,108,46,73,231,142,109,239,122,124,235,220,71,94,169,199,
111,94,243,41,102,118,125,77,34,130,172,154,108,140,140,182,37,89,65,176,254,
131,250,123,246,147,229,199,173,227,174,50,79,119,82,0,244,0,20,143,73,62,160,
88,19,200,230,220,127,79,126,161,160,207,94,235,203,233,55,58,76,133,193,120,
205,185,91,130,25,69,128,99,249,63,79,117,226,49,240,245,177,78,179,74,176,186,
70,254,61,55,118,45,48,26,67,1,100,72,209,45,98,192,242,79,30,244,53,102,167,
175,80,117,197,177,179,0,67,197,32,83,8,153,92,15,72,67,111,85,219,211,166,223,
94,120,191,189,248,130,162,132,113,234,160,15,203,168,237,69,52,100,121,85,172,
160,58,168,3,81,67,125,47,193,60,90,223,237,238,61,236,48,227,78,61,123,252,61,
77,131,198,178,20,211,164,107,210,27,243,117,141,173,119,110,9,254,163,243,253,
61,248,80,100,30,29,84,131,131,229,214,49,34,137,61,44,86,200,84,0,72,184,86,
31,211,241,115,249,247,97,90,113,235,199,85,48,115,214,119,170,141,35,91,133,
96,1,6,255,0,169,129,107,242,71,171,159,199,191,3,195,215,175,5,197,6,58,151,
73,146,167,19,83,235,2,63,27,70,24,176,215,26,242,229,156,173,137,33,174,47,
197,253,220,53,10,212,96,117,226,166,140,43,196,117,202,171,52,130,74,136,162,
148,84,2,128,64,242,170,203,12,86,155,200,99,8,214,100,10,73,227,143,122,147,
184,140,249,245,160,184,207,250,190,125,112,124,220,245,90,255,0,110,20,144,194,
212,229,161,12,165,227,49,184,101,176,98,52,216,155,159,192,62,219,210,8,97,228,
122,184,192,249,117,151,111,100,226,167,168,163,133,238,141,21,80,43,32,43,113,
174,64,65,5,129,211,99,249,250,131,111,105,231,139,94,163,76,145,195,242,234,
194,157,58,238,58,118,168,150,144,36,102,56,154,134,15,92,158,77,117,19,15,35,6,
140,234,103,144,41,39,81,250,255,0,78,61,238,23,62,126,191,203,170,133,3,207,
207,164,124,226,162,204,205,3,50,197,36,107,173,185,72,201,67,194,234,37,64,113,
207,30,213,7,28,120,245,237,61,97,102,99,33,23,254,200,45,164,139,125,121,31,67,
248,254,158,252,122,247,217,214,39,143,81,91,144,171,99,233,2,220,240,121,36,
234,62,253,215,179,215,2,26,48,66,90,196,19,123,146,121,254,134,214,36,123,209,
235,199,172,3,81,60,241,228,111,171,91,212,111,253,71,2,215,252,123,213,122,247,
248,58,122,167,82,206,132,150,114,165,0,125,103,246,200,5,90,202,151,98,192,127,
79,161,247,163,32,245,235,116,174,41,211,199,240,251,206,99,86,152,63,152,186,
213,68,14,133,88,153,64,75,128,36,70,230,246,54,177,231,252,125,182,38,20,175,
167,207,173,149,20,233,228,84,213,253,225,115,75,36,173,59,73,5,153,157,210,179,
84,102,56,212,177,209,43,105,96,47,115,98,198,196,123,223,142,104,123,252,189,
122,168,140,82,158,93,63,96,160,204,253,181,117,61,29,117,74,69,53,42,26,180,
134,34,168,29,18,72,146,157,157,79,149,74,37,213,185,22,255,0,109,237,179,114,
71,217,246,245,113,24,56,166,122,94,226,42,119,68,120,195,141,141,40,124,109,
93,79,73,9,168,165,6,99,12,58,62,209,100,80,241,181,66,163,160,212,207,173,205,
249,62,221,91,128,202,65,90,245,70,64,15,28,116,199,151,163,222,171,71,47,151,
32,101,147,31,81,81,227,162,164,192,49,89,93,166,121,89,226,34,16,173,1,149,
152,150,144,106,91,126,125,222,54,141,207,195,159,203,170,51,12,116,159,202,101,
183,36,244,216,89,107,159,27,76,107,40,234,154,159,205,79,37,62,154,56,12,35,
238,83,73,66,198,163,81,43,167,131,164,223,233,238,243,65,30,149,58,64,199,151,
90,73,13,92,84,154,30,155,104,115,155,141,146,241,64,107,150,59,83,68,209,84,
73,112,179,21,80,97,96,204,0,147,88,80,214,250,251,96,197,25,243,161,233,223,
16,252,250,233,183,126,66,73,116,100,30,190,50,27,252,162,52,17,176,153,23,210,
21,192,49,186,106,4,134,255,0,85,254,191,187,44,65,48,188,60,186,241,98,213,36,
154,158,132,92,14,252,197,39,142,157,92,65,43,196,105,217,165,251,136,159,237,
136,209,20,1,102,103,138,75,49,181,239,123,126,125,223,245,22,180,0,30,171,165,
91,143,14,167,164,56,140,140,77,69,77,24,133,164,104,211,77,20,146,82,253,195,
179,201,235,153,64,101,100,141,134,175,87,28,127,79,109,75,52,138,115,24,167,86,
17,171,10,235,207,217,212,212,198,79,67,21,5,20,89,10,116,83,83,89,87,106,217,
53,71,32,93,49,90,54,64,169,60,197,69,254,131,221,82,232,249,134,4,30,171,36,0,
119,84,26,142,158,246,205,92,243,102,190,194,157,233,215,33,166,179,33,53,48,
167,87,164,150,58,58,104,218,58,129,56,113,116,149,39,178,88,91,88,63,145,237,
79,214,5,80,196,26,127,168,116,149,237,137,170,215,249,244,33,69,153,192,64,
241,50,154,10,217,195,73,72,26,58,179,81,85,76,36,32,44,79,78,236,143,8,134,69,
32,105,38,75,30,73,30,244,119,8,197,75,53,63,35,254,207,77,11,59,130,70,144,
127,149,15,231,211,28,117,185,138,175,184,169,165,105,168,26,90,153,146,154,81,
32,164,130,88,101,145,86,177,157,196,146,212,42,203,96,10,242,141,111,122,23,
232,99,102,13,83,94,3,167,77,161,12,21,144,126,116,234,95,241,185,198,69,241,
223,199,254,222,12,213,67,203,64,244,141,80,94,130,172,53,233,237,81,80,145,34,
211,73,40,120,203,49,34,235,112,45,207,189,71,124,197,245,171,149,63,229,253,
181,233,169,173,79,131,253,144,98,188,126,99,206,152,233,3,13,101,39,220,214,71,
146,201,201,51,99,90,124,165,111,241,28,156,80,25,222,154,165,102,169,69,64,53,
53,92,145,192,64,0,59,235,176,183,189,25,231,103,106,204,218,206,106,51,95,182,
191,225,234,223,78,186,18,144,168,90,83,3,135,250,189,58,135,185,55,5,6,117,104,
39,195,209,81,195,45,84,117,109,93,5,10,188,164,215,83,206,210,70,3,75,12,65,
99,104,13,227,94,117,133,36,219,219,11,36,178,180,175,113,170,167,207,167,196,
34,16,139,29,8,3,249,116,215,137,236,76,222,223,164,142,42,152,19,43,74,194,68,
161,171,156,22,52,115,200,214,117,80,165,88,60,124,149,86,244,220,254,125,188,
35,86,112,65,169,31,47,219,95,243,244,219,197,172,80,49,0,241,21,255,0,47,78,
71,126,213,75,75,27,44,235,25,150,83,81,4,94,102,138,84,46,91,206,179,60,96,
151,31,211,155,127,196,105,196,65,136,49,102,184,255,0,87,249,58,216,183,98,7,
127,15,151,76,185,93,211,144,157,105,43,105,106,132,98,115,34,74,223,113,63,169,
116,48,49,200,68,160,50,74,172,65,6,203,254,30,212,164,74,208,129,171,187,60,71,
242,255,0,103,170,211,75,0,87,3,166,15,239,174,110,102,167,199,253,203,192,32,
52,166,160,188,144,105,174,104,167,11,4,116,242,89,170,26,43,48,184,213,254,39,
232,44,141,108,76,111,83,198,191,225,233,94,160,84,156,112,235,134,228,222,25,
151,206,238,6,150,142,145,190,230,166,69,170,133,60,198,59,83,58,32,145,24,74,
178,198,76,41,193,4,27,114,57,246,227,218,247,56,200,0,245,88,200,210,191,103,
80,113,189,147,144,163,162,174,164,52,139,60,21,47,78,190,85,154,173,21,99,129,
158,109,15,79,230,120,100,34,64,8,37,65,36,2,73,246,195,91,100,16,231,29,57,81,
252,57,234,71,250,85,202,202,244,80,26,172,141,61,37,21,76,98,130,150,26,153,
238,148,134,164,203,80,166,87,149,226,121,157,173,109,104,192,2,109,111,167,187,
170,74,160,81,205,41,249,126,206,171,225,196,196,213,5,126,206,149,155,127,126,
253,253,114,208,84,100,36,164,166,174,172,112,107,234,36,121,42,41,76,143,227,
79,180,1,140,114,84,52,103,75,43,128,25,77,184,22,30,238,143,42,50,0,217,168,
255,0,87,217,211,111,4,101,88,232,242,234,119,241,41,242,21,217,89,41,50,212,
180,144,208,26,136,42,132,181,145,154,140,132,169,47,137,13,5,60,64,179,234,78,
94,195,74,128,111,207,181,77,124,201,41,71,140,17,95,178,157,52,182,195,66,228,
240,235,37,78,97,214,147,28,36,155,206,96,165,173,19,195,174,19,164,173,89,145,
134,170,111,4,205,33,142,123,144,192,176,7,218,149,186,141,194,154,116,201,183,
112,207,221,198,159,224,252,250,139,152,121,170,231,21,180,25,154,218,58,73,13,
60,82,80,197,162,36,242,125,145,112,194,176,167,221,198,21,129,212,154,136,55,
255,0,97,237,242,85,232,85,205,61,63,217,233,165,170,118,178,85,179,159,207,211,
135,89,54,246,38,146,245,208,164,56,201,30,187,154,170,170,154,120,164,150,105,
221,101,122,131,53,214,77,49,52,80,147,233,31,175,253,127,118,68,4,208,1,83,214,
164,148,138,26,158,145,57,188,22,34,77,115,173,43,173,72,128,65,10,81,58,197,78,
25,47,166,86,72,97,64,159,214,228,16,64,183,182,93,20,131,131,95,151,79,164,
174,41,156,87,166,180,217,50,209,229,105,104,145,162,168,150,166,142,57,91,90,
74,34,85,146,145,165,180,210,233,101,73,15,208,11,93,155,222,132,122,93,105,
156,127,147,171,125,64,100,102,35,129,255,0,47,81,14,6,142,33,106,172,61,89,82,
193,22,170,9,149,227,149,138,2,17,117,41,112,182,250,92,92,144,109,239,90,7,154,
30,173,226,147,144,227,169,16,237,252,36,203,28,255,0,101,88,22,57,157,30,153,
158,47,91,54,159,17,242,34,9,88,234,86,244,155,127,175,239,198,40,219,73,11,79,
217,214,140,238,9,0,142,154,234,177,244,144,212,164,113,224,105,188,76,193,111,
83,53,92,117,16,31,237,179,60,115,152,72,23,191,34,246,246,209,140,106,160,132,
83,167,22,74,173,75,231,172,31,221,186,57,102,47,81,52,184,216,11,8,152,71,3,
213,222,119,66,209,182,187,146,145,49,0,88,220,220,251,217,132,87,141,58,216,
152,121,10,158,61,102,125,151,52,45,42,79,185,182,237,57,137,17,188,82,77,92,38,
49,184,253,77,18,210,144,156,216,5,38,228,251,208,132,143,244,69,235,222,50,
154,16,141,251,58,67,213,227,234,32,146,97,39,168,43,219,82,18,65,23,244,184,86,
245,4,101,228,18,47,99,207,182,89,24,19,81,211,193,129,2,135,166,215,139,212,
173,102,244,146,86,224,16,26,255,0,95,232,121,254,190,235,79,94,29,91,61,77,241,
235,137,180,5,3,210,205,233,28,53,199,234,60,21,250,125,1,177,191,189,99,62,189,
123,174,212,212,68,124,141,1,101,113,97,195,58,112,3,112,194,247,32,27,243,244,
191,189,112,207,85,35,246,245,154,41,3,179,41,130,123,161,14,193,64,208,53,114,
159,130,109,207,3,232,109,239,117,199,207,175,30,3,215,174,107,21,60,161,22,100,
241,182,166,103,107,50,144,183,98,215,91,105,4,15,165,135,244,247,226,124,188,
186,176,167,159,159,92,77,4,72,222,151,101,86,3,198,232,117,135,250,147,123,112,
44,191,242,63,126,44,105,74,117,238,61,100,251,58,146,85,86,88,216,105,190,146,
72,100,245,16,17,130,130,186,203,90,195,159,116,44,5,43,142,183,66,120,14,178,
10,74,192,160,234,181,216,144,67,45,174,23,81,250,240,23,254,39,221,234,41,142,
29,107,237,235,137,130,169,84,6,44,69,133,134,133,58,111,192,6,205,253,127,7,
241,239,64,214,153,199,94,235,5,68,117,43,164,50,178,169,87,54,190,159,161,31,
69,252,0,61,250,163,211,175,117,28,69,35,45,159,80,70,185,34,246,255,0,27,158,
109,255,0,19,239,221,123,172,126,24,144,139,143,169,37,65,39,240,108,47,245,55,
36,143,167,191,84,254,125,123,169,32,92,128,170,170,8,11,101,2,199,131,205,248,
36,27,31,122,39,143,91,235,205,3,74,44,168,204,64,212,197,148,133,178,144,72,
44,72,36,175,231,252,61,251,231,214,171,214,39,160,158,21,141,204,145,4,147,89,
12,161,181,149,93,58,206,151,81,244,36,127,183,247,179,215,186,196,148,178,2,
127,81,80,163,75,27,5,80,72,23,123,155,3,164,127,183,247,170,245,179,231,212,
176,177,169,96,237,26,178,48,181,152,200,204,10,240,170,150,39,80,63,91,251,215,
152,167,94,21,167,30,162,73,160,23,49,144,192,218,250,248,5,1,227,73,34,247,39,
139,88,113,238,222,124,49,215,169,92,117,131,81,80,36,86,80,192,220,0,65,252,14,
44,223,130,63,38,255,0,79,126,167,94,166,104,122,195,116,62,162,196,131,126,
121,184,255,0,95,253,115,239,221,123,30,157,99,19,32,54,208,173,112,84,234,39,
134,32,217,135,244,34,255,0,237,199,189,224,121,117,174,179,121,83,199,164,22,
185,77,37,116,241,171,80,252,95,232,108,27,250,220,123,223,109,56,103,175,117,
255,210,208,113,13,152,178,250,121,93,34,228,181,193,187,57,63,91,216,123,178,
154,86,188,58,245,42,56,117,41,26,210,223,80,54,144,139,147,107,242,69,136,255,
0,99,238,248,63,136,210,191,234,61,85,129,161,175,89,180,133,86,224,18,124,
204,56,224,122,148,92,92,30,110,191,237,253,232,32,161,227,90,158,180,9,245,235,
140,136,186,224,10,22,233,167,232,63,166,146,110,63,36,127,188,251,243,70,71,
195,199,173,106,52,61,101,208,186,84,216,92,185,32,141,34,227,83,19,97,207,22,
255,0,11,251,166,150,35,20,235,218,143,174,122,243,164,42,86,69,179,6,13,123,
144,9,101,126,57,224,6,252,123,209,7,133,58,240,39,53,255,0,7,80,70,147,35,130,
206,170,22,220,16,214,226,237,207,212,88,123,215,219,199,173,249,3,65,94,163,
148,109,118,214,121,63,149,250,129,114,79,31,210,222,252,79,86,83,170,157,98,
212,65,191,22,185,3,234,63,35,158,61,216,121,87,175,117,200,179,139,27,125,121,
54,107,147,201,250,219,155,251,215,91,235,151,145,239,127,168,22,54,111,212,
223,237,133,175,239,126,64,87,61,123,172,177,77,34,20,96,0,41,114,5,129,3,159,
169,4,17,239,76,160,143,149,122,247,78,171,152,152,49,18,162,203,17,68,215,11,
130,17,194,133,186,131,29,138,7,31,211,219,38,33,248,120,142,189,254,14,148,208,
231,113,50,210,83,210,180,34,17,12,111,31,137,208,126,226,187,188,143,7,222,13,
50,149,111,236,235,250,123,97,162,148,49,35,38,191,234,199,87,212,181,207,76,
85,114,34,203,52,116,108,142,117,144,90,50,242,68,168,77,210,197,192,107,34,
250,126,134,228,127,177,247,117,6,149,144,117,163,67,195,166,209,26,204,9,49,
152,184,127,27,46,160,146,184,183,237,249,44,16,144,63,219,251,189,74,224,49,
235,84,249,117,141,168,170,52,223,141,10,170,215,102,227,212,53,16,24,241,169,
65,185,31,129,238,226,69,53,198,122,245,15,167,88,124,46,182,210,200,228,146,
52,171,92,144,5,239,205,133,189,218,181,161,7,249,117,186,1,231,214,22,78,72,
145,121,55,38,227,213,244,63,147,245,30,246,73,3,25,234,180,235,130,249,87,73,
82,116,176,60,175,234,60,18,110,127,6,222,232,196,102,135,61,111,207,169,116,
231,214,178,104,82,24,149,210,13,236,215,22,43,245,101,60,253,15,215,222,245,86,
160,245,174,148,244,213,178,153,105,149,150,54,20,209,37,48,18,177,140,61,239,
114,133,65,179,0,108,127,35,235,237,150,160,4,138,250,254,206,182,51,229,215,89,
189,49,81,69,36,43,165,164,158,127,185,81,50,200,172,87,74,134,0,92,163,92,159,
207,43,207,212,115,116,163,17,246,117,179,230,58,69,187,177,43,102,250,42,218,
199,233,192,183,211,242,61,186,60,250,175,92,149,156,149,179,220,147,99,115,253,
77,128,231,159,122,36,83,175,87,229,212,177,28,133,18,254,178,117,5,75,88,49,7,
146,91,253,164,255,0,183,246,217,122,159,65,215,169,231,214,97,28,113,248,140,
196,27,57,188,74,108,196,20,187,16,196,88,41,255,0,110,61,235,61,221,108,116,
225,5,124,41,33,98,130,56,225,133,66,141,9,43,73,33,26,57,176,42,74,18,88,27,30,
71,189,24,200,29,108,18,14,15,89,155,112,212,75,9,167,153,33,145,26,67,50,131,
14,135,50,234,212,38,242,35,41,22,2,223,241,30,235,224,209,133,15,91,213,235,
212,234,109,193,19,84,83,45,90,198,244,141,60,50,207,21,58,24,216,180,77,101,
215,230,101,39,89,230,247,3,242,125,232,192,218,78,150,238,235,64,244,171,165,
220,209,227,215,39,36,116,244,230,91,170,83,160,134,61,19,64,242,51,180,211,201,
27,50,135,8,218,88,0,73,31,79,109,27,121,9,94,243,243,234,194,64,1,4,14,159,
241,253,163,29,35,47,147,23,7,132,58,163,3,26,122,162,4,6,49,78,2,180,111,171,
242,77,192,54,183,189,139,105,20,102,94,63,46,155,57,199,79,209,246,134,13,204,
130,22,146,130,4,212,209,9,101,105,26,243,145,123,203,17,55,106,114,1,2,224,27,
251,112,7,77,37,84,18,63,159,231,213,10,106,4,55,3,211,214,123,127,237,151,135,
7,2,193,65,60,11,143,169,73,69,84,30,42,137,218,97,9,118,74,232,73,154,56,211,
144,170,27,155,146,71,62,220,241,228,98,227,195,199,237,254,93,50,32,100,238,
174,9,175,236,233,59,20,59,62,173,210,171,27,84,113,255,0,119,5,164,11,86,178,8,
219,80,18,64,3,42,74,170,182,224,145,171,77,143,180,205,43,172,189,192,133,251,
58,81,248,79,155,117,35,33,180,169,42,164,105,33,202,83,86,83,75,8,84,154,98,
181,50,70,224,107,138,0,171,166,196,144,116,191,212,223,144,61,237,175,35,4,141,
57,31,42,117,228,141,200,3,253,95,225,234,60,123,27,29,34,194,243,197,78,242,
125,172,19,201,29,52,146,120,227,144,184,15,73,33,99,117,151,67,134,252,89,121,
4,253,61,168,91,216,84,2,197,71,84,49,201,82,51,95,179,166,40,240,245,184,217,
102,168,160,251,212,163,90,138,138,25,252,141,83,42,208,50,174,168,230,19,44,45,
227,5,9,177,96,183,254,132,94,214,51,195,45,56,16,120,103,171,209,212,80,252,94,
125,75,92,70,123,35,77,0,161,215,58,65,53,72,133,150,65,33,178,48,145,245,60,65,
132,18,8,174,214,62,166,31,143,117,45,18,144,161,77,126,93,108,22,60,79,88,205,
6,234,198,213,73,86,82,105,36,138,8,163,13,21,125,220,44,178,36,111,74,19,202,
38,120,194,144,93,20,27,6,7,222,217,67,46,157,38,135,229,78,170,27,60,114,58,
137,29,126,118,140,188,181,20,250,17,231,96,81,225,18,83,137,52,151,212,250,83,
72,118,136,30,47,168,142,125,167,104,98,102,53,108,244,240,145,133,41,195,165,
70,27,119,228,163,195,213,211,121,161,68,53,58,229,139,237,226,141,163,49,105,
17,44,82,184,214,172,63,31,75,95,218,168,173,98,49,215,207,164,210,204,198,65,
210,55,37,184,163,122,56,98,170,215,35,211,75,50,68,211,84,212,59,8,166,115,47,
6,21,34,234,227,252,63,81,183,187,24,20,80,169,235,97,216,244,207,91,186,226,
174,167,34,60,116,116,210,187,71,29,65,166,165,68,214,176,92,188,194,121,29,229,
18,212,144,165,192,225,173,200,231,219,241,172,74,130,177,231,252,157,80,169,
213,150,199,80,233,43,178,149,51,205,79,77,69,52,139,84,241,164,69,164,120,146,
58,150,107,68,193,125,42,52,126,120,252,251,116,106,171,5,140,0,122,246,149,20,
37,184,117,25,229,207,187,69,29,105,103,72,165,144,4,100,30,37,126,0,13,101,93,
87,81,199,251,127,207,182,21,74,212,233,205,122,185,85,97,199,167,10,244,170,
241,211,150,68,100,35,84,145,232,32,41,245,13,17,144,195,74,185,183,63,155,123,
180,135,129,210,7,90,82,7,19,212,243,21,100,248,8,99,89,98,141,135,146,49,17,
137,139,89,217,174,177,152,209,138,146,26,215,54,227,219,171,173,163,20,193,234,
133,144,57,36,227,166,79,176,170,136,65,165,167,81,2,35,7,17,42,178,34,53,237,
228,86,102,230,67,248,189,253,249,109,165,26,88,214,158,189,88,204,148,96,7,88,
42,133,69,85,101,85,76,230,170,106,137,207,220,52,231,71,238,74,218,65,242,133,
101,244,167,248,11,241,244,247,230,141,234,78,107,215,149,212,0,5,41,212,69,130,
100,14,21,22,66,206,140,235,36,15,164,31,93,174,65,184,87,7,253,97,237,181,14,
42,15,151,203,171,213,124,186,226,235,42,248,252,244,122,129,14,66,163,88,143,
220,35,130,65,111,77,184,255,0,91,222,153,136,193,81,78,183,80,124,250,227,12,
209,193,85,13,75,107,167,146,10,136,229,142,57,1,228,197,32,117,91,128,0,38,223,
67,111,116,5,106,164,2,13,122,241,161,5,105,196,117,50,182,172,84,84,84,85,199,
16,65,45,69,68,226,237,32,210,36,147,89,91,168,212,88,177,37,121,32,3,207,186,
176,12,238,212,165,79,94,7,76,106,149,200,233,222,10,140,138,193,13,222,173,97,
148,74,232,197,99,168,166,210,232,170,65,36,9,35,35,197,201,225,184,224,123,247,
132,84,140,16,122,222,161,66,13,15,83,242,153,122,170,120,212,172,147,135,71,
140,126,220,164,35,72,144,149,82,240,206,178,130,214,252,159,199,181,26,217,51,
94,147,233,70,99,219,211,150,219,221,213,16,78,236,238,197,205,68,76,93,169,
225,40,247,134,107,164,168,21,17,134,163,127,78,147,111,111,197,112,220,72,233,
169,109,129,7,72,234,5,78,126,84,251,115,55,1,245,153,37,146,34,134,85,58,184,
86,137,68,65,150,227,65,91,253,121,30,232,102,225,94,182,34,57,233,84,119,4,95,
196,41,43,169,158,73,33,52,148,241,178,197,122,169,169,167,165,165,142,16,75,56,
213,33,112,186,141,197,195,19,248,246,239,142,154,148,131,142,152,240,91,67,41,
25,175,216,14,122,106,254,245,226,226,212,213,82,79,170,202,150,142,52,119,149,
152,115,244,117,85,181,185,254,128,127,143,186,253,68,96,86,189,57,224,57,32,0,
58,207,73,191,176,49,82,213,69,36,117,12,194,190,157,232,245,70,197,93,4,114,
36,146,76,194,210,68,209,234,189,148,27,216,1,238,162,233,56,16,105,214,218,
214,66,65,86,21,167,93,100,247,126,215,171,18,165,60,169,28,145,188,166,35,61,
41,120,167,1,1,177,50,155,136,228,102,252,217,238,182,60,125,105,45,194,49,52,
225,213,227,130,80,1,39,61,54,13,223,12,177,197,78,100,165,88,214,39,142,73,86,
97,20,178,43,0,35,99,96,161,37,141,128,209,167,232,47,127,126,91,129,77,39,143,
91,54,244,36,168,207,93,201,152,165,156,202,124,180,210,164,133,93,132,254,57,
117,54,143,25,102,112,218,152,141,32,223,253,85,205,253,249,167,83,82,23,28,115,
215,150,22,83,198,157,54,85,61,12,176,52,72,113,241,0,5,218,15,25,103,22,180,
137,228,105,25,173,170,223,79,116,105,107,129,64,62,206,157,10,71,117,79,73,137,
97,31,88,208,24,65,144,137,24,160,4,170,147,165,53,122,26,215,250,243,205,184,
246,199,159,159,87,81,76,158,178,67,137,173,120,94,93,116,209,175,164,157,51,70,
106,11,181,194,175,136,21,11,200,230,246,176,247,238,182,72,61,114,124,20,235,
70,181,18,74,134,245,115,194,80,76,24,94,56,162,149,142,148,66,116,58,11,139,
145,207,191,117,234,231,29,70,251,26,66,172,89,192,209,36,104,229,100,145,46,90,
57,173,194,32,109,87,81,123,143,126,235,217,206,51,214,40,241,240,72,2,197,54,
153,18,48,238,37,150,193,195,68,8,40,24,131,169,92,223,242,8,227,143,126,242,
175,94,38,189,96,90,87,82,127,118,41,121,10,137,119,49,186,240,90,68,213,16,113,
32,99,207,246,120,250,251,245,70,1,29,120,234,197,13,15,78,147,81,85,65,170,81,
44,82,40,36,248,252,130,57,70,173,5,157,174,11,0,171,110,45,123,17,244,247,70,
10,77,65,53,234,233,46,8,96,13,127,47,230,58,226,212,213,11,142,146,168,188,68,
36,178,4,68,242,203,40,68,83,228,212,68,98,45,17,129,197,219,81,39,233,249,247,
170,154,142,7,215,171,6,67,80,70,126,125,54,52,242,50,146,146,20,226,228,4,3,
144,110,161,65,212,234,8,228,95,139,251,210,150,60,64,253,189,120,170,208,80,
231,172,134,102,43,0,54,191,141,189,65,149,174,91,128,196,27,155,175,228,91,222,
193,13,92,255,0,171,253,158,170,65,7,174,34,4,101,141,165,112,3,200,203,112,218,
117,196,188,7,143,79,169,223,241,207,230,222,246,107,90,15,245,124,186,245,113,
149,235,167,163,165,6,107,121,92,32,11,12,140,81,67,182,191,212,234,228,50,30,
45,97,205,253,233,77,105,214,129,53,31,62,176,188,148,235,25,13,26,164,133,70,
133,212,76,138,193,133,236,108,22,235,207,31,227,238,253,104,31,46,162,26,212,
212,117,0,72,228,50,6,93,77,98,188,250,128,36,131,249,247,188,86,180,235,103,61,
115,146,181,164,138,20,0,47,137,100,0,92,20,210,238,27,129,99,234,63,235,220,91,
222,169,147,235,215,189,122,197,229,119,91,22,184,184,226,246,30,155,90,226,223,
227,254,241,239,120,28,7,159,87,192,39,20,235,14,184,212,155,176,23,39,144,57,
182,159,173,255,0,167,30,253,242,242,235,101,128,39,204,117,5,230,189,172,56,91,
159,245,239,254,183,191,124,250,169,106,230,157,97,105,3,30,62,132,14,7,208,88,
14,79,250,254,253,214,186,198,205,110,7,251,31,240,255,0,141,251,247,90,235,24,
254,158,253,215,186,229,253,147,207,63,210,255,0,226,57,255,0,120,247,238,189,
215,255,211,208,100,134,36,141,54,187,17,112,7,23,54,4,127,64,111,239,116,60,58,
177,63,33,214,70,70,89,72,98,195,75,223,83,106,28,139,94,214,28,123,221,15,152,
234,181,249,245,205,181,134,148,44,186,78,139,16,215,187,115,118,95,74,255,0,
141,255,0,30,246,9,160,61,106,157,72,50,177,120,89,88,55,168,241,167,213,233,69,
191,164,241,167,139,125,111,239,193,206,59,186,246,144,124,179,212,138,121,52,
192,178,201,18,56,90,139,48,98,126,140,132,128,80,141,86,22,252,113,238,224,177,
2,135,61,123,72,201,39,168,207,52,114,178,168,140,174,176,108,21,199,142,250,
219,73,179,220,167,211,222,180,211,20,197,58,213,41,92,227,168,50,43,23,115,253,
155,254,120,189,129,176,31,94,77,191,219,251,169,90,1,221,158,180,56,103,172,
132,56,77,68,31,167,7,245,250,3,2,196,106,60,21,35,253,183,189,31,77,56,254,126,
125,88,82,134,131,203,168,196,115,126,13,142,174,63,55,177,252,92,3,253,125,215,
210,157,122,189,116,53,49,0,15,212,127,214,185,191,212,126,5,189,251,173,245,
153,17,139,105,181,236,121,183,39,235,107,91,139,155,251,241,167,145,235,221,
101,85,109,86,211,107,129,110,46,61,64,27,95,250,219,223,129,253,157,123,172,
110,162,236,74,218,203,112,62,150,176,250,255,0,173,207,251,127,126,60,122,246,
113,142,184,90,192,125,15,63,215,146,63,175,211,223,169,251,122,215,94,66,81,
175,114,127,170,234,63,67,199,215,253,137,247,162,42,58,247,74,58,58,200,89,224,
73,25,22,24,201,36,11,125,24,91,64,141,172,162,231,234,127,215,246,157,146,149,
32,103,171,234,224,58,116,168,240,74,145,50,24,227,12,99,215,40,40,161,80,162,
160,241,68,231,69,217,193,185,31,142,45,237,177,81,171,29,91,136,20,233,162,174,
146,161,101,49,170,195,53,161,50,58,161,142,63,160,55,64,234,197,92,168,32,255,
0,137,62,220,86,28,65,243,235,68,28,215,168,98,150,73,90,63,218,120,1,68,245,
62,179,101,213,167,80,109,60,131,127,119,214,5,72,106,154,245,234,26,10,142,61,
96,90,89,225,229,163,147,72,18,254,224,141,244,125,109,117,99,192,184,250,251,
211,16,192,16,69,125,58,175,88,225,164,149,153,2,173,140,139,33,189,216,133,34,
226,205,233,184,63,159,207,227,223,181,14,236,231,175,83,32,30,167,198,245,64,
47,172,50,169,81,251,128,54,155,175,58,89,133,249,208,69,190,158,244,115,131,
94,182,58,207,95,44,134,8,11,162,105,120,164,114,20,105,186,134,210,188,139,
155,233,250,241,239,99,249,117,239,151,73,167,26,90,192,223,129,99,249,250,113,
127,245,189,185,171,215,173,17,158,185,66,133,228,141,65,181,221,69,239,107,115,
245,247,162,104,132,245,239,62,157,35,123,19,32,85,188,76,116,55,58,181,53,244,
181,185,7,145,115,254,30,219,11,154,122,245,227,78,176,85,84,52,151,37,99,121,
30,80,239,35,173,220,130,160,13,32,88,44,99,79,0,88,251,120,10,117,170,158,163,
152,93,181,54,171,1,160,19,244,110,117,91,133,225,120,31,75,251,181,61,7,90,174,
71,88,221,2,21,26,141,244,139,146,15,31,91,142,126,191,239,94,253,215,135,159,
92,65,80,111,201,63,215,254,39,253,183,189,102,191,46,183,210,163,12,104,167,
242,69,56,142,51,34,160,143,204,110,140,84,0,225,90,252,19,254,194,220,251,109,
217,150,148,235,98,135,137,207,92,242,148,145,194,129,169,226,101,17,183,238,5,
115,36,69,153,151,79,142,229,139,70,0,189,205,189,248,62,161,199,173,17,235,210,
117,157,11,150,40,19,81,7,80,229,175,249,176,2,192,146,61,220,41,160,3,203,175,
100,116,161,130,146,146,166,158,158,85,47,43,248,164,73,5,149,12,44,133,20,61,
148,155,242,111,115,205,189,182,75,6,161,175,90,173,60,186,139,24,154,145,210,
72,89,68,177,180,128,72,135,200,196,139,2,133,73,96,117,31,165,193,247,118,80,
224,130,58,245,104,126,93,75,25,188,168,146,233,87,224,26,148,232,72,146,48,116,
155,129,34,11,220,93,191,215,246,211,90,196,194,140,186,169,213,214,66,184,24,
233,254,155,121,102,226,13,32,175,145,100,49,248,145,83,198,85,34,93,33,244,35,
47,165,153,185,38,228,219,253,111,117,250,56,20,80,70,43,213,75,177,57,99,78,
157,177,91,230,179,29,45,70,165,41,247,10,129,167,134,64,210,11,25,15,49,178,
201,11,159,95,208,253,127,175,186,52,12,105,67,195,173,250,244,175,193,239,76,
85,53,42,65,93,79,75,84,197,106,74,72,175,61,4,178,180,145,44,111,229,20,236,
144,70,204,121,39,146,57,183,22,30,218,120,230,25,82,70,126,222,188,15,26,142,
132,37,220,184,182,197,100,36,134,142,142,173,103,160,162,145,196,181,171,45,61,
41,133,212,181,53,60,241,63,221,49,145,148,51,29,44,215,176,60,123,220,107,33,
161,36,212,31,159,243,233,150,96,24,12,244,154,198,77,67,153,76,148,242,147,23,
251,148,167,101,145,73,115,36,82,161,133,218,74,123,17,195,48,210,71,232,28,91,
159,105,101,138,80,250,146,153,30,159,229,233,90,200,154,85,94,180,233,207,29,
65,183,150,142,165,230,171,72,204,181,231,246,30,146,77,106,154,188,69,228,181,
227,98,25,47,125,95,164,142,61,175,182,250,133,136,130,162,180,245,233,60,222,
25,144,16,113,211,76,24,60,21,85,77,76,21,51,81,80,70,144,78,235,44,144,199,86,
205,111,67,70,20,152,80,178,35,107,83,113,98,44,125,237,166,150,35,240,84,19,
243,235,66,32,224,119,144,122,100,198,237,252,36,53,146,99,30,142,12,204,181,34,
72,224,201,138,135,162,165,167,158,66,18,157,136,89,92,13,82,217,137,98,220,49,
224,88,123,175,214,20,36,176,199,166,122,112,219,187,105,42,115,249,83,165,91,
236,236,119,222,10,58,73,42,225,204,77,88,97,131,23,18,192,12,115,192,236,243,
211,154,135,50,133,241,8,218,196,150,44,7,215,218,159,175,86,93,65,62,127,234,
199,76,136,100,83,70,53,31,234,242,175,92,119,46,195,193,209,101,76,49,212,230,
233,222,73,227,156,10,175,225,174,42,96,171,64,83,237,94,18,200,100,74,144,204,
218,130,145,25,28,18,109,237,169,111,192,64,241,166,62,222,29,57,20,14,199,76,
134,159,151,92,167,218,27,101,113,177,86,79,89,145,99,229,140,160,153,169,196,
75,17,19,187,169,134,50,143,57,34,47,73,4,92,255,0,176,246,142,77,210,80,202,
130,16,77,60,171,94,148,165,149,85,152,190,58,195,131,196,193,144,196,212,125,
165,12,116,208,195,33,146,158,106,130,207,35,132,150,40,221,156,52,163,130,31,
250,241,253,61,171,109,197,224,137,123,59,190,95,236,244,157,109,86,73,8,215,
219,215,190,211,15,75,81,71,72,244,18,215,205,34,72,240,203,37,108,116,212,239,
58,144,246,49,38,178,85,84,19,164,55,63,155,125,125,218,45,210,119,0,178,80,
143,157,127,201,213,37,177,211,90,56,161,249,117,22,186,159,105,210,67,91,37,68,
117,82,212,145,28,208,195,29,21,36,17,248,164,169,62,72,227,172,167,118,100,49,
199,114,3,35,220,128,53,15,102,118,247,82,200,172,206,86,190,148,31,225,233,28,
145,178,178,170,127,132,255,0,131,166,204,93,30,6,182,9,235,154,106,72,225,143,
33,71,26,210,204,94,57,38,142,68,170,41,27,74,192,24,222,209,144,205,171,243,
199,248,106,105,220,171,16,18,149,224,48,127,159,94,164,129,150,58,28,131,159,
33,243,234,126,66,135,111,214,154,122,58,105,96,90,153,90,105,99,134,26,200,
210,44,101,60,245,140,12,21,37,218,70,50,69,31,209,84,177,111,245,253,150,189,
192,101,44,232,84,214,159,111,204,103,253,142,159,81,32,36,17,80,7,249,58,230,
54,102,5,228,106,87,168,70,146,124,117,84,134,162,162,56,170,32,147,197,76,42,
105,140,13,251,18,193,36,170,172,11,88,157,66,214,252,251,66,46,216,18,200,164,
138,129,79,180,211,231,210,141,56,26,141,15,76,145,109,28,76,70,157,177,209,212,
228,229,169,163,166,171,16,169,134,154,150,150,105,130,19,79,52,134,87,50,162,
125,20,6,91,147,201,83,199,181,9,59,179,54,165,210,160,211,214,189,105,130,133,
4,55,113,29,112,251,90,25,233,170,60,244,17,253,210,215,199,20,136,82,56,213,
96,212,209,84,40,154,25,66,169,136,240,188,27,158,111,237,91,57,49,106,92,80,
255,0,177,211,73,80,253,220,40,122,141,85,183,104,107,76,240,208,143,181,119,
174,180,112,71,48,169,17,160,135,81,4,74,165,139,167,228,235,211,207,210,222,
217,123,134,140,13,96,211,167,85,53,17,67,229,212,172,118,205,142,154,88,22,178,
150,138,72,69,104,121,42,22,118,134,167,237,227,83,35,25,74,75,167,83,30,2,168,
39,241,127,109,45,226,144,40,198,191,103,87,100,34,189,39,243,144,181,41,52,
208,105,142,33,35,211,197,4,138,30,212,203,34,248,138,172,186,74,234,67,123,147,
250,126,166,254,220,18,131,90,53,105,213,104,41,195,164,46,86,162,174,124,181,
76,137,74,41,199,153,211,199,142,105,97,136,152,208,68,29,85,117,71,169,194,3,
192,177,255,0,121,246,234,176,167,197,159,159,94,210,56,0,58,77,60,174,202,203,
234,32,233,54,144,21,112,194,226,234,110,79,231,159,235,237,193,192,245,186,83,
203,172,107,40,208,111,127,173,255,0,12,56,250,125,126,158,232,104,72,167,151,
86,4,117,209,38,246,13,168,159,192,82,15,170,214,0,115,248,62,237,138,252,57,
234,202,87,34,158,93,101,142,57,100,44,2,0,80,13,92,13,86,63,150,22,184,191,186,
86,148,20,243,235,68,121,211,169,17,82,200,215,187,91,131,117,8,215,0,18,47,
117,244,233,99,237,194,104,79,85,52,242,29,40,41,41,22,24,69,91,69,26,44,111,26,
218,107,185,119,123,241,225,26,72,80,57,191,230,222,235,168,231,187,170,156,208,
117,38,106,191,28,101,26,162,40,214,71,36,58,196,158,37,70,26,10,170,57,103,141,
148,142,127,1,127,62,252,11,117,170,124,186,131,30,110,10,63,39,137,105,75,22,
188,110,145,52,196,122,10,179,146,210,5,146,66,26,198,227,243,113,244,247,98,9,
207,94,161,226,122,103,169,203,207,44,81,196,142,232,145,200,239,96,236,21,139,
160,78,80,27,112,7,214,228,255,0,176,247,112,135,137,235,90,69,107,231,212,8,
234,164,75,182,179,118,112,88,92,146,215,250,221,141,205,189,250,130,131,173,
245,156,87,40,50,183,141,1,112,161,120,114,1,80,7,3,87,166,254,245,164,82,135,
175,126,121,234,85,62,100,211,161,85,75,59,2,186,129,87,210,140,81,138,162,201,
172,33,98,166,228,127,95,122,49,215,52,242,235,68,102,189,76,92,244,118,144,173,
20,112,179,202,206,172,137,228,88,145,148,134,91,59,16,205,41,54,107,142,1,184,
247,226,7,167,94,200,167,119,92,83,51,104,194,8,188,74,198,102,41,27,55,136,25,
151,66,254,209,212,61,10,63,169,250,255,0,135,189,17,95,183,173,241,205,122,138,
213,202,202,192,128,192,233,112,168,52,149,63,167,153,0,4,219,250,126,127,175,
191,0,48,72,235,121,252,186,224,213,113,4,26,34,55,100,23,98,214,5,129,60,217,
72,183,191,105,4,212,158,183,94,177,181,89,43,13,145,64,77,118,23,54,55,62,174,
57,54,96,127,175,250,222,246,49,215,177,215,17,88,202,30,209,68,53,255,0,180,
179,104,23,185,211,118,38,231,242,126,167,223,186,209,161,234,51,51,59,92,5,228,
30,45,192,31,225,245,183,215,223,186,247,229,214,1,101,62,171,27,143,245,244,
145,255,0,19,113,239,221,123,172,174,125,10,192,222,250,133,137,23,22,107,92,11,
242,79,251,199,191,117,234,87,172,102,91,13,32,131,234,54,54,34,252,126,175,175,
215,143,126,225,214,233,78,61,69,118,44,73,38,228,155,242,126,167,223,186,215,
81,203,19,245,250,95,233,239,221,123,175,41,35,145,107,145,199,244,255,0,99,
244,30,253,215,186,235,159,200,255,0,111,254,250,254,253,215,186,236,11,253,126,
134,224,31,233,110,57,30,252,51,214,137,167,89,52,13,36,243,193,224,127,75,145,
207,211,243,238,212,243,235,213,235,255,212,208,139,233,244,39,253,247,226,252,
14,61,184,184,212,125,8,234,167,236,235,156,198,210,49,184,31,67,245,23,28,11,
95,159,175,183,9,227,156,117,234,2,40,70,58,200,142,158,86,182,191,92,95,212,
18,88,175,231,235,199,248,123,241,61,104,14,177,51,218,69,101,31,146,215,183,
250,192,219,158,53,125,15,182,202,247,10,249,245,112,72,175,175,88,38,114,73,
102,254,201,93,54,211,96,45,109,32,125,110,160,253,127,30,253,80,184,28,58,213,
75,26,158,61,69,86,55,190,162,8,245,3,123,88,143,161,0,253,125,249,88,147,199,
175,117,203,213,37,205,164,185,60,5,185,82,5,255,0,173,248,12,127,175,189,87,29,
123,169,137,20,214,82,197,236,69,199,233,2,215,32,218,231,232,127,165,190,183,
247,225,143,44,255,0,171,249,117,174,39,135,94,52,198,50,3,132,32,177,1,204,131,
215,200,33,172,183,210,57,31,235,159,175,191,26,14,188,15,30,178,44,113,128,218,
79,23,38,224,221,111,253,3,0,164,16,127,173,253,212,210,167,175,83,207,174,72,
0,32,169,185,253,74,84,253,78,155,94,230,230,196,223,253,143,189,121,117,108,
117,153,45,173,67,105,181,136,0,184,42,61,54,45,118,231,80,191,211,250,251,240,
245,235,93,71,151,65,103,58,236,66,88,5,177,231,73,7,80,107,133,28,255,0,177,
247,224,15,3,214,199,157,58,108,146,91,186,250,129,0,242,71,23,177,60,220,127,
135,187,28,143,203,175,127,135,174,132,186,152,1,194,220,255,0,137,181,190,128,
112,111,199,186,245,239,240,245,145,92,3,193,55,255,0,31,234,108,109,253,61,235,
7,173,14,165,45,71,43,115,98,0,2,228,144,20,31,160,247,66,181,224,122,240,36,
103,169,98,186,237,171,82,177,10,2,242,1,0,181,153,72,96,67,3,127,165,189,208,
197,156,117,96,223,46,156,151,39,79,169,11,211,9,22,72,163,14,30,121,8,186,72,
14,181,100,42,85,155,79,208,88,115,237,163,11,14,7,249,116,231,136,61,51,78,
158,33,207,65,77,65,83,20,108,139,88,232,68,82,21,242,65,227,103,13,163,81,58,
210,160,2,121,181,184,246,216,137,139,169,63,15,91,214,180,32,140,253,157,50,
140,172,2,57,36,119,111,36,144,77,27,71,19,104,66,204,192,70,53,90,197,64,230,
234,1,227,218,128,135,133,58,108,145,231,211,107,215,168,71,85,41,118,137,23,
233,175,149,231,139,142,8,254,190,236,20,250,117,170,211,168,181,149,18,57,68,
47,233,72,130,11,113,193,60,143,246,227,221,149,113,215,171,212,27,126,127,223,
127,176,254,182,247,127,240,245,174,179,198,52,89,136,230,235,201,250,125,111,
254,219,143,109,146,73,199,94,235,59,22,26,185,191,55,224,139,18,111,107,1,200,
247,177,65,67,214,250,198,61,76,72,28,221,72,91,94,227,144,110,199,143,72,247,
113,90,117,175,240,117,151,207,104,229,225,11,23,139,213,201,1,70,190,56,224,
123,181,8,28,58,175,203,168,204,84,147,168,95,242,44,109,248,224,255,0,173,207,
251,31,126,61,108,112,235,24,183,23,63,236,45,193,255,0,90,223,211,222,169,214,
250,204,172,202,53,41,63,91,169,31,81,254,32,126,15,191,80,122,117,161,211,197,
14,91,193,196,200,36,82,0,26,199,208,233,33,152,216,143,207,248,123,161,142,
160,211,171,3,76,30,179,50,138,168,194,68,209,105,83,60,145,68,246,80,178,74,6,
173,37,2,189,206,145,164,18,86,255,0,143,118,92,12,245,163,158,29,99,251,122,
168,22,41,35,73,33,215,28,197,72,36,71,42,196,200,36,185,45,102,187,48,0,115,
127,126,102,90,1,233,214,130,147,212,120,140,172,226,244,238,204,15,232,64,75,
173,249,245,105,0,139,253,69,249,62,253,192,245,226,56,245,53,114,52,202,23,205,
72,182,211,195,170,45,202,159,245,192,191,211,235,248,62,252,115,192,245,160,
15,159,78,180,181,148,82,126,201,162,135,87,137,202,179,40,253,33,53,59,147,
160,131,192,191,251,215,186,144,196,96,245,224,0,207,82,35,20,90,46,177,211,19,
111,91,4,42,132,146,72,80,71,37,128,254,159,79,116,163,26,85,141,63,103,87,225,
229,158,149,184,113,182,106,241,16,193,93,76,171,85,21,85,83,125,197,51,17,34,
70,124,65,11,175,46,161,8,54,224,222,255,0,79,116,144,72,8,40,122,168,169,99,
90,211,165,36,187,67,4,248,217,171,40,55,36,49,206,191,189,83,67,144,142,232,
105,244,168,72,105,106,105,14,182,149,75,2,99,16,151,255,0,97,239,105,41,85,238,
67,90,255,0,168,245,82,164,182,41,74,116,148,147,9,150,161,137,37,199,84,45,
124,172,209,211,145,65,58,188,34,35,30,185,210,168,171,249,105,103,134,64,6,157,
23,39,145,110,61,248,73,9,160,98,7,219,213,244,62,72,24,253,189,79,196,73,146,
199,195,86,181,19,58,74,41,53,138,58,185,22,41,98,50,201,39,151,76,51,196,30,
112,186,67,23,107,155,48,246,190,31,13,149,180,240,167,73,164,168,101,52,53,29,
51,84,101,242,18,64,99,158,158,73,97,141,26,154,105,85,39,88,226,19,16,90,65,
45,28,176,153,36,123,112,36,214,151,254,207,182,202,32,98,105,83,211,128,240,
163,99,168,144,101,226,44,128,177,162,241,195,226,4,163,31,34,43,51,66,225,231,
15,226,148,150,62,162,9,255,0,97,97,238,140,145,53,74,168,227,213,170,192,82,
181,233,204,229,113,230,190,73,228,201,87,211,212,73,68,168,206,140,222,72,234,
213,188,98,165,103,142,88,86,73,37,143,251,97,84,168,39,142,125,235,194,83,65,
64,122,213,92,14,166,54,90,51,12,114,54,226,138,90,208,90,41,42,194,234,154,72,
82,47,216,140,25,29,163,141,225,115,96,229,46,72,250,251,109,162,90,129,164,17,
213,195,176,245,29,96,203,101,161,150,158,135,199,148,166,149,232,168,5,60,116,
254,66,210,197,12,74,88,9,88,146,174,110,196,235,55,39,85,173,239,222,10,113,43,
147,199,173,137,27,134,105,214,122,61,199,144,167,193,75,73,12,202,145,60,171,
229,146,54,149,26,19,120,201,120,100,142,104,238,204,234,13,142,165,212,62,151,
246,239,131,9,74,180,96,245,77,114,9,48,196,14,147,178,238,220,188,229,162,158,
164,204,177,37,145,218,40,156,254,214,181,142,64,250,46,146,89,141,200,224,159,
173,253,209,33,132,26,132,0,83,171,151,115,197,186,131,81,187,171,101,74,129,61,
53,58,188,208,162,72,198,148,9,85,86,192,20,125,97,84,177,2,250,64,31,239,94,
221,77,40,40,170,41,213,10,213,170,79,81,198,224,48,227,234,41,145,20,201,83,85,
79,44,178,153,157,24,44,16,76,145,44,97,73,41,167,202,109,239,101,148,168,5,
115,94,181,161,171,171,202,159,234,207,77,147,229,93,12,111,28,254,173,44,9,96,
142,224,23,212,61,76,173,115,171,234,126,190,218,117,70,0,83,31,111,87,66,203,
83,231,215,35,158,201,180,96,180,228,136,244,152,202,176,136,234,85,208,108,
233,98,196,175,28,220,123,105,98,77,64,105,61,88,177,167,82,97,221,25,26,120,
214,49,61,84,106,209,172,66,56,157,10,248,66,157,42,183,31,64,127,31,225,254,
183,183,12,107,67,64,42,125,122,108,40,243,235,156,59,145,197,13,84,114,52,197,
229,120,10,57,119,6,50,147,23,123,160,33,31,201,126,120,226,222,236,169,69,167,
225,235,71,226,4,113,235,51,110,185,160,150,41,162,148,25,146,99,41,71,180,145,
200,197,21,117,48,6,194,194,220,126,125,234,72,131,2,172,122,178,18,51,211,157,
79,99,229,234,218,157,9,167,136,44,156,188,81,5,153,180,173,129,212,110,34,86,
63,208,15,108,71,101,10,28,19,199,171,151,98,50,58,78,84,231,106,114,114,83,45,
67,72,238,52,163,6,31,132,58,73,86,7,155,168,23,63,95,110,8,149,9,167,94,175,
19,212,250,26,236,76,21,202,210,210,213,24,209,184,117,148,59,53,193,215,35,
167,149,68,96,30,64,23,32,123,109,149,136,52,97,159,151,94,31,62,156,178,213,
216,218,136,82,154,145,105,102,129,29,93,229,122,125,114,89,190,130,250,108,170,
15,251,87,227,219,113,198,224,212,212,31,182,157,111,236,29,49,38,42,7,134,86,
140,29,58,73,186,53,194,168,96,47,165,129,26,127,216,251,116,57,12,42,115,215,
189,58,100,169,166,208,23,196,91,93,189,90,129,143,73,4,168,85,55,43,33,32,125,
65,30,221,13,140,245,227,78,160,188,19,195,123,235,82,126,160,234,86,63,131,
199,23,0,255,0,175,238,194,134,158,125,122,135,203,174,161,169,168,166,99,36,
110,225,192,43,107,157,68,56,177,22,107,155,17,254,219,223,136,4,117,94,184,61,
108,237,168,185,144,155,11,51,51,181,255,0,0,30,110,7,62,253,138,215,175,117,
141,164,145,133,202,18,72,4,16,110,127,31,236,125,239,236,235,221,113,245,31,
197,143,224,18,65,31,239,2,220,123,247,86,28,114,58,200,22,224,92,128,15,251,17,
192,255,0,111,249,247,177,233,199,175,21,197,71,92,88,0,46,6,171,183,38,255,0,
167,131,198,158,71,227,223,177,213,126,222,187,184,2,255,0,215,72,28,113,248,63,
95,123,197,122,221,120,245,204,32,227,250,253,126,191,215,243,199,189,31,151,
85,161,198,122,196,207,164,144,170,69,175,205,143,251,209,252,123,247,229,215,
184,158,187,19,155,114,163,253,135,7,232,127,60,216,95,223,188,190,125,120,142,
187,243,173,174,88,3,107,88,143,175,170,231,145,126,127,215,247,225,243,235,127,
151,92,252,202,64,31,83,110,57,250,31,207,226,255,0,79,122,60,120,245,238,178,
151,140,133,23,35,145,123,255,0,100,27,220,126,47,107,125,125,251,175,99,174,44,
99,7,137,20,3,249,230,235,99,245,177,0,19,239,223,103,94,234,59,63,169,180,200,
74,216,168,36,88,145,205,254,131,232,125,251,211,173,212,14,35,168,250,155,250,
177,252,113,254,219,242,125,239,236,235,122,128,252,61,114,242,49,64,182,181,
175,254,63,159,201,183,189,117,162,213,197,58,230,165,56,190,171,127,83,248,255,
0,97,249,183,191,124,186,213,79,10,245,143,211,127,212,57,63,155,223,131,111,
233,245,183,191,117,234,245,193,130,130,127,60,241,248,63,235,219,252,125,251,
173,241,199,92,70,159,233,254,251,253,143,191,113,235,196,83,174,193,31,143,241,
184,63,227,254,62,253,142,189,67,214,64,5,255,0,175,211,243,111,245,236,15,215,
222,199,30,181,214,95,247,93,184,182,162,73,184,189,184,224,31,235,239,223,151,
94,255,0,7,95,255,213,208,132,243,168,114,62,182,3,232,8,185,254,166,246,247,
106,26,26,28,87,175,121,252,250,194,228,147,205,254,167,235,249,176,252,127,176,
30,237,83,130,79,159,94,225,229,215,56,228,179,134,32,13,43,98,109,123,1,249,
183,245,247,179,65,246,117,229,238,235,139,73,98,71,34,194,75,95,158,109,245,
250,88,159,122,212,184,61,84,103,61,55,180,141,114,65,250,219,155,255,0,65,254,
185,30,233,95,150,58,183,92,150,82,8,38,199,79,210,227,234,63,161,176,191,191,
87,61,106,159,46,186,90,130,175,117,37,77,173,167,234,57,32,253,120,189,253,
251,236,235,221,76,106,253,69,73,75,170,174,159,212,64,54,255,0,3,170,227,159,
123,39,135,94,210,56,117,193,170,245,174,128,161,1,109,70,252,242,45,245,60,15,
168,247,227,145,215,169,215,2,242,127,170,181,255,0,161,22,224,222,214,30,245,
243,61,111,175,106,114,127,83,30,64,7,81,227,147,244,63,143,248,223,189,14,35,
175,117,147,128,74,179,177,28,144,202,110,62,156,253,127,196,243,238,198,156,64,
199,90,235,21,65,93,74,53,94,218,77,237,205,236,47,126,111,238,163,62,125,90,
148,234,41,183,226,255,0,236,127,222,61,239,29,107,174,213,153,72,42,121,31,79,
200,255,0,90,223,155,223,223,186,247,89,128,54,255,0,96,9,255,0,27,216,127,190,
255,0,15,122,235,221,119,99,123,125,126,191,78,126,159,211,252,61,251,175,117,
239,246,7,223,186,247,94,6,220,243,244,254,182,250,142,63,219,123,215,94,235,
222,75,31,213,205,191,60,255,0,198,189,250,131,211,175,117,213,238,63,31,237,
135,251,223,189,245,238,186,38,194,254,253,215,186,198,100,98,111,254,241,239,
221,123,172,130,91,240,111,111,240,183,31,235,123,247,94,235,62,161,205,136,35,
234,63,199,139,251,173,51,129,215,171,214,104,166,91,89,181,92,220,51,94,254,
147,244,183,231,253,127,116,101,53,168,225,214,250,207,11,70,146,221,135,23,1,
44,46,29,77,129,86,230,224,48,55,252,253,61,217,91,173,30,185,152,148,153,217,
87,90,43,198,117,14,108,164,184,82,64,31,164,146,0,176,246,238,40,71,207,170,
240,167,167,77,242,131,245,32,15,74,218,223,212,129,245,183,208,216,123,215,229,
214,250,196,13,173,111,168,247,174,183,215,122,141,173,207,214,247,191,248,91,
222,235,235,215,186,230,174,45,102,6,255,0,131,199,251,27,254,79,191,99,35,207,
175,117,38,0,84,135,71,210,71,168,0,214,32,169,184,54,255,0,31,168,183,191,17,
228,70,58,247,79,19,86,200,209,64,166,85,147,200,11,58,253,91,146,9,93,66,218,
65,60,144,45,115,238,180,3,175,84,231,61,73,74,165,168,68,138,119,96,17,245,62,
187,104,96,160,104,215,200,211,164,112,62,135,252,125,250,158,135,173,87,208,87,
169,145,226,169,230,141,230,74,168,140,113,9,60,80,79,169,181,54,165,2,24,222,
45,69,188,90,174,11,240,71,191,17,199,173,125,189,77,166,194,60,104,181,17,168,
45,160,69,81,120,170,21,210,73,181,8,90,152,69,120,230,73,5,129,54,36,92,241,
237,166,149,1,165,107,213,213,73,33,188,186,146,152,105,86,88,20,188,81,78,234,
88,235,5,163,242,32,34,225,132,122,70,176,108,20,143,175,231,143,126,18,84,227,
173,19,65,192,211,175,53,27,173,12,144,186,64,36,142,174,39,87,210,99,117,50,0,
91,83,161,1,116,149,184,13,245,35,221,131,212,1,76,117,239,58,245,142,127,226,
13,19,66,229,79,133,153,217,153,136,118,93,40,22,116,252,190,155,88,219,250,
123,209,11,80,60,255,0,213,229,215,133,72,45,229,211,93,1,100,171,73,64,168,5,
153,164,213,28,140,147,51,169,253,113,216,141,72,167,139,253,111,254,62,246,80,
112,175,14,188,90,134,189,8,216,44,236,169,247,76,146,76,178,200,139,11,75,92,
134,127,34,139,107,86,105,196,186,154,64,5,141,254,130,199,241,237,68,40,189,
195,229,211,50,30,6,181,29,67,171,201,83,249,157,36,161,165,138,115,49,169,105,
169,165,215,28,65,27,136,89,73,100,40,228,255,0,81,207,62,244,216,52,169,235,
116,4,117,212,107,137,200,164,48,168,122,41,102,52,35,84,180,158,88,222,114,109,
80,41,201,97,26,0,198,231,232,24,241,113,237,35,150,80,77,5,7,167,78,0,13,15,
83,166,218,212,237,83,88,34,168,12,41,188,201,59,77,71,53,60,209,199,5,153,221,
34,45,43,74,71,55,176,55,23,54,227,219,66,115,138,15,231,213,180,211,236,175,
81,35,217,15,88,144,154,115,8,74,164,150,165,42,94,146,114,12,37,9,64,210,32,
241,1,33,22,83,195,95,241,127,126,250,160,164,213,77,65,165,43,211,158,13,105,
70,197,58,203,22,196,166,243,83,195,89,81,246,111,52,102,40,228,88,165,79,59,
167,166,72,192,39,135,189,175,126,127,195,222,158,236,170,179,4,192,235,66,17,
81,221,214,122,253,137,43,211,203,79,143,172,141,236,242,122,75,57,8,232,25,
199,144,149,26,34,0,114,205,244,99,254,62,246,151,170,193,84,138,87,173,52,44,
164,154,96,116,144,59,39,50,140,200,10,202,97,64,238,176,161,102,8,72,91,196,72,
85,123,127,129,246,176,16,126,222,153,44,58,105,24,120,140,117,18,79,86,244,
226,27,135,73,84,198,228,169,112,165,16,179,59,15,38,157,70,198,215,247,179,214,
195,87,128,233,150,124,124,38,34,234,146,5,37,74,203,170,225,212,134,0,105,123,
17,114,56,254,190,245,159,207,173,131,212,105,169,22,24,226,244,54,167,87,210,
24,48,187,43,21,32,128,7,32,255,0,143,189,87,173,245,139,196,165,77,224,111,74,
243,167,144,57,55,111,199,187,3,215,186,239,195,14,180,26,93,5,155,212,193,199,
26,141,138,144,72,32,143,123,199,159,90,205,58,232,193,76,203,233,148,254,174,
87,80,176,183,23,253,92,150,247,188,83,143,85,161,169,244,234,20,209,66,63,205,
180,140,215,226,246,250,113,118,255,0,0,127,30,244,127,203,213,133,122,140,18,
199,234,224,131,253,74,243,199,227,139,123,247,91,235,148,109,36,108,25,92,234,
95,165,255,0,165,184,183,63,79,122,34,184,235,221,115,251,186,141,64,220,106,
28,112,0,227,159,247,191,122,210,58,247,89,34,200,212,197,192,97,245,31,80,56,
255,0,97,244,227,222,180,142,189,212,148,200,57,213,228,168,144,92,159,76,118,
80,126,132,31,168,227,223,168,43,195,175,103,174,43,93,34,176,97,105,44,14,159,
34,234,211,115,125,66,255,0,70,255,0,31,122,40,51,76,117,234,245,53,242,81,201,
35,178,211,196,190,85,210,201,161,10,160,96,117,4,37,111,201,231,250,223,221,
66,17,197,141,122,181,125,58,226,177,71,84,204,170,4,66,49,232,212,199,134,36,
250,4,150,187,51,91,139,253,61,238,180,161,97,90,245,190,36,84,99,166,217,227,
41,233,98,218,71,22,99,244,224,125,15,35,221,197,9,39,173,31,229,214,21,5,93,
148,122,136,3,73,60,219,233,199,38,214,183,187,83,246,117,224,120,15,46,178,73,
117,10,0,228,143,85,192,60,216,27,143,200,22,62,253,214,192,82,115,229,215,152,
54,145,193,178,168,63,75,17,114,77,173,245,231,250,254,7,189,117,227,65,76,245,
132,253,63,80,55,32,242,64,210,72,107,139,95,147,239,221,104,28,117,196,179,122,
185,39,244,255,0,78,52,143,247,159,126,235,216,235,165,157,208,130,173,111,160,
252,125,1,255,0,82,125,39,145,239,117,235,68,117,198,73,181,49,187,106,185,230,
194,215,191,60,143,165,253,235,173,117,237,105,97,127,173,207,224,1,127,165,143,
22,250,123,247,94,235,17,35,131,107,220,126,126,150,254,159,237,199,191,117,
238,188,88,216,126,63,226,159,208,3,193,247,190,189,214,65,41,11,207,0,255,0,
137,252,242,15,191,117,238,184,51,150,39,212,79,215,251,86,31,235,253,121,247,
239,46,189,215,29,71,235,127,205,172,109,255,0,26,247,239,179,173,117,216,99,
205,199,211,253,133,191,215,247,234,117,190,185,137,23,77,174,194,231,233,127,
175,211,234,47,239,221,107,174,36,158,72,228,3,107,91,223,177,249,117,190,184,
106,252,21,22,254,131,143,247,220,123,215,94,235,220,127,91,127,129,30,253,213,
171,215,96,31,246,222,253,214,234,58,234,231,223,179,142,189,215,119,110,79,248,
251,247,90,52,192,235,32,115,160,143,197,239,254,199,143,126,235,84,207,95,255,
214,208,97,158,107,147,115,201,250,129,233,189,175,199,23,250,123,216,4,240,24,
175,94,52,199,175,88,175,41,55,58,174,13,175,99,245,183,211,233,245,183,191,10,
240,174,58,215,14,185,2,229,133,238,111,207,208,128,62,163,250,15,165,253,184,
56,80,142,188,49,129,214,57,74,217,79,246,128,36,142,65,23,224,159,167,39,253,
135,182,232,60,186,247,81,73,185,191,248,255,0,190,254,190,245,214,250,235,155,
94,246,255,0,122,255,0,31,126,235,221,97,36,222,255,0,227,245,255,0,138,123,
247,94,235,34,185,250,31,192,250,254,64,255,0,31,235,245,247,186,245,238,185,
241,110,13,253,235,175,117,204,59,15,207,3,128,15,210,223,211,253,231,223,186,
247,89,4,162,195,210,1,4,155,243,110,126,131,143,233,239,221,123,174,154,83,248,
39,243,254,31,82,73,255,0,95,235,239,220,126,206,189,243,235,15,191,117,238,
189,239,221,123,172,136,57,185,28,15,167,251,239,240,247,238,189,214,81,249,250,
127,133,255,0,215,31,241,30,253,215,186,228,142,87,232,214,254,167,72,63,214,
223,95,193,62,253,78,189,214,54,127,169,189,205,255,0,216,223,223,186,247,88,
139,19,249,227,142,63,28,127,135,191,117,238,184,251,247,94,235,222,253,215,186,
239,81,181,175,199,251,239,246,62,253,215,186,235,223,186,247,94,247,238,189,
215,53,39,240,56,254,159,208,127,135,191,117,238,179,2,200,67,11,130,57,7,221,8,
253,157,123,167,8,52,202,97,140,40,103,55,85,91,149,179,19,250,139,1,245,91,94,
223,211,221,77,86,167,203,173,245,42,22,104,100,153,90,85,88,216,34,185,72,195,
234,8,203,117,68,112,84,145,245,55,32,123,186,182,8,242,61,104,142,176,79,74,
186,12,203,104,227,209,17,185,87,179,187,153,21,76,90,174,116,157,4,155,113,123,
251,115,30,184,234,181,62,153,233,180,131,249,252,127,95,247,220,255,0,176,247,
175,62,173,215,38,82,63,178,70,149,4,146,15,32,220,234,185,3,143,123,34,148,167,
90,235,25,32,125,79,63,235,27,127,177,63,79,117,235,125,114,87,35,232,65,31,
211,235,254,244,111,111,123,207,94,234,92,147,163,71,24,17,157,32,177,12,69,217,
90,227,141,87,245,40,252,95,243,239,71,229,215,191,62,184,172,151,250,146,164,
125,28,220,130,10,219,212,9,191,251,15,233,239,93,110,156,40,122,112,163,200,
207,72,210,20,72,230,141,213,86,72,165,23,12,21,181,6,70,93,44,142,79,228,115,
238,172,181,193,99,94,181,79,229,210,158,147,120,214,65,251,14,130,40,157,12,66,
59,21,142,18,196,127,148,31,164,178,73,110,46,91,233,253,61,167,120,9,169,6,
167,249,244,224,126,0,244,243,71,184,40,195,134,145,148,47,146,232,82,125,82,
200,57,245,179,72,163,79,39,252,63,30,219,208,227,203,187,173,144,24,126,93,43,
176,231,5,44,105,12,198,54,161,144,25,197,84,240,200,52,212,70,100,103,142,121,
94,68,62,180,39,69,129,214,220,241,245,247,109,76,88,175,250,169,235,215,144,
40,53,114,116,208,240,28,79,144,175,144,249,231,236,235,43,97,98,149,114,31,
103,144,164,104,153,210,58,104,106,34,72,92,106,137,153,86,103,87,111,20,236,
220,45,139,0,64,38,247,246,235,58,234,0,28,116,217,4,174,70,125,63,213,199,160,
254,106,122,168,165,154,47,182,155,68,50,71,12,193,36,109,108,225,137,50,91,65,
212,36,65,110,45,253,125,217,36,20,168,106,245,170,103,167,108,53,132,245,138,
201,58,7,244,233,120,202,132,83,202,186,133,58,125,74,109,244,230,222,212,196,
196,234,39,211,166,100,81,65,246,244,159,170,146,9,38,111,83,104,102,112,250,73,
189,135,54,4,15,87,2,246,183,189,49,245,234,225,5,48,113,211,67,180,49,178,24,
234,165,1,46,209,52,101,211,68,159,81,235,45,96,192,255,0,128,231,221,9,245,29,
88,12,116,236,251,147,33,247,141,60,185,38,173,146,48,85,30,177,47,46,134,117,
125,6,85,179,221,173,207,7,221,22,53,200,80,7,217,215,137,63,159,79,52,219,255,
0,37,4,18,69,20,149,20,241,201,59,159,12,85,50,24,224,114,154,60,148,140,111,
224,213,245,35,77,191,165,189,182,214,200,104,212,207,217,158,156,14,192,17,168,
245,46,109,243,91,87,145,146,182,170,106,89,231,144,81,191,154,122,85,137,41,82,
136,42,248,98,142,32,136,209,206,167,215,233,5,200,4,159,116,146,221,88,0,43,
167,252,53,235,201,41,6,180,207,78,248,237,217,247,53,105,46,66,172,125,140,181,
53,18,73,75,2,43,198,60,232,247,121,138,222,83,4,106,6,133,231,213,199,182,210,
217,35,101,43,29,72,30,125,109,230,102,83,86,165,122,124,161,221,148,114,71,45,
45,108,171,69,78,72,92,57,163,167,113,52,241,44,130,235,81,169,149,162,145,226,
181,173,164,31,235,237,101,77,50,58,78,87,133,58,74,86,211,82,73,28,237,254,91,
59,73,27,10,97,60,42,146,75,165,153,204,68,18,100,89,137,82,8,181,189,235,82,
215,171,80,142,20,232,57,150,74,168,228,119,48,60,34,57,212,232,120,156,8,157,
85,194,198,78,157,22,183,227,243,254,30,239,80,124,250,221,7,88,100,168,121,72,
50,201,207,0,91,133,81,228,187,42,47,209,65,189,248,252,251,209,30,157,120,99,
29,113,242,70,132,44,132,152,181,49,117,83,102,58,137,250,181,191,195,143,175,
187,1,94,29,120,240,36,113,235,184,229,167,191,239,169,10,33,151,237,221,80,92,
189,219,65,147,212,5,255,0,167,189,208,113,61,87,56,234,48,167,138,88,163,187,
34,182,153,29,137,188,122,136,250,175,7,245,27,139,92,90,254,253,64,41,213,186,
143,87,77,36,55,23,30,59,130,47,205,137,80,71,35,252,61,248,241,249,245,177,78,
160,13,65,129,38,246,45,245,250,113,99,107,31,168,32,251,240,52,61,123,143,93,
174,139,49,123,143,73,10,64,184,44,127,168,191,248,251,216,243,199,90,207,145,
235,22,145,123,255,0,79,246,220,123,215,91,235,129,82,57,227,235,248,255,0,95,
250,123,215,94,235,176,183,250,219,159,245,239,245,231,250,123,247,90,235,191,
167,228,216,127,83,126,62,156,1,254,223,223,188,250,247,93,172,154,127,173,184,
60,255,0,95,248,131,239,223,58,117,236,244,231,77,82,63,75,144,137,193,186,139,
234,176,54,13,99,98,73,255,0,99,111,116,42,43,213,129,200,235,140,225,36,215,
172,185,54,66,160,1,97,200,63,95,192,211,244,247,172,129,129,158,173,229,158,
161,45,149,128,63,75,216,147,253,15,248,241,199,183,7,243,234,180,175,14,179,55,
170,224,31,175,208,130,73,22,32,90,250,121,227,223,188,254,93,88,82,185,21,235,
131,146,228,148,213,192,183,214,224,39,210,223,213,120,247,238,181,235,145,78,
184,106,117,141,144,38,164,184,60,139,219,155,90,255,0,236,111,239,223,46,181,
79,95,78,176,147,125,35,139,18,63,173,249,227,242,125,251,175,112,200,235,19,
45,184,226,226,223,235,218,255,0,239,7,223,186,215,88,154,215,62,253,215,186,
227,126,45,248,247,238,189,215,189,251,175,117,221,254,156,15,247,159,248,175,
191,117,238,187,4,127,65,244,255,0,17,205,191,28,218,254,253,215,186,226,125,
251,175,117,239,126,235,221,119,126,111,207,191,117,238,188,8,252,255,0,143,251,
215,189,215,175,117,201,73,36,115,127,175,251,227,239,216,235,221,118,23,232,
109,111,235,127,207,245,54,247,239,94,189,215,122,5,185,63,239,191,222,125,235,
175,117,196,141,63,66,127,31,225,239,221,123,174,55,247,238,183,83,215,32,214,
247,238,183,80,120,245,202,227,73,250,127,197,126,156,251,247,90,243,227,215,
255,215,208,98,162,105,44,25,174,9,26,109,109,43,112,45,192,254,160,123,187,31,
159,90,245,29,66,18,186,253,24,218,247,23,230,196,254,127,215,247,90,245,236,
117,145,103,44,70,178,6,149,176,101,28,241,200,189,190,183,62,246,24,142,188,7,
207,174,111,118,181,197,174,63,194,199,252,110,44,61,232,154,245,190,177,50,1,
123,17,193,35,252,13,191,60,255,0,95,122,235,221,96,54,23,4,255,0,95,249,23,30,
253,215,186,196,109,248,55,255,0,136,255,0,138,223,223,186,247,92,111,239,221,
123,174,65,136,255,0,137,247,238,189,215,61,107,254,62,253,215,186,246,177,254,
63,239,191,216,251,247,94,235,218,215,252,125,251,175,117,202,224,254,71,191,
117,238,188,13,205,128,63,236,120,247,238,189,215,38,107,30,9,54,31,65,245,252,
95,253,143,62,253,215,186,199,228,114,13,175,248,230,255,0,79,126,235,221,112,
37,191,36,223,253,136,247,191,47,159,94,235,171,159,234,127,219,251,215,94,235,
150,166,255,0,109,254,251,159,123,235,221,118,29,191,194,223,235,127,188,95,252,
125,250,157,120,117,222,163,254,2,223,91,159,248,167,189,80,245,238,186,215,254,
28,255,0,190,255,0,111,239,221,123,175,7,254,163,253,183,191,117,238,185,130,
15,211,223,186,247,92,129,210,110,63,222,69,199,251,111,126,235,221,101,212,90,
223,218,60,95,254,52,61,251,173,245,218,72,202,247,23,95,200,34,224,219,250,92,
125,15,189,17,142,183,192,84,30,158,232,101,134,69,169,251,135,118,111,183,145,
144,149,91,52,161,148,38,182,32,232,12,165,133,249,55,246,211,3,138,12,117,170,
231,175,50,201,226,69,75,74,173,24,110,26,239,18,169,111,72,22,224,169,99,254,
23,252,123,116,19,192,245,90,103,168,126,50,12,70,196,191,148,141,14,57,225,
137,22,101,80,9,254,163,235,127,123,235,223,159,88,234,24,151,100,93,100,178,
122,65,99,117,2,250,146,198,215,228,127,182,247,99,246,103,173,15,183,166,238,
121,250,143,234,63,175,244,247,175,183,171,117,218,155,27,254,126,150,252,155,
240,127,195,222,186,247,89,214,66,84,88,91,130,15,228,31,167,224,223,222,235,
214,169,215,53,144,234,186,159,87,0,93,117,131,110,0,34,214,107,1,199,189,117,
97,229,215,40,201,228,41,102,36,242,44,120,6,231,129,110,45,239,126,125,120,
245,207,91,93,3,11,176,176,44,79,44,111,199,22,227,235,239,71,135,203,175,83,
172,169,34,242,72,6,198,197,109,99,254,182,166,83,244,247,77,39,133,122,240,62,
167,29,57,67,147,169,137,68,41,44,158,61,65,202,23,109,36,0,66,144,166,234,8,86,
181,236,64,247,237,42,77,72,207,86,227,246,116,229,75,155,200,37,74,203,28,229,
229,44,93,145,211,90,234,65,96,198,214,4,105,181,173,99,237,166,137,104,53,112,
245,175,86,252,243,212,196,220,21,161,144,29,77,58,178,187,207,20,229,101,101,
99,98,45,34,217,166,26,190,191,143,118,17,0,7,85,226,122,126,162,205,164,223,
112,143,36,130,81,26,106,73,98,119,18,56,97,165,155,66,148,15,24,23,34,252,223,
241,237,232,198,146,192,116,203,121,124,186,67,73,40,50,76,197,139,72,206,192,
44,90,99,211,169,185,4,144,69,249,22,0,114,61,208,158,156,2,158,125,55,121,29,
88,130,161,237,201,185,226,226,255,0,143,160,36,123,183,151,94,175,92,252,139,
44,178,16,214,118,179,128,70,165,36,14,77,249,250,130,57,28,123,240,199,151,90,
62,157,114,70,125,54,80,231,214,215,22,250,19,207,0,139,127,177,246,237,71,231,
213,72,61,122,89,24,202,161,133,180,253,65,252,176,0,11,175,210,227,222,152,87,
61,107,228,15,93,194,210,40,83,19,21,185,110,47,112,74,141,64,90,196,27,159,
240,247,173,52,167,175,94,7,229,94,166,46,78,176,32,140,204,204,177,180,122,117,
54,187,104,215,227,11,228,15,160,169,250,91,233,239,101,49,83,195,175,12,158,
158,49,219,186,190,158,172,212,84,84,121,204,177,205,12,198,104,195,201,166,117,
43,51,199,40,32,36,196,18,21,197,138,147,127,109,152,227,243,25,234,213,35,169,
159,124,181,148,210,172,41,247,82,37,80,150,106,141,76,230,104,25,38,17,157,13,
165,148,161,224,253,111,239,222,23,29,45,142,189,168,231,29,55,10,104,135,218,
74,145,20,150,206,94,208,189,85,49,102,145,180,169,87,86,80,196,122,89,69,244,
159,247,139,105,165,42,112,122,174,186,214,131,61,49,213,165,129,185,118,105,28,
113,164,170,175,168,250,64,43,123,41,63,79,168,22,247,239,240,245,96,72,233,177,
89,212,250,126,168,26,255,0,212,90,252,242,13,189,235,56,175,91,168,244,235,42,
77,164,18,228,2,209,181,152,241,203,63,245,250,27,145,254,195,222,193,235,71,
168,213,53,19,72,228,51,146,1,22,55,38,246,22,28,220,223,222,186,240,234,56,149,
135,244,191,60,219,147,127,175,191,117,190,188,37,31,164,253,9,231,233,111,161,
3,235,254,191,191,117,238,185,112,126,132,255,0,141,143,228,243,244,55,247,
238,189,215,137,183,63,236,127,222,63,226,190,253,215,186,199,228,185,227,143,
240,255,0,123,250,243,239,221,123,174,58,155,145,171,143,233,193,3,250,241,111,
240,247,238,181,249,245,208,114,111,244,254,156,91,233,111,126,235,195,211,174,
196,143,31,33,191,215,4,14,127,199,223,186,247,92,190,234,83,109,86,54,181,191,
179,244,252,18,45,199,191,117,190,164,45,104,44,166,85,33,69,255,0,72,82,15,55,
228,122,73,28,159,207,189,83,143,94,227,199,167,8,222,145,149,218,25,61,98,16,
60,111,22,173,82,56,10,234,167,139,1,115,164,253,71,189,142,189,214,51,226,40,
3,70,218,202,53,152,92,125,56,83,192,37,133,129,191,248,251,247,248,122,247,
92,21,85,22,66,117,50,29,42,45,110,27,245,95,254,65,63,139,15,123,199,167,91,
242,227,212,119,88,218,222,160,6,145,244,95,161,55,181,255,0,214,255,0,121,247,
174,189,212,114,135,234,1,35,233,123,127,188,31,207,191,117,174,163,176,55,185,
255,0,110,62,158,253,215,186,225,239,221,123,175,123,247,94,235,222,253,215,186,
247,191,117,238,187,185,31,241,79,199,251,111,126,235,221,119,171,252,20,255,0,
176,255,0,138,123,247,94,235,189,67,250,91,253,96,63,226,71,191,117,238,187,1,
79,28,127,135,214,255,0,79,207,191,117,238,185,139,95,233,111,246,22,252,255,0,
189,123,240,235,221,115,58,127,4,255,0,190,255,0,109,239,125,123,174,184,247,
238,189,214,39,63,143,246,63,239,191,216,123,215,94,235,31,191,117,238,189,239,
221,123,174,237,197,255,0,216,123,247,94,235,255,208,208,46,70,179,21,215,169,3,
29,60,157,54,63,66,1,60,27,123,217,235,195,172,5,192,250,114,127,222,61,235,
175,117,196,63,245,31,237,189,251,175,117,204,72,63,6,223,235,253,63,226,158,
253,215,186,226,242,51,19,207,231,235,254,251,250,251,247,94,235,133,207,245,63,
237,253,251,175,117,215,191,117,238,189,239,221,123,175,123,247,94,235,222,253,
215,186,247,191,117,238,189,239,221,123,174,75,245,250,92,241,254,195,250,159,
126,235,221,100,45,99,99,205,254,167,243,207,245,250,255,0,196,123,247,94,235,
187,126,108,61,239,175,117,208,252,255,0,182,254,151,177,60,255,0,188,251,215,
94,235,187,11,123,247,94,235,137,81,98,127,60,159,126,235,221,99,63,215,253,
191,231,159,126,235,221,118,9,181,128,191,251,3,255,0,17,239,221,123,174,119,
184,250,114,1,63,78,63,219,255,0,143,191,117,238,177,90,223,236,121,247,238,189,
215,118,255,0,17,244,191,252,107,253,127,126,235,221,117,239,221,123,172,129,
175,97,249,255,0,125,254,62,253,215,186,228,9,228,159,199,251,3,239,221,108,129,
138,117,200,57,4,94,255,0,237,255,0,226,62,158,253,214,192,244,234,82,57,1,172,
77,153,74,159,241,191,224,131,193,30,244,71,90,234,124,51,198,10,25,53,144,177,
233,10,167,72,47,118,182,162,13,244,144,71,248,251,108,131,145,215,177,231,212,
185,173,48,12,146,52,42,11,201,246,226,222,56,164,28,126,214,139,132,214,0,177,
54,212,125,186,14,5,79,90,167,167,76,243,249,100,145,195,179,22,95,82,235,44,
72,82,11,216,22,231,139,159,240,247,191,207,175,112,234,32,98,62,132,143,245,
137,247,174,189,215,94,253,215,186,236,49,7,143,205,197,191,169,247,238,189,215,
174,223,66,214,224,155,1,110,127,216,125,61,251,175,117,228,119,228,220,139,114,
1,39,241,253,63,196,251,221,125,58,247,89,132,237,249,0,243,126,9,31,241,95,
207,189,117,238,178,172,171,168,37,216,169,55,179,16,169,169,190,173,249,181,
191,222,125,251,200,245,190,56,234,72,30,165,120,141,227,114,202,173,37,138,179,
142,29,71,34,195,159,248,175,189,129,130,107,159,78,188,248,225,93,61,101,95,42,
201,195,16,202,47,233,39,143,175,1,71,2,227,241,253,61,251,73,28,71,94,12,15,
236,235,159,145,245,250,217,141,138,242,224,173,192,111,175,170,220,15,205,253,
251,212,17,215,143,1,254,126,179,10,234,138,96,198,41,89,120,230,206,116,0,73,
190,155,126,64,63,239,62,246,49,231,214,180,250,244,220,102,144,234,125,108,215,
98,71,63,165,174,8,113,200,55,30,235,215,186,143,172,146,73,228,158,77,207,4,
159,169,54,250,223,223,186,247,82,99,102,37,181,49,37,18,241,160,22,55,36,2,171,
164,157,22,254,158,253,79,62,181,214,104,76,158,48,89,201,30,82,44,236,73,83,
107,95,147,249,34,199,222,252,190,93,111,169,70,64,210,168,145,47,125,69,155,93,
148,190,147,244,26,131,88,27,112,61,238,191,183,173,122,117,194,48,16,160,103,
123,9,8,254,210,216,88,250,128,250,143,248,145,238,193,137,34,131,61,107,200,
245,2,166,118,98,85,72,0,53,174,44,172,109,127,169,250,253,79,191,22,249,245,
234,14,163,199,80,232,8,184,55,255,0,84,161,191,222,126,190,244,73,207,91,235,
52,85,141,24,54,47,25,58,110,80,220,29,33,172,10,241,245,191,62,233,249,231,
173,17,90,122,116,233,6,126,185,82,10,118,172,168,251,88,172,22,20,158,85,141,1,
111,81,88,195,5,82,65,60,129,126,125,239,83,99,184,211,175,105,25,52,207,89,30,
73,42,83,246,228,51,46,183,210,88,249,36,69,87,184,36,48,214,164,169,250,143,
213,239,93,123,29,55,248,208,217,88,29,77,172,171,95,210,64,44,78,139,155,31,
175,227,253,239,222,198,15,14,183,67,76,30,161,204,154,44,172,73,98,128,128,57,
177,36,157,60,95,223,186,247,80,25,206,175,248,215,189,117,177,215,29,77,253,
125,251,175,117,199,254,35,223,186,247,92,195,16,127,161,191,212,127,189,17,249,
30,253,215,186,203,168,176,1,190,191,239,127,226,8,247,238,189,215,13,60,253,
127,32,219,223,190,93,123,174,249,250,3,249,252,219,233,239,221,123,174,37,109,
244,255,0,14,126,150,255,0,109,201,189,253,251,242,235,93,116,195,129,205,255,0,
222,255,0,226,125,251,173,245,195,223,186,247,94,247,238,189,215,32,204,183,210,
72,191,214,223,159,126,235,221,72,73,152,217,117,127,175,168,159,160,227,131,
98,64,231,233,239,221,123,169,66,105,21,81,91,73,189,220,220,88,216,141,33,129,
176,4,142,79,231,223,186,247,93,186,153,1,35,88,42,64,22,32,128,170,191,225,96,
77,255,0,62,253,215,186,142,99,149,109,203,29,95,66,15,39,233,197,135,231,159,
167,191,117,238,163,176,109,68,54,160,121,4,127,143,215,159,160,23,254,158,253,
215,186,225,110,47,113,254,199,250,255,0,79,233,239,221,123,174,136,35,234,61,
251,175,117,215,191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,
229,164,158,71,63,241,31,237,253,251,175,117,216,86,250,253,15,248,255,0,190,
231,143,126,235,221,100,2,223,242,43,127,190,62,253,215,186,239,223,186,247,94,
250,123,247,94,234,63,215,147,239,221,123,175,123,247,94,235,176,46,109,239,221,
123,172,214,22,183,191,117,238,191,255,209,208,1,141,205,255,0,195,223,186,247,
93,123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,
94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,222,
253,215,186,247,191,117,238,185,131,97,111,235,126,127,167,30,246,5,122,247,92,
61,235,175,117,144,56,22,250,159,235,127,205,255,0,214,247,190,189,215,48,65,
185,36,15,240,191,191,30,189,215,46,45,254,195,250,255,0,143,189,117,238,177,61,
248,31,241,63,241,30,253,215,186,234,192,125,126,188,127,189,243,244,255,0,15,
126,235,220,122,240,99,200,252,88,219,252,45,123,123,247,94,235,141,255,0,223,
127,200,253,251,175,117,215,191,117,238,189,239,221,123,175,123,247,94,235,154,
27,27,127,95,247,191,126,235,221,100,247,238,189,215,129,255,0,11,127,198,184,
247,238,183,214,69,127,195,92,254,111,255,0,17,253,63,30,253,214,186,207,28,128,
106,23,184,101,35,250,27,142,65,228,92,139,251,209,0,231,175,117,33,25,152,170,
169,189,216,91,73,179,141,36,176,184,224,27,15,246,30,247,229,215,177,215,42,
139,27,31,80,145,85,64,114,195,146,46,88,89,127,193,135,251,17,245,247,161,243,
235,221,55,48,252,254,127,63,235,255,0,95,245,143,189,245,238,184,123,247,94,
235,171,144,87,143,207,251,14,57,247,238,189,215,126,253,215,186,238,246,255,0,
95,250,255,0,183,247,238,189,215,94,253,215,186,239,142,63,192,255,0,183,255,0,
91,250,123,247,94,235,38,182,60,16,116,254,7,244,38,220,143,126,24,235,102,167,
175,44,178,165,172,196,88,220,115,110,127,169,191,250,222,237,168,227,61,86,157,
74,90,230,22,14,9,32,240,252,19,166,223,167,73,224,139,251,213,112,49,158,189,
156,117,233,170,34,145,108,131,75,126,74,250,65,34,255,0,85,38,215,255,0,99,239,
216,235,96,159,62,160,220,131,254,63,239,127,241,175,122,235,221,100,18,126,15,
28,127,176,255,0,141,123,247,94,235,50,189,248,86,55,7,240,66,243,110,77,205,
172,127,199,223,186,247,78,81,85,152,212,105,147,65,87,214,37,178,180,214,241,
233,40,46,8,43,171,145,249,3,253,111,123,175,237,235,67,237,207,93,74,240,74,96,
241,59,121,116,13,96,232,141,76,191,66,229,206,155,179,113,97,111,126,52,35,231,
214,250,143,43,128,44,236,127,109,156,92,48,212,77,200,184,2,225,64,63,139,251,
247,94,233,174,73,14,163,245,107,159,169,250,159,173,191,175,191,84,245,238,177,
25,15,251,15,246,254,253,94,189,215,131,159,200,191,251,199,189,117,238,178,
171,3,98,13,143,231,252,57,250,251,247,94,234,101,53,68,180,242,69,60,77,166,72,
157,100,70,176,96,29,13,212,149,32,169,250,126,69,189,251,175,116,250,153,99,88,
102,142,189,159,68,237,44,172,97,88,192,73,157,15,238,36,94,132,91,183,214,196,
11,94,194,254,247,90,156,158,171,74,112,233,186,116,73,90,52,140,171,5,69,13,
42,144,3,18,91,212,67,105,40,67,112,64,191,210,254,253,229,214,254,126,93,54,
73,5,198,161,127,169,1,173,96,214,181,199,244,184,191,191,83,175,127,135,168,
133,74,253,125,235,173,245,199,223,186,247,94,247,238,189,215,32,127,7,233,254,
242,63,214,247,238,189,214,80,111,253,47,254,31,145,253,125,251,175,117,223,191,
117,238,184,223,253,239,243,254,243,111,126,235,85,235,196,7,252,218,198,194,
255,0,235,95,233,245,30,253,214,250,198,84,175,215,243,239,221,123,174,62,253,
215,186,247,191,117,238,189,244,228,123,247,94,235,32,149,248,5,137,0,88,2,79,3,
250,15,240,247,238,189,212,184,165,82,65,86,208,109,200,36,129,233,23,224,254,
15,22,22,247,238,189,212,207,45,252,122,84,170,27,107,28,159,37,175,118,36,146,
57,28,113,239,223,224,235,125,99,156,44,165,202,41,85,212,110,186,150,192,31,
162,139,182,182,28,27,251,247,174,58,208,7,172,38,145,10,6,70,58,155,128,150,
191,224,159,175,214,252,123,247,94,234,27,44,137,125,64,216,113,123,2,166,223,
227,253,45,239,221,123,174,4,131,248,177,252,254,63,219,127,135,191,117,238,186,
191,245,0,255,0,188,127,189,113,239,221,123,174,189,251,175,117,239,245,184,247,
238,189,215,96,145,244,247,238,189,214,64,223,91,142,7,228,31,246,222,253,246,
117,238,185,130,15,231,143,240,255,0,122,255,0,95,223,186,223,94,35,252,79,251,
15,126,235,223,151,94,247,238,181,214,11,27,218,220,251,247,94,235,192,18,109,
249,247,238,189,214,101,91,112,62,191,239,126,253,215,186,236,253,7,250,231,253,
235,243,239,126,157,123,175,255,210,208,0,251,217,235,221,117,239,93,123,175,
123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,
235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,187,31,
246,255,0,237,237,254,183,191,117,238,178,129,97,254,60,219,252,63,226,61,251,
175,117,135,223,186,247,92,172,110,63,199,253,184,255,0,97,239,125,123,174,191,
175,248,255,0,197,125,235,175,117,204,18,188,159,207,227,233,239,221,123,174,
152,220,143,240,255,0,109,254,240,125,251,175,117,195,223,186,247,94,30,253,215,
186,247,191,117,238,187,177,227,143,175,211,223,186,247,94,247,238,189,215,94,
253,215,186,247,191,117,238,185,6,35,250,127,177,255,0,90,222,253,215,186,229,
175,252,63,222,127,226,125,251,175,117,222,177,205,191,222,126,158,253,215,186,
228,79,251,207,244,231,253,247,30,253,215,186,203,27,50,186,149,44,45,115,192,
191,224,220,17,244,32,253,61,251,175,117,204,76,27,131,107,220,155,243,200,255,
0,19,244,247,238,189,215,25,24,19,192,2,246,35,235,192,252,91,233,239,221,123,
172,94,253,215,186,247,191,117,238,185,21,63,143,235,107,95,253,181,189,251,175,
117,198,223,236,61,251,175,117,226,45,239,221,123,174,248,191,215,143,246,222,
253,214,199,93,234,36,139,147,110,1,250,243,111,126,235,192,158,187,97,201,227,
143,248,143,233,239,192,245,227,158,184,129,127,233,111,207,251,239,241,247,190,
181,214,41,63,28,127,188,115,254,223,250,31,122,235,221,114,18,1,245,254,159,91,
126,125,251,173,117,222,181,254,191,211,250,251,247,91,235,194,64,15,6,223,239,
190,128,216,251,247,94,235,32,159,139,127,95,175,224,126,45,126,63,195,223,186,
247,159,93,249,143,166,214,186,242,63,39,240,127,219,95,223,186,247,94,105,25,
239,170,198,229,154,246,254,211,14,79,31,215,253,183,191,117,238,176,178,223,
243,111,240,250,255,0,177,255,0,99,239,221,123,172,68,16,108,125,251,175,117,
215,191,117,238,189,239,125,123,172,209,204,80,169,250,216,253,15,244,227,139,
255,0,176,247,238,189,212,191,36,76,47,98,140,20,125,44,85,136,28,159,197,175,
239,93,123,175,36,197,110,21,236,27,78,161,199,58,77,199,212,126,15,191,117,238,
156,140,201,83,22,137,52,70,177,179,72,172,196,45,164,144,0,66,170,128,164,16,
188,251,181,106,41,213,105,251,122,106,146,50,90,192,93,137,32,168,31,86,191,
210,223,75,223,250,123,175,86,234,43,173,190,128,254,110,63,167,191,117,238,177,
145,110,15,191,117,238,189,239,221,123,172,137,127,233,199,224,255,0,196,127,
177,247,238,189,214,79,126,235,221,116,71,250,223,155,123,247,94,35,135,93,41,
250,131,245,30,253,215,186,229,115,254,195,250,123,247,94,235,162,128,243,244,
63,225,249,255,0,88,127,176,247,238,189,214,34,164,127,173,253,125,251,175,117,
199,223,186,247,94,247,238,189,215,99,252,127,223,127,197,125,251,175,117,33,37,
117,224,55,28,88,30,84,243,123,115,244,231,253,143,191,117,236,245,46,58,129,
113,194,163,170,184,12,170,9,58,249,55,6,224,216,92,15,232,15,248,123,247,94,
169,233,197,101,163,106,45,114,121,82,116,169,137,35,41,109,34,17,19,121,3,149,
42,117,150,177,6,222,247,229,243,175,94,6,191,103,92,34,88,164,73,81,90,54,117,
141,220,41,98,202,250,164,139,66,163,0,45,42,131,249,252,143,126,245,235,127,
111,80,234,169,214,52,138,199,247,10,130,233,160,169,141,135,36,19,107,57,177,
31,235,123,215,91,165,120,14,160,181,59,4,15,107,43,18,16,223,245,21,250,129,
253,109,239,212,235,84,235,1,82,62,163,254,41,239,221,107,174,189,251,175,117,
239,126,235,221,123,223,186,247,89,22,199,252,13,207,35,243,127,240,247,238,189,
214,91,255,0,91,88,127,128,255,0,141,123,247,94,235,175,126,235,221,122,220,27,
123,247,91,29,113,183,60,91,253,107,127,196,253,125,251,175,117,201,1,6,227,147,
207,28,145,111,207,30,247,215,171,212,175,7,252,24,88,91,232,183,60,91,129,254,
7,243,239,212,205,58,181,23,142,105,215,255,211,249,255,0,251,247,94,235,222,
253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,
247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,
238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,189,239,
221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,
123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,
235,222,253,215,186,247,191,117,238,189,239,221,123,174,193,35,232,72,255,0,91,
223,186,247,94,212,127,169,255,0,110,125,251,175,117,235,159,234,127,219,159,
126,235,221,122,231,250,159,246,231,223,186,247,94,185,254,167,253,191,191,117,
238,189,115,253,79,251,115,239,221,123,175,106,111,245,71,253,185,247,238,189,
215,174,127,169,255,0,110,125,251,175,117,235,159,234,127,219,159,126,235,221,
122,231,250,159,246,231,223,186,247,94,212,127,169,255,0,110,125,251,175,117,
237,71,250,159,246,231,223,186,247,94,185,254,167,253,185,247,238,189,215,174,
127,169,231,252,125,251,175,117,215,191,117,238,189,239,221,123,175,123,247,94,
235,222,253,215,186,247,191,117,238,187,185,31,66,125,251,175,117,235,159,234,
127,219,159,126,235,221,117,114,126,164,159,126,235,221,123,223,186,247,94,247,
238,189,215,189,251,175,117,221,207,245,63,237,253,251,175,117,235,159,234,127,
219,159,126,235,221,119,169,191,213,55,251,115,239,221,123,175,107,127,174,182,
184,250,29,71,143,247,159,126,235,221,117,114,127,39,253,185,247,238,189,215,87,
191,215,223,186,247,94,247,238,189,215,119,35,242,127,219,251,247,94,235,215,63,
212,255,0,183,247,238,189,215,35,244,250,220,3,249,39,159,248,131,239,221,123,
174,30,253,215,186,238,231,250,159,246,254,253,215,186,245,207,245,63,237,207,
191,117,238,189,115,249,39,252,57,63,95,126,235,221,117,239,221,123,175,123,247,
94,235,222,253,215,186,247,191,117,238,187,185,254,167,253,191,191,117,238,178,
44,132,30,73,185,227,85,205,255,0,192,31,122,60,49,215,134,60,186,230,205,97,
112,126,171,207,63,171,155,243,253,121,247,161,95,94,183,215,33,36,150,31,185,
39,245,30,182,226,227,241,207,244,247,234,154,211,175,87,246,117,196,146,127,
39,253,191,245,250,255,0,183,247,226,125,58,247,88,216,17,244,38,223,145,127,
247,220,123,240,62,71,173,117,143,221,186,247,94,247,238,189,215,189,251,175,
117,239,126,235,221,122,231,250,251,247,94,235,187,159,234,125,251,175,117,235,
159,234,127,219,159,126,235,221,122,231,250,159,246,254,253,215,186,240,102,31,
70,35,241,193,35,143,233,239,221,123,174,94,73,62,154,222,223,79,212,223,79,
246,254,253,215,186,255,212,249,255,0,251,247,94,235,222,253,215,186,247,191,
117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,189,
239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,
175,123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,
94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,222,
253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,
247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,
238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,189,239,
221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,
123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,
235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,
215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,
191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,
189,239,221,123,174,192,191,191,117,227,142,187,210,71,63,239,94,245,94,189,215,
102,218,87,253,177,23,250,17,127,199,245,62,252,60,250,247,92,69,136,255,0,31,
197,191,63,225,239,223,224,235,221,120,2,126,159,241,30,253,94,189,215,97,88,
155,91,253,247,251,15,126,175,94,235,162,44,109,239,125,123,174,189,251,175,117,
239,126,235,221,123,223,186,247,94,247,238,189,215,189,251,175,117,239,126,235,
221,123,223,186,247,92,195,216,90,215,255,0,99,239,84,205,122,247,93,235,255,0,
15,247,159,248,215,189,105,249,245,238,186,46,127,28,123,246,158,189,215,15,
118,235,221,123,223,186,247,94,247,238,189,215,189,251,175,117,239,126,235,221,
123,223,186,247,94,247,238,189,215,189,251,175,117,239,126,235,221,123,223,186,
247,95,255,213,249,255,0,251,247,94,235,222,253,215,186,247,191,117,238,189,239,
221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,
123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,
235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,
215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,
191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,
185,5,185,255,0,97,127,122,39,175,117,209,22,60,253,63,222,199,191,113,29,123,
175,27,126,63,167,251,207,191,103,173,245,215,189,245,174,189,239,221,123,175,
123,247,94,235,187,126,125,234,189,110,159,62,186,247,190,181,215,189,251,175,
117,239,126,235,221,123,223,186,247,94,247,238,189,215,189,251,175,117,239,126,
235,221,123,223,186,247,94,247,238,189,215,189,251,175,117,239,126,235,221,123,
223,186,247,94,181,253,251,175,117,217,4,125,71,191,117,238,186,247,238,189,215,
189,251,175,117,239,126,235,221,123,223,186,247,94,247,238,189,215,189,251,175,
117,239,126,235,221,123,223,186,247,94,247,238,189,215,189,251,175,117,239,126,
235,221,114,210,126,164,113,254,251,241,127,122,175,94,235,160,56,39,253,135,
250,247,247,190,189,214,123,113,254,31,239,191,226,158,235,229,215,186,226,214,
177,191,244,227,254,35,223,135,94,235,15,211,221,186,247,89,3,11,253,45,254,63,
95,247,175,117,167,207,173,245,205,92,175,7,73,185,6,246,231,253,111,240,7,223,
136,235,93,113,118,212,73,43,201,227,243,254,63,67,245,54,183,191,1,243,235,125,
99,32,143,175,187,117,174,186,247,238,189,215,189,251,175,117,239,126,235,221,
123,223,186,247,94,247,238,189,215,189,251,175,117,239,126,235,221,123,223,186,
247,94,247,238,189,215,189,251,175,117,239,126,235,221,123,223,186,247,94,247,
238,189,215,189,251,175,117,239,126,235,221,123,223,186,247,94,247,238,189,215,
189,251,175,117,239,126,235,221,127,255,214,249,255,0,251,247,94,235,222,253,
215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,
191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,
189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,
123,175,123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,
247,94,235,222,253,215,186,238,222,253,214,192,175,93,123,247,90,167,94,247,238,
189,215,189,251,175,117,239,126,235,221,101,22,226,214,255,0,137,255,0,145,123,
161,249,245,110,188,127,222,63,63,225,254,62,252,63,159,85,235,31,210,227,253,
247,245,255,0,31,119,235,221,117,239,221,123,175,123,247,94,235,222,253,215,186,
228,62,159,236,127,175,189,117,101,235,143,189,245,94,189,239,221,123,175,123,
247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,
222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,152,66,126,
188,127,175,245,63,235,15,122,175,94,235,178,192,112,163,233,254,247,110,77,193,
231,253,235,223,169,94,61,111,174,55,7,234,63,216,143,247,187,113,239,212,62,
189,107,175,122,127,23,31,235,253,63,222,61,251,61,123,174,62,247,215,186,247,
191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,
189,239,221,123,175,123,247,94,235,222,253,215,186,230,131,155,255,0,79,248,159,
117,110,189,215,153,175,192,255,0,145,251,216,242,175,94,235,154,88,105,212,46,
63,168,185,228,222,196,139,143,167,189,87,143,94,235,33,184,28,243,113,123,253,
63,35,159,241,250,123,240,207,94,234,51,114,79,189,142,189,215,133,175,255,0,
26,189,255,0,215,231,222,250,247,89,53,143,232,125,214,157,111,175,107,31,211,
253,227,252,45,253,125,250,135,175,117,209,115,205,141,191,214,31,241,39,159,
123,3,175,117,192,2,223,79,126,235,93,101,0,1,107,127,198,253,235,237,235,221,
116,80,31,240,255,0,125,253,61,238,167,175,117,140,139,123,240,53,235,221,117,
239,125,123,175,123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,
175,123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,
94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,222,
253,215,186,247,191,117,238,191,255,215,249,255,0,251,247,94,235,222,253,215,
186,247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,
117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,189,
239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,
175,123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,
94,235,222,253,215,186,239,241,239,93,91,203,143,94,247,238,181,215,94,247,214,
186,239,253,143,250,223,239,191,216,251,215,94,235,214,55,183,251,239,248,223,
189,245,238,185,2,0,255,0,31,175,251,207,186,145,83,214,199,89,63,28,255,0,78,
125,215,175,117,195,77,239,245,255,0,99,244,247,106,240,235,93,112,32,143,175,
231,221,186,247,93,123,247,94,235,159,12,9,250,88,127,197,125,235,135,91,61,113,
31,159,126,235,195,207,174,189,239,173,117,239,126,235,221,123,223,186,247,94,
247,238,189,215,189,251,175,117,239,126,235,221,123,223,186,247,94,247,238,189,
215,189,251,175,117,201,87,81,181,192,255,0,95,253,247,62,253,90,117,238,179,
105,68,177,227,252,9,255,0,136,95,117,227,215,186,233,155,87,164,22,63,142,0,
191,227,234,109,239,125,123,172,86,0,144,127,31,241,75,251,246,122,216,167,94,
36,127,64,125,251,61,108,211,174,35,159,123,234,189,114,43,111,175,189,3,94,
189,215,31,123,235,221,123,223,186,247,94,247,238,189,215,189,251,175,117,239,
126,235,221,123,223,186,247,94,247,238,189,215,189,251,175,117,221,248,183,248,
223,223,186,247,94,28,145,254,191,191,117,238,179,0,5,207,211,253,235,250,31,
247,143,117,227,215,186,231,113,107,127,129,177,255,0,96,109,239,196,28,158,189,
214,18,56,176,23,60,92,253,63,228,126,253,243,60,58,247,92,8,183,60,127,176,62,
247,94,189,215,128,39,223,171,214,232,122,230,19,250,159,122,169,242,29,107,174,
128,23,254,191,239,31,242,63,199,251,127,123,39,29,123,172,131,233,254,251,253,
227,223,169,78,189,215,126,252,105,95,159,94,235,27,63,244,255,0,111,239,212,
175,30,189,215,11,30,126,191,227,255,0,27,247,190,189,215,94,253,215,186,247,
191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,
189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,
123,175,123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,
247,94,235,255,208,249,255,0,251,247,94,235,222,253,215,186,247,191,117,238,189,
239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,
175,123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,
94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,222,
253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,
247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,238,254,253,
215,186,236,92,253,15,63,129,253,127,175,189,30,183,215,34,26,223,171,253,226,
220,127,176,247,161,79,78,181,215,90,73,252,131,254,196,159,126,168,30,93,123,
174,54,255,0,125,255,0,20,252,123,183,94,235,196,91,253,231,143,200,231,243,239,
93,123,175,15,168,191,245,247,227,195,175,117,204,129,254,222,255,0,239,94,244,
58,176,225,215,3,239,99,175,55,93,123,223,85,235,222,253,215,186,247,191,117,
238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,189,239,
221,123,174,65,73,228,90,227,159,199,211,250,253,125,234,189,123,174,244,150,
177,189,238,109,115,248,254,183,63,79,247,159,126,235,221,115,210,71,165,71,34,
252,220,16,64,228,18,65,60,251,245,122,223,88,244,146,126,163,252,79,251,239,
207,191,84,117,238,188,86,223,159,247,143,126,175,94,167,93,125,61,239,175,100,
117,205,255,0,30,234,62,125,122,180,235,31,187,117,174,189,239,221,123,175,123,
247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,
222,253,215,186,247,191,117,238,187,22,191,63,79,122,63,46,189,214,97,244,255,0,
96,61,232,227,175,117,227,123,27,127,128,255,0,15,247,214,247,238,189,215,64,
88,91,221,78,122,247,93,48,189,185,0,95,222,199,159,94,235,161,245,63,211,254,
32,113,239,125,111,174,87,224,159,167,214,215,227,253,111,175,189,14,61,123,
174,151,234,13,255,0,79,211,250,19,255,0,26,191,189,245,238,187,102,183,250,254,
253,196,252,186,215,92,61,76,109,248,255,0,120,247,188,15,183,175,117,204,0,163,
233,127,248,159,245,236,47,238,181,207,91,235,144,146,195,158,71,23,255,0,82,
109,205,173,114,56,255,0,121,247,190,189,215,71,73,36,128,8,63,75,113,201,7,250,
15,193,247,239,46,189,214,18,121,255,0,1,192,255,0,91,222,199,90,235,175,123,
235,221,123,223,186,247,94,247,238,189,215,189,251,175,117,239,126,235,221,123,
223,186,247,94,247,238,189,215,189,251,175,117,239,126,235,221,123,223,186,247,
94,247,238,189,215,189,251,175,117,239,126,235,221,123,223,186,247,95,255,209,
249,255,0,251,247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,
123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,
235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,
215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,
191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,
189,239,221,123,175,123,247,94,235,222,253,215,186,239,241,244,252,253,121,255,
0,125,249,247,174,189,215,136,177,255,0,137,31,241,30,247,199,175,117,204,53,
205,173,245,191,63,235,243,238,164,121,245,238,188,164,114,63,219,95,250,127,79,
126,35,207,175,117,192,253,79,189,142,29,123,174,87,36,127,174,46,127,39,253,79,
31,79,122,235,221,112,247,110,189,215,48,215,250,253,61,214,158,157,88,124,186,
241,28,31,235,255,0,17,239,192,245,227,145,215,15,118,234,189,123,223,186,247,
94,247,238,189,215,189,251,175,117,239,126,235,221,114,11,253,127,226,191,239,
94,245,94,183,78,187,210,63,55,255,0,110,63,226,125,234,189,122,157,118,20,127,
78,15,245,255,0,136,183,191,84,245,234,117,235,94,224,11,15,247,223,159,241,
247,190,189,142,185,1,111,247,223,214,215,255,0,111,111,122,235,221,120,158,127,
226,125,235,175,83,175,115,248,255,0,98,125,251,175,125,189,116,109,107,95,253,
111,126,29,108,86,189,99,3,145,254,189,189,223,170,245,205,173,192,60,216,127,
177,247,81,83,213,177,158,177,251,183,85,235,222,253,215,186,247,191,117,238,
189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,
123,175,123,247,94,235,222,253,215,186,230,88,255,0,95,247,143,117,160,235,221,
117,168,255,0,173,254,183,189,208,117,238,185,6,63,210,255,0,235,123,213,0,60,
122,247,92,117,115,114,47,113,107,123,221,58,247,92,181,0,63,62,245,67,214,250,
226,90,252,11,255,0,196,159,123,3,175,117,208,250,255,0,79,207,191,30,29,120,
117,147,79,245,39,221,107,214,235,215,96,91,129,239,92,122,215,94,63,211,159,
123,235,71,174,173,123,115,192,250,15,235,199,215,223,171,79,183,173,245,217,
250,125,108,63,214,191,191,15,179,173,117,135,221,250,247,94,247,238,189,215,
189,251,175,117,239,126,235,221,123,223,186,247,94,247,238,189,215,189,251,175,
117,239,126,235,221,123,223,186,247,94,247,238,189,215,189,251,175,117,239,126,
235,221,123,223,186,247,94,247,238,189,215,189,251,175,117,255,210,249,255,0,
251,247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,
235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,
215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,
191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,
189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,
123,175,123,247,94,235,222,253,215,186,228,45,205,254,188,255,0,189,125,61,232,
215,175,117,203,234,63,22,181,205,191,175,62,245,195,173,253,189,99,247,110,181,
215,189,251,175,117,223,215,253,241,227,254,53,239,221,123,175,3,99,127,126,235,
221,120,155,155,251,240,199,94,235,175,126,235,221,100,4,17,254,63,78,126,158,
234,122,183,92,108,57,191,215,241,239,121,235,100,117,199,222,250,167,94,247,
238,189,215,96,19,244,247,238,189,215,127,79,122,234,224,117,145,81,219,244,173,
239,199,226,223,83,249,227,233,239,93,106,189,116,7,214,255,0,94,65,31,227,254,
63,210,199,223,186,245,122,236,155,127,79,248,159,248,208,247,174,181,215,175,
127,232,62,159,236,125,248,245,236,14,189,254,218,254,245,215,191,193,215,129,
254,191,239,143,248,127,135,189,245,179,242,235,142,171,255,0,128,189,191,228,
103,241,239,116,235,88,235,142,161,253,56,255,0,92,251,221,58,245,122,237,69,
205,255,0,31,239,173,239,222,157,123,174,44,110,79,191,14,181,215,94,247,215,
186,247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,
117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,189,
239,221,123,174,86,226,252,127,135,215,222,171,158,181,231,215,119,0,126,9,63,
210,220,123,215,31,179,173,245,195,221,186,247,94,247,238,189,215,189,251,175,
117,216,7,241,239,221,123,172,194,231,241,207,248,123,165,58,223,93,144,71,215,
223,169,215,186,227,97,253,7,252,87,253,127,126,31,111,90,235,190,62,190,245,
214,250,196,196,241,248,35,250,31,119,0,117,174,184,251,223,94,235,222,253,215,
186,247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,
117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,189,
239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,191,255,211,249,
255,0,251,247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,
247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,
222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,
186,247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,
117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,189,
239,221,123,175,123,247,94,235,222,253,215,186,236,127,79,235,254,247,239,221,
123,174,189,251,175,117,239,126,235,221,123,223,186,247,94,247,238,189,215,189,
251,175,117,239,126,235,221,123,223,186,247,93,131,111,247,171,123,209,29,108,
117,144,88,241,110,63,62,234,122,217,249,245,237,32,95,242,61,238,191,183,173,
124,186,235,77,190,191,79,126,175,167,91,249,117,217,31,77,54,30,245,95,94,189,
94,186,177,184,176,254,159,211,147,253,72,252,123,216,235,221,102,5,2,234,177,
215,244,181,130,168,250,139,240,110,220,125,120,3,223,186,215,88,201,255,0,145,
127,196,159,240,247,174,183,215,11,243,127,123,234,221,114,250,130,127,63,75,
251,215,203,170,240,52,235,142,171,126,63,215,62,247,78,183,215,68,255,0,177,
247,186,117,170,129,195,174,137,191,189,245,94,188,61,251,173,142,185,14,20,255,
0,83,239,92,79,94,235,135,189,245,174,189,239,221,123,175,123,247,94,235,222,
253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,
247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,
238,189,239,221,123,175,123,247,94,235,176,46,109,239,68,211,175,117,205,84,16,
110,63,60,255,0,176,247,172,215,229,215,186,200,63,223,127,135,189,211,173,252,
250,230,164,15,167,36,254,127,226,61,232,131,215,186,224,120,39,223,190,222,189,
215,31,168,63,236,71,251,225,239,93,107,172,122,143,30,237,78,181,78,184,222,
255,0,239,94,247,214,250,247,191,117,238,189,239,221,123,175,123,247,94,235,222,
253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,
247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,
238,189,239,221,123,175,123,247,94,235,255,212,249,255,0,251,247,94,235,222,253,
215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,
191,117,238,189,239,221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,
187,31,159,245,143,189,31,46,180,124,186,235,222,250,223,94,247,238,189,215,189,
251,175,117,239,126,235,221,123,223,186,247,94,247,238,189,215,189,251,175,117,
239,126,235,221,123,223,186,247,94,247,238,189,215,189,251,175,117,239,126,235,
221,119,253,126,191,95,248,175,215,252,125,251,175,117,215,191,117,238,189,239,
221,123,174,255,0,175,250,223,241,35,223,186,247,167,93,123,247,94,235,222,253,
215,186,247,191,117,238,185,15,210,223,236,63,222,253,232,241,29,123,174,62,247,
215,186,247,191,117,191,46,189,239,221,120,113,29,115,95,168,255,0,125,248,247,
83,213,188,186,230,62,159,236,79,251,223,189,30,171,215,191,219,125,127,226,79,
191,117,238,189,254,251,252,62,191,239,126,253,214,250,229,253,125,251,200,245,
175,94,184,55,251,31,248,143,249,31,189,142,182,58,226,126,167,253,127,126,234,
195,135,94,252,127,177,31,241,62,253,215,188,250,232,251,223,90,60,58,241,250,
123,247,94,60,58,227,239,125,83,175,123,247,94,235,191,233,254,251,243,239,221,
111,211,175,31,126,235,199,174,189,251,173,117,239,126,235,221,123,223,186,247,
94,247,238,189,215,189,251,175,117,239,126,235,221,123,223,186,247,94,247,238,
189,215,189,251,175,117,239,126,235,221,123,223,186,247,94,247,238,189,215,189,
251,175,117,239,126,235,221,123,223,186,247,89,23,244,255,0,177,255,0,136,247,
83,199,173,30,29,114,79,210,63,216,255,0,189,251,223,175,91,235,32,250,159,246,
63,239,94,245,213,188,207,94,254,201,255,0,131,126,62,159,79,247,175,123,243,
252,186,175,92,15,189,31,46,183,214,31,245,95,241,31,79,168,250,123,223,167,90,
235,179,250,71,251,31,126,243,61,123,174,62,247,215,186,247,191,117,238,189,239,
221,123,175,123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,
123,247,94,235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,
235,222,253,215,186,247,191,117,238,189,239,221,123,175,123,247,94,235,255,217};
static Fl_JPEG_Image image_launcher_bg("launcher_bg.jpg", idata_launcher_bg);

void cUserInterface::cb_CBQPreset_i(Fl_Choice*, void*) {
  int lSelectedItem = CBQPreset->value();
cConfigFile* pPreset = mvPresets[lSelectedItem];

if(pPreset==NULL) return;

cLauncherHelper::UpdateConfigFileWithPreset(mpConfigFile, pPreset);
cLauncherHelper::SetInitialValues(mpConfigFile, this);
}
void cUserInterface::cb_CBQPreset(Fl_Choice* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_CBQPreset_i(o,v);
}

Fl_Menu_Item cUserInterface::menu_CBQPreset[] = {
 {"Low", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Medium", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"High", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Custom", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};
Fl_Menu_Item* cUserInterface::MIQPLow = cUserInterface::menu_CBQPreset + 0;
Fl_Menu_Item* cUserInterface::MIQPMed = cUserInterface::menu_CBQPreset + 1;
Fl_Menu_Item* cUserInterface::MIQPHigh = cUserInterface::menu_CBQPreset + 2;
Fl_Menu_Item* cUserInterface::MIQPCustom = cUserInterface::menu_CBQPreset + 3;

void cUserInterface::cb_BDetectSettings_i(Fl_Button*, void*) {
  cLauncherHelper::DetectSettings(this, mpConfigFile, mvPresets, mpQualityChooser, msCardString);
}
void cUserInterface::cb_BDetectSettings(Fl_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_BDetectSettings_i(o,v);
}

void cUserInterface::cb_CBLanguage_i(Fl_Choice*, void*) {
  int lValue = CBLanguage->value();
const tString& sLangFile = mvLanguageFiles[lValue];
cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Main", "StartLanguage", sLangFile);

Fl::delete_widget(LauncherWindow);
}
void cUserInterface::cb_CBLanguage(Fl_Choice* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_CBLanguage_i(o,v);
}

void cUserInterface::cb_CBResolution_i(Fl_Choice*, void*) {
  int lValue = (long int)CBResolution->mvalue()->user_data();
cVideoMode& vMode = mvVModes[lValue];
cLauncherHelper::UpdateConfigFile(this, mpConfigFile,"Screen", "Width", vMode.mvScreenSize.x);
cLauncherHelper::UpdateConfigFile(this, mpConfigFile,"Screen", "Height", vMode.mvScreenSize.y);
cLauncherHelper::UpdateConfigFile(this, mpConfigFile,"Screen", "Display", vMode.mlDisplay);
}
void cUserInterface::cb_CBResolution(Fl_Choice* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_CBResolution_i(o,v);
}

void cUserInterface::cb_ChBFullScreen_i(Fl_Check_Button*, void*) {
  cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Screen", "FullScreen", ChBFullScreen->value()==1);
}
void cUserInterface::cb_ChBFullScreen(Fl_Check_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_ChBFullScreen_i(o,v);
}

void cUserInterface::cb_CBShadowQ_i(Fl_Choice*, void*) {
  cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Graphics", "ShadowQuality", CBShadowQ->value());
}
void cUserInterface::cb_CBShadowQ(Fl_Choice* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_CBShadowQ_i(o,v);
}

Fl_Menu_Item cUserInterface::menu_CBShadowQ[] = {
 {"Low", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Medium", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"High", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};
Fl_Menu_Item* cUserInterface::MISQLow = cUserInterface::menu_CBShadowQ + 0;
Fl_Menu_Item* cUserInterface::MISQMed = cUserInterface::menu_CBShadowQ + 1;
Fl_Menu_Item* cUserInterface::MISQHigh = cUserInterface::menu_CBShadowQ + 2;

void cUserInterface::cb_CBShadowRes_i(Fl_Choice*, void*) {
  cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Graphics", "ShadowResolution", CBShadowRes->value());
}
void cUserInterface::cb_CBShadowRes(Fl_Choice* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_CBShadowRes_i(o,v);
}

Fl_Menu_Item cUserInterface::menu_CBShadowRes[] = {
 {"Low", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Medium", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"High", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};
Fl_Menu_Item* cUserInterface::MISRLow = cUserInterface::menu_CBShadowRes + 0;
Fl_Menu_Item* cUserInterface::MISRMed = cUserInterface::menu_CBShadowRes + 1;
Fl_Menu_Item* cUserInterface::MISRHigh = cUserInterface::menu_CBShadowRes + 2;

void cUserInterface::cb_BShowAdvanced_i(Fl_Button*, void*) {
  SetWidgetEnabled(GroupBasicGfxOptions, false);
SetWidgetVisible(GroupBasicGfxOptions, false);

SetWidgetEnabled(GroupAdvancedGfxOptions, true);
SetWidgetVisible(GroupAdvancedGfxOptions, true);
}
void cUserInterface::cb_BShowAdvanced(Fl_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_BShowAdvanced_i(o,v);
}

void cUserInterface::cb_CBTexQ_i(Fl_Choice*, void*) {
  cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Graphics", "TextureQuality", (CBTexQ->size()-1-1)-CBTexQ->value());
}
void cUserInterface::cb_CBTexQ(Fl_Choice* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_CBTexQ_i(o,v);
}

Fl_Menu_Item cUserInterface::menu_CBTexQ[] = {
 {"Low", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Medium", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"High", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};
Fl_Menu_Item* cUserInterface::MITQLow = cUserInterface::menu_CBTexQ + 0;
Fl_Menu_Item* cUserInterface::MITQMed = cUserInterface::menu_CBTexQ + 1;
Fl_Menu_Item* cUserInterface::MITQHigh = cUserInterface::menu_CBTexQ + 2;

void cUserInterface::cb_CBAnisotropy_i(Fl_Choice*, void*) {
  int lValue = (long int)CBAnisotropy->mvalue()->user_data();
cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Graphics", "TextureAnisotropy", (float)lValue);
}
void cUserInterface::cb_CBAnisotropy(Fl_Choice* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_CBAnisotropy_i(o,v);
}

Fl_Menu_Item cUserInterface::menu_CBAnisotropy[] = {
 {"Off", 0,  0, (void*)(1), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"2x", 0,  0, (void*)(2), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"4x", 0,  0, (void*)(4), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"8x", 0,  0, (void*)(8), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"16x", 0,  0, (void*)(16), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};
Fl_Menu_Item* cUserInterface::MIAnisotropyOff = cUserInterface::menu_CBAnisotropy + 0;

void cUserInterface::cb_ChBSSAO_i(Fl_Check_Button*, void*) {
  cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Graphics", "SSAOActive", ChBSSAO->value()==1);
}
void cUserInterface::cb_ChBSSAO(Fl_Check_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_ChBSSAO_i(o,v);
}

void cUserInterface::cb_CBSSAORes_i(Fl_Choice*, void*) {
  cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Graphics", "SSAOResolution", CBSSAORes->value());
}
void cUserInterface::cb_CBSSAORes(Fl_Choice* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_CBSSAORes_i(o,v);
}

Fl_Menu_Item cUserInterface::menu_CBSSAORes[] = {
 {"Medium", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"High", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};
Fl_Menu_Item* cUserInterface::MISSAOResMed = cUserInterface::menu_CBSSAORes + 0;
Fl_Menu_Item* cUserInterface::MISSAOResHigh = cUserInterface::menu_CBSSAORes + 1;

void cUserInterface::cb_ChBEdgeSmooth_i(Fl_Check_Button*, void*) {
  cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Graphics", "EdgeSmooth", ChBEdgeSmooth->value()==1);
}
void cUserInterface::cb_ChBEdgeSmooth(Fl_Check_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_ChBEdgeSmooth_i(o,v);
}

void cUserInterface::cb_CBTexFilter_i(Fl_Choice*, void*) {
  cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Graphics", "TextureFilter", CBTexFilter->value());
}
void cUserInterface::cb_CBTexFilter(Fl_Choice* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_CBTexFilter_i(o,v);
}

Fl_Menu_Item cUserInterface::menu_CBTexFilter[] = {
 {"Nearest", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Bilinear", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Trilinear", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};
Fl_Menu_Item* cUserInterface::MITFilterNearest = cUserInterface::menu_CBTexFilter + 0;
Fl_Menu_Item* cUserInterface::MITFilterBilinear = cUserInterface::menu_CBTexFilter + 1;
Fl_Menu_Item* cUserInterface::MITFilterTrilinear = cUserInterface::menu_CBTexFilter + 2;

void cUserInterface::cb_ChBWaterReflect_i(Fl_Check_Button*, void*) {
  cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Graphics", "WorldReflection", ChBWaterReflect->value()==1);
}
void cUserInterface::cb_ChBWaterReflect(Fl_Check_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_ChBWaterReflect_i(o,v);
}

void cUserInterface::cb_CBParallax_i(Fl_Choice*, void*) {
  int lSelectedItem = CBParallax->value();

cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Graphics", "ParallaxEnabled", lSelectedItem==1);
}
void cUserInterface::cb_CBParallax(Fl_Choice* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_CBParallax_i(o,v);
}

Fl_Menu_Item cUserInterface::menu_CBParallax[] = {
 {"Off", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"On", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};
Fl_Menu_Item* cUserInterface::MIParallaxOff = cUserInterface::menu_CBParallax + 0;
Fl_Menu_Item* cUserInterface::MIParallaxOn = cUserInterface::menu_CBParallax + 1;

void cUserInterface::cb_BShowBasic_i(Fl_Button*, void*) {
  SetWidgetEnabled(GroupAdvancedGfxOptions, false);
SetWidgetVisible(GroupAdvancedGfxOptions, false);

SetWidgetEnabled(GroupBasicGfxOptions, true);
SetWidgetVisible(GroupBasicGfxOptions, true);
}
void cUserInterface::cb_BShowBasic(Fl_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_BShowBasic_i(o,v);
}

void cUserInterface::cb_CBSSAOSamples_i(Fl_Choice*, void*) {
  int lValue = (long int)CBSSAOSamples->mvalue()->user_data();
cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Graphics", "SSAOSamples", lValue);
}
void cUserInterface::cb_CBSSAOSamples(Fl_Choice* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_CBSSAOSamples_i(o,v);
}

Fl_Menu_Item cUserInterface::menu_CBSSAOSamples[] = {
 {"4", 0,  0, (void*)(4), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"8", 0,  0, (void*)(8), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"16", 0,  0, (void*)(16), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"32", 0,  0, (void*)(32), 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

void cUserInterface::cb_CBSoundDevices_i(Fl_Choice*, void*) {
  int lIndex = CBSoundDevices->value();
int lDevID;
if(lIndex<0 || lIndex>=(int)mvSoundDevices.size())
{
	lDevID = mpCurSndDev->GetID();
}
else
{
	iSoundDeviceIdentifier* pDev = mvSoundDevices[lIndex];
	lDevID = pDev->GetID();
}


cLauncherHelper::UpdateConfigFile(this, mpConfigFile, "Sound", "Device", lDevID);
}
void cUserInterface::cb_CBSoundDevices(Fl_Choice* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_CBSoundDevices_i(o,v);
}

void cUserInterface::cb_BLaunchGame_i(Fl_Button*, void*) {
  mlExitFlag = 1;
mpConfigFile->Save();

Fl::delete_widget(LauncherWindow);
}
void cUserInterface::cb_BLaunchGame(Fl_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->user_data()))->cb_BLaunchGame_i(o,v);
}

void cUserInterface::cb_BCancel_i(Fl_Button*, void*) {
  mlExitFlag = 0;

Fl::delete_widget(LauncherWindow);
}
void cUserInterface::cb_BCancel(Fl_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->user_data()))->cb_BCancel_i(o,v);
}

void cUserInterface::cb_BReadRemember_i(Fl_Button*, void*) {
  cPlatform::OpenFileOnShell(_W("Remember - Short Story Collection.pdf"));
}
void cUserInterface::cb_BReadRemember(Fl_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->user_data()))->cb_BReadRemember_i(o,v);
}

void cUserInterface::cb_BLaunchPTest_i(Fl_Button*, void*) {
  mlExitFlag = 2;
mpConfigFile->Save();

Fl::delete_widget(LauncherWindow);
}
void cUserInterface::cb_BLaunchPTest(Fl_Button* o, void* v) {
  ((cUserInterface*)(o->parent()->parent()->user_data()))->cb_BLaunchPTest_i(o,v);
}

Fl_Window* cUserInterface::CreateWindow() {
  { AddResolutionWindow = new Fl_Window(205, 135, "Add Custom Resolution");
    AddResolutionWindow->callback((Fl_Callback*)cb_AddResolutionWindow, (void*)(this));
    { BAddCustomResolution = new Fl_Return_Button(120, 95, 70, 25, "Add");
      BAddCustomResolution->callback((Fl_Callback*)cb_BAddCustomResolution);
    } // Fl_Return_Button* BAddCustomResolution
    { Fl_Button* o = new Fl_Button(15, 95, 80, 25, "Cancel");
      o->callback((Fl_Callback*)cb_Cancel);
    } // Fl_Button* o
    { ICustomWidth = new Fl_Value_Input(75, 15, 100, 25, "Width:");
      ICustomWidth->minimum(640);
      ICustomWidth->maximum(4000);
      ICustomWidth->step(1);
      ICustomWidth->value(640);
    } // Fl_Value_Input* ICustomWidth
    { ICustomHeight = new Fl_Value_Input(75, 55, 100, 25, "Height:");
      ICustomHeight->minimum(480);
      ICustomHeight->maximum(4000);
      ICustomHeight->step(1);
      ICustomHeight->value(480);
    } // Fl_Value_Input* ICustomHeight
    AddResolutionWindow->set_modal();
    AddResolutionWindow->end();
  } // Fl_Window* AddResolutionWindow
  { LauncherWindow = new Fl_Window(694, 554, "Amnesia: The Dark Descent launcher");
    LauncherWindow->box(FL_NO_BOX);
    LauncherWindow->color((Fl_Color)228);
    LauncherWindow->user_data((void*)(this));
    LauncherWindow->when(FL_WHEN_NEVER);
    { Fl_Group* o = new Fl_Group(0, 0, 695, 555);
      o->color(FL_BACKGROUND2_COLOR);
      o->image(image_launcher_bg);
      o->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
      { Fl_Tabs* o = new Fl_Tabs(60, 330, 585, 175);
        { TabGeneral = new Fl_Group(60, 355, 585, 150, "General");
          { CBQPreset = new Fl_Choice(235, 405, 110, 20, "Quality:");
            CBQPreset->down_box(FL_BORDER_BOX);
            CBQPreset->callback((Fl_Callback*)cb_CBQPreset);
            CBQPreset->when(FL_WHEN_RELEASE_ALWAYS);
            CBQPreset->menu(menu_CBQPreset);
          } // Fl_Choice* CBQPreset
          { BDetectSettings = new Fl_Button(380, 405, 135, 20, "Detect");
            BDetectSettings->callback((Fl_Callback*)cb_BDetectSettings);
          } // Fl_Button* BDetectSettings
          { StringVideoDevice = new Fl_Box(235, 368, 405, 22);
            StringVideoDevice->align(Fl_Align(36|FL_ALIGN_INSIDE));
            StringVideoDevice->label(msCardString.c_str());
          } // Fl_Box* StringVideoDevice
          { LabelVideoDevice = new Fl_Box(235, 369, 405, 21, "Video Device:");
            LabelVideoDevice->align(Fl_Align(FL_ALIGN_LEFT));
          } // Fl_Box* LabelVideoDevice
          { CBLanguage = new Fl_Choice(235, 435, 110, 20, "Language:");
            CBLanguage->down_box(FL_BORDER_BOX);
            CBLanguage->callback((Fl_Callback*)cb_CBLanguage);
          } // Fl_Choice* CBLanguage
          TabGeneral->end();
        } // Fl_Group* TabGeneral
        { TabGraphics = new Fl_Group(60, 355, 585, 150, "Graphic Options");
          TabGraphics->hide();
          { GroupBasicGfxOptions = new Fl_Group(60, 355, 585, 150);
            { CBResolution = new Fl_Choice(190, 370, 115, 20, "Resolution:");
              CBResolution->down_box(FL_BORDER_BOX);
              CBResolution->callback((Fl_Callback*)cb_CBResolution);
              CBResolution->when(FL_WHEN_CHANGED);
            } // Fl_Choice* CBResolution
            { ChBFullScreen = new Fl_Check_Button(335, 370, 170, 20, "Full screen");
              ChBFullScreen->down_box(FL_DOWN_BOX);
              ChBFullScreen->callback((Fl_Callback*)cb_ChBFullScreen);
              ChBFullScreen->when(FL_WHEN_CHANGED);
            } // Fl_Check_Button* ChBFullScreen
            { CBShadowQ = new Fl_Choice(220, 430, 85, 20, "Shadow quality:");
              CBShadowQ->down_box(FL_BORDER_BOX);
              CBShadowQ->callback((Fl_Callback*)cb_CBShadowQ);
              CBShadowQ->when(FL_WHEN_CHANGED);
              CBShadowQ->menu(menu_CBShadowQ);
            } // Fl_Choice* CBShadowQ
            { CBShadowRes = new Fl_Choice(490, 430, 90, 20, "Shadow resolution:");
              CBShadowRes->down_box(FL_BORDER_BOX);
              CBShadowRes->callback((Fl_Callback*)cb_CBShadowRes);
              CBShadowRes->when(FL_WHEN_CHANGED);
              CBShadowRes->menu(menu_CBShadowRes);
            } // Fl_Choice* CBShadowRes
            { BShowAdvanced = new Fl_Button(405, 480, 225, 20, "Show Advanced");
              BShowAdvanced->callback((Fl_Callback*)cb_BShowAdvanced);
            } // Fl_Button* BShowAdvanced
            { CBTexQ = new Fl_Choice(220, 400, 85, 20, "Texture quality:");
              CBTexQ->down_box(FL_BORDER_BOX);
              CBTexQ->callback((Fl_Callback*)cb_CBTexQ);
              CBTexQ->menu(menu_CBTexQ);
            } // Fl_Choice* CBTexQ
            GroupBasicGfxOptions->end();
          } // Fl_Group* GroupBasicGfxOptions
          { GroupAdvancedGfxOptions = new Fl_Group(60, 355, 585, 150);
            GroupAdvancedGfxOptions->hide();
            GroupAdvancedGfxOptions->deactivate();
            { CBAnisotropy = new Fl_Choice(450, 370, 120, 20, "Anisotropy:");
              CBAnisotropy->down_box(FL_BORDER_BOX);
              CBAnisotropy->callback((Fl_Callback*)cb_CBAnisotropy);
              CBAnisotropy->menu(menu_CBAnisotropy);
            } // Fl_Choice* CBAnisotropy
            { ChBSSAO = new Fl_Check_Button(130, 395, 65, 20, "SSAO");
              ChBSSAO->down_box(FL_DOWN_BOX);
              ChBSSAO->callback((Fl_Callback*)cb_ChBSSAO);
              ChBSSAO->when(FL_WHEN_CHANGED);
            } // Fl_Check_Button* ChBSSAO
            { CBSSAORes = new Fl_Choice(450, 395, 120, 20, "SSAO Resolution:");
              CBSSAORes->down_box(FL_BORDER_BOX);
              CBSSAORes->callback((Fl_Callback*)cb_CBSSAORes);
              CBSSAORes->menu(menu_CBSSAORes);
            } // Fl_Choice* CBSSAORes
            { ChBEdgeSmooth = new Fl_Check_Button(130, 420, 155, 20, "Edge Smooth");
              ChBEdgeSmooth->down_box(FL_DOWN_BOX);
              ChBEdgeSmooth->callback((Fl_Callback*)cb_ChBEdgeSmooth);
            } // Fl_Check_Button* ChBEdgeSmooth
            { CBTexFilter = new Fl_Choice(225, 370, 80, 20, "Texture Filter:");
              CBTexFilter->down_box(FL_BORDER_BOX);
              CBTexFilter->callback((Fl_Callback*)cb_CBTexFilter);
              CBTexFilter->menu(menu_CBTexFilter);
            } // Fl_Choice* CBTexFilter
            { ChBWaterReflect = new Fl_Check_Button(130, 445, 155, 20, "Water reflection");
              ChBWaterReflect->down_box(FL_DOWN_BOX);
              ChBWaterReflect->callback((Fl_Callback*)cb_ChBWaterReflect);
              ChBWaterReflect->when(FL_WHEN_CHANGED);
            } // Fl_Check_Button* ChBWaterReflect
            { CBParallax = new Fl_Choice(450, 445, 120, 20, "Parallax:");
              CBParallax->down_box(FL_BORDER_BOX);
              CBParallax->callback((Fl_Callback*)cb_CBParallax);
              CBParallax->menu(menu_CBParallax);
            } // Fl_Choice* CBParallax
            { BShowBasic = new Fl_Button(415, 480, 230, 20, "Show Basic");
              BShowBasic->callback((Fl_Callback*)cb_BShowBasic);
            } // Fl_Button* BShowBasic
            { CBSSAOSamples = new Fl_Choice(450, 420, 120, 20, "SSAO Samples:");
              CBSSAOSamples->down_box(FL_BORDER_BOX);
              CBSSAOSamples->callback((Fl_Callback*)cb_CBSSAOSamples);
              CBSSAOSamples->menu(menu_CBSSAOSamples);
            } // Fl_Choice* CBSSAOSamples
            GroupAdvancedGfxOptions->end();
          } // Fl_Group* GroupAdvancedGfxOptions
          TabGraphics->end();
        } // Fl_Group* TabGraphics
        { TabSound = new Fl_Group(60, 355, 585, 150, "Sound Options");
          TabSound->hide();
          { CBSoundDevices = new Fl_Choice(190, 370, 300, 20, "Device:");
            CBSoundDevices->down_box(FL_BORDER_BOX);
            CBSoundDevices->callback((Fl_Callback*)cb_CBSoundDevices);
          } // Fl_Choice* CBSoundDevices
          TabSound->end();
        } // Fl_Group* TabSound
        o->end();
      } // Fl_Tabs* o
      { BLaunchGame = new Fl_Button(225, 520, 115, 25, "Launch game");
        BLaunchGame->callback((Fl_Callback*)cb_BLaunchGame);
      } // Fl_Button* BLaunchGame
      { BCancel = new Fl_Button(350, 520, 115, 25, "Cancel");
        BCancel->callback((Fl_Callback*)cb_BCancel);
      } // Fl_Button* BCancel
      { BReadRemember = new Fl_Button(5, 520, 95, 25, "Remember");
        BReadRemember->labelfont(2);
        BReadRemember->callback((Fl_Callback*)cb_BReadRemember);
      } // Fl_Button* BReadRemember
      { BLaunchPTest = new Fl_Button(600, 520, 90, 25, "Justine");
        BLaunchPTest->labelfont(2);
        BLaunchPTest->callback((Fl_Callback*)cb_BLaunchPTest);
      } // Fl_Button* BLaunchPTest
      o->end();
    } // Fl_Group* o
    LauncherWindow->position(((float)(Fl::w()-LauncherWindow->w()))*0.5f, ((float)(Fl::h()-LauncherWindow->h()))*0.5f);
    LauncherWindow->set_modal();
    LauncherWindow->end();
  } // Fl_Window* LauncherWindow
  BShowAdvanced->value(0);

  cLauncherHelper::PopulateLanguages(mvLanguageFiles, gsDefaultGameLanguage, mpConfigFile, CBLanguage);
  cLauncherHelper::PopulateResolutions(mvVModes, mpConfigFile, CBResolution, this);

  mpCurSndDev = mpEngine->GetSound()->GetLowLevel()->GetCurrentSoundDevice();
  cLauncherHelper::PopulateSoundDevices(mvSoundDevices, mpCurSndDev, mpConfigFile, CBSoundDevices);
  cb_CBSoundDevices_i(NULL,NULL);

  cLauncherHelper::SetUpWidgetLabels(this, mlstLabels);
  cLauncherHelper::SetInitialValues(mpConfigFile,this);

  CheckEqualsPreset();
  return LauncherWindow;
}

cUserInterface::cUserInterface(int& alExitFlag, cConfigFile *apConfigFile, bool abConfigFileExists, bool abLastInitCrashed, const tString& asCardString, cQualityChooser* apChooser, const std::vector<cConfigFile*>& avPresets, cEngine* apEng) : mlExitFlag(alExitFlag) {
  Fl::scheme("plastic");

  if(abLastInitCrashed)
  	fl_message("Last settings crashed the game, falling back to defaults");

  mpConfigFile = apConfigFile;

  msCardString = asCardString;
  mpQualityChooser = apChooser;
  mvPresets = avPresets;

  mpEngine = apEng;

  mbSettingPreset = false;


  ////////////////////////////////////
  // Retrieve available languages
  mvLanguageFiles = cLauncherHelper::GetAvailableLanguages(gsGameLanguageFolder);

  ////////////////////////////////////
  // Retrieve video modes
  mvVModes = cLauncherHelper::GetAvailableVideoModes(mpConfigFile);

  ////////////////////////////////////
  // Retrieve sound devices
  mvSoundDevices = cLauncherHelper::GetAvailableSoundDevices();

  /////////////////////////////////////////////
  // If no config file was present, set 'medium' settings
  if(abConfigFileExists==false)
  	cLauncherHelper::UpdateConfigFileWithPreset(mpConfigFile, mvPresets[1]);

  Fl_Window* pWin = CreateWindow();
  char *argv[] = { " " };
  pWin->show(0,argv);
}

int cUserInterface::Run() {
  return Fl::run();
}

void cUserInterface::SetWidgetEnabled(Fl_Widget* apW, bool abX) {
  if(abX)
  	apW->show();
  else
  	apW->hide();
}

void cUserInterface::SetWidgetVisible(Fl_Widget* apW, bool abX) {
  if(abX)
  	apW->activate();
  else
  	apW->deactivate();
}

void cUserInterface::CheckEqualsPreset() {
  int lValue = cLauncherHelper::GetEqualPresetIndex(mpConfigFile, mvPresets);
  if(lValue==-1)
  	lValue = 3;

  CBQPreset->value(lValue);
}
