# Conventions

## Branches

1. Working on `master` is **forbidden**.
You should always work **on your own branches.**
2. Each branch name will begin with the type of changes:
* `feat/` - Adding new features to the project.
* `fix/` - Bug fixes.
* `refactor/` - Rewriting code.
* `style/` - Reformatting code.
* `chore/` - Maintenance of the project (Build script files, etc).
* `docs/` - Adding project documentation.

3. After the `/` character, you will write the name of the branch in `kebab-case`. Keep it short and focus on the main subject changes.

Example:
* `feat/congestion-tests`
* `fix/zookeeper-disconnect`
* `refactor/manufacturing-locks`
