/*
 * vim: ts=4 sw=4 et tw=0 wm=0
 *
 * libdialect - A library for computing DiAlEcT layouts:
 *                 D = Decompose/Distribute
 *                 A = Arrange
 *                 E = Expand/Emend
 *                 T = Transform
 *
 * Copyright (C) 2018  Monash University
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * See the file LICENSE.LGPL distributed with the library.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Author(s):   Steve Kieffer   <http://skieffer.info>
*/

/*
 * Generated by gen_bend_seq_lookup.py
 *
*/

#include <map>
#include <vector>

#include "libdialect/ortho.h"
#include "libdialect/chains.h"

using dialect::CompassDir;
using dialect::CardinalDir;
using dialect::LinkShape;
using std::map;
using std::vector;

const map<CompassDir, map<CardinalDir, map<CardinalDir, vector<vector<LinkShape>>>>> dialect::minimalBendSeqs{
    {CompassDir::NW, {
        {CardinalDir::EAST, {
            {CardinalDir::EAST, {
                {LinkShape::TRC, LinkShape::BLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::TRC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::TRC, LinkShape::BRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::TRC, LinkShape::BLC, LinkShape::BRC},
                {LinkShape::TRC, LinkShape::BRC, LinkShape::BLC}
            }}
        }},
        {CardinalDir::SOUTH, {
            {CardinalDir::EAST, {
                {LinkShape::BLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::BLC, LinkShape::TRC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::BLC, LinkShape::TRC, LinkShape::BRC},
                {LinkShape::BLC, LinkShape::BRC, LinkShape::TRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::BLC, LinkShape::BRC}
            }}
        }},
        {CardinalDir::WEST, {
            {CardinalDir::EAST, {
                {LinkShape::TLC, LinkShape::BLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::TLC, LinkShape::BLC, LinkShape::TRC},
                {LinkShape::BLC, LinkShape::TLC, LinkShape::TRC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::BLC, LinkShape::TLC, LinkShape::TRC, LinkShape::BRC},
                {LinkShape::TLC, LinkShape::BLC, LinkShape::TRC, LinkShape::BRC},
                {LinkShape::TLC, LinkShape::BLC, LinkShape::BRC, LinkShape::TRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::TLC, LinkShape::BLC, LinkShape::BRC}
            }}
        }},
        {CardinalDir::NORTH, {
            {CardinalDir::EAST, {
                {LinkShape::TLC, LinkShape::TRC, LinkShape::BLC},
                {LinkShape::TRC, LinkShape::TLC, LinkShape::BLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::TLC, LinkShape::TRC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::TLC, LinkShape::TRC, LinkShape::BRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::TRC, LinkShape::TLC, LinkShape::BLC, LinkShape::BRC},
                {LinkShape::TLC, LinkShape::TRC, LinkShape::BLC, LinkShape::BRC},
                {LinkShape::TLC, LinkShape::TRC, LinkShape::BRC, LinkShape::BLC}
            }}
        }}
    }},
    {CompassDir::NORTH, {
        {CardinalDir::EAST, {
            {CardinalDir::EAST, {
                {LinkShape::BRC, LinkShape::TRC, LinkShape::TLC, LinkShape::BLC},
                {LinkShape::TRC, LinkShape::BRC, LinkShape::TLC, LinkShape::BLC},
                {LinkShape::TRC, LinkShape::BRC, LinkShape::BLC, LinkShape::TLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::TRC, LinkShape::BRC, LinkShape::TLC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::TRC, LinkShape::BRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::TRC, LinkShape::BRC, LinkShape::BLC}
            }}
        }},
        {CardinalDir::SOUTH, {
            {CardinalDir::EAST, {
                {LinkShape::BRC, LinkShape::TLC, LinkShape::BLC},
                {LinkShape::BRC, LinkShape::BLC, LinkShape::TLC}
            }},
            {CardinalDir::SOUTH, {
                {}
            }},
            {CardinalDir::WEST, {
                {LinkShape::BLC, LinkShape::TRC, LinkShape::BRC},
                {LinkShape::BLC, LinkShape::BRC, LinkShape::TRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::BRC, LinkShape::TLC, LinkShape::BLC, LinkShape::BRC},
                {LinkShape::BLC, LinkShape::TRC, LinkShape::BRC, LinkShape::BLC}
            }}
        }},
        {CardinalDir::WEST, {
            {CardinalDir::EAST, {
                {LinkShape::TLC, LinkShape::BLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::TLC, LinkShape::BLC, LinkShape::TRC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::BLC, LinkShape::TLC, LinkShape::TRC, LinkShape::BRC},
                {LinkShape::TLC, LinkShape::BLC, LinkShape::TRC, LinkShape::BRC},
                {LinkShape::TLC, LinkShape::BLC, LinkShape::BRC, LinkShape::TRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::TLC, LinkShape::BLC, LinkShape::BRC}
            }}
        }},
        {CardinalDir::NORTH, {
            {CardinalDir::EAST, {
                {LinkShape::TRC, LinkShape::TLC, LinkShape::BLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::TLC, LinkShape::TRC, LinkShape::BRC, LinkShape::TLC},
                {LinkShape::TRC, LinkShape::TLC, LinkShape::BLC, LinkShape::TRC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::TLC, LinkShape::TRC, LinkShape::BRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::TRC, LinkShape::TLC, LinkShape::BLC, LinkShape::BRC},
                {LinkShape::TLC, LinkShape::TRC, LinkShape::BRC, LinkShape::BLC}
            }}
        }}
    }},
    {CompassDir::NE, {
        {CardinalDir::EAST, {
            {CardinalDir::EAST, {
                {LinkShape::BRC, LinkShape::TRC, LinkShape::TLC, LinkShape::BLC},
                {LinkShape::TRC, LinkShape::BRC, LinkShape::TLC, LinkShape::BLC},
                {LinkShape::TRC, LinkShape::BRC, LinkShape::BLC, LinkShape::TLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::TRC, LinkShape::BRC, LinkShape::TLC},
                {LinkShape::BRC, LinkShape::TRC, LinkShape::TLC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::TRC, LinkShape::BRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::TRC, LinkShape::BRC, LinkShape::BLC}
            }}
        }},
        {CardinalDir::SOUTH, {
            {CardinalDir::EAST, {
                {LinkShape::BRC, LinkShape::TLC, LinkShape::BLC},
                {LinkShape::BRC, LinkShape::BLC, LinkShape::TLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::BRC, LinkShape::TLC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::BRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::BRC, LinkShape::BLC}
            }}
        }},
        {CardinalDir::WEST, {
            {CardinalDir::EAST, {
                {LinkShape::TLC, LinkShape::BLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::TLC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::TLC, LinkShape::BRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::TLC, LinkShape::BRC, LinkShape::BLC},
                {LinkShape::TLC, LinkShape::BLC, LinkShape::BRC}
            }}
        }},
        {CardinalDir::NORTH, {
            {CardinalDir::EAST, {
                {LinkShape::TRC, LinkShape::TLC, LinkShape::BLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::TRC, LinkShape::TLC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::TRC, LinkShape::TLC, LinkShape::BRC},
                {LinkShape::TLC, LinkShape::TRC, LinkShape::BRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::TLC, LinkShape::TRC, LinkShape::BRC, LinkShape::BLC},
                {LinkShape::TRC, LinkShape::TLC, LinkShape::BRC, LinkShape::BLC},
                {LinkShape::TRC, LinkShape::TLC, LinkShape::BLC, LinkShape::BRC}
            }}
        }}
    }},
    {CompassDir::WEST, {
        {CardinalDir::EAST, {
            {CardinalDir::EAST, {
                {}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::BRC, LinkShape::TLC, LinkShape::TRC},
                {LinkShape::BRC, LinkShape::TRC, LinkShape::TLC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::TRC, LinkShape::BLC, LinkShape::BRC, LinkShape::TRC},
                {LinkShape::BRC, LinkShape::TLC, LinkShape::TRC, LinkShape::BRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::TRC, LinkShape::BLC, LinkShape::BRC},
                {LinkShape::TRC, LinkShape::BRC, LinkShape::BLC}
            }}
        }},
        {CardinalDir::SOUTH, {
            {CardinalDir::EAST, {
                {LinkShape::BLC, LinkShape::BRC, LinkShape::TLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::BRC, LinkShape::BLC, LinkShape::TLC, LinkShape::TRC},
                {LinkShape::BLC, LinkShape::BRC, LinkShape::TLC, LinkShape::TRC},
                {LinkShape::BLC, LinkShape::BRC, LinkShape::TRC, LinkShape::TLC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::BLC, LinkShape::BRC, LinkShape::TRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::BLC, LinkShape::BRC}
            }}
        }},
        {CardinalDir::WEST, {
            {CardinalDir::EAST, {
                {LinkShape::BLC, LinkShape::TLC, LinkShape::TRC, LinkShape::BLC},
                {LinkShape::TLC, LinkShape::BLC, LinkShape::BRC, LinkShape::TLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::BLC, LinkShape::TLC, LinkShape::TRC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::TLC, LinkShape::BLC, LinkShape::BRC, LinkShape::TRC},
                {LinkShape::BLC, LinkShape::TLC, LinkShape::TRC, LinkShape::BRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::TLC, LinkShape::BLC, LinkShape::BRC}
            }}
        }},
        {CardinalDir::NORTH, {
            {CardinalDir::EAST, {
                {LinkShape::TLC, LinkShape::TRC, LinkShape::BLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::TLC, LinkShape::TRC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::TLC, LinkShape::TRC, LinkShape::BRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::TRC, LinkShape::TLC, LinkShape::BLC, LinkShape::BRC},
                {LinkShape::TLC, LinkShape::TRC, LinkShape::BLC, LinkShape::BRC},
                {LinkShape::TLC, LinkShape::TRC, LinkShape::BRC, LinkShape::BLC}
            }}
        }}
    }},
    {CompassDir::EAST, {
        {CardinalDir::EAST, {
            {CardinalDir::EAST, {
                {LinkShape::BRC, LinkShape::TRC, LinkShape::TLC, LinkShape::BLC},
                {LinkShape::TRC, LinkShape::BRC, LinkShape::BLC, LinkShape::TLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::BRC, LinkShape::TRC, LinkShape::TLC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::TRC, LinkShape::BRC, LinkShape::BLC, LinkShape::TRC},
                {LinkShape::BRC, LinkShape::TRC, LinkShape::TLC, LinkShape::BRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::TRC, LinkShape::BRC, LinkShape::BLC}
            }}
        }},
        {CardinalDir::SOUTH, {
            {CardinalDir::EAST, {
                {LinkShape::BRC, LinkShape::BLC, LinkShape::TLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::BLC, LinkShape::BRC, LinkShape::TRC, LinkShape::TLC},
                {LinkShape::BRC, LinkShape::BLC, LinkShape::TRC, LinkShape::TLC},
                {LinkShape::BRC, LinkShape::BLC, LinkShape::TLC, LinkShape::TRC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::BRC, LinkShape::BLC, LinkShape::TRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::BRC, LinkShape::BLC}
            }}
        }},
        {CardinalDir::WEST, {
            {CardinalDir::EAST, {
                {LinkShape::BLC, LinkShape::TRC, LinkShape::TLC, LinkShape::BLC},
                {LinkShape::TLC, LinkShape::BRC, LinkShape::BLC, LinkShape::TLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::BLC, LinkShape::TRC, LinkShape::TLC},
                {LinkShape::BLC, LinkShape::TLC, LinkShape::TRC}
            }},
            {CardinalDir::WEST, {
                {}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::TLC, LinkShape::BRC, LinkShape::BLC},
                {LinkShape::TLC, LinkShape::BLC, LinkShape::BRC}
            }}
        }},
        {CardinalDir::NORTH, {
            {CardinalDir::EAST, {
                {LinkShape::TRC, LinkShape::TLC, LinkShape::BLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::TRC, LinkShape::TLC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::TRC, LinkShape::TLC, LinkShape::BRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::TLC, LinkShape::TRC, LinkShape::BRC, LinkShape::BLC},
                {LinkShape::TRC, LinkShape::TLC, LinkShape::BRC, LinkShape::BLC},
                {LinkShape::TRC, LinkShape::TLC, LinkShape::BLC, LinkShape::BRC}
            }}
        }}
    }},
    {CompassDir::SW, {
        {CardinalDir::EAST, {
            {CardinalDir::EAST, {
                {LinkShape::BRC, LinkShape::TLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::BRC, LinkShape::TLC, LinkShape::TRC},
                {LinkShape::BRC, LinkShape::TRC, LinkShape::TLC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::BRC, LinkShape::TRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::BRC}
            }}
        }},
        {CardinalDir::SOUTH, {
            {CardinalDir::EAST, {
                {LinkShape::BLC, LinkShape::BRC, LinkShape::TLC},
                {LinkShape::BRC, LinkShape::BLC, LinkShape::TLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::BRC, LinkShape::BLC, LinkShape::TLC, LinkShape::TRC},
                {LinkShape::BLC, LinkShape::BRC, LinkShape::TLC, LinkShape::TRC},
                {LinkShape::BLC, LinkShape::BRC, LinkShape::TRC, LinkShape::TLC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::BLC, LinkShape::BRC, LinkShape::TRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::BLC, LinkShape::BRC}
            }}
        }},
        {CardinalDir::WEST, {
            {CardinalDir::EAST, {
                {LinkShape::BLC, LinkShape::TLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::BLC, LinkShape::TLC, LinkShape::TRC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::TLC, LinkShape::BLC, LinkShape::BRC, LinkShape::TRC},
                {LinkShape::BLC, LinkShape::TLC, LinkShape::BRC, LinkShape::TRC},
                {LinkShape::BLC, LinkShape::TLC, LinkShape::TRC, LinkShape::BRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::BLC, LinkShape::TLC, LinkShape::BRC},
                {LinkShape::TLC, LinkShape::BLC, LinkShape::BRC}
            }}
        }},
        {CardinalDir::NORTH, {
            {CardinalDir::EAST, {
                {LinkShape::TLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::TLC, LinkShape::TRC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::TLC, LinkShape::BRC, LinkShape::TRC},
                {LinkShape::TLC, LinkShape::TRC, LinkShape::BRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::TLC, LinkShape::BRC}
            }}
        }}
    }},
    {CompassDir::SOUTH, {
        {CardinalDir::EAST, {
            {CardinalDir::EAST, {
                {LinkShape::TRC, LinkShape::BRC, LinkShape::BLC, LinkShape::TLC},
                {LinkShape::BRC, LinkShape::TRC, LinkShape::BLC, LinkShape::TLC},
                {LinkShape::BRC, LinkShape::TRC, LinkShape::TLC, LinkShape::BLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::BRC, LinkShape::TRC, LinkShape::TLC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::BRC, LinkShape::TRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::BRC, LinkShape::TRC, LinkShape::BLC}
            }}
        }},
        {CardinalDir::SOUTH, {
            {CardinalDir::EAST, {
                {LinkShape::BRC, LinkShape::BLC, LinkShape::TLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::BLC, LinkShape::BRC, LinkShape::TRC, LinkShape::TLC},
                {LinkShape::BRC, LinkShape::BLC, LinkShape::TLC, LinkShape::TRC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::BLC, LinkShape::BRC, LinkShape::TRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::BRC, LinkShape::BLC, LinkShape::TLC, LinkShape::BRC},
                {LinkShape::BLC, LinkShape::BRC, LinkShape::TRC, LinkShape::BLC}
            }}
        }},
        {CardinalDir::WEST, {
            {CardinalDir::EAST, {
                {LinkShape::BLC, LinkShape::TLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::BLC, LinkShape::TLC, LinkShape::TRC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::TLC, LinkShape::BLC, LinkShape::BRC, LinkShape::TRC},
                {LinkShape::BLC, LinkShape::TLC, LinkShape::BRC, LinkShape::TRC},
                {LinkShape::BLC, LinkShape::TLC, LinkShape::TRC, LinkShape::BRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::BLC, LinkShape::TLC, LinkShape::BRC}
            }}
        }},
        {CardinalDir::NORTH, {
            {CardinalDir::EAST, {
                {LinkShape::TRC, LinkShape::BLC, LinkShape::TLC},
                {LinkShape::TRC, LinkShape::TLC, LinkShape::BLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::TLC, LinkShape::BRC, LinkShape::TRC, LinkShape::TLC},
                {LinkShape::TRC, LinkShape::BLC, LinkShape::TLC, LinkShape::TRC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::TLC, LinkShape::BRC, LinkShape::TRC},
                {LinkShape::TLC, LinkShape::TRC, LinkShape::BRC}
            }},
            {CardinalDir::NORTH, {
                {}
            }}
        }}
    }},
    {CompassDir::SE, {
        {CardinalDir::EAST, {
            {CardinalDir::EAST, {
                {LinkShape::TRC, LinkShape::BRC, LinkShape::BLC, LinkShape::TLC},
                {LinkShape::BRC, LinkShape::TRC, LinkShape::BLC, LinkShape::TLC},
                {LinkShape::BRC, LinkShape::TRC, LinkShape::TLC, LinkShape::BLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::BRC, LinkShape::TRC, LinkShape::TLC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::BRC, LinkShape::TRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::BRC, LinkShape::TRC, LinkShape::BLC},
                {LinkShape::TRC, LinkShape::BRC, LinkShape::BLC}
            }}
        }},
        {CardinalDir::SOUTH, {
            {CardinalDir::EAST, {
                {LinkShape::BRC, LinkShape::BLC, LinkShape::TLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::BLC, LinkShape::BRC, LinkShape::TRC, LinkShape::TLC},
                {LinkShape::BRC, LinkShape::BLC, LinkShape::TRC, LinkShape::TLC},
                {LinkShape::BRC, LinkShape::BLC, LinkShape::TLC, LinkShape::TRC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::BRC, LinkShape::BLC, LinkShape::TRC},
                {LinkShape::BLC, LinkShape::BRC, LinkShape::TRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::BRC, LinkShape::BLC}
            }}
        }},
        {CardinalDir::WEST, {
            {CardinalDir::EAST, {
                {LinkShape::BLC, LinkShape::TLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::BLC, LinkShape::TRC, LinkShape::TLC},
                {LinkShape::BLC, LinkShape::TLC, LinkShape::TRC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::BLC, LinkShape::TRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::BLC}
            }}
        }},
        {CardinalDir::NORTH, {
            {CardinalDir::EAST, {
                {LinkShape::TRC, LinkShape::BLC, LinkShape::TLC},
                {LinkShape::TRC, LinkShape::TLC, LinkShape::BLC}
            }},
            {CardinalDir::SOUTH, {
                {LinkShape::TRC, LinkShape::TLC}
            }},
            {CardinalDir::WEST, {
                {LinkShape::TRC}
            }},
            {CardinalDir::NORTH, {
                {LinkShape::TRC, LinkShape::BLC}
            }}
        }}
    }}
};
