#!/hint/sh

show_crt() {
	openssl x509 -in "$tmpd/$1.crt" -noout -text
}

pid_pebble=
pid_nginx=

tdir=$srcdir/tests

check_cmd() {
	printf 'Checking for %s ... ' "$1"
	if command -v "$1" 2>/dev/null; then
		printf 'OK'
	else
		printf 'FAIL'
		exit 1
	fi
}
check_cmd curl
check_cmd nginx
check_cmd openssl
check_cmd pebble

cleanup() {
	ec=$?

	[ -n "$pid_pebble" ] && kill "$pid_pebble"
	[ -n "$pid_nginx"  ] && kill "$pid_nginx"

	wait

	#rm -rf "$tmpd"

	exit "$ec"
}
trap cleanup EXIT

tmpd=/tmp/acme-client-portable-test.$$
mkdir "$tmpd"
mkdir "$tmpd/acme-challenge"



openssl req -x509 -newkey rsa:4096 \
	-keyout "$tmpd"/ssl.key \
	-out "$tmpd"/ssl.crt \
	-days 1 -nodes \
	-subj '/CN=localhost'

SSL_CERT_FILE=$tmpd/ssl.crt
export SSL_CERT_FILE



sed -Ee 's~@TMPD@~'"$tmpd"'~' "$tdir/pebble.json" >"$tmpd/pebble.json"

PEBBLE_WFE_NONCEREJECT=0 pebble -config "$tmpd/pebble.json" &
pid_pebble=$!



sed -Ee 's~@TMPD@~'"$tmpd"'~' "$tdir/nginx.conf" >"$tmpd/nginx.conf"

mkdir -p "$tmpd/nginx/logs"
mkdir -p "$tmpd/nginx/tmp"
nginx -c "$tmpd/nginx.conf" -p "$tmpd/nginx" &
pid_nginx=$!



# TODO: Proper wait for pebble and nginx
sleep 3

sed -Ee 's~@TMPD@~'"$tmpd"'~' \
	"$tdir/acme-client.conf.${0##*test-}" >"$tmpd/acme-client.conf"
