/*  SpiralSynth
 *  Copyleft (C) 2000 David Griffiths <dave@pawfal.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <sys/types.h>
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#if defined (__FreeBSD__)
	#include <machine/soundcard.h>
#else
#if defined (__NetBSD__) || defined (__OpenBSD__)
	#include <soundcard.h>            /* OSS emulation */
#undef ioctl
#else 	                              /* BSDI, Linux, Solaris */
	#include <sys/soundcard.h>
#endif                                /* __NetBSD__ or __OpenBSD__ */
#endif                                /* __FreeBSD__ */
#include <sys/ioctl.h>
#include <limits.h>

#include "SpiralInfo.h"
#include "RiffWav.h"

#ifndef SOUND_MANAGER
#define SOUND_MANAGER
 
inline int FixedLinear(int bot,int top,int pos,int val1,int val2, int Fixed) 
{ 
    float t=(pos-bot)/(float)(top-bot); 
    return (int)(val1*t + val2*(1.0f-t)); 
} 

class Output
{
public:
	Output(int Channels);
	~Output() {close(m_Dspfd);}
	void Send(Sample &data, float LeftVolume=1, float RightVolume=1);
	void SendStereo(Sample &data);
	void SetVolume(float s) {m_Amp=s;}
	void SetNumChannels(int s) {m_Channels=s;}
	float GetVolume() {return m_Amp;}
	void Play();
	void ClearBuffer();
	void WavOpen(char* name) {m_Wav.Open(name,WavFile::WRITE, WavFile::STEREO);}
	void WavClose() {m_Wav.Close();}
	Sample &GetBuffer() {return m_Buffer;}
	
private:
	void Init();

	Sample m_Buffer;

	int m_Dspfd;
	float m_Amp;
	int m_Channels;
	WavFile m_Wav;
};

#endif
